/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PositiveIntType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ContactPoint")
public class ContactPoint
extends DataType
implements ICompositeType {
    @Child(name="system", type={CodeType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="phone | fax | email | pager | url | sms | other", formalDefinition="Telecommunications form for contact point - what communications system is required to make use of the contact.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contact-point-system")
    protected Enumeration<ContactPointSystem> system;
    @Child(name="value", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The actual contact point details", formalDefinition="The actual contact point details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).")
    protected StringType value;
    @Child(name="use", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="home | work | temp | old | mobile - purpose of this contact point", formalDefinition="Identifies the purpose for the contact point.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contact-point-use")
    protected Enumeration<ContactPointUse> use;
    @Child(name="rank", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specify preferred order of use (1 = highest)", formalDefinition="Specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.")
    protected PositiveIntType rank;
    @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when the contact point was/is in use", formalDefinition="Time period when the contact point was/is in use.")
    protected Period period;
    private static final long serialVersionUID = 1509610874L;

    public Enumeration<ContactPointSystem> getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ContactPoint.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new Enumeration<ContactPointSystem>(new ContactPointSystemEnumFactory());
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public ContactPoint setSystemElement(Enumeration<ContactPointSystem> value) {
        this.system = value;
        return this;
    }

    public ContactPointSystem getSystem() {
        return this.system == null ? null : (ContactPointSystem)((Object)this.system.getValue());
    }

    public ContactPoint setSystem(ContactPointSystem value) {
        if (value == null) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new Enumeration<ContactPointSystem>(new ContactPointSystemEnumFactory());
            }
            this.system.setValue((Object)value);
        }
        return this;
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ContactPoint.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public ContactPoint setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public ContactPoint setValue(String value) {
        if (Utilities.noString((String)value)) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    public Enumeration<ContactPointUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ContactPoint.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<ContactPointUse>(new ContactPointUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public ContactPoint setUseElement(Enumeration<ContactPointUse> value) {
        this.use = value;
        return this;
    }

    public ContactPointUse getUse() {
        return this.use == null ? null : (ContactPointUse)((Object)this.use.getValue());
    }

    public ContactPoint setUse(ContactPointUse value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<ContactPointUse>(new ContactPointUseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public PositiveIntType getRankElement() {
        if (this.rank == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ContactPoint.rank");
            }
            if (Configuration.doAutoCreate()) {
                this.rank = new PositiveIntType();
            }
        }
        return this.rank;
    }

    public boolean hasRankElement() {
        return this.rank != null && !this.rank.isEmpty();
    }

    public boolean hasRank() {
        return this.rank != null && !this.rank.isEmpty();
    }

    public ContactPoint setRankElement(PositiveIntType value) {
        this.rank = value;
        return this;
    }

    public int getRank() {
        return this.rank == null || this.rank.isEmpty() ? 0 : (Integer)this.rank.getValue();
    }

    public ContactPoint setRank(int value) {
        if (this.rank == null) {
            this.rank = new PositiveIntType();
        }
        this.rank.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ContactPoint.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ContactPoint setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("system", "code", "Telecommunications form for contact point - what communications system is required to make use of the contact.", 0, 1, this.system));
        children.add(new Property("value", "string", "The actual contact point details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).", 0, 1, this.value));
        children.add(new Property("use", "code", "Identifies the purpose for the contact point.", 0, 1, this.use));
        children.add(new Property("rank", "positiveInt", "Specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.", 0, 1, this.rank));
        children.add(new Property("period", "Period", "Time period when the contact point was/is in use.", 0, 1, this.period));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -887328209: {
                return new Property("system", "code", "Telecommunications form for contact point - what communications system is required to make use of the contact.", 0, 1, this.system);
            }
            case 111972721: {
                return new Property("value", "string", "The actual contact point details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).", 0, 1, this.value);
            }
            case 116103: {
                return new Property("use", "code", "Identifies the purpose for the contact point.", 0, 1, this.use);
            }
            case 3492908: {
                return new Property("rank", "positiveInt", "Specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.", 0, 1, this.rank);
            }
            case -991726143: {
                return new Property("period", "Period", "Time period when the contact point was/is in use.", 0, 1, this.period);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.system;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.use;
                }
                return baseArray;
            }
            case 3492908: {
                Base[] baseArray;
                if (this.rank == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.rank;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -887328209: {
                value = new ContactPointSystemEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.system = value;
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
            case 116103: {
                value = new ContactPointUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
                return value;
            }
            case 3492908: {
                this.rank = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("system")) {
            value = new ContactPointSystemEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.system = value;
        } else if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else if (name.equals("use")) {
            value = new ContactPointUseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals("rank")) {
            this.rank = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887328209: {
                return this.getSystemElement();
            }
            case 111972721: {
                return this.getValueElement();
            }
            case 116103: {
                return this.getUseElement();
            }
            case 3492908: {
                return this.getRankElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887328209: {
                return new String[]{"code"};
            }
            case 111972721: {
                return new String[]{"string"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case 3492908: {
                return new String[]{"positiveInt"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("system")) {
            throw new FHIRException("Cannot call addChild on a primitive type ContactPoint.system");
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a primitive type ContactPoint.value");
        }
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type ContactPoint.use");
        }
        if (name.equals("rank")) {
            throw new FHIRException("Cannot call addChild on a primitive type ContactPoint.rank");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ContactPoint";
    }

    @Override
    public ContactPoint copy() {
        ContactPoint dst = new ContactPoint();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ContactPoint dst) {
        super.copyValues(dst);
        dst.system = this.system == null ? null : this.system.copy();
        dst.value = this.value == null ? null : this.value.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.rank = this.rank == null ? null : this.rank.copy();
        dst.period = this.period == null ? null : this.period.copy();
    }

    protected ContactPoint typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ContactPoint)) {
            return false;
        }
        ContactPoint o = (ContactPoint)other_;
        return ContactPoint.compareDeep(this.system, o.system, true) && ContactPoint.compareDeep(this.value, o.value, true) && ContactPoint.compareDeep(this.use, o.use, true) && ContactPoint.compareDeep(this.rank, o.rank, true) && ContactPoint.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ContactPoint)) {
            return false;
        }
        ContactPoint o = (ContactPoint)other_;
        return ContactPoint.compareValues(this.system, o.system, true) && ContactPoint.compareValues(this.value, o.value, true) && ContactPoint.compareValues(this.use, o.use, true) && ContactPoint.compareValues(this.rank, o.rank, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.system, this.value, this.use, this.rank, this.period});
    }

    public static class ContactPointUseEnumFactory
    implements EnumFactory<ContactPointUse> {
        @Override
        public ContactPointUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("home".equals(codeString)) {
                return ContactPointUse.HOME;
            }
            if ("work".equals(codeString)) {
                return ContactPointUse.WORK;
            }
            if ("temp".equals(codeString)) {
                return ContactPointUse.TEMP;
            }
            if ("old".equals(codeString)) {
                return ContactPointUse.OLD;
            }
            if ("mobile".equals(codeString)) {
                return ContactPointUse.MOBILE;
            }
            throw new IllegalArgumentException("Unknown ContactPointUse code '" + codeString + "'");
        }

        public Enumeration<ContactPointUse> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.NULL, code);
            }
            if ("home".equals(codeString)) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.HOME, code);
            }
            if ("work".equals(codeString)) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.WORK, code);
            }
            if ("temp".equals(codeString)) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.TEMP, code);
            }
            if ("old".equals(codeString)) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.OLD, code);
            }
            if ("mobile".equals(codeString)) {
                return new Enumeration<ContactPointUse>(this, ContactPointUse.MOBILE, code);
            }
            throw new FHIRException("Unknown ContactPointUse code '" + codeString + "'");
        }

        @Override
        public String toCode(ContactPointUse code) {
            if (code == ContactPointUse.HOME) {
                return "home";
            }
            if (code == ContactPointUse.WORK) {
                return "work";
            }
            if (code == ContactPointUse.TEMP) {
                return "temp";
            }
            if (code == ContactPointUse.OLD) {
                return "old";
            }
            if (code == ContactPointUse.MOBILE) {
                return "mobile";
            }
            return "?";
        }

        @Override
        public String toSystem(ContactPointUse code) {
            return code.getSystem();
        }
    }

    public static enum ContactPointUse {
        HOME,
        WORK,
        TEMP,
        OLD,
        MOBILE,
        NULL;


        public static ContactPointUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("home".equals(codeString)) {
                return HOME;
            }
            if ("work".equals(codeString)) {
                return WORK;
            }
            if ("temp".equals(codeString)) {
                return TEMP;
            }
            if ("old".equals(codeString)) {
                return OLD;
            }
            if ("mobile".equals(codeString)) {
                return MOBILE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ContactPointUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HOME: {
                    return "home";
                }
                case WORK: {
                    return "work";
                }
                case TEMP: {
                    return "temp";
                }
                case OLD: {
                    return "old";
                }
                case MOBILE: {
                    return "mobile";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HOME: {
                    return "http://hl7.org/fhir/contact-point-use";
                }
                case WORK: {
                    return "http://hl7.org/fhir/contact-point-use";
                }
                case TEMP: {
                    return "http://hl7.org/fhir/contact-point-use";
                }
                case OLD: {
                    return "http://hl7.org/fhir/contact-point-use";
                }
                case MOBILE: {
                    return "http://hl7.org/fhir/contact-point-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HOME: {
                    return "A communication contact point at a home; attempted contacts for business purposes might intrude privacy and chances are one will contact family or other household members instead of the person one wishes to call. Typically used with urgent cases, or if no other contacts are available.";
                }
                case WORK: {
                    return "An office contact point. First choice for business related contacts during business hours.";
                }
                case TEMP: {
                    return "A temporary contact point. The period can provide more detailed information.";
                }
                case OLD: {
                    return "This contact point is no longer in use (or was never correct, but retained for records).";
                }
                case MOBILE: {
                    return "A telecommunication device that moves and stays with its owner. May have characteristics of all other use codes, suitable for urgent matters, not the first choice for routine business.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HOME: {
                    return "Home";
                }
                case WORK: {
                    return "Work";
                }
                case TEMP: {
                    return "Temp";
                }
                case OLD: {
                    return "Old";
                }
                case MOBILE: {
                    return "Mobile";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ContactPointSystemEnumFactory
    implements EnumFactory<ContactPointSystem> {
        @Override
        public ContactPointSystem fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("phone".equals(codeString)) {
                return ContactPointSystem.PHONE;
            }
            if ("fax".equals(codeString)) {
                return ContactPointSystem.FAX;
            }
            if ("email".equals(codeString)) {
                return ContactPointSystem.EMAIL;
            }
            if ("pager".equals(codeString)) {
                return ContactPointSystem.PAGER;
            }
            if ("url".equals(codeString)) {
                return ContactPointSystem.URL;
            }
            if ("sms".equals(codeString)) {
                return ContactPointSystem.SMS;
            }
            if ("other".equals(codeString)) {
                return ContactPointSystem.OTHER;
            }
            throw new IllegalArgumentException("Unknown ContactPointSystem code '" + codeString + "'");
        }

        public Enumeration<ContactPointSystem> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.NULL, code);
            }
            if ("phone".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.PHONE, code);
            }
            if ("fax".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.FAX, code);
            }
            if ("email".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.EMAIL, code);
            }
            if ("pager".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.PAGER, code);
            }
            if ("url".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.URL, code);
            }
            if ("sms".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.SMS, code);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<ContactPointSystem>(this, ContactPointSystem.OTHER, code);
            }
            throw new FHIRException("Unknown ContactPointSystem code '" + codeString + "'");
        }

        @Override
        public String toCode(ContactPointSystem code) {
            if (code == ContactPointSystem.PHONE) {
                return "phone";
            }
            if (code == ContactPointSystem.FAX) {
                return "fax";
            }
            if (code == ContactPointSystem.EMAIL) {
                return "email";
            }
            if (code == ContactPointSystem.PAGER) {
                return "pager";
            }
            if (code == ContactPointSystem.URL) {
                return "url";
            }
            if (code == ContactPointSystem.SMS) {
                return "sms";
            }
            if (code == ContactPointSystem.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(ContactPointSystem code) {
            return code.getSystem();
        }
    }

    public static enum ContactPointSystem {
        PHONE,
        FAX,
        EMAIL,
        PAGER,
        URL,
        SMS,
        OTHER,
        NULL;


        public static ContactPointSystem fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("phone".equals(codeString)) {
                return PHONE;
            }
            if ("fax".equals(codeString)) {
                return FAX;
            }
            if ("email".equals(codeString)) {
                return EMAIL;
            }
            if ("pager".equals(codeString)) {
                return PAGER;
            }
            if ("url".equals(codeString)) {
                return URL;
            }
            if ("sms".equals(codeString)) {
                return SMS;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ContactPointSystem code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PHONE: {
                    return "phone";
                }
                case FAX: {
                    return "fax";
                }
                case EMAIL: {
                    return "email";
                }
                case PAGER: {
                    return "pager";
                }
                case URL: {
                    return "url";
                }
                case SMS: {
                    return "sms";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PHONE: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case FAX: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case EMAIL: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case PAGER: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case URL: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case SMS: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/contact-point-system";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PHONE: {
                    return "The value is a telephone number used for voice calls. Use of full international numbers starting with + is recommended to enable automatic dialing support but not required.";
                }
                case FAX: {
                    return "The value is a fax machine. Use of full international numbers starting with + is recommended to enable automatic dialing support but not required.";
                }
                case EMAIL: {
                    return "The value is an email address.";
                }
                case PAGER: {
                    return "The value is a pager number. These may be local pager numbers that are only usable on a particular pager system.";
                }
                case URL: {
                    return "A contact that is not a phone, fax, pager or email address and is expressed as a URL.  This is intended for various institutional or personal contacts including web sites, blogs, Skype, Twitter, Facebook, etc. Do not use for email addresses.";
                }
                case SMS: {
                    return "A contact that can be used for sending an sms message (e.g. mobile phones, some landlines).";
                }
                case OTHER: {
                    return "A contact that is not a phone, fax, page or email address and is not expressible as a URL.  E.g. Internal mail address.  This SHOULD NOT be used for contacts that are expressible as a URL (e.g. Skype, Twitter, Facebook, etc.)  Extensions may be used to distinguish \"other\" contact types.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PHONE: {
                    return "Phone";
                }
                case FAX: {
                    return "Fax";
                }
                case EMAIL: {
                    return "Email";
                }
                case PAGER: {
                    return "Pager";
                }
                case URL: {
                    return "URL";
                }
                case SMS: {
                    return "SMS";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

