/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Ratio;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationAdministration", profile="http://hl7.org/fhir/StructureDefinition/MedicationAdministration")
public class MedicationAdministration
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="instantiates", type={UriType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="A protocol, guideline, orderset, or other definition that was adhered to in whole or in part by this event.")
    protected List<UriType> instantiates;
    @Child(name="partOf", type={MedicationAdministration.class, Procedure.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | not-done | on-hold | completed | entered-in-error | stopped | unknown", formalDefinition="Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-status")
    protected Enumeration<MedicationAdministrationStatusCodes> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason administration not performed", formalDefinition="A code indicating why the administration was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-not-given-codes")
    protected List<CodeableConcept> statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of medication usage", formalDefinition="Indicates where the medication is expected to be consumed or administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-category")
    protected CodeableConcept category;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What was administered", formalDefinition="Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected DataType medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who received medication", formalDefinition="The person or animal or group receiving the medication.")
    protected Reference subject;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter or Episode of Care administered as part of", formalDefinition="The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.")
    protected Reference context;
    @Child(name="supportingInformation", type={Reference.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information to support administration", formalDefinition="Additional information (for example, patient height and weight) that supports the administration of the medication.")
    protected List<Reference> supportingInformation;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end time of administration", formalDefinition="A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.")
    protected DataType effective;
    @Child(name="performer", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who performed the medication administration and what they did", formalDefinition="Indicates who or what performed the medication administration and how they were involved.")
    protected List<MedicationAdministrationPerformerComponent> performer;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason administration performed", formalDefinition="A code indicating why the medication was given.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-given-codes")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class, DiagnosticReport.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition or observation that supports why the medication was administered", formalDefinition="Condition or observation that supports why the medication was administered.")
    protected List<Reference> reasonReference;
    @Child(name="request", type={MedicationRequest.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request administration performed against", formalDefinition="The original request, instruction or authority to perform the administration.")
    protected Reference request;
    @Child(name="device", type={Device.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device used to administer", formalDefinition="The device used in administering the medication to the patient.  For example, a particular infusion pump.")
    protected List<Reference> device;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the administration", formalDefinition="Extra information about the medication administration that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosage", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of how medication was taken", formalDefinition="Describes the medication dosage information details e.g. dose, rate, site, route, etc.")
    protected MedicationAdministrationDosageComponent dosage;
    @Child(name="eventHistory", type={Provenance.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="A summary of the events of interest that have occurred, such as when the administration was verified.")
    protected List<Reference> eventHistory;
    private static final long serialVersionUID = 1202226940L;
    @SearchParamDefinition(name="context", path="MedicationAdministration.context", description="Return administrations that share this encounter or episode of care", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("MedicationAdministration:context").toLocked();
    @SearchParamDefinition(name="device", path="MedicationAdministration.device", description="Return administrations with this administration device identity", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device")}, target={Device.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("MedicationAdministration:device").toLocked();
    @SearchParamDefinition(name="effective-time", path="MedicationAdministration.effective", description="Date administration happened (or did not happen)", type="date")
    public static final String SP_EFFECTIVE_TIME = "effective-time";
    public static final DateClientParam EFFECTIVE_TIME = new DateClientParam("effective-time");
    @SearchParamDefinition(name="performer", path="MedicationAdministration.performer.actor", description="The identity of the individual who administered the medication", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("MedicationAdministration:performer").toLocked();
    @SearchParamDefinition(name="reason-given", path="MedicationAdministration.reasonCode", description="Reasons for administering the medication", type="token")
    public static final String SP_REASON_GIVEN = "reason-given";
    public static final TokenClientParam REASON_GIVEN = new TokenClientParam("reason-given");
    @SearchParamDefinition(name="reason-not-given", path="MedicationAdministration.statusReason", description="Reasons for not administering the medication", type="token")
    public static final String SP_REASON_NOT_GIVEN = "reason-not-given";
    public static final TokenClientParam REASON_NOT_GIVEN = new TokenClientParam("reason-not-given");
    @SearchParamDefinition(name="request", path="MedicationAdministration.request", description="The identity of a request to list administrations from", type="reference", target={MedicationRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("MedicationAdministration:request").toLocked();
    @SearchParamDefinition(name="subject", path="MedicationAdministration.subject", description="The identity of the individual or group to list administrations for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationAdministration:subject").toLocked();
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | (DeviceRequest.code as CodeableConcept) | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | (MedicationAdministration.medication as CodeableConcept) | (MedicationDispense.medication as CodeableConcept) | (MedicationRequest.medication as CodeableConcept) | (MedicationStatement.medication as CodeableConcept) | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.masterIdentifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Master Version Specific Identifier\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.patient | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject.where(resolve() is Patient) | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationAdministration:patient").toLocked();
    @SearchParamDefinition(name="medication", path="(MedicationAdministration.medication as Reference) | (MedicationDispense.medication as Reference) | (MedicationRequest.medication as Reference) | (MedicationStatement.medication as Reference)", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication resource\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine resource\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions for this medication reference\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication reference\r\n", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationAdministration:medication").toLocked();
    @SearchParamDefinition(name="status", path="MedicationAdministration.status | MedicationDispense.status | MedicationRequest.status | MedicationStatement.status", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): MedicationAdministration event status (for example one of active/paused/completed/nullified)\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specified dispense status\r\n* [MedicationRequest](medicationrequest.html): Status of the prescription\r\n* [MedicationStatement](medicationstatement.html): Return statements that match the given status\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationAdministration() {
    }

    public MedicationAdministration(MedicationAdministrationStatusCodes status, DataType medication, Reference subject, DataType effective) {
        this.setStatus(status);
        this.setMedication(medication);
        this.setSubject(subject);
        this.setEffective(effective);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationAdministration setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationAdministration addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<UriType> getInstantiates() {
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<UriType>();
        }
        return this.instantiates;
    }

    public MedicationAdministration setInstantiates(List<UriType> theInstantiates) {
        this.instantiates = theInstantiates;
        return this;
    }

    public boolean hasInstantiates() {
        if (this.instantiates == null) {
            return false;
        }
        for (UriType item : this.instantiates) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesElement() {
        UriType t = new UriType();
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<UriType>();
        }
        this.instantiates.add(t);
        return t;
    }

    public MedicationAdministration addInstantiates(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<UriType>();
        }
        this.instantiates.add(t);
        return this;
    }

    public boolean hasInstantiates(String value) {
        if (this.instantiates == null) {
            return false;
        }
        for (UriType v : this.instantiates) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public MedicationAdministration setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public MedicationAdministration addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<MedicationAdministrationStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationAdministrationStatusCodes>(new MedicationAdministrationStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationAdministration setStatusElement(Enumeration<MedicationAdministrationStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationAdministrationStatusCodes getStatus() {
        return this.status == null ? null : (MedicationAdministrationStatusCodes)((Object)this.status.getValue());
    }

    public MedicationAdministration setStatus(MedicationAdministrationStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationAdministrationStatusCodes>(new MedicationAdministrationStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getStatusReason() {
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        return this.statusReason;
    }

    public MedicationAdministration setStatusReason(List<CodeableConcept> theStatusReason) {
        this.statusReason = theStatusReason;
        return this;
    }

    public boolean hasStatusReason() {
        if (this.statusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.statusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return t;
    }

    public MedicationAdministration addStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return this;
    }

    public CodeableConcept getStatusReasonFirstRep() {
        if (this.getStatusReason().isEmpty()) {
            this.addStatusReason();
        }
        return this.getStatusReason().get(0);
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public MedicationAdministration setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public DataType getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (this.medication == null) {
            this.medication = new CodeableConcept();
        }
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this != null && this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (this.medication == null) {
            this.medication = new Reference();
        }
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this != null && this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationAdministration setMedication(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for MedicationAdministration.medication[x]: " + value.fhirType());
        }
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationAdministration setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public MedicationAdministration setContext(Reference value) {
        this.context = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public MedicationAdministration setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationAdministration addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public DataType getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public MedicationAdministration setEffective(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for MedicationAdministration.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public List<MedicationAdministrationPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        return this.performer;
    }

    public MedicationAdministration setPerformer(List<MedicationAdministrationPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (MedicationAdministrationPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationAdministrationPerformerComponent addPerformer() {
        MedicationAdministrationPerformerComponent t = new MedicationAdministrationPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public MedicationAdministration addPerformer(MedicationAdministrationPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public MedicationAdministrationPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public MedicationAdministration setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public MedicationAdministration addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public MedicationAdministration setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public MedicationAdministration addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public MedicationAdministration setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public MedicationAdministration setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicationAdministration addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationAdministration setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationAdministration addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public MedicationAdministrationDosageComponent getDosage() {
        if (this.dosage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.dosage");
            }
            if (Configuration.doAutoCreate()) {
                this.dosage = new MedicationAdministrationDosageComponent();
            }
        }
        return this.dosage;
    }

    public boolean hasDosage() {
        return this.dosage != null && !this.dosage.isEmpty();
    }

    public MedicationAdministration setDosage(MedicationAdministrationDosageComponent value) {
        this.dosage = value;
        return this;
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public MedicationAdministration setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public MedicationAdministration addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiates", "uri", "A protocol, guideline, orderset, or other definition that was adhered to in whole or in part by this event.", 0, Integer.MAX_VALUE, this.instantiates));
        children.add(new Property("partOf", "Reference(MedicationAdministration|Procedure)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.statusReason));
        children.add(new Property("category", "CodeableConcept", "Indicates where the medication is expected to be consumed or administered.", 0, 1, this.category));
        children.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person or animal or group receiving the medication.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.", 0, 1, this.context));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information (for example, patient height and weight) that supports the administration of the medication.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective));
        children.add(new Property(SP_PERFORMER, "", "Indicates who or what performed the medication administration and how they were involved.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("reasonCode", "CodeableConcept", "A code indicating why the medication was given.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport)", "Condition or observation that supports why the medication was administered.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property(SP_REQUEST, "Reference(MedicationRequest)", "The original request, instruction or authority to perform the administration.", 0, 1, this.request));
        children.add(new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("note", "Annotation", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, 1, this.dosage));
        children.add(new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the administration was verified.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -246883639: {
                return new Property("instantiates", "uri", "A protocol, guideline, orderset, or other definition that was adhered to in whole or in part by this event.", 0, Integer.MAX_VALUE, this.instantiates);
            }
            case -995410646: {
                return new Property("partOf", "Reference(MedicationAdministration|Procedure)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.statusReason);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Indicates where the medication is expected to be consumed or administered.", 0, 1, this.category);
            }
            case 1458402129: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 1998965455: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -209845038: {
                return new Property("medication[x]", "CodeableConcept", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 2104315196: {
                return new Property("medication[x]", "Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person or animal or group receiving the medication.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.", 0, 1, this.context);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information (for example, patient height and weight) that supports the administration of the medication.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.effective);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Indicates who or what performed the medication administration and how they were involved.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "A code indicating why the medication was given.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport)", "Condition or observation that supports why the medication was administered.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(MedicationRequest)", "The original request, instruction or authority to perform the administration.", 0, 1, this.request);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1326018889: {
                return new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, 1, this.dosage);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the administration was verified.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -246883639: {
                return this.instantiates == null ? new Base[]{} : this.instantiates.toArray(new Base[this.instantiates.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.category;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.effective;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.request;
                }
                return baseArray;
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1326018889: {
                Base[] baseArray;
                if (this.dosage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.dosage;
                }
                return baseArray;
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -246883639: {
                this.getInstantiates().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new MedicationAdministrationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 50511102: {
                this.category = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1998965455: {
                this.medication = TypeConvertor.castToType(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = TypeConvertor.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1468651097: {
                this.effective = TypeConvertor.castToType(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((MedicationAdministrationPerformerComponent)((Object)value));
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1095692943: {
                this.request = TypeConvertor.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.getDevice().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1326018889: {
                this.dosage = (MedicationAdministrationDosageComponent)((Object)value);
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiates")) {
            this.getInstantiates().add(TypeConvertor.castToUri(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationAdministrationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("category")) {
            this.category = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("medication[x]")) {
            this.medication = TypeConvertor.castToType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = TypeConvertor.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("effective[x]")) {
            this.effective = TypeConvertor.castToType(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((MedicationAdministrationPerformerComponent)((Object)value));
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_REQUEST)) {
            this.request = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.getDevice().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("dosage")) {
            this.dosage = (MedicationAdministrationDosageComponent)((Object)value);
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -246883639: {
                return this.addInstantiatesElement();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.addStatusReason();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 1458402129: {
                return this.getMedication();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1326018889: {
                return this.getDosage();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -246883639: {
                return new String[]{"uri"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1998965455: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case 481140686: {
                return new String[0];
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1326018889: {
                return new String[0];
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiates")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.instantiates");
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.status");
        }
        if (name.equals("statusReason")) {
            return this.addStatusReason();
        }
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_DEVICE)) {
            return this.addDevice();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosage")) {
            this.dosage = new MedicationAdministrationDosageComponent();
            return this.dosage;
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationAdministration";
    }

    @Override
    public MedicationAdministration copy() {
        MedicationAdministration dst = new MedicationAdministration();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationAdministration dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiates != null) {
            dst.instantiates = new ArrayList<UriType>();
            for (UriType uriType : this.instantiates) {
                dst.instantiates.add(uriType.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<MedicationAdministrationStatusCodes> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusReason != null) {
            dst.statusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.statusReason) {
                dst.statusReason.add(codeableConcept.copy());
            }
        }
        dst.category = this.category == null ? null : this.category.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        Reference reference = dst.context = this.context == null ? null : this.context.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference2 : this.supportingInformation) {
                dst.supportingInformation.add(reference2.copy());
            }
        }
        DataType dataType = dst.effective = this.effective == null ? null : this.effective.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
            for (MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : this.performer) {
                dst.performer.add(medicationAdministrationPerformerComponent.copy());
            }
        }
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference3 : this.reasonReference) {
                dst.reasonReference.add(reference3.copy());
            }
        }
        Reference reference4 = dst.request = this.request == null ? null : this.request.copy();
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference5 : this.device) {
                dst.device.add(reference5.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = dst.dosage = this.dosage == null ? null : this.dosage.copy();
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference6 : this.eventHistory) {
                dst.eventHistory.add(reference6.copy());
            }
        }
    }

    protected MedicationAdministration typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other_;
        return MedicationAdministration.compareDeep(this.identifier, o.identifier, true) && MedicationAdministration.compareDeep(this.instantiates, o.instantiates, true) && MedicationAdministration.compareDeep(this.partOf, o.partOf, true) && MedicationAdministration.compareDeep(this.status, o.status, true) && MedicationAdministration.compareDeep(this.statusReason, o.statusReason, true) && MedicationAdministration.compareDeep(this.category, o.category, true) && MedicationAdministration.compareDeep(this.medication, o.medication, true) && MedicationAdministration.compareDeep(this.subject, o.subject, true) && MedicationAdministration.compareDeep(this.context, o.context, true) && MedicationAdministration.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationAdministration.compareDeep(this.effective, o.effective, true) && MedicationAdministration.compareDeep(this.performer, o.performer, true) && MedicationAdministration.compareDeep(this.reasonCode, o.reasonCode, true) && MedicationAdministration.compareDeep(this.reasonReference, o.reasonReference, true) && MedicationAdministration.compareDeep(this.request, o.request, true) && MedicationAdministration.compareDeep(this.device, o.device, true) && MedicationAdministration.compareDeep(this.note, o.note, true) && MedicationAdministration.compareDeep(this.dosage, o.dosage, true) && MedicationAdministration.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other_;
        return MedicationAdministration.compareValues(this.instantiates, o.instantiates, true) && MedicationAdministration.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiates, this.partOf, this.status, this.statusReason, this.category, this.medication, this.subject, this.context, this.supportingInformation, this.effective, this.performer, this.reasonCode, this.reasonReference, this.request, this.device, this.note, this.dosage, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationAdministration;
    }

    @Block
    public static class MedicationAdministrationDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Free text dosage instructions e.g. SIG", formalDefinition="Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.")
        protected StringType text;
        @Child(name="site", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Body site administered to", formalDefinition="A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
        protected CodeableConcept site;
        @Child(name="route", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path of substance into body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How drug was administered", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
        protected CodeableConcept method;
        @Child(name="dose", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.")
        protected Quantity dose;
        @Child(name="rate", type={Ratio.class, Quantity.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected DataType rate;
        private static final long serialVersionUID = -484090956L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationAdministrationDosageComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationAdministrationDosageComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getSite() {
            if (this.site == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.site");
                }
                if (Configuration.doAutoCreate()) {
                    this.site = new CodeableConcept();
                }
            }
            return this.site;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationAdministrationDosageComponent setSite(CodeableConcept value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationAdministrationDosageComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public Quantity getDose() {
            if (this.dose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.dose");
                }
                if (Configuration.doAutoCreate()) {
                    this.dose = new Quantity();
                }
            }
            return this.dose;
        }

        public boolean hasDose() {
            return this.dose != null && !this.dose.isEmpty();
        }

        public MedicationAdministrationDosageComponent setDose(Quantity value) {
            this.dose = value;
            return this;
        }

        public DataType getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Ratio();
            }
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this != null && this.rate instanceof Ratio;
        }

        public Quantity getRateQuantity() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Quantity();
            }
            if (!(this.rate instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Quantity)this.rate;
        }

        public boolean hasRateQuantity() {
            return this != null && this.rate instanceof Quantity;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRate(DataType value) {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for MedicationAdministration.dosage.rate[x]: " + value.fhirType());
            }
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("text", "string", "Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.", 0, 1, this.text));
            children.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, 1, this.site));
            children.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, 1, this.route));
            children.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, 1, this.method));
            children.add(new Property("dose", "Quantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, 1, this.dose));
            children.add(new Property("rate[x]", "Ratio|Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3556653: {
                    return new Property("text", "string", "Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.", 0, 1, this.text);
                }
                case 3530567: {
                    return new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, 1, this.site);
                }
                case 108704329: {
                    return new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, 1, this.route);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, 1, this.method);
                }
                case 3089437: {
                    return new Property("dose", "Quantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, 1, this.dose);
                }
                case 983460768: {
                    return new Property("rate[x]", "Ratio|Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case 3493088: {
                    return new Property("rate[x]", "Ratio|Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case 204021515: {
                    return new Property("rate[x]", "Ratio", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case -1085459061: {
                    return new Property("rate[x]", "Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.text;
                    }
                    return baseArray;
                }
                case 3530567: {
                    Base[] baseArray;
                    if (this.site == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.site;
                    }
                    return baseArray;
                }
                case 108704329: {
                    Base[] baseArray;
                    if (this.route == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.route;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.method;
                    }
                    return baseArray;
                }
                case 3089437: {
                    Base[] baseArray;
                    if (this.dose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.dose;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.rate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
                case 3530567: {
                    this.site = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 108704329: {
                    this.route = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1077554975: {
                    this.method = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3089437: {
                    this.dose = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3493088: {
                    this.rate = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else if (name.equals("site")) {
                this.site = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("route")) {
                this.route = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dose")) {
                this.dose = TypeConvertor.castToQuantity(value);
            } else if (name.equals("rate[x]")) {
                this.rate = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    return this.getTextElement();
                }
                case 3530567: {
                    return this.getSite();
                }
                case 108704329: {
                    return this.getRoute();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case 3089437: {
                    return this.getDose();
                }
                case 983460768: {
                    return this.getRate();
                }
                case 3493088: {
                    return this.getRate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    return new String[]{"string"};
                }
                case 3530567: {
                    return new String[]{"CodeableConcept"};
                }
                case 108704329: {
                    return new String[]{"CodeableConcept"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 3089437: {
                    return new String[]{"Quantity"};
                }
                case 3493088: {
                    return new String[]{"Ratio", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.dosage.text");
            }
            if (name.equals("site")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("dose")) {
                this.dose = new Quantity();
                return this.dose;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateQuantity")) {
                this.rate = new Quantity();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationDosageComponent copy() {
            MedicationAdministrationDosageComponent dst = new MedicationAdministrationDosageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationAdministrationDosageComponent dst) {
            super.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.dose = this.dose == null ? null : this.dose.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other_;
            return MedicationAdministrationDosageComponent.compareDeep(this.text, o.text, true) && MedicationAdministrationDosageComponent.compareDeep(this.site, o.site, true) && MedicationAdministrationDosageComponent.compareDeep(this.route, o.route, true) && MedicationAdministrationDosageComponent.compareDeep(this.method, o.method, true) && MedicationAdministrationDosageComponent.compareDeep(this.dose, o.dose, true) && MedicationAdministrationDosageComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other_;
            return MedicationAdministrationDosageComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.text, this.site, this.route, this.method, this.dose, this.rate});
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.dosage";
        }
    }

    @Block
    public static class MedicationAdministrationPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of performance", formalDefinition="Distinguishes the type of involvement of the performer in the medication administration.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/med-admin-perform-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Device.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the medication administration", formalDefinition="Indicates who or what performed the medication administration.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public MedicationAdministrationPerformerComponent() {
        }

        public MedicationAdministrationPerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public MedicationAdministrationPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public MedicationAdministrationPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the medication administration.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device)", "Indicates who or what performed the medication administration.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the medication administration.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device)", "Indicates who or what performed the medication administration.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationPerformerComponent copy() {
            MedicationAdministrationPerformerComponent dst = new MedicationAdministrationPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationAdministrationPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationPerformerComponent)) {
                return false;
            }
            MedicationAdministrationPerformerComponent o = (MedicationAdministrationPerformerComponent)other_;
            return MedicationAdministrationPerformerComponent.compareDeep(this.function, o.function, true) && MedicationAdministrationPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationPerformerComponent)) {
                return false;
            }
            MedicationAdministrationPerformerComponent o = (MedicationAdministrationPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.performer";
        }
    }

    public static class MedicationAdministrationStatusCodesEnumFactory
    implements EnumFactory<MedicationAdministrationStatusCodes> {
        @Override
        public MedicationAdministrationStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return MedicationAdministrationStatusCodes.INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return MedicationAdministrationStatusCodes.NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationAdministrationStatusCodes.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationAdministrationStatusCodes.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationAdministrationStatusCodes.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationAdministrationStatusCodes.STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return MedicationAdministrationStatusCodes.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MedicationAdministrationStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationAdministrationStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.NULL, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.INPROGRESS, code);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.NOTDONE, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.ONHOLD, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.ENTEREDINERROR, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.STOPPED, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.UNKNOWN, code);
            }
            throw new FHIRException("Unknown MedicationAdministrationStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationAdministrationStatusCodes code) {
            if (code == MedicationAdministrationStatusCodes.INPROGRESS) {
                return "in-progress";
            }
            if (code == MedicationAdministrationStatusCodes.NOTDONE) {
                return "not-done";
            }
            if (code == MedicationAdministrationStatusCodes.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationAdministrationStatusCodes.COMPLETED) {
                return "completed";
            }
            if (code == MedicationAdministrationStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationAdministrationStatusCodes.STOPPED) {
                return "stopped";
            }
            if (code == MedicationAdministrationStatusCodes.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationAdministrationStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationAdministrationStatusCodes {
        INPROGRESS,
        NOTDONE,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        UNKNOWN,
        NULL;


        public static MedicationAdministrationStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationAdministrationStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case NOTDONE: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case ONHOLD: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case COMPLETED: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case ENTEREDINERROR: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case STOPPED: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case UNKNOWN: {
                    return "http://terminology.hl7.org/CodeSystem/medication-admin-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The administration has started but has not yet completed.";
                }
                case NOTDONE: {
                    return "The administration was terminated prior to any impact on the subject (though preparatory actions may have been taken)";
                }
                case ONHOLD: {
                    return "Actions implied by the administration have been temporarily halted, but are expected to continue later. May also be called 'suspended'.";
                }
                case COMPLETED: {
                    return "All actions that are implied by the administration have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The administration was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the administration have been permanently halted, before all of them occurred.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for 'other' - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case NOTDONE: {
                    return "Not Done";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

