/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UrlType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="TerminologyCapabilities", profile="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities")
public class TerminologyCapabilities
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this terminology capabilities, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this terminology capabilities when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this terminology capabilities is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the terminology capabilities is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the terminology capabilities", formalDefinition="The identifier that is used to identify this version of the terminology capabilities when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the terminology capabilities author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this terminology capabilities (computer friendly)", formalDefinition="A natural language name identifying the terminology capabilities. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this terminology capabilities (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the terminology capabilities.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this terminology capabilities. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this terminology capabilities is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the terminology capabilities was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the terminology capabilities changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the terminology capabilities.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the terminology capabilities", formalDefinition="A free text natural language description of the terminology capabilities from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate terminology capabilities instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for terminology capabilities (if applicable)", formalDefinition="A legal or geographic region in which the terminology capabilities is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this terminology capabilities is defined", formalDefinition="Explanation of why this terminology capabilities is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the terminology capabilities and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the terminology capabilities.")
    protected MarkdownType copyright;
    @Child(name="kind", type={CodeType.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="instance | capability | requirements", formalDefinition="The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/capability-statement-kind")
    protected Enumeration<Enumerations.CapabilityStatementKind> kind;
    @Child(name="software", type={}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Software that is covered by this terminology capability statement", formalDefinition="Software that is covered by this terminology capability statement.  It is used when the statement describes the capabilities of a particular software version, independent of an installation.")
    protected TerminologyCapabilitiesSoftwareComponent software;
    @Child(name="implementation", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this describes a specific instance", formalDefinition="Identifies a specific implementation instance that is described by the terminology capability statement - i.e. a particular installation, rather than the capabilities of a software program.")
    protected TerminologyCapabilitiesImplementationComponent implementation;
    @Child(name="lockedDate", type={BooleanType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether lockedDate is supported", formalDefinition="Whether the server supports lockedDate.")
    protected BooleanType lockedDate;
    @Child(name="codeSystem", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A code system supported by the server", formalDefinition="Identifies a code system that is supported by the server. If there is a no code system URL, then this declares the general assumptions a client can make about support for any CodeSystem resource.")
    protected List<TerminologyCapabilitiesCodeSystemComponent> codeSystem;
    @Child(name="expansion", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the [ValueSet/$expand](valueset-operation-expand.html) operation", formalDefinition="Information about the [ValueSet/$expand](valueset-operation-expand.html) operation.")
    protected TerminologyCapabilitiesExpansionComponent expansion;
    @Child(name="codeSearch", type={CodeType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="explicit | all", formalDefinition="The degree to which the server supports the code search parameter on ValueSet, if it is supported.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/code-search-support")
    protected Enumeration<CodeSearchSupport> codeSearch;
    @Child(name="validateCode", type={}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the [ValueSet/$validate-code](valueset-operation-validate-code.html) operation", formalDefinition="Information about the [ValueSet/$validate-code](valueset-operation-validate-code.html) operation.")
    protected TerminologyCapabilitiesValidateCodeComponent validateCode;
    @Child(name="translation", type={}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the [ConceptMap/$translate](conceptmap-operation-translate.html) operation", formalDefinition="Information about the [ConceptMap/$translate](conceptmap-operation-translate.html) operation.")
    protected TerminologyCapabilitiesTranslationComponent translation;
    @Child(name="closure", type={}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the [ConceptMap/$closure](conceptmap-operation-closure.html) operation", formalDefinition="Whether the $closure operation is supported.")
    protected TerminologyCapabilitiesClosureComponent closure;
    private static final long serialVersionUID = -471633367L;
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="CapabilityStatement.title | CodeSystem.title | ConceptMap.title | ImplementationGuide.title | MessageDefinition.title | OperationDefinition.title | StructureDefinition.title | StructureMap.title | TerminologyCapabilities.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public TerminologyCapabilities() {
    }

    public TerminologyCapabilities(Enumerations.PublicationStatus status, Date date, Enumerations.CapabilityStatementKind kind) {
        this.setStatus(status);
        this.setDate(date);
        this.setKind(kind);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public TerminologyCapabilities setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public TerminologyCapabilities setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public TerminologyCapabilities setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public TerminologyCapabilities setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public TerminologyCapabilities setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public TerminologyCapabilities setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public TerminologyCapabilities setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public TerminologyCapabilities setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public TerminologyCapabilities setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public TerminologyCapabilities setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public TerminologyCapabilities setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public TerminologyCapabilities setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public TerminologyCapabilities setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public TerminologyCapabilities setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public TerminologyCapabilities setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public TerminologyCapabilities setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public TerminologyCapabilities setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public TerminologyCapabilities addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public TerminologyCapabilities setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public TerminologyCapabilities setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public TerminologyCapabilities setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public TerminologyCapabilities addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public TerminologyCapabilities setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public TerminologyCapabilities addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public TerminologyCapabilities setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public TerminologyCapabilities setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public TerminologyCapabilities setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public TerminologyCapabilities setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.CapabilityStatementKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public TerminologyCapabilities setKindElement(Enumeration<Enumerations.CapabilityStatementKind> value) {
        this.kind = value;
        return this;
    }

    public Enumerations.CapabilityStatementKind getKind() {
        return this.kind == null ? null : (Enumerations.CapabilityStatementKind)((Object)this.kind.getValue());
    }

    public TerminologyCapabilities setKind(Enumerations.CapabilityStatementKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public TerminologyCapabilitiesSoftwareComponent getSoftware() {
        if (this.software == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.software");
            }
            if (Configuration.doAutoCreate()) {
                this.software = new TerminologyCapabilitiesSoftwareComponent();
            }
        }
        return this.software;
    }

    public boolean hasSoftware() {
        return this.software != null && !this.software.isEmpty();
    }

    public TerminologyCapabilities setSoftware(TerminologyCapabilitiesSoftwareComponent value) {
        this.software = value;
        return this;
    }

    public TerminologyCapabilitiesImplementationComponent getImplementation() {
        if (this.implementation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.implementation");
            }
            if (Configuration.doAutoCreate()) {
                this.implementation = new TerminologyCapabilitiesImplementationComponent();
            }
        }
        return this.implementation;
    }

    public boolean hasImplementation() {
        return this.implementation != null && !this.implementation.isEmpty();
    }

    public TerminologyCapabilities setImplementation(TerminologyCapabilitiesImplementationComponent value) {
        this.implementation = value;
        return this;
    }

    public BooleanType getLockedDateElement() {
        if (this.lockedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.lockedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lockedDate = new BooleanType();
            }
        }
        return this.lockedDate;
    }

    public boolean hasLockedDateElement() {
        return this.lockedDate != null && !this.lockedDate.isEmpty();
    }

    public boolean hasLockedDate() {
        return this.lockedDate != null && !this.lockedDate.isEmpty();
    }

    public TerminologyCapabilities setLockedDateElement(BooleanType value) {
        this.lockedDate = value;
        return this;
    }

    public boolean getLockedDate() {
        return this.lockedDate == null || this.lockedDate.isEmpty() ? false : (Boolean)this.lockedDate.getValue();
    }

    public TerminologyCapabilities setLockedDate(boolean value) {
        if (this.lockedDate == null) {
            this.lockedDate = new BooleanType();
        }
        this.lockedDate.setValue((Object)value);
        return this;
    }

    public List<TerminologyCapabilitiesCodeSystemComponent> getCodeSystem() {
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
        }
        return this.codeSystem;
    }

    public TerminologyCapabilities setCodeSystem(List<TerminologyCapabilitiesCodeSystemComponent> theCodeSystem) {
        this.codeSystem = theCodeSystem;
        return this;
    }

    public boolean hasCodeSystem() {
        if (this.codeSystem == null) {
            return false;
        }
        for (TerminologyCapabilitiesCodeSystemComponent item : this.codeSystem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TerminologyCapabilitiesCodeSystemComponent addCodeSystem() {
        TerminologyCapabilitiesCodeSystemComponent t = new TerminologyCapabilitiesCodeSystemComponent();
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return t;
    }

    public TerminologyCapabilities addCodeSystem(TerminologyCapabilitiesCodeSystemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return this;
    }

    public TerminologyCapabilitiesCodeSystemComponent getCodeSystemFirstRep() {
        if (this.getCodeSystem().isEmpty()) {
            this.addCodeSystem();
        }
        return this.getCodeSystem().get(0);
    }

    public TerminologyCapabilitiesExpansionComponent getExpansion() {
        if (this.expansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.expansion");
            }
            if (Configuration.doAutoCreate()) {
                this.expansion = new TerminologyCapabilitiesExpansionComponent();
            }
        }
        return this.expansion;
    }

    public boolean hasExpansion() {
        return this.expansion != null && !this.expansion.isEmpty();
    }

    public TerminologyCapabilities setExpansion(TerminologyCapabilitiesExpansionComponent value) {
        this.expansion = value;
        return this;
    }

    public Enumeration<CodeSearchSupport> getCodeSearchElement() {
        if (this.codeSearch == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.codeSearch");
            }
            if (Configuration.doAutoCreate()) {
                this.codeSearch = new Enumeration<CodeSearchSupport>(new CodeSearchSupportEnumFactory());
            }
        }
        return this.codeSearch;
    }

    public boolean hasCodeSearchElement() {
        return this.codeSearch != null && !this.codeSearch.isEmpty();
    }

    public boolean hasCodeSearch() {
        return this.codeSearch != null && !this.codeSearch.isEmpty();
    }

    public TerminologyCapabilities setCodeSearchElement(Enumeration<CodeSearchSupport> value) {
        this.codeSearch = value;
        return this;
    }

    public CodeSearchSupport getCodeSearch() {
        return this.codeSearch == null ? null : (CodeSearchSupport)((Object)this.codeSearch.getValue());
    }

    public TerminologyCapabilities setCodeSearch(CodeSearchSupport value) {
        if (value == null) {
            this.codeSearch = null;
        } else {
            if (this.codeSearch == null) {
                this.codeSearch = new Enumeration<CodeSearchSupport>(new CodeSearchSupportEnumFactory());
            }
            this.codeSearch.setValue((Object)value);
        }
        return this;
    }

    public TerminologyCapabilitiesValidateCodeComponent getValidateCode() {
        if (this.validateCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.validateCode");
            }
            if (Configuration.doAutoCreate()) {
                this.validateCode = new TerminologyCapabilitiesValidateCodeComponent();
            }
        }
        return this.validateCode;
    }

    public boolean hasValidateCode() {
        return this.validateCode != null && !this.validateCode.isEmpty();
    }

    public TerminologyCapabilities setValidateCode(TerminologyCapabilitiesValidateCodeComponent value) {
        this.validateCode = value;
        return this;
    }

    public TerminologyCapabilitiesTranslationComponent getTranslation() {
        if (this.translation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.translation");
            }
            if (Configuration.doAutoCreate()) {
                this.translation = new TerminologyCapabilitiesTranslationComponent();
            }
        }
        return this.translation;
    }

    public boolean hasTranslation() {
        return this.translation != null && !this.translation.isEmpty();
    }

    public TerminologyCapabilities setTranslation(TerminologyCapabilitiesTranslationComponent value) {
        this.translation = value;
        return this;
    }

    public TerminologyCapabilitiesClosureComponent getClosure() {
        if (this.closure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.closure");
            }
            if (Configuration.doAutoCreate()) {
                this.closure = new TerminologyCapabilitiesClosureComponent();
            }
        }
        return this.closure;
    }

    public boolean hasClosure() {
        return this.closure != null && !this.closure.isEmpty();
    }

    public TerminologyCapabilities setClosure(TerminologyCapabilitiesClosureComponent value) {
        this.closure = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this terminology capabilities when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this terminology capabilities is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the terminology capabilities is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the terminology capabilities when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the terminology capabilities author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the terminology capabilities. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the terminology capabilities.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this terminology capabilities. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this terminology capabilities is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the terminology capabilities was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the terminology capabilities changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the terminology capabilities.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the terminology capabilities from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate terminology capabilities instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the terminology capabilities is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this terminology capabilities is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the terminology capabilities and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the terminology capabilities.", 0, 1, this.copyright));
        children.add(new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).", 0, 1, this.kind));
        children.add(new Property("software", "", "Software that is covered by this terminology capability statement.  It is used when the statement describes the capabilities of a particular software version, independent of an installation.", 0, 1, this.software));
        children.add(new Property("implementation", "", "Identifies a specific implementation instance that is described by the terminology capability statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, 1, this.implementation));
        children.add(new Property("lockedDate", "boolean", "Whether the server supports lockedDate.", 0, 1, this.lockedDate));
        children.add(new Property("codeSystem", "", "Identifies a code system that is supported by the server. If there is a no code system URL, then this declares the general assumptions a client can make about support for any CodeSystem resource.", 0, Integer.MAX_VALUE, this.codeSystem));
        children.add(new Property("expansion", "", "Information about the [ValueSet/$expand](valueset-operation-expand.html) operation.", 0, 1, this.expansion));
        children.add(new Property("codeSearch", "code", "The degree to which the server supports the code search parameter on ValueSet, if it is supported.", 0, 1, this.codeSearch));
        children.add(new Property("validateCode", "", "Information about the [ValueSet/$validate-code](valueset-operation-validate-code.html) operation.", 0, 1, this.validateCode));
        children.add(new Property("translation", "", "Information about the [ConceptMap/$translate](conceptmap-operation-translate.html) operation.", 0, 1, this.translation));
        children.add(new Property("closure", "", "Whether the $closure operation is supported.", 0, 1, this.closure));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this terminology capabilities when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this terminology capabilities is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the terminology capabilities is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the terminology capabilities when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the terminology capabilities author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the terminology capabilities. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the terminology capabilities.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this terminology capabilities. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this terminology capabilities is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the terminology capabilities was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the terminology capabilities changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the terminology capabilities.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the terminology capabilities from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate terminology capabilities instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the terminology capabilities is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this terminology capabilities is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the terminology capabilities and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the terminology capabilities.", 0, 1, this.copyright);
            }
            case 3292052: {
                return new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).", 0, 1, this.kind);
            }
            case 1319330215: {
                return new Property("software", "", "Software that is covered by this terminology capability statement.  It is used when the statement describes the capabilities of a particular software version, independent of an installation.", 0, 1, this.software);
            }
            case 1683336114: {
                return new Property("implementation", "", "Identifies a specific implementation instance that is described by the terminology capability statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, 1, this.implementation);
            }
            case 1391591896: {
                return new Property("lockedDate", "boolean", "Whether the server supports lockedDate.", 0, 1, this.lockedDate);
            }
            case -916511108: {
                return new Property("codeSystem", "", "Identifies a code system that is supported by the server. If there is a no code system URL, then this declares the general assumptions a client can make about support for any CodeSystem resource.", 0, Integer.MAX_VALUE, this.codeSystem);
            }
            case 17878207: {
                return new Property("expansion", "", "Information about the [ValueSet/$expand](valueset-operation-expand.html) operation.", 0, 1, this.expansion);
            }
            case -935519755: {
                return new Property("codeSearch", "code", "The degree to which the server supports the code search parameter on ValueSet, if it is supported.", 0, 1, this.codeSearch);
            }
            case 1080737827: {
                return new Property("validateCode", "", "Information about the [ValueSet/$validate-code](valueset-operation-validate-code.html) operation.", 0, 1, this.validateCode);
            }
            case -1840647503: {
                return new Property("translation", "", "Information about the [ConceptMap/$translate](conceptmap-operation-translate.html) operation.", 0, 1, this.translation);
            }
            case 866552379: {
                return new Property("closure", "", "Whether the $closure operation is supported.", 0, 1, this.closure);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.kind;
                }
                return baseArray;
            }
            case 1319330215: {
                Base[] baseArray;
                if (this.software == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.software;
                }
                return baseArray;
            }
            case 1683336114: {
                Base[] baseArray;
                if (this.implementation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.implementation;
                }
                return baseArray;
            }
            case 1391591896: {
                Base[] baseArray;
                if (this.lockedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.lockedDate;
                }
                return baseArray;
            }
            case -916511108: {
                return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
            }
            case 17878207: {
                Base[] baseArray;
                if (this.expansion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.expansion;
                }
                return baseArray;
            }
            case -935519755: {
                Base[] baseArray;
                if (this.codeSearch == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.codeSearch;
                }
                return baseArray;
            }
            case 1080737827: {
                Base[] baseArray;
                if (this.validateCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.validateCode;
                }
                return baseArray;
            }
            case -1840647503: {
                Base[] baseArray;
                if (this.translation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.translation;
                }
                return baseArray;
            }
            case 866552379: {
                Base[] baseArray;
                if (this.closure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.closure;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3292052: {
                value = new Enumerations.CapabilityStatementKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
                return value;
            }
            case 1319330215: {
                this.software = (TerminologyCapabilitiesSoftwareComponent)((Object)value);
                return value;
            }
            case 1683336114: {
                this.implementation = (TerminologyCapabilitiesImplementationComponent)((Object)value);
                return value;
            }
            case 1391591896: {
                this.lockedDate = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -916511108: {
                this.getCodeSystem().add((TerminologyCapabilitiesCodeSystemComponent)((Object)value));
                return value;
            }
            case 17878207: {
                this.expansion = (TerminologyCapabilitiesExpansionComponent)((Object)value);
                return value;
            }
            case -935519755: {
                value = new CodeSearchSupportEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.codeSearch = value;
                return value;
            }
            case 1080737827: {
                this.validateCode = (TerminologyCapabilitiesValidateCodeComponent)((Object)value);
                return value;
            }
            case -1840647503: {
                this.translation = (TerminologyCapabilitiesTranslationComponent)((Object)value);
                return value;
            }
            case 866552379: {
                this.closure = (TerminologyCapabilitiesClosureComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("kind")) {
            value = new Enumerations.CapabilityStatementKindEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.kind = value;
        } else if (name.equals("software")) {
            this.software = (TerminologyCapabilitiesSoftwareComponent)((Object)value);
        } else if (name.equals("implementation")) {
            this.implementation = (TerminologyCapabilitiesImplementationComponent)((Object)value);
        } else if (name.equals("lockedDate")) {
            this.lockedDate = TypeConvertor.castToBoolean(value);
        } else if (name.equals("codeSystem")) {
            this.getCodeSystem().add((TerminologyCapabilitiesCodeSystemComponent)((Object)value));
        } else if (name.equals("expansion")) {
            this.expansion = (TerminologyCapabilitiesExpansionComponent)((Object)value);
        } else if (name.equals("codeSearch")) {
            value = new CodeSearchSupportEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.codeSearch = value;
        } else if (name.equals("validateCode")) {
            this.validateCode = (TerminologyCapabilitiesValidateCodeComponent)((Object)value);
        } else if (name.equals("translation")) {
            this.translation = (TerminologyCapabilitiesTranslationComponent)((Object)value);
        } else if (name.equals("closure")) {
            this.closure = (TerminologyCapabilitiesClosureComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case 1319330215: {
                return this.getSoftware();
            }
            case 1683336114: {
                return this.getImplementation();
            }
            case 1391591896: {
                return this.getLockedDateElement();
            }
            case -916511108: {
                return this.addCodeSystem();
            }
            case 17878207: {
                return this.getExpansion();
            }
            case -935519755: {
                return this.getCodeSearchElement();
            }
            case 1080737827: {
                return this.getValidateCode();
            }
            case -1840647503: {
                return this.getTranslation();
            }
            case 866552379: {
                return this.getClosure();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case 1319330215: {
                return new String[0];
            }
            case 1683336114: {
                return new String[0];
            }
            case 1391591896: {
                return new String[]{"boolean"};
            }
            case -916511108: {
                return new String[0];
            }
            case 17878207: {
                return new String[0];
            }
            case -935519755: {
                return new String[]{"code"};
            }
            case 1080737827: {
                return new String[0];
            }
            case -1840647503: {
                return new String[0];
            }
            case 866552379: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.copyright");
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.kind");
        }
        if (name.equals("software")) {
            this.software = new TerminologyCapabilitiesSoftwareComponent();
            return this.software;
        }
        if (name.equals("implementation")) {
            this.implementation = new TerminologyCapabilitiesImplementationComponent();
            return this.implementation;
        }
        if (name.equals("lockedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.lockedDate");
        }
        if (name.equals("codeSystem")) {
            return this.addCodeSystem();
        }
        if (name.equals("expansion")) {
            this.expansion = new TerminologyCapabilitiesExpansionComponent();
            return this.expansion;
        }
        if (name.equals("codeSearch")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSearch");
        }
        if (name.equals("validateCode")) {
            this.validateCode = new TerminologyCapabilitiesValidateCodeComponent();
            return this.validateCode;
        }
        if (name.equals("translation")) {
            this.translation = new TerminologyCapabilitiesTranslationComponent();
            return this.translation;
        }
        if (name.equals("closure")) {
            this.closure = new TerminologyCapabilitiesClosureComponent();
            return this.closure;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TerminologyCapabilities";
    }

    @Override
    public TerminologyCapabilities copy() {
        TerminologyCapabilities dst = new TerminologyCapabilities();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TerminologyCapabilities dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.software = this.software == null ? null : this.software.copy();
        dst.implementation = this.implementation == null ? null : this.implementation.copy();
        BooleanType booleanType = dst.lockedDate = this.lockedDate == null ? null : this.lockedDate.copy();
        if (this.codeSystem != null) {
            dst.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
            for (TerminologyCapabilitiesCodeSystemComponent terminologyCapabilitiesCodeSystemComponent : this.codeSystem) {
                dst.codeSystem.add(terminologyCapabilitiesCodeSystemComponent.copy());
            }
        }
        dst.expansion = this.expansion == null ? null : this.expansion.copy();
        dst.codeSearch = this.codeSearch == null ? null : this.codeSearch.copy();
        dst.validateCode = this.validateCode == null ? null : this.validateCode.copy();
        dst.translation = this.translation == null ? null : this.translation.copy();
        dst.closure = this.closure == null ? null : this.closure.copy();
    }

    protected TerminologyCapabilities typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TerminologyCapabilities)) {
            return false;
        }
        TerminologyCapabilities o = (TerminologyCapabilities)other_;
        return TerminologyCapabilities.compareDeep(this.url, o.url, true) && TerminologyCapabilities.compareDeep(this.version, o.version, true) && TerminologyCapabilities.compareDeep(this.name, o.name, true) && TerminologyCapabilities.compareDeep(this.title, o.title, true) && TerminologyCapabilities.compareDeep(this.status, o.status, true) && TerminologyCapabilities.compareDeep(this.experimental, o.experimental, true) && TerminologyCapabilities.compareDeep(this.date, o.date, true) && TerminologyCapabilities.compareDeep(this.publisher, o.publisher, true) && TerminologyCapabilities.compareDeep(this.contact, o.contact, true) && TerminologyCapabilities.compareDeep(this.description, o.description, true) && TerminologyCapabilities.compareDeep(this.useContext, o.useContext, true) && TerminologyCapabilities.compareDeep(this.jurisdiction, o.jurisdiction, true) && TerminologyCapabilities.compareDeep(this.purpose, o.purpose, true) && TerminologyCapabilities.compareDeep(this.copyright, o.copyright, true) && TerminologyCapabilities.compareDeep(this.kind, o.kind, true) && TerminologyCapabilities.compareDeep(this.software, o.software, true) && TerminologyCapabilities.compareDeep(this.implementation, o.implementation, true) && TerminologyCapabilities.compareDeep(this.lockedDate, o.lockedDate, true) && TerminologyCapabilities.compareDeep(this.codeSystem, o.codeSystem, true) && TerminologyCapabilities.compareDeep(this.expansion, o.expansion, true) && TerminologyCapabilities.compareDeep(this.codeSearch, o.codeSearch, true) && TerminologyCapabilities.compareDeep(this.validateCode, o.validateCode, true) && TerminologyCapabilities.compareDeep(this.translation, o.translation, true) && TerminologyCapabilities.compareDeep(this.closure, o.closure, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TerminologyCapabilities)) {
            return false;
        }
        TerminologyCapabilities o = (TerminologyCapabilities)other_;
        return TerminologyCapabilities.compareValues(this.url, o.url, true) && TerminologyCapabilities.compareValues(this.version, o.version, true) && TerminologyCapabilities.compareValues(this.name, o.name, true) && TerminologyCapabilities.compareValues(this.title, o.title, true) && TerminologyCapabilities.compareValues(this.status, o.status, true) && TerminologyCapabilities.compareValues(this.experimental, o.experimental, true) && TerminologyCapabilities.compareValues(this.date, o.date, true) && TerminologyCapabilities.compareValues(this.publisher, o.publisher, true) && TerminologyCapabilities.compareValues(this.description, o.description, true) && TerminologyCapabilities.compareValues(this.purpose, o.purpose, true) && TerminologyCapabilities.compareValues(this.copyright, o.copyright, true) && TerminologyCapabilities.compareValues(this.kind, o.kind, true) && TerminologyCapabilities.compareValues(this.lockedDate, o.lockedDate, true) && TerminologyCapabilities.compareValues(this.codeSearch, o.codeSearch, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.kind, this.software, this.implementation, this.lockedDate, this.codeSystem, this.expansion, this.codeSearch, this.validateCode, this.translation, this.closure});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TerminologyCapabilities;
    }

    @Override
    public List<Identifier> getIdentifier() {
        return new ArrayList<Identifier>();
    }

    @Override
    public CanonicalResource setIdentifier(List<Identifier> theIdentifier) {
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        return null;
    }

    @Override
    public CanonicalResource addIdentifier(Identifier t) {
        return null;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        return new Identifier();
    }

    @Block
    public static class TerminologyCapabilitiesClosureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="translation", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If cross-system closure is supported", formalDefinition="If cross-system closure is supported.")
        protected BooleanType translation;
        private static final long serialVersionUID = 1900484343L;

        public BooleanType getTranslationElement() {
            if (this.translation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesClosureComponent.translation");
                }
                if (Configuration.doAutoCreate()) {
                    this.translation = new BooleanType();
                }
            }
            return this.translation;
        }

        public boolean hasTranslationElement() {
            return this.translation != null && !this.translation.isEmpty();
        }

        public boolean hasTranslation() {
            return this.translation != null && !this.translation.isEmpty();
        }

        public TerminologyCapabilitiesClosureComponent setTranslationElement(BooleanType value) {
            this.translation = value;
            return this;
        }

        public boolean getTranslation() {
            return this.translation == null || this.translation.isEmpty() ? false : (Boolean)this.translation.getValue();
        }

        public TerminologyCapabilitiesClosureComponent setTranslation(boolean value) {
            if (this.translation == null) {
                this.translation = new BooleanType();
            }
            this.translation.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("translation", "boolean", "If cross-system closure is supported.", 0, 1, this.translation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1840647503: {
                    return new Property("translation", "boolean", "If cross-system closure is supported.", 0, 1, this.translation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    Base[] baseArray;
                    if (this.translation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.translation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    this.translation = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("translation")) {
                return super.setProperty(name, value);
            }
            this.translation = TypeConvertor.castToBoolean(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    return this.getTranslationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("translation")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.closure.translation");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesClosureComponent copy() {
            TerminologyCapabilitiesClosureComponent dst = new TerminologyCapabilitiesClosureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesClosureComponent dst) {
            super.copyValues(dst);
            dst.translation = this.translation == null ? null : this.translation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesClosureComponent)) {
                return false;
            }
            TerminologyCapabilitiesClosureComponent o = (TerminologyCapabilitiesClosureComponent)other_;
            return TerminologyCapabilitiesClosureComponent.compareDeep(this.translation, o.translation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesClosureComponent)) {
                return false;
            }
            TerminologyCapabilitiesClosureComponent o = (TerminologyCapabilitiesClosureComponent)other_;
            return TerminologyCapabilitiesClosureComponent.compareValues(this.translation, o.translation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.translation});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.closure";
        }
    }

    @Block
    public static class TerminologyCapabilitiesTranslationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="needsMap", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the client must identify the map", formalDefinition="Whether the client must identify the map.")
        protected BooleanType needsMap;
        private static final long serialVersionUID = -1727843575L;

        public TerminologyCapabilitiesTranslationComponent() {
        }

        public TerminologyCapabilitiesTranslationComponent(boolean needsMap) {
            this.setNeedsMap(needsMap);
        }

        public BooleanType getNeedsMapElement() {
            if (this.needsMap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesTranslationComponent.needsMap");
                }
                if (Configuration.doAutoCreate()) {
                    this.needsMap = new BooleanType();
                }
            }
            return this.needsMap;
        }

        public boolean hasNeedsMapElement() {
            return this.needsMap != null && !this.needsMap.isEmpty();
        }

        public boolean hasNeedsMap() {
            return this.needsMap != null && !this.needsMap.isEmpty();
        }

        public TerminologyCapabilitiesTranslationComponent setNeedsMapElement(BooleanType value) {
            this.needsMap = value;
            return this;
        }

        public boolean getNeedsMap() {
            return this.needsMap == null || this.needsMap.isEmpty() ? false : (Boolean)this.needsMap.getValue();
        }

        public TerminologyCapabilitiesTranslationComponent setNeedsMap(boolean value) {
            if (this.needsMap == null) {
                this.needsMap = new BooleanType();
            }
            this.needsMap.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("needsMap", "boolean", "Whether the client must identify the map.", 0, 1, this.needsMap));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 866566527: {
                    return new Property("needsMap", "boolean", "Whether the client must identify the map.", 0, 1, this.needsMap);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    Base[] baseArray;
                    if (this.needsMap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.needsMap;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    this.needsMap = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("needsMap")) {
                return super.setProperty(name, value);
            }
            this.needsMap = TypeConvertor.castToBoolean(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    return this.getNeedsMapElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("needsMap")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.translation.needsMap");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesTranslationComponent copy() {
            TerminologyCapabilitiesTranslationComponent dst = new TerminologyCapabilitiesTranslationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesTranslationComponent dst) {
            super.copyValues(dst);
            dst.needsMap = this.needsMap == null ? null : this.needsMap.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesTranslationComponent)) {
                return false;
            }
            TerminologyCapabilitiesTranslationComponent o = (TerminologyCapabilitiesTranslationComponent)other_;
            return TerminologyCapabilitiesTranslationComponent.compareDeep(this.needsMap, o.needsMap, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesTranslationComponent)) {
                return false;
            }
            TerminologyCapabilitiesTranslationComponent o = (TerminologyCapabilitiesTranslationComponent)other_;
            return TerminologyCapabilitiesTranslationComponent.compareValues(this.needsMap, o.needsMap, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.needsMap});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.translation";
        }
    }

    @Block
    public static class TerminologyCapabilitiesValidateCodeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="translations", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether translations are validated", formalDefinition="Whether translations are validated.")
        protected BooleanType translations;
        private static final long serialVersionUID = -1212814906L;

        public TerminologyCapabilitiesValidateCodeComponent() {
        }

        public TerminologyCapabilitiesValidateCodeComponent(boolean translations) {
            this.setTranslations(translations);
        }

        public BooleanType getTranslationsElement() {
            if (this.translations == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesValidateCodeComponent.translations");
                }
                if (Configuration.doAutoCreate()) {
                    this.translations = new BooleanType();
                }
            }
            return this.translations;
        }

        public boolean hasTranslationsElement() {
            return this.translations != null && !this.translations.isEmpty();
        }

        public boolean hasTranslations() {
            return this.translations != null && !this.translations.isEmpty();
        }

        public TerminologyCapabilitiesValidateCodeComponent setTranslationsElement(BooleanType value) {
            this.translations = value;
            return this;
        }

        public boolean getTranslations() {
            return this.translations == null || this.translations.isEmpty() ? false : (Boolean)this.translations.getValue();
        }

        public TerminologyCapabilitiesValidateCodeComponent setTranslations(boolean value) {
            if (this.translations == null) {
                this.translations = new BooleanType();
            }
            this.translations.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("translations", "boolean", "Whether translations are validated.", 0, 1, this.translations));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1225497630: {
                    return new Property("translations", "boolean", "Whether translations are validated.", 0, 1, this.translations);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    Base[] baseArray;
                    if (this.translations == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.translations;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    this.translations = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("translations")) {
                return super.setProperty(name, value);
            }
            this.translations = TypeConvertor.castToBoolean(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    return this.getTranslationsElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("translations")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.validateCode.translations");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesValidateCodeComponent copy() {
            TerminologyCapabilitiesValidateCodeComponent dst = new TerminologyCapabilitiesValidateCodeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesValidateCodeComponent dst) {
            super.copyValues(dst);
            dst.translations = this.translations == null ? null : this.translations.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesValidateCodeComponent)) {
                return false;
            }
            TerminologyCapabilitiesValidateCodeComponent o = (TerminologyCapabilitiesValidateCodeComponent)other_;
            return TerminologyCapabilitiesValidateCodeComponent.compareDeep(this.translations, o.translations, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesValidateCodeComponent)) {
                return false;
            }
            TerminologyCapabilitiesValidateCodeComponent o = (TerminologyCapabilitiesValidateCodeComponent)other_;
            return TerminologyCapabilitiesValidateCodeComponent.compareValues(this.translations, o.translations, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.translations});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.validateCode";
        }
    }

    @Block
    public static class TerminologyCapabilitiesExpansionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expansion Parameter name", formalDefinition="Expansion Parameter name.")
        protected CodeType name;
        @Child(name="documentation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of support for parameter", formalDefinition="Description of support for parameter.")
        protected StringType documentation;
        private static final long serialVersionUID = -1703372741L;

        public TerminologyCapabilitiesExpansionParameterComponent() {
        }

        public TerminologyCapabilitiesExpansionParameterComponent(String name) {
            this.setName(name);
        }

        public CodeType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TerminologyCapabilitiesExpansionParameterComponent setNameElement(CodeType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TerminologyCapabilitiesExpansionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionParameterComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public TerminologyCapabilitiesExpansionParameterComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public TerminologyCapabilitiesExpansionParameterComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TerminologyCapabilities.SP_NAME, "code", "Expansion Parameter name.", 0, 1, this.name));
            children.add(new Property("documentation", "string", "Description of support for parameter.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(TerminologyCapabilities.SP_NAME, "code", "Expansion Parameter name.", 0, 1, this.name);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Description of support for parameter.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TerminologyCapabilities.SP_NAME)) {
                this.name = TypeConvertor.castToCode(value);
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TerminologyCapabilities.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.expansion.parameter.name");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.expansion.parameter.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesExpansionParameterComponent copy() {
            TerminologyCapabilitiesExpansionParameterComponent dst = new TerminologyCapabilitiesExpansionParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesExpansionParameterComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesExpansionParameterComponent)) {
                return false;
            }
            TerminologyCapabilitiesExpansionParameterComponent o = (TerminologyCapabilitiesExpansionParameterComponent)other_;
            return TerminologyCapabilitiesExpansionParameterComponent.compareDeep(this.name, o.name, true) && TerminologyCapabilitiesExpansionParameterComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesExpansionParameterComponent)) {
                return false;
            }
            TerminologyCapabilitiesExpansionParameterComponent o = (TerminologyCapabilitiesExpansionParameterComponent)other_;
            return TerminologyCapabilitiesExpansionParameterComponent.compareValues(this.name, o.name, true) && TerminologyCapabilitiesExpansionParameterComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.documentation});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.expansion.parameter";
        }
    }

    @Block
    public static class TerminologyCapabilitiesExpansionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="hierarchical", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the server can return nested value sets", formalDefinition="Whether the server can return nested value sets.")
        protected BooleanType hierarchical;
        @Child(name="paging", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the server supports paging on expansion", formalDefinition="Whether the server supports paging on expansion.")
        protected BooleanType paging;
        @Child(name="incomplete", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Allow request for incomplete expansions?", formalDefinition="Allow request for incomplete expansions?")
        protected BooleanType incomplete;
        @Child(name="parameter", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supported expansion parameter", formalDefinition="Supported expansion parameter.")
        protected List<TerminologyCapabilitiesExpansionParameterComponent> parameter;
        @Child(name="textFilter", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation about text searching works", formalDefinition="Documentation about text searching works.")
        protected MarkdownType textFilter;
        private static final long serialVersionUID = -1011350616L;

        public BooleanType getHierarchicalElement() {
            if (this.hierarchical == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.hierarchical");
                }
                if (Configuration.doAutoCreate()) {
                    this.hierarchical = new BooleanType();
                }
            }
            return this.hierarchical;
        }

        public boolean hasHierarchicalElement() {
            return this.hierarchical != null && !this.hierarchical.isEmpty();
        }

        public boolean hasHierarchical() {
            return this.hierarchical != null && !this.hierarchical.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setHierarchicalElement(BooleanType value) {
            this.hierarchical = value;
            return this;
        }

        public boolean getHierarchical() {
            return this.hierarchical == null || this.hierarchical.isEmpty() ? false : (Boolean)this.hierarchical.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setHierarchical(boolean value) {
            if (this.hierarchical == null) {
                this.hierarchical = new BooleanType();
            }
            this.hierarchical.setValue((Object)value);
            return this;
        }

        public BooleanType getPagingElement() {
            if (this.paging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.paging");
                }
                if (Configuration.doAutoCreate()) {
                    this.paging = new BooleanType();
                }
            }
            return this.paging;
        }

        public boolean hasPagingElement() {
            return this.paging != null && !this.paging.isEmpty();
        }

        public boolean hasPaging() {
            return this.paging != null && !this.paging.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setPagingElement(BooleanType value) {
            this.paging = value;
            return this;
        }

        public boolean getPaging() {
            return this.paging == null || this.paging.isEmpty() ? false : (Boolean)this.paging.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setPaging(boolean value) {
            if (this.paging == null) {
                this.paging = new BooleanType();
            }
            this.paging.setValue((Object)value);
            return this;
        }

        public BooleanType getIncompleteElement() {
            if (this.incomplete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.incomplete");
                }
                if (Configuration.doAutoCreate()) {
                    this.incomplete = new BooleanType();
                }
            }
            return this.incomplete;
        }

        public boolean hasIncompleteElement() {
            return this.incomplete != null && !this.incomplete.isEmpty();
        }

        public boolean hasIncomplete() {
            return this.incomplete != null && !this.incomplete.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setIncompleteElement(BooleanType value) {
            this.incomplete = value;
            return this;
        }

        public boolean getIncomplete() {
            return this.incomplete == null || this.incomplete.isEmpty() ? false : (Boolean)this.incomplete.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setIncomplete(boolean value) {
            if (this.incomplete == null) {
                this.incomplete = new BooleanType();
            }
            this.incomplete.setValue((Object)value);
            return this;
        }

        public List<TerminologyCapabilitiesExpansionParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<TerminologyCapabilitiesExpansionParameterComponent>();
            }
            return this.parameter;
        }

        public TerminologyCapabilitiesExpansionComponent setParameter(List<TerminologyCapabilitiesExpansionParameterComponent> theParameter) {
            this.parameter = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (TerminologyCapabilitiesExpansionParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TerminologyCapabilitiesExpansionParameterComponent addParameter() {
            TerminologyCapabilitiesExpansionParameterComponent t = new TerminologyCapabilitiesExpansionParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<TerminologyCapabilitiesExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public TerminologyCapabilitiesExpansionComponent addParameter(TerminologyCapabilitiesExpansionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<TerminologyCapabilitiesExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public TerminologyCapabilitiesExpansionParameterComponent getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public MarkdownType getTextFilterElement() {
            if (this.textFilter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.textFilter");
                }
                if (Configuration.doAutoCreate()) {
                    this.textFilter = new MarkdownType();
                }
            }
            return this.textFilter;
        }

        public boolean hasTextFilterElement() {
            return this.textFilter != null && !this.textFilter.isEmpty();
        }

        public boolean hasTextFilter() {
            return this.textFilter != null && !this.textFilter.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setTextFilterElement(MarkdownType value) {
            this.textFilter = value;
            return this;
        }

        public String getTextFilter() {
            return this.textFilter == null ? null : (String)this.textFilter.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setTextFilter(String value) {
            if (value == null) {
                this.textFilter = null;
            } else {
                if (this.textFilter == null) {
                    this.textFilter = new MarkdownType();
                }
                this.textFilter.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("hierarchical", "boolean", "Whether the server can return nested value sets.", 0, 1, this.hierarchical));
            children.add(new Property("paging", "boolean", "Whether the server supports paging on expansion.", 0, 1, this.paging));
            children.add(new Property("incomplete", "boolean", "Allow request for incomplete expansions?", 0, 1, this.incomplete));
            children.add(new Property("parameter", "", "Supported expansion parameter.", 0, Integer.MAX_VALUE, this.parameter));
            children.add(new Property("textFilter", "markdown", "Documentation about text searching works.", 0, 1, this.textFilter));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 857636745: {
                    return new Property("hierarchical", "boolean", "Whether the server can return nested value sets.", 0, 1, this.hierarchical);
                }
                case -995747956: {
                    return new Property("paging", "boolean", "Whether the server supports paging on expansion.", 0, 1, this.paging);
                }
                case -1010022050: {
                    return new Property("incomplete", "boolean", "Allow request for incomplete expansions?", 0, 1, this.incomplete);
                }
                case 1954460585: {
                    return new Property("parameter", "", "Supported expansion parameter.", 0, Integer.MAX_VALUE, this.parameter);
                }
                case 1469359877: {
                    return new Property("textFilter", "markdown", "Documentation about text searching works.", 0, 1, this.textFilter);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    Base[] baseArray;
                    if (this.hierarchical == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.hierarchical;
                    }
                    return baseArray;
                }
                case -995747956: {
                    Base[] baseArray;
                    if (this.paging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.paging;
                    }
                    return baseArray;
                }
                case -1010022050: {
                    Base[] baseArray;
                    if (this.incomplete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.incomplete;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
                case 1469359877: {
                    Base[] baseArray;
                    if (this.textFilter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.textFilter;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    this.hierarchical = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -995747956: {
                    this.paging = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1010022050: {
                    this.incomplete = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1954460585: {
                    this.getParameter().add((TerminologyCapabilitiesExpansionParameterComponent)value);
                    return value;
                }
                case 1469359877: {
                    this.textFilter = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("hierarchical")) {
                this.hierarchical = TypeConvertor.castToBoolean(value);
            } else if (name.equals("paging")) {
                this.paging = TypeConvertor.castToBoolean(value);
            } else if (name.equals("incomplete")) {
                this.incomplete = TypeConvertor.castToBoolean(value);
            } else if (name.equals("parameter")) {
                this.getParameter().add((TerminologyCapabilitiesExpansionParameterComponent)value);
            } else if (name.equals("textFilter")) {
                this.textFilter = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    return this.getHierarchicalElement();
                }
                case -995747956: {
                    return this.getPagingElement();
                }
                case -1010022050: {
                    return this.getIncompleteElement();
                }
                case 1954460585: {
                    return this.addParameter();
                }
                case 1469359877: {
                    return this.getTextFilterElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    return new String[]{"boolean"};
                }
                case -995747956: {
                    return new String[]{"boolean"};
                }
                case -1010022050: {
                    return new String[]{"boolean"};
                }
                case 1954460585: {
                    return new String[0];
                }
                case 1469359877: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("hierarchical")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.expansion.hierarchical");
            }
            if (name.equals("paging")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.expansion.paging");
            }
            if (name.equals("incomplete")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.expansion.incomplete");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("textFilter")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.expansion.textFilter");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesExpansionComponent copy() {
            TerminologyCapabilitiesExpansionComponent dst = new TerminologyCapabilitiesExpansionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesExpansionComponent dst) {
            super.copyValues(dst);
            dst.hierarchical = this.hierarchical == null ? null : this.hierarchical.copy();
            dst.paging = this.paging == null ? null : this.paging.copy();
            BooleanType booleanType = dst.incomplete = this.incomplete == null ? null : this.incomplete.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<TerminologyCapabilitiesExpansionParameterComponent>();
                for (TerminologyCapabilitiesExpansionParameterComponent i : this.parameter) {
                    dst.parameter.add(i.copy());
                }
            }
            dst.textFilter = this.textFilter == null ? null : this.textFilter.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesExpansionComponent)) {
                return false;
            }
            TerminologyCapabilitiesExpansionComponent o = (TerminologyCapabilitiesExpansionComponent)other_;
            return TerminologyCapabilitiesExpansionComponent.compareDeep(this.hierarchical, o.hierarchical, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.paging, o.paging, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.incomplete, o.incomplete, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.parameter, o.parameter, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.textFilter, o.textFilter, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesExpansionComponent)) {
                return false;
            }
            TerminologyCapabilitiesExpansionComponent o = (TerminologyCapabilitiesExpansionComponent)other_;
            return TerminologyCapabilitiesExpansionComponent.compareValues(this.hierarchical, o.hierarchical, true) && TerminologyCapabilitiesExpansionComponent.compareValues(this.paging, o.paging, true) && TerminologyCapabilitiesExpansionComponent.compareValues(this.incomplete, o.incomplete, true) && TerminologyCapabilitiesExpansionComponent.compareValues(this.textFilter, o.textFilter, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.hierarchical, this.paging, this.incomplete, this.parameter, this.textFilter});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.expansion";
        }
    }

    @Block
    public static class TerminologyCapabilitiesCodeSystemVersionFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code of the property supported", formalDefinition="Code of the property supported.")
        protected CodeType code;
        @Child(name="op", type={CodeType.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Operations supported for the property", formalDefinition="Operations supported for the property.")
        protected List<CodeType> op;
        private static final long serialVersionUID = -489160282L;

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent() {
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent(String code, String op) {
            this.setCode(code);
            this.addOp(op);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionFilterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public List<CodeType> getOp() {
            if (this.op == null) {
                this.op = new ArrayList<CodeType>();
            }
            return this.op;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent setOp(List<CodeType> theOp) {
            this.op = theOp;
            return this;
        }

        public boolean hasOp() {
            if (this.op == null) {
                return false;
            }
            for (CodeType item : this.op) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addOpElement() {
            CodeType t = new CodeType();
            if (this.op == null) {
                this.op = new ArrayList<CodeType>();
            }
            this.op.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent addOp(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.op == null) {
                this.op = new ArrayList<CodeType>();
            }
            this.op.add(t);
            return this;
        }

        public boolean hasOp(String value) {
            if (this.op == null) {
                return false;
            }
            for (CodeType v : this.op) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Code of the property supported.", 0, 1, this.code));
            children.add(new Property("op", "code", "Operations supported for the property.", 0, Integer.MAX_VALUE, this.op));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Code of the property supported.", 0, 1, this.code);
                }
                case 3553: {
                    return new Property("op", "code", "Operations supported for the property.", 0, Integer.MAX_VALUE, this.op);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 3553: {
                    return this.op == null ? new Base[]{} : this.op.toArray(new Base[this.op.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 3553: {
                    this.getOp().add(TypeConvertor.castToCode(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("op")) {
                this.getOp().add(TypeConvertor.castToCode(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 3553: {
                    return this.addOpElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 3553: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.filter.code");
            }
            if (name.equals("op")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.filter.op");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesCodeSystemVersionFilterComponent copy() {
            TerminologyCapabilitiesCodeSystemVersionFilterComponent dst = new TerminologyCapabilitiesCodeSystemVersionFilterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesCodeSystemVersionFilterComponent dst) {
            super.copyValues(dst);
            CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
            if (this.op != null) {
                dst.op = new ArrayList<CodeType>();
                for (CodeType i : this.op) {
                    dst.op.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionFilterComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionFilterComponent o = (TerminologyCapabilitiesCodeSystemVersionFilterComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareDeep(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareDeep(this.op, o.op, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionFilterComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionFilterComponent o = (TerminologyCapabilitiesCodeSystemVersionFilterComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareValues(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareValues(this.op, o.op, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.op});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.codeSystem.version.filter";
        }
    }

    @Block
    public static class TerminologyCapabilitiesCodeSystemVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version identifier for this version", formalDefinition="For version-less code systems, there should be a single version with no identifier.")
        protected StringType code;
        @Child(name="isDefault", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If this is the default version for this code system", formalDefinition="If this is the default version for this code system.")
        protected BooleanType isDefault;
        @Child(name="compositional", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If compositional grammar is supported", formalDefinition="If the compositional grammar defined by the code system is supported.")
        protected BooleanType compositional;
        @Child(name="language", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Language Displays supported", formalDefinition="Language Displays supported.")
        protected List<CodeType> language;
        @Child(name="filter", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Filter Properties supported", formalDefinition="Filter Properties supported.")
        protected List<TerminologyCapabilitiesCodeSystemVersionFilterComponent> filter;
        @Child(name="property", type={CodeType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Properties supported for $lookup", formalDefinition="Properties supported for $lookup.")
        protected List<CodeType> property;
        private static final long serialVersionUID = 1857571343L;

        public StringType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new StringType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCodeElement(StringType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new StringType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public BooleanType getIsDefaultElement() {
            if (this.isDefault == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionComponent.isDefault");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDefault = new BooleanType();
                }
            }
            return this.isDefault;
        }

        public boolean hasIsDefaultElement() {
            return this.isDefault != null && !this.isDefault.isEmpty();
        }

        public boolean hasIsDefault() {
            return this.isDefault != null && !this.isDefault.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setIsDefaultElement(BooleanType value) {
            this.isDefault = value;
            return this;
        }

        public boolean getIsDefault() {
            return this.isDefault == null || this.isDefault.isEmpty() ? false : (Boolean)this.isDefault.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setIsDefault(boolean value) {
            if (this.isDefault == null) {
                this.isDefault = new BooleanType();
            }
            this.isDefault.setValue((Object)value);
            return this;
        }

        public BooleanType getCompositionalElement() {
            if (this.compositional == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionComponent.compositional");
                }
                if (Configuration.doAutoCreate()) {
                    this.compositional = new BooleanType();
                }
            }
            return this.compositional;
        }

        public boolean hasCompositionalElement() {
            return this.compositional != null && !this.compositional.isEmpty();
        }

        public boolean hasCompositional() {
            return this.compositional != null && !this.compositional.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCompositionalElement(BooleanType value) {
            this.compositional = value;
            return this;
        }

        public boolean getCompositional() {
            return this.compositional == null || this.compositional.isEmpty() ? false : (Boolean)this.compositional.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCompositional(boolean value) {
            if (this.compositional == null) {
                this.compositional = new BooleanType();
            }
            this.compositional.setValue((Object)value);
            return this;
        }

        public List<CodeType> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeType>();
            }
            return this.language;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setLanguage(List<CodeType> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeType item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addLanguageElement() {
            CodeType t = new CodeType();
            if (this.language == null) {
                this.language = new ArrayList<CodeType>();
            }
            this.language.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addLanguage(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.language == null) {
                this.language = new ArrayList<CodeType>();
            }
            this.language.add(t);
            return this;
        }

        public boolean hasLanguage(String value) {
            if (this.language == null) {
                return false;
            }
            for (CodeType v : this.language) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<TerminologyCapabilitiesCodeSystemVersionFilterComponent> getFilter() {
            if (this.filter == null) {
                this.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
            }
            return this.filter;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setFilter(List<TerminologyCapabilitiesCodeSystemVersionFilterComponent> theFilter) {
            this.filter = theFilter;
            return this;
        }

        public boolean hasFilter() {
            if (this.filter == null) {
                return false;
            }
            for (TerminologyCapabilitiesCodeSystemVersionFilterComponent item : this.filter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent addFilter() {
            TerminologyCapabilitiesCodeSystemVersionFilterComponent t = new TerminologyCapabilitiesCodeSystemVersionFilterComponent();
            if (this.filter == null) {
                this.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
            }
            this.filter.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addFilter(TerminologyCapabilitiesCodeSystemVersionFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.filter == null) {
                this.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
            }
            this.filter.add(t);
            return this;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent getFilterFirstRep() {
            if (this.getFilter().isEmpty()) {
                this.addFilter();
            }
            return this.getFilter().get(0);
        }

        public List<CodeType> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<CodeType>();
            }
            return this.property;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setProperty(List<CodeType> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (CodeType item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addPropertyElement() {
            CodeType t = new CodeType();
            if (this.property == null) {
                this.property = new ArrayList<CodeType>();
            }
            this.property.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addProperty(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.property == null) {
                this.property = new ArrayList<CodeType>();
            }
            this.property.add(t);
            return this;
        }

        public boolean hasProperty(String value) {
            if (this.property == null) {
                return false;
            }
            for (CodeType v : this.property) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "string", "For version-less code systems, there should be a single version with no identifier.", 0, 1, this.code));
            children.add(new Property("isDefault", "boolean", "If this is the default version for this code system.", 0, 1, this.isDefault));
            children.add(new Property("compositional", "boolean", "If the compositional grammar defined by the code system is supported.", 0, 1, this.compositional));
            children.add(new Property("language", "code", "Language Displays supported.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property("filter", "", "Filter Properties supported.", 0, Integer.MAX_VALUE, this.filter));
            children.add(new Property("property", "code", "Properties supported for $lookup.", 0, Integer.MAX_VALUE, this.property));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "string", "For version-less code systems, there should be a single version with no identifier.", 0, 1, this.code);
                }
                case 965025207: {
                    return new Property("isDefault", "boolean", "If this is the default version for this code system.", 0, 1, this.isDefault);
                }
                case 1248023381: {
                    return new Property("compositional", "boolean", "If the compositional grammar defined by the code system is supported.", 0, 1, this.compositional);
                }
                case -1613589672: {
                    return new Property("language", "code", "Language Displays supported.", 0, Integer.MAX_VALUE, this.language);
                }
                case -1274492040: {
                    return new Property("filter", "", "Filter Properties supported.", 0, Integer.MAX_VALUE, this.filter);
                }
                case -993141291: {
                    return new Property("property", "code", "Properties supported for $lookup.", 0, Integer.MAX_VALUE, this.property);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 965025207: {
                    Base[] baseArray;
                    if (this.isDefault == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isDefault;
                    }
                    return baseArray;
                }
                case 1248023381: {
                    Base[] baseArray;
                    if (this.compositional == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.compositional;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case -1274492040: {
                    return this.filter == null ? new Base[]{} : this.filter.toArray(new Base[this.filter.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToString(value);
                    return value;
                }
                case 965025207: {
                    this.isDefault = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1248023381: {
                    this.compositional = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(TypeConvertor.castToCode(value));
                    return value;
                }
                case -1274492040: {
                    this.getFilter().add((TerminologyCapabilitiesCodeSystemVersionFilterComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add(TypeConvertor.castToCode(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToString(value);
            } else if (name.equals("isDefault")) {
                this.isDefault = TypeConvertor.castToBoolean(value);
            } else if (name.equals("compositional")) {
                this.compositional = TypeConvertor.castToBoolean(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(TypeConvertor.castToCode(value));
            } else if (name.equals("filter")) {
                this.getFilter().add((TerminologyCapabilitiesCodeSystemVersionFilterComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add(TypeConvertor.castToCode(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 965025207: {
                    return this.getIsDefaultElement();
                }
                case 1248023381: {
                    return this.getCompositionalElement();
                }
                case -1613589672: {
                    return this.addLanguageElement();
                }
                case -1274492040: {
                    return this.addFilter();
                }
                case -993141291: {
                    return this.addPropertyElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"string"};
                }
                case 965025207: {
                    return new String[]{"boolean"};
                }
                case 1248023381: {
                    return new String[]{"boolean"};
                }
                case -1613589672: {
                    return new String[]{"code"};
                }
                case -1274492040: {
                    return new String[0];
                }
                case -993141291: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.code");
            }
            if (name.equals("isDefault")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.isDefault");
            }
            if (name.equals("compositional")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.compositional");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.language");
            }
            if (name.equals("filter")) {
                return this.addFilter();
            }
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.version.property");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesCodeSystemVersionComponent copy() {
            TerminologyCapabilitiesCodeSystemVersionComponent dst = new TerminologyCapabilitiesCodeSystemVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesCodeSystemVersionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.isDefault = this.isDefault == null ? null : this.isDefault.copy();
            BooleanType booleanType = dst.compositional = this.compositional == null ? null : this.compositional.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeType>();
                for (CodeType codeType : this.language) {
                    dst.language.add(codeType.copy());
                }
            }
            if (this.filter != null) {
                dst.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
                for (TerminologyCapabilitiesCodeSystemVersionFilterComponent terminologyCapabilitiesCodeSystemVersionFilterComponent : this.filter) {
                    dst.filter.add(terminologyCapabilitiesCodeSystemVersionFilterComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<CodeType>();
                for (CodeType codeType : this.property) {
                    dst.property.add(codeType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionComponent o = (TerminologyCapabilitiesCodeSystemVersionComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.isDefault, o.isDefault, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.compositional, o.compositional, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.language, o.language, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.filter, o.filter, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.property, o.property, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionComponent o = (TerminologyCapabilitiesCodeSystemVersionComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.isDefault, o.isDefault, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.compositional, o.compositional, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.language, o.language, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.property, o.property, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.isDefault, this.compositional, this.language, this.filter, this.property});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.codeSystem.version";
        }
    }

    @Block
    public static class TerminologyCapabilitiesCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uri", type={CanonicalType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="URI for the Code System", formalDefinition="URI for the Code System.")
        protected CanonicalType uri;
        @Child(name="version", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Version of Code System supported", formalDefinition="For the code system, a list of versions that are supported by the server.")
        protected List<TerminologyCapabilitiesCodeSystemVersionComponent> version;
        @Child(name="subsumption", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether subsumption is supported", formalDefinition="True if subsumption is supported for this version of the code system.")
        protected BooleanType subsumption;
        private static final long serialVersionUID = -1593622817L;

        public CanonicalType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new CanonicalType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemComponent setUriElement(CanonicalType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public TerminologyCapabilitiesCodeSystemComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new CanonicalType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public List<TerminologyCapabilitiesCodeSystemVersionComponent> getVersion() {
            if (this.version == null) {
                this.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
            }
            return this.version;
        }

        public TerminologyCapabilitiesCodeSystemComponent setVersion(List<TerminologyCapabilitiesCodeSystemVersionComponent> theVersion) {
            this.version = theVersion;
            return this;
        }

        public boolean hasVersion() {
            if (this.version == null) {
                return false;
            }
            for (TerminologyCapabilitiesCodeSystemVersionComponent item : this.version) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addVersion() {
            TerminologyCapabilitiesCodeSystemVersionComponent t = new TerminologyCapabilitiesCodeSystemVersionComponent();
            if (this.version == null) {
                this.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
            }
            this.version.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemComponent addVersion(TerminologyCapabilitiesCodeSystemVersionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.version == null) {
                this.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
            }
            this.version.add(t);
            return this;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent getVersionFirstRep() {
            if (this.getVersion().isEmpty()) {
                this.addVersion();
            }
            return this.getVersion().get(0);
        }

        public BooleanType getSubsumptionElement() {
            if (this.subsumption == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemComponent.subsumption");
                }
                if (Configuration.doAutoCreate()) {
                    this.subsumption = new BooleanType();
                }
            }
            return this.subsumption;
        }

        public boolean hasSubsumptionElement() {
            return this.subsumption != null && !this.subsumption.isEmpty();
        }

        public boolean hasSubsumption() {
            return this.subsumption != null && !this.subsumption.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemComponent setSubsumptionElement(BooleanType value) {
            this.subsumption = value;
            return this;
        }

        public boolean getSubsumption() {
            return this.subsumption == null || this.subsumption.isEmpty() ? false : (Boolean)this.subsumption.getValue();
        }

        public TerminologyCapabilitiesCodeSystemComponent setSubsumption(boolean value) {
            if (this.subsumption == null) {
                this.subsumption = new BooleanType();
            }
            this.subsumption.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uri", "canonical(CodeSystem)", "URI for the Code System.", 0, 1, this.uri));
            children.add(new Property(TerminologyCapabilities.SP_VERSION, "", "For the code system, a list of versions that are supported by the server.", 0, Integer.MAX_VALUE, this.version));
            children.add(new Property("subsumption", "boolean", "True if subsumption is supported for this version of the code system.", 0, 1, this.subsumption));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116076: {
                    return new Property("uri", "canonical(CodeSystem)", "URI for the Code System.", 0, 1, this.uri);
                }
                case 351608024: {
                    return new Property(TerminologyCapabilities.SP_VERSION, "", "For the code system, a list of versions that are supported by the server.", 0, Integer.MAX_VALUE, this.version);
                }
                case -499084711: {
                    return new Property("subsumption", "boolean", "True if subsumption is supported for this version of the code system.", 0, 1, this.subsumption);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uri;
                    }
                    return baseArray;
                }
                case 351608024: {
                    return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
                }
                case -499084711: {
                    Base[] baseArray;
                    if (this.subsumption == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subsumption;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116076: {
                    this.uri = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 351608024: {
                    this.getVersion().add((TerminologyCapabilitiesCodeSystemVersionComponent)value);
                    return value;
                }
                case -499084711: {
                    this.subsumption = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uri")) {
                this.uri = TypeConvertor.castToCanonical(value);
            } else if (name.equals(TerminologyCapabilities.SP_VERSION)) {
                this.getVersion().add((TerminologyCapabilitiesCodeSystemVersionComponent)value);
            } else if (name.equals("subsumption")) {
                this.subsumption = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return this.getUriElement();
                }
                case 351608024: {
                    return this.addVersion();
                }
                case -499084711: {
                    return this.getSubsumptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return new String[]{"canonical"};
                }
                case 351608024: {
                    return new String[0];
                }
                case -499084711: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.uri");
            }
            if (name.equals(TerminologyCapabilities.SP_VERSION)) {
                return this.addVersion();
            }
            if (name.equals("subsumption")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSystem.subsumption");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesCodeSystemComponent copy() {
            TerminologyCapabilitiesCodeSystemComponent dst = new TerminologyCapabilitiesCodeSystemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesCodeSystemComponent dst) {
            super.copyValues(dst);
            CanonicalType canonicalType = dst.uri = this.uri == null ? null : this.uri.copy();
            if (this.version != null) {
                dst.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
                for (TerminologyCapabilitiesCodeSystemVersionComponent i : this.version) {
                    dst.version.add(i.copy());
                }
            }
            dst.subsumption = this.subsumption == null ? null : this.subsumption.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemComponent o = (TerminologyCapabilitiesCodeSystemComponent)other_;
            return TerminologyCapabilitiesCodeSystemComponent.compareDeep(this.uri, o.uri, true) && TerminologyCapabilitiesCodeSystemComponent.compareDeep(this.version, o.version, true) && TerminologyCapabilitiesCodeSystemComponent.compareDeep(this.subsumption, o.subsumption, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemComponent o = (TerminologyCapabilitiesCodeSystemComponent)other_;
            return TerminologyCapabilitiesCodeSystemComponent.compareValues(this.uri, o.uri, true) && TerminologyCapabilitiesCodeSystemComponent.compareValues(this.subsumption, o.subsumption, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uri, this.version, this.subsumption});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.codeSystem";
        }
    }

    @Block
    public static class TerminologyCapabilitiesImplementationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Describes this specific instance", formalDefinition="Information about the specific installation that this terminology capability statement relates to.")
        protected StringType description;
        @Child(name="url", type={UrlType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Base URL for the implementation", formalDefinition="An absolute base URL for the implementation.")
        protected UrlType url;
        private static final long serialVersionUID = 98009649L;

        public TerminologyCapabilitiesImplementationComponent() {
        }

        public TerminologyCapabilitiesImplementationComponent(String description) {
            this.setDescription(description);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesImplementationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TerminologyCapabilitiesImplementationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TerminologyCapabilitiesImplementationComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public UrlType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesImplementationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UrlType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public TerminologyCapabilitiesImplementationComponent setUrlElement(UrlType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public TerminologyCapabilitiesImplementationComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UrlType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TerminologyCapabilities.SP_DESCRIPTION, "string", "Information about the specific installation that this terminology capability statement relates to.", 0, 1, this.description));
            children.add(new Property(TerminologyCapabilities.SP_URL, TerminologyCapabilities.SP_URL, "An absolute base URL for the implementation.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(TerminologyCapabilities.SP_DESCRIPTION, "string", "Information about the specific installation that this terminology capability statement relates to.", 0, 1, this.description);
                }
                case 116079: {
                    return new Property(TerminologyCapabilities.SP_URL, TerminologyCapabilities.SP_URL, "An absolute base URL for the implementation.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TerminologyCapabilities.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals(TerminologyCapabilities.SP_URL)) {
                this.url = TypeConvertor.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{TerminologyCapabilities.SP_URL};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TerminologyCapabilities.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.implementation.description");
            }
            if (name.equals(TerminologyCapabilities.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.implementation.url");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesImplementationComponent copy() {
            TerminologyCapabilitiesImplementationComponent dst = new TerminologyCapabilitiesImplementationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesImplementationComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesImplementationComponent)) {
                return false;
            }
            TerminologyCapabilitiesImplementationComponent o = (TerminologyCapabilitiesImplementationComponent)other_;
            return TerminologyCapabilitiesImplementationComponent.compareDeep(this.description, o.description, true) && TerminologyCapabilitiesImplementationComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesImplementationComponent)) {
                return false;
            }
            TerminologyCapabilitiesImplementationComponent o = (TerminologyCapabilitiesImplementationComponent)other_;
            return TerminologyCapabilitiesImplementationComponent.compareValues(this.description, o.description, true) && TerminologyCapabilitiesImplementationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.url});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.implementation";
        }
    }

    @Block
    public static class TerminologyCapabilitiesSoftwareComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A name the software is known by", formalDefinition="Name the software is known by.")
        protected StringType name;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version covered by this statement", formalDefinition="The version identifier for the software covered by this statement.")
        protected StringType version;
        private static final long serialVersionUID = -790299911L;

        public TerminologyCapabilitiesSoftwareComponent() {
        }

        public TerminologyCapabilitiesSoftwareComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesSoftwareComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TerminologyCapabilitiesSoftwareComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TerminologyCapabilitiesSoftwareComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesSoftwareComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public TerminologyCapabilitiesSoftwareComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public TerminologyCapabilitiesSoftwareComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TerminologyCapabilities.SP_NAME, "string", "Name the software is known by.", 0, 1, this.name));
            children.add(new Property(TerminologyCapabilities.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, 1, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(TerminologyCapabilities.SP_NAME, "string", "Name the software is known by.", 0, 1, this.name);
                }
                case 351608024: {
                    return new Property(TerminologyCapabilities.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, 1, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TerminologyCapabilities.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(TerminologyCapabilities.SP_VERSION)) {
                this.version = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TerminologyCapabilities.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.software.name");
            }
            if (name.equals(TerminologyCapabilities.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.software.version");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesSoftwareComponent copy() {
            TerminologyCapabilitiesSoftwareComponent dst = new TerminologyCapabilitiesSoftwareComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TerminologyCapabilitiesSoftwareComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.version = this.version == null ? null : this.version.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesSoftwareComponent)) {
                return false;
            }
            TerminologyCapabilitiesSoftwareComponent o = (TerminologyCapabilitiesSoftwareComponent)other_;
            return TerminologyCapabilitiesSoftwareComponent.compareDeep(this.name, o.name, true) && TerminologyCapabilitiesSoftwareComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesSoftwareComponent)) {
                return false;
            }
            TerminologyCapabilitiesSoftwareComponent o = (TerminologyCapabilitiesSoftwareComponent)other_;
            return TerminologyCapabilitiesSoftwareComponent.compareValues(this.name, o.name, true) && TerminologyCapabilitiesSoftwareComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.version});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.software";
        }
    }

    public static class CodeSearchSupportEnumFactory
    implements EnumFactory<CodeSearchSupport> {
        @Override
        public CodeSearchSupport fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("explicit".equals(codeString)) {
                return CodeSearchSupport.EXPLICIT;
            }
            if ("all".equals(codeString)) {
                return CodeSearchSupport.ALL;
            }
            throw new IllegalArgumentException("Unknown CodeSearchSupport code '" + codeString + "'");
        }

        public Enumeration<CodeSearchSupport> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CodeSearchSupport>(this, CodeSearchSupport.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CodeSearchSupport>(this, CodeSearchSupport.NULL, code);
            }
            if ("explicit".equals(codeString)) {
                return new Enumeration<CodeSearchSupport>(this, CodeSearchSupport.EXPLICIT, code);
            }
            if ("all".equals(codeString)) {
                return new Enumeration<CodeSearchSupport>(this, CodeSearchSupport.ALL, code);
            }
            throw new FHIRException("Unknown CodeSearchSupport code '" + codeString + "'");
        }

        @Override
        public String toCode(CodeSearchSupport code) {
            if (code == CodeSearchSupport.EXPLICIT) {
                return "explicit";
            }
            if (code == CodeSearchSupport.ALL) {
                return "all";
            }
            return "?";
        }

        @Override
        public String toSystem(CodeSearchSupport code) {
            return code.getSystem();
        }
    }

    public static enum CodeSearchSupport {
        EXPLICIT,
        ALL,
        NULL;


        public static CodeSearchSupport fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("explicit".equals(codeString)) {
                return EXPLICIT;
            }
            if ("all".equals(codeString)) {
                return ALL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CodeSearchSupport code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EXPLICIT: {
                    return "explicit";
                }
                case ALL: {
                    return "all";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EXPLICIT: {
                    return "http://hl7.org/fhir/code-search-support";
                }
                case ALL: {
                    return "http://hl7.org/fhir/code-search-support";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EXPLICIT: {
                    return "The search for code on ValueSet only includes codes explicitly detailed on includes or expansions.";
                }
                case ALL: {
                    return "The search for code on ValueSet only includes all codes based on the expansion of the value set.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EXPLICIT: {
                    return "Explicit Codes";
                }
                case ALL: {
                    return "Implicit Codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

