/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.IntegerType;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="TestScript", profile="http://hl7.org/fhir/StructureDefinition/TestScript")
public class TestScript
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this test script, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this test script when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this test script is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the test script is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the test script", formalDefinition="A formal identifier that is used to identify this test script when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the test script", formalDefinition="The identifier that is used to identify this version of the test script when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the test script author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this test script (computer friendly)", formalDefinition="A natural language name identifying the test script. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this test script (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the test script.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this test script. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this test script is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the test script was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the test script changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the test script.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the test script", formalDefinition="A free text natural language description of the test script from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate test script instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for test script (if applicable)", formalDefinition="A legal or geographic region in which the test script is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this test script is defined", formalDefinition="Explanation of why this test script is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the test script and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the test script.")
    protected MarkdownType copyright;
    @Child(name="origin", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An abstract server representing a client or sender in a message exchange", formalDefinition="An abstract server used in operations within this test script in the origin element.")
    protected List<TestScriptOriginComponent> origin;
    @Child(name="destination", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An abstract server representing a destination or receiver in a message exchange", formalDefinition="An abstract server used in operations within this test script in the destination element.")
    protected List<TestScriptDestinationComponent> destination;
    @Child(name="metadata", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Required capability that is assumed to function correctly on the FHIR server being tested", formalDefinition="The required capability must exist and are assumed to function correctly on the FHIR server being tested.")
    protected TestScriptMetadataComponent metadata;
    @Child(name="fixture", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Fixture in the test script - by reference (uri)", formalDefinition="Fixture in the test script - by reference (uri). All fixtures are required for the test script to execute.")
    protected List<TestScriptFixtureComponent> fixture;
    @Child(name="profile", type={Reference.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference of the validation profile", formalDefinition="Reference to the profile to be used for validation.")
    protected List<Reference> profile;
    @Child(name="variable", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Placeholder for evaluated elements", formalDefinition="Variable is set based either on element value in response body or on header field value in the response headers.")
    protected List<TestScriptVariableComponent> variable;
    @Child(name="setup", type={}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A series of required setup operations before tests are executed", formalDefinition="A series of required setup operations before tests are executed.")
    protected TestScriptSetupComponent setup;
    @Child(name="test", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A test in this script", formalDefinition="A test in this script.")
    protected List<TestScriptTestComponent> test;
    @Child(name="teardown", type={}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A series of required clean up steps", formalDefinition="A series of operations required to clean up after all the tests are executed (successfully or otherwise).")
    protected TestScriptTeardownComponent teardown;
    private static final long serialVersionUID = -2020826225L;
    @SearchParamDefinition(name="context-quantity", path="(TestScript.useContext.value as Quantity) | (TestScript.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the test script", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="TestScript.useContext", description="A use context type and quantity- or range-based value assigned to the test script", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="TestScript.useContext", description="A use context type and value assigned to the test script", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="TestScript.useContext.code", description="A type of use context assigned to the test script", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(TestScript.useContext.value as CodeableConcept)", description="A use context assigned to the test script", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="TestScript.date", description="The test script publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="TestScript.description", description="The description of the test script", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="TestScript.identifier", description="External identifier for the test script", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="TestScript.jurisdiction", description="Intended jurisdiction for the test script", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="TestScript.name", description="Computationally friendly name of the test script", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="TestScript.publisher", description="Name of the publisher of the test script", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="TestScript.status", description="The current status of the test script", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="testscript-capability", path="TestScript.metadata.capability.description", description="TestScript required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_CAPABILITY = "testscript-capability";
    public static final StringClientParam TESTSCRIPT_CAPABILITY = new StringClientParam("testscript-capability");
    @SearchParamDefinition(name="title", path="TestScript.title", description="The human-friendly name of the test script", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="TestScript.url", description="The uri that identifies the test script", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="TestScript.version", description="The business version of the test script", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public TestScript() {
    }

    public TestScript(String url, String name, Enumerations.PublicationStatus status) {
        this.setUrl(url);
        this.setName(name);
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public TestScript setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public TestScript setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public int getIdentifierMax() {
        return 1;
    }

    @Override
    public List<Identifier> getIdentifier() {
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        if (this.identifier == null) {
            list.add(this.identifier);
        }
        return list;
    }

    @Override
    public TestScript setIdentifier(List<Identifier> theIdentifier) {
        if (theIdentifier.size() == 0) {
            this.identifier = null;
        } else if (theIdentifier.size() == 1) {
            this.identifier = theIdentifier.get(0);
        } else {
            throw new Error("Cannot have more than one TestScript.identifier");
        }
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    @Override
    public Identifier addIdentifier() {
        if (this.identifier != null) {
            throw new Error("Cannot have more than one TestScript.identifier");
        }
        this.identifier = new Identifier();
        return this.identifier;
    }

    @Override
    public TestScript addIdentifier(Identifier t) {
        if (this.identifier != null) {
            throw new Error("Cannot have more than one TestScript.identifier");
        }
        this.identifier = t;
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.identifier == null) {
            this.addIdentifier();
        }
        return this.identifier;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public TestScript setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public TestScript setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public TestScript setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public TestScript setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public TestScript setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public TestScript setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public TestScript setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public TestScript setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public TestScript setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public TestScript setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public TestScript setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public TestScript setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public TestScript setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public TestScript setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public TestScript setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public TestScript addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public TestScript setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public TestScript setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public TestScript setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public TestScript addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public TestScript setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public TestScript addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public TestScript setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public TestScript setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public TestScript setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public TestScript setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<TestScriptOriginComponent> getOrigin() {
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOriginComponent>();
        }
        return this.origin;
    }

    public TestScript setOrigin(List<TestScriptOriginComponent> theOrigin) {
        this.origin = theOrigin;
        return this;
    }

    public boolean hasOrigin() {
        if (this.origin == null) {
            return false;
        }
        for (TestScriptOriginComponent item : this.origin) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptOriginComponent addOrigin() {
        TestScriptOriginComponent t = new TestScriptOriginComponent();
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOriginComponent>();
        }
        this.origin.add(t);
        return t;
    }

    public TestScript addOrigin(TestScriptOriginComponent t) {
        if (t == null) {
            return this;
        }
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOriginComponent>();
        }
        this.origin.add(t);
        return this;
    }

    public TestScriptOriginComponent getOriginFirstRep() {
        if (this.getOrigin().isEmpty()) {
            this.addOrigin();
        }
        return this.getOrigin().get(0);
    }

    public List<TestScriptDestinationComponent> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestinationComponent>();
        }
        return this.destination;
    }

    public TestScript setDestination(List<TestScriptDestinationComponent> theDestination) {
        this.destination = theDestination;
        return this;
    }

    public boolean hasDestination() {
        if (this.destination == null) {
            return false;
        }
        for (TestScriptDestinationComponent item : this.destination) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptDestinationComponent addDestination() {
        TestScriptDestinationComponent t = new TestScriptDestinationComponent();
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestinationComponent>();
        }
        this.destination.add(t);
        return t;
    }

    public TestScript addDestination(TestScriptDestinationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestinationComponent>();
        }
        this.destination.add(t);
        return this;
    }

    public TestScriptDestinationComponent getDestinationFirstRep() {
        if (this.getDestination().isEmpty()) {
            this.addDestination();
        }
        return this.getDestination().get(0);
    }

    public TestScriptMetadataComponent getMetadata() {
        if (this.metadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.metadata");
            }
            if (Configuration.doAutoCreate()) {
                this.metadata = new TestScriptMetadataComponent();
            }
        }
        return this.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    public TestScript setMetadata(TestScriptMetadataComponent value) {
        this.metadata = value;
        return this;
    }

    public List<TestScriptFixtureComponent> getFixture() {
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixtureComponent>();
        }
        return this.fixture;
    }

    public TestScript setFixture(List<TestScriptFixtureComponent> theFixture) {
        this.fixture = theFixture;
        return this;
    }

    public boolean hasFixture() {
        if (this.fixture == null) {
            return false;
        }
        for (TestScriptFixtureComponent item : this.fixture) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptFixtureComponent addFixture() {
        TestScriptFixtureComponent t = new TestScriptFixtureComponent();
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixtureComponent>();
        }
        this.fixture.add(t);
        return t;
    }

    public TestScript addFixture(TestScriptFixtureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixtureComponent>();
        }
        this.fixture.add(t);
        return this;
    }

    public TestScriptFixtureComponent getFixtureFirstRep() {
        if (this.getFixture().isEmpty()) {
            this.addFixture();
        }
        return this.getFixture().get(0);
    }

    public List<Reference> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        return this.profile;
    }

    public TestScript setProfile(List<Reference> theProfile) {
        this.profile = theProfile;
        return this;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (Reference item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProfile() {
        Reference t = new Reference();
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        this.profile.add(t);
        return t;
    }

    public TestScript addProfile(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        this.profile.add(t);
        return this;
    }

    public Reference getProfileFirstRep() {
        if (this.getProfile().isEmpty()) {
            this.addProfile();
        }
        return this.getProfile().get(0);
    }

    public List<TestScriptVariableComponent> getVariable() {
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariableComponent>();
        }
        return this.variable;
    }

    public TestScript setVariable(List<TestScriptVariableComponent> theVariable) {
        this.variable = theVariable;
        return this;
    }

    public boolean hasVariable() {
        if (this.variable == null) {
            return false;
        }
        for (TestScriptVariableComponent item : this.variable) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptVariableComponent addVariable() {
        TestScriptVariableComponent t = new TestScriptVariableComponent();
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariableComponent>();
        }
        this.variable.add(t);
        return t;
    }

    public TestScript addVariable(TestScriptVariableComponent t) {
        if (t == null) {
            return this;
        }
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariableComponent>();
        }
        this.variable.add(t);
        return this;
    }

    public TestScriptVariableComponent getVariableFirstRep() {
        if (this.getVariable().isEmpty()) {
            this.addVariable();
        }
        return this.getVariable().get(0);
    }

    public TestScriptSetupComponent getSetup() {
        if (this.setup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.setup");
            }
            if (Configuration.doAutoCreate()) {
                this.setup = new TestScriptSetupComponent();
            }
        }
        return this.setup;
    }

    public boolean hasSetup() {
        return this.setup != null && !this.setup.isEmpty();
    }

    public TestScript setSetup(TestScriptSetupComponent value) {
        this.setup = value;
        return this;
    }

    public List<TestScriptTestComponent> getTest() {
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTestComponent>();
        }
        return this.test;
    }

    public TestScript setTest(List<TestScriptTestComponent> theTest) {
        this.test = theTest;
        return this;
    }

    public boolean hasTest() {
        if (this.test == null) {
            return false;
        }
        for (TestScriptTestComponent item : this.test) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptTestComponent addTest() {
        TestScriptTestComponent t = new TestScriptTestComponent();
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTestComponent>();
        }
        this.test.add(t);
        return t;
    }

    public TestScript addTest(TestScriptTestComponent t) {
        if (t == null) {
            return this;
        }
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTestComponent>();
        }
        this.test.add(t);
        return this;
    }

    public TestScriptTestComponent getTestFirstRep() {
        if (this.getTest().isEmpty()) {
            this.addTest();
        }
        return this.getTest().get(0);
    }

    public TestScriptTeardownComponent getTeardown() {
        if (this.teardown == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.teardown");
            }
            if (Configuration.doAutoCreate()) {
                this.teardown = new TestScriptTeardownComponent();
            }
        }
        return this.teardown;
    }

    public boolean hasTeardown() {
        return this.teardown != null && !this.teardown.isEmpty();
    }

    public TestScript setTeardown(TestScriptTeardownComponent value) {
        this.teardown = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this test script when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this test script is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the test script is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this test script when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the test script when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the test script author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the test script. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the test script.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this test script. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this test script is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the test script was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the test script changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the test script.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the test script from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate test script instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the test script is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this test script is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the test script and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the test script.", 0, 1, this.copyright));
        children.add(new Property("origin", "", "An abstract server used in operations within this test script in the origin element.", 0, Integer.MAX_VALUE, this.origin));
        children.add(new Property("destination", "", "An abstract server used in operations within this test script in the destination element.", 0, Integer.MAX_VALUE, this.destination));
        children.add(new Property("metadata", "", "The required capability must exist and are assumed to function correctly on the FHIR server being tested.", 0, 1, this.metadata));
        children.add(new Property("fixture", "", "Fixture in the test script - by reference (uri). All fixtures are required for the test script to execute.", 0, Integer.MAX_VALUE, this.fixture));
        children.add(new Property("profile", "Reference(Any)", "Reference to the profile to be used for validation.", 0, Integer.MAX_VALUE, this.profile));
        children.add(new Property("variable", "", "Variable is set based either on element value in response body or on header field value in the response headers.", 0, Integer.MAX_VALUE, this.variable));
        children.add(new Property("setup", "", "A series of required setup operations before tests are executed.", 0, 1, this.setup));
        children.add(new Property("test", "", "A test in this script.", 0, Integer.MAX_VALUE, this.test));
        children.add(new Property("teardown", "", "A series of operations required to clean up after all the tests are executed (successfully or otherwise).", 0, 1, this.teardown));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this test script when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this test script is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the test script is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this test script when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the test script when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the test script author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the test script. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the test script.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this test script. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this test script is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the test script was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the test script changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the test script.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the test script from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate test script instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the test script is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this test script is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the test script and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the test script.", 0, 1, this.copyright);
            }
            case -1008619738: {
                return new Property("origin", "", "An abstract server used in operations within this test script in the origin element.", 0, Integer.MAX_VALUE, this.origin);
            }
            case -1429847026: {
                return new Property("destination", "", "An abstract server used in operations within this test script in the destination element.", 0, Integer.MAX_VALUE, this.destination);
            }
            case -450004177: {
                return new Property("metadata", "", "The required capability must exist and are assumed to function correctly on the FHIR server being tested.", 0, 1, this.metadata);
            }
            case -843449847: {
                return new Property("fixture", "", "Fixture in the test script - by reference (uri). All fixtures are required for the test script to execute.", 0, Integer.MAX_VALUE, this.fixture);
            }
            case -309425751: {
                return new Property("profile", "Reference(Any)", "Reference to the profile to be used for validation.", 0, Integer.MAX_VALUE, this.profile);
            }
            case -1249586564: {
                return new Property("variable", "", "Variable is set based either on element value in response body or on header field value in the response headers.", 0, Integer.MAX_VALUE, this.variable);
            }
            case 109329021: {
                return new Property("setup", "", "A series of required setup operations before tests are executed.", 0, 1, this.setup);
            }
            case 3556498: {
                return new Property("test", "", "A test in this script.", 0, Integer.MAX_VALUE, this.test);
            }
            case -1663474172: {
                return new Property("teardown", "", "A series of operations required to clean up after all the tests are executed (successfully or otherwise).", 0, 1, this.teardown);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case -1008619738: {
                return this.origin == null ? new Base[]{} : this.origin.toArray(new Base[this.origin.size()]);
            }
            case -1429847026: {
                return this.destination == null ? new Base[]{} : this.destination.toArray(new Base[this.destination.size()]);
            }
            case -450004177: {
                Base[] baseArray;
                if (this.metadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.metadata;
                }
                return baseArray;
            }
            case -843449847: {
                return this.fixture == null ? new Base[]{} : this.fixture.toArray(new Base[this.fixture.size()]);
            }
            case -309425751: {
                return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
            }
            case -1249586564: {
                return this.variable == null ? new Base[]{} : this.variable.toArray(new Base[this.variable.size()]);
            }
            case 109329021: {
                Base[] baseArray;
                if (this.setup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.setup;
                }
                return baseArray;
            }
            case 3556498: {
                return this.test == null ? new Base[]{} : this.test.toArray(new Base[this.test.size()]);
            }
            case -1663474172: {
                Base[] baseArray;
                if (this.teardown == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.teardown;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1008619738: {
                this.getOrigin().add((TestScriptOriginComponent)((Object)value));
                return value;
            }
            case -1429847026: {
                this.getDestination().add((TestScriptDestinationComponent)((Object)value));
                return value;
            }
            case -450004177: {
                this.metadata = (TestScriptMetadataComponent)((Object)value);
                return value;
            }
            case -843449847: {
                this.getFixture().add((TestScriptFixtureComponent)((Object)value));
                return value;
            }
            case -309425751: {
                this.getProfile().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1249586564: {
                this.getVariable().add((TestScriptVariableComponent)((Object)value));
                return value;
            }
            case 109329021: {
                this.setup = (TestScriptSetupComponent)((Object)value);
                return value;
            }
            case 3556498: {
                this.getTest().add((TestScriptTestComponent)((Object)value));
                return value;
            }
            case -1663474172: {
                this.teardown = (TestScriptTeardownComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("origin")) {
            this.getOrigin().add((TestScriptOriginComponent)((Object)value));
        } else if (name.equals("destination")) {
            this.getDestination().add((TestScriptDestinationComponent)((Object)value));
        } else if (name.equals("metadata")) {
            this.metadata = (TestScriptMetadataComponent)((Object)value);
        } else if (name.equals("fixture")) {
            this.getFixture().add((TestScriptFixtureComponent)((Object)value));
        } else if (name.equals("profile")) {
            this.getProfile().add(TypeConvertor.castToReference(value));
        } else if (name.equals("variable")) {
            this.getVariable().add((TestScriptVariableComponent)((Object)value));
        } else if (name.equals("setup")) {
            this.setup = (TestScriptSetupComponent)((Object)value);
        } else if (name.equals("test")) {
            this.getTest().add((TestScriptTestComponent)((Object)value));
        } else if (name.equals("teardown")) {
            this.teardown = (TestScriptTeardownComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.getIdentifierFirstRep();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -1008619738: {
                return this.addOrigin();
            }
            case -1429847026: {
                return this.addDestination();
            }
            case -450004177: {
                return this.getMetadata();
            }
            case -843449847: {
                return this.addFixture();
            }
            case -309425751: {
                return this.addProfile();
            }
            case -1249586564: {
                return this.addVariable();
            }
            case 109329021: {
                return this.getSetup();
            }
            case 3556498: {
                return this.addTest();
            }
            case -1663474172: {
                return this.getTeardown();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -1008619738: {
                return new String[0];
            }
            case -1429847026: {
                return new String[0];
            }
            case -450004177: {
                return new String[0];
            }
            case -843449847: {
                return new String[0];
            }
            case -309425751: {
                return new String[]{"Reference"};
            }
            case -1249586564: {
                return new String[0];
            }
            case 109329021: {
                return new String[0];
            }
            case 3556498: {
                return new String[0];
            }
            case -1663474172: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.copyright");
        }
        if (name.equals("origin")) {
            return this.addOrigin();
        }
        if (name.equals("destination")) {
            return this.addDestination();
        }
        if (name.equals("metadata")) {
            this.metadata = new TestScriptMetadataComponent();
            return this.metadata;
        }
        if (name.equals("fixture")) {
            return this.addFixture();
        }
        if (name.equals("profile")) {
            return this.addProfile();
        }
        if (name.equals("variable")) {
            return this.addVariable();
        }
        if (name.equals("setup")) {
            this.setup = new TestScriptSetupComponent();
            return this.setup;
        }
        if (name.equals("test")) {
            return this.addTest();
        }
        if (name.equals("teardown")) {
            this.teardown = new TestScriptTeardownComponent();
            return this.teardown;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TestScript";
    }

    @Override
    public TestScript copy() {
        TestScript dst = new TestScript();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TestScript dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        MarkdownType markdownType2 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.origin != null) {
            dst.origin = new ArrayList<TestScriptOriginComponent>();
            for (TestScriptOriginComponent testScriptOriginComponent : this.origin) {
                dst.origin.add(testScriptOriginComponent.copy());
            }
        }
        if (this.destination != null) {
            dst.destination = new ArrayList<TestScriptDestinationComponent>();
            for (TestScriptDestinationComponent testScriptDestinationComponent : this.destination) {
                dst.destination.add(testScriptDestinationComponent.copy());
            }
        }
        TestScriptMetadataComponent testScriptMetadataComponent = dst.metadata = this.metadata == null ? null : this.metadata.copy();
        if (this.fixture != null) {
            dst.fixture = new ArrayList<TestScriptFixtureComponent>();
            for (TestScriptFixtureComponent testScriptFixtureComponent : this.fixture) {
                dst.fixture.add(testScriptFixtureComponent.copy());
            }
        }
        if (this.profile != null) {
            dst.profile = new ArrayList<Reference>();
            for (Reference reference : this.profile) {
                dst.profile.add(reference.copy());
            }
        }
        if (this.variable != null) {
            dst.variable = new ArrayList<TestScriptVariableComponent>();
            for (TestScriptVariableComponent testScriptVariableComponent : this.variable) {
                dst.variable.add(testScriptVariableComponent.copy());
            }
        }
        TestScriptSetupComponent testScriptSetupComponent = dst.setup = this.setup == null ? null : this.setup.copy();
        if (this.test != null) {
            dst.test = new ArrayList<TestScriptTestComponent>();
            for (TestScriptTestComponent testScriptTestComponent : this.test) {
                dst.test.add(testScriptTestComponent.copy());
            }
        }
        dst.teardown = this.teardown == null ? null : this.teardown.copy();
    }

    protected TestScript typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TestScript)) {
            return false;
        }
        TestScript o = (TestScript)other_;
        return TestScript.compareDeep(this.url, o.url, true) && TestScript.compareDeep(this.identifier, o.identifier, true) && TestScript.compareDeep(this.version, o.version, true) && TestScript.compareDeep(this.name, o.name, true) && TestScript.compareDeep(this.title, o.title, true) && TestScript.compareDeep(this.status, o.status, true) && TestScript.compareDeep(this.experimental, o.experimental, true) && TestScript.compareDeep(this.date, o.date, true) && TestScript.compareDeep(this.publisher, o.publisher, true) && TestScript.compareDeep(this.contact, o.contact, true) && TestScript.compareDeep(this.description, o.description, true) && TestScript.compareDeep(this.useContext, o.useContext, true) && TestScript.compareDeep(this.jurisdiction, o.jurisdiction, true) && TestScript.compareDeep(this.purpose, o.purpose, true) && TestScript.compareDeep(this.copyright, o.copyright, true) && TestScript.compareDeep(this.origin, o.origin, true) && TestScript.compareDeep(this.destination, o.destination, true) && TestScript.compareDeep(this.metadata, o.metadata, true) && TestScript.compareDeep(this.fixture, o.fixture, true) && TestScript.compareDeep(this.profile, o.profile, true) && TestScript.compareDeep(this.variable, o.variable, true) && TestScript.compareDeep(this.setup, o.setup, true) && TestScript.compareDeep(this.test, o.test, true) && TestScript.compareDeep(this.teardown, o.teardown, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TestScript)) {
            return false;
        }
        TestScript o = (TestScript)other_;
        return TestScript.compareValues(this.url, o.url, true) && TestScript.compareValues(this.version, o.version, true) && TestScript.compareValues(this.name, o.name, true) && TestScript.compareValues(this.title, o.title, true) && TestScript.compareValues(this.status, o.status, true) && TestScript.compareValues(this.experimental, o.experimental, true) && TestScript.compareValues(this.date, o.date, true) && TestScript.compareValues(this.publisher, o.publisher, true) && TestScript.compareValues(this.description, o.description, true) && TestScript.compareValues(this.purpose, o.purpose, true) && TestScript.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.origin, this.destination, this.metadata, this.fixture, this.profile, this.variable, this.setup, this.test, this.teardown});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TestScript;
    }

    @Block
    public static class TeardownActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={SetupActionOperationComponent.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The teardown operation to perform", formalDefinition="An operation would involve a REST request to a server.")
        protected SetupActionOperationComponent operation;
        private static final long serialVersionUID = -1099598054L;

        public TeardownActionComponent() {
        }

        public TeardownActionComponent(SetupActionOperationComponent operation) {
            this.setOperation(operation);
        }

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TeardownActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TeardownActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operation", "@TestScript.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1662702951: {
                    return new Property("operation", "@TestScript.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("operation")) {
                return super.setProperty(name, value);
            }
            this.operation = (SetupActionOperationComponent)value;
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return new String[]{"@TestScript.setup.action.operation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            return super.addChild(name);
        }

        @Override
        public TeardownActionComponent copy() {
            TeardownActionComponent dst = new TeardownActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TeardownActionComponent dst) {
            super.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TeardownActionComponent)) {
                return false;
            }
            TeardownActionComponent o = (TeardownActionComponent)other_;
            return TeardownActionComponent.compareDeep(this.operation, o.operation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TeardownActionComponent)) {
                return false;
            }
            TeardownActionComponent o = (TeardownActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.operation});
        }

        @Override
        public String fhirType() {
            return "TestScript.teardown.action";
        }
    }

    @Block
    public static class TestScriptTeardownComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="One or more teardown operations to perform", formalDefinition="The teardown action will only contain an operation.")
        protected List<TeardownActionComponent> action;
        private static final long serialVersionUID = 1168638089L;

        public TestScriptTeardownComponent() {
        }

        public TestScriptTeardownComponent(TeardownActionComponent action) {
            this.addAction(action);
        }

        public List<TeardownActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            return this.action;
        }

        public TestScriptTeardownComponent setAction(List<TeardownActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (TeardownActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TeardownActionComponent addAction() {
            TeardownActionComponent t = new TeardownActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestScriptTeardownComponent addAction(TeardownActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public TeardownActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "", "The teardown action will only contain an operation.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "", "The teardown action will only contain an operation.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.getAction().add((TeardownActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("action")) {
                return super.setProperty(name, value);
            }
            this.getAction().add((TeardownActionComponent)value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptTeardownComponent copy() {
            TestScriptTeardownComponent dst = new TestScriptTeardownComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptTeardownComponent dst) {
            super.copyValues(dst);
            if (this.action != null) {
                dst.action = new ArrayList<TeardownActionComponent>();
                for (TeardownActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptTeardownComponent)) {
                return false;
            }
            TestScriptTeardownComponent o = (TestScriptTeardownComponent)other_;
            return TestScriptTeardownComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptTeardownComponent)) {
                return false;
            }
            TestScriptTeardownComponent o = (TestScriptTeardownComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.action);
        }

        @Override
        public String fhirType() {
            return "TestScript.teardown";
        }
    }

    @Block
    public static class TestActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={SetupActionOperationComponent.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The setup operation to perform", formalDefinition="An operation would involve a REST request to a server.")
        protected SetupActionOperationComponent operation;
        @Child(name="assert", type={SetupActionAssertComponent.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The setup assertion to perform", formalDefinition="Evaluates the results of previous operations to determine if the server under test behaves appropriately.")
        protected SetupActionAssertComponent assert_;
        private static final long serialVersionUID = -252088305L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TestActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        public SetupActionAssertComponent getAssert() {
            if (this.assert_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestActionComponent.assert_");
                }
                if (Configuration.doAutoCreate()) {
                    this.assert_ = new SetupActionAssertComponent();
                }
            }
            return this.assert_;
        }

        public boolean hasAssert() {
            return this.assert_ != null && !this.assert_.isEmpty();
        }

        public TestActionComponent setAssert(SetupActionAssertComponent value) {
            this.assert_ = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operation", "@TestScript.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation));
            children.add(new Property("assert", "@TestScript.setup.action.assert", "Evaluates the results of previous operations to determine if the server under test behaves appropriately.", 0, 1, this.assert_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1662702951: {
                    return new Property("operation", "@TestScript.setup.action.operation", "An operation would involve a REST request to a server.", 0, 1, this.operation);
                }
                case -1408208058: {
                    return new Property("assert", "@TestScript.setup.action.assert", "Evaluates the results of previous operations to determine if the server under test behaves appropriately.", 0, 1, this.assert_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
                case -1408208058: {
                    Base[] baseArray;
                    if (this.assert_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.assert_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    return value;
                }
                case -1408208058: {
                    this.assert_ = (SetupActionAssertComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else if (name.equals("assert")) {
                this.assert_ = (SetupActionAssertComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
                case -1408208058: {
                    return this.getAssert();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return new String[]{"@TestScript.setup.action.operation"};
                }
                case -1408208058: {
                    return new String[]{"@TestScript.setup.action.assert"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            if (name.equals("assert")) {
                this.assert_ = new SetupActionAssertComponent();
                return this.assert_;
            }
            return super.addChild(name);
        }

        @Override
        public TestActionComponent copy() {
            TestActionComponent dst = new TestActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestActionComponent dst) {
            super.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            dst.assert_ = this.assert_ == null ? null : this.assert_.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestActionComponent)) {
                return false;
            }
            TestActionComponent o = (TestActionComponent)other_;
            return TestActionComponent.compareDeep(this.operation, o.operation, true) && TestActionComponent.compareDeep(this.assert_, o.assert_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestActionComponent)) {
                return false;
            }
            TestActionComponent o = (TestActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.operation, this.assert_});
        }

        @Override
        public String fhirType() {
            return "TestScript.test.action";
        }
    }

    @Block
    public static class TestScriptTestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging name of this test", formalDefinition="The name of this test used for tracking/logging purposes by test engines.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting short description of the test", formalDefinition="A short description of the test used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="action", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A test operation or assert to perform", formalDefinition="Action would contain either an operation or an assertion.")
        protected List<TestActionComponent> action;
        private static final long serialVersionUID = -865006110L;

        public TestScriptTestComponent() {
        }

        public TestScriptTestComponent(TestActionComponent action) {
            this.addAction(action);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptTestComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptTestComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptTestComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptTestComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptTestComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptTestComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<TestActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            return this.action;
        }

        public TestScriptTestComponent setAction(List<TestActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (TestActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestActionComponent addAction() {
            TestActionComponent t = new TestActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestScriptTestComponent addAction(TestActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public TestActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TestScript.SP_NAME, "string", "The name of this test used for tracking/logging purposes by test engines.", 0, 1, this.name));
            children.add(new Property(TestScript.SP_DESCRIPTION, "string", "A short description of the test used by test engines for tracking and reporting purposes.", 0, 1, this.description));
            children.add(new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(TestScript.SP_NAME, "string", "The name of this test used for tracking/logging purposes by test engines.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(TestScript.SP_DESCRIPTION, "string", "A short description of the test used by test engines for tracking and reporting purposes.", 0, 1, this.description);
                }
                case -1422950858: {
                    return new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((TestActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("action")) {
                this.getAction().add((TestActionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1422950858: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.test.name");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.test.description");
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptTestComponent copy() {
            TestScriptTestComponent dst = new TestScriptTestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptTestComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.action != null) {
                dst.action = new ArrayList<TestActionComponent>();
                for (TestActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptTestComponent)) {
                return false;
            }
            TestScriptTestComponent o = (TestScriptTestComponent)other_;
            return TestScriptTestComponent.compareDeep(this.name, o.name, true) && TestScriptTestComponent.compareDeep(this.description, o.description, true) && TestScriptTestComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptTestComponent)) {
                return false;
            }
            TestScriptTestComponent o = (TestScriptTestComponent)other_;
            return TestScriptTestComponent.compareValues(this.name, o.name, true) && TestScriptTestComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.description, this.action});
        }

        @Override
        public String fhirType() {
            return "TestScript.test";
        }
    }

    @Block
    public static class SetupActionAssertComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="label", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging assertion label", formalDefinition="The label would be used for tracking/logging purposes by test engines.")
        protected StringType label;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting assertion description", formalDefinition="The description would be used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="direction", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="response | request", formalDefinition="The direction to use for the assertion.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/assert-direction-codes")
        protected Enumeration<AssertionDirectionType> direction;
        @Child(name="compareToSourceId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of the source fixture to be evaluated", formalDefinition="Id of the source fixture used as the contents to be evaluated by either the \"source/expression\" or \"sourceId/path\" definition.")
        protected StringType compareToSourceId;
        @Child(name="compareToSourceExpression", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The FHIRPath expression to evaluate against the source fixture", formalDefinition="The FHIRPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.")
        protected StringType compareToSourceExpression;
        @Child(name="compareToSourcePath", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="XPath or JSONPath expression to evaluate against the source fixture", formalDefinition="XPath or JSONPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.")
        protected StringType compareToSourcePath;
        @Child(name="contentType", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Mime type to compare against the 'Content-Type' header", formalDefinition="The mime-type contents to compare against the request or response message 'Content-Type' header.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
        protected CodeType contentType;
        @Child(name="expression", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The FHIRPath expression to be evaluated", formalDefinition="The FHIRPath expression to be evaluated against the request or response message contents - HTTP headers and payload.")
        protected StringType expression;
        @Child(name="headerField", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP header field name", formalDefinition="The HTTP header field name e.g. 'Location'.")
        protected StringType headerField;
        @Child(name="minimumId", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of minimum content resource", formalDefinition="The ID of a fixture.  Asserts that the response contains at a minimum the fixture specified by minimumId.")
        protected StringType minimumId;
        @Child(name="navigationLinks", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Perform validation on navigation links?", formalDefinition="Whether or not the test execution performs validation on the bundle navigation links.")
        protected BooleanType navigationLinks;
        @Child(name="operator", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="equals | notEquals | in | notIn | greaterThan | lessThan | empty | notEmpty | contains | notContains | eval", formalDefinition="The operator type defines the conditional behavior of the assert. If not defined, the default is equals.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/assert-operator-codes")
        protected Enumeration<AssertionOperatorType> operator;
        @Child(name="path", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="XPath or JSONPath expression", formalDefinition="The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.")
        protected StringType path;
        @Child(name="requestMethod", type={CodeType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="delete | get | options | patch | post | put | head", formalDefinition="The request method or HTTP operation code to compare against that used by the client system under test.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/http-operations")
        protected Enumeration<TestScriptRequestMethodCode> requestMethod;
        @Child(name="requestURL", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Request URL comparison value", formalDefinition="The value to use in a comparison against the request URL path string.")
        protected StringType requestURL;
        @Child(name="resource", type={CodeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource type", formalDefinition="The type of the resource.  See http://build.fhir.org/resourcelist.html.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected Enumeration<FHIRDefinedType> resource;
        @Child(name="response", type={CodeType.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable", formalDefinition="okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/assert-response-code-types")
        protected Enumeration<AssertionResponseTypes> response;
        @Child(name="responseCode", type={StringType.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP response code to test", formalDefinition="The value of the HTTP response code to be tested.")
        protected StringType responseCode;
        @Child(name="sourceId", type={IdType.class}, order=19, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of source expression or headerField", formalDefinition="Fixture to evaluate the XPath/JSONPath expression or the headerField  against.")
        protected IdType sourceId;
        @Child(name="validateProfileId", type={IdType.class}, order=20, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile Id of validation profile reference", formalDefinition="The ID of the Profile to validate against.")
        protected IdType validateProfileId;
        @Child(name="value", type={StringType.class}, order=21, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The value to compare to", formalDefinition="The value to compare to.")
        protected StringType value;
        @Child(name="warningOnly", type={BooleanType.class}, order=22, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Will this assert produce a warning only on error?", formalDefinition="Whether or not the test execution will produce a warning only on error for this assert.")
        protected BooleanType warningOnly;
        private static final long serialVersionUID = -1112296782L;

        public SetupActionAssertComponent() {
        }

        public SetupActionAssertComponent(boolean warningOnly) {
            this.setWarningOnly(warningOnly);
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public SetupActionAssertComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public SetupActionAssertComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SetupActionAssertComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SetupActionAssertComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<AssertionDirectionType> getDirectionElement() {
            if (this.direction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.direction");
                }
                if (Configuration.doAutoCreate()) {
                    this.direction = new Enumeration<AssertionDirectionType>(new AssertionDirectionTypeEnumFactory());
                }
            }
            return this.direction;
        }

        public boolean hasDirectionElement() {
            return this.direction != null && !this.direction.isEmpty();
        }

        public boolean hasDirection() {
            return this.direction != null && !this.direction.isEmpty();
        }

        public SetupActionAssertComponent setDirectionElement(Enumeration<AssertionDirectionType> value) {
            this.direction = value;
            return this;
        }

        public AssertionDirectionType getDirection() {
            return this.direction == null ? null : (AssertionDirectionType)((Object)this.direction.getValue());
        }

        public SetupActionAssertComponent setDirection(AssertionDirectionType value) {
            if (value == null) {
                this.direction = null;
            } else {
                if (this.direction == null) {
                    this.direction = new Enumeration<AssertionDirectionType>(new AssertionDirectionTypeEnumFactory());
                }
                this.direction.setValue((Object)value);
            }
            return this;
        }

        public StringType getCompareToSourceIdElement() {
            if (this.compareToSourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.compareToSourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.compareToSourceId = new StringType();
                }
            }
            return this.compareToSourceId;
        }

        public boolean hasCompareToSourceIdElement() {
            return this.compareToSourceId != null && !this.compareToSourceId.isEmpty();
        }

        public boolean hasCompareToSourceId() {
            return this.compareToSourceId != null && !this.compareToSourceId.isEmpty();
        }

        public SetupActionAssertComponent setCompareToSourceIdElement(StringType value) {
            this.compareToSourceId = value;
            return this;
        }

        public String getCompareToSourceId() {
            return this.compareToSourceId == null ? null : (String)this.compareToSourceId.getValue();
        }

        public SetupActionAssertComponent setCompareToSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.compareToSourceId = null;
            } else {
                if (this.compareToSourceId == null) {
                    this.compareToSourceId = new StringType();
                }
                this.compareToSourceId.setValue(value);
            }
            return this;
        }

        public StringType getCompareToSourceExpressionElement() {
            if (this.compareToSourceExpression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.compareToSourceExpression");
                }
                if (Configuration.doAutoCreate()) {
                    this.compareToSourceExpression = new StringType();
                }
            }
            return this.compareToSourceExpression;
        }

        public boolean hasCompareToSourceExpressionElement() {
            return this.compareToSourceExpression != null && !this.compareToSourceExpression.isEmpty();
        }

        public boolean hasCompareToSourceExpression() {
            return this.compareToSourceExpression != null && !this.compareToSourceExpression.isEmpty();
        }

        public SetupActionAssertComponent setCompareToSourceExpressionElement(StringType value) {
            this.compareToSourceExpression = value;
            return this;
        }

        public String getCompareToSourceExpression() {
            return this.compareToSourceExpression == null ? null : (String)this.compareToSourceExpression.getValue();
        }

        public SetupActionAssertComponent setCompareToSourceExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.compareToSourceExpression = null;
            } else {
                if (this.compareToSourceExpression == null) {
                    this.compareToSourceExpression = new StringType();
                }
                this.compareToSourceExpression.setValue(value);
            }
            return this;
        }

        public StringType getCompareToSourcePathElement() {
            if (this.compareToSourcePath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.compareToSourcePath");
                }
                if (Configuration.doAutoCreate()) {
                    this.compareToSourcePath = new StringType();
                }
            }
            return this.compareToSourcePath;
        }

        public boolean hasCompareToSourcePathElement() {
            return this.compareToSourcePath != null && !this.compareToSourcePath.isEmpty();
        }

        public boolean hasCompareToSourcePath() {
            return this.compareToSourcePath != null && !this.compareToSourcePath.isEmpty();
        }

        public SetupActionAssertComponent setCompareToSourcePathElement(StringType value) {
            this.compareToSourcePath = value;
            return this;
        }

        public String getCompareToSourcePath() {
            return this.compareToSourcePath == null ? null : (String)this.compareToSourcePath.getValue();
        }

        public SetupActionAssertComponent setCompareToSourcePath(String value) {
            if (Utilities.noString((String)value)) {
                this.compareToSourcePath = null;
            } else {
                if (this.compareToSourcePath == null) {
                    this.compareToSourcePath = new StringType();
                }
                this.compareToSourcePath.setValue(value);
            }
            return this;
        }

        public CodeType getContentTypeElement() {
            if (this.contentType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.contentType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contentType = new CodeType();
                }
            }
            return this.contentType;
        }

        public boolean hasContentTypeElement() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public boolean hasContentType() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public SetupActionAssertComponent setContentTypeElement(CodeType value) {
            this.contentType = value;
            return this;
        }

        public String getContentType() {
            return this.contentType == null ? null : (String)this.contentType.getValue();
        }

        public SetupActionAssertComponent setContentType(String value) {
            if (Utilities.noString((String)value)) {
                this.contentType = null;
            } else {
                if (this.contentType == null) {
                    this.contentType = new CodeType();
                }
                this.contentType.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public SetupActionAssertComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public SetupActionAssertComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        public StringType getHeaderFieldElement() {
            if (this.headerField == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.headerField");
                }
                if (Configuration.doAutoCreate()) {
                    this.headerField = new StringType();
                }
            }
            return this.headerField;
        }

        public boolean hasHeaderFieldElement() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public boolean hasHeaderField() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public SetupActionAssertComponent setHeaderFieldElement(StringType value) {
            this.headerField = value;
            return this;
        }

        public String getHeaderField() {
            return this.headerField == null ? null : (String)this.headerField.getValue();
        }

        public SetupActionAssertComponent setHeaderField(String value) {
            if (Utilities.noString((String)value)) {
                this.headerField = null;
            } else {
                if (this.headerField == null) {
                    this.headerField = new StringType();
                }
                this.headerField.setValue(value);
            }
            return this;
        }

        public StringType getMinimumIdElement() {
            if (this.minimumId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.minimumId");
                }
                if (Configuration.doAutoCreate()) {
                    this.minimumId = new StringType();
                }
            }
            return this.minimumId;
        }

        public boolean hasMinimumIdElement() {
            return this.minimumId != null && !this.minimumId.isEmpty();
        }

        public boolean hasMinimumId() {
            return this.minimumId != null && !this.minimumId.isEmpty();
        }

        public SetupActionAssertComponent setMinimumIdElement(StringType value) {
            this.minimumId = value;
            return this;
        }

        public String getMinimumId() {
            return this.minimumId == null ? null : (String)this.minimumId.getValue();
        }

        public SetupActionAssertComponent setMinimumId(String value) {
            if (Utilities.noString((String)value)) {
                this.minimumId = null;
            } else {
                if (this.minimumId == null) {
                    this.minimumId = new StringType();
                }
                this.minimumId.setValue(value);
            }
            return this;
        }

        public BooleanType getNavigationLinksElement() {
            if (this.navigationLinks == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.navigationLinks");
                }
                if (Configuration.doAutoCreate()) {
                    this.navigationLinks = new BooleanType();
                }
            }
            return this.navigationLinks;
        }

        public boolean hasNavigationLinksElement() {
            return this.navigationLinks != null && !this.navigationLinks.isEmpty();
        }

        public boolean hasNavigationLinks() {
            return this.navigationLinks != null && !this.navigationLinks.isEmpty();
        }

        public SetupActionAssertComponent setNavigationLinksElement(BooleanType value) {
            this.navigationLinks = value;
            return this;
        }

        public boolean getNavigationLinks() {
            return this.navigationLinks == null || this.navigationLinks.isEmpty() ? false : (Boolean)this.navigationLinks.getValue();
        }

        public SetupActionAssertComponent setNavigationLinks(boolean value) {
            if (this.navigationLinks == null) {
                this.navigationLinks = new BooleanType();
            }
            this.navigationLinks.setValue((Object)value);
            return this;
        }

        public Enumeration<AssertionOperatorType> getOperatorElement() {
            if (this.operator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.operator");
                }
                if (Configuration.doAutoCreate()) {
                    this.operator = new Enumeration<AssertionOperatorType>(new AssertionOperatorTypeEnumFactory());
                }
            }
            return this.operator;
        }

        public boolean hasOperatorElement() {
            return this.operator != null && !this.operator.isEmpty();
        }

        public boolean hasOperator() {
            return this.operator != null && !this.operator.isEmpty();
        }

        public SetupActionAssertComponent setOperatorElement(Enumeration<AssertionOperatorType> value) {
            this.operator = value;
            return this;
        }

        public AssertionOperatorType getOperator() {
            return this.operator == null ? null : (AssertionOperatorType)((Object)this.operator.getValue());
        }

        public SetupActionAssertComponent setOperator(AssertionOperatorType value) {
            if (value == null) {
                this.operator = null;
            } else {
                if (this.operator == null) {
                    this.operator = new Enumeration<AssertionOperatorType>(new AssertionOperatorTypeEnumFactory());
                }
                this.operator.setValue((Object)value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public SetupActionAssertComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public SetupActionAssertComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public Enumeration<TestScriptRequestMethodCode> getRequestMethodElement() {
            if (this.requestMethod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.requestMethod");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestMethod = new Enumeration<TestScriptRequestMethodCode>(new TestScriptRequestMethodCodeEnumFactory());
                }
            }
            return this.requestMethod;
        }

        public boolean hasRequestMethodElement() {
            return this.requestMethod != null && !this.requestMethod.isEmpty();
        }

        public boolean hasRequestMethod() {
            return this.requestMethod != null && !this.requestMethod.isEmpty();
        }

        public SetupActionAssertComponent setRequestMethodElement(Enumeration<TestScriptRequestMethodCode> value) {
            this.requestMethod = value;
            return this;
        }

        public TestScriptRequestMethodCode getRequestMethod() {
            return this.requestMethod == null ? null : (TestScriptRequestMethodCode)((Object)this.requestMethod.getValue());
        }

        public SetupActionAssertComponent setRequestMethod(TestScriptRequestMethodCode value) {
            if (value == null) {
                this.requestMethod = null;
            } else {
                if (this.requestMethod == null) {
                    this.requestMethod = new Enumeration<TestScriptRequestMethodCode>(new TestScriptRequestMethodCodeEnumFactory());
                }
                this.requestMethod.setValue((Object)value);
            }
            return this;
        }

        public StringType getRequestURLElement() {
            if (this.requestURL == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.requestURL");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestURL = new StringType();
                }
            }
            return this.requestURL;
        }

        public boolean hasRequestURLElement() {
            return this.requestURL != null && !this.requestURL.isEmpty();
        }

        public boolean hasRequestURL() {
            return this.requestURL != null && !this.requestURL.isEmpty();
        }

        public SetupActionAssertComponent setRequestURLElement(StringType value) {
            this.requestURL = value;
            return this;
        }

        public String getRequestURL() {
            return this.requestURL == null ? null : (String)this.requestURL.getValue();
        }

        public SetupActionAssertComponent setRequestURL(String value) {
            if (Utilities.noString((String)value)) {
                this.requestURL = null;
            } else {
                if (this.requestURL == null) {
                    this.requestURL = new StringType();
                }
                this.requestURL.setValue(value);
            }
            return this;
        }

        public Enumeration<FHIRDefinedType> getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Enumeration<FHIRDefinedType>(new FHIRDefinedTypeEnumFactory());
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SetupActionAssertComponent setResourceElement(Enumeration<FHIRDefinedType> value) {
            this.resource = value;
            return this;
        }

        public FHIRDefinedType getResource() {
            return this.resource == null ? null : (FHIRDefinedType)((Object)this.resource.getValue());
        }

        public SetupActionAssertComponent setResource(FHIRDefinedType value) {
            if (value == null) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new Enumeration<FHIRDefinedType>(new FHIRDefinedTypeEnumFactory());
                }
                this.resource.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<AssertionResponseTypes> getResponseElement() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new Enumeration<AssertionResponseTypes>(new AssertionResponseTypesEnumFactory());
                }
            }
            return this.response;
        }

        public boolean hasResponseElement() {
            return this.response != null && !this.response.isEmpty();
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public SetupActionAssertComponent setResponseElement(Enumeration<AssertionResponseTypes> value) {
            this.response = value;
            return this;
        }

        public AssertionResponseTypes getResponse() {
            return this.response == null ? null : (AssertionResponseTypes)((Object)this.response.getValue());
        }

        public SetupActionAssertComponent setResponse(AssertionResponseTypes value) {
            if (value == null) {
                this.response = null;
            } else {
                if (this.response == null) {
                    this.response = new Enumeration<AssertionResponseTypes>(new AssertionResponseTypesEnumFactory());
                }
                this.response.setValue((Object)value);
            }
            return this;
        }

        public StringType getResponseCodeElement() {
            if (this.responseCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.responseCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.responseCode = new StringType();
                }
            }
            return this.responseCode;
        }

        public boolean hasResponseCodeElement() {
            return this.responseCode != null && !this.responseCode.isEmpty();
        }

        public boolean hasResponseCode() {
            return this.responseCode != null && !this.responseCode.isEmpty();
        }

        public SetupActionAssertComponent setResponseCodeElement(StringType value) {
            this.responseCode = value;
            return this;
        }

        public String getResponseCode() {
            return this.responseCode == null ? null : (String)this.responseCode.getValue();
        }

        public SetupActionAssertComponent setResponseCode(String value) {
            if (Utilities.noString((String)value)) {
                this.responseCode = null;
            } else {
                if (this.responseCode == null) {
                    this.responseCode = new StringType();
                }
                this.responseCode.setValue(value);
            }
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public SetupActionAssertComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public SetupActionAssertComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new IdType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        public IdType getValidateProfileIdElement() {
            if (this.validateProfileId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.validateProfileId");
                }
                if (Configuration.doAutoCreate()) {
                    this.validateProfileId = new IdType();
                }
            }
            return this.validateProfileId;
        }

        public boolean hasValidateProfileIdElement() {
            return this.validateProfileId != null && !this.validateProfileId.isEmpty();
        }

        public boolean hasValidateProfileId() {
            return this.validateProfileId != null && !this.validateProfileId.isEmpty();
        }

        public SetupActionAssertComponent setValidateProfileIdElement(IdType value) {
            this.validateProfileId = value;
            return this;
        }

        public String getValidateProfileId() {
            return this.validateProfileId == null ? null : this.validateProfileId.getValue();
        }

        public SetupActionAssertComponent setValidateProfileId(String value) {
            if (Utilities.noString((String)value)) {
                this.validateProfileId = null;
            } else {
                if (this.validateProfileId == null) {
                    this.validateProfileId = new IdType();
                }
                this.validateProfileId.setValue(value);
            }
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SetupActionAssertComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SetupActionAssertComponent setValue(String value) {
            if (Utilities.noString((String)value)) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public BooleanType getWarningOnlyElement() {
            if (this.warningOnly == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.warningOnly");
                }
                if (Configuration.doAutoCreate()) {
                    this.warningOnly = new BooleanType();
                }
            }
            return this.warningOnly;
        }

        public boolean hasWarningOnlyElement() {
            return this.warningOnly != null && !this.warningOnly.isEmpty();
        }

        public boolean hasWarningOnly() {
            return this.warningOnly != null && !this.warningOnly.isEmpty();
        }

        public SetupActionAssertComponent setWarningOnlyElement(BooleanType value) {
            this.warningOnly = value;
            return this;
        }

        public boolean getWarningOnly() {
            return this.warningOnly == null || this.warningOnly.isEmpty() ? false : (Boolean)this.warningOnly.getValue();
        }

        public SetupActionAssertComponent setWarningOnly(boolean value) {
            if (this.warningOnly == null) {
                this.warningOnly = new BooleanType();
            }
            this.warningOnly.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "The label would be used for tracking/logging purposes by test engines.", 0, 1, this.label));
            children.add(new Property(TestScript.SP_DESCRIPTION, "string", "The description would be used by test engines for tracking and reporting purposes.", 0, 1, this.description));
            children.add(new Property("direction", "code", "The direction to use for the assertion.", 0, 1, this.direction));
            children.add(new Property("compareToSourceId", "string", "Id of the source fixture used as the contents to be evaluated by either the \"source/expression\" or \"sourceId/path\" definition.", 0, 1, this.compareToSourceId));
            children.add(new Property("compareToSourceExpression", "string", "The FHIRPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.", 0, 1, this.compareToSourceExpression));
            children.add(new Property("compareToSourcePath", "string", "XPath or JSONPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.", 0, 1, this.compareToSourcePath));
            children.add(new Property("contentType", "code", "The mime-type contents to compare against the request or response message 'Content-Type' header.", 0, 1, this.contentType));
            children.add(new Property("expression", "string", "The FHIRPath expression to be evaluated against the request or response message contents - HTTP headers and payload.", 0, 1, this.expression));
            children.add(new Property("headerField", "string", "The HTTP header field name e.g. 'Location'.", 0, 1, this.headerField));
            children.add(new Property("minimumId", "string", "The ID of a fixture.  Asserts that the response contains at a minimum the fixture specified by minimumId.", 0, 1, this.minimumId));
            children.add(new Property("navigationLinks", "boolean", "Whether or not the test execution performs validation on the bundle navigation links.", 0, 1, this.navigationLinks));
            children.add(new Property("operator", "code", "The operator type defines the conditional behavior of the assert. If not defined, the default is equals.", 0, 1, this.operator));
            children.add(new Property("path", "string", "The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.", 0, 1, this.path));
            children.add(new Property("requestMethod", "code", "The request method or HTTP operation code to compare against that used by the client system under test.", 0, 1, this.requestMethod));
            children.add(new Property("requestURL", "string", "The value to use in a comparison against the request URL path string.", 0, 1, this.requestURL));
            children.add(new Property("resource", "code", "The type of the resource.  See http://build.fhir.org/resourcelist.html.", 0, 1, this.resource));
            children.add(new Property("response", "code", "okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.", 0, 1, this.response));
            children.add(new Property("responseCode", "string", "The value of the HTTP response code to be tested.", 0, 1, this.responseCode));
            children.add(new Property("sourceId", "id", "Fixture to evaluate the XPath/JSONPath expression or the headerField  against.", 0, 1, this.sourceId));
            children.add(new Property("validateProfileId", "id", "The ID of the Profile to validate against.", 0, 1, this.validateProfileId));
            children.add(new Property("value", "string", "The value to compare to.", 0, 1, this.value));
            children.add(new Property("warningOnly", "boolean", "Whether or not the test execution will produce a warning only on error for this assert.", 0, 1, this.warningOnly));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "The label would be used for tracking/logging purposes by test engines.", 0, 1, this.label);
                }
                case -1724546052: {
                    return new Property(TestScript.SP_DESCRIPTION, "string", "The description would be used by test engines for tracking and reporting purposes.", 0, 1, this.description);
                }
                case -962590849: {
                    return new Property("direction", "code", "The direction to use for the assertion.", 0, 1, this.direction);
                }
                case 2081856758: {
                    return new Property("compareToSourceId", "string", "Id of the source fixture used as the contents to be evaluated by either the \"source/expression\" or \"sourceId/path\" definition.", 0, 1, this.compareToSourceId);
                }
                case -1415702669: {
                    return new Property("compareToSourceExpression", "string", "The FHIRPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.", 0, 1, this.compareToSourceExpression);
                }
                case -790206144: {
                    return new Property("compareToSourcePath", "string", "XPath or JSONPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.", 0, 1, this.compareToSourcePath);
                }
                case -389131437: {
                    return new Property("contentType", "code", "The mime-type contents to compare against the request or response message 'Content-Type' header.", 0, 1, this.contentType);
                }
                case -1795452264: {
                    return new Property("expression", "string", "The FHIRPath expression to be evaluated against the request or response message contents - HTTP headers and payload.", 0, 1, this.expression);
                }
                case 1160732269: {
                    return new Property("headerField", "string", "The HTTP header field name e.g. 'Location'.", 0, 1, this.headerField);
                }
                case 818925001: {
                    return new Property("minimumId", "string", "The ID of a fixture.  Asserts that the response contains at a minimum the fixture specified by minimumId.", 0, 1, this.minimumId);
                }
                case 1001488901: {
                    return new Property("navigationLinks", "boolean", "Whether or not the test execution performs validation on the bundle navigation links.", 0, 1, this.navigationLinks);
                }
                case -500553564: {
                    return new Property("operator", "code", "The operator type defines the conditional behavior of the assert. If not defined, the default is equals.", 0, 1, this.operator);
                }
                case 3433509: {
                    return new Property("path", "string", "The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.", 0, 1, this.path);
                }
                case 1217874000: {
                    return new Property("requestMethod", "code", "The request method or HTTP operation code to compare against that used by the client system under test.", 0, 1, this.requestMethod);
                }
                case 37099616: {
                    return new Property("requestURL", "string", "The value to use in a comparison against the request URL path string.", 0, 1, this.requestURL);
                }
                case -341064690: {
                    return new Property("resource", "code", "The type of the resource.  See http://build.fhir.org/resourcelist.html.", 0, 1, this.resource);
                }
                case -340323263: {
                    return new Property("response", "code", "okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.", 0, 1, this.response);
                }
                case 1438723534: {
                    return new Property("responseCode", "string", "The value of the HTTP response code to be tested.", 0, 1, this.responseCode);
                }
                case 1746327190: {
                    return new Property("sourceId", "id", "Fixture to evaluate the XPath/JSONPath expression or the headerField  against.", 0, 1, this.sourceId);
                }
                case 1555541038: {
                    return new Property("validateProfileId", "id", "The ID of the Profile to validate against.", 0, 1, this.validateProfileId);
                }
                case 111972721: {
                    return new Property("value", "string", "The value to compare to.", 0, 1, this.value);
                }
                case -481159832: {
                    return new Property("warningOnly", "boolean", "Whether or not the test execution will produce a warning only on error for this assert.", 0, 1, this.warningOnly);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -962590849: {
                    Base[] baseArray;
                    if (this.direction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.direction;
                    }
                    return baseArray;
                }
                case 2081856758: {
                    Base[] baseArray;
                    if (this.compareToSourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.compareToSourceId;
                    }
                    return baseArray;
                }
                case -1415702669: {
                    Base[] baseArray;
                    if (this.compareToSourceExpression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.compareToSourceExpression;
                    }
                    return baseArray;
                }
                case -790206144: {
                    Base[] baseArray;
                    if (this.compareToSourcePath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.compareToSourcePath;
                    }
                    return baseArray;
                }
                case -389131437: {
                    Base[] baseArray;
                    if (this.contentType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.contentType;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.expression;
                    }
                    return baseArray;
                }
                case 1160732269: {
                    Base[] baseArray;
                    if (this.headerField == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.headerField;
                    }
                    return baseArray;
                }
                case 818925001: {
                    Base[] baseArray;
                    if (this.minimumId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.minimumId;
                    }
                    return baseArray;
                }
                case 1001488901: {
                    Base[] baseArray;
                    if (this.navigationLinks == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.navigationLinks;
                    }
                    return baseArray;
                }
                case -500553564: {
                    Base[] baseArray;
                    if (this.operator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.operator;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.path;
                    }
                    return baseArray;
                }
                case 1217874000: {
                    Base[] baseArray;
                    if (this.requestMethod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.requestMethod;
                    }
                    return baseArray;
                }
                case 37099616: {
                    Base[] baseArray;
                    if (this.requestURL == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.requestURL;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray17 = new Base[1];
                        baseArray = baseArray17;
                        baseArray17[0] = this.resource;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray18 = new Base[1];
                        baseArray = baseArray18;
                        baseArray18[0] = this.response;
                    }
                    return baseArray;
                }
                case 1438723534: {
                    Base[] baseArray;
                    if (this.responseCode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray19 = new Base[1];
                        baseArray = baseArray19;
                        baseArray19[0] = this.responseCode;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray20 = new Base[1];
                        baseArray = baseArray20;
                        baseArray20[0] = this.sourceId;
                    }
                    return baseArray;
                }
                case 1555541038: {
                    Base[] baseArray;
                    if (this.validateProfileId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray21 = new Base[1];
                        baseArray = baseArray21;
                        baseArray21[0] = this.validateProfileId;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray22 = new Base[1];
                        baseArray = baseArray22;
                        baseArray22[0] = this.value;
                    }
                    return baseArray;
                }
                case -481159832: {
                    Base[] baseArray;
                    if (this.warningOnly == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray23 = new Base[1];
                        baseArray = baseArray23;
                        baseArray23[0] = this.warningOnly;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -962590849: {
                    value = new AssertionDirectionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.direction = value;
                    return value;
                }
                case 2081856758: {
                    this.compareToSourceId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1415702669: {
                    this.compareToSourceExpression = TypeConvertor.castToString(value);
                    return value;
                }
                case -790206144: {
                    this.compareToSourcePath = TypeConvertor.castToString(value);
                    return value;
                }
                case -389131437: {
                    this.contentType = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToString(value);
                    return value;
                }
                case 1160732269: {
                    this.headerField = TypeConvertor.castToString(value);
                    return value;
                }
                case 818925001: {
                    this.minimumId = TypeConvertor.castToString(value);
                    return value;
                }
                case 1001488901: {
                    this.navigationLinks = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -500553564: {
                    value = new AssertionOperatorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.operator = value;
                    return value;
                }
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case 1217874000: {
                    value = new TestScriptRequestMethodCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.requestMethod = value;
                    return value;
                }
                case 37099616: {
                    this.requestURL = TypeConvertor.castToString(value);
                    return value;
                }
                case -341064690: {
                    value = new FHIRDefinedTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resource = value;
                    return value;
                }
                case -340323263: {
                    value = new AssertionResponseTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.response = value;
                    return value;
                }
                case 1438723534: {
                    this.responseCode = TypeConvertor.castToString(value);
                    return value;
                }
                case 1746327190: {
                    this.sourceId = TypeConvertor.castToId(value);
                    return value;
                }
                case 1555541038: {
                    this.validateProfileId = TypeConvertor.castToId(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case -481159832: {
                    this.warningOnly = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = TypeConvertor.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("direction")) {
                value = new AssertionDirectionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.direction = value;
            } else if (name.equals("compareToSourceId")) {
                this.compareToSourceId = TypeConvertor.castToString(value);
            } else if (name.equals("compareToSourceExpression")) {
                this.compareToSourceExpression = TypeConvertor.castToString(value);
            } else if (name.equals("compareToSourcePath")) {
                this.compareToSourcePath = TypeConvertor.castToString(value);
            } else if (name.equals("contentType")) {
                this.contentType = TypeConvertor.castToCode(value);
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToString(value);
            } else if (name.equals("headerField")) {
                this.headerField = TypeConvertor.castToString(value);
            } else if (name.equals("minimumId")) {
                this.minimumId = TypeConvertor.castToString(value);
            } else if (name.equals("navigationLinks")) {
                this.navigationLinks = TypeConvertor.castToBoolean(value);
            } else if (name.equals("operator")) {
                value = new AssertionOperatorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.operator = value;
            } else if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("requestMethod")) {
                value = new TestScriptRequestMethodCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.requestMethod = value;
            } else if (name.equals("requestURL")) {
                this.requestURL = TypeConvertor.castToString(value);
            } else if (name.equals("resource")) {
                value = new FHIRDefinedTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resource = value;
            } else if (name.equals("response")) {
                value = new AssertionResponseTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.response = value;
            } else if (name.equals("responseCode")) {
                this.responseCode = TypeConvertor.castToString(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = TypeConvertor.castToId(value);
            } else if (name.equals("validateProfileId")) {
                this.validateProfileId = TypeConvertor.castToId(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("warningOnly")) {
                this.warningOnly = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -962590849: {
                    return this.getDirectionElement();
                }
                case 2081856758: {
                    return this.getCompareToSourceIdElement();
                }
                case -1415702669: {
                    return this.getCompareToSourceExpressionElement();
                }
                case -790206144: {
                    return this.getCompareToSourcePathElement();
                }
                case -389131437: {
                    return this.getContentTypeElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
                case 1160732269: {
                    return this.getHeaderFieldElement();
                }
                case 818925001: {
                    return this.getMinimumIdElement();
                }
                case 1001488901: {
                    return this.getNavigationLinksElement();
                }
                case -500553564: {
                    return this.getOperatorElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
                case 1217874000: {
                    return this.getRequestMethodElement();
                }
                case 37099616: {
                    return this.getRequestURLElement();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case -340323263: {
                    return this.getResponseElement();
                }
                case 1438723534: {
                    return this.getResponseCodeElement();
                }
                case 1746327190: {
                    return this.getSourceIdElement();
                }
                case 1555541038: {
                    return this.getValidateProfileIdElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case -481159832: {
                    return this.getWarningOnlyElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -962590849: {
                    return new String[]{"code"};
                }
                case 2081856758: {
                    return new String[]{"string"};
                }
                case -1415702669: {
                    return new String[]{"string"};
                }
                case -790206144: {
                    return new String[]{"string"};
                }
                case -389131437: {
                    return new String[]{"code"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
                case 1160732269: {
                    return new String[]{"string"};
                }
                case 818925001: {
                    return new String[]{"string"};
                }
                case 1001488901: {
                    return new String[]{"boolean"};
                }
                case -500553564: {
                    return new String[]{"code"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
                case 1217874000: {
                    return new String[]{"code"};
                }
                case 37099616: {
                    return new String[]{"string"};
                }
                case -341064690: {
                    return new String[]{"code"};
                }
                case -340323263: {
                    return new String[]{"code"};
                }
                case 1438723534: {
                    return new String[]{"string"};
                }
                case 1746327190: {
                    return new String[]{"id"};
                }
                case 1555541038: {
                    return new String[]{"id"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case -481159832: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.label");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.description");
            }
            if (name.equals("direction")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.direction");
            }
            if (name.equals("compareToSourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.compareToSourceId");
            }
            if (name.equals("compareToSourceExpression")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.compareToSourceExpression");
            }
            if (name.equals("compareToSourcePath")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.compareToSourcePath");
            }
            if (name.equals("contentType")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.contentType");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.expression");
            }
            if (name.equals("headerField")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.headerField");
            }
            if (name.equals("minimumId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.minimumId");
            }
            if (name.equals("navigationLinks")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.navigationLinks");
            }
            if (name.equals("operator")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.operator");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.path");
            }
            if (name.equals("requestMethod")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.requestMethod");
            }
            if (name.equals("requestURL")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.requestURL");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.resource");
            }
            if (name.equals("response")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.response");
            }
            if (name.equals("responseCode")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.responseCode");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.sourceId");
            }
            if (name.equals("validateProfileId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.validateProfileId");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.value");
            }
            if (name.equals("warningOnly")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.assert.warningOnly");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertComponent copy() {
            SetupActionAssertComponent dst = new SetupActionAssertComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SetupActionAssertComponent dst) {
            super.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.direction = this.direction == null ? null : this.direction.copy();
            dst.compareToSourceId = this.compareToSourceId == null ? null : this.compareToSourceId.copy();
            dst.compareToSourceExpression = this.compareToSourceExpression == null ? null : this.compareToSourceExpression.copy();
            dst.compareToSourcePath = this.compareToSourcePath == null ? null : this.compareToSourcePath.copy();
            dst.contentType = this.contentType == null ? null : this.contentType.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            dst.headerField = this.headerField == null ? null : this.headerField.copy();
            dst.minimumId = this.minimumId == null ? null : this.minimumId.copy();
            dst.navigationLinks = this.navigationLinks == null ? null : this.navigationLinks.copy();
            dst.operator = this.operator == null ? null : this.operator.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.requestMethod = this.requestMethod == null ? null : this.requestMethod.copy();
            dst.requestURL = this.requestURL == null ? null : this.requestURL.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.response = this.response == null ? null : this.response.copy();
            dst.responseCode = this.responseCode == null ? null : this.responseCode.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
            dst.validateProfileId = this.validateProfileId == null ? null : this.validateProfileId.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.warningOnly = this.warningOnly == null ? null : this.warningOnly.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionAssertComponent)) {
                return false;
            }
            SetupActionAssertComponent o = (SetupActionAssertComponent)other_;
            return SetupActionAssertComponent.compareDeep(this.label, o.label, true) && SetupActionAssertComponent.compareDeep(this.description, o.description, true) && SetupActionAssertComponent.compareDeep(this.direction, o.direction, true) && SetupActionAssertComponent.compareDeep(this.compareToSourceId, o.compareToSourceId, true) && SetupActionAssertComponent.compareDeep(this.compareToSourceExpression, o.compareToSourceExpression, true) && SetupActionAssertComponent.compareDeep(this.compareToSourcePath, o.compareToSourcePath, true) && SetupActionAssertComponent.compareDeep(this.contentType, o.contentType, true) && SetupActionAssertComponent.compareDeep(this.expression, o.expression, true) && SetupActionAssertComponent.compareDeep(this.headerField, o.headerField, true) && SetupActionAssertComponent.compareDeep(this.minimumId, o.minimumId, true) && SetupActionAssertComponent.compareDeep(this.navigationLinks, o.navigationLinks, true) && SetupActionAssertComponent.compareDeep(this.operator, o.operator, true) && SetupActionAssertComponent.compareDeep(this.path, o.path, true) && SetupActionAssertComponent.compareDeep(this.requestMethod, o.requestMethod, true) && SetupActionAssertComponent.compareDeep(this.requestURL, o.requestURL, true) && SetupActionAssertComponent.compareDeep(this.resource, o.resource, true) && SetupActionAssertComponent.compareDeep(this.response, o.response, true) && SetupActionAssertComponent.compareDeep(this.responseCode, o.responseCode, true) && SetupActionAssertComponent.compareDeep(this.sourceId, o.sourceId, true) && SetupActionAssertComponent.compareDeep(this.validateProfileId, o.validateProfileId, true) && SetupActionAssertComponent.compareDeep(this.value, o.value, true) && SetupActionAssertComponent.compareDeep(this.warningOnly, o.warningOnly, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionAssertComponent)) {
                return false;
            }
            SetupActionAssertComponent o = (SetupActionAssertComponent)other_;
            return SetupActionAssertComponent.compareValues(this.label, o.label, true) && SetupActionAssertComponent.compareValues(this.description, o.description, true) && SetupActionAssertComponent.compareValues(this.direction, o.direction, true) && SetupActionAssertComponent.compareValues(this.compareToSourceId, o.compareToSourceId, true) && SetupActionAssertComponent.compareValues(this.compareToSourceExpression, o.compareToSourceExpression, true) && SetupActionAssertComponent.compareValues(this.compareToSourcePath, o.compareToSourcePath, true) && SetupActionAssertComponent.compareValues(this.contentType, o.contentType, true) && SetupActionAssertComponent.compareValues(this.expression, o.expression, true) && SetupActionAssertComponent.compareValues(this.headerField, o.headerField, true) && SetupActionAssertComponent.compareValues(this.minimumId, o.minimumId, true) && SetupActionAssertComponent.compareValues(this.navigationLinks, o.navigationLinks, true) && SetupActionAssertComponent.compareValues(this.operator, o.operator, true) && SetupActionAssertComponent.compareValues(this.path, o.path, true) && SetupActionAssertComponent.compareValues(this.requestMethod, o.requestMethod, true) && SetupActionAssertComponent.compareValues(this.requestURL, o.requestURL, true) && SetupActionAssertComponent.compareValues(this.resource, o.resource, true) && SetupActionAssertComponent.compareValues(this.response, o.response, true) && SetupActionAssertComponent.compareValues(this.responseCode, o.responseCode, true) && SetupActionAssertComponent.compareValues(this.sourceId, o.sourceId, true) && SetupActionAssertComponent.compareValues(this.validateProfileId, o.validateProfileId, true) && SetupActionAssertComponent.compareValues(this.value, o.value, true) && SetupActionAssertComponent.compareValues(this.warningOnly, o.warningOnly, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.label, this.description, this.direction, this.compareToSourceId, this.compareToSourceExpression, this.compareToSourcePath, this.contentType, this.expression, this.headerField, this.minimumId, this.navigationLinks, this.operator, this.path, this.requestMethod, this.requestURL, this.resource, this.response, this.responseCode, this.sourceId, this.validateProfileId, this.value, this.warningOnly});
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert";
        }
    }

    @Block
    public static class SetupActionOperationRequestHeaderComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="field", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP header field name", formalDefinition="The HTTP header field e.g. \"Accept\".")
        protected StringType field;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP headerfield value", formalDefinition="The value of the header e.g. \"application/fhir+xml\".")
        protected StringType value;
        private static final long serialVersionUID = 274395337L;

        public SetupActionOperationRequestHeaderComponent() {
        }

        public SetupActionOperationRequestHeaderComponent(String field, String value) {
            this.setField(field);
            this.setValue(value);
        }

        public StringType getFieldElement() {
            if (this.field == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationRequestHeaderComponent.field");
                }
                if (Configuration.doAutoCreate()) {
                    this.field = new StringType();
                }
            }
            return this.field;
        }

        public boolean hasFieldElement() {
            return this.field != null && !this.field.isEmpty();
        }

        public boolean hasField() {
            return this.field != null && !this.field.isEmpty();
        }

        public SetupActionOperationRequestHeaderComponent setFieldElement(StringType value) {
            this.field = value;
            return this;
        }

        public String getField() {
            return this.field == null ? null : (String)this.field.getValue();
        }

        public SetupActionOperationRequestHeaderComponent setField(String value) {
            if (this.field == null) {
                this.field = new StringType();
            }
            this.field.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationRequestHeaderComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SetupActionOperationRequestHeaderComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SetupActionOperationRequestHeaderComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("field", "string", "The HTTP header field e.g. \"Accept\".", 0, 1, this.field));
            children.add(new Property("value", "string", "The value of the header e.g. \"application/fhir+xml\".", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 97427706: {
                    return new Property("field", "string", "The HTTP header field e.g. \"Accept\".", 0, 1, this.field);
                }
                case 111972721: {
                    return new Property("value", "string", "The value of the header e.g. \"application/fhir+xml\".", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    Base[] baseArray;
                    if (this.field == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.field;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    this.field = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("field")) {
                this.field = TypeConvertor.castToString(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    return this.getFieldElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("field")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.requestHeader.field");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.requestHeader.value");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionOperationRequestHeaderComponent copy() {
            SetupActionOperationRequestHeaderComponent dst = new SetupActionOperationRequestHeaderComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SetupActionOperationRequestHeaderComponent dst) {
            super.copyValues(dst);
            dst.field = this.field == null ? null : this.field.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionOperationRequestHeaderComponent)) {
                return false;
            }
            SetupActionOperationRequestHeaderComponent o = (SetupActionOperationRequestHeaderComponent)other_;
            return SetupActionOperationRequestHeaderComponent.compareDeep(this.field, o.field, true) && SetupActionOperationRequestHeaderComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionOperationRequestHeaderComponent)) {
                return false;
            }
            SetupActionOperationRequestHeaderComponent o = (SetupActionOperationRequestHeaderComponent)other_;
            return SetupActionOperationRequestHeaderComponent.compareValues(this.field, o.field, true) && SetupActionOperationRequestHeaderComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.field, this.value});
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.operation.requestHeader";
        }
    }

    @Block
    public static class SetupActionOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The operation code type that will be executed", formalDefinition="Server interaction or operation type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/testscript-operation-codes")
        protected Coding type;
        @Child(name="resource", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource type", formalDefinition="The type of the resource.  See http://build.fhir.org/resourcelist.html.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected Enumeration<FHIRDefinedType> resource;
        @Child(name="label", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging operation label", formalDefinition="The label would be used for tracking/logging purposes by test engines.")
        protected StringType label;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting operation description", formalDefinition="The description would be used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="accept", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Mime type to accept in the payload of the response, with charset etc.", formalDefinition="The mime-type to use for RESTful operation in the 'Accept' header.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
        protected CodeType accept;
        @Child(name="contentType", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Mime type of the request payload contents, with charset etc.", formalDefinition="The mime-type to use for RESTful operation in the 'Content-Type' header.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
        protected CodeType contentType;
        @Child(name="destination", type={IntegerType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server responding to the request", formalDefinition="The server where the request message is destined for.  Must be one of the server numbers listed in TestScript.destination section.")
        protected IntegerType destination;
        @Child(name="encodeRequestUrl", type={BooleanType.class}, order=8, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not to send the request url in encoded format", formalDefinition="Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.")
        protected BooleanType encodeRequestUrl;
        @Child(name="method", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="delete | get | options | patch | post | put | head", formalDefinition="The HTTP method the test engine MUST use for this operation regardless of any other operation details.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/http-operations")
        protected Enumeration<TestScriptRequestMethodCode> method;
        @Child(name="origin", type={IntegerType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server initiating the request", formalDefinition="The server where the request message originates from.  Must be one of the server numbers listed in TestScript.origin section.")
        protected IntegerType origin;
        @Child(name="params", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explicitly defined path parameters", formalDefinition="Path plus parameters after [type].  Used to set parts of the request URL explicitly.")
        protected StringType params;
        @Child(name="requestHeader", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Each operation can have one or more header elements", formalDefinition="Header elements would be used to set HTTP headers.")
        protected List<SetupActionOperationRequestHeaderComponent> requestHeader;
        @Child(name="requestId", type={IdType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of mapped request", formalDefinition="The fixture id (maybe new) to map to the request.")
        protected IdType requestId;
        @Child(name="responseId", type={IdType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of mapped response", formalDefinition="The fixture id (maybe new) to map to the response.")
        protected IdType responseId;
        @Child(name="sourceId", type={IdType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of body for PUT and POST requests", formalDefinition="The id of the fixture used as the body of a PUT or POST request.")
        protected IdType sourceId;
        @Child(name="targetId", type={IdType.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of fixture used for extracting the [id],  [type], and [vid] for GET requests", formalDefinition="Id of fixture used for extracting the [id],  [type], and [vid] for GET requests.")
        protected IdType targetId;
        @Child(name="url", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Request URL", formalDefinition="Complete request URL.")
        protected StringType url;
        private static final long serialVersionUID = -1301448722L;

        public SetupActionOperationComponent() {
        }

        public SetupActionOperationComponent(boolean encodeRequestUrl) {
            this.setEncodeRequestUrl(encodeRequestUrl);
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SetupActionOperationComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Enumeration<FHIRDefinedType> getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Enumeration<FHIRDefinedType>(new FHIRDefinedTypeEnumFactory());
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SetupActionOperationComponent setResourceElement(Enumeration<FHIRDefinedType> value) {
            this.resource = value;
            return this;
        }

        public FHIRDefinedType getResource() {
            return this.resource == null ? null : (FHIRDefinedType)((Object)this.resource.getValue());
        }

        public SetupActionOperationComponent setResource(FHIRDefinedType value) {
            if (value == null) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new Enumeration<FHIRDefinedType>(new FHIRDefinedTypeEnumFactory());
                }
                this.resource.setValue((Object)value);
            }
            return this;
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public SetupActionOperationComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public SetupActionOperationComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SetupActionOperationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SetupActionOperationComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeType getAcceptElement() {
            if (this.accept == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.accept");
                }
                if (Configuration.doAutoCreate()) {
                    this.accept = new CodeType();
                }
            }
            return this.accept;
        }

        public boolean hasAcceptElement() {
            return this.accept != null && !this.accept.isEmpty();
        }

        public boolean hasAccept() {
            return this.accept != null && !this.accept.isEmpty();
        }

        public SetupActionOperationComponent setAcceptElement(CodeType value) {
            this.accept = value;
            return this;
        }

        public String getAccept() {
            return this.accept == null ? null : (String)this.accept.getValue();
        }

        public SetupActionOperationComponent setAccept(String value) {
            if (Utilities.noString((String)value)) {
                this.accept = null;
            } else {
                if (this.accept == null) {
                    this.accept = new CodeType();
                }
                this.accept.setValue(value);
            }
            return this;
        }

        public CodeType getContentTypeElement() {
            if (this.contentType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.contentType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contentType = new CodeType();
                }
            }
            return this.contentType;
        }

        public boolean hasContentTypeElement() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public boolean hasContentType() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public SetupActionOperationComponent setContentTypeElement(CodeType value) {
            this.contentType = value;
            return this;
        }

        public String getContentType() {
            return this.contentType == null ? null : (String)this.contentType.getValue();
        }

        public SetupActionOperationComponent setContentType(String value) {
            if (Utilities.noString((String)value)) {
                this.contentType = null;
            } else {
                if (this.contentType == null) {
                    this.contentType = new CodeType();
                }
                this.contentType.setValue(value);
            }
            return this;
        }

        public IntegerType getDestinationElement() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new IntegerType();
                }
            }
            return this.destination;
        }

        public boolean hasDestinationElement() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public SetupActionOperationComponent setDestinationElement(IntegerType value) {
            this.destination = value;
            return this;
        }

        public int getDestination() {
            return this.destination == null || this.destination.isEmpty() ? 0 : (Integer)this.destination.getValue();
        }

        public SetupActionOperationComponent setDestination(int value) {
            if (this.destination == null) {
                this.destination = new IntegerType();
            }
            this.destination.setValue((Object)value);
            return this;
        }

        public BooleanType getEncodeRequestUrlElement() {
            if (this.encodeRequestUrl == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.encodeRequestUrl");
                }
                if (Configuration.doAutoCreate()) {
                    this.encodeRequestUrl = new BooleanType();
                }
            }
            return this.encodeRequestUrl;
        }

        public boolean hasEncodeRequestUrlElement() {
            return this.encodeRequestUrl != null && !this.encodeRequestUrl.isEmpty();
        }

        public boolean hasEncodeRequestUrl() {
            return this.encodeRequestUrl != null && !this.encodeRequestUrl.isEmpty();
        }

        public SetupActionOperationComponent setEncodeRequestUrlElement(BooleanType value) {
            this.encodeRequestUrl = value;
            return this;
        }

        public boolean getEncodeRequestUrl() {
            return this.encodeRequestUrl == null || this.encodeRequestUrl.isEmpty() ? false : (Boolean)this.encodeRequestUrl.getValue();
        }

        public SetupActionOperationComponent setEncodeRequestUrl(boolean value) {
            if (this.encodeRequestUrl == null) {
                this.encodeRequestUrl = new BooleanType();
            }
            this.encodeRequestUrl.setValue((Object)value);
            return this;
        }

        public Enumeration<TestScriptRequestMethodCode> getMethodElement() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new Enumeration<TestScriptRequestMethodCode>(new TestScriptRequestMethodCodeEnumFactory());
                }
            }
            return this.method;
        }

        public boolean hasMethodElement() {
            return this.method != null && !this.method.isEmpty();
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SetupActionOperationComponent setMethodElement(Enumeration<TestScriptRequestMethodCode> value) {
            this.method = value;
            return this;
        }

        public TestScriptRequestMethodCode getMethod() {
            return this.method == null ? null : (TestScriptRequestMethodCode)((Object)this.method.getValue());
        }

        public SetupActionOperationComponent setMethod(TestScriptRequestMethodCode value) {
            if (value == null) {
                this.method = null;
            } else {
                if (this.method == null) {
                    this.method = new Enumeration<TestScriptRequestMethodCode>(new TestScriptRequestMethodCodeEnumFactory());
                }
                this.method.setValue((Object)value);
            }
            return this;
        }

        public IntegerType getOriginElement() {
            if (this.origin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.origin = new IntegerType();
                }
            }
            return this.origin;
        }

        public boolean hasOriginElement() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public boolean hasOrigin() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public SetupActionOperationComponent setOriginElement(IntegerType value) {
            this.origin = value;
            return this;
        }

        public int getOrigin() {
            return this.origin == null || this.origin.isEmpty() ? 0 : (Integer)this.origin.getValue();
        }

        public SetupActionOperationComponent setOrigin(int value) {
            if (this.origin == null) {
                this.origin = new IntegerType();
            }
            this.origin.setValue((Object)value);
            return this;
        }

        public StringType getParamsElement() {
            if (this.params == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.params");
                }
                if (Configuration.doAutoCreate()) {
                    this.params = new StringType();
                }
            }
            return this.params;
        }

        public boolean hasParamsElement() {
            return this.params != null && !this.params.isEmpty();
        }

        public boolean hasParams() {
            return this.params != null && !this.params.isEmpty();
        }

        public SetupActionOperationComponent setParamsElement(StringType value) {
            this.params = value;
            return this;
        }

        public String getParams() {
            return this.params == null ? null : (String)this.params.getValue();
        }

        public SetupActionOperationComponent setParams(String value) {
            if (Utilities.noString((String)value)) {
                this.params = null;
            } else {
                if (this.params == null) {
                    this.params = new StringType();
                }
                this.params.setValue(value);
            }
            return this;
        }

        public List<SetupActionOperationRequestHeaderComponent> getRequestHeader() {
            if (this.requestHeader == null) {
                this.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
            }
            return this.requestHeader;
        }

        public SetupActionOperationComponent setRequestHeader(List<SetupActionOperationRequestHeaderComponent> theRequestHeader) {
            this.requestHeader = theRequestHeader;
            return this;
        }

        public boolean hasRequestHeader() {
            if (this.requestHeader == null) {
                return false;
            }
            for (SetupActionOperationRequestHeaderComponent item : this.requestHeader) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionOperationRequestHeaderComponent addRequestHeader() {
            SetupActionOperationRequestHeaderComponent t = new SetupActionOperationRequestHeaderComponent();
            if (this.requestHeader == null) {
                this.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
            }
            this.requestHeader.add(t);
            return t;
        }

        public SetupActionOperationComponent addRequestHeader(SetupActionOperationRequestHeaderComponent t) {
            if (t == null) {
                return this;
            }
            if (this.requestHeader == null) {
                this.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
            }
            this.requestHeader.add(t);
            return this;
        }

        public SetupActionOperationRequestHeaderComponent getRequestHeaderFirstRep() {
            if (this.getRequestHeader().isEmpty()) {
                this.addRequestHeader();
            }
            return this.getRequestHeader().get(0);
        }

        public IdType getRequestIdElement() {
            if (this.requestId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.requestId");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestId = new IdType();
                }
            }
            return this.requestId;
        }

        public boolean hasRequestIdElement() {
            return this.requestId != null && !this.requestId.isEmpty();
        }

        public boolean hasRequestId() {
            return this.requestId != null && !this.requestId.isEmpty();
        }

        public SetupActionOperationComponent setRequestIdElement(IdType value) {
            this.requestId = value;
            return this;
        }

        public String getRequestId() {
            return this.requestId == null ? null : this.requestId.getValue();
        }

        public SetupActionOperationComponent setRequestId(String value) {
            if (Utilities.noString((String)value)) {
                this.requestId = null;
            } else {
                if (this.requestId == null) {
                    this.requestId = new IdType();
                }
                this.requestId.setValue(value);
            }
            return this;
        }

        public IdType getResponseIdElement() {
            if (this.responseId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.responseId");
                }
                if (Configuration.doAutoCreate()) {
                    this.responseId = new IdType();
                }
            }
            return this.responseId;
        }

        public boolean hasResponseIdElement() {
            return this.responseId != null && !this.responseId.isEmpty();
        }

        public boolean hasResponseId() {
            return this.responseId != null && !this.responseId.isEmpty();
        }

        public SetupActionOperationComponent setResponseIdElement(IdType value) {
            this.responseId = value;
            return this;
        }

        public String getResponseId() {
            return this.responseId == null ? null : this.responseId.getValue();
        }

        public SetupActionOperationComponent setResponseId(String value) {
            if (Utilities.noString((String)value)) {
                this.responseId = null;
            } else {
                if (this.responseId == null) {
                    this.responseId = new IdType();
                }
                this.responseId.setValue(value);
            }
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public SetupActionOperationComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public SetupActionOperationComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new IdType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        public IdType getTargetIdElement() {
            if (this.targetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.targetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetId = new IdType();
                }
            }
            return this.targetId;
        }

        public boolean hasTargetIdElement() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public boolean hasTargetId() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public SetupActionOperationComponent setTargetIdElement(IdType value) {
            this.targetId = value;
            return this;
        }

        public String getTargetId() {
            return this.targetId == null ? null : this.targetId.getValue();
        }

        public SetupActionOperationComponent setTargetId(String value) {
            if (Utilities.noString((String)value)) {
                this.targetId = null;
            } else {
                if (this.targetId == null) {
                    this.targetId = new IdType();
                }
                this.targetId.setValue(value);
            }
            return this;
        }

        public StringType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new StringType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public SetupActionOperationComponent setUrlElement(StringType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public SetupActionOperationComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new StringType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "Coding", "Server interaction or operation type.", 0, 1, this.type));
            children.add(new Property("resource", "code", "The type of the resource.  See http://build.fhir.org/resourcelist.html.", 0, 1, this.resource));
            children.add(new Property("label", "string", "The label would be used for tracking/logging purposes by test engines.", 0, 1, this.label));
            children.add(new Property(TestScript.SP_DESCRIPTION, "string", "The description would be used by test engines for tracking and reporting purposes.", 0, 1, this.description));
            children.add(new Property("accept", "code", "The mime-type to use for RESTful operation in the 'Accept' header.", 0, 1, this.accept));
            children.add(new Property("contentType", "code", "The mime-type to use for RESTful operation in the 'Content-Type' header.", 0, 1, this.contentType));
            children.add(new Property("destination", "integer", "The server where the request message is destined for.  Must be one of the server numbers listed in TestScript.destination section.", 0, 1, this.destination));
            children.add(new Property("encodeRequestUrl", "boolean", "Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.", 0, 1, this.encodeRequestUrl));
            children.add(new Property("method", "code", "The HTTP method the test engine MUST use for this operation regardless of any other operation details.", 0, 1, this.method));
            children.add(new Property("origin", "integer", "The server where the request message originates from.  Must be one of the server numbers listed in TestScript.origin section.", 0, 1, this.origin));
            children.add(new Property("params", "string", "Path plus parameters after [type].  Used to set parts of the request URL explicitly.", 0, 1, this.params));
            children.add(new Property("requestHeader", "", "Header elements would be used to set HTTP headers.", 0, Integer.MAX_VALUE, this.requestHeader));
            children.add(new Property("requestId", "id", "The fixture id (maybe new) to map to the request.", 0, 1, this.requestId));
            children.add(new Property("responseId", "id", "The fixture id (maybe new) to map to the response.", 0, 1, this.responseId));
            children.add(new Property("sourceId", "id", "The id of the fixture used as the body of a PUT or POST request.", 0, 1, this.sourceId));
            children.add(new Property("targetId", "id", "Id of fixture used for extracting the [id],  [type], and [vid] for GET requests.", 0, 1, this.targetId));
            children.add(new Property(TestScript.SP_URL, "string", "Complete request URL.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "Coding", "Server interaction or operation type.", 0, 1, this.type);
                }
                case -341064690: {
                    return new Property("resource", "code", "The type of the resource.  See http://build.fhir.org/resourcelist.html.", 0, 1, this.resource);
                }
                case 102727412: {
                    return new Property("label", "string", "The label would be used for tracking/logging purposes by test engines.", 0, 1, this.label);
                }
                case -1724546052: {
                    return new Property(TestScript.SP_DESCRIPTION, "string", "The description would be used by test engines for tracking and reporting purposes.", 0, 1, this.description);
                }
                case -1423461112: {
                    return new Property("accept", "code", "The mime-type to use for RESTful operation in the 'Accept' header.", 0, 1, this.accept);
                }
                case -389131437: {
                    return new Property("contentType", "code", "The mime-type to use for RESTful operation in the 'Content-Type' header.", 0, 1, this.contentType);
                }
                case -1429847026: {
                    return new Property("destination", "integer", "The server where the request message is destined for.  Must be one of the server numbers listed in TestScript.destination section.", 0, 1, this.destination);
                }
                case -1760554218: {
                    return new Property("encodeRequestUrl", "boolean", "Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.", 0, 1, this.encodeRequestUrl);
                }
                case -1077554975: {
                    return new Property("method", "code", "The HTTP method the test engine MUST use for this operation regardless of any other operation details.", 0, 1, this.method);
                }
                case -1008619738: {
                    return new Property("origin", "integer", "The server where the request message originates from.  Must be one of the server numbers listed in TestScript.origin section.", 0, 1, this.origin);
                }
                case -995427962: {
                    return new Property("params", "string", "Path plus parameters after [type].  Used to set parts of the request URL explicitly.", 0, 1, this.params);
                }
                case 1074158076: {
                    return new Property("requestHeader", "", "Header elements would be used to set HTTP headers.", 0, Integer.MAX_VALUE, this.requestHeader);
                }
                case 693933066: {
                    return new Property("requestId", "id", "The fixture id (maybe new) to map to the request.", 0, 1, this.requestId);
                }
                case -633138884: {
                    return new Property("responseId", "id", "The fixture id (maybe new) to map to the response.", 0, 1, this.responseId);
                }
                case 1746327190: {
                    return new Property("sourceId", "id", "The id of the fixture used as the body of a PUT or POST request.", 0, 1, this.sourceId);
                }
                case -441951604: {
                    return new Property("targetId", "id", "Id of fixture used for extracting the [id],  [type], and [vid] for GET requests.", 0, 1, this.targetId);
                }
                case 116079: {
                    return new Property(TestScript.SP_URL, "string", "Complete request URL.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.label;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -1423461112: {
                    Base[] baseArray;
                    if (this.accept == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.accept;
                    }
                    return baseArray;
                }
                case -389131437: {
                    Base[] baseArray;
                    if (this.contentType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.contentType;
                    }
                    return baseArray;
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.destination;
                    }
                    return baseArray;
                }
                case -1760554218: {
                    Base[] baseArray;
                    if (this.encodeRequestUrl == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.encodeRequestUrl;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.method;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    Base[] baseArray;
                    if (this.origin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.origin;
                    }
                    return baseArray;
                }
                case -995427962: {
                    Base[] baseArray;
                    if (this.params == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.params;
                    }
                    return baseArray;
                }
                case 1074158076: {
                    return this.requestHeader == null ? new Base[]{} : this.requestHeader.toArray(new Base[this.requestHeader.size()]);
                }
                case 693933066: {
                    Base[] baseArray;
                    if (this.requestId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.requestId;
                    }
                    return baseArray;
                }
                case -633138884: {
                    Base[] baseArray;
                    if (this.responseId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.responseId;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.sourceId;
                    }
                    return baseArray;
                }
                case -441951604: {
                    Base[] baseArray;
                    if (this.targetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.targetId;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray17 = new Base[1];
                        baseArray = baseArray17;
                        baseArray17[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -341064690: {
                    value = new FHIRDefinedTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resource = value;
                    return value;
                }
                case 102727412: {
                    this.label = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1423461112: {
                    this.accept = TypeConvertor.castToCode(value);
                    return value;
                }
                case -389131437: {
                    this.contentType = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1429847026: {
                    this.destination = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -1760554218: {
                    this.encodeRequestUrl = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1077554975: {
                    value = new TestScriptRequestMethodCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.method = value;
                    return value;
                }
                case -1008619738: {
                    this.origin = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -995427962: {
                    this.params = TypeConvertor.castToString(value);
                    return value;
                }
                case 1074158076: {
                    this.getRequestHeader().add((SetupActionOperationRequestHeaderComponent)((Object)value));
                    return value;
                }
                case 693933066: {
                    this.requestId = TypeConvertor.castToId(value);
                    return value;
                }
                case -633138884: {
                    this.responseId = TypeConvertor.castToId(value);
                    return value;
                }
                case 1746327190: {
                    this.sourceId = TypeConvertor.castToId(value);
                    return value;
                }
                case -441951604: {
                    this.targetId = TypeConvertor.castToId(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCoding(value);
            } else if (name.equals("resource")) {
                value = new FHIRDefinedTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resource = value;
            } else if (name.equals("label")) {
                this.label = TypeConvertor.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("accept")) {
                this.accept = TypeConvertor.castToCode(value);
            } else if (name.equals("contentType")) {
                this.contentType = TypeConvertor.castToCode(value);
            } else if (name.equals("destination")) {
                this.destination = TypeConvertor.castToInteger(value);
            } else if (name.equals("encodeRequestUrl")) {
                this.encodeRequestUrl = TypeConvertor.castToBoolean(value);
            } else if (name.equals("method")) {
                value = new TestScriptRequestMethodCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.method = value;
            } else if (name.equals("origin")) {
                this.origin = TypeConvertor.castToInteger(value);
            } else if (name.equals("params")) {
                this.params = TypeConvertor.castToString(value);
            } else if (name.equals("requestHeader")) {
                this.getRequestHeader().add((SetupActionOperationRequestHeaderComponent)((Object)value));
            } else if (name.equals("requestId")) {
                this.requestId = TypeConvertor.castToId(value);
            } else if (name.equals("responseId")) {
                this.responseId = TypeConvertor.castToId(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = TypeConvertor.castToId(value);
            } else if (name.equals("targetId")) {
                this.targetId = TypeConvertor.castToId(value);
            } else if (name.equals(TestScript.SP_URL)) {
                this.url = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case 102727412: {
                    return this.getLabelElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1423461112: {
                    return this.getAcceptElement();
                }
                case -389131437: {
                    return this.getContentTypeElement();
                }
                case -1429847026: {
                    return this.getDestinationElement();
                }
                case -1760554218: {
                    return this.getEncodeRequestUrlElement();
                }
                case -1077554975: {
                    return this.getMethodElement();
                }
                case -1008619738: {
                    return this.getOriginElement();
                }
                case -995427962: {
                    return this.getParamsElement();
                }
                case 1074158076: {
                    return this.addRequestHeader();
                }
                case 693933066: {
                    return this.getRequestIdElement();
                }
                case -633138884: {
                    return this.getResponseIdElement();
                }
                case 1746327190: {
                    return this.getSourceIdElement();
                }
                case -441951604: {
                    return this.getTargetIdElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case -341064690: {
                    return new String[]{"code"};
                }
                case 102727412: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1423461112: {
                    return new String[]{"code"};
                }
                case -389131437: {
                    return new String[]{"code"};
                }
                case -1429847026: {
                    return new String[]{"integer"};
                }
                case -1760554218: {
                    return new String[]{"boolean"};
                }
                case -1077554975: {
                    return new String[]{"code"};
                }
                case -1008619738: {
                    return new String[]{"integer"};
                }
                case -995427962: {
                    return new String[]{"string"};
                }
                case 1074158076: {
                    return new String[0];
                }
                case 693933066: {
                    return new String[]{"id"};
                }
                case -633138884: {
                    return new String[]{"id"};
                }
                case 1746327190: {
                    return new String[]{"id"};
                }
                case -441951604: {
                    return new String[]{"id"};
                }
                case 116079: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.resource");
            }
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.label");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.description");
            }
            if (name.equals("accept")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.accept");
            }
            if (name.equals("contentType")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.contentType");
            }
            if (name.equals("destination")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.destination");
            }
            if (name.equals("encodeRequestUrl")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.encodeRequestUrl");
            }
            if (name.equals("method")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.method");
            }
            if (name.equals("origin")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.origin");
            }
            if (name.equals("params")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.params");
            }
            if (name.equals("requestHeader")) {
                return this.addRequestHeader();
            }
            if (name.equals("requestId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.requestId");
            }
            if (name.equals("responseId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.responseId");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.sourceId");
            }
            if (name.equals("targetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.targetId");
            }
            if (name.equals(TestScript.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.setup.action.operation.url");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionOperationComponent copy() {
            SetupActionOperationComponent dst = new SetupActionOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SetupActionOperationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.label = this.label == null ? null : this.label.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.accept = this.accept == null ? null : this.accept.copy();
            dst.contentType = this.contentType == null ? null : this.contentType.copy();
            dst.destination = this.destination == null ? null : this.destination.copy();
            dst.encodeRequestUrl = this.encodeRequestUrl == null ? null : this.encodeRequestUrl.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.origin = this.origin == null ? null : this.origin.copy();
            StringType stringType = dst.params = this.params == null ? null : this.params.copy();
            if (this.requestHeader != null) {
                dst.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
                for (SetupActionOperationRequestHeaderComponent i : this.requestHeader) {
                    dst.requestHeader.add(i.copy());
                }
            }
            dst.requestId = this.requestId == null ? null : this.requestId.copy();
            dst.responseId = this.responseId == null ? null : this.responseId.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
            dst.targetId = this.targetId == null ? null : this.targetId.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionOperationComponent)) {
                return false;
            }
            SetupActionOperationComponent o = (SetupActionOperationComponent)other_;
            return SetupActionOperationComponent.compareDeep(this.type, o.type, true) && SetupActionOperationComponent.compareDeep(this.resource, o.resource, true) && SetupActionOperationComponent.compareDeep(this.label, o.label, true) && SetupActionOperationComponent.compareDeep(this.description, o.description, true) && SetupActionOperationComponent.compareDeep(this.accept, o.accept, true) && SetupActionOperationComponent.compareDeep(this.contentType, o.contentType, true) && SetupActionOperationComponent.compareDeep(this.destination, o.destination, true) && SetupActionOperationComponent.compareDeep(this.encodeRequestUrl, o.encodeRequestUrl, true) && SetupActionOperationComponent.compareDeep(this.method, o.method, true) && SetupActionOperationComponent.compareDeep(this.origin, o.origin, true) && SetupActionOperationComponent.compareDeep(this.params, o.params, true) && SetupActionOperationComponent.compareDeep(this.requestHeader, o.requestHeader, true) && SetupActionOperationComponent.compareDeep(this.requestId, o.requestId, true) && SetupActionOperationComponent.compareDeep(this.responseId, o.responseId, true) && SetupActionOperationComponent.compareDeep(this.sourceId, o.sourceId, true) && SetupActionOperationComponent.compareDeep(this.targetId, o.targetId, true) && SetupActionOperationComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionOperationComponent)) {
                return false;
            }
            SetupActionOperationComponent o = (SetupActionOperationComponent)other_;
            return SetupActionOperationComponent.compareValues(this.resource, o.resource, true) && SetupActionOperationComponent.compareValues(this.label, o.label, true) && SetupActionOperationComponent.compareValues(this.description, o.description, true) && SetupActionOperationComponent.compareValues(this.accept, o.accept, true) && SetupActionOperationComponent.compareValues(this.contentType, o.contentType, true) && SetupActionOperationComponent.compareValues(this.destination, o.destination, true) && SetupActionOperationComponent.compareValues(this.encodeRequestUrl, o.encodeRequestUrl, true) && SetupActionOperationComponent.compareValues(this.method, o.method, true) && SetupActionOperationComponent.compareValues(this.origin, o.origin, true) && SetupActionOperationComponent.compareValues(this.params, o.params, true) && SetupActionOperationComponent.compareValues(this.requestId, o.requestId, true) && SetupActionOperationComponent.compareValues(this.responseId, o.responseId, true) && SetupActionOperationComponent.compareValues(this.sourceId, o.sourceId, true) && SetupActionOperationComponent.compareValues(this.targetId, o.targetId, true) && SetupActionOperationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.resource, this.label, this.description, this.accept, this.contentType, this.destination, this.encodeRequestUrl, this.method, this.origin, this.params, this.requestHeader, this.requestId, this.responseId, this.sourceId, this.targetId, this.url});
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.operation";
        }
    }

    @Block
    public static class SetupActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The setup operation to perform", formalDefinition="The operation to perform.")
        protected SetupActionOperationComponent operation;
        @Child(name="assert", type={}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The assertion to perform", formalDefinition="Evaluates the results of previous operations to determine if the server under test behaves appropriately.")
        protected SetupActionAssertComponent assert_;
        private static final long serialVersionUID = -252088305L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public SetupActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        public SetupActionAssertComponent getAssert() {
            if (this.assert_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionComponent.assert_");
                }
                if (Configuration.doAutoCreate()) {
                    this.assert_ = new SetupActionAssertComponent();
                }
            }
            return this.assert_;
        }

        public boolean hasAssert() {
            return this.assert_ != null && !this.assert_.isEmpty();
        }

        public SetupActionComponent setAssert(SetupActionAssertComponent value) {
            this.assert_ = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operation", "", "The operation to perform.", 0, 1, this.operation));
            children.add(new Property("assert", "", "Evaluates the results of previous operations to determine if the server under test behaves appropriately.", 0, 1, this.assert_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1662702951: {
                    return new Property("operation", "", "The operation to perform.", 0, 1, this.operation);
                }
                case -1408208058: {
                    return new Property("assert", "", "Evaluates the results of previous operations to determine if the server under test behaves appropriately.", 0, 1, this.assert_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
                case -1408208058: {
                    Base[] baseArray;
                    if (this.assert_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.assert_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    return value;
                }
                case -1408208058: {
                    this.assert_ = (SetupActionAssertComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else if (name.equals("assert")) {
                this.assert_ = (SetupActionAssertComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
                case -1408208058: {
                    return this.getAssert();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return new String[0];
                }
                case -1408208058: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            if (name.equals("assert")) {
                this.assert_ = new SetupActionAssertComponent();
                return this.assert_;
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionComponent copy() {
            SetupActionComponent dst = new SetupActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SetupActionComponent dst) {
            super.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            dst.assert_ = this.assert_ == null ? null : this.assert_.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionComponent)) {
                return false;
            }
            SetupActionComponent o = (SetupActionComponent)other_;
            return SetupActionComponent.compareDeep(this.operation, o.operation, true) && SetupActionComponent.compareDeep(this.assert_, o.assert_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SetupActionComponent)) {
                return false;
            }
            SetupActionComponent o = (SetupActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.operation, this.assert_});
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action";
        }
    }

    @Block
    public static class TestScriptSetupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A setup operation or assert to perform", formalDefinition="Action would contain either an operation or an assertion.")
        protected List<SetupActionComponent> action;
        private static final long serialVersionUID = -123374486L;

        public TestScriptSetupComponent() {
        }

        public TestScriptSetupComponent(SetupActionComponent action) {
            this.addAction(action);
        }

        public List<SetupActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            return this.action;
        }

        public TestScriptSetupComponent setAction(List<SetupActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (SetupActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionComponent addAction() {
            SetupActionComponent t = new SetupActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestScriptSetupComponent addAction(SetupActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public SetupActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.getAction().add((SetupActionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("action")) {
                return super.setProperty(name, value);
            }
            this.getAction().add((SetupActionComponent)value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptSetupComponent copy() {
            TestScriptSetupComponent dst = new TestScriptSetupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptSetupComponent dst) {
            super.copyValues(dst);
            if (this.action != null) {
                dst.action = new ArrayList<SetupActionComponent>();
                for (SetupActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptSetupComponent)) {
                return false;
            }
            TestScriptSetupComponent o = (TestScriptSetupComponent)other_;
            return TestScriptSetupComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptSetupComponent)) {
                return false;
            }
            TestScriptSetupComponent o = (TestScriptSetupComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.action);
        }

        @Override
        public String fhirType() {
            return "TestScript.setup";
        }
    }

    @Block
    public static class TestScriptVariableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Descriptive name for this variable", formalDefinition="Descriptive name for this variable.")
        protected StringType name;
        @Child(name="defaultValue", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Default, hard-coded, or user-defined value for this variable", formalDefinition="A default, hard-coded, or user-defined value for this variable.")
        protected StringType defaultValue;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the variable", formalDefinition="A free text natural language description of the variable and its purpose.")
        protected StringType description;
        @Child(name="expression", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The FHIRPath expression against the fixture body", formalDefinition="The FHIRPath expression to evaluate against the fixture body. When variables are defined, only one of either expression, headerField or path must be specified.")
        protected StringType expression;
        @Child(name="headerField", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP header field name for source", formalDefinition="Will be used to grab the HTTP header field value from the headers that sourceId is pointing to.")
        protected StringType headerField;
        @Child(name="hint", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Hint help text for default value to enter", formalDefinition="Displayable text string with hint help information to the user when entering a default value.")
        protected StringType hint;
        @Child(name="path", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="XPath or JSONPath against the fixture body", formalDefinition="XPath or JSONPath to evaluate against the fixture body.  When variables are defined, only one of either expression, headerField or path must be specified.")
        protected StringType path;
        @Child(name="sourceId", type={IdType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of source expression or headerField within this variable", formalDefinition="Fixture to evaluate the XPath/JSONPath expression or the headerField  against within this variable.")
        protected IdType sourceId;
        private static final long serialVersionUID = -1592325432L;

        public TestScriptVariableComponent() {
        }

        public TestScriptVariableComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptVariableComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptVariableComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDefaultValueElement() {
            if (this.defaultValue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.defaultValue");
                }
                if (Configuration.doAutoCreate()) {
                    this.defaultValue = new StringType();
                }
            }
            return this.defaultValue;
        }

        public boolean hasDefaultValueElement() {
            return this.defaultValue != null && !this.defaultValue.isEmpty();
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null && !this.defaultValue.isEmpty();
        }

        public TestScriptVariableComponent setDefaultValueElement(StringType value) {
            this.defaultValue = value;
            return this;
        }

        public String getDefaultValue() {
            return this.defaultValue == null ? null : (String)this.defaultValue.getValue();
        }

        public TestScriptVariableComponent setDefaultValue(String value) {
            if (Utilities.noString((String)value)) {
                this.defaultValue = null;
            } else {
                if (this.defaultValue == null) {
                    this.defaultValue = new StringType();
                }
                this.defaultValue.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptVariableComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptVariableComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public TestScriptVariableComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public TestScriptVariableComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        public StringType getHeaderFieldElement() {
            if (this.headerField == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.headerField");
                }
                if (Configuration.doAutoCreate()) {
                    this.headerField = new StringType();
                }
            }
            return this.headerField;
        }

        public boolean hasHeaderFieldElement() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public boolean hasHeaderField() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public TestScriptVariableComponent setHeaderFieldElement(StringType value) {
            this.headerField = value;
            return this;
        }

        public String getHeaderField() {
            return this.headerField == null ? null : (String)this.headerField.getValue();
        }

        public TestScriptVariableComponent setHeaderField(String value) {
            if (Utilities.noString((String)value)) {
                this.headerField = null;
            } else {
                if (this.headerField == null) {
                    this.headerField = new StringType();
                }
                this.headerField.setValue(value);
            }
            return this;
        }

        public StringType getHintElement() {
            if (this.hint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.hint");
                }
                if (Configuration.doAutoCreate()) {
                    this.hint = new StringType();
                }
            }
            return this.hint;
        }

        public boolean hasHintElement() {
            return this.hint != null && !this.hint.isEmpty();
        }

        public boolean hasHint() {
            return this.hint != null && !this.hint.isEmpty();
        }

        public TestScriptVariableComponent setHintElement(StringType value) {
            this.hint = value;
            return this;
        }

        public String getHint() {
            return this.hint == null ? null : (String)this.hint.getValue();
        }

        public TestScriptVariableComponent setHint(String value) {
            if (Utilities.noString((String)value)) {
                this.hint = null;
            } else {
                if (this.hint == null) {
                    this.hint = new StringType();
                }
                this.hint.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public TestScriptVariableComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public TestScriptVariableComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public TestScriptVariableComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public TestScriptVariableComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new IdType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TestScript.SP_NAME, "string", "Descriptive name for this variable.", 0, 1, this.name));
            children.add(new Property("defaultValue", "string", "A default, hard-coded, or user-defined value for this variable.", 0, 1, this.defaultValue));
            children.add(new Property(TestScript.SP_DESCRIPTION, "string", "A free text natural language description of the variable and its purpose.", 0, 1, this.description));
            children.add(new Property("expression", "string", "The FHIRPath expression to evaluate against the fixture body. When variables are defined, only one of either expression, headerField or path must be specified.", 0, 1, this.expression));
            children.add(new Property("headerField", "string", "Will be used to grab the HTTP header field value from the headers that sourceId is pointing to.", 0, 1, this.headerField));
            children.add(new Property("hint", "string", "Displayable text string with hint help information to the user when entering a default value.", 0, 1, this.hint));
            children.add(new Property("path", "string", "XPath or JSONPath to evaluate against the fixture body.  When variables are defined, only one of either expression, headerField or path must be specified.", 0, 1, this.path));
            children.add(new Property("sourceId", "id", "Fixture to evaluate the XPath/JSONPath expression or the headerField  against within this variable.", 0, 1, this.sourceId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(TestScript.SP_NAME, "string", "Descriptive name for this variable.", 0, 1, this.name);
                }
                case -659125328: {
                    return new Property("defaultValue", "string", "A default, hard-coded, or user-defined value for this variable.", 0, 1, this.defaultValue);
                }
                case -1724546052: {
                    return new Property(TestScript.SP_DESCRIPTION, "string", "A free text natural language description of the variable and its purpose.", 0, 1, this.description);
                }
                case -1795452264: {
                    return new Property("expression", "string", "The FHIRPath expression to evaluate against the fixture body. When variables are defined, only one of either expression, headerField or path must be specified.", 0, 1, this.expression);
                }
                case 1160732269: {
                    return new Property("headerField", "string", "Will be used to grab the HTTP header field value from the headers that sourceId is pointing to.", 0, 1, this.headerField);
                }
                case 3202695: {
                    return new Property("hint", "string", "Displayable text string with hint help information to the user when entering a default value.", 0, 1, this.hint);
                }
                case 3433509: {
                    return new Property("path", "string", "XPath or JSONPath to evaluate against the fixture body.  When variables are defined, only one of either expression, headerField or path must be specified.", 0, 1, this.path);
                }
                case 1746327190: {
                    return new Property("sourceId", "id", "Fixture to evaluate the XPath/JSONPath expression or the headerField  against within this variable.", 0, 1, this.sourceId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -659125328: {
                    Base[] baseArray;
                    if (this.defaultValue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.defaultValue;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
                case 1160732269: {
                    Base[] baseArray;
                    if (this.headerField == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.headerField;
                    }
                    return baseArray;
                }
                case 3202695: {
                    Base[] baseArray;
                    if (this.hint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.hint;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.path;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.sourceId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -659125328: {
                    this.defaultValue = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToString(value);
                    return value;
                }
                case 1160732269: {
                    this.headerField = TypeConvertor.castToString(value);
                    return value;
                }
                case 3202695: {
                    this.hint = TypeConvertor.castToString(value);
                    return value;
                }
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case 1746327190: {
                    this.sourceId = TypeConvertor.castToId(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("defaultValue")) {
                this.defaultValue = TypeConvertor.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToString(value);
            } else if (name.equals("headerField")) {
                this.headerField = TypeConvertor.castToString(value);
            } else if (name.equals("hint")) {
                this.hint = TypeConvertor.castToString(value);
            } else if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = TypeConvertor.castToId(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -659125328: {
                    return this.getDefaultValueElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
                case 1160732269: {
                    return this.getHeaderFieldElement();
                }
                case 3202695: {
                    return this.getHintElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
                case 1746327190: {
                    return this.getSourceIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -659125328: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
                case 1160732269: {
                    return new String[]{"string"};
                }
                case 3202695: {
                    return new String[]{"string"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
                case 1746327190: {
                    return new String[]{"id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.name");
            }
            if (name.equals("defaultValue")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.defaultValue");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.description");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.expression");
            }
            if (name.equals("headerField")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.headerField");
            }
            if (name.equals("hint")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.hint");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.path");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.variable.sourceId");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptVariableComponent copy() {
            TestScriptVariableComponent dst = new TestScriptVariableComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptVariableComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.defaultValue = this.defaultValue == null ? null : this.defaultValue.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            dst.headerField = this.headerField == null ? null : this.headerField.copy();
            dst.hint = this.hint == null ? null : this.hint.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptVariableComponent)) {
                return false;
            }
            TestScriptVariableComponent o = (TestScriptVariableComponent)other_;
            return TestScriptVariableComponent.compareDeep(this.name, o.name, true) && TestScriptVariableComponent.compareDeep(this.defaultValue, o.defaultValue, true) && TestScriptVariableComponent.compareDeep(this.description, o.description, true) && TestScriptVariableComponent.compareDeep(this.expression, o.expression, true) && TestScriptVariableComponent.compareDeep(this.headerField, o.headerField, true) && TestScriptVariableComponent.compareDeep(this.hint, o.hint, true) && TestScriptVariableComponent.compareDeep(this.path, o.path, true) && TestScriptVariableComponent.compareDeep(this.sourceId, o.sourceId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptVariableComponent)) {
                return false;
            }
            TestScriptVariableComponent o = (TestScriptVariableComponent)other_;
            return TestScriptVariableComponent.compareValues(this.name, o.name, true) && TestScriptVariableComponent.compareValues(this.defaultValue, o.defaultValue, true) && TestScriptVariableComponent.compareValues(this.description, o.description, true) && TestScriptVariableComponent.compareValues(this.expression, o.expression, true) && TestScriptVariableComponent.compareValues(this.headerField, o.headerField, true) && TestScriptVariableComponent.compareValues(this.hint, o.hint, true) && TestScriptVariableComponent.compareValues(this.path, o.path, true) && TestScriptVariableComponent.compareValues(this.sourceId, o.sourceId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.defaultValue, this.description, this.expression, this.headerField, this.hint, this.path, this.sourceId});
        }

        @Override
        public String fhirType() {
            return "TestScript.variable";
        }
    }

    @Block
    public static class TestScriptFixtureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="autocreate", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not to implicitly create the fixture during setup", formalDefinition="Whether or not to implicitly create the fixture during setup. If true, the fixture is automatically created on each server being tested during setup, therefore no create operation is required for this fixture in the TestScript.setup section.")
        protected BooleanType autocreate;
        @Child(name="autodelete", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not to implicitly delete the fixture during teardown", formalDefinition="Whether or not to implicitly delete the fixture during teardown. If true, the fixture is automatically deleted on each server being tested during teardown, therefore no delete operation is required for this fixture in the TestScript.teardown section.")
        protected BooleanType autodelete;
        @Child(name="resource", type={Reference.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference of the resource", formalDefinition="Reference to the resource (containing the contents of the resource needed for operations).")
        protected Reference resource;
        private static final long serialVersionUID = 672117234L;

        public TestScriptFixtureComponent() {
        }

        public TestScriptFixtureComponent(boolean autocreate, boolean autodelete) {
            this.setAutocreate(autocreate);
            this.setAutodelete(autodelete);
        }

        public BooleanType getAutocreateElement() {
            if (this.autocreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptFixtureComponent.autocreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.autocreate = new BooleanType();
                }
            }
            return this.autocreate;
        }

        public boolean hasAutocreateElement() {
            return this.autocreate != null && !this.autocreate.isEmpty();
        }

        public boolean hasAutocreate() {
            return this.autocreate != null && !this.autocreate.isEmpty();
        }

        public TestScriptFixtureComponent setAutocreateElement(BooleanType value) {
            this.autocreate = value;
            return this;
        }

        public boolean getAutocreate() {
            return this.autocreate == null || this.autocreate.isEmpty() ? false : (Boolean)this.autocreate.getValue();
        }

        public TestScriptFixtureComponent setAutocreate(boolean value) {
            if (this.autocreate == null) {
                this.autocreate = new BooleanType();
            }
            this.autocreate.setValue((Object)value);
            return this;
        }

        public BooleanType getAutodeleteElement() {
            if (this.autodelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptFixtureComponent.autodelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.autodelete = new BooleanType();
                }
            }
            return this.autodelete;
        }

        public boolean hasAutodeleteElement() {
            return this.autodelete != null && !this.autodelete.isEmpty();
        }

        public boolean hasAutodelete() {
            return this.autodelete != null && !this.autodelete.isEmpty();
        }

        public TestScriptFixtureComponent setAutodeleteElement(BooleanType value) {
            this.autodelete = value;
            return this;
        }

        public boolean getAutodelete() {
            return this.autodelete == null || this.autodelete.isEmpty() ? false : (Boolean)this.autodelete.getValue();
        }

        public TestScriptFixtureComponent setAutodelete(boolean value) {
            if (this.autodelete == null) {
                this.autodelete = new BooleanType();
            }
            this.autodelete.setValue((Object)value);
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptFixtureComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public TestScriptFixtureComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("autocreate", "boolean", "Whether or not to implicitly create the fixture during setup. If true, the fixture is automatically created on each server being tested during setup, therefore no create operation is required for this fixture in the TestScript.setup section.", 0, 1, this.autocreate));
            children.add(new Property("autodelete", "boolean", "Whether or not to implicitly delete the fixture during teardown. If true, the fixture is automatically deleted on each server being tested during teardown, therefore no delete operation is required for this fixture in the TestScript.teardown section.", 0, 1, this.autodelete));
            children.add(new Property("resource", "Reference(Any)", "Reference to the resource (containing the contents of the resource needed for operations).", 0, 1, this.resource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 73154411: {
                    return new Property("autocreate", "boolean", "Whether or not to implicitly create the fixture during setup. If true, the fixture is automatically created on each server being tested during setup, therefore no create operation is required for this fixture in the TestScript.setup section.", 0, 1, this.autocreate);
                }
                case 89990170: {
                    return new Property("autodelete", "boolean", "Whether or not to implicitly delete the fixture during teardown. If true, the fixture is automatically deleted on each server being tested during teardown, therefore no delete operation is required for this fixture in the TestScript.teardown section.", 0, 1, this.autodelete);
                }
                case -341064690: {
                    return new Property("resource", "Reference(Any)", "Reference to the resource (containing the contents of the resource needed for operations).", 0, 1, this.resource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    Base[] baseArray;
                    if (this.autocreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.autocreate;
                    }
                    return baseArray;
                }
                case 89990170: {
                    Base[] baseArray;
                    if (this.autodelete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.autodelete;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    this.autocreate = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 89990170: {
                    this.autodelete = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("autocreate")) {
                this.autocreate = TypeConvertor.castToBoolean(value);
            } else if (name.equals("autodelete")) {
                this.autodelete = TypeConvertor.castToBoolean(value);
            } else if (name.equals("resource")) {
                this.resource = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    return this.getAutocreateElement();
                }
                case 89990170: {
                    return this.getAutodeleteElement();
                }
                case -341064690: {
                    return this.getResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    return new String[]{"boolean"};
                }
                case 89990170: {
                    return new String[]{"boolean"};
                }
                case -341064690: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("autocreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.fixture.autocreate");
            }
            if (name.equals("autodelete")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.fixture.autodelete");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptFixtureComponent copy() {
            TestScriptFixtureComponent dst = new TestScriptFixtureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptFixtureComponent dst) {
            super.copyValues(dst);
            dst.autocreate = this.autocreate == null ? null : this.autocreate.copy();
            dst.autodelete = this.autodelete == null ? null : this.autodelete.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptFixtureComponent)) {
                return false;
            }
            TestScriptFixtureComponent o = (TestScriptFixtureComponent)other_;
            return TestScriptFixtureComponent.compareDeep(this.autocreate, o.autocreate, true) && TestScriptFixtureComponent.compareDeep(this.autodelete, o.autodelete, true) && TestScriptFixtureComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptFixtureComponent)) {
                return false;
            }
            TestScriptFixtureComponent o = (TestScriptFixtureComponent)other_;
            return TestScriptFixtureComponent.compareValues(this.autocreate, o.autocreate, true) && TestScriptFixtureComponent.compareValues(this.autodelete, o.autodelete, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.autocreate, this.autodelete, this.resource});
        }

        @Override
        public String fhirType() {
            return "TestScript.fixture";
        }
    }

    @Block
    public static class TestScriptMetadataCapabilityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="required", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Are the capabilities required?", formalDefinition="Whether or not the test execution will require the given capabilities of the server in order for this test script to execute.")
        protected BooleanType required;
        @Child(name="validated", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Are the capabilities validated?", formalDefinition="Whether or not the test execution will validate the given capabilities of the server in order for this test script to execute.")
        protected BooleanType validated;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The expected capabilities of the server", formalDefinition="Description of the capabilities that this test script is requiring the server to support.")
        protected StringType description;
        @Child(name="origin", type={IntegerType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Which origin server these requirements apply to", formalDefinition="Which origin server these requirements apply to.")
        protected List<IntegerType> origin;
        @Child(name="destination", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which server these requirements apply to", formalDefinition="Which server these requirements apply to.")
        protected IntegerType destination;
        @Child(name="link", type={UriType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Links to the FHIR specification", formalDefinition="Links to the FHIR specification that describes this interaction and the resources involved in more detail.")
        protected List<UriType> link;
        @Child(name="capabilities", type={CanonicalType.class}, order=7, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Required Capability Statement", formalDefinition="Minimum capabilities required of server for test script to execute successfully.   If server does not meet at a minimum the referenced capability statement, then all tests in this script are skipped.")
        protected CanonicalType capabilities;
        private static final long serialVersionUID = -1368199288L;

        public TestScriptMetadataCapabilityComponent() {
        }

        public TestScriptMetadataCapabilityComponent(boolean required, boolean validated, String capabilities) {
            this.setRequired(required);
            this.setValidated(validated);
            this.setCapabilities(capabilities);
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public TestScriptMetadataCapabilityComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public BooleanType getValidatedElement() {
            if (this.validated == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.validated");
                }
                if (Configuration.doAutoCreate()) {
                    this.validated = new BooleanType();
                }
            }
            return this.validated;
        }

        public boolean hasValidatedElement() {
            return this.validated != null && !this.validated.isEmpty();
        }

        public boolean hasValidated() {
            return this.validated != null && !this.validated.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setValidatedElement(BooleanType value) {
            this.validated = value;
            return this;
        }

        public boolean getValidated() {
            return this.validated == null || this.validated.isEmpty() ? false : (Boolean)this.validated.getValue();
        }

        public TestScriptMetadataCapabilityComponent setValidated(boolean value) {
            if (this.validated == null) {
                this.validated = new BooleanType();
            }
            this.validated.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptMetadataCapabilityComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<IntegerType> getOrigin() {
            if (this.origin == null) {
                this.origin = new ArrayList<IntegerType>();
            }
            return this.origin;
        }

        public TestScriptMetadataCapabilityComponent setOrigin(List<IntegerType> theOrigin) {
            this.origin = theOrigin;
            return this;
        }

        public boolean hasOrigin() {
            if (this.origin == null) {
                return false;
            }
            for (IntegerType item : this.origin) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IntegerType addOriginElement() {
            IntegerType t = new IntegerType();
            if (this.origin == null) {
                this.origin = new ArrayList<IntegerType>();
            }
            this.origin.add(t);
            return t;
        }

        public TestScriptMetadataCapabilityComponent addOrigin(int value) {
            IntegerType t = new IntegerType();
            t.setValue((Object)value);
            if (this.origin == null) {
                this.origin = new ArrayList<IntegerType>();
            }
            this.origin.add(t);
            return this;
        }

        public boolean hasOrigin(int value) {
            if (this.origin == null) {
                return false;
            }
            for (IntegerType v : this.origin) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public IntegerType getDestinationElement() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new IntegerType();
                }
            }
            return this.destination;
        }

        public boolean hasDestinationElement() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setDestinationElement(IntegerType value) {
            this.destination = value;
            return this;
        }

        public int getDestination() {
            return this.destination == null || this.destination.isEmpty() ? 0 : (Integer)this.destination.getValue();
        }

        public TestScriptMetadataCapabilityComponent setDestination(int value) {
            if (this.destination == null) {
                this.destination = new IntegerType();
            }
            this.destination.setValue((Object)value);
            return this;
        }

        public List<UriType> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<UriType>();
            }
            return this.link;
        }

        public TestScriptMetadataCapabilityComponent setLink(List<UriType> theLink) {
            this.link = theLink;
            return this;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (UriType item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addLinkElement() {
            UriType t = new UriType();
            if (this.link == null) {
                this.link = new ArrayList<UriType>();
            }
            this.link.add(t);
            return t;
        }

        public TestScriptMetadataCapabilityComponent addLink(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.link == null) {
                this.link = new ArrayList<UriType>();
            }
            this.link.add(t);
            return this;
        }

        public boolean hasLink(String value) {
            if (this.link == null) {
                return false;
            }
            for (UriType v : this.link) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CanonicalType getCapabilitiesElement() {
            if (this.capabilities == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.capabilities");
                }
                if (Configuration.doAutoCreate()) {
                    this.capabilities = new CanonicalType();
                }
            }
            return this.capabilities;
        }

        public boolean hasCapabilitiesElement() {
            return this.capabilities != null && !this.capabilities.isEmpty();
        }

        public boolean hasCapabilities() {
            return this.capabilities != null && !this.capabilities.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setCapabilitiesElement(CanonicalType value) {
            this.capabilities = value;
            return this;
        }

        public String getCapabilities() {
            return this.capabilities == null ? null : (String)this.capabilities.getValue();
        }

        public TestScriptMetadataCapabilityComponent setCapabilities(String value) {
            if (this.capabilities == null) {
                this.capabilities = new CanonicalType();
            }
            this.capabilities.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("required", "boolean", "Whether or not the test execution will require the given capabilities of the server in order for this test script to execute.", 0, 1, this.required));
            children.add(new Property("validated", "boolean", "Whether or not the test execution will validate the given capabilities of the server in order for this test script to execute.", 0, 1, this.validated));
            children.add(new Property(TestScript.SP_DESCRIPTION, "string", "Description of the capabilities that this test script is requiring the server to support.", 0, 1, this.description));
            children.add(new Property("origin", "integer", "Which origin server these requirements apply to.", 0, Integer.MAX_VALUE, this.origin));
            children.add(new Property("destination", "integer", "Which server these requirements apply to.", 0, 1, this.destination));
            children.add(new Property("link", "uri", "Links to the FHIR specification that describes this interaction and the resources involved in more detail.", 0, Integer.MAX_VALUE, this.link));
            children.add(new Property("capabilities", "canonical(CapabilityStatement)", "Minimum capabilities required of server for test script to execute successfully.   If server does not meet at a minimum the referenced capability statement, then all tests in this script are skipped.", 0, 1, this.capabilities));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -393139297: {
                    return new Property("required", "boolean", "Whether or not the test execution will require the given capabilities of the server in order for this test script to execute.", 0, 1, this.required);
                }
                case -1109784050: {
                    return new Property("validated", "boolean", "Whether or not the test execution will validate the given capabilities of the server in order for this test script to execute.", 0, 1, this.validated);
                }
                case -1724546052: {
                    return new Property(TestScript.SP_DESCRIPTION, "string", "Description of the capabilities that this test script is requiring the server to support.", 0, 1, this.description);
                }
                case -1008619738: {
                    return new Property("origin", "integer", "Which origin server these requirements apply to.", 0, Integer.MAX_VALUE, this.origin);
                }
                case -1429847026: {
                    return new Property("destination", "integer", "Which server these requirements apply to.", 0, 1, this.destination);
                }
                case 3321850: {
                    return new Property("link", "uri", "Links to the FHIR specification that describes this interaction and the resources involved in more detail.", 0, Integer.MAX_VALUE, this.link);
                }
                case -1487597642: {
                    return new Property("capabilities", "canonical(CapabilityStatement)", "Minimum capabilities required of server for test script to execute successfully.   If server does not meet at a minimum the referenced capability statement, then all tests in this script are skipped.", 0, 1, this.capabilities);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.required;
                    }
                    return baseArray;
                }
                case -1109784050: {
                    Base[] baseArray;
                    if (this.validated == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.validated;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    return this.origin == null ? new Base[]{} : this.origin.toArray(new Base[this.origin.size()]);
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.destination;
                    }
                    return baseArray;
                }
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case -1487597642: {
                    Base[] baseArray;
                    if (this.capabilities == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.capabilities;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    this.required = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1109784050: {
                    this.validated = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1008619738: {
                    this.getOrigin().add(TypeConvertor.castToInteger(value));
                    return value;
                }
                case -1429847026: {
                    this.destination = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 3321850: {
                    this.getLink().add(TypeConvertor.castToUri(value));
                    return value;
                }
                case -1487597642: {
                    this.capabilities = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("required")) {
                this.required = TypeConvertor.castToBoolean(value);
            } else if (name.equals("validated")) {
                this.validated = TypeConvertor.castToBoolean(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("origin")) {
                this.getOrigin().add(TypeConvertor.castToInteger(value));
            } else if (name.equals("destination")) {
                this.destination = TypeConvertor.castToInteger(value);
            } else if (name.equals("link")) {
                this.getLink().add(TypeConvertor.castToUri(value));
            } else if (name.equals("capabilities")) {
                this.capabilities = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    return this.getRequiredElement();
                }
                case -1109784050: {
                    return this.getValidatedElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1008619738: {
                    return this.addOriginElement();
                }
                case -1429847026: {
                    return this.getDestinationElement();
                }
                case 3321850: {
                    return this.addLinkElement();
                }
                case -1487597642: {
                    return this.getCapabilitiesElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    return new String[]{"boolean"};
                }
                case -1109784050: {
                    return new String[]{"boolean"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1008619738: {
                    return new String[]{"integer"};
                }
                case -1429847026: {
                    return new String[]{"integer"};
                }
                case 3321850: {
                    return new String[]{"uri"};
                }
                case -1487597642: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.required");
            }
            if (name.equals("validated")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.validated");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.description");
            }
            if (name.equals("origin")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.origin");
            }
            if (name.equals("destination")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.destination");
            }
            if (name.equals("link")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.link");
            }
            if (name.equals("capabilities")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.capability.capabilities");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptMetadataCapabilityComponent copy() {
            TestScriptMetadataCapabilityComponent dst = new TestScriptMetadataCapabilityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptMetadataCapabilityComponent dst) {
            super.copyValues(dst);
            dst.required = this.required == null ? null : this.required.copy();
            dst.validated = this.validated == null ? null : this.validated.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.origin != null) {
                dst.origin = new ArrayList<IntegerType>();
                for (IntegerType integerType : this.origin) {
                    dst.origin.add(integerType.copy());
                }
            }
            IntegerType integerType = dst.destination = this.destination == null ? null : this.destination.copy();
            if (this.link != null) {
                dst.link = new ArrayList<UriType>();
                for (UriType uriType : this.link) {
                    dst.link.add(uriType.copy());
                }
            }
            dst.capabilities = this.capabilities == null ? null : this.capabilities.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptMetadataCapabilityComponent)) {
                return false;
            }
            TestScriptMetadataCapabilityComponent o = (TestScriptMetadataCapabilityComponent)other_;
            return TestScriptMetadataCapabilityComponent.compareDeep(this.required, o.required, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.validated, o.validated, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.description, o.description, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.origin, o.origin, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.destination, o.destination, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.link, o.link, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.capabilities, o.capabilities, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptMetadataCapabilityComponent)) {
                return false;
            }
            TestScriptMetadataCapabilityComponent o = (TestScriptMetadataCapabilityComponent)other_;
            return TestScriptMetadataCapabilityComponent.compareValues(this.required, o.required, true) && TestScriptMetadataCapabilityComponent.compareValues(this.validated, o.validated, true) && TestScriptMetadataCapabilityComponent.compareValues(this.description, o.description, true) && TestScriptMetadataCapabilityComponent.compareValues(this.origin, o.origin, true) && TestScriptMetadataCapabilityComponent.compareValues(this.destination, o.destination, true) && TestScriptMetadataCapabilityComponent.compareValues(this.link, o.link, true) && TestScriptMetadataCapabilityComponent.compareValues(this.capabilities, o.capabilities, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.required, this.validated, this.description, this.origin, this.destination, this.link, this.capabilities});
        }

        @Override
        public String fhirType() {
            return "TestScript.metadata.capability";
        }
    }

    @Block
    public static class TestScriptMetadataLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="url", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="URL to the specification", formalDefinition="URL to a particular requirement or feature within the FHIR specification.")
        protected UriType url;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short description", formalDefinition="Short description of the link.")
        protected StringType description;
        private static final long serialVersionUID = 213372298L;

        public TestScriptMetadataLinkComponent() {
        }

        public TestScriptMetadataLinkComponent(String url) {
            this.setUrl(url);
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataLinkComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public TestScriptMetadataLinkComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public TestScriptMetadataLinkComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataLinkComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptMetadataLinkComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptMetadataLinkComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(TestScript.SP_URL, "uri", "URL to a particular requirement or feature within the FHIR specification.", 0, 1, this.url));
            children.add(new Property(TestScript.SP_DESCRIPTION, "string", "Short description of the link.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116079: {
                    return new Property(TestScript.SP_URL, "uri", "URL to a particular requirement or feature within the FHIR specification.", 0, 1, this.url);
                }
                case -1724546052: {
                    return new Property(TestScript.SP_DESCRIPTION, "string", "Short description of the link.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116079: {
                    this.url = TypeConvertor.castToUri(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_URL)) {
                this.url = TypeConvertor.castToUri(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    return this.getUrlElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    return new String[]{"uri"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.link.url");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.metadata.link.description");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptMetadataLinkComponent copy() {
            TestScriptMetadataLinkComponent dst = new TestScriptMetadataLinkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptMetadataLinkComponent dst) {
            super.copyValues(dst);
            dst.url = this.url == null ? null : this.url.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptMetadataLinkComponent)) {
                return false;
            }
            TestScriptMetadataLinkComponent o = (TestScriptMetadataLinkComponent)other_;
            return TestScriptMetadataLinkComponent.compareDeep(this.url, o.url, true) && TestScriptMetadataLinkComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptMetadataLinkComponent)) {
                return false;
            }
            TestScriptMetadataLinkComponent o = (TestScriptMetadataLinkComponent)other_;
            return TestScriptMetadataLinkComponent.compareValues(this.url, o.url, true) && TestScriptMetadataLinkComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.url, this.description});
        }

        @Override
        public String fhirType() {
            return "TestScript.metadata.link";
        }
    }

    @Block
    public static class TestScriptMetadataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="link", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Links to the FHIR specification", formalDefinition="A link to the FHIR specification that this test is covering.")
        protected List<TestScriptMetadataLinkComponent> link;
        @Child(name="capability", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Capabilities  that are assumed to function correctly on the FHIR server being tested", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        protected List<TestScriptMetadataCapabilityComponent> capability;
        private static final long serialVersionUID = 745183328L;

        public TestScriptMetadataComponent() {
        }

        public TestScriptMetadataComponent(TestScriptMetadataCapabilityComponent capability) {
            this.addCapability(capability);
        }

        public List<TestScriptMetadataLinkComponent> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<TestScriptMetadataLinkComponent>();
            }
            return this.link;
        }

        public TestScriptMetadataComponent setLink(List<TestScriptMetadataLinkComponent> theLink) {
            this.link = theLink;
            return this;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (TestScriptMetadataLinkComponent item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptMetadataLinkComponent addLink() {
            TestScriptMetadataLinkComponent t = new TestScriptMetadataLinkComponent();
            if (this.link == null) {
                this.link = new ArrayList<TestScriptMetadataLinkComponent>();
            }
            this.link.add(t);
            return t;
        }

        public TestScriptMetadataComponent addLink(TestScriptMetadataLinkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.link == null) {
                this.link = new ArrayList<TestScriptMetadataLinkComponent>();
            }
            this.link.add(t);
            return this;
        }

        public TestScriptMetadataLinkComponent getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                this.addLink();
            }
            return this.getLink().get(0);
        }

        public List<TestScriptMetadataCapabilityComponent> getCapability() {
            if (this.capability == null) {
                this.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
            }
            return this.capability;
        }

        public TestScriptMetadataComponent setCapability(List<TestScriptMetadataCapabilityComponent> theCapability) {
            this.capability = theCapability;
            return this;
        }

        public boolean hasCapability() {
            if (this.capability == null) {
                return false;
            }
            for (TestScriptMetadataCapabilityComponent item : this.capability) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptMetadataCapabilityComponent addCapability() {
            TestScriptMetadataCapabilityComponent t = new TestScriptMetadataCapabilityComponent();
            if (this.capability == null) {
                this.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
            }
            this.capability.add(t);
            return t;
        }

        public TestScriptMetadataComponent addCapability(TestScriptMetadataCapabilityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.capability == null) {
                this.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
            }
            this.capability.add(t);
            return this;
        }

        public TestScriptMetadataCapabilityComponent getCapabilityFirstRep() {
            if (this.getCapability().isEmpty()) {
                this.addCapability();
            }
            return this.getCapability().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("link", "", "A link to the FHIR specification that this test is covering.", 0, Integer.MAX_VALUE, this.link));
            children.add(new Property("capability", "", "Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.", 0, Integer.MAX_VALUE, this.capability));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3321850: {
                    return new Property("link", "", "A link to the FHIR specification that this test is covering.", 0, Integer.MAX_VALUE, this.link);
                }
                case -783669992: {
                    return new Property("capability", "", "Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.", 0, Integer.MAX_VALUE, this.capability);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case -783669992: {
                    return this.capability == null ? new Base[]{} : this.capability.toArray(new Base[this.capability.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    this.getLink().add((TestScriptMetadataLinkComponent)value);
                    return value;
                }
                case -783669992: {
                    this.getCapability().add((TestScriptMetadataCapabilityComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("link")) {
                this.getLink().add((TestScriptMetadataLinkComponent)value);
            } else if (name.equals("capability")) {
                this.getCapability().add((TestScriptMetadataCapabilityComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.addLink();
                }
                case -783669992: {
                    return this.addCapability();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return new String[0];
                }
                case -783669992: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("link")) {
                return this.addLink();
            }
            if (name.equals("capability")) {
                return this.addCapability();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptMetadataComponent copy() {
            TestScriptMetadataComponent dst = new TestScriptMetadataComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptMetadataComponent dst) {
            super.copyValues(dst);
            if (this.link != null) {
                dst.link = new ArrayList<TestScriptMetadataLinkComponent>();
                for (TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : this.link) {
                    dst.link.add(testScriptMetadataLinkComponent.copy());
                }
            }
            if (this.capability != null) {
                dst.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
                for (TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : this.capability) {
                    dst.capability.add(testScriptMetadataCapabilityComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptMetadataComponent)) {
                return false;
            }
            TestScriptMetadataComponent o = (TestScriptMetadataComponent)other_;
            return TestScriptMetadataComponent.compareDeep(this.link, o.link, true) && TestScriptMetadataComponent.compareDeep(this.capability, o.capability, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptMetadataComponent)) {
                return false;
            }
            TestScriptMetadataComponent o = (TestScriptMetadataComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.link, this.capability});
        }

        @Override
        public String fhirType() {
            return "TestScript.metadata";
        }
    }

    @Block
    public static class TestScriptDestinationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="index", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The index of the abstract destination server starting at 1", formalDefinition="Abstract name given to a destination server in this test script.  The name is provided as a number starting at 1.")
        protected IntegerType index;
        @Child(name="profile", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="FHIR-Server | FHIR-SDC-FormManager | FHIR-SDC-FormReceiver | FHIR-SDC-FormProcessor", formalDefinition="The type of destination profile the test system supports.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/testscript-profile-destination-types")
        protected Coding profile;
        private static final long serialVersionUID = -1239935149L;

        public TestScriptDestinationComponent() {
        }

        public TestScriptDestinationComponent(int index, Coding profile) {
            this.setIndex(index);
            this.setProfile(profile);
        }

        public IntegerType getIndexElement() {
            if (this.index == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptDestinationComponent.index");
                }
                if (Configuration.doAutoCreate()) {
                    this.index = new IntegerType();
                }
            }
            return this.index;
        }

        public boolean hasIndexElement() {
            return this.index != null && !this.index.isEmpty();
        }

        public boolean hasIndex() {
            return this.index != null && !this.index.isEmpty();
        }

        public TestScriptDestinationComponent setIndexElement(IntegerType value) {
            this.index = value;
            return this;
        }

        public int getIndex() {
            return this.index == null || this.index.isEmpty() ? 0 : (Integer)this.index.getValue();
        }

        public TestScriptDestinationComponent setIndex(int value) {
            if (this.index == null) {
                this.index = new IntegerType();
            }
            this.index.setValue((Object)value);
            return this;
        }

        public Coding getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptDestinationComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Coding();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public TestScriptDestinationComponent setProfile(Coding value) {
            this.profile = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("index", "integer", "Abstract name given to a destination server in this test script.  The name is provided as a number starting at 1.", 0, 1, this.index));
            children.add(new Property("profile", "Coding", "The type of destination profile the test system supports.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 100346066: {
                    return new Property("index", "integer", "Abstract name given to a destination server in this test script.  The name is provided as a number starting at 1.", 0, 1, this.index);
                }
                case -309425751: {
                    return new Property("profile", "Coding", "The type of destination profile the test system supports.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    Base[] baseArray;
                    if (this.index == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.index;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    this.index = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -309425751: {
                    this.profile = TypeConvertor.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("index")) {
                this.index = TypeConvertor.castToInteger(value);
            } else if (name.equals("profile")) {
                this.profile = TypeConvertor.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    return this.getIndexElement();
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    return new String[]{"integer"};
                }
                case -309425751: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("index")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.destination.index");
            }
            if (name.equals("profile")) {
                this.profile = new Coding();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptDestinationComponent copy() {
            TestScriptDestinationComponent dst = new TestScriptDestinationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptDestinationComponent dst) {
            super.copyValues(dst);
            dst.index = this.index == null ? null : this.index.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptDestinationComponent)) {
                return false;
            }
            TestScriptDestinationComponent o = (TestScriptDestinationComponent)other_;
            return TestScriptDestinationComponent.compareDeep(this.index, o.index, true) && TestScriptDestinationComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptDestinationComponent)) {
                return false;
            }
            TestScriptDestinationComponent o = (TestScriptDestinationComponent)other_;
            return TestScriptDestinationComponent.compareValues(this.index, o.index, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.index, this.profile});
        }

        @Override
        public String fhirType() {
            return "TestScript.destination";
        }
    }

    @Block
    public static class TestScriptOriginComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="index", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The index of the abstract origin server starting at 1", formalDefinition="Abstract name given to an origin server in this test script.  The name is provided as a number starting at 1.")
        protected IntegerType index;
        @Child(name="profile", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="FHIR-Client | FHIR-SDC-FormFiller", formalDefinition="The type of origin profile the test system supports.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/testscript-profile-origin-types")
        protected Coding profile;
        private static final long serialVersionUID = -1239935149L;

        public TestScriptOriginComponent() {
        }

        public TestScriptOriginComponent(int index, Coding profile) {
            this.setIndex(index);
            this.setProfile(profile);
        }

        public IntegerType getIndexElement() {
            if (this.index == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptOriginComponent.index");
                }
                if (Configuration.doAutoCreate()) {
                    this.index = new IntegerType();
                }
            }
            return this.index;
        }

        public boolean hasIndexElement() {
            return this.index != null && !this.index.isEmpty();
        }

        public boolean hasIndex() {
            return this.index != null && !this.index.isEmpty();
        }

        public TestScriptOriginComponent setIndexElement(IntegerType value) {
            this.index = value;
            return this;
        }

        public int getIndex() {
            return this.index == null || this.index.isEmpty() ? 0 : (Integer)this.index.getValue();
        }

        public TestScriptOriginComponent setIndex(int value) {
            if (this.index == null) {
                this.index = new IntegerType();
            }
            this.index.setValue((Object)value);
            return this;
        }

        public Coding getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptOriginComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Coding();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public TestScriptOriginComponent setProfile(Coding value) {
            this.profile = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("index", "integer", "Abstract name given to an origin server in this test script.  The name is provided as a number starting at 1.", 0, 1, this.index));
            children.add(new Property("profile", "Coding", "The type of origin profile the test system supports.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 100346066: {
                    return new Property("index", "integer", "Abstract name given to an origin server in this test script.  The name is provided as a number starting at 1.", 0, 1, this.index);
                }
                case -309425751: {
                    return new Property("profile", "Coding", "The type of origin profile the test system supports.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    Base[] baseArray;
                    if (this.index == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.index;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    this.index = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -309425751: {
                    this.profile = TypeConvertor.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("index")) {
                this.index = TypeConvertor.castToInteger(value);
            } else if (name.equals("profile")) {
                this.profile = TypeConvertor.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    return this.getIndexElement();
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    return new String[]{"integer"};
                }
                case -309425751: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("index")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.origin.index");
            }
            if (name.equals("profile")) {
                this.profile = new Coding();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptOriginComponent copy() {
            TestScriptOriginComponent dst = new TestScriptOriginComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestScriptOriginComponent dst) {
            super.copyValues(dst);
            dst.index = this.index == null ? null : this.index.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptOriginComponent)) {
                return false;
            }
            TestScriptOriginComponent o = (TestScriptOriginComponent)other_;
            return TestScriptOriginComponent.compareDeep(this.index, o.index, true) && TestScriptOriginComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestScriptOriginComponent)) {
                return false;
            }
            TestScriptOriginComponent o = (TestScriptOriginComponent)other_;
            return TestScriptOriginComponent.compareValues(this.index, o.index, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.index, this.profile});
        }

        @Override
        public String fhirType() {
            return "TestScript.origin";
        }
    }

    public static class TestScriptRequestMethodCodeEnumFactory
    implements EnumFactory<TestScriptRequestMethodCode> {
        @Override
        public TestScriptRequestMethodCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("delete".equals(codeString)) {
                return TestScriptRequestMethodCode.DELETE;
            }
            if ("get".equals(codeString)) {
                return TestScriptRequestMethodCode.GET;
            }
            if ("options".equals(codeString)) {
                return TestScriptRequestMethodCode.OPTIONS;
            }
            if ("patch".equals(codeString)) {
                return TestScriptRequestMethodCode.PATCH;
            }
            if ("post".equals(codeString)) {
                return TestScriptRequestMethodCode.POST;
            }
            if ("put".equals(codeString)) {
                return TestScriptRequestMethodCode.PUT;
            }
            if ("head".equals(codeString)) {
                return TestScriptRequestMethodCode.HEAD;
            }
            throw new IllegalArgumentException("Unknown TestScriptRequestMethodCode code '" + codeString + "'");
        }

        public Enumeration<TestScriptRequestMethodCode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.NULL, code);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.DELETE, code);
            }
            if ("get".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.GET, code);
            }
            if ("options".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.OPTIONS, code);
            }
            if ("patch".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.PATCH, code);
            }
            if ("post".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.POST, code);
            }
            if ("put".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.PUT, code);
            }
            if ("head".equals(codeString)) {
                return new Enumeration<TestScriptRequestMethodCode>(this, TestScriptRequestMethodCode.HEAD, code);
            }
            throw new FHIRException("Unknown TestScriptRequestMethodCode code '" + codeString + "'");
        }

        @Override
        public String toCode(TestScriptRequestMethodCode code) {
            if (code == TestScriptRequestMethodCode.DELETE) {
                return "delete";
            }
            if (code == TestScriptRequestMethodCode.GET) {
                return "get";
            }
            if (code == TestScriptRequestMethodCode.OPTIONS) {
                return "options";
            }
            if (code == TestScriptRequestMethodCode.PATCH) {
                return "patch";
            }
            if (code == TestScriptRequestMethodCode.POST) {
                return "post";
            }
            if (code == TestScriptRequestMethodCode.PUT) {
                return "put";
            }
            if (code == TestScriptRequestMethodCode.HEAD) {
                return "head";
            }
            return "?";
        }

        @Override
        public String toSystem(TestScriptRequestMethodCode code) {
            return code.getSystem();
        }
    }

    public static enum TestScriptRequestMethodCode {
        DELETE,
        GET,
        OPTIONS,
        PATCH,
        POST,
        PUT,
        HEAD,
        NULL;


        public static TestScriptRequestMethodCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if ("get".equals(codeString)) {
                return GET;
            }
            if ("options".equals(codeString)) {
                return OPTIONS;
            }
            if ("patch".equals(codeString)) {
                return PATCH;
            }
            if ("post".equals(codeString)) {
                return POST;
            }
            if ("put".equals(codeString)) {
                return PUT;
            }
            if ("head".equals(codeString)) {
                return HEAD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TestScriptRequestMethodCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DELETE: {
                    return "delete";
                }
                case GET: {
                    return "get";
                }
                case OPTIONS: {
                    return "options";
                }
                case PATCH: {
                    return "patch";
                }
                case POST: {
                    return "post";
                }
                case PUT: {
                    return "put";
                }
                case HEAD: {
                    return "head";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DELETE: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case GET: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case OPTIONS: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case PATCH: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case POST: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case PUT: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case HEAD: {
                    return "http://hl7.org/fhir/http-operations";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DELETE: {
                    return "HTTP DELETE operation.";
                }
                case GET: {
                    return "HTTP GET operation.";
                }
                case OPTIONS: {
                    return "HTTP OPTIONS operation.";
                }
                case PATCH: {
                    return "HTTP PATCH operation.";
                }
                case POST: {
                    return "HTTP POST operation.";
                }
                case PUT: {
                    return "HTTP PUT operation.";
                }
                case HEAD: {
                    return "HTTP HEAD operation.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DELETE: {
                    return "DELETE";
                }
                case GET: {
                    return "GET";
                }
                case OPTIONS: {
                    return "OPTIONS";
                }
                case PATCH: {
                    return "PATCH";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case HEAD: {
                    return "HEAD";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class FHIRDefinedTypeEnumFactory
    implements EnumFactory<FHIRDefinedType> {
        @Override
        public FHIRDefinedType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Address".equals(codeString)) {
                return FHIRDefinedType.ADDRESS;
            }
            if ("Age".equals(codeString)) {
                return FHIRDefinedType.AGE;
            }
            if ("Annotation".equals(codeString)) {
                return FHIRDefinedType.ANNOTATION;
            }
            if ("Attachment".equals(codeString)) {
                return FHIRDefinedType.ATTACHMENT;
            }
            if ("BackboneElement".equals(codeString)) {
                return FHIRDefinedType.BACKBONEELEMENT;
            }
            if ("CodeableConcept".equals(codeString)) {
                return FHIRDefinedType.CODEABLECONCEPT;
            }
            if ("CodeableReference".equals(codeString)) {
                return FHIRDefinedType.CODEABLEREFERENCE;
            }
            if ("Coding".equals(codeString)) {
                return FHIRDefinedType.CODING;
            }
            if ("ContactDetail".equals(codeString)) {
                return FHIRDefinedType.CONTACTDETAIL;
            }
            if ("ContactPoint".equals(codeString)) {
                return FHIRDefinedType.CONTACTPOINT;
            }
            if ("Contributor".equals(codeString)) {
                return FHIRDefinedType.CONTRIBUTOR;
            }
            if ("Count".equals(codeString)) {
                return FHIRDefinedType.COUNT;
            }
            if ("DataRequirement".equals(codeString)) {
                return FHIRDefinedType.DATAREQUIREMENT;
            }
            if ("DataType".equals(codeString)) {
                return FHIRDefinedType.DATATYPE;
            }
            if ("Distance".equals(codeString)) {
                return FHIRDefinedType.DISTANCE;
            }
            if ("Dosage".equals(codeString)) {
                return FHIRDefinedType.DOSAGE;
            }
            if ("Duration".equals(codeString)) {
                return FHIRDefinedType.DURATION;
            }
            if ("Element".equals(codeString)) {
                return FHIRDefinedType.ELEMENT;
            }
            if ("ElementDefinition".equals(codeString)) {
                return FHIRDefinedType.ELEMENTDEFINITION;
            }
            if ("Expression".equals(codeString)) {
                return FHIRDefinedType.EXPRESSION;
            }
            if ("Extension".equals(codeString)) {
                return FHIRDefinedType.EXTENSION;
            }
            if ("HumanName".equals(codeString)) {
                return FHIRDefinedType.HUMANNAME;
            }
            if ("Identifier".equals(codeString)) {
                return FHIRDefinedType.IDENTIFIER;
            }
            if ("MarketingStatus".equals(codeString)) {
                return FHIRDefinedType.MARKETINGSTATUS;
            }
            if ("Meta".equals(codeString)) {
                return FHIRDefinedType.META;
            }
            if ("Money".equals(codeString)) {
                return FHIRDefinedType.MONEY;
            }
            if ("MoneyQuantity".equals(codeString)) {
                return FHIRDefinedType.MONEYQUANTITY;
            }
            if ("Narrative".equals(codeString)) {
                return FHIRDefinedType.NARRATIVE;
            }
            if ("ParameterDefinition".equals(codeString)) {
                return FHIRDefinedType.PARAMETERDEFINITION;
            }
            if ("Period".equals(codeString)) {
                return FHIRDefinedType.PERIOD;
            }
            if ("Population".equals(codeString)) {
                return FHIRDefinedType.POPULATION;
            }
            if ("ProdCharacteristic".equals(codeString)) {
                return FHIRDefinedType.PRODCHARACTERISTIC;
            }
            if ("ProductShelfLife".equals(codeString)) {
                return FHIRDefinedType.PRODUCTSHELFLIFE;
            }
            if ("Quantity".equals(codeString)) {
                return FHIRDefinedType.QUANTITY;
            }
            if ("Range".equals(codeString)) {
                return FHIRDefinedType.RANGE;
            }
            if ("Ratio".equals(codeString)) {
                return FHIRDefinedType.RATIO;
            }
            if ("RatioRange".equals(codeString)) {
                return FHIRDefinedType.RATIORANGE;
            }
            if ("Reference".equals(codeString)) {
                return FHIRDefinedType.REFERENCE;
            }
            if ("RelatedArtifact".equals(codeString)) {
                return FHIRDefinedType.RELATEDARTIFACT;
            }
            if ("SampledData".equals(codeString)) {
                return FHIRDefinedType.SAMPLEDDATA;
            }
            if ("Signature".equals(codeString)) {
                return FHIRDefinedType.SIGNATURE;
            }
            if ("SimpleQuantity".equals(codeString)) {
                return FHIRDefinedType.SIMPLEQUANTITY;
            }
            if ("Timing".equals(codeString)) {
                return FHIRDefinedType.TIMING;
            }
            if ("TriggerDefinition".equals(codeString)) {
                return FHIRDefinedType.TRIGGERDEFINITION;
            }
            if ("UsageContext".equals(codeString)) {
                return FHIRDefinedType.USAGECONTEXT;
            }
            if ("base64Binary".equals(codeString)) {
                return FHIRDefinedType.BASE64BINARY;
            }
            if ("boolean".equals(codeString)) {
                return FHIRDefinedType.BOOLEAN;
            }
            if ("canonical".equals(codeString)) {
                return FHIRDefinedType.CANONICAL;
            }
            if ("code".equals(codeString)) {
                return FHIRDefinedType.CODE;
            }
            if (TestScript.SP_DATE.equals(codeString)) {
                return FHIRDefinedType.DATE;
            }
            if ("dateTime".equals(codeString)) {
                return FHIRDefinedType.DATETIME;
            }
            if ("decimal".equals(codeString)) {
                return FHIRDefinedType.DECIMAL;
            }
            if ("id".equals(codeString)) {
                return FHIRDefinedType.ID;
            }
            if ("instant".equals(codeString)) {
                return FHIRDefinedType.INSTANT;
            }
            if ("integer".equals(codeString)) {
                return FHIRDefinedType.INTEGER;
            }
            if ("markdown".equals(codeString)) {
                return FHIRDefinedType.MARKDOWN;
            }
            if ("oid".equals(codeString)) {
                return FHIRDefinedType.OID;
            }
            if ("positiveInt".equals(codeString)) {
                return FHIRDefinedType.POSITIVEINT;
            }
            if ("string".equals(codeString)) {
                return FHIRDefinedType.STRING;
            }
            if ("time".equals(codeString)) {
                return FHIRDefinedType.TIME;
            }
            if ("unsignedInt".equals(codeString)) {
                return FHIRDefinedType.UNSIGNEDINT;
            }
            if ("uri".equals(codeString)) {
                return FHIRDefinedType.URI;
            }
            if (TestScript.SP_URL.equals(codeString)) {
                return FHIRDefinedType.URL;
            }
            if ("uuid".equals(codeString)) {
                return FHIRDefinedType.UUID;
            }
            if ("xhtml".equals(codeString)) {
                return FHIRDefinedType.XHTML;
            }
            if ("Resource".equals(codeString)) {
                return FHIRDefinedType.RESOURCE;
            }
            if ("Binary".equals(codeString)) {
                return FHIRDefinedType.BINARY;
            }
            if ("Bundle".equals(codeString)) {
                return FHIRDefinedType.BUNDLE;
            }
            if ("DomainResource".equals(codeString)) {
                return FHIRDefinedType.DOMAINRESOURCE;
            }
            if ("Account".equals(codeString)) {
                return FHIRDefinedType.ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return FHIRDefinedType.ACTIVITYDEFINITION;
            }
            if ("AdministrableProductDefinition".equals(codeString)) {
                return FHIRDefinedType.ADMINISTRABLEPRODUCTDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return FHIRDefinedType.ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return FHIRDefinedType.ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return FHIRDefinedType.APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return FHIRDefinedType.APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return FHIRDefinedType.AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return FHIRDefinedType.BASIC;
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return FHIRDefinedType.BIOLOGICALLYDERIVEDPRODUCT;
            }
            if ("BodyStructure".equals(codeString)) {
                return FHIRDefinedType.BODYSTRUCTURE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return FHIRDefinedType.CAPABILITYSTATEMENT;
            }
            if ("CarePlan".equals(codeString)) {
                return FHIRDefinedType.CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return FHIRDefinedType.CARETEAM;
            }
            if ("CatalogEntry".equals(codeString)) {
                return FHIRDefinedType.CATALOGENTRY;
            }
            if ("ChargeItem".equals(codeString)) {
                return FHIRDefinedType.CHARGEITEM;
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return FHIRDefinedType.CHARGEITEMDEFINITION;
            }
            if ("Citation".equals(codeString)) {
                return FHIRDefinedType.CITATION;
            }
            if ("Claim".equals(codeString)) {
                return FHIRDefinedType.CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return FHIRDefinedType.CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return FHIRDefinedType.CLINICALIMPRESSION;
            }
            if ("ClinicalUseDefinition".equals(codeString)) {
                return FHIRDefinedType.CLINICALUSEDEFINITION;
            }
            if ("CodeSystem".equals(codeString)) {
                return FHIRDefinedType.CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return FHIRDefinedType.COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return FHIRDefinedType.COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return FHIRDefinedType.COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return FHIRDefinedType.COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return FHIRDefinedType.CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return FHIRDefinedType.CONDITION;
            }
            if ("Consent".equals(codeString)) {
                return FHIRDefinedType.CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return FHIRDefinedType.CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return FHIRDefinedType.COVERAGE;
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return FHIRDefinedType.COVERAGEELIGIBILITYREQUEST;
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return FHIRDefinedType.COVERAGEELIGIBILITYRESPONSE;
            }
            if ("DetectedIssue".equals(codeString)) {
                return FHIRDefinedType.DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return FHIRDefinedType.DEVICE;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return FHIRDefinedType.DEVICEDEFINITION;
            }
            if ("DeviceMetric".equals(codeString)) {
                return FHIRDefinedType.DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return FHIRDefinedType.DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return FHIRDefinedType.DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return FHIRDefinedType.DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return FHIRDefinedType.DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return FHIRDefinedType.DOCUMENTREFERENCE;
            }
            if ("Encounter".equals(codeString)) {
                return FHIRDefinedType.ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return FHIRDefinedType.ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return FHIRDefinedType.ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return FHIRDefinedType.ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return FHIRDefinedType.EPISODEOFCARE;
            }
            if ("EventDefinition".equals(codeString)) {
                return FHIRDefinedType.EVENTDEFINITION;
            }
            if ("Evidence".equals(codeString)) {
                return FHIRDefinedType.EVIDENCE;
            }
            if ("EvidenceReport".equals(codeString)) {
                return FHIRDefinedType.EVIDENCEREPORT;
            }
            if ("EvidenceVariable".equals(codeString)) {
                return FHIRDefinedType.EVIDENCEVARIABLE;
            }
            if ("ExampleScenario".equals(codeString)) {
                return FHIRDefinedType.EXAMPLESCENARIO;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return FHIRDefinedType.EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FHIRDefinedType.FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FHIRDefinedType.FLAG;
            }
            if ("Goal".equals(codeString)) {
                return FHIRDefinedType.GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return FHIRDefinedType.GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return FHIRDefinedType.GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return FHIRDefinedType.GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return FHIRDefinedType.HEALTHCARESERVICE;
            }
            if ("ImagingStudy".equals(codeString)) {
                return FHIRDefinedType.IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return FHIRDefinedType.IMMUNIZATION;
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return FHIRDefinedType.IMMUNIZATIONEVALUATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return FHIRDefinedType.IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return FHIRDefinedType.IMPLEMENTATIONGUIDE;
            }
            if ("Ingredient".equals(codeString)) {
                return FHIRDefinedType.INGREDIENT;
            }
            if ("InsurancePlan".equals(codeString)) {
                return FHIRDefinedType.INSURANCEPLAN;
            }
            if ("Invoice".equals(codeString)) {
                return FHIRDefinedType.INVOICE;
            }
            if ("Library".equals(codeString)) {
                return FHIRDefinedType.LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return FHIRDefinedType.LINKAGE;
            }
            if ("List".equals(codeString)) {
                return FHIRDefinedType.LIST;
            }
            if ("Location".equals(codeString)) {
                return FHIRDefinedType.LOCATION;
            }
            if ("ManufacturedItemDefinition".equals(codeString)) {
                return FHIRDefinedType.MANUFACTUREDITEMDEFINITION;
            }
            if ("Measure".equals(codeString)) {
                return FHIRDefinedType.MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return FHIRDefinedType.MEASUREREPORT;
            }
            if ("Media".equals(codeString)) {
                return FHIRDefinedType.MEDIA;
            }
            if ("Medication".equals(codeString)) {
                return FHIRDefinedType.MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return FHIRDefinedType.MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return FHIRDefinedType.MEDICATIONDISPENSE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return FHIRDefinedType.MEDICATIONKNOWLEDGE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return FHIRDefinedType.MEDICATIONREQUEST;
            }
            if ("MedicationStatement".equals(codeString)) {
                return FHIRDefinedType.MEDICATIONSTATEMENT;
            }
            if ("MedicinalProductDefinition".equals(codeString)) {
                return FHIRDefinedType.MEDICINALPRODUCTDEFINITION;
            }
            if ("MessageDefinition".equals(codeString)) {
                return FHIRDefinedType.MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return FHIRDefinedType.MESSAGEHEADER;
            }
            if ("MolecularSequence".equals(codeString)) {
                return FHIRDefinedType.MOLECULARSEQUENCE;
            }
            if ("NamingSystem".equals(codeString)) {
                return FHIRDefinedType.NAMINGSYSTEM;
            }
            if ("NutritionOrder".equals(codeString)) {
                return FHIRDefinedType.NUTRITIONORDER;
            }
            if ("NutritionProduct".equals(codeString)) {
                return FHIRDefinedType.NUTRITIONPRODUCT;
            }
            if ("Observation".equals(codeString)) {
                return FHIRDefinedType.OBSERVATION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return FHIRDefinedType.OBSERVATIONDEFINITION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return FHIRDefinedType.OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return FHIRDefinedType.OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return FHIRDefinedType.ORGANIZATION;
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return FHIRDefinedType.ORGANIZATIONAFFILIATION;
            }
            if ("PackagedProductDefinition".equals(codeString)) {
                return FHIRDefinedType.PACKAGEDPRODUCTDEFINITION;
            }
            if ("Patient".equals(codeString)) {
                return FHIRDefinedType.PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return FHIRDefinedType.PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return FHIRDefinedType.PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return FHIRDefinedType.PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return FHIRDefinedType.PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return FHIRDefinedType.PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return FHIRDefinedType.PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return FHIRDefinedType.PROCEDURE;
            }
            if ("Provenance".equals(codeString)) {
                return FHIRDefinedType.PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return FHIRDefinedType.QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return FHIRDefinedType.QUESTIONNAIRERESPONSE;
            }
            if ("RegulatedAuthorization".equals(codeString)) {
                return FHIRDefinedType.REGULATEDAUTHORIZATION;
            }
            if ("RelatedPerson".equals(codeString)) {
                return FHIRDefinedType.RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return FHIRDefinedType.REQUESTGROUP;
            }
            if ("ResearchDefinition".equals(codeString)) {
                return FHIRDefinedType.RESEARCHDEFINITION;
            }
            if ("ResearchElementDefinition".equals(codeString)) {
                return FHIRDefinedType.RESEARCHELEMENTDEFINITION;
            }
            if ("ResearchStudy".equals(codeString)) {
                return FHIRDefinedType.RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return FHIRDefinedType.RESEARCHSUBJECT;
            }
            if ("RiskAssessment".equals(codeString)) {
                return FHIRDefinedType.RISKASSESSMENT;
            }
            if ("Schedule".equals(codeString)) {
                return FHIRDefinedType.SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return FHIRDefinedType.SEARCHPARAMETER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return FHIRDefinedType.SERVICEREQUEST;
            }
            if ("Slot".equals(codeString)) {
                return FHIRDefinedType.SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return FHIRDefinedType.SPECIMEN;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return FHIRDefinedType.SPECIMENDEFINITION;
            }
            if ("StructureDefinition".equals(codeString)) {
                return FHIRDefinedType.STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return FHIRDefinedType.STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return FHIRDefinedType.SUBSCRIPTION;
            }
            if ("SubscriptionStatus".equals(codeString)) {
                return FHIRDefinedType.SUBSCRIPTIONSTATUS;
            }
            if ("SubscriptionTopic".equals(codeString)) {
                return FHIRDefinedType.SUBSCRIPTIONTOPIC;
            }
            if ("Substance".equals(codeString)) {
                return FHIRDefinedType.SUBSTANCE;
            }
            if ("SubstanceDefinition".equals(codeString)) {
                return FHIRDefinedType.SUBSTANCEDEFINITION;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return FHIRDefinedType.SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return FHIRDefinedType.SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return FHIRDefinedType.TASK;
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return FHIRDefinedType.TERMINOLOGYCAPABILITIES;
            }
            if ("TestReport".equals(codeString)) {
                return FHIRDefinedType.TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return FHIRDefinedType.TESTSCRIPT;
            }
            if ("ValueSet".equals(codeString)) {
                return FHIRDefinedType.VALUESET;
            }
            if ("VerificationResult".equals(codeString)) {
                return FHIRDefinedType.VERIFICATIONRESULT;
            }
            if ("VisionPrescription".equals(codeString)) {
                return FHIRDefinedType.VISIONPRESCRIPTION;
            }
            if ("Parameters".equals(codeString)) {
                return FHIRDefinedType.PARAMETERS;
            }
            throw new IllegalArgumentException("Unknown FHIRDefinedType code '" + codeString + "'");
        }

        public Enumeration<FHIRDefinedType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.NULL, code);
            }
            if ("Address".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ADDRESS, code);
            }
            if ("Age".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.AGE, code);
            }
            if ("Annotation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ANNOTATION, code);
            }
            if ("Attachment".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ATTACHMENT, code);
            }
            if ("BackboneElement".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BACKBONEELEMENT, code);
            }
            if ("CodeableConcept".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CODEABLECONCEPT, code);
            }
            if ("CodeableReference".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CODEABLEREFERENCE, code);
            }
            if ("Coding".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CODING, code);
            }
            if ("ContactDetail".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONTACTDETAIL, code);
            }
            if ("ContactPoint".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONTACTPOINT, code);
            }
            if ("Contributor".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONTRIBUTOR, code);
            }
            if ("Count".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COUNT, code);
            }
            if ("DataRequirement".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DATAREQUIREMENT, code);
            }
            if ("DataType".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DATATYPE, code);
            }
            if ("Distance".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DISTANCE, code);
            }
            if ("Dosage".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DOSAGE, code);
            }
            if ("Duration".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DURATION, code);
            }
            if ("Element".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ELEMENT, code);
            }
            if ("ElementDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ELEMENTDEFINITION, code);
            }
            if ("Expression".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EXPRESSION, code);
            }
            if ("Extension".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EXTENSION, code);
            }
            if ("HumanName".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.HUMANNAME, code);
            }
            if ("Identifier".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.IDENTIFIER, code);
            }
            if ("MarketingStatus".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MARKETINGSTATUS, code);
            }
            if ("Meta".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.META, code);
            }
            if ("Money".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MONEY, code);
            }
            if ("MoneyQuantity".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MONEYQUANTITY, code);
            }
            if ("Narrative".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.NARRATIVE, code);
            }
            if ("ParameterDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PARAMETERDEFINITION, code);
            }
            if ("Period".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PERIOD, code);
            }
            if ("Population".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.POPULATION, code);
            }
            if ("ProdCharacteristic".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PRODCHARACTERISTIC, code);
            }
            if ("ProductShelfLife".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PRODUCTSHELFLIFE, code);
            }
            if ("Quantity".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.QUANTITY, code);
            }
            if ("Range".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RANGE, code);
            }
            if ("Ratio".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RATIO, code);
            }
            if ("RatioRange".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RATIORANGE, code);
            }
            if ("Reference".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.REFERENCE, code);
            }
            if ("RelatedArtifact".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RELATEDARTIFACT, code);
            }
            if ("SampledData".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SAMPLEDDATA, code);
            }
            if ("Signature".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SIGNATURE, code);
            }
            if ("SimpleQuantity".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SIMPLEQUANTITY, code);
            }
            if ("Timing".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TIMING, code);
            }
            if ("TriggerDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TRIGGERDEFINITION, code);
            }
            if ("UsageContext".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.USAGECONTEXT, code);
            }
            if ("base64Binary".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BASE64BINARY, code);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BOOLEAN, code);
            }
            if ("canonical".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CANONICAL, code);
            }
            if ("code".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CODE, code);
            }
            if (TestScript.SP_DATE.equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DATE, code);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DATETIME, code);
            }
            if ("decimal".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DECIMAL, code);
            }
            if ("id".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ID, code);
            }
            if ("instant".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.INSTANT, code);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.INTEGER, code);
            }
            if ("markdown".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MARKDOWN, code);
            }
            if ("oid".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.OID, code);
            }
            if ("positiveInt".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.POSITIVEINT, code);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.STRING, code);
            }
            if ("time".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TIME, code);
            }
            if ("unsignedInt".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.UNSIGNEDINT, code);
            }
            if ("uri".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.URI, code);
            }
            if (TestScript.SP_URL.equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.URL, code);
            }
            if ("uuid".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.UUID, code);
            }
            if ("xhtml".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.XHTML, code);
            }
            if ("Resource".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RESOURCE, code);
            }
            if ("Binary".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BINARY, code);
            }
            if ("Bundle".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BUNDLE, code);
            }
            if ("DomainResource".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DOMAINRESOURCE, code);
            }
            if ("Account".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ACCOUNT, code);
            }
            if ("ActivityDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ACTIVITYDEFINITION, code);
            }
            if ("AdministrableProductDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ADMINISTRABLEPRODUCTDEFINITION, code);
            }
            if ("AdverseEvent".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ADVERSEEVENT, code);
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ALLERGYINTOLERANCE, code);
            }
            if ("Appointment".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.APPOINTMENT, code);
            }
            if ("AppointmentResponse".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.APPOINTMENTRESPONSE, code);
            }
            if ("AuditEvent".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.AUDITEVENT, code);
            }
            if ("Basic".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BASIC, code);
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BIOLOGICALLYDERIVEDPRODUCT, code);
            }
            if ("BodyStructure".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.BODYSTRUCTURE, code);
            }
            if ("CapabilityStatement".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CAPABILITYSTATEMENT, code);
            }
            if ("CarePlan".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CAREPLAN, code);
            }
            if ("CareTeam".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CARETEAM, code);
            }
            if ("CatalogEntry".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CATALOGENTRY, code);
            }
            if ("ChargeItem".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CHARGEITEM, code);
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CHARGEITEMDEFINITION, code);
            }
            if ("Citation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CITATION, code);
            }
            if ("Claim".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CLAIM, code);
            }
            if ("ClaimResponse".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CLAIMRESPONSE, code);
            }
            if ("ClinicalImpression".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CLINICALIMPRESSION, code);
            }
            if ("ClinicalUseDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CLINICALUSEDEFINITION, code);
            }
            if ("CodeSystem".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CODESYSTEM, code);
            }
            if ("Communication".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COMMUNICATION, code);
            }
            if ("CommunicationRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COMMUNICATIONREQUEST, code);
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COMPARTMENTDEFINITION, code);
            }
            if ("Composition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COMPOSITION, code);
            }
            if ("ConceptMap".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONCEPTMAP, code);
            }
            if ("Condition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONDITION, code);
            }
            if ("Consent".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONSENT, code);
            }
            if ("Contract".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.CONTRACT, code);
            }
            if ("Coverage".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COVERAGE, code);
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COVERAGEELIGIBILITYREQUEST, code);
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.COVERAGEELIGIBILITYRESPONSE, code);
            }
            if ("DetectedIssue".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DETECTEDISSUE, code);
            }
            if ("Device".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DEVICE, code);
            }
            if ("DeviceDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DEVICEDEFINITION, code);
            }
            if ("DeviceMetric".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DEVICEMETRIC, code);
            }
            if ("DeviceRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DEVICEREQUEST, code);
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DEVICEUSESTATEMENT, code);
            }
            if ("DiagnosticReport".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DIAGNOSTICREPORT, code);
            }
            if ("DocumentManifest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DOCUMENTMANIFEST, code);
            }
            if ("DocumentReference".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.DOCUMENTREFERENCE, code);
            }
            if ("Encounter".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ENCOUNTER, code);
            }
            if ("Endpoint".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ENDPOINT, code);
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ENROLLMENTREQUEST, code);
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ENROLLMENTRESPONSE, code);
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EPISODEOFCARE, code);
            }
            if ("EventDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EVENTDEFINITION, code);
            }
            if ("Evidence".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EVIDENCE, code);
            }
            if ("EvidenceReport".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EVIDENCEREPORT, code);
            }
            if ("EvidenceVariable".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EVIDENCEVARIABLE, code);
            }
            if ("ExampleScenario".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EXAMPLESCENARIO, code);
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.EXPLANATIONOFBENEFIT, code);
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.FAMILYMEMBERHISTORY, code);
            }
            if ("Flag".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.FLAG, code);
            }
            if ("Goal".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.GOAL, code);
            }
            if ("GraphDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.GRAPHDEFINITION, code);
            }
            if ("Group".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.GROUP, code);
            }
            if ("GuidanceResponse".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.GUIDANCERESPONSE, code);
            }
            if ("HealthcareService".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.HEALTHCARESERVICE, code);
            }
            if ("ImagingStudy".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.IMAGINGSTUDY, code);
            }
            if ("Immunization".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.IMMUNIZATION, code);
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.IMMUNIZATIONEVALUATION, code);
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.IMMUNIZATIONRECOMMENDATION, code);
            }
            if ("ImplementationGuide".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.IMPLEMENTATIONGUIDE, code);
            }
            if ("Ingredient".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.INGREDIENT, code);
            }
            if ("InsurancePlan".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.INSURANCEPLAN, code);
            }
            if ("Invoice".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.INVOICE, code);
            }
            if ("Library".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.LIBRARY, code);
            }
            if ("Linkage".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.LINKAGE, code);
            }
            if ("List".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.LIST, code);
            }
            if ("Location".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.LOCATION, code);
            }
            if ("ManufacturedItemDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MANUFACTUREDITEMDEFINITION, code);
            }
            if ("Measure".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEASURE, code);
            }
            if ("MeasureReport".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEASUREREPORT, code);
            }
            if ("Media".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDIA, code);
            }
            if ("Medication".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICATION, code);
            }
            if ("MedicationAdministration".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICATIONADMINISTRATION, code);
            }
            if ("MedicationDispense".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICATIONDISPENSE, code);
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICATIONKNOWLEDGE, code);
            }
            if ("MedicationRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICATIONREQUEST, code);
            }
            if ("MedicationStatement".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICATIONSTATEMENT, code);
            }
            if ("MedicinalProductDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MEDICINALPRODUCTDEFINITION, code);
            }
            if ("MessageDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MESSAGEDEFINITION, code);
            }
            if ("MessageHeader".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MESSAGEHEADER, code);
            }
            if ("MolecularSequence".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.MOLECULARSEQUENCE, code);
            }
            if ("NamingSystem".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.NAMINGSYSTEM, code);
            }
            if ("NutritionOrder".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.NUTRITIONORDER, code);
            }
            if ("NutritionProduct".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.NUTRITIONPRODUCT, code);
            }
            if ("Observation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.OBSERVATION, code);
            }
            if ("ObservationDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.OBSERVATIONDEFINITION, code);
            }
            if ("OperationDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.OPERATIONDEFINITION, code);
            }
            if ("OperationOutcome".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.OPERATIONOUTCOME, code);
            }
            if ("Organization".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ORGANIZATION, code);
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.ORGANIZATIONAFFILIATION, code);
            }
            if ("PackagedProductDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PACKAGEDPRODUCTDEFINITION, code);
            }
            if ("Patient".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PATIENT, code);
            }
            if ("PaymentNotice".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PAYMENTNOTICE, code);
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PAYMENTRECONCILIATION, code);
            }
            if ("Person".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PERSON, code);
            }
            if ("PlanDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PLANDEFINITION, code);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PRACTITIONER, code);
            }
            if ("PractitionerRole".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PRACTITIONERROLE, code);
            }
            if ("Procedure".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PROCEDURE, code);
            }
            if ("Provenance".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PROVENANCE, code);
            }
            if ("Questionnaire".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.QUESTIONNAIRE, code);
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.QUESTIONNAIRERESPONSE, code);
            }
            if ("RegulatedAuthorization".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.REGULATEDAUTHORIZATION, code);
            }
            if ("RelatedPerson".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RELATEDPERSON, code);
            }
            if ("RequestGroup".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.REQUESTGROUP, code);
            }
            if ("ResearchDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RESEARCHDEFINITION, code);
            }
            if ("ResearchElementDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RESEARCHELEMENTDEFINITION, code);
            }
            if ("ResearchStudy".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RESEARCHSTUDY, code);
            }
            if ("ResearchSubject".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RESEARCHSUBJECT, code);
            }
            if ("RiskAssessment".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.RISKASSESSMENT, code);
            }
            if ("Schedule".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SCHEDULE, code);
            }
            if ("SearchParameter".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SEARCHPARAMETER, code);
            }
            if ("ServiceRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SERVICEREQUEST, code);
            }
            if ("Slot".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SLOT, code);
            }
            if ("Specimen".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SPECIMEN, code);
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SPECIMENDEFINITION, code);
            }
            if ("StructureDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.STRUCTUREDEFINITION, code);
            }
            if ("StructureMap".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.STRUCTUREMAP, code);
            }
            if ("Subscription".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUBSCRIPTION, code);
            }
            if ("SubscriptionStatus".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUBSCRIPTIONSTATUS, code);
            }
            if ("SubscriptionTopic".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUBSCRIPTIONTOPIC, code);
            }
            if ("Substance".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUBSTANCE, code);
            }
            if ("SubstanceDefinition".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUBSTANCEDEFINITION, code);
            }
            if ("SupplyDelivery".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUPPLYDELIVERY, code);
            }
            if ("SupplyRequest".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.SUPPLYREQUEST, code);
            }
            if ("Task".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TASK, code);
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TERMINOLOGYCAPABILITIES, code);
            }
            if ("TestReport".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TESTREPORT, code);
            }
            if ("TestScript".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.TESTSCRIPT, code);
            }
            if ("ValueSet".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.VALUESET, code);
            }
            if ("VerificationResult".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.VERIFICATIONRESULT, code);
            }
            if ("VisionPrescription".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.VISIONPRESCRIPTION, code);
            }
            if ("Parameters".equals(codeString)) {
                return new Enumeration<FHIRDefinedType>(this, FHIRDefinedType.PARAMETERS, code);
            }
            throw new FHIRException("Unknown FHIRDefinedType code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRDefinedType code) {
            if (code == FHIRDefinedType.ADDRESS) {
                return "Address";
            }
            if (code == FHIRDefinedType.AGE) {
                return "Age";
            }
            if (code == FHIRDefinedType.ANNOTATION) {
                return "Annotation";
            }
            if (code == FHIRDefinedType.ATTACHMENT) {
                return "Attachment";
            }
            if (code == FHIRDefinedType.BACKBONEELEMENT) {
                return "BackboneElement";
            }
            if (code == FHIRDefinedType.CODEABLECONCEPT) {
                return "CodeableConcept";
            }
            if (code == FHIRDefinedType.CODEABLEREFERENCE) {
                return "CodeableReference";
            }
            if (code == FHIRDefinedType.CODING) {
                return "Coding";
            }
            if (code == FHIRDefinedType.CONTACTDETAIL) {
                return "ContactDetail";
            }
            if (code == FHIRDefinedType.CONTACTPOINT) {
                return "ContactPoint";
            }
            if (code == FHIRDefinedType.CONTRIBUTOR) {
                return "Contributor";
            }
            if (code == FHIRDefinedType.COUNT) {
                return "Count";
            }
            if (code == FHIRDefinedType.DATAREQUIREMENT) {
                return "DataRequirement";
            }
            if (code == FHIRDefinedType.DATATYPE) {
                return "DataType";
            }
            if (code == FHIRDefinedType.DISTANCE) {
                return "Distance";
            }
            if (code == FHIRDefinedType.DOSAGE) {
                return "Dosage";
            }
            if (code == FHIRDefinedType.DURATION) {
                return "Duration";
            }
            if (code == FHIRDefinedType.ELEMENT) {
                return "Element";
            }
            if (code == FHIRDefinedType.ELEMENTDEFINITION) {
                return "ElementDefinition";
            }
            if (code == FHIRDefinedType.EXPRESSION) {
                return "Expression";
            }
            if (code == FHIRDefinedType.EXTENSION) {
                return "Extension";
            }
            if (code == FHIRDefinedType.HUMANNAME) {
                return "HumanName";
            }
            if (code == FHIRDefinedType.IDENTIFIER) {
                return "Identifier";
            }
            if (code == FHIRDefinedType.MARKETINGSTATUS) {
                return "MarketingStatus";
            }
            if (code == FHIRDefinedType.META) {
                return "Meta";
            }
            if (code == FHIRDefinedType.MONEY) {
                return "Money";
            }
            if (code == FHIRDefinedType.MONEYQUANTITY) {
                return "MoneyQuantity";
            }
            if (code == FHIRDefinedType.NARRATIVE) {
                return "Narrative";
            }
            if (code == FHIRDefinedType.PARAMETERDEFINITION) {
                return "ParameterDefinition";
            }
            if (code == FHIRDefinedType.PERIOD) {
                return "Period";
            }
            if (code == FHIRDefinedType.POPULATION) {
                return "Population";
            }
            if (code == FHIRDefinedType.PRODCHARACTERISTIC) {
                return "ProdCharacteristic";
            }
            if (code == FHIRDefinedType.PRODUCTSHELFLIFE) {
                return "ProductShelfLife";
            }
            if (code == FHIRDefinedType.QUANTITY) {
                return "Quantity";
            }
            if (code == FHIRDefinedType.RANGE) {
                return "Range";
            }
            if (code == FHIRDefinedType.RATIO) {
                return "Ratio";
            }
            if (code == FHIRDefinedType.RATIORANGE) {
                return "RatioRange";
            }
            if (code == FHIRDefinedType.REFERENCE) {
                return "Reference";
            }
            if (code == FHIRDefinedType.RELATEDARTIFACT) {
                return "RelatedArtifact";
            }
            if (code == FHIRDefinedType.SAMPLEDDATA) {
                return "SampledData";
            }
            if (code == FHIRDefinedType.SIGNATURE) {
                return "Signature";
            }
            if (code == FHIRDefinedType.SIMPLEQUANTITY) {
                return "SimpleQuantity";
            }
            if (code == FHIRDefinedType.TIMING) {
                return "Timing";
            }
            if (code == FHIRDefinedType.TRIGGERDEFINITION) {
                return "TriggerDefinition";
            }
            if (code == FHIRDefinedType.USAGECONTEXT) {
                return "UsageContext";
            }
            if (code == FHIRDefinedType.BASE64BINARY) {
                return "base64Binary";
            }
            if (code == FHIRDefinedType.BOOLEAN) {
                return "boolean";
            }
            if (code == FHIRDefinedType.CANONICAL) {
                return "canonical";
            }
            if (code == FHIRDefinedType.CODE) {
                return "code";
            }
            if (code == FHIRDefinedType.DATE) {
                return TestScript.SP_DATE;
            }
            if (code == FHIRDefinedType.DATETIME) {
                return "dateTime";
            }
            if (code == FHIRDefinedType.DECIMAL) {
                return "decimal";
            }
            if (code == FHIRDefinedType.ID) {
                return "id";
            }
            if (code == FHIRDefinedType.INSTANT) {
                return "instant";
            }
            if (code == FHIRDefinedType.INTEGER) {
                return "integer";
            }
            if (code == FHIRDefinedType.MARKDOWN) {
                return "markdown";
            }
            if (code == FHIRDefinedType.OID) {
                return "oid";
            }
            if (code == FHIRDefinedType.POSITIVEINT) {
                return "positiveInt";
            }
            if (code == FHIRDefinedType.STRING) {
                return "string";
            }
            if (code == FHIRDefinedType.TIME) {
                return "time";
            }
            if (code == FHIRDefinedType.UNSIGNEDINT) {
                return "unsignedInt";
            }
            if (code == FHIRDefinedType.URI) {
                return "uri";
            }
            if (code == FHIRDefinedType.URL) {
                return TestScript.SP_URL;
            }
            if (code == FHIRDefinedType.UUID) {
                return "uuid";
            }
            if (code == FHIRDefinedType.XHTML) {
                return "xhtml";
            }
            if (code == FHIRDefinedType.RESOURCE) {
                return "Resource";
            }
            if (code == FHIRDefinedType.BINARY) {
                return "Binary";
            }
            if (code == FHIRDefinedType.BUNDLE) {
                return "Bundle";
            }
            if (code == FHIRDefinedType.DOMAINRESOURCE) {
                return "DomainResource";
            }
            if (code == FHIRDefinedType.ACCOUNT) {
                return "Account";
            }
            if (code == FHIRDefinedType.ACTIVITYDEFINITION) {
                return "ActivityDefinition";
            }
            if (code == FHIRDefinedType.ADMINISTRABLEPRODUCTDEFINITION) {
                return "AdministrableProductDefinition";
            }
            if (code == FHIRDefinedType.ADVERSEEVENT) {
                return "AdverseEvent";
            }
            if (code == FHIRDefinedType.ALLERGYINTOLERANCE) {
                return "AllergyIntolerance";
            }
            if (code == FHIRDefinedType.APPOINTMENT) {
                return "Appointment";
            }
            if (code == FHIRDefinedType.APPOINTMENTRESPONSE) {
                return "AppointmentResponse";
            }
            if (code == FHIRDefinedType.AUDITEVENT) {
                return "AuditEvent";
            }
            if (code == FHIRDefinedType.BASIC) {
                return "Basic";
            }
            if (code == FHIRDefinedType.BIOLOGICALLYDERIVEDPRODUCT) {
                return "BiologicallyDerivedProduct";
            }
            if (code == FHIRDefinedType.BODYSTRUCTURE) {
                return "BodyStructure";
            }
            if (code == FHIRDefinedType.CAPABILITYSTATEMENT) {
                return "CapabilityStatement";
            }
            if (code == FHIRDefinedType.CAREPLAN) {
                return "CarePlan";
            }
            if (code == FHIRDefinedType.CARETEAM) {
                return "CareTeam";
            }
            if (code == FHIRDefinedType.CATALOGENTRY) {
                return "CatalogEntry";
            }
            if (code == FHIRDefinedType.CHARGEITEM) {
                return "ChargeItem";
            }
            if (code == FHIRDefinedType.CHARGEITEMDEFINITION) {
                return "ChargeItemDefinition";
            }
            if (code == FHIRDefinedType.CITATION) {
                return "Citation";
            }
            if (code == FHIRDefinedType.CLAIM) {
                return "Claim";
            }
            if (code == FHIRDefinedType.CLAIMRESPONSE) {
                return "ClaimResponse";
            }
            if (code == FHIRDefinedType.CLINICALIMPRESSION) {
                return "ClinicalImpression";
            }
            if (code == FHIRDefinedType.CLINICALUSEDEFINITION) {
                return "ClinicalUseDefinition";
            }
            if (code == FHIRDefinedType.CODESYSTEM) {
                return "CodeSystem";
            }
            if (code == FHIRDefinedType.COMMUNICATION) {
                return "Communication";
            }
            if (code == FHIRDefinedType.COMMUNICATIONREQUEST) {
                return "CommunicationRequest";
            }
            if (code == FHIRDefinedType.COMPARTMENTDEFINITION) {
                return "CompartmentDefinition";
            }
            if (code == FHIRDefinedType.COMPOSITION) {
                return "Composition";
            }
            if (code == FHIRDefinedType.CONCEPTMAP) {
                return "ConceptMap";
            }
            if (code == FHIRDefinedType.CONDITION) {
                return "Condition";
            }
            if (code == FHIRDefinedType.CONSENT) {
                return "Consent";
            }
            if (code == FHIRDefinedType.CONTRACT) {
                return "Contract";
            }
            if (code == FHIRDefinedType.COVERAGE) {
                return "Coverage";
            }
            if (code == FHIRDefinedType.COVERAGEELIGIBILITYREQUEST) {
                return "CoverageEligibilityRequest";
            }
            if (code == FHIRDefinedType.COVERAGEELIGIBILITYRESPONSE) {
                return "CoverageEligibilityResponse";
            }
            if (code == FHIRDefinedType.DETECTEDISSUE) {
                return "DetectedIssue";
            }
            if (code == FHIRDefinedType.DEVICE) {
                return "Device";
            }
            if (code == FHIRDefinedType.DEVICEDEFINITION) {
                return "DeviceDefinition";
            }
            if (code == FHIRDefinedType.DEVICEMETRIC) {
                return "DeviceMetric";
            }
            if (code == FHIRDefinedType.DEVICEREQUEST) {
                return "DeviceRequest";
            }
            if (code == FHIRDefinedType.DEVICEUSESTATEMENT) {
                return "DeviceUseStatement";
            }
            if (code == FHIRDefinedType.DIAGNOSTICREPORT) {
                return "DiagnosticReport";
            }
            if (code == FHIRDefinedType.DOCUMENTMANIFEST) {
                return "DocumentManifest";
            }
            if (code == FHIRDefinedType.DOCUMENTREFERENCE) {
                return "DocumentReference";
            }
            if (code == FHIRDefinedType.ENCOUNTER) {
                return "Encounter";
            }
            if (code == FHIRDefinedType.ENDPOINT) {
                return "Endpoint";
            }
            if (code == FHIRDefinedType.ENROLLMENTREQUEST) {
                return "EnrollmentRequest";
            }
            if (code == FHIRDefinedType.ENROLLMENTRESPONSE) {
                return "EnrollmentResponse";
            }
            if (code == FHIRDefinedType.EPISODEOFCARE) {
                return "EpisodeOfCare";
            }
            if (code == FHIRDefinedType.EVENTDEFINITION) {
                return "EventDefinition";
            }
            if (code == FHIRDefinedType.EVIDENCE) {
                return "Evidence";
            }
            if (code == FHIRDefinedType.EVIDENCEREPORT) {
                return "EvidenceReport";
            }
            if (code == FHIRDefinedType.EVIDENCEVARIABLE) {
                return "EvidenceVariable";
            }
            if (code == FHIRDefinedType.EXAMPLESCENARIO) {
                return "ExampleScenario";
            }
            if (code == FHIRDefinedType.EXPLANATIONOFBENEFIT) {
                return "ExplanationOfBenefit";
            }
            if (code == FHIRDefinedType.FAMILYMEMBERHISTORY) {
                return "FamilyMemberHistory";
            }
            if (code == FHIRDefinedType.FLAG) {
                return "Flag";
            }
            if (code == FHIRDefinedType.GOAL) {
                return "Goal";
            }
            if (code == FHIRDefinedType.GRAPHDEFINITION) {
                return "GraphDefinition";
            }
            if (code == FHIRDefinedType.GROUP) {
                return "Group";
            }
            if (code == FHIRDefinedType.GUIDANCERESPONSE) {
                return "GuidanceResponse";
            }
            if (code == FHIRDefinedType.HEALTHCARESERVICE) {
                return "HealthcareService";
            }
            if (code == FHIRDefinedType.IMAGINGSTUDY) {
                return "ImagingStudy";
            }
            if (code == FHIRDefinedType.IMMUNIZATION) {
                return "Immunization";
            }
            if (code == FHIRDefinedType.IMMUNIZATIONEVALUATION) {
                return "ImmunizationEvaluation";
            }
            if (code == FHIRDefinedType.IMMUNIZATIONRECOMMENDATION) {
                return "ImmunizationRecommendation";
            }
            if (code == FHIRDefinedType.IMPLEMENTATIONGUIDE) {
                return "ImplementationGuide";
            }
            if (code == FHIRDefinedType.INGREDIENT) {
                return "Ingredient";
            }
            if (code == FHIRDefinedType.INSURANCEPLAN) {
                return "InsurancePlan";
            }
            if (code == FHIRDefinedType.INVOICE) {
                return "Invoice";
            }
            if (code == FHIRDefinedType.LIBRARY) {
                return "Library";
            }
            if (code == FHIRDefinedType.LINKAGE) {
                return "Linkage";
            }
            if (code == FHIRDefinedType.LIST) {
                return "List";
            }
            if (code == FHIRDefinedType.LOCATION) {
                return "Location";
            }
            if (code == FHIRDefinedType.MANUFACTUREDITEMDEFINITION) {
                return "ManufacturedItemDefinition";
            }
            if (code == FHIRDefinedType.MEASURE) {
                return "Measure";
            }
            if (code == FHIRDefinedType.MEASUREREPORT) {
                return "MeasureReport";
            }
            if (code == FHIRDefinedType.MEDIA) {
                return "Media";
            }
            if (code == FHIRDefinedType.MEDICATION) {
                return "Medication";
            }
            if (code == FHIRDefinedType.MEDICATIONADMINISTRATION) {
                return "MedicationAdministration";
            }
            if (code == FHIRDefinedType.MEDICATIONDISPENSE) {
                return "MedicationDispense";
            }
            if (code == FHIRDefinedType.MEDICATIONKNOWLEDGE) {
                return "MedicationKnowledge";
            }
            if (code == FHIRDefinedType.MEDICATIONREQUEST) {
                return "MedicationRequest";
            }
            if (code == FHIRDefinedType.MEDICATIONSTATEMENT) {
                return "MedicationStatement";
            }
            if (code == FHIRDefinedType.MEDICINALPRODUCTDEFINITION) {
                return "MedicinalProductDefinition";
            }
            if (code == FHIRDefinedType.MESSAGEDEFINITION) {
                return "MessageDefinition";
            }
            if (code == FHIRDefinedType.MESSAGEHEADER) {
                return "MessageHeader";
            }
            if (code == FHIRDefinedType.MOLECULARSEQUENCE) {
                return "MolecularSequence";
            }
            if (code == FHIRDefinedType.NAMINGSYSTEM) {
                return "NamingSystem";
            }
            if (code == FHIRDefinedType.NUTRITIONORDER) {
                return "NutritionOrder";
            }
            if (code == FHIRDefinedType.NUTRITIONPRODUCT) {
                return "NutritionProduct";
            }
            if (code == FHIRDefinedType.OBSERVATION) {
                return "Observation";
            }
            if (code == FHIRDefinedType.OBSERVATIONDEFINITION) {
                return "ObservationDefinition";
            }
            if (code == FHIRDefinedType.OPERATIONDEFINITION) {
                return "OperationDefinition";
            }
            if (code == FHIRDefinedType.OPERATIONOUTCOME) {
                return "OperationOutcome";
            }
            if (code == FHIRDefinedType.ORGANIZATION) {
                return "Organization";
            }
            if (code == FHIRDefinedType.ORGANIZATIONAFFILIATION) {
                return "OrganizationAffiliation";
            }
            if (code == FHIRDefinedType.PACKAGEDPRODUCTDEFINITION) {
                return "PackagedProductDefinition";
            }
            if (code == FHIRDefinedType.PATIENT) {
                return "Patient";
            }
            if (code == FHIRDefinedType.PAYMENTNOTICE) {
                return "PaymentNotice";
            }
            if (code == FHIRDefinedType.PAYMENTRECONCILIATION) {
                return "PaymentReconciliation";
            }
            if (code == FHIRDefinedType.PERSON) {
                return "Person";
            }
            if (code == FHIRDefinedType.PLANDEFINITION) {
                return "PlanDefinition";
            }
            if (code == FHIRDefinedType.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == FHIRDefinedType.PRACTITIONERROLE) {
                return "PractitionerRole";
            }
            if (code == FHIRDefinedType.PROCEDURE) {
                return "Procedure";
            }
            if (code == FHIRDefinedType.PROVENANCE) {
                return "Provenance";
            }
            if (code == FHIRDefinedType.QUESTIONNAIRE) {
                return "Questionnaire";
            }
            if (code == FHIRDefinedType.QUESTIONNAIRERESPONSE) {
                return "QuestionnaireResponse";
            }
            if (code == FHIRDefinedType.REGULATEDAUTHORIZATION) {
                return "RegulatedAuthorization";
            }
            if (code == FHIRDefinedType.RELATEDPERSON) {
                return "RelatedPerson";
            }
            if (code == FHIRDefinedType.REQUESTGROUP) {
                return "RequestGroup";
            }
            if (code == FHIRDefinedType.RESEARCHDEFINITION) {
                return "ResearchDefinition";
            }
            if (code == FHIRDefinedType.RESEARCHELEMENTDEFINITION) {
                return "ResearchElementDefinition";
            }
            if (code == FHIRDefinedType.RESEARCHSTUDY) {
                return "ResearchStudy";
            }
            if (code == FHIRDefinedType.RESEARCHSUBJECT) {
                return "ResearchSubject";
            }
            if (code == FHIRDefinedType.RISKASSESSMENT) {
                return "RiskAssessment";
            }
            if (code == FHIRDefinedType.SCHEDULE) {
                return "Schedule";
            }
            if (code == FHIRDefinedType.SEARCHPARAMETER) {
                return "SearchParameter";
            }
            if (code == FHIRDefinedType.SERVICEREQUEST) {
                return "ServiceRequest";
            }
            if (code == FHIRDefinedType.SLOT) {
                return "Slot";
            }
            if (code == FHIRDefinedType.SPECIMEN) {
                return "Specimen";
            }
            if (code == FHIRDefinedType.SPECIMENDEFINITION) {
                return "SpecimenDefinition";
            }
            if (code == FHIRDefinedType.STRUCTUREDEFINITION) {
                return "StructureDefinition";
            }
            if (code == FHIRDefinedType.STRUCTUREMAP) {
                return "StructureMap";
            }
            if (code == FHIRDefinedType.SUBSCRIPTION) {
                return "Subscription";
            }
            if (code == FHIRDefinedType.SUBSCRIPTIONSTATUS) {
                return "SubscriptionStatus";
            }
            if (code == FHIRDefinedType.SUBSCRIPTIONTOPIC) {
                return "SubscriptionTopic";
            }
            if (code == FHIRDefinedType.SUBSTANCE) {
                return "Substance";
            }
            if (code == FHIRDefinedType.SUBSTANCEDEFINITION) {
                return "SubstanceDefinition";
            }
            if (code == FHIRDefinedType.SUPPLYDELIVERY) {
                return "SupplyDelivery";
            }
            if (code == FHIRDefinedType.SUPPLYREQUEST) {
                return "SupplyRequest";
            }
            if (code == FHIRDefinedType.TASK) {
                return "Task";
            }
            if (code == FHIRDefinedType.TERMINOLOGYCAPABILITIES) {
                return "TerminologyCapabilities";
            }
            if (code == FHIRDefinedType.TESTREPORT) {
                return "TestReport";
            }
            if (code == FHIRDefinedType.TESTSCRIPT) {
                return "TestScript";
            }
            if (code == FHIRDefinedType.VALUESET) {
                return "ValueSet";
            }
            if (code == FHIRDefinedType.VERIFICATIONRESULT) {
                return "VerificationResult";
            }
            if (code == FHIRDefinedType.VISIONPRESCRIPTION) {
                return "VisionPrescription";
            }
            if (code == FHIRDefinedType.PARAMETERS) {
                return "Parameters";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRDefinedType code) {
            return code.getSystem();
        }
    }

    public static enum FHIRDefinedType {
        ADDRESS,
        AGE,
        ANNOTATION,
        ATTACHMENT,
        BACKBONEELEMENT,
        CODEABLECONCEPT,
        CODEABLEREFERENCE,
        CODING,
        CONTACTDETAIL,
        CONTACTPOINT,
        CONTRIBUTOR,
        COUNT,
        DATAREQUIREMENT,
        DATATYPE,
        DISTANCE,
        DOSAGE,
        DURATION,
        ELEMENT,
        ELEMENTDEFINITION,
        EXPRESSION,
        EXTENSION,
        HUMANNAME,
        IDENTIFIER,
        MARKETINGSTATUS,
        META,
        MONEY,
        MONEYQUANTITY,
        NARRATIVE,
        PARAMETERDEFINITION,
        PERIOD,
        POPULATION,
        PRODCHARACTERISTIC,
        PRODUCTSHELFLIFE,
        QUANTITY,
        RANGE,
        RATIO,
        RATIORANGE,
        REFERENCE,
        RELATEDARTIFACT,
        SAMPLEDDATA,
        SIGNATURE,
        SIMPLEQUANTITY,
        TIMING,
        TRIGGERDEFINITION,
        USAGECONTEXT,
        BASE64BINARY,
        BOOLEAN,
        CANONICAL,
        CODE,
        DATE,
        DATETIME,
        DECIMAL,
        ID,
        INSTANT,
        INTEGER,
        MARKDOWN,
        OID,
        POSITIVEINT,
        STRING,
        TIME,
        UNSIGNEDINT,
        URI,
        URL,
        UUID,
        XHTML,
        RESOURCE,
        BINARY,
        BUNDLE,
        DOMAINRESOURCE,
        ACCOUNT,
        ACTIVITYDEFINITION,
        ADMINISTRABLEPRODUCTDEFINITION,
        ADVERSEEVENT,
        ALLERGYINTOLERANCE,
        APPOINTMENT,
        APPOINTMENTRESPONSE,
        AUDITEVENT,
        BASIC,
        BIOLOGICALLYDERIVEDPRODUCT,
        BODYSTRUCTURE,
        CAPABILITYSTATEMENT,
        CAREPLAN,
        CARETEAM,
        CATALOGENTRY,
        CHARGEITEM,
        CHARGEITEMDEFINITION,
        CITATION,
        CLAIM,
        CLAIMRESPONSE,
        CLINICALIMPRESSION,
        CLINICALUSEDEFINITION,
        CODESYSTEM,
        COMMUNICATION,
        COMMUNICATIONREQUEST,
        COMPARTMENTDEFINITION,
        COMPOSITION,
        CONCEPTMAP,
        CONDITION,
        CONSENT,
        CONTRACT,
        COVERAGE,
        COVERAGEELIGIBILITYREQUEST,
        COVERAGEELIGIBILITYRESPONSE,
        DETECTEDISSUE,
        DEVICE,
        DEVICEDEFINITION,
        DEVICEMETRIC,
        DEVICEREQUEST,
        DEVICEUSESTATEMENT,
        DIAGNOSTICREPORT,
        DOCUMENTMANIFEST,
        DOCUMENTREFERENCE,
        ENCOUNTER,
        ENDPOINT,
        ENROLLMENTREQUEST,
        ENROLLMENTRESPONSE,
        EPISODEOFCARE,
        EVENTDEFINITION,
        EVIDENCE,
        EVIDENCEREPORT,
        EVIDENCEVARIABLE,
        EXAMPLESCENARIO,
        EXPLANATIONOFBENEFIT,
        FAMILYMEMBERHISTORY,
        FLAG,
        GOAL,
        GRAPHDEFINITION,
        GROUP,
        GUIDANCERESPONSE,
        HEALTHCARESERVICE,
        IMAGINGSTUDY,
        IMMUNIZATION,
        IMMUNIZATIONEVALUATION,
        IMMUNIZATIONRECOMMENDATION,
        IMPLEMENTATIONGUIDE,
        INGREDIENT,
        INSURANCEPLAN,
        INVOICE,
        LIBRARY,
        LINKAGE,
        LIST,
        LOCATION,
        MANUFACTUREDITEMDEFINITION,
        MEASURE,
        MEASUREREPORT,
        MEDIA,
        MEDICATION,
        MEDICATIONADMINISTRATION,
        MEDICATIONDISPENSE,
        MEDICATIONKNOWLEDGE,
        MEDICATIONREQUEST,
        MEDICATIONSTATEMENT,
        MEDICINALPRODUCTDEFINITION,
        MESSAGEDEFINITION,
        MESSAGEHEADER,
        MOLECULARSEQUENCE,
        NAMINGSYSTEM,
        NUTRITIONORDER,
        NUTRITIONPRODUCT,
        OBSERVATION,
        OBSERVATIONDEFINITION,
        OPERATIONDEFINITION,
        OPERATIONOUTCOME,
        ORGANIZATION,
        ORGANIZATIONAFFILIATION,
        PACKAGEDPRODUCTDEFINITION,
        PATIENT,
        PAYMENTNOTICE,
        PAYMENTRECONCILIATION,
        PERSON,
        PLANDEFINITION,
        PRACTITIONER,
        PRACTITIONERROLE,
        PROCEDURE,
        PROVENANCE,
        QUESTIONNAIRE,
        QUESTIONNAIRERESPONSE,
        REGULATEDAUTHORIZATION,
        RELATEDPERSON,
        REQUESTGROUP,
        RESEARCHDEFINITION,
        RESEARCHELEMENTDEFINITION,
        RESEARCHSTUDY,
        RESEARCHSUBJECT,
        RISKASSESSMENT,
        SCHEDULE,
        SEARCHPARAMETER,
        SERVICEREQUEST,
        SLOT,
        SPECIMEN,
        SPECIMENDEFINITION,
        STRUCTUREDEFINITION,
        STRUCTUREMAP,
        SUBSCRIPTION,
        SUBSCRIPTIONSTATUS,
        SUBSCRIPTIONTOPIC,
        SUBSTANCE,
        SUBSTANCEDEFINITION,
        SUPPLYDELIVERY,
        SUPPLYREQUEST,
        TASK,
        TERMINOLOGYCAPABILITIES,
        TESTREPORT,
        TESTSCRIPT,
        VALUESET,
        VERIFICATIONRESULT,
        VISIONPRESCRIPTION,
        PARAMETERS,
        NULL;


        public static FHIRDefinedType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Address".equals(codeString)) {
                return ADDRESS;
            }
            if ("Age".equals(codeString)) {
                return AGE;
            }
            if ("Annotation".equals(codeString)) {
                return ANNOTATION;
            }
            if ("Attachment".equals(codeString)) {
                return ATTACHMENT;
            }
            if ("BackboneElement".equals(codeString)) {
                return BACKBONEELEMENT;
            }
            if ("CodeableConcept".equals(codeString)) {
                return CODEABLECONCEPT;
            }
            if ("CodeableReference".equals(codeString)) {
                return CODEABLEREFERENCE;
            }
            if ("Coding".equals(codeString)) {
                return CODING;
            }
            if ("ContactDetail".equals(codeString)) {
                return CONTACTDETAIL;
            }
            if ("ContactPoint".equals(codeString)) {
                return CONTACTPOINT;
            }
            if ("Contributor".equals(codeString)) {
                return CONTRIBUTOR;
            }
            if ("Count".equals(codeString)) {
                return COUNT;
            }
            if ("DataRequirement".equals(codeString)) {
                return DATAREQUIREMENT;
            }
            if ("DataType".equals(codeString)) {
                return DATATYPE;
            }
            if ("Distance".equals(codeString)) {
                return DISTANCE;
            }
            if ("Dosage".equals(codeString)) {
                return DOSAGE;
            }
            if ("Duration".equals(codeString)) {
                return DURATION;
            }
            if ("Element".equals(codeString)) {
                return ELEMENT;
            }
            if ("ElementDefinition".equals(codeString)) {
                return ELEMENTDEFINITION;
            }
            if ("Expression".equals(codeString)) {
                return EXPRESSION;
            }
            if ("Extension".equals(codeString)) {
                return EXTENSION;
            }
            if ("HumanName".equals(codeString)) {
                return HUMANNAME;
            }
            if ("Identifier".equals(codeString)) {
                return IDENTIFIER;
            }
            if ("MarketingStatus".equals(codeString)) {
                return MARKETINGSTATUS;
            }
            if ("Meta".equals(codeString)) {
                return META;
            }
            if ("Money".equals(codeString)) {
                return MONEY;
            }
            if ("MoneyQuantity".equals(codeString)) {
                return MONEYQUANTITY;
            }
            if ("Narrative".equals(codeString)) {
                return NARRATIVE;
            }
            if ("ParameterDefinition".equals(codeString)) {
                return PARAMETERDEFINITION;
            }
            if ("Period".equals(codeString)) {
                return PERIOD;
            }
            if ("Population".equals(codeString)) {
                return POPULATION;
            }
            if ("ProdCharacteristic".equals(codeString)) {
                return PRODCHARACTERISTIC;
            }
            if ("ProductShelfLife".equals(codeString)) {
                return PRODUCTSHELFLIFE;
            }
            if ("Quantity".equals(codeString)) {
                return QUANTITY;
            }
            if ("Range".equals(codeString)) {
                return RANGE;
            }
            if ("Ratio".equals(codeString)) {
                return RATIO;
            }
            if ("RatioRange".equals(codeString)) {
                return RATIORANGE;
            }
            if ("Reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("RelatedArtifact".equals(codeString)) {
                return RELATEDARTIFACT;
            }
            if ("SampledData".equals(codeString)) {
                return SAMPLEDDATA;
            }
            if ("Signature".equals(codeString)) {
                return SIGNATURE;
            }
            if ("SimpleQuantity".equals(codeString)) {
                return SIMPLEQUANTITY;
            }
            if ("Timing".equals(codeString)) {
                return TIMING;
            }
            if ("TriggerDefinition".equals(codeString)) {
                return TRIGGERDEFINITION;
            }
            if ("UsageContext".equals(codeString)) {
                return USAGECONTEXT;
            }
            if ("base64Binary".equals(codeString)) {
                return BASE64BINARY;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("canonical".equals(codeString)) {
                return CANONICAL;
            }
            if ("code".equals(codeString)) {
                return CODE;
            }
            if (TestScript.SP_DATE.equals(codeString)) {
                return DATE;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("decimal".equals(codeString)) {
                return DECIMAL;
            }
            if ("id".equals(codeString)) {
                return ID;
            }
            if ("instant".equals(codeString)) {
                return INSTANT;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if ("markdown".equals(codeString)) {
                return MARKDOWN;
            }
            if ("oid".equals(codeString)) {
                return OID;
            }
            if ("positiveInt".equals(codeString)) {
                return POSITIVEINT;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("time".equals(codeString)) {
                return TIME;
            }
            if ("unsignedInt".equals(codeString)) {
                return UNSIGNEDINT;
            }
            if ("uri".equals(codeString)) {
                return URI;
            }
            if (TestScript.SP_URL.equals(codeString)) {
                return URL;
            }
            if ("uuid".equals(codeString)) {
                return UUID;
            }
            if ("xhtml".equals(codeString)) {
                return XHTML;
            }
            if ("Resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("Binary".equals(codeString)) {
                return BINARY;
            }
            if ("Bundle".equals(codeString)) {
                return BUNDLE;
            }
            if ("DomainResource".equals(codeString)) {
                return DOMAINRESOURCE;
            }
            if ("Account".equals(codeString)) {
                return ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return ACTIVITYDEFINITION;
            }
            if ("AdministrableProductDefinition".equals(codeString)) {
                return ADMINISTRABLEPRODUCTDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return BASIC;
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return BIOLOGICALLYDERIVEDPRODUCT;
            }
            if ("BodyStructure".equals(codeString)) {
                return BODYSTRUCTURE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return CAPABILITYSTATEMENT;
            }
            if ("CarePlan".equals(codeString)) {
                return CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return CARETEAM;
            }
            if ("CatalogEntry".equals(codeString)) {
                return CATALOGENTRY;
            }
            if ("ChargeItem".equals(codeString)) {
                return CHARGEITEM;
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return CHARGEITEMDEFINITION;
            }
            if ("Citation".equals(codeString)) {
                return CITATION;
            }
            if ("Claim".equals(codeString)) {
                return CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return CLINICALIMPRESSION;
            }
            if ("ClinicalUseDefinition".equals(codeString)) {
                return CLINICALUSEDEFINITION;
            }
            if ("CodeSystem".equals(codeString)) {
                return CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return CONDITION;
            }
            if ("Consent".equals(codeString)) {
                return CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return COVERAGE;
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return COVERAGEELIGIBILITYREQUEST;
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return COVERAGEELIGIBILITYRESPONSE;
            }
            if ("DetectedIssue".equals(codeString)) {
                return DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return DEVICE;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return DEVICEDEFINITION;
            }
            if ("DeviceMetric".equals(codeString)) {
                return DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return DOCUMENTREFERENCE;
            }
            if ("Encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return EPISODEOFCARE;
            }
            if ("EventDefinition".equals(codeString)) {
                return EVENTDEFINITION;
            }
            if ("Evidence".equals(codeString)) {
                return EVIDENCE;
            }
            if ("EvidenceReport".equals(codeString)) {
                return EVIDENCEREPORT;
            }
            if ("EvidenceVariable".equals(codeString)) {
                return EVIDENCEVARIABLE;
            }
            if ("ExampleScenario".equals(codeString)) {
                return EXAMPLESCENARIO;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FLAG;
            }
            if ("Goal".equals(codeString)) {
                return GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return HEALTHCARESERVICE;
            }
            if ("ImagingStudy".equals(codeString)) {
                return IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return IMMUNIZATION;
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return IMMUNIZATIONEVALUATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return IMPLEMENTATIONGUIDE;
            }
            if ("Ingredient".equals(codeString)) {
                return INGREDIENT;
            }
            if ("InsurancePlan".equals(codeString)) {
                return INSURANCEPLAN;
            }
            if ("Invoice".equals(codeString)) {
                return INVOICE;
            }
            if ("Library".equals(codeString)) {
                return LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return LINKAGE;
            }
            if ("List".equals(codeString)) {
                return LIST;
            }
            if ("Location".equals(codeString)) {
                return LOCATION;
            }
            if ("ManufacturedItemDefinition".equals(codeString)) {
                return MANUFACTUREDITEMDEFINITION;
            }
            if ("Measure".equals(codeString)) {
                return MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return MEASUREREPORT;
            }
            if ("Media".equals(codeString)) {
                return MEDIA;
            }
            if ("Medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return MEDICATIONDISPENSE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return MEDICATIONKNOWLEDGE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return MEDICATIONREQUEST;
            }
            if ("MedicationStatement".equals(codeString)) {
                return MEDICATIONSTATEMENT;
            }
            if ("MedicinalProductDefinition".equals(codeString)) {
                return MEDICINALPRODUCTDEFINITION;
            }
            if ("MessageDefinition".equals(codeString)) {
                return MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return MESSAGEHEADER;
            }
            if ("MolecularSequence".equals(codeString)) {
                return MOLECULARSEQUENCE;
            }
            if ("NamingSystem".equals(codeString)) {
                return NAMINGSYSTEM;
            }
            if ("NutritionOrder".equals(codeString)) {
                return NUTRITIONORDER;
            }
            if ("NutritionProduct".equals(codeString)) {
                return NUTRITIONPRODUCT;
            }
            if ("Observation".equals(codeString)) {
                return OBSERVATION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return OBSERVATIONDEFINITION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return ORGANIZATION;
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return ORGANIZATIONAFFILIATION;
            }
            if ("PackagedProductDefinition".equals(codeString)) {
                return PACKAGEDPRODUCTDEFINITION;
            }
            if ("Patient".equals(codeString)) {
                return PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return PROCEDURE;
            }
            if ("Provenance".equals(codeString)) {
                return PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return QUESTIONNAIRERESPONSE;
            }
            if ("RegulatedAuthorization".equals(codeString)) {
                return REGULATEDAUTHORIZATION;
            }
            if ("RelatedPerson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return REQUESTGROUP;
            }
            if ("ResearchDefinition".equals(codeString)) {
                return RESEARCHDEFINITION;
            }
            if ("ResearchElementDefinition".equals(codeString)) {
                return RESEARCHELEMENTDEFINITION;
            }
            if ("ResearchStudy".equals(codeString)) {
                return RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return RESEARCHSUBJECT;
            }
            if ("RiskAssessment".equals(codeString)) {
                return RISKASSESSMENT;
            }
            if ("Schedule".equals(codeString)) {
                return SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return SEARCHPARAMETER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return SERVICEREQUEST;
            }
            if ("Slot".equals(codeString)) {
                return SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return SPECIMEN;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return SPECIMENDEFINITION;
            }
            if ("StructureDefinition".equals(codeString)) {
                return STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return SUBSCRIPTION;
            }
            if ("SubscriptionStatus".equals(codeString)) {
                return SUBSCRIPTIONSTATUS;
            }
            if ("SubscriptionTopic".equals(codeString)) {
                return SUBSCRIPTIONTOPIC;
            }
            if ("Substance".equals(codeString)) {
                return SUBSTANCE;
            }
            if ("SubstanceDefinition".equals(codeString)) {
                return SUBSTANCEDEFINITION;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return TASK;
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return TERMINOLOGYCAPABILITIES;
            }
            if ("TestReport".equals(codeString)) {
                return TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return TESTSCRIPT;
            }
            if ("ValueSet".equals(codeString)) {
                return VALUESET;
            }
            if ("VerificationResult".equals(codeString)) {
                return VERIFICATIONRESULT;
            }
            if ("VisionPrescription".equals(codeString)) {
                return VISIONPRESCRIPTION;
            }
            if ("Parameters".equals(codeString)) {
                return PARAMETERS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRDefinedType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ADDRESS: {
                    return "Address";
                }
                case AGE: {
                    return "Age";
                }
                case ANNOTATION: {
                    return "Annotation";
                }
                case ATTACHMENT: {
                    return "Attachment";
                }
                case BACKBONEELEMENT: {
                    return "BackboneElement";
                }
                case CODEABLECONCEPT: {
                    return "CodeableConcept";
                }
                case CODEABLEREFERENCE: {
                    return "CodeableReference";
                }
                case CODING: {
                    return "Coding";
                }
                case CONTACTDETAIL: {
                    return "ContactDetail";
                }
                case CONTACTPOINT: {
                    return "ContactPoint";
                }
                case CONTRIBUTOR: {
                    return "Contributor";
                }
                case COUNT: {
                    return "Count";
                }
                case DATAREQUIREMENT: {
                    return "DataRequirement";
                }
                case DATATYPE: {
                    return "DataType";
                }
                case DISTANCE: {
                    return "Distance";
                }
                case DOSAGE: {
                    return "Dosage";
                }
                case DURATION: {
                    return "Duration";
                }
                case ELEMENT: {
                    return "Element";
                }
                case ELEMENTDEFINITION: {
                    return "ElementDefinition";
                }
                case EXPRESSION: {
                    return "Expression";
                }
                case EXTENSION: {
                    return "Extension";
                }
                case HUMANNAME: {
                    return "HumanName";
                }
                case IDENTIFIER: {
                    return "Identifier";
                }
                case MARKETINGSTATUS: {
                    return "MarketingStatus";
                }
                case META: {
                    return "Meta";
                }
                case MONEY: {
                    return "Money";
                }
                case MONEYQUANTITY: {
                    return "MoneyQuantity";
                }
                case NARRATIVE: {
                    return "Narrative";
                }
                case PARAMETERDEFINITION: {
                    return "ParameterDefinition";
                }
                case PERIOD: {
                    return "Period";
                }
                case POPULATION: {
                    return "Population";
                }
                case PRODCHARACTERISTIC: {
                    return "ProdCharacteristic";
                }
                case PRODUCTSHELFLIFE: {
                    return "ProductShelfLife";
                }
                case QUANTITY: {
                    return "Quantity";
                }
                case RANGE: {
                    return "Range";
                }
                case RATIO: {
                    return "Ratio";
                }
                case RATIORANGE: {
                    return "RatioRange";
                }
                case REFERENCE: {
                    return "Reference";
                }
                case RELATEDARTIFACT: {
                    return "RelatedArtifact";
                }
                case SAMPLEDDATA: {
                    return "SampledData";
                }
                case SIGNATURE: {
                    return "Signature";
                }
                case SIMPLEQUANTITY: {
                    return "SimpleQuantity";
                }
                case TIMING: {
                    return "Timing";
                }
                case TRIGGERDEFINITION: {
                    return "TriggerDefinition";
                }
                case USAGECONTEXT: {
                    return "UsageContext";
                }
                case BASE64BINARY: {
                    return "base64Binary";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case CANONICAL: {
                    return "canonical";
                }
                case CODE: {
                    return "code";
                }
                case DATE: {
                    return TestScript.SP_DATE;
                }
                case DATETIME: {
                    return "dateTime";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case ID: {
                    return "id";
                }
                case INSTANT: {
                    return "instant";
                }
                case INTEGER: {
                    return "integer";
                }
                case MARKDOWN: {
                    return "markdown";
                }
                case OID: {
                    return "oid";
                }
                case POSITIVEINT: {
                    return "positiveInt";
                }
                case STRING: {
                    return "string";
                }
                case TIME: {
                    return "time";
                }
                case UNSIGNEDINT: {
                    return "unsignedInt";
                }
                case URI: {
                    return "uri";
                }
                case URL: {
                    return TestScript.SP_URL;
                }
                case UUID: {
                    return "uuid";
                }
                case XHTML: {
                    return "xhtml";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case BINARY: {
                    return "Binary";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "AdministrableProductDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "BiologicallyDerivedProduct";
                }
                case BODYSTRUCTURE: {
                    return "BodyStructure";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CATALOGENTRY: {
                    return "CatalogEntry";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CHARGEITEMDEFINITION: {
                    return "ChargeItemDefinition";
                }
                case CITATION: {
                    return "Citation";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CLINICALUSEDEFINITION: {
                    return "ClinicalUseDefinition";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "CoverageEligibilityRequest";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "CoverageEligibilityResponse";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EVENTDEFINITION: {
                    return "EventDefinition";
                }
                case EVIDENCE: {
                    return "Evidence";
                }
                case EVIDENCEREPORT: {
                    return "EvidenceReport";
                }
                case EVIDENCEVARIABLE: {
                    return "EvidenceVariable";
                }
                case EXAMPLESCENARIO: {
                    return "ExampleScenario";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "ImmunizationEvaluation";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case INGREDIENT: {
                    return "Ingredient";
                }
                case INSURANCEPLAN: {
                    return "InsurancePlan";
                }
                case INVOICE: {
                    return "Invoice";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "ManufacturedItemDefinition";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDIA: {
                    return "Media";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONSTATEMENT: {
                    return "MedicationStatement";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "MedicinalProductDefinition";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case MOLECULARSEQUENCE: {
                    return "MolecularSequence";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case NUTRITIONPRODUCT: {
                    return "NutritionProduct";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "OrganizationAffiliation";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "PackagedProductDefinition";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case REGULATEDAUTHORIZATION: {
                    return "RegulatedAuthorization";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHDEFINITION: {
                    return "ResearchDefinition";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "ResearchElementDefinition";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSCRIPTIONSTATUS: {
                    return "SubscriptionStatus";
                }
                case SUBSCRIPTIONTOPIC: {
                    return "SubscriptionTopic";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUBSTANCEDEFINITION: {
                    return "SubstanceDefinition";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "TerminologyCapabilities";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VERIFICATIONRESULT: {
                    return "VerificationResult";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ADDRESS: {
                    return "http://hl7.org/fhir/data-types";
                }
                case AGE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case ANNOTATION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case ATTACHMENT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case BACKBONEELEMENT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CODEABLECONCEPT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CODEABLEREFERENCE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CODING: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CONTACTDETAIL: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CONTACTPOINT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CONTRIBUTOR: {
                    return "http://hl7.org/fhir/data-types";
                }
                case COUNT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DATAREQUIREMENT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DATATYPE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DISTANCE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DOSAGE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DURATION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case ELEMENT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case ELEMENTDEFINITION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case EXPRESSION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case EXTENSION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case HUMANNAME: {
                    return "http://hl7.org/fhir/data-types";
                }
                case IDENTIFIER: {
                    return "http://hl7.org/fhir/data-types";
                }
                case MARKETINGSTATUS: {
                    return "http://hl7.org/fhir/data-types";
                }
                case META: {
                    return "http://hl7.org/fhir/data-types";
                }
                case MONEY: {
                    return "http://hl7.org/fhir/data-types";
                }
                case MONEYQUANTITY: {
                    return "http://hl7.org/fhir/data-types";
                }
                case NARRATIVE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case PARAMETERDEFINITION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case PERIOD: {
                    return "http://hl7.org/fhir/data-types";
                }
                case POPULATION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case PRODCHARACTERISTIC: {
                    return "http://hl7.org/fhir/data-types";
                }
                case PRODUCTSHELFLIFE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case QUANTITY: {
                    return "http://hl7.org/fhir/data-types";
                }
                case RANGE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case RATIO: {
                    return "http://hl7.org/fhir/data-types";
                }
                case RATIORANGE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case REFERENCE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case RELATEDARTIFACT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case SAMPLEDDATA: {
                    return "http://hl7.org/fhir/data-types";
                }
                case SIGNATURE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case SIMPLEQUANTITY: {
                    return "http://hl7.org/fhir/data-types";
                }
                case TIMING: {
                    return "http://hl7.org/fhir/data-types";
                }
                case TRIGGERDEFINITION: {
                    return "http://hl7.org/fhir/data-types";
                }
                case USAGECONTEXT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case BASE64BINARY: {
                    return "http://hl7.org/fhir/data-types";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CANONICAL: {
                    return "http://hl7.org/fhir/data-types";
                }
                case CODE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DATE: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/data-types";
                }
                case DECIMAL: {
                    return "http://hl7.org/fhir/data-types";
                }
                case ID: {
                    return "http://hl7.org/fhir/data-types";
                }
                case INSTANT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/data-types";
                }
                case MARKDOWN: {
                    return "http://hl7.org/fhir/data-types";
                }
                case OID: {
                    return "http://hl7.org/fhir/data-types";
                }
                case POSITIVEINT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case STRING: {
                    return "http://hl7.org/fhir/data-types";
                }
                case TIME: {
                    return "http://hl7.org/fhir/data-types";
                }
                case UNSIGNEDINT: {
                    return "http://hl7.org/fhir/data-types";
                }
                case URI: {
                    return "http://hl7.org/fhir/data-types";
                }
                case URL: {
                    return "http://hl7.org/fhir/data-types";
                }
                case UUID: {
                    return "http://hl7.org/fhir/data-types";
                }
                case XHTML: {
                    return "http://hl7.org/fhir/data-types";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BINARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BUNDLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOMAINRESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ACCOUNT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ACTIVITYDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ADVERSEEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ALLERGYINTOLERANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case AUDITEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BASIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BODYSTRUCTURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAPABILITYSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAREPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CARETEAM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CATALOGENTRY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEMDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CITATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIMRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLINICALIMPRESSION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLINICALUSEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CODESYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPARTMENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPOSITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONCEPTMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONDITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONSENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONTRACT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DETECTEDISSUE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEMETRIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEUSESTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DIAGNOSTICREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTMANIFEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTREFERENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENDPOINT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EPISODEOFCARE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCEREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCEVARIABLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXAMPLESCENARIO: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FAMILYMEMBERHISTORY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FLAG: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GOAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GRAPHDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GUIDANCERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case HEALTHCARESERVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMAGINGSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INGREDIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INSURANCEPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INVOICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIBRARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LINKAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LOCATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASUREREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDIA: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONADMINISTRATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONDISPENSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEHEADER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MOLECULARSEQUENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NAMINGSYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NUTRITIONORDER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NUTRITIONPRODUCT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONOUTCOME: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PATIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTNOTICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTRECONCILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PLANDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONERROLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCEDURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROVENANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REGULATEDAUTHORIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REQUESTGROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSUBJECT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RISKASSESSMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SCHEDULE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SEARCHPARAMETER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SERVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SLOT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMEN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMENDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSCRIPTIONSTATUS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSCRIPTIONTOPIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYDELIVERY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TASK: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTSCRIPT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VALUESET: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VERIFICATIONRESULT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VISIONPRESCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PARAMETERS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ADDRESS: {
                    return "An address expressed using postal conventions (as opposed to GPS or other location definition formats).  This data type may be used to convey addresses for use in delivering mail as well as for visiting locations which might not be valid for mail delivery.  There are a variety of postal address formats defined around the world.";
                }
                case AGE: {
                    return "A duration of time during which an organism (or a process) has existed.";
                }
                case ANNOTATION: {
                    return "A  text note which also  contains information about who made the statement and when.";
                }
                case ATTACHMENT: {
                    return "For referring to data content defined in other formats.";
                }
                case BACKBONEELEMENT: {
                    return "Base definition for all elements that are defined inside a resource - but not those in a data type.";
                }
                case CODEABLECONCEPT: {
                    return "A concept that may be defined by a formal reference to a terminology or ontology or may be provided by text.";
                }
                case CODEABLEREFERENCE: {
                    return "A reference to a resource (by instance), or instead, a reference to a cencept defined in a terminology or ontology (by class).";
                }
                case CODING: {
                    return "A reference to a code defined by a terminology system.";
                }
                case CONTACTDETAIL: {
                    return "Specifies contact information for a person or organization.";
                }
                case CONTACTPOINT: {
                    return "Details for all kinds of technology mediated contact points for a person or organization, including telephone, email, etc.";
                }
                case CONTRIBUTOR: {
                    return "A contributor to the content of a knowledge asset, including authors, editors, reviewers, and endorsers.";
                }
                case COUNT: {
                    return "A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.";
                }
                case DATAREQUIREMENT: {
                    return "Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.";
                }
                case DATATYPE: {
                    return "The base class for all re-useable types defined as part of the FHIR Specification.";
                }
                case DISTANCE: {
                    return "A length - a value with a unit that is a physical distance.";
                }
                case DOSAGE: {
                    return "Indicates how the medication is/was taken or should be taken by the patient.";
                }
                case DURATION: {
                    return "A length of time.";
                }
                case ELEMENT: {
                    return "Base definition for all elements in a resource.";
                }
                case ELEMENTDEFINITION: {
                    return "Captures constraints on each element within the resource, profile, or extension.";
                }
                case EXPRESSION: {
                    return "A expression that is evaluated in a specified context and returns a value. The context of use of the expression must specify the context in which the expression is evaluated, and how the result of the expression is used.";
                }
                case EXTENSION: {
                    return "Optional Extension Element - found in all resources.";
                }
                case HUMANNAME: {
                    return "A human's name with the ability to identify parts and usage.";
                }
                case IDENTIFIER: {
                    return "An identifier - identifies some entity uniquely and unambiguously. Typically this is used for business identifiers.";
                }
                case MARKETINGSTATUS: {
                    return "The marketing status describes the date when a medicinal product is actually put on the market or the date as of which it is no longer available.";
                }
                case META: {
                    return "The metadata about a resource. This is content in the resource that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.";
                }
                case MONEY: {
                    return "An amount of economic utility in some recognized currency.";
                }
                case MONEYQUANTITY: {
                    return "";
                }
                case NARRATIVE: {
                    return "A human-readable summary of the resource conveying the essential clinical and business information for the resource.";
                }
                case PARAMETERDEFINITION: {
                    return "The parameters to the module. This collection specifies both the input and output parameters. Input parameters are provided by the caller as part of the $evaluate operation. Output parameters are included in the GuidanceResponse.";
                }
                case PERIOD: {
                    return "A time period defined by a start and end date and optionally time.";
                }
                case POPULATION: {
                    return "A populatioof people with some set of grouping criteria.";
                }
                case PRODCHARACTERISTIC: {
                    return "The marketing status describes the date when a medicinal product is actually put on the market or the date as of which it is no longer available.";
                }
                case PRODUCTSHELFLIFE: {
                    return "The shelf-life and storage information for a medicinal product item or container can be described using this class.";
                }
                case QUANTITY: {
                    return "A measured amount (or an amount that can potentially be measured). Note that measured amounts include amounts that are not precisely quantified, including amounts involving arbitrary units and floating currencies.";
                }
                case RANGE: {
                    return "A set of ordered Quantities defined by a low and high limit.";
                }
                case RATIO: {
                    return "A relationship of two Quantity values - expressed as a numerator and a denominator.";
                }
                case RATIORANGE: {
                    return "A range of ratios expressed as a low and high numerator and a denominator.";
                }
                case REFERENCE: {
                    return "A reference from one resource to another.";
                }
                case RELATEDARTIFACT: {
                    return "Related artifacts such as additional documentation, justification, or bibliographic references.";
                }
                case SAMPLEDDATA: {
                    return "A series of measurements taken by a device, with upper and lower limits. There may be more than one dimension in the data.";
                }
                case SIGNATURE: {
                    return "A signature along with supporting context. The signature may be a digital signature that is cryptographic in nature, or some other signature acceptable to the domain. This other signature may be as simple as a graphical image representing a hand-written signature, or a signature ceremony Different signature approaches have different utilities.";
                }
                case SIMPLEQUANTITY: {
                    return "";
                }
                case TIMING: {
                    return "Specifies an event that may occur multiple times. Timing schedules are used to record when things are planned, expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds, and may be used for reporting the schedule to which past regular activities were carried out.";
                }
                case TRIGGERDEFINITION: {
                    return "A description of a triggering event. Triggering events can be named events, data events, or periodic, as determined by the type element.";
                }
                case USAGECONTEXT: {
                    return "Specifies clinical/business/etc. metadata that can be used to retrieve, index and/or categorize an artifact. This metadata can either be specific to the applicable population (e.g., age category, DRG) or the specific context of care (e.g., venue, care setting, provider of care).";
                }
                case BASE64BINARY: {
                    return "A stream of bytes";
                }
                case BOOLEAN: {
                    return "Value of \"true\" or \"false\"";
                }
                case CANONICAL: {
                    return "A URI that is a reference to a canonical URL on a FHIR resource";
                }
                case CODE: {
                    return "A string which has at least one character and no leading or trailing whitespace and where there is no whitespace other than single spaces in the contents";
                }
                case DATE: {
                    return "A date or partial date (e.g. just year or year + month). There is no time zone. The format is a union of the schema types gYear, gYearMonth and date.  Dates SHALL be valid dates.";
                }
                case DATETIME: {
                    return "A date, date-time or partial date (e.g. just year or year + month).  If hours and minutes are specified, a time zone SHALL be populated. The format is a union of the schema types gYear, gYearMonth, date and dateTime. Seconds must be provided due to schema type constraints but may be zero-filled and may be ignored.                 Dates SHALL be valid dates.";
                }
                case DECIMAL: {
                    return "A rational number with implicit precision";
                }
                case ID: {
                    return "Any combination of letters, numerals, \"-\" and \".\", with a length limit of 64 characters.  (This might be an integer, an unprefixed OID, UUID or any other identifier pattern that meets these constraints.)  Ids are case-insensitive.";
                }
                case INSTANT: {
                    return "An instant in time - known at least to the second";
                }
                case INTEGER: {
                    return "A whole number";
                }
                case MARKDOWN: {
                    return "A string that may contain Github Flavored Markdown syntax for optional processing by a mark down presentation engine";
                }
                case OID: {
                    return "An OID represented as a URI";
                }
                case POSITIVEINT: {
                    return "An integer with a value that is positive (e.g. >0)";
                }
                case STRING: {
                    return "A sequence of Unicode characters";
                }
                case TIME: {
                    return "A time during the day, with no date specified";
                }
                case UNSIGNEDINT: {
                    return "An integer with a value that is not negative (e.g. >= 0)";
                }
                case URI: {
                    return "String of characters used to identify a name or a resource";
                }
                case URL: {
                    return "A URI that is a literal reference";
                }
                case UUID: {
                    return "A UUID, represented as a URI";
                }
                case XHTML: {
                    return "XHTML format, as defined by W3C, but restricted usage (mainly, no active content)";
                }
                case RESOURCE: {
                    return "--- Abstract Type! ---This is the base resource type for everything.";
                }
                case BINARY: {
                    return "A resource that represents the data of a single raw artifact as digital content accessible in its native format.  A Binary resource can contain any content, whether text, image, pdf, zip archive, etc.";
                }
                case BUNDLE: {
                    return "A container for a collection of resources.";
                }
                case DOMAINRESOURCE: {
                    return "--- Abstract Type! ---A resource that includes narrative, extensions, and contained resources.";
                }
                case ACCOUNT: {
                    return "A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.";
                }
                case ACTIVITYDEFINITION: {
                    return "This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "A medicinal product in the final form which is suitable for administering to a patient (after any mixing of multiple components, dissolution etc. has been performed).";
                }
                case ADVERSEEVENT: {
                    return "Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.";
                }
                case ALLERGYINTOLERANCE: {
                    return "Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.";
                }
                case APPOINTMENT: {
                    return "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).";
                }
                case APPOINTMENTRESPONSE: {
                    return "A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.";
                }
                case AUDITEVENT: {
                    return "A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.";
                }
                case BASIC: {
                    return "Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "A material substance originating from a biological entity intended to be transplanted or infused\ninto another (possibly the same) biological entity.";
                }
                case BODYSTRUCTURE: {
                    return "Record details about an anatomical structure.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.";
                }
                case CAPABILITYSTATEMENT: {
                    return "A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case CAREPLAN: {
                    return "Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.";
                }
                case CARETEAM: {
                    return "The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.";
                }
                case CATALOGENTRY: {
                    return "Catalog entries are wrappers that contextualize items included in a catalog.";
                }
                case CHARGEITEM: {
                    return "The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.";
                }
                case CHARGEITEMDEFINITION: {
                    return "The ChargeItemDefinition resource provides the properties that apply to the (billing) codes necessary to calculate costs and prices. The properties may differ largely depending on type and realm, therefore this resource gives only a rough structure and requires profiling for each type of billing code system.";
                }
                case CITATION: {
                    return "The Citation Resource enables reference to any knowledge artifact for purposes of identification and attribution. The Citation Resource supports existing reference structures and developing publication practices such as versioning, expressing complex contributorship roles, and referencing computable resources.";
                }
                case CLAIM: {
                    return "A provider issued list of professional services and products which have been provided, or are to be provided, to a patient which is sent to an insurer for reimbursement.";
                }
                case CLAIMRESPONSE: {
                    return "This resource provides the adjudication details from the processing of a Claim resource.";
                }
                case CLINICALIMPRESSION: {
                    return "A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called \"ClinicalImpression\" rather than \"ClinicalAssessment\" to avoid confusion with the recording of assessment tools such as Apgar score.";
                }
                case CLINICALUSEDEFINITION: {
                    return "A single issue - either an indication, contraindication, interaction or an undesirable effect for a medicinal product, medication, device or procedure.";
                }
                case CODESYSTEM: {
                    return "The CodeSystem resource is used to declare the existence of and describe a code system or code system supplement and its key properties, and optionally define a part or all of its content.";
                }
                case COMMUNICATION: {
                    return "An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency that was notified about a reportable condition.";
                }
                case COMMUNICATIONREQUEST: {
                    return "A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.";
                }
                case COMPARTMENTDEFINITION: {
                    return "A compartment definition that defines how resources are accessed on a server.";
                }
                case COMPOSITION: {
                    return "A set of healthcare-related information that is assembled together into a single logical package that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. A Composition defines the structure and narrative content necessary for a document. However, a Composition alone does not constitute a document. Rather, the Composition must be the first entry in a Bundle where Bundle.type=document, and any other resources referenced from Composition must be included as subsequent entries in the Bundle (for example Patient, Practitioner, Encounter, etc.).";
                }
                case CONCEPTMAP: {
                    return "A statement of relationships from one set of concepts to one or more other concepts - either concepts in code systems, or data element/data element concepts, or classes in class models.";
                }
                case CONDITION: {
                    return "A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.";
                }
                case CONSENT: {
                    return "A record of a healthcare consumer\u2019s  choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.";
                }
                case CONTRACT: {
                    return "Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.";
                }
                case COVERAGE: {
                    return "Financial instrument which may be used to reimburse or pay for health care products and services. Includes both insurance and self-payment.";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "The CoverageEligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an CoverageEligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "This resource provides eligibility and plan details from the processing of an CoverageEligibilityRequest resource.";
                }
                case DETECTEDISSUE: {
                    return "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.";
                }
                case DEVICE: {
                    return "A type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.";
                }
                case DEVICEDEFINITION: {
                    return "The characteristics, operational status and capabilities of a medical-related component of a medical device.";
                }
                case DEVICEMETRIC: {
                    return "Describes a measurement, calculation or setting capability of a medical device.";
                }
                case DEVICEREQUEST: {
                    return "Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.";
                }
                case DEVICEUSESTATEMENT: {
                    return "A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.";
                }
                case DIAGNOSTICREPORT: {
                    return "The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.";
                }
                case DOCUMENTMANIFEST: {
                    return "A collection of documents compiled for a purpose together with metadata that applies to the collection.";
                }
                case DOCUMENTREFERENCE: {
                    return "A reference to a document of any kind for any purpose. Provides metadata about the document so that the document can be discovered and managed. The scope of a document is any seralized object with a mime-type, so includes formal patient centric documents (CDA), cliical notes, scanned paper, and non-patient specific documents like policy text.";
                }
                case ENCOUNTER: {
                    return "An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.";
                }
                case ENDPOINT: {
                    return "The technical details of an endpoint that can be used for electronic services, such as for web services providing XDS.b or a REST endpoint for another FHIR server. This may include any security context information.";
                }
                case ENROLLMENTREQUEST: {
                    return "This resource provides the insurance enrollment details to the insurer regarding a specified coverage.";
                }
                case ENROLLMENTRESPONSE: {
                    return "This resource provides enrollment and plan details from the processing of an EnrollmentRequest resource.";
                }
                case EPISODEOFCARE: {
                    return "An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.";
                }
                case EVENTDEFINITION: {
                    return "The EventDefinition resource provides a reusable description of when a particular event can occur.";
                }
                case EVIDENCE: {
                    return "The Evidence Resource provides a machine-interpretable expression of an evidence concept including the evidence variables (eg population, exposures/interventions, comparators, outcomes, measured variables, confounding variables), the statistics, and the certainty of this evidence.";
                }
                case EVIDENCEREPORT: {
                    return "The EvidenceReport Resource is a specialized container for a collection of resources and codable concepts, adapted to support compositions of Evidence, EvidenceVariable, and Citation resources and related concepts.";
                }
                case EVIDENCEVARIABLE: {
                    return "The EvidenceVariable resource describes an element that knowledge (Evidence) is about.";
                }
                case EXAMPLESCENARIO: {
                    return "Example of workflow instance.";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.";
                }
                case FAMILYMEMBERHISTORY: {
                    return "Significant health conditions for a person related to the patient relevant in the context of care for the patient.";
                }
                case FLAG: {
                    return "Prospective warnings of potential issues when providing care to the patient.";
                }
                case GOAL: {
                    return "Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.";
                }
                case GRAPHDEFINITION: {
                    return "A formal computable definition of a graph of resources - that is, a coherent set of resources that form a graph by following references. The Graph Definition resource defines a set and makes rules about the set.";
                }
                case GROUP: {
                    return "Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively, and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.";
                }
                case GUIDANCERESPONSE: {
                    return "A guidance response is the formal response to a guidance request, including any output parameters returned by the evaluation, as well as the description of any proposed actions to be taken.";
                }
                case HEALTHCARESERVICE: {
                    return "The details of a healthcare service available at a location.";
                }
                case IMAGINGSTUDY: {
                    return "Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.";
                }
                case IMMUNIZATION: {
                    return "Describes the event of a patient being administered a vaccine or a record of an immunization as reported by a patient, a clinician or another party.";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "Describes a comparison of an immunization event against published recommendations to determine if the administration is \"valid\" in relation to those  recommendations.";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "A patient's point-in-time set of recommendations (i.e. forecasting) according to a published schedule with optional supporting justification.";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "A set of rules of how a particular interoperability or standards problem is solved - typically through the use of FHIR resources. This resource is used to gather all the parts of an implementation guide into a logical whole and to publish a computable definition of all the parts.";
                }
                case INGREDIENT: {
                    return "An ingredient of a manufactured item or pharmaceutical product.";
                }
                case INSURANCEPLAN: {
                    return "Details of a Health Insurance product/plan provided by an organization.";
                }
                case INVOICE: {
                    return "Invoice containing collected ChargeItems from an Account with calculated individual and total price for Billing purpose.";
                }
                case LIBRARY: {
                    return "The Library resource is a general-purpose container for knowledge asset definitions. It can be used to describe and expose existing knowledge assets such as logic libraries and information model descriptions, as well as to describe a collection of knowledge assets.";
                }
                case LINKAGE: {
                    return "Identifies two or more records (resource instances) that refer to the same real-world \"occurrence\".";
                }
                case LIST: {
                    return "A list is a curated collection of resources.";
                }
                case LOCATION: {
                    return "Details and position information for a physical place where services are provided and resources and participants may be stored, found, contained, or accommodated.";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "The definition and characteristics of a medicinal manufactured item, such as a tablet or capsule, as contained in a packaged medicinal product.";
                }
                case MEASURE: {
                    return "The Measure resource provides the definition of a quality measure.";
                }
                case MEASUREREPORT: {
                    return "The MeasureReport resource contains the results of the calculation of a measure; and optionally a reference to the resources involved in that calculation.";
                }
                case MEDIA: {
                    return "A photo, video, or audio recording acquired or used in healthcare. The actual content may be inline or provided by direct reference.";
                }
                case MEDICATION: {
                    return "This resource is primarily used for the identification and definition of a medication for the purposes of prescribing, dispensing, and administering a medication as well as for making statements about medication use.";
                }
                case MEDICATIONADMINISTRATION: {
                    return "Describes the event of a patient consuming or otherwise being administered a medication.  This may be as simple as swallowing a tablet or it may be a long running infusion.  Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.";
                }
                case MEDICATIONDISPENSE: {
                    return "Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "Information about a medication that is used to support knowledge.";
                }
                case MEDICATIONREQUEST: {
                    return "An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called \"MedicationRequest\" rather than \"MedicationPrescription\" or \"MedicationOrder\" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.";
                }
                case MEDICATIONSTATEMENT: {
                    return "A record of a medication that is being consumed by a patient.   A MedicationStatement may indicate that the patient may be taking the medication now or has taken the medication in the past or will be taking the medication in the future.  The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician.  A common scenario where this information is captured is during the history taking process during a patient visit or stay.   The medication information may come from sources such as the patient's memory, from a prescription bottle,  or from a list of medications the patient, clinician or other party maintains. \n\nThe primary difference between a medication statement and a medication administration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication.  A medication statement is often, if not always, less specific.  There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise.  As stated earlier, the medication statement information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains.  Medication administration is more formal and is not missing detailed information.";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "Detailed definition of a medicinal product, typically for uses other than direct patient care (e.g. regulatory use, drug catalogs).";
                }
                case MESSAGEDEFINITION: {
                    return "Defines the characteristics of a message that can be shared between systems, including the type of event that initiates the message, the content to be transmitted and what response(s), if any, are permitted.";
                }
                case MESSAGEHEADER: {
                    return "The header for a message exchange that is either requesting or responding to an action.  The reference(s) that are the subject of the action as well as other information related to the action are typically transmitted in a bundle in which the MessageHeader resource instance is the first resource in the bundle.";
                }
                case MOLECULARSEQUENCE: {
                    return "Raw data describing a biological sequence.";
                }
                case NAMINGSYSTEM: {
                    return "A curated namespace that issues unique symbols within that namespace for the identification of concepts, people, devices, etc.  Represents a \"System\" used within the Identifier and Coding data types.";
                }
                case NUTRITIONORDER: {
                    return "A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.";
                }
                case NUTRITIONPRODUCT: {
                    return "A food or fluid product that is consumed by patients.";
                }
                case OBSERVATION: {
                    return "Measurements and simple assertions made about a patient, device or other subject.";
                }
                case OBSERVATIONDEFINITION: {
                    return "Set of definitional characteristics for a kind of observation or measurement produced or consumed by an orderable health care service.";
                }
                case OPERATIONDEFINITION: {
                    return "A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).";
                }
                case OPERATIONOUTCOME: {
                    return "A collection of error, warning, or information messages that result from a system action.";
                }
                case ORGANIZATION: {
                    return "A formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action.  Includes companies, institutions, corporations, departments, community groups, healthcare practice groups, payer/insurer, etc.";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "Defines an affiliation/assotiation/relationship between 2 distinct oganizations, that is not a part-of relationship/sub-division relationship.";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "A medically related item or items, in a container or package.";
                }
                case PATIENT: {
                    return "Demographics and other administrative information about an individual or animal receiving care or other health-related services.";
                }
                case PAYMENTNOTICE: {
                    return "This resource provides the status of the payment for goods and services rendered, and the request and response resource references.";
                }
                case PAYMENTRECONCILIATION: {
                    return "This resource provides the details including amount of a payment and allocates the payment items being paid.";
                }
                case PERSON: {
                    return "Demographics and administrative information about a person independent of a specific health-related context.";
                }
                case PLANDEFINITION: {
                    return "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical and non-clinical artifacts such as clinical decision support rules, order sets, protocols, and drug quality specifications.";
                }
                case PRACTITIONER: {
                    return "A person who is directly or indirectly involved in the provisioning of healthcare.";
                }
                case PRACTITIONERROLE: {
                    return "A specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.";
                }
                case PROCEDURE: {
                    return "An action that is or was performed on or for a patient. This can be a physical intervention like an operation, or less invasive like long term services, counseling, or hypnotherapy.";
                }
                case PROVENANCE: {
                    return "Provenance of a resource is a record that describes entities and processes involved in producing and delivering or otherwise influencing that resource. Provenance provides a critical foundation for assessing authenticity, enabling trust, and allowing reproducibility. Provenance assertions are a form of contextual metadata and can themselves become important records with their own provenance. Provenance statement indicates clinical significance in terms of confidence in authenticity, reliability, and trustworthiness, integrity, and stage in lifecycle (e.g. Document Completion - has the artifact been legally authenticated), all of which may impact security, privacy, and trust policies.";
                }
                case QUESTIONNAIRE: {
                    return "A structured set of questions intended to guide the collection of answers from end-users. Questionnaires provide detailed control over order, presentation, phraseology and grouping to allow coherent, consistent data collection.";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "A structured set of questions and their answers. The questions are ordered and grouped into coherent subsets, corresponding to the structure of the grouping of the questionnaire being responded to.";
                }
                case REGULATEDAUTHORIZATION: {
                    return "Regulatory approval, clearance or licencing related to a regulated product, treatment, facility or activity that is cited in a guidance, regulation, rule or legislative act. An example is Market Authorization relating to a Medicinal Product.";
                }
                case RELATEDPERSON: {
                    return "Information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process.";
                }
                case REQUESTGROUP: {
                    return "A group of related requests that can be used to capture intended activities that have inter-dependencies such as \"give this medication after that one\".";
                }
                case RESEARCHDEFINITION: {
                    return "The ResearchDefinition resource describes the conditional state (population and any exposures being compared within the population) and outcome (if specified) that the knowledge (evidence, assertion, recommendation) is about.";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "The ResearchElementDefinition resource describes a \"PICO\" element that knowledge (evidence, assertion, recommendation) is about.";
                }
                case RESEARCHSTUDY: {
                    return "A process where a researcher or organization plans and then executes a series of steps intended to increase the field of healthcare-related knowledge.  This includes studies of safety, efficacy, comparative effectiveness and other information about medications, devices, therapies and other interventional and investigative techniques.  A ResearchStudy involves the gathering of information about human or animal subjects.";
                }
                case RESEARCHSUBJECT: {
                    return "A physical entity which is the primary unit of operational and/or administrative interest in a study.";
                }
                case RISKASSESSMENT: {
                    return "An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.";
                }
                case SCHEDULE: {
                    return "A container for slots of time that may be available for booking appointments.";
                }
                case SEARCHPARAMETER: {
                    return "A search parameter that defines a named search item that can be used to search/filter on a resource.";
                }
                case SERVICEREQUEST: {
                    return "A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.";
                }
                case SLOT: {
                    return "A slot of time on a schedule that may be available for booking appointments.";
                }
                case SPECIMEN: {
                    return "A sample to be used for analysis.";
                }
                case SPECIMENDEFINITION: {
                    return "A kind of specimen with associated set of requirements.";
                }
                case STRUCTUREDEFINITION: {
                    return "A definition of a FHIR structure. This resource is used to describe the underlying resources, data types defined in FHIR, and also for describing extensions and constraints on resources and data types.";
                }
                case STRUCTUREMAP: {
                    return "A Map of relationships between 2 structures that can be used to transform data.";
                }
                case SUBSCRIPTION: {
                    return "The subscription resource is used to define a push-based subscription from a server to another system. Once a subscription is registered with the server, the server checks every resource that is created or updated, and if the resource matches the given criteria, it sends a message on the defined \"channel\" so that another system can take an appropriate action.";
                }
                case SUBSCRIPTIONSTATUS: {
                    return "The SubscriptionStatus resource describes the state of a Subscription during notifications.";
                }
                case SUBSCRIPTIONTOPIC: {
                    return "Describes a stream of resource state changes identified by trigger criteria and annotated with labels useful to filter projections from this topic.";
                }
                case SUBSTANCE: {
                    return "A homogeneous material with a definite composition.";
                }
                case SUBSTANCEDEFINITION: {
                    return "The detailed description of a substance, typically at a level beyond what is used for prescribing.";
                }
                case SUPPLYDELIVERY: {
                    return "Record of delivery of what is supplied.";
                }
                case SUPPLYREQUEST: {
                    return "A record of a request for a medication, substance or device used in the healthcare setting.";
                }
                case TASK: {
                    return "A task to be performed.";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "A TerminologyCapabilities resource documents a set of capabilities (behaviors) of a FHIR Terminology Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case TESTREPORT: {
                    return "A summary of information based on the results of executing a TestScript.";
                }
                case TESTSCRIPT: {
                    return "A structured set of tests against a FHIR server or client implementation to determine compliance against the FHIR specification.";
                }
                case VALUESET: {
                    return "A ValueSet resource instance specifies a set of codes drawn from one or more code systems, intended for use in a particular context. Value sets link between [[[CodeSystem]]] definitions and their use in [coded elements](terminologies.html).";
                }
                case VERIFICATIONRESULT: {
                    return "Describes validation requirements, source(s), status and dates for one or more elements.";
                }
                case VISIONPRESCRIPTION: {
                    return "An authorization for the provision of glasses and/or contact lenses to a patient.";
                }
                case PARAMETERS: {
                    return "This resource is a non-persisted resource used to pass information into and back from an [operation](operations.html). It has no other use, and there is no RESTful endpoint associated with it.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ADDRESS: {
                    return "Address";
                }
                case AGE: {
                    return "Age";
                }
                case ANNOTATION: {
                    return "Annotation";
                }
                case ATTACHMENT: {
                    return "Attachment";
                }
                case BACKBONEELEMENT: {
                    return "BackboneElement";
                }
                case CODEABLECONCEPT: {
                    return "CodeableConcept";
                }
                case CODEABLEREFERENCE: {
                    return "CodeableReference";
                }
                case CODING: {
                    return "Coding";
                }
                case CONTACTDETAIL: {
                    return "ContactDetail";
                }
                case CONTACTPOINT: {
                    return "ContactPoint";
                }
                case CONTRIBUTOR: {
                    return "Contributor";
                }
                case COUNT: {
                    return "Count";
                }
                case DATAREQUIREMENT: {
                    return "DataRequirement";
                }
                case DATATYPE: {
                    return "DataType";
                }
                case DISTANCE: {
                    return "Distance";
                }
                case DOSAGE: {
                    return "Dosage";
                }
                case DURATION: {
                    return "Duration";
                }
                case ELEMENT: {
                    return "Element";
                }
                case ELEMENTDEFINITION: {
                    return "ElementDefinition";
                }
                case EXPRESSION: {
                    return "Expression";
                }
                case EXTENSION: {
                    return "Extension";
                }
                case HUMANNAME: {
                    return "HumanName";
                }
                case IDENTIFIER: {
                    return "Identifier";
                }
                case MARKETINGSTATUS: {
                    return "MarketingStatus";
                }
                case META: {
                    return "Meta";
                }
                case MONEY: {
                    return "Money";
                }
                case MONEYQUANTITY: {
                    return "MoneyQuantity";
                }
                case NARRATIVE: {
                    return "Narrative";
                }
                case PARAMETERDEFINITION: {
                    return "ParameterDefinition";
                }
                case PERIOD: {
                    return "Period";
                }
                case POPULATION: {
                    return "Population";
                }
                case PRODCHARACTERISTIC: {
                    return "ProdCharacteristic";
                }
                case PRODUCTSHELFLIFE: {
                    return "ProductShelfLife";
                }
                case QUANTITY: {
                    return "Quantity";
                }
                case RANGE: {
                    return "Range";
                }
                case RATIO: {
                    return "Ratio";
                }
                case RATIORANGE: {
                    return "RatioRange";
                }
                case REFERENCE: {
                    return "Reference";
                }
                case RELATEDARTIFACT: {
                    return "RelatedArtifact";
                }
                case SAMPLEDDATA: {
                    return "SampledData";
                }
                case SIGNATURE: {
                    return "Signature";
                }
                case SIMPLEQUANTITY: {
                    return "SimpleQuantity";
                }
                case TIMING: {
                    return "Timing";
                }
                case TRIGGERDEFINITION: {
                    return "TriggerDefinition";
                }
                case USAGECONTEXT: {
                    return "UsageContext";
                }
                case BASE64BINARY: {
                    return "base64Binary";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case CANONICAL: {
                    return "canonical";
                }
                case CODE: {
                    return "code";
                }
                case DATE: {
                    return TestScript.SP_DATE;
                }
                case DATETIME: {
                    return "dateTime";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case ID: {
                    return "id";
                }
                case INSTANT: {
                    return "instant";
                }
                case INTEGER: {
                    return "integer";
                }
                case MARKDOWN: {
                    return "markdown";
                }
                case OID: {
                    return "oid";
                }
                case POSITIVEINT: {
                    return "positiveInt";
                }
                case STRING: {
                    return "string";
                }
                case TIME: {
                    return "time";
                }
                case UNSIGNEDINT: {
                    return "unsignedInt";
                }
                case URI: {
                    return "uri";
                }
                case URL: {
                    return TestScript.SP_URL;
                }
                case UUID: {
                    return "uuid";
                }
                case XHTML: {
                    return "XHTML";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case BINARY: {
                    return "Binary";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "AdministrableProductDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "BiologicallyDerivedProduct";
                }
                case BODYSTRUCTURE: {
                    return "BodyStructure";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CATALOGENTRY: {
                    return "CatalogEntry";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CHARGEITEMDEFINITION: {
                    return "ChargeItemDefinition";
                }
                case CITATION: {
                    return "Citation";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CLINICALUSEDEFINITION: {
                    return "ClinicalUseDefinition";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "CoverageEligibilityRequest";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "CoverageEligibilityResponse";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EVENTDEFINITION: {
                    return "EventDefinition";
                }
                case EVIDENCE: {
                    return "Evidence";
                }
                case EVIDENCEREPORT: {
                    return "EvidenceReport";
                }
                case EVIDENCEVARIABLE: {
                    return "EvidenceVariable";
                }
                case EXAMPLESCENARIO: {
                    return "ExampleScenario";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "ImmunizationEvaluation";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case INGREDIENT: {
                    return "Ingredient";
                }
                case INSURANCEPLAN: {
                    return "InsurancePlan";
                }
                case INVOICE: {
                    return "Invoice";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "ManufacturedItemDefinition";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDIA: {
                    return "Media";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONSTATEMENT: {
                    return "MedicationStatement";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "MedicinalProductDefinition";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case MOLECULARSEQUENCE: {
                    return "MolecularSequence";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case NUTRITIONPRODUCT: {
                    return "NutritionProduct";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "OrganizationAffiliation";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "PackagedProductDefinition";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case REGULATEDAUTHORIZATION: {
                    return "RegulatedAuthorization";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHDEFINITION: {
                    return "ResearchDefinition";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "ResearchElementDefinition";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSCRIPTIONSTATUS: {
                    return "SubscriptionStatus";
                }
                case SUBSCRIPTIONTOPIC: {
                    return "SubscriptionTopic";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUBSTANCEDEFINITION: {
                    return "SubstanceDefinition";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "TerminologyCapabilities";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VERIFICATIONRESULT: {
                    return "VerificationResult";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AssertionResponseTypesEnumFactory
    implements EnumFactory<AssertionResponseTypes> {
        @Override
        public AssertionResponseTypes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("okay".equals(codeString)) {
                return AssertionResponseTypes.OKAY;
            }
            if ("created".equals(codeString)) {
                return AssertionResponseTypes.CREATED;
            }
            if ("noContent".equals(codeString)) {
                return AssertionResponseTypes.NOCONTENT;
            }
            if ("notModified".equals(codeString)) {
                return AssertionResponseTypes.NOTMODIFIED;
            }
            if ("bad".equals(codeString)) {
                return AssertionResponseTypes.BAD;
            }
            if ("forbidden".equals(codeString)) {
                return AssertionResponseTypes.FORBIDDEN;
            }
            if ("notFound".equals(codeString)) {
                return AssertionResponseTypes.NOTFOUND;
            }
            if ("methodNotAllowed".equals(codeString)) {
                return AssertionResponseTypes.METHODNOTALLOWED;
            }
            if ("conflict".equals(codeString)) {
                return AssertionResponseTypes.CONFLICT;
            }
            if ("gone".equals(codeString)) {
                return AssertionResponseTypes.GONE;
            }
            if ("preconditionFailed".equals(codeString)) {
                return AssertionResponseTypes.PRECONDITIONFAILED;
            }
            if ("unprocessable".equals(codeString)) {
                return AssertionResponseTypes.UNPROCESSABLE;
            }
            throw new IllegalArgumentException("Unknown AssertionResponseTypes code '" + codeString + "'");
        }

        public Enumeration<AssertionResponseTypes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NULL, code);
            }
            if ("okay".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.OKAY, code);
            }
            if ("created".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.CREATED, code);
            }
            if ("noContent".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NOCONTENT, code);
            }
            if ("notModified".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NOTMODIFIED, code);
            }
            if ("bad".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.BAD, code);
            }
            if ("forbidden".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.FORBIDDEN, code);
            }
            if ("notFound".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NOTFOUND, code);
            }
            if ("methodNotAllowed".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.METHODNOTALLOWED, code);
            }
            if ("conflict".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.CONFLICT, code);
            }
            if ("gone".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.GONE, code);
            }
            if ("preconditionFailed".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.PRECONDITIONFAILED, code);
            }
            if ("unprocessable".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.UNPROCESSABLE, code);
            }
            throw new FHIRException("Unknown AssertionResponseTypes code '" + codeString + "'");
        }

        @Override
        public String toCode(AssertionResponseTypes code) {
            if (code == AssertionResponseTypes.OKAY) {
                return "okay";
            }
            if (code == AssertionResponseTypes.CREATED) {
                return "created";
            }
            if (code == AssertionResponseTypes.NOCONTENT) {
                return "noContent";
            }
            if (code == AssertionResponseTypes.NOTMODIFIED) {
                return "notModified";
            }
            if (code == AssertionResponseTypes.BAD) {
                return "bad";
            }
            if (code == AssertionResponseTypes.FORBIDDEN) {
                return "forbidden";
            }
            if (code == AssertionResponseTypes.NOTFOUND) {
                return "notFound";
            }
            if (code == AssertionResponseTypes.METHODNOTALLOWED) {
                return "methodNotAllowed";
            }
            if (code == AssertionResponseTypes.CONFLICT) {
                return "conflict";
            }
            if (code == AssertionResponseTypes.GONE) {
                return "gone";
            }
            if (code == AssertionResponseTypes.PRECONDITIONFAILED) {
                return "preconditionFailed";
            }
            if (code == AssertionResponseTypes.UNPROCESSABLE) {
                return "unprocessable";
            }
            return "?";
        }

        @Override
        public String toSystem(AssertionResponseTypes code) {
            return code.getSystem();
        }
    }

    public static enum AssertionResponseTypes {
        OKAY,
        CREATED,
        NOCONTENT,
        NOTMODIFIED,
        BAD,
        FORBIDDEN,
        NOTFOUND,
        METHODNOTALLOWED,
        CONFLICT,
        GONE,
        PRECONDITIONFAILED,
        UNPROCESSABLE,
        NULL;


        public static AssertionResponseTypes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("okay".equals(codeString)) {
                return OKAY;
            }
            if ("created".equals(codeString)) {
                return CREATED;
            }
            if ("noContent".equals(codeString)) {
                return NOCONTENT;
            }
            if ("notModified".equals(codeString)) {
                return NOTMODIFIED;
            }
            if ("bad".equals(codeString)) {
                return BAD;
            }
            if ("forbidden".equals(codeString)) {
                return FORBIDDEN;
            }
            if ("notFound".equals(codeString)) {
                return NOTFOUND;
            }
            if ("methodNotAllowed".equals(codeString)) {
                return METHODNOTALLOWED;
            }
            if ("conflict".equals(codeString)) {
                return CONFLICT;
            }
            if ("gone".equals(codeString)) {
                return GONE;
            }
            if ("preconditionFailed".equals(codeString)) {
                return PRECONDITIONFAILED;
            }
            if ("unprocessable".equals(codeString)) {
                return UNPROCESSABLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AssertionResponseTypes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OKAY: {
                    return "okay";
                }
                case CREATED: {
                    return "created";
                }
                case NOCONTENT: {
                    return "noContent";
                }
                case NOTMODIFIED: {
                    return "notModified";
                }
                case BAD: {
                    return "bad";
                }
                case FORBIDDEN: {
                    return "forbidden";
                }
                case NOTFOUND: {
                    return "notFound";
                }
                case METHODNOTALLOWED: {
                    return "methodNotAllowed";
                }
                case CONFLICT: {
                    return "conflict";
                }
                case GONE: {
                    return "gone";
                }
                case PRECONDITIONFAILED: {
                    return "preconditionFailed";
                }
                case UNPROCESSABLE: {
                    return "unprocessable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OKAY: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case CREATED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NOCONTENT: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NOTMODIFIED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case BAD: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case FORBIDDEN: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NOTFOUND: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case METHODNOTALLOWED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case CONFLICT: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case GONE: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case PRECONDITIONFAILED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case UNPROCESSABLE: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OKAY: {
                    return "Response code is 200.";
                }
                case CREATED: {
                    return "Response code is 201.";
                }
                case NOCONTENT: {
                    return "Response code is 204.";
                }
                case NOTMODIFIED: {
                    return "Response code is 304.";
                }
                case BAD: {
                    return "Response code is 400.";
                }
                case FORBIDDEN: {
                    return "Response code is 403.";
                }
                case NOTFOUND: {
                    return "Response code is 404.";
                }
                case METHODNOTALLOWED: {
                    return "Response code is 405.";
                }
                case CONFLICT: {
                    return "Response code is 409.";
                }
                case GONE: {
                    return "Response code is 410.";
                }
                case PRECONDITIONFAILED: {
                    return "Response code is 412.";
                }
                case UNPROCESSABLE: {
                    return "Response code is 422.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OKAY: {
                    return "okay";
                }
                case CREATED: {
                    return "created";
                }
                case NOCONTENT: {
                    return "noContent";
                }
                case NOTMODIFIED: {
                    return "notModified";
                }
                case BAD: {
                    return "bad";
                }
                case FORBIDDEN: {
                    return "forbidden";
                }
                case NOTFOUND: {
                    return "notFound";
                }
                case METHODNOTALLOWED: {
                    return "methodNotAllowed";
                }
                case CONFLICT: {
                    return "conflict";
                }
                case GONE: {
                    return "gone";
                }
                case PRECONDITIONFAILED: {
                    return "preconditionFailed";
                }
                case UNPROCESSABLE: {
                    return "unprocessable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AssertionOperatorTypeEnumFactory
    implements EnumFactory<AssertionOperatorType> {
        @Override
        public AssertionOperatorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("equals".equals(codeString)) {
                return AssertionOperatorType.EQUALS;
            }
            if ("notEquals".equals(codeString)) {
                return AssertionOperatorType.NOTEQUALS;
            }
            if ("in".equals(codeString)) {
                return AssertionOperatorType.IN;
            }
            if ("notIn".equals(codeString)) {
                return AssertionOperatorType.NOTIN;
            }
            if ("greaterThan".equals(codeString)) {
                return AssertionOperatorType.GREATERTHAN;
            }
            if ("lessThan".equals(codeString)) {
                return AssertionOperatorType.LESSTHAN;
            }
            if ("empty".equals(codeString)) {
                return AssertionOperatorType.EMPTY;
            }
            if ("notEmpty".equals(codeString)) {
                return AssertionOperatorType.NOTEMPTY;
            }
            if ("contains".equals(codeString)) {
                return AssertionOperatorType.CONTAINS;
            }
            if ("notContains".equals(codeString)) {
                return AssertionOperatorType.NOTCONTAINS;
            }
            if ("eval".equals(codeString)) {
                return AssertionOperatorType.EVAL;
            }
            throw new IllegalArgumentException("Unknown AssertionOperatorType code '" + codeString + "'");
        }

        public Enumeration<AssertionOperatorType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NULL, code);
            }
            if ("equals".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.EQUALS, code);
            }
            if ("notEquals".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTEQUALS, code);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.IN, code);
            }
            if ("notIn".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTIN, code);
            }
            if ("greaterThan".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.GREATERTHAN, code);
            }
            if ("lessThan".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.LESSTHAN, code);
            }
            if ("empty".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.EMPTY, code);
            }
            if ("notEmpty".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTEMPTY, code);
            }
            if ("contains".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.CONTAINS, code);
            }
            if ("notContains".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTCONTAINS, code);
            }
            if ("eval".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.EVAL, code);
            }
            throw new FHIRException("Unknown AssertionOperatorType code '" + codeString + "'");
        }

        @Override
        public String toCode(AssertionOperatorType code) {
            if (code == AssertionOperatorType.EQUALS) {
                return "equals";
            }
            if (code == AssertionOperatorType.NOTEQUALS) {
                return "notEquals";
            }
            if (code == AssertionOperatorType.IN) {
                return "in";
            }
            if (code == AssertionOperatorType.NOTIN) {
                return "notIn";
            }
            if (code == AssertionOperatorType.GREATERTHAN) {
                return "greaterThan";
            }
            if (code == AssertionOperatorType.LESSTHAN) {
                return "lessThan";
            }
            if (code == AssertionOperatorType.EMPTY) {
                return "empty";
            }
            if (code == AssertionOperatorType.NOTEMPTY) {
                return "notEmpty";
            }
            if (code == AssertionOperatorType.CONTAINS) {
                return "contains";
            }
            if (code == AssertionOperatorType.NOTCONTAINS) {
                return "notContains";
            }
            if (code == AssertionOperatorType.EVAL) {
                return "eval";
            }
            return "?";
        }

        @Override
        public String toSystem(AssertionOperatorType code) {
            return code.getSystem();
        }
    }

    public static enum AssertionOperatorType {
        EQUALS,
        NOTEQUALS,
        IN,
        NOTIN,
        GREATERTHAN,
        LESSTHAN,
        EMPTY,
        NOTEMPTY,
        CONTAINS,
        NOTCONTAINS,
        EVAL,
        NULL;


        public static AssertionOperatorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("equals".equals(codeString)) {
                return EQUALS;
            }
            if ("notEquals".equals(codeString)) {
                return NOTEQUALS;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("notIn".equals(codeString)) {
                return NOTIN;
            }
            if ("greaterThan".equals(codeString)) {
                return GREATERTHAN;
            }
            if ("lessThan".equals(codeString)) {
                return LESSTHAN;
            }
            if ("empty".equals(codeString)) {
                return EMPTY;
            }
            if ("notEmpty".equals(codeString)) {
                return NOTEMPTY;
            }
            if ("contains".equals(codeString)) {
                return CONTAINS;
            }
            if ("notContains".equals(codeString)) {
                return NOTCONTAINS;
            }
            if ("eval".equals(codeString)) {
                return EVAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AssertionOperatorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQUALS: {
                    return "equals";
                }
                case NOTEQUALS: {
                    return "notEquals";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "notIn";
                }
                case GREATERTHAN: {
                    return "greaterThan";
                }
                case LESSTHAN: {
                    return "lessThan";
                }
                case EMPTY: {
                    return "empty";
                }
                case NOTEMPTY: {
                    return "notEmpty";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOTCONTAINS: {
                    return "notContains";
                }
                case EVAL: {
                    return "eval";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQUALS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTEQUALS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case IN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case GREATERTHAN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case LESSTHAN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case EMPTY: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTEMPTY: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case CONTAINS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTCONTAINS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case EVAL: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQUALS: {
                    return "Default value. Equals comparison.";
                }
                case NOTEQUALS: {
                    return "Not equals comparison.";
                }
                case IN: {
                    return "Compare value within a known set of values.";
                }
                case NOTIN: {
                    return "Compare value not within a known set of values.";
                }
                case GREATERTHAN: {
                    return "Compare value to be greater than a known value.";
                }
                case LESSTHAN: {
                    return "Compare value to be less than a known value.";
                }
                case EMPTY: {
                    return "Compare value is empty.";
                }
                case NOTEMPTY: {
                    return "Compare value is not empty.";
                }
                case CONTAINS: {
                    return "Compare value string contains a known value.";
                }
                case NOTCONTAINS: {
                    return "Compare value string does not contain a known value.";
                }
                case EVAL: {
                    return "Evaluate the FHIRPath expression as a boolean condition.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQUALS: {
                    return "equals";
                }
                case NOTEQUALS: {
                    return "notEquals";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "notIn";
                }
                case GREATERTHAN: {
                    return "greaterThan";
                }
                case LESSTHAN: {
                    return "lessThan";
                }
                case EMPTY: {
                    return "empty";
                }
                case NOTEMPTY: {
                    return "notEmpty";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOTCONTAINS: {
                    return "notContains";
                }
                case EVAL: {
                    return "evaluate";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AssertionDirectionTypeEnumFactory
    implements EnumFactory<AssertionDirectionType> {
        @Override
        public AssertionDirectionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("response".equals(codeString)) {
                return AssertionDirectionType.RESPONSE;
            }
            if ("request".equals(codeString)) {
                return AssertionDirectionType.REQUEST;
            }
            throw new IllegalArgumentException("Unknown AssertionDirectionType code '" + codeString + "'");
        }

        public Enumeration<AssertionDirectionType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AssertionDirectionType>(this, AssertionDirectionType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AssertionDirectionType>(this, AssertionDirectionType.NULL, code);
            }
            if ("response".equals(codeString)) {
                return new Enumeration<AssertionDirectionType>(this, AssertionDirectionType.RESPONSE, code);
            }
            if ("request".equals(codeString)) {
                return new Enumeration<AssertionDirectionType>(this, AssertionDirectionType.REQUEST, code);
            }
            throw new FHIRException("Unknown AssertionDirectionType code '" + codeString + "'");
        }

        @Override
        public String toCode(AssertionDirectionType code) {
            if (code == AssertionDirectionType.RESPONSE) {
                return "response";
            }
            if (code == AssertionDirectionType.REQUEST) {
                return "request";
            }
            return "?";
        }

        @Override
        public String toSystem(AssertionDirectionType code) {
            return code.getSystem();
        }
    }

    public static enum AssertionDirectionType {
        RESPONSE,
        REQUEST,
        NULL;


        public static AssertionDirectionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("response".equals(codeString)) {
                return RESPONSE;
            }
            if ("request".equals(codeString)) {
                return REQUEST;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AssertionDirectionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RESPONSE: {
                    return "response";
                }
                case REQUEST: {
                    return "request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RESPONSE: {
                    return "http://hl7.org/fhir/assert-direction-codes";
                }
                case REQUEST: {
                    return "http://hl7.org/fhir/assert-direction-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RESPONSE: {
                    return "The assertion is evaluated on the response. This is the default value.";
                }
                case REQUEST: {
                    return "The assertion is evaluated on the request.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RESPONSE: {
                    return "response";
                }
                case REQUEST: {
                    return "request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

