/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.formats;

public class TurtleLexer {
    private String source;
    private int cursor;
    private String token;
    private TurtleTokenType type;

    public TurtleLexer(String source) throws Exception {
        this.source = source;
        this.cursor = 0;
        this.readNext();
    }

    private void readNext() throws Exception {
        if (this.cursor >= this.source.length()) {
            this.token = null;
            this.type = TurtleTokenType.NULL;
        } else if (this.source.charAt(this.cursor) == '\"') {
            this.readLiteral();
        } else if (this.source.charAt(this.cursor) == '[' || this.source.charAt(this.cursor) == ']') {
            this.readDelimiter();
        } else {
            if (this.source.charAt(this.cursor) == '(') {
                throw new Exception("not supported yet");
            }
            if (this.source.charAt(this.cursor) == ';' || this.source.charAt(this.cursor) == '.' || this.source.charAt(this.cursor) == ',') {
                this.readDelimiter();
            } else if (Character.isLetter(this.source.charAt(this.cursor))) {
                this.readToken();
            }
        }
    }

    private void readLiteral() {
        StringBuilder b = new StringBuilder();
        ++this.cursor;
        while (this.cursor < this.source.length() && this.source.charAt(this.cursor) != '\"') {
            if (this.source.charAt(this.cursor) == '\\') {
                b.append(this.source.charAt(this.cursor));
                ++this.cursor;
            }
            b.append(this.source.charAt(this.cursor));
            ++this.cursor;
        }
        this.token = "\"" + b.toString() + "\"";
        this.type = TurtleTokenType.LITERAL;
        ++this.cursor;
        while (this.cursor < this.source.length() && Character.isWhitespace(this.source.charAt(this.cursor))) {
            ++this.cursor;
        }
    }

    private void readDelimiter() {
        StringBuilder b = new StringBuilder();
        b.append(this.source.charAt(this.cursor));
        ++this.cursor;
        this.token = b.toString();
        this.type = TurtleTokenType.SPECIAL;
        while (this.cursor < this.source.length() && Character.isWhitespace(this.source.charAt(this.cursor))) {
            ++this.cursor;
        }
    }

    private void readToken() {
        StringBuilder b = new StringBuilder();
        while (this.cursor < this.source.length() && this.isValidTokenChar(this.source.charAt(this.cursor))) {
            if (this.source.charAt(this.cursor) == '\\') {
                b.append(this.source.charAt(this.cursor));
                ++this.cursor;
            }
            b.append(this.source.charAt(this.cursor));
            ++this.cursor;
        }
        this.token = b.toString();
        this.type = TurtleTokenType.TOKEN;
        if (this.token.endsWith(".")) {
            --this.cursor;
            this.token = this.token.substring(0, this.token.length() - 1);
        }
        while (this.cursor < this.source.length() && Character.isWhitespace(this.source.charAt(this.cursor))) {
            ++this.cursor;
        }
    }

    private boolean isValidTokenChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == ':' || c == '\\' || c == '.';
    }

    public boolean done() {
        return this.type == TurtleTokenType.NULL;
    }

    public String next() throws Exception {
        String res = this.token;
        this.readNext();
        return res;
    }

    public String peek() throws Exception {
        return this.token;
    }

    public TurtleTokenType peekType() {
        return this.type;
    }

    public static enum TurtleTokenType {
        NULL,
        TOKEN,
        SPECIAL,
        LITERAL;

    }
}

