/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.renderers.ResourceRenderer;
import org.hl7.fhir.r4b.renderers.utils.BaseWrappers;
import org.hl7.fhir.r4b.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ProvenanceRenderer
extends ResourceRenderer {
    public ProvenanceRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource prv) throws UnsupportedEncodingException, IOException {
        return this.render(x, (Provenance)prv);
    }

    public boolean render(XhtmlNode x, Provenance prv) throws UnsupportedEncodingException, IOException {
        XhtmlNode tr;
        boolean hasExtensions = false;
        if (!prv.getTarget().isEmpty()) {
            if (prv.getTarget().size() == 1) {
                XhtmlNode p = x.para();
                p.tx("Provenance for ");
                this.renderReference(prv, p, prv.getTargetFirstRep());
            } else {
                x.para().tx("Provenance for:");
                XhtmlNode ul = x.ul();
                for (Reference ref : prv.getTarget()) {
                    this.renderReference(prv, ul.li(), ref);
                }
            }
        }
        x.para().tx("Summary");
        XhtmlNode t = x.table("grid");
        if (prv.hasOccurred()) {
            tr = t.tr();
            tr.td().tx("Occurrence");
            if (prv.hasOccurredPeriod()) {
                this.renderPeriod(tr.td(), prv.getOccurredPeriod());
            } else {
                this.renderDateTime(tr.td(), prv.getOccurredDateTimeType());
            }
        }
        if (prv.hasRecorded()) {
            tr = t.tr();
            tr.td().tx("Recorded");
            tr.td().addText(prv.getRecordedElement().toHumanDisplay());
        }
        if (prv.hasPolicy()) {
            tr = t.tr();
            tr.td().tx("Policy");
            if (prv.getPolicy().size() == 1) {
                this.renderUri(tr.td(), prv.getPolicy().get(0));
            } else {
                XhtmlNode ul = tr.td().ul();
                for (UriType u : prv.getPolicy()) {
                    this.renderUri(ul.li(), u);
                }
            }
        }
        if (prv.hasLocation()) {
            tr = t.tr();
            tr.td().tx("Location");
            this.renderReference(prv, tr.td(), prv.getLocation());
        }
        if (prv.hasActivity()) {
            tr = t.tr();
            tr.td().tx("Activity");
            this.renderCodeableConcept(tr.td(), prv.getActivity(), false);
        }
        boolean hasType = false;
        boolean hasRole = false;
        boolean hasOnBehalfOf = false;
        for (Provenance.ProvenanceAgentComponent a : prv.getAgent()) {
            hasType = hasType || a.hasType();
            hasRole = hasRole || a.hasRole();
            hasOnBehalfOf = hasOnBehalfOf || a.hasOnBehalfOf();
        }
        x.para().b().tx("Agents");
        t = x.table("grid");
        tr = t.tr();
        if (hasType) {
            tr.td().b().tx("Type");
        }
        if (hasRole) {
            tr.td().b().tx("Role");
        }
        tr.td().b().tx("who");
        if (hasOnBehalfOf) {
            tr.td().b().tx("On Behalf Of");
        }
        for (Provenance.ProvenanceAgentComponent a : prv.getAgent()) {
            tr = t.tr();
            if (hasType) {
                if (a.hasType()) {
                    this.renderCodeableConcept(tr.td(), a.getType(), false);
                } else {
                    tr.td();
                }
            }
            if (hasRole) {
                if (a.hasRole()) {
                    if (a.getRole().size() == 1) {
                        this.renderCodeableConcept(tr.td(), a.getType(), false);
                    } else {
                        XhtmlNode ul = tr.td().ul();
                        for (CodeableConcept cc : a.getRole()) {
                            this.renderCodeableConcept(ul.li(), cc, false);
                        }
                    }
                } else {
                    tr.td();
                }
            }
            if (a.hasWho()) {
                this.renderReference(prv, tr.td(), a.getWho());
            } else {
                tr.td();
            }
            if (!hasOnBehalfOf) continue;
            if (a.hasOnBehalfOf()) {
                this.renderReference(prv, tr.td(), a.getOnBehalfOf());
                continue;
            }
            tr.td();
        }
        return hasExtensions;
    }

    @Override
    public String display(Resource dr) throws UnsupportedEncodingException, IOException {
        return this.display((Provenance)dr);
    }

    public String display(Provenance prv) throws UnsupportedEncodingException, IOException {
        return "Provenance for " + this.displayReference(prv, prv.getTargetFirstRep());
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }
}

