/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.terminologies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;

public class TerminologyCacheManager {
    private static final String CACHE_VERSION = "1";
    private String cacheFolder;
    private String version;
    private String ghOrg;
    private String ghRepo;
    private String ghBranch;

    public TerminologyCacheManager(String serverVersion, String rootDir, String ghOrg, String ghRepo, String ghBranch) throws IOException {
        this.ghOrg = ghOrg;
        this.ghRepo = ghRepo;
        this.ghBranch = ghBranch;
        this.version = "1/" + VersionUtilities.getMajMin((String)serverVersion);
        this.cacheFolder = Utilities.noString((String)ghOrg) || Utilities.noString((String)ghRepo) || Utilities.noString((String)ghBranch) ? Utilities.path((String[])new String[]{rootDir, "temp", "tx-cache"}) : Utilities.path((String[])new String[]{System.getProperty("user.home"), ".fhir", "tx-cache", ghOrg, ghRepo, ghBranch});
    }

    public void initialize() throws IOException {
        File f = new File(this.cacheFolder);
        if (!f.exists()) {
            Utilities.createDirectory((String)this.cacheFolder);
        }
        if (!this.version.equals(this.getCacheVersion())) {
            this.clearCache();
            this.fillCache("https://tx.fhir.org/tx-cache/" + this.ghOrg + "/" + this.ghRepo + "/" + this.ghBranch + ".zip");
        }
        if (!this.version.equals(this.getCacheVersion())) {
            this.clearCache();
            this.fillCache("https://tx.fhir.org/tx-cache/" + this.ghOrg + "/" + this.ghRepo + "/default.zip");
        }
        if (!this.version.equals(this.getCacheVersion())) {
            this.clearCache();
        }
        IniFile ini = new IniFile(Utilities.path((String[])new String[]{this.cacheFolder, "cache.ini"}));
        ini.setStringProperty("cache", "version", this.version, null);
        ini.setDateProperty("cache", "last-use", new Date(), null);
        ini.save();
    }

    private void fillCache(String source) throws IOException {
        try {
            System.out.println("Initialise terminology cache from " + source);
            SimpleHTTPClient http = new SimpleHTTPClient();
            SimpleHTTPClient.HTTPResult res = http.get(source + "?nocache=" + System.currentTimeMillis());
            res.checkThrowException();
            TerminologyCacheManager.unzip(new ByteArrayInputStream(res.getContent()), this.cacheFolder);
        }
        catch (Exception e) {
            System.out.println("No - can't initialise cache from " + source + ": " + e.getMessage());
        }
    }

    public static void unzip(InputStream is, String targetDir) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                String path = Path.of(Utilities.path((String[])new String[]{targetDir, ze.getName()}), new String[0]).normalize().toFile().getAbsolutePath();
                if (!path.startsWith(targetDir)) {
                    throw new RuntimeException("Entry with an illegal path: " + ze.getName());
                }
                if (ze.isDirectory()) {
                    Utilities.createDirectory((String)path);
                    continue;
                }
                Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)path));
                TextFile.streamToFileNoClose((InputStream)zipIn, (String)path);
            }
        }
    }

    private void clearCache() throws IOException {
        Utilities.clearDirectory((String)this.cacheFolder, (String[])new String[0]);
    }

    private String getCacheVersion() throws IOException {
        IniFile ini = new IniFile(Utilities.path((String[])new String[]{this.cacheFolder, "cache.ini"}));
        return ini.getStringProperty("cache", "version");
    }

    public String getFolder() {
        return this.cacheFolder;
    }

    private void zipDirectory(OutputStream outputStream) throws IOException {
        try (ZipOutputStream zs = new ZipOutputStream(outputStream);){
            Path pp = Paths.get(this.cacheFolder, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).forEach(path -> {
                try {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        zs.putNextEntry(new ZipEntry(pp.relativize((Path)path).toString() + "/"));
                    } else {
                        ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                        zs.putNextEntry(zipEntry);
                        Files.copy(path, zs);
                        zs.closeEntry();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            });
        }
    }

    public void commit(String token) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        this.zipDirectory(bs);
        String url = "https://tx.fhir.org/post/tx-cache/" + this.ghOrg + "/" + this.ghRepo + "/" + this.ghBranch + ".zip";
        System.out.println("Sending tx-cache to " + url + " (" + Utilities.describeSize((int)bs.toByteArray().length) + ")");
        SimpleHTTPClient http = new SimpleHTTPClient();
        http.setUsername(token.substring(0, token.indexOf(58)));
        http.setPassword(token.substring(token.indexOf(58) + 1));
        SimpleHTTPClient.HTTPResult res = http.put(url, "application/zip", bs.toByteArray(), null);
        if (res.getCode() >= 300) {
            System.out.println("sending cache failed: " + res.getCode());
        } else {
            System.out.println("Sent cache");
        }
    }
}

