package org.hl7.fhir.r4b.formats;

// generated

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Mon, Jun 13, 2022 17:19+0300 for FHIR v4.3.0



import org.hl7.fhir.r4b.model.*;
import org.hl7.fhir.r4b.model.Enumerations.FHIRVersion;
import org.xmlpull.v1.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import java.io.IOException;

public class XmlParser extends XmlParserBase {

  public XmlParser() {
    super();
  }

  public XmlParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  protected boolean parseBaseContent(int eventType, XmlPullParser xpp, Base res) throws XmlPullParserException, IOException, FHIRFormatError {
    return false;
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    parseElementAttributes(xpp, res);
    res.setValue((E) e.fromCode(xpp.getAttributeValue(null, "value")));
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DateType res = new DateType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    StringType res = new StringType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected Integer64Type parseInteger64(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Integer64Type res = new Integer64Type(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OidType res = new OidType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected CanonicalType parseCanonical(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CanonicalType res = new CanonicalType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UriType res = new UriType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UrlType parseUrl(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UrlType res = new UrlType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    IdType res = new IdType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extension")) {
      res.getExtension().add(parseExtension(xpp));
    } else { 
        return false;
    }
    return true;
  }

  protected boolean parseBackboneElementContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) {
      res.getModifierExtension().add(parseExtension(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
        return false;
    }
    return true;
  }

  protected boolean parseBackboneTypeContent(int eventType, XmlPullParser xpp, BackboneType res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) {
      res.getModifierExtension().add(parseExtension(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected boolean parseDataTypeContent(int eventType, XmlPullParser xpp, DataType res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!parseElementContent(eventType, xpp, res)){ 
        return false;
    }
    return true;
  }

  protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Address res = new Address();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAddressContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAddressContent(int eventType, XmlPullParser xpp, Address res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("line")) {
      res.getLine().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("city")) {
      res.setCityElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("district")) {
      res.setDistrictElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("state")) {
      res.setStateElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("postalCode")) {
      res.setPostalCodeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
      res.setCountryElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Age res = new Age();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAgeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAgeContent(int eventType, XmlPullParser xpp, Age res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!parseQuantityContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAnnotationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAnnotationContent(int eventType, XmlPullParser xpp, Annotation res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "author")) {
      res.setAuthor(parseType("author", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
      res.setTimeElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseMarkdown(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAttachmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAttachmentContent(int eventType, XmlPullParser xpp, Attachment res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
      res.setContentTypeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguageElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
      res.setDataElement(parseBase64Binary(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUrl(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("size")) {
      res.setSizeElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hash")) {
      res.setHashElement(parseBase64Binary(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("creation")) {
      res.setCreationElement(parseDateTime(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeableConceptContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeableConceptContent(int eventType, XmlPullParser xpp, CodeableConcept res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coding")) {
      res.getCoding().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeableReference parseCodeableReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeableReference res = new CodeableReference();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeableReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeableReferenceContent(int eventType, XmlPullParser xpp, CodeableReference res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
      res.setConcept(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coding res = new Coding();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodingContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodingContent(int eventType, XmlPullParser xpp, Coding res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
      res.setSystemElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("userSelected")) {
      res.setUserSelectedElement(parseBoolean(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ContactDetail parseContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContactDetailContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContactDetailContent(int eventType, XmlPullParser xpp, ContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
      res.getTelecom().add(parseContactPoint(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContactPointContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContactPointContent(int eventType, XmlPullParser xpp, ContactPoint res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
      res.setSystemElement(parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
      res.setRankElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contributor parseContributor(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContributorContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContributorContent(int eventType, XmlPullParser xpp, Contributor res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Count res = new Count();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCountContent(int eventType, XmlPullParser xpp, Count res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!parseQuantityContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDataRequirementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementContent(int eventType, XmlPullParser xpp, DataRequirement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.getProfile().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
      res.setSubject(parseType("subject", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mustSupport")) {
      res.getMustSupport().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("codeFilter")) {
      res.getCodeFilter().add(parseDataRequirementCodeFilterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateFilter")) {
      res.getDateFilter().add(parseDataRequirementDateFilterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("limit")) {
      res.setLimitElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sort")) {
      res.getSort().add(parseDataRequirementSortComponent(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementCodeFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDataRequirementCodeFilterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementCodeFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementCodeFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
      res.setSearchParamElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
      res.setValueSetElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCoding(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDateFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDataRequirementDateFilterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementDateFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementDateFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
      res.setSearchParamElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DataRequirement.DataRequirementSortComponent parseDataRequirementSortComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDataRequirementSortComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementSortComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementSortComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("direction")) {
      res.setDirectionElement(parseEnumeration(xpp, DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Distance res = new Distance();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDistanceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDistanceContent(int eventType, XmlPullParser xpp, Distance res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!parseQuantityContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Dosage parseDosage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDosageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDosageContent(int eventType, XmlPullParser xpp, Dosage res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalInstruction")) {
      res.getAdditionalInstruction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientInstruction")) {
      res.setPatientInstructionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timing")) {
      res.setTiming(parseTiming(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "asNeeded")) {
      res.setAsNeeded(parseType("asNeeded", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
      res.setSite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
      res.setRoute(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseAndRate")) {
      res.getDoseAndRate().add(parseDosageDoseAndRateComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerPeriod")) {
      res.setMaxDosePerPeriod(parseRatio(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerAdministration")) {
      res.setMaxDosePerAdministration(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerLifetime")) {
      res.setMaxDosePerLifetime(parseQuantity(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Dosage.DosageDoseAndRateComponent parseDosageDoseAndRateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDosageDoseAndRateComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDosageDoseAndRateComponentContent(int eventType, XmlPullParser xpp, Dosage.DosageDoseAndRateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "dose")) {
      res.setDose(parseType("dose", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
      res.setRate(parseType("rate", xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Duration res = new Duration();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDurationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDurationContent(int eventType, XmlPullParser xpp, Duration res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!parseQuantityContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionContent(int eventType, XmlPullParser xpp, ElementDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("representation")) {
      res.getRepresentation().add(parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceName")) {
      res.setSliceNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceIsConstraining")) {
      res.setSliceIsConstrainingElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
      res.setLabelElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("slicing")) {
      res.setSlicing(parseElementDefinitionSlicingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("short")) {
      res.setShortElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinitionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirements")) {
      res.setRequirementsElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
      res.getAlias().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
      res.setMinElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
      res.setMaxElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
      res.setBase(parseElementDefinitionBaseComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentReference")) {
      res.setContentReferenceElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseElementDefinitionTypeRefComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "defaultValue")) {
      res.setDefaultValue(parseType("defaultValue", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaningWhenMissing")) {
      res.setMeaningWhenMissingElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderMeaning")) {
      res.setOrderMeaningElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "fixed")) {
      res.setFixed(parseType("fixed", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "pattern")) {
      res.setPattern(parseType("pattern", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("example")) {
      res.getExample().add(parseElementDefinitionExampleComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "minValue")) {
      res.setMinValue(parseType("minValue", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "maxValue")) {
      res.setMaxValue(parseType("maxValue", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxLength")) {
      res.setMaxLengthElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.getCondition().add(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("constraint")) {
      res.getConstraint().add(parseElementDefinitionConstraintComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mustSupport")) {
      res.setMustSupportElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isModifier")) {
      res.setIsModifierElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isModifierReason")) {
      res.setIsModifierReasonElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isSummary")) {
      res.setIsSummaryElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("binding")) {
      res.setBinding(parseElementDefinitionBindingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mapping")) {
      res.getMapping().add(parseElementDefinitionMappingComponent(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionSlicingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionSlicingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionSlicingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionSlicingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("discriminator")) {
      res.getDiscriminator().add(parseElementDefinitionSlicingDiscriminatorComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ordered")) {
      res.setOrderedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rules")) {
      res.setRulesElement(parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionSlicingDiscriminatorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionSlicingDiscriminatorComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionSlicingDiscriminatorComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionBaseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionBaseComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionBaseComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionBaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
      res.setMinElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
      res.setMaxElement(parseString(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionTypeRefComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionTypeRefComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.TypeRefComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.getProfile().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetProfile")) {
      res.getTargetProfile().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("aggregation")) {
      res.getAggregation().add(parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versioning")) {
      res.setVersioningElement(parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionExampleComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionExampleComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionExampleComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionExampleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
      res.setLabelElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionConstraintComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionConstraintComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionConstraintComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionConstraintComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("key")) {
      res.setKeyElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirements")) {
      res.setRequirementsElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
      res.setSeverityElement(parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("human")) {
      res.setHumanElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
      res.setExpressionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("xpath")) {
      res.setXpathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseCanonical(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionBindingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionBindingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionBindingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
      res.setStrengthElement(parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
      res.setValueSetElement(parseCanonical(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionMappingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseElementDefinitionMappingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identity")) {
      res.setIdentityElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguageElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("map")) {
      res.setMapElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Expression parseExpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Expression res = new Expression();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExpressionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpressionContent(int eventType, XmlPullParser xpp, Expression res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguageElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
      res.setExpressionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReferenceElement(parseUri(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Extension res = new Extension();
    parseElementAttributes(xpp, res);
    if (xpp.getAttributeValue(null, "url") != null)
        res.setUrl(xpp.getAttributeValue(null, "url"));
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExtensionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExtensionContent(int eventType, XmlPullParser xpp, Extension res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseHumanNameContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHumanNameContent(int eventType, XmlPullParser xpp, HumanName res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("family")) {
      res.setFamilyElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("given")) {
      res.getGiven().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prefix")) {
      res.getPrefix().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suffix")) {
      res.getSuffix().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseIdentifierContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIdentifierContent(int eventType, XmlPullParser xpp, Identifier res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
      res.setSystemElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assigner")) {
      res.setAssigner(parseReference(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MarketingStatus parseMarketingStatus(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MarketingStatus res = new MarketingStatus();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMarketingStatusContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMarketingStatusContent(int eventType, XmlPullParser xpp, MarketingStatus res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
      res.setCountry(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.setJurisdiction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateRange")) {
      res.setDateRange(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("restoreDate")) {
      res.setRestoreDateElement(parseDateTime(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Meta res = new Meta();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMetaContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMetaContent(int eventType, XmlPullParser xpp, Meta res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
      res.setVersionIdElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastUpdated")) {
      res.setLastUpdatedElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.getProfile().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("security")) {
      res.getSecurity().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tag")) {
      res.getTag().add(parseCoding(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Money res = new Money();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMoneyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMoneyContent(int eventType, XmlPullParser xpp, Money res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("currency")) {
      res.setCurrencyElement(parseCode(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNarrativeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNarrativeContent(int eventType, XmlPullParser xpp, Narrative res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("div")) {
      res.setDiv(parseXhtml(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseParameterDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParameterDefinitionContent(int eventType, XmlPullParser xpp, ParameterDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
      res.setMinElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
      res.setMaxElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Period res = new Period();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parsePeriodContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePeriodContent(int eventType, XmlPullParser xpp, Period res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseDateTime(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Population parsePopulation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Population res = new Population();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parsePopulationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePopulationContent(int eventType, XmlPullParser xpp, Population res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "age")) {
      res.setAge(parseType("age", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
      res.setGender(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("race")) {
      res.setRace(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physiologicalCondition")) {
      res.setPhysiologicalCondition(parseCodeableConcept(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ProdCharacteristic parseProdCharacteristic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProdCharacteristic res = new ProdCharacteristic();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseProdCharacteristicContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProdCharacteristicContent(int eventType, XmlPullParser xpp, ProdCharacteristic res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("height")) {
      res.setHeight(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("width")) {
      res.setWidth(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("depth")) {
      res.setDepth(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("weight")) {
      res.setWeight(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nominalVolume")) {
      res.setNominalVolume(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("externalDiameter")) {
      res.setExternalDiameter(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("shape")) {
      res.setShapeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("color")) {
      res.getColor().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imprint")) {
      res.getImprint().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
      res.getImage().add(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scoring")) {
      res.setScoring(parseCodeableConcept(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ProductShelfLife parseProductShelfLife(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProductShelfLife res = new ProductShelfLife();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseProductShelfLifeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProductShelfLifeContent(int eventType, XmlPullParser xpp, ProductShelfLife res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "period")) {
      res.setPeriod(parseType("period", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialPrecautionsForStorage")) {
      res.getSpecialPrecautionsForStorage().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseQuantityContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuantityContent(int eventType, XmlPullParser xpp, Quantity res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comparator")) {
      res.setComparatorElement(parseEnumeration(xpp, Enumerations.QuantityComparator.NULL, new Enumerations.QuantityComparatorEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
      res.setUnitElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
      res.setSystemElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Range res = new Range();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseRangeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRangeContent(int eventType, XmlPullParser xpp, Range res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("low")) {
      res.setLow(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("high")) {
      res.setHigh(parseQuantity(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseRatioContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRatioContent(int eventType, XmlPullParser xpp, Ratio res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numerator")) {
      res.setNumerator(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("denominator")) {
      res.setDenominator(parseQuantity(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected RatioRange parseRatioRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RatioRange res = new RatioRange();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseRatioRangeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRatioRangeContent(int eventType, XmlPullParser xpp, RatioRange res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lowNumerator")) {
      res.setLowNumerator(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("highNumerator")) {
      res.setHighNumerator(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("denominator")) {
      res.setDenominator(parseQuantity(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Reference res = new Reference();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseReferenceContent(int eventType, XmlPullParser xpp, Reference res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReferenceElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected RelatedArtifact parseRelatedArtifact(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseRelatedArtifactContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRelatedArtifactContent(int eventType, XmlPullParser xpp, RelatedArtifact res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
      res.setLabelElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("citation")) {
      res.setCitationElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUrl(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("document")) {
      res.setDocument(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.setResourceElement(parseCanonical(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseSampledDataContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSampledDataContent(int eventType, XmlPullParser xpp, SampledData res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
      res.setOrigin(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriodElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lowerLimit")) {
      res.setLowerLimitElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("upperLimit")) {
      res.setUpperLimitElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dimensions")) {
      res.setDimensionsElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
      res.setDataElement(parseString(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Signature res = new Signature();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseSignatureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSignatureContent(int eventType, XmlPullParser xpp, Signature res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("when")) {
      res.setWhenElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("who")) {
      res.setWho(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
      res.setOnBehalfOf(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetFormat")) {
      res.setTargetFormatElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sigFormat")) {
      res.setSigFormatElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
      res.setDataElement(parseBase64Binary(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Timing res = new Timing();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseTimingContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTimingContent(int eventType, XmlPullParser xpp, Timing res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
      res.getEvent().add(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repeat")) {
      res.setRepeat(parseTimingRepeatComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Timing.TimingRepeatComponent parseTimingRepeatComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseTimingRepeatComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTimingRepeatComponentContent(int eventType, XmlPullParser xpp, Timing.TimingRepeatComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "bounds")) {
      res.setBounds(parseType("bounds", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
      res.setCountElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("countMax")) {
      res.setCountMaxElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
      res.setDurationElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("durationMax")) {
      res.setDurationMaxElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("durationUnit")) {
      res.setDurationUnitElement(parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequency")) {
      res.setFrequencyElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequencyMax")) {
      res.setFrequencyMaxElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriodElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodMax")) {
      res.setPeriodMaxElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodUnit")) {
      res.setPeriodUnitElement(parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dayOfWeek")) {
      res.getDayOfWeek().add(parseEnumeration(xpp, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timeOfDay")) {
      res.getTimeOfDay().add(parseTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("when")) {
      res.getWhen().add(parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("offset")) {
      res.setOffsetElement(parseUnsignedInt(xpp));
    } else if (!parseElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseTriggerDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTriggerDefinitionContent(int eventType, XmlPullParser xpp, TriggerDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
      res.setTiming(parseType("timing", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
      res.getData().add(parseDataRequirement(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.setCondition(parseExpression(xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected UsageContext parseUsageContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseUsageContextContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseUsageContextContent(int eventType, XmlPullParser xpp, UsageContext res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseDataTypeContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("id")) {
      res.setIdElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meta")) {
      res.setMeta(parseMeta(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implicitRules")) {
      res.setImplicitRulesElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguageElement(parseCode(xpp));
    } else  { 
        return false;
    }
    return true;
  }

  protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setText(parseNarrative(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contained")) {
      res.getContained().add(parseResourceContained(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extension")) {
      res.getExtension().add(parseExtension(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) {
      res.getModifierExtension().add(parseExtension(xpp));
    } else if (!parseResourceContent(eventType, xpp, res)){ 
        return false;
    }
    return true;
  }

  protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Account res = new Account();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAccountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountContent(int eventType, XmlPullParser xpp, Account res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.getSubject().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("servicePeriod")) {
      res.setServicePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.getCoverage().add(parseAccountCoverageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
      res.setOwner(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("guarantor")) {
      res.getGuarantor().add(parseAccountGuarantorComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.setPartOf(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAccountCoverageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountCoverageComponentContent(int eventType, XmlPullParser xpp, Account.CoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parsePositiveInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAccountGuarantorComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountGuarantorComponentContent(int eventType, XmlPullParser xpp, Account.GuarantorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
      res.setParty(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onHold")) {
      res.setOnHoldElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ActivityDefinition parseActivityDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseActivityDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionContent(int eventType, XmlPullParser xpp, ActivityDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
      res.setSubtitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
      res.setSubject(parseType("subject", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
      res.setUsageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
      res.setEffectivePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
      res.getTopic().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
      res.getLibrary().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
      res.setKindElement(parseEnumeration(xpp, ActivityDefinition.RequestResourceType.NULL, new ActivityDefinition.RequestResourceTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
      res.setIntentElement(parseEnumeration(xpp, Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
      res.setDoNotPerformElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
      res.setTiming(parseType("timing", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
      res.getParticipant().add(parseActivityDefinitionParticipantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
      res.setProduct(parseType("product", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
      res.getDosage().add(parseDosage(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.getBodySite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimenRequirement")) {
      res.getSpecimenRequirement().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observationRequirement")) {
      res.getObservationRequirement().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observationResultRequirement")) {
      res.getObservationResultRequirement().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("transform")) {
      res.setTransformElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dynamicValue")) {
      res.getDynamicValue().add(parseActivityDefinitionDynamicValueComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseActivityDefinitionParticipantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionParticipantComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.ActionParticipantType.NULL, new Enumerations.ActionParticipantTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionDynamicValueComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseActivityDefinitionDynamicValueComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionDynamicValueComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
      res.setExpression(parseExpression(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdministrableProductDefinition parseAdministrableProductDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition res = new AdministrableProductDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdministrableProductDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("formOf")) {
      res.getFormOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrableDoseForm")) {
      res.setAdministrableDoseForm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitOfPresentation")) {
      res.setUnitOfPresentation(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("producedFrom")) {
      res.getProducedFrom().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
      res.getIngredient().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.setDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.getProperty().add(parseAdministrableProductDefinitionPropertyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("routeOfAdministration")) {
      res.getRouteOfAdministration().add(parseAdministrableProductDefinitionRouteOfAdministrationComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent parseAdministrableProductDefinitionPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdministrableProductDefinitionPropertyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatus(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionRouteOfAdministrationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdministrableProductDefinitionRouteOfAdministrationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionRouteOfAdministrationComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("firstDose")) {
      res.setFirstDose(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxSingleDose")) {
      res.setMaxSingleDose(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerDay")) {
      res.setMaxDosePerDay(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerTreatmentPeriod")) {
      res.setMaxDosePerTreatmentPeriod(parseRatio(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxTreatmentPeriod")) {
      res.setMaxTreatmentPeriod(parseDuration(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetSpecies")) {
      res.getTargetSpecies().add(parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("withdrawalPeriod")) {
      res.getWithdrawalPeriod().add(parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tissue")) {
      res.setTissue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValue(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
      res.setSupportingInformationElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdverseEvent parseAdverseEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdverseEventContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventContent(int eventType, XmlPullParser xpp, AdverseEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actuality")) {
      res.setActualityElement(parseEnumeration(xpp, AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
      res.setEvent(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detected")) {
      res.setDetectedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedDate")) {
      res.setRecordedDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resultingCondition")) {
      res.getResultingCondition().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("seriousness")) {
      res.setSeriousness(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
      res.setSeverity(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcome(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
      res.setRecorder(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
      res.getContributor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suspectEntity")) {
      res.getSuspectEntity().add(parseAdverseEventSuspectEntityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectMedicalHistory")) {
      res.getSubjectMedicalHistory().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceDocument")) {
      res.getReferenceDocument().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("study")) {
      res.getStudy().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventSuspectEntityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdverseEventSuspectEntityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventSuspectEntityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventSuspectEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
      res.setInstance(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("causality")) {
      res.getCausality().add(parseAdverseEventSuspectEntityCausalityComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventSuspectEntityCausalityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAdverseEventSuspectEntityCausalityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventSuspectEntityCausalityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessment")) {
      res.setAssessment(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productRelatedness")) {
      res.setProductRelatednessElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAllergyIntoleranceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAllergyIntoleranceContent(int eventType, XmlPullParser xpp, AllergyIntolerance res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalStatus")) {
      res.setClinicalStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationStatus")) {
      res.setVerificationStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criticality")) {
      res.setCriticalityElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
      res.setOnset(parseType("onset", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedDate")) {
      res.setRecordedDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
      res.setRecorder(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asserter")) {
      res.setAsserter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastOccurrence")) {
      res.setLastOccurrenceElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reaction")) {
      res.getReaction().add(parseAllergyIntoleranceReactionComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceReactionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAllergyIntoleranceReactionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAllergyIntoleranceReactionComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
      res.setSubstance(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manifestation")) {
      res.getManifestation().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onset")) {
      res.setOnsetElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
      res.setSeverityElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exposureRoute")) {
      res.setExposureRoute(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAppointmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentContent(int eventType, XmlPullParser xpp, Appointment res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cancelationReason")) {
      res.setCancelationReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceCategory")) {
      res.getServiceCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
      res.getServiceType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
      res.getSpecialty().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentType")) {
      res.setAppointmentType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
      res.getSupportingInformation().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("minutesDuration")) {
      res.setMinutesDurationElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("slot")) {
      res.getSlot().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientInstruction")) {
      res.setPatientInstructionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
      res.getParticipant().add(parseAppointmentParticipantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestedPeriod")) {
      res.getRequestedPeriod().add(parsePeriod(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAppointmentParticipantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentParticipantComponentContent(int eventType, XmlPullParser xpp, Appointment.AppointmentParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("required")) {
      res.setRequiredElement(parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAppointmentResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentResponseContent(int eventType, XmlPullParser xpp, AppointmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointment")) {
      res.setAppointment(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participantType")) {
      res.getParticipantType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participantStatus")) {
      res.setParticipantStatusElement(parseEnumeration(xpp, Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAuditEventContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventContent(int eventType, XmlPullParser xpp, AuditEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtype")) {
      res.getSubtype().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
      res.setActionElement(parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
      res.setRecordedElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcomeElement(parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeDesc")) {
      res.setOutcomeDescElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purposeOfEvent")) {
      res.getPurposeOfEvent().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
      res.getAgent().add(parseAuditEventAgentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseAuditEventSourceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
      res.getEntity().add(parseAuditEventEntityComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAgentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAuditEventAgentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAgentComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.getRole().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("who")) {
      res.setWho(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("altId")) {
      res.setAltIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
      res.setRequestorElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
      res.getPolicy().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("media")) {
      res.setMedia(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.setNetwork(parseAuditEventAgentNetworkComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purposeOfUse")) {
      res.getPurposeOfUse().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAgentNetworkComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAuditEventAgentNetworkComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAgentNetworkComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventAgentNetworkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
      res.setAddressElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventSourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAuditEventSourceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventSourceComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
      res.setSiteElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observer")) {
      res.setObserver(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCoding(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventEntityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAuditEventEntityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventEntityComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("what")) {
      res.setWhat(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lifecycle")) {
      res.setLifecycle(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
      res.getSecurityLabel().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("query")) {
      res.setQueryElement(parseBase64Binary(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseAuditEventEntityDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventEntityDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseAuditEventEntityDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventEntityDetailComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventEntityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Basic res = new Basic();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBasicContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBasicContent(int eventType, XmlPullParser xpp, Basic res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Binary res = new Binary();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBinaryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBinaryContent(int eventType, XmlPullParser xpp, Binary res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
      res.setContentTypeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityContext")) {
      res.setSecurityContext(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
      res.setDataElement(parseBase64Binary(xpp));
    } else if (!parseResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBiologicallyDerivedProductContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productCategory")) {
      res.setProductCategoryElement(parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productCode")) {
      res.setProductCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.getRequest().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantityElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
      res.getParent().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collection")) {
      res.setCollection(parseBiologicallyDerivedProductCollectionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processing")) {
      res.getProcessing().add(parseBiologicallyDerivedProductProcessingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manipulation")) {
      res.setManipulation(parseBiologicallyDerivedProductManipulationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("storage")) {
      res.getStorage().add(parseBiologicallyDerivedProductStorageComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductCollectionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBiologicallyDerivedProductCollectionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductCollectionComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collector")) {
      res.setCollector(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "collected")) {
      res.setCollected(parseType("collected", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductProcessingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBiologicallyDerivedProductProcessingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductProcessingComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
      res.setProcedure(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additive")) {
      res.setAdditive(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "time")) {
      res.setTime(parseType("time", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductManipulationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBiologicallyDerivedProductManipulationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductManipulationComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "time")) {
      res.setTime(parseType("time", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductStorageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBiologicallyDerivedProductStorageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBiologicallyDerivedProductStorageComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("temperature")) {
      res.setTemperatureElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scale")) {
      res.setScaleElement(parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
      res.setDuration(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected BodyStructure parseBodyStructure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBodyStructureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBodyStructureContent(int eventType, XmlPullParser xpp, BodyStructure res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
      res.setActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("morphology")) {
      res.setMorphology(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("locationQualifier")) {
      res.getLocationQualifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
      res.getImage().add(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBundleContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleContent(int eventType, XmlPullParser xpp, Bundle res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timestamp")) {
      res.setTimestampElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
      res.setTotalElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
      res.getLink().add(parseBundleLinkComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
      res.getEntry().add(parseBundleEntryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
      res.setSignature(parseSignature(xpp));
    } else if (!parseResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Bundle.BundleLinkComponent parseBundleLinkComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBundleLinkComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleLinkComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relation")) {
      res.setRelationElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Bundle.BundleEntryComponent parseBundleEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBundleEntryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleEntryComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
      res.getLink().add(parseBundleLinkComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fullUrl")) {
      res.setFullUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.setResource(parseResourceContained(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("search")) {
      res.setSearch(parseBundleEntrySearchComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.setRequest(parseBundleEntryRequestComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
      res.setResponse(parseBundleEntryResponseComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Bundle.BundleEntrySearchComponent parseBundleEntrySearchComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBundleEntrySearchComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleEntrySearchComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntrySearchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
      res.setScoreElement(parseDecimal(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Bundle.BundleEntryRequestComponent parseBundleEntryRequestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBundleEntryRequestComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleEntryRequestComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntryRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethodElement(parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifNoneMatch")) {
      res.setIfNoneMatchElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifModifiedSince")) {
      res.setIfModifiedSinceElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifMatch")) {
      res.setIfMatchElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifNoneExist")) {
      res.setIfNoneExistElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Bundle.BundleEntryResponseComponent parseBundleEntryResponseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseBundleEntryResponseComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleEntryResponseComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntryResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocationElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("etag")) {
      res.setEtagElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastModified")) {
      res.setLastModifiedElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcome(parseResourceContained(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement parseCapabilityStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementContent(int eventType, XmlPullParser xpp, CapabilityStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
      res.setKindElement(parseEnumeration(xpp, Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
      res.getInstantiates().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imports")) {
      res.getImports().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
      res.setSoftware(parseCapabilityStatementSoftwareComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementation")) {
      res.setImplementation(parseCapabilityStatementImplementationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
      res.setFhirVersionElement(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
      res.getFormat().add(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patchFormat")) {
      res.getPatchFormat().add(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementationGuide")) {
      res.getImplementationGuide().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rest")) {
      res.getRest().add(parseCapabilityStatementRestComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("messaging")) {
      res.getMessaging().add(parseCapabilityStatementMessagingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("document")) {
      res.getDocument().add(parseCapabilityStatementDocumentComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementSoftwareComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementSoftwareComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementSoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("releaseDate")) {
      res.setReleaseDateElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementImplementationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementImplementationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUrl(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
      res.setCustodian(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementRestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementRestComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementRestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("security")) {
      res.setSecurity(parseCapabilityStatementRestSecurityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.getResource().add(parseCapabilityStatementRestResourceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
      res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
      res.getSearchParam().add(parseCapabilityStatementRestResourceSearchParamComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
      res.getOperation().add(parseCapabilityStatementRestResourceOperationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
      res.getCompartment().add(parseCanonical(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementRestSecurityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementRestSecurityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementRestSecurityComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cors")) {
      res.setCorsElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
      res.getService().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementRestResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementRestResourceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementRestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportedProfile")) {
      res.getSupportedProfile().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
      res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versioning")) {
      res.setVersioningElement(parseEnumeration(xpp, CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readHistory")) {
      res.setReadHistoryElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("updateCreate")) {
      res.setUpdateCreateElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalCreate")) {
      res.setConditionalCreateElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalRead")) {
      res.setConditionalReadElement(parseEnumeration(xpp, CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalUpdate")) {
      res.setConditionalUpdateElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalDelete")) {
      res.setConditionalDeleteElement(parseEnumeration(xpp, CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencePolicy")) {
      res.getReferencePolicy().add(parseEnumeration(xpp, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchInclude")) {
      res.getSearchInclude().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchRevInclude")) {
      res.getSearchRevInclude().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
      res.getSearchParam().add(parseCapabilityStatementRestResourceSearchParamComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
      res.getOperation().add(parseCapabilityStatementRestResourceOperationComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementResourceInteractionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementRestResourceSearchParamComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementRestResourceSearchParamComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementRestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinitionElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementRestResourceOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementRestResourceOperationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementRestResourceOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinitionElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementSystemInteractionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementSystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementMessagingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementMessagingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementMessagingComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementMessagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.getEndpoint().add(parseCapabilityStatementMessagingEndpointComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reliableCache")) {
      res.setReliableCacheElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportedMessage")) {
      res.getSupportedMessage().add(parseCapabilityStatementMessagingSupportedMessageComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementMessagingEndpointComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementMessagingEndpointComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementMessagingEndpointComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
      res.setProtocol(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
      res.setAddressElement(parseUrl(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementMessagingSupportedMessageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementMessagingSupportedMessageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementMessagingSupportedMessageComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinitionElement(parseCanonical(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementDocumentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCapabilityStatementDocumentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementDocumentComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementDocumentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCarePlanContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanContent(int eventType, XmlPullParser xpp, CarePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
      res.getReplaces().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
      res.setIntentElement(parseEnumeration(xpp, CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
      res.getContributor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
      res.getCareTeam().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addresses")) {
      res.getAddresses().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
      res.getGoal().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activity")) {
      res.getActivity().add(parseCarePlanActivityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanActivityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCarePlanActivityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanActivityComponentContent(int eventType, XmlPullParser xpp, CarePlan.CarePlanActivityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeCodeableConcept")) {
      res.getOutcomeCodeableConcept().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeReference")) {
      res.getOutcomeReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("progress")) {
      res.getProgress().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.setDetail(parseCarePlanActivityDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanActivityDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCarePlanActivityDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanActivityDetailComponentContent(int eventType, XmlPullParser xpp, CarePlan.CarePlanActivityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
      res.setKindElement(parseEnumeration(xpp, CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
      res.getGoal().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
      res.setDoNotPerformElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "scheduled")) {
      res.setScheduled(parseType("scheduled", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
      res.setProduct(parseType("product", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dailyAmount")) {
      res.setDailyAmount(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCareTeamContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCareTeamContent(int eventType, XmlPullParser xpp, CareTeam res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
      res.getParticipant().add(parseCareTeamParticipantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
      res.getManagingOrganization().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
      res.getTelecom().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCareTeamParticipantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCareTeamParticipantComponentContent(int eventType, XmlPullParser xpp, CareTeam.CareTeamParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.getRole().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("member")) {
      res.setMember(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
      res.setOnBehalfOf(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CatalogEntry parseCatalogEntry(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CatalogEntry res = new CatalogEntry();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCatalogEntryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCatalogEntryContent(int eventType, XmlPullParser xpp, CatalogEntry res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderable")) {
      res.setOrderableElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencedItem")) {
      res.setReferencedItem(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalIdentifier")) {
      res.getAdditionalIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.getClassification().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validityPeriod")) {
      res.setValidityPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validTo")) {
      res.setValidToElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastUpdated")) {
      res.setLastUpdatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalCharacteristic")) {
      res.getAdditionalCharacteristic().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalClassification")) {
      res.getAdditionalClassification().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedEntry")) {
      res.getRelatedEntry().add(parseCatalogEntryRelatedEntryComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryRelatedEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCatalogEntryRelatedEntryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCatalogEntryRelatedEntryComponentContent(int eventType, XmlPullParser xpp, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationtype")) {
      res.setRelationtypeElement(parseEnumeration(xpp, CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.setItem(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ChargeItem parseChargeItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseChargeItemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemContent(int eventType, XmlPullParser xpp, ChargeItem res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definitionUri")) {
      res.getDefinitionUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definitionCanonical")) {
      res.getDefinitionCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
      res.setOccurrence(parseType("occurrence", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseChargeItemPerformerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performingOrganization")) {
      res.setPerformingOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestingOrganization")) {
      res.setRequestingOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("costCenter")) {
      res.setCostCenter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodysite")) {
      res.getBodysite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factorOverride")) {
      res.setFactorOverrideElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceOverride")) {
      res.setPriceOverride(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("overrideReason")) {
      res.setOverrideReasonElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
      res.setEnterer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enteredDate")) {
      res.setEnteredDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.getReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
      res.getService().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
      res.setProduct(parseType("product", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
      res.getAccount().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
      res.getSupportingInformation().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ChargeItem.ChargeItemPerformerComponent parseChargeItemPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseChargeItemPerformerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemPerformerComponentContent(int eventType, XmlPullParser xpp, ChargeItem.ChargeItemPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
      res.setFunction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ChargeItemDefinition parseChargeItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition res = new ChargeItemDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseChargeItemDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionContent(int eventType, XmlPullParser xpp, ChargeItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFromUri")) {
      res.getDerivedFromUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
      res.getReplaces().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
      res.setEffectivePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
      res.getInstance().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applicability")) {
      res.getApplicability().add(parseChargeItemDefinitionApplicabilityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("propertyGroup")) {
      res.getPropertyGroup().add(parseChargeItemDefinitionPropertyGroupComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionApplicabilityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseChargeItemDefinitionApplicabilityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionApplicabilityComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
      res.setExpressionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionPropertyGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseChargeItemDefinitionPropertyGroupComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionPropertyGroupComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applicability")) {
      res.getApplicability().add(parseChargeItemDefinitionApplicabilityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceComponent")) {
      res.getPriceComponent().add(parseChargeItemDefinitionPropertyGroupPriceComponentComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionPropertyGroupPriceComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseChargeItemDefinitionPropertyGroupPriceComponentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemDefinitionPropertyGroupPriceComponentComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.InvoicePriceComponentType.NULL, new Enumerations.InvoicePriceComponentTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation parseCitation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation res = new Citation();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationContent(int eventType, XmlPullParser xpp, Citation res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
      res.setEffectivePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
      res.getSummary().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.getClassification().add(parseCitationClassificationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("currentState")) {
      res.getCurrentState().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
      res.getStatusDate().add(parseCitationStatusDateComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
      res.getRelatesTo().add(parseCitationRelatesToComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("citedArtifact")) {
      res.setCitedArtifact(parseCitationCitedArtifactComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationClassificationComponent parseCitationClassificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationClassificationComponent res = new Citation.CitationClassificationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationClassificationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationClassificationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classifier")) {
      res.getClassifier().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationStatusDateComponent parseCitationStatusDateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationStatusDateComponent res = new Citation.CitationStatusDateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationStatusDateComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationStatusDateComponentContent(int eventType, XmlPullParser xpp, Citation.CitationStatusDateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activity")) {
      res.setActivity(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
      res.setActualElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationRelatesToComponent parseCitationRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationRelatesToComponent res = new Citation.CitationRelatesToComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationRelatesToComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationRelatesToComponentContent(int eventType, XmlPullParser xpp, Citation.CitationRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationshipType")) {
      res.setRelationshipType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetClassifier")) {
      res.getTargetClassifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
      res.setTarget(parseType("target", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactComponent parseCitationCitedArtifactComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactComponent res = new Citation.CitationCitedArtifactComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedIdentifier")) {
      res.getRelatedIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateAccessed")) {
      res.setDateAccessedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersion(parseCitationCitedArtifactVersionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("currentState")) {
      res.getCurrentState().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
      res.getStatusDate().add(parseCitationCitedArtifactStatusDateComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.getTitle().add(parseCitationCitedArtifactTitleComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("abstract")) {
      res.getAbstract().add(parseCitationCitedArtifactAbstractComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
      res.setPart(parseCitationCitedArtifactPartComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
      res.getRelatesTo().add(parseCitationCitedArtifactRelatesToComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationForm")) {
      res.getPublicationForm().add(parseCitationCitedArtifactPublicationFormComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("webLocation")) {
      res.getWebLocation().add(parseCitationCitedArtifactWebLocationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.getClassification().add(parseCitationCitedArtifactClassificationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributorship")) {
      res.setContributorship(parseCitationCitedArtifactContributorshipComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactVersionComponent parseCitationCitedArtifactVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactVersionComponent res = new Citation.CitationCitedArtifactVersionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactVersionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactVersionComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseCitation")) {
      res.setBaseCitation(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactStatusDateComponent parseCitationCitedArtifactStatusDateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactStatusDateComponent res = new Citation.CitationCitedArtifactStatusDateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactStatusDateComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactStatusDateComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactStatusDateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activity")) {
      res.setActivity(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
      res.setActualElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactTitleComponent parseCitationCitedArtifactTitleComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactTitleComponent res = new Citation.CitationCitedArtifactTitleComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactTitleComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactTitleComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactTitleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguage(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactAbstractComponent parseCitationCitedArtifactAbstractComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactAbstractComponent res = new Citation.CitationCitedArtifactAbstractComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactAbstractComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactAbstractComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactAbstractComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguage(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactPartComponent parseCitationCitedArtifactPartComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPartComponent res = new Citation.CitationCitedArtifactPartComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactPartComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactPartComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseCitation")) {
      res.setBaseCitation(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactRelatesToComponent parseCitationCitedArtifactRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactRelatesToComponent res = new Citation.CitationCitedArtifactRelatesToComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactRelatesToComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactRelatesToComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationshipType")) {
      res.setRelationshipType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetClassifier")) {
      res.getTargetClassifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
      res.setTarget(parseType("target", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactPublicationFormComponent parseCitationCitedArtifactPublicationFormComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPublicationFormComponent res = new Citation.CitationCitedArtifactPublicationFormComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactPublicationFormComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactPublicationFormComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPublicationFormComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publishedIn")) {
      res.setPublishedIn(parseCitationCitedArtifactPublicationFormPublishedInComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodicRelease")) {
      res.setPeriodicRelease(parseCitationCitedArtifactPublicationFormPeriodicReleaseComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("articleDate")) {
      res.setArticleDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastRevisionDate")) {
      res.setLastRevisionDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.getLanguage().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accessionNumber")) {
      res.setAccessionNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pageString")) {
      res.setPageStringElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("firstPage")) {
      res.setFirstPageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastPage")) {
      res.setLastPageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pageCount")) {
      res.setPageCountElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactPublicationFormPublishedInComponent parseCitationCitedArtifactPublicationFormPublishedInComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPublicationFormPublishedInComponent res = new Citation.CitationCitedArtifactPublicationFormPublishedInComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactPublicationFormPublishedInComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactPublicationFormPublishedInComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPublicationFormPublishedInComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisher(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisherLocation")) {
      res.setPublisherLocationElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactPublicationFormPeriodicReleaseComponent parseCitationCitedArtifactPublicationFormPeriodicReleaseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPublicationFormPeriodicReleaseComponent res = new Citation.CitationCitedArtifactPublicationFormPeriodicReleaseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactPublicationFormPeriodicReleaseComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactPublicationFormPeriodicReleaseComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPublicationFormPeriodicReleaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("citedMedium")) {
      res.setCitedMedium(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("volume")) {
      res.setVolumeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issue")) {
      res.setIssueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateOfPublication")) {
      res.setDateOfPublication(parseCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent parseCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent res = new Citation.CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("year")) {
      res.setYearElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("month")) {
      res.setMonthElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("day")) {
      res.setDayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("season")) {
      res.setSeasonElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactWebLocationComponent parseCitationCitedArtifactWebLocationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactWebLocationComponent res = new Citation.CitationCitedArtifactWebLocationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactWebLocationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactWebLocationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactWebLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactClassificationComponent parseCitationCitedArtifactClassificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactClassificationComponent res = new Citation.CitationCitedArtifactClassificationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactClassificationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactClassificationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classifier")) {
      res.getClassifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whoClassified")) {
      res.setWhoClassified(parseCitationCitedArtifactClassificationWhoClassifiedComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactClassificationWhoClassifiedComponent parseCitationCitedArtifactClassificationWhoClassifiedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactClassificationWhoClassifiedComponent res = new Citation.CitationCitedArtifactClassificationWhoClassifiedComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactClassificationWhoClassifiedComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactClassificationWhoClassifiedComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactClassificationWhoClassifiedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("person")) {
      res.setPerson(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
      res.setOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisher(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classifierCopyright")) {
      res.setClassifierCopyrightElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("freeToShare")) {
      res.setFreeToShareElement(parseBoolean(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactContributorshipComponent parseCitationCitedArtifactContributorshipComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipComponent res = new Citation.CitationCitedArtifactContributorshipComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactContributorshipComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactContributorshipComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("complete")) {
      res.setCompleteElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
      res.getEntry().add(parseCitationCitedArtifactContributorshipEntryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
      res.getSummary().add(parseCitationCitedArtifactContributorshipSummaryComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactContributorshipEntryComponent parseCitationCitedArtifactContributorshipEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipEntryComponent res = new Citation.CitationCitedArtifactContributorshipEntryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactContributorshipEntryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactContributorshipEntryComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setName(parseHumanName(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initials")) {
      res.setInitialsElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collectiveName")) {
      res.setCollectiveNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("affiliationInfo")) {
      res.getAffiliationInfo().add(parseCitationCitedArtifactContributorshipEntryAffiliationInfoComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
      res.getAddress().add(parseAddress(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
      res.getTelecom().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributionType")) {
      res.getContributionType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributionInstance")) {
      res.getContributionInstance().add(parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("correspondingContact")) {
      res.setCorrespondingContactElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("listOrder")) {
      res.setListOrderElement(parsePositiveInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactContributorshipEntryAffiliationInfoComponent parseCitationCitedArtifactContributorshipEntryAffiliationInfoComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipEntryAffiliationInfoComponent res = new Citation.CitationCitedArtifactContributorshipEntryAffiliationInfoComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactContributorshipEntryAffiliationInfoComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactContributorshipEntryAffiliationInfoComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipEntryAffiliationInfoComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("affiliation")) {
      res.setAffiliationElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRoleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res = new Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
      res.setTimeElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Citation.CitationCitedArtifactContributorshipSummaryComponent parseCitationCitedArtifactContributorshipSummaryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipSummaryComponent res = new Citation.CitationCitedArtifactContributorshipSummaryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCitationCitedArtifactContributorshipSummaryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCitationCitedArtifactContributorshipSummaryComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipSummaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("style")) {
      res.setStyle(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim res = new Claim();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimContent(int eventType, XmlPullParser xpp, Claim res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
      res.setSubType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billablePeriod")) {
      res.setBillablePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
      res.setEnterer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
      res.setInsurer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriority(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
      res.setFundsReserve(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
      res.getRelated().add(parseClaimRelatedClaimComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prescription")) {
      res.setPrescription(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("originalPrescription")) {
      res.setOriginalPrescription(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
      res.setPayee(parseClaimPayeeComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referral")) {
      res.setReferral(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
      res.setFacility(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
      res.getCareTeam().add(parseClaimCareTeamComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseClaimSupportingInformationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
      res.getDiagnosis().add(parseClaimDiagnosisComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
      res.getProcedure().add(parseClaimProcedureComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseClaimInsuranceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accident")) {
      res.setAccident(parseClaimAccidentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseClaimItemComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
      res.setTotal(parseMoney(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimRelatedClaimComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimRelatedClaimComponentContent(int eventType, XmlPullParser xpp, Claim.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
      res.setClaim(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
      res.setRelationship(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseIdentifier(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimPayeeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimPayeeComponentContent(int eventType, XmlPullParser xpp, Claim.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
      res.setParty(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimCareTeamComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimCareTeamComponentContent(int eventType, XmlPullParser xpp, Claim.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
      res.setResponsibleElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
      res.setQualification(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimSupportingInformationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimSupportingInformationComponentContent(int eventType, XmlPullParser xpp, Claim.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
      res.setTiming(parseType("timing", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.setReason(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimDiagnosisComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimDiagnosisComponentContent(int eventType, XmlPullParser xpp, Claim.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
      res.setDiagnosis(parseType("diagnosis", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onAdmission")) {
      res.setOnAdmission(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageCode")) {
      res.setPackageCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimProcedureComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimProcedureComponentContent(int eventType, XmlPullParser xpp, Claim.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "procedure")) {
      res.setProcedure(parseType("procedure", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimInsuranceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimInsuranceComponentContent(int eventType, XmlPullParser xpp, Claim.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
      res.setFocalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
      res.setBusinessArrangementElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
      res.getPreAuthRef().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
      res.setClaimResponse(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimAccidentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimAccidentComponentContent(int eventType, XmlPullParser xpp, Claim.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
      res.setLocation(parseType("location", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.ItemComponent parseClaimItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimItemComponentContent(int eventType, XmlPullParser xpp, Claim.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeamSequence")) {
      res.getCareTeamSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosisSequence")) {
      res.getDiagnosisSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureSequence")) {
      res.getProcedureSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSequence")) {
      res.getInformationSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
      res.setRevenue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
      res.setServiced(parseType("serviced", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
      res.setLocation(parseType("location", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
      res.getSubSite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.getEncounter().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseClaimDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimDetailComponentContent(int eventType, XmlPullParser xpp, Claim.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
      res.setRevenue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
      res.getSubDetail().add(parseClaimSubDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimSubDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimSubDetailComponentContent(int eventType, XmlPullParser xpp, Claim.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
      res.setRevenue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseContent(int eventType, XmlPullParser xpp, ClaimResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
      res.setSubType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
      res.setInsurer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
      res.setRequestor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.setRequest(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
      res.setDispositionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
      res.setPreAuthRefElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthPeriod")) {
      res.setPreAuthPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payeeType")) {
      res.setPayeeType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseClaimResponseItemComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addItem")) {
      res.getAddItem().add(parseClaimResponseAddedItemComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
      res.getTotal().add(parseClaimResponseTotalComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
      res.setPayment(parseClaimResponsePaymentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
      res.setFundsReserve(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("formCode")) {
      res.setFormCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
      res.setForm(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
      res.getProcessNote().add(parseClaimResponseNoteComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communicationRequest")) {
      res.getCommunicationRequest().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseClaimResponseInsuranceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
      res.getError().add(parseClaimResponseErrorComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
      res.setItemSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseClaimResponseItemDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseAdjudicationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAdjudicationComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.setReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseDecimal(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseItemDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.ItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
      res.setDetailSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
      res.getSubDetail().add(parseClaimResponseSubDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseSubDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetailSequence")) {
      res.setSubDetailSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseAddedItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
      res.getItemSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
      res.getDetailSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subdetailSequence")) {
      res.getSubdetailSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.getProvider().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
      res.setServiced(parseType("serviced", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
      res.setLocation(parseType("location", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
      res.getSubSite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseClaimResponseAddedItemDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseAddedItemDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
      res.getSubDetail().add(parseClaimResponseAddedItemSubDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseAddedItemSubDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AddedItemSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseTotalComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseTotalComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponsePaymentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponsePaymentComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustment")) {
      res.setAdjustment(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustmentReason")) {
      res.setAdjustmentReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseNoteComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseNoteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
      res.setNumberElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguage(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseInsuranceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
      res.setFocalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
      res.setBusinessArrangementElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
      res.setClaimResponse(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClaimResponseErrorComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseErrorComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.ErrorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
      res.setItemSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
      res.setDetailSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetailSequence")) {
      res.setSubDetailSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalImpressionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionContent(int eventType, XmlPullParser xpp, ClinicalImpression res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
      res.setEffective(parseType("effective", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessor")) {
      res.setAssessor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("previous")) {
      res.setPrevious(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("problem")) {
      res.getProblem().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("investigation")) {
      res.getInvestigation().add(parseClinicalImpressionInvestigationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
      res.getProtocol().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
      res.setSummaryElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("finding")) {
      res.getFinding().add(parseClinicalImpressionFindingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prognosisCodeableConcept")) {
      res.getPrognosisCodeableConcept().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prognosisReference")) {
      res.getPrognosisReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionInvestigationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalImpressionInvestigationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionInvestigationComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionFindingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalImpressionFindingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionFindingComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression.ClinicalImpressionFindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemCodeableConcept")) {
      res.setItemCodeableConcept(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemReference")) {
      res.setItemReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basis")) {
      res.setBasisElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition parseClinicalUseDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition res = new ClinicalUseDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, ClinicalUseDefinition.ClinicalUseIssueType.NULL, new ClinicalUseDefinition.ClinicalUseIssueTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.getSubject().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contraindication")) {
      res.setContraindication(parseClinicalUseDefinitionContraindicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
      res.setIndication(parseClinicalUseDefinitionIndicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
      res.setInteraction(parseClinicalUseDefinitionInteractionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
      res.getPopulation().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("undesirableEffect")) {
      res.setUndesirableEffect(parseClinicalUseDefinitionUndesirableEffectComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("warning")) {
      res.setWarning(parseClinicalUseDefinitionWarningComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent parseClinicalUseDefinitionContraindicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionContraindicationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionContraindicationComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseSymptomProcedure")) {
      res.setDiseaseSymptomProcedure(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseStatus")) {
      res.setDiseaseStatus(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comorbidity")) {
      res.getComorbidity().add(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
      res.getIndication().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("otherTherapy")) {
      res.getOtherTherapy().add(parseClinicalUseDefinitionContraindicationOtherTherapyComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent parseClinicalUseDefinitionContraindicationOtherTherapyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionContraindicationOtherTherapyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionContraindicationOtherTherapyComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationshipType")) {
      res.setRelationshipType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("therapy")) {
      res.setTherapy(parseCodeableReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent parseClinicalUseDefinitionIndicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionIndicationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionIndicationComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseSymptomProcedure")) {
      res.setDiseaseSymptomProcedure(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diseaseStatus")) {
      res.setDiseaseStatus(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comorbidity")) {
      res.getComorbidity().add(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedEffect")) {
      res.setIntendedEffect(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
      res.setDuration(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("undesirableEffect")) {
      res.getUndesirableEffect().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("otherTherapy")) {
      res.getOtherTherapy().add(parseClinicalUseDefinitionContraindicationOtherTherapyComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent parseClinicalUseDefinitionInteractionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionInteractionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionInteractionComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interactant")) {
      res.getInteractant().add(parseClinicalUseDefinitionInteractionInteractantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effect")) {
      res.setEffect(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("incidence")) {
      res.setIncidence(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("management")) {
      res.getManagement().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent parseClinicalUseDefinitionInteractionInteractantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionInteractionInteractantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionInteractionInteractantComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
      res.setItem(parseType("item", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent parseClinicalUseDefinitionUndesirableEffectComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionUndesirableEffectComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionUndesirableEffectComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("symptomConditionEffect")) {
      res.setSymptomConditionEffect(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.setClassification(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequencyOfOccurrence")) {
      res.setFrequencyOfOccurrence(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent parseClinicalUseDefinitionWarningComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseClinicalUseDefinitionWarningComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalUseDefinitionWarningComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeSystemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemContent(int eventType, XmlPullParser xpp, CodeSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("caseSensitive")) {
      res.setCaseSensitiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
      res.setValueSetElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hierarchyMeaning")) {
      res.setHierarchyMeaningElement(parseEnumeration(xpp, CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compositional")) {
      res.setCompositionalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionNeeded")) {
      res.setVersionNeededElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
      res.setContentElement(parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplements")) {
      res.setSupplementsElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
      res.setCountElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("filter")) {
      res.getFilter().add(parseCodeSystemFilterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.getProperty().add(parseCodeSystemPropertyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
      res.getConcept().add(parseCodeSystemConceptDefinitionComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeSystemFilterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemFilterComponentContent(int eventType, XmlPullParser xpp, CodeSystem.CodeSystemFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operator")) {
      res.getOperator().add(parseEnumeration(xpp, Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeSystemPropertyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem.PropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
      res.setUriElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeSystemConceptDefinitionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptDefinitionComponentContent(int eventType, XmlPullParser xpp, CodeSystem.ConceptDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinitionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("designation")) {
      res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.getProperty().add(parseCodeSystemConceptPropertyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
      res.getConcept().add(parseCodeSystemConceptDefinitionComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeSystemConceptDefinitionDesignationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptDefinitionDesignationComponentContent(int eventType, XmlPullParser xpp, CodeSystem.ConceptDefinitionDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguageElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUse(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCodeSystemConceptPropertyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem.ConceptPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Communication res = new Communication();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCommunicationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationContent(int eventType, XmlPullParser xpp, Communication res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inResponseTo")) {
      res.getInResponseTo().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medium")) {
      res.getMedium().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
      res.setTopic(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("about")) {
      res.getAbout().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sent")) {
      res.setSentElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("received")) {
      res.setReceivedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
      res.getRecipient().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
      res.setSender(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
      res.getPayload().add(parseCommunicationPayloadComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationPayloadComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCommunicationPayloadComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationPayloadComponentContent(int eventType, XmlPullParser xpp, Communication.CommunicationPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
      res.setContent(parseType("content", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCommunicationRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestContent(int eventType, XmlPullParser xpp, CommunicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
      res.getReplaces().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
      res.setGroupIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
      res.setDoNotPerformElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medium")) {
      res.getMedium().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("about")) {
      res.getAbout().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
      res.getPayload().add(parseCommunicationRequestPayloadComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
      res.setOccurrence(parseType("occurrence", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
      res.setAuthoredOnElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
      res.setRequester(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
      res.getRecipient().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
      res.setSender(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestPayloadComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCommunicationRequestPayloadComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestPayloadComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest.CommunicationRequestPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
      res.setContent(parseType("content", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompartmentDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompartmentDefinitionContent(int eventType, XmlPullParser xpp, CompartmentDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("search")) {
      res.setSearchElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.getResource().add(parseCompartmentDefinitionResourceComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompartmentDefinitionResourceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompartmentDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("param")) {
      res.getParam().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition res = new Composition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompositionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionContent(int eventType, XmlPullParser xpp, Composition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("confidentiality")) {
      res.setConfidentialityElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attester")) {
      res.getAttester().add(parseCompositionAttesterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
      res.setCustodian(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
      res.getRelatesTo().add(parseCompositionRelatesToComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
      res.getEvent().add(parseCompositionEventComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
      res.getSection().add(parseCompositionSectionComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Composition.CompositionAttesterComponent parseCompositionAttesterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompositionAttesterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionAttesterComponentContent(int eventType, XmlPullParser xpp, Composition.CompositionAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
      res.setTimeElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
      res.setParty(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Composition.CompositionRelatesToComponent parseCompositionRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompositionRelatesToComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionRelatesToComponentContent(int eventType, XmlPullParser xpp, Composition.CompositionRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, Enumerations.DocumentRelationshipType.NULL, new Enumerations.DocumentRelationshipTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
      res.setTarget(parseType("target", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Composition.CompositionEventComponent parseCompositionEventComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompositionEventComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionEventComponentContent(int eventType, XmlPullParser xpp, Composition.CompositionEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCompositionSectionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionSectionComponentContent(int eventType, XmlPullParser xpp, Composition.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
      res.setFocus(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setText(parseNarrative(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
      res.setOrderedBy(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
      res.getEntry().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
      res.setEmptyReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
      res.getSection().add(parseCompositionSectionComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConceptMapContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapContent(int eventType, XmlPullParser xpp, ConceptMap res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.addIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "source")) {
      res.setSource(parseType("source", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
      res.setTarget(parseType("target", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
      res.getGroup().add(parseConceptMapGroupComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConceptMapGroupComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapGroupComponentContent(int eventType, XmlPullParser xpp, ConceptMap.ConceptMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceVersion")) {
      res.setSourceVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
      res.setTargetElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetVersion")) {
      res.setTargetVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
      res.getElement().add(parseConceptMapSourceElementComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unmapped")) {
      res.setUnmapped(parseConceptMapGroupUnmappedComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConceptMapSourceElementComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapSourceElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap.SourceElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
      res.getTarget().add(parseConceptMapTargetElementComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConceptMapTargetElementComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapTargetElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap.TargetElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("equivalence")) {
      res.setEquivalenceElement(parseEnumeration(xpp, ConceptMap.ConceptMapEquivalence.NULL, new ConceptMap.ConceptMapEquivalenceEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependsOn")) {
      res.getDependsOn().add(parseConceptMapOtherElementComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("product")) {
      res.getProduct().add(parseConceptMapOtherElementComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConceptMapOtherElementComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapOtherElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap.OtherElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.setPropertyElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
      res.setSystemElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapGroupUnmappedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConceptMapGroupUnmappedComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapGroupUnmappedComponentContent(int eventType, XmlPullParser xpp, ConceptMap.ConceptMapGroupUnmappedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
      res.setDisplayElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseCanonical(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition res = new Condition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConditionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionContent(int eventType, XmlPullParser xpp, Condition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalStatus")) {
      res.setClinicalStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationStatus")) {
      res.setVerificationStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
      res.setSeverity(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.getBodySite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
      res.setOnset(parseType("onset", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "abatement")) {
      res.setAbatement(parseType("abatement", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedDate")) {
      res.setRecordedDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
      res.setRecorder(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asserter")) {
      res.setAsserter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stage")) {
      res.getStage().add(parseConditionStageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evidence")) {
      res.getEvidence().add(parseConditionEvidenceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Condition.ConditionStageComponent parseConditionStageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConditionStageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionStageComponentContent(int eventType, XmlPullParser xpp, Condition.ConditionStageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
      res.setSummary(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessment")) {
      res.getAssessment().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Condition.ConditionEvidenceComponent parseConditionEvidenceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConditionEvidenceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionEvidenceComponentContent(int eventType, XmlPullParser xpp, Condition.ConditionEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Consent parseConsent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent res = new Consent();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConsentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentContent(int eventType, XmlPullParser xpp, Consent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
      res.setScope(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateTime")) {
      res.setDateTimeElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
      res.getOrganization().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "source")) {
      res.setSource(parseType("source", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
      res.getPolicy().add(parseConsentPolicyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policyRule")) {
      res.setPolicyRule(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verification")) {
      res.getVerification().add(parseConsentVerificationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provision")) {
      res.setProvision(parseConsentProvisionComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Consent.ConsentPolicyComponent parseConsentPolicyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConsentPolicyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentPolicyComponentContent(int eventType, XmlPullParser xpp, Consent.ConsentPolicyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
      res.setAuthorityElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
      res.setUriElement(parseUri(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Consent.ConsentVerificationComponent parseConsentVerificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConsentVerificationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentVerificationComponentContent(int eventType, XmlPullParser xpp, Consent.ConsentVerificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verified")) {
      res.setVerifiedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verifiedWith")) {
      res.setVerifiedWith(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationDate")) {
      res.setVerificationDateElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Consent.ProvisionComponent parseConsentProvisionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ProvisionComponent res = new Consent.ProvisionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConsentProvisionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentProvisionComponentContent(int eventType, XmlPullParser xpp, Consent.ProvisionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.getActor().add(parseConsentProvisionActorComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
      res.getAction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
      res.getSecurityLabel().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.getPurpose().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
      res.getClass_().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataPeriod")) {
      res.setDataPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
      res.getData().add(parseConsentProvisionDataComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provision")) {
      res.getProvision().add(parseConsentProvisionComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Consent.ProvisionActorComponent parseConsentProvisionActorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ProvisionActorComponent res = new Consent.ProvisionActorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConsentProvisionActorComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentProvisionActorComponentContent(int eventType, XmlPullParser xpp, Consent.ProvisionActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Consent.ProvisionDataComponent parseConsentProvisionDataComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ProvisionDataComponent res = new Consent.ProvisionDataComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseConsentProvisionDataComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentProvisionDataComponentContent(int eventType, XmlPullParser xpp, Consent.ProvisionDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaning")) {
      res.setMeaningElement(parseEnumeration(xpp, Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract res = new Contract();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContent(int eventType, XmlPullParser xpp, Contract res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Contract.ContractResourceStatusCodes.NULL, new Contract.ContractResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legalState")) {
      res.setLegalState(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.setInstantiatesCanonical(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.setInstantiatesUriElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentDerivative")) {
      res.setContentDerivative(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
      res.setIssuedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applies")) {
      res.setApplies(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationType")) {
      res.setExpirationType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.getSubject().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
      res.getAuthority().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("domain")) {
      res.getDomain().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
      res.getSite().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
      res.setSubtitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
      res.getAlias().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
      res.setScope(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "topic")) {
      res.setTopic(parseType("topic", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
      res.getSubType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentDefinition")) {
      res.setContentDefinition(parseContractContentDefinitionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
      res.getTerm().add(parseContractTermComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
      res.getRelevantHistory().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signer")) {
      res.getSigner().add(parseContractSignatoryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("friendly")) {
      res.getFriendly().add(parseContractFriendlyLanguageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legal")) {
      res.getLegal().add(parseContractLegalLanguageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
      res.getRule().add(parseContractComputableLanguageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "legallyBinding")) {
      res.setLegallyBinding(parseType("legallyBinding", xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractContentDefinitionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContentDefinitionComponentContent(int eventType, XmlPullParser xpp, Contract.ContentDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
      res.setSubType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisher(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationDate")) {
      res.setPublicationDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationStatus")) {
      res.setPublicationStatusElement(parseEnumeration(xpp, Contract.ContractResourcePublicationStatusCodes.NULL, new Contract.ContractResourcePublicationStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractTermComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractTermComponentContent(int eventType, XmlPullParser xpp, Contract.TermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
      res.setIssuedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applies")) {
      res.setApplies(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "topic")) {
      res.setTopic(parseType("topic", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
      res.setSubType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
      res.getSecurityLabel().add(parseContractSecurityLabelComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("offer")) {
      res.setOffer(parseContractOfferComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asset")) {
      res.getAsset().add(parseContractAssetComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
      res.getAction().add(parseContractActionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
      res.getGroup().add(parseContractTermComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractSecurityLabelComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractSecurityLabelComponentContent(int eventType, XmlPullParser xpp, Contract.SecurityLabelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
      res.getNumber().add(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.setClassification(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("control")) {
      res.getControl().add(parseCoding(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ContractOfferComponent parseContractOfferComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractOfferComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractOfferComponentContent(int eventType, XmlPullParser xpp, Contract.ContractOfferComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
      res.getParty().add(parseContractPartyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
      res.setTopic(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("decision")) {
      res.setDecision(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("decisionMode")) {
      res.getDecisionMode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("answer")) {
      res.getAnswer().add(parseContractAnswerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
      res.getLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
      res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ContractPartyComponent parseContractPartyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractPartyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractPartyComponentContent(int eventType, XmlPullParser xpp, Contract.ContractPartyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.getReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.AnswerComponent parseContractAnswerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.AnswerComponent res = new Contract.AnswerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractAnswerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAnswerComponentContent(int eventType, XmlPullParser xpp, Contract.AnswerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ContractAssetComponent parseContractAssetComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractAssetComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAssetComponentContent(int eventType, XmlPullParser xpp, Contract.ContractAssetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
      res.setScope(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("typeReference")) {
      res.getTypeReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtype")) {
      res.getSubtype().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
      res.setRelationship(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.getContext().add(parseContractAssetContextComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.setConditionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodType")) {
      res.getPeriodType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.getPeriod().add(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usePeriod")) {
      res.getUsePeriod().add(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
      res.getLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("answer")) {
      res.getAnswer().add(parseContractAnswerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
      res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valuedItem")) {
      res.getValuedItem().add(parseContractValuedItemComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.AssetContextComponent parseContractAssetContextComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.AssetContextComponent res = new Contract.AssetContextComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractAssetContextComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAssetContextComponentContent(int eventType, XmlPullParser xpp, Contract.AssetContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractValuedItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract.ValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "entity")) {
      res.setEntity(parseType("entity", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectiveTime")) {
      res.setEffectiveTimeElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("points")) {
      res.setPointsElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
      res.setPaymentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("paymentDate")) {
      res.setPaymentDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
      res.setResponsible(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
      res.setRecipient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
      res.getLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
      res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ActionComponent parseContractActionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ActionComponent res = new Contract.ActionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractActionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractActionComponentContent(int eventType, XmlPullParser xpp, Contract.ActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
      res.setDoNotPerformElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.getSubject().add(parseContractActionSubjectComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
      res.setIntent(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
      res.getLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contextLinkId")) {
      res.getContextLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
      res.setOccurrence(parseType("occurrence", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
      res.getRequester().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requesterLinkId")) {
      res.getRequesterLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
      res.getPerformerType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerRole")) {
      res.setPerformerRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.setPerformer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerLinkId")) {
      res.getPerformerLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.getReason().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonLinkId")) {
      res.getReasonLinkId().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabelNumber")) {
      res.getSecurityLabelNumber().add(parseUnsignedInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractActionSubjectComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractActionSubjectComponentContent(int eventType, XmlPullParser xpp, Contract.ActionSubjectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.getReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractSignatoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractSignatoryComponentContent(int eventType, XmlPullParser xpp, Contract.SignatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
      res.setParty(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
      res.getSignature().add(parseSignature(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractFriendlyLanguageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractFriendlyLanguageComponentContent(int eventType, XmlPullParser xpp, Contract.FriendlyLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
      res.setContent(parseType("content", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractLegalLanguageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractLegalLanguageComponentContent(int eventType, XmlPullParser xpp, Contract.LegalLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
      res.setContent(parseType("content", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseContractComputableLanguageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractComputableLanguageComponentContent(int eventType, XmlPullParser xpp, Contract.ComputableLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
      res.setContent(parseType("content", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageContent(int eventType, XmlPullParser xpp, Coverage res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policyHolder")) {
      res.setPolicyHolder(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subscriber")) {
      res.setSubscriber(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subscriberId")) {
      res.setSubscriberIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("beneficiary")) {
      res.setBeneficiary(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependent")) {
      res.setDependentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
      res.setRelationship(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payor")) {
      res.getPayor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
      res.getClass_().add(parseCoverageClassComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("order")) {
      res.setOrderElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.setNetworkElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("costToBeneficiary")) {
      res.getCostToBeneficiary().add(parseCoverageCostToBeneficiaryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subrogation")) {
      res.setSubrogationElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contract")) {
      res.getContract().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Coverage.ClassComponent parseCoverageClassComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.ClassComponent res = new Coverage.ClassComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageClassComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageClassComponentContent(int eventType, XmlPullParser xpp, Coverage.ClassComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageCostToBeneficiaryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageCostToBeneficiaryComponentContent(int eventType, XmlPullParser xpp, Coverage.CostToBeneficiaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exception")) {
      res.getException().add(parseCoverageExemptionComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Coverage.ExemptionComponent parseCoverageExemptionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageExemptionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageExemptionComponentContent(int eventType, XmlPullParser xpp, Coverage.ExemptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityRequest parseCoverageEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest res = new CoverageEligibilityRequest();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriority(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.getPurpose().add(parseEnumeration(xpp, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
      res.setServiced(parseType("serviced", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
      res.setEnterer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
      res.setInsurer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
      res.setFacility(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseCoverageEligibilityRequestSupportingInformationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseCoverageEligibilityRequestInsuranceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseCoverageEligibilityRequestDetailsComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityRequestSupportingInformationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestSupportingInformationComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("information")) {
      res.setInformation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appliesToAll")) {
      res.setAppliesToAllElement(parseBoolean(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityRequestInsuranceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
      res.setFocalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
      res.setBusinessArrangementElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityRequestDetailsComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestDetailsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.DetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfoSequence")) {
      res.getSupportingInfoSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
      res.setFacility(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
      res.getDiagnosis().add(parseCoverageEligibilityRequestDiagnosisComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityRequestDiagnosisComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityRequestDiagnosisComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
      res.setDiagnosis(parseType("diagnosis", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityResponse parseCoverageEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse res = new CoverageEligibilityResponse();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.getPurpose().add(parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
      res.setServiced(parseType("serviced", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
      res.setRequestor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.setRequest(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
      res.setDispositionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
      res.setInsurer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseCoverageEligibilityResponseInsuranceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
      res.setPreAuthRefElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
      res.setForm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
      res.getError().add(parseCoverageEligibilityResponseErrorsComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityResponseInsuranceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inforce")) {
      res.setInforceElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitPeriod")) {
      res.setBenefitPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseCoverageEligibilityResponseItemsComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityResponseItemsComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseItemsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.ItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excluded")) {
      res.setExcludedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.setNetwork(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
      res.setUnit(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
      res.setTerm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefit")) {
      res.getBenefit().add(parseCoverageEligibilityResponseBenefitComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizationRequired")) {
      res.setAuthorizationRequiredElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizationSupporting")) {
      res.getAuthorizationSupporting().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizationUrl")) {
      res.setAuthorizationUrlElement(parseUri(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityResponseBenefitComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseBenefitComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
      res.setAllowed(parseType("allowed", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "used")) {
      res.setUsed(parseType("used", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseCoverageEligibilityResponseErrorsComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageEligibilityResponseErrorsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.ErrorsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDetectedIssueContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueContent(int eventType, XmlPullParser xpp, DetectedIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.ObservationStatus.NULL, new Enumerations.ObservationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
      res.setSeverityElement(parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "identified")) {
      res.setIdentified(parseType("identified", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implicated")) {
      res.getImplicated().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evidence")) {
      res.getEvidence().add(parseDetectedIssueEvidenceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.setDetailElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReferenceElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mitigation")) {
      res.getMitigation().add(parseDetectedIssueMitigationComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueEvidenceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDetectedIssueEvidenceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueEvidenceComponentContent(int eventType, XmlPullParser xpp, DetectedIssue.DetectedIssueEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueMitigationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDetectedIssueMitigationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueMitigationComponentContent(int eventType, XmlPullParser xpp, DetectedIssue.DetectedIssueMitigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
      res.setAction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device res = new Device();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceContent(int eventType, XmlPullParser xpp, Device res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinition(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udiCarrier")) {
      res.getUdiCarrier().add(parseDeviceUdiCarrierComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.getStatusReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("distinctIdentifier")) {
      res.setDistinctIdentifierElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.setManufacturerElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufactureDate")) {
      res.setManufactureDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
      res.setExpirationDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
      res.setLotNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serialNumber")) {
      res.setSerialNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceName")) {
      res.getDeviceName().add(parseDeviceDeviceNameComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modelNumber")) {
      res.setModelNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partNumber")) {
      res.setPartNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialization")) {
      res.getSpecialization().add(parseDeviceSpecializationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.getVersion().add(parseDeviceVersionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.getProperty().add(parseDevicePropertyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
      res.setOwner(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("safety")) {
      res.getSafety().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
      res.setParent(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Device.DeviceUdiCarrierComponent parseDeviceUdiCarrierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceUdiCarrierComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceUdiCarrierComponentContent(int eventType, XmlPullParser xpp, Device.DeviceUdiCarrierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceIdentifier")) {
      res.setDeviceIdentifierElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
      res.setIssuerElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.setJurisdictionElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("carrierAIDC")) {
      res.setCarrierAIDCElement(parseBase64Binary(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("carrierHRF")) {
      res.setCarrierHRFElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entryType")) {
      res.setEntryTypeElement(parseEnumeration(xpp, Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Device.DeviceDeviceNameComponent parseDeviceDeviceNameComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDeviceNameComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDeviceNameComponentContent(int eventType, XmlPullParser xpp, Device.DeviceDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Device.DeviceSpecializationComponent parseDeviceSpecializationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceSpecializationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceSpecializationComponentContent(int eventType, XmlPullParser xpp, Device.DeviceSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("systemType")) {
      res.setSystemType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Device.DeviceVersionComponent parseDeviceVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceVersionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceVersionComponentContent(int eventType, XmlPullParser xpp, Device.DeviceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
      res.setComponent(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Device.DevicePropertyComponent parseDevicePropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDevicePropertyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDevicePropertyComponentContent(int eventType, XmlPullParser xpp, Device.DevicePropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueQuantity")) {
      res.getValueQuantity().add(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueCode")) {
      res.getValueCode().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition parseDeviceDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition res = new DeviceDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionContent(int eventType, XmlPullParser xpp, DeviceDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udiDeviceIdentifier")) {
      res.getUdiDeviceIdentifier().add(parseDeviceDefinitionUdiDeviceIdentifierComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "manufacturer")) {
      res.setManufacturer(parseType("manufacturer", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceName")) {
      res.getDeviceName().add(parseDeviceDefinitionDeviceNameComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modelNumber")) {
      res.setModelNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialization")) {
      res.getSpecialization().add(parseDeviceDefinitionSpecializationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.getVersion().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("safety")) {
      res.getSafety().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("shelfLifeStorage")) {
      res.getShelfLifeStorage().add(parseProductShelfLife(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalCharacteristics")) {
      res.setPhysicalCharacteristics(parseProdCharacteristic(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("languageCode")) {
      res.getLanguageCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("capability")) {
      res.getCapability().add(parseDeviceDefinitionCapabilityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.getProperty().add(parseDeviceDefinitionPropertyComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
      res.setOwner(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onlineInformation")) {
      res.setOnlineInformationElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parentDevice")) {
      res.setParentDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("material")) {
      res.getMaterial().add(parseDeviceDefinitionMaterialComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionUdiDeviceIdentifierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionUdiDeviceIdentifierComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionUdiDeviceIdentifierComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceIdentifier")) {
      res.setDeviceIdentifierElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
      res.setIssuerElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.setJurisdictionElement(parseUri(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceNameComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionDeviceNameComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionDeviceNameComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionSpecializationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionSpecializationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionSpecializationComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("systemType")) {
      res.setSystemTypeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionCapabilityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionCapabilityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionCapabilityComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.getDescription().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionPropertyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueQuantity")) {
      res.getValueQuantity().add(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueCode")) {
      res.getValueCode().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionMaterialComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceDefinitionMaterialComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDefinitionMaterialComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
      res.setSubstance(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alternate")) {
      res.setAlternateElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergenicIndicator")) {
      res.setAllergenicIndicatorElement(parseBoolean(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceMetricContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceMetricContent(int eventType, XmlPullParser xpp, DeviceMetric res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
      res.setUnit(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
      res.setParent(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
      res.setOperationalStatusElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("color")) {
      res.setColorElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategoryElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPeriod")) {
      res.setMeasurementPeriod(parseTiming(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("calibration")) {
      res.getCalibration().add(parseDeviceMetricCalibrationComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricCalibrationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceMetricCalibrationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceMetricCalibrationComponentContent(int eventType, XmlPullParser xpp, DeviceMetric.DeviceMetricCalibrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("state")) {
      res.setStateElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
      res.setTimeElement(parseInstant(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceRequest parseDeviceRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceRequestContent(int eventType, XmlPullParser xpp, DeviceRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priorRequest")) {
      res.getPriorRequest().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
      res.setGroupIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
      res.setIntentElement(parseEnumeration(xpp, Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "code")) {
      res.setCode(parseType("code", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
      res.getParameter().add(parseDeviceRequestParameterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
      res.setOccurrence(parseType("occurrence", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
      res.setAuthoredOnElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
      res.setRequester(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
      res.setPerformerType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.setPerformer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
      res.getRelevantHistory().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestParameterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceRequestParameterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceRequestParameterComponentContent(int eventType, XmlPullParser xpp, DeviceRequest.DeviceRequestParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDeviceUseStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceUseStatementContent(int eventType, XmlPullParser xpp, DeviceUseStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
      res.getDerivedFrom().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
      res.setTiming(parseType("timing", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedOn")) {
      res.setRecordedOnElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.setDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDiagnosticReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDiagnosticReportContent(int eventType, XmlPullParser xpp, DiagnosticReport res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
      res.setEffective(parseType("effective", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
      res.setIssuedElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resultsInterpreter")) {
      res.getResultsInterpreter().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
      res.getSpecimen().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
      res.getResult().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imagingStudy")) {
      res.getImagingStudy().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("media")) {
      res.getMedia().add(parseDiagnosticReportMediaComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conclusion")) {
      res.setConclusionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conclusionCode")) {
      res.getConclusionCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentedForm")) {
      res.getPresentedForm().add(parseAttachment(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportMediaComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDiagnosticReportMediaComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDiagnosticReportMediaComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport.DiagnosticReportMediaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
      res.setLink(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDocumentManifestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestContent(int eventType, XmlPullParser xpp, DocumentManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterIdentifier")) {
      res.setMasterIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
      res.getRecipient().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
      res.getContent().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
      res.getRelated().add(parseDocumentManifestRelatedComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestRelatedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDocumentManifestRelatedComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentManifest.DocumentManifestRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ref")) {
      res.setRef(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDocumentReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceContent(int eventType, XmlPullParser xpp, DocumentReference res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterIdentifier")) {
      res.setMasterIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("docStatus")) {
      res.setDocStatusElement(parseEnumeration(xpp, Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authenticator")) {
      res.setAuthenticator(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
      res.setCustodian(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
      res.getRelatesTo().add(parseDocumentReferenceRelatesToComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
      res.getSecurityLabel().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
      res.getContent().add(parseDocumentReferenceContentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseDocumentReferenceContextComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDocumentReferenceRelatesToComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceRelatesToComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, Enumerations.DocumentRelationshipType.NULL, new Enumerations.DocumentRelationshipTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
      res.setTarget(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceContentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDocumentReferenceContentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceContentComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attachment")) {
      res.setAttachment(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
      res.setFormat(parseCoding(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceContextComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseDocumentReferenceContextComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceContextComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.getEncounter().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
      res.getEvent().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facilityType")) {
      res.setFacilityType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("practiceSetting")) {
      res.setPracticeSetting(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourcePatientInfo")) {
      res.setSourcePatientInfo(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
      res.getRelated().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterContent(int eventType, XmlPullParser xpp, Encounter res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusHistory")) {
      res.getStatusHistory().add(parseEncounterStatusHistoryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
      res.setClass_(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classHistory")) {
      res.getClassHistory().add(parseEncounterClassHistoryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
      res.setServiceType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriority(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("episodeOfCare")) {
      res.getEpisodeOfCare().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
      res.getParticipant().add(parseEncounterParticipantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointment")) {
      res.getAppointment().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("length")) {
      res.setLength(parseDuration(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
      res.getDiagnosis().add(parseEncounterDiagnosisComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
      res.getAccount().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hospitalization")) {
      res.setHospitalization(parseEncounterHospitalizationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.getLocation().add(parseEncounterLocationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceProvider")) {
      res.setServiceProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.setPartOf(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterStatusHistoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterStatusHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter.StatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterClassHistoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterClassHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter.ClassHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
      res.setClass_(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter.EncounterParticipantComponent parseEncounterParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterParticipantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterParticipantComponentContent(int eventType, XmlPullParser xpp, Encounter.EncounterParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("individual")) {
      res.setIndividual(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterDiagnosisComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterDiagnosisComponentContent(int eventType, XmlPullParser xpp, Encounter.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.setCondition(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUse(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
      res.setRankElement(parsePositiveInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterHospitalizationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterHospitalizationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterHospitalizationComponentContent(int eventType, XmlPullParser xpp, Encounter.EncounterHospitalizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAdmissionIdentifier")) {
      res.setPreAdmissionIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
      res.setOrigin(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("admitSource")) {
      res.setAdmitSource(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reAdmission")) {
      res.setReAdmission(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dietPreference")) {
      res.getDietPreference().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialCourtesy")) {
      res.getSpecialCourtesy().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialArrangement")) {
      res.getSpecialArrangement().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
      res.setDestination(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dischargeDisposition")) {
      res.setDischargeDisposition(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Encounter.EncounterLocationComponent parseEncounterLocationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEncounterLocationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterLocationComponentContent(int eventType, XmlPullParser xpp, Encounter.EncounterLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalType")) {
      res.setPhysicalType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Endpoint parseEndpoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEndpointContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEndpointContent(int eventType, XmlPullParser xpp, Endpoint res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("connectionType")) {
      res.setConnectionType(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
      res.setManagingOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payloadType")) {
      res.getPayloadType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payloadMimeType")) {
      res.getPayloadMimeType().add(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
      res.setAddressElement(parseUrl(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("header")) {
      res.getHeader().add(parseString(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEnrollmentRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEnrollmentRequestContent(int eventType, XmlPullParser xpp, EnrollmentRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
      res.setInsurer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("candidate")) {
      res.setCandidate(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEnrollmentResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEnrollmentResponseContent(int eventType, XmlPullParser xpp, EnrollmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.setRequest(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
      res.setDispositionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
      res.setOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
      res.setRequestProvider(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEpisodeOfCareContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareContent(int eventType, XmlPullParser xpp, EpisodeOfCare res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusHistory")) {
      res.getStatusHistory().add(parseEpisodeOfCareStatusHistoryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
      res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
      res.setManagingOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referralRequest")) {
      res.getReferralRequest().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careManager")) {
      res.setCareManager(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("team")) {
      res.getTeam().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
      res.getAccount().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEpisodeOfCareStatusHistoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareStatusHistoryComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEpisodeOfCareDiagnosisComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareDiagnosisComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.setCondition(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
      res.setRankElement(parsePositiveInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EventDefinition parseEventDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEventDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEventDefinitionContent(int eventType, XmlPullParser xpp, EventDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
      res.setSubtitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
      res.setSubject(parseType("subject", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
      res.setUsageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
      res.setEffectivePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
      res.getTopic().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("trigger")) {
      res.getTrigger().add(parseTriggerDefinition(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence parseEvidence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence res = new Evidence();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceContent(int eventType, XmlPullParser xpp, Evidence res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "citeAs")) {
      res.setCiteAs(parseType("citeAs", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assertion")) {
      res.setAssertionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variableDefinition")) {
      res.getVariableDefinition().add(parseEvidenceVariableDefinitionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("synthesisType")) {
      res.setSynthesisType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("studyType")) {
      res.setStudyType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statistic")) {
      res.getStatistic().add(parseEvidenceStatisticComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("certainty")) {
      res.getCertainty().add(parseEvidenceCertaintyComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceVariableDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceVariableDefinitionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableDefinitionComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceVariableDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variableRole")) {
      res.setVariableRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observed")) {
      res.setObserved(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intended")) {
      res.setIntended(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("directnessMatch")) {
      res.setDirectnessMatch(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceStatisticComponent parseEvidenceStatisticComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceStatisticComponent res = new Evidence.EvidenceStatisticComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceStatisticComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceStatisticComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statisticType")) {
      res.setStatisticType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfEvents")) {
      res.setNumberOfEventsElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberAffected")) {
      res.setNumberAffectedElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sampleSize")) {
      res.setSampleSize(parseEvidenceStatisticSampleSizeComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attributeEstimate")) {
      res.getAttributeEstimate().add(parseEvidenceStatisticAttributeEstimateComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modelCharacteristic")) {
      res.getModelCharacteristic().add(parseEvidenceStatisticModelCharacteristicComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceStatisticSampleSizeComponent parseEvidenceStatisticSampleSizeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceStatisticSampleSizeComponent res = new Evidence.EvidenceStatisticSampleSizeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceStatisticSampleSizeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceStatisticSampleSizeComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticSampleSizeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfStudies")) {
      res.setNumberOfStudiesElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfParticipants")) {
      res.setNumberOfParticipantsElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("knownDataCount")) {
      res.setKnownDataCountElement(parseUnsignedInt(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceStatisticAttributeEstimateComponent parseEvidenceStatisticAttributeEstimateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceStatisticAttributeEstimateComponent res = new Evidence.EvidenceStatisticAttributeEstimateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceStatisticAttributeEstimateComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceStatisticAttributeEstimateComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticAttributeEstimateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("level")) {
      res.setLevelElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("range")) {
      res.setRange(parseRange(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attributeEstimate")) {
      res.getAttributeEstimate().add(parseEvidenceStatisticAttributeEstimateComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceStatisticModelCharacteristicComponent parseEvidenceStatisticModelCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceStatisticModelCharacteristicComponent res = new Evidence.EvidenceStatisticModelCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceStatisticModelCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceStatisticModelCharacteristicComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticModelCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValue(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variable")) {
      res.getVariable().add(parseEvidenceStatisticModelCharacteristicVariableComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attributeEstimate")) {
      res.getAttributeEstimate().add(parseEvidenceStatisticAttributeEstimateComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceStatisticModelCharacteristicVariableComponent parseEvidenceStatisticModelCharacteristicVariableComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceStatisticModelCharacteristicVariableComponent res = new Evidence.EvidenceStatisticModelCharacteristicVariableComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceStatisticModelCharacteristicVariableComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceStatisticModelCharacteristicVariableComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticModelCharacteristicVariableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variableDefinition")) {
      res.setVariableDefinition(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("handling")) {
      res.setHandlingElement(parseEnumeration(xpp, Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueCategory")) {
      res.getValueCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueQuantity")) {
      res.getValueQuantity().add(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueRange")) {
      res.getValueRange().add(parseRange(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Evidence.EvidenceCertaintyComponent parseEvidenceCertaintyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceCertaintyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceCertaintyComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceCertaintyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rating")) {
      res.setRating(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rater")) {
      res.setRaterElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subcomponent")) {
      res.getSubcomponent().add(parseEvidenceCertaintyComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceReport parseEvidenceReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceReport res = new EvidenceReport();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceReportContent(int eventType, XmlPullParser xpp, EvidenceReport res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedIdentifier")) {
      res.getRelatedIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "citeAs")) {
      res.setCiteAs(parseType("citeAs", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseEvidenceReportSubjectComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
      res.getRelatesTo().add(parseEvidenceReportRelatesToComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
      res.getSection().add(parseEvidenceReportSectionComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceReport.EvidenceReportSubjectComponent parseEvidenceReportSubjectComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportSubjectComponent res = new EvidenceReport.EvidenceReportSubjectComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceReportSubjectComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceReportSubjectComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportSubjectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
      res.getCharacteristic().add(parseEvidenceReportSubjectCharacteristicComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceReport.EvidenceReportSubjectCharacteristicComponent parseEvidenceReportSubjectCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportSubjectCharacteristicComponent res = new EvidenceReport.EvidenceReportSubjectCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceReportSubjectCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceReportSubjectCharacteristicComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportSubjectCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
      res.setExcludeElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceReport.EvidenceReportRelatesToComponent parseEvidenceReportRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportRelatesToComponent res = new EvidenceReport.EvidenceReportRelatesToComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceReportRelatesToComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceReportRelatesToComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, EvidenceReport.ReportRelationshipType.NULL, new EvidenceReport.ReportRelationshipTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
      res.setTarget(parseType("target", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceReport.SectionComponent parseEvidenceReportSectionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceReport.SectionComponent res = new EvidenceReport.SectionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceReportSectionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceReportSectionComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
      res.setFocus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focusReference")) {
      res.setFocusReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setText(parseNarrative(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
      res.setOrderedBy(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entryClassifier")) {
      res.getEntryClassifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entryReference")) {
      res.getEntryReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entryQuantity")) {
      res.getEntryQuantity().add(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
      res.setEmptyReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
      res.getSection().add(parseEvidenceReportSectionComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceVariable parseEvidenceVariable(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceVariable res = new EvidenceVariable();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceVariableContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableContent(int eventType, XmlPullParser xpp, EvidenceVariable res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("shortTitle")) {
      res.setShortTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
      res.setSubtitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
      res.setActualElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristicCombination")) {
      res.setCharacteristicCombinationElement(parseEnumeration(xpp, EvidenceVariable.CharacteristicCombination.NULL, new EvidenceVariable.CharacteristicCombinationEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
      res.getCharacteristic().add(parseEvidenceVariableCharacteristicComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("handling")) {
      res.setHandlingElement(parseEnumeration(xpp, Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseEvidenceVariableCategoryComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceVariableCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableCharacteristicComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "definition")) {
      res.setDefinition(parseType("definition", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.setDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
      res.setExcludeElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timeFromStart")) {
      res.setTimeFromStart(parseEvidenceVariableCharacteristicTimeFromStartComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupMeasure")) {
      res.setGroupMeasureElement(parseEnumeration(xpp, Enumerations.GroupMeasure.NULL, new Enumerations.GroupMeasureEnumFactory()));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent parseEvidenceVariableCharacteristicTimeFromStartComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent res = new EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceVariableCharacteristicTimeFromStartComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableCharacteristicTimeFromStartComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("range")) {
      res.setRange(parseRange(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected EvidenceVariable.EvidenceVariableCategoryComponent parseEvidenceVariableCategoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCategoryComponent res = new EvidenceVariable.EvidenceVariableCategoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseEvidenceVariableCategoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEvidenceVariableCategoryComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCategoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario parseExampleScenario(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioContent(int eventType, XmlPullParser xpp, ExampleScenario res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.getActor().add(parseExampleScenarioActorComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
      res.getInstance().add(parseExampleScenarioInstanceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("process")) {
      res.getProcess().add(parseExampleScenarioProcessComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("workflow")) {
      res.getWorkflow().add(parseCanonical(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioActorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioActorComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioActorComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actorId")) {
      res.setActorIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioInstanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceId")) {
      res.setResourceIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceType")) {
      res.setResourceTypeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.getVersion().add(parseExampleScenarioInstanceVersionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containedInstance")) {
      res.getContainedInstance().add(parseExampleScenarioInstanceContainedInstanceComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioInstanceVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioInstanceVersionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioInstanceVersionComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
      res.setVersionIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioInstanceContainedInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioInstanceContainedInstanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioInstanceContainedInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceId")) {
      res.setResourceIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
      res.setVersionIdElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioProcessComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioProcessComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioProcessComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preConditions")) {
      res.setPreConditionsElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("postConditions")) {
      res.setPostConditionsElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("step")) {
      res.getStep().add(parseExampleScenarioProcessStepComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioProcessStepComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioProcessStepComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioProcessStepComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessStepComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("process")) {
      res.getProcess().add(parseExampleScenarioProcessComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pause")) {
      res.setPauseElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
      res.setOperation(parseExampleScenarioProcessStepOperationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alternative")) {
      res.getAlternative().add(parseExampleScenarioProcessStepAlternativeComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioProcessStepOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioProcessStepOperationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioProcessStepOperationComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
      res.setNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initiator")) {
      res.setInitiatorElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
      res.setReceiverElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initiatorActive")) {
      res.setInitiatorActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiverActive")) {
      res.setReceiverActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.setRequest(parseExampleScenarioInstanceContainedInstanceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
      res.setResponse(parseExampleScenarioInstanceContainedInstanceComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioProcessStepAlternativeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExampleScenarioProcessStepAlternativeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioProcessStepAlternativeComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("step")) {
      res.getStep().add(parseExampleScenarioProcessStepComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
      res.setSubType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billablePeriod")) {
      res.setBillablePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
      res.setCreatedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
      res.setEnterer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
      res.setInsurer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriority(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserveRequested")) {
      res.setFundsReserveRequested(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
      res.setFundsReserve(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
      res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prescription")) {
      res.setPrescription(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("originalPrescription")) {
      res.setOriginalPrescription(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
      res.setPayee(parseExplanationOfBenefitPayeeComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referral")) {
      res.setReferral(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
      res.setFacility(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
      res.setClaim(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
      res.setClaimResponse(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
      res.setDispositionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
      res.getPreAuthRef().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRefPeriod")) {
      res.getPreAuthRefPeriod().add(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
      res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
      res.getSupportingInfo().add(parseExplanationOfBenefitSupportingInformationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
      res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
      res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precedence")) {
      res.setPrecedenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseExplanationOfBenefitInsuranceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accident")) {
      res.setAccident(parseExplanationOfBenefitAccidentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseExplanationOfBenefitItemComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addItem")) {
      res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
      res.getTotal().add(parseExplanationOfBenefitTotalComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
      res.setPayment(parseExplanationOfBenefitPaymentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("formCode")) {
      res.setFormCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
      res.setForm(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
      res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitPeriod")) {
      res.setBenefitPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitBalance")) {
      res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitRelatedClaimComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitRelatedClaimComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
      res.setClaim(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
      res.setRelationship(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseIdentifier(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitPayeeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitPayeeComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
      res.setParty(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitCareTeamComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitCareTeamComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.setProvider(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
      res.setResponsibleElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
      res.setQualification(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitSupportingInformationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitSupportingInformationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
      res.setTiming(parseType("timing", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.setReason(parseCoding(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitDiagnosisComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitDiagnosisComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
      res.setDiagnosis(parseType("diagnosis", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onAdmission")) {
      res.setOnAdmission(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageCode")) {
      res.setPackageCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitProcedureComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitProcedureComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "procedure")) {
      res.setProcedure(parseType("procedure", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitInsuranceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitInsuranceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
      res.setFocalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.setCoverage(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
      res.getPreAuthRef().add(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitAccidentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAccidentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
      res.setLocation(parseType("location", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeamSequence")) {
      res.getCareTeamSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosisSequence")) {
      res.getDiagnosisSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureSequence")) {
      res.getProcedureSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSequence")) {
      res.getInformationSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
      res.setRevenue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
      res.setServiced(parseType("serviced", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
      res.setLocation(parseType("location", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
      res.getSubSite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.getEncounter().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseExplanationOfBenefitDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitAdjudicationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAdjudicationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.setReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseDecimal(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
      res.setRevenue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
      res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitSubDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
      res.setRevenue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
      res.getUdi().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitAddedItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("itemSequence")) {
      res.getItemSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequence")) {
      res.getDetailSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetailSequence")) {
      res.getSubDetailSequence().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
      res.getProvider().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
      res.getProgramCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
      res.setServiced(parseType("serviced", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
      res.setLocation(parseType("location", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
      res.getSubSite().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.getDetail().add(parseExplanationOfBenefitAddedItemDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitAddedItemDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
      res.getSubDetail().add(parseExplanationOfBenefitAddedItemDetailSubDetailComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productOrService")) {
      res.setProductOrService(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.getModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
      res.setUnitPrice(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
      res.setNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
      res.getNoteNumber().add(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
      res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitTotalComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitTotalComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitPaymentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitPaymentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustment")) {
      res.setAdjustment(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustmentReason")) {
      res.setAdjustmentReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitNoteComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitNoteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
      res.setNumberElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguage(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitBenefitBalanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitBenefitBalanceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.BenefitBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excluded")) {
      res.setExcludedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.setNetwork(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
      res.setUnit(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
      res.setTerm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("financial")) {
      res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseExplanationOfBenefitBenefitComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitBenefitComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
      res.setAllowed(parseType("allowed", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "used")) {
      res.setUsed(parseType("used", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseFamilyMemberHistoryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryContent(int eventType, XmlPullParser xpp, FamilyMemberHistory res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
      res.setDataAbsentReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
      res.setRelationship(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sex")) {
      res.setSex(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "born")) {
      res.setBorn(parseType("born", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "age")) {
      res.setAge(parseType("age", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("estimatedAge")) {
      res.setEstimatedAgeElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "deceased")) {
      res.setDeceased(parseType("deceased", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.getCondition().add(parseFamilyMemberHistoryConditionComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryConditionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseFamilyMemberHistoryConditionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryConditionComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
      res.setOutcome(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributedToDeath")) {
      res.setContributedToDeathElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
      res.setOnset(parseType("onset", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Flag res = new Flag();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseFlagContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFlagContent(int eventType, XmlPullParser xpp, Flag res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Goal res = new Goal();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGoalContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGoalContent(int eventType, XmlPullParser xpp, Goal res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lifecycleStatus")) {
      res.setLifecycleStatusElement(parseEnumeration(xpp, Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("achievementStatus")) {
      res.setAchievementStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriority(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescription(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "start")) {
      res.setStart(parseType("start", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
      res.getTarget().add(parseGoalTargetComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
      res.setStatusDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReasonElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expressedBy")) {
      res.setExpressedBy(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addresses")) {
      res.getAddresses().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeCode")) {
      res.getOutcomeCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeReference")) {
      res.getOutcomeReference().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Goal.GoalTargetComponent parseGoalTargetComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGoalTargetComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGoalTargetComponentContent(int eventType, XmlPullParser xpp, Goal.GoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
      res.setMeasure(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "detail")) {
      res.setDetail(parseType("detail", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "due")) {
      res.setDue(parseType("due", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected GraphDefinition parseGraphDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGraphDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionContent(int eventType, XmlPullParser xpp, GraphDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
      res.getLink().add(parseGraphDefinitionLinkComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionLinkComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGraphDefinitionLinkComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, GraphDefinition.GraphDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
      res.setPathElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceName")) {
      res.setSliceNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
      res.setMinElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
      res.setMaxElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
      res.getTarget().add(parseGraphDefinitionLinkTargetComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionLinkTargetComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGraphDefinitionLinkTargetComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionLinkTargetComponentContent(int eventType, XmlPullParser xpp, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("params")) {
      res.setParamsElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
      res.getCompartment().add(parseGraphDefinitionLinkTargetCompartmentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
      res.getLink().add(parseGraphDefinitionLinkComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionLinkTargetCompartmentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGraphDefinitionLinkTargetCompartmentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionLinkTargetCompartmentComponentContent(int eventType, XmlPullParser xpp, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
      res.setRuleElement(parseEnumeration(xpp, GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
      res.setExpressionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Group res = new Group();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGroupContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupContent(int eventType, XmlPullParser xpp, Group res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
      res.setActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
      res.setActualElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantityElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingEntity")) {
      res.setManagingEntity(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
      res.getCharacteristic().add(parseGroupCharacteristicComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("member")) {
      res.getMember().add(parseGroupMemberComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Group.GroupCharacteristicComponent parseGroupCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGroupCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupCharacteristicComponentContent(int eventType, XmlPullParser xpp, Group.GroupCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
      res.setExcludeElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Group.GroupMemberComponent parseGroupMemberComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGroupMemberComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupMemberComponentContent(int eventType, XmlPullParser xpp, Group.GroupMemberComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
      res.setEntity(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inactive")) {
      res.setInactiveElement(parseBoolean(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseGuidanceResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGuidanceResponseContent(int eventType, XmlPullParser xpp, GuidanceResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestIdentifier")) {
      res.setRequestIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "module")) {
      res.setModule(parseType("module", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("occurrenceDateTime")) {
      res.setOccurrenceDateTimeElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.setPerformer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evaluationMessage")) {
      res.getEvaluationMessage().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outputParameters")) {
      res.setOutputParameters(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
      res.setResult(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
      res.getDataRequirement().add(parseDataRequirement(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseHealthcareServiceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceContent(int eventType, XmlPullParser xpp, HealthcareService res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
      res.setActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("providedBy")) {
      res.setProvidedBy(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
      res.getSpecialty().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.getLocation().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extraDetails")) {
      res.setExtraDetailsElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
      res.setPhoto(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
      res.getTelecom().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
      res.getCoverageArea().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceProvisionCode")) {
      res.getServiceProvisionCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eligibility")) {
      res.getEligibility().add(parseHealthcareServiceEligibilityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("program")) {
      res.getProgram().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
      res.getCharacteristic().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communication")) {
      res.getCommunication().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referralMethod")) {
      res.getReferralMethod().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentRequired")) {
      res.setAppointmentRequiredElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableTime")) {
      res.getAvailableTime().add(parseHealthcareServiceAvailableTimeComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notAvailable")) {
      res.getNotAvailable().add(parseHealthcareServiceNotAvailableComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availabilityExceptions")) {
      res.setAvailabilityExceptionsElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.getEndpoint().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceEligibilityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseHealthcareServiceEligibilityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceEligibilityComponentContent(int eventType, XmlPullParser xpp, HealthcareService.HealthcareServiceEligibilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceAvailableTimeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseHealthcareServiceAvailableTimeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceAvailableTimeComponentContent(int eventType, XmlPullParser xpp, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysOfWeek")) {
      res.getDaysOfWeek().add(parseEnumeration(xpp, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allDay")) {
      res.setAllDayElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableStartTime")) {
      res.setAvailableStartTimeElement(parseTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableEndTime")) {
      res.setAvailableEndTimeElement(parseTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceNotAvailableComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseHealthcareServiceNotAvailableComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceNotAvailableComponentContent(int eventType, XmlPullParser xpp, HealthcareService.HealthcareServiceNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("during")) {
      res.setDuring(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImagingStudyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyContent(int eventType, XmlPullParser xpp, ImagingStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modality")) {
      res.getModality().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("started")) {
      res.setStartedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referrer")) {
      res.setReferrer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpreter")) {
      res.getInterpreter().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.getEndpoint().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfSeries")) {
      res.setNumberOfSeriesElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfInstances")) {
      res.setNumberOfInstancesElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureReference")) {
      res.setProcedureReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureCode")) {
      res.getProcedureCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
      res.getSeries().add(parseImagingStudySeriesComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudySeriesComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImagingStudySeriesComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudySeriesComponentContent(int eventType, XmlPullParser xpp, ImagingStudy.ImagingStudySeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
      res.setUidElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
      res.setNumberElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modality")) {
      res.setModality(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfInstances")) {
      res.setNumberOfInstancesElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.getEndpoint().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("laterality")) {
      res.setLaterality(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
      res.getSpecimen().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("started")) {
      res.setStartedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseImagingStudySeriesPerformerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
      res.getInstance().add(parseImagingStudySeriesInstanceComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudySeriesPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImagingStudySeriesPerformerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudySeriesPerformerComponentContent(int eventType, XmlPullParser xpp, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
      res.setFunction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudySeriesInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImagingStudySeriesInstanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudySeriesInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
      res.setUidElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sopClass")) {
      res.setSopClass(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
      res.setNumberElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationContent(int eventType, XmlPullParser xpp, Immunization res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Immunization.ImmunizationStatusCodes.NULL, new Immunization.ImmunizationStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccineCode")) {
      res.setVaccineCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
      res.setOccurrence(parseType("occurrence", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
      res.setRecordedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("primarySource")) {
      res.setPrimarySourceElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reportOrigin")) {
      res.setReportOrigin(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.setManufacturer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
      res.setLotNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
      res.setExpirationDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
      res.setSite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
      res.setRoute(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseQuantity")) {
      res.setDoseQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseImmunizationPerformerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isSubpotent")) {
      res.setIsSubpotentElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subpotentReason")) {
      res.getSubpotentReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("education")) {
      res.getEducation().add(parseImmunizationEducationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programEligibility")) {
      res.getProgramEligibility().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundingSource")) {
      res.setFundingSource(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reaction")) {
      res.getReaction().add(parseImmunizationReactionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocolApplied")) {
      res.getProtocolApplied().add(parseImmunizationProtocolAppliedComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Immunization.ImmunizationPerformerComponent parseImmunizationPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationPerformerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationPerformerComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
      res.setFunction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Immunization.ImmunizationEducationComponent parseImmunizationEducationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationEducationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationEducationComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationEducationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentType")) {
      res.setDocumentTypeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReferenceElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publicationDate")) {
      res.setPublicationDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentationDate")) {
      res.setPresentationDateElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationReactionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationReactionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationReactionComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
      res.setDetail(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reported")) {
      res.setReportedElement(parseBoolean(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationProtocolAppliedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationProtocolAppliedComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationProtocolAppliedComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationProtocolAppliedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
      res.setSeriesElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
      res.setAuthority(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
      res.getTargetDisease().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "doseNumber")) {
      res.setDoseNumber(parseType("doseNumber", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "seriesDoses")) {
      res.setSeriesDoses(parseType("seriesDoses", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImmunizationEvaluation parseImmunizationEvaluation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationEvaluation res = new ImmunizationEvaluation();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationEvaluationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationEvaluationContent(int eventType, XmlPullParser xpp, ImmunizationEvaluation res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
      res.setAuthority(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
      res.setTargetDisease(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("immunizationEvent")) {
      res.setImmunizationEvent(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseStatus")) {
      res.setDoseStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseStatusReason")) {
      res.getDoseStatusReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
      res.setSeriesElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "doseNumber")) {
      res.setDoseNumber(parseType("doseNumber", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "seriesDoses")) {
      res.setSeriesDoses(parseType("seriesDoses", xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationRecommendationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
      res.setAuthority(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recommendation")) {
      res.getRecommendation().add(parseImmunizationRecommendationRecommendationComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationRecommendationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationRecommendationRecommendationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationRecommendationComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccineCode")) {
      res.getVaccineCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
      res.setTargetDisease(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contraindicatedVaccineCode")) {
      res.getContraindicatedVaccineCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("forecastStatus")) {
      res.setForecastStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("forecastReason")) {
      res.getForecastReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateCriterion")) {
      res.getDateCriterion().add(parseImmunizationRecommendationRecommendationDateCriterionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
      res.setSeriesElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "doseNumber")) {
      res.setDoseNumber(parseType("doseNumber", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "seriesDoses")) {
      res.setSeriesDoses(parseType("seriesDoses", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingImmunization")) {
      res.getSupportingImmunization().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingPatientInformation")) {
      res.getSupportingPatientInformation().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImmunizationRecommendationRecommendationDateCriterionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationRecommendationDateCriterionComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideContent(int eventType, XmlPullParser xpp, ImplementationGuide res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageId")) {
      res.setPackageIdElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("license")) {
      res.setLicenseElement(parseEnumeration(xpp, ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
      res.getFhirVersion().add(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependsOn")) {
      res.getDependsOn().add(parseImplementationGuideDependsOnComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("global")) {
      res.getGlobal().add(parseImplementationGuideGlobalComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinition(parseImplementationGuideDefinitionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manifest")) {
      res.setManifest(parseImplementationGuideManifestComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideDependsOnComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDependsOnComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDependsOnComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
      res.setUriElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageId")) {
      res.setPackageIdElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideGlobalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideGlobalComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideGlobalComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideGlobalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDefinitionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDefinitionComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("grouping")) {
      res.getGrouping().add(parseImplementationGuideDefinitionGroupingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.getResource().add(parseImplementationGuideDefinitionResourceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
      res.setPage(parseImplementationGuideDefinitionPageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
      res.getParameter().add(parseImplementationGuideDefinitionParameterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("template")) {
      res.getTemplate().add(parseImplementationGuideDefinitionTemplateComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideDefinitionGroupingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDefinitionGroupingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDefinitionGroupingComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideDefinitionResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDefinitionResourceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
      res.getFhirVersion().add(parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "example")) {
      res.setExample(parseType("example", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupingId")) {
      res.setGroupingIdElement(parseId(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideDefinitionPageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDefinitionPageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDefinitionPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "name")) {
      res.setName(parseType("name", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("generation")) {
      res.setGenerationElement(parseEnumeration(xpp, ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
      res.getPage().add(parseImplementationGuideDefinitionPageComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideDefinitionParameterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDefinitionParameterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideDefinitionTemplateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideDefinitionTemplateComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideDefinitionTemplateComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scope")) {
      res.setScopeElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideManifestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideManifestComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideManifestComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideManifestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rendering")) {
      res.setRenderingElement(parseUrl(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.getResource().add(parseImplementationGuideManifestResourceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
      res.getPage().add(parseImplementationGuideManifestPageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
      res.getImage().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("other")) {
      res.getOther().add(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideManifestResourceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideManifestResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ManifestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.setReference(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "example")) {
      res.setExample(parseType("example", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relativePath")) {
      res.setRelativePathElement(parseUrl(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseImplementationGuideManifestPageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideManifestPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ManifestPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("anchor")) {
      res.getAnchor().add(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Ingredient parseIngredient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient res = new Ingredient();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseIngredientContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientContent(int eventType, XmlPullParser xpp, Ingredient res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("for")) {
      res.getFor().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
      res.getFunction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergenicIndicator")) {
      res.setAllergenicIndicatorElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.getManufacturer().add(parseIngredientManufacturerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
      res.setSubstance(parseIngredientSubstanceComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Ingredient.IngredientManufacturerComponent parseIngredientManufacturerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientManufacturerComponent res = new Ingredient.IngredientManufacturerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseIngredientManufacturerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientManufacturerComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientManufacturerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.setManufacturer(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Ingredient.IngredientSubstanceComponent parseIngredientSubstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceComponent res = new Ingredient.IngredientSubstanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseIngredientSubstanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientSubstanceComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientSubstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
      res.getStrength().add(parseIngredientSubstanceStrengthComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Ingredient.IngredientSubstanceStrengthComponent parseIngredientSubstanceStrengthComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseIngredientSubstanceStrengthComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientSubstanceStrengthComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientSubstanceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "presentation")) {
      res.setPresentation(parseType("presentation", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentationText")) {
      res.setPresentationTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "concentration")) {
      res.setConcentration(parseType("concentration", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concentrationText")) {
      res.setConcentrationTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPoint")) {
      res.setMeasurementPointElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
      res.getCountry().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceStrength")) {
      res.getReferenceStrength().add(parseIngredientSubstanceStrengthReferenceStrengthComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent parseIngredientSubstanceStrengthReferenceStrengthComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseIngredientSubstanceStrengthReferenceStrengthComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIngredientSubstanceStrengthReferenceStrengthComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
      res.setSubstance(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "strength")) {
      res.setStrength(parseType("strength", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPoint")) {
      res.setMeasurementPointElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
      res.getCountry().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan parseInsurancePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan res = new InsurancePlan();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanContent(int eventType, XmlPullParser xpp, InsurancePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
      res.getAlias().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ownedBy")) {
      res.setOwnedBy(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administeredBy")) {
      res.setAdministeredBy(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
      res.getCoverageArea().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseInsurancePlanContactComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.getEndpoint().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.getNetwork().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
      res.getCoverage().add(parseInsurancePlanCoverageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("plan")) {
      res.getPlan().add(parseInsurancePlanPlanComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.InsurancePlanContactComponent parseInsurancePlanContactComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanContactComponent res = new InsurancePlan.InsurancePlanContactComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanContactComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanContactComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurpose(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setName(parseHumanName(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
      res.getTelecom().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
      res.setAddress(parseAddress(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanCoverageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanCoverageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanCoverageComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanCoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.getNetwork().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefit")) {
      res.getBenefit().add(parseInsurancePlanCoverageBenefitComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanCoverageBenefitComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanCoverageBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.CoverageBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirement")) {
      res.setRequirementElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("limit")) {
      res.getLimit().add(parseInsurancePlanCoverageBenefitLimitComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanCoverageBenefitLimitComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanCoverageBenefitLimitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.CoverageBenefitLimitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValue(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanPlanComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanPlanComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanPlanComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
      res.getCoverageArea().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
      res.getNetwork().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("generalCost")) {
      res.getGeneralCost().add(parseInsurancePlanPlanGeneralCostComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specificCost")) {
      res.getSpecificCost().add(parseInsurancePlanPlanSpecificCostComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanPlanGeneralCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanPlanGeneralCostComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanGeneralCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupSize")) {
      res.setGroupSizeElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
      res.setCost(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanPlanSpecificCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanPlanSpecificCostComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanSpecificCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefit")) {
      res.getBenefit().add(parseInsurancePlanPlanBenefitComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanPlanBenefitComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.PlanBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
      res.getCost().add(parseInsurancePlanPlanBenefitCostComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInsurancePlanPlanBenefitCostComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInsurancePlanPlanBenefitCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.PlanBenefitCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applicability")) {
      res.setApplicability(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualifiers")) {
      res.getQualifiers().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValue(parseQuantity(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Invoice parseInvoice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice res = new Invoice();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInvoiceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceContent(int eventType, XmlPullParser xpp, Invoice res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cancelledReason")) {
      res.setCancelledReasonElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
      res.setRecipient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
      res.getParticipant().add(parseInvoiceParticipantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
      res.setIssuer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
      res.setAccount(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lineItem")) {
      res.getLineItem().add(parseInvoiceLineItemComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalPriceComponent")) {
      res.getTotalPriceComponent().add(parseInvoiceLineItemPriceComponentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalNet")) {
      res.setTotalNet(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalGross")) {
      res.setTotalGross(parseMoney(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("paymentTerms")) {
      res.setPaymentTermsElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Invoice.InvoiceParticipantComponent parseInvoiceParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInvoiceParticipantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceParticipantComponentContent(int eventType, XmlPullParser xpp, Invoice.InvoiceParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
      res.setRole(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Invoice.InvoiceLineItemComponent parseInvoiceLineItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInvoiceLineItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceLineItemComponentContent(int eventType, XmlPullParser xpp, Invoice.InvoiceLineItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
      res.setSequenceElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "chargeItem")) {
      res.setChargeItem(parseType("chargeItem", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceComponent")) {
      res.getPriceComponent().add(parseInvoiceLineItemPriceComponentComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Invoice.InvoiceLineItemPriceComponentComponent parseInvoiceLineItemPriceComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Invoice.InvoiceLineItemPriceComponentComponent res = new Invoice.InvoiceLineItemPriceComponentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseInvoiceLineItemPriceComponentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseInvoiceLineItemPriceComponentComponentContent(int eventType, XmlPullParser xpp, Invoice.InvoiceLineItemPriceComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.InvoicePriceComponentType.NULL, new Enumerations.InvoicePriceComponentTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
      res.setFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseMoney(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Library res = new Library();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseLibraryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLibraryContent(int eventType, XmlPullParser xpp, Library res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
      res.setSubtitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
      res.setSubject(parseType("subject", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
      res.setUsageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
      res.setEffectivePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
      res.getTopic().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
      res.getParameter().add(parseParameterDefinition(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
      res.getDataRequirement().add(parseDataRequirement(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
      res.getContent().add(parseAttachment(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseLinkageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLinkageContent(int eventType, XmlPullParser xpp, Linkage res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
      res.setActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.getItem().add(parseLinkageItemComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Linkage.LinkageItemComponent parseLinkageItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseLinkageItemComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLinkageItemComponentContent(int eventType, XmlPullParser xpp, Linkage.LinkageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.setResource(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseListResourceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseListResourceContent(int eventType, XmlPullParser xpp, ListResource res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
      res.setOrderedBy(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
      res.getEntry().add(parseListResourceEntryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
      res.setEmptyReason(parseCodeableConcept(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ListResource.ListResourceEntryComponent parseListResourceEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ListResource.ListResourceEntryComponent res = new ListResource.ListResourceEntryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseListResourceEntryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseListResourceEntryComponentContent(int eventType, XmlPullParser xpp, ListResource.ListResourceEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("flag")) {
      res.setFlag(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deleted")) {
      res.setDeletedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.setItem(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Location res = new Location();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseLocationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationContent(int eventType, XmlPullParser xpp, Location res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
      res.setOperationalStatus(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
      res.getAlias().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
      res.setModeElement(parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
      res.getTelecom().add(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
      res.setAddress(parseAddress(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalType")) {
      res.setPhysicalType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("position")) {
      res.setPosition(parseLocationPositionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
      res.setManagingOrganization(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.setPartOf(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hoursOfOperation")) {
      res.getHoursOfOperation().add(parseLocationHoursOfOperationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availabilityExceptions")) {
      res.setAvailabilityExceptionsElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.getEndpoint().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Location.LocationPositionComponent parseLocationPositionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseLocationPositionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationPositionComponentContent(int eventType, XmlPullParser xpp, Location.LocationPositionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("longitude")) {
      res.setLongitudeElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("latitude")) {
      res.setLatitudeElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("altitude")) {
      res.setAltitudeElement(parseDecimal(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Location.LocationHoursOfOperationComponent parseLocationHoursOfOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Location.LocationHoursOfOperationComponent res = new Location.LocationHoursOfOperationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseLocationHoursOfOperationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationHoursOfOperationComponentContent(int eventType, XmlPullParser xpp, Location.LocationHoursOfOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysOfWeek")) {
      res.getDaysOfWeek().add(parseEnumeration(xpp, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allDay")) {
      res.setAllDayElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("openingTime")) {
      res.setOpeningTimeElement(parseTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("closingTime")) {
      res.setClosingTimeElement(parseTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ManufacturedItemDefinition parseManufacturedItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ManufacturedItemDefinition res = new ManufacturedItemDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseManufacturedItemDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseManufacturedItemDefinitionContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturedDoseForm")) {
      res.setManufacturedDoseForm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitOfPresentation")) {
      res.setUnitOfPresentation(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.getManufacturer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
      res.getIngredient().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
      res.getProperty().add(parseManufacturedItemDefinitionPropertyComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent parseManufacturedItemDefinitionPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent res = new ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseManufacturedItemDefinitionPropertyComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseManufacturedItemDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure res = new Measure();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureContent(int eventType, XmlPullParser xpp, Measure res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtitle")) {
      res.setSubtitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "subject")) {
      res.setSubject(parseType("subject", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
      res.setUsageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
      res.setApprovalDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
      res.setLastReviewDateElement(parseDate(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
      res.setEffectivePeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
      res.getTopic().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.getAuthor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("editor")) {
      res.getEditor().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reviewer")) {
      res.getReviewer().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endorser")) {
      res.getEndorser().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
      res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
      res.getLibrary().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disclaimer")) {
      res.setDisclaimerElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scoring")) {
      res.setScoring(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compositeScoring")) {
      res.setCompositeScoring(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("riskAdjustment")) {
      res.setRiskAdjustmentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rateAggregation")) {
      res.setRateAggregationElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rationale")) {
      res.setRationaleElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalRecommendationStatement")) {
      res.setClinicalRecommendationStatementElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("improvementNotation")) {
      res.setImprovementNotation(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.getDefinition().add(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("guidance")) {
      res.setGuidanceElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
      res.getGroup().add(parseMeasureGroupComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplementalData")) {
      res.getSupplementalData().add(parseMeasureSupplementalDataComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Measure.MeasureGroupComponent parseMeasureGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureGroupComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureGroupComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
      res.getPopulation().add(parseMeasureGroupPopulationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratifier")) {
      res.getStratifier().add(parseMeasureGroupStratifierComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureGroupPopulationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureGroupPopulationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureGroupPopulationComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
      res.setCriteria(parseExpression(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureGroupStratifierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureGroupStratifierComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureGroupStratifierComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
      res.setCriteria(parseExpression(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
      res.getComponent().add(parseMeasureGroupStratifierComponentComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Measure.MeasureGroupStratifierComponentComponent parseMeasureGroupStratifierComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponentComponent res = new Measure.MeasureGroupStratifierComponentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureGroupStratifierComponentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureGroupStratifierComponentComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupStratifierComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
      res.setCriteria(parseExpression(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureSupplementalDataComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureSupplementalDataComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureSupplementalDataComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureSupplementalDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
      res.getUsage().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
      res.setCriteria(parseExpression(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport parseMeasureReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportContent(int eventType, XmlPullParser xpp, MeasureReport res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
      res.setMeasureElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reporter")) {
      res.setReporter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("improvementNotation")) {
      res.setImprovementNotation(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
      res.getGroup().add(parseMeasureReportGroupComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evaluatedResource")) {
      res.getEvaluatedResource().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportGroupComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport.MeasureReportGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
      res.getPopulation().add(parseMeasureReportGroupPopulationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measureScore")) {
      res.setMeasureScore(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratifier")) {
      res.getStratifier().add(parseMeasureReportGroupStratifierComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportGroupPopulationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportGroupPopulationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport.MeasureReportGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
      res.setCountElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectResults")) {
      res.setSubjectResults(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportGroupStratifierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportGroupStratifierComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportGroupStratifierComponentContent(int eventType, XmlPullParser xpp, MeasureReport.MeasureReportGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratum")) {
      res.getStratum().add(parseMeasureReportStratifierGroupComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportStratifierGroupComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport.StratifierGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValue(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
      res.getComponent().add(parseMeasureReportStratifierGroupComponentComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
      res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measureScore")) {
      res.setMeasureScore(parseQuantity(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport.StratifierGroupComponentComponent parseMeasureReportStratifierGroupComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponentComponent res = new MeasureReport.StratifierGroupComponentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportStratifierGroupComponentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupComponentComponentContent(int eventType, XmlPullParser xpp, MeasureReport.StratifierGroupComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValue(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMeasureReportStratifierGroupPopulationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport.StratifierGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
      res.setCountElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectResults")) {
      res.setSubjectResults(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Media parseMedia(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Media res = new Media();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMediaContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMediaContent(int eventType, XmlPullParser xpp, Media res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modality")) {
      res.setModality(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("view")) {
      res.setView(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "created")) {
      res.setCreated(parseType("created", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
      res.setIssuedElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operator")) {
      res.setOperator(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceName")) {
      res.setDeviceNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.setDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("height")) {
      res.setHeightElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("width")) {
      res.setWidthElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frames")) {
      res.setFramesElement(parsePositiveInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
      res.setDurationElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
      res.setContent(parseAttachment(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication res = new Medication();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationContent(int eventType, XmlPullParser xpp, Medication res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Medication.MedicationStatusCodes.NULL, new Medication.MedicationStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.setManufacturer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
      res.setForm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseRatio(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
      res.getIngredient().add(parseMedicationIngredientComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("batch")) {
      res.setBatch(parseMedicationBatchComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Medication.MedicationIngredientComponent parseMedicationIngredientComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationIngredientComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationIngredientComponentContent(int eventType, XmlPullParser xpp, Medication.MedicationIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
      res.setItem(parseType("item", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isActive")) {
      res.setIsActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
      res.setStrength(parseRatio(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Medication.MedicationBatchComponent parseMedicationBatchComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationBatchComponent res = new Medication.MedicationBatchComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationBatchComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationBatchComponentContent(int eventType, XmlPullParser xpp, Medication.MedicationBatchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
      res.setLotNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
      res.setExpirationDateElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationAdministrationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationContent(int eventType, XmlPullParser xpp, MedicationAdministration res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
      res.getInstantiates().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, MedicationAdministration.MedicationAdministrationStatusCodes.NULL, new MedicationAdministration.MedicationAdministrationStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.getStatusReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
      res.setMedication(parseType("medication", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
      res.getSupportingInformation().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
      res.setEffective(parseType("effective", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseMedicationAdministrationPerformerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
      res.setRequest(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.getDevice().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
      res.setDosage(parseMedicationAdministrationDosageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
      res.getEventHistory().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationAdministrationPerformerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationPerformerComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
      res.setFunction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationDosageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationAdministrationDosageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationDosageComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration.MedicationAdministrationDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
      res.setSite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
      res.setRoute(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dose")) {
      res.setDose(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
      res.setRate(parseType("rate", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationDispenseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseContent(int eventType, XmlPullParser xpp, MedicationDispense res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, MedicationDispense.MedicationDispenseStatusCodes.NULL, new MedicationDispense.MedicationDispenseStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "statusReason")) {
      res.setStatusReason(parseType("statusReason", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
      res.setMedication(parseType("medication", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
      res.getSupportingInformation().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseMedicationDispensePerformerComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
      res.setLocation(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizingPrescription")) {
      res.getAuthorizingPrescription().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysSupply")) {
      res.setDaysSupply(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenPrepared")) {
      res.setWhenPreparedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenHandedOver")) {
      res.setWhenHandedOverElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
      res.setDestination(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
      res.getReceiver().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosageInstruction")) {
      res.getDosageInstruction().add(parseDosage(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
      res.setSubstitution(parseMedicationDispenseSubstitutionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detectedIssue")) {
      res.getDetectedIssue().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
      res.getEventHistory().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispensePerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationDispensePerformerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispensePerformerComponentContent(int eventType, XmlPullParser xpp, MedicationDispense.MedicationDispensePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("function")) {
      res.setFunction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
      res.setActor(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseSubstitutionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationDispenseSubstitutionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("wasSubstituted")) {
      res.setWasSubstitutedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.getReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsibleParty")) {
      res.getResponsibleParty().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge parseMedicationKnowledge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge res = new MedicationKnowledge();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeContent(int eventType, XmlPullParser xpp, MedicationKnowledge res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, MedicationKnowledge.MedicationKnowledgeStatusCodes.NULL, new MedicationKnowledge.MedicationKnowledgeStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.setManufacturer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseForm")) {
      res.setDoseForm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("synonym")) {
      res.getSynonym().add(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedMedicationKnowledge")) {
      res.getRelatedMedicationKnowledge().add(parseMedicationKnowledgeRelatedMedicationKnowledgeComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("associatedMedication")) {
      res.getAssociatedMedication().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productType")) {
      res.getProductType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("monograph")) {
      res.getMonograph().add(parseMedicationKnowledgeMonographComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
      res.getIngredient().add(parseMedicationKnowledgeIngredientComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preparationInstruction")) {
      res.setPreparationInstructionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intendedRoute")) {
      res.getIntendedRoute().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
      res.getCost().add(parseMedicationKnowledgeCostComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("monitoringProgram")) {
      res.getMonitoringProgram().add(parseMedicationKnowledgeMonitoringProgramComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrationGuidelines")) {
      res.getAdministrationGuidelines().add(parseMedicationKnowledgeAdministrationGuidelinesComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medicineClassification")) {
      res.getMedicineClassification().add(parseMedicationKnowledgeMedicineClassificationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packaging")) {
      res.setPackaging(parseMedicationKnowledgePackagingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("drugCharacteristic")) {
      res.getDrugCharacteristic().add(parseMedicationKnowledgeDrugCharacteristicComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contraindication")) {
      res.getContraindication().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("regulatory")) {
      res.getRegulatory().add(parseMedicationKnowledgeRegulatoryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kinetics")) {
      res.getKinetics().add(parseMedicationKnowledgeKineticsComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent parseMedicationKnowledgeRelatedMedicationKnowledgeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeRelatedMedicationKnowledgeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeRelatedMedicationKnowledgeComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
      res.getReference().add(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeMonographComponent parseMedicationKnowledgeMonographComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonographComponent res = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeMonographComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMonographComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeMonographComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeIngredientComponent parseMedicationKnowledgeIngredientComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeIngredientComponent res = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeIngredientComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeIngredientComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
      res.setItem(parseType("item", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isActive")) {
      res.setIsActiveElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
      res.setStrength(parseRatio(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeCostComponent parseMedicationKnowledgeCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeCostComponent res = new MedicationKnowledge.MedicationKnowledgeCostComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeCostComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeCostComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cost")) {
      res.setCost(parseMoney(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent parseMedicationKnowledgeMonitoringProgramComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeMonitoringProgramComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMonitoringProgramComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent parseMedicationKnowledgeAdministrationGuidelinesComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeAdministrationGuidelinesComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeAdministrationGuidelinesComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
      res.getDosage().add(parseMedicationKnowledgeAdministrationGuidelinesDosageComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "indication")) {
      res.setIndication(parseType("indication", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientCharacteristics")) {
      res.getPatientCharacteristics().add(parseMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent parseMedicationKnowledgeAdministrationGuidelinesDosageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeAdministrationGuidelinesDosageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeAdministrationGuidelinesDosageComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
      res.getDosage().add(parseDosage(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent parseMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "characteristic")) {
      res.setCharacteristic(parseType("characteristic", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.getValue().add(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent parseMedicationKnowledgeMedicineClassificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeMedicineClassificationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeMedicineClassificationComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.getClassification().add(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgePackagingComponent parseMedicationKnowledgePackagingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgePackagingComponent res = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgePackagingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgePackagingComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgePackagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent parseMedicationKnowledgeDrugCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeDrugCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeDrugCharacteristicComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryComponent parseMedicationKnowledgeRegulatoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeRegulatoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeRegulatoryComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("regulatoryAuthority")) {
      res.setRegulatoryAuthority(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
      res.getSubstitution().add(parseMedicationKnowledgeRegulatorySubstitutionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
      res.getSchedule().add(parseMedicationKnowledgeRegulatoryScheduleComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDispense")) {
      res.setMaxDispense(parseMedicationKnowledgeRegulatoryMaxDispenseComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent parseMedicationKnowledgeRegulatorySubstitutionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeRegulatorySubstitutionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeRegulatorySubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allowed")) {
      res.setAllowedElement(parseBoolean(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent parseMedicationKnowledgeRegulatoryScheduleComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeRegulatoryScheduleComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeRegulatoryScheduleComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
      res.setSchedule(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent parseMedicationKnowledgeRegulatoryMaxDispenseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeRegulatoryMaxDispenseComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeRegulatoryMaxDispenseComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parseDuration(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationKnowledge.MedicationKnowledgeKineticsComponent parseMedicationKnowledgeKineticsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeKineticsComponent res = new MedicationKnowledge.MedicationKnowledgeKineticsComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationKnowledgeKineticsComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationKnowledgeKineticsComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge.MedicationKnowledgeKineticsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("areaUnderCurve")) {
      res.getAreaUnderCurve().add(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lethalDose50")) {
      res.getLethalDose50().add(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("halfLifePeriod")) {
      res.setHalfLifePeriod(parseDuration(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationRequest parseMedicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestContent(int eventType, XmlPullParser xpp, MedicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, MedicationRequest.MedicationrequestStatus.NULL, new MedicationRequest.MedicationrequestStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.setStatusReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
      res.setIntentElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
      res.setPriorityElement(parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
      res.setDoNotPerformElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "reported")) {
      res.setReported(parseType("reported", xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
      res.setMedication(parseType("medication", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
      res.getSupportingInformation().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
      res.setAuthoredOnElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
      res.setRequester(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.setPerformer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
      res.setPerformerType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
      res.setRecorder(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
      res.setGroupIdentifier(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("courseOfTherapyType")) {
      res.setCourseOfTherapyType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
      res.getInsurance().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosageInstruction")) {
      res.getDosageInstruction().add(parseDosage(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dispenseRequest")) {
      res.setDispenseRequest(parseMedicationRequestDispenseRequestComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
      res.setSubstitution(parseMedicationRequestSubstitutionComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priorPrescription")) {
      res.setPriorPrescription(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detectedIssue")) {
      res.getDetectedIssue().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
      res.getEventHistory().add(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestDispenseRequestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationRequestDispenseRequestComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestDispenseRequestComponentContent(int eventType, XmlPullParser xpp, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initialFill")) {
      res.setInitialFill(parseMedicationRequestDispenseRequestInitialFillComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dispenseInterval")) {
      res.setDispenseInterval(parseDuration(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validityPeriod")) {
      res.setValidityPeriod(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfRepeatsAllowed")) {
      res.setNumberOfRepeatsAllowedElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expectedSupplyDuration")) {
      res.setExpectedSupplyDuration(parseDuration(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.setPerformer(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent parseMedicationRequestDispenseRequestInitialFillComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationRequestDispenseRequestInitialFillComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestDispenseRequestInitialFillComponentContent(int eventType, XmlPullParser xpp, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
      res.setDuration(parseDuration(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestSubstitutionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationRequestSubstitutionComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationRequest.MedicationRequestSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
      res.setAllowed(parseType("allowed", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.setReason(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicationStatement parseMedicationStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationStatement res = new MedicationStatement();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicationStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationStatementContent(int eventType, XmlPullParser xpp, MedicationStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, MedicationStatement.MedicationStatusCodes.NULL, new MedicationStatement.MedicationStatusCodesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
      res.getStatusReason().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategory(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
      res.setMedication(parseType("medication", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
      res.setEffective(parseType("effective", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateAsserted")) {
      res.setDateAssertedElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSource")) {
      res.setInformationSource(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
      res.getDerivedFrom().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
      res.getReasonCode().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
      res.getReasonReference().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
      res.getDosage().add(parseDosage(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition parseMedicinalProductDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition res = new MedicinalProductDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("domain")) {
      res.setDomain(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatus(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
      res.setStatusDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("combinedPharmaceuticalDoseForm")) {
      res.setCombinedPharmaceuticalDoseForm(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
      res.getRoute().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
      res.setIndicationElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legalStatusOfSupply")) {
      res.setLegalStatusOfSupply(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalMonitoringIndicator")) {
      res.setAdditionalMonitoringIndicator(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialMeasures")) {
      res.getSpecialMeasures().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pediatricUseIndicator")) {
      res.setPediatricUseIndicator(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
      res.getClassification().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("marketingStatus")) {
      res.getMarketingStatus().add(parseMarketingStatus(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packagedMedicinalProduct")) {
      res.getPackagedMedicinalProduct().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
      res.getIngredient().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("impurity")) {
      res.getImpurity().add(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attachedDocument")) {
      res.getAttachedDocument().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterFile")) {
      res.getMasterFile().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseMedicinalProductDefinitionContactComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalTrial")) {
      res.getClinicalTrial().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.getCode().add(parseCoding(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.getName().add(parseMedicinalProductDefinitionNameComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("crossReference")) {
      res.getCrossReference().add(parseMedicinalProductDefinitionCrossReferenceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
      res.getOperation().add(parseMedicinalProductDefinitionOperationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
      res.getCharacteristic().add(parseMedicinalProductDefinitionCharacteristicComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionContactComponent parseMedicinalProductDefinitionContactComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionContactComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionContactComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionContactComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionContactComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.setContact(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameComponent parseMedicinalProductDefinitionNameComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionNameComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionNameComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productName")) {
      res.setProductNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("namePart")) {
      res.getNamePart().add(parseMedicinalProductDefinitionNameNamePartComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("countryLanguage")) {
      res.getCountryLanguage().add(parseMedicinalProductDefinitionNameCountryLanguageComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent parseMedicinalProductDefinitionNameNamePartComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionNameNamePartComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionNameNamePartComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
      res.setPartElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent parseMedicinalProductDefinitionNameCountryLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionNameCountryLanguageComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionNameCountryLanguageComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
      res.setCountry(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.setJurisdiction(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
      res.setLanguage(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent parseMedicinalProductDefinitionCrossReferenceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionCrossReferenceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionCrossReferenceComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("product")) {
      res.setProduct(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent parseMedicinalProductDefinitionOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionOperationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionOperationComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectiveDate")) {
      res.setEffectiveDate(parsePeriod(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
      res.getOrganization().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("confidentialityIndicator")) {
      res.setConfidentialityIndicator(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent parseMedicinalProductDefinitionCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMedicinalProductDefinitionCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicinalProductDefinitionCharacteristicComponentContent(int eventType, XmlPullParser xpp, MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageDefinition parseMessageDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionContent(int eventType, XmlPullParser xpp, MessageDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
      res.getReplaces().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
      res.setCopyrightElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
      res.setBaseElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
      res.getParent().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "event")) {
      res.setEvent(parseType("event", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategoryElement(parseEnumeration(xpp, MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
      res.getFocus().add(parseMessageDefinitionFocusComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responseRequired")) {
      res.setResponseRequiredElement(parseEnumeration(xpp, MessageDefinition.MessageheaderResponseRequest.NULL, new MessageDefinition.MessageheaderResponseRequestEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allowedResponse")) {
      res.getAllowedResponse().add(parseMessageDefinitionAllowedResponseComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("graph")) {
      res.getGraph().add(parseCanonical(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionFocusComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageDefinitionFocusComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionFocusComponentContent(int eventType, XmlPullParser xpp, MessageDefinition.MessageDefinitionFocusComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
      res.setProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
      res.setMinElement(parseUnsignedInt(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
      res.setMaxElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionAllowedResponseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageDefinitionAllowedResponseComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionAllowedResponseComponentContent(int eventType, XmlPullParser xpp, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("message")) {
      res.setMessageElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("situation")) {
      res.setSituationElement(parseMarkdown(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageHeaderContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderContent(int eventType, XmlPullParser xpp, MessageHeader res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "event")) {
      res.setEvent(parseType("event", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
      res.getDestination().add(parseMessageHeaderMessageDestinationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
      res.setSender(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
      res.setEnterer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
      res.setAuthor(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSource(parseMessageHeaderMessageSourceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
      res.setResponsible(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
      res.setReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
      res.setResponse(parseMessageHeaderResponseComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
      res.getFocus().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
      res.setDefinitionElement(parseCanonical(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageHeaderMessageDestinationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageDestinationComponentContent(int eventType, XmlPullParser xpp, MessageHeader.MessageDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
      res.setTarget(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.setEndpointElement(parseUrl(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
      res.setReceiver(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageHeaderMessageSourceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageSourceComponentContent(int eventType, XmlPullParser xpp, MessageHeader.MessageSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
      res.setSoftwareElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.setContact(parseContactPoint(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
      res.setEndpointElement(parseUrl(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderResponseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMessageHeaderResponseComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderResponseComponentContent(int eventType, XmlPullParser xpp, MessageHeader.MessageHeaderResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.setIdentifierElement(parseId(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("details")) {
      res.setDetails(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence parseMolecularSequence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence res = new MolecularSequence();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceContent(int eventType, XmlPullParser xpp, MolecularSequence res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, MolecularSequence.SequenceType.NULL, new MolecularSequence.SequenceTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coordinateSystem")) {
      res.setCoordinateSystemElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
      res.setSpecimen(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.setDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.setPerformer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeq")) {
      res.setReferenceSeq(parseMolecularSequenceReferenceSeqComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variant")) {
      res.getVariant().add(parseMolecularSequenceVariantComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observedSeq")) {
      res.setObservedSeqElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quality")) {
      res.getQuality().add(parseMolecularSequenceQualityComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readCoverage")) {
      res.setReadCoverageElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repository")) {
      res.getRepository().add(parseMolecularSequenceRepositoryComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pointer")) {
      res.getPointer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("structureVariant")) {
      res.getStructureVariant().add(parseMolecularSequenceStructureVariantComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceReferenceSeqComponent parseMolecularSequenceReferenceSeqComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceReferenceSeqComponent res = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceReferenceSeqComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceReferenceSeqComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceReferenceSeqComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("chromosome")) {
      res.setChromosome(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("genomeBuild")) {
      res.setGenomeBuildElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orientation")) {
      res.setOrientationElement(parseEnumeration(xpp, MolecularSequence.OrientationType.NULL, new MolecularSequence.OrientationTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqId")) {
      res.setReferenceSeqId(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqPointer")) {
      res.setReferenceSeqPointer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqString")) {
      res.setReferenceSeqStringElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strand")) {
      res.setStrandElement(parseEnumeration(xpp, MolecularSequence.StrandType.NULL, new MolecularSequence.StrandTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("windowStart")) {
      res.setWindowStartElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("windowEnd")) {
      res.setWindowEndElement(parseInteger(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceVariantComponent parseMolecularSequenceVariantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceVariantComponent res = new MolecularSequence.MolecularSequenceVariantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceVariantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceVariantComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observedAllele")) {
      res.setObservedAlleleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceAllele")) {
      res.setReferenceAlleleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cigar")) {
      res.setCigarElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantPointer")) {
      res.setVariantPointer(parseReference(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceQualityComponent parseMolecularSequenceQualityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityComponent res = new MolecularSequence.MolecularSequenceQualityComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceQualityComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceQualityComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceQualityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, MolecularSequence.QualityType.NULL, new MolecularSequence.QualityTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("standardSequence")) {
      res.setStandardSequence(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
      res.setScore(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("truthTP")) {
      res.setTruthTPElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("queryTP")) {
      res.setQueryTPElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("truthFN")) {
      res.setTruthFNElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("queryFP")) {
      res.setQueryFPElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gtFP")) {
      res.setGtFPElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
      res.setPrecisionElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recall")) {
      res.setRecallElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fScore")) {
      res.setFScoreElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("roc")) {
      res.setRoc(parseMolecularSequenceQualityRocComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceQualityRocComponent parseMolecularSequenceQualityRocComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityRocComponent res = new MolecularSequence.MolecularSequenceQualityRocComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceQualityRocComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceQualityRocComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceQualityRocComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
      res.getScore().add(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numTP")) {
      res.getNumTP().add(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numFP")) {
      res.getNumFP().add(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numFN")) {
      res.getNumFN().add(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
      res.getPrecision().add(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sensitivity")) {
      res.getSensitivity().add(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fMeasure")) {
      res.getFMeasure().add(parseDecimal(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceRepositoryComponent parseMolecularSequenceRepositoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceRepositoryComponent res = new MolecularSequence.MolecularSequenceRepositoryComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceRepositoryComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceRepositoryComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceRepositoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, MolecularSequence.RepositoryType.NULL, new MolecularSequence.RepositoryTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("datasetId")) {
      res.setDatasetIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantsetId")) {
      res.setVariantsetIdElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readsetId")) {
      res.setReadsetIdElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceStructureVariantComponent parseMolecularSequenceStructureVariantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantComponent res = new MolecularSequence.MolecularSequenceStructureVariantComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceStructureVariantComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceStructureVariantComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceStructureVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantType")) {
      res.setVariantType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exact")) {
      res.setExactElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("length")) {
      res.setLengthElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outer")) {
      res.setOuter(parseMolecularSequenceStructureVariantOuterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inner")) {
      res.setInner(parseMolecularSequenceStructureVariantInnerComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceStructureVariantOuterComponent parseMolecularSequenceStructureVariantOuterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantOuterComponent res = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceStructureVariantOuterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceStructureVariantOuterComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceStructureVariantOuterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseInteger(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected MolecularSequence.MolecularSequenceStructureVariantInnerComponent parseMolecularSequenceStructureVariantInnerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantInnerComponent res = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseMolecularSequenceStructureVariantInnerComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMolecularSequenceStructureVariantInnerComponentContent(int eventType, XmlPullParser xpp, MolecularSequence.MolecularSequenceStructureVariantInnerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
      res.setStartElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
      res.setEndElement(parseInteger(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNamingSystemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNamingSystemContent(int eventType, XmlPullParser xpp, NamingSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
      res.setKindElement(parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
      res.setResponsibleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
      res.setUsageElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uniqueId")) {
      res.getUniqueId().add(parseNamingSystemUniqueIdComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemUniqueIdComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNamingSystemUniqueIdComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNamingSystemUniqueIdComponentContent(int eventType, XmlPullParser xpp, NamingSystem.NamingSystemUniqueIdComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
      res.setValueElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preferred")) {
      res.setPreferredElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
      res.setPeriod(parsePeriod(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderContent(int eventType, XmlPullParser xpp, NutritionOrder res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesCanonical")) {
      res.getInstantiatesCanonical().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiatesUri")) {
      res.getInstantiatesUri().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
      res.getInstantiates().add(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
      res.setIntentElement(parseEnumeration(xpp, Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
      res.setPatient(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateTime")) {
      res.setDateTimeElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderer")) {
      res.setOrderer(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergyIntolerance")) {
      res.getAllergyIntolerance().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("foodPreferenceModifier")) {
      res.getFoodPreferenceModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludeFoodModifier")) {
      res.getExcludeFoodModifier().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("oralDiet")) {
      res.setOralDiet(parseNutritionOrderOralDietComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplement")) {
      res.getSupplement().add(parseNutritionOrderSupplementComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enteralFormula")) {
      res.setEnteralFormula(parseNutritionOrderEnteralFormulaComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderOralDietComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderOralDietComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderOralDietComponentContent(int eventType, XmlPullParser xpp, NutritionOrder.NutritionOrderOralDietComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.getType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
      res.getSchedule().add(parseTiming(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nutrient")) {
      res.getNutrient().add(parseNutritionOrderOralDietNutrientComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("texture")) {
      res.getTexture().add(parseNutritionOrderOralDietTextureComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fluidConsistencyType")) {
      res.getFluidConsistencyType().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
      res.setInstructionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderOralDietNutrientComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderOralDietNutrientComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderOralDietNutrientComponentContent(int eventType, XmlPullParser xpp, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.setModifier(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.setAmount(parseQuantity(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderOralDietTextureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderOralDietTextureComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderOralDietTextureComponentContent(int eventType, XmlPullParser xpp, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
      res.setModifier(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("foodType")) {
      res.setFoodType(parseCodeableConcept(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderSupplementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderSupplementComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderSupplementComponentContent(int eventType, XmlPullParser xpp, NutritionOrder.NutritionOrderSupplementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productName")) {
      res.setProductNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
      res.getSchedule().add(parseTiming(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
      res.setInstructionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderEnteralFormulaComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderEnteralFormulaComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderEnteralFormulaComponentContent(int eventType, XmlPullParser xpp, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseFormulaType")) {
      res.setBaseFormulaType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseFormulaProductName")) {
      res.setBaseFormulaProductNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additiveType")) {
      res.setAdditiveType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additiveProductName")) {
      res.setAdditiveProductNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("caloricDensity")) {
      res.setCaloricDensity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("routeofAdministration")) {
      res.setRouteofAdministration(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administration")) {
      res.getAdministration().add(parseNutritionOrderEnteralFormulaAdministrationComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxVolumeToDeliver")) {
      res.setMaxVolumeToDeliver(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrationInstruction")) {
      res.setAdministrationInstructionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionOrderEnteralFormulaAdministrationComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderEnteralFormulaAdministrationComponentContent(int eventType, XmlPullParser xpp, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
      res.setSchedule(parseTiming(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
      res.setRate(parseType("rate", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionProduct parseNutritionProduct(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionProduct res = new NutritionProduct();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionProductContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionProductContent(int eventType, XmlPullParser xpp, NutritionProduct res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, NutritionProduct.NutritionProductStatus.NULL, new NutritionProduct.NutritionProductStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
      res.getManufacturer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nutrient")) {
      res.getNutrient().add(parseNutritionProductNutrientComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
      res.getIngredient().add(parseNutritionProductIngredientComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("knownAllergen")) {
      res.getKnownAllergen().add(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productCharacteristic")) {
      res.getProductCharacteristic().add(parseNutritionProductProductCharacteristicComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
      res.setInstance(parseNutritionProductInstanceComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionProduct.NutritionProductNutrientComponent parseNutritionProductNutrientComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionProduct.NutritionProductNutrientComponent res = new NutritionProduct.NutritionProductNutrientComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionProductNutrientComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionProductNutrientComponentContent(int eventType, XmlPullParser xpp, NutritionProduct.NutritionProductNutrientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.setItem(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.getAmount().add(parseRatio(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionProduct.NutritionProductIngredientComponent parseNutritionProductIngredientComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionProduct.NutritionProductIngredientComponent res = new NutritionProduct.NutritionProductIngredientComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionProductIngredientComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionProductIngredientComponentContent(int eventType, XmlPullParser xpp, NutritionProduct.NutritionProductIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
      res.setItem(parseCodeableReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
      res.getAmount().add(parseRatio(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionProduct.NutritionProductProductCharacteristicComponent parseNutritionProductProductCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionProduct.NutritionProductProductCharacteristicComponent res = new NutritionProduct.NutritionProductProductCharacteristicComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionProductProductCharacteristicComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionProductProductCharacteristicComponentContent(int eventType, XmlPullParser xpp, NutritionProduct.NutritionProductProductCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected NutritionProduct.NutritionProductInstanceComponent parseNutritionProductInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionProduct.NutritionProductInstanceComponent res = new NutritionProduct.NutritionProductInstanceComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseNutritionProductInstanceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionProductInstanceComponentContent(int eventType, XmlPullParser xpp, NutritionProduct.NutritionProductInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
      res.setQuantity(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
      res.setLotNumberElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expiry")) {
      res.setExpiryElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useBy")) {
      res.setUseByElement(parseDateTime(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Observation parseObservation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation res = new Observation();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseObservationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationContent(int eventType, XmlPullParser xpp, Observation res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
      res.getBasedOn().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
      res.getPartOf().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.ObservationStatus.NULL, new Enumerations.ObservationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
      res.setSubject(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
      res.getFocus().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
      res.setEncounter(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
      res.setEffective(parseType("effective", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
      res.setIssuedElement(parseInstant(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
      res.getPerformer().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
      res.setDataAbsentReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpretation")) {
      res.getInterpretation().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
      res.getNote().add(parseAnnotation(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
      res.setBodySite(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
      res.setSpecimen(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
      res.setDevice(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceRange")) {
      res.getReferenceRange().add(parseObservationReferenceRangeComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hasMember")) {
      res.getHasMember().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
      res.getDerivedFrom().add(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
      res.getComponent().add(parseObservationComponentComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Observation.ObservationReferenceRangeComponent parseObservationReferenceRangeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseObservationReferenceRangeComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationReferenceRangeComponentContent(int eventType, XmlPullParser xpp, Observation.ObservationReferenceRangeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("low")) {
      res.setLow(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("high")) {
      res.setHigh(parseQuantity(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setType(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appliesTo")) {
      res.getAppliesTo().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("age")) {
      res.setAge(parseRange(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
      res.setTextElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected Observation.ObservationComponentComponent parseObservationComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseObservationComponentComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationComponentComponentContent(int eventType, XmlPullParser xpp, Observation.ObservationComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
      res.setValue(parseType("value", xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
      res.setDataAbsentReason(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpretation")) {
      res.getInterpretation().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceRange")) {
      res.getReferenceRange().add(parseObservationReferenceRangeComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ObservationDefinition parseObservationDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ObservationDefinition res = new ObservationDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseObservationDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationDefinitionContent(int eventType, XmlPullParser xpp, ObservationDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.getCategory().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCode(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
      res.getIdentifier().add(parseIdentifier(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("permittedDataType")) {
      res.getPermittedDataType().add(parseEnumeration(xpp, ObservationDefinition.ObservationDataType.NULL, new ObservationDefinition.ObservationDataTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("multipleResultsAllowed")) {
      res.setMultipleResultsAllowedElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
      res.setMethod(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preferredReportName")) {
      res.setPreferredReportNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantitativeDetails")) {
      res.setQuantitativeDetails(parseObservationDefinitionQuantitativeDetailsComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualifiedInterval")) {
      res.getQualifiedInterval().add(parseObservationDefinitionQualifiedIntervalComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validCodedValueSet")) {
      res.setValidCodedValueSet(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("normalCodedValueSet")) {
      res.setNormalCodedValueSet(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("abnormalCodedValueSet")) {
      res.setAbnormalCodedValueSet(parseReference(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criticalCodedValueSet")) {
      res.setCriticalCodedValueSet(parseReference(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent parseObservationDefinitionQuantitativeDetailsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent res = new ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseObservationDefinitionQuantitativeDetailsComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationDefinitionQuantitativeDetailsComponentContent(int eventType, XmlPullParser xpp, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("customaryUnit")) {
      res.setCustomaryUnit(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
      res.setUnit(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conversionFactor")) {
      res.setConversionFactorElement(parseDecimal(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("decimalPrecision")) {
      res.setDecimalPrecisionElement(parseInteger(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent parseObservationDefinitionQualifiedIntervalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent res = new ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseObservationDefinitionQualifiedIntervalComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationDefinitionQualifiedIntervalComponentContent(int eventType, XmlPullParser xpp, ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
      res.setCategoryElement(parseEnumeration(xpp, ObservationDefinition.ObservationRangeCategory.NULL, new ObservationDefinition.ObservationRangeCategoryEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("range")) {
      res.setRange(parseRange(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
      res.setContext(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appliesTo")) {
      res.getAppliesTo().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
      res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("age")) {
      res.setAge(parseRange(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gestationalAge")) {
      res.setGestationalAge(parseRange(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
      res.setConditionElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected OperationDefinition parseOperationDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition res = new OperationDefinition();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseOperationDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionContent(int eventType, XmlPullParser xpp, OperationDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
      res.setUrlElement(parseUri(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
      res.setVersionElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
      res.setTitleElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
      res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
      res.setKindElement(parseEnumeration(xpp, OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
      res.setExperimentalElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
      res.setDateElement(parseDateTime(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
      res.setPublisherElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
      res.getContact().add(parseContactDetail(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
      res.setDescriptionElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
      res.getUseContext().add(parseUsageContext(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
      res.getJurisdiction().add(parseCodeableConcept(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
      res.setPurposeElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("affectsState")) {
      res.setAffectsStateElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
      res.setCodeElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
      res.setCommentElement(parseMarkdown(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
      res.setBaseElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
      res.getResource().add(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
      res.setSystemElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
      res.setInstanceElement(parseBoolean(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inputProfile")) {
      res.setInputProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outputProfile")) {
      res.setOutputProfileElement(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
      res.getParameter().add(parseOperationDefinitionParameterComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("overload")) {
      res.getOverload().add(parseOperationDefinitionOverloadComponent(xpp));
    } else if (!parseDomainResourceContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionParameterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseOperationDefinitionParameterComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, OperationDefinition.OperationDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
      res.setNameElement(parseCode(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
      res.setUseElement(parseEnumeration(xpp, Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
      res.setMinElement(parseInteger(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
      res.setMaxElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
      res.setDocumentationElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
      res.setTypeElement(parseEnumeration(xpp, Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetProfile")) {
      res.getTargetProfile().add(parseCanonical(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchType")) {
      res.setSearchTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("binding")) {
      res.setBinding(parseOperationDefinitionParameterBindingComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencedFrom")) {
      res.getReferencedFrom().add(parseOperationDefinitionParameterReferencedFromComponent(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
      res.getPart().add(parseOperationDefinitionParameterComponent(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionParameterBindingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseOperationDefinitionParameterBindingComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionParameterBindingComponentContent(int eventType, XmlPullParser xpp, OperationDefinition.OperationDefinitionParameterBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
      res.setStrengthElement(parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
      res.setValueSetElement(parseCanonical(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected OperationDefinition.OperationDefinitionParameterReferencedFromComponent parseOperationDefinitionParameterReferencedFromComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterReferencedFromComponent res = new OperationDefinition.OperationDefinitionParameterReferencedFromComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
    if (!parseOperationDefinitionParameterReferencedFromComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionParameterReferencedFromComponentContent(int eventType, XmlPullParser xpp, OperationDefinition.OperationDefinitionParameterReferencedFromComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
      res.setSourceElement(parseString(xpp));
    } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceId")) {
      res.setSourceIdElement(parseString(xpp));
    } else if (!parseBackboneElementContent(eventType, xpp, res)){ 
      return false;
    }
    return true;
  }

  protected OperationDefinition.OperationDefinitionOverloadComponent parseOperationDefinitionOverloadComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionOverloadComponent res = new OperationDefinition.OperationDefinitionOverloadComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
 