/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="List", profile="http://hl7.org/fhir/StructureDefinition/List")
public class ListResource
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier for the List assigned for business purposes outside the context of FHIR.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="current | retired | entered-in-error", formalDefinition="Indicates the current state of this list.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-status")
    protected Enumeration<ListStatus> status;
    @Child(name="mode", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="working | snapshot | changes", formalDefinition="How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
    protected Enumeration<Enumerations.ListMode> mode;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Descriptive name for the list", formalDefinition="A label for the list assigned by the author.")
    protected StringType title;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What the purpose of this list is", formalDefinition="This code defines the purpose of the list - why it was created.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-example-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If all resources have the same subject", formalDefinition="The common subject (or patient) of the resources that are in the list if there is one.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Context in which list created", formalDefinition="The encounter that is the context in which this list was created.")
    protected Reference encounter;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the list was prepared", formalDefinition="The date that the list was prepared.")
    protected DateTimeType date;
    @Child(name="source", type={Practitioner.class, PractitionerRole.class, Patient.class, Device.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what defined the list contents (aka Author)", formalDefinition="The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.")
    protected Reference source;
    @Child(name="orderedBy", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What order the list has", formalDefinition="What order applies to the items in the list.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-order")
    protected CodeableConcept orderedBy;
    @Child(name="note", type={Annotation.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the list", formalDefinition="Comments that apply to the overall list.")
    protected List<Annotation> note;
    @Child(name="entry", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entries in the list", formalDefinition="Entries in this list.")
    protected List<ListResourceEntryComponent> entry;
    @Child(name="emptyReason", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why list is empty", formalDefinition="If the list is empty, why the list is empty.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
    protected CodeableConcept emptyReason;
    private static final long serialVersionUID = 1429954620L;
    @SearchParamDefinition(name="empty-reason", path="List.emptyReason", description="Why list is empty", type="token")
    public static final String SP_EMPTY_REASON = "empty-reason";
    public static final TokenClientParam EMPTY_REASON = new TokenClientParam("empty-reason");
    @SearchParamDefinition(name="item", path="List.entry.item", description="Actual entry", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_ITEM = "item";
    public static final ReferenceClientParam ITEM = new ReferenceClientParam("item");
    public static final Include INCLUDE_ITEM = new Include("List:item").toLocked();
    @SearchParamDefinition(name="notes", path="List.note.text", description="The annotation  - text content (as markdown)", type="string")
    public static final String SP_NOTES = "notes";
    public static final StringClientParam NOTES = new StringClientParam("notes");
    @SearchParamDefinition(name="source", path="List.source", description="Who and/or what defined the list contents (aka Author)", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Patient.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("List:source").toLocked();
    @SearchParamDefinition(name="status", path="List.status", description="current | retired | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="List.subject", description="If all resources have the same subject", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={Device.class, Group.class, Location.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("List:subject").toLocked();
    @SearchParamDefinition(name="title", path="List.title", description="Descriptive name for the list", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | (DeviceRequest.code as CodeableConcept) | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | (MedicationAdministration.medication as CodeableConcept) | (MedicationDispense.medication as CodeableConcept) | (MedicationRequest.medication as CodeableConcept) | (MedicationStatement.medication as CodeableConcept) | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | CareTeam.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | Immunization.occurrence | List.date | Observation.effective | Procedure.performed | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): Time period team covers\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When this Consent was created or indexed\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure was performed\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.context.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): Encounter created as part of\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("List:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.masterIdentifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Master Version Specific Identifier\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.patient | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject.where(resolve() is Patient) | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("List:patient").toLocked();

    public ListResource() {
    }

    public ListResource(ListStatus status, Enumerations.ListMode mode) {
        this.setStatus(status);
        this.setMode(mode);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ListResource setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ListResource addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ListStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ListStatus>(new ListStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ListResource setStatusElement(Enumeration<ListStatus> value) {
        this.status = value;
        return this;
    }

    public ListStatus getStatus() {
        return this.status == null ? null : (ListStatus)((Object)this.status.getValue());
    }

    public ListResource setStatus(ListStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ListStatus>(new ListStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.ListMode> getModeElement() {
        if (this.mode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.mode");
            }
            if (Configuration.doAutoCreate()) {
                this.mode = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
            }
        }
        return this.mode;
    }

    public boolean hasModeElement() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public boolean hasMode() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public ListResource setModeElement(Enumeration<Enumerations.ListMode> value) {
        this.mode = value;
        return this;
    }

    public Enumerations.ListMode getMode() {
        return this.mode == null ? null : (Enumerations.ListMode)((Object)this.mode.getValue());
    }

    public ListResource setMode(Enumerations.ListMode value) {
        if (this.mode == null) {
            this.mode = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
        }
        this.mode.setValue((Object)value);
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ListResource setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ListResource setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ListResource setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ListResource setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ListResource setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ListResource setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ListResource setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public ListResource setSource(Reference value) {
        this.source = value;
        return this;
    }

    public CodeableConcept getOrderedBy() {
        if (this.orderedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.orderedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.orderedBy = new CodeableConcept();
            }
        }
        return this.orderedBy;
    }

    public boolean hasOrderedBy() {
        return this.orderedBy != null && !this.orderedBy.isEmpty();
    }

    public ListResource setOrderedBy(CodeableConcept value) {
        this.orderedBy = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ListResource setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ListResource addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<ListResourceEntryComponent> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<ListResourceEntryComponent>();
        }
        return this.entry;
    }

    public ListResource setEntry(List<ListResourceEntryComponent> theEntry) {
        this.entry = theEntry;
        return this;
    }

    public boolean hasEntry() {
        if (this.entry == null) {
            return false;
        }
        for (ListResourceEntryComponent item : this.entry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ListResourceEntryComponent addEntry() {
        ListResourceEntryComponent t = new ListResourceEntryComponent();
        if (this.entry == null) {
            this.entry = new ArrayList<ListResourceEntryComponent>();
        }
        this.entry.add(t);
        return t;
    }

    public ListResource addEntry(ListResourceEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entry == null) {
            this.entry = new ArrayList<ListResourceEntryComponent>();
        }
        this.entry.add(t);
        return this;
    }

    public ListResourceEntryComponent getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public CodeableConcept getEmptyReason() {
        if (this.emptyReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.emptyReason");
            }
            if (Configuration.doAutoCreate()) {
                this.emptyReason = new CodeableConcept();
            }
        }
        return this.emptyReason;
    }

    public boolean hasEmptyReason() {
        return this.emptyReason != null && !this.emptyReason.isEmpty();
    }

    public ListResource setEmptyReason(CodeableConcept value) {
        this.emptyReason = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the List assigned for business purposes outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "Indicates the current state of this list.", 0, 1, this.status));
        children.add(new Property("mode", SP_CODE, "How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode));
        children.add(new Property(SP_TITLE, "string", "A label for the list assigned by the author.", 0, 1, this.title));
        children.add(new Property(SP_CODE, "CodeableConcept", "This code defines the purpose of the list - why it was created.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The common subject (or patient) of the resources that are in the list if there is one.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that is the context in which this list was created.", 0, 1, this.encounter));
        children.add(new Property(SP_DATE, "dateTime", "The date that the list was prepared.", 0, 1, this.date));
        children.add(new Property(SP_SOURCE, "Reference(Practitioner|PractitionerRole|Patient|Device)", "The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.", 0, 1, this.source));
        children.add(new Property("orderedBy", "CodeableConcept", "What order applies to the items in the list.", 0, 1, this.orderedBy));
        children.add(new Property("note", "Annotation", "Comments that apply to the overall list.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("entry", "", "Entries in this list.", 0, Integer.MAX_VALUE, this.entry));
        children.add(new Property("emptyReason", "CodeableConcept", "If the list is empty, why the list is empty.", 0, 1, this.emptyReason));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the List assigned for business purposes outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Indicates the current state of this list.", 0, 1, this.status);
            }
            case 0x3339A3: {
                return new Property("mode", SP_CODE, "How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A label for the list assigned by the author.", 0, 1, this.title);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "This code defines the purpose of the list - why it was created.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The common subject (or patient) of the resources that are in the list if there is one.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that is the context in which this list was created.", 0, 1, this.encounter);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date that the list was prepared.", 0, 1, this.date);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "Reference(Practitioner|PractitionerRole|Patient|Device)", "The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.", 0, 1, this.source);
            }
            case -391079516: {
                return new Property("orderedBy", "CodeableConcept", "What order applies to the items in the list.", 0, 1, this.orderedBy);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments that apply to the overall list.", 0, Integer.MAX_VALUE, this.note);
            }
            case 96667762: {
                return new Property("entry", "", "Entries in this list.", 0, Integer.MAX_VALUE, this.entry);
            }
            case 1140135409: {
                return new Property("emptyReason", "CodeableConcept", "If the list is empty, why the list is empty.", 0, 1, this.emptyReason);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 0x3339A3: {
                Base[] baseArray;
                if (this.mode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.mode;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.source;
                }
                return baseArray;
            }
            case -391079516: {
                Base[] baseArray;
                if (this.orderedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.orderedBy;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 96667762: {
                return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
            }
            case 1140135409: {
                Base[] baseArray;
                if (this.emptyReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.emptyReason;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ListStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 0x3339A3: {
                value = new Enumerations.ListModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToReference(value);
                return value;
            }
            case -391079516: {
                this.orderedBy = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 96667762: {
                this.getEntry().add((ListResourceEntryComponent)((Object)value));
                return value;
            }
            case 1140135409: {
                this.emptyReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ListStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("mode")) {
            value = new Enumerations.ListModeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.mode = value;
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = TypeConvertor.castToReference(value);
        } else if (name.equals("orderedBy")) {
            this.orderedBy = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("entry")) {
            this.getEntry().add((ListResourceEntryComponent)((Object)value));
        } else if (name.equals("emptyReason")) {
            this.emptyReason = TypeConvertor.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 0x3339A3: {
                return this.getModeElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -896505829: {
                return this.getSource();
            }
            case -391079516: {
                return this.getOrderedBy();
            }
            case 3387378: {
                return this.addNote();
            }
            case 96667762: {
                return this.addEntry();
            }
            case 1140135409: {
                return this.getEmptyReason();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 0x3339A3: {
                return new String[]{SP_CODE};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case -391079516: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 96667762: {
                return new String[0];
            }
            case 1140135409: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type List.status");
        }
        if (name.equals("mode")) {
            throw new FHIRException("Cannot call addChild on a primitive type List.mode");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type List.title");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type List.date");
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("orderedBy")) {
            this.orderedBy = new CodeableConcept();
            return this.orderedBy;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("entry")) {
            return this.addEntry();
        }
        if (name.equals("emptyReason")) {
            this.emptyReason = new CodeableConcept();
            return this.emptyReason;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "List";
    }

    @Override
    public ListResource copy() {
        ListResource dst = new ListResource();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ListResource dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.mode = this.mode == null ? null : this.mode.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.source = this.source == null ? null : this.source.copy();
        CodeableConcept codeableConcept = dst.orderedBy = this.orderedBy == null ? null : this.orderedBy.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.entry != null) {
            dst.entry = new ArrayList<ListResourceEntryComponent>();
            for (ListResourceEntryComponent listResourceEntryComponent : this.entry) {
                dst.entry.add(listResourceEntryComponent.copy());
            }
        }
        dst.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
    }

    protected ListResource typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ListResource)) {
            return false;
        }
        ListResource o = (ListResource)other_;
        return ListResource.compareDeep(this.identifier, o.identifier, true) && ListResource.compareDeep(this.status, o.status, true) && ListResource.compareDeep(this.mode, o.mode, true) && ListResource.compareDeep(this.title, o.title, true) && ListResource.compareDeep(this.code, o.code, true) && ListResource.compareDeep(this.subject, o.subject, true) && ListResource.compareDeep(this.encounter, o.encounter, true) && ListResource.compareDeep(this.date, o.date, true) && ListResource.compareDeep(this.source, o.source, true) && ListResource.compareDeep(this.orderedBy, o.orderedBy, true) && ListResource.compareDeep(this.note, o.note, true) && ListResource.compareDeep(this.entry, o.entry, true) && ListResource.compareDeep(this.emptyReason, o.emptyReason, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ListResource)) {
            return false;
        }
        ListResource o = (ListResource)other_;
        return ListResource.compareValues(this.status, o.status, true) && ListResource.compareValues(this.mode, o.mode, true) && ListResource.compareValues(this.title, o.title, true) && ListResource.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.mode, this.title, this.code, this.subject, this.encounter, this.date, this.source, this.orderedBy, this.note, this.entry, this.emptyReason});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.List;
    }

    @Block
    public static class ListResourceEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="flag", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Status/Workflow information about this item", formalDefinition="The flag allows the system constructing the list to indicate the role and significance of the item in the list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-item-flag")
        protected CodeableConcept flag;
        @Child(name="deleted", type={BooleanType.class}, order=2, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="If this item is actually marked as deleted", formalDefinition="True if this item is marked as deleted in the list.")
        protected BooleanType deleted;
        @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When item added to list", formalDefinition="When this item was added to the list.")
        protected DateTimeType date;
        @Child(name="item", type={Reference.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actual entry", formalDefinition="A reference to the actual resource from which data was derived.")
        protected Reference item;
        private static final long serialVersionUID = -872672029L;

        public ListResourceEntryComponent() {
        }

        public ListResourceEntryComponent(Reference item) {
            this.setItem(item);
        }

        public CodeableConcept getFlag() {
            if (this.flag == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListResourceEntryComponent.flag");
                }
                if (Configuration.doAutoCreate()) {
                    this.flag = new CodeableConcept();
                }
            }
            return this.flag;
        }

        public boolean hasFlag() {
            return this.flag != null && !this.flag.isEmpty();
        }

        public ListResourceEntryComponent setFlag(CodeableConcept value) {
            this.flag = value;
            return this;
        }

        public BooleanType getDeletedElement() {
            if (this.deleted == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListResourceEntryComponent.deleted");
                }
                if (Configuration.doAutoCreate()) {
                    this.deleted = new BooleanType();
                }
            }
            return this.deleted;
        }

        public boolean hasDeletedElement() {
            return this.deleted != null && !this.deleted.isEmpty();
        }

        public boolean hasDeleted() {
            return this.deleted != null && !this.deleted.isEmpty();
        }

        public ListResourceEntryComponent setDeletedElement(BooleanType value) {
            this.deleted = value;
            return this;
        }

        public boolean getDeleted() {
            return this.deleted == null || this.deleted.isEmpty() ? false : (Boolean)this.deleted.getValue();
        }

        public ListResourceEntryComponent setDeleted(boolean value) {
            if (this.deleted == null) {
                this.deleted = new BooleanType();
            }
            this.deleted.setValue((Object)value);
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListResourceEntryComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ListResourceEntryComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ListResourceEntryComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListResourceEntryComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new Reference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public ListResourceEntryComponent setItem(Reference value) {
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("flag", "CodeableConcept", "The flag allows the system constructing the list to indicate the role and significance of the item in the list.", 0, 1, this.flag));
            children.add(new Property("deleted", "boolean", "True if this item is marked as deleted in the list.", 0, 1, this.deleted));
            children.add(new Property(ListResource.SP_DATE, "dateTime", "When this item was added to the list.", 0, 1, this.date));
            children.add(new Property(ListResource.SP_ITEM, "Reference(Any)", "A reference to the actual resource from which data was derived.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3145580: {
                    return new Property("flag", "CodeableConcept", "The flag allows the system constructing the list to indicate the role and significance of the item in the list.", 0, 1, this.flag);
                }
                case 1550463001: {
                    return new Property("deleted", "boolean", "True if this item is marked as deleted in the list.", 0, 1, this.deleted);
                }
                case 3076014: {
                    return new Property(ListResource.SP_DATE, "dateTime", "When this item was added to the list.", 0, 1, this.date);
                }
                case 3242771: {
                    return new Property(ListResource.SP_ITEM, "Reference(Any)", "A reference to the actual resource from which data was derived.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    Base[] baseArray;
                    if (this.flag == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.flag;
                    }
                    return baseArray;
                }
                case 1550463001: {
                    Base[] baseArray;
                    if (this.deleted == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.deleted;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.date;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    this.flag = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1550463001: {
                    this.deleted = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 3242771: {
                    this.item = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("flag")) {
                this.flag = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("deleted")) {
                this.deleted = TypeConvertor.castToBoolean(value);
            } else if (name.equals(ListResource.SP_DATE)) {
                this.date = TypeConvertor.castToDateTime(value);
            } else if (name.equals(ListResource.SP_ITEM)) {
                this.item = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    return this.getFlag();
                }
                case 1550463001: {
                    return this.getDeletedElement();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    return new String[]{"CodeableConcept"};
                }
                case 1550463001: {
                    return new String[]{"boolean"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case 3242771: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("flag")) {
                this.flag = new CodeableConcept();
                return this.flag;
            }
            if (name.equals("deleted")) {
                throw new FHIRException("Cannot call addChild on a primitive type List.entry.deleted");
            }
            if (name.equals(ListResource.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type List.entry.date");
            }
            if (name.equals(ListResource.SP_ITEM)) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public ListResourceEntryComponent copy() {
            ListResourceEntryComponent dst = new ListResourceEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ListResourceEntryComponent dst) {
            super.copyValues(dst);
            dst.flag = this.flag == null ? null : this.flag.copy();
            dst.deleted = this.deleted == null ? null : this.deleted.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ListResourceEntryComponent)) {
                return false;
            }
            ListResourceEntryComponent o = (ListResourceEntryComponent)other_;
            return ListResourceEntryComponent.compareDeep(this.flag, o.flag, true) && ListResourceEntryComponent.compareDeep(this.deleted, o.deleted, true) && ListResourceEntryComponent.compareDeep(this.date, o.date, true) && ListResourceEntryComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ListResourceEntryComponent)) {
                return false;
            }
            ListResourceEntryComponent o = (ListResourceEntryComponent)other_;
            return ListResourceEntryComponent.compareValues(this.deleted, o.deleted, true) && ListResourceEntryComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.flag, this.deleted, this.date, this.item});
        }

        @Override
        public String fhirType() {
            return "List.entry";
        }
    }

    public static class ListStatusEnumFactory
    implements EnumFactory<ListStatus> {
        @Override
        public ListStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("current".equals(codeString)) {
                return ListStatus.CURRENT;
            }
            if ("retired".equals(codeString)) {
                return ListStatus.RETIRED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ListStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ListStatus code '" + codeString + "'");
        }

        public Enumeration<ListStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ListStatus>(this, ListStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.NULL, code);
            }
            if ("current".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.CURRENT, code);
            }
            if ("retired".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.RETIRED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown ListStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ListStatus code) {
            if (code == ListStatus.CURRENT) {
                return "current";
            }
            if (code == ListStatus.RETIRED) {
                return "retired";
            }
            if (code == ListStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ListStatus code) {
            return code.getSystem();
        }
    }

    public static enum ListStatus {
        CURRENT,
        RETIRED,
        ENTEREDINERROR,
        NULL;


        public static ListStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("current".equals(codeString)) {
                return CURRENT;
            }
            if ("retired".equals(codeString)) {
                return RETIRED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ListStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CURRENT: {
                    return "current";
                }
                case RETIRED: {
                    return "retired";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CURRENT: {
                    return "http://hl7.org/fhir/list-status";
                }
                case RETIRED: {
                    return "http://hl7.org/fhir/list-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/list-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CURRENT: {
                    return "The list is considered to be an active part of the patient's record.";
                }
                case RETIRED: {
                    return "The list is \"old\" and should no longer be considered accurate or relevant.";
                }
                case ENTEREDINERROR: {
                    return "The list was never accurate.  It is retained for medico-legal purposes only.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CURRENT: {
                    return "Current";
                }
                case RETIRED: {
                    return "Retired";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

