/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.ExpressionNode;
import org.hl7.fhir.r4b.model.Tuple;
import org.hl7.fhir.r4b.model.TypeDetails;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.utils.FHIRLexer;
import org.hl7.fhir.r4b.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class LiquidEngine
implements FHIRPathEngine.IEvaluationContext {
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private FHIRPathEngine engine;
    private ILiquidEngineIncludeResolver includeResolver;
    private ILiquidRenderingSupport renderingSupport;

    public LiquidEngine(IWorkerContext context, FHIRPathEngine.IEvaluationContext hostServices) {
        this.externalHostServices = hostServices;
        this.engine = new FHIRPathEngine(context);
        this.engine.setHostServices(this);
        this.engine.setLiquidMode(true);
    }

    public ILiquidEngineIncludeResolver getIncludeResolver() {
        return this.includeResolver;
    }

    public void setIncludeResolver(ILiquidEngineIncludeResolver includeResolver) {
        this.includeResolver = includeResolver;
    }

    public ILiquidRenderingSupport getRenderingSupport() {
        return this.renderingSupport;
    }

    public void setRenderingSupport(ILiquidRenderingSupport renderingSupport) {
        this.renderingSupport = renderingSupport;
    }

    public LiquidDocument parse(String source, String sourceName) throws FHIRException {
        return new LiquidParser(source).parse(sourceName);
    }

    public String evaluate(LiquidDocument document, Base resource, Object appContext) throws FHIRException {
        StringBuilder b = new StringBuilder();
        LiquidEngineContext ctxt = new LiquidEngineContext(appContext);
        for (LiquidNode n : document.body) {
            n.evaluate(b, resource, ctxt);
        }
        return b.toString();
    }

    @Override
    public List<Base> resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        if (ctxt.vars.containsKey(name)) {
            return new ArrayList<Base>(Arrays.asList(ctxt.vars.get(name)));
        }
        if (this.externalHostServices == null) {
            return new ArrayList<Base>();
        }
        return this.externalHostServices.resolveConstant(ctxt.externalContext, name, beforeContext);
    }

    @Override
    public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.resolveConstantType(ctxt.externalContext, name);
    }

    @Override
    public boolean log(String argument, List<Base> focus) {
        if (this.externalHostServices == null) {
            return false;
        }
        return this.externalHostServices.log(argument, focus);
    }

    @Override
    public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
        if (this.externalHostServices == null) {
            return null;
        }
        return this.externalHostServices.resolveFunction(functionName);
    }

    @Override
    public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.checkFunction(ctxt.externalContext, functionName, parameters);
    }

    @Override
    public List<Base> executeFunction(Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.executeFunction(ctxt.externalContext, focus, functionName, parameters);
    }

    @Override
    public Base resolveReference(Object appContext, String url, Base refContext) throws FHIRException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.resolveReference(ctxt.externalContext, url, refContext);
    }

    @Override
    public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
        if (this.externalHostServices == null) {
            return false;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.conformsToProfile(ctxt.externalContext, item, url);
    }

    @Override
    public ValueSet resolveValueSet(Object appContext, String url) {
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        if (this.externalHostServices != null) {
            return this.externalHostServices.resolveValueSet(ctxt.externalContext, url);
        }
        return this.engine.getWorker().fetchResource(ValueSet.class, url);
    }

    public boolean replaceInHtml(XhtmlNode node, Map<String, String> vars) {
        boolean replaced = false;
        if (node.getNodeType() == NodeType.Text || node.getNodeType() == NodeType.Comment) {
            String cnt = node.getContent();
            for (String n : vars.keySet()) {
                cnt = cnt.replace(n, vars.get(n));
            }
            if (!cnt.equals(node.getContent())) {
                node.setContent(cnt);
                replaced = true;
            }
        } else if (node.getNodeType() == NodeType.Element || node.getNodeType() == NodeType.Document) {
            for (XhtmlNode c : node.getChildNodes()) {
                if (!this.replaceInHtml(c, vars)) continue;
                replaced = true;
            }
            for (String an : node.getAttributes().keySet()) {
                String cnt = (String)node.getAttributes().get(an);
                for (String n : vars.keySet()) {
                    cnt = cnt.replace(n, vars.get(n));
                }
                if (cnt.equals(node.getAttributes().get(an))) continue;
                node.getAttributes().put(an, cnt);
                replaced = true;
            }
        }
        return replaced;
    }

    private class LiquidParser {
        private String source;
        private int cursor;
        private String name;

        public LiquidParser(String source) {
            this.source = source;
            this.cursor = 0;
        }

        private char next1() {
            if (this.cursor >= this.source.length()) {
                return '\u0000';
            }
            return this.source.charAt(this.cursor);
        }

        private char next2() {
            if (this.cursor >= this.source.length() - 1) {
                return '\u0000';
            }
            return this.source.charAt(this.cursor + 1);
        }

        private char grab() {
            ++this.cursor;
            return this.source.charAt(this.cursor - 1);
        }

        public LiquidDocument parse(String name) throws FHIRException {
            this.name = name;
            LiquidDocument doc = new LiquidDocument();
            this.parseList(doc.body, false, new String[0]);
            return doc;
        }

        public LiquidCycle parseCycle(String cnt) {
            LiquidCycle res = new LiquidCycle();
            cnt = "," + ((String)cnt).substring(5).trim();
            while (!Utilities.noString((String)cnt)) {
                int i;
                if (!((String)cnt).startsWith(",")) {
                    throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Found " + ((String)cnt).charAt(0) + " expecting ',' parsing cycle");
                }
                if (!((String)(cnt = ((String)cnt).substring(1).trim())).startsWith("\"")) {
                    throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Found " + ((String)cnt).charAt(0) + " expecting '\"' parsing cycle");
                }
                cnt = ((String)cnt).substring(1);
                for (i = 0; i < ((String)cnt).length() && ((String)cnt).charAt(i) != '\"'; ++i) {
                }
                if (i == ((String)cnt).length()) {
                    throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Found unterminated string parsing cycle");
                }
                res.list.add(((String)cnt).substring(0, i));
                cnt = ((String)cnt).substring(i + 1).trim();
            }
            return res;
        }

        private String parseList(List<LiquidNode> list, boolean inLoop, String[] terminators) throws FHIRException {
            String close = null;
            while (this.cursor < this.source.length()) {
                if (this.next1() == '{' && (this.next2() == '%' || this.next2() == '{')) {
                    if (this.next2() == '%') {
                        String cnt = this.parseTag('%');
                        if (this.isTerminator(cnt, terminators)) {
                            close = cnt;
                            break;
                        }
                        if (cnt.startsWith("if ")) {
                            list.add(this.parseIf(cnt, inLoop));
                            continue;
                        }
                        if (cnt.startsWith("loop ")) {
                            list.add(this.parseLoop(cnt.substring(4).trim()));
                            continue;
                        }
                        if (cnt.startsWith("for ")) {
                            list.add(this.parseFor(cnt.substring(3).trim()));
                            continue;
                        }
                        if (inLoop && cnt.equals("continue")) {
                            list.add(new LiquidContinue());
                            continue;
                        }
                        if (inLoop && cnt.equals("break")) {
                            list.add(new LiquidBreak());
                            continue;
                        }
                        if (inLoop && cnt.startsWith("cycle ")) {
                            list.add(this.parseCycle(cnt));
                            continue;
                        }
                        if (cnt.startsWith("include ")) {
                            list.add(this.parseInclude(cnt.substring(7).trim()));
                            continue;
                        }
                        throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Unknown flow control statement " + cnt);
                    }
                    list.add(this.parseStatement());
                    continue;
                }
                if (list.size() == 0 || !(list.get(list.size() - 1) instanceof LiquidConstant)) {
                    list.add(new LiquidConstant());
                }
                ((LiquidConstant)list.get(list.size() - 1)).addChar(this.grab());
            }
            for (LiquidNode n : list) {
                n.closeUp();
            }
            if (terminators.length > 0 && !this.isTerminator(close, terminators)) {
                throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Found end of script looking for " + terminators);
            }
            return close;
        }

        private boolean isTerminator(String cnt, String[] terminators) {
            if (Utilities.noString((String)cnt)) {
                return false;
            }
            for (String t : terminators) {
                if (!(t.endsWith(" ") ? cnt.startsWith(t) : cnt.equals(t))) continue;
                return true;
            }
            return false;
        }

        private LiquidNode parseIf(String cnt, boolean inLoop) throws FHIRException {
            LiquidIf res = new LiquidIf();
            res.condition = cnt.substring(3).trim();
            String term = this.parseList(res.thenBody, inLoop, new String[]{"else", "elsif ", "endif"});
            while (term.startsWith("elsif ")) {
                LiquidElsIf elsIf = new LiquidElsIf();
                res.elseIf.add(elsIf);
                elsIf.condition = term.substring(5).trim();
                term = this.parseList(elsIf.body, inLoop, new String[]{"elsif ", "else", "endif"});
            }
            if ("else".equals(term)) {
                term = this.parseList(res.elseBody, inLoop, new String[]{"endif"});
            }
            return res;
        }

        private LiquidNode parseInclude(String cnt) throws FHIRException {
            int i;
            for (i = 1; i < cnt.length() && !Character.isWhitespace(cnt.charAt(i)); ++i) {
            }
            if (i == cnt.length() || i == 0) {
                throw new FHIRException("Script " + this.name + ": Error reading include: " + cnt);
            }
            LiquidInclude res = new LiquidInclude();
            res.page = cnt.substring(0, i);
            while (i < cnt.length() && Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            while (i < cnt.length()) {
                int j = i;
                while (i < cnt.length() && cnt.charAt(i) != '=') {
                    ++i;
                }
                if (i >= cnt.length() || j == i) {
                    throw new FHIRException("Script " + this.name + ": Error reading include: " + cnt);
                }
                String n = cnt.substring(j, i);
                if (res.params.containsKey(n)) {
                    throw new FHIRException("Script " + this.name + ": Error reading include: " + cnt);
                }
                FHIRPathEngine.ExpressionNodeWithOffset t = LiquidEngine.this.engine.parsePartial(cnt, ++i);
                res.params.put(n, t.getNode());
                for (i = t.getOffset(); i < cnt.length() && Character.isWhitespace(cnt.charAt(i)); ++i) {
                }
            }
            return res;
        }

        private LiquidNode parseLoop(String cnt) throws FHIRException {
            int i = 0;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            LiquidFor res = new LiquidFor();
            res.varName = cnt.substring(0, i);
            while (Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            int j = i;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            if (!"in".equals(cnt.substring(j, i))) {
                throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Error reading loop: " + cnt);
            }
            res.condition = cnt.substring(i).trim();
            this.parseList(res.body, false, new String[]{"endloop"});
            return res;
        }

        private LiquidNode parseFor(String cnt) throws FHIRException {
            int i = 0;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            LiquidFor res = new LiquidFor();
            res.varName = cnt.substring(0, i);
            while (Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            int j = i;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            if (!"in".equals(cnt.substring(j, i))) {
                throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Error reading loop: " + cnt);
            }
            res.condition = cnt.substring(i).trim();
            String term = this.parseList(res.body, true, new String[]{"endfor", "else"});
            if ("else".equals(term)) {
                this.parseList(res.elseBody, false, new String[]{"endfor"});
            }
            return res;
        }

        private String parseTag(char ch) throws FHIRException {
            this.grab();
            this.grab();
            StringBuilder b = new StringBuilder();
            while (this.cursor < this.source.length() && (this.next1() != '%' || this.next2() != '}')) {
                b.append(this.grab());
            }
            if (this.next1() != '%' || this.next2() != '}') {
                throw new FHIRException("Script " + this.name + ": Unterminated Liquid statement {% " + b.toString());
            }
            this.grab();
            this.grab();
            return b.toString().trim();
        }

        private LiquidStatement parseStatement() throws FHIRException {
            this.grab();
            this.grab();
            StringBuilder b = new StringBuilder();
            while (this.cursor < this.source.length() && (this.next1() != '}' || this.next2() != '}')) {
                b.append(this.grab());
            }
            if (this.next1() != '}' || this.next2() != '}') {
                throw new FHIRException("Script " + this.name + ": Unterminated Liquid statement {{ " + b.toString());
            }
            this.grab();
            this.grab();
            LiquidStatement res = new LiquidStatement();
            res.statement = b.toString().trim();
            return res;
        }
    }

    public static class LiquidDocument {
        private List<LiquidNode> body = new ArrayList<LiquidNode>();
    }

    private class LiquidInclude
    extends LiquidNode {
        private String page;
        private Map<String, ExpressionNode> params;

        private LiquidInclude() {
            this.params = new HashMap<String, ExpressionNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            String src = LiquidEngine.this.includeResolver.fetchInclude(LiquidEngine.this, this.page);
            LiquidParser parser = new LiquidParser(src);
            LiquidDocument doc = parser.parse(this.page);
            LiquidEngineContext nctxt = new LiquidEngineContext(ctxt.externalContext);
            Tuple incl = new Tuple();
            nctxt.vars.put("include", incl);
            for (String s : this.params.keySet()) {
                incl.addProperty(s, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, this.params.get(s)));
            }
            for (LiquidNode n : doc.body) {
                n.evaluate(b, resource, nctxt);
            }
        }
    }

    private class LiquidFor
    extends LiquidNode {
        private String varName;
        private String condition;
        private ExpressionNode compiled;
        private boolean reversed;
        private int limit;
        private int offset;
        private List<LiquidNode> body;
        private List<LiquidNode> elseBody;

        private LiquidFor() {
            this.reversed = false;
            this.limit = -1;
            this.offset = -1;
            this.body = new ArrayList<LiquidNode>();
            this.elseBody = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled == null) {
                FHIRPathEngine.ExpressionNodeWithOffset po = LiquidEngine.this.engine.parsePartial(this.condition, 0);
                this.compiled = po.getNode();
                if (po.getOffset() < this.condition.length()) {
                    this.parseModifiers(this.condition.substring(po.getOffset()));
                }
            }
            List<Base> list = LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, this.compiled);
            LiquidEngineContext lctxt = new LiquidEngineContext(ctxt);
            if (list.isEmpty()) {
                for (LiquidNode n : this.elseBody) {
                    n.evaluate(b, resource, lctxt);
                }
            } else {
                if (this.reversed) {
                    Collections.reverse(list);
                }
                int i = 0;
                for (Base o : list) {
                    if (this.offset >= 0 && i < this.offset) {
                        ++i;
                        continue;
                    }
                    if (this.limit >= 0 && i == this.limit) break;
                    lctxt.vars.put(this.varName, o);
                    boolean wantBreak = false;
                    for (LiquidNode n : this.body) {
                        try {
                            n.evaluate(b, resource, lctxt);
                        }
                        catch (LiquidContinueExecuted e) {
                            break;
                        }
                        catch (LiquidBreakExecuted e) {
                            wantBreak = true;
                            break;
                        }
                    }
                    if (!wantBreak) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }

        private void parseModifiers(String cnt) {
            String src = cnt;
            while (!Utilities.noString((String)cnt)) {
                int i;
                if (cnt.startsWith("reversed")) {
                    this.reversed = true;
                    cnt = cnt.substring(8);
                    continue;
                }
                if (cnt.startsWith("limit")) {
                    if (!(cnt = cnt.substring(5).trim()).startsWith(":")) {
                        throw new FHIRException("Exception evaluating " + src + ": limit is not followed by ':'");
                    }
                    cnt = cnt.substring(1).trim();
                    for (i = 0; i < cnt.length() && Character.isDigit(cnt.charAt(i)); ++i) {
                    }
                    if (i == 0) {
                        throw new FHIRException("Exception evaluating " + src + ": limit is not followed by a number");
                    }
                    this.limit = Integer.parseInt(cnt.substring(0, i));
                    cnt = cnt.substring(i);
                    continue;
                }
                if (cnt.startsWith("offset")) {
                    if (!(cnt = cnt.substring(6).trim()).startsWith(":")) {
                        throw new FHIRException("Exception evaluating " + src + ": limit is not followed by ':'");
                    }
                    cnt = cnt.substring(1).trim();
                    for (i = 0; i < cnt.length() && Character.isDigit(cnt.charAt(i)); ++i) {
                    }
                    if (i == 0) {
                        throw new FHIRException("Exception evaluating " + src + ": limit is not followed by a number");
                    }
                    this.offset = Integer.parseInt(cnt.substring(0, i));
                    cnt = cnt.substring(i);
                    continue;
                }
                throw new FHIRException("Exception evaluating " + src + ": unexpected content at " + cnt);
            }
        }
    }

    private class LiquidCycle
    extends LiquidNode {
        private List<String> list;
        private int cursor;

        private LiquidCycle() {
            this.list = new ArrayList<String>();
            this.cursor = 0;
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            b.append(this.list.get(this.cursor));
            ++this.cursor;
            if (this.cursor == this.list.size()) {
                this.cursor = 0;
            }
        }
    }

    private class LiquidBreak
    extends LiquidNode {
        private LiquidBreak() {
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            throw new LiquidBreakExecuted();
        }
    }

    private class LiquidBreakExecuted
    extends FHIRException {
        private static final long serialVersionUID = 6328496371172871082L;

        private LiquidBreakExecuted() {
        }
    }

    private class LiquidContinue
    extends LiquidNode {
        private LiquidContinue() {
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            throw new LiquidContinueExecuted();
        }
    }

    private class LiquidContinueExecuted
    extends FHIRException {
        private static final long serialVersionUID = 4748737094188943721L;

        private LiquidContinueExecuted() {
        }
    }

    private class LiquidIf
    extends LiquidNode {
        private String condition;
        private ExpressionNode compiled;
        private List<LiquidNode> thenBody;
        private List<LiquidElsIf> elseIf;
        private List<LiquidNode> elseBody;

        private LiquidIf() {
            this.thenBody = new ArrayList<LiquidNode>();
            this.elseIf = new ArrayList<LiquidElsIf>();
            this.elseBody = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled == null) {
                this.compiled = LiquidEngine.this.engine.parse(this.condition);
            }
            boolean ok = LiquidEngine.this.engine.evaluateToBoolean((Object)ctxt, resource, resource, resource, this.compiled);
            List<LiquidNode> list = null;
            if (ok) {
                list = this.thenBody;
            } else {
                list = this.elseBody;
                for (LiquidElsIf i : this.elseIf) {
                    if (i.compiled == null) {
                        i.compiled = LiquidEngine.this.engine.parse(i.condition);
                    }
                    if (!(ok = LiquidEngine.this.engine.evaluateToBoolean((Object)ctxt, resource, resource, resource, i.compiled))) continue;
                    list = i.body;
                    break;
                }
            }
            for (LiquidNode n : list) {
                n.evaluate(b, resource, ctxt);
            }
        }
    }

    private class LiquidElsIf
    extends LiquidNode {
        private String condition;
        private ExpressionNode compiled;
        private List<LiquidNode> body;

        private LiquidElsIf() {
            this.body = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            for (LiquidNode n : this.body) {
                n.evaluate(b, resource, ctxt);
            }
        }
    }

    private class LiquidStatement
    extends LiquidNode {
        private String statement;
        private List<LiquidExpressionNode> compiled;

        private LiquidStatement() {
            this.compiled = new ArrayList<LiquidExpressionNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled.size() == 0) {
                FHIRLexer lexer = new FHIRLexer(this.statement, "liquid statement");
                lexer.setLiquidMode(true);
                this.compiled.add(new LiquidExpressionNode(null, LiquidEngine.this.engine.parse(lexer)));
                while (!lexer.done()) {
                    if (lexer.getCurrent().equals("||")) {
                        lexer.next();
                        String f = lexer.getCurrent();
                        LiquidFilter filter = LiquidFilter.fromCode(f);
                        if (filter == null) {
                            lexer.error("Unknown Liquid filter '" + f + "'");
                        }
                        lexer.next();
                        if (!lexer.done() && lexer.getCurrent().equals(":")) {
                            lexer.next();
                            this.compiled.add(new LiquidExpressionNode(filter, LiquidEngine.this.engine.parse(lexer)));
                            continue;
                        }
                        this.compiled.add(new LiquidExpressionNode(filter, null));
                        continue;
                    }
                    lexer.error("Unexpected syntax parsing liquid statement");
                }
            }
            Object t = null;
            for (LiquidExpressionNode i : this.compiled) {
                if (i.filter == null) {
                    t = this.stmtToString(ctxt, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, i.expression));
                    continue;
                }
                switch (i.filter) {
                    case PREPEND: {
                        t = this.stmtToString(ctxt, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, i.expression)) + (String)t;
                    }
                }
            }
            b.append((String)t);
        }

        private String stmtToString(LiquidEngineContext ctxt, List<Base> items) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (Base i : items) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                String s = LiquidEngine.this.renderingSupport != null ? LiquidEngine.this.renderingSupport.renderForLiquid(ctxt.externalContext, i) : null;
                b.append(s != null ? s : LiquidEngine.this.engine.convertToString(i));
            }
            return b.toString();
        }
    }

    private class LiquidExpressionNode {
        private LiquidFilter filter;
        private ExpressionNode expression;

        public LiquidExpressionNode(LiquidFilter filter, ExpressionNode expression) {
            this.filter = filter;
            this.expression = expression;
        }
    }

    private static enum LiquidFilter {
        PREPEND;


        public static LiquidFilter fromCode(String code) {
            if ("prepend".equals(code)) {
                return PREPEND;
            }
            return null;
        }
    }

    private class LiquidConstant
    extends LiquidNode {
        private String constant;
        private StringBuilder b;

        private LiquidConstant() {
            this.b = new StringBuilder();
        }

        @Override
        protected void closeUp() {
            this.constant = this.b.toString();
            this.b = null;
        }

        public void addChar(char ch) {
            this.b.append(ch);
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) {
            b.append(this.constant);
        }
    }

    private abstract class LiquidNode {
        private LiquidNode() {
        }

        protected void closeUp() {
        }

        public abstract void evaluate(StringBuilder var1, Base var2, LiquidEngineContext var3) throws FHIRException;
    }

    private class LiquidEngineContext {
        private Object externalContext;
        private Map<String, Base> vars = new HashMap<String, Base>();

        public LiquidEngineContext(Object externalContext) {
            this.externalContext = externalContext;
        }

        public LiquidEngineContext(LiquidEngineContext existing) {
            this.externalContext = existing.externalContext;
            this.vars.putAll(existing.vars);
        }
    }

    public static interface ILiquidEngineIncludeResolver {
        public String fetchInclude(LiquidEngine var1, String var2);
    }

    public static interface ILiquidRenderingSupport {
        public String renderForLiquid(Object var1, Base var2) throws FHIRException;
    }
}

