/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.Money;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PositiveIntType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/StructureDefinition/Coverage")
public class Coverage
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for the coverage", formalDefinition="A unique identifier assigned to this coverage.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<Enumerations.FinancialResourceStatusCodes> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage category such as medical or accident", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-type")
    protected CodeableConcept type;
    @Child(name="policyHolder", type={Patient.class, RelatedPerson.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Owner of the policy", formalDefinition="The party who 'owns' the insurance policy.")
    protected Reference policyHolder;
    @Child(name="subscriber", type={Patient.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subscriber to the policy", formalDefinition="The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.")
    protected Reference subscriber;
    @Child(name="subscriberId", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ID assigned to the subscriber", formalDefinition="The insurer assigned ID for the Subscriber.")
    protected StringType subscriberId;
    @Child(name="beneficiary", type={Patient.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Plan beneficiary", formalDefinition="The party who benefits from the insurance coverage; the patient when products and/or services are provided.")
    protected Reference beneficiary;
    @Child(name="dependent", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dependent number", formalDefinition="A unique identifier for a dependent under the coverage.")
    protected StringType dependent;
    @Child(name="relationship", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Beneficiary relationship to the subscriber", formalDefinition="The relationship of beneficiary (patient) to the subscriber.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriber-relationship")
    protected CodeableConcept relationship;
    @Child(name="period", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    protected Period period;
    @Child(name="payor", type={Organization.class, Patient.class, RelatedPerson.class}, order=10, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Issuer of the policy", formalDefinition="The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements.")
    protected List<Reference> payor;
    @Child(name="class", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional coverage classifications", formalDefinition="A suite of underwriter specific classifiers.")
    protected List<ClassComponent> class_;
    @Child(name="order", type={PositiveIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relative order of the coverage", formalDefinition="The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care.")
    protected PositiveIntType order;
    @Child(name="network", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer network", formalDefinition="The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.")
    protected StringType network;
    @Child(name="costToBeneficiary", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient payments for services/products", formalDefinition="A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been  included on the health card.")
    protected List<CostToBeneficiaryComponent> costToBeneficiary;
    @Child(name="subrogation", type={BooleanType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reimbursement to insurer", formalDefinition="When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.")
    protected BooleanType subrogation;
    @Child(name="contract", type={Contract.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract details", formalDefinition="The policy(s) which constitute this insurance coverage.")
    protected List<Reference> contract;
    private static final long serialVersionUID = -1520724464L;
    @SearchParamDefinition(name="beneficiary", path="Coverage.beneficiary", description="Covered party", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_BENEFICIARY = "beneficiary";
    public static final ReferenceClientParam BENEFICIARY = new ReferenceClientParam("beneficiary");
    public static final Include INCLUDE_BENEFICIARY = new Include("Coverage:beneficiary").toLocked();
    @SearchParamDefinition(name="class-type", path="Coverage.class.type", description="Coverage class (eg. plan, group)", type="token")
    public static final String SP_CLASS_TYPE = "class-type";
    public static final TokenClientParam CLASS_TYPE = new TokenClientParam("class-type");
    @SearchParamDefinition(name="class-value", path="Coverage.class.value", description="Value of the class (eg. Plan number, group number)", type="string")
    public static final String SP_CLASS_VALUE = "class-value";
    public static final StringClientParam CLASS_VALUE = new StringClientParam("class-value");
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="string")
    public static final String SP_DEPENDENT = "dependent";
    public static final StringClientParam DEPENDENT = new StringClientParam("dependent");
    @SearchParamDefinition(name="identifier", path="Coverage.identifier", description="The primary identifier of the insured and the coverage", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Coverage.beneficiary", description="Retrieve coverages for a patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Coverage:patient").toLocked();
    @SearchParamDefinition(name="payor", path="Coverage.payor", description="The identity of the insurer or party paying for services", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_PAYOR = "payor";
    public static final ReferenceClientParam PAYOR = new ReferenceClientParam("payor");
    public static final Include INCLUDE_PAYOR = new Include("Coverage:payor").toLocked();
    @SearchParamDefinition(name="policy-holder", path="Coverage.policyHolder", description="Reference to the policyholder", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_POLICY_HOLDER = "policy-holder";
    public static final ReferenceClientParam POLICY_HOLDER = new ReferenceClientParam("policy-holder");
    public static final Include INCLUDE_POLICY_HOLDER = new Include("Coverage:policy-holder").toLocked();
    @SearchParamDefinition(name="status", path="Coverage.status", description="The status of the Coverage", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subscriber", path="Coverage.subscriber", description="Reference to the subscriber", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Patient.class, RelatedPerson.class})
    public static final String SP_SUBSCRIBER = "subscriber";
    public static final ReferenceClientParam SUBSCRIBER = new ReferenceClientParam("subscriber");
    public static final Include INCLUDE_SUBSCRIBER = new Include("Coverage:subscriber").toLocked();
    @SearchParamDefinition(name="type", path="Coverage.type", description="The kind of coverage (health plan, auto, Workers Compensation)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Coverage() {
    }

    public Coverage(Enumerations.FinancialResourceStatusCodes status, Reference beneficiary, Reference payor) {
        this.setStatus(status);
        this.setBeneficiary(beneficiary);
        this.addPayor(payor);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coverage setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Coverage addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.FinancialResourceStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Coverage setStatusElement(Enumeration<Enumerations.FinancialResourceStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.FinancialResourceStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.FinancialResourceStatusCodes)((Object)this.status.getValue());
    }

    public Coverage setStatus(Enumerations.FinancialResourceStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Coverage setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getPolicyHolder() {
        if (this.policyHolder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.policyHolder");
            }
            if (Configuration.doAutoCreate()) {
                this.policyHolder = new Reference();
            }
        }
        return this.policyHolder;
    }

    public boolean hasPolicyHolder() {
        return this.policyHolder != null && !this.policyHolder.isEmpty();
    }

    public Coverage setPolicyHolder(Reference value) {
        this.policyHolder = value;
        return this;
    }

    public Reference getSubscriber() {
        if (this.subscriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriber");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriber = new Reference();
            }
        }
        return this.subscriber;
    }

    public boolean hasSubscriber() {
        return this.subscriber != null && !this.subscriber.isEmpty();
    }

    public Coverage setSubscriber(Reference value) {
        this.subscriber = value;
        return this;
    }

    public StringType getSubscriberIdElement() {
        if (this.subscriberId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriberId");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriberId = new StringType();
            }
        }
        return this.subscriberId;
    }

    public boolean hasSubscriberIdElement() {
        return this.subscriberId != null && !this.subscriberId.isEmpty();
    }

    public boolean hasSubscriberId() {
        return this.subscriberId != null && !this.subscriberId.isEmpty();
    }

    public Coverage setSubscriberIdElement(StringType value) {
        this.subscriberId = value;
        return this;
    }

    public String getSubscriberId() {
        return this.subscriberId == null ? null : (String)this.subscriberId.getValue();
    }

    public Coverage setSubscriberId(String value) {
        if (Utilities.noString((String)value)) {
            this.subscriberId = null;
        } else {
            if (this.subscriberId == null) {
                this.subscriberId = new StringType();
            }
            this.subscriberId.setValue(value);
        }
        return this;
    }

    public Reference getBeneficiary() {
        if (this.beneficiary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.beneficiary");
            }
            if (Configuration.doAutoCreate()) {
                this.beneficiary = new Reference();
            }
        }
        return this.beneficiary;
    }

    public boolean hasBeneficiary() {
        return this.beneficiary != null && !this.beneficiary.isEmpty();
    }

    public Coverage setBeneficiary(Reference value) {
        this.beneficiary = value;
        return this;
    }

    public StringType getDependentElement() {
        if (this.dependent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.dependent");
            }
            if (Configuration.doAutoCreate()) {
                this.dependent = new StringType();
            }
        }
        return this.dependent;
    }

    public boolean hasDependentElement() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public boolean hasDependent() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public Coverage setDependentElement(StringType value) {
        this.dependent = value;
        return this;
    }

    public String getDependent() {
        return this.dependent == null ? null : (String)this.dependent.getValue();
    }

    public Coverage setDependent(String value) {
        if (Utilities.noString((String)value)) {
            this.dependent = null;
        } else {
            if (this.dependent == null) {
                this.dependent = new StringType();
            }
            this.dependent.setValue(value);
        }
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public Coverage setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Coverage setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getPayor() {
        if (this.payor == null) {
            this.payor = new ArrayList<Reference>();
        }
        return this.payor;
    }

    public Coverage setPayor(List<Reference> thePayor) {
        this.payor = thePayor;
        return this;
    }

    public boolean hasPayor() {
        if (this.payor == null) {
            return false;
        }
        for (Reference item : this.payor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPayor() {
        Reference t = new Reference();
        if (this.payor == null) {
            this.payor = new ArrayList<Reference>();
        }
        this.payor.add(t);
        return t;
    }

    public Coverage addPayor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.payor == null) {
            this.payor = new ArrayList<Reference>();
        }
        this.payor.add(t);
        return this;
    }

    public Reference getPayorFirstRep() {
        if (this.getPayor().isEmpty()) {
            this.addPayor();
        }
        return this.getPayor().get(0);
    }

    public List<ClassComponent> getClass_() {
        if (this.class_ == null) {
            this.class_ = new ArrayList<ClassComponent>();
        }
        return this.class_;
    }

    public Coverage setClass_(List<ClassComponent> theClass_) {
        this.class_ = theClass_;
        return this;
    }

    public boolean hasClass_() {
        if (this.class_ == null) {
            return false;
        }
        for (ClassComponent item : this.class_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClassComponent addClass_() {
        ClassComponent t = new ClassComponent();
        if (this.class_ == null) {
            this.class_ = new ArrayList<ClassComponent>();
        }
        this.class_.add(t);
        return t;
    }

    public Coverage addClass_(ClassComponent t) {
        if (t == null) {
            return this;
        }
        if (this.class_ == null) {
            this.class_ = new ArrayList<ClassComponent>();
        }
        this.class_.add(t);
        return this;
    }

    public ClassComponent getClass_FirstRep() {
        if (this.getClass_().isEmpty()) {
            this.addClass_();
        }
        return this.getClass_().get(0);
    }

    public PositiveIntType getOrderElement() {
        if (this.order == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.order");
            }
            if (Configuration.doAutoCreate()) {
                this.order = new PositiveIntType();
            }
        }
        return this.order;
    }

    public boolean hasOrderElement() {
        return this.order != null && !this.order.isEmpty();
    }

    public boolean hasOrder() {
        return this.order != null && !this.order.isEmpty();
    }

    public Coverage setOrderElement(PositiveIntType value) {
        this.order = value;
        return this;
    }

    public int getOrder() {
        return this.order == null || this.order.isEmpty() ? 0 : (Integer)this.order.getValue();
    }

    public Coverage setOrder(int value) {
        if (this.order == null) {
            this.order = new PositiveIntType();
        }
        this.order.setValue((Object)value);
        return this;
    }

    public StringType getNetworkElement() {
        if (this.network == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.network");
            }
            if (Configuration.doAutoCreate()) {
                this.network = new StringType();
            }
        }
        return this.network;
    }

    public boolean hasNetworkElement() {
        return this.network != null && !this.network.isEmpty();
    }

    public boolean hasNetwork() {
        return this.network != null && !this.network.isEmpty();
    }

    public Coverage setNetworkElement(StringType value) {
        this.network = value;
        return this;
    }

    public String getNetwork() {
        return this.network == null ? null : (String)this.network.getValue();
    }

    public Coverage setNetwork(String value) {
        if (Utilities.noString((String)value)) {
            this.network = null;
        } else {
            if (this.network == null) {
                this.network = new StringType();
            }
            this.network.setValue(value);
        }
        return this;
    }

    public List<CostToBeneficiaryComponent> getCostToBeneficiary() {
        if (this.costToBeneficiary == null) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
        }
        return this.costToBeneficiary;
    }

    public Coverage setCostToBeneficiary(List<CostToBeneficiaryComponent> theCostToBeneficiary) {
        this.costToBeneficiary = theCostToBeneficiary;
        return this;
    }

    public boolean hasCostToBeneficiary() {
        if (this.costToBeneficiary == null) {
            return false;
        }
        for (CostToBeneficiaryComponent item : this.costToBeneficiary) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CostToBeneficiaryComponent addCostToBeneficiary() {
        CostToBeneficiaryComponent t = new CostToBeneficiaryComponent();
        if (this.costToBeneficiary == null) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
        }
        this.costToBeneficiary.add(t);
        return t;
    }

    public Coverage addCostToBeneficiary(CostToBeneficiaryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.costToBeneficiary == null) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
        }
        this.costToBeneficiary.add(t);
        return this;
    }

    public CostToBeneficiaryComponent getCostToBeneficiaryFirstRep() {
        if (this.getCostToBeneficiary().isEmpty()) {
            this.addCostToBeneficiary();
        }
        return this.getCostToBeneficiary().get(0);
    }

    public BooleanType getSubrogationElement() {
        if (this.subrogation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subrogation");
            }
            if (Configuration.doAutoCreate()) {
                this.subrogation = new BooleanType();
            }
        }
        return this.subrogation;
    }

    public boolean hasSubrogationElement() {
        return this.subrogation != null && !this.subrogation.isEmpty();
    }

    public boolean hasSubrogation() {
        return this.subrogation != null && !this.subrogation.isEmpty();
    }

    public Coverage setSubrogationElement(BooleanType value) {
        this.subrogation = value;
        return this;
    }

    public boolean getSubrogation() {
        return this.subrogation == null || this.subrogation.isEmpty() ? false : (Boolean)this.subrogation.getValue();
    }

    public Coverage setSubrogation(boolean value) {
        if (this.subrogation == null) {
            this.subrogation = new BooleanType();
        }
        this.subrogation.setValue((Object)value);
        return this;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public Coverage setContract(List<Reference> theContract) {
        this.contract = theContract;
        return this;
    }

    public boolean hasContract() {
        if (this.contract == null) {
            return false;
        }
        for (Reference item : this.contract) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContract() {
        Reference t = new Reference();
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return t;
    }

    public Coverage addContract(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return this;
    }

    public Reference getContractFirstRep() {
        if (this.getContract().isEmpty()) {
            this.addContract();
        }
        return this.getContract().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this coverage.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.", 0, 1, this.type));
        children.add(new Property("policyHolder", "Reference(Patient|RelatedPerson|Organization)", "The party who 'owns' the insurance policy.", 0, 1, this.policyHolder));
        children.add(new Property(SP_SUBSCRIBER, "Reference(Patient|RelatedPerson)", "The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.", 0, 1, this.subscriber));
        children.add(new Property("subscriberId", "string", "The insurer assigned ID for the Subscriber.", 0, 1, this.subscriberId));
        children.add(new Property(SP_BENEFICIARY, "Reference(Patient)", "The party who benefits from the insurance coverage; the patient when products and/or services are provided.", 0, 1, this.beneficiary));
        children.add(new Property(SP_DEPENDENT, "string", "A unique identifier for a dependent under the coverage.", 0, 1, this.dependent));
        children.add(new Property("relationship", "CodeableConcept", "The relationship of beneficiary (patient) to the subscriber.", 0, 1, this.relationship));
        children.add(new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, 1, this.period));
        children.add(new Property(SP_PAYOR, "Reference(Organization|Patient|RelatedPerson)", "The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements.", 0, Integer.MAX_VALUE, this.payor));
        children.add(new Property("class", "", "A suite of underwriter specific classifiers.", 0, Integer.MAX_VALUE, this.class_));
        children.add(new Property("order", "positiveInt", "The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care.", 0, 1, this.order));
        children.add(new Property("network", "string", "The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.", 0, 1, this.network));
        children.add(new Property("costToBeneficiary", "", "A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been  included on the health card.", 0, Integer.MAX_VALUE, this.costToBeneficiary));
        children.add(new Property("subrogation", "boolean", "When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.", 0, 1, this.subrogation));
        children.add(new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this coverage.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.", 0, 1, this.type);
            }
            case 2046898558: {
                return new Property("policyHolder", "Reference(Patient|RelatedPerson|Organization)", "The party who 'owns' the insurance policy.", 0, 1, this.policyHolder);
            }
            case -1219769240: {
                return new Property(SP_SUBSCRIBER, "Reference(Patient|RelatedPerson)", "The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.", 0, 1, this.subscriber);
            }
            case 327834531: {
                return new Property("subscriberId", "string", "The insurer assigned ID for the Subscriber.", 0, 1, this.subscriberId);
            }
            case -565102875: {
                return new Property(SP_BENEFICIARY, "Reference(Patient)", "The party who benefits from the insurance coverage; the patient when products and/or services are provided.", 0, 1, this.beneficiary);
            }
            case -1109226753: {
                return new Property(SP_DEPENDENT, "string", "A unique identifier for a dependent under the coverage.", 0, 1, this.dependent);
            }
            case -261851592: {
                return new Property("relationship", "CodeableConcept", "The relationship of beneficiary (patient) to the subscriber.", 0, 1, this.relationship);
            }
            case -991726143: {
                return new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, 1, this.period);
            }
            case 106443915: {
                return new Property(SP_PAYOR, "Reference(Organization|Patient|RelatedPerson)", "The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements.", 0, Integer.MAX_VALUE, this.payor);
            }
            case 94742904: {
                return new Property("class", "", "A suite of underwriter specific classifiers.", 0, Integer.MAX_VALUE, this.class_);
            }
            case 106006350: {
                return new Property("order", "positiveInt", "The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care.", 0, 1, this.order);
            }
            case 1843485230: {
                return new Property("network", "string", "The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.", 0, 1, this.network);
            }
            case -1866474851: {
                return new Property("costToBeneficiary", "", "A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been  included on the health card.", 0, Integer.MAX_VALUE, this.costToBeneficiary);
            }
            case 837389739: {
                return new Property("subrogation", "boolean", "When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.", 0, 1, this.subrogation);
            }
            case -566947566: {
                return new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 2046898558: {
                Base[] baseArray;
                if (this.policyHolder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.policyHolder;
                }
                return baseArray;
            }
            case -1219769240: {
                Base[] baseArray;
                if (this.subscriber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subscriber;
                }
                return baseArray;
            }
            case 327834531: {
                Base[] baseArray;
                if (this.subscriberId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subscriberId;
                }
                return baseArray;
            }
            case -565102875: {
                Base[] baseArray;
                if (this.beneficiary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.beneficiary;
                }
                return baseArray;
            }
            case -1109226753: {
                Base[] baseArray;
                if (this.dependent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.dependent;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.relationship;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.period;
                }
                return baseArray;
            }
            case 106443915: {
                return this.payor == null ? new Base[]{} : this.payor.toArray(new Base[this.payor.size()]);
            }
            case 94742904: {
                return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
            }
            case 106006350: {
                Base[] baseArray;
                if (this.order == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.order;
                }
                return baseArray;
            }
            case 1843485230: {
                Base[] baseArray;
                if (this.network == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.network;
                }
                return baseArray;
            }
            case -1866474851: {
                return this.costToBeneficiary == null ? new Base[]{} : this.costToBeneficiary.toArray(new Base[this.costToBeneficiary.size()]);
            }
            case 837389739: {
                Base[] baseArray;
                if (this.subrogation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.subrogation;
                }
                return baseArray;
            }
            case -566947566: {
                return this.contract == null ? new Base[]{} : this.contract.toArray(new Base[this.contract.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 2046898558: {
                this.policyHolder = TypeConvertor.castToReference(value);
                return value;
            }
            case -1219769240: {
                this.subscriber = TypeConvertor.castToReference(value);
                return value;
            }
            case 327834531: {
                this.subscriberId = TypeConvertor.castToString(value);
                return value;
            }
            case -565102875: {
                this.beneficiary = TypeConvertor.castToReference(value);
                return value;
            }
            case -1109226753: {
                this.dependent = TypeConvertor.castToString(value);
                return value;
            }
            case -261851592: {
                this.relationship = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 106443915: {
                this.getPayor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 94742904: {
                this.getClass_().add((ClassComponent)((Object)value));
                return value;
            }
            case 106006350: {
                this.order = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 1843485230: {
                this.network = TypeConvertor.castToString(value);
                return value;
            }
            case -1866474851: {
                this.getCostToBeneficiary().add((CostToBeneficiaryComponent)((Object)value));
                return value;
            }
            case 837389739: {
                this.subrogation = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -566947566: {
                this.getContract().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("policyHolder")) {
            this.policyHolder = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = TypeConvertor.castToReference(value);
        } else if (name.equals("subscriberId")) {
            this.subscriberId = TypeConvertor.castToString(value);
        } else if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEPENDENT)) {
            this.dependent = TypeConvertor.castToString(value);
        } else if (name.equals("relationship")) {
            this.relationship = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_PAYOR)) {
            this.getPayor().add(TypeConvertor.castToReference(value));
        } else if (name.equals("class")) {
            this.getClass_().add((ClassComponent)((Object)value));
        } else if (name.equals("order")) {
            this.order = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("network")) {
            this.network = TypeConvertor.castToString(value);
        } else if (name.equals("costToBeneficiary")) {
            this.getCostToBeneficiary().add((CostToBeneficiaryComponent)((Object)value));
        } else if (name.equals("subrogation")) {
            this.subrogation = TypeConvertor.castToBoolean(value);
        } else if (name.equals("contract")) {
            this.getContract().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 2046898558: {
                return this.getPolicyHolder();
            }
            case -1219769240: {
                return this.getSubscriber();
            }
            case 327834531: {
                return this.getSubscriberIdElement();
            }
            case -565102875: {
                return this.getBeneficiary();
            }
            case -1109226753: {
                return this.getDependentElement();
            }
            case -261851592: {
                return this.getRelationship();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 106443915: {
                return this.addPayor();
            }
            case 94742904: {
                return this.addClass_();
            }
            case 106006350: {
                return this.getOrderElement();
            }
            case 1843485230: {
                return this.getNetworkElement();
            }
            case -1866474851: {
                return this.addCostToBeneficiary();
            }
            case 837389739: {
                return this.getSubrogationElement();
            }
            case -566947566: {
                return this.addContract();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 2046898558: {
                return new String[]{"Reference"};
            }
            case -1219769240: {
                return new String[]{"Reference"};
            }
            case 327834531: {
                return new String[]{"string"};
            }
            case -565102875: {
                return new String[]{"Reference"};
            }
            case -1109226753: {
                return new String[]{"string"};
            }
            case -261851592: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 106443915: {
                return new String[]{"Reference"};
            }
            case 94742904: {
                return new String[0];
            }
            case 106006350: {
                return new String[]{"positiveInt"};
            }
            case 1843485230: {
                return new String[]{"string"};
            }
            case -1866474851: {
                return new String[0];
            }
            case 837389739: {
                return new String[]{"boolean"};
            }
            case -566947566: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("policyHolder")) {
            this.policyHolder = new Reference();
            return this.policyHolder;
        }
        if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = new Reference();
            return this.subscriber;
        }
        if (name.equals("subscriberId")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.subscriberId");
        }
        if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = new Reference();
            return this.beneficiary;
        }
        if (name.equals(SP_DEPENDENT)) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.dependent");
        }
        if (name.equals("relationship")) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_PAYOR)) {
            return this.addPayor();
        }
        if (name.equals("class")) {
            return this.addClass_();
        }
        if (name.equals("order")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.order");
        }
        if (name.equals("network")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.network");
        }
        if (name.equals("costToBeneficiary")) {
            return this.addCostToBeneficiary();
        }
        if (name.equals("subrogation")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.subrogation");
        }
        if (name.equals("contract")) {
            return this.addContract();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coverage";
    }

    @Override
    public Coverage copy() {
        Coverage dst = new Coverage();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Coverage dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.policyHolder = this.policyHolder == null ? null : this.policyHolder.copy();
        dst.subscriber = this.subscriber == null ? null : this.subscriber.copy();
        dst.subscriberId = this.subscriberId == null ? null : this.subscriberId.copy();
        dst.beneficiary = this.beneficiary == null ? null : this.beneficiary.copy();
        dst.dependent = this.dependent == null ? null : this.dependent.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.payor != null) {
            dst.payor = new ArrayList<Reference>();
            for (Reference reference : this.payor) {
                dst.payor.add(reference.copy());
            }
        }
        if (this.class_ != null) {
            dst.class_ = new ArrayList<ClassComponent>();
            for (ClassComponent classComponent : this.class_) {
                dst.class_.add(classComponent.copy());
            }
        }
        dst.order = this.order == null ? null : this.order.copy();
        StringType stringType = dst.network = this.network == null ? null : this.network.copy();
        if (this.costToBeneficiary != null) {
            dst.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
            for (CostToBeneficiaryComponent costToBeneficiaryComponent : this.costToBeneficiary) {
                dst.costToBeneficiary.add(costToBeneficiaryComponent.copy());
            }
        }
        BooleanType booleanType = dst.subrogation = this.subrogation == null ? null : this.subrogation.copy();
        if (this.contract != null) {
            dst.contract = new ArrayList<Reference>();
            for (Reference reference : this.contract) {
                dst.contract.add(reference.copy());
            }
        }
    }

    protected Coverage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other_;
        return Coverage.compareDeep(this.identifier, o.identifier, true) && Coverage.compareDeep(this.status, o.status, true) && Coverage.compareDeep(this.type, o.type, true) && Coverage.compareDeep(this.policyHolder, o.policyHolder, true) && Coverage.compareDeep(this.subscriber, o.subscriber, true) && Coverage.compareDeep(this.subscriberId, o.subscriberId, true) && Coverage.compareDeep(this.beneficiary, o.beneficiary, true) && Coverage.compareDeep(this.dependent, o.dependent, true) && Coverage.compareDeep(this.relationship, o.relationship, true) && Coverage.compareDeep(this.period, o.period, true) && Coverage.compareDeep(this.payor, o.payor, true) && Coverage.compareDeep(this.class_, o.class_, true) && Coverage.compareDeep(this.order, o.order, true) && Coverage.compareDeep(this.network, o.network, true) && Coverage.compareDeep(this.costToBeneficiary, o.costToBeneficiary, true) && Coverage.compareDeep(this.subrogation, o.subrogation, true) && Coverage.compareDeep(this.contract, o.contract, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other_;
        return Coverage.compareValues(this.status, o.status, true) && Coverage.compareValues(this.subscriberId, o.subscriberId, true) && Coverage.compareValues(this.dependent, o.dependent, true) && Coverage.compareValues(this.order, o.order, true) && Coverage.compareValues(this.network, o.network, true) && Coverage.compareValues(this.subrogation, o.subrogation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.policyHolder, this.subscriber, this.subscriberId, this.beneficiary, this.dependent, this.relationship, this.period, this.payor, this.class_, this.order, this.network, this.costToBeneficiary, this.subrogation, this.contract});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Coverage;
    }

    @Block
    public static class ExemptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Exception category", formalDefinition="The code for the specific exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-financial-exception")
        protected CodeableConcept type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The effective period of the exception", formalDefinition="The timeframe during when the exception is in force.")
        protected Period period;
        private static final long serialVersionUID = 523191991L;

        public ExemptionComponent() {
        }

        public ExemptionComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExemptionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExemptionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExemptionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ExemptionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_TYPE, "CodeableConcept", "The code for the specific exception.", 0, 1, this.type));
            children.add(new Property("period", "Period", "The timeframe during when the exception is in force.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Coverage.SP_TYPE, "CodeableConcept", "The code for the specific exception.", 0, 1, this.type);
                }
                case -991726143: {
                    return new Property("period", "Period", "The timeframe during when the exception is in force.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ExemptionComponent copy() {
            ExemptionComponent dst = new ExemptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExemptionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExemptionComponent)) {
                return false;
            }
            ExemptionComponent o = (ExemptionComponent)other_;
            return ExemptionComponent.compareDeep(this.type, o.type, true) && ExemptionComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExemptionComponent)) {
                return false;
            }
            ExemptionComponent o = (ExemptionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.period});
        }

        @Override
        public String fhirType() {
            return "Coverage.costToBeneficiary.exception";
        }
    }

    @Block
    public static class CostToBeneficiaryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Cost category", formalDefinition="The category of patient centric costs associated with treatment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-copay-type")
        protected CodeableConcept type;
        @Child(name="value", type={Quantity.class, Money.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The amount or percentage due from the beneficiary", formalDefinition="The amount due from the patient for the cost category.")
        protected DataType value;
        @Child(name="exception", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Exceptions for patient payments", formalDefinition="A suite of codes indicating exceptions or reductions to patient costs and their effective periods.")
        protected List<ExemptionComponent> exception;
        private static final long serialVersionUID = -1531646137L;

        public CostToBeneficiaryComponent() {
        }

        public CostToBeneficiaryComponent(DataType value) {
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CostToBeneficiaryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CostToBeneficiaryComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this != null && this.value instanceof Money;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CostToBeneficiaryComponent setValue(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof Money)) {
                throw new Error("Not the right type for Coverage.costToBeneficiary.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public List<ExemptionComponent> getException() {
            if (this.exception == null) {
                this.exception = new ArrayList<ExemptionComponent>();
            }
            return this.exception;
        }

        public CostToBeneficiaryComponent setException(List<ExemptionComponent> theException) {
            this.exception = theException;
            return this;
        }

        public boolean hasException() {
            if (this.exception == null) {
                return false;
            }
            for (ExemptionComponent item : this.exception) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExemptionComponent addException() {
            ExemptionComponent t = new ExemptionComponent();
            if (this.exception == null) {
                this.exception = new ArrayList<ExemptionComponent>();
            }
            this.exception.add(t);
            return t;
        }

        public CostToBeneficiaryComponent addException(ExemptionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.exception == null) {
                this.exception = new ArrayList<ExemptionComponent>();
            }
            this.exception.add(t);
            return this;
        }

        public ExemptionComponent getExceptionFirstRep() {
            if (this.getException().isEmpty()) {
                this.addException();
            }
            return this.getException().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_TYPE, "CodeableConcept", "The category of patient centric costs associated with treatment.", 0, 1, this.type));
            children.add(new Property("value[x]", "Quantity|Money", "The amount due from the patient for the cost category.", 0, 1, this.value));
            children.add(new Property("exception", "", "A suite of codes indicating exceptions or reductions to patient costs and their effective periods.", 0, Integer.MAX_VALUE, this.exception));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Coverage.SP_TYPE, "CodeableConcept", "The category of patient centric costs associated with treatment.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|Money", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|Money", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case 1481625679: {
                    return new Property("exception", "", "A suite of codes indicating exceptions or reductions to patient costs and their effective periods.", 0, Integer.MAX_VALUE, this.exception);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 1481625679: {
                    return this.exception == null ? new Base[]{} : this.exception.toArray(new Base[this.exception.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case 1481625679: {
                    this.getException().add((ExemptionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("exception")) {
                this.getException().add((ExemptionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 1481625679: {
                    return this.addException();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "Money"};
                }
                case 1481625679: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("exception")) {
                return this.addException();
            }
            return super.addChild(name);
        }

        @Override
        public CostToBeneficiaryComponent copy() {
            CostToBeneficiaryComponent dst = new CostToBeneficiaryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CostToBeneficiaryComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            DataType dataType = dst.value = this.value == null ? null : this.value.copy();
            if (this.exception != null) {
                dst.exception = new ArrayList<ExemptionComponent>();
                for (ExemptionComponent i : this.exception) {
                    dst.exception.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CostToBeneficiaryComponent)) {
                return false;
            }
            CostToBeneficiaryComponent o = (CostToBeneficiaryComponent)other_;
            return CostToBeneficiaryComponent.compareDeep(this.type, o.type, true) && CostToBeneficiaryComponent.compareDeep(this.value, o.value, true) && CostToBeneficiaryComponent.compareDeep(this.exception, o.exception, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CostToBeneficiaryComponent)) {
                return false;
            }
            CostToBeneficiaryComponent o = (CostToBeneficiaryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.value, this.exception});
        }

        @Override
        public String fhirType() {
            return "Coverage.costToBeneficiary";
        }
    }

    @Block
    public static class ClassComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of class such as 'group' or 'plan'", formalDefinition="The type of classification for which an insurer-specific class label or number and optional name is provided, for example may be used to identify a class of coverage or employer group, Policy, Plan.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-class")
        protected CodeableConcept type;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Value associated with the type", formalDefinition="The alphanumeric string value associated with the insurer issued label.")
        protected StringType value;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human readable description of the type and value", formalDefinition="A short description for the class.")
        protected StringType name;
        private static final long serialVersionUID = -1501519769L;

        public ClassComponent() {
        }

        public ClassComponent(CodeableConcept type, String value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ClassComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ClassComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ClassComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ClassComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ClassComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_TYPE, "CodeableConcept", "The type of classification for which an insurer-specific class label or number and optional name is provided, for example may be used to identify a class of coverage or employer group, Policy, Plan.", 0, 1, this.type));
            children.add(new Property("value", "string", "The alphanumeric string value associated with the insurer issued label.", 0, 1, this.value));
            children.add(new Property("name", "string", "A short description for the class.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Coverage.SP_TYPE, "CodeableConcept", "The type of classification for which an insurer-specific class label or number and optional name is provided, for example may be used to identify a class of coverage or employer group, Policy, Plan.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "string", "The alphanumeric string value associated with the insurer issued label.", 0, 1, this.value);
                }
                case 3373707: {
                    return new Property("name", "string", "A short description for the class.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.class.value");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.class.name");
            }
            return super.addChild(name);
        }

        @Override
        public ClassComponent copy() {
            ClassComponent dst = new ClassComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClassComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.name = this.name == null ? null : this.name.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassComponent)) {
                return false;
            }
            ClassComponent o = (ClassComponent)other_;
            return ClassComponent.compareDeep(this.type, o.type, true) && ClassComponent.compareDeep(this.value, o.value, true) && ClassComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassComponent)) {
                return false;
            }
            ClassComponent o = (ClassComponent)other_;
            return ClassComponent.compareValues(this.value, o.value, true) && ClassComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value, this.name});
        }

        @Override
        public String fhirType() {
            return "Coverage.class";
        }
    }
}

