/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.Attachment;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Consent", profile="http://hl7.org/fhir/StructureDefinition/Consent")
public class Consent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for this record (external references)", formalDefinition="Unique identifier for this copy of the Consent Statement.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | proposed | active | rejected | inactive | entered-in-error", formalDefinition="Indicates the current state of this consent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-state-codes")
    protected Enumeration<ConsentState> status;
    @Child(name="scope", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Which of the four areas this resource covers (extensible)", formalDefinition="A selector of the type of consent being presented: ADR, Privacy, Treatment, Research.  This list is now extensible.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-scope")
    protected CodeableConcept scope;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the consent statement - for indexing/retrieval", formalDefinition="A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-category")
    protected List<CodeableConcept> category;
    @Child(name="patient", type={Patient.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the consent applies to", formalDefinition="The patient/healthcare consumer to whom this consent applies.")
    protected Reference patient;
    @Child(name="dateTime", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this Consent was created or indexed", formalDefinition="When this  Consent was issued / created / indexed.")
    protected DateTimeType dateTime;
    @Child(name="performer", type={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is agreeing to the policy and rules", formalDefinition="Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.")
    protected List<Reference> performer;
    @Child(name="organization", type={Organization.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Custodian of the consent", formalDefinition="The organization that manages the consent, and the framework within which it is executed.")
    protected List<Reference> organization;
    @Child(name="source", type={Attachment.class, Consent.class, DocumentReference.class, Contract.class, QuestionnaireResponse.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Source from which this consent is taken", formalDefinition="The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.")
    protected DataType source;
    @Child(name="policy", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Policies covered by this consent", formalDefinition="The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.")
    protected List<ConsentPolicyComponent> policy;
    @Child(name="policyRule", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Regulation that this consents to", formalDefinition="A reference to the specific base computable regulation or policy.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-policy")
    protected CodeableConcept policyRule;
    @Child(name="verification", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Consent Verified by patient or family", formalDefinition="Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.")
    protected List<ConsentVerificationComponent> verification;
    @Child(name="provision", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Constraints to the base Consent.policyRule", formalDefinition="An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.")
    protected ProvisionComponent provision;
    private static final long serialVersionUID = 2061814558L;
    @SearchParamDefinition(name="action", path="Consent.provision.action", description="Actions controlled by this rule", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="actor", path="Consent.provision.actor.reference", description="Resource for the actor (or group, by role)", type="reference", target={CareTeam.class, Device.class, Group.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Consent:actor").toLocked();
    @SearchParamDefinition(name="category", path="Consent.category", description="Classification of the consent statement - for indexing/retrieval", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="consentor", path="Consent.performer", description="Who is agreeing to the policy and rules", type="reference", target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_CONSENTOR = "consentor";
    public static final ReferenceClientParam CONSENTOR = new ReferenceClientParam("consentor");
    public static final Include INCLUDE_CONSENTOR = new Include("Consent:consentor").toLocked();
    @SearchParamDefinition(name="data", path="Consent.provision.data.reference", description="The actual data reference", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DATA = "data";
    public static final ReferenceClientParam DATA = new ReferenceClientParam("data");
    public static final Include INCLUDE_DATA = new Include("Consent:data").toLocked();
    @SearchParamDefinition(name="organization", path="Consent.organization", description="Custodian of the consent", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Consent:organization").toLocked();
    @SearchParamDefinition(name="period", path="Consent.provision.period", description="Timeframe for this rule", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="purpose", path="Consent.provision.purpose", description="Context of activities covered by this rule", type="token")
    public static final String SP_PURPOSE = "purpose";
    public static final TokenClientParam PURPOSE = new TokenClientParam("purpose");
    @SearchParamDefinition(name="scope", path="Consent.scope", description="Which of the four areas this resource covers (extensible)", type="token")
    public static final String SP_SCOPE = "scope";
    public static final TokenClientParam SCOPE = new TokenClientParam("scope");
    @SearchParamDefinition(name="security-label", path="Consent.provision.securityLabel", description="Security Labels that define affected resources", type="token")
    public static final String SP_SECURITY_LABEL = "security-label";
    public static final TokenClientParam SECURITY_LABEL = new TokenClientParam("security-label");
    @SearchParamDefinition(name="source-reference", path="Consent.source", description="Search by reference to a Consent, DocumentReference, Contract  or QuestionnaireResponse", type="reference", target={Consent.class, Contract.class, DocumentReference.class, QuestionnaireResponse.class})
    public static final String SP_SOURCE_REFERENCE = "source-reference";
    public static final ReferenceClientParam SOURCE_REFERENCE = new ReferenceClientParam("source-reference");
    public static final Include INCLUDE_SOURCE_REFERENCE = new Include("Consent:source-reference").toLocked();
    @SearchParamDefinition(name="status", path="Consent.status", description="draft | proposed | active | rejected | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | CareTeam.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | Immunization.occurrence | List.date | Observation.effective | Procedure.performed | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): Time period team covers\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When this Consent was created or indexed\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure was performed\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.masterIdentifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Master Version Specific Identifier\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.patient | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject.where(resolve() is Patient) | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Consent:patient").toLocked();

    public Consent() {
    }

    public Consent(ConsentState status, CodeableConcept scope, CodeableConcept category) {
        this.setStatus(status);
        this.setScope(scope);
        this.addCategory(category);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Consent setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Consent addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ConsentState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Consent setStatusElement(Enumeration<ConsentState> value) {
        this.status = value;
        return this;
    }

    public ConsentState getStatus() {
        return this.status == null ? null : (ConsentState)((Object)this.status.getValue());
    }

    public Consent setStatus(ConsentState value) {
        if (this.status == null) {
            this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getScope() {
        if (this.scope == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.scope");
            }
            if (Configuration.doAutoCreate()) {
                this.scope = new CodeableConcept();
            }
        }
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null && !this.scope.isEmpty();
    }

    public Consent setScope(CodeableConcept value) {
        this.scope = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Consent setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Consent addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Consent setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public DateTimeType getDateTimeElement() {
        if (this.dateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.dateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.dateTime = new DateTimeType();
            }
        }
        return this.dateTime;
    }

    public boolean hasDateTimeElement() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public boolean hasDateTime() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public Consent setDateTimeElement(DateTimeType value) {
        this.dateTime = value;
        return this;
    }

    public Date getDateTime() {
        return this.dateTime == null ? null : (Date)this.dateTime.getValue();
    }

    public Consent setDateTime(Date value) {
        if (value == null) {
            this.dateTime = null;
        } else {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Consent setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public Consent addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<Reference> getOrganization() {
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        return this.organization;
    }

    public Consent setOrganization(List<Reference> theOrganization) {
        this.organization = theOrganization;
        return this;
    }

    public boolean hasOrganization() {
        if (this.organization == null) {
            return false;
        }
        for (Reference item : this.organization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addOrganization() {
        Reference t = new Reference();
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        this.organization.add(t);
        return t;
    }

    public Consent addOrganization(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        this.organization.add(t);
        return this;
    }

    public Reference getOrganizationFirstRep() {
        if (this.getOrganization().isEmpty()) {
            this.addOrganization();
        }
        return this.getOrganization().get(0);
    }

    public DataType getSource() {
        return this.source;
    }

    public Attachment getSourceAttachment() throws FHIRException {
        if (this.source == null) {
            this.source = new Attachment();
        }
        if (!(this.source instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Attachment)this.source;
    }

    public boolean hasSourceAttachment() {
        return this != null && this.source instanceof Attachment;
    }

    public Reference getSourceReference() throws FHIRException {
        if (this.source == null) {
            this.source = new Reference();
        }
        if (!(this.source instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Reference)this.source;
    }

    public boolean hasSourceReference() {
        return this != null && this.source instanceof Reference;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public Consent setSource(DataType value) {
        if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Consent.source[x]: " + value.fhirType());
        }
        this.source = value;
        return this;
    }

    public List<ConsentPolicyComponent> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        return this.policy;
    }

    public Consent setPolicy(List<ConsentPolicyComponent> thePolicy) {
        this.policy = thePolicy;
        return this;
    }

    public boolean hasPolicy() {
        if (this.policy == null) {
            return false;
        }
        for (ConsentPolicyComponent item : this.policy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentPolicyComponent addPolicy() {
        ConsentPolicyComponent t = new ConsentPolicyComponent();
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        this.policy.add(t);
        return t;
    }

    public Consent addPolicy(ConsentPolicyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        this.policy.add(t);
        return this;
    }

    public ConsentPolicyComponent getPolicyFirstRep() {
        if (this.getPolicy().isEmpty()) {
            this.addPolicy();
        }
        return this.getPolicy().get(0);
    }

    public CodeableConcept getPolicyRule() {
        if (this.policyRule == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.policyRule");
            }
            if (Configuration.doAutoCreate()) {
                this.policyRule = new CodeableConcept();
            }
        }
        return this.policyRule;
    }

    public boolean hasPolicyRule() {
        return this.policyRule != null && !this.policyRule.isEmpty();
    }

    public Consent setPolicyRule(CodeableConcept value) {
        this.policyRule = value;
        return this;
    }

    public List<ConsentVerificationComponent> getVerification() {
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        return this.verification;
    }

    public Consent setVerification(List<ConsentVerificationComponent> theVerification) {
        this.verification = theVerification;
        return this;
    }

    public boolean hasVerification() {
        if (this.verification == null) {
            return false;
        }
        for (ConsentVerificationComponent item : this.verification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentVerificationComponent addVerification() {
        ConsentVerificationComponent t = new ConsentVerificationComponent();
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        this.verification.add(t);
        return t;
    }

    public Consent addVerification(ConsentVerificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        this.verification.add(t);
        return this;
    }

    public ConsentVerificationComponent getVerificationFirstRep() {
        if (this.getVerification().isEmpty()) {
            this.addVerification();
        }
        return this.getVerification().get(0);
    }

    public ProvisionComponent getProvision() {
        if (this.provision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.provision");
            }
            if (Configuration.doAutoCreate()) {
                this.provision = new ProvisionComponent();
            }
        }
        return this.provision;
    }

    public boolean hasProvision() {
        return this.provision != null && !this.provision.isEmpty();
    }

    public Consent setProvision(ProvisionComponent value) {
        this.provision = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates the current state of this consent.", 0, 1, this.status));
        children.add(new Property(SP_SCOPE, "CodeableConcept", "A selector of the type of consent being presented: ADR, Privacy, Treatment, Research.  This list is now extensible.", 0, 1, this.scope));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient/healthcare consumer to whom this consent applies.", 0, 1, this.patient));
        children.add(new Property("dateTime", "dateTime", "When this  Consent was issued / created / indexed.", 0, 1, this.dateTime));
        children.add(new Property("performer", "Reference(Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization that manages the consent, and the framework within which it is executed.", 0, Integer.MAX_VALUE, this.organization));
        children.add(new Property("source[x]", "Attachment|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source));
        children.add(new Property("policy", "", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, Integer.MAX_VALUE, this.policy));
        children.add(new Property("policyRule", "CodeableConcept", "A reference to the specific base computable regulation or policy.", 0, 1, this.policyRule));
        children.add(new Property("verification", "", "Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.", 0, Integer.MAX_VALUE, this.verification));
        children.add(new Property("provision", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, 1, this.provision));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current state of this consent.", 0, 1, this.status);
            }
            case 109264468: {
                return new Property(SP_SCOPE, "CodeableConcept", "A selector of the type of consent being presented: ADR, Privacy, Treatment, Research.  This list is now extensible.", 0, 1, this.scope);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient/healthcare consumer to whom this consent applies.", 0, 1, this.patient);
            }
            case 1792749467: {
                return new Property("dateTime", "dateTime", "When this  Consent was issued / created / indexed.", 0, 1, this.dateTime);
            }
            case 481140686: {
                return new Property("performer", "Reference(Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization that manages the consent, and the framework within which it is executed.", 0, Integer.MAX_VALUE, this.organization);
            }
            case -1698413947: {
                return new Property("source[x]", "Attachment|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -896505829: {
                return new Property("source[x]", "Attachment|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case 1964406686: {
                return new Property("source[x]", "Attachment", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -244259472: {
                return new Property("source[x]", "Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -982670030: {
                return new Property("policy", "", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, Integer.MAX_VALUE, this.policy);
            }
            case 1593493326: {
                return new Property("policyRule", "CodeableConcept", "A reference to the specific base computable regulation or policy.", 0, 1, this.policyRule);
            }
            case -1484401125: {
                return new Property("verification", "", "Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.", 0, Integer.MAX_VALUE, this.verification);
            }
            case -547120939: {
                return new Property("provision", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, 1, this.provision);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 109264468: {
                Base[] baseArray;
                if (this.scope == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.scope;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 1792749467: {
                Base[] baseArray;
                if (this.dateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.dateTime;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1178922291: {
                return this.organization == null ? new Base[]{} : this.organization.toArray(new Base[this.organization.size()]);
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.source;
                }
                return baseArray;
            }
            case -982670030: {
                return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
            }
            case 1593493326: {
                Base[] baseArray;
                if (this.policyRule == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.policyRule;
                }
                return baseArray;
            }
            case -1484401125: {
                return this.verification == null ? new Base[]{} : this.verification.toArray(new Base[this.verification.size()]);
            }
            case -547120939: {
                Base[] baseArray;
                if (this.provision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.provision;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ConsentStateEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 109264468: {
                this.scope = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1792749467: {
                this.dateTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1178922291: {
                this.getOrganization().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToType(value);
                return value;
            }
            case -982670030: {
                this.getPolicy().add((ConsentPolicyComponent)((Object)value));
                return value;
            }
            case 1593493326: {
                this.policyRule = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1484401125: {
                this.getVerification().add((ConsentVerificationComponent)((Object)value));
                return value;
            }
            case -547120939: {
                this.provision = (ProvisionComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ConsentStateEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SCOPE)) {
            this.scope = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("dateTime")) {
            this.dateTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals("performer")) {
            this.getPerformer().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ORGANIZATION)) {
            this.getOrganization().add(TypeConvertor.castToReference(value));
        } else if (name.equals("source[x]")) {
            this.source = TypeConvertor.castToType(value);
        } else if (name.equals("policy")) {
            this.getPolicy().add((ConsentPolicyComponent)((Object)value));
        } else if (name.equals("policyRule")) {
            this.policyRule = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("verification")) {
            this.getVerification().add((ConsentVerificationComponent)((Object)value));
        } else if (name.equals("provision")) {
            this.provision = (ProvisionComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 109264468: {
                return this.getScope();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1792749467: {
                return this.getDateTimeElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1178922291: {
                return this.addOrganization();
            }
            case -1698413947: {
                return this.getSource();
            }
            case -896505829: {
                return this.getSource();
            }
            case -982670030: {
                return this.addPolicy();
            }
            case 1593493326: {
                return this.getPolicyRule();
            }
            case -1484401125: {
                return this.addVerification();
            }
            case -547120939: {
                return this.getProvision();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 109264468: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1792749467: {
                return new String[]{"dateTime"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case -896505829: {
                return new String[]{"Attachment", "Reference"};
            }
            case -982670030: {
                return new String[0];
            }
            case 1593493326: {
                return new String[]{"CodeableConcept"};
            }
            case -1484401125: {
                return new String[0];
            }
            case -547120939: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Consent.status");
        }
        if (name.equals(SP_SCOPE)) {
            this.scope = new CodeableConcept();
            return this.scope;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("dateTime")) {
            throw new FHIRException("Cannot call addChild on a singleton property Consent.dateTime");
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals(SP_ORGANIZATION)) {
            return this.addOrganization();
        }
        if (name.equals("sourceAttachment")) {
            this.source = new Attachment();
            return this.source;
        }
        if (name.equals("sourceReference")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("policy")) {
            return this.addPolicy();
        }
        if (name.equals("policyRule")) {
            this.policyRule = new CodeableConcept();
            return this.policyRule;
        }
        if (name.equals("verification")) {
            return this.addVerification();
        }
        if (name.equals("provision")) {
            this.provision = new ProvisionComponent();
            return this.provision;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Consent";
    }

    @Override
    public Consent copy() {
        Consent dst = new Consent();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Consent dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.scope = this.scope == null ? null : this.scope.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        DateTimeType dateTimeType = dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference : this.performer) {
                dst.performer.add(reference.copy());
            }
        }
        if (this.organization != null) {
            dst.organization = new ArrayList<Reference>();
            for (Reference reference : this.organization) {
                dst.organization.add(reference.copy());
            }
        }
        DataType dataType = dst.source = this.source == null ? null : this.source.copy();
        if (this.policy != null) {
            dst.policy = new ArrayList<ConsentPolicyComponent>();
            for (ConsentPolicyComponent consentPolicyComponent : this.policy) {
                dst.policy.add(consentPolicyComponent.copy());
            }
        }
        CodeableConcept codeableConcept3 = dst.policyRule = this.policyRule == null ? null : this.policyRule.copy();
        if (this.verification != null) {
            dst.verification = new ArrayList<ConsentVerificationComponent>();
            for (ConsentVerificationComponent consentVerificationComponent : this.verification) {
                dst.verification.add(consentVerificationComponent.copy());
            }
        }
        dst.provision = this.provision == null ? null : this.provision.copy();
    }

    protected Consent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareDeep(this.identifier, o.identifier, true) && Consent.compareDeep(this.status, o.status, true) && Consent.compareDeep(this.scope, o.scope, true) && Consent.compareDeep(this.category, o.category, true) && Consent.compareDeep(this.patient, o.patient, true) && Consent.compareDeep(this.dateTime, o.dateTime, true) && Consent.compareDeep(this.performer, o.performer, true) && Consent.compareDeep(this.organization, o.organization, true) && Consent.compareDeep(this.source, o.source, true) && Consent.compareDeep(this.policy, o.policy, true) && Consent.compareDeep(this.policyRule, o.policyRule, true) && Consent.compareDeep(this.verification, o.verification, true) && Consent.compareDeep(this.provision, o.provision, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareValues(this.status, o.status, true) && Consent.compareValues(this.dateTime, o.dateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.scope, this.category, this.patient, this.dateTime, this.performer, this.organization, this.source, this.policy, this.policyRule, this.verification, this.provision});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Consent;
    }

    @Block
    public static class ProvisionDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="meaning", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="instance | related | dependents | authoredby", formalDefinition="How the resource reference is interpreted when testing consent restrictions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning")
        protected Enumeration<ConsentDataMeaning> meaning;
        @Child(name="reference", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual data reference", formalDefinition="A reference to a specific resource that defines which resources are covered by this consent.")
        protected Reference reference;
        private static final long serialVersionUID = 1735979153L;

        public ProvisionDataComponent() {
        }

        public ProvisionDataComponent(ConsentDataMeaning meaning, Reference reference) {
            this.setMeaning(meaning);
            this.setReference(reference);
        }

        public Enumeration<ConsentDataMeaning> getMeaningElement() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionDataComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
                }
            }
            return this.meaning;
        }

        public boolean hasMeaningElement() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public ProvisionDataComponent setMeaningElement(Enumeration<ConsentDataMeaning> value) {
            this.meaning = value;
            return this;
        }

        public ConsentDataMeaning getMeaning() {
            return this.meaning == null ? null : (ConsentDataMeaning)((Object)this.meaning.getValue());
        }

        public ProvisionDataComponent setMeaning(ConsentDataMeaning value) {
            if (this.meaning == null) {
                this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
            }
            this.meaning.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionDataComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ProvisionDataComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning));
            children.add(new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938160637: {
                    return new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    Base[] baseArray;
                    if (this.meaning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.meaning;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    value = new ConsentDataMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.meaning = value;
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("meaning")) {
                value = new ConsentDataMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.meaning = value;
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return this.getMeaningElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("meaning")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.provision.data.meaning");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ProvisionDataComponent copy() {
            ProvisionDataComponent dst = new ProvisionDataComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvisionDataComponent dst) {
            super.copyValues(dst);
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionDataComponent)) {
                return false;
            }
            ProvisionDataComponent o = (ProvisionDataComponent)other_;
            return ProvisionDataComponent.compareDeep(this.meaning, o.meaning, true) && ProvisionDataComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionDataComponent)) {
                return false;
            }
            ProvisionDataComponent o = (ProvisionDataComponent)other_;
            return ProvisionDataComponent.compareValues(this.meaning, o.meaning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.provision.data";
        }
    }

    @Block
    public static class ProvisionActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the actor is involved", formalDefinition="How the individual is involved in the resources content that is described in the exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected CodeableConcept role;
        @Child(name="reference", type={Device.class, Group.class, CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource for the actor (or group, by role)", formalDefinition="The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected Reference reference;
        private static final long serialVersionUID = -1992921787L;

        public ProvisionActorComponent() {
        }

        public ProvisionActorComponent(CodeableConcept role, Reference reference) {
            this.setRole(role);
            this.setReference(reference);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionActorComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProvisionActorComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionActorComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ProvisionActorComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ProvisionActorComponent copy() {
            ProvisionActorComponent dst = new ProvisionActorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvisionActorComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionActorComponent)) {
                return false;
            }
            ProvisionActorComponent o = (ProvisionActorComponent)other_;
            return ProvisionActorComponent.compareDeep(this.role, o.role, true) && ProvisionActorComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionActorComponent)) {
                return false;
            }
            ProvisionActorComponent o = (ProvisionActorComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.provision.actor";
        }
    }

    @Block
    public static class ProvisionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="deny | permit", formalDefinition="Action  to take - permit or deny - when the rule conditions are met.  Not permitted in root rule, required in all nested rules.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-provision-type")
        protected Enumeration<ConsentProvisionType> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for this rule", formalDefinition="The timeframe in this rule is valid.")
        protected Period period;
        @Child(name="actor", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who|what controlled by this rule (or group, by role)", formalDefinition="Who or what is controlled by this rule. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected List<ProvisionActorComponent> actor;
        @Child(name="action", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Actions controlled by this rule", formalDefinition="Actions controlled by this Rule.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-action")
        protected List<CodeableConcept> action;
        @Child(name="securityLabel", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Security Labels that define affected resources", formalDefinition="A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        protected List<Coding> securityLabel;
        @Child(name="purpose", type={Coding.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Context of activities covered by this rule", formalDefinition="The context of the activities a user is taking - why the user is accessing the data - that are controlled by this rule.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected List<Coding> purpose;
        @Child(name="class", type={Coding.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. Resource Type, Profile, CDA, etc.", formalDefinition="The class of information covered by this rule. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
        protected List<Coding> class_;
        @Child(name="code", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. LOINC or SNOMED CT code, etc. in the content", formalDefinition="If this code is found in an instance, then the rule applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-code")
        protected List<CodeableConcept> code;
        @Child(name="dataPeriod", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for data controlled by this rule", formalDefinition="Clinical or Operational Relevant period of time that bounds the data controlled by this rule.")
        protected Period dataPeriod;
        @Child(name="data", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Data controlled by this rule", formalDefinition="The resources controlled by this rule if specific resources are referenced.")
        protected List<ProvisionDataComponent> data;
        @Child(name="provision", type={ProvisionComponent.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Exception Rules", formalDefinition="Rules which provide exceptions to the base rule or subrules.")
        protected List<ProvisionComponent> provision;
        private static final long serialVersionUID = 924910269L;

        public Enumeration<ConsentProvisionType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConsentProvisionType>(new ConsentProvisionTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProvisionComponent setTypeElement(Enumeration<ConsentProvisionType> value) {
            this.type = value;
            return this;
        }

        public ConsentProvisionType getType() {
            return this.type == null ? null : (ConsentProvisionType)((Object)this.type.getValue());
        }

        public ProvisionComponent setType(ConsentProvisionType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<ConsentProvisionType>(new ConsentProvisionTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ProvisionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<ProvisionActorComponent> getActor() {
            if (this.actor == null) {
                this.actor = new ArrayList<ProvisionActorComponent>();
            }
            return this.actor;
        }

        public ProvisionComponent setActor(List<ProvisionActorComponent> theActor) {
            this.actor = theActor;
            return this;
        }

        public boolean hasActor() {
            if (this.actor == null) {
                return false;
            }
            for (ProvisionActorComponent item : this.actor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvisionActorComponent addActor() {
            ProvisionActorComponent t = new ProvisionActorComponent();
            if (this.actor == null) {
                this.actor = new ArrayList<ProvisionActorComponent>();
            }
            this.actor.add(t);
            return t;
        }

        public ProvisionComponent addActor(ProvisionActorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.actor == null) {
                this.actor = new ArrayList<ProvisionActorComponent>();
            }
            this.actor.add(t);
            return this;
        }

        public ProvisionActorComponent getActorFirstRep() {
            if (this.getActor().isEmpty()) {
                this.addActor();
            }
            return this.getActor().get(0);
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public ProvisionComponent setAction(List<CodeableConcept> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public ProvisionComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public CodeableConcept getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public ProvisionComponent setSecurityLabel(List<Coding> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public ProvisionComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public Coding getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public List<Coding> getPurpose() {
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            return this.purpose;
        }

        public ProvisionComponent setPurpose(List<Coding> thePurpose) {
            this.purpose = thePurpose;
            return this;
        }

        public boolean hasPurpose() {
            if (this.purpose == null) {
                return false;
            }
            for (Coding item : this.purpose) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPurpose() {
            Coding t = new Coding();
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return t;
        }

        public ProvisionComponent addPurpose(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return this;
        }

        public Coding getPurposeFirstRep() {
            if (this.getPurpose().isEmpty()) {
                this.addPurpose();
            }
            return this.getPurpose().get(0);
        }

        public List<Coding> getClass_() {
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            return this.class_;
        }

        public ProvisionComponent setClass_(List<Coding> theClass_) {
            this.class_ = theClass_;
            return this;
        }

        public boolean hasClass_() {
            if (this.class_ == null) {
                return false;
            }
            for (Coding item : this.class_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addClass_() {
            Coding t = new Coding();
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            this.class_.add(t);
            return t;
        }

        public ProvisionComponent addClass_(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            this.class_.add(t);
            return this;
        }

        public Coding getClass_FirstRep() {
            if (this.getClass_().isEmpty()) {
                this.addClass_();
            }
            return this.getClass_().get(0);
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public ProvisionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public ProvisionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public Period getDataPeriod() {
            if (this.dataPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.dataPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataPeriod = new Period();
                }
            }
            return this.dataPeriod;
        }

        public boolean hasDataPeriod() {
            return this.dataPeriod != null && !this.dataPeriod.isEmpty();
        }

        public ProvisionComponent setDataPeriod(Period value) {
            this.dataPeriod = value;
            return this;
        }

        public List<ProvisionDataComponent> getData() {
            if (this.data == null) {
                this.data = new ArrayList<ProvisionDataComponent>();
            }
            return this.data;
        }

        public ProvisionComponent setData(List<ProvisionDataComponent> theData) {
            this.data = theData;
            return this;
        }

        public boolean hasData() {
            if (this.data == null) {
                return false;
            }
            for (ProvisionDataComponent item : this.data) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvisionDataComponent addData() {
            ProvisionDataComponent t = new ProvisionDataComponent();
            if (this.data == null) {
                this.data = new ArrayList<ProvisionDataComponent>();
            }
            this.data.add(t);
            return t;
        }

        public ProvisionComponent addData(ProvisionDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new ArrayList<ProvisionDataComponent>();
            }
            this.data.add(t);
            return this;
        }

        public ProvisionDataComponent getDataFirstRep() {
            if (this.getData().isEmpty()) {
                this.addData();
            }
            return this.getData().get(0);
        }

        public List<ProvisionComponent> getProvision() {
            if (this.provision == null) {
                this.provision = new ArrayList<ProvisionComponent>();
            }
            return this.provision;
        }

        public ProvisionComponent setProvision(List<ProvisionComponent> theProvision) {
            this.provision = theProvision;
            return this;
        }

        public boolean hasProvision() {
            if (this.provision == null) {
                return false;
            }
            for (ProvisionComponent item : this.provision) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvisionComponent addProvision() {
            ProvisionComponent t = new ProvisionComponent();
            if (this.provision == null) {
                this.provision = new ArrayList<ProvisionComponent>();
            }
            this.provision.add(t);
            return t;
        }

        public ProvisionComponent addProvision(ProvisionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.provision == null) {
                this.provision = new ArrayList<ProvisionComponent>();
            }
            this.provision.add(t);
            return this;
        }

        public ProvisionComponent getProvisionFirstRep() {
            if (this.getProvision().isEmpty()) {
                this.addProvision();
            }
            return this.getProvision().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Action  to take - permit or deny - when the rule conditions are met.  Not permitted in root rule, required in all nested rules.", 0, 1, this.type));
            children.add(new Property(Consent.SP_PERIOD, "Period", "The timeframe in this rule is valid.", 0, 1, this.period));
            children.add(new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this rule. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor));
            children.add(new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this Rule.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("securityLabel", "Coding", "A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this rule.", 0, Integer.MAX_VALUE, this.purpose));
            children.add(new Property("class", "Coding", "The class of information covered by this rule. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.class_));
            children.add(new Property("code", "CodeableConcept", "If this code is found in an instance, then the rule applies.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this rule.", 0, 1, this.dataPeriod));
            children.add(new Property(Consent.SP_DATA, "", "The resources controlled by this rule if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data));
            children.add(new Property("provision", "@Consent.provision", "Rules which provide exceptions to the base rule or subrules.", 0, Integer.MAX_VALUE, this.provision));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Action  to take - permit or deny - when the rule conditions are met.  Not permitted in root rule, required in all nested rules.", 0, 1, this.type);
                }
                case -991726143: {
                    return new Property(Consent.SP_PERIOD, "Period", "The timeframe in this rule is valid.", 0, 1, this.period);
                }
                case 92645877: {
                    return new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this rule. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor);
                }
                case -1422950858: {
                    return new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this Rule.", 0, Integer.MAX_VALUE, this.action);
                }
                case -722296940: {
                    return new Property("securityLabel", "Coding", "A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case -220463842: {
                    return new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this rule.", 0, Integer.MAX_VALUE, this.purpose);
                }
                case 94742904: {
                    return new Property("class", "Coding", "The class of information covered by this rule. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.class_);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "If this code is found in an instance, then the rule applies.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1177250315: {
                    return new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this rule.", 0, 1, this.dataPeriod);
                }
                case 3076010: {
                    return new Property(Consent.SP_DATA, "", "The resources controlled by this rule if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data);
                }
                case -547120939: {
                    return new Property("provision", "@Consent.provision", "Rules which provide exceptions to the base rule or subrules.", 0, Integer.MAX_VALUE, this.provision);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 92645877: {
                    return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case -220463842: {
                    return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
                }
                case 94742904: {
                    return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1177250315: {
                    Base[] baseArray;
                    if (this.dataPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dataPeriod;
                    }
                    return baseArray;
                }
                case 3076010: {
                    return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
                }
                case -547120939: {
                    return this.provision == null ? new Base[]{} : this.provision.toArray(new Base[this.provision.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ConsentProvisionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 92645877: {
                    this.getActor().add((ProvisionActorComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -220463842: {
                    this.getPurpose().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case 94742904: {
                    this.getClass_().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1177250315: {
                    this.dataPeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 3076010: {
                    this.getData().add((ProvisionDataComponent)((Object)value));
                    return value;
                }
                case -547120939: {
                    this.getProvision().add((ProvisionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ConsentProvisionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals(Consent.SP_PERIOD)) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals(Consent.SP_ACTOR)) {
                this.getActor().add((ProvisionActorComponent)((Object)value));
            } else if (name.equals(Consent.SP_ACTION)) {
                this.getAction().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(TypeConvertor.castToCoding(value));
            } else if (name.equals(Consent.SP_PURPOSE)) {
                this.getPurpose().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("class")) {
                this.getClass_().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("code")) {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("dataPeriod")) {
                this.dataPeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals(Consent.SP_DATA)) {
                this.getData().add((ProvisionDataComponent)((Object)value));
            } else if (name.equals("provision")) {
                this.getProvision().add((ProvisionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 92645877: {
                    return this.addActor();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case -220463842: {
                    return this.addPurpose();
                }
                case 94742904: {
                    return this.addClass_();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1177250315: {
                    return this.getDataPeriod();
                }
                case 3076010: {
                    return this.addData();
                }
                case -547120939: {
                    return this.addProvision();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 92645877: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case -722296940: {
                    return new String[]{"Coding"};
                }
                case -220463842: {
                    return new String[]{"Coding"};
                }
                case 94742904: {
                    return new String[]{"Coding"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1177250315: {
                    return new String[]{"Period"};
                }
                case 3076010: {
                    return new String[0];
                }
                case -547120939: {
                    return new String[]{"@Consent.provision"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.provision.type");
            }
            if (name.equals(Consent.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals(Consent.SP_ACTOR)) {
                return this.addActor();
            }
            if (name.equals(Consent.SP_ACTION)) {
                return this.addAction();
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals(Consent.SP_PURPOSE)) {
                return this.addPurpose();
            }
            if (name.equals("class")) {
                return this.addClass_();
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("dataPeriod")) {
                this.dataPeriod = new Period();
                return this.dataPeriod;
            }
            if (name.equals(Consent.SP_DATA)) {
                return this.addData();
            }
            if (name.equals("provision")) {
                return this.addProvision();
            }
            return super.addChild(name);
        }

        @Override
        public ProvisionComponent copy() {
            ProvisionComponent dst = new ProvisionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvisionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.actor != null) {
                dst.actor = new ArrayList<ProvisionActorComponent>();
                for (ProvisionActorComponent provisionActorComponent : this.actor) {
                    dst.actor.add(provisionActorComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.action) {
                    dst.action.add(codeableConcept.copy());
                }
            }
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding : this.securityLabel) {
                    dst.securityLabel.add(coding.copy());
                }
            }
            if (this.purpose != null) {
                dst.purpose = new ArrayList<Coding>();
                for (Coding coding : this.purpose) {
                    dst.purpose.add(coding.copy());
                }
            }
            if (this.class_ != null) {
                dst.class_ = new ArrayList<Coding>();
                for (Coding coding : this.class_) {
                    dst.class_.add(coding.copy());
                }
            }
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            Period period2 = dst.dataPeriod = this.dataPeriod == null ? null : this.dataPeriod.copy();
            if (this.data != null) {
                dst.data = new ArrayList<ProvisionDataComponent>();
                for (ProvisionDataComponent provisionDataComponent : this.data) {
                    dst.data.add(provisionDataComponent.copy());
                }
            }
            if (this.provision != null) {
                dst.provision = new ArrayList<ProvisionComponent>();
                for (ProvisionComponent provisionComponent : this.provision) {
                    dst.provision.add(provisionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionComponent)) {
                return false;
            }
            ProvisionComponent o = (ProvisionComponent)other_;
            return ProvisionComponent.compareDeep(this.type, o.type, true) && ProvisionComponent.compareDeep(this.period, o.period, true) && ProvisionComponent.compareDeep(this.actor, o.actor, true) && ProvisionComponent.compareDeep(this.action, o.action, true) && ProvisionComponent.compareDeep(this.securityLabel, o.securityLabel, true) && ProvisionComponent.compareDeep(this.purpose, o.purpose, true) && ProvisionComponent.compareDeep(this.class_, o.class_, true) && ProvisionComponent.compareDeep(this.code, o.code, true) && ProvisionComponent.compareDeep(this.dataPeriod, o.dataPeriod, true) && ProvisionComponent.compareDeep(this.data, o.data, true) && ProvisionComponent.compareDeep(this.provision, o.provision, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionComponent)) {
                return false;
            }
            ProvisionComponent o = (ProvisionComponent)other_;
            return ProvisionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.period, this.actor, this.action, this.securityLabel, this.purpose, this.class_, this.code, this.dataPeriod, this.data, this.provision});
        }

        @Override
        public String fhirType() {
            return "Consent.provision";
        }
    }

    @Block
    public static class ConsentVerificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="verified", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Has been verified", formalDefinition="Has the instruction been verified.")
        protected BooleanType verified;
        @Child(name="verifiedWith", type={Patient.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Person who verified", formalDefinition="Who verified the instruction (Patient, Relative or other Authorized Person).")
        protected Reference verifiedWith;
        @Child(name="verificationDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When consent verified", formalDefinition="Date verification was collected.")
        protected DateTimeType verificationDate;
        private static final long serialVersionUID = 2114191641L;

        public ConsentVerificationComponent() {
        }

        public ConsentVerificationComponent(boolean verified) {
            this.setVerified(verified);
        }

        public BooleanType getVerifiedElement() {
            if (this.verified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verified");
                }
                if (Configuration.doAutoCreate()) {
                    this.verified = new BooleanType();
                }
            }
            return this.verified;
        }

        public boolean hasVerifiedElement() {
            return this.verified != null && !this.verified.isEmpty();
        }

        public boolean hasVerified() {
            return this.verified != null && !this.verified.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedElement(BooleanType value) {
            this.verified = value;
            return this;
        }

        public boolean getVerified() {
            return this.verified == null || this.verified.isEmpty() ? false : (Boolean)this.verified.getValue();
        }

        public ConsentVerificationComponent setVerified(boolean value) {
            if (this.verified == null) {
                this.verified = new BooleanType();
            }
            this.verified.setValue((Object)value);
            return this;
        }

        public Reference getVerifiedWith() {
            if (this.verifiedWith == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verifiedWith");
                }
                if (Configuration.doAutoCreate()) {
                    this.verifiedWith = new Reference();
                }
            }
            return this.verifiedWith;
        }

        public boolean hasVerifiedWith() {
            return this.verifiedWith != null && !this.verifiedWith.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedWith(Reference value) {
            this.verifiedWith = value;
            return this;
        }

        public DateTimeType getVerificationDateElement() {
            if (this.verificationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verificationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.verificationDate = new DateTimeType();
                }
            }
            return this.verificationDate;
        }

        public boolean hasVerificationDateElement() {
            return this.verificationDate != null && !this.verificationDate.isEmpty();
        }

        public boolean hasVerificationDate() {
            return this.verificationDate != null && !this.verificationDate.isEmpty();
        }

        public ConsentVerificationComponent setVerificationDateElement(DateTimeType value) {
            this.verificationDate = value;
            return this;
        }

        public Date getVerificationDate() {
            return this.verificationDate == null ? null : (Date)this.verificationDate.getValue();
        }

        public ConsentVerificationComponent setVerificationDate(Date value) {
            if (value == null) {
                this.verificationDate = null;
            } else {
                if (this.verificationDate == null) {
                    this.verificationDate = new DateTimeType();
                }
                this.verificationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("verified", "boolean", "Has the instruction been verified.", 0, 1, this.verified));
            children.add(new Property("verifiedWith", "Reference(Patient|RelatedPerson)", "Who verified the instruction (Patient, Relative or other Authorized Person).", 0, 1, this.verifiedWith));
            children.add(new Property("verificationDate", "dateTime", "Date verification was collected.", 0, 1, this.verificationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1994383672: {
                    return new Property("verified", "boolean", "Has the instruction been verified.", 0, 1, this.verified);
                }
                case -1425236050: {
                    return new Property("verifiedWith", "Reference(Patient|RelatedPerson)", "Who verified the instruction (Patient, Relative or other Authorized Person).", 0, 1, this.verifiedWith);
                }
                case 642233449: {
                    return new Property("verificationDate", "dateTime", "Date verification was collected.", 0, 1, this.verificationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    Base[] baseArray;
                    if (this.verified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.verified;
                    }
                    return baseArray;
                }
                case -1425236050: {
                    Base[] baseArray;
                    if (this.verifiedWith == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.verifiedWith;
                    }
                    return baseArray;
                }
                case 642233449: {
                    Base[] baseArray;
                    if (this.verificationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.verificationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    this.verified = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1425236050: {
                    this.verifiedWith = TypeConvertor.castToReference(value);
                    return value;
                }
                case 642233449: {
                    this.verificationDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("verified")) {
                this.verified = TypeConvertor.castToBoolean(value);
            } else if (name.equals("verifiedWith")) {
                this.verifiedWith = TypeConvertor.castToReference(value);
            } else if (name.equals("verificationDate")) {
                this.verificationDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    return this.getVerifiedElement();
                }
                case -1425236050: {
                    return this.getVerifiedWith();
                }
                case 642233449: {
                    return this.getVerificationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    return new String[]{"boolean"};
                }
                case -1425236050: {
                    return new String[]{"Reference"};
                }
                case 642233449: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("verified")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.verification.verified");
            }
            if (name.equals("verifiedWith")) {
                this.verifiedWith = new Reference();
                return this.verifiedWith;
            }
            if (name.equals("verificationDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.verification.verificationDate");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentVerificationComponent copy() {
            ConsentVerificationComponent dst = new ConsentVerificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConsentVerificationComponent dst) {
            super.copyValues(dst);
            dst.verified = this.verified == null ? null : this.verified.copy();
            dst.verifiedWith = this.verifiedWith == null ? null : this.verifiedWith.copy();
            dst.verificationDate = this.verificationDate == null ? null : this.verificationDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentVerificationComponent)) {
                return false;
            }
            ConsentVerificationComponent o = (ConsentVerificationComponent)other_;
            return ConsentVerificationComponent.compareDeep(this.verified, o.verified, true) && ConsentVerificationComponent.compareDeep(this.verifiedWith, o.verifiedWith, true) && ConsentVerificationComponent.compareDeep(this.verificationDate, o.verificationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentVerificationComponent)) {
                return false;
            }
            ConsentVerificationComponent o = (ConsentVerificationComponent)other_;
            return ConsentVerificationComponent.compareValues(this.verified, o.verified, true) && ConsentVerificationComponent.compareValues(this.verificationDate, o.verificationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.verified, this.verifiedWith, this.verificationDate});
        }

        @Override
        public String fhirType() {
            return "Consent.verification";
        }
    }

    @Block
    public static class ConsentPolicyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authority", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Enforcement source for policy", formalDefinition="Entity or Organization having regulatory jurisdiction or accountability for  enforcing policies pertaining to Consent Directives.")
        protected UriType authority;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific policy covered by this consent", formalDefinition="The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.")
        protected UriType uri;
        private static final long serialVersionUID = 672275705L;

        public UriType getAuthorityElement() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new UriType();
                }
            }
            return this.authority;
        }

        public boolean hasAuthorityElement() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public ConsentPolicyComponent setAuthorityElement(UriType value) {
            this.authority = value;
            return this;
        }

        public String getAuthority() {
            return this.authority == null ? null : (String)this.authority.getValue();
        }

        public ConsentPolicyComponent setAuthority(String value) {
            if (Utilities.noString((String)value)) {
                this.authority = null;
            } else {
                if (this.authority == null) {
                    this.authority = new UriType();
                }
                this.authority.setValue(value);
            }
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ConsentPolicyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ConsentPolicyComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authority", "uri", "Entity or Organization having regulatory jurisdiction or accountability for  enforcing policies pertaining to Consent Directives.", 0, 1, this.authority));
            children.add(new Property("uri", "uri", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, 1, this.uri));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1475610435: {
                    return new Property("authority", "uri", "Entity or Organization having regulatory jurisdiction or accountability for  enforcing policies pertaining to Consent Directives.", 0, 1, this.authority);
                }
                case 116076: {
                    return new Property("uri", "uri", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, 1, this.uri);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authority;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    this.authority = TypeConvertor.castToUri(value);
                    return value;
                }
                case 116076: {
                    this.uri = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = TypeConvertor.castToUri(value);
            } else if (name.equals("uri")) {
                this.uri = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return this.getAuthorityElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return new String[]{"uri"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authority")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.policy.authority");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.policy.uri");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentPolicyComponent copy() {
            ConsentPolicyComponent dst = new ConsentPolicyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConsentPolicyComponent dst) {
            super.copyValues(dst);
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyComponent)) {
                return false;
            }
            ConsentPolicyComponent o = (ConsentPolicyComponent)other_;
            return ConsentPolicyComponent.compareDeep(this.authority, o.authority, true) && ConsentPolicyComponent.compareDeep(this.uri, o.uri, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyComponent)) {
                return false;
            }
            ConsentPolicyComponent o = (ConsentPolicyComponent)other_;
            return ConsentPolicyComponent.compareValues(this.authority, o.authority, true) && ConsentPolicyComponent.compareValues(this.uri, o.uri, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authority, this.uri});
        }

        @Override
        public String fhirType() {
            return "Consent.policy";
        }
    }

    public static class ConsentStateEnumFactory
    implements EnumFactory<ConsentState> {
        @Override
        public ConsentState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ConsentState.DRAFT;
            }
            if ("proposed".equals(codeString)) {
                return ConsentState.PROPOSED;
            }
            if ("active".equals(codeString)) {
                return ConsentState.ACTIVE;
            }
            if ("rejected".equals(codeString)) {
                return ConsentState.REJECTED;
            }
            if ("inactive".equals(codeString)) {
                return ConsentState.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ConsentState.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ConsentState code '" + codeString + "'");
        }

        public Enumeration<ConsentState> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentState>(this, ConsentState.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.DRAFT, code);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.PROPOSED, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ACTIVE, code);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.REJECTED, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentState code) {
            if (code == ConsentState.DRAFT) {
                return "draft";
            }
            if (code == ConsentState.PROPOSED) {
                return "proposed";
            }
            if (code == ConsentState.ACTIVE) {
                return "active";
            }
            if (code == ConsentState.REJECTED) {
                return "rejected";
            }
            if (code == ConsentState.INACTIVE) {
                return "inactive";
            }
            if (code == ConsentState.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentState code) {
            return code.getSystem();
        }
    }

    public static enum ConsentState {
        DRAFT,
        PROPOSED,
        ACTIVE,
        REJECTED,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static ConsentState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case PROPOSED: {
                    return "proposed";
                }
                case ACTIVE: {
                    return "active";
                }
                case REJECTED: {
                    return "rejected";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case PROPOSED: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The consent is in development or awaiting use but is not yet intended to be acted upon.";
                }
                case PROPOSED: {
                    return "The consent has been proposed but not yet agreed to by all parties. The negotiation stage.";
                }
                case ACTIVE: {
                    return "The consent is to be followed and enforced.";
                }
                case REJECTED: {
                    return "The consent has been rejected by one or more of the parties.";
                }
                case INACTIVE: {
                    return "The consent is terminated or replaced.";
                }
                case ENTEREDINERROR: {
                    return "The consent was created wrongly (e.g. wrong patient) and should be ignored.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Pending";
                }
                case PROPOSED: {
                    return "Proposed";
                }
                case ACTIVE: {
                    return "Active";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConsentProvisionTypeEnumFactory
    implements EnumFactory<ConsentProvisionType> {
        @Override
        public ConsentProvisionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return ConsentProvisionType.DENY;
            }
            if ("permit".equals(codeString)) {
                return ConsentProvisionType.PERMIT;
            }
            throw new IllegalArgumentException("Unknown ConsentProvisionType code '" + codeString + "'");
        }

        public Enumeration<ConsentProvisionType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentProvisionType>(this, ConsentProvisionType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConsentProvisionType>(this, ConsentProvisionType.NULL, code);
            }
            if ("deny".equals(codeString)) {
                return new Enumeration<ConsentProvisionType>(this, ConsentProvisionType.DENY, code);
            }
            if ("permit".equals(codeString)) {
                return new Enumeration<ConsentProvisionType>(this, ConsentProvisionType.PERMIT, code);
            }
            throw new FHIRException("Unknown ConsentProvisionType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentProvisionType code) {
            if (code == ConsentProvisionType.DENY) {
                return "deny";
            }
            if (code == ConsentProvisionType.PERMIT) {
                return "permit";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentProvisionType code) {
            return code.getSystem();
        }
    }

    public static enum ConsentProvisionType {
        DENY,
        PERMIT,
        NULL;


        public static ConsentProvisionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return DENY;
            }
            if ("permit".equals(codeString)) {
                return PERMIT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentProvisionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DENY: {
                    return "deny";
                }
                case PERMIT: {
                    return "permit";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DENY: {
                    return "http://hl7.org/fhir/consent-provision-type";
                }
                case PERMIT: {
                    return "http://hl7.org/fhir/consent-provision-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DENY: {
                    return "Consent is denied for actions meeting these rules.";
                }
                case PERMIT: {
                    return "Consent is provided for actions meeting these rules.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DENY: {
                    return "Opt Out";
                }
                case PERMIT: {
                    return "Opt In";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConsentDataMeaningEnumFactory
    implements EnumFactory<ConsentDataMeaning> {
        @Override
        public ConsentDataMeaning fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return ConsentDataMeaning.INSTANCE;
            }
            if ("related".equals(codeString)) {
                return ConsentDataMeaning.RELATED;
            }
            if ("dependents".equals(codeString)) {
                return ConsentDataMeaning.DEPENDENTS;
            }
            if ("authoredby".equals(codeString)) {
                return ConsentDataMeaning.AUTHOREDBY;
            }
            throw new IllegalArgumentException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        public Enumeration<ConsentDataMeaning> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.NULL, code);
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.INSTANCE, code);
            }
            if ("related".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.RELATED, code);
            }
            if ("dependents".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.DEPENDENTS, code);
            }
            if ("authoredby".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.AUTHOREDBY, code);
            }
            throw new FHIRException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentDataMeaning code) {
            if (code == ConsentDataMeaning.INSTANCE) {
                return "instance";
            }
            if (code == ConsentDataMeaning.RELATED) {
                return "related";
            }
            if (code == ConsentDataMeaning.DEPENDENTS) {
                return "dependents";
            }
            if (code == ConsentDataMeaning.AUTHOREDBY) {
                return "authoredby";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentDataMeaning code) {
            return code.getSystem();
        }
    }

    public static enum ConsentDataMeaning {
        INSTANCE,
        RELATED,
        DEPENDENTS,
        AUTHOREDBY,
        NULL;


        public static ConsentDataMeaning fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("related".equals(codeString)) {
                return RELATED;
            }
            if ("dependents".equals(codeString)) {
                return DEPENDENTS;
            }
            if ("authoredby".equals(codeString)) {
                return AUTHOREDBY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case RELATED: {
                    return "related";
                }
                case DEPENDENTS: {
                    return "dependents";
                }
                case AUTHOREDBY: {
                    return "authoredby";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case RELATED: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case DEPENDENTS: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case AUTHOREDBY: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The consent applies directly to the instance of the resource.";
                }
                case RELATED: {
                    return "The consent applies directly to the instance of the resource and instances it refers to.";
                }
                case DEPENDENTS: {
                    return "The consent applies directly to the instance of the resource and instances that refer to it.";
                }
                case AUTHOREDBY: {
                    return "The consent applies to instances of resources that are authored by.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case RELATED: {
                    return "Related";
                }
                case DEPENDENTS: {
                    return "Dependents";
                }
                case AUTHOREDBY: {
                    return "AuthoredBy";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

