/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConceptMap", profile="http://hl7.org/fhir/StructureDefinition/ConceptMap")
public class ConceptMap
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this concept map, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the concept map", formalDefinition="A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the concept map", formalDefinition="The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this concept map (computer friendly)", formalDefinition="A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this concept map (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the concept map.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this concept map. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the concept map was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the concept map.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the concept map", formalDefinition="A free text natural language description of the concept map from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for concept map (if applicable)", formalDefinition="A legal or geographic region in which the concept map is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this concept map is defined", formalDefinition="Explanation of why this concept map is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.")
    protected MarkdownType copyright;
    @Child(name="source", type={UriType.class, CanonicalType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source value set that contains the concepts that are being mapped", formalDefinition="Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.")
    protected DataType source;
    @Child(name="target", type={UriType.class, CanonicalType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The target value set which provides context for the mappings", formalDefinition="The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.")
    protected DataType target;
    @Child(name="group", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Same source and target systems", formalDefinition="A group of mappings that all have the same source and target system.")
    protected List<ConceptMapGroupComponent> group;
    private static final long serialVersionUID = 1735271896L;
    @SearchParamDefinition(name="dependson", path="ConceptMap.group.element.target.dependsOn.property", description="Reference to property mapping depends on", type="uri")
    public static final String SP_DEPENDSON = "dependson";
    public static final UriClientParam DEPENDSON = new UriClientParam("dependson");
    @SearchParamDefinition(name="other", path="ConceptMap.group.unmapped.url", description="canonical reference to an additional ConceptMap to use for mapping if the source concept is unmapped", type="reference", target={ConceptMap.class})
    public static final String SP_OTHER = "other";
    public static final ReferenceClientParam OTHER = new ReferenceClientParam("other");
    public static final Include INCLUDE_OTHER = new Include("ConceptMap:other").toLocked();
    @SearchParamDefinition(name="product", path="ConceptMap.group.element.target.product.property", description="Reference to property mapping depends on", type="uri")
    public static final String SP_PRODUCT = "product";
    public static final UriClientParam PRODUCT = new UriClientParam("product");
    @SearchParamDefinition(name="source-code", path="ConceptMap.group.element.code", description="Identifies element being mapped", type="token")
    public static final String SP_SOURCE_CODE = "source-code";
    public static final TokenClientParam SOURCE_CODE = new TokenClientParam("source-code");
    @SearchParamDefinition(name="source-system", path="ConceptMap.group.source", description="Source system where concepts to be mapped are defined", type="uri")
    public static final String SP_SOURCE_SYSTEM = "source-system";
    public static final UriClientParam SOURCE_SYSTEM = new UriClientParam("source-system");
    @SearchParamDefinition(name="source-uri", path="(ConceptMap.source as uri)", description="The source value set that contains the concepts that are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE_URI = "source-uri";
    public static final ReferenceClientParam SOURCE_URI = new ReferenceClientParam("source-uri");
    public static final Include INCLUDE_SOURCE_URI = new Include("ConceptMap:source-uri").toLocked();
    @SearchParamDefinition(name="source", path="(ConceptMap.source as canonical)", description="The source value set that contains the concepts that are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("ConceptMap:source").toLocked();
    @SearchParamDefinition(name="target-code", path="ConceptMap.group.element.target.code", description="Code that identifies the target element", type="token")
    public static final String SP_TARGET_CODE = "target-code";
    public static final TokenClientParam TARGET_CODE = new TokenClientParam("target-code");
    @SearchParamDefinition(name="target-system", path="ConceptMap.group.target", description="Target system that the concepts are to be mapped to", type="uri")
    public static final String SP_TARGET_SYSTEM = "target-system";
    public static final UriClientParam TARGET_SYSTEM = new UriClientParam("target-system");
    @SearchParamDefinition(name="target-uri", path="(ConceptMap.target as uri)", description="The target value set which provides context for the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET_URI = "target-uri";
    public static final ReferenceClientParam TARGET_URI = new ReferenceClientParam("target-uri");
    public static final Include INCLUDE_TARGET_URI = new Include("ConceptMap:target-uri").toLocked();
    @SearchParamDefinition(name="target", path="(ConceptMap.target as canonical)", description="The target value set which provides context for the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("ConceptMap:target").toLocked();
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="CodeSystem.identifier | ConceptMap.identifier | MessageDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="CapabilityStatement.title | CodeSystem.title | ConceptMap.title | ImplementationGuide.title | MessageDefinition.title | OperationDefinition.title | StructureDefinition.title | StructureMap.title | TerminologyCapabilities.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ConceptMap() {
    }

    public ConceptMap(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ConceptMap setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ConceptMap setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public int getIdentifierMax() {
        return 1;
    }

    @Override
    public List<Identifier> getIdentifier() {
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        if (this.identifier == null) {
            list.add(this.identifier);
        }
        return list;
    }

    @Override
    public ConceptMap setIdentifier(List<Identifier> theIdentifier) {
        if (theIdentifier.size() == 0) {
            this.identifier = null;
        } else if (theIdentifier.size() == 1) {
            this.identifier = theIdentifier.get(0);
        } else {
            throw new Error("Cannot have more than one ConceptMap.identifier");
        }
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    @Override
    public Identifier addIdentifier() {
        if (this.identifier != null) {
            throw new Error("Cannot have more than one ConceptMap.identifier");
        }
        this.identifier = new Identifier();
        return this.identifier;
    }

    @Override
    public ConceptMap addIdentifier(Identifier t) {
        if (this.identifier != null) {
            throw new Error("Cannot have more than one ConceptMap.identifier");
        }
        this.identifier = t;
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.identifier == null) {
            this.addIdentifier();
        }
        return this.identifier;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ConceptMap setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ConceptMap setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ConceptMap setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ConceptMap setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ConceptMap setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ConceptMap setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ConceptMap setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ConceptMap setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ConceptMap setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ConceptMap setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ConceptMap setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ConceptMap setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ConceptMap setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ConceptMap setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ConceptMap setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ConceptMap addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ConceptMap setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ConceptMap setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ConceptMap setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ConceptMap addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ConceptMap setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ConceptMap addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ConceptMap setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ConceptMap setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ConceptMap setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ConceptMap setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DataType getSource() {
        return this.source;
    }

    public UriType getSourceUriType() throws FHIRException {
        if (this.source == null) {
            this.source = new UriType();
        }
        if (!(this.source instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (UriType)this.source;
    }

    public boolean hasSourceUriType() {
        return this != null && this.source instanceof UriType;
    }

    public CanonicalType getSourceCanonicalType() throws FHIRException {
        if (this.source == null) {
            this.source = new CanonicalType();
        }
        if (!(this.source instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.source;
    }

    public boolean hasSourceCanonicalType() {
        return this != null && this.source instanceof CanonicalType;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public ConceptMap setSource(DataType value) {
        if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
            throw new Error("Not the right type for ConceptMap.source[x]: " + value.fhirType());
        }
        this.source = value;
        return this;
    }

    public DataType getTarget() {
        return this.target;
    }

    public UriType getTargetUriType() throws FHIRException {
        if (this.target == null) {
            this.target = new UriType();
        }
        if (!(this.target instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (UriType)this.target;
    }

    public boolean hasTargetUriType() {
        return this != null && this.target instanceof UriType;
    }

    public CanonicalType getTargetCanonicalType() throws FHIRException {
        if (this.target == null) {
            this.target = new CanonicalType();
        }
        if (!(this.target instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.target;
    }

    public boolean hasTargetCanonicalType() {
        return this != null && this.target instanceof CanonicalType;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public ConceptMap setTarget(DataType value) {
        if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
            throw new Error("Not the right type for ConceptMap.target[x]: " + value.fhirType());
        }
        this.target = value;
        return this;
    }

    public List<ConceptMapGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        return this.group;
    }

    public ConceptMap setGroup(List<ConceptMapGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (ConceptMapGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptMapGroupComponent addGroup() {
        ConceptMapGroupComponent t = new ConceptMapGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public ConceptMap addGroup(ConceptMapGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public ConceptMapGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the concept map.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright));
        children.add(new Property("source[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source));
        children.add(new Property("target[x]", "uri|canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target));
        children.add(new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the concept map.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright);
            }
            case -1698413947: {
                return new Property("source[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case -896505829: {
                return new Property("source[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case -1698419887: {
                return new Property("source[x]", "uri", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case 1509247769: {
                return new Property("source[x]", "canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case -815579825: {
                return new Property("target[x]", "uri|canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -880905839: {
                return new Property("target[x]", "uri|canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -815585765: {
                return new Property("target[x]", "uri", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -1281653149: {
                return new Property("target[x]", "canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case 98629247: {
                return new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.source;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.target;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToType(value);
                return value;
            }
            case -880905839: {
                this.target = TypeConvertor.castToType(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((ConceptMapGroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("source[x]")) {
            this.source = TypeConvertor.castToType(value);
        } else if (name.equals("target[x]")) {
            this.target = TypeConvertor.castToType(value);
        } else if (name.equals("group")) {
            this.getGroup().add((ConceptMapGroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = null;
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("source[x]")) {
            this.source = null;
        } else if (name.equals("target[x]")) {
            this.target = null;
        } else if (name.equals("group")) {
            this.getGroup().remove((ConceptMapGroupComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.getIdentifierFirstRep();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -1698413947: {
                return this.getSource();
            }
            case -896505829: {
                return this.getSource();
            }
            case -815579825: {
                return this.getTarget();
            }
            case -880905839: {
                return this.getTarget();
            }
            case 98629247: {
                return this.addGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -896505829: {
                return new String[]{"uri", "canonical"};
            }
            case -880905839: {
                return new String[]{"uri", "canonical"};
            }
            case 98629247: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.copyright");
        }
        if (name.equals("sourceUri")) {
            this.source = new UriType();
            return this.source;
        }
        if (name.equals("sourceCanonical")) {
            this.source = new CanonicalType();
            return this.source;
        }
        if (name.equals("targetUri")) {
            this.target = new UriType();
            return this.target;
        }
        if (name.equals("targetCanonical")) {
            this.target = new CanonicalType();
            return this.target;
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConceptMap";
    }

    @Override
    public ConceptMap copy() {
        ConceptMap dst = new ConceptMap();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ConceptMap dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.source = this.source == null ? null : this.source.copy();
        DataType dataType = dst.target = this.target == null ? null : this.target.copy();
        if (this.group != null) {
            dst.group = new ArrayList<ConceptMapGroupComponent>();
            for (ConceptMapGroupComponent conceptMapGroupComponent : this.group) {
                dst.group.add(conceptMapGroupComponent.copy());
            }
        }
    }

    protected ConceptMap typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other_;
        return ConceptMap.compareDeep(this.url, o.url, true) && ConceptMap.compareDeep(this.identifier, o.identifier, true) && ConceptMap.compareDeep(this.version, o.version, true) && ConceptMap.compareDeep(this.name, o.name, true) && ConceptMap.compareDeep(this.title, o.title, true) && ConceptMap.compareDeep(this.status, o.status, true) && ConceptMap.compareDeep(this.experimental, o.experimental, true) && ConceptMap.compareDeep(this.date, o.date, true) && ConceptMap.compareDeep(this.publisher, o.publisher, true) && ConceptMap.compareDeep(this.contact, o.contact, true) && ConceptMap.compareDeep(this.description, o.description, true) && ConceptMap.compareDeep(this.useContext, o.useContext, true) && ConceptMap.compareDeep(this.jurisdiction, o.jurisdiction, true) && ConceptMap.compareDeep(this.purpose, o.purpose, true) && ConceptMap.compareDeep(this.copyright, o.copyright, true) && ConceptMap.compareDeep(this.source, o.source, true) && ConceptMap.compareDeep(this.target, o.target, true) && ConceptMap.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other_;
        return ConceptMap.compareValues(this.url, o.url, true) && ConceptMap.compareValues(this.version, o.version, true) && ConceptMap.compareValues(this.name, o.name, true) && ConceptMap.compareValues(this.title, o.title, true) && ConceptMap.compareValues(this.status, o.status, true) && ConceptMap.compareValues(this.experimental, o.experimental, true) && ConceptMap.compareValues(this.date, o.date, true) && ConceptMap.compareValues(this.publisher, o.publisher, true) && ConceptMap.compareValues(this.description, o.description, true) && ConceptMap.compareValues(this.purpose, o.purpose, true) && ConceptMap.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.source, this.target, this.group});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConceptMap;
    }

    @Block
    public static class ConceptMapGroupUnmappedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="provided | fixed | other-map", formalDefinition="Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conceptmap-unmapped-mode")
        protected Enumeration<ConceptMapGroupUnmappedMode> mode;
        @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed code when mode = fixed", formalDefinition="The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="url", type={CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="canonical reference to an additional ConceptMap to use for mapping if the source concept is unmapped", formalDefinition="The canonical reference to an additional ConceptMap resource instance to use for mapping if this ConceptMap resource contains no matching mapping for the source concept.")
        protected CanonicalType url;
        private static final long serialVersionUID = 1261364354L;

        public ConceptMapGroupUnmappedComponent() {
        }

        public ConceptMapGroupUnmappedComponent(ConceptMapGroupUnmappedMode mode) {
            this.setMode(mode);
        }

        public Enumeration<ConceptMapGroupUnmappedMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<ConceptMapGroupUnmappedMode>(new ConceptMapGroupUnmappedModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setModeElement(Enumeration<ConceptMapGroupUnmappedMode> value) {
            this.mode = value;
            return this;
        }

        public ConceptMapGroupUnmappedMode getMode() {
            return this.mode == null ? null : (ConceptMapGroupUnmappedMode)((Object)this.mode.getValue());
        }

        public ConceptMapGroupUnmappedComponent setMode(ConceptMapGroupUnmappedMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<ConceptMapGroupUnmappedMode>(new ConceptMapGroupUnmappedModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptMapGroupUnmappedComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptMapGroupUnmappedComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new CanonicalType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setUrlElement(CanonicalType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public ConceptMapGroupUnmappedComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new CanonicalType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode));
            children.add(new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property(ConceptMap.SP_URL, "canonical(ConceptMap)", "The canonical reference to an additional ConceptMap resource instance to use for mapping if this ConceptMap resource contains no matching mapping for the source concept.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode);
                }
                case 3059181: {
                    return new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case 116079: {
                    return new Property(ConceptMap.SP_URL, "canonical(ConceptMap)", "The canonical reference to an additional ConceptMap resource instance to use for mapping if this ConceptMap resource contains no matching mapping for the source concept.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.display;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals(ConceptMap.SP_URL)) {
                this.url = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = null;
            } else if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals(ConceptMap.SP_URL)) {
                this.url = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.mode");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.display");
            }
            if (name.equals(ConceptMap.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.url");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapGroupUnmappedComponent copy() {
            ConceptMapGroupUnmappedComponent dst = new ConceptMapGroupUnmappedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptMapGroupUnmappedComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupUnmappedComponent)) {
                return false;
            }
            ConceptMapGroupUnmappedComponent o = (ConceptMapGroupUnmappedComponent)other_;
            return ConceptMapGroupUnmappedComponent.compareDeep(this.mode, o.mode, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.code, o.code, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.display, o.display, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupUnmappedComponent)) {
                return false;
            }
            ConceptMapGroupUnmappedComponent o = (ConceptMapGroupUnmappedComponent)other_;
            return ConceptMapGroupUnmappedComponent.compareValues(this.mode, o.mode, true) && ConceptMapGroupUnmappedComponent.compareValues(this.code, o.code, true) && ConceptMapGroupUnmappedComponent.compareValues(this.display, o.display, true) && ConceptMapGroupUnmappedComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.code, this.display, this.url});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.unmapped";
        }
    }

    @Block
    public static class OtherElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="property", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to property mapping depends on", formalDefinition="A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somewhere that is labeled to correspond with a code system property.")
        protected UriType property;
        @Child(name="system", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code System (if necessary)", formalDefinition="An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).")
        protected CanonicalType system;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the referenced element", formalDefinition="Identity (code or path) or the element/item/ValueSet/text that the map depends on / refers to.")
        protected StringType value;
        @Child(name="display", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code (if value is a code)", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        private static final long serialVersionUID = -1836341923L;

        public OtherElementComponent() {
        }

        public OtherElementComponent(String property, String value) {
            this.setProperty(property);
            this.setValue(value);
        }

        public UriType getPropertyElement() {
            if (this.property == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.property");
                }
                if (Configuration.doAutoCreate()) {
                    this.property = new UriType();
                }
            }
            return this.property;
        }

        public boolean hasPropertyElement() {
            return this.property != null && !this.property.isEmpty();
        }

        public boolean hasProperty() {
            return this.property != null && !this.property.isEmpty();
        }

        public OtherElementComponent setPropertyElement(UriType value) {
            this.property = value;
            return this;
        }

        public String getProperty() {
            return this.property == null ? null : (String)this.property.getValue();
        }

        public OtherElementComponent setProperty(String value) {
            if (this.property == null) {
                this.property = new UriType();
            }
            this.property.setValue(value);
            return this;
        }

        public CanonicalType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new CanonicalType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public OtherElementComponent setSystemElement(CanonicalType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public OtherElementComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new CanonicalType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public OtherElementComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public OtherElementComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public OtherElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public OtherElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("property", "uri", "A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somewhere that is labeled to correspond with a code system property.", 0, 1, this.property));
            children.add(new Property("system", "canonical(CodeSystem)", "An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).", 0, 1, this.system));
            children.add(new Property("value", "string", "Identity (code or path) or the element/item/ValueSet/text that the map depends on / refers to.", 0, 1, this.value));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -993141291: {
                    return new Property("property", "uri", "A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somewhere that is labeled to correspond with a code system property.", 0, 1, this.property);
                }
                case -887328209: {
                    return new Property("system", "canonical(CodeSystem)", "An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).", 0, 1, this.system);
                }
                case 111972721: {
                    return new Property("value", "string", "Identity (code or path) or the element/item/ValueSet/text that the map depends on / refers to.", 0, 1, this.value);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    Base[] baseArray;
                    if (this.property == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.property;
                    }
                    return baseArray;
                }
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.system;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.display;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    this.property = TypeConvertor.castToUri(value);
                    return value;
                }
                case -887328209: {
                    this.system = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = TypeConvertor.castToUri(value);
            } else if (name.equals("system")) {
                this.system = TypeConvertor.castToCanonical(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = null;
            } else if (name.equals("system")) {
                this.system = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return this.getPropertyElement();
                }
                case -887328209: {
                    return this.getSystemElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return new String[]{"uri"};
                }
                case -887328209: {
                    return new String[]{"canonical"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.dependsOn.property");
            }
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.dependsOn.system");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.dependsOn.value");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.dependsOn.display");
            }
            return super.addChild(name);
        }

        @Override
        public OtherElementComponent copy() {
            OtherElementComponent dst = new OtherElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OtherElementComponent dst) {
            super.copyValues(dst);
            dst.property = this.property == null ? null : this.property.copy();
            dst.system = this.system == null ? null : this.system.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.display = this.display == null ? null : this.display.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareDeep(this.property, o.property, true) && OtherElementComponent.compareDeep(this.system, o.system, true) && OtherElementComponent.compareDeep(this.value, o.value, true) && OtherElementComponent.compareDeep(this.display, o.display, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareValues(this.property, o.property, true) && OtherElementComponent.compareValues(this.system, o.system, true) && OtherElementComponent.compareValues(this.value, o.value, true) && OtherElementComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.property, this.system, this.value, this.display});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target.dependsOn";
        }
    }

    @Block
    public static class TargetElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies the target element", formalDefinition="Identity (code or path) or the element/item that the map refers to.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="equivalence", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="relatedto | equivalent | equal | wider | subsumes | narrower | specializes | inexact | unmatched | disjoint", formalDefinition="The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-map-equivalence")
        protected Enumeration<ConceptMapEquivalence> equivalence;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of status/issues in mapping", formalDefinition="A description of status/issues in mapping that conveys additional information not represented in  the structured data.")
        protected StringType comment;
        @Child(name="dependsOn", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other elements required for this mapping (from context)", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.")
        protected List<OtherElementComponent> dependsOn;
        @Child(name="product", type={OtherElementComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other concepts that this mapping also produces", formalDefinition="A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.")
        protected List<OtherElementComponent> product;
        private static final long serialVersionUID = -2008997477L;

        public TargetElementComponent() {
        }

        public TargetElementComponent(ConceptMapEquivalence equivalence) {
            this.setEquivalence(equivalence);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TargetElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TargetElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public TargetElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public TargetElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public Enumeration<ConceptMapEquivalence> getEquivalenceElement() {
            if (this.equivalence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.equivalence");
                }
                if (Configuration.doAutoCreate()) {
                    this.equivalence = new Enumeration<ConceptMapEquivalence>(new ConceptMapEquivalenceEnumFactory());
                }
            }
            return this.equivalence;
        }

        public boolean hasEquivalenceElement() {
            return this.equivalence != null && !this.equivalence.isEmpty();
        }

        public boolean hasEquivalence() {
            return this.equivalence != null && !this.equivalence.isEmpty();
        }

        public TargetElementComponent setEquivalenceElement(Enumeration<ConceptMapEquivalence> value) {
            this.equivalence = value;
            return this;
        }

        public ConceptMapEquivalence getEquivalence() {
            return this.equivalence == null ? null : (ConceptMapEquivalence)((Object)this.equivalence.getValue());
        }

        public TargetElementComponent setEquivalence(ConceptMapEquivalence value) {
            if (this.equivalence == null) {
                this.equivalence = new Enumeration<ConceptMapEquivalence>(new ConceptMapEquivalenceEnumFactory());
            }
            this.equivalence.setValue((Object)value);
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public TargetElementComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public TargetElementComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public List<OtherElementComponent> getDependsOn() {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            return this.dependsOn;
        }

        public TargetElementComponent setDependsOn(List<OtherElementComponent> theDependsOn) {
            this.dependsOn = theDependsOn;
            return this;
        }

        public boolean hasDependsOn() {
            if (this.dependsOn == null) {
                return false;
            }
            for (OtherElementComponent item : this.dependsOn) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addDependsOn() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return t;
        }

        public TargetElementComponent addDependsOn(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return this;
        }

        public OtherElementComponent getDependsOnFirstRep() {
            if (this.getDependsOn().isEmpty()) {
                this.addDependsOn();
            }
            return this.getDependsOn().get(0);
        }

        public List<OtherElementComponent> getProduct() {
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            return this.product;
        }

        public TargetElementComponent setProduct(List<OtherElementComponent> theProduct) {
            this.product = theProduct;
            return this;
        }

        public boolean hasProduct() {
            if (this.product == null) {
                return false;
            }
            for (OtherElementComponent item : this.product) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addProduct() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return t;
        }

        public TargetElementComponent addProduct(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return this;
        }

        public OtherElementComponent getProductFirstRep() {
            if (this.getProduct().isEmpty()) {
                this.addProduct();
            }
            return this.getProduct().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("equivalence", "code", "The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).", 0, 1, this.equivalence));
            children.add(new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment));
            children.add(new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn));
            children.add(new Property(ConceptMap.SP_PRODUCT, "@ConceptMap.group.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.", 0, Integer.MAX_VALUE, this.product));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -15828692: {
                    return new Property("equivalence", "code", "The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).", 0, 1, this.equivalence);
                }
                case 950398559: {
                    return new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment);
                }
                case -1109214266: {
                    return new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn);
                }
                case -309474065: {
                    return new Property(ConceptMap.SP_PRODUCT, "@ConceptMap.group.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.", 0, Integer.MAX_VALUE, this.product);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -15828692: {
                    Base[] baseArray;
                    if (this.equivalence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.equivalence;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
                case -1109214266: {
                    return this.dependsOn == null ? new Base[]{} : this.dependsOn.toArray(new Base[this.dependsOn.size()]);
                }
                case -309474065: {
                    return this.product == null ? new Base[]{} : this.product.toArray(new Base[this.product.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -15828692: {
                    value = new ConceptMapEquivalenceEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.equivalence = value;
                    return value;
                }
                case 950398559: {
                    this.comment = TypeConvertor.castToString(value);
                    return value;
                }
                case -1109214266: {
                    this.getDependsOn().add((OtherElementComponent)((Object)value));
                    return value;
                }
                case -309474065: {
                    this.getProduct().add((OtherElementComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("equivalence")) {
                value = new ConceptMapEquivalenceEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.equivalence = value;
            } else if (name.equals("comment")) {
                this.comment = TypeConvertor.castToString(value);
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().add((OtherElementComponent)((Object)value));
            } else if (name.equals(ConceptMap.SP_PRODUCT)) {
                this.getProduct().add((OtherElementComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("equivalence")) {
                this.equivalence = null;
            } else if (name.equals("comment")) {
                this.comment = null;
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().remove((OtherElementComponent)value);
            } else if (name.equals(ConceptMap.SP_PRODUCT)) {
                this.getProduct().remove((OtherElementComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -15828692: {
                    return this.getEquivalenceElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case -1109214266: {
                    return this.addDependsOn();
                }
                case -309474065: {
                    return this.addProduct();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -15828692: {
                    return new String[]{"code"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case -1109214266: {
                    return new String[0];
                }
                case -309474065: {
                    return new String[]{"@ConceptMap.group.element.target.dependsOn"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.display");
            }
            if (name.equals("equivalence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.equivalence");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.comment");
            }
            if (name.equals("dependsOn")) {
                return this.addDependsOn();
            }
            if (name.equals(ConceptMap.SP_PRODUCT)) {
                return this.addProduct();
            }
            return super.addChild(name);
        }

        @Override
        public TargetElementComponent copy() {
            TargetElementComponent dst = new TargetElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TargetElementComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.equivalence = this.equivalence == null ? null : this.equivalence.copy();
            StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
            if (this.dependsOn != null) {
                dst.dependsOn = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.dependsOn) {
                    dst.dependsOn.add(i.copy());
                }
            }
            if (this.product != null) {
                dst.product = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.product) {
                    dst.product.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareDeep(this.code, o.code, true) && TargetElementComponent.compareDeep(this.display, o.display, true) && TargetElementComponent.compareDeep(this.equivalence, o.equivalence, true) && TargetElementComponent.compareDeep(this.comment, o.comment, true) && TargetElementComponent.compareDeep(this.dependsOn, o.dependsOn, true) && TargetElementComponent.compareDeep(this.product, o.product, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareValues(this.code, o.code, true) && TargetElementComponent.compareValues(this.display, o.display, true) && TargetElementComponent.compareValues(this.equivalence, o.equivalence, true) && TargetElementComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.equivalence, this.comment, this.dependsOn, this.product});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target";
        }
    }

    @Block
    public static class SourceElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies element being mapped", formalDefinition="Identity (code or path) or the element/item being mapped.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="target", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concept in target system for element", formalDefinition="A concept from the target value set that this concept maps to.")
        protected List<TargetElementComponent> target;
        private static final long serialVersionUID = -1115258852L;

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SourceElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public SourceElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public SourceElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public SourceElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<TargetElementComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            return this.target;
        }

        public SourceElementComponent setTarget(List<TargetElementComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (TargetElementComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TargetElementComponent addTarget() {
            TargetElementComponent t = new TargetElementComponent();
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return t;
        }

        public SourceElementComponent addTarget(TargetElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return this;
        }

        public TargetElementComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property(ConceptMap.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -880905839: {
                    return new Property(ConceptMap.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((TargetElementComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.getTarget().add((TargetElementComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.getTarget().remove((TargetElementComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.display");
            }
            if (name.equals(ConceptMap.SP_TARGET)) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public SourceElementComponent copy() {
            SourceElementComponent dst = new SourceElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SourceElementComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.target != null) {
                dst.target = new ArrayList<TargetElementComponent>();
                for (TargetElementComponent i : this.target) {
                    dst.target.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareDeep(this.code, o.code, true) && SourceElementComponent.compareDeep(this.display, o.display, true) && SourceElementComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareValues(this.code, o.code, true) && SourceElementComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.target});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element";
        }
    }

    @Block
    public static class ConceptMapGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source system where concepts to be mapped are defined", formalDefinition="An absolute URI that identifies the source system where the concepts to be mapped are defined.")
        protected UriType source;
        @Child(name="sourceVersion", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific version of the  code system", formalDefinition="The specific version of the code system, as determined by the code system authority.")
        protected StringType sourceVersion;
        @Child(name="target", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Target system that the concepts are to be mapped to", formalDefinition="An absolute URI that identifies the target system that the concepts will be mapped to.")
        protected UriType target;
        @Child(name="targetVersion", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific version of the  code system", formalDefinition="The specific version of the code system, as determined by the code system authority.")
        protected StringType targetVersion;
        @Child(name="element", type={}, order=5, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Mappings for a concept from the source set", formalDefinition="Mappings for an individual concept in the source to one or more concepts in the target.")
        protected List<SourceElementComponent> element;
        @Child(name="unmapped", type={}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What to do when there is no mapping for the source concept", formalDefinition="What to do when there is no mapping for the source concept. \"Unmapped\" does not include codes that are unmatched, and the unmapped element is ignored in a code is specified to have equivalence = unmatched.")
        protected ConceptMapGroupUnmappedComponent unmapped;
        private static final long serialVersionUID = 1606357508L;

        public ConceptMapGroupComponent() {
        }

        public ConceptMapGroupComponent(SourceElementComponent element) {
            this.addElement(element);
        }

        public UriType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new UriType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ConceptMapGroupComponent setSourceElement(UriType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ConceptMapGroupComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new UriType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public StringType getSourceVersionElement() {
            if (this.sourceVersion == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.sourceVersion");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceVersion = new StringType();
                }
            }
            return this.sourceVersion;
        }

        public boolean hasSourceVersionElement() {
            return this.sourceVersion != null && !this.sourceVersion.isEmpty();
        }

        public boolean hasSourceVersion() {
            return this.sourceVersion != null && !this.sourceVersion.isEmpty();
        }

        public ConceptMapGroupComponent setSourceVersionElement(StringType value) {
            this.sourceVersion = value;
            return this;
        }

        public String getSourceVersion() {
            return this.sourceVersion == null ? null : (String)this.sourceVersion.getValue();
        }

        public ConceptMapGroupComponent setSourceVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceVersion = null;
            } else {
                if (this.sourceVersion == null) {
                    this.sourceVersion = new StringType();
                }
                this.sourceVersion.setValue(value);
            }
            return this;
        }

        public UriType getTargetElement() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new UriType();
                }
            }
            return this.target;
        }

        public boolean hasTargetElement() {
            return this.target != null && !this.target.isEmpty();
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ConceptMapGroupComponent setTargetElement(UriType value) {
            this.target = value;
            return this;
        }

        public String getTarget() {
            return this.target == null ? null : (String)this.target.getValue();
        }

        public ConceptMapGroupComponent setTarget(String value) {
            if (Utilities.noString((String)value)) {
                this.target = null;
            } else {
                if (this.target == null) {
                    this.target = new UriType();
                }
                this.target.setValue(value);
            }
            return this;
        }

        public StringType getTargetVersionElement() {
            if (this.targetVersion == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.targetVersion");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetVersion = new StringType();
                }
            }
            return this.targetVersion;
        }

        public boolean hasTargetVersionElement() {
            return this.targetVersion != null && !this.targetVersion.isEmpty();
        }

        public boolean hasTargetVersion() {
            return this.targetVersion != null && !this.targetVersion.isEmpty();
        }

        public ConceptMapGroupComponent setTargetVersionElement(StringType value) {
            this.targetVersion = value;
            return this;
        }

        public String getTargetVersion() {
            return this.targetVersion == null ? null : (String)this.targetVersion.getValue();
        }

        public ConceptMapGroupComponent setTargetVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.targetVersion = null;
            } else {
                if (this.targetVersion == null) {
                    this.targetVersion = new StringType();
                }
                this.targetVersion.setValue(value);
            }
            return this;
        }

        public List<SourceElementComponent> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            return this.element;
        }

        public ConceptMapGroupComponent setElement(List<SourceElementComponent> theElement) {
            this.element = theElement;
            return this;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (SourceElementComponent item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SourceElementComponent addElement() {
            SourceElementComponent t = new SourceElementComponent();
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return t;
        }

        public ConceptMapGroupComponent addElement(SourceElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return this;
        }

        public SourceElementComponent getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                this.addElement();
            }
            return this.getElement().get(0);
        }

        public ConceptMapGroupUnmappedComponent getUnmapped() {
            if (this.unmapped == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.unmapped");
                }
                if (Configuration.doAutoCreate()) {
                    this.unmapped = new ConceptMapGroupUnmappedComponent();
                }
            }
            return this.unmapped;
        }

        public boolean hasUnmapped() {
            return this.unmapped != null && !this.unmapped.isEmpty();
        }

        public ConceptMapGroupComponent setUnmapped(ConceptMapGroupUnmappedComponent value) {
            this.unmapped = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ConceptMap.SP_SOURCE, "uri", "An absolute URI that identifies the source system where the concepts to be mapped are defined.", 0, 1, this.source));
            children.add(new Property("sourceVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.sourceVersion));
            children.add(new Property(ConceptMap.SP_TARGET, "uri", "An absolute URI that identifies the target system that the concepts will be mapped to.", 0, 1, this.target));
            children.add(new Property("targetVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.targetVersion));
            children.add(new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element));
            children.add(new Property("unmapped", "", "What to do when there is no mapping for the source concept. \"Unmapped\" does not include codes that are unmatched, and the unmapped element is ignored in a code is specified to have equivalence = unmatched.", 0, 1, this.unmapped));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property(ConceptMap.SP_SOURCE, "uri", "An absolute URI that identifies the source system where the concepts to be mapped are defined.", 0, 1, this.source);
                }
                case 446171197: {
                    return new Property("sourceVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.sourceVersion);
                }
                case -880905839: {
                    return new Property(ConceptMap.SP_TARGET, "uri", "An absolute URI that identifies the target system that the concepts will be mapped to.", 0, 1, this.target);
                }
                case -1639412217: {
                    return new Property("targetVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.targetVersion);
                }
                case -1662836996: {
                    return new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element);
                }
                case -194857460: {
                    return new Property("unmapped", "", "What to do when there is no mapping for the source concept. \"Unmapped\" does not include codes that are unmatched, and the unmapped element is ignored in a code is specified to have equivalence = unmatched.", 0, 1, this.unmapped);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case 446171197: {
                    Base[] baseArray;
                    if (this.sourceVersion == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sourceVersion;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.target;
                    }
                    return baseArray;
                }
                case -1639412217: {
                    Base[] baseArray;
                    if (this.targetVersion == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.targetVersion;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
                case -194857460: {
                    Base[] baseArray;
                    if (this.unmapped == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unmapped;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = TypeConvertor.castToUri(value);
                    return value;
                }
                case 446171197: {
                    this.sourceVersion = TypeConvertor.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToUri(value);
                    return value;
                }
                case -1639412217: {
                    this.targetVersion = TypeConvertor.castToString(value);
                    return value;
                }
                case -1662836996: {
                    this.getElement().add((SourceElementComponent)value);
                    return value;
                }
                case -194857460: {
                    this.unmapped = (ConceptMapGroupUnmappedComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ConceptMap.SP_SOURCE)) {
                this.source = TypeConvertor.castToUri(value);
            } else if (name.equals("sourceVersion")) {
                this.sourceVersion = TypeConvertor.castToString(value);
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.target = TypeConvertor.castToUri(value);
            } else if (name.equals("targetVersion")) {
                this.targetVersion = TypeConvertor.castToString(value);
            } else if (name.equals("element")) {
                this.getElement().add((SourceElementComponent)value);
            } else if (name.equals("unmapped")) {
                this.unmapped = (ConceptMapGroupUnmappedComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ConceptMap.SP_SOURCE)) {
                this.source = null;
            } else if (name.equals("sourceVersion")) {
                this.sourceVersion = null;
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.target = null;
            } else if (name.equals("targetVersion")) {
                this.targetVersion = null;
            } else if (name.equals("element")) {
                this.getElement().remove((SourceElementComponent)value);
            } else if (name.equals("unmapped")) {
                this.unmapped = (ConceptMapGroupUnmappedComponent)value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSourceElement();
                }
                case 446171197: {
                    return this.getSourceVersionElement();
                }
                case -880905839: {
                    return this.getTargetElement();
                }
                case -1639412217: {
                    return this.getTargetVersionElement();
                }
                case -1662836996: {
                    return this.addElement();
                }
                case -194857460: {
                    return this.getUnmapped();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"uri"};
                }
                case 446171197: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[]{"uri"};
                }
                case -1639412217: {
                    return new String[]{"string"};
                }
                case -1662836996: {
                    return new String[0];
                }
                case -194857460: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ConceptMap.SP_SOURCE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.source");
            }
            if (name.equals("sourceVersion")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.sourceVersion");
            }
            if (name.equals(ConceptMap.SP_TARGET)) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.target");
            }
            if (name.equals("targetVersion")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.targetVersion");
            }
            if (name.equals("element")) {
                return this.addElement();
            }
            if (name.equals("unmapped")) {
                this.unmapped = new ConceptMapGroupUnmappedComponent();
                return this.unmapped;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapGroupComponent copy() {
            ConceptMapGroupComponent dst = new ConceptMapGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptMapGroupComponent dst) {
            super.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            dst.sourceVersion = this.sourceVersion == null ? null : this.sourceVersion.copy();
            dst.target = this.target == null ? null : this.target.copy();
            StringType stringType = dst.targetVersion = this.targetVersion == null ? null : this.targetVersion.copy();
            if (this.element != null) {
                dst.element = new ArrayList<SourceElementComponent>();
                for (SourceElementComponent i : this.element) {
                    dst.element.add(i.copy());
                }
            }
            dst.unmapped = this.unmapped == null ? null : this.unmapped.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupComponent)) {
                return false;
            }
            ConceptMapGroupComponent o = (ConceptMapGroupComponent)other_;
            return ConceptMapGroupComponent.compareDeep(this.source, o.source, true) && ConceptMapGroupComponent.compareDeep(this.sourceVersion, o.sourceVersion, true) && ConceptMapGroupComponent.compareDeep(this.target, o.target, true) && ConceptMapGroupComponent.compareDeep(this.targetVersion, o.targetVersion, true) && ConceptMapGroupComponent.compareDeep(this.element, o.element, true) && ConceptMapGroupComponent.compareDeep(this.unmapped, o.unmapped, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupComponent)) {
                return false;
            }
            ConceptMapGroupComponent o = (ConceptMapGroupComponent)other_;
            return ConceptMapGroupComponent.compareValues(this.source, o.source, true) && ConceptMapGroupComponent.compareValues(this.sourceVersion, o.sourceVersion, true) && ConceptMapGroupComponent.compareValues(this.target, o.target, true) && ConceptMapGroupComponent.compareValues(this.targetVersion, o.targetVersion, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.source, this.sourceVersion, this.target, this.targetVersion, this.element, this.unmapped});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group";
        }
    }

    public static class ConceptMapGroupUnmappedModeEnumFactory
    implements EnumFactory<ConceptMapGroupUnmappedMode> {
        @Override
        public ConceptMapGroupUnmappedMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("provided".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.PROVIDED;
            }
            if ("fixed".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.FIXED;
            }
            if ("other-map".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.OTHERMAP;
            }
            throw new IllegalArgumentException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        public Enumeration<ConceptMapGroupUnmappedMode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.NULL, code);
            }
            if ("provided".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.PROVIDED, code);
            }
            if ("fixed".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.FIXED, code);
            }
            if ("other-map".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.OTHERMAP, code);
            }
            throw new FHIRException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        @Override
        public String toCode(ConceptMapGroupUnmappedMode code) {
            if (code == ConceptMapGroupUnmappedMode.PROVIDED) {
                return "provided";
            }
            if (code == ConceptMapGroupUnmappedMode.FIXED) {
                return "fixed";
            }
            if (code == ConceptMapGroupUnmappedMode.OTHERMAP) {
                return "other-map";
            }
            return "?";
        }

        @Override
        public String toSystem(ConceptMapGroupUnmappedMode code) {
            return code.getSystem();
        }
    }

    public static enum ConceptMapGroupUnmappedMode {
        PROVIDED,
        FIXED,
        OTHERMAP,
        NULL;


        public static ConceptMapGroupUnmappedMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provided".equals(codeString)) {
                return PROVIDED;
            }
            if ("fixed".equals(codeString)) {
                return FIXED;
            }
            if ("other-map".equals(codeString)) {
                return OTHERMAP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROVIDED: {
                    return "provided";
                }
                case FIXED: {
                    return "fixed";
                }
                case OTHERMAP: {
                    return "other-map";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROVIDED: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case FIXED: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case OTHERMAP: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROVIDED: {
                    return "Use the code as provided in the $translate request.";
                }
                case FIXED: {
                    return "Use the code explicitly provided in the group.unmapped.";
                }
                case OTHERMAP: {
                    return "Use the map identified by the canonical URL in the url element.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROVIDED: {
                    return "Provided Code";
                }
                case FIXED: {
                    return "Fixed Code";
                }
                case OTHERMAP: {
                    return "Other Map";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConceptMapEquivalenceEnumFactory
    implements EnumFactory<ConceptMapEquivalence> {
        @Override
        public ConceptMapEquivalence fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("relatedto".equals(codeString)) {
                return ConceptMapEquivalence.RELATEDTO;
            }
            if ("equivalent".equals(codeString)) {
                return ConceptMapEquivalence.EQUIVALENT;
            }
            if ("equal".equals(codeString)) {
                return ConceptMapEquivalence.EQUAL;
            }
            if ("wider".equals(codeString)) {
                return ConceptMapEquivalence.WIDER;
            }
            if ("subsumes".equals(codeString)) {
                return ConceptMapEquivalence.SUBSUMES;
            }
            if ("narrower".equals(codeString)) {
                return ConceptMapEquivalence.NARROWER;
            }
            if ("specializes".equals(codeString)) {
                return ConceptMapEquivalence.SPECIALIZES;
            }
            if ("inexact".equals(codeString)) {
                return ConceptMapEquivalence.INEXACT;
            }
            if ("unmatched".equals(codeString)) {
                return ConceptMapEquivalence.UNMATCHED;
            }
            if ("disjoint".equals(codeString)) {
                return ConceptMapEquivalence.DISJOINT;
            }
            throw new IllegalArgumentException("Unknown ConceptMapEquivalence code '" + codeString + "'");
        }

        public Enumeration<ConceptMapEquivalence> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.NULL, code);
            }
            if ("relatedto".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.RELATEDTO, code);
            }
            if ("equivalent".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.EQUIVALENT, code);
            }
            if ("equal".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.EQUAL, code);
            }
            if ("wider".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.WIDER, code);
            }
            if ("subsumes".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.SUBSUMES, code);
            }
            if ("narrower".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.NARROWER, code);
            }
            if ("specializes".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.SPECIALIZES, code);
            }
            if ("inexact".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.INEXACT, code);
            }
            if ("unmatched".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.UNMATCHED, code);
            }
            if ("disjoint".equals(codeString)) {
                return new Enumeration<ConceptMapEquivalence>(this, ConceptMapEquivalence.DISJOINT, code);
            }
            throw new FHIRException("Unknown ConceptMapEquivalence code '" + codeString + "'");
        }

        @Override
        public String toCode(ConceptMapEquivalence code) {
            if (code == ConceptMapEquivalence.RELATEDTO) {
                return "relatedto";
            }
            if (code == ConceptMapEquivalence.EQUIVALENT) {
                return "equivalent";
            }
            if (code == ConceptMapEquivalence.EQUAL) {
                return "equal";
            }
            if (code == ConceptMapEquivalence.WIDER) {
                return "wider";
            }
            if (code == ConceptMapEquivalence.SUBSUMES) {
                return "subsumes";
            }
            if (code == ConceptMapEquivalence.NARROWER) {
                return "narrower";
            }
            if (code == ConceptMapEquivalence.SPECIALIZES) {
                return "specializes";
            }
            if (code == ConceptMapEquivalence.INEXACT) {
                return "inexact";
            }
            if (code == ConceptMapEquivalence.UNMATCHED) {
                return "unmatched";
            }
            if (code == ConceptMapEquivalence.DISJOINT) {
                return "disjoint";
            }
            return "?";
        }

        @Override
        public String toSystem(ConceptMapEquivalence code) {
            return code.getSystem();
        }
    }

    public static enum ConceptMapEquivalence {
        RELATEDTO,
        EQUIVALENT,
        EQUAL,
        WIDER,
        SUBSUMES,
        NARROWER,
        SPECIALIZES,
        INEXACT,
        UNMATCHED,
        DISJOINT,
        NULL;


        public static ConceptMapEquivalence fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("relatedto".equals(codeString)) {
                return RELATEDTO;
            }
            if ("equivalent".equals(codeString)) {
                return EQUIVALENT;
            }
            if ("equal".equals(codeString)) {
                return EQUAL;
            }
            if ("wider".equals(codeString)) {
                return WIDER;
            }
            if ("subsumes".equals(codeString)) {
                return SUBSUMES;
            }
            if ("narrower".equals(codeString)) {
                return NARROWER;
            }
            if ("specializes".equals(codeString)) {
                return SPECIALIZES;
            }
            if ("inexact".equals(codeString)) {
                return INEXACT;
            }
            if ("unmatched".equals(codeString)) {
                return UNMATCHED;
            }
            if ("disjoint".equals(codeString)) {
                return DISJOINT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConceptMapEquivalence code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RELATEDTO: {
                    return "relatedto";
                }
                case EQUIVALENT: {
                    return "equivalent";
                }
                case EQUAL: {
                    return "equal";
                }
                case WIDER: {
                    return "wider";
                }
                case SUBSUMES: {
                    return "subsumes";
                }
                case NARROWER: {
                    return "narrower";
                }
                case SPECIALIZES: {
                    return "specializes";
                }
                case INEXACT: {
                    return "inexact";
                }
                case UNMATCHED: {
                    return "unmatched";
                }
                case DISJOINT: {
                    return "disjoint";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RELATEDTO: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case EQUIVALENT: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case EQUAL: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case WIDER: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case SUBSUMES: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case NARROWER: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case SPECIALIZES: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case INEXACT: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case UNMATCHED: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case DISJOINT: {
                    return "http://hl7.org/fhir/concept-map-equivalence";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RELATEDTO: {
                    return "The concepts are related to each other, and have at least some overlap in meaning, but the exact relationship is not known.";
                }
                case EQUIVALENT: {
                    return "The definitions of the concepts mean the same thing (including when structural implications of meaning are considered) (i.e. extensionally identical).";
                }
                case EQUAL: {
                    return "The definitions of the concepts are exactly the same (i.e. only grammatical differences) and structural implications of meaning are identical or irrelevant (i.e. intentionally identical).";
                }
                case WIDER: {
                    return "The target mapping is wider in meaning than the source concept.";
                }
                case SUBSUMES: {
                    return "The target mapping subsumes the meaning of the source concept (e.g. the source is-a target).";
                }
                case NARROWER: {
                    return "The target mapping is narrower in meaning than the source concept. The sense in which the mapping is narrower SHALL be described in the comments in this case, and applications should be careful when attempting to use these mappings operationally.";
                }
                case SPECIALIZES: {
                    return "The target mapping specializes the meaning of the source concept (e.g. the target is-a source).";
                }
                case INEXACT: {
                    return "The target mapping overlaps with the source concept, but both source and target cover additional meaning, or the definitions are imprecise and it is uncertain whether they have the same boundaries to their meaning. The sense in which the mapping is inexact SHALL be described in the comments in this case, and applications should be careful when attempting to use these mappings operationally.";
                }
                case UNMATCHED: {
                    return "There is no match for this concept in the target code system.";
                }
                case DISJOINT: {
                    return "This is an explicit assertion that there is no mapping between the source and target concept.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RELATEDTO: {
                    return "Related To";
                }
                case EQUIVALENT: {
                    return "Equivalent";
                }
                case EQUAL: {
                    return "Equal";
                }
                case WIDER: {
                    return "Wider";
                }
                case SUBSUMES: {
                    return "Subsumes";
                }
                case NARROWER: {
                    return "Narrower";
                }
                case SPECIALIZES: {
                    return "Specializes";
                }
                case INEXACT: {
                    return "Inexact";
                }
                case UNMATCHED: {
                    return "Unmatched";
                }
                case DISJOINT: {
                    return "Disjoint";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

