/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.IntegerType;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="OperationDefinition", profile="http://hl7.org/fhir/StructureDefinition/OperationDefinition")
public class OperationDefinition
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this operation definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this operation definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this operation definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the operation definition is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the operation definition", formalDefinition="The identifier that is used to identify this version of the operation definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the operation definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this operation definition (computer friendly)", formalDefinition="A natural language name identifying the operation definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this operation definition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the operation definition.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this operation definition. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="kind", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="operation | query", formalDefinition="Whether this is an operation or a named query.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-kind")
    protected Enumeration<OperationKind> kind;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this operation definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the operation definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the operation definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the operation definition.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the operation definition", formalDefinition="A free text natural language description of the operation definition from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate operation definition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for operation definition (if applicable)", formalDefinition="A legal or geographic region in which the operation definition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this operation definition is defined", formalDefinition="Explanation of why this operation definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="affectsState", type={BooleanType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether content is changed by the operation", formalDefinition="Whether the operation affects state. Side effects such as producing audit trail entries do not count as 'affecting  state'.")
    protected BooleanType affectsState;
    @Child(name="code", type={CodeType.class}, order=15, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name used to invoke the operation", formalDefinition="The name used to invoke the operation.")
    protected CodeType code;
    @Child(name="comment", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about use", formalDefinition="Additional information about how to use this operation or named query.")
    protected MarkdownType comment;
    @Child(name="base", type={CanonicalType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Marks this as a profile of the base", formalDefinition="Indicates that this operation definition is a constraining profile on the base.")
    protected CanonicalType base;
    @Child(name="resource", type={CodeType.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Types this operation applies to", formalDefinition="The types on which this operation can be executed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> resource;
    @Child(name="system", type={BooleanType.class}, order=19, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoke at the system level?", formalDefinition="Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).")
    protected BooleanType system;
    @Child(name="type", type={BooleanType.class}, order=20, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoke at the type level?", formalDefinition="Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).")
    protected BooleanType type;
    @Child(name="instance", type={BooleanType.class}, order=21, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoke on an instance?", formalDefinition="Indicates whether this operation can be invoked on a particular instance of one of the given types.")
    protected BooleanType instance;
    @Child(name="inputProfile", type={CanonicalType.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Validation information for in parameters", formalDefinition="Additional validation information for the in parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource as a whole.")
    protected CanonicalType inputProfile;
    @Child(name="outputProfile", type={CanonicalType.class}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Validation information for out parameters", formalDefinition="Additional validation information for the out parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource.")
    protected CanonicalType outputProfile;
    @Child(name="parameter", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Parameters for the operation/query", formalDefinition="The parameters for the operation/query.")
    protected List<OperationDefinitionParameterComponent> parameter;
    @Child(name="overload", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Define overloaded variants for when  generating code", formalDefinition="Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.")
    protected List<OperationDefinitionOverloadComponent> overload;
    private static final long serialVersionUID = 715394391L;
    @SearchParamDefinition(name="base", path="OperationDefinition.base", description="Marks this as a profile of the base", type="reference", target={OperationDefinition.class})
    public static final String SP_BASE = "base";
    public static final ReferenceClientParam BASE = new ReferenceClientParam("base");
    public static final Include INCLUDE_BASE = new Include("OperationDefinition:base").toLocked();
    @SearchParamDefinition(name="code", path="OperationDefinition.code", description="Name used to invoke the operation", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="input-profile", path="OperationDefinition.inputProfile", description="Validation information for in parameters", type="reference", target={StructureDefinition.class})
    public static final String SP_INPUT_PROFILE = "input-profile";
    public static final ReferenceClientParam INPUT_PROFILE = new ReferenceClientParam("input-profile");
    public static final Include INCLUDE_INPUT_PROFILE = new Include("OperationDefinition:input-profile").toLocked();
    @SearchParamDefinition(name="instance", path="OperationDefinition.instance", description="Invoke on an instance?", type="token")
    public static final String SP_INSTANCE = "instance";
    public static final TokenClientParam INSTANCE = new TokenClientParam("instance");
    @SearchParamDefinition(name="kind", path="OperationDefinition.kind", description="operation | query", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="output-profile", path="OperationDefinition.outputProfile", description="Validation information for out parameters", type="reference", target={StructureDefinition.class})
    public static final String SP_OUTPUT_PROFILE = "output-profile";
    public static final ReferenceClientParam OUTPUT_PROFILE = new ReferenceClientParam("output-profile");
    public static final Include INCLUDE_OUTPUT_PROFILE = new Include("OperationDefinition:output-profile").toLocked();
    @SearchParamDefinition(name="system", path="OperationDefinition.system", description="Invoke at the system level?", type="token")
    public static final String SP_SYSTEM = "system";
    public static final TokenClientParam SYSTEM = new TokenClientParam("system");
    @SearchParamDefinition(name="type", path="OperationDefinition.type", description="Invoke at the type level?", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="CapabilityStatement.title | CodeSystem.title | ConceptMap.title | ImplementationGuide.title | MessageDefinition.title | OperationDefinition.title | StructureDefinition.title | StructureMap.title | TerminologyCapabilities.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public OperationDefinition() {
    }

    public OperationDefinition(String name, Enumerations.PublicationStatus status, OperationKind kind, String code, boolean system, boolean type, boolean instance) {
        this.setName(name);
        this.setStatus(status);
        this.setKind(kind);
        this.setCode(code);
        this.setSystem(system);
        this.setType(type);
        this.setInstance(instance);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public OperationDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public OperationDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public OperationDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public OperationDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public OperationDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public OperationDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public OperationDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public OperationDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public OperationDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public OperationDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<OperationKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<OperationKind>(new OperationKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public OperationDefinition setKindElement(Enumeration<OperationKind> value) {
        this.kind = value;
        return this;
    }

    public OperationKind getKind() {
        return this.kind == null ? null : (OperationKind)((Object)this.kind.getValue());
    }

    public OperationDefinition setKind(OperationKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<OperationKind>(new OperationKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public OperationDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public OperationDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public OperationDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public OperationDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public OperationDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public OperationDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public OperationDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public OperationDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public OperationDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public OperationDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public OperationDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public OperationDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public OperationDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public OperationDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public OperationDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public OperationDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public BooleanType getAffectsStateElement() {
        if (this.affectsState == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.affectsState");
            }
            if (Configuration.doAutoCreate()) {
                this.affectsState = new BooleanType();
            }
        }
        return this.affectsState;
    }

    public boolean hasAffectsStateElement() {
        return this.affectsState != null && !this.affectsState.isEmpty();
    }

    public boolean hasAffectsState() {
        return this.affectsState != null && !this.affectsState.isEmpty();
    }

    public OperationDefinition setAffectsStateElement(BooleanType value) {
        this.affectsState = value;
        return this;
    }

    public boolean getAffectsState() {
        return this.affectsState == null || this.affectsState.isEmpty() ? false : (Boolean)this.affectsState.getValue();
    }

    public OperationDefinition setAffectsState(boolean value) {
        if (this.affectsState == null) {
            this.affectsState = new BooleanType();
        }
        this.affectsState.setValue((Object)value);
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public OperationDefinition setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public OperationDefinition setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public MarkdownType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new MarkdownType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public OperationDefinition setCommentElement(MarkdownType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public OperationDefinition setComment(String value) {
        if (value == null) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new MarkdownType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public CanonicalType getBaseElement() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new CanonicalType();
            }
        }
        return this.base;
    }

    public boolean hasBaseElement() {
        return this.base != null && !this.base.isEmpty();
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public OperationDefinition setBaseElement(CanonicalType value) {
        this.base = value;
        return this;
    }

    public String getBase() {
        return this.base == null ? null : (String)this.base.getValue();
    }

    public OperationDefinition setBase(String value) {
        if (Utilities.noString((String)value)) {
            this.base = null;
        } else {
            if (this.base == null) {
                this.base = new CanonicalType();
            }
            this.base.setValue(value);
        }
        return this;
    }

    public List<CodeType> getResource() {
        if (this.resource == null) {
            this.resource = new ArrayList<CodeType>();
        }
        return this.resource;
    }

    public OperationDefinition setResource(List<CodeType> theResource) {
        this.resource = theResource;
        return this;
    }

    public boolean hasResource() {
        if (this.resource == null) {
            return false;
        }
        for (CodeType item : this.resource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addResourceElement() {
        CodeType t = new CodeType();
        if (this.resource == null) {
            this.resource = new ArrayList<CodeType>();
        }
        this.resource.add(t);
        return t;
    }

    public OperationDefinition addResource(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.resource == null) {
            this.resource = new ArrayList<CodeType>();
        }
        this.resource.add(t);
        return this;
    }

    public boolean hasResource(String value) {
        if (this.resource == null) {
            return false;
        }
        for (CodeType v : this.resource) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public BooleanType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new BooleanType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public OperationDefinition setSystemElement(BooleanType value) {
        this.system = value;
        return this;
    }

    public boolean getSystem() {
        return this.system == null || this.system.isEmpty() ? false : (Boolean)this.system.getValue();
    }

    public OperationDefinition setSystem(boolean value) {
        if (this.system == null) {
            this.system = new BooleanType();
        }
        this.system.setValue((Object)value);
        return this;
    }

    public BooleanType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new BooleanType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public OperationDefinition setTypeElement(BooleanType value) {
        this.type = value;
        return this;
    }

    public boolean getType() {
        return this.type == null || this.type.isEmpty() ? false : (Boolean)this.type.getValue();
    }

    public OperationDefinition setType(boolean value) {
        if (this.type == null) {
            this.type = new BooleanType();
        }
        this.type.setValue((Object)value);
        return this;
    }

    public BooleanType getInstanceElement() {
        if (this.instance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.instance");
            }
            if (Configuration.doAutoCreate()) {
                this.instance = new BooleanType();
            }
        }
        return this.instance;
    }

    public boolean hasInstanceElement() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public boolean hasInstance() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public OperationDefinition setInstanceElement(BooleanType value) {
        this.instance = value;
        return this;
    }

    public boolean getInstance() {
        return this.instance == null || this.instance.isEmpty() ? false : (Boolean)this.instance.getValue();
    }

    public OperationDefinition setInstance(boolean value) {
        if (this.instance == null) {
            this.instance = new BooleanType();
        }
        this.instance.setValue((Object)value);
        return this;
    }

    public CanonicalType getInputProfileElement() {
        if (this.inputProfile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.inputProfile");
            }
            if (Configuration.doAutoCreate()) {
                this.inputProfile = new CanonicalType();
            }
        }
        return this.inputProfile;
    }

    public boolean hasInputProfileElement() {
        return this.inputProfile != null && !this.inputProfile.isEmpty();
    }

    public boolean hasInputProfile() {
        return this.inputProfile != null && !this.inputProfile.isEmpty();
    }

    public OperationDefinition setInputProfileElement(CanonicalType value) {
        this.inputProfile = value;
        return this;
    }

    public String getInputProfile() {
        return this.inputProfile == null ? null : (String)this.inputProfile.getValue();
    }

    public OperationDefinition setInputProfile(String value) {
        if (Utilities.noString((String)value)) {
            this.inputProfile = null;
        } else {
            if (this.inputProfile == null) {
                this.inputProfile = new CanonicalType();
            }
            this.inputProfile.setValue(value);
        }
        return this;
    }

    public CanonicalType getOutputProfileElement() {
        if (this.outputProfile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.outputProfile");
            }
            if (Configuration.doAutoCreate()) {
                this.outputProfile = new CanonicalType();
            }
        }
        return this.outputProfile;
    }

    public boolean hasOutputProfileElement() {
        return this.outputProfile != null && !this.outputProfile.isEmpty();
    }

    public boolean hasOutputProfile() {
        return this.outputProfile != null && !this.outputProfile.isEmpty();
    }

    public OperationDefinition setOutputProfileElement(CanonicalType value) {
        this.outputProfile = value;
        return this;
    }

    public String getOutputProfile() {
        return this.outputProfile == null ? null : (String)this.outputProfile.getValue();
    }

    public OperationDefinition setOutputProfile(String value) {
        if (Utilities.noString((String)value)) {
            this.outputProfile = null;
        } else {
            if (this.outputProfile == null) {
                this.outputProfile = new CanonicalType();
            }
            this.outputProfile.setValue(value);
        }
        return this;
    }

    public List<OperationDefinitionParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        return this.parameter;
    }

    public OperationDefinition setParameter(List<OperationDefinitionParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (OperationDefinitionParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationDefinitionParameterComponent addParameter() {
        OperationDefinitionParameterComponent t = new OperationDefinitionParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public OperationDefinition addParameter(OperationDefinitionParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public OperationDefinitionParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public List<OperationDefinitionOverloadComponent> getOverload() {
        if (this.overload == null) {
            this.overload = new ArrayList<OperationDefinitionOverloadComponent>();
        }
        return this.overload;
    }

    public OperationDefinition setOverload(List<OperationDefinitionOverloadComponent> theOverload) {
        this.overload = theOverload;
        return this;
    }

    public boolean hasOverload() {
        if (this.overload == null) {
            return false;
        }
        for (OperationDefinitionOverloadComponent item : this.overload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationDefinitionOverloadComponent addOverload() {
        OperationDefinitionOverloadComponent t = new OperationDefinitionOverloadComponent();
        if (this.overload == null) {
            this.overload = new ArrayList<OperationDefinitionOverloadComponent>();
        }
        this.overload.add(t);
        return t;
    }

    public OperationDefinition addOverload(OperationDefinitionOverloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.overload == null) {
            this.overload = new ArrayList<OperationDefinitionOverloadComponent>();
        }
        this.overload.add(t);
        return this;
    }

    public OperationDefinitionOverloadComponent getOverloadFirstRep() {
        if (this.getOverload().isEmpty()) {
            this.addOverload();
        }
        return this.getOverload().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this operation definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this operation definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the operation definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the operation definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the operation definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the operation definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the operation definition.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this operation definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_KIND, SP_CODE, "Whether this is an operation or a named query.", 0, 1, this.kind));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this operation definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the operation definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the operation definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the operation definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the operation definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate operation definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the operation definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this operation definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("affectsState", "boolean", "Whether the operation affects state. Side effects such as producing audit trail entries do not count as 'affecting  state'.", 0, 1, this.affectsState));
        children.add(new Property(SP_CODE, SP_CODE, "The name used to invoke the operation.", 0, 1, this.code));
        children.add(new Property("comment", "markdown", "Additional information about how to use this operation or named query.", 0, 1, this.comment));
        children.add(new Property(SP_BASE, "canonical(OperationDefinition)", "Indicates that this operation definition is a constraining profile on the base.", 0, 1, this.base));
        children.add(new Property("resource", SP_CODE, "The types on which this operation can be executed.", 0, Integer.MAX_VALUE, this.resource));
        children.add(new Property(SP_SYSTEM, "boolean", "Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).", 0, 1, this.system));
        children.add(new Property(SP_TYPE, "boolean", "Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).", 0, 1, this.type));
        children.add(new Property(SP_INSTANCE, "boolean", "Indicates whether this operation can be invoked on a particular instance of one of the given types.", 0, 1, this.instance));
        children.add(new Property("inputProfile", "canonical(StructureDefinition)", "Additional validation information for the in parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource as a whole.", 0, 1, this.inputProfile));
        children.add(new Property("outputProfile", "canonical(StructureDefinition)", "Additional validation information for the out parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource.", 0, 1, this.outputProfile));
        children.add(new Property("parameter", "", "The parameters for the operation/query.", 0, Integer.MAX_VALUE, this.parameter));
        children.add(new Property("overload", "", "Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.", 0, Integer.MAX_VALUE, this.overload));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this operation definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this operation definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the operation definition is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the operation definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the operation definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the operation definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the operation definition.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this operation definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3292052: {
                return new Property(SP_KIND, SP_CODE, "Whether this is an operation or a named query.", 0, 1, this.kind);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this operation definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the operation definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the operation definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the operation definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the operation definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate operation definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the operation definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this operation definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case -14805197: {
                return new Property("affectsState", "boolean", "Whether the operation affects state. Side effects such as producing audit trail entries do not count as 'affecting  state'.", 0, 1, this.affectsState);
            }
            case 3059181: {
                return new Property(SP_CODE, SP_CODE, "The name used to invoke the operation.", 0, 1, this.code);
            }
            case 950398559: {
                return new Property("comment", "markdown", "Additional information about how to use this operation or named query.", 0, 1, this.comment);
            }
            case 3016401: {
                return new Property(SP_BASE, "canonical(OperationDefinition)", "Indicates that this operation definition is a constraining profile on the base.", 0, 1, this.base);
            }
            case -341064690: {
                return new Property("resource", SP_CODE, "The types on which this operation can be executed.", 0, Integer.MAX_VALUE, this.resource);
            }
            case -887328209: {
                return new Property(SP_SYSTEM, "boolean", "Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).", 0, 1, this.system);
            }
            case 3575610: {
                return new Property(SP_TYPE, "boolean", "Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).", 0, 1, this.type);
            }
            case 555127957: {
                return new Property(SP_INSTANCE, "boolean", "Indicates whether this operation can be invoked on a particular instance of one of the given types.", 0, 1, this.instance);
            }
            case 676942463: {
                return new Property("inputProfile", "canonical(StructureDefinition)", "Additional validation information for the in parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource as a whole.", 0, 1, this.inputProfile);
            }
            case 1826166120: {
                return new Property("outputProfile", "canonical(StructureDefinition)", "Additional validation information for the out parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource.", 0, 1, this.outputProfile);
            }
            case 1954460585: {
                return new Property("parameter", "", "The parameters for the operation/query.", 0, Integer.MAX_VALUE, this.parameter);
            }
            case 529823674: {
                return new Property("overload", "", "Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.", 0, Integer.MAX_VALUE, this.overload);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.kind;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case -14805197: {
                Base[] baseArray;
                if (this.affectsState == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.affectsState;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.code;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.comment;
                }
                return baseArray;
            }
            case 3016401: {
                Base[] baseArray;
                if (this.base == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.base;
                }
                return baseArray;
            }
            case -341064690: {
                return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
            }
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.system;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.type;
                }
                return baseArray;
            }
            case 555127957: {
                Base[] baseArray;
                if (this.instance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.instance;
                }
                return baseArray;
            }
            case 676942463: {
                Base[] baseArray;
                if (this.inputProfile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.inputProfile;
                }
                return baseArray;
            }
            case 1826166120: {
                Base[] baseArray;
                if (this.outputProfile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.outputProfile;
                }
                return baseArray;
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case 529823674: {
                return this.overload == null ? new Base[]{} : this.overload.toArray(new Base[this.overload.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3292052: {
                value = new OperationKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -14805197: {
                this.affectsState = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCode(value);
                return value;
            }
            case 950398559: {
                this.comment = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3016401: {
                this.base = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -341064690: {
                this.getResource().add(TypeConvertor.castToCode(value));
                return value;
            }
            case -887328209: {
                this.system = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 555127957: {
                this.instance = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 676942463: {
                this.inputProfile = TypeConvertor.castToCanonical(value);
                return value;
            }
            case 1826166120: {
                this.outputProfile = TypeConvertor.castToCanonical(value);
                return value;
            }
            case 1954460585: {
                this.getParameter().add((OperationDefinitionParameterComponent)((Object)value));
                return value;
            }
            case 529823674: {
                this.getOverload().add((OperationDefinitionOverloadComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_KIND)) {
            value = new OperationKindEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.kind = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("affectsState")) {
            this.affectsState = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCode(value);
        } else if (name.equals("comment")) {
            this.comment = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_BASE)) {
            this.base = TypeConvertor.castToCanonical(value);
        } else if (name.equals("resource")) {
            this.getResource().add(TypeConvertor.castToCode(value));
        } else if (name.equals(SP_SYSTEM)) {
            this.system = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_INSTANCE)) {
            this.instance = TypeConvertor.castToBoolean(value);
        } else if (name.equals("inputProfile")) {
            this.inputProfile = TypeConvertor.castToCanonical(value);
        } else if (name.equals("outputProfile")) {
            this.outputProfile = TypeConvertor.castToCanonical(value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((OperationDefinitionParameterComponent)((Object)value));
        } else if (name.equals("overload")) {
            this.getOverload().add((OperationDefinitionOverloadComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals(SP_KIND)) {
            this.kind = null;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("affectsState")) {
            this.affectsState = null;
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals("comment")) {
            this.comment = null;
        } else if (name.equals(SP_BASE)) {
            this.base = null;
        } else if (name.equals("resource")) {
            this.getResource().remove(value);
        } else if (name.equals(SP_SYSTEM)) {
            this.system = null;
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals(SP_INSTANCE)) {
            this.instance = null;
        } else if (name.equals("inputProfile")) {
            this.inputProfile = null;
        } else if (name.equals("outputProfile")) {
            this.outputProfile = null;
        } else if (name.equals("parameter")) {
            this.getParameter().remove((OperationDefinitionParameterComponent)value);
        } else if (name.equals("overload")) {
            this.getOverload().remove((OperationDefinitionOverloadComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case -14805197: {
                return this.getAffectsStateElement();
            }
            case 3059181: {
                return this.getCodeElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case 3016401: {
                return this.getBaseElement();
            }
            case -341064690: {
                return this.addResourceElement();
            }
            case -887328209: {
                return this.getSystemElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 555127957: {
                return this.getInstanceElement();
            }
            case 676942463: {
                return this.getInputProfileElement();
            }
            case 1826166120: {
                return this.getOutputProfileElement();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case 529823674: {
                return this.addOverload();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 3292052: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case -14805197: {
                return new String[]{"boolean"};
            }
            case 3059181: {
                return new String[]{SP_CODE};
            }
            case 950398559: {
                return new String[]{"markdown"};
            }
            case 3016401: {
                return new String[]{"canonical"};
            }
            case -341064690: {
                return new String[]{SP_CODE};
            }
            case -887328209: {
                return new String[]{"boolean"};
            }
            case 3575610: {
                return new String[]{"boolean"};
            }
            case 555127957: {
                return new String[]{"boolean"};
            }
            case 676942463: {
                return new String[]{"canonical"};
            }
            case 1826166120: {
                return new String[]{"canonical"};
            }
            case 1954460585: {
                return new String[0];
            }
            case 529823674: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.status");
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.kind");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.purpose");
        }
        if (name.equals("affectsState")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.affectsState");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.code");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.comment");
        }
        if (name.equals(SP_BASE)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.base");
        }
        if (name.equals("resource")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.resource");
        }
        if (name.equals(SP_SYSTEM)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.system");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.type");
        }
        if (name.equals(SP_INSTANCE)) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.instance");
        }
        if (name.equals("inputProfile")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.inputProfile");
        }
        if (name.equals("outputProfile")) {
            throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.outputProfile");
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("overload")) {
            return this.addOverload();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OperationDefinition";
    }

    @Override
    public OperationDefinition copy() {
        OperationDefinition dst = new OperationDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(OperationDefinition dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.affectsState = this.affectsState == null ? null : this.affectsState.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        CanonicalType canonicalType = dst.base = this.base == null ? null : this.base.copy();
        if (this.resource != null) {
            dst.resource = new ArrayList<CodeType>();
            for (CodeType codeType : this.resource) {
                dst.resource.add(codeType.copy());
            }
        }
        dst.system = this.system == null ? null : this.system.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.instance = this.instance == null ? null : this.instance.copy();
        dst.inputProfile = this.inputProfile == null ? null : this.inputProfile.copy();
        CanonicalType canonicalType2 = dst.outputProfile = this.outputProfile == null ? null : this.outputProfile.copy();
        if (this.parameter != null) {
            dst.parameter = new ArrayList<OperationDefinitionParameterComponent>();
            for (OperationDefinitionParameterComponent operationDefinitionParameterComponent : this.parameter) {
                dst.parameter.add(operationDefinitionParameterComponent.copy());
            }
        }
        if (this.overload != null) {
            dst.overload = new ArrayList<OperationDefinitionOverloadComponent>();
            for (OperationDefinitionOverloadComponent operationDefinitionOverloadComponent : this.overload) {
                dst.overload.add(operationDefinitionOverloadComponent.copy());
            }
        }
    }

    protected OperationDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition o = (OperationDefinition)other_;
        return OperationDefinition.compareDeep(this.url, o.url, true) && OperationDefinition.compareDeep(this.version, o.version, true) && OperationDefinition.compareDeep(this.name, o.name, true) && OperationDefinition.compareDeep(this.title, o.title, true) && OperationDefinition.compareDeep(this.status, o.status, true) && OperationDefinition.compareDeep(this.kind, o.kind, true) && OperationDefinition.compareDeep(this.experimental, o.experimental, true) && OperationDefinition.compareDeep(this.date, o.date, true) && OperationDefinition.compareDeep(this.publisher, o.publisher, true) && OperationDefinition.compareDeep(this.contact, o.contact, true) && OperationDefinition.compareDeep(this.description, o.description, true) && OperationDefinition.compareDeep(this.useContext, o.useContext, true) && OperationDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && OperationDefinition.compareDeep(this.purpose, o.purpose, true) && OperationDefinition.compareDeep(this.affectsState, o.affectsState, true) && OperationDefinition.compareDeep(this.code, o.code, true) && OperationDefinition.compareDeep(this.comment, o.comment, true) && OperationDefinition.compareDeep(this.base, o.base, true) && OperationDefinition.compareDeep(this.resource, o.resource, true) && OperationDefinition.compareDeep(this.system, o.system, true) && OperationDefinition.compareDeep(this.type, o.type, true) && OperationDefinition.compareDeep(this.instance, o.instance, true) && OperationDefinition.compareDeep(this.inputProfile, o.inputProfile, true) && OperationDefinition.compareDeep(this.outputProfile, o.outputProfile, true) && OperationDefinition.compareDeep(this.parameter, o.parameter, true) && OperationDefinition.compareDeep(this.overload, o.overload, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition o = (OperationDefinition)other_;
        return OperationDefinition.compareValues(this.url, o.url, true) && OperationDefinition.compareValues(this.version, o.version, true) && OperationDefinition.compareValues(this.name, o.name, true) && OperationDefinition.compareValues(this.title, o.title, true) && OperationDefinition.compareValues(this.status, o.status, true) && OperationDefinition.compareValues(this.kind, o.kind, true) && OperationDefinition.compareValues(this.experimental, o.experimental, true) && OperationDefinition.compareValues(this.date, o.date, true) && OperationDefinition.compareValues(this.publisher, o.publisher, true) && OperationDefinition.compareValues(this.description, o.description, true) && OperationDefinition.compareValues(this.purpose, o.purpose, true) && OperationDefinition.compareValues(this.affectsState, o.affectsState, true) && OperationDefinition.compareValues(this.code, o.code, true) && OperationDefinition.compareValues(this.comment, o.comment, true) && OperationDefinition.compareValues(this.base, o.base, true) && OperationDefinition.compareValues(this.resource, o.resource, true) && OperationDefinition.compareValues(this.system, o.system, true) && OperationDefinition.compareValues(this.type, o.type, true) && OperationDefinition.compareValues(this.instance, o.instance, true) && OperationDefinition.compareValues(this.inputProfile, o.inputProfile, true) && OperationDefinition.compareValues(this.outputProfile, o.outputProfile, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.version, this.name, this.title, this.status, this.kind, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.affectsState, this.code, this.comment, this.base, this.resource, this.system, this.type, this.instance, this.inputProfile, this.outputProfile, this.parameter, this.overload});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OperationDefinition;
    }

    @Override
    public String getCopyright() {
        return new String();
    }

    @Override
    public MarkdownType getCopyrightElement() {
        return new MarkdownType();
    }

    @Override
    public CanonicalResource setCopyright(String theCopyright) {
        return this;
    }

    @Override
    public CanonicalResource setCopyrightElement(MarkdownType theCopyright) {
        return this;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public List<Identifier> getIdentifier() {
        return new ArrayList<Identifier>();
    }

    @Override
    public CanonicalResource setIdentifier(List<Identifier> theIdentifier) {
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        return null;
    }

    @Override
    public CanonicalResource addIdentifier(Identifier t) {
        return null;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        return new Identifier();
    }

    @Override
    public boolean supportsCopyright() {
        return false;
    }

    @Block
    public static class OperationDefinitionOverloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="parameterName", type={StringType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Name of parameter to include in overload", formalDefinition="Name of parameter to include in overload.")
        protected List<StringType> parameterName;
        @Child(name="comment", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comments to go on overload", formalDefinition="Comments to go on overload.")
        protected StringType comment;
        private static final long serialVersionUID = -907948545L;

        public List<StringType> getParameterName() {
            if (this.parameterName == null) {
                this.parameterName = new ArrayList<StringType>();
            }
            return this.parameterName;
        }

        public OperationDefinitionOverloadComponent setParameterName(List<StringType> theParameterName) {
            this.parameterName = theParameterName;
            return this;
        }

        public boolean hasParameterName() {
            if (this.parameterName == null) {
                return false;
            }
            for (StringType item : this.parameterName) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addParameterNameElement() {
            StringType t = new StringType();
            if (this.parameterName == null) {
                this.parameterName = new ArrayList<StringType>();
            }
            this.parameterName.add(t);
            return t;
        }

        public OperationDefinitionOverloadComponent addParameterName(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.parameterName == null) {
                this.parameterName = new ArrayList<StringType>();
            }
            this.parameterName.add(t);
            return this;
        }

        public boolean hasParameterName(String value) {
            if (this.parameterName == null) {
                return false;
            }
            for (StringType v : this.parameterName) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionOverloadComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public OperationDefinitionOverloadComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public OperationDefinitionOverloadComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("parameterName", "string", "Name of parameter to include in overload.", 0, Integer.MAX_VALUE, this.parameterName));
            children.add(new Property("comment", "string", "Comments to go on overload.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -379607596: {
                    return new Property("parameterName", "string", "Name of parameter to include in overload.", 0, Integer.MAX_VALUE, this.parameterName);
                }
                case 950398559: {
                    return new Property("comment", "string", "Comments to go on overload.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    return this.parameterName == null ? new Base[]{} : this.parameterName.toArray(new Base[this.parameterName.size()]);
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    this.getParameterName().add(TypeConvertor.castToString(value));
                    return value;
                }
                case 950398559: {
                    this.comment = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("parameterName")) {
                this.getParameterName().add(TypeConvertor.castToString(value));
            } else if (name.equals("comment")) {
                this.comment = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("parameterName")) {
                this.getParameterName().remove(value);
            } else if (name.equals("comment")) {
                this.comment = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    return this.addParameterNameElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    return new String[]{"string"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("parameterName")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.overload.parameterName");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.overload.comment");
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionOverloadComponent copy() {
            OperationDefinitionOverloadComponent dst = new OperationDefinitionOverloadComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OperationDefinitionOverloadComponent dst) {
            super.copyValues(dst);
            if (this.parameterName != null) {
                dst.parameterName = new ArrayList<StringType>();
                for (StringType i : this.parameterName) {
                    dst.parameterName.add(i.copy());
                }
            }
            dst.comment = this.comment == null ? null : this.comment.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionOverloadComponent)) {
                return false;
            }
            OperationDefinitionOverloadComponent o = (OperationDefinitionOverloadComponent)other_;
            return OperationDefinitionOverloadComponent.compareDeep(this.parameterName, o.parameterName, true) && OperationDefinitionOverloadComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionOverloadComponent)) {
                return false;
            }
            OperationDefinitionOverloadComponent o = (OperationDefinitionOverloadComponent)other_;
            return OperationDefinitionOverloadComponent.compareValues(this.parameterName, o.parameterName, true) && OperationDefinitionOverloadComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.parameterName, this.comment});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.overload";
        }
    }

    @Block
    public static class OperationDefinitionParameterReferencedFromComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Referencing parameter", formalDefinition="The name of the parameter or dot-separated path of parameter names pointing to the resource parameter that is expected to contain a reference to this resource.")
        protected StringType source;
        @Child(name="sourceId", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Element id of reference", formalDefinition="The id of the element in the referencing resource that is expected to resolve to this resource.")
        protected StringType sourceId;
        private static final long serialVersionUID = -104239783L;

        public OperationDefinitionParameterReferencedFromComponent() {
        }

        public OperationDefinitionParameterReferencedFromComponent(String source) {
            this.setSource(source);
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterReferencedFromComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public OperationDefinitionParameterReferencedFromComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public OperationDefinitionParameterReferencedFromComponent setSource(String value) {
            if (this.source == null) {
                this.source = new StringType();
            }
            this.source.setValue(value);
            return this;
        }

        public StringType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterReferencedFromComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new StringType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public OperationDefinitionParameterReferencedFromComponent setSourceIdElement(StringType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : (String)this.sourceId.getValue();
        }

        public OperationDefinitionParameterReferencedFromComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new StringType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("source", "string", "The name of the parameter or dot-separated path of parameter names pointing to the resource parameter that is expected to contain a reference to this resource.", 0, 1, this.source));
            children.add(new Property("sourceId", "string", "The id of the element in the referencing resource that is expected to resolve to this resource.", 0, 1, this.sourceId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property("source", "string", "The name of the parameter or dot-separated path of parameter names pointing to the resource parameter that is expected to contain a reference to this resource.", 0, 1, this.source);
                }
                case 1746327190: {
                    return new Property("sourceId", "string", "The id of the element in the referencing resource that is expected to resolve to this resource.", 0, 1, this.sourceId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sourceId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = TypeConvertor.castToString(value);
                    return value;
                }
                case 1746327190: {
                    this.sourceId = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = TypeConvertor.castToString(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = null;
            } else if (name.equals("sourceId")) {
                this.sourceId = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSourceElement();
                }
                case 1746327190: {
                    return this.getSourceIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"string"};
                }
                case 1746327190: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.referencedFrom.source");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.referencedFrom.sourceId");
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterReferencedFromComponent copy() {
            OperationDefinitionParameterReferencedFromComponent dst = new OperationDefinitionParameterReferencedFromComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OperationDefinitionParameterReferencedFromComponent dst) {
            super.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterReferencedFromComponent)) {
                return false;
            }
            OperationDefinitionParameterReferencedFromComponent o = (OperationDefinitionParameterReferencedFromComponent)other_;
            return OperationDefinitionParameterReferencedFromComponent.compareDeep(this.source, o.source, true) && OperationDefinitionParameterReferencedFromComponent.compareDeep(this.sourceId, o.sourceId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterReferencedFromComponent)) {
                return false;
            }
            OperationDefinitionParameterReferencedFromComponent o = (OperationDefinitionParameterReferencedFromComponent)other_;
            return OperationDefinitionParameterReferencedFromComponent.compareValues(this.source, o.source, true) && OperationDefinitionParameterReferencedFromComponent.compareValues(this.sourceId, o.sourceId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.source, this.sourceId});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter.referencedFrom";
        }
    }

    @Block
    public static class OperationDefinitionParameterBindingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="strength", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="required | extensible | preferred | example", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/binding-strength")
        protected Enumeration<Enumerations.BindingStrength> strength;
        @Child(name="valueSet", type={CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source of value set", formalDefinition="Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.")
        protected CanonicalType valueSet;
        private static final long serialVersionUID = -2048653907L;

        public OperationDefinitionParameterBindingComponent() {
        }

        public OperationDefinitionParameterBindingComponent(Enumerations.BindingStrength strength, String valueSet) {
            this.setStrength(strength);
            this.setValueSet(valueSet);
        }

        public Enumeration<Enumerations.BindingStrength> getStrengthElement() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterBindingComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
                }
            }
            return this.strength;
        }

        public boolean hasStrengthElement() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public OperationDefinitionParameterBindingComponent setStrengthElement(Enumeration<Enumerations.BindingStrength> value) {
            this.strength = value;
            return this;
        }

        public Enumerations.BindingStrength getStrength() {
            return this.strength == null ? null : (Enumerations.BindingStrength)((Object)this.strength.getValue());
        }

        public OperationDefinitionParameterBindingComponent setStrength(Enumerations.BindingStrength value) {
            if (this.strength == null) {
                this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
            }
            this.strength.setValue((Object)value);
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterBindingComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public OperationDefinitionParameterBindingComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public OperationDefinitionParameterBindingComponent setValueSet(String value) {
            if (this.valueSet == null) {
                this.valueSet = new CanonicalType();
            }
            this.valueSet.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("strength", OperationDefinition.SP_CODE, "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, 1, this.strength));
            children.add(new Property("valueSet", "canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1791316033: {
                    return new Property("strength", OperationDefinition.SP_CODE, "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, 1, this.strength);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.strength;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.valueSet;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    value = new Enumerations.BindingStrengthEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.strength = value;
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("strength")) {
                value = new Enumerations.BindingStrengthEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.strength = value;
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("strength")) {
                this.strength = null;
            } else if (name.equals("valueSet")) {
                this.valueSet = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    return this.getStrengthElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("strength")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.binding.strength");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.binding.valueSet");
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterBindingComponent copy() {
            OperationDefinitionParameterBindingComponent dst = new OperationDefinitionParameterBindingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OperationDefinitionParameterBindingComponent dst) {
            super.copyValues(dst);
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterBindingComponent)) {
                return false;
            }
            OperationDefinitionParameterBindingComponent o = (OperationDefinitionParameterBindingComponent)other_;
            return OperationDefinitionParameterBindingComponent.compareDeep(this.strength, o.strength, true) && OperationDefinitionParameterBindingComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterBindingComponent)) {
                return false;
            }
            OperationDefinitionParameterBindingComponent o = (OperationDefinitionParameterBindingComponent)other_;
            return OperationDefinitionParameterBindingComponent.compareValues(this.strength, o.strength, true) && OperationDefinitionParameterBindingComponent.compareValues(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.strength, this.valueSet});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter.binding";
        }
    }

    @Block
    public static class OperationDefinitionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name in Parameters.parameter.name or in URL", formalDefinition="The name of used to identify the parameter.")
        protected CodeType name;
        @Child(name="use", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="in | out", formalDefinition="Whether this is an input or an output parameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-parameter-use")
        protected Enumeration<Enumerations.OperationParameterUse> use;
        @Child(name="min", type={IntegerType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum Cardinality", formalDefinition="The minimum number of times this parameter SHALL appear in the request or response.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum Cardinality (a number or *)", formalDefinition="The maximum number of times this element is permitted to appear in the request or response.")
        protected StringType max;
        @Child(name="documentation", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of meaning/use", formalDefinition="Describes the meaning or use of this parameter.")
        protected StringType documentation;
        @Child(name="type", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type this parameter has", formalDefinition="The type for this parameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-types")
        protected Enumeration<Enumerations.FHIRAllTypes> type;
        @Child(name="targetProfile", type={CanonicalType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="If type is Reference | canonical, allowed targets", formalDefinition="Used when the type is \"Reference\" or \"canonical\", and identifies a profile structure or implementation Guide that applies to the target of the reference this parameter refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.")
        protected List<CanonicalType> targetProfile;
        @Child(name="searchType", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri | special", formalDefinition="How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
        protected Enumeration<Enumerations.SearchParamType> searchType;
        @Child(name="binding", type={}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ValueSet details if this is coded", formalDefinition="Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).")
        protected OperationDefinitionParameterBindingComponent binding;
        @Child(name="referencedFrom", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="References to this parameter", formalDefinition="Identifies other resource parameters within the operation invocation that are expected to resolve to this resource.")
        protected List<OperationDefinitionParameterReferencedFromComponent> referencedFrom;
        @Child(name="part", type={OperationDefinitionParameterComponent.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parts of a nested Parameter", formalDefinition="The parts of a nested Parameter.")
        protected List<OperationDefinitionParameterComponent> part;
        private static final long serialVersionUID = -153032790L;

        public OperationDefinitionParameterComponent() {
        }

        public OperationDefinitionParameterComponent(String name, Enumerations.OperationParameterUse use, int min, String max) {
            this.setName(name);
            this.setUse(use);
            this.setMin(min);
            this.setMax(max);
        }

        public CodeType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public OperationDefinitionParameterComponent setNameElement(CodeType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public OperationDefinitionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.OperationParameterUse> getUseElement() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
                }
            }
            return this.use;
        }

        public boolean hasUseElement() {
            return this.use != null && !this.use.isEmpty();
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public OperationDefinitionParameterComponent setUseElement(Enumeration<Enumerations.OperationParameterUse> value) {
            this.use = value;
            return this;
        }

        public Enumerations.OperationParameterUse getUse() {
            return this.use == null ? null : (Enumerations.OperationParameterUse)((Object)this.use.getValue());
        }

        public OperationDefinitionParameterComponent setUse(Enumerations.OperationParameterUse value) {
            if (this.use == null) {
                this.use = new Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
            }
            this.use.setValue((Object)value);
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public OperationDefinitionParameterComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public OperationDefinitionParameterComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public OperationDefinitionParameterComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public OperationDefinitionParameterComponent setMax(String value) {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public OperationDefinitionParameterComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public OperationDefinitionParameterComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.FHIRAllTypes> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.FHIRAllTypes>(new Enumerations.FHIRAllTypesEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public OperationDefinitionParameterComponent setTypeElement(Enumeration<Enumerations.FHIRAllTypes> value) {
            this.type = value;
            return this;
        }

        public Enumerations.FHIRAllTypes getType() {
            return this.type == null ? null : (Enumerations.FHIRAllTypes)((Object)this.type.getValue());
        }

        public OperationDefinitionParameterComponent setType(Enumerations.FHIRAllTypes value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.FHIRAllTypes>(new Enumerations.FHIRAllTypesEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public List<CanonicalType> getTargetProfile() {
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            return this.targetProfile;
        }

        public OperationDefinitionParameterComponent setTargetProfile(List<CanonicalType> theTargetProfile) {
            this.targetProfile = theTargetProfile;
            return this;
        }

        public boolean hasTargetProfile() {
            if (this.targetProfile == null) {
                return false;
            }
            for (CanonicalType item : this.targetProfile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addTargetProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            this.targetProfile.add(t);
            return t;
        }

        public OperationDefinitionParameterComponent addTargetProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            this.targetProfile.add(t);
            return this;
        }

        public boolean hasTargetProfile(String value) {
            if (this.targetProfile == null) {
                return false;
            }
            for (CanonicalType v : this.targetProfile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.SearchParamType> getSearchTypeElement() {
            if (this.searchType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.searchType");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchType = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
            }
            return this.searchType;
        }

        public boolean hasSearchTypeElement() {
            return this.searchType != null && !this.searchType.isEmpty();
        }

        public boolean hasSearchType() {
            return this.searchType != null && !this.searchType.isEmpty();
        }

        public OperationDefinitionParameterComponent setSearchTypeElement(Enumeration<Enumerations.SearchParamType> value) {
            this.searchType = value;
            return this;
        }

        public Enumerations.SearchParamType getSearchType() {
            return this.searchType == null ? null : (Enumerations.SearchParamType)((Object)this.searchType.getValue());
        }

        public OperationDefinitionParameterComponent setSearchType(Enumerations.SearchParamType value) {
            if (value == null) {
                this.searchType = null;
            } else {
                if (this.searchType == null) {
                    this.searchType = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
                this.searchType.setValue((Object)value);
            }
            return this;
        }

        public OperationDefinitionParameterBindingComponent getBinding() {
            if (this.binding == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.binding");
                }
                if (Configuration.doAutoCreate()) {
                    this.binding = new OperationDefinitionParameterBindingComponent();
                }
            }
            return this.binding;
        }

        public boolean hasBinding() {
            return this.binding != null && !this.binding.isEmpty();
        }

        public OperationDefinitionParameterComponent setBinding(OperationDefinitionParameterBindingComponent value) {
            this.binding = value;
            return this;
        }

        public List<OperationDefinitionParameterReferencedFromComponent> getReferencedFrom() {
            if (this.referencedFrom == null) {
                this.referencedFrom = new ArrayList<OperationDefinitionParameterReferencedFromComponent>();
            }
            return this.referencedFrom;
        }

        public OperationDefinitionParameterComponent setReferencedFrom(List<OperationDefinitionParameterReferencedFromComponent> theReferencedFrom) {
            this.referencedFrom = theReferencedFrom;
            return this;
        }

        public boolean hasReferencedFrom() {
            if (this.referencedFrom == null) {
                return false;
            }
            for (OperationDefinitionParameterReferencedFromComponent item : this.referencedFrom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OperationDefinitionParameterReferencedFromComponent addReferencedFrom() {
            OperationDefinitionParameterReferencedFromComponent t = new OperationDefinitionParameterReferencedFromComponent();
            if (this.referencedFrom == null) {
                this.referencedFrom = new ArrayList<OperationDefinitionParameterReferencedFromComponent>();
            }
            this.referencedFrom.add(t);
            return t;
        }

        public OperationDefinitionParameterComponent addReferencedFrom(OperationDefinitionParameterReferencedFromComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referencedFrom == null) {
                this.referencedFrom = new ArrayList<OperationDefinitionParameterReferencedFromComponent>();
            }
            this.referencedFrom.add(t);
            return this;
        }

        public OperationDefinitionParameterReferencedFromComponent getReferencedFromFirstRep() {
            if (this.getReferencedFrom().isEmpty()) {
                this.addReferencedFrom();
            }
            return this.getReferencedFrom().get(0);
        }

        public List<OperationDefinitionParameterComponent> getPart() {
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            return this.part;
        }

        public OperationDefinitionParameterComponent setPart(List<OperationDefinitionParameterComponent> thePart) {
            this.part = thePart;
            return this;
        }

        public boolean hasPart() {
            if (this.part == null) {
                return false;
            }
            for (OperationDefinitionParameterComponent item : this.part) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OperationDefinitionParameterComponent addPart() {
            OperationDefinitionParameterComponent t = new OperationDefinitionParameterComponent();
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            this.part.add(t);
            return t;
        }

        public OperationDefinitionParameterComponent addPart(OperationDefinitionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            this.part.add(t);
            return this;
        }

        public OperationDefinitionParameterComponent getPartFirstRep() {
            if (this.getPart().isEmpty()) {
                this.addPart();
            }
            return this.getPart().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(OperationDefinition.SP_NAME, OperationDefinition.SP_CODE, "The name of used to identify the parameter.", 0, 1, this.name));
            children.add(new Property("use", OperationDefinition.SP_CODE, "Whether this is an input or an output parameter.", 0, 1, this.use));
            children.add(new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, 1, this.min));
            children.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, 1, this.max));
            children.add(new Property("documentation", "string", "Describes the meaning or use of this parameter.", 0, 1, this.documentation));
            children.add(new Property(OperationDefinition.SP_TYPE, OperationDefinition.SP_CODE, "The type for this parameter.", 0, 1, this.type));
            children.add(new Property("targetProfile", "canonical(StructureDefinition)", "Used when the type is \"Reference\" or \"canonical\", and identifies a profile structure or implementation Guide that applies to the target of the reference this parameter refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.targetProfile));
            children.add(new Property("searchType", OperationDefinition.SP_CODE, "How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.", 0, 1, this.searchType));
            children.add(new Property("binding", "", "Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).", 0, 1, this.binding));
            children.add(new Property("referencedFrom", "", "Identifies other resource parameters within the operation invocation that are expected to resolve to this resource.", 0, Integer.MAX_VALUE, this.referencedFrom));
            children.add(new Property("part", "@OperationDefinition.parameter", "The parts of a nested Parameter.", 0, Integer.MAX_VALUE, this.part));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(OperationDefinition.SP_NAME, OperationDefinition.SP_CODE, "The name of used to identify the parameter.", 0, 1, this.name);
                }
                case 116103: {
                    return new Property("use", OperationDefinition.SP_CODE, "Whether this is an input or an output parameter.", 0, 1, this.use);
                }
                case 108114: {
                    return new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, 1, this.max);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Describes the meaning or use of this parameter.", 0, 1, this.documentation);
                }
                case 3575610: {
                    return new Property(OperationDefinition.SP_TYPE, OperationDefinition.SP_CODE, "The type for this parameter.", 0, 1, this.type);
                }
                case 1994521304: {
                    return new Property("targetProfile", "canonical(StructureDefinition)", "Used when the type is \"Reference\" or \"canonical\", and identifies a profile structure or implementation Guide that applies to the target of the reference this parameter refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.", 0, Integer.MAX_VALUE, this.targetProfile);
                }
                case -710454014: {
                    return new Property("searchType", OperationDefinition.SP_CODE, "How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.", 0, 1, this.searchType);
                }
                case -108220795: {
                    return new Property("binding", "", "Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).", 0, 1, this.binding);
                }
                case -1896721981: {
                    return new Property("referencedFrom", "", "Identifies other resource parameters within the operation invocation that are expected to resolve to this resource.", 0, Integer.MAX_VALUE, this.referencedFrom);
                }
                case 3433459: {
                    return new Property("part", "@OperationDefinition.parameter", "The parts of a nested Parameter.", 0, Integer.MAX_VALUE, this.part);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.max;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.type;
                    }
                    return baseArray;
                }
                case 1994521304: {
                    return this.targetProfile == null ? new Base[]{} : this.targetProfile.toArray(new Base[this.targetProfile.size()]);
                }
                case -710454014: {
                    Base[] baseArray;
                    if (this.searchType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.searchType;
                    }
                    return baseArray;
                }
                case -108220795: {
                    Base[] baseArray;
                    if (this.binding == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.binding;
                    }
                    return baseArray;
                }
                case -1896721981: {
                    return this.referencedFrom == null ? new Base[]{} : this.referencedFrom.toArray(new Base[this.referencedFrom.size()]);
                }
                case 3433459: {
                    return this.part == null ? new Base[]{} : this.part.toArray(new Base[this.part.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116103: {
                    value = new Enumerations.OperationParameterUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.use = value;
                    return value;
                }
                case 108114: {
                    this.min = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 107876: {
                    this.max = TypeConvertor.castToString(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.FHIRAllTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 1994521304: {
                    this.getTargetProfile().add(TypeConvertor.castToCanonical(value));
                    return value;
                }
                case -710454014: {
                    value = new Enumerations.SearchParamTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.searchType = value;
                    return value;
                }
                case -108220795: {
                    this.binding = (OperationDefinitionParameterBindingComponent)((Object)value);
                    return value;
                }
                case -1896721981: {
                    this.getReferencedFrom().add((OperationDefinitionParameterReferencedFromComponent)((Object)value));
                    return value;
                }
                case 3433459: {
                    this.getPart().add((OperationDefinitionParameterComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                this.name = TypeConvertor.castToCode(value);
            } else if (name.equals("use")) {
                value = new Enumerations.OperationParameterUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
            } else if (name.equals("min")) {
                this.min = TypeConvertor.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = TypeConvertor.castToString(value);
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToString(value);
            } else if (name.equals(OperationDefinition.SP_TYPE)) {
                value = new Enumerations.FHIRAllTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("targetProfile")) {
                this.getTargetProfile().add(TypeConvertor.castToCanonical(value));
            } else if (name.equals("searchType")) {
                value = new Enumerations.SearchParamTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.searchType = value;
            } else if (name.equals("binding")) {
                this.binding = (OperationDefinitionParameterBindingComponent)((Object)value);
            } else if (name.equals("referencedFrom")) {
                this.getReferencedFrom().add((OperationDefinitionParameterReferencedFromComponent)((Object)value));
            } else if (name.equals("part")) {
                this.getPart().add((OperationDefinitionParameterComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                this.name = null;
            } else if (name.equals("use")) {
                this.use = null;
            } else if (name.equals("min")) {
                this.min = null;
            } else if (name.equals("max")) {
                this.max = null;
            } else if (name.equals("documentation")) {
                this.documentation = null;
            } else if (name.equals(OperationDefinition.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("targetProfile")) {
                this.getTargetProfile().remove(value);
            } else if (name.equals("searchType")) {
                this.searchType = null;
            } else if (name.equals("binding")) {
                this.binding = (OperationDefinitionParameterBindingComponent)value;
            } else if (name.equals("referencedFrom")) {
                this.getReferencedFrom().remove((OperationDefinitionParameterReferencedFromComponent)value);
            } else if (name.equals("part")) {
                this.getPart().remove((OperationDefinitionParameterComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 116103: {
                    return this.getUseElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 1994521304: {
                    return this.addTargetProfileElement();
                }
                case -710454014: {
                    return this.getSearchTypeElement();
                }
                case -108220795: {
                    return this.getBinding();
                }
                case -1896721981: {
                    return this.addReferencedFrom();
                }
                case 3433459: {
                    return this.addPart();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case 116103: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case 108114: {
                    return new String[]{"integer"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case 1994521304: {
                    return new String[]{"canonical"};
                }
                case -710454014: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case -108220795: {
                    return new String[0];
                }
                case -1896721981: {
                    return new String[0];
                }
                case 3433459: {
                    return new String[]{"@OperationDefinition.parameter"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.name");
            }
            if (name.equals("use")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.use");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.max");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.documentation");
            }
            if (name.equals(OperationDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.type");
            }
            if (name.equals("targetProfile")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.targetProfile");
            }
            if (name.equals("searchType")) {
                throw new FHIRException("Cannot call addChild on a singleton property OperationDefinition.parameter.searchType");
            }
            if (name.equals("binding")) {
                this.binding = new OperationDefinitionParameterBindingComponent();
                return this.binding;
            }
            if (name.equals("referencedFrom")) {
                return this.addReferencedFrom();
            }
            if (name.equals("part")) {
                return this.addPart();
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterComponent copy() {
            OperationDefinitionParameterComponent dst = new OperationDefinitionParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OperationDefinitionParameterComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            Enumeration<Enumerations.FHIRAllTypes> enumeration = dst.type = this.type == null ? null : this.type.copy();
            if (this.targetProfile != null) {
                dst.targetProfile = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.targetProfile) {
                    dst.targetProfile.add(canonicalType.copy());
                }
            }
            dst.searchType = this.searchType == null ? null : this.searchType.copy();
            OperationDefinitionParameterBindingComponent operationDefinitionParameterBindingComponent = dst.binding = this.binding == null ? null : this.binding.copy();
            if (this.referencedFrom != null) {
                dst.referencedFrom = new ArrayList<OperationDefinitionParameterReferencedFromComponent>();
                for (OperationDefinitionParameterReferencedFromComponent operationDefinitionParameterReferencedFromComponent : this.referencedFrom) {
                    dst.referencedFrom.add(operationDefinitionParameterReferencedFromComponent.copy());
                }
            }
            if (this.part != null) {
                dst.part = new ArrayList<OperationDefinitionParameterComponent>();
                for (OperationDefinitionParameterComponent operationDefinitionParameterComponent : this.part) {
                    dst.part.add(operationDefinitionParameterComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterComponent)) {
                return false;
            }
            OperationDefinitionParameterComponent o = (OperationDefinitionParameterComponent)other_;
            return OperationDefinitionParameterComponent.compareDeep(this.name, o.name, true) && OperationDefinitionParameterComponent.compareDeep(this.use, o.use, true) && OperationDefinitionParameterComponent.compareDeep(this.min, o.min, true) && OperationDefinitionParameterComponent.compareDeep(this.max, o.max, true) && OperationDefinitionParameterComponent.compareDeep(this.documentation, o.documentation, true) && OperationDefinitionParameterComponent.compareDeep(this.type, o.type, true) && OperationDefinitionParameterComponent.compareDeep(this.targetProfile, o.targetProfile, true) && OperationDefinitionParameterComponent.compareDeep(this.searchType, o.searchType, true) && OperationDefinitionParameterComponent.compareDeep(this.binding, o.binding, true) && OperationDefinitionParameterComponent.compareDeep(this.referencedFrom, o.referencedFrom, true) && OperationDefinitionParameterComponent.compareDeep(this.part, o.part, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterComponent)) {
                return false;
            }
            OperationDefinitionParameterComponent o = (OperationDefinitionParameterComponent)other_;
            return OperationDefinitionParameterComponent.compareValues(this.name, o.name, true) && OperationDefinitionParameterComponent.compareValues(this.use, o.use, true) && OperationDefinitionParameterComponent.compareValues(this.min, o.min, true) && OperationDefinitionParameterComponent.compareValues(this.max, o.max, true) && OperationDefinitionParameterComponent.compareValues(this.documentation, o.documentation, true) && OperationDefinitionParameterComponent.compareValues(this.type, o.type, true) && OperationDefinitionParameterComponent.compareValues(this.targetProfile, o.targetProfile, true) && OperationDefinitionParameterComponent.compareValues(this.searchType, o.searchType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.use, this.min, this.max, this.documentation, this.type, this.targetProfile, this.searchType, this.binding, this.referencedFrom, this.part});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter";
        }
    }

    public static class OperationKindEnumFactory
    implements EnumFactory<OperationKind> {
        @Override
        public OperationKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return OperationKind.OPERATION;
            }
            if ("query".equals(codeString)) {
                return OperationKind.QUERY;
            }
            throw new IllegalArgumentException("Unknown OperationKind code '" + codeString + "'");
        }

        public Enumeration<OperationKind> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<OperationKind>(this, OperationKind.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.NULL, code);
            }
            if ("operation".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.OPERATION, code);
            }
            if ("query".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.QUERY, code);
            }
            throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
        }

        @Override
        public String toCode(OperationKind code) {
            if (code == OperationKind.OPERATION) {
                return "operation";
            }
            if (code == OperationKind.QUERY) {
                return "query";
            }
            return "?";
        }

        @Override
        public String toSystem(OperationKind code) {
            return code.getSystem();
        }
    }

    public static enum OperationKind {
        OPERATION,
        QUERY,
        NULL;


        public static OperationKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return OPERATION;
            }
            if ("query".equals(codeString)) {
                return QUERY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OPERATION: {
                    return "operation";
                }
                case QUERY: {
                    return "query";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OPERATION: {
                    return "http://hl7.org/fhir/operation-kind";
                }
                case QUERY: {
                    return "http://hl7.org/fhir/operation-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OPERATION: {
                    return "This operation is invoked as an operation.";
                }
                case QUERY: {
                    return "This operation is a named query, invoked using the search mechanism.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OPERATION: {
                    return "Operation";
                }
                case QUERY: {
                    return "Query";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

