/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.utils.structuremap;

import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.utils.structuremap.VariableMode;

public class Variable {
    private VariableMode mode;
    private String name;
    private Base object;

    public Variable(VariableMode mode, String name, Base object) {
        this.mode = mode;
        this.name = name;
        this.object = object;
    }

    public VariableMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public Base getObject() {
        return this.object;
    }

    public String summary() {
        if (this.object == null) {
            return null;
        }
        if (this.object instanceof PrimitiveType) {
            return this.name + ": \"" + ((PrimitiveType)this.object).asStringValue() + "\"";
        }
        return this.name + ": (" + this.object.fhirType() + ")";
    }
}

