/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.Extension;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="BackboneElement")
public abstract class BackboneElement
extends DataType
implements IBaseBackboneElement {
    @Child(name="modifierExtension", type={Extension.class}, order=0, min=0, max=-1, modifier=true, summary=true)
    @Description(shortDefinition="Extensions that cannot be ignored even if unrecognized", formalDefinition="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).")
    protected List<Extension> modifierExtension;
    private static final long serialVersionUID = -1431673179L;

    public List<Extension> getModifierExtension() {
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        return this.modifierExtension;
    }

    public BackboneElement setModifierExtension(List<Extension> theModifierExtension) {
        this.modifierExtension = theModifierExtension;
        return this;
    }

    public boolean hasModifierExtension() {
        if (this.modifierExtension == null) {
            return false;
        }
        for (Extension item : this.modifierExtension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addModifierExtension() {
        Extension t = new Extension();
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return t;
    }

    public BackboneElement addModifierExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return this;
    }

    public Extension getModifierExtensionFirstRep() {
        if (this.getModifierExtension().isEmpty()) {
            this.addModifierExtension();
        }
        return this.getModifierExtension().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).", 0, Integer.MAX_VALUE, this.modifierExtension));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -298878168: {
                return new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).", 0, Integer.MAX_VALUE, this.modifierExtension);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -298878168: {
                return this.modifierExtension == null ? new Base[]{} : this.modifierExtension.toArray(new Base[this.modifierExtension.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -298878168: {
                this.getModifierExtension().add(TypeConvertor.castToExtension(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("modifierExtension")) {
            return super.setProperty(name, value);
        }
        this.getModifierExtension().add(TypeConvertor.castToExtension(value));
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("modifierExtension")) {
            this.getModifierExtension().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -298878168: {
                return this.addModifierExtension();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -298878168: {
                return new String[]{"Extension"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("modifierExtension")) {
            return this.addModifierExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BackboneElement";
    }

    @Override
    public abstract BackboneElement copy();

    public void copyValues(BackboneElement dst) {
        super.copyValues(dst);
        if (this.modifierExtension != null) {
            dst.modifierExtension = new ArrayList<Extension>();
            for (Extension i : this.modifierExtension) {
                dst.modifierExtension.add(i.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BackboneElement)) {
            return false;
        }
        BackboneElement o = (BackboneElement)other_;
        return BackboneElement.compareDeep(this.modifierExtension, o.modifierExtension, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BackboneElement)) {
            return false;
        }
        BackboneElement o = (BackboneElement)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.modifierExtension);
    }

    public void checkNoModifiers(String noun, String verb) throws FHIRException {
        if (this.hasModifierExtension()) {
            throw new FHIRException("Found unknown Modifier Exceptions on " + noun + " doing " + verb);
        }
    }

    public void addModifierExtension(String url, DataType value) {
        if (this.isDisallowExtensions()) {
            throw new Error("Extensions are not allowed in this context");
        }
        Extension ex = new Extension();
        ex.setUrl(url);
        ex.setValue(value);
        this.getModifierExtension().add(ex);
    }

    @Override
    public Extension getExtensionByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        Extension res = super.getExtensionByUrl(theUrl);
        if (res != null) {
            retVal.add(res);
        }
        for (Extension next : this.getModifierExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        if (retVal.size() == 0) {
            return null;
        }
        Validate.isTrue((retVal.size() == 1 ? 1 : 0) != 0, (String)("Url " + theUrl + " must have only one match"), (Object[])new Object[0]);
        return (Extension)retVal.get(0);
    }

    @Override
    public void removeExtension(String theUrl) {
        for (int i = this.getModifierExtension().size() - 1; i >= 0; --i) {
            if (!theUrl.equals(this.getExtension().get(i).getUrl())) continue;
            this.getExtension().remove(i);
        }
        super.removeExtension(theUrl);
    }

    @Override
    public List<Extension> getExtensionsByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        retVal.addAll(super.getExtensionsByUrl(theUrl));
        for (Extension next : this.getModifierExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public void copyExtensions(BackboneElement src, String ... urls) {
        super.copyExtensions(src, urls);
        for (Extension e : src.getModifierExtension()) {
            if (!Utilities.existsInList((String)e.getUrl(), (String[])urls)) continue;
            this.addModifierExtension(e.copy());
        }
    }

    @Override
    public List<Extension> getExtensionsByUrl(String ... theUrls) {
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getModifierExtension()) {
            if (!Utilities.existsInList((String)next.getUrl(), (String[])theUrls)) continue;
            retVal.add(next);
        }
        retVal.addAll(super.getExtensionsByUrl(theUrls));
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public boolean hasExtension(String ... theUrls) {
        for (Extension next : this.getModifierExtension()) {
            if (!Utilities.existsInList((String)next.getUrl(), (String[])theUrls)) continue;
            return true;
        }
        return super.hasExtension(theUrls);
    }

    @Override
    public boolean hasExtension(String theUrl) {
        for (Extension ext : this.getModifierExtension()) {
            if (!theUrl.equals(ext.getUrl())) continue;
            return true;
        }
        return super.hasExtension(theUrl);
    }

    public void copyNewExtensions(BackboneElement src, String ... urls) {
        for (Extension e : src.getModifierExtension()) {
            if (!Utilities.existsInList((String)e.getUrl(), (String[])urls) || !this.hasExtension(e.getUrl())) continue;
            this.addExtension(e.copy());
        }
        super.copyNewExtensions(src, urls);
    }
}

