/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.CodeableReference;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.TypeConvertor;

@ResourceDef(name="ClinicalUseDefinition", profile="http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition")
public class ClinicalUseDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this issue", formalDefinition="Business identifier for this issue.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="indication | contraindication | interaction | undesirable-effect | warning", formalDefinition="indication | contraindication | interaction | undesirable-effect | warning.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-use-issue-type")
    protected Enumeration<ClinicalUseIssueType> type;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A categorisation of the issue, primarily for dividing warnings into subject heading areas such as \"Pregnancy and Lactation\", \"Overdose\", \"Effects on Ability to Drive and Use Machines\"", formalDefinition="A categorisation of the issue, primarily for dividing warnings into subject heading areas such as \"Pregnancy and Lactation\", \"Overdose\", \"Effects on Ability to Drive and Use Machines\".")
    protected List<CodeableConcept> category;
    @Child(name="subject", type={MedicinalProductDefinition.class, Medication.class, ActivityDefinition.class, PlanDefinition.class, Device.class, DeviceDefinition.class, Substance.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The medication or procedure for which this is an indication", formalDefinition="The medication or procedure for which this is an indication.")
    protected List<Reference> subject;
    @Child(name="status", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this is a current issue or one that has been retired etc", formalDefinition="Whether this is a current issue or one that has been retired etc.")
    protected CodeableConcept status;
    @Child(name="contraindication", type={}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specifics for when this is a contraindication", formalDefinition="Specifics for when this is a contraindication.")
    protected ClinicalUseDefinitionContraindicationComponent contraindication;
    @Child(name="indication", type={}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specifics for when this is an indication", formalDefinition="Specifics for when this is an indication.")
    protected ClinicalUseDefinitionIndicationComponent indication;
    @Child(name="interaction", type={}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specifics for when this is an interaction", formalDefinition="Specifics for when this is an interaction.")
    protected ClinicalUseDefinitionInteractionComponent interaction;
    @Child(name="population", type={Group.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
    protected List<Reference> population;
    @Child(name="undesirableEffect", type={}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A possible negative outcome from the use of this treatment", formalDefinition="Describe the undesirable effects of the medicinal product.")
    protected ClinicalUseDefinitionUndesirableEffectComponent undesirableEffect;
    @Child(name="warning", type={}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A critical piece of information about environmental, health or physical risks or hazards that serve as caution to the user. For example 'Do not operate heavy machinery', 'May cause drowsiness' or 'Get medical advice/attention if you feel unwell'", formalDefinition="A critical piece of information about environmental, health or physical risks or hazards that serve as caution to the user. For example 'Do not operate heavy machinery', 'May cause drowsiness', or 'Get medical advice/attention if you feel unwell'.")
    protected ClinicalUseDefinitionWarningComponent warning;
    private static final long serialVersionUID = 258286207L;
    @SearchParamDefinition(name="contraindication-reference", path="ClinicalUseDefinition.contraindication.diseaseSymptomProcedure", description="The situation that is being documented as contraindicating against this item, as a reference", type="reference")
    public static final String SP_CONTRAINDICATION_REFERENCE = "contraindication-reference";
    public static final ReferenceClientParam CONTRAINDICATION_REFERENCE = new ReferenceClientParam("contraindication-reference");
    public static final Include INCLUDE_CONTRAINDICATION_REFERENCE = new Include("ClinicalUseDefinition:contraindication-reference").toLocked();
    @SearchParamDefinition(name="contraindication", path="ClinicalUseDefinition.contraindication.diseaseSymptomProcedure", description="The situation that is being documented as contraindicating against this item, as a code", type="token")
    public static final String SP_CONTRAINDICATION = "contraindication";
    public static final TokenClientParam CONTRAINDICATION = new TokenClientParam("contraindication");
    @SearchParamDefinition(name="effect-reference", path="ClinicalUseDefinition.undesirableEffect.symptomConditionEffect", description="The situation in which the undesirable effect may manifest, as a reference", type="reference")
    public static final String SP_EFFECT_REFERENCE = "effect-reference";
    public static final ReferenceClientParam EFFECT_REFERENCE = new ReferenceClientParam("effect-reference");
    public static final Include INCLUDE_EFFECT_REFERENCE = new Include("ClinicalUseDefinition:effect-reference").toLocked();
    @SearchParamDefinition(name="effect", path="ClinicalUseDefinition.undesirableEffect.symptomConditionEffect", description="The situation in which the undesirable effect may manifest, as a code", type="token")
    public static final String SP_EFFECT = "effect";
    public static final TokenClientParam EFFECT = new TokenClientParam("effect");
    @SearchParamDefinition(name="identifier", path="ClinicalUseDefinition.identifier", description="Business identifier for this issue", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="indication-reference", path="ClinicalUseDefinition.indication.diseaseSymptomProcedure", description="The situation that is being documented as an indicaton for this item, as a reference", type="reference")
    public static final String SP_INDICATION_REFERENCE = "indication-reference";
    public static final ReferenceClientParam INDICATION_REFERENCE = new ReferenceClientParam("indication-reference");
    public static final Include INCLUDE_INDICATION_REFERENCE = new Include("ClinicalUseDefinition:indication-reference").toLocked();
    @SearchParamDefinition(name="indication", path="ClinicalUseDefinition.indication.diseaseSymptomProcedure", description="The situation that is being documented as an indicaton for this item, as a code", type="token")
    public static final String SP_INDICATION = "indication";
    public static final TokenClientParam INDICATION = new TokenClientParam("indication");
    @SearchParamDefinition(name="interaction", path="ClinicalUseDefinition.interaction.type", description="The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction", type="token")
    public static final String SP_INTERACTION = "interaction";
    public static final TokenClientParam INTERACTION = new TokenClientParam("interaction");
    @SearchParamDefinition(name="product", path="ClinicalUseDefinition.subject.where(resolve() is MedicinalProductDefinition)", description="The medicinal product for which this is a clinical usage issue", type="reference", target={ActivityDefinition.class, Device.class, DeviceDefinition.class, Medication.class, MedicinalProductDefinition.class, PlanDefinition.class, Substance.class})
    public static final String SP_PRODUCT = "product";
    public static final ReferenceClientParam PRODUCT = new ReferenceClientParam("product");
    public static final Include INCLUDE_PRODUCT = new Include("ClinicalUseDefinition:product").toLocked();
    @SearchParamDefinition(name="subject", path="ClinicalUseDefinition.subject", description="The resource for which this is a clinical usage issue", type="reference", target={ActivityDefinition.class, Device.class, DeviceDefinition.class, Medication.class, MedicinalProductDefinition.class, PlanDefinition.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ClinicalUseDefinition:subject").toLocked();
    @SearchParamDefinition(name="type", path="ClinicalUseDefinition.type", description="indication | contraindication | interaction | undesirable-effect | warning", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public ClinicalUseDefinition() {
    }

    public ClinicalUseDefinition(ClinicalUseIssueType type) {
        this.setType(type);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ClinicalUseDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClinicalUseDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ClinicalUseIssueType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ClinicalUseIssueType>(new ClinicalUseIssueTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ClinicalUseDefinition setTypeElement(Enumeration<ClinicalUseIssueType> value) {
        this.type = value;
        return this;
    }

    public ClinicalUseIssueType getType() {
        return this.type == null ? null : (ClinicalUseIssueType)((Object)this.type.getValue());
    }

    public ClinicalUseDefinition setType(ClinicalUseIssueType value) {
        if (this.type == null) {
            this.type = new Enumeration<ClinicalUseIssueType>(new ClinicalUseIssueTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public ClinicalUseDefinition setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public ClinicalUseDefinition addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public ClinicalUseDefinition setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public ClinicalUseDefinition addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClinicalUseDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public ClinicalUseDefinitionContraindicationComponent getContraindication() {
        if (this.contraindication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.contraindication");
            }
            if (Configuration.doAutoCreate()) {
                this.contraindication = new ClinicalUseDefinitionContraindicationComponent();
            }
        }
        return this.contraindication;
    }

    public boolean hasContraindication() {
        return this.contraindication != null && !this.contraindication.isEmpty();
    }

    public ClinicalUseDefinition setContraindication(ClinicalUseDefinitionContraindicationComponent value) {
        this.contraindication = value;
        return this;
    }

    public ClinicalUseDefinitionIndicationComponent getIndication() {
        if (this.indication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.indication");
            }
            if (Configuration.doAutoCreate()) {
                this.indication = new ClinicalUseDefinitionIndicationComponent();
            }
        }
        return this.indication;
    }

    public boolean hasIndication() {
        return this.indication != null && !this.indication.isEmpty();
    }

    public ClinicalUseDefinition setIndication(ClinicalUseDefinitionIndicationComponent value) {
        this.indication = value;
        return this;
    }

    public ClinicalUseDefinitionInteractionComponent getInteraction() {
        if (this.interaction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.interaction");
            }
            if (Configuration.doAutoCreate()) {
                this.interaction = new ClinicalUseDefinitionInteractionComponent();
            }
        }
        return this.interaction;
    }

    public boolean hasInteraction() {
        return this.interaction != null && !this.interaction.isEmpty();
    }

    public ClinicalUseDefinition setInteraction(ClinicalUseDefinitionInteractionComponent value) {
        this.interaction = value;
        return this;
    }

    public List<Reference> getPopulation() {
        if (this.population == null) {
            this.population = new ArrayList<Reference>();
        }
        return this.population;
    }

    public ClinicalUseDefinition setPopulation(List<Reference> thePopulation) {
        this.population = thePopulation;
        return this;
    }

    public boolean hasPopulation() {
        if (this.population == null) {
            return false;
        }
        for (Reference item : this.population) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPopulation() {
        Reference t = new Reference();
        if (this.population == null) {
            this.population = new ArrayList<Reference>();
        }
        this.population.add(t);
        return t;
    }

    public ClinicalUseDefinition addPopulation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.population == null) {
            this.population = new ArrayList<Reference>();
        }
        this.population.add(t);
        return this;
    }

    public Reference getPopulationFirstRep() {
        if (this.getPopulation().isEmpty()) {
            this.addPopulation();
        }
        return this.getPopulation().get(0);
    }

    public ClinicalUseDefinitionUndesirableEffectComponent getUndesirableEffect() {
        if (this.undesirableEffect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.undesirableEffect");
            }
            if (Configuration.doAutoCreate()) {
                this.undesirableEffect = new ClinicalUseDefinitionUndesirableEffectComponent();
            }
        }
        return this.undesirableEffect;
    }

    public boolean hasUndesirableEffect() {
        return this.undesirableEffect != null && !this.undesirableEffect.isEmpty();
    }

    public ClinicalUseDefinition setUndesirableEffect(ClinicalUseDefinitionUndesirableEffectComponent value) {
        this.undesirableEffect = value;
        return this;
    }

    public ClinicalUseDefinitionWarningComponent getWarning() {
        if (this.warning == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalUseDefinition.warning");
            }
            if (Configuration.doAutoCreate()) {
                this.warning = new ClinicalUseDefinitionWarningComponent();
            }
        }
        return this.warning;
    }

    public boolean hasWarning() {
        return this.warning != null && !this.warning.isEmpty();
    }

    public ClinicalUseDefinition setWarning(ClinicalUseDefinitionWarningComponent value) {
        this.warning = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this issue.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "code", "indication | contraindication | interaction | undesirable-effect | warning.", 0, 1, this.type));
        children.add(new Property("category", "CodeableConcept", "A categorisation of the issue, primarily for dividing warnings into subject heading areas such as \"Pregnancy and Lactation\", \"Overdose\", \"Effects on Ability to Drive and Use Machines\".", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition|Medication|ActivityDefinition|PlanDefinition|Device|DeviceDefinition|Substance)", "The medication or procedure for which this is an indication.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("status", "CodeableConcept", "Whether this is a current issue or one that has been retired etc.", 0, 1, this.status));
        children.add(new Property(SP_CONTRAINDICATION, "", "Specifics for when this is a contraindication.", 0, 1, this.contraindication));
        children.add(new Property(SP_INDICATION, "", "Specifics for when this is an indication.", 0, 1, this.indication));
        children.add(new Property(SP_INTERACTION, "", "Specifics for when this is an interaction.", 0, 1, this.interaction));
        children.add(new Property("population", "Reference(Group)", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
        children.add(new Property("undesirableEffect", "", "Describe the undesirable effects of the medicinal product.", 0, 1, this.undesirableEffect));
        children.add(new Property("warning", "", "A critical piece of information about environmental, health or physical risks or hazards that serve as caution to the user. For example 'Do not operate heavy machinery', 'May cause drowsiness', or 'Get medical advice/attention if you feel unwell'.", 0, 1, this.warning));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this issue.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "indication | contraindication | interaction | undesirable-effect | warning.", 0, 1, this.type);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "A categorisation of the issue, primarily for dividing warnings into subject heading areas such as \"Pregnancy and Lactation\", \"Overdose\", \"Effects on Ability to Drive and Use Machines\".", 0, Integer.MAX_VALUE, this.category);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition|Medication|ActivityDefinition|PlanDefinition|Device|DeviceDefinition|Substance)", "The medication or procedure for which this is an indication.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -892481550: {
                return new Property("status", "CodeableConcept", "Whether this is a current issue or one that has been retired etc.", 0, 1, this.status);
            }
            case 107135229: {
                return new Property(SP_CONTRAINDICATION, "", "Specifics for when this is a contraindication.", 0, 1, this.contraindication);
            }
            case -597168804: {
                return new Property(SP_INDICATION, "", "Specifics for when this is an indication.", 0, 1, this.indication);
            }
            case 1844104722: {
                return new Property(SP_INTERACTION, "", "Specifics for when this is an interaction.", 0, 1, this.interaction);
            }
            case -2023558323: {
                return new Property("population", "Reference(Group)", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
            }
            case 444367565: {
                return new Property("undesirableEffect", "", "Describe the undesirable effects of the medicinal product.", 0, 1, this.undesirableEffect);
            }
            case 1124446108: {
                return new Property("warning", "", "A critical piece of information about environmental, health or physical risks or hazards that serve as caution to the user. For example 'Do not operate heavy machinery', 'May cause drowsiness', or 'Get medical advice/attention if you feel unwell'.", 0, 1, this.warning);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 107135229: {
                Base[] baseArray;
                if (this.contraindication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.contraindication;
                }
                return baseArray;
            }
            case -597168804: {
                Base[] baseArray;
                if (this.indication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.indication;
                }
                return baseArray;
            }
            case 1844104722: {
                Base[] baseArray;
                if (this.interaction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.interaction;
                }
                return baseArray;
            }
            case -2023558323: {
                return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
            }
            case 444367565: {
                Base[] baseArray;
                if (this.undesirableEffect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.undesirableEffect;
                }
                return baseArray;
            }
            case 1124446108: {
                Base[] baseArray;
                if (this.warning == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.warning;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                value = new ClinicalUseIssueTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 107135229: {
                this.contraindication = (ClinicalUseDefinitionContraindicationComponent)((Object)value);
                return value;
            }
            case -597168804: {
                this.indication = (ClinicalUseDefinitionIndicationComponent)((Object)value);
                return value;
            }
            case 1844104722: {
                this.interaction = (ClinicalUseDefinitionInteractionComponent)((Object)value);
                return value;
            }
            case -2023558323: {
                this.getPopulation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 444367565: {
                this.undesirableEffect = (ClinicalUseDefinitionUndesirableEffectComponent)((Object)value);
                return value;
            }
            case 1124446108: {
                this.warning = (ClinicalUseDefinitionWarningComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            value = new ClinicalUseIssueTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals("status")) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CONTRAINDICATION)) {
            this.contraindication = (ClinicalUseDefinitionContraindicationComponent)((Object)value);
        } else if (name.equals(SP_INDICATION)) {
            this.indication = (ClinicalUseDefinitionIndicationComponent)((Object)value);
        } else if (name.equals(SP_INTERACTION)) {
            this.interaction = (ClinicalUseDefinitionInteractionComponent)((Object)value);
        } else if (name.equals("population")) {
            this.getPopulation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("undesirableEffect")) {
            this.undesirableEffect = (ClinicalUseDefinitionUndesirableEffectComponent)((Object)value);
        } else if (name.equals("warning")) {
            this.warning = (ClinicalUseDefinitionWarningComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals("category")) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().remove(value);
        } else if (name.equals("status")) {
            this.status = null;
        } else if (name.equals(SP_CONTRAINDICATION)) {
            this.contraindication = (ClinicalUseDefinitionContraindicationComponent)value;
        } else if (name.equals(SP_INDICATION)) {
            this.indication = (ClinicalUseDefinitionIndicationComponent)value;
        } else if (name.equals(SP_INTERACTION)) {
            this.interaction = (ClinicalUseDefinitionInteractionComponent)value;
        } else if (name.equals("population")) {
            this.getPopulation().remove(value);
        } else if (name.equals("undesirableEffect")) {
            this.undesirableEffect = (ClinicalUseDefinitionUndesirableEffectComponent)value;
        } else if (name.equals("warning")) {
            this.warning = (ClinicalUseDefinitionWarningComponent)value;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 107135229: {
                return this.getContraindication();
            }
            case -597168804: {
                return this.getIndication();
            }
            case 1844104722: {
                return this.getInteraction();
            }
            case -2023558323: {
                return this.addPopulation();
            }
            case 444367565: {
                return this.getUndesirableEffect();
            }
            case 1124446108: {
                return this.getWarning();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 107135229: {
                return new String[0];
            }
            case -597168804: {
                return new String[0];
            }
            case 1844104722: {
                return new String[0];
            }
            case -2023558323: {
                return new String[]{"Reference"};
            }
            case 444367565: {
                return new String[0];
            }
            case 1124446108: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClinicalUseDefinition.type");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("status")) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals(SP_CONTRAINDICATION)) {
            this.contraindication = new ClinicalUseDefinitionContraindicationComponent();
            return this.contraindication;
        }
        if (name.equals(SP_INDICATION)) {
            this.indication = new ClinicalUseDefinitionIndicationComponent();
            return this.indication;
        }
        if (name.equals(SP_INTERACTION)) {
            this.interaction = new ClinicalUseDefinitionInteractionComponent();
            return this.interaction;
        }
        if (name.equals("population")) {
            return this.addPopulation();
        }
        if (name.equals("undesirableEffect")) {
            this.undesirableEffect = new ClinicalUseDefinitionUndesirableEffectComponent();
            return this.undesirableEffect;
        }
        if (name.equals("warning")) {
            this.warning = new ClinicalUseDefinitionWarningComponent();
            return this.warning;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClinicalUseDefinition";
    }

    @Override
    public ClinicalUseDefinition copy() {
        ClinicalUseDefinition dst = new ClinicalUseDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ClinicalUseDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<ClinicalUseIssueType> enumeration = dst.type = this.type == null ? null : this.type.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.contraindication = this.contraindication == null ? null : this.contraindication.copy();
        dst.indication = this.indication == null ? null : this.indication.copy();
        ClinicalUseDefinitionInteractionComponent clinicalUseDefinitionInteractionComponent = dst.interaction = this.interaction == null ? null : this.interaction.copy();
        if (this.population != null) {
            dst.population = new ArrayList<Reference>();
            for (Reference reference : this.population) {
                dst.population.add(reference.copy());
            }
        }
        dst.undesirableEffect = this.undesirableEffect == null ? null : this.undesirableEffect.copy();
        dst.warning = this.warning == null ? null : this.warning.copy();
    }

    protected ClinicalUseDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ClinicalUseDefinition)) {
            return false;
        }
        ClinicalUseDefinition o = (ClinicalUseDefinition)other_;
        return ClinicalUseDefinition.compareDeep(this.identifier, o.identifier, true) && ClinicalUseDefinition.compareDeep(this.type, o.type, true) && ClinicalUseDefinition.compareDeep(this.category, o.category, true) && ClinicalUseDefinition.compareDeep(this.subject, o.subject, true) && ClinicalUseDefinition.compareDeep(this.status, o.status, true) && ClinicalUseDefinition.compareDeep(this.contraindication, o.contraindication, true) && ClinicalUseDefinition.compareDeep(this.indication, o.indication, true) && ClinicalUseDefinition.compareDeep(this.interaction, o.interaction, true) && ClinicalUseDefinition.compareDeep(this.population, o.population, true) && ClinicalUseDefinition.compareDeep(this.undesirableEffect, o.undesirableEffect, true) && ClinicalUseDefinition.compareDeep(this.warning, o.warning, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ClinicalUseDefinition)) {
            return false;
        }
        ClinicalUseDefinition o = (ClinicalUseDefinition)other_;
        return ClinicalUseDefinition.compareValues(this.type, o.type, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.category, this.subject, this.status, this.contraindication, this.indication, this.interaction, this.population, this.undesirableEffect, this.warning});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClinicalUseDefinition;
    }

    @Block
    public static class ClinicalUseDefinitionWarningComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A textual definition of this warning, with formatting", formalDefinition="A textual definition of this warning, with formatting.")
        protected MarkdownType description;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A coded or unformatted textual definition of this warning", formalDefinition="A coded or unformatted textual definition of this warning.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/warning-type")
        protected CodeableConcept code;
        private static final long serialVersionUID = 213710553L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionWarningComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ClinicalUseDefinitionWarningComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ClinicalUseDefinitionWarningComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionWarningComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ClinicalUseDefinitionWarningComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "A textual definition of this warning, with formatting.", 0, 1, this.description));
            children.add(new Property("code", "CodeableConcept", "A coded or unformatted textual definition of this warning.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "A textual definition of this warning, with formatting.", 0, 1, this.description);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A coded or unformatted textual definition of this warning.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("code")) {
                this.code = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClinicalUseDefinition.warning.description");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionWarningComponent copy() {
            ClinicalUseDefinitionWarningComponent dst = new ClinicalUseDefinitionWarningComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionWarningComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionWarningComponent)) {
                return false;
            }
            ClinicalUseDefinitionWarningComponent o = (ClinicalUseDefinitionWarningComponent)other_;
            return ClinicalUseDefinitionWarningComponent.compareDeep(this.description, o.description, true) && ClinicalUseDefinitionWarningComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionWarningComponent)) {
                return false;
            }
            ClinicalUseDefinitionWarningComponent o = (ClinicalUseDefinitionWarningComponent)other_;
            return ClinicalUseDefinitionWarningComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.code});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.warning";
        }
    }

    @Block
    public static class ClinicalUseDefinitionUndesirableEffectComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="symptomConditionEffect", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The situation in which the undesirable effect may manifest", formalDefinition="The situation in which the undesirable effect may manifest.")
        protected CodeableReference symptomConditionEffect;
        @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="High level classification of the effect", formalDefinition="High level classification of the effect.")
        protected CodeableConcept classification;
        @Child(name="frequencyOfOccurrence", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How often the effect is seen", formalDefinition="How often the effect is seen.")
        protected CodeableConcept frequencyOfOccurrence;
        private static final long serialVersionUID = -55472609L;

        public CodeableReference getSymptomConditionEffect() {
            if (this.symptomConditionEffect == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionUndesirableEffectComponent.symptomConditionEffect");
                }
                if (Configuration.doAutoCreate()) {
                    this.symptomConditionEffect = new CodeableReference();
                }
            }
            return this.symptomConditionEffect;
        }

        public boolean hasSymptomConditionEffect() {
            return this.symptomConditionEffect != null && !this.symptomConditionEffect.isEmpty();
        }

        public ClinicalUseDefinitionUndesirableEffectComponent setSymptomConditionEffect(CodeableReference value) {
            this.symptomConditionEffect = value;
            return this;
        }

        public CodeableConcept getClassification() {
            if (this.classification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionUndesirableEffectComponent.classification");
                }
                if (Configuration.doAutoCreate()) {
                    this.classification = new CodeableConcept();
                }
            }
            return this.classification;
        }

        public boolean hasClassification() {
            return this.classification != null && !this.classification.isEmpty();
        }

        public ClinicalUseDefinitionUndesirableEffectComponent setClassification(CodeableConcept value) {
            this.classification = value;
            return this;
        }

        public CodeableConcept getFrequencyOfOccurrence() {
            if (this.frequencyOfOccurrence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionUndesirableEffectComponent.frequencyOfOccurrence");
                }
                if (Configuration.doAutoCreate()) {
                    this.frequencyOfOccurrence = new CodeableConcept();
                }
            }
            return this.frequencyOfOccurrence;
        }

        public boolean hasFrequencyOfOccurrence() {
            return this.frequencyOfOccurrence != null && !this.frequencyOfOccurrence.isEmpty();
        }

        public ClinicalUseDefinitionUndesirableEffectComponent setFrequencyOfOccurrence(CodeableConcept value) {
            this.frequencyOfOccurrence = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("symptomConditionEffect", "CodeableReference(ObservationDefinition)", "The situation in which the undesirable effect may manifest.", 0, 1, this.symptomConditionEffect));
            children.add(new Property("classification", "CodeableConcept", "High level classification of the effect.", 0, 1, this.classification));
            children.add(new Property("frequencyOfOccurrence", "CodeableConcept", "How often the effect is seen.", 0, 1, this.frequencyOfOccurrence));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -650549981: {
                    return new Property("symptomConditionEffect", "CodeableReference(ObservationDefinition)", "The situation in which the undesirable effect may manifest.", 0, 1, this.symptomConditionEffect);
                }
                case 382350310: {
                    return new Property("classification", "CodeableConcept", "High level classification of the effect.", 0, 1, this.classification);
                }
                case 791175812: {
                    return new Property("frequencyOfOccurrence", "CodeableConcept", "How often the effect is seen.", 0, 1, this.frequencyOfOccurrence);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    Base[] baseArray;
                    if (this.symptomConditionEffect == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.symptomConditionEffect;
                    }
                    return baseArray;
                }
                case 382350310: {
                    Base[] baseArray;
                    if (this.classification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.classification;
                    }
                    return baseArray;
                }
                case 791175812: {
                    Base[] baseArray;
                    if (this.frequencyOfOccurrence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.frequencyOfOccurrence;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    this.symptomConditionEffect = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 382350310: {
                    this.classification = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 791175812: {
                    this.frequencyOfOccurrence = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("symptomConditionEffect")) {
                this.symptomConditionEffect = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("classification")) {
                this.classification = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("frequencyOfOccurrence")) {
                this.frequencyOfOccurrence = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("symptomConditionEffect")) {
                this.symptomConditionEffect = null;
            } else if (name.equals("classification")) {
                this.classification = null;
            } else if (name.equals("frequencyOfOccurrence")) {
                this.frequencyOfOccurrence = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    return this.getSymptomConditionEffect();
                }
                case 382350310: {
                    return this.getClassification();
                }
                case 791175812: {
                    return this.getFrequencyOfOccurrence();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    return new String[]{"CodeableReference"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
                case 791175812: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("symptomConditionEffect")) {
                this.symptomConditionEffect = new CodeableReference();
                return this.symptomConditionEffect;
            }
            if (name.equals("classification")) {
                this.classification = new CodeableConcept();
                return this.classification;
            }
            if (name.equals("frequencyOfOccurrence")) {
                this.frequencyOfOccurrence = new CodeableConcept();
                return this.frequencyOfOccurrence;
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionUndesirableEffectComponent copy() {
            ClinicalUseDefinitionUndesirableEffectComponent dst = new ClinicalUseDefinitionUndesirableEffectComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionUndesirableEffectComponent dst) {
            super.copyValues(dst);
            dst.symptomConditionEffect = this.symptomConditionEffect == null ? null : this.symptomConditionEffect.copy();
            dst.classification = this.classification == null ? null : this.classification.copy();
            dst.frequencyOfOccurrence = this.frequencyOfOccurrence == null ? null : this.frequencyOfOccurrence.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionUndesirableEffectComponent)) {
                return false;
            }
            ClinicalUseDefinitionUndesirableEffectComponent o = (ClinicalUseDefinitionUndesirableEffectComponent)other_;
            return ClinicalUseDefinitionUndesirableEffectComponent.compareDeep(this.symptomConditionEffect, o.symptomConditionEffect, true) && ClinicalUseDefinitionUndesirableEffectComponent.compareDeep(this.classification, o.classification, true) && ClinicalUseDefinitionUndesirableEffectComponent.compareDeep(this.frequencyOfOccurrence, o.frequencyOfOccurrence, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionUndesirableEffectComponent)) {
                return false;
            }
            ClinicalUseDefinitionUndesirableEffectComponent o = (ClinicalUseDefinitionUndesirableEffectComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.symptomConditionEffect, this.classification, this.frequencyOfOccurrence});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.undesirableEffect";
        }
    }

    @Block
    public static class ClinicalUseDefinitionInteractionInteractantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={MedicinalProductDefinition.class, Medication.class, Substance.class, ObservationDefinition.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific medication, food or laboratory test that interacts", formalDefinition="The specific medication, food or laboratory test that interacts.")
        protected DataType item;
        private static final long serialVersionUID = 1847936859L;

        public ClinicalUseDefinitionInteractionInteractantComponent() {
        }

        public ClinicalUseDefinitionInteractionInteractantComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public ClinicalUseDefinitionInteractionInteractantComponent setItem(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for ClinicalUseDefinition.interaction.interactant.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "Reference(MedicinalProductDefinition|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "Reference(MedicinalProductDefinition|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "Reference(MedicinalProductDefinition|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(MedicinalProductDefinition|Medication|Substance|ObservationDefinition)", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("item[x]")) {
                return super.setProperty(name, value);
            }
            this.item = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionInteractionInteractantComponent copy() {
            ClinicalUseDefinitionInteractionInteractantComponent dst = new ClinicalUseDefinitionInteractionInteractantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionInteractionInteractantComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionInteractionInteractantComponent)) {
                return false;
            }
            ClinicalUseDefinitionInteractionInteractantComponent o = (ClinicalUseDefinitionInteractionInteractantComponent)other_;
            return ClinicalUseDefinitionInteractionInteractantComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionInteractionInteractantComponent)) {
                return false;
            }
            ClinicalUseDefinitionInteractionInteractantComponent o = (ClinicalUseDefinitionInteractionInteractantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.interaction.interactant";
        }
    }

    @Block
    public static class ClinicalUseDefinitionInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="interactant", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The specific medication, food, substance or laboratory test that interacts", formalDefinition="The specific medication, food, substance or laboratory test that interacts.")
        protected List<ClinicalUseDefinitionInteractionInteractantComponent> interactant;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction", formalDefinition="The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.")
        protected CodeableConcept type;
        @Child(name="effect", type={CodeableReference.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The effect of the interaction, for example \"reduced gastric absorption of primary medication\"", formalDefinition="The effect of the interaction, for example \"reduced gastric absorption of primary medication\".")
        protected CodeableReference effect;
        @Child(name="incidence", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The incidence of the interaction, e.g. theoretical, observed", formalDefinition="The incidence of the interaction, e.g. theoretical, observed.")
        protected CodeableConcept incidence;
        @Child(name="management", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Actions for managing the interaction", formalDefinition="Actions for managing the interaction.")
        protected List<CodeableConcept> management;
        private static final long serialVersionUID = 2072955553L;

        public List<ClinicalUseDefinitionInteractionInteractantComponent> getInteractant() {
            if (this.interactant == null) {
                this.interactant = new ArrayList<ClinicalUseDefinitionInteractionInteractantComponent>();
            }
            return this.interactant;
        }

        public ClinicalUseDefinitionInteractionComponent setInteractant(List<ClinicalUseDefinitionInteractionInteractantComponent> theInteractant) {
            this.interactant = theInteractant;
            return this;
        }

        public boolean hasInteractant() {
            if (this.interactant == null) {
                return false;
            }
            for (ClinicalUseDefinitionInteractionInteractantComponent item : this.interactant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ClinicalUseDefinitionInteractionInteractantComponent addInteractant() {
            ClinicalUseDefinitionInteractionInteractantComponent t = new ClinicalUseDefinitionInteractionInteractantComponent();
            if (this.interactant == null) {
                this.interactant = new ArrayList<ClinicalUseDefinitionInteractionInteractantComponent>();
            }
            this.interactant.add(t);
            return t;
        }

        public ClinicalUseDefinitionInteractionComponent addInteractant(ClinicalUseDefinitionInteractionInteractantComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interactant == null) {
                this.interactant = new ArrayList<ClinicalUseDefinitionInteractionInteractantComponent>();
            }
            this.interactant.add(t);
            return this;
        }

        public ClinicalUseDefinitionInteractionInteractantComponent getInteractantFirstRep() {
            if (this.getInteractant().isEmpty()) {
                this.addInteractant();
            }
            return this.getInteractant().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionInteractionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ClinicalUseDefinitionInteractionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableReference getEffect() {
            if (this.effect == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionInteractionComponent.effect");
                }
                if (Configuration.doAutoCreate()) {
                    this.effect = new CodeableReference();
                }
            }
            return this.effect;
        }

        public boolean hasEffect() {
            return this.effect != null && !this.effect.isEmpty();
        }

        public ClinicalUseDefinitionInteractionComponent setEffect(CodeableReference value) {
            this.effect = value;
            return this;
        }

        public CodeableConcept getIncidence() {
            if (this.incidence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionInteractionComponent.incidence");
                }
                if (Configuration.doAutoCreate()) {
                    this.incidence = new CodeableConcept();
                }
            }
            return this.incidence;
        }

        public boolean hasIncidence() {
            return this.incidence != null && !this.incidence.isEmpty();
        }

        public ClinicalUseDefinitionInteractionComponent setIncidence(CodeableConcept value) {
            this.incidence = value;
            return this;
        }

        public List<CodeableConcept> getManagement() {
            if (this.management == null) {
                this.management = new ArrayList<CodeableConcept>();
            }
            return this.management;
        }

        public ClinicalUseDefinitionInteractionComponent setManagement(List<CodeableConcept> theManagement) {
            this.management = theManagement;
            return this;
        }

        public boolean hasManagement() {
            if (this.management == null) {
                return false;
            }
            for (CodeableConcept item : this.management) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addManagement() {
            CodeableConcept t = new CodeableConcept();
            if (this.management == null) {
                this.management = new ArrayList<CodeableConcept>();
            }
            this.management.add(t);
            return t;
        }

        public ClinicalUseDefinitionInteractionComponent addManagement(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.management == null) {
                this.management = new ArrayList<CodeableConcept>();
            }
            this.management.add(t);
            return this;
        }

        public CodeableConcept getManagementFirstRep() {
            if (this.getManagement().isEmpty()) {
                this.addManagement();
            }
            return this.getManagement().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("interactant", "", "The specific medication, food, substance or laboratory test that interacts.", 0, Integer.MAX_VALUE, this.interactant));
            children.add(new Property(ClinicalUseDefinition.SP_TYPE, "CodeableConcept", "The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.", 0, 1, this.type));
            children.add(new Property(ClinicalUseDefinition.SP_EFFECT, "CodeableReference(ObservationDefinition)", "The effect of the interaction, for example \"reduced gastric absorption of primary medication\".", 0, 1, this.effect));
            children.add(new Property("incidence", "CodeableConcept", "The incidence of the interaction, e.g. theoretical, observed.", 0, 1, this.incidence));
            children.add(new Property("management", "CodeableConcept", "Actions for managing the interaction.", 0, Integer.MAX_VALUE, this.management));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1844097009: {
                    return new Property("interactant", "", "The specific medication, food, substance or laboratory test that interacts.", 0, Integer.MAX_VALUE, this.interactant);
                }
                case 3575610: {
                    return new Property(ClinicalUseDefinition.SP_TYPE, "CodeableConcept", "The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.", 0, 1, this.type);
                }
                case -1306084975: {
                    return new Property(ClinicalUseDefinition.SP_EFFECT, "CodeableReference(ObservationDefinition)", "The effect of the interaction, for example \"reduced gastric absorption of primary medication\".", 0, 1, this.effect);
                }
                case -1598467132: {
                    return new Property("incidence", "CodeableConcept", "The incidence of the interaction, e.g. theoretical, observed.", 0, 1, this.incidence);
                }
                case -1799980989: {
                    return new Property("management", "CodeableConcept", "Actions for managing the interaction.", 0, Integer.MAX_VALUE, this.management);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    return this.interactant == null ? new Base[]{} : this.interactant.toArray(new Base[this.interactant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1306084975: {
                    Base[] baseArray;
                    if (this.effect == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.effect;
                    }
                    return baseArray;
                }
                case -1598467132: {
                    Base[] baseArray;
                    if (this.incidence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.incidence;
                    }
                    return baseArray;
                }
                case -1799980989: {
                    return this.management == null ? new Base[]{} : this.management.toArray(new Base[this.management.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    this.getInteractant().add((ClinicalUseDefinitionInteractionInteractantComponent)value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1306084975: {
                    this.effect = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1598467132: {
                    this.incidence = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1799980989: {
                    this.getManagement().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("interactant")) {
                this.getInteractant().add((ClinicalUseDefinitionInteractionInteractantComponent)value);
            } else if (name.equals(ClinicalUseDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(ClinicalUseDefinition.SP_EFFECT)) {
                this.effect = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("incidence")) {
                this.incidence = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("management")) {
                this.getManagement().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("interactant")) {
                this.getInteractant().remove((ClinicalUseDefinitionInteractionInteractantComponent)value);
            } else if (name.equals(ClinicalUseDefinition.SP_TYPE)) {
                this.type = null;
            } else if (name.equals(ClinicalUseDefinition.SP_EFFECT)) {
                this.effect = null;
            } else if (name.equals("incidence")) {
                this.incidence = null;
            } else if (name.equals("management")) {
                this.getManagement().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    return this.addInteractant();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1306084975: {
                    return this.getEffect();
                }
                case -1598467132: {
                    return this.getIncidence();
                }
                case -1799980989: {
                    return this.addManagement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    return new String[0];
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1306084975: {
                    return new String[]{"CodeableReference"};
                }
                case -1598467132: {
                    return new String[]{"CodeableConcept"};
                }
                case -1799980989: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("interactant")) {
                return this.addInteractant();
            }
            if (name.equals(ClinicalUseDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(ClinicalUseDefinition.SP_EFFECT)) {
                this.effect = new CodeableReference();
                return this.effect;
            }
            if (name.equals("incidence")) {
                this.incidence = new CodeableConcept();
                return this.incidence;
            }
            if (name.equals("management")) {
                return this.addManagement();
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionInteractionComponent copy() {
            ClinicalUseDefinitionInteractionComponent dst = new ClinicalUseDefinitionInteractionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionInteractionComponent dst) {
            super.copyValues(dst);
            if (this.interactant != null) {
                dst.interactant = new ArrayList<ClinicalUseDefinitionInteractionInteractantComponent>();
                for (ClinicalUseDefinitionInteractionInteractantComponent clinicalUseDefinitionInteractionInteractantComponent : this.interactant) {
                    dst.interactant.add(clinicalUseDefinitionInteractionInteractantComponent.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.effect = this.effect == null ? null : this.effect.copy();
            CodeableConcept codeableConcept = dst.incidence = this.incidence == null ? null : this.incidence.copy();
            if (this.management != null) {
                dst.management = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.management) {
                    dst.management.add(codeableConcept2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionInteractionComponent)) {
                return false;
            }
            ClinicalUseDefinitionInteractionComponent o = (ClinicalUseDefinitionInteractionComponent)other_;
            return ClinicalUseDefinitionInteractionComponent.compareDeep(this.interactant, o.interactant, true) && ClinicalUseDefinitionInteractionComponent.compareDeep(this.type, o.type, true) && ClinicalUseDefinitionInteractionComponent.compareDeep(this.effect, o.effect, true) && ClinicalUseDefinitionInteractionComponent.compareDeep(this.incidence, o.incidence, true) && ClinicalUseDefinitionInteractionComponent.compareDeep(this.management, o.management, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionInteractionComponent)) {
                return false;
            }
            ClinicalUseDefinitionInteractionComponent o = (ClinicalUseDefinitionInteractionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.interactant, this.type, this.effect, this.incidence, this.management});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.interaction";
        }
    }

    @Block
    public static class ClinicalUseDefinitionIndicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="diseaseSymptomProcedure", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The situation that is being documented as an indicaton for this item", formalDefinition="The situation that is being documented as an indicaton for this item.")
        protected CodeableReference diseaseSymptomProcedure;
        @Child(name="diseaseStatus", type={CodeableReference.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the disease or symptom for the indication", formalDefinition="The status of the disease or symptom for the indication.")
        protected CodeableReference diseaseStatus;
        @Child(name="comorbidity", type={CodeableReference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A comorbidity (concurrent condition) or coinfection as part of the indication", formalDefinition="A comorbidity (concurrent condition) or coinfection as part of the indication.")
        protected List<CodeableReference> comorbidity;
        @Child(name="intendedEffect", type={CodeableReference.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The intended effect, aim or strategy to be achieved", formalDefinition="The intended effect, aim or strategy to be achieved.")
        protected CodeableReference intendedEffect;
        @Child(name="duration", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timing or duration information", formalDefinition="Timing or duration information.")
        protected Quantity duration;
        @Child(name="undesirableEffect", type={ClinicalUseDefinition.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The specific undesirable effects of the medicinal product", formalDefinition="The specific undesirable effects of the medicinal product.")
        protected List<Reference> undesirableEffect;
        @Child(name="otherTherapy", type={ClinicalUseDefinitionContraindicationOtherTherapyComponent.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication.")
        protected List<ClinicalUseDefinitionContraindicationOtherTherapyComponent> otherTherapy;
        private static final long serialVersionUID = 1882904823L;

        public CodeableReference getDiseaseSymptomProcedure() {
            if (this.diseaseSymptomProcedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionIndicationComponent.diseaseSymptomProcedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseSymptomProcedure = new CodeableReference();
                }
            }
            return this.diseaseSymptomProcedure;
        }

        public boolean hasDiseaseSymptomProcedure() {
            return this.diseaseSymptomProcedure != null && !this.diseaseSymptomProcedure.isEmpty();
        }

        public ClinicalUseDefinitionIndicationComponent setDiseaseSymptomProcedure(CodeableReference value) {
            this.diseaseSymptomProcedure = value;
            return this;
        }

        public CodeableReference getDiseaseStatus() {
            if (this.diseaseStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionIndicationComponent.diseaseStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseStatus = new CodeableReference();
                }
            }
            return this.diseaseStatus;
        }

        public boolean hasDiseaseStatus() {
            return this.diseaseStatus != null && !this.diseaseStatus.isEmpty();
        }

        public ClinicalUseDefinitionIndicationComponent setDiseaseStatus(CodeableReference value) {
            this.diseaseStatus = value;
            return this;
        }

        public List<CodeableReference> getComorbidity() {
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableReference>();
            }
            return this.comorbidity;
        }

        public ClinicalUseDefinitionIndicationComponent setComorbidity(List<CodeableReference> theComorbidity) {
            this.comorbidity = theComorbidity;
            return this;
        }

        public boolean hasComorbidity() {
            if (this.comorbidity == null) {
                return false;
            }
            for (CodeableReference item : this.comorbidity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addComorbidity() {
            CodeableReference t = new CodeableReference();
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableReference>();
            }
            this.comorbidity.add(t);
            return t;
        }

        public ClinicalUseDefinitionIndicationComponent addComorbidity(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableReference>();
            }
            this.comorbidity.add(t);
            return this;
        }

        public CodeableReference getComorbidityFirstRep() {
            if (this.getComorbidity().isEmpty()) {
                this.addComorbidity();
            }
            return this.getComorbidity().get(0);
        }

        public CodeableReference getIntendedEffect() {
            if (this.intendedEffect == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionIndicationComponent.intendedEffect");
                }
                if (Configuration.doAutoCreate()) {
                    this.intendedEffect = new CodeableReference();
                }
            }
            return this.intendedEffect;
        }

        public boolean hasIntendedEffect() {
            return this.intendedEffect != null && !this.intendedEffect.isEmpty();
        }

        public ClinicalUseDefinitionIndicationComponent setIntendedEffect(CodeableReference value) {
            this.intendedEffect = value;
            return this;
        }

        public Quantity getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionIndicationComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Quantity();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public ClinicalUseDefinitionIndicationComponent setDuration(Quantity value) {
            this.duration = value;
            return this;
        }

        public List<Reference> getUndesirableEffect() {
            if (this.undesirableEffect == null) {
                this.undesirableEffect = new ArrayList<Reference>();
            }
            return this.undesirableEffect;
        }

        public ClinicalUseDefinitionIndicationComponent setUndesirableEffect(List<Reference> theUndesirableEffect) {
            this.undesirableEffect = theUndesirableEffect;
            return this;
        }

        public boolean hasUndesirableEffect() {
            if (this.undesirableEffect == null) {
                return false;
            }
            for (Reference item : this.undesirableEffect) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUndesirableEffect() {
            Reference t = new Reference();
            if (this.undesirableEffect == null) {
                this.undesirableEffect = new ArrayList<Reference>();
            }
            this.undesirableEffect.add(t);
            return t;
        }

        public ClinicalUseDefinitionIndicationComponent addUndesirableEffect(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.undesirableEffect == null) {
                this.undesirableEffect = new ArrayList<Reference>();
            }
            this.undesirableEffect.add(t);
            return this;
        }

        public Reference getUndesirableEffectFirstRep() {
            if (this.getUndesirableEffect().isEmpty()) {
                this.addUndesirableEffect();
            }
            return this.getUndesirableEffect().get(0);
        }

        public List<ClinicalUseDefinitionContraindicationOtherTherapyComponent> getOtherTherapy() {
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
            }
            return this.otherTherapy;
        }

        public ClinicalUseDefinitionIndicationComponent setOtherTherapy(List<ClinicalUseDefinitionContraindicationOtherTherapyComponent> theOtherTherapy) {
            this.otherTherapy = theOtherTherapy;
            return this;
        }

        public boolean hasOtherTherapy() {
            if (this.otherTherapy == null) {
                return false;
            }
            for (ClinicalUseDefinitionContraindicationOtherTherapyComponent item : this.otherTherapy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent addOtherTherapy() {
            ClinicalUseDefinitionContraindicationOtherTherapyComponent t = new ClinicalUseDefinitionContraindicationOtherTherapyComponent();
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return t;
        }

        public ClinicalUseDefinitionIndicationComponent addOtherTherapy(ClinicalUseDefinitionContraindicationOtherTherapyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return this;
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent getOtherTherapyFirstRep() {
            if (this.getOtherTherapy().isEmpty()) {
                this.addOtherTherapy();
            }
            return this.getOtherTherapy().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("diseaseSymptomProcedure", "CodeableReference(ObservationDefinition)", "The situation that is being documented as an indicaton for this item.", 0, 1, this.diseaseSymptomProcedure));
            children.add(new Property("diseaseStatus", "CodeableReference(ObservationDefinition)", "The status of the disease or symptom for the indication.", 0, 1, this.diseaseStatus));
            children.add(new Property("comorbidity", "CodeableReference(ObservationDefinition)", "A comorbidity (concurrent condition) or coinfection as part of the indication.", 0, Integer.MAX_VALUE, this.comorbidity));
            children.add(new Property("intendedEffect", "CodeableReference(ObservationDefinition)", "The intended effect, aim or strategy to be achieved.", 0, 1, this.intendedEffect));
            children.add(new Property("duration", "Quantity", "Timing or duration information.", 0, 1, this.duration));
            children.add(new Property("undesirableEffect", "Reference(ClinicalUseDefinition)", "The specific undesirable effects of the medicinal product.", 0, Integer.MAX_VALUE, this.undesirableEffect));
            children.add(new Property("otherTherapy", "@ClinicalUseDefinition.contraindication.otherTherapy", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1497395130: {
                    return new Property("diseaseSymptomProcedure", "CodeableReference(ObservationDefinition)", "The situation that is being documented as an indicaton for this item.", 0, 1, this.diseaseSymptomProcedure);
                }
                case -505503602: {
                    return new Property("diseaseStatus", "CodeableReference(ObservationDefinition)", "The status of the disease or symptom for the indication.", 0, 1, this.diseaseStatus);
                }
                case -406395211: {
                    return new Property("comorbidity", "CodeableReference(ObservationDefinition)", "A comorbidity (concurrent condition) or coinfection as part of the indication.", 0, Integer.MAX_VALUE, this.comorbidity);
                }
                case 1587112348: {
                    return new Property("intendedEffect", "CodeableReference(ObservationDefinition)", "The intended effect, aim or strategy to be achieved.", 0, 1, this.intendedEffect);
                }
                case -1992012396: {
                    return new Property("duration", "Quantity", "Timing or duration information.", 0, 1, this.duration);
                }
                case 444367565: {
                    return new Property("undesirableEffect", "Reference(ClinicalUseDefinition)", "The specific undesirable effects of the medicinal product.", 0, Integer.MAX_VALUE, this.undesirableEffect);
                }
                case -544509127: {
                    return new Property("otherTherapy", "@ClinicalUseDefinition.contraindication.otherTherapy", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    Base[] baseArray;
                    if (this.diseaseSymptomProcedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.diseaseSymptomProcedure;
                    }
                    return baseArray;
                }
                case -505503602: {
                    Base[] baseArray;
                    if (this.diseaseStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diseaseStatus;
                    }
                    return baseArray;
                }
                case -406395211: {
                    return this.comorbidity == null ? new Base[]{} : this.comorbidity.toArray(new Base[this.comorbidity.size()]);
                }
                case 1587112348: {
                    Base[] baseArray;
                    if (this.intendedEffect == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.intendedEffect;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
                case 444367565: {
                    return this.undesirableEffect == null ? new Base[]{} : this.undesirableEffect.toArray(new Base[this.undesirableEffect.size()]);
                }
                case -544509127: {
                    return this.otherTherapy == null ? new Base[]{} : this.otherTherapy.toArray(new Base[this.otherTherapy.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    this.diseaseSymptomProcedure = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -505503602: {
                    this.diseaseStatus = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -406395211: {
                    this.getComorbidity().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 1587112348: {
                    this.intendedEffect = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 444367565: {
                    this.getUndesirableEffect().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -544509127: {
                    this.getOtherTherapy().add((ClinicalUseDefinitionContraindicationOtherTherapyComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("diseaseStatus")) {
                this.diseaseStatus = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("comorbidity")) {
                this.getComorbidity().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("intendedEffect")) {
                this.intendedEffect = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("duration")) {
                this.duration = TypeConvertor.castToQuantity(value);
            } else if (name.equals("undesirableEffect")) {
                this.getUndesirableEffect().add(TypeConvertor.castToReference(value));
            } else if (name.equals("otherTherapy")) {
                this.getOtherTherapy().add((ClinicalUseDefinitionContraindicationOtherTherapyComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = null;
            } else if (name.equals("diseaseStatus")) {
                this.diseaseStatus = null;
            } else if (name.equals("comorbidity")) {
                this.getComorbidity().remove(value);
            } else if (name.equals("intendedEffect")) {
                this.intendedEffect = null;
            } else if (name.equals("duration")) {
                this.duration = null;
            } else if (name.equals("undesirableEffect")) {
                this.getUndesirableEffect().remove(value);
            } else if (name.equals("otherTherapy")) {
                this.getOtherTherapy().remove((ClinicalUseDefinitionContraindicationOtherTherapyComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    return this.getDiseaseSymptomProcedure();
                }
                case -505503602: {
                    return this.getDiseaseStatus();
                }
                case -406395211: {
                    return this.addComorbidity();
                }
                case 1587112348: {
                    return this.getIntendedEffect();
                }
                case -1992012396: {
                    return this.getDuration();
                }
                case 444367565: {
                    return this.addUndesirableEffect();
                }
                case -544509127: {
                    return this.addOtherTherapy();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    return new String[]{"CodeableReference"};
                }
                case -505503602: {
                    return new String[]{"CodeableReference"};
                }
                case -406395211: {
                    return new String[]{"CodeableReference"};
                }
                case 1587112348: {
                    return new String[]{"CodeableReference"};
                }
                case -1992012396: {
                    return new String[]{"Quantity"};
                }
                case 444367565: {
                    return new String[]{"Reference"};
                }
                case -544509127: {
                    return new String[]{"@ClinicalUseDefinition.contraindication.otherTherapy"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = new CodeableReference();
                return this.diseaseSymptomProcedure;
            }
            if (name.equals("diseaseStatus")) {
                this.diseaseStatus = new CodeableReference();
                return this.diseaseStatus;
            }
            if (name.equals("comorbidity")) {
                return this.addComorbidity();
            }
            if (name.equals("intendedEffect")) {
                this.intendedEffect = new CodeableReference();
                return this.intendedEffect;
            }
            if (name.equals("duration")) {
                this.duration = new Quantity();
                return this.duration;
            }
            if (name.equals("undesirableEffect")) {
                return this.addUndesirableEffect();
            }
            if (name.equals("otherTherapy")) {
                return this.addOtherTherapy();
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionIndicationComponent copy() {
            ClinicalUseDefinitionIndicationComponent dst = new ClinicalUseDefinitionIndicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionIndicationComponent dst) {
            super.copyValues(dst);
            dst.diseaseSymptomProcedure = this.diseaseSymptomProcedure == null ? null : this.diseaseSymptomProcedure.copy();
            CodeableReference codeableReference = dst.diseaseStatus = this.diseaseStatus == null ? null : this.diseaseStatus.copy();
            if (this.comorbidity != null) {
                dst.comorbidity = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference2 : this.comorbidity) {
                    dst.comorbidity.add(codeableReference2.copy());
                }
            }
            dst.intendedEffect = this.intendedEffect == null ? null : this.intendedEffect.copy();
            Quantity quantity = dst.duration = this.duration == null ? null : this.duration.copy();
            if (this.undesirableEffect != null) {
                dst.undesirableEffect = new ArrayList<Reference>();
                for (Reference reference : this.undesirableEffect) {
                    dst.undesirableEffect.add(reference.copy());
                }
            }
            if (this.otherTherapy != null) {
                dst.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
                for (ClinicalUseDefinitionContraindicationOtherTherapyComponent clinicalUseDefinitionContraindicationOtherTherapyComponent : this.otherTherapy) {
                    dst.otherTherapy.add(clinicalUseDefinitionContraindicationOtherTherapyComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionIndicationComponent)) {
                return false;
            }
            ClinicalUseDefinitionIndicationComponent o = (ClinicalUseDefinitionIndicationComponent)other_;
            return ClinicalUseDefinitionIndicationComponent.compareDeep(this.diseaseSymptomProcedure, o.diseaseSymptomProcedure, true) && ClinicalUseDefinitionIndicationComponent.compareDeep(this.diseaseStatus, o.diseaseStatus, true) && ClinicalUseDefinitionIndicationComponent.compareDeep(this.comorbidity, o.comorbidity, true) && ClinicalUseDefinitionIndicationComponent.compareDeep(this.intendedEffect, o.intendedEffect, true) && ClinicalUseDefinitionIndicationComponent.compareDeep(this.duration, o.duration, true) && ClinicalUseDefinitionIndicationComponent.compareDeep(this.undesirableEffect, o.undesirableEffect, true) && ClinicalUseDefinitionIndicationComponent.compareDeep(this.otherTherapy, o.otherTherapy, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionIndicationComponent)) {
                return false;
            }
            ClinicalUseDefinitionIndicationComponent o = (ClinicalUseDefinitionIndicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.intendedEffect, this.duration, this.undesirableEffect, this.otherTherapy});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.indication";
        }
    }

    @Block
    public static class ClinicalUseDefinitionContraindicationOtherTherapyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationshipType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy", formalDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy.")
        protected CodeableConcept relationshipType;
        @Child(name="therapy", type={CodeableReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication", formalDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.")
        protected CodeableReference therapy;
        private static final long serialVersionUID = -363440718L;

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent() {
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent(CodeableConcept relationshipType, CodeableReference therapy) {
            this.setRelationshipType(relationshipType);
            this.setTherapy(therapy);
        }

        public CodeableConcept getRelationshipType() {
            if (this.relationshipType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionContraindicationOtherTherapyComponent.relationshipType");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationshipType = new CodeableConcept();
                }
            }
            return this.relationshipType;
        }

        public boolean hasRelationshipType() {
            return this.relationshipType != null && !this.relationshipType.isEmpty();
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent setRelationshipType(CodeableConcept value) {
            this.relationshipType = value;
            return this;
        }

        public CodeableReference getTherapy() {
            if (this.therapy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionContraindicationOtherTherapyComponent.therapy");
                }
                if (Configuration.doAutoCreate()) {
                    this.therapy = new CodeableReference();
                }
            }
            return this.therapy;
        }

        public boolean hasTherapy() {
            return this.therapy != null && !this.therapy.isEmpty();
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent setTherapy(CodeableReference value) {
            this.therapy = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.relationshipType));
            children.add(new Property("therapy", "CodeableReference(MedicinalProductDefinition|Medication|Substance|SubstanceDefinition|ActivityDefinition)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.therapy));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1602839150: {
                    return new Property("relationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.relationshipType);
                }
                case -1349555095: {
                    return new Property("therapy", "CodeableReference(MedicinalProductDefinition|Medication|Substance|SubstanceDefinition|ActivityDefinition)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.therapy);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    Base[] baseArray;
                    if (this.relationshipType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationshipType;
                    }
                    return baseArray;
                }
                case -1349555095: {
                    Base[] baseArray;
                    if (this.therapy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.therapy;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    this.relationshipType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1349555095: {
                    this.therapy = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("therapy")) {
                this.therapy = TypeConvertor.castToCodeableReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = null;
            } else if (name.equals("therapy")) {
                this.therapy = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    return this.getRelationshipType();
                }
                case -1349555095: {
                    return this.getTherapy();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    return new String[]{"CodeableConcept"};
                }
                case -1349555095: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = new CodeableConcept();
                return this.relationshipType;
            }
            if (name.equals("therapy")) {
                this.therapy = new CodeableReference();
                return this.therapy;
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionContraindicationOtherTherapyComponent copy() {
            ClinicalUseDefinitionContraindicationOtherTherapyComponent dst = new ClinicalUseDefinitionContraindicationOtherTherapyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionContraindicationOtherTherapyComponent dst) {
            super.copyValues(dst);
            dst.relationshipType = this.relationshipType == null ? null : this.relationshipType.copy();
            dst.therapy = this.therapy == null ? null : this.therapy.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionContraindicationOtherTherapyComponent)) {
                return false;
            }
            ClinicalUseDefinitionContraindicationOtherTherapyComponent o = (ClinicalUseDefinitionContraindicationOtherTherapyComponent)other_;
            return ClinicalUseDefinitionContraindicationOtherTherapyComponent.compareDeep(this.relationshipType, o.relationshipType, true) && ClinicalUseDefinitionContraindicationOtherTherapyComponent.compareDeep(this.therapy, o.therapy, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionContraindicationOtherTherapyComponent)) {
                return false;
            }
            ClinicalUseDefinitionContraindicationOtherTherapyComponent o = (ClinicalUseDefinitionContraindicationOtherTherapyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relationshipType, this.therapy});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.contraindication.otherTherapy";
        }
    }

    @Block
    public static class ClinicalUseDefinitionContraindicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="diseaseSymptomProcedure", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The situation that is being documented as contraindicating against this item", formalDefinition="The situation that is being documented as contraindicating against this item.")
        protected CodeableReference diseaseSymptomProcedure;
        @Child(name="diseaseStatus", type={CodeableReference.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the disease or symptom for the contraindication", formalDefinition="The status of the disease or symptom for the contraindication.")
        protected CodeableReference diseaseStatus;
        @Child(name="comorbidity", type={CodeableReference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A comorbidity (concurrent condition) or coinfection", formalDefinition="A comorbidity (concurrent condition) or coinfection.")
        protected List<CodeableReference> comorbidity;
        @Child(name="indication", type={ClinicalUseDefinition.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The indication which this is a contraidication for", formalDefinition="The indication which this is a contraidication for.")
        protected List<Reference> indication;
        @Child(name="otherTherapy", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the contraindication", formalDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the contraindication.")
        protected List<ClinicalUseDefinitionContraindicationOtherTherapyComponent> otherTherapy;
        private static final long serialVersionUID = 832395863L;

        public CodeableReference getDiseaseSymptomProcedure() {
            if (this.diseaseSymptomProcedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionContraindicationComponent.diseaseSymptomProcedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseSymptomProcedure = new CodeableReference();
                }
            }
            return this.diseaseSymptomProcedure;
        }

        public boolean hasDiseaseSymptomProcedure() {
            return this.diseaseSymptomProcedure != null && !this.diseaseSymptomProcedure.isEmpty();
        }

        public ClinicalUseDefinitionContraindicationComponent setDiseaseSymptomProcedure(CodeableReference value) {
            this.diseaseSymptomProcedure = value;
            return this;
        }

        public CodeableReference getDiseaseStatus() {
            if (this.diseaseStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalUseDefinitionContraindicationComponent.diseaseStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseStatus = new CodeableReference();
                }
            }
            return this.diseaseStatus;
        }

        public boolean hasDiseaseStatus() {
            return this.diseaseStatus != null && !this.diseaseStatus.isEmpty();
        }

        public ClinicalUseDefinitionContraindicationComponent setDiseaseStatus(CodeableReference value) {
            this.diseaseStatus = value;
            return this;
        }

        public List<CodeableReference> getComorbidity() {
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableReference>();
            }
            return this.comorbidity;
        }

        public ClinicalUseDefinitionContraindicationComponent setComorbidity(List<CodeableReference> theComorbidity) {
            this.comorbidity = theComorbidity;
            return this;
        }

        public boolean hasComorbidity() {
            if (this.comorbidity == null) {
                return false;
            }
            for (CodeableReference item : this.comorbidity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addComorbidity() {
            CodeableReference t = new CodeableReference();
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableReference>();
            }
            this.comorbidity.add(t);
            return t;
        }

        public ClinicalUseDefinitionContraindicationComponent addComorbidity(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableReference>();
            }
            this.comorbidity.add(t);
            return this;
        }

        public CodeableReference getComorbidityFirstRep() {
            if (this.getComorbidity().isEmpty()) {
                this.addComorbidity();
            }
            return this.getComorbidity().get(0);
        }

        public List<Reference> getIndication() {
            if (this.indication == null) {
                this.indication = new ArrayList<Reference>();
            }
            return this.indication;
        }

        public ClinicalUseDefinitionContraindicationComponent setIndication(List<Reference> theIndication) {
            this.indication = theIndication;
            return this;
        }

        public boolean hasIndication() {
            if (this.indication == null) {
                return false;
            }
            for (Reference item : this.indication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addIndication() {
            Reference t = new Reference();
            if (this.indication == null) {
                this.indication = new ArrayList<Reference>();
            }
            this.indication.add(t);
            return t;
        }

        public ClinicalUseDefinitionContraindicationComponent addIndication(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.indication == null) {
                this.indication = new ArrayList<Reference>();
            }
            this.indication.add(t);
            return this;
        }

        public Reference getIndicationFirstRep() {
            if (this.getIndication().isEmpty()) {
                this.addIndication();
            }
            return this.getIndication().get(0);
        }

        public List<ClinicalUseDefinitionContraindicationOtherTherapyComponent> getOtherTherapy() {
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
            }
            return this.otherTherapy;
        }

        public ClinicalUseDefinitionContraindicationComponent setOtherTherapy(List<ClinicalUseDefinitionContraindicationOtherTherapyComponent> theOtherTherapy) {
            this.otherTherapy = theOtherTherapy;
            return this;
        }

        public boolean hasOtherTherapy() {
            if (this.otherTherapy == null) {
                return false;
            }
            for (ClinicalUseDefinitionContraindicationOtherTherapyComponent item : this.otherTherapy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent addOtherTherapy() {
            ClinicalUseDefinitionContraindicationOtherTherapyComponent t = new ClinicalUseDefinitionContraindicationOtherTherapyComponent();
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return t;
        }

        public ClinicalUseDefinitionContraindicationComponent addOtherTherapy(ClinicalUseDefinitionContraindicationOtherTherapyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return this;
        }

        public ClinicalUseDefinitionContraindicationOtherTherapyComponent getOtherTherapyFirstRep() {
            if (this.getOtherTherapy().isEmpty()) {
                this.addOtherTherapy();
            }
            return this.getOtherTherapy().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("diseaseSymptomProcedure", "CodeableReference(ObservationDefinition)", "The situation that is being documented as contraindicating against this item.", 0, 1, this.diseaseSymptomProcedure));
            children.add(new Property("diseaseStatus", "CodeableReference(ObservationDefinition)", "The status of the disease or symptom for the contraindication.", 0, 1, this.diseaseStatus));
            children.add(new Property("comorbidity", "CodeableReference(ObservationDefinition)", "A comorbidity (concurrent condition) or coinfection.", 0, Integer.MAX_VALUE, this.comorbidity));
            children.add(new Property(ClinicalUseDefinition.SP_INDICATION, "Reference(ClinicalUseDefinition)", "The indication which this is a contraidication for.", 0, Integer.MAX_VALUE, this.indication));
            children.add(new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the contraindication.", 0, Integer.MAX_VALUE, this.otherTherapy));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1497395130: {
                    return new Property("diseaseSymptomProcedure", "CodeableReference(ObservationDefinition)", "The situation that is being documented as contraindicating against this item.", 0, 1, this.diseaseSymptomProcedure);
                }
                case -505503602: {
                    return new Property("diseaseStatus", "CodeableReference(ObservationDefinition)", "The status of the disease or symptom for the contraindication.", 0, 1, this.diseaseStatus);
                }
                case -406395211: {
                    return new Property("comorbidity", "CodeableReference(ObservationDefinition)", "A comorbidity (concurrent condition) or coinfection.", 0, Integer.MAX_VALUE, this.comorbidity);
                }
                case -597168804: {
                    return new Property(ClinicalUseDefinition.SP_INDICATION, "Reference(ClinicalUseDefinition)", "The indication which this is a contraidication for.", 0, Integer.MAX_VALUE, this.indication);
                }
                case -544509127: {
                    return new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the contraindication.", 0, Integer.MAX_VALUE, this.otherTherapy);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    Base[] baseArray;
                    if (this.diseaseSymptomProcedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.diseaseSymptomProcedure;
                    }
                    return baseArray;
                }
                case -505503602: {
                    Base[] baseArray;
                    if (this.diseaseStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diseaseStatus;
                    }
                    return baseArray;
                }
                case -406395211: {
                    return this.comorbidity == null ? new Base[]{} : this.comorbidity.toArray(new Base[this.comorbidity.size()]);
                }
                case -597168804: {
                    return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
                }
                case -544509127: {
                    return this.otherTherapy == null ? new Base[]{} : this.otherTherapy.toArray(new Base[this.otherTherapy.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    this.diseaseSymptomProcedure = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -505503602: {
                    this.diseaseStatus = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -406395211: {
                    this.getComorbidity().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -597168804: {
                    this.getIndication().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -544509127: {
                    this.getOtherTherapy().add((ClinicalUseDefinitionContraindicationOtherTherapyComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("diseaseStatus")) {
                this.diseaseStatus = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("comorbidity")) {
                this.getComorbidity().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals(ClinicalUseDefinition.SP_INDICATION)) {
                this.getIndication().add(TypeConvertor.castToReference(value));
            } else if (name.equals("otherTherapy")) {
                this.getOtherTherapy().add((ClinicalUseDefinitionContraindicationOtherTherapyComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = null;
            } else if (name.equals("diseaseStatus")) {
                this.diseaseStatus = null;
            } else if (name.equals("comorbidity")) {
                this.getComorbidity().remove(value);
            } else if (name.equals(ClinicalUseDefinition.SP_INDICATION)) {
                this.getIndication().remove(value);
            } else if (name.equals("otherTherapy")) {
                this.getOtherTherapy().remove((ClinicalUseDefinitionContraindicationOtherTherapyComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    return this.getDiseaseSymptomProcedure();
                }
                case -505503602: {
                    return this.getDiseaseStatus();
                }
                case -406395211: {
                    return this.addComorbidity();
                }
                case -597168804: {
                    return this.addIndication();
                }
                case -544509127: {
                    return this.addOtherTherapy();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    return new String[]{"CodeableReference"};
                }
                case -505503602: {
                    return new String[]{"CodeableReference"};
                }
                case -406395211: {
                    return new String[]{"CodeableReference"};
                }
                case -597168804: {
                    return new String[]{"Reference"};
                }
                case -544509127: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = new CodeableReference();
                return this.diseaseSymptomProcedure;
            }
            if (name.equals("diseaseStatus")) {
                this.diseaseStatus = new CodeableReference();
                return this.diseaseStatus;
            }
            if (name.equals("comorbidity")) {
                return this.addComorbidity();
            }
            if (name.equals(ClinicalUseDefinition.SP_INDICATION)) {
                return this.addIndication();
            }
            if (name.equals("otherTherapy")) {
                return this.addOtherTherapy();
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalUseDefinitionContraindicationComponent copy() {
            ClinicalUseDefinitionContraindicationComponent dst = new ClinicalUseDefinitionContraindicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalUseDefinitionContraindicationComponent dst) {
            super.copyValues(dst);
            dst.diseaseSymptomProcedure = this.diseaseSymptomProcedure == null ? null : this.diseaseSymptomProcedure.copy();
            CodeableReference codeableReference = dst.diseaseStatus = this.diseaseStatus == null ? null : this.diseaseStatus.copy();
            if (this.comorbidity != null) {
                dst.comorbidity = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference2 : this.comorbidity) {
                    dst.comorbidity.add(codeableReference2.copy());
                }
            }
            if (this.indication != null) {
                dst.indication = new ArrayList<Reference>();
                for (Reference reference : this.indication) {
                    dst.indication.add(reference.copy());
                }
            }
            if (this.otherTherapy != null) {
                dst.otherTherapy = new ArrayList<ClinicalUseDefinitionContraindicationOtherTherapyComponent>();
                for (ClinicalUseDefinitionContraindicationOtherTherapyComponent clinicalUseDefinitionContraindicationOtherTherapyComponent : this.otherTherapy) {
                    dst.otherTherapy.add(clinicalUseDefinitionContraindicationOtherTherapyComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionContraindicationComponent)) {
                return false;
            }
            ClinicalUseDefinitionContraindicationComponent o = (ClinicalUseDefinitionContraindicationComponent)other_;
            return ClinicalUseDefinitionContraindicationComponent.compareDeep(this.diseaseSymptomProcedure, o.diseaseSymptomProcedure, true) && ClinicalUseDefinitionContraindicationComponent.compareDeep(this.diseaseStatus, o.diseaseStatus, true) && ClinicalUseDefinitionContraindicationComponent.compareDeep(this.comorbidity, o.comorbidity, true) && ClinicalUseDefinitionContraindicationComponent.compareDeep(this.indication, o.indication, true) && ClinicalUseDefinitionContraindicationComponent.compareDeep(this.otherTherapy, o.otherTherapy, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalUseDefinitionContraindicationComponent)) {
                return false;
            }
            ClinicalUseDefinitionContraindicationComponent o = (ClinicalUseDefinitionContraindicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.indication, this.otherTherapy});
        }

        @Override
        public String fhirType() {
            return "ClinicalUseDefinition.contraindication";
        }
    }

    public static class ClinicalUseIssueTypeEnumFactory
    implements EnumFactory<ClinicalUseIssueType> {
        @Override
        public ClinicalUseIssueType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (ClinicalUseDefinition.SP_INDICATION.equals(codeString)) {
                return ClinicalUseIssueType.INDICATION;
            }
            if (ClinicalUseDefinition.SP_CONTRAINDICATION.equals(codeString)) {
                return ClinicalUseIssueType.CONTRAINDICATION;
            }
            if (ClinicalUseDefinition.SP_INTERACTION.equals(codeString)) {
                return ClinicalUseIssueType.INTERACTION;
            }
            if ("undesirable-effect".equals(codeString)) {
                return ClinicalUseIssueType.UNDESIRABLEEFFECT;
            }
            if ("warning".equals(codeString)) {
                return ClinicalUseIssueType.WARNING;
            }
            throw new IllegalArgumentException("Unknown ClinicalUseIssueType code '" + codeString + "'");
        }

        public Enumeration<ClinicalUseIssueType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.NULL, code);
            }
            if (ClinicalUseDefinition.SP_INDICATION.equals(codeString)) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.INDICATION, code);
            }
            if (ClinicalUseDefinition.SP_CONTRAINDICATION.equals(codeString)) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.CONTRAINDICATION, code);
            }
            if (ClinicalUseDefinition.SP_INTERACTION.equals(codeString)) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.INTERACTION, code);
            }
            if ("undesirable-effect".equals(codeString)) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.UNDESIRABLEEFFECT, code);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<ClinicalUseIssueType>(this, ClinicalUseIssueType.WARNING, code);
            }
            throw new FHIRException("Unknown ClinicalUseIssueType code '" + codeString + "'");
        }

        @Override
        public String toCode(ClinicalUseIssueType code) {
            if (code == ClinicalUseIssueType.NULL) {
                return null;
            }
            if (code == ClinicalUseIssueType.INDICATION) {
                return ClinicalUseDefinition.SP_INDICATION;
            }
            if (code == ClinicalUseIssueType.CONTRAINDICATION) {
                return ClinicalUseDefinition.SP_CONTRAINDICATION;
            }
            if (code == ClinicalUseIssueType.INTERACTION) {
                return ClinicalUseDefinition.SP_INTERACTION;
            }
            if (code == ClinicalUseIssueType.UNDESIRABLEEFFECT) {
                return "undesirable-effect";
            }
            if (code == ClinicalUseIssueType.WARNING) {
                return "warning";
            }
            return "?";
        }

        @Override
        public String toSystem(ClinicalUseIssueType code) {
            return code.getSystem();
        }
    }

    public static enum ClinicalUseIssueType {
        INDICATION,
        CONTRAINDICATION,
        INTERACTION,
        UNDESIRABLEEFFECT,
        WARNING,
        NULL;


        public static ClinicalUseIssueType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (ClinicalUseDefinition.SP_INDICATION.equals(codeString)) {
                return INDICATION;
            }
            if (ClinicalUseDefinition.SP_CONTRAINDICATION.equals(codeString)) {
                return CONTRAINDICATION;
            }
            if (ClinicalUseDefinition.SP_INTERACTION.equals(codeString)) {
                return INTERACTION;
            }
            if ("undesirable-effect".equals(codeString)) {
                return UNDESIRABLEEFFECT;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ClinicalUseIssueType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INDICATION: {
                    return ClinicalUseDefinition.SP_INDICATION;
                }
                case CONTRAINDICATION: {
                    return ClinicalUseDefinition.SP_CONTRAINDICATION;
                }
                case INTERACTION: {
                    return ClinicalUseDefinition.SP_INTERACTION;
                }
                case UNDESIRABLEEFFECT: {
                    return "undesirable-effect";
                }
                case WARNING: {
                    return "warning";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INDICATION: {
                    return "http://hl7.org/fhir/clinical-use-issue-type";
                }
                case CONTRAINDICATION: {
                    return "http://hl7.org/fhir/clinical-use-issue-type";
                }
                case INTERACTION: {
                    return "http://hl7.org/fhir/clinical-use-issue-type";
                }
                case UNDESIRABLEEFFECT: {
                    return "http://hl7.org/fhir/clinical-use-issue-type";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/clinical-use-issue-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INDICATION: {
                    return "A reason for giving the medicaton.";
                }
                case CONTRAINDICATION: {
                    return "A reason for not giving the medicaition.";
                }
                case INTERACTION: {
                    return "Interactions between the medication and other substances.";
                }
                case UNDESIRABLEEFFECT: {
                    return "Side effects or adverse effects associated with the medication.";
                }
                case WARNING: {
                    return "A general warning or issue that is not specifically one of the other types.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INDICATION: {
                    return "Indication";
                }
                case CONTRAINDICATION: {
                    return "Contraindication";
                }
                case INTERACTION: {
                    return "Interaction";
                }
                case UNDESIRABLEEFFECT: {
                    return "Undesirable Effect";
                }
                case WARNING: {
                    return "Warning";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

