/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Dosage;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;

@ResourceDef(name="MedicationDispense", profile="http://hl7.org/fhir/StructureDefinition/MedicationDispense")
public class MedicationDispense
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="Identifiers associated with this Medication Dispense that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="partOf", type={Procedure.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Event that dispense is part of", formalDefinition="The procedure that trigger the dispense.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | cancelled | on-hold | completed | entered-in-error | stopped | declined | unknown", formalDefinition="A code specifying the state of the set of dispense events.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-status")
    protected Enumeration<MedicationDispenseStatusCodes> status;
    @Child(name="statusReason", type={CodeableConcept.class, DetectedIssue.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why a dispense was not performed", formalDefinition="Indicates the reason why a dispense was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-status-reason")
    protected DataType statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of medication dispense", formalDefinition="Indicates the type of medication dispense (for example, where the medication is expected to be consumed or administered (i.e. inpatient or outpatient)).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-category")
    protected CodeableConcept category;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What medication was supplied", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected DataType medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the dispense is for", formalDefinition="A link to a resource representing the person or the group to whom the medication will be given.")
    protected Reference subject;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter / Episode associated with event", formalDefinition="The encounter or episode of care that establishes the context for this event.")
    protected Reference context;
    @Child(name="supportingInformation", type={Reference.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information that supports the dispensing of the medication", formalDefinition="Additional information that supports the medication being dispensed.")
    protected List<Reference> supportingInformation;
    @Child(name="performer", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who performed event", formalDefinition="Indicates who or what performed the event.")
    protected List<MedicationDispensePerformerComponent> performer;
    @Child(name="location", type={Location.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the dispense occurred", formalDefinition="The principal physical location where the dispense was performed.")
    protected Reference location;
    @Child(name="authorizingPrescription", type={MedicationRequest.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Medication order that authorizes the dispense", formalDefinition="Indicates the medication order that is being dispensed against.")
    protected List<Reference> authorizingPrescription;
    @Child(name="type", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Trial fill, partial fill, emergency fill, etc.", formalDefinition="Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType")
    protected CodeableConcept type;
    @Child(name="quantity", type={Quantity.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of medication that has been dispensed. Includes unit of measure.")
    protected Quantity quantity;
    @Child(name="daysSupply", type={Quantity.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount of medication expressed as a timing amount", formalDefinition="The amount of medication expressed as a timing amount.")
    protected Quantity daysSupply;
    @Child(name="whenPrepared", type={DateTimeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When product was packaged and reviewed", formalDefinition="The time when the dispensed product was packaged and reviewed.")
    protected DateTimeType whenPrepared;
    @Child(name="whenHandedOver", type={DateTimeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When product was given out", formalDefinition="The time the dispensed product was provided to the patient or their representative.")
    protected DateTimeType whenHandedOver;
    @Child(name="destination", type={Location.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the medication was sent", formalDefinition="Identification of the facility/location where the medication was shipped to, as part of the dispense event.")
    protected Reference destination;
    @Child(name="receiver", type={Patient.class, Practitioner.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who collected the medication", formalDefinition="Identifies the person who picked up the medication.  This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.")
    protected List<Reference> receiver;
    @Child(name="note", type={Annotation.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the dispense", formalDefinition="Extra information about the dispense that could not be conveyed in the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosageInstruction", type={Dosage.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="How the medication is to be used by the patient or administered by the caregiver", formalDefinition="Indicates how the medication is to be used by the patient.")
    protected List<Dosage> dosageInstruction;
    @Child(name="substitution", type={}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether a substitution was performed on the dispense", formalDefinition="Indicates whether or not substitution was made as part of the dispense.  In some cases, substitution will be expected but does not happen, in other cases substitution is not expected but does happen.  This block explains what substitution did or did not happen and why.  If nothing is specified, substitution was not done.")
    protected MedicationDispenseSubstitutionComponent substitution;
    @Child(name="detectedIssue", type={DetectedIssue.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical issue with action", formalDefinition="Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. drug-drug interaction, duplicate therapy, dosage alert etc.")
    protected List<Reference> detectedIssue;
    @Child(name="eventHistory", type={Provenance.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of relevant lifecycle events", formalDefinition="A summary of the events of interest that have occurred, such as when the dispense was verified.")
    protected List<Reference> eventHistory;
    private static final long serialVersionUID = -1830053160L;
    @SearchParamDefinition(name="context", path="MedicationDispense.context", description="Returns dispenses with a specific context (episode or episode of care)", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("MedicationDispense:context").toLocked();
    @SearchParamDefinition(name="destination", path="MedicationDispense.destination", description="Returns dispenses that should be sent to a specific destination", type="reference", target={Location.class})
    public static final String SP_DESTINATION = "destination";
    public static final ReferenceClientParam DESTINATION = new ReferenceClientParam("destination");
    public static final Include INCLUDE_DESTINATION = new Include("MedicationDispense:destination").toLocked();
    @SearchParamDefinition(name="performer", path="MedicationDispense.performer.actor", description="Returns dispenses performed by a specific individual", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("MedicationDispense:performer").toLocked();
    @SearchParamDefinition(name="receiver", path="MedicationDispense.receiver", description="The identity of a receiver to list dispenses for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Patient.class, Practitioner.class})
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_RECEIVER = new Include("MedicationDispense:receiver").toLocked();
    @SearchParamDefinition(name="responsibleparty", path="MedicationDispense.substitution.responsibleParty", description="Returns dispenses with the specified responsible party", type="reference", target={Practitioner.class, PractitionerRole.class})
    public static final String SP_RESPONSIBLEPARTY = "responsibleparty";
    public static final ReferenceClientParam RESPONSIBLEPARTY = new ReferenceClientParam("responsibleparty");
    public static final Include INCLUDE_RESPONSIBLEPARTY = new Include("MedicationDispense:responsibleparty").toLocked();
    @SearchParamDefinition(name="subject", path="MedicationDispense.subject", description="The identity of a patient for whom to list dispenses", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationDispense:subject").toLocked();
    @SearchParamDefinition(name="type", path="MedicationDispense.type", description="Returns dispenses of a specific type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="whenhandedover", path="MedicationDispense.whenHandedOver", description="Returns dispenses handed over on this date", type="date")
    public static final String SP_WHENHANDEDOVER = "whenhandedover";
    public static final DateClientParam WHENHANDEDOVER = new DateClientParam("whenhandedover");
    @SearchParamDefinition(name="whenprepared", path="MedicationDispense.whenPrepared", description="Returns dispenses prepared on this date", type="date")
    public static final String SP_WHENPREPARED = "whenprepared";
    public static final DateClientParam WHENPREPARED = new DateClientParam("whenprepared");
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | (DeviceRequest.code as CodeableConcept) | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | (MedicationAdministration.medication as CodeableConcept) | (MedicationDispense.medication as CodeableConcept) | (MedicationRequest.medication as CodeableConcept) | (MedicationStatement.medication as CodeableConcept) | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.masterIdentifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Master Version Specific Identifier\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.patient | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject.where(resolve() is Patient) | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationDispense:patient").toLocked();
    @SearchParamDefinition(name="medication", path="(MedicationAdministration.medication as Reference) | (MedicationDispense.medication as Reference) | (MedicationRequest.medication as Reference) | (MedicationStatement.medication as Reference)", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication resource\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine resource\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions for this medication reference\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication reference\r\n", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationDispense:medication").toLocked();
    @SearchParamDefinition(name="prescription", path="MedicationDispense.authorizingPrescription", description="Multiple Resources: \r\n\r\n* [MedicationDispense](medicationdispense.html): The identity of a prescription to list dispenses from\r\n", type="reference", target={MedicationRequest.class})
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    public static final Include INCLUDE_PRESCRIPTION = new Include("MedicationDispense:prescription").toLocked();
    @SearchParamDefinition(name="status", path="MedicationAdministration.status | MedicationDispense.status | MedicationRequest.status | MedicationStatement.status", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): MedicationAdministration event status (for example one of active/paused/completed/nullified)\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specified dispense status\r\n* [MedicationRequest](medicationrequest.html): Status of the prescription\r\n* [MedicationStatement](medicationstatement.html): Return statements that match the given status\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationDispense() {
    }

    public MedicationDispense(MedicationDispenseStatusCodes status, DataType medication) {
        this.setStatus(status);
        this.setMedication(medication);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationDispense setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationDispense addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public MedicationDispense setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public MedicationDispense addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<MedicationDispenseStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationDispenseStatusCodes>(new MedicationDispenseStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationDispense setStatusElement(Enumeration<MedicationDispenseStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationDispenseStatusCodes getStatus() {
        return this.status == null ? null : (MedicationDispenseStatusCodes)((Object)this.status.getValue());
    }

    public MedicationDispense setStatus(MedicationDispenseStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationDispenseStatusCodes>(new MedicationDispenseStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DataType getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getStatusReasonCodeableConcept() throws FHIRException {
        if (this.statusReason == null) {
            this.statusReason = new CodeableConcept();
        }
        if (!(this.statusReason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.statusReason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.statusReason;
    }

    public boolean hasStatusReasonCodeableConcept() {
        return this != null && this.statusReason instanceof CodeableConcept;
    }

    public Reference getStatusReasonReference() throws FHIRException {
        if (this.statusReason == null) {
            this.statusReason = new Reference();
        }
        if (!(this.statusReason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.statusReason.getClass().getName() + " was encountered");
        }
        return (Reference)this.statusReason;
    }

    public boolean hasStatusReasonReference() {
        return this != null && this.statusReason instanceof Reference;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public MedicationDispense setStatusReason(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for MedicationDispense.statusReason[x]: " + value.fhirType());
        }
        this.statusReason = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public MedicationDispense setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public DataType getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (this.medication == null) {
            this.medication = new CodeableConcept();
        }
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this != null && this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (this.medication == null) {
            this.medication = new Reference();
        }
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this != null && this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationDispense setMedication(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for MedicationDispense.medication[x]: " + value.fhirType());
        }
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationDispense setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public MedicationDispense setContext(Reference value) {
        this.context = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public MedicationDispense setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationDispense addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public List<MedicationDispensePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationDispensePerformerComponent>();
        }
        return this.performer;
    }

    public MedicationDispense setPerformer(List<MedicationDispensePerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (MedicationDispensePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationDispensePerformerComponent addPerformer() {
        MedicationDispensePerformerComponent t = new MedicationDispensePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationDispensePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public MedicationDispense addPerformer(MedicationDispensePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationDispensePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public MedicationDispensePerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public MedicationDispense setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<Reference> getAuthorizingPrescription() {
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        return this.authorizingPrescription;
    }

    public MedicationDispense setAuthorizingPrescription(List<Reference> theAuthorizingPrescription) {
        this.authorizingPrescription = theAuthorizingPrescription;
        return this;
    }

    public boolean hasAuthorizingPrescription() {
        if (this.authorizingPrescription == null) {
            return false;
        }
        for (Reference item : this.authorizingPrescription) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthorizingPrescription() {
        Reference t = new Reference();
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        this.authorizingPrescription.add(t);
        return t;
    }

    public MedicationDispense addAuthorizingPrescription(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        this.authorizingPrescription.add(t);
        return this;
    }

    public Reference getAuthorizingPrescriptionFirstRep() {
        if (this.getAuthorizingPrescription().isEmpty()) {
            this.addAuthorizingPrescription();
        }
        return this.getAuthorizingPrescription().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicationDispense setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public MedicationDispense setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public Quantity getDaysSupply() {
        if (this.daysSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.daysSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.daysSupply = new Quantity();
            }
        }
        return this.daysSupply;
    }

    public boolean hasDaysSupply() {
        return this.daysSupply != null && !this.daysSupply.isEmpty();
    }

    public MedicationDispense setDaysSupply(Quantity value) {
        this.daysSupply = value;
        return this;
    }

    public DateTimeType getWhenPreparedElement() {
        if (this.whenPrepared == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.whenPrepared");
            }
            if (Configuration.doAutoCreate()) {
                this.whenPrepared = new DateTimeType();
            }
        }
        return this.whenPrepared;
    }

    public boolean hasWhenPreparedElement() {
        return this.whenPrepared != null && !this.whenPrepared.isEmpty();
    }

    public boolean hasWhenPrepared() {
        return this.whenPrepared != null && !this.whenPrepared.isEmpty();
    }

    public MedicationDispense setWhenPreparedElement(DateTimeType value) {
        this.whenPrepared = value;
        return this;
    }

    public Date getWhenPrepared() {
        return this.whenPrepared == null ? null : (Date)this.whenPrepared.getValue();
    }

    public MedicationDispense setWhenPrepared(Date value) {
        if (value == null) {
            this.whenPrepared = null;
        } else {
            if (this.whenPrepared == null) {
                this.whenPrepared = new DateTimeType();
            }
            this.whenPrepared.setValue(value);
        }
        return this;
    }

    public DateTimeType getWhenHandedOverElement() {
        if (this.whenHandedOver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.whenHandedOver");
            }
            if (Configuration.doAutoCreate()) {
                this.whenHandedOver = new DateTimeType();
            }
        }
        return this.whenHandedOver;
    }

    public boolean hasWhenHandedOverElement() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public boolean hasWhenHandedOver() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public MedicationDispense setWhenHandedOverElement(DateTimeType value) {
        this.whenHandedOver = value;
        return this;
    }

    public Date getWhenHandedOver() {
        return this.whenHandedOver == null ? null : (Date)this.whenHandedOver.getValue();
    }

    public MedicationDispense setWhenHandedOver(Date value) {
        if (value == null) {
            this.whenHandedOver = null;
        } else {
            if (this.whenHandedOver == null) {
                this.whenHandedOver = new DateTimeType();
            }
            this.whenHandedOver.setValue(value);
        }
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public MedicationDispense setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public MedicationDispense setReceiver(List<Reference> theReceiver) {
        this.receiver = theReceiver;
        return this;
    }

    public boolean hasReceiver() {
        if (this.receiver == null) {
            return false;
        }
        for (Reference item : this.receiver) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReceiver() {
        Reference t = new Reference();
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return t;
    }

    public MedicationDispense addReceiver(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return this;
    }

    public Reference getReceiverFirstRep() {
        if (this.getReceiver().isEmpty()) {
            this.addReceiver();
        }
        return this.getReceiver().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationDispense setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationDispense addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Dosage> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        return this.dosageInstruction;
    }

    public MedicationDispense setDosageInstruction(List<Dosage> theDosageInstruction) {
        this.dosageInstruction = theDosageInstruction;
        return this;
    }

    public boolean hasDosageInstruction() {
        if (this.dosageInstruction == null) {
            return false;
        }
        for (Dosage item : this.dosageInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosageInstruction() {
        Dosage t = new Dosage();
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        this.dosageInstruction.add(t);
        return t;
    }

    public MedicationDispense addDosageInstruction(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        this.dosageInstruction.add(t);
        return this;
    }

    public Dosage getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            this.addDosageInstruction();
        }
        return this.getDosageInstruction().get(0);
    }

    public MedicationDispenseSubstitutionComponent getSubstitution() {
        if (this.substitution == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.substitution");
            }
            if (Configuration.doAutoCreate()) {
                this.substitution = new MedicationDispenseSubstitutionComponent();
            }
        }
        return this.substitution;
    }

    public boolean hasSubstitution() {
        return this.substitution != null && !this.substitution.isEmpty();
    }

    public MedicationDispense setSubstitution(MedicationDispenseSubstitutionComponent value) {
        this.substitution = value;
        return this;
    }

    public List<Reference> getDetectedIssue() {
        if (this.detectedIssue == null) {
            this.detectedIssue = new ArrayList<Reference>();
        }
        return this.detectedIssue;
    }

    public MedicationDispense setDetectedIssue(List<Reference> theDetectedIssue) {
        this.detectedIssue = theDetectedIssue;
        return this;
    }

    public boolean hasDetectedIssue() {
        if (this.detectedIssue == null) {
            return false;
        }
        for (Reference item : this.detectedIssue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDetectedIssue() {
        Reference t = new Reference();
        if (this.detectedIssue == null) {
            this.detectedIssue = new ArrayList<Reference>();
        }
        this.detectedIssue.add(t);
        return t;
    }

    public MedicationDispense addDetectedIssue(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.detectedIssue == null) {
            this.detectedIssue = new ArrayList<Reference>();
        }
        this.detectedIssue.add(t);
        return this;
    }

    public Reference getDetectedIssueFirstRep() {
        if (this.getDetectedIssue().isEmpty()) {
            this.addDetectedIssue();
        }
        return this.getDetectedIssue().get(0);
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public MedicationDispense setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public MedicationDispense addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Dispense that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("partOf", "Reference(Procedure)", "The procedure that trigger the dispense.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the state of the set of dispense events.", 0, 1, this.status));
        children.add(new Property("statusReason[x]", "CodeableConcept|Reference(DetectedIssue)", "Indicates the reason why a dispense was not performed.", 0, 1, this.statusReason));
        children.add(new Property("category", "CodeableConcept", "Indicates the type of medication dispense (for example, where the medication is expected to be consumed or administered (i.e. inpatient or outpatient)).", 0, 1, this.category));
        children.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "A link to a resource representing the person or the group to whom the medication will be given.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this event.", 0, 1, this.context));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information that supports the medication being dispensed.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property(SP_PERFORMER, "", "Indicates who or what performed the event.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("location", "Reference(Location)", "The principal physical location where the dispense was performed.", 0, 1, this.location));
        children.add(new Property("authorizingPrescription", "Reference(MedicationRequest)", "Indicates the medication order that is being dispensed against.", 0, Integer.MAX_VALUE, this.authorizingPrescription));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, 1, this.type));
        children.add(new Property("quantity", "Quantity", "The amount of medication that has been dispensed. Includes unit of measure.", 0, 1, this.quantity));
        children.add(new Property("daysSupply", "Quantity", "The amount of medication expressed as a timing amount.", 0, 1, this.daysSupply));
        children.add(new Property("whenPrepared", "dateTime", "The time when the dispensed product was packaged and reviewed.", 0, 1, this.whenPrepared));
        children.add(new Property("whenHandedOver", "dateTime", "The time the dispensed product was provided to the patient or their representative.", 0, 1, this.whenHandedOver));
        children.add(new Property(SP_DESTINATION, "Reference(Location)", "Identification of the facility/location where the medication was shipped to, as part of the dispense event.", 0, 1, this.destination));
        children.add(new Property(SP_RECEIVER, "Reference(Patient|Practitioner)", "Identifies the person who picked up the medication.  This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.", 0, Integer.MAX_VALUE, this.receiver));
        children.add(new Property("note", "Annotation", "Extra information about the dispense that could not be conveyed in the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("dosageInstruction", "Dosage", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction));
        children.add(new Property("substitution", "", "Indicates whether or not substitution was made as part of the dispense.  In some cases, substitution will be expected but does not happen, in other cases substitution is not expected but does happen.  This block explains what substitution did or did not happen and why.  If nothing is specified, substitution was not done.", 0, 1, this.substitution));
        children.add(new Property("detectedIssue", "Reference(DetectedIssue)", "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. drug-drug interaction, duplicate therapy, dosage alert etc.", 0, Integer.MAX_VALUE, this.detectedIssue));
        children.add(new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the dispense was verified.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Dispense that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Procedure)", "The procedure that trigger the dispense.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the state of the set of dispense events.", 0, 1, this.status);
            }
            case -1421632534: {
                return new Property("statusReason[x]", "CodeableConcept|Reference(DetectedIssue)", "Indicates the reason why a dispense was not performed.", 0, 1, this.statusReason);
            }
            case 2051346646: {
                return new Property("statusReason[x]", "CodeableConcept|Reference(DetectedIssue)", "Indicates the reason why a dispense was not performed.", 0, 1, this.statusReason);
            }
            case 2082934763: {
                return new Property("statusReason[x]", "CodeableConcept", "Indicates the reason why a dispense was not performed.", 0, 1, this.statusReason);
            }
            case 1344200469: {
                return new Property("statusReason[x]", "Reference(DetectedIssue)", "Indicates the reason why a dispense was not performed.", 0, 1, this.statusReason);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Indicates the type of medication dispense (for example, where the medication is expected to be consumed or administered (i.e. inpatient or outpatient)).", 0, 1, this.category);
            }
            case 1458402129: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 1998965455: {
                return new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -209845038: {
                return new Property("medication[x]", "CodeableConcept", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case 2104315196: {
                return new Property("medication[x]", "Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "A link to a resource representing the person or the group to whom the medication will be given.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this event.", 0, 1, this.context);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information that supports the medication being dispensed.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Indicates who or what performed the event.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "The principal physical location where the dispense was performed.", 0, 1, this.location);
            }
            case -1237557856: {
                return new Property("authorizingPrescription", "Reference(MedicationRequest)", "Indicates the medication order that is being dispensed against.", 0, Integer.MAX_VALUE, this.authorizingPrescription);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, 1, this.type);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The amount of medication that has been dispensed. Includes unit of measure.", 0, 1, this.quantity);
            }
            case 197175334: {
                return new Property("daysSupply", "Quantity", "The amount of medication expressed as a timing amount.", 0, 1, this.daysSupply);
            }
            case -562837097: {
                return new Property("whenPrepared", "dateTime", "The time when the dispensed product was packaged and reviewed.", 0, 1, this.whenPrepared);
            }
            case -940241380: {
                return new Property("whenHandedOver", "dateTime", "The time the dispensed product was provided to the patient or their representative.", 0, 1, this.whenHandedOver);
            }
            case -1429847026: {
                return new Property(SP_DESTINATION, "Reference(Location)", "Identification of the facility/location where the medication was shipped to, as part of the dispense event.", 0, 1, this.destination);
            }
            case -808719889: {
                return new Property(SP_RECEIVER, "Reference(Patient|Practitioner)", "Identifies the person who picked up the medication.  This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.", 0, Integer.MAX_VALUE, this.receiver);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the dispense that could not be conveyed in the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1201373865: {
                return new Property("dosageInstruction", "Dosage", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction);
            }
            case 826147581: {
                return new Property("substitution", "", "Indicates whether or not substitution was made as part of the dispense.  In some cases, substitution will be expected but does not happen, in other cases substitution is not expected but does happen.  This block explains what substitution did or did not happen and why.  If nothing is specified, substitution was not done.", 0, 1, this.substitution);
            }
            case 51602295: {
                return new Property("detectedIssue", "Reference(DetectedIssue)", "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. drug-drug interaction, duplicate therapy, dosage alert etc.", 0, Integer.MAX_VALUE, this.detectedIssue);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the dispense was verified.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statusReason;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.context;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.location;
                }
                return baseArray;
            }
            case -1237557856: {
                return this.authorizingPrescription == null ? new Base[]{} : this.authorizingPrescription.toArray(new Base[this.authorizingPrescription.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.type;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.quantity;
                }
                return baseArray;
            }
            case 197175334: {
                Base[] baseArray;
                if (this.daysSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.daysSupply;
                }
                return baseArray;
            }
            case -562837097: {
                Base[] baseArray;
                if (this.whenPrepared == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.whenPrepared;
                }
                return baseArray;
            }
            case -940241380: {
                Base[] baseArray;
                if (this.whenHandedOver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.whenHandedOver;
                }
                return baseArray;
            }
            case -1429847026: {
                Base[] baseArray;
                if (this.destination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.destination;
                }
                return baseArray;
            }
            case -808719889: {
                return this.receiver == null ? new Base[]{} : this.receiver.toArray(new Base[this.receiver.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1201373865: {
                return this.dosageInstruction == null ? new Base[]{} : this.dosageInstruction.toArray(new Base[this.dosageInstruction.size()]);
            }
            case 826147581: {
                Base[] baseArray;
                if (this.substitution == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.substitution;
                }
                return baseArray;
            }
            case 51602295: {
                return this.detectedIssue == null ? new Base[]{} : this.detectedIssue.toArray(new Base[this.detectedIssue.size()]);
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new MedicationDispenseStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToType(value);
                return value;
            }
            case 50511102: {
                this.category = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1998965455: {
                this.medication = TypeConvertor.castToType(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = TypeConvertor.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 481140686: {
                this.getPerformer().add((MedicationDispensePerformerComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -1237557856: {
                this.getAuthorizingPrescription().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 197175334: {
                this.daysSupply = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -562837097: {
                this.whenPrepared = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -940241380: {
                this.whenHandedOver = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1429847026: {
                this.destination = TypeConvertor.castToReference(value);
                return value;
            }
            case -808719889: {
                this.getReceiver().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1201373865: {
                this.getDosageInstruction().add(TypeConvertor.castToDosage(value));
                return value;
            }
            case 826147581: {
                this.substitution = (MedicationDispenseSubstitutionComponent)((Object)value);
                return value;
            }
            case 51602295: {
                this.getDetectedIssue().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationDispenseStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason[x]")) {
            this.statusReason = TypeConvertor.castToType(value);
        } else if (name.equals("category")) {
            this.category = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("medication[x]")) {
            this.medication = TypeConvertor.castToType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = TypeConvertor.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((MedicationDispensePerformerComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("authorizingPrescription")) {
            this.getAuthorizingPrescription().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals("daysSupply")) {
            this.daysSupply = TypeConvertor.castToQuantity(value);
        } else if (name.equals("whenPrepared")) {
            this.whenPrepared = TypeConvertor.castToDateTime(value);
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_DESTINATION)) {
            this.destination = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("dosageInstruction")) {
            this.getDosageInstruction().add(TypeConvertor.castToDosage(value));
        } else if (name.equals("substitution")) {
            this.substitution = (MedicationDispenseSubstitutionComponent)((Object)value);
        } else if (name.equals("detectedIssue")) {
            this.getDetectedIssue().add(TypeConvertor.castToReference(value));
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().remove(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("statusReason[x]")) {
            this.statusReason = null;
        } else if (name.equals("category")) {
            this.category = null;
        } else if (name.equals("medication[x]")) {
            this.medication = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_CONTEXT)) {
            this.context = null;
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().remove(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().remove((MedicationDispensePerformerComponent)value);
        } else if (name.equals("location")) {
            this.location = null;
        } else if (name.equals("authorizingPrescription")) {
            this.getAuthorizingPrescription().remove(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals("quantity")) {
            this.quantity = null;
        } else if (name.equals("daysSupply")) {
            this.daysSupply = null;
        } else if (name.equals("whenPrepared")) {
            this.whenPrepared = null;
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = null;
        } else if (name.equals(SP_DESTINATION)) {
            this.destination = null;
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("dosageInstruction")) {
            this.getDosageInstruction().remove(value);
        } else if (name.equals("substitution")) {
            this.substitution = (MedicationDispenseSubstitutionComponent)value;
        } else if (name.equals("detectedIssue")) {
            this.getDetectedIssue().remove(value);
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1421632534: {
                return this.getStatusReason();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 1458402129: {
                return this.getMedication();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1237557856: {
                return this.addAuthorizingPrescription();
            }
            case 3575610: {
                return this.getType();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 197175334: {
                return this.getDaysSupply();
            }
            case -562837097: {
                return this.getWhenPreparedElement();
            }
            case -940241380: {
                return this.getWhenHandedOverElement();
            }
            case -1429847026: {
                return this.getDestination();
            }
            case -808719889: {
                return this.addReceiver();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1201373865: {
                return this.addDosageInstruction();
            }
            case 826147581: {
                return this.getSubstitution();
            }
            case 51602295: {
                return this.addDetectedIssue();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1998965455: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1237557856: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 197175334: {
                return new String[]{"Quantity"};
            }
            case -562837097: {
                return new String[]{"dateTime"};
            }
            case -940241380: {
                return new String[]{"dateTime"};
            }
            case -1429847026: {
                return new String[]{"Reference"};
            }
            case -808719889: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1201373865: {
                return new String[]{"Dosage"};
            }
            case 826147581: {
                return new String[0];
            }
            case 51602295: {
                return new String[]{"Reference"};
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationDispense.status");
        }
        if (name.equals("statusReasonCodeableConcept")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("statusReasonReference")) {
            this.statusReason = new Reference();
            return this.statusReason;
        }
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("authorizingPrescription")) {
            return this.addAuthorizingPrescription();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("daysSupply")) {
            this.daysSupply = new Quantity();
            return this.daysSupply;
        }
        if (name.equals("whenPrepared")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationDispense.whenPrepared");
        }
        if (name.equals("whenHandedOver")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationDispense.whenHandedOver");
        }
        if (name.equals(SP_DESTINATION)) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals(SP_RECEIVER)) {
            return this.addReceiver();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosageInstruction")) {
            return this.addDosageInstruction();
        }
        if (name.equals("substitution")) {
            this.substitution = new MedicationDispenseSubstitutionComponent();
            return this.substitution;
        }
        if (name.equals("detectedIssue")) {
            return this.addDetectedIssue();
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationDispense";
    }

    @Override
    public MedicationDispense copy() {
        MedicationDispense dst = new MedicationDispense();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationDispense dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        Reference reference = dst.context = this.context == null ? null : this.context.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference2 : this.supportingInformation) {
                dst.supportingInformation.add(reference2.copy());
            }
        }
        if (this.performer != null) {
            dst.performer = new ArrayList<MedicationDispensePerformerComponent>();
            for (MedicationDispensePerformerComponent medicationDispensePerformerComponent : this.performer) {
                dst.performer.add(medicationDispensePerformerComponent.copy());
            }
        }
        Reference reference3 = dst.location = this.location == null ? null : this.location.copy();
        if (this.authorizingPrescription != null) {
            dst.authorizingPrescription = new ArrayList<Reference>();
            for (Reference reference4 : this.authorizingPrescription) {
                dst.authorizingPrescription.add(reference4.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.daysSupply = this.daysSupply == null ? null : this.daysSupply.copy();
        dst.whenPrepared = this.whenPrepared == null ? null : this.whenPrepared.copy();
        dst.whenHandedOver = this.whenHandedOver == null ? null : this.whenHandedOver.copy();
        Reference reference5 = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.receiver != null) {
            dst.receiver = new ArrayList<Reference>();
            for (Reference reference6 : this.receiver) {
                dst.receiver.add(reference6.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.dosageInstruction != null) {
            dst.dosageInstruction = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosageInstruction) {
                dst.dosageInstruction.add(dosage.copy());
            }
        }
        MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent = dst.substitution = this.substitution == null ? null : this.substitution.copy();
        if (this.detectedIssue != null) {
            dst.detectedIssue = new ArrayList<Reference>();
            for (Reference reference7 : this.detectedIssue) {
                dst.detectedIssue.add(reference7.copy());
            }
        }
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference8 : this.eventHistory) {
                dst.eventHistory.add(reference8.copy());
            }
        }
    }

    protected MedicationDispense typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationDispense)) {
            return false;
        }
        MedicationDispense o = (MedicationDispense)other_;
        return MedicationDispense.compareDeep(this.identifier, o.identifier, true) && MedicationDispense.compareDeep(this.partOf, o.partOf, true) && MedicationDispense.compareDeep(this.status, o.status, true) && MedicationDispense.compareDeep(this.statusReason, o.statusReason, true) && MedicationDispense.compareDeep(this.category, o.category, true) && MedicationDispense.compareDeep(this.medication, o.medication, true) && MedicationDispense.compareDeep(this.subject, o.subject, true) && MedicationDispense.compareDeep(this.context, o.context, true) && MedicationDispense.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationDispense.compareDeep(this.performer, o.performer, true) && MedicationDispense.compareDeep(this.location, o.location, true) && MedicationDispense.compareDeep(this.authorizingPrescription, o.authorizingPrescription, true) && MedicationDispense.compareDeep(this.type, o.type, true) && MedicationDispense.compareDeep(this.quantity, o.quantity, true) && MedicationDispense.compareDeep(this.daysSupply, o.daysSupply, true) && MedicationDispense.compareDeep(this.whenPrepared, o.whenPrepared, true) && MedicationDispense.compareDeep(this.whenHandedOver, o.whenHandedOver, true) && MedicationDispense.compareDeep(this.destination, o.destination, true) && MedicationDispense.compareDeep(this.receiver, o.receiver, true) && MedicationDispense.compareDeep(this.note, o.note, true) && MedicationDispense.compareDeep(this.dosageInstruction, o.dosageInstruction, true) && MedicationDispense.compareDeep(this.substitution, o.substitution, true) && MedicationDispense.compareDeep(this.detectedIssue, o.detectedIssue, true) && MedicationDispense.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationDispense)) {
            return false;
        }
        MedicationDispense o = (MedicationDispense)other_;
        return MedicationDispense.compareValues(this.status, o.status, true) && MedicationDispense.compareValues(this.whenPrepared, o.whenPrepared, true) && MedicationDispense.compareValues(this.whenHandedOver, o.whenHandedOver, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.partOf, this.status, this.statusReason, this.category, this.medication, this.subject, this.context, this.supportingInformation, this.performer, this.location, this.authorizingPrescription, this.type, this.quantity, this.daysSupply, this.whenPrepared, this.whenHandedOver, this.destination, this.receiver, this.note, this.dosageInstruction, this.substitution, this.detectedIssue, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationDispense;
    }

    @Block
    public static class MedicationDispenseSubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="wasSubstituted", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether a substitution was or was not performed on the dispense", formalDefinition="True if the dispenser dispensed a different drug or product from what was prescribed.")
        protected BooleanType wasSubstituted;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code signifying whether a different drug was dispensed from what was prescribed", formalDefinition="A code signifying whether a different drug was dispensed from what was prescribed.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode")
        protected CodeableConcept type;
        @Child(name="reason", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why was substitution made", formalDefinition="Indicates the reason for the substitution (or lack of substitution) from what was prescribed.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason")
        protected List<CodeableConcept> reason;
        @Child(name="responsibleParty", type={Practitioner.class, PractitionerRole.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who is responsible for the substitution", formalDefinition="The person or organization that has primary responsibility for the substitution.")
        protected List<Reference> responsibleParty;
        private static final long serialVersionUID = -1895098960L;

        public MedicationDispenseSubstitutionComponent() {
        }

        public MedicationDispenseSubstitutionComponent(boolean wasSubstituted) {
            this.setWasSubstituted(wasSubstituted);
        }

        public BooleanType getWasSubstitutedElement() {
            if (this.wasSubstituted == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseSubstitutionComponent.wasSubstituted");
                }
                if (Configuration.doAutoCreate()) {
                    this.wasSubstituted = new BooleanType();
                }
            }
            return this.wasSubstituted;
        }

        public boolean hasWasSubstitutedElement() {
            return this.wasSubstituted != null && !this.wasSubstituted.isEmpty();
        }

        public boolean hasWasSubstituted() {
            return this.wasSubstituted != null && !this.wasSubstituted.isEmpty();
        }

        public MedicationDispenseSubstitutionComponent setWasSubstitutedElement(BooleanType value) {
            this.wasSubstituted = value;
            return this;
        }

        public boolean getWasSubstituted() {
            return this.wasSubstituted == null || this.wasSubstituted.isEmpty() ? false : (Boolean)this.wasSubstituted.getValue();
        }

        public MedicationDispenseSubstitutionComponent setWasSubstituted(boolean value) {
            if (this.wasSubstituted == null) {
                this.wasSubstituted = new BooleanType();
            }
            this.wasSubstituted.setValue((Object)value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseSubstitutionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationDispenseSubstitutionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public MedicationDispenseSubstitutionComponent setReason(List<CodeableConcept> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public MedicationDispenseSubstitutionComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public CodeableConcept getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<Reference> getResponsibleParty() {
            if (this.responsibleParty == null) {
                this.responsibleParty = new ArrayList<Reference>();
            }
            return this.responsibleParty;
        }

        public MedicationDispenseSubstitutionComponent setResponsibleParty(List<Reference> theResponsibleParty) {
            this.responsibleParty = theResponsibleParty;
            return this;
        }

        public boolean hasResponsibleParty() {
            if (this.responsibleParty == null) {
                return false;
            }
            for (Reference item : this.responsibleParty) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addResponsibleParty() {
            Reference t = new Reference();
            if (this.responsibleParty == null) {
                this.responsibleParty = new ArrayList<Reference>();
            }
            this.responsibleParty.add(t);
            return t;
        }

        public MedicationDispenseSubstitutionComponent addResponsibleParty(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.responsibleParty == null) {
                this.responsibleParty = new ArrayList<Reference>();
            }
            this.responsibleParty.add(t);
            return this;
        }

        public Reference getResponsiblePartyFirstRep() {
            if (this.getResponsibleParty().isEmpty()) {
                this.addResponsibleParty();
            }
            return this.getResponsibleParty().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("wasSubstituted", "boolean", "True if the dispenser dispensed a different drug or product from what was prescribed.", 0, 1, this.wasSubstituted));
            children.add(new Property(MedicationDispense.SP_TYPE, "CodeableConcept", "A code signifying whether a different drug was dispensed from what was prescribed.", 0, 1, this.type));
            children.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution (or lack of substitution) from what was prescribed.", 0, Integer.MAX_VALUE, this.reason));
            children.add(new Property("responsibleParty", "Reference(Practitioner|PractitionerRole)", "The person or organization that has primary responsibility for the substitution.", 0, Integer.MAX_VALUE, this.responsibleParty));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -592113567: {
                    return new Property("wasSubstituted", "boolean", "True if the dispenser dispensed a different drug or product from what was prescribed.", 0, 1, this.wasSubstituted);
                }
                case 3575610: {
                    return new Property(MedicationDispense.SP_TYPE, "CodeableConcept", "A code signifying whether a different drug was dispensed from what was prescribed.", 0, 1, this.type);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Indicates the reason for the substitution (or lack of substitution) from what was prescribed.", 0, Integer.MAX_VALUE, this.reason);
                }
                case 1511509392: {
                    return new Property("responsibleParty", "Reference(Practitioner|PractitionerRole)", "The person or organization that has primary responsibility for the substitution.", 0, Integer.MAX_VALUE, this.responsibleParty);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -592113567: {
                    Base[] baseArray;
                    if (this.wasSubstituted == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.wasSubstituted;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case 1511509392: {
                    return this.responsibleParty == null ? new Base[]{} : this.responsibleParty.toArray(new Base[this.responsibleParty.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -592113567: {
                    this.wasSubstituted = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.getReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1511509392: {
                    this.getResponsibleParty().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("wasSubstituted")) {
                this.wasSubstituted = TypeConvertor.castToBoolean(value);
            } else if (name.equals(MedicationDispense.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.getReason().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("responsibleParty")) {
                this.getResponsibleParty().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("wasSubstituted")) {
                this.wasSubstituted = null;
            } else if (name.equals(MedicationDispense.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("reason")) {
                this.getReason().remove(value);
            } else if (name.equals("responsibleParty")) {
                this.getResponsibleParty().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -592113567: {
                    return this.getWasSubstitutedElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -934964668: {
                    return this.addReason();
                }
                case 1511509392: {
                    return this.addResponsibleParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -592113567: {
                    return new String[]{"boolean"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case 1511509392: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("wasSubstituted")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicationDispense.substitution.wasSubstituted");
            }
            if (name.equals(MedicationDispense.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            if (name.equals("responsibleParty")) {
                return this.addResponsibleParty();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationDispenseSubstitutionComponent copy() {
            MedicationDispenseSubstitutionComponent dst = new MedicationDispenseSubstitutionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationDispenseSubstitutionComponent dst) {
            super.copyValues(dst);
            dst.wasSubstituted = this.wasSubstituted == null ? null : this.wasSubstituted.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.reason) {
                    dst.reason.add(codeableConcept2.copy());
                }
            }
            if (this.responsibleParty != null) {
                dst.responsibleParty = new ArrayList<Reference>();
                for (Reference reference : this.responsibleParty) {
                    dst.responsibleParty.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationDispenseSubstitutionComponent)) {
                return false;
            }
            MedicationDispenseSubstitutionComponent o = (MedicationDispenseSubstitutionComponent)other_;
            return MedicationDispenseSubstitutionComponent.compareDeep(this.wasSubstituted, o.wasSubstituted, true) && MedicationDispenseSubstitutionComponent.compareDeep(this.type, o.type, true) && MedicationDispenseSubstitutionComponent.compareDeep(this.reason, o.reason, true) && MedicationDispenseSubstitutionComponent.compareDeep(this.responsibleParty, o.responsibleParty, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationDispenseSubstitutionComponent)) {
                return false;
            }
            MedicationDispenseSubstitutionComponent o = (MedicationDispenseSubstitutionComponent)other_;
            return MedicationDispenseSubstitutionComponent.compareValues(this.wasSubstituted, o.wasSubstituted, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.wasSubstituted, this.type, this.reason, this.responsibleParty});
        }

        @Override
        public String fhirType() {
            return "MedicationDispense.substitution";
        }
    }

    @Block
    public static class MedicationDispensePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who performed the dispense and what they did", formalDefinition="Distinguishes the type of performer in the dispense.  For example, date enterer, packager, final checker.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-performer-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual who was performing", formalDefinition="The device, practitioner, etc. who performed the action.  It should be assumed that the actor is the dispenser of the medication.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public MedicationDispensePerformerComponent() {
        }

        public MedicationDispensePerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispensePerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public MedicationDispensePerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispensePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public MedicationDispensePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of performer in the dispense.  For example, date enterer, packager, final checker.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed the action.  It should be assumed that the actor is the dispenser of the medication.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of performer in the dispense.  For example, date enterer, packager, final checker.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed the action.  It should be assumed that the actor is the dispenser of the medication.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationDispensePerformerComponent copy() {
            MedicationDispensePerformerComponent dst = new MedicationDispensePerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationDispensePerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationDispensePerformerComponent)) {
                return false;
            }
            MedicationDispensePerformerComponent o = (MedicationDispensePerformerComponent)other_;
            return MedicationDispensePerformerComponent.compareDeep(this.function, o.function, true) && MedicationDispensePerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationDispensePerformerComponent)) {
                return false;
            }
            MedicationDispensePerformerComponent o = (MedicationDispensePerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "MedicationDispense.performer";
        }
    }

    public static class MedicationDispenseStatusCodesEnumFactory
    implements EnumFactory<MedicationDispenseStatusCodes> {
        @Override
        public MedicationDispenseStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return MedicationDispenseStatusCodes.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return MedicationDispenseStatusCodes.INPROGRESS;
            }
            if ("cancelled".equals(codeString)) {
                return MedicationDispenseStatusCodes.CANCELLED;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationDispenseStatusCodes.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationDispenseStatusCodes.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationDispenseStatusCodes.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationDispenseStatusCodes.STOPPED;
            }
            if ("declined".equals(codeString)) {
                return MedicationDispenseStatusCodes.DECLINED;
            }
            if ("unknown".equals(codeString)) {
                return MedicationDispenseStatusCodes.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MedicationDispenseStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationDispenseStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.NULL, code);
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.PREPARATION, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.INPROGRESS, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.CANCELLED, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.ONHOLD, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.ENTEREDINERROR, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.STOPPED, code);
            }
            if ("declined".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.DECLINED, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatusCodes>(this, MedicationDispenseStatusCodes.UNKNOWN, code);
            }
            throw new FHIRException("Unknown MedicationDispenseStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationDispenseStatusCodes code) {
            if (code == MedicationDispenseStatusCodes.NULL) {
                return null;
            }
            if (code == MedicationDispenseStatusCodes.PREPARATION) {
                return "preparation";
            }
            if (code == MedicationDispenseStatusCodes.INPROGRESS) {
                return "in-progress";
            }
            if (code == MedicationDispenseStatusCodes.CANCELLED) {
                return "cancelled";
            }
            if (code == MedicationDispenseStatusCodes.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationDispenseStatusCodes.COMPLETED) {
                return "completed";
            }
            if (code == MedicationDispenseStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationDispenseStatusCodes.STOPPED) {
                return "stopped";
            }
            if (code == MedicationDispenseStatusCodes.DECLINED) {
                return "declined";
            }
            if (code == MedicationDispenseStatusCodes.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationDispenseStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationDispenseStatusCodes {
        PREPARATION,
        INPROGRESS,
        CANCELLED,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        DECLINED,
        UNKNOWN,
        NULL;


        public static MedicationDispenseStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("declined".equals(codeString)) {
                return DECLINED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationDispenseStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case DECLINED: {
                    return "declined";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case INPROGRESS: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case CANCELLED: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case ONHOLD: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case COMPLETED: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case ENTEREDINERROR: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case STOPPED: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case DECLINED: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case UNKNOWN: {
                    return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. initial compounding or packaging of medication). Preparation stages may be tracked for billing purposes.";
                }
                case INPROGRESS: {
                    return "The dispensed product is ready for pickup.";
                }
                case CANCELLED: {
                    return "The dispensed product was not and will never be picked up by the patient.";
                }
                case ONHOLD: {
                    return "The dispense process is paused while waiting for an external event to reactivate the dispense.  For example, new stock has arrived or the prescriber has called.";
                }
                case COMPLETED: {
                    return "The dispensed product has been picked up.";
                }
                case ENTEREDINERROR: {
                    return "The dispense was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the dispense have been permanently halted, before all of them occurred.";
                }
                case DECLINED: {
                    return "The dispense was declined and not performed.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values applies for this medication dispense.  Note: this concept is not to be used for other - one of the listed statuses is presumed to apply, it's just now known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case DECLINED: {
                    return "Declined";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

