/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.ContactPoint;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UrlType;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MessageHeader", profile="http://hl7.org/fhir/StructureDefinition/MessageHeader")
public class MessageHeader
extends DomainResource {
    @Child(name="event", type={Coding.class, UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code for the event this message represents or link to event definition", formalDefinition="Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://terminology.hl7.org/CodeSystem/message-events\".  Alternatively uri to the EventDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-events")
    protected DataType event;
    @Child(name="destination", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message destination application(s)", formalDefinition="The destination application which the message is intended for.")
    protected List<MessageDestinationComponent> destination;
    @Child(name="sender", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Real world sender of the message", formalDefinition="Identifies the sending system to allow the use of a trust relationship.")
    protected Reference sender;
    @Child(name="enterer", type={Practitioner.class, PractitionerRole.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source of the data entry", formalDefinition="The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.")
    protected Reference enterer;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source of the decision", formalDefinition="The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.")
    protected Reference author;
    @Child(name="source", type={}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message source application", formalDefinition="The source application from which this message originated.")
    protected MessageSourceComponent source;
    @Child(name="responsible", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Final responsibility for event", formalDefinition="The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.")
    protected Reference responsible;
    @Child(name="reason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Cause of event", formalDefinition="Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-reason-encounter")
    protected CodeableConcept reason;
    @Child(name="response", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this is a reply to prior message", formalDefinition="Information about the message that this message is a response to.  Only present if this message is a response.")
    protected MessageHeaderResponseComponent response;
    @Child(name="focus", type={Reference.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The actual content of the message", formalDefinition="The actual data of the message - a reference to the root/focus class of the event.")
    protected List<Reference> focus;
    @Child(name="definition", type={CanonicalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Link to the definition for this message", formalDefinition="Permanent link to the MessageDefinition for this message.")
    protected CanonicalType definition;
    private static final long serialVersionUID = -2012792051L;
    @SearchParamDefinition(name="author", path="MessageHeader.author", description="The source of the decision", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("MessageHeader:author").toLocked();
    @SearchParamDefinition(name="code", path="MessageHeader.response.code", description="ok | transient-error | fatal-error", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="destination-uri", path="MessageHeader.destination.endpoint", description="Actual destination address or id", type="uri")
    public static final String SP_DESTINATION_URI = "destination-uri";
    public static final UriClientParam DESTINATION_URI = new UriClientParam("destination-uri");
    @SearchParamDefinition(name="destination", path="MessageHeader.destination.name", description="Name of system", type="string")
    public static final String SP_DESTINATION = "destination";
    public static final StringClientParam DESTINATION = new StringClientParam("destination");
    @SearchParamDefinition(name="enterer", path="MessageHeader.enterer", description="The source of the data entry", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("MessageHeader:enterer").toLocked();
    @SearchParamDefinition(name="event", path="MessageHeader.event", description="Code for the event this message represents or link to event definition", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="focus", path="MessageHeader.focus", description="The actual content of the message", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_FOCUS = "focus";
    public static final ReferenceClientParam FOCUS = new ReferenceClientParam("focus");
    public static final Include INCLUDE_FOCUS = new Include("MessageHeader:focus").toLocked();
    @SearchParamDefinition(name="receiver", path="MessageHeader.destination.receiver", description="Intended \"real-world\" recipient for the data", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_RECEIVER = new Include("MessageHeader:receiver").toLocked();
    @SearchParamDefinition(name="response-id", path="MessageHeader.response.identifier", description="Id of original message", type="token")
    public static final String SP_RESPONSE_ID = "response-id";
    public static final TokenClientParam RESPONSE_ID = new TokenClientParam("response-id");
    @SearchParamDefinition(name="responsible", path="MessageHeader.responsible", description="Final responsibility for event", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_RESPONSIBLE = "responsible";
    public static final ReferenceClientParam RESPONSIBLE = new ReferenceClientParam("responsible");
    public static final Include INCLUDE_RESPONSIBLE = new Include("MessageHeader:responsible").toLocked();
    @SearchParamDefinition(name="sender", path="MessageHeader.sender", description="Real world sender of the message", type="reference", target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    public static final Include INCLUDE_SENDER = new Include("MessageHeader:sender").toLocked();
    @SearchParamDefinition(name="source-uri", path="MessageHeader.source.endpoint", description="Actual message source address or id", type="uri")
    public static final String SP_SOURCE_URI = "source-uri";
    public static final UriClientParam SOURCE_URI = new UriClientParam("source-uri");
    @SearchParamDefinition(name="source", path="MessageHeader.source.name", description="Name of system", type="string")
    public static final String SP_SOURCE = "source";
    public static final StringClientParam SOURCE = new StringClientParam("source");
    @SearchParamDefinition(name="target", path="MessageHeader.destination.target", description="Particular delivery destination within the destination", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device")}, target={Device.class})
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("MessageHeader:target").toLocked();

    public MessageHeader() {
    }

    public MessageHeader(DataType event, MessageSourceComponent source) {
        this.setEvent(event);
        this.setSource(source);
    }

    public DataType getEvent() {
        return this.event;
    }

    public Coding getEventCoding() throws FHIRException {
        if (this.event == null) {
            this.event = new Coding();
        }
        if (!(this.event instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.event.getClass().getName() + " was encountered");
        }
        return (Coding)this.event;
    }

    public boolean hasEventCoding() {
        return this != null && this.event instanceof Coding;
    }

    public UriType getEventUriType() throws FHIRException {
        if (this.event == null) {
            this.event = new UriType();
        }
        if (!(this.event instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.event.getClass().getName() + " was encountered");
        }
        return (UriType)this.event;
    }

    public boolean hasEventUriType() {
        return this != null && this.event instanceof UriType;
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public MessageHeader setEvent(DataType value) {
        if (value != null && !(value instanceof Coding) && !(value instanceof UriType)) {
            throw new Error("Not the right type for MessageHeader.event[x]: " + value.fhirType());
        }
        this.event = value;
        return this;
    }

    public List<MessageDestinationComponent> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        return this.destination;
    }

    public MessageHeader setDestination(List<MessageDestinationComponent> theDestination) {
        this.destination = theDestination;
        return this;
    }

    public boolean hasDestination() {
        if (this.destination == null) {
            return false;
        }
        for (MessageDestinationComponent item : this.destination) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationComponent addDestination() {
        MessageDestinationComponent t = new MessageDestinationComponent();
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        this.destination.add(t);
        return t;
    }

    public MessageHeader addDestination(MessageDestinationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        this.destination.add(t);
        return this;
    }

    public MessageDestinationComponent getDestinationFirstRep() {
        if (this.getDestination().isEmpty()) {
            this.addDestination();
        }
        return this.getDestination().get(0);
    }

    public Reference getSender() {
        if (this.sender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.sender");
            }
            if (Configuration.doAutoCreate()) {
                this.sender = new Reference();
            }
        }
        return this.sender;
    }

    public boolean hasSender() {
        return this.sender != null && !this.sender.isEmpty();
    }

    public MessageHeader setSender(Reference value) {
        this.sender = value;
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public MessageHeader setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public MessageHeader setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public MessageSourceComponent getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new MessageSourceComponent();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public MessageHeader setSource(MessageSourceComponent value) {
        this.source = value;
        return this;
    }

    public Reference getResponsible() {
        if (this.responsible == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.responsible");
            }
            if (Configuration.doAutoCreate()) {
                this.responsible = new Reference();
            }
        }
        return this.responsible;
    }

    public boolean hasResponsible() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public MessageHeader setResponsible(Reference value) {
        this.responsible = value;
        return this;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public MessageHeader setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public MessageHeaderResponseComponent getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new MessageHeaderResponseComponent();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public MessageHeader setResponse(MessageHeaderResponseComponent value) {
        this.response = value;
        return this;
    }

    public List<Reference> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        return this.focus;
    }

    public MessageHeader setFocus(List<Reference> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (Reference item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFocus() {
        Reference t = new Reference();
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return t;
    }

    public MessageHeader addFocus(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return this;
    }

    public Reference getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public CanonicalType getDefinitionElement() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new CanonicalType();
            }
        }
        return this.definition;
    }

    public boolean hasDefinitionElement() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public MessageHeader setDefinitionElement(CanonicalType value) {
        this.definition = value;
        return this;
    }

    public String getDefinition() {
        return this.definition == null ? null : (String)this.definition.getValue();
    }

    public MessageHeader setDefinition(String value) {
        if (Utilities.noString((String)value)) {
            this.definition = null;
        } else {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            this.definition.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("event[x]", "Coding|uri", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://terminology.hl7.org/CodeSystem/message-events\".  Alternatively uri to the EventDefinition.", 0, 1, this.event));
        children.add(new Property(SP_DESTINATION, "", "The destination application which the message is intended for.", 0, Integer.MAX_VALUE, this.destination));
        children.add(new Property(SP_SENDER, "Reference(Practitioner|PractitionerRole|Organization)", "Identifies the sending system to allow the use of a trust relationship.", 0, 1, this.sender));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.", 0, 1, this.enterer));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole)", "The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.", 0, 1, this.author));
        children.add(new Property(SP_SOURCE, "", "The source application from which this message originated.", 0, 1, this.source));
        children.add(new Property(SP_RESPONSIBLE, "Reference(Practitioner|PractitionerRole|Organization)", "The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.", 0, 1, this.responsible));
        children.add(new Property("reason", "CodeableConcept", "Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.", 0, 1, this.reason));
        children.add(new Property("response", "", "Information about the message that this message is a response to.  Only present if this message is a response.", 0, 1, this.response));
        children.add(new Property(SP_FOCUS, "Reference(Any)", "The actual data of the message - a reference to the root/focus class of the event.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property("definition", "canonical(MessageDefinition)", "Permanent link to the MessageDefinition for this message.", 0, 1, this.definition));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 278115238: {
                return new Property("event[x]", "Coding|uri", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://terminology.hl7.org/CodeSystem/message-events\".  Alternatively uri to the EventDefinition.", 0, 1, this.event);
            }
            case 96891546: {
                return new Property("event[x]", "Coding|uri", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://terminology.hl7.org/CodeSystem/message-events\".  Alternatively uri to the EventDefinition.", 0, 1, this.event);
            }
            case -355957084: {
                return new Property("event[x]", "Coding", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://terminology.hl7.org/CodeSystem/message-events\".  Alternatively uri to the EventDefinition.", 0, 1, this.event);
            }
            case 278109298: {
                return new Property("event[x]", "uri", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://terminology.hl7.org/CodeSystem/message-events\".  Alternatively uri to the EventDefinition.", 0, 1, this.event);
            }
            case -1429847026: {
                return new Property(SP_DESTINATION, "", "The destination application which the message is intended for.", 0, Integer.MAX_VALUE, this.destination);
            }
            case -905962955: {
                return new Property(SP_SENDER, "Reference(Practitioner|PractitionerRole|Organization)", "Identifies the sending system to allow the use of a trust relationship.", 0, 1, this.sender);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.", 0, 1, this.enterer);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole)", "The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.", 0, 1, this.author);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "", "The source application from which this message originated.", 0, 1, this.source);
            }
            case 1847674614: {
                return new Property(SP_RESPONSIBLE, "Reference(Practitioner|PractitionerRole|Organization)", "The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.", 0, 1, this.responsible);
            }
            case -934964668: {
                return new Property("reason", "CodeableConcept", "Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.", 0, 1, this.reason);
            }
            case -340323263: {
                return new Property("response", "", "Information about the message that this message is a response to.  Only present if this message is a response.", 0, 1, this.response);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "Reference(Any)", "The actual data of the message - a reference to the root/focus class of the event.", 0, Integer.MAX_VALUE, this.focus);
            }
            case -1014418093: {
                return new Property("definition", "canonical(MessageDefinition)", "Permanent link to the MessageDefinition for this message.", 0, 1, this.definition);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 96891546: {
                Base[] baseArray;
                if (this.event == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.event;
                }
                return baseArray;
            }
            case -1429847026: {
                return this.destination == null ? new Base[]{} : this.destination.toArray(new Base[this.destination.size()]);
            }
            case -905962955: {
                Base[] baseArray;
                if (this.sender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.sender;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.enterer;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.author;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.source;
                }
                return baseArray;
            }
            case 1847674614: {
                Base[] baseArray;
                if (this.responsible == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.responsible;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.reason;
                }
                return baseArray;
            }
            case -340323263: {
                Base[] baseArray;
                if (this.response == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.response;
                }
                return baseArray;
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.definition;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 96891546: {
                this.event = TypeConvertor.castToType(value);
                return value;
            }
            case -1429847026: {
                this.getDestination().add((MessageDestinationComponent)value);
                return value;
            }
            case -905962955: {
                this.sender = TypeConvertor.castToReference(value);
                return value;
            }
            case -1591951995: {
                this.enterer = TypeConvertor.castToReference(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
            case -896505829: {
                this.source = (MessageSourceComponent)value;
                return value;
            }
            case 1847674614: {
                this.responsible = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -340323263: {
                this.response = (MessageHeaderResponseComponent)value;
                return value;
            }
            case 97604824: {
                this.getFocus().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1014418093: {
                this.definition = TypeConvertor.castToCanonical(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("event[x]")) {
            this.event = TypeConvertor.castToType(value);
        } else if (name.equals(SP_DESTINATION)) {
            this.getDestination().add((MessageDestinationComponent)value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = (MessageSourceComponent)value;
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.reason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("response")) {
            this.response = (MessageHeaderResponseComponent)value;
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(TypeConvertor.castToReference(value));
        } else if (name.equals("definition")) {
            this.definition = TypeConvertor.castToCanonical(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("event[x]")) {
            this.event = null;
        } else if (name.equals(SP_DESTINATION)) {
            this.getDestination().remove((MessageDestinationComponent)value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = null;
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = null;
        } else if (name.equals(SP_AUTHOR)) {
            this.author = null;
        } else if (name.equals(SP_SOURCE)) {
            this.source = (MessageSourceComponent)value;
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = null;
        } else if (name.equals("reason")) {
            this.reason = null;
        } else if (name.equals("response")) {
            this.response = (MessageHeaderResponseComponent)value;
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().remove(value);
        } else if (name.equals("definition")) {
            this.definition = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 278115238: {
                return this.getEvent();
            }
            case 96891546: {
                return this.getEvent();
            }
            case -1429847026: {
                return this.addDestination();
            }
            case -905962955: {
                return this.getSender();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -896505829: {
                return this.getSource();
            }
            case 1847674614: {
                return this.getResponsible();
            }
            case -934964668: {
                return this.getReason();
            }
            case -340323263: {
                return this.getResponse();
            }
            case 97604824: {
                return this.addFocus();
            }
            case -1014418093: {
                return this.getDefinitionElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return new String[]{"Coding", "uri"};
            }
            case -1429847026: {
                return new String[0];
            }
            case -905962955: {
                return new String[]{"Reference"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -896505829: {
                return new String[0];
            }
            case 1847674614: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case -340323263: {
                return new String[0];
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case -1014418093: {
                return new String[]{"canonical"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("eventCoding")) {
            this.event = new Coding();
            return this.event;
        }
        if (name.equals("eventUri")) {
            this.event = new UriType();
            return this.event;
        }
        if (name.equals(SP_DESTINATION)) {
            return this.addDestination();
        }
        if (name.equals(SP_SENDER)) {
            this.sender = new Reference();
            return this.sender;
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new MessageSourceComponent();
            return this.source;
        }
        if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = new Reference();
            return this.responsible;
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("response")) {
            this.response = new MessageHeaderResponseComponent();
            return this.response;
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.definition");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MessageHeader";
    }

    @Override
    public MessageHeader copy() {
        MessageHeader dst = new MessageHeader();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MessageHeader dst) {
        super.copyValues(dst);
        DataType dataType = dst.event = this.event == null ? null : this.event.copy();
        if (this.destination != null) {
            dst.destination = new ArrayList<MessageDestinationComponent>();
            for (MessageDestinationComponent messageDestinationComponent : this.destination) {
                dst.destination.add(messageDestinationComponent.copy());
            }
        }
        dst.sender = this.sender == null ? null : this.sender.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.responsible = this.responsible == null ? null : this.responsible.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        MessageHeaderResponseComponent messageHeaderResponseComponent = dst.response = this.response == null ? null : this.response.copy();
        if (this.focus != null) {
            dst.focus = new ArrayList<Reference>();
            for (Reference reference : this.focus) {
                dst.focus.add(reference.copy());
            }
        }
        dst.definition = this.definition == null ? null : this.definition.copy();
    }

    protected MessageHeader typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MessageHeader)) {
            return false;
        }
        MessageHeader o = (MessageHeader)other_;
        return MessageHeader.compareDeep(this.event, o.event, true) && MessageHeader.compareDeep(this.destination, o.destination, true) && MessageHeader.compareDeep(this.sender, o.sender, true) && MessageHeader.compareDeep(this.enterer, o.enterer, true) && MessageHeader.compareDeep(this.author, o.author, true) && MessageHeader.compareDeep(this.source, o.source, true) && MessageHeader.compareDeep(this.responsible, o.responsible, true) && MessageHeader.compareDeep(this.reason, o.reason, true) && MessageHeader.compareDeep(this.response, o.response, true) && MessageHeader.compareDeep(this.focus, o.focus, true) && MessageHeader.compareDeep(this.definition, o.definition, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MessageHeader)) {
            return false;
        }
        MessageHeader o = (MessageHeader)other_;
        return MessageHeader.compareValues(this.definition, o.definition, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.event, this.destination, this.sender, this.enterer, this.author, this.source, this.responsible, this.reason, this.response, this.focus, this.definition});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MessageHeader;
    }

    @Block
    public static class MessageHeaderResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of original message", formalDefinition="The MessageHeader.id of the message to which this message is a response.")
        protected IdType identifier;
        @Child(name="code", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ok | transient-error | fatal-error", formalDefinition="Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/response-code")
        protected Enumeration<ResponseType> code;
        @Child(name="details", type={OperationOutcome.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific list of hints/warnings/errors", formalDefinition="Full details of any issues found in the message.")
        protected Reference details;
        private static final long serialVersionUID = 399636654L;

        public MessageHeaderResponseComponent() {
        }

        public MessageHeaderResponseComponent(String identifier, ResponseType code) {
            this.setIdentifier(identifier);
            this.setCode(code);
        }

        public IdType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new IdType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MessageHeaderResponseComponent setIdentifierElement(IdType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public MessageHeaderResponseComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new IdType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public Enumeration<ResponseType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<ResponseType>(new ResponseTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MessageHeaderResponseComponent setCodeElement(Enumeration<ResponseType> value) {
            this.code = value;
            return this;
        }

        public ResponseType getCode() {
            return this.code == null ? null : (ResponseType)((Object)this.code.getValue());
        }

        public MessageHeaderResponseComponent setCode(ResponseType value) {
            if (this.code == null) {
                this.code = new Enumeration<ResponseType>(new ResponseTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Reference getDetails() {
            if (this.details == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.details");
                }
                if (Configuration.doAutoCreate()) {
                    this.details = new Reference();
                }
            }
            return this.details;
        }

        public boolean hasDetails() {
            return this.details != null && !this.details.isEmpty();
        }

        public MessageHeaderResponseComponent setDetails(Reference value) {
            this.details = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identifier", "id", "The MessageHeader.id of the message to which this message is a response.", 0, 1, this.identifier));
            children.add(new Property(MessageHeader.SP_CODE, MessageHeader.SP_CODE, "Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.", 0, 1, this.code));
            children.add(new Property("details", "Reference(OperationOutcome)", "Full details of any issues found in the message.", 0, 1, this.details));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property("identifier", "id", "The MessageHeader.id of the message to which this message is a response.", 0, 1, this.identifier);
                }
                case 3059181: {
                    return new Property(MessageHeader.SP_CODE, MessageHeader.SP_CODE, "Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.", 0, 1, this.code);
                }
                case 1557721666: {
                    return new Property("details", "Reference(OperationOutcome)", "Full details of any issues found in the message.", 0, 1, this.details);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1557721666: {
                    Base[] baseArray;
                    if (this.details == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.details;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = TypeConvertor.castToId(value);
                    return value;
                }
                case 3059181: {
                    value = new ResponseTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 1557721666: {
                    this.details = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = TypeConvertor.castToId(value);
            } else if (name.equals(MessageHeader.SP_CODE)) {
                value = new ResponseTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.code = value;
            } else if (name.equals("details")) {
                this.details = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = null;
            } else if (name.equals(MessageHeader.SP_CODE)) {
                this.code = null;
            } else if (name.equals("details")) {
                this.details = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifierElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1557721666: {
                    return this.getDetails();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"id"};
                }
                case 3059181: {
                    return new String[]{MessageHeader.SP_CODE};
                }
                case 1557721666: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.response.identifier");
            }
            if (name.equals(MessageHeader.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.response.code");
            }
            if (name.equals("details")) {
                this.details = new Reference();
                return this.details;
            }
            return super.addChild(name);
        }

        @Override
        public MessageHeaderResponseComponent copy() {
            MessageHeaderResponseComponent dst = new MessageHeaderResponseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MessageHeaderResponseComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.details = this.details == null ? null : this.details.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageHeaderResponseComponent)) {
                return false;
            }
            MessageHeaderResponseComponent o = (MessageHeaderResponseComponent)other_;
            return MessageHeaderResponseComponent.compareDeep(this.identifier, o.identifier, true) && MessageHeaderResponseComponent.compareDeep(this.code, o.code, true) && MessageHeaderResponseComponent.compareDeep(this.details, o.details, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageHeaderResponseComponent)) {
                return false;
            }
            MessageHeaderResponseComponent o = (MessageHeaderResponseComponent)other_;
            return MessageHeaderResponseComponent.compareValues(this.identifier, o.identifier, true) && MessageHeaderResponseComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.code, this.details});
        }

        @Override
        public String fhirType() {
            return "MessageHeader.response";
        }
    }

    @Block
    public static class MessageSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the source system.")
        protected StringType name;
        @Child(name="software", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of software running the system", formalDefinition="May include configuration or other information useful in debugging.")
        protected StringType software;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version of software running", formalDefinition="Can convey versions of multiple systems in situations where a message passes through multiple hands.")
        protected StringType version;
        @Child(name="contact", type={ContactPoint.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human contact for problems", formalDefinition="An e-mail, phone, website or other contact point to use to resolve issues with message communications.")
        protected ContactPoint contact;
        @Child(name="endpoint", type={UrlType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual message source address or id", formalDefinition="Identifies the routing target to send acknowledgements to.")
        protected UrlType endpoint;
        private static final long serialVersionUID = -350916401L;

        public MessageSourceComponent() {
        }

        public MessageSourceComponent(String endpoint) {
            this.setEndpoint(endpoint);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MessageSourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MessageSourceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getSoftwareElement() {
            if (this.software == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.software");
                }
                if (Configuration.doAutoCreate()) {
                    this.software = new StringType();
                }
            }
            return this.software;
        }

        public boolean hasSoftwareElement() {
            return this.software != null && !this.software.isEmpty();
        }

        public boolean hasSoftware() {
            return this.software != null && !this.software.isEmpty();
        }

        public MessageSourceComponent setSoftwareElement(StringType value) {
            this.software = value;
            return this;
        }

        public String getSoftware() {
            return this.software == null ? null : (String)this.software.getValue();
        }

        public MessageSourceComponent setSoftware(String value) {
            if (Utilities.noString((String)value)) {
                this.software = null;
            } else {
                if (this.software == null) {
                    this.software = new StringType();
                }
                this.software.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public MessageSourceComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public MessageSourceComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public ContactPoint getContact() {
            if (this.contact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.contact");
                }
                if (Configuration.doAutoCreate()) {
                    this.contact = new ContactPoint();
                }
            }
            return this.contact;
        }

        public boolean hasContact() {
            return this.contact != null && !this.contact.isEmpty();
        }

        public MessageSourceComponent setContact(ContactPoint value) {
            this.contact = value;
            return this;
        }

        public UrlType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UrlType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public MessageSourceComponent setEndpointElement(UrlType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public MessageSourceComponent setEndpoint(String value) {
            if (this.endpoint == null) {
                this.endpoint = new UrlType();
            }
            this.endpoint.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Human-readable name for the source system.", 0, 1, this.name));
            children.add(new Property("software", "string", "May include configuration or other information useful in debugging.", 0, 1, this.software));
            children.add(new Property("version", "string", "Can convey versions of multiple systems in situations where a message passes through multiple hands.", 0, 1, this.version));
            children.add(new Property("contact", "ContactPoint", "An e-mail, phone, website or other contact point to use to resolve issues with message communications.", 0, 1, this.contact));
            children.add(new Property("endpoint", "url", "Identifies the routing target to send acknowledgements to.", 0, 1, this.endpoint));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Human-readable name for the source system.", 0, 1, this.name);
                }
                case 1319330215: {
                    return new Property("software", "string", "May include configuration or other information useful in debugging.", 0, 1, this.software);
                }
                case 351608024: {
                    return new Property("version", "string", "Can convey versions of multiple systems in situations where a message passes through multiple hands.", 0, 1, this.version);
                }
                case 951526432: {
                    return new Property("contact", "ContactPoint", "An e-mail, phone, website or other contact point to use to resolve issues with message communications.", 0, 1, this.contact);
                }
                case 1741102485: {
                    return new Property("endpoint", "url", "Identifies the routing target to send acknowledgements to.", 0, 1, this.endpoint);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 1319330215: {
                    Base[] baseArray;
                    if (this.software == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.software;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
                case 951526432: {
                    Base[] baseArray;
                    if (this.contact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.contact;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    Base[] baseArray;
                    if (this.endpoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.endpoint;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 1319330215: {
                    this.software = TypeConvertor.castToString(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
                case 951526432: {
                    this.contact = TypeConvertor.castToContactPoint(value);
                    return value;
                }
                case 1741102485: {
                    this.endpoint = TypeConvertor.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("software")) {
                this.software = TypeConvertor.castToString(value);
            } else if (name.equals("version")) {
                this.version = TypeConvertor.castToString(value);
            } else if (name.equals("contact")) {
                this.contact = TypeConvertor.castToContactPoint(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = TypeConvertor.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = null;
            } else if (name.equals("software")) {
                this.software = null;
            } else if (name.equals("version")) {
                this.version = null;
            } else if (name.equals("contact")) {
                this.contact = null;
            } else if (name.equals("endpoint")) {
                this.endpoint = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 1319330215: {
                    return this.getSoftwareElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 951526432: {
                    return this.getContact();
                }
                case 1741102485: {
                    return this.getEndpointElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 1319330215: {
                    return new String[]{"string"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 951526432: {
                    return new String[]{"ContactPoint"};
                }
                case 1741102485: {
                    return new String[]{"url"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.source.name");
            }
            if (name.equals("software")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.source.software");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.source.version");
            }
            if (name.equals("contact")) {
                this.contact = new ContactPoint();
                return this.contact;
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.source.endpoint");
            }
            return super.addChild(name);
        }

        @Override
        public MessageSourceComponent copy() {
            MessageSourceComponent dst = new MessageSourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MessageSourceComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.software = this.software == null ? null : this.software.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.contact = this.contact == null ? null : this.contact.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageSourceComponent)) {
                return false;
            }
            MessageSourceComponent o = (MessageSourceComponent)other_;
            return MessageSourceComponent.compareDeep(this.name, o.name, true) && MessageSourceComponent.compareDeep(this.software, o.software, true) && MessageSourceComponent.compareDeep(this.version, o.version, true) && MessageSourceComponent.compareDeep(this.contact, o.contact, true) && MessageSourceComponent.compareDeep(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageSourceComponent)) {
                return false;
            }
            MessageSourceComponent o = (MessageSourceComponent)other_;
            return MessageSourceComponent.compareValues(this.name, o.name, true) && MessageSourceComponent.compareValues(this.software, o.software, true) && MessageSourceComponent.compareValues(this.version, o.version, true) && MessageSourceComponent.compareValues(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.software, this.version, this.contact, this.endpoint});
        }

        @Override
        public String fhirType() {
            return "MessageHeader.source";
        }
    }

    @Block
    public static class MessageDestinationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the target system.")
        protected StringType name;
        @Child(name="target", type={Device.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Particular delivery destination within the destination", formalDefinition="Identifies the target end system in situations where the initial message transmission is to an intermediary system.")
        protected Reference target;
        @Child(name="endpoint", type={UrlType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual destination address or id", formalDefinition="Indicates where the message should be routed to.")
        protected UrlType endpoint;
        @Child(name="receiver", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Intended \"real-world\" recipient for the data", formalDefinition="Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.")
        protected Reference receiver;
        private static final long serialVersionUID = -686949282L;

        public MessageDestinationComponent() {
        }

        public MessageDestinationComponent(String endpoint) {
            this.setEndpoint(endpoint);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MessageDestinationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MessageDestinationComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public MessageDestinationComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public UrlType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UrlType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public MessageDestinationComponent setEndpointElement(UrlType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public MessageDestinationComponent setEndpoint(String value) {
            if (this.endpoint == null) {
                this.endpoint = new UrlType();
            }
            this.endpoint.setValue(value);
            return this;
        }

        public Reference getReceiver() {
            if (this.receiver == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.receiver");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiver = new Reference();
                }
            }
            return this.receiver;
        }

        public boolean hasReceiver() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public MessageDestinationComponent setReceiver(Reference value) {
            this.receiver = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Human-readable name for the target system.", 0, 1, this.name));
            children.add(new Property(MessageHeader.SP_TARGET, "Reference(Device)", "Identifies the target end system in situations where the initial message transmission is to an intermediary system.", 0, 1, this.target));
            children.add(new Property("endpoint", "url", "Indicates where the message should be routed to.", 0, 1, this.endpoint));
            children.add(new Property(MessageHeader.SP_RECEIVER, "Reference(Practitioner|PractitionerRole|Organization)", "Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.", 0, 1, this.receiver));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Human-readable name for the target system.", 0, 1, this.name);
                }
                case -880905839: {
                    return new Property(MessageHeader.SP_TARGET, "Reference(Device)", "Identifies the target end system in situations where the initial message transmission is to an intermediary system.", 0, 1, this.target);
                }
                case 1741102485: {
                    return new Property("endpoint", "url", "Indicates where the message should be routed to.", 0, 1, this.endpoint);
                }
                case -808719889: {
                    return new Property(MessageHeader.SP_RECEIVER, "Reference(Practitioner|PractitionerRole|Organization)", "Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.", 0, 1, this.receiver);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    Base[] baseArray;
                    if (this.endpoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.endpoint;
                    }
                    return baseArray;
                }
                case -808719889: {
                    Base[] baseArray;
                    if (this.receiver == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.receiver;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1741102485: {
                    this.endpoint = TypeConvertor.castToUrl(value);
                    return value;
                }
                case -808719889: {
                    this.receiver = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = TypeConvertor.castToReference(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = TypeConvertor.castToUrl(value);
            } else if (name.equals(MessageHeader.SP_RECEIVER)) {
                this.receiver = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = null;
            } else if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = null;
            } else if (name.equals("endpoint")) {
                this.endpoint = null;
            } else if (name.equals(MessageHeader.SP_RECEIVER)) {
                this.receiver = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -880905839: {
                    return this.getTarget();
                }
                case 1741102485: {
                    return this.getEndpointElement();
                }
                case -808719889: {
                    return this.getReceiver();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
                case 1741102485: {
                    return new String[]{"url"};
                }
                case -808719889: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.destination.name");
            }
            if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.destination.endpoint");
            }
            if (name.equals(MessageHeader.SP_RECEIVER)) {
                this.receiver = new Reference();
                return this.receiver;
            }
            return super.addChild(name);
        }

        @Override
        public MessageDestinationComponent copy() {
            MessageDestinationComponent dst = new MessageDestinationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MessageDestinationComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.target = this.target == null ? null : this.target.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            dst.receiver = this.receiver == null ? null : this.receiver.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDestinationComponent)) {
                return false;
            }
            MessageDestinationComponent o = (MessageDestinationComponent)other_;
            return MessageDestinationComponent.compareDeep(this.name, o.name, true) && MessageDestinationComponent.compareDeep(this.target, o.target, true) && MessageDestinationComponent.compareDeep(this.endpoint, o.endpoint, true) && MessageDestinationComponent.compareDeep(this.receiver, o.receiver, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MessageDestinationComponent)) {
                return false;
            }
            MessageDestinationComponent o = (MessageDestinationComponent)other_;
            return MessageDestinationComponent.compareValues(this.name, o.name, true) && MessageDestinationComponent.compareValues(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.target, this.endpoint, this.receiver});
        }

        @Override
        public String fhirType() {
            return "MessageHeader.destination";
        }
    }

    public static class ResponseTypeEnumFactory
    implements EnumFactory<ResponseType> {
        @Override
        public ResponseType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return ResponseType.OK;
            }
            if ("transient-error".equals(codeString)) {
                return ResponseType.TRANSIENTERROR;
            }
            if ("fatal-error".equals(codeString)) {
                return ResponseType.FATALERROR;
            }
            throw new IllegalArgumentException("Unknown ResponseType code '" + codeString + "'");
        }

        public Enumeration<ResponseType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResponseType>(this, ResponseType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.NULL, code);
            }
            if ("ok".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.OK, code);
            }
            if ("transient-error".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.TRANSIENTERROR, code);
            }
            if ("fatal-error".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.FATALERROR, code);
            }
            throw new FHIRException("Unknown ResponseType code '" + codeString + "'");
        }

        @Override
        public String toCode(ResponseType code) {
            if (code == ResponseType.NULL) {
                return null;
            }
            if (code == ResponseType.OK) {
                return "ok";
            }
            if (code == ResponseType.TRANSIENTERROR) {
                return "transient-error";
            }
            if (code == ResponseType.FATALERROR) {
                return "fatal-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ResponseType code) {
            return code.getSystem();
        }
    }

    public static enum ResponseType {
        OK,
        TRANSIENTERROR,
        FATALERROR,
        NULL;


        public static ResponseType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return OK;
            }
            if ("transient-error".equals(codeString)) {
                return TRANSIENTERROR;
            }
            if ("fatal-error".equals(codeString)) {
                return FATALERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResponseType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OK: {
                    return "ok";
                }
                case TRANSIENTERROR: {
                    return "transient-error";
                }
                case FATALERROR: {
                    return "fatal-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OK: {
                    return "http://hl7.org/fhir/response-code";
                }
                case TRANSIENTERROR: {
                    return "http://hl7.org/fhir/response-code";
                }
                case FATALERROR: {
                    return "http://hl7.org/fhir/response-code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OK: {
                    return "The message was accepted and processed without error.";
                }
                case TRANSIENTERROR: {
                    return "Some internal unexpected error occurred - wait and try again. Note - this is usually used for things like database unavailable, which may be expected to resolve, though human intervention may be required.";
                }
                case FATALERROR: {
                    return "The message was rejected because of a problem with the content. There is no point in re-sending without change. The response narrative SHALL describe the issue.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OK: {
                    return "OK";
                }
                case TRANSIENTERROR: {
                    return "Transient Error";
                }
                case FATALERROR: {
                    return "Fatal Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

