/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UrlType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImplementationGuide", profile="http://hl7.org/fhir/StructureDefinition/ImplementationGuide")
public class ImplementationGuide
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this implementation guide, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this implementation guide is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the implementation guide is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the implementation guide", formalDefinition="The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this implementation guide (computer friendly)", formalDefinition="A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this implementation guide (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the implementation guide.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this implementation guide. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the implementation guide was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the implementation guide.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the implementation guide", formalDefinition="A free text natural language description of the implementation guide from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate implementation guide instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for implementation guide (if applicable)", formalDefinition="A legal or geographic region in which the implementation guide is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="copyright", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.")
    protected MarkdownType copyright;
    @Child(name="packageId", type={IdType.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="NPM Package name for IG", formalDefinition="The NPM package name for this Implementation Guide, used in the NPM package distribution, which is the primary mechanism by which FHIR based tooling manages IG dependencies. This value must be globally unique, and should be assigned with care.")
    protected IdType packageId;
    @Child(name="license", type={CodeType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="SPDX license code for this IG (or not-open-source)", formalDefinition="The license that applies to this Implementation Guide, using an SPDX license code, or 'not-open-source'.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/spdx-license")
    protected Enumeration<SPDXLicense> license;
    @Child(name="fhirVersion", type={CodeType.class}, order=15, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version(s) this Implementation Guide targets", formalDefinition="The version(s) of the FHIR specification that this ImplementationGuide targets - e.g. describes how to use. The value of this element is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 4.3.0-snapshot1. for this version.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/FHIR-version")
    protected List<Enumeration<Enumerations.FHIRVersion>> fhirVersion;
    @Child(name="dependsOn", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Another Implementation guide this depends on", formalDefinition="Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.")
    protected List<ImplementationGuideDependsOnComponent> dependsOn;
    @Child(name="global", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Profiles that apply globally", formalDefinition="A set of profiles that all resources covered by this implementation guide must conform to.")
    protected List<ImplementationGuideGlobalComponent> global;
    @Child(name="definition", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information needed to build the IG", formalDefinition="The information needed by an IG publisher tool to publish the whole implementation guide.")
    protected ImplementationGuideDefinitionComponent definition;
    @Child(name="manifest", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about an assembled IG", formalDefinition="Information about an assembled implementation guide, created by the publication tooling.")
    protected ImplementationGuideManifestComponent manifest;
    private static final long serialVersionUID = -362658755L;
    @SearchParamDefinition(name="depends-on", path="ImplementationGuide.dependsOn.uri", description="Identity of the IG that this depends on", type="reference", target={ImplementationGuide.class})
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("ImplementationGuide:depends-on").toLocked();
    @SearchParamDefinition(name="experimental", path="ImplementationGuide.experimental", description="For testing purposes, not real usage", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="global", path="ImplementationGuide.global.profile", description="Profile that all resources must conform to", type="reference", target={StructureDefinition.class})
    public static final String SP_GLOBAL = "global";
    public static final ReferenceClientParam GLOBAL = new ReferenceClientParam("global");
    public static final Include INCLUDE_GLOBAL = new Include("ImplementationGuide:global").toLocked();
    @SearchParamDefinition(name="resource", path="ImplementationGuide.definition.resource.reference", description="Location of the resource", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_RESOURCE = "resource";
    public static final ReferenceClientParam RESOURCE = new ReferenceClientParam("resource");
    public static final Include INCLUDE_RESOURCE = new Include("ImplementationGuide:resource").toLocked();
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="CapabilityStatement.title | CodeSystem.title | ConceptMap.title | ImplementationGuide.title | MessageDefinition.title | OperationDefinition.title | StructureDefinition.title | StructureMap.title | TerminologyCapabilities.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ImplementationGuide() {
    }

    public ImplementationGuide(String url, String name, Enumerations.PublicationStatus status, String packageId, Enumerations.FHIRVersion fhirVersion) {
        this.setUrl(url);
        this.setName(name);
        this.setStatus(status);
        this.setPackageId(packageId);
        this.addFhirVersion(fhirVersion);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ImplementationGuide setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ImplementationGuide setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ImplementationGuide setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ImplementationGuide setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ImplementationGuide setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ImplementationGuide setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ImplementationGuide setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ImplementationGuide setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ImplementationGuide setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ImplementationGuide setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ImplementationGuide setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ImplementationGuide setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ImplementationGuide setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ImplementationGuide setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ImplementationGuide setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ImplementationGuide setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ImplementationGuide setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ImplementationGuide setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ImplementationGuide setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ImplementationGuide setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ImplementationGuide setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ImplementationGuide setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ImplementationGuide setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public IdType getPackageIdElement() {
        if (this.packageId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.packageId");
            }
            if (Configuration.doAutoCreate()) {
                this.packageId = new IdType();
            }
        }
        return this.packageId;
    }

    public boolean hasPackageIdElement() {
        return this.packageId != null && !this.packageId.isEmpty();
    }

    public boolean hasPackageId() {
        return this.packageId != null && !this.packageId.isEmpty();
    }

    public ImplementationGuide setPackageIdElement(IdType value) {
        this.packageId = value;
        return this;
    }

    public String getPackageId() {
        return this.packageId == null ? null : this.packageId.getValue();
    }

    public ImplementationGuide setPackageId(String value) {
        if (this.packageId == null) {
            this.packageId = new IdType();
        }
        this.packageId.setValue(value);
        return this;
    }

    public Enumeration<SPDXLicense> getLicenseElement() {
        if (this.license == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.license");
            }
            if (Configuration.doAutoCreate()) {
                this.license = new Enumeration<SPDXLicense>(new SPDXLicenseEnumFactory());
            }
        }
        return this.license;
    }

    public boolean hasLicenseElement() {
        return this.license != null && !this.license.isEmpty();
    }

    public boolean hasLicense() {
        return this.license != null && !this.license.isEmpty();
    }

    public ImplementationGuide setLicenseElement(Enumeration<SPDXLicense> value) {
        this.license = value;
        return this;
    }

    public SPDXLicense getLicense() {
        return this.license == null ? null : (SPDXLicense)((Object)this.license.getValue());
    }

    public ImplementationGuide setLicense(SPDXLicense value) {
        if (value == null) {
            this.license = null;
        } else {
            if (this.license == null) {
                this.license = new Enumeration<SPDXLicense>(new SPDXLicenseEnumFactory());
            }
            this.license.setValue((Object)value);
        }
        return this;
    }

    public List<Enumeration<Enumerations.FHIRVersion>> getFhirVersion() {
        if (this.fhirVersion == null) {
            this.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
        }
        return this.fhirVersion;
    }

    public ImplementationGuide setFhirVersion(List<Enumeration<Enumerations.FHIRVersion>> theFhirVersion) {
        this.fhirVersion = theFhirVersion;
        return this;
    }

    public boolean hasFhirVersion() {
        if (this.fhirVersion == null) {
            return false;
        }
        for (Enumeration<Enumerations.FHIRVersion> item : this.fhirVersion) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.FHIRVersion> addFhirVersionElement() {
        Enumeration<Enumerations.FHIRVersion> t = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
        if (this.fhirVersion == null) {
            this.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
        }
        this.fhirVersion.add(t);
        return t;
    }

    public ImplementationGuide addFhirVersion(Enumerations.FHIRVersion value) {
        Enumeration<Enumerations.FHIRVersion> t = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
        t.setValue((Object)value);
        if (this.fhirVersion == null) {
            this.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
        }
        this.fhirVersion.add(t);
        return this;
    }

    public boolean hasFhirVersion(Enumerations.FHIRVersion value) {
        if (this.fhirVersion == null) {
            return false;
        }
        for (Enumeration<Enumerations.FHIRVersion> v : this.fhirVersion) {
            if (!((Enumerations.FHIRVersion)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public List<ImplementationGuideDependsOnComponent> getDependsOn() {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
        }
        return this.dependsOn;
    }

    public ImplementationGuide setDependsOn(List<ImplementationGuideDependsOnComponent> theDependsOn) {
        this.dependsOn = theDependsOn;
        return this;
    }

    public boolean hasDependsOn() {
        if (this.dependsOn == null) {
            return false;
        }
        for (ImplementationGuideDependsOnComponent item : this.dependsOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideDependsOnComponent addDependsOn() {
        ImplementationGuideDependsOnComponent t = new ImplementationGuideDependsOnComponent();
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
        }
        this.dependsOn.add(t);
        return t;
    }

    public ImplementationGuide addDependsOn(ImplementationGuideDependsOnComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
        }
        this.dependsOn.add(t);
        return this;
    }

    public ImplementationGuideDependsOnComponent getDependsOnFirstRep() {
        if (this.getDependsOn().isEmpty()) {
            this.addDependsOn();
        }
        return this.getDependsOn().get(0);
    }

    public List<ImplementationGuideGlobalComponent> getGlobal() {
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        return this.global;
    }

    public ImplementationGuide setGlobal(List<ImplementationGuideGlobalComponent> theGlobal) {
        this.global = theGlobal;
        return this;
    }

    public boolean hasGlobal() {
        if (this.global == null) {
            return false;
        }
        for (ImplementationGuideGlobalComponent item : this.global) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideGlobalComponent addGlobal() {
        ImplementationGuideGlobalComponent t = new ImplementationGuideGlobalComponent();
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return t;
    }

    public ImplementationGuide addGlobal(ImplementationGuideGlobalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return this;
    }

    public ImplementationGuideGlobalComponent getGlobalFirstRep() {
        if (this.getGlobal().isEmpty()) {
            this.addGlobal();
        }
        return this.getGlobal().get(0);
    }

    public ImplementationGuideDefinitionComponent getDefinition() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new ImplementationGuideDefinitionComponent();
            }
        }
        return this.definition;
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public ImplementationGuide setDefinition(ImplementationGuideDefinitionComponent value) {
        this.definition = value;
        return this;
    }

    public ImplementationGuideManifestComponent getManifest() {
        if (this.manifest == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.manifest");
            }
            if (Configuration.doAutoCreate()) {
                this.manifest = new ImplementationGuideManifestComponent();
            }
        }
        return this.manifest;
    }

    public boolean hasManifest() {
        return this.manifest != null && !this.manifest.isEmpty();
    }

    public ImplementationGuide setManifest(ImplementationGuideManifestComponent value) {
        this.manifest = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this implementation guide is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the implementation guide is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the implementation guide.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this implementation guide. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_EXPERIMENTAL, "boolean", "A Boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the implementation guide was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the implementation guide.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the implementation guide from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate implementation guide instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the implementation guide is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.", 0, 1, this.copyright));
        children.add(new Property("packageId", "id", "The NPM package name for this Implementation Guide, used in the NPM package distribution, which is the primary mechanism by which FHIR based tooling manages IG dependencies. This value must be globally unique, and should be assigned with care.", 0, 1, this.packageId));
        children.add(new Property("license", "code", "The license that applies to this Implementation Guide, using an SPDX license code, or 'not-open-source'.", 0, 1, this.license));
        children.add(new Property("fhirVersion", "code", "The version(s) of the FHIR specification that this ImplementationGuide targets - e.g. describes how to use. The value of this element is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 4.3.0-snapshot1. for this version.", 0, Integer.MAX_VALUE, this.fhirVersion));
        children.add(new Property("dependsOn", "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependsOn));
        children.add(new Property(SP_GLOBAL, "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global));
        children.add(new Property("definition", "", "The information needed by an IG publisher tool to publish the whole implementation guide.", 0, 1, this.definition));
        children.add(new Property("manifest", "", "Information about an assembled implementation guide, created by the publication tooling.", 0, 1, this.manifest));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this implementation guide is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the implementation guide is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the implementation guide.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this implementation guide. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property(SP_EXPERIMENTAL, "boolean", "A Boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the implementation guide was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the implementation guide.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the implementation guide from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate implementation guide instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the implementation guide is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.", 0, 1, this.copyright);
            }
            case 1802060801: {
                return new Property("packageId", "id", "The NPM package name for this Implementation Guide, used in the NPM package distribution, which is the primary mechanism by which FHIR based tooling manages IG dependencies. This value must be globally unique, and should be assigned with care.", 0, 1, this.packageId);
            }
            case 166757441: {
                return new Property("license", "code", "The license that applies to this Implementation Guide, using an SPDX license code, or 'not-open-source'.", 0, 1, this.license);
            }
            case 461006061: {
                return new Property("fhirVersion", "code", "The version(s) of the FHIR specification that this ImplementationGuide targets - e.g. describes how to use. The value of this element is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 4.3.0-snapshot1. for this version.", 0, Integer.MAX_VALUE, this.fhirVersion);
            }
            case -1109214266: {
                return new Property("dependsOn", "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependsOn);
            }
            case -1243020381: {
                return new Property(SP_GLOBAL, "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global);
            }
            case -1014418093: {
                return new Property("definition", "", "The information needed by an IG publisher tool to publish the whole implementation guide.", 0, 1, this.definition);
            }
            case 130625071: {
                return new Property("manifest", "", "Information about an assembled implementation guide, created by the publication tooling.", 0, 1, this.manifest);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyright;
                }
                return baseArray;
            }
            case 1802060801: {
                Base[] baseArray;
                if (this.packageId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.packageId;
                }
                return baseArray;
            }
            case 166757441: {
                Base[] baseArray;
                if (this.license == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.license;
                }
                return baseArray;
            }
            case 461006061: {
                return this.fhirVersion == null ? new Base[]{} : this.fhirVersion.toArray(new Base[this.fhirVersion.size()]);
            }
            case -1109214266: {
                return this.dependsOn == null ? new Base[]{} : this.dependsOn.toArray(new Base[this.dependsOn.size()]);
            }
            case -1243020381: {
                return this.global == null ? new Base[]{} : this.global.toArray(new Base[this.global.size()]);
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.definition;
                }
                return baseArray;
            }
            case 130625071: {
                Base[] baseArray;
                if (this.manifest == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.manifest;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1802060801: {
                this.packageId = TypeConvertor.castToId(value);
                return value;
            }
            case 166757441: {
                value = new SPDXLicenseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.license = value;
                return value;
            }
            case 461006061: {
                value = new Enumerations.FHIRVersionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getFhirVersion().add(value);
                return value;
            }
            case -1109214266: {
                this.getDependsOn().add((ImplementationGuideDependsOnComponent)((Object)value));
                return value;
            }
            case -1243020381: {
                this.getGlobal().add((ImplementationGuideGlobalComponent)((Object)value));
                return value;
            }
            case -1014418093: {
                this.definition = (ImplementationGuideDefinitionComponent)((Object)value);
                return value;
            }
            case 130625071: {
                this.manifest = (ImplementationGuideManifestComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("packageId")) {
            this.packageId = TypeConvertor.castToId(value);
        } else if (name.equals("license")) {
            value = new SPDXLicenseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.license = value;
        } else if (name.equals("fhirVersion")) {
            value = new Enumerations.FHIRVersionEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getFhirVersion().add(value);
        } else if (name.equals("dependsOn")) {
            this.getDependsOn().add((ImplementationGuideDependsOnComponent)((Object)value));
        } else if (name.equals(SP_GLOBAL)) {
            this.getGlobal().add((ImplementationGuideGlobalComponent)((Object)value));
        } else if (name.equals("definition")) {
            this.definition = (ImplementationGuideDefinitionComponent)((Object)value);
        } else if (name.equals("manifest")) {
            this.manifest = (ImplementationGuideManifestComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("packageId")) {
            this.packageId = null;
        } else if (name.equals("license")) {
            this.license = null;
        } else if (name.equals("fhirVersion")) {
            this.getFhirVersion().remove((Enumeration)value);
        } else if (name.equals("dependsOn")) {
            this.getDependsOn().remove((ImplementationGuideDependsOnComponent)value);
        } else if (name.equals(SP_GLOBAL)) {
            this.getGlobal().remove((ImplementationGuideGlobalComponent)value);
        } else if (name.equals("definition")) {
            this.definition = null;
        } else if (name.equals("manifest")) {
            this.manifest = (ImplementationGuideManifestComponent)value;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 1802060801: {
                return this.getPackageIdElement();
            }
            case 166757441: {
                return this.getLicenseElement();
            }
            case 461006061: {
                return this.addFhirVersionElement();
            }
            case -1109214266: {
                return this.addDependsOn();
            }
            case -1243020381: {
                return this.addGlobal();
            }
            case -1014418093: {
                return this.getDefinition();
            }
            case 130625071: {
                return this.getManifest();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 1802060801: {
                return new String[]{"id"};
            }
            case 166757441: {
                return new String[]{"code"};
            }
            case 461006061: {
                return new String[]{"code"};
            }
            case -1109214266: {
                return new String[0];
            }
            case -1243020381: {
                return new String[0];
            }
            case -1014418093: {
                return new String[0];
            }
            case 130625071: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.copyright");
        }
        if (name.equals("packageId")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.packageId");
        }
        if (name.equals("license")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.license");
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.fhirVersion");
        }
        if (name.equals("dependsOn")) {
            return this.addDependsOn();
        }
        if (name.equals(SP_GLOBAL)) {
            return this.addGlobal();
        }
        if (name.equals("definition")) {
            this.definition = new ImplementationGuideDefinitionComponent();
            return this.definition;
        }
        if (name.equals("manifest")) {
            this.manifest = new ImplementationGuideManifestComponent();
            return this.manifest;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImplementationGuide";
    }

    @Override
    public ImplementationGuide copy() {
        ImplementationGuide dst = new ImplementationGuide();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImplementationGuide dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.packageId = this.packageId == null ? null : this.packageId.copy();
        Enumeration<SPDXLicense> enumeration = dst.license = this.license == null ? null : this.license.copy();
        if (this.fhirVersion != null) {
            dst.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
            for (Enumeration enumeration2 : this.fhirVersion) {
                dst.fhirVersion.add((Enumeration<Enumerations.FHIRVersion>)enumeration2.copy());
            }
        }
        if (this.dependsOn != null) {
            dst.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
            for (ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : this.dependsOn) {
                dst.dependsOn.add(implementationGuideDependsOnComponent.copy());
            }
        }
        if (this.global != null) {
            dst.global = new ArrayList<ImplementationGuideGlobalComponent>();
            for (ImplementationGuideGlobalComponent implementationGuideGlobalComponent : this.global) {
                dst.global.add(implementationGuideGlobalComponent.copy());
            }
        }
        dst.definition = this.definition == null ? null : this.definition.copy();
        dst.manifest = this.manifest == null ? null : this.manifest.copy();
    }

    protected ImplementationGuide typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other_;
        return ImplementationGuide.compareDeep(this.url, o.url, true) && ImplementationGuide.compareDeep(this.version, o.version, true) && ImplementationGuide.compareDeep(this.name, o.name, true) && ImplementationGuide.compareDeep(this.title, o.title, true) && ImplementationGuide.compareDeep(this.status, o.status, true) && ImplementationGuide.compareDeep(this.experimental, o.experimental, true) && ImplementationGuide.compareDeep(this.date, o.date, true) && ImplementationGuide.compareDeep(this.publisher, o.publisher, true) && ImplementationGuide.compareDeep(this.contact, o.contact, true) && ImplementationGuide.compareDeep(this.description, o.description, true) && ImplementationGuide.compareDeep(this.useContext, o.useContext, true) && ImplementationGuide.compareDeep(this.jurisdiction, o.jurisdiction, true) && ImplementationGuide.compareDeep(this.copyright, o.copyright, true) && ImplementationGuide.compareDeep(this.packageId, o.packageId, true) && ImplementationGuide.compareDeep(this.license, o.license, true) && ImplementationGuide.compareDeep(this.fhirVersion, o.fhirVersion, true) && ImplementationGuide.compareDeep(this.dependsOn, o.dependsOn, true) && ImplementationGuide.compareDeep(this.global, o.global, true) && ImplementationGuide.compareDeep(this.definition, o.definition, true) && ImplementationGuide.compareDeep(this.manifest, o.manifest, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other_;
        return ImplementationGuide.compareValues(this.url, o.url, true) && ImplementationGuide.compareValues(this.version, o.version, true) && ImplementationGuide.compareValues(this.name, o.name, true) && ImplementationGuide.compareValues(this.title, o.title, true) && ImplementationGuide.compareValues(this.status, o.status, true) && ImplementationGuide.compareValues(this.experimental, o.experimental, true) && ImplementationGuide.compareValues(this.date, o.date, true) && ImplementationGuide.compareValues(this.publisher, o.publisher, true) && ImplementationGuide.compareValues(this.description, o.description, true) && ImplementationGuide.compareValues(this.copyright, o.copyright, true) && ImplementationGuide.compareValues(this.packageId, o.packageId, true) && ImplementationGuide.compareValues(this.license, o.license, true) && ImplementationGuide.compareValues(this.fhirVersion, o.fhirVersion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.copyright, this.packageId, this.license, this.fhirVersion, this.dependsOn, this.global, this.definition, this.manifest});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImplementationGuide;
    }

    @Override
    public String getPurpose() {
        return new String();
    }

    @Override
    public MarkdownType getPurposeElement() {
        return new MarkdownType();
    }

    @Override
    public CanonicalResource setPurpose(String thePurpose) {
        return this;
    }

    @Override
    public CanonicalResource setPurposeElement(MarkdownType thePurpose) {
        return this;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public List<Identifier> getIdentifier() {
        return new ArrayList<Identifier>();
    }

    @Override
    public CanonicalResource setIdentifier(List<Identifier> theIdentifier) {
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        return null;
    }

    @Override
    public CanonicalResource addIdentifier(Identifier t) {
        return null;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        return new Identifier();
    }

    @Block
    public static class ManifestPageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTML page name", formalDefinition="Relative path to the page.")
        protected StringType name;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Title of the page, for references", formalDefinition="Label for the page intended for human display.")
        protected StringType title;
        @Child(name="anchor", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Anchor available on the page", formalDefinition="The name of an anchor available on the page.")
        protected List<StringType> anchor;
        private static final long serialVersionUID = 1920576611L;

        public ManifestPageComponent() {
        }

        public ManifestPageComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManifestPageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ManifestPageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ManifestPageComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManifestPageComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ManifestPageComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ManifestPageComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public List<StringType> getAnchor() {
            if (this.anchor == null) {
                this.anchor = new ArrayList<StringType>();
            }
            return this.anchor;
        }

        public ManifestPageComponent setAnchor(List<StringType> theAnchor) {
            this.anchor = theAnchor;
            return this;
        }

        public boolean hasAnchor() {
            if (this.anchor == null) {
                return false;
            }
            for (StringType item : this.anchor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addAnchorElement() {
            StringType t = new StringType();
            if (this.anchor == null) {
                this.anchor = new ArrayList<StringType>();
            }
            this.anchor.add(t);
            return t;
        }

        public ManifestPageComponent addAnchor(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.anchor == null) {
                this.anchor = new ArrayList<StringType>();
            }
            this.anchor.add(t);
            return this;
        }

        public boolean hasAnchor(String value) {
            if (this.anchor == null) {
                return false;
            }
            for (StringType v : this.anchor) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "Relative path to the page.", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_TITLE, "string", "Label for the page intended for human display.", 0, 1, this.title));
            children.add(new Property("anchor", "string", "The name of an anchor available on the page.", 0, Integer.MAX_VALUE, this.anchor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "Relative path to the page.", 0, 1, this.name);
                }
                case 110371416: {
                    return new Property(ImplementationGuide.SP_TITLE, "string", "Label for the page intended for human display.", 0, 1, this.title);
                }
                case -1413299531: {
                    return new Property("anchor", "string", "The name of an anchor available on the page.", 0, Integer.MAX_VALUE, this.anchor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case -1413299531: {
                    return this.anchor == null ? new Base[]{} : this.anchor.toArray(new Base[this.anchor.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1413299531: {
                    this.getAnchor().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("anchor")) {
                this.getAnchor().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = null;
            } else if (name.equals(ImplementationGuide.SP_TITLE)) {
                this.title = null;
            } else if (name.equals("anchor")) {
                this.getAnchor().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1413299531: {
                    return this.addAnchorElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1413299531: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.page.name");
            }
            if (name.equals(ImplementationGuide.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.page.title");
            }
            if (name.equals("anchor")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.page.anchor");
            }
            return super.addChild(name);
        }

        @Override
        public ManifestPageComponent copy() {
            ManifestPageComponent dst = new ManifestPageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManifestPageComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.title = this.title == null ? null : this.title.copy();
            if (this.anchor != null) {
                dst.anchor = new ArrayList<StringType>();
                for (StringType i : this.anchor) {
                    dst.anchor.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManifestPageComponent)) {
                return false;
            }
            ManifestPageComponent o = (ManifestPageComponent)other_;
            return ManifestPageComponent.compareDeep(this.name, o.name, true) && ManifestPageComponent.compareDeep(this.title, o.title, true) && ManifestPageComponent.compareDeep(this.anchor, o.anchor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManifestPageComponent)) {
                return false;
            }
            ManifestPageComponent o = (ManifestPageComponent)other_;
            return ManifestPageComponent.compareValues(this.name, o.name, true) && ManifestPageComponent.compareValues(this.title, o.title, true) && ManifestPageComponent.compareValues(this.anchor, o.anchor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.title, this.anchor});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.manifest.page";
        }
    }

    @Block
    public static class ManifestResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Reference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of the resource", formalDefinition="Where this resource is found.")
        protected Reference reference;
        @Child(name="example", type={BooleanType.class, CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is an example/What is this an example of?", formalDefinition="If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.")
        protected DataType example;
        @Child(name="relativePath", type={UrlType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relative path for page in IG", formalDefinition="The relative path for primary page for this resource within the IG.")
        protected UrlType relativePath;
        private static final long serialVersionUID = 956753658L;

        public ManifestResourceComponent() {
        }

        public ManifestResourceComponent(Reference reference) {
            this.setReference(reference);
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManifestResourceComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ManifestResourceComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public DataType getExample() {
            return this.example;
        }

        public BooleanType getExampleBooleanType() throws FHIRException {
            if (this.example == null) {
                this.example = new BooleanType();
            }
            if (!(this.example instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.example;
        }

        public boolean hasExampleBooleanType() {
            return this != null && this.example instanceof BooleanType;
        }

        public CanonicalType getExampleCanonicalType() throws FHIRException {
            if (this.example == null) {
                this.example = new CanonicalType();
            }
            if (!(this.example instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.example;
        }

        public boolean hasExampleCanonicalType() {
            return this != null && this.example instanceof CanonicalType;
        }

        public boolean hasExample() {
            return this.example != null && !this.example.isEmpty();
        }

        public ManifestResourceComponent setExample(DataType value) {
            if (value != null && !(value instanceof BooleanType) && !(value instanceof CanonicalType)) {
                throw new Error("Not the right type for ImplementationGuide.manifest.resource.example[x]: " + value.fhirType());
            }
            this.example = value;
            return this;
        }

        public UrlType getRelativePathElement() {
            if (this.relativePath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManifestResourceComponent.relativePath");
                }
                if (Configuration.doAutoCreate()) {
                    this.relativePath = new UrlType();
                }
            }
            return this.relativePath;
        }

        public boolean hasRelativePathElement() {
            return this.relativePath != null && !this.relativePath.isEmpty();
        }

        public boolean hasRelativePath() {
            return this.relativePath != null && !this.relativePath.isEmpty();
        }

        public ManifestResourceComponent setRelativePathElement(UrlType value) {
            this.relativePath = value;
            return this;
        }

        public String getRelativePath() {
            return this.relativePath == null ? null : (String)this.relativePath.getValue();
        }

        public ManifestResourceComponent setRelativePath(String value) {
            if (Utilities.noString((String)value)) {
                this.relativePath = null;
            } else {
                if (this.relativePath == null) {
                    this.relativePath = new UrlType();
                }
                this.relativePath.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference));
            children.add(new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example));
            children.add(new Property("relativePath", ImplementationGuide.SP_URL, "The relative path for primary page for this resource within the IG.", 0, 1, this.relativePath));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference);
                }
                case -2002328874: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -1322970774: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 159803230: {
                    return new Property("example[x]", "boolean", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 2016979626: {
                    return new Property("example[x]", "canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -70808303: {
                    return new Property("relativePath", ImplementationGuide.SP_URL, "The relative path for primary page for this resource within the IG.", 0, 1, this.relativePath);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case -1322970774: {
                    Base[] baseArray;
                    if (this.example == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.example;
                    }
                    return baseArray;
                }
                case -70808303: {
                    Base[] baseArray;
                    if (this.relativePath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relativePath;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1322970774: {
                    this.example = TypeConvertor.castToType(value);
                    return value;
                }
                case -70808303: {
                    this.relativePath = TypeConvertor.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else if (name.equals("example[x]")) {
                this.example = TypeConvertor.castToType(value);
            } else if (name.equals("relativePath")) {
                this.relativePath = TypeConvertor.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = null;
            } else if (name.equals("example[x]")) {
                this.example = null;
            } else if (name.equals("relativePath")) {
                this.relativePath = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case -2002328874: {
                    return this.getExample();
                }
                case -1322970774: {
                    return this.getExample();
                }
                case -70808303: {
                    return this.getRelativePathElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case -1322970774: {
                    return new String[]{"boolean", "canonical"};
                }
                case -70808303: {
                    return new String[]{ImplementationGuide.SP_URL};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("exampleBoolean")) {
                this.example = new BooleanType();
                return this.example;
            }
            if (name.equals("exampleCanonical")) {
                this.example = new CanonicalType();
                return this.example;
            }
            if (name.equals("relativePath")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.resource.relativePath");
            }
            return super.addChild(name);
        }

        @Override
        public ManifestResourceComponent copy() {
            ManifestResourceComponent dst = new ManifestResourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManifestResourceComponent dst) {
            super.copyValues(dst);
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.example = this.example == null ? null : this.example.copy();
            dst.relativePath = this.relativePath == null ? null : this.relativePath.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManifestResourceComponent)) {
                return false;
            }
            ManifestResourceComponent o = (ManifestResourceComponent)other_;
            return ManifestResourceComponent.compareDeep(this.reference, o.reference, true) && ManifestResourceComponent.compareDeep(this.example, o.example, true) && ManifestResourceComponent.compareDeep(this.relativePath, o.relativePath, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManifestResourceComponent)) {
                return false;
            }
            ManifestResourceComponent o = (ManifestResourceComponent)other_;
            return ManifestResourceComponent.compareValues(this.relativePath, o.relativePath, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.reference, this.example, this.relativePath});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.manifest.resource";
        }
    }

    @Block
    public static class ImplementationGuideManifestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="rendering", type={UrlType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of rendered implementation guide", formalDefinition="A pointer to official web page, PDF or other rendering of the implementation guide.")
        protected UrlType rendering;
        @Child(name="resource", type={}, order=2, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource in the implementation guide", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.")
        protected List<ManifestResourceComponent> resource;
        @Child(name="page", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="HTML page within the parent IG", formalDefinition="Information about a page within the IG.")
        protected List<ManifestPageComponent> page;
        @Child(name="image", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Image within the IG", formalDefinition="Indicates a relative path to an image that exists within the IG.")
        protected List<StringType> image;
        @Child(name="other", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional linkable file in IG", formalDefinition="Indicates the relative path of an additional non-page, non-image file that is part of the IG - e.g. zip, jar and similar files that could be the target of a hyperlink in a derived IG.")
        protected List<StringType> other;
        private static final long serialVersionUID = 1881327712L;

        public ImplementationGuideManifestComponent() {
        }

        public ImplementationGuideManifestComponent(ManifestResourceComponent resource) {
            this.addResource(resource);
        }

        public UrlType getRenderingElement() {
            if (this.rendering == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideManifestComponent.rendering");
                }
                if (Configuration.doAutoCreate()) {
                    this.rendering = new UrlType();
                }
            }
            return this.rendering;
        }

        public boolean hasRenderingElement() {
            return this.rendering != null && !this.rendering.isEmpty();
        }

        public boolean hasRendering() {
            return this.rendering != null && !this.rendering.isEmpty();
        }

        public ImplementationGuideManifestComponent setRenderingElement(UrlType value) {
            this.rendering = value;
            return this;
        }

        public String getRendering() {
            return this.rendering == null ? null : (String)this.rendering.getValue();
        }

        public ImplementationGuideManifestComponent setRendering(String value) {
            if (Utilities.noString((String)value)) {
                this.rendering = null;
            } else {
                if (this.rendering == null) {
                    this.rendering = new UrlType();
                }
                this.rendering.setValue(value);
            }
            return this;
        }

        public List<ManifestResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ManifestResourceComponent>();
            }
            return this.resource;
        }

        public ImplementationGuideManifestComponent setResource(List<ManifestResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ManifestResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ManifestResourceComponent addResource() {
            ManifestResourceComponent t = new ManifestResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ManifestResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addResource(ManifestResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ManifestResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public ManifestResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<ManifestPageComponent> getPage() {
            if (this.page == null) {
                this.page = new ArrayList<ManifestPageComponent>();
            }
            return this.page;
        }

        public ImplementationGuideManifestComponent setPage(List<ManifestPageComponent> thePage) {
            this.page = thePage;
            return this;
        }

        public boolean hasPage() {
            if (this.page == null) {
                return false;
            }
            for (ManifestPageComponent item : this.page) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ManifestPageComponent addPage() {
            ManifestPageComponent t = new ManifestPageComponent();
            if (this.page == null) {
                this.page = new ArrayList<ManifestPageComponent>();
            }
            this.page.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addPage(ManifestPageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.page == null) {
                this.page = new ArrayList<ManifestPageComponent>();
            }
            this.page.add(t);
            return this;
        }

        public ManifestPageComponent getPageFirstRep() {
            if (this.getPage().isEmpty()) {
                this.addPage();
            }
            return this.getPage().get(0);
        }

        public List<StringType> getImage() {
            if (this.image == null) {
                this.image = new ArrayList<StringType>();
            }
            return this.image;
        }

        public ImplementationGuideManifestComponent setImage(List<StringType> theImage) {
            this.image = theImage;
            return this;
        }

        public boolean hasImage() {
            if (this.image == null) {
                return false;
            }
            for (StringType item : this.image) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addImageElement() {
            StringType t = new StringType();
            if (this.image == null) {
                this.image = new ArrayList<StringType>();
            }
            this.image.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addImage(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.image == null) {
                this.image = new ArrayList<StringType>();
            }
            this.image.add(t);
            return this;
        }

        public boolean hasImage(String value) {
            if (this.image == null) {
                return false;
            }
            for (StringType v : this.image) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getOther() {
            if (this.other == null) {
                this.other = new ArrayList<StringType>();
            }
            return this.other;
        }

        public ImplementationGuideManifestComponent setOther(List<StringType> theOther) {
            this.other = theOther;
            return this;
        }

        public boolean hasOther() {
            if (this.other == null) {
                return false;
            }
            for (StringType item : this.other) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addOtherElement() {
            StringType t = new StringType();
            if (this.other == null) {
                this.other = new ArrayList<StringType>();
            }
            this.other.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addOther(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.other == null) {
                this.other = new ArrayList<StringType>();
            }
            this.other.add(t);
            return this;
        }

        public boolean hasOther(String value) {
            if (this.other == null) {
                return false;
            }
            for (StringType v : this.other) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("rendering", ImplementationGuide.SP_URL, "A pointer to official web page, PDF or other rendering of the implementation guide.", 0, 1, this.rendering));
            children.add(new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("page", "", "Information about a page within the IG.", 0, Integer.MAX_VALUE, this.page));
            children.add(new Property("image", "string", "Indicates a relative path to an image that exists within the IG.", 0, Integer.MAX_VALUE, this.image));
            children.add(new Property("other", "string", "Indicates the relative path of an additional non-page, non-image file that is part of the IG - e.g. zip, jar and similar files that could be the target of a hyperlink in a derived IG.", 0, Integer.MAX_VALUE, this.other));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1839654540: {
                    return new Property("rendering", ImplementationGuide.SP_URL, "A pointer to official web page, PDF or other rendering of the implementation guide.", 0, 1, this.rendering);
                }
                case -341064690: {
                    return new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 3433103: {
                    return new Property("page", "", "Information about a page within the IG.", 0, Integer.MAX_VALUE, this.page);
                }
                case 100313435: {
                    return new Property("image", "string", "Indicates a relative path to an image that exists within the IG.", 0, Integer.MAX_VALUE, this.image);
                }
                case 106069776: {
                    return new Property("other", "string", "Indicates the relative path of an additional non-page, non-image file that is part of the IG - e.g. zip, jar and similar files that could be the target of a hyperlink in a derived IG.", 0, Integer.MAX_VALUE, this.other);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    Base[] baseArray;
                    if (this.rendering == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.rendering;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 3433103: {
                    return this.page == null ? new Base[]{} : this.page.toArray(new Base[this.page.size()]);
                }
                case 100313435: {
                    return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
                }
                case 106069776: {
                    return this.other == null ? new Base[]{} : this.other.toArray(new Base[this.other.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    this.rendering = TypeConvertor.castToUrl(value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((ManifestResourceComponent)value);
                    return value;
                }
                case 3433103: {
                    this.getPage().add((ManifestPageComponent)value);
                    return value;
                }
                case 100313435: {
                    this.getImage().add(TypeConvertor.castToString(value));
                    return value;
                }
                case 106069776: {
                    this.getOther().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("rendering")) {
                this.rendering = TypeConvertor.castToUrl(value);
            } else if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                this.getResource().add((ManifestResourceComponent)value);
            } else if (name.equals("page")) {
                this.getPage().add((ManifestPageComponent)value);
            } else if (name.equals("image")) {
                this.getImage().add(TypeConvertor.castToString(value));
            } else if (name.equals("other")) {
                this.getOther().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("rendering")) {
                this.rendering = null;
            } else if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                this.getResource().remove((ManifestResourceComponent)value);
            } else if (name.equals("page")) {
                this.getPage().remove((ManifestPageComponent)value);
            } else if (name.equals("image")) {
                this.getImage().remove(value);
            } else if (name.equals("other")) {
                this.getOther().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    return this.getRenderingElement();
                }
                case -341064690: {
                    return this.addResource();
                }
                case 3433103: {
                    return this.addPage();
                }
                case 100313435: {
                    return this.addImageElement();
                }
                case 106069776: {
                    return this.addOtherElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    return new String[]{ImplementationGuide.SP_URL};
                }
                case -341064690: {
                    return new String[0];
                }
                case 3433103: {
                    return new String[0];
                }
                case 100313435: {
                    return new String[]{"string"};
                }
                case 106069776: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("rendering")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.rendering");
            }
            if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                return this.addResource();
            }
            if (name.equals("page")) {
                return this.addPage();
            }
            if (name.equals("image")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.image");
            }
            if (name.equals("other")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.manifest.other");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideManifestComponent copy() {
            ImplementationGuideManifestComponent dst = new ImplementationGuideManifestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideManifestComponent dst) {
            super.copyValues(dst);
            UrlType urlType = dst.rendering = this.rendering == null ? null : this.rendering.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<ManifestResourceComponent>();
                for (ManifestResourceComponent manifestResourceComponent : this.resource) {
                    dst.resource.add(manifestResourceComponent.copy());
                }
            }
            if (this.page != null) {
                dst.page = new ArrayList<ManifestPageComponent>();
                for (ManifestPageComponent manifestPageComponent : this.page) {
                    dst.page.add(manifestPageComponent.copy());
                }
            }
            if (this.image != null) {
                dst.image = new ArrayList<StringType>();
                for (StringType stringType : this.image) {
                    dst.image.add(stringType.copy());
                }
            }
            if (this.other != null) {
                dst.other = new ArrayList<StringType>();
                for (StringType stringType : this.other) {
                    dst.other.add(stringType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestComponent)) {
                return false;
            }
            ImplementationGuideManifestComponent o = (ImplementationGuideManifestComponent)other_;
            return ImplementationGuideManifestComponent.compareDeep(this.rendering, o.rendering, true) && ImplementationGuideManifestComponent.compareDeep(this.resource, o.resource, true) && ImplementationGuideManifestComponent.compareDeep(this.page, o.page, true) && ImplementationGuideManifestComponent.compareDeep(this.image, o.image, true) && ImplementationGuideManifestComponent.compareDeep(this.other, o.other, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestComponent)) {
                return false;
            }
            ImplementationGuideManifestComponent o = (ImplementationGuideManifestComponent)other_;
            return ImplementationGuideManifestComponent.compareValues(this.rendering, o.rendering, true) && ImplementationGuideManifestComponent.compareValues(this.image, o.image, true) && ImplementationGuideManifestComponent.compareValues(this.other, o.other, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.rendering, this.resource, this.page, this.image, this.other});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.manifest";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionTemplateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of template specified", formalDefinition="Type of template specified.")
        protected CodeType code;
        @Child(name="source", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source location for the template", formalDefinition="The source location for the template.")
        protected StringType source;
        @Child(name="scope", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The scope in which the template applies", formalDefinition="The scope in which the template applies.")
        protected StringType scope;
        private static final long serialVersionUID = 923832457L;

        public ImplementationGuideDefinitionTemplateComponent() {
        }

        public ImplementationGuideDefinitionTemplateComponent(String code, String source) {
            this.setCode(code);
            this.setSource(source);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionTemplateComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImplementationGuideDefinitionTemplateComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ImplementationGuideDefinitionTemplateComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionTemplateComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ImplementationGuideDefinitionTemplateComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ImplementationGuideDefinitionTemplateComponent setSource(String value) {
            if (this.source == null) {
                this.source = new StringType();
            }
            this.source.setValue(value);
            return this;
        }

        public StringType getScopeElement() {
            if (this.scope == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionTemplateComponent.scope");
                }
                if (Configuration.doAutoCreate()) {
                    this.scope = new StringType();
                }
            }
            return this.scope;
        }

        public boolean hasScopeElement() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public boolean hasScope() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public ImplementationGuideDefinitionTemplateComponent setScopeElement(StringType value) {
            this.scope = value;
            return this;
        }

        public String getScope() {
            return this.scope == null ? null : (String)this.scope.getValue();
        }

        public ImplementationGuideDefinitionTemplateComponent setScope(String value) {
            if (Utilities.noString((String)value)) {
                this.scope = null;
            } else {
                if (this.scope == null) {
                    this.scope = new StringType();
                }
                this.scope.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Type of template specified.", 0, 1, this.code));
            children.add(new Property("source", "string", "The source location for the template.", 0, 1, this.source));
            children.add(new Property("scope", "string", "The scope in which the template applies.", 0, 1, this.scope));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Type of template specified.", 0, 1, this.code);
                }
                case -896505829: {
                    return new Property("source", "string", "The source location for the template.", 0, 1, this.source);
                }
                case 109264468: {
                    return new Property("scope", "string", "The scope in which the template applies.", 0, 1, this.scope);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 109264468: {
                    Base[] baseArray;
                    if (this.scope == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.scope;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToString(value);
                    return value;
                }
                case 109264468: {
                    this.scope = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToString(value);
            } else if (name.equals("scope")) {
                this.scope = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("source")) {
                this.source = null;
            } else if (name.equals("scope")) {
                this.scope = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
                case 109264468: {
                    return this.getScopeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -896505829: {
                    return new String[]{"string"};
                }
                case 109264468: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.template.code");
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.template.source");
            }
            if (name.equals("scope")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.template.scope");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionTemplateComponent copy() {
            ImplementationGuideDefinitionTemplateComponent dst = new ImplementationGuideDefinitionTemplateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDefinitionTemplateComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.scope = this.scope == null ? null : this.scope.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionTemplateComponent)) {
                return false;
            }
            ImplementationGuideDefinitionTemplateComponent o = (ImplementationGuideDefinitionTemplateComponent)other_;
            return ImplementationGuideDefinitionTemplateComponent.compareDeep(this.code, o.code, true) && ImplementationGuideDefinitionTemplateComponent.compareDeep(this.source, o.source, true) && ImplementationGuideDefinitionTemplateComponent.compareDeep(this.scope, o.scope, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionTemplateComponent)) {
                return false;
            }
            ImplementationGuideDefinitionTemplateComponent o = (ImplementationGuideDefinitionTemplateComponent)other_;
            return ImplementationGuideDefinitionTemplateComponent.compareValues(this.code, o.code, true) && ImplementationGuideDefinitionTemplateComponent.compareValues(this.source, o.source, true) && ImplementationGuideDefinitionTemplateComponent.compareValues(this.scope, o.scope, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.source, this.scope});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.template";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="apply | path-resource | path-pages | path-tx-cache | expansion-parameter | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template", formalDefinition="apply | path-resource | path-pages | path-tx-cache | expansion-parameter | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template.")
        protected StringType code;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value for named type", formalDefinition="Value for named type.")
        protected StringType value;
        private static final long serialVersionUID = 1188999138L;

        public ImplementationGuideDefinitionParameterComponent() {
        }

        public ImplementationGuideDefinitionParameterComponent(StringType code, StringType value) {
            this.code = code;
            this.value = value;
        }

        public StringType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionParameterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new StringType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImplementationGuideDefinitionParameterComponent setCodeElement(StringType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ImplementationGuideDefinitionParameterComponent setCode(String value) {
            if (this.code == null) {
                this.code = new StringType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionParameterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ImplementationGuideDefinitionParameterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ImplementationGuideDefinitionParameterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "string", "apply | path-resource | path-pages | path-tx-cache | expansion-parameter | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template.", 0, 1, this.code));
            children.add(new Property("value", "string", "Value for named type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "string", "apply | path-resource | path-pages | path-tx-cache | expansion-parameter | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "string", "Value for named type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToString(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.parameter.code");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.parameter.value");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionParameterComponent copy() {
            ImplementationGuideDefinitionParameterComponent dst = new ImplementationGuideDefinitionParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDefinitionParameterComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionParameterComponent)) {
                return false;
            }
            ImplementationGuideDefinitionParameterComponent o = (ImplementationGuideDefinitionParameterComponent)other_;
            return ImplementationGuideDefinitionParameterComponent.compareDeep(this.code, o.code, true) && ImplementationGuideDefinitionParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionParameterComponent)) {
                return false;
            }
            ImplementationGuideDefinitionParameterComponent o = (ImplementationGuideDefinitionParameterComponent)other_;
            return ImplementationGuideDefinitionParameterComponent.compareValues(this.code, o.code, true) && ImplementationGuideDefinitionParameterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.parameter";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionPageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={UrlType.class, Binary.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where to find that page", formalDefinition="The source address for the page.")
        protected DataType name;
        @Child(name="title", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short title shown for navigational assistance", formalDefinition="A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.")
        protected StringType title;
        @Child(name="generation", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="html | markdown | xml | generated", formalDefinition="A code that indicates how the page is generated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/guide-page-generation")
        protected Enumeration<GuidePageGeneration> generation;
        @Child(name="page", type={ImplementationGuideDefinitionPageComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Pages / Sections", formalDefinition="Nested Pages/Sections under this page.")
        protected List<ImplementationGuideDefinitionPageComponent> page;
        private static final long serialVersionUID = -2100991860L;

        public ImplementationGuideDefinitionPageComponent() {
        }

        public ImplementationGuideDefinitionPageComponent(DataType name, String title, GuidePageGeneration generation) {
            this.setName(name);
            this.setTitle(title);
            this.setGeneration(generation);
        }

        public DataType getName() {
            return this.name;
        }

        public UrlType getNameUrlType() throws FHIRException {
            if (this.name == null) {
                this.name = new UrlType();
            }
            if (!(this.name instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.name.getClass().getName() + " was encountered");
            }
            return (UrlType)this.name;
        }

        public boolean hasNameUrlType() {
            return this != null && this.name instanceof UrlType;
        }

        public Reference getNameReference() throws FHIRException {
            if (this.name == null) {
                this.name = new Reference();
            }
            if (!(this.name instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.name.getClass().getName() + " was encountered");
            }
            return (Reference)this.name;
        }

        public boolean hasNameReference() {
            return this != null && this.name instanceof Reference;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideDefinitionPageComponent setName(DataType value) {
            if (value != null && !(value instanceof UrlType) && !(value instanceof Reference)) {
                throw new Error("Not the right type for ImplementationGuide.definition.page.name[x]: " + value.fhirType());
            }
            this.name = value;
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionPageComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImplementationGuideDefinitionPageComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImplementationGuideDefinitionPageComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public Enumeration<GuidePageGeneration> getGenerationElement() {
            if (this.generation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionPageComponent.generation");
                }
                if (Configuration.doAutoCreate()) {
                    this.generation = new Enumeration<GuidePageGeneration>(new GuidePageGenerationEnumFactory());
                }
            }
            return this.generation;
        }

        public boolean hasGenerationElement() {
            return this.generation != null && !this.generation.isEmpty();
        }

        public boolean hasGeneration() {
            return this.generation != null && !this.generation.isEmpty();
        }

        public ImplementationGuideDefinitionPageComponent setGenerationElement(Enumeration<GuidePageGeneration> value) {
            this.generation = value;
            return this;
        }

        public GuidePageGeneration getGeneration() {
            return this.generation == null ? null : (GuidePageGeneration)((Object)this.generation.getValue());
        }

        public ImplementationGuideDefinitionPageComponent setGeneration(GuidePageGeneration value) {
            if (this.generation == null) {
                this.generation = new Enumeration<GuidePageGeneration>(new GuidePageGenerationEnumFactory());
            }
            this.generation.setValue((Object)value);
            return this;
        }

        public List<ImplementationGuideDefinitionPageComponent> getPage() {
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
            }
            return this.page;
        }

        public ImplementationGuideDefinitionPageComponent setPage(List<ImplementationGuideDefinitionPageComponent> thePage) {
            this.page = thePage;
            return this;
        }

        public boolean hasPage() {
            if (this.page == null) {
                return false;
            }
            for (ImplementationGuideDefinitionPageComponent item : this.page) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionPageComponent addPage() {
            ImplementationGuideDefinitionPageComponent t = new ImplementationGuideDefinitionPageComponent();
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
            }
            this.page.add(t);
            return t;
        }

        public ImplementationGuideDefinitionPageComponent addPage(ImplementationGuideDefinitionPageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
            }
            this.page.add(t);
            return this;
        }

        public ImplementationGuideDefinitionPageComponent getPageFirstRep() {
            if (this.getPage().isEmpty()) {
                this.addPage();
            }
            return this.getPage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_TITLE, "string", "A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, 1, this.title));
            children.add(new Property("generation", "code", "A code that indicates how the page is generated.", 0, 1, this.generation));
            children.add(new Property("page", "@ImplementationGuide.definition.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1721948693: {
                    return new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 3373707: {
                    return new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 1721942756: {
                    return new Property("name[x]", ImplementationGuide.SP_URL, "The source address for the page.", 0, 1, this.name);
                }
                case 1833144576: {
                    return new Property("name[x]", "Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 110371416: {
                    return new Property(ImplementationGuide.SP_TITLE, "string", "A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, 1, this.title);
                }
                case 305703192: {
                    return new Property("generation", "code", "A code that indicates how the page is generated.", 0, 1, this.generation);
                }
                case 3433103: {
                    return new Property("page", "@ImplementationGuide.definition.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case 305703192: {
                    Base[] baseArray;
                    if (this.generation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.generation;
                    }
                    return baseArray;
                }
                case 3433103: {
                    return this.page == null ? new Base[]{} : this.page.toArray(new Base[this.page.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToType(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 305703192: {
                    value = new GuidePageGenerationEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.generation = value;
                    return value;
                }
                case 3433103: {
                    this.getPage().add((ImplementationGuideDefinitionPageComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name[x]")) {
                this.name = TypeConvertor.castToType(value);
            } else if (name.equals(ImplementationGuide.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("generation")) {
                value = new GuidePageGenerationEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.generation = value;
            } else if (name.equals("page")) {
                this.getPage().add((ImplementationGuideDefinitionPageComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("name[x]")) {
                this.name = null;
            } else if (name.equals(ImplementationGuide.SP_TITLE)) {
                this.title = null;
            } else if (name.equals("generation")) {
                this.generation = null;
            } else if (name.equals("page")) {
                this.getPage().remove((ImplementationGuideDefinitionPageComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1721948693: {
                    return this.getName();
                }
                case 3373707: {
                    return this.getName();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case 305703192: {
                    return this.getGenerationElement();
                }
                case 3433103: {
                    return this.addPage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{ImplementationGuide.SP_URL, "Reference"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case 305703192: {
                    return new String[]{"code"};
                }
                case 3433103: {
                    return new String[]{"@ImplementationGuide.definition.page"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nameUrl")) {
                this.name = new UrlType();
                return this.name;
            }
            if (name.equals("nameReference")) {
                this.name = new Reference();
                return this.name;
            }
            if (name.equals(ImplementationGuide.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.page.title");
            }
            if (name.equals("generation")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.page.generation");
            }
            if (name.equals("page")) {
                return this.addPage();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionPageComponent copy() {
            ImplementationGuideDefinitionPageComponent dst = new ImplementationGuideDefinitionPageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDefinitionPageComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.title = this.title == null ? null : this.title.copy();
            Enumeration<GuidePageGeneration> enumeration = dst.generation = this.generation == null ? null : this.generation.copy();
            if (this.page != null) {
                dst.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
                for (ImplementationGuideDefinitionPageComponent i : this.page) {
                    dst.page.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionPageComponent)) {
                return false;
            }
            ImplementationGuideDefinitionPageComponent o = (ImplementationGuideDefinitionPageComponent)other_;
            return ImplementationGuideDefinitionPageComponent.compareDeep(this.name, o.name, true) && ImplementationGuideDefinitionPageComponent.compareDeep(this.title, o.title, true) && ImplementationGuideDefinitionPageComponent.compareDeep(this.generation, o.generation, true) && ImplementationGuideDefinitionPageComponent.compareDeep(this.page, o.page, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionPageComponent)) {
                return false;
            }
            ImplementationGuideDefinitionPageComponent o = (ImplementationGuideDefinitionPageComponent)other_;
            return ImplementationGuideDefinitionPageComponent.compareValues(this.title, o.title, true) && ImplementationGuideDefinitionPageComponent.compareValues(this.generation, o.generation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.title, this.generation, this.page});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.page";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location of the resource", formalDefinition="Where this resource is found.")
        protected Reference reference;
        @Child(name="fhirVersion", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Versions this applies to (if different to IG)", formalDefinition="Indicates the FHIR Version(s) this artifact is intended to apply to. If no versions are specified, the resource is assumed to apply to all the versions stated in ImplementationGuide.fhirVersion.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/FHIR-version")
        protected List<Enumeration<Enumerations.FHIRVersion>> fhirVersion;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human Name for the resource", formalDefinition="A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason why included in guide", formalDefinition="A description of the reason that a resource has been included in the implementation guide.")
        protected StringType description;
        @Child(name="example", type={BooleanType.class, CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is an example/What is this an example of?", formalDefinition="If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.")
        protected DataType example;
        @Child(name="groupingId", type={IdType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Grouping this is part of", formalDefinition="Reference to the id of the grouping this resource appears in.")
        protected IdType groupingId;
        private static final long serialVersionUID = 268206575L;

        public ImplementationGuideDefinitionResourceComponent() {
        }

        public ImplementationGuideDefinitionResourceComponent(Reference reference) {
            this.setReference(reference);
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public List<Enumeration<Enumerations.FHIRVersion>> getFhirVersion() {
            if (this.fhirVersion == null) {
                this.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
            }
            return this.fhirVersion;
        }

        public ImplementationGuideDefinitionResourceComponent setFhirVersion(List<Enumeration<Enumerations.FHIRVersion>> theFhirVersion) {
            this.fhirVersion = theFhirVersion;
            return this;
        }

        public boolean hasFhirVersion() {
            if (this.fhirVersion == null) {
                return false;
            }
            for (Enumeration<Enumerations.FHIRVersion> item : this.fhirVersion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.FHIRVersion> addFhirVersionElement() {
            Enumeration<Enumerations.FHIRVersion> t = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
            if (this.fhirVersion == null) {
                this.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
            }
            this.fhirVersion.add(t);
            return t;
        }

        public ImplementationGuideDefinitionResourceComponent addFhirVersion(Enumerations.FHIRVersion value) {
            Enumeration<Enumerations.FHIRVersion> t = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
            t.setValue((Object)value);
            if (this.fhirVersion == null) {
                this.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
            }
            this.fhirVersion.add(t);
            return this;
        }

        public boolean hasFhirVersion(Enumerations.FHIRVersion value) {
            if (this.fhirVersion == null) {
                return false;
            }
            for (Enumeration<Enumerations.FHIRVersion> v : this.fhirVersion) {
                if (!((Enumerations.FHIRVersion)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuideDefinitionResourceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuideDefinitionResourceComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public DataType getExample() {
            return this.example;
        }

        public BooleanType getExampleBooleanType() throws FHIRException {
            if (this.example == null) {
                this.example = new BooleanType();
            }
            if (!(this.example instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.example;
        }

        public boolean hasExampleBooleanType() {
            return this != null && this.example instanceof BooleanType;
        }

        public CanonicalType getExampleCanonicalType() throws FHIRException {
            if (this.example == null) {
                this.example = new CanonicalType();
            }
            if (!(this.example instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.example;
        }

        public boolean hasExampleCanonicalType() {
            return this != null && this.example instanceof CanonicalType;
        }

        public boolean hasExample() {
            return this.example != null && !this.example.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setExample(DataType value) {
            if (value != null && !(value instanceof BooleanType) && !(value instanceof CanonicalType)) {
                throw new Error("Not the right type for ImplementationGuide.definition.resource.example[x]: " + value.fhirType());
            }
            this.example = value;
            return this;
        }

        public IdType getGroupingIdElement() {
            if (this.groupingId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.groupingId");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupingId = new IdType();
                }
            }
            return this.groupingId;
        }

        public boolean hasGroupingIdElement() {
            return this.groupingId != null && !this.groupingId.isEmpty();
        }

        public boolean hasGroupingId() {
            return this.groupingId != null && !this.groupingId.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setGroupingIdElement(IdType value) {
            this.groupingId = value;
            return this;
        }

        public String getGroupingId() {
            return this.groupingId == null ? null : this.groupingId.getValue();
        }

        public ImplementationGuideDefinitionResourceComponent setGroupingId(String value) {
            if (Utilities.noString((String)value)) {
                this.groupingId = null;
            } else {
                if (this.groupingId == null) {
                    this.groupingId = new IdType();
                }
                this.groupingId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference));
            children.add(new Property("fhirVersion", "code", "Indicates the FHIR Version(s) this artifact is intended to apply to. If no versions are specified, the resource is assumed to apply to all the versions stated in ImplementationGuide.fhirVersion.", 0, Integer.MAX_VALUE, this.fhirVersion));
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, 1, this.description));
            children.add(new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example));
            children.add(new Property("groupingId", "id", "Reference to the id of the grouping this resource appears in.", 0, 1, this.groupingId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference);
                }
                case 461006061: {
                    return new Property("fhirVersion", "code", "Indicates the FHIR Version(s) this artifact is intended to apply to. If no versions are specified, the resource is assumed to apply to all the versions stated in ImplementationGuide.fhirVersion.", 0, Integer.MAX_VALUE, this.fhirVersion);
                }
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, 1, this.description);
                }
                case -2002328874: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -1322970774: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 159803230: {
                    return new Property("example[x]", "boolean", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 2016979626: {
                    return new Property("example[x]", "canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 1291547006: {
                    return new Property("groupingId", "id", "Reference to the id of the grouping this resource appears in.", 0, 1, this.groupingId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case 461006061: {
                    return this.fhirVersion == null ? new Base[]{} : this.fhirVersion.toArray(new Base[this.fhirVersion.size()]);
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1322970774: {
                    Base[] baseArray;
                    if (this.example == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.example;
                    }
                    return baseArray;
                }
                case 1291547006: {
                    Base[] baseArray;
                    if (this.groupingId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.groupingId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 461006061: {
                    value = new Enumerations.FHIRVersionEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getFhirVersion().add(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1322970774: {
                    this.example = TypeConvertor.castToType(value);
                    return value;
                }
                case 1291547006: {
                    this.groupingId = TypeConvertor.castToId(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else if (name.equals("fhirVersion")) {
                value = new Enumerations.FHIRVersionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getFhirVersion().add(value);
            } else if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("example[x]")) {
                this.example = TypeConvertor.castToType(value);
            } else if (name.equals("groupingId")) {
                this.groupingId = TypeConvertor.castToId(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = null;
            } else if (name.equals("fhirVersion")) {
                this.getFhirVersion().remove((Enumeration)value);
            } else if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = null;
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = null;
            } else if (name.equals("example[x]")) {
                this.example = null;
            } else if (name.equals("groupingId")) {
                this.groupingId = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case 461006061: {
                    return this.addFhirVersionElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -2002328874: {
                    return this.getExample();
                }
                case -1322970774: {
                    return this.getExample();
                }
                case 1291547006: {
                    return this.getGroupingIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 461006061: {
                    return new String[]{"code"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1322970774: {
                    return new String[]{"boolean", "canonical"};
                }
                case 1291547006: {
                    return new String[]{"id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("fhirVersion")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.resource.fhirVersion");
            }
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.resource.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.resource.description");
            }
            if (name.equals("exampleBoolean")) {
                this.example = new BooleanType();
                return this.example;
            }
            if (name.equals("exampleCanonical")) {
                this.example = new CanonicalType();
                return this.example;
            }
            if (name.equals("groupingId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.resource.groupingId");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionResourceComponent copy() {
            ImplementationGuideDefinitionResourceComponent dst = new ImplementationGuideDefinitionResourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDefinitionResourceComponent dst) {
            super.copyValues(dst);
            Reference reference = dst.reference = this.reference == null ? null : this.reference.copy();
            if (this.fhirVersion != null) {
                dst.fhirVersion = new ArrayList<Enumeration<Enumerations.FHIRVersion>>();
                for (Enumeration<Enumerations.FHIRVersion> i : this.fhirVersion) {
                    dst.fhirVersion.add((Enumeration<Enumerations.FHIRVersion>)i.copy());
                }
            }
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.example = this.example == null ? null : this.example.copy();
            dst.groupingId = this.groupingId == null ? null : this.groupingId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionResourceComponent)) {
                return false;
            }
            ImplementationGuideDefinitionResourceComponent o = (ImplementationGuideDefinitionResourceComponent)other_;
            return ImplementationGuideDefinitionResourceComponent.compareDeep(this.reference, o.reference, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.fhirVersion, o.fhirVersion, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.name, o.name, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.description, o.description, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.example, o.example, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.groupingId, o.groupingId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionResourceComponent)) {
                return false;
            }
            ImplementationGuideDefinitionResourceComponent o = (ImplementationGuideDefinitionResourceComponent)other_;
            return ImplementationGuideDefinitionResourceComponent.compareValues(this.fhirVersion, o.fhirVersion, true) && ImplementationGuideDefinitionResourceComponent.compareValues(this.name, o.name, true) && ImplementationGuideDefinitionResourceComponent.compareValues(this.description, o.description, true) && ImplementationGuideDefinitionResourceComponent.compareValues(this.groupingId, o.groupingId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.reference, this.fhirVersion, this.name, this.description, this.example, this.groupingId});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.resource";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionGroupingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Descriptive name for the package", formalDefinition="The human-readable title to display for the package of resources when rendering the implementation guide.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable text describing the package", formalDefinition="Human readable text describing the package.")
        protected StringType description;
        private static final long serialVersionUID = -1105523499L;

        public ImplementationGuideDefinitionGroupingComponent() {
        }

        public ImplementationGuideDefinitionGroupingComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionGroupingComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideDefinitionGroupingComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuideDefinitionGroupingComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionGroupingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuideDefinitionGroupingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuideDefinitionGroupingComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "The human-readable title to display for the package of resources when rendering the implementation guide.", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "The human-readable title to display for the package of resources when rendering the implementation guide.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = null;
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.grouping.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.definition.grouping.description");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionGroupingComponent copy() {
            ImplementationGuideDefinitionGroupingComponent dst = new ImplementationGuideDefinitionGroupingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDefinitionGroupingComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionGroupingComponent)) {
                return false;
            }
            ImplementationGuideDefinitionGroupingComponent o = (ImplementationGuideDefinitionGroupingComponent)other_;
            return ImplementationGuideDefinitionGroupingComponent.compareDeep(this.name, o.name, true) && ImplementationGuideDefinitionGroupingComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionGroupingComponent)) {
                return false;
            }
            ImplementationGuideDefinitionGroupingComponent o = (ImplementationGuideDefinitionGroupingComponent)other_;
            return ImplementationGuideDefinitionGroupingComponent.compareValues(this.name, o.name, true) && ImplementationGuideDefinitionGroupingComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.description});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.grouping";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="grouping", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Grouping used to present related resources in the IG", formalDefinition="A logical group of resources. Logical groups can be used when building pages.")
        protected List<ImplementationGuideDefinitionGroupingComponent> grouping;
        @Child(name="resource", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resource in the implementation guide", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.")
        protected List<ImplementationGuideDefinitionResourceComponent> resource;
        @Child(name="page", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Page/Section in the Guide", formalDefinition="A page / section in the implementation guide. The root page is the implementation guide home page.")
        protected ImplementationGuideDefinitionPageComponent page;
        @Child(name="parameter", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Defines how IG is built by tools", formalDefinition="Defines how IG is built by tools.")
        protected List<ImplementationGuideDefinitionParameterComponent> parameter;
        @Child(name="template", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A template for building resources", formalDefinition="A template for building resources.")
        protected List<ImplementationGuideDefinitionTemplateComponent> template;
        private static final long serialVersionUID = 179051968L;

        public ImplementationGuideDefinitionComponent() {
        }

        public ImplementationGuideDefinitionComponent(ImplementationGuideDefinitionResourceComponent resource) {
            this.addResource(resource);
        }

        public List<ImplementationGuideDefinitionGroupingComponent> getGrouping() {
            if (this.grouping == null) {
                this.grouping = new ArrayList<ImplementationGuideDefinitionGroupingComponent>();
            }
            return this.grouping;
        }

        public ImplementationGuideDefinitionComponent setGrouping(List<ImplementationGuideDefinitionGroupingComponent> theGrouping) {
            this.grouping = theGrouping;
            return this;
        }

        public boolean hasGrouping() {
            if (this.grouping == null) {
                return false;
            }
            for (ImplementationGuideDefinitionGroupingComponent item : this.grouping) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionGroupingComponent addGrouping() {
            ImplementationGuideDefinitionGroupingComponent t = new ImplementationGuideDefinitionGroupingComponent();
            if (this.grouping == null) {
                this.grouping = new ArrayList<ImplementationGuideDefinitionGroupingComponent>();
            }
            this.grouping.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addGrouping(ImplementationGuideDefinitionGroupingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.grouping == null) {
                this.grouping = new ArrayList<ImplementationGuideDefinitionGroupingComponent>();
            }
            this.grouping.add(t);
            return this;
        }

        public ImplementationGuideDefinitionGroupingComponent getGroupingFirstRep() {
            if (this.getGrouping().isEmpty()) {
                this.addGrouping();
            }
            return this.getGrouping().get(0);
        }

        public List<ImplementationGuideDefinitionResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
            }
            return this.resource;
        }

        public ImplementationGuideDefinitionComponent setResource(List<ImplementationGuideDefinitionResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ImplementationGuideDefinitionResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionResourceComponent addResource() {
            ImplementationGuideDefinitionResourceComponent t = new ImplementationGuideDefinitionResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addResource(ImplementationGuideDefinitionResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public ImplementationGuideDefinitionResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public ImplementationGuideDefinitionPageComponent getPage() {
            if (this.page == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionComponent.page");
                }
                if (Configuration.doAutoCreate()) {
                    this.page = new ImplementationGuideDefinitionPageComponent();
                }
            }
            return this.page;
        }

        public boolean hasPage() {
            return this.page != null && !this.page.isEmpty();
        }

        public ImplementationGuideDefinitionComponent setPage(ImplementationGuideDefinitionPageComponent value) {
            this.page = value;
            return this;
        }

        public List<ImplementationGuideDefinitionParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
            }
            return this.parameter;
        }

        public ImplementationGuideDefinitionComponent setParameter(List<ImplementationGuideDefinitionParameterComponent> theParameter) {
            this.parameter = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (ImplementationGuideDefinitionParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionParameterComponent addParameter() {
            ImplementationGuideDefinitionParameterComponent t = new ImplementationGuideDefinitionParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addParameter(ImplementationGuideDefinitionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public ImplementationGuideDefinitionParameterComponent getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public List<ImplementationGuideDefinitionTemplateComponent> getTemplate() {
            if (this.template == null) {
                this.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
            }
            return this.template;
        }

        public ImplementationGuideDefinitionComponent setTemplate(List<ImplementationGuideDefinitionTemplateComponent> theTemplate) {
            this.template = theTemplate;
            return this;
        }

        public boolean hasTemplate() {
            if (this.template == null) {
                return false;
            }
            for (ImplementationGuideDefinitionTemplateComponent item : this.template) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionTemplateComponent addTemplate() {
            ImplementationGuideDefinitionTemplateComponent t = new ImplementationGuideDefinitionTemplateComponent();
            if (this.template == null) {
                this.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
            }
            this.template.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addTemplate(ImplementationGuideDefinitionTemplateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.template == null) {
                this.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
            }
            this.template.add(t);
            return this;
        }

        public ImplementationGuideDefinitionTemplateComponent getTemplateFirstRep() {
            if (this.getTemplate().isEmpty()) {
                this.addTemplate();
            }
            return this.getTemplate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("grouping", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.grouping));
            children.add(new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, 1, this.page));
            children.add(new Property("parameter", "", "Defines how IG is built by tools.", 0, Integer.MAX_VALUE, this.parameter));
            children.add(new Property("template", "", "A template for building resources.", 0, Integer.MAX_VALUE, this.template));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 506371331: {
                    return new Property("grouping", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.grouping);
                }
                case -341064690: {
                    return new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 3433103: {
                    return new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, 1, this.page);
                }
                case 1954460585: {
                    return new Property("parameter", "", "Defines how IG is built by tools.", 0, Integer.MAX_VALUE, this.parameter);
                }
                case -1321546630: {
                    return new Property("template", "", "A template for building resources.", 0, Integer.MAX_VALUE, this.template);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 506371331: {
                    return this.grouping == null ? new Base[]{} : this.grouping.toArray(new Base[this.grouping.size()]);
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 3433103: {
                    Base[] baseArray;
                    if (this.page == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.page;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
                case -1321546630: {
                    return this.template == null ? new Base[]{} : this.template.toArray(new Base[this.template.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 506371331: {
                    this.getGrouping().add((ImplementationGuideDefinitionGroupingComponent)value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((ImplementationGuideDefinitionResourceComponent)value);
                    return value;
                }
                case 3433103: {
                    this.page = (ImplementationGuideDefinitionPageComponent)value;
                    return value;
                }
                case 1954460585: {
                    this.getParameter().add((ImplementationGuideDefinitionParameterComponent)value);
                    return value;
                }
                case -1321546630: {
                    this.getTemplate().add((ImplementationGuideDefinitionTemplateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("grouping")) {
                this.getGrouping().add((ImplementationGuideDefinitionGroupingComponent)value);
            } else if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                this.getResource().add((ImplementationGuideDefinitionResourceComponent)value);
            } else if (name.equals("page")) {
                this.page = (ImplementationGuideDefinitionPageComponent)value;
            } else if (name.equals("parameter")) {
                this.getParameter().add((ImplementationGuideDefinitionParameterComponent)value);
            } else if (name.equals("template")) {
                this.getTemplate().add((ImplementationGuideDefinitionTemplateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("grouping")) {
                this.getGrouping().remove((ImplementationGuideDefinitionGroupingComponent)value);
            } else if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                this.getResource().remove((ImplementationGuideDefinitionResourceComponent)value);
            } else if (name.equals("page")) {
                this.page = (ImplementationGuideDefinitionPageComponent)value;
            } else if (name.equals("parameter")) {
                this.getParameter().remove((ImplementationGuideDefinitionParameterComponent)value);
            } else if (name.equals("template")) {
                this.getTemplate().remove((ImplementationGuideDefinitionTemplateComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 506371331: {
                    return this.addGrouping();
                }
                case -341064690: {
                    return this.addResource();
                }
                case 3433103: {
                    return this.getPage();
                }
                case 1954460585: {
                    return this.addParameter();
                }
                case -1321546630: {
                    return this.addTemplate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 506371331: {
                    return new String[0];
                }
                case -341064690: {
                    return new String[0];
                }
                case 3433103: {
                    return new String[0];
                }
                case 1954460585: {
                    return new String[0];
                }
                case -1321546630: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("grouping")) {
                return this.addGrouping();
            }
            if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                return this.addResource();
            }
            if (name.equals("page")) {
                this.page = new ImplementationGuideDefinitionPageComponent();
                return this.page;
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("template")) {
                return this.addTemplate();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionComponent copy() {
            ImplementationGuideDefinitionComponent dst = new ImplementationGuideDefinitionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDefinitionComponent dst) {
            super.copyValues(dst);
            if (this.grouping != null) {
                dst.grouping = new ArrayList<ImplementationGuideDefinitionGroupingComponent>();
                for (ImplementationGuideDefinitionGroupingComponent implementationGuideDefinitionGroupingComponent : this.grouping) {
                    dst.grouping.add(implementationGuideDefinitionGroupingComponent.copy());
                }
            }
            if (this.resource != null) {
                dst.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
                for (ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : this.resource) {
                    dst.resource.add(implementationGuideDefinitionResourceComponent.copy());
                }
            }
            ImplementationGuideDefinitionPageComponent implementationGuideDefinitionPageComponent = dst.page = this.page == null ? null : this.page.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
                for (ImplementationGuideDefinitionParameterComponent implementationGuideDefinitionParameterComponent : this.parameter) {
                    dst.parameter.add(implementationGuideDefinitionParameterComponent.copy());
                }
            }
            if (this.template != null) {
                dst.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
                for (ImplementationGuideDefinitionTemplateComponent implementationGuideDefinitionTemplateComponent : this.template) {
                    dst.template.add(implementationGuideDefinitionTemplateComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionComponent)) {
                return false;
            }
            ImplementationGuideDefinitionComponent o = (ImplementationGuideDefinitionComponent)other_;
            return ImplementationGuideDefinitionComponent.compareDeep(this.grouping, o.grouping, true) && ImplementationGuideDefinitionComponent.compareDeep(this.resource, o.resource, true) && ImplementationGuideDefinitionComponent.compareDeep(this.page, o.page, true) && ImplementationGuideDefinitionComponent.compareDeep(this.parameter, o.parameter, true) && ImplementationGuideDefinitionComponent.compareDeep(this.template, o.template, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionComponent)) {
                return false;
            }
            ImplementationGuideDefinitionComponent o = (ImplementationGuideDefinitionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.grouping, this.resource, this.page, this.parameter, this.template});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition";
        }
    }

    @Block
    public static class ImplementationGuideGlobalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type this profile applies to", formalDefinition="The type of resource that all instances must conform to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType type;
        @Child(name="profile", type={CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Profile that all resources must conform to", formalDefinition="A reference to the profile that all instances must conform to.")
        protected CanonicalType profile;
        private static final long serialVersionUID = 33894666L;

        public ImplementationGuideGlobalComponent() {
        }

        public ImplementationGuideGlobalComponent(String type, String profile) {
            this.setType(type);
            this.setProfile(profile);
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImplementationGuideGlobalComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ImplementationGuideGlobalComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ImplementationGuideGlobalComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public ImplementationGuideGlobalComponent setProfile(String value) {
            if (this.profile == null) {
                this.profile = new CanonicalType();
            }
            this.profile.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of resource that all instances must conform to.", 0, 1, this.type));
            children.add(new Property("profile", "canonical(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of resource that all instances must conform to.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("profile")) {
                this.profile = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.global.type");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.global.profile");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideGlobalComponent copy() {
            ImplementationGuideGlobalComponent dst = new ImplementationGuideGlobalComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideGlobalComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other_;
            return ImplementationGuideGlobalComponent.compareDeep(this.type, o.type, true) && ImplementationGuideGlobalComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other_;
            return ImplementationGuideGlobalComponent.compareValues(this.type, o.type, true) && ImplementationGuideGlobalComponent.compareValues(this.profile, o.profile, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.profile});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.global";
        }
    }

    @Block
    public static class ImplementationGuideDependsOnComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uri", type={CanonicalType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identity of the IG that this depends on", formalDefinition="A canonical reference to the Implementation guide for the dependency.")
        protected CanonicalType uri;
        @Child(name="packageId", type={IdType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="NPM Package name for IG this depends on", formalDefinition="The NPM package name for the Implementation Guide that this IG depends on.")
        protected IdType packageId;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version of the IG", formalDefinition="The version of the IG that is depended on, when the correct version is required to understand the IG correctly.")
        protected StringType version;
        private static final long serialVersionUID = -215808797L;

        public ImplementationGuideDependsOnComponent() {
        }

        public ImplementationGuideDependsOnComponent(String uri) {
            this.setUri(uri);
        }

        public CanonicalType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependsOnComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new CanonicalType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ImplementationGuideDependsOnComponent setUriElement(CanonicalType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ImplementationGuideDependsOnComponent setUri(String value) {
            if (this.uri == null) {
                this.uri = new CanonicalType();
            }
            this.uri.setValue(value);
            return this;
        }

        public IdType getPackageIdElement() {
            if (this.packageId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependsOnComponent.packageId");
                }
                if (Configuration.doAutoCreate()) {
                    this.packageId = new IdType();
                }
            }
            return this.packageId;
        }

        public boolean hasPackageIdElement() {
            return this.packageId != null && !this.packageId.isEmpty();
        }

        public boolean hasPackageId() {
            return this.packageId != null && !this.packageId.isEmpty();
        }

        public ImplementationGuideDependsOnComponent setPackageIdElement(IdType value) {
            this.packageId = value;
            return this;
        }

        public String getPackageId() {
            return this.packageId == null ? null : this.packageId.getValue();
        }

        public ImplementationGuideDependsOnComponent setPackageId(String value) {
            if (Utilities.noString((String)value)) {
                this.packageId = null;
            } else {
                if (this.packageId == null) {
                    this.packageId = new IdType();
                }
                this.packageId.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependsOnComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ImplementationGuideDependsOnComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ImplementationGuideDependsOnComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uri", "canonical(ImplementationGuide)", "A canonical reference to the Implementation guide for the dependency.", 0, 1, this.uri));
            children.add(new Property("packageId", "id", "The NPM package name for the Implementation Guide that this IG depends on.", 0, 1, this.packageId));
            children.add(new Property(ImplementationGuide.SP_VERSION, "string", "The version of the IG that is depended on, when the correct version is required to understand the IG correctly.", 0, 1, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116076: {
                    return new Property("uri", "canonical(ImplementationGuide)", "A canonical reference to the Implementation guide for the dependency.", 0, 1, this.uri);
                }
                case 1802060801: {
                    return new Property("packageId", "id", "The NPM package name for the Implementation Guide that this IG depends on.", 0, 1, this.packageId);
                }
                case 351608024: {
                    return new Property(ImplementationGuide.SP_VERSION, "string", "The version of the IG that is depended on, when the correct version is required to understand the IG correctly.", 0, 1, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uri;
                    }
                    return baseArray;
                }
                case 1802060801: {
                    Base[] baseArray;
                    if (this.packageId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.packageId;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116076: {
                    this.uri = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 1802060801: {
                    this.packageId = TypeConvertor.castToId(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uri")) {
                this.uri = TypeConvertor.castToCanonical(value);
            } else if (name.equals("packageId")) {
                this.packageId = TypeConvertor.castToId(value);
            } else if (name.equals(ImplementationGuide.SP_VERSION)) {
                this.version = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("uri")) {
                this.uri = null;
            } else if (name.equals("packageId")) {
                this.packageId = null;
            } else if (name.equals(ImplementationGuide.SP_VERSION)) {
                this.version = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return this.getUriElement();
                }
                case 1802060801: {
                    return this.getPackageIdElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return new String[]{"canonical"};
                }
                case 1802060801: {
                    return new String[]{"id"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.dependsOn.uri");
            }
            if (name.equals("packageId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.dependsOn.packageId");
            }
            if (name.equals(ImplementationGuide.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ImplementationGuide.dependsOn.version");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDependsOnComponent copy() {
            ImplementationGuideDependsOnComponent dst = new ImplementationGuideDependsOnComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImplementationGuideDependsOnComponent dst) {
            super.copyValues(dst);
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.packageId = this.packageId == null ? null : this.packageId.copy();
            dst.version = this.version == null ? null : this.version.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDependsOnComponent)) {
                return false;
            }
            ImplementationGuideDependsOnComponent o = (ImplementationGuideDependsOnComponent)other_;
            return ImplementationGuideDependsOnComponent.compareDeep(this.uri, o.uri, true) && ImplementationGuideDependsOnComponent.compareDeep(this.packageId, o.packageId, true) && ImplementationGuideDependsOnComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDependsOnComponent)) {
                return false;
            }
            ImplementationGuideDependsOnComponent o = (ImplementationGuideDependsOnComponent)other_;
            return ImplementationGuideDependsOnComponent.compareValues(this.uri, o.uri, true) && ImplementationGuideDependsOnComponent.compareValues(this.packageId, o.packageId, true) && ImplementationGuideDependsOnComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.uri, this.packageId, this.version});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.dependsOn";
        }
    }

    public static class SPDXLicenseEnumFactory
    implements EnumFactory<SPDXLicense> {
        @Override
        public SPDXLicense fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("0BSD".equals(codeString)) {
                return SPDXLicense._0BSD;
            }
            if ("AAL".equals(codeString)) {
                return SPDXLicense.AAL;
            }
            if ("Abstyles".equals(codeString)) {
                return SPDXLicense.ABSTYLES;
            }
            if ("AdaCore-doc".equals(codeString)) {
                return SPDXLicense.ADACORE_DOC;
            }
            if ("Adobe-2006".equals(codeString)) {
                return SPDXLicense.ADOBE_2006;
            }
            if ("Adobe-Glyph".equals(codeString)) {
                return SPDXLicense.ADOBE_GLYPH;
            }
            if ("ADSL".equals(codeString)) {
                return SPDXLicense.ADSL;
            }
            if ("AFL-1.1".equals(codeString)) {
                return SPDXLicense.AFL_1_1;
            }
            if ("AFL-1.2".equals(codeString)) {
                return SPDXLicense.AFL_1_2;
            }
            if ("AFL-2.0".equals(codeString)) {
                return SPDXLicense.AFL_2_0;
            }
            if ("AFL-2.1".equals(codeString)) {
                return SPDXLicense.AFL_2_1;
            }
            if ("AFL-3.0".equals(codeString)) {
                return SPDXLicense.AFL_3_0;
            }
            if ("Afmparse".equals(codeString)) {
                return SPDXLicense.AFMPARSE;
            }
            if ("AGPL-1.0".equals(codeString)) {
                return SPDXLicense.AGPL_1_0;
            }
            if ("AGPL-1.0-only".equals(codeString)) {
                return SPDXLicense.AGPL_1_0_ONLY;
            }
            if ("AGPL-1.0-or-later".equals(codeString)) {
                return SPDXLicense.AGPL_1_0_OR_LATER;
            }
            if ("AGPL-3.0".equals(codeString)) {
                return SPDXLicense.AGPL_3_0;
            }
            if ("AGPL-3.0-only".equals(codeString)) {
                return SPDXLicense.AGPL_3_0_ONLY;
            }
            if ("AGPL-3.0-or-later".equals(codeString)) {
                return SPDXLicense.AGPL_3_0_OR_LATER;
            }
            if ("Aladdin".equals(codeString)) {
                return SPDXLicense.ALADDIN;
            }
            if ("AMDPLPA".equals(codeString)) {
                return SPDXLicense.AMDPLPA;
            }
            if ("AML".equals(codeString)) {
                return SPDXLicense.AML;
            }
            if ("AMPAS".equals(codeString)) {
                return SPDXLicense.AMPAS;
            }
            if ("ANTLR-PD".equals(codeString)) {
                return SPDXLicense.ANTLR_PD;
            }
            if ("ANTLR-PD-fallback".equals(codeString)) {
                return SPDXLicense.ANTLR_PD_FALLBACK;
            }
            if ("Apache-1.0".equals(codeString)) {
                return SPDXLicense.APACHE_1_0;
            }
            if ("Apache-1.1".equals(codeString)) {
                return SPDXLicense.APACHE_1_1;
            }
            if ("Apache-2.0".equals(codeString)) {
                return SPDXLicense.APACHE_2_0;
            }
            if ("APAFML".equals(codeString)) {
                return SPDXLicense.APAFML;
            }
            if ("APL-1.0".equals(codeString)) {
                return SPDXLicense.APL_1_0;
            }
            if ("App-s2p".equals(codeString)) {
                return SPDXLicense.APP_S2P;
            }
            if ("APSL-1.0".equals(codeString)) {
                return SPDXLicense.APSL_1_0;
            }
            if ("APSL-1.1".equals(codeString)) {
                return SPDXLicense.APSL_1_1;
            }
            if ("APSL-1.2".equals(codeString)) {
                return SPDXLicense.APSL_1_2;
            }
            if ("APSL-2.0".equals(codeString)) {
                return SPDXLicense.APSL_2_0;
            }
            if ("Arphic-1999".equals(codeString)) {
                return SPDXLicense.ARPHIC_1999;
            }
            if ("Artistic-1.0".equals(codeString)) {
                return SPDXLicense.ARTISTIC_1_0;
            }
            if ("Artistic-1.0-cl8".equals(codeString)) {
                return SPDXLicense.ARTISTIC_1_0_CL8;
            }
            if ("Artistic-1.0-Perl".equals(codeString)) {
                return SPDXLicense.ARTISTIC_1_0_PERL;
            }
            if ("Artistic-2.0".equals(codeString)) {
                return SPDXLicense.ARTISTIC_2_0;
            }
            if ("ASWF-Digital-Assets-1.0".equals(codeString)) {
                return SPDXLicense.ASWF_DIGITAL_ASSETS_1_0;
            }
            if ("ASWF-Digital-Assets-1.1".equals(codeString)) {
                return SPDXLicense.ASWF_DIGITAL_ASSETS_1_1;
            }
            if ("Baekmuk".equals(codeString)) {
                return SPDXLicense.BAEKMUK;
            }
            if ("Bahyph".equals(codeString)) {
                return SPDXLicense.BAHYPH;
            }
            if ("Barr".equals(codeString)) {
                return SPDXLicense.BARR;
            }
            if ("Beerware".equals(codeString)) {
                return SPDXLicense.BEERWARE;
            }
            if ("Bitstream-Charter".equals(codeString)) {
                return SPDXLicense.BITSTREAM_CHARTER;
            }
            if ("Bitstream-Vera".equals(codeString)) {
                return SPDXLicense.BITSTREAM_VERA;
            }
            if ("BitTorrent-1.0".equals(codeString)) {
                return SPDXLicense.BITTORRENT_1_0;
            }
            if ("BitTorrent-1.1".equals(codeString)) {
                return SPDXLicense.BITTORRENT_1_1;
            }
            if ("blessing".equals(codeString)) {
                return SPDXLicense.BLESSING;
            }
            if ("BlueOak-1.0.0".equals(codeString)) {
                return SPDXLicense.BLUEOAK_1_0_0;
            }
            if ("Boehm-GC".equals(codeString)) {
                return SPDXLicense.BOEHM_GC;
            }
            if ("Borceux".equals(codeString)) {
                return SPDXLicense.BORCEUX;
            }
            if ("Brian-Gladman-3-Clause".equals(codeString)) {
                return SPDXLicense.BRIAN_GLADMAN_3_CLAUSE;
            }
            if ("BSD-1-Clause".equals(codeString)) {
                return SPDXLicense.BSD_1_CLAUSE;
            }
            if ("BSD-2-Clause".equals(codeString)) {
                return SPDXLicense.BSD_2_CLAUSE;
            }
            if ("BSD-2-Clause-FreeBSD".equals(codeString)) {
                return SPDXLicense.BSD_2_CLAUSE_FREEBSD;
            }
            if ("BSD-2-Clause-NetBSD".equals(codeString)) {
                return SPDXLicense.BSD_2_CLAUSE_NETBSD;
            }
            if ("BSD-2-Clause-Patent".equals(codeString)) {
                return SPDXLicense.BSD_2_CLAUSE_PATENT;
            }
            if ("BSD-2-Clause-Views".equals(codeString)) {
                return SPDXLicense.BSD_2_CLAUSE_VIEWS;
            }
            if ("BSD-3-Clause".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE;
            }
            if ("BSD-3-Clause-Attribution".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_ATTRIBUTION;
            }
            if ("BSD-3-Clause-Clear".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_CLEAR;
            }
            if ("BSD-3-Clause-LBNL".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_LBNL;
            }
            if ("BSD-3-Clause-Modification".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_MODIFICATION;
            }
            if ("BSD-3-Clause-No-Military-License".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_NO_MILITARY_LICENSE;
            }
            if ("BSD-3-Clause-No-Nuclear-License".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE;
            }
            if ("BSD-3-Clause-No-Nuclear-License-2014".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014;
            }
            if ("BSD-3-Clause-No-Nuclear-Warranty".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY;
            }
            if ("BSD-3-Clause-Open-MPI".equals(codeString)) {
                return SPDXLicense.BSD_3_CLAUSE_OPEN_MPI;
            }
            if ("BSD-4-Clause".equals(codeString)) {
                return SPDXLicense.BSD_4_CLAUSE;
            }
            if ("BSD-4-Clause-Shortened".equals(codeString)) {
                return SPDXLicense.BSD_4_CLAUSE_SHORTENED;
            }
            if ("BSD-4-Clause-UC".equals(codeString)) {
                return SPDXLicense.BSD_4_CLAUSE_UC;
            }
            if ("BSD-4.3RENO".equals(codeString)) {
                return SPDXLicense.BSD_4_3RENO;
            }
            if ("BSD-4.3TAHOE".equals(codeString)) {
                return SPDXLicense.BSD_4_3TAHOE;
            }
            if ("BSD-Advertising-Acknowledgement".equals(codeString)) {
                return SPDXLicense.BSD_ADVERTISING_ACKNOWLEDGEMENT;
            }
            if ("BSD-Attribution-HPND-disclaimer".equals(codeString)) {
                return SPDXLicense.BSD_ATTRIBUTION_HPND_DISCLAIMER;
            }
            if ("BSD-Protection".equals(codeString)) {
                return SPDXLicense.BSD_PROTECTION;
            }
            if ("BSD-Source-Code".equals(codeString)) {
                return SPDXLicense.BSD_SOURCE_CODE;
            }
            if ("BSL-1.0".equals(codeString)) {
                return SPDXLicense.BSL_1_0;
            }
            if ("BUSL-1.1".equals(codeString)) {
                return SPDXLicense.BUSL_1_1;
            }
            if ("bzip2-1.0.5".equals(codeString)) {
                return SPDXLicense.BZIP2_1_0_5;
            }
            if ("bzip2-1.0.6".equals(codeString)) {
                return SPDXLicense.BZIP2_1_0_6;
            }
            if ("C-UDA-1.0".equals(codeString)) {
                return SPDXLicense.C_UDA_1_0;
            }
            if ("CAL-1.0".equals(codeString)) {
                return SPDXLicense.CAL_1_0;
            }
            if ("CAL-1.0-Combined-Work-Exception".equals(codeString)) {
                return SPDXLicense.CAL_1_0_COMBINED_WORK_EXCEPTION;
            }
            if ("Caldera".equals(codeString)) {
                return SPDXLicense.CALDERA;
            }
            if ("CATOSL-1.1".equals(codeString)) {
                return SPDXLicense.CATOSL_1_1;
            }
            if ("CC-BY-1.0".equals(codeString)) {
                return SPDXLicense.CC_BY_1_0;
            }
            if ("CC-BY-2.0".equals(codeString)) {
                return SPDXLicense.CC_BY_2_0;
            }
            if ("CC-BY-2.5".equals(codeString)) {
                return SPDXLicense.CC_BY_2_5;
            }
            if ("CC-BY-2.5-AU".equals(codeString)) {
                return SPDXLicense.CC_BY_2_5_AU;
            }
            if ("CC-BY-3.0".equals(codeString)) {
                return SPDXLicense.CC_BY_3_0;
            }
            if ("CC-BY-3.0-AT".equals(codeString)) {
                return SPDXLicense.CC_BY_3_0_AT;
            }
            if ("CC-BY-3.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_3_0_DE;
            }
            if ("CC-BY-3.0-IGO".equals(codeString)) {
                return SPDXLicense.CC_BY_3_0_IGO;
            }
            if ("CC-BY-3.0-NL".equals(codeString)) {
                return SPDXLicense.CC_BY_3_0_NL;
            }
            if ("CC-BY-3.0-US".equals(codeString)) {
                return SPDXLicense.CC_BY_3_0_US;
            }
            if ("CC-BY-4.0".equals(codeString)) {
                return SPDXLicense.CC_BY_4_0;
            }
            if ("CC-BY-NC-1.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_1_0;
            }
            if ("CC-BY-NC-2.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_2_0;
            }
            if ("CC-BY-NC-2.5".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_2_5;
            }
            if ("CC-BY-NC-3.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_3_0;
            }
            if ("CC-BY-NC-3.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_3_0_DE;
            }
            if ("CC-BY-NC-4.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_4_0;
            }
            if ("CC-BY-NC-ND-1.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_1_0;
            }
            if ("CC-BY-NC-ND-2.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_2_0;
            }
            if ("CC-BY-NC-ND-2.5".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_2_5;
            }
            if ("CC-BY-NC-ND-3.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_3_0;
            }
            if ("CC-BY-NC-ND-3.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_3_0_DE;
            }
            if ("CC-BY-NC-ND-3.0-IGO".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_3_0_IGO;
            }
            if ("CC-BY-NC-ND-4.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_ND_4_0;
            }
            if ("CC-BY-NC-SA-1.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_1_0;
            }
            if ("CC-BY-NC-SA-2.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_2_0;
            }
            if ("CC-BY-NC-SA-2.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_2_0_DE;
            }
            if ("CC-BY-NC-SA-2.0-FR".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_2_0_FR;
            }
            if ("CC-BY-NC-SA-2.0-UK".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_2_0_UK;
            }
            if ("CC-BY-NC-SA-2.5".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_2_5;
            }
            if ("CC-BY-NC-SA-3.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_3_0;
            }
            if ("CC-BY-NC-SA-3.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_3_0_DE;
            }
            if ("CC-BY-NC-SA-3.0-IGO".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_3_0_IGO;
            }
            if ("CC-BY-NC-SA-4.0".equals(codeString)) {
                return SPDXLicense.CC_BY_NC_SA_4_0;
            }
            if ("CC-BY-ND-1.0".equals(codeString)) {
                return SPDXLicense.CC_BY_ND_1_0;
            }
            if ("CC-BY-ND-2.0".equals(codeString)) {
                return SPDXLicense.CC_BY_ND_2_0;
            }
            if ("CC-BY-ND-2.5".equals(codeString)) {
                return SPDXLicense.CC_BY_ND_2_5;
            }
            if ("CC-BY-ND-3.0".equals(codeString)) {
                return SPDXLicense.CC_BY_ND_3_0;
            }
            if ("CC-BY-ND-3.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_ND_3_0_DE;
            }
            if ("CC-BY-ND-4.0".equals(codeString)) {
                return SPDXLicense.CC_BY_ND_4_0;
            }
            if ("CC-BY-SA-1.0".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_1_0;
            }
            if ("CC-BY-SA-2.0".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_2_0;
            }
            if ("CC-BY-SA-2.0-UK".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_2_0_UK;
            }
            if ("CC-BY-SA-2.1-JP".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_2_1_JP;
            }
            if ("CC-BY-SA-2.5".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_2_5;
            }
            if ("CC-BY-SA-3.0".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_3_0;
            }
            if ("CC-BY-SA-3.0-AT".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_3_0_AT;
            }
            if ("CC-BY-SA-3.0-DE".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_3_0_DE;
            }
            if ("CC-BY-SA-3.0-IGO".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_3_0_IGO;
            }
            if ("CC-BY-SA-4.0".equals(codeString)) {
                return SPDXLicense.CC_BY_SA_4_0;
            }
            if ("CC-PDDC".equals(codeString)) {
                return SPDXLicense.CC_PDDC;
            }
            if ("CC0-1.0".equals(codeString)) {
                return SPDXLicense.CC0_1_0;
            }
            if ("CDDL-1.0".equals(codeString)) {
                return SPDXLicense.CDDL_1_0;
            }
            if ("CDDL-1.1".equals(codeString)) {
                return SPDXLicense.CDDL_1_1;
            }
            if ("CDL-1.0".equals(codeString)) {
                return SPDXLicense.CDL_1_0;
            }
            if ("CDLA-Permissive-1.0".equals(codeString)) {
                return SPDXLicense.CDLA_PERMISSIVE_1_0;
            }
            if ("CDLA-Permissive-2.0".equals(codeString)) {
                return SPDXLicense.CDLA_PERMISSIVE_2_0;
            }
            if ("CDLA-Sharing-1.0".equals(codeString)) {
                return SPDXLicense.CDLA_SHARING_1_0;
            }
            if ("CECILL-1.0".equals(codeString)) {
                return SPDXLicense.CECILL_1_0;
            }
            if ("CECILL-1.1".equals(codeString)) {
                return SPDXLicense.CECILL_1_1;
            }
            if ("CECILL-2.0".equals(codeString)) {
                return SPDXLicense.CECILL_2_0;
            }
            if ("CECILL-2.1".equals(codeString)) {
                return SPDXLicense.CECILL_2_1;
            }
            if ("CECILL-B".equals(codeString)) {
                return SPDXLicense.CECILL_B;
            }
            if ("CECILL-C".equals(codeString)) {
                return SPDXLicense.CECILL_C;
            }
            if ("CERN-OHL-1.1".equals(codeString)) {
                return SPDXLicense.CERN_OHL_1_1;
            }
            if ("CERN-OHL-1.2".equals(codeString)) {
                return SPDXLicense.CERN_OHL_1_2;
            }
            if ("CERN-OHL-P-2.0".equals(codeString)) {
                return SPDXLicense.CERN_OHL_P_2_0;
            }
            if ("CERN-OHL-S-2.0".equals(codeString)) {
                return SPDXLicense.CERN_OHL_S_2_0;
            }
            if ("CERN-OHL-W-2.0".equals(codeString)) {
                return SPDXLicense.CERN_OHL_W_2_0;
            }
            if ("CFITSIO".equals(codeString)) {
                return SPDXLicense.CFITSIO;
            }
            if ("checkmk".equals(codeString)) {
                return SPDXLicense.CHECKMK;
            }
            if ("ClArtistic".equals(codeString)) {
                return SPDXLicense.CLARTISTIC;
            }
            if ("Clips".equals(codeString)) {
                return SPDXLicense.CLIPS;
            }
            if ("CMU-Mach".equals(codeString)) {
                return SPDXLicense.CMU_MACH;
            }
            if ("CNRI-Jython".equals(codeString)) {
                return SPDXLicense.CNRI_JYTHON;
            }
            if ("CNRI-Python".equals(codeString)) {
                return SPDXLicense.CNRI_PYTHON;
            }
            if ("CNRI-Python-GPL-Compatible".equals(codeString)) {
                return SPDXLicense.CNRI_PYTHON_GPL_COMPATIBLE;
            }
            if ("COIL-1.0".equals(codeString)) {
                return SPDXLicense.COIL_1_0;
            }
            if ("Community-Spec-1.0".equals(codeString)) {
                return SPDXLicense.COMMUNITY_SPEC_1_0;
            }
            if ("Condor-1.1".equals(codeString)) {
                return SPDXLicense.CONDOR_1_1;
            }
            if ("copyleft-next-0.3.0".equals(codeString)) {
                return SPDXLicense.COPYLEFT_NEXT_0_3_0;
            }
            if ("copyleft-next-0.3.1".equals(codeString)) {
                return SPDXLicense.COPYLEFT_NEXT_0_3_1;
            }
            if ("Cornell-Lossless-JPEG".equals(codeString)) {
                return SPDXLicense.CORNELL_LOSSLESS_JPEG;
            }
            if ("CPAL-1.0".equals(codeString)) {
                return SPDXLicense.CPAL_1_0;
            }
            if ("CPL-1.0".equals(codeString)) {
                return SPDXLicense.CPL_1_0;
            }
            if ("CPOL-1.02".equals(codeString)) {
                return SPDXLicense.CPOL_1_02;
            }
            if ("Crossword".equals(codeString)) {
                return SPDXLicense.CROSSWORD;
            }
            if ("CrystalStacker".equals(codeString)) {
                return SPDXLicense.CRYSTALSTACKER;
            }
            if ("CUA-OPL-1.0".equals(codeString)) {
                return SPDXLicense.CUA_OPL_1_0;
            }
            if ("Cube".equals(codeString)) {
                return SPDXLicense.CUBE;
            }
            if ("curl".equals(codeString)) {
                return SPDXLicense.CURL;
            }
            if ("D-FSL-1.0".equals(codeString)) {
                return SPDXLicense.D_FSL_1_0;
            }
            if ("diffmark".equals(codeString)) {
                return SPDXLicense.DIFFMARK;
            }
            if ("DL-DE-BY-2.0".equals(codeString)) {
                return SPDXLicense.DL_DE_BY_2_0;
            }
            if ("DOC".equals(codeString)) {
                return SPDXLicense.DOC;
            }
            if ("Dotseqn".equals(codeString)) {
                return SPDXLicense.DOTSEQN;
            }
            if ("DRL-1.0".equals(codeString)) {
                return SPDXLicense.DRL_1_0;
            }
            if ("DSDP".equals(codeString)) {
                return SPDXLicense.DSDP;
            }
            if ("dtoa".equals(codeString)) {
                return SPDXLicense.DTOA;
            }
            if ("dvipdfm".equals(codeString)) {
                return SPDXLicense.DVIPDFM;
            }
            if ("ECL-1.0".equals(codeString)) {
                return SPDXLicense.ECL_1_0;
            }
            if ("ECL-2.0".equals(codeString)) {
                return SPDXLicense.ECL_2_0;
            }
            if ("eCos-2.0".equals(codeString)) {
                return SPDXLicense.ECOS_2_0;
            }
            if ("EFL-1.0".equals(codeString)) {
                return SPDXLicense.EFL_1_0;
            }
            if ("EFL-2.0".equals(codeString)) {
                return SPDXLicense.EFL_2_0;
            }
            if ("eGenix".equals(codeString)) {
                return SPDXLicense.EGENIX;
            }
            if ("Elastic-2.0".equals(codeString)) {
                return SPDXLicense.ELASTIC_2_0;
            }
            if ("Entessa".equals(codeString)) {
                return SPDXLicense.ENTESSA;
            }
            if ("EPICS".equals(codeString)) {
                return SPDXLicense.EPICS;
            }
            if ("EPL-1.0".equals(codeString)) {
                return SPDXLicense.EPL_1_0;
            }
            if ("EPL-2.0".equals(codeString)) {
                return SPDXLicense.EPL_2_0;
            }
            if ("ErlPL-1.1".equals(codeString)) {
                return SPDXLicense.ERLPL_1_1;
            }
            if ("etalab-2.0".equals(codeString)) {
                return SPDXLicense.ETALAB_2_0;
            }
            if ("EUDatagrid".equals(codeString)) {
                return SPDXLicense.EUDATAGRID;
            }
            if ("EUPL-1.0".equals(codeString)) {
                return SPDXLicense.EUPL_1_0;
            }
            if ("EUPL-1.1".equals(codeString)) {
                return SPDXLicense.EUPL_1_1;
            }
            if ("EUPL-1.2".equals(codeString)) {
                return SPDXLicense.EUPL_1_2;
            }
            if ("Eurosym".equals(codeString)) {
                return SPDXLicense.EUROSYM;
            }
            if ("Fair".equals(codeString)) {
                return SPDXLicense.FAIR;
            }
            if ("FDK-AAC".equals(codeString)) {
                return SPDXLicense.FDK_AAC;
            }
            if ("Frameworx-1.0".equals(codeString)) {
                return SPDXLicense.FRAMEWORX_1_0;
            }
            if ("FreeBSD-DOC".equals(codeString)) {
                return SPDXLicense.FREEBSD_DOC;
            }
            if ("FreeImage".equals(codeString)) {
                return SPDXLicense.FREEIMAGE;
            }
            if ("FSFAP".equals(codeString)) {
                return SPDXLicense.FSFAP;
            }
            if ("FSFUL".equals(codeString)) {
                return SPDXLicense.FSFUL;
            }
            if ("FSFULLR".equals(codeString)) {
                return SPDXLicense.FSFULLR;
            }
            if ("FSFULLRWD".equals(codeString)) {
                return SPDXLicense.FSFULLRWD;
            }
            if ("FTL".equals(codeString)) {
                return SPDXLicense.FTL;
            }
            if ("GD".equals(codeString)) {
                return SPDXLicense.GD;
            }
            if ("GFDL-1.1".equals(codeString)) {
                return SPDXLicense.GFDL_1_1;
            }
            if ("GFDL-1.1-invariants-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_1_INVARIANTS_ONLY;
            }
            if ("GFDL-1.1-invariants-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_1_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.1-no-invariants-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_1_NO_INVARIANTS_ONLY;
            }
            if ("GFDL-1.1-no-invariants-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_1_NO_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.1-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_1_ONLY;
            }
            if ("GFDL-1.1-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_1_OR_LATER;
            }
            if ("GFDL-1.2".equals(codeString)) {
                return SPDXLicense.GFDL_1_2;
            }
            if ("GFDL-1.2-invariants-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_2_INVARIANTS_ONLY;
            }
            if ("GFDL-1.2-invariants-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_2_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.2-no-invariants-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_2_NO_INVARIANTS_ONLY;
            }
            if ("GFDL-1.2-no-invariants-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_2_NO_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.2-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_2_ONLY;
            }
            if ("GFDL-1.2-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_2_OR_LATER;
            }
            if ("GFDL-1.3".equals(codeString)) {
                return SPDXLicense.GFDL_1_3;
            }
            if ("GFDL-1.3-invariants-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_3_INVARIANTS_ONLY;
            }
            if ("GFDL-1.3-invariants-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_3_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.3-no-invariants-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_3_NO_INVARIANTS_ONLY;
            }
            if ("GFDL-1.3-no-invariants-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_3_NO_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.3-only".equals(codeString)) {
                return SPDXLicense.GFDL_1_3_ONLY;
            }
            if ("GFDL-1.3-or-later".equals(codeString)) {
                return SPDXLicense.GFDL_1_3_OR_LATER;
            }
            if ("Giftware".equals(codeString)) {
                return SPDXLicense.GIFTWARE;
            }
            if ("GL2PS".equals(codeString)) {
                return SPDXLicense.GL2PS;
            }
            if ("Glide".equals(codeString)) {
                return SPDXLicense.GLIDE;
            }
            if ("Glulxe".equals(codeString)) {
                return SPDXLicense.GLULXE;
            }
            if ("GLWTPL".equals(codeString)) {
                return SPDXLicense.GLWTPL;
            }
            if ("gnuplot".equals(codeString)) {
                return SPDXLicense.GNUPLOT;
            }
            if ("GPL-1.0".equals(codeString)) {
                return SPDXLicense.GPL_1_0;
            }
            if ("GPL-1.0+".equals(codeString)) {
                return SPDXLicense.GPL_1_0PLUS;
            }
            if ("GPL-1.0-only".equals(codeString)) {
                return SPDXLicense.GPL_1_0_ONLY;
            }
            if ("GPL-1.0-or-later".equals(codeString)) {
                return SPDXLicense.GPL_1_0_OR_LATER;
            }
            if ("GPL-2.0".equals(codeString)) {
                return SPDXLicense.GPL_2_0;
            }
            if ("GPL-2.0+".equals(codeString)) {
                return SPDXLicense.GPL_2_0PLUS;
            }
            if ("GPL-2.0-only".equals(codeString)) {
                return SPDXLicense.GPL_2_0_ONLY;
            }
            if ("GPL-2.0-or-later".equals(codeString)) {
                return SPDXLicense.GPL_2_0_OR_LATER;
            }
            if ("GPL-2.0-with-autoconf-exception".equals(codeString)) {
                return SPDXLicense.GPL_2_0_WITH_AUTOCONF_EXCEPTION;
            }
            if ("GPL-2.0-with-bison-exception".equals(codeString)) {
                return SPDXLicense.GPL_2_0_WITH_BISON_EXCEPTION;
            }
            if ("GPL-2.0-with-classpath-exception".equals(codeString)) {
                return SPDXLicense.GPL_2_0_WITH_CLASSPATH_EXCEPTION;
            }
            if ("GPL-2.0-with-font-exception".equals(codeString)) {
                return SPDXLicense.GPL_2_0_WITH_FONT_EXCEPTION;
            }
            if ("GPL-2.0-with-GCC-exception".equals(codeString)) {
                return SPDXLicense.GPL_2_0_WITH_GCC_EXCEPTION;
            }
            if ("GPL-3.0".equals(codeString)) {
                return SPDXLicense.GPL_3_0;
            }
            if ("GPL-3.0+".equals(codeString)) {
                return SPDXLicense.GPL_3_0PLUS;
            }
            if ("GPL-3.0-only".equals(codeString)) {
                return SPDXLicense.GPL_3_0_ONLY;
            }
            if ("GPL-3.0-or-later".equals(codeString)) {
                return SPDXLicense.GPL_3_0_OR_LATER;
            }
            if ("GPL-3.0-with-autoconf-exception".equals(codeString)) {
                return SPDXLicense.GPL_3_0_WITH_AUTOCONF_EXCEPTION;
            }
            if ("GPL-3.0-with-GCC-exception".equals(codeString)) {
                return SPDXLicense.GPL_3_0_WITH_GCC_EXCEPTION;
            }
            if ("Graphics-Gems".equals(codeString)) {
                return SPDXLicense.GRAPHICS_GEMS;
            }
            if ("gSOAP-1.3b".equals(codeString)) {
                return SPDXLicense.GSOAP_1_3B;
            }
            if ("HaskellReport".equals(codeString)) {
                return SPDXLicense.HASKELLREPORT;
            }
            if ("Hippocratic-2.1".equals(codeString)) {
                return SPDXLicense.HIPPOCRATIC_2_1;
            }
            if ("HP-1986".equals(codeString)) {
                return SPDXLicense.HP_1986;
            }
            if ("HPND".equals(codeString)) {
                return SPDXLicense.HPND;
            }
            if ("HPND-export-US".equals(codeString)) {
                return SPDXLicense.HPND_EXPORT_US;
            }
            if ("HPND-Markus-Kuhn".equals(codeString)) {
                return SPDXLicense.HPND_MARKUS_KUHN;
            }
            if ("HPND-sell-variant".equals(codeString)) {
                return SPDXLicense.HPND_SELL_VARIANT;
            }
            if ("HPND-sell-variant-MIT-disclaimer".equals(codeString)) {
                return SPDXLicense.HPND_SELL_VARIANT_MIT_DISCLAIMER;
            }
            if ("HTMLTIDY".equals(codeString)) {
                return SPDXLicense.HTMLTIDY;
            }
            if ("IBM-pibs".equals(codeString)) {
                return SPDXLicense.IBM_PIBS;
            }
            if ("ICU".equals(codeString)) {
                return SPDXLicense.ICU;
            }
            if ("IEC-Code-Components-EULA".equals(codeString)) {
                return SPDXLicense.IEC_CODE_COMPONENTS_EULA;
            }
            if ("IJG".equals(codeString)) {
                return SPDXLicense.IJG;
            }
            if ("IJG-short".equals(codeString)) {
                return SPDXLicense.IJG_SHORT;
            }
            if ("ImageMagick".equals(codeString)) {
                return SPDXLicense.IMAGEMAGICK;
            }
            if ("iMatix".equals(codeString)) {
                return SPDXLicense.IMATIX;
            }
            if ("Imlib2".equals(codeString)) {
                return SPDXLicense.IMLIB2;
            }
            if ("Info-ZIP".equals(codeString)) {
                return SPDXLicense.INFO_ZIP;
            }
            if ("Inner-Net-2.0".equals(codeString)) {
                return SPDXLicense.INNER_NET_2_0;
            }
            if ("Intel".equals(codeString)) {
                return SPDXLicense.INTEL;
            }
            if ("Intel-ACPI".equals(codeString)) {
                return SPDXLicense.INTEL_ACPI;
            }
            if ("Interbase-1.0".equals(codeString)) {
                return SPDXLicense.INTERBASE_1_0;
            }
            if ("IPA".equals(codeString)) {
                return SPDXLicense.IPA;
            }
            if ("IPL-1.0".equals(codeString)) {
                return SPDXLicense.IPL_1_0;
            }
            if ("ISC".equals(codeString)) {
                return SPDXLicense.ISC;
            }
            if ("Jam".equals(codeString)) {
                return SPDXLicense.JAM;
            }
            if ("JasPer-2.0".equals(codeString)) {
                return SPDXLicense.JASPER_2_0;
            }
            if ("JPL-image".equals(codeString)) {
                return SPDXLicense.JPL_IMAGE;
            }
            if ("JPNIC".equals(codeString)) {
                return SPDXLicense.JPNIC;
            }
            if ("JSON".equals(codeString)) {
                return SPDXLicense.JSON;
            }
            if ("Kazlib".equals(codeString)) {
                return SPDXLicense.KAZLIB;
            }
            if ("Knuth-CTAN".equals(codeString)) {
                return SPDXLicense.KNUTH_CTAN;
            }
            if ("LAL-1.2".equals(codeString)) {
                return SPDXLicense.LAL_1_2;
            }
            if ("LAL-1.3".equals(codeString)) {
                return SPDXLicense.LAL_1_3;
            }
            if ("Latex2e".equals(codeString)) {
                return SPDXLicense.LATEX2E;
            }
            if ("Latex2e-translated-notice".equals(codeString)) {
                return SPDXLicense.LATEX2E_TRANSLATED_NOTICE;
            }
            if ("Leptonica".equals(codeString)) {
                return SPDXLicense.LEPTONICA;
            }
            if ("LGPL-2.0".equals(codeString)) {
                return SPDXLicense.LGPL_2_0;
            }
            if ("LGPL-2.0+".equals(codeString)) {
                return SPDXLicense.LGPL_2_0PLUS;
            }
            if ("LGPL-2.0-only".equals(codeString)) {
                return SPDXLicense.LGPL_2_0_ONLY;
            }
            if ("LGPL-2.0-or-later".equals(codeString)) {
                return SPDXLicense.LGPL_2_0_OR_LATER;
            }
            if ("LGPL-2.1".equals(codeString)) {
                return SPDXLicense.LGPL_2_1;
            }
            if ("LGPL-2.1+".equals(codeString)) {
                return SPDXLicense.LGPL_2_1PLUS;
            }
            if ("LGPL-2.1-only".equals(codeString)) {
                return SPDXLicense.LGPL_2_1_ONLY;
            }
            if ("LGPL-2.1-or-later".equals(codeString)) {
                return SPDXLicense.LGPL_2_1_OR_LATER;
            }
            if ("LGPL-3.0".equals(codeString)) {
                return SPDXLicense.LGPL_3_0;
            }
            if ("LGPL-3.0+".equals(codeString)) {
                return SPDXLicense.LGPL_3_0PLUS;
            }
            if ("LGPL-3.0-only".equals(codeString)) {
                return SPDXLicense.LGPL_3_0_ONLY;
            }
            if ("LGPL-3.0-or-later".equals(codeString)) {
                return SPDXLicense.LGPL_3_0_OR_LATER;
            }
            if ("LGPLLR".equals(codeString)) {
                return SPDXLicense.LGPLLR;
            }
            if ("Libpng".equals(codeString)) {
                return SPDXLicense.LIBPNG;
            }
            if ("libpng-2.0".equals(codeString)) {
                return SPDXLicense.LIBPNG_2_0;
            }
            if ("libselinux-1.0".equals(codeString)) {
                return SPDXLicense.LIBSELINUX_1_0;
            }
            if ("libtiff".equals(codeString)) {
                return SPDXLicense.LIBTIFF;
            }
            if ("libutil-David-Nugent".equals(codeString)) {
                return SPDXLicense.LIBUTIL_DAVID_NUGENT;
            }
            if ("LiLiQ-P-1.1".equals(codeString)) {
                return SPDXLicense.LILIQ_P_1_1;
            }
            if ("LiLiQ-R-1.1".equals(codeString)) {
                return SPDXLicense.LILIQ_R_1_1;
            }
            if ("LiLiQ-Rplus-1.1".equals(codeString)) {
                return SPDXLicense.LILIQ_RPLUS_1_1;
            }
            if ("Linux-man-pages-1-para".equals(codeString)) {
                return SPDXLicense.LINUX_MAN_PAGES_1_PARA;
            }
            if ("Linux-man-pages-copyleft".equals(codeString)) {
                return SPDXLicense.LINUX_MAN_PAGES_COPYLEFT;
            }
            if ("Linux-man-pages-copyleft-2-para".equals(codeString)) {
                return SPDXLicense.LINUX_MAN_PAGES_COPYLEFT_2_PARA;
            }
            if ("Linux-man-pages-copyleft-var".equals(codeString)) {
                return SPDXLicense.LINUX_MAN_PAGES_COPYLEFT_VAR;
            }
            if ("Linux-OpenIB".equals(codeString)) {
                return SPDXLicense.LINUX_OPENIB;
            }
            if ("LOOP".equals(codeString)) {
                return SPDXLicense.LOOP;
            }
            if ("LPL-1.0".equals(codeString)) {
                return SPDXLicense.LPL_1_0;
            }
            if ("LPL-1.02".equals(codeString)) {
                return SPDXLicense.LPL_1_02;
            }
            if ("LPPL-1.0".equals(codeString)) {
                return SPDXLicense.LPPL_1_0;
            }
            if ("LPPL-1.1".equals(codeString)) {
                return SPDXLicense.LPPL_1_1;
            }
            if ("LPPL-1.2".equals(codeString)) {
                return SPDXLicense.LPPL_1_2;
            }
            if ("LPPL-1.3a".equals(codeString)) {
                return SPDXLicense.LPPL_1_3A;
            }
            if ("LPPL-1.3c".equals(codeString)) {
                return SPDXLicense.LPPL_1_3C;
            }
            if ("LZMA-SDK-9.11-to-9.20".equals(codeString)) {
                return SPDXLicense.LZMA_SDK_9_11_TO_9_20;
            }
            if ("LZMA-SDK-9.22".equals(codeString)) {
                return SPDXLicense.LZMA_SDK_9_22;
            }
            if ("MakeIndex".equals(codeString)) {
                return SPDXLicense.MAKEINDEX;
            }
            if ("Martin-Birgmeier".equals(codeString)) {
                return SPDXLicense.MARTIN_BIRGMEIER;
            }
            if ("metamail".equals(codeString)) {
                return SPDXLicense.METAMAIL;
            }
            if ("Minpack".equals(codeString)) {
                return SPDXLicense.MINPACK;
            }
            if ("MirOS".equals(codeString)) {
                return SPDXLicense.MIROS;
            }
            if ("MIT".equals(codeString)) {
                return SPDXLicense.MIT;
            }
            if ("MIT-0".equals(codeString)) {
                return SPDXLicense.MIT_0;
            }
            if ("MIT-advertising".equals(codeString)) {
                return SPDXLicense.MIT_ADVERTISING;
            }
            if ("MIT-CMU".equals(codeString)) {
                return SPDXLicense.MIT_CMU;
            }
            if ("MIT-enna".equals(codeString)) {
                return SPDXLicense.MIT_ENNA;
            }
            if ("MIT-feh".equals(codeString)) {
                return SPDXLicense.MIT_FEH;
            }
            if ("MIT-Festival".equals(codeString)) {
                return SPDXLicense.MIT_FESTIVAL;
            }
            if ("MIT-Modern-Variant".equals(codeString)) {
                return SPDXLicense.MIT_MODERN_VARIANT;
            }
            if ("MIT-open-group".equals(codeString)) {
                return SPDXLicense.MIT_OPEN_GROUP;
            }
            if ("MIT-Wu".equals(codeString)) {
                return SPDXLicense.MIT_WU;
            }
            if ("MITNFA".equals(codeString)) {
                return SPDXLicense.MITNFA;
            }
            if ("Motosoto".equals(codeString)) {
                return SPDXLicense.MOTOSOTO;
            }
            if ("mpi-permissive".equals(codeString)) {
                return SPDXLicense.MPI_PERMISSIVE;
            }
            if ("mpich2".equals(codeString)) {
                return SPDXLicense.MPICH2;
            }
            if ("MPL-1.0".equals(codeString)) {
                return SPDXLicense.MPL_1_0;
            }
            if ("MPL-1.1".equals(codeString)) {
                return SPDXLicense.MPL_1_1;
            }
            if ("MPL-2.0".equals(codeString)) {
                return SPDXLicense.MPL_2_0;
            }
            if ("MPL-2.0-no-copyleft-exception".equals(codeString)) {
                return SPDXLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION;
            }
            if ("mplus".equals(codeString)) {
                return SPDXLicense.MPLUS;
            }
            if ("MS-LPL".equals(codeString)) {
                return SPDXLicense.MS_LPL;
            }
            if ("MS-PL".equals(codeString)) {
                return SPDXLicense.MS_PL;
            }
            if ("MS-RL".equals(codeString)) {
                return SPDXLicense.MS_RL;
            }
            if ("MTLL".equals(codeString)) {
                return SPDXLicense.MTLL;
            }
            if ("MulanPSL-1.0".equals(codeString)) {
                return SPDXLicense.MULANPSL_1_0;
            }
            if ("MulanPSL-2.0".equals(codeString)) {
                return SPDXLicense.MULANPSL_2_0;
            }
            if ("Multics".equals(codeString)) {
                return SPDXLicense.MULTICS;
            }
            if ("Mup".equals(codeString)) {
                return SPDXLicense.MUP;
            }
            if ("NAIST-2003".equals(codeString)) {
                return SPDXLicense.NAIST_2003;
            }
            if ("NASA-1.3".equals(codeString)) {
                return SPDXLicense.NASA_1_3;
            }
            if ("Naumen".equals(codeString)) {
                return SPDXLicense.NAUMEN;
            }
            if ("NBPL-1.0".equals(codeString)) {
                return SPDXLicense.NBPL_1_0;
            }
            if ("NCGL-UK-2.0".equals(codeString)) {
                return SPDXLicense.NCGL_UK_2_0;
            }
            if ("NCSA".equals(codeString)) {
                return SPDXLicense.NCSA;
            }
            if ("Net-SNMP".equals(codeString)) {
                return SPDXLicense.NET_SNMP;
            }
            if ("NetCDF".equals(codeString)) {
                return SPDXLicense.NETCDF;
            }
            if ("Newsletr".equals(codeString)) {
                return SPDXLicense.NEWSLETR;
            }
            if ("NGPL".equals(codeString)) {
                return SPDXLicense.NGPL;
            }
            if ("NICTA-1.0".equals(codeString)) {
                return SPDXLicense.NICTA_1_0;
            }
            if ("NIST-PD".equals(codeString)) {
                return SPDXLicense.NIST_PD;
            }
            if ("NIST-PD-fallback".equals(codeString)) {
                return SPDXLicense.NIST_PD_FALLBACK;
            }
            if ("NIST-Software".equals(codeString)) {
                return SPDXLicense.NIST_SOFTWARE;
            }
            if ("NLOD-1.0".equals(codeString)) {
                return SPDXLicense.NLOD_1_0;
            }
            if ("NLOD-2.0".equals(codeString)) {
                return SPDXLicense.NLOD_2_0;
            }
            if ("NLPL".equals(codeString)) {
                return SPDXLicense.NLPL;
            }
            if ("Nokia".equals(codeString)) {
                return SPDXLicense.NOKIA;
            }
            if ("NOSL".equals(codeString)) {
                return SPDXLicense.NOSL;
            }
            if ("not-open-source".equals(codeString)) {
                return SPDXLicense.NOT_OPEN_SOURCE;
            }
            if ("Noweb".equals(codeString)) {
                return SPDXLicense.NOWEB;
            }
            if ("NPL-1.0".equals(codeString)) {
                return SPDXLicense.NPL_1_0;
            }
            if ("NPL-1.1".equals(codeString)) {
                return SPDXLicense.NPL_1_1;
            }
            if ("NPOSL-3.0".equals(codeString)) {
                return SPDXLicense.NPOSL_3_0;
            }
            if ("NRL".equals(codeString)) {
                return SPDXLicense.NRL;
            }
            if ("NTP".equals(codeString)) {
                return SPDXLicense.NTP;
            }
            if ("NTP-0".equals(codeString)) {
                return SPDXLicense.NTP_0;
            }
            if ("Nunit".equals(codeString)) {
                return SPDXLicense.NUNIT;
            }
            if ("O-UDA-1.0".equals(codeString)) {
                return SPDXLicense.O_UDA_1_0;
            }
            if ("OCCT-PL".equals(codeString)) {
                return SPDXLicense.OCCT_PL;
            }
            if ("OCLC-2.0".equals(codeString)) {
                return SPDXLicense.OCLC_2_0;
            }
            if ("ODbL-1.0".equals(codeString)) {
                return SPDXLicense.ODBL_1_0;
            }
            if ("ODC-By-1.0".equals(codeString)) {
                return SPDXLicense.ODC_BY_1_0;
            }
            if ("OFFIS".equals(codeString)) {
                return SPDXLicense.OFFIS;
            }
            if ("OFL-1.0".equals(codeString)) {
                return SPDXLicense.OFL_1_0;
            }
            if ("OFL-1.0-no-RFN".equals(codeString)) {
                return SPDXLicense.OFL_1_0_NO_RFN;
            }
            if ("OFL-1.0-RFN".equals(codeString)) {
                return SPDXLicense.OFL_1_0_RFN;
            }
            if ("OFL-1.1".equals(codeString)) {
                return SPDXLicense.OFL_1_1;
            }
            if ("OFL-1.1-no-RFN".equals(codeString)) {
                return SPDXLicense.OFL_1_1_NO_RFN;
            }
            if ("OFL-1.1-RFN".equals(codeString)) {
                return SPDXLicense.OFL_1_1_RFN;
            }
            if ("OGC-1.0".equals(codeString)) {
                return SPDXLicense.OGC_1_0;
            }
            if ("OGDL-Taiwan-1.0".equals(codeString)) {
                return SPDXLicense.OGDL_TAIWAN_1_0;
            }
            if ("OGL-Canada-2.0".equals(codeString)) {
                return SPDXLicense.OGL_CANADA_2_0;
            }
            if ("OGL-UK-1.0".equals(codeString)) {
                return SPDXLicense.OGL_UK_1_0;
            }
            if ("OGL-UK-2.0".equals(codeString)) {
                return SPDXLicense.OGL_UK_2_0;
            }
            if ("OGL-UK-3.0".equals(codeString)) {
                return SPDXLicense.OGL_UK_3_0;
            }
            if ("OGTSL".equals(codeString)) {
                return SPDXLicense.OGTSL;
            }
            if ("OLDAP-1.1".equals(codeString)) {
                return SPDXLicense.OLDAP_1_1;
            }
            if ("OLDAP-1.2".equals(codeString)) {
                return SPDXLicense.OLDAP_1_2;
            }
            if ("OLDAP-1.3".equals(codeString)) {
                return SPDXLicense.OLDAP_1_3;
            }
            if ("OLDAP-1.4".equals(codeString)) {
                return SPDXLicense.OLDAP_1_4;
            }
            if ("OLDAP-2.0".equals(codeString)) {
                return SPDXLicense.OLDAP_2_0;
            }
            if ("OLDAP-2.0.1".equals(codeString)) {
                return SPDXLicense.OLDAP_2_0_1;
            }
            if ("OLDAP-2.1".equals(codeString)) {
                return SPDXLicense.OLDAP_2_1;
            }
            if ("OLDAP-2.2".equals(codeString)) {
                return SPDXLicense.OLDAP_2_2;
            }
            if ("OLDAP-2.2.1".equals(codeString)) {
                return SPDXLicense.OLDAP_2_2_1;
            }
            if ("OLDAP-2.2.2".equals(codeString)) {
                return SPDXLicense.OLDAP_2_2_2;
            }
            if ("OLDAP-2.3".equals(codeString)) {
                return SPDXLicense.OLDAP_2_3;
            }
            if ("OLDAP-2.4".equals(codeString)) {
                return SPDXLicense.OLDAP_2_4;
            }
            if ("OLDAP-2.5".equals(codeString)) {
                return SPDXLicense.OLDAP_2_5;
            }
            if ("OLDAP-2.6".equals(codeString)) {
                return SPDXLicense.OLDAP_2_6;
            }
            if ("OLDAP-2.7".equals(codeString)) {
                return SPDXLicense.OLDAP_2_7;
            }
            if ("OLDAP-2.8".equals(codeString)) {
                return SPDXLicense.OLDAP_2_8;
            }
            if ("OLFL-1.3".equals(codeString)) {
                return SPDXLicense.OLFL_1_3;
            }
            if ("OML".equals(codeString)) {
                return SPDXLicense.OML;
            }
            if ("OpenPBS-2.3".equals(codeString)) {
                return SPDXLicense.OPENPBS_2_3;
            }
            if ("OpenSSL".equals(codeString)) {
                return SPDXLicense.OPENSSL;
            }
            if ("OPL-1.0".equals(codeString)) {
                return SPDXLicense.OPL_1_0;
            }
            if ("OPL-UK-3.0".equals(codeString)) {
                return SPDXLicense.OPL_UK_3_0;
            }
            if ("OPUBL-1.0".equals(codeString)) {
                return SPDXLicense.OPUBL_1_0;
            }
            if ("OSET-PL-2.1".equals(codeString)) {
                return SPDXLicense.OSET_PL_2_1;
            }
            if ("OSL-1.0".equals(codeString)) {
                return SPDXLicense.OSL_1_0;
            }
            if ("OSL-1.1".equals(codeString)) {
                return SPDXLicense.OSL_1_1;
            }
            if ("OSL-2.0".equals(codeString)) {
                return SPDXLicense.OSL_2_0;
            }
            if ("OSL-2.1".equals(codeString)) {
                return SPDXLicense.OSL_2_1;
            }
            if ("OSL-3.0".equals(codeString)) {
                return SPDXLicense.OSL_3_0;
            }
            if ("Parity-6.0.0".equals(codeString)) {
                return SPDXLicense.PARITY_6_0_0;
            }
            if ("Parity-7.0.0".equals(codeString)) {
                return SPDXLicense.PARITY_7_0_0;
            }
            if ("PDDL-1.0".equals(codeString)) {
                return SPDXLicense.PDDL_1_0;
            }
            if ("PHP-3.0".equals(codeString)) {
                return SPDXLicense.PHP_3_0;
            }
            if ("PHP-3.01".equals(codeString)) {
                return SPDXLicense.PHP_3_01;
            }
            if ("Plexus".equals(codeString)) {
                return SPDXLicense.PLEXUS;
            }
            if ("PolyForm-Noncommercial-1.0.0".equals(codeString)) {
                return SPDXLicense.POLYFORM_NONCOMMERCIAL_1_0_0;
            }
            if ("PolyForm-Small-Business-1.0.0".equals(codeString)) {
                return SPDXLicense.POLYFORM_SMALL_BUSINESS_1_0_0;
            }
            if ("PostgreSQL".equals(codeString)) {
                return SPDXLicense.POSTGRESQL;
            }
            if ("PSF-2.0".equals(codeString)) {
                return SPDXLicense.PSF_2_0;
            }
            if ("psfrag".equals(codeString)) {
                return SPDXLicense.PSFRAG;
            }
            if ("psutils".equals(codeString)) {
                return SPDXLicense.PSUTILS;
            }
            if ("Python-2.0".equals(codeString)) {
                return SPDXLicense.PYTHON_2_0;
            }
            if ("Python-2.0.1".equals(codeString)) {
                return SPDXLicense.PYTHON_2_0_1;
            }
            if ("Qhull".equals(codeString)) {
                return SPDXLicense.QHULL;
            }
            if ("QPL-1.0".equals(codeString)) {
                return SPDXLicense.QPL_1_0;
            }
            if ("QPL-1.0-INRIA-2004".equals(codeString)) {
                return SPDXLicense.QPL_1_0_INRIA_2004;
            }
            if ("Rdisc".equals(codeString)) {
                return SPDXLicense.RDISC;
            }
            if ("RHeCos-1.1".equals(codeString)) {
                return SPDXLicense.RHECOS_1_1;
            }
            if ("RPL-1.1".equals(codeString)) {
                return SPDXLicense.RPL_1_1;
            }
            if ("RPL-1.5".equals(codeString)) {
                return SPDXLicense.RPL_1_5;
            }
            if ("RPSL-1.0".equals(codeString)) {
                return SPDXLicense.RPSL_1_0;
            }
            if ("RSA-MD".equals(codeString)) {
                return SPDXLicense.RSA_MD;
            }
            if ("RSCPL".equals(codeString)) {
                return SPDXLicense.RSCPL;
            }
            if ("Ruby".equals(codeString)) {
                return SPDXLicense.RUBY;
            }
            if ("SAX-PD".equals(codeString)) {
                return SPDXLicense.SAX_PD;
            }
            if ("Saxpath".equals(codeString)) {
                return SPDXLicense.SAXPATH;
            }
            if ("SCEA".equals(codeString)) {
                return SPDXLicense.SCEA;
            }
            if ("SchemeReport".equals(codeString)) {
                return SPDXLicense.SCHEMEREPORT;
            }
            if ("Sendmail".equals(codeString)) {
                return SPDXLicense.SENDMAIL;
            }
            if ("Sendmail-8.23".equals(codeString)) {
                return SPDXLicense.SENDMAIL_8_23;
            }
            if ("SGI-B-1.0".equals(codeString)) {
                return SPDXLicense.SGI_B_1_0;
            }
            if ("SGI-B-1.1".equals(codeString)) {
                return SPDXLicense.SGI_B_1_1;
            }
            if ("SGI-B-2.0".equals(codeString)) {
                return SPDXLicense.SGI_B_2_0;
            }
            if ("SGP4".equals(codeString)) {
                return SPDXLicense.SGP4;
            }
            if ("SHL-0.5".equals(codeString)) {
                return SPDXLicense.SHL_0_5;
            }
            if ("SHL-0.51".equals(codeString)) {
                return SPDXLicense.SHL_0_51;
            }
            if ("SimPL-2.0".equals(codeString)) {
                return SPDXLicense.SIMPL_2_0;
            }
            if ("SISSL".equals(codeString)) {
                return SPDXLicense.SISSL;
            }
            if ("SISSL-1.2".equals(codeString)) {
                return SPDXLicense.SISSL_1_2;
            }
            if ("Sleepycat".equals(codeString)) {
                return SPDXLicense.SLEEPYCAT;
            }
            if ("SMLNJ".equals(codeString)) {
                return SPDXLicense.SMLNJ;
            }
            if ("SMPPL".equals(codeString)) {
                return SPDXLicense.SMPPL;
            }
            if ("SNIA".equals(codeString)) {
                return SPDXLicense.SNIA;
            }
            if ("snprintf".equals(codeString)) {
                return SPDXLicense.SNPRINTF;
            }
            if ("Spencer-86".equals(codeString)) {
                return SPDXLicense.SPENCER_86;
            }
            if ("Spencer-94".equals(codeString)) {
                return SPDXLicense.SPENCER_94;
            }
            if ("Spencer-99".equals(codeString)) {
                return SPDXLicense.SPENCER_99;
            }
            if ("SPL-1.0".equals(codeString)) {
                return SPDXLicense.SPL_1_0;
            }
            if ("SSH-OpenSSH".equals(codeString)) {
                return SPDXLicense.SSH_OPENSSH;
            }
            if ("SSH-short".equals(codeString)) {
                return SPDXLicense.SSH_SHORT;
            }
            if ("SSPL-1.0".equals(codeString)) {
                return SPDXLicense.SSPL_1_0;
            }
            if ("StandardML-NJ".equals(codeString)) {
                return SPDXLicense.STANDARDML_NJ;
            }
            if ("SugarCRM-1.1.3".equals(codeString)) {
                return SPDXLicense.SUGARCRM_1_1_3;
            }
            if ("SunPro".equals(codeString)) {
                return SPDXLicense.SUNPRO;
            }
            if ("SWL".equals(codeString)) {
                return SPDXLicense.SWL;
            }
            if ("Symlinks".equals(codeString)) {
                return SPDXLicense.SYMLINKS;
            }
            if ("TAPR-OHL-1.0".equals(codeString)) {
                return SPDXLicense.TAPR_OHL_1_0;
            }
            if ("TCL".equals(codeString)) {
                return SPDXLicense.TCL;
            }
            if ("TCP-wrappers".equals(codeString)) {
                return SPDXLicense.TCP_WRAPPERS;
            }
            if ("TermReadKey".equals(codeString)) {
                return SPDXLicense.TERMREADKEY;
            }
            if ("TMate".equals(codeString)) {
                return SPDXLicense.TMATE;
            }
            if ("TORQUE-1.1".equals(codeString)) {
                return SPDXLicense.TORQUE_1_1;
            }
            if ("TOSL".equals(codeString)) {
                return SPDXLicense.TOSL;
            }
            if ("TPDL".equals(codeString)) {
                return SPDXLicense.TPDL;
            }
            if ("TPL-1.0".equals(codeString)) {
                return SPDXLicense.TPL_1_0;
            }
            if ("TTWL".equals(codeString)) {
                return SPDXLicense.TTWL;
            }
            if ("TU-Berlin-1.0".equals(codeString)) {
                return SPDXLicense.TU_BERLIN_1_0;
            }
            if ("TU-Berlin-2.0".equals(codeString)) {
                return SPDXLicense.TU_BERLIN_2_0;
            }
            if ("UCAR".equals(codeString)) {
                return SPDXLicense.UCAR;
            }
            if ("UCL-1.0".equals(codeString)) {
                return SPDXLicense.UCL_1_0;
            }
            if ("Unicode-DFS-2015".equals(codeString)) {
                return SPDXLicense.UNICODE_DFS_2015;
            }
            if ("Unicode-DFS-2016".equals(codeString)) {
                return SPDXLicense.UNICODE_DFS_2016;
            }
            if ("Unicode-TOU".equals(codeString)) {
                return SPDXLicense.UNICODE_TOU;
            }
            if ("UnixCrypt".equals(codeString)) {
                return SPDXLicense.UNIXCRYPT;
            }
            if ("Unlicense".equals(codeString)) {
                return SPDXLicense.UNLICENSE;
            }
            if ("UPL-1.0".equals(codeString)) {
                return SPDXLicense.UPL_1_0;
            }
            if ("Vim".equals(codeString)) {
                return SPDXLicense.VIM;
            }
            if ("VOSTROM".equals(codeString)) {
                return SPDXLicense.VOSTROM;
            }
            if ("VSL-1.0".equals(codeString)) {
                return SPDXLicense.VSL_1_0;
            }
            if ("W3C".equals(codeString)) {
                return SPDXLicense.W3C;
            }
            if ("W3C-19980720".equals(codeString)) {
                return SPDXLicense.W3C_19980720;
            }
            if ("W3C-20150513".equals(codeString)) {
                return SPDXLicense.W3C_20150513;
            }
            if ("w3m".equals(codeString)) {
                return SPDXLicense.W3M;
            }
            if ("Watcom-1.0".equals(codeString)) {
                return SPDXLicense.WATCOM_1_0;
            }
            if ("Widget-Workshop".equals(codeString)) {
                return SPDXLicense.WIDGET_WORKSHOP;
            }
            if ("Wsuipa".equals(codeString)) {
                return SPDXLicense.WSUIPA;
            }
            if ("WTFPL".equals(codeString)) {
                return SPDXLicense.WTFPL;
            }
            if ("wxWindows".equals(codeString)) {
                return SPDXLicense.WXWINDOWS;
            }
            if ("X11".equals(codeString)) {
                return SPDXLicense.X11;
            }
            if ("X11-distribute-modifications-variant".equals(codeString)) {
                return SPDXLicense.X11_DISTRIBUTE_MODIFICATIONS_VARIANT;
            }
            if ("Xdebug-1.03".equals(codeString)) {
                return SPDXLicense.XDEBUG_1_03;
            }
            if ("Xerox".equals(codeString)) {
                return SPDXLicense.XEROX;
            }
            if ("Xfig".equals(codeString)) {
                return SPDXLicense.XFIG;
            }
            if ("XFree86-1.1".equals(codeString)) {
                return SPDXLicense.XFREE86_1_1;
            }
            if ("xinetd".equals(codeString)) {
                return SPDXLicense.XINETD;
            }
            if ("xlock".equals(codeString)) {
                return SPDXLicense.XLOCK;
            }
            if ("Xnet".equals(codeString)) {
                return SPDXLicense.XNET;
            }
            if ("xpp".equals(codeString)) {
                return SPDXLicense.XPP;
            }
            if ("XSkat".equals(codeString)) {
                return SPDXLicense.XSKAT;
            }
            if ("YPL-1.0".equals(codeString)) {
                return SPDXLicense.YPL_1_0;
            }
            if ("YPL-1.1".equals(codeString)) {
                return SPDXLicense.YPL_1_1;
            }
            if ("Zed".equals(codeString)) {
                return SPDXLicense.ZED;
            }
            if ("Zend-2.0".equals(codeString)) {
                return SPDXLicense.ZEND_2_0;
            }
            if ("Zimbra-1.3".equals(codeString)) {
                return SPDXLicense.ZIMBRA_1_3;
            }
            if ("Zimbra-1.4".equals(codeString)) {
                return SPDXLicense.ZIMBRA_1_4;
            }
            if ("Zlib".equals(codeString)) {
                return SPDXLicense.ZLIB;
            }
            if ("zlib-acknowledgement".equals(codeString)) {
                return SPDXLicense.ZLIB_ACKNOWLEDGEMENT;
            }
            if ("ZPL-1.1".equals(codeString)) {
                return SPDXLicense.ZPL_1_1;
            }
            if ("ZPL-2.0".equals(codeString)) {
                return SPDXLicense.ZPL_2_0;
            }
            if ("ZPL-2.1".equals(codeString)) {
                return SPDXLicense.ZPL_2_1;
            }
            throw new IllegalArgumentException("Unknown SPDXLicense code '" + codeString + "'");
        }

        public Enumeration<SPDXLicense> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NULL, code);
            }
            if ("0BSD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense._0BSD, code);
            }
            if ("AAL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AAL, code);
            }
            if ("Abstyles".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ABSTYLES, code);
            }
            if ("AdaCore-doc".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ADACORE_DOC, code);
            }
            if ("Adobe-2006".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ADOBE_2006, code);
            }
            if ("Adobe-Glyph".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ADOBE_GLYPH, code);
            }
            if ("ADSL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ADSL, code);
            }
            if ("AFL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AFL_1_1, code);
            }
            if ("AFL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AFL_1_2, code);
            }
            if ("AFL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AFL_2_0, code);
            }
            if ("AFL-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AFL_2_1, code);
            }
            if ("AFL-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AFL_3_0, code);
            }
            if ("Afmparse".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AFMPARSE, code);
            }
            if ("AGPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AGPL_1_0, code);
            }
            if ("AGPL-1.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AGPL_1_0_ONLY, code);
            }
            if ("AGPL-1.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AGPL_1_0_OR_LATER, code);
            }
            if ("AGPL-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AGPL_3_0, code);
            }
            if ("AGPL-3.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AGPL_3_0_ONLY, code);
            }
            if ("AGPL-3.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AGPL_3_0_OR_LATER, code);
            }
            if ("Aladdin".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ALADDIN, code);
            }
            if ("AMDPLPA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AMDPLPA, code);
            }
            if ("AML".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AML, code);
            }
            if ("AMPAS".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.AMPAS, code);
            }
            if ("ANTLR-PD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ANTLR_PD, code);
            }
            if ("ANTLR-PD-fallback".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ANTLR_PD_FALLBACK, code);
            }
            if ("Apache-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APACHE_1_0, code);
            }
            if ("Apache-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APACHE_1_1, code);
            }
            if ("Apache-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APACHE_2_0, code);
            }
            if ("APAFML".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APAFML, code);
            }
            if ("APL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APL_1_0, code);
            }
            if ("App-s2p".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APP_S2P, code);
            }
            if ("APSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APSL_1_0, code);
            }
            if ("APSL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APSL_1_1, code);
            }
            if ("APSL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APSL_1_2, code);
            }
            if ("APSL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.APSL_2_0, code);
            }
            if ("Arphic-1999".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ARPHIC_1999, code);
            }
            if ("Artistic-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ARTISTIC_1_0, code);
            }
            if ("Artistic-1.0-cl8".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ARTISTIC_1_0_CL8, code);
            }
            if ("Artistic-1.0-Perl".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ARTISTIC_1_0_PERL, code);
            }
            if ("Artistic-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ARTISTIC_2_0, code);
            }
            if ("ASWF-Digital-Assets-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ASWF_DIGITAL_ASSETS_1_0, code);
            }
            if ("ASWF-Digital-Assets-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ASWF_DIGITAL_ASSETS_1_1, code);
            }
            if ("Baekmuk".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BAEKMUK, code);
            }
            if ("Bahyph".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BAHYPH, code);
            }
            if ("Barr".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BARR, code);
            }
            if ("Beerware".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BEERWARE, code);
            }
            if ("Bitstream-Charter".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BITSTREAM_CHARTER, code);
            }
            if ("Bitstream-Vera".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BITSTREAM_VERA, code);
            }
            if ("BitTorrent-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BITTORRENT_1_0, code);
            }
            if ("BitTorrent-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BITTORRENT_1_1, code);
            }
            if ("blessing".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BLESSING, code);
            }
            if ("BlueOak-1.0.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BLUEOAK_1_0_0, code);
            }
            if ("Boehm-GC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BOEHM_GC, code);
            }
            if ("Borceux".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BORCEUX, code);
            }
            if ("Brian-Gladman-3-Clause".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BRIAN_GLADMAN_3_CLAUSE, code);
            }
            if ("BSD-1-Clause".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_1_CLAUSE, code);
            }
            if ("BSD-2-Clause".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_2_CLAUSE, code);
            }
            if ("BSD-2-Clause-FreeBSD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_2_CLAUSE_FREEBSD, code);
            }
            if ("BSD-2-Clause-NetBSD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_2_CLAUSE_NETBSD, code);
            }
            if ("BSD-2-Clause-Patent".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_2_CLAUSE_PATENT, code);
            }
            if ("BSD-2-Clause-Views".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_2_CLAUSE_VIEWS, code);
            }
            if ("BSD-3-Clause".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE, code);
            }
            if ("BSD-3-Clause-Attribution".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_ATTRIBUTION, code);
            }
            if ("BSD-3-Clause-Clear".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_CLEAR, code);
            }
            if ("BSD-3-Clause-LBNL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_LBNL, code);
            }
            if ("BSD-3-Clause-Modification".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_MODIFICATION, code);
            }
            if ("BSD-3-Clause-No-Military-License".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_NO_MILITARY_LICENSE, code);
            }
            if ("BSD-3-Clause-No-Nuclear-License".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE, code);
            }
            if ("BSD-3-Clause-No-Nuclear-License-2014".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014, code);
            }
            if ("BSD-3-Clause-No-Nuclear-Warranty".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY, code);
            }
            if ("BSD-3-Clause-Open-MPI".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_3_CLAUSE_OPEN_MPI, code);
            }
            if ("BSD-4-Clause".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_4_CLAUSE, code);
            }
            if ("BSD-4-Clause-Shortened".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_4_CLAUSE_SHORTENED, code);
            }
            if ("BSD-4-Clause-UC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_4_CLAUSE_UC, code);
            }
            if ("BSD-4.3RENO".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_4_3RENO, code);
            }
            if ("BSD-4.3TAHOE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_4_3TAHOE, code);
            }
            if ("BSD-Advertising-Acknowledgement".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_ADVERTISING_ACKNOWLEDGEMENT, code);
            }
            if ("BSD-Attribution-HPND-disclaimer".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_ATTRIBUTION_HPND_DISCLAIMER, code);
            }
            if ("BSD-Protection".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_PROTECTION, code);
            }
            if ("BSD-Source-Code".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSD_SOURCE_CODE, code);
            }
            if ("BSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BSL_1_0, code);
            }
            if ("BUSL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BUSL_1_1, code);
            }
            if ("bzip2-1.0.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BZIP2_1_0_5, code);
            }
            if ("bzip2-1.0.6".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.BZIP2_1_0_6, code);
            }
            if ("C-UDA-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.C_UDA_1_0, code);
            }
            if ("CAL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CAL_1_0, code);
            }
            if ("CAL-1.0-Combined-Work-Exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CAL_1_0_COMBINED_WORK_EXCEPTION, code);
            }
            if ("Caldera".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CALDERA, code);
            }
            if ("CATOSL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CATOSL_1_1, code);
            }
            if ("CC-BY-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_1_0, code);
            }
            if ("CC-BY-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_2_0, code);
            }
            if ("CC-BY-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_2_5, code);
            }
            if ("CC-BY-2.5-AU".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_2_5_AU, code);
            }
            if ("CC-BY-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_3_0, code);
            }
            if ("CC-BY-3.0-AT".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_3_0_AT, code);
            }
            if ("CC-BY-3.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_3_0_DE, code);
            }
            if ("CC-BY-3.0-IGO".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_3_0_IGO, code);
            }
            if ("CC-BY-3.0-NL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_3_0_NL, code);
            }
            if ("CC-BY-3.0-US".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_3_0_US, code);
            }
            if ("CC-BY-4.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_4_0, code);
            }
            if ("CC-BY-NC-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_1_0, code);
            }
            if ("CC-BY-NC-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_2_0, code);
            }
            if ("CC-BY-NC-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_2_5, code);
            }
            if ("CC-BY-NC-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_3_0, code);
            }
            if ("CC-BY-NC-3.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_3_0_DE, code);
            }
            if ("CC-BY-NC-4.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_4_0, code);
            }
            if ("CC-BY-NC-ND-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_1_0, code);
            }
            if ("CC-BY-NC-ND-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_2_0, code);
            }
            if ("CC-BY-NC-ND-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_2_5, code);
            }
            if ("CC-BY-NC-ND-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_3_0, code);
            }
            if ("CC-BY-NC-ND-3.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_3_0_DE, code);
            }
            if ("CC-BY-NC-ND-3.0-IGO".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_3_0_IGO, code);
            }
            if ("CC-BY-NC-ND-4.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_ND_4_0, code);
            }
            if ("CC-BY-NC-SA-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_1_0, code);
            }
            if ("CC-BY-NC-SA-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_2_0, code);
            }
            if ("CC-BY-NC-SA-2.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_2_0_DE, code);
            }
            if ("CC-BY-NC-SA-2.0-FR".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_2_0_FR, code);
            }
            if ("CC-BY-NC-SA-2.0-UK".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_2_0_UK, code);
            }
            if ("CC-BY-NC-SA-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_2_5, code);
            }
            if ("CC-BY-NC-SA-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_3_0, code);
            }
            if ("CC-BY-NC-SA-3.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_3_0_DE, code);
            }
            if ("CC-BY-NC-SA-3.0-IGO".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_3_0_IGO, code);
            }
            if ("CC-BY-NC-SA-4.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_NC_SA_4_0, code);
            }
            if ("CC-BY-ND-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_ND_1_0, code);
            }
            if ("CC-BY-ND-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_ND_2_0, code);
            }
            if ("CC-BY-ND-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_ND_2_5, code);
            }
            if ("CC-BY-ND-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_ND_3_0, code);
            }
            if ("CC-BY-ND-3.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_ND_3_0_DE, code);
            }
            if ("CC-BY-ND-4.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_ND_4_0, code);
            }
            if ("CC-BY-SA-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_1_0, code);
            }
            if ("CC-BY-SA-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_2_0, code);
            }
            if ("CC-BY-SA-2.0-UK".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_2_0_UK, code);
            }
            if ("CC-BY-SA-2.1-JP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_2_1_JP, code);
            }
            if ("CC-BY-SA-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_2_5, code);
            }
            if ("CC-BY-SA-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_3_0, code);
            }
            if ("CC-BY-SA-3.0-AT".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_3_0_AT, code);
            }
            if ("CC-BY-SA-3.0-DE".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_3_0_DE, code);
            }
            if ("CC-BY-SA-3.0-IGO".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_3_0_IGO, code);
            }
            if ("CC-BY-SA-4.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_BY_SA_4_0, code);
            }
            if ("CC-PDDC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC_PDDC, code);
            }
            if ("CC0-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CC0_1_0, code);
            }
            if ("CDDL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CDDL_1_0, code);
            }
            if ("CDDL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CDDL_1_1, code);
            }
            if ("CDL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CDL_1_0, code);
            }
            if ("CDLA-Permissive-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CDLA_PERMISSIVE_1_0, code);
            }
            if ("CDLA-Permissive-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CDLA_PERMISSIVE_2_0, code);
            }
            if ("CDLA-Sharing-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CDLA_SHARING_1_0, code);
            }
            if ("CECILL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CECILL_1_0, code);
            }
            if ("CECILL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CECILL_1_1, code);
            }
            if ("CECILL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CECILL_2_0, code);
            }
            if ("CECILL-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CECILL_2_1, code);
            }
            if ("CECILL-B".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CECILL_B, code);
            }
            if ("CECILL-C".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CECILL_C, code);
            }
            if ("CERN-OHL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CERN_OHL_1_1, code);
            }
            if ("CERN-OHL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CERN_OHL_1_2, code);
            }
            if ("CERN-OHL-P-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CERN_OHL_P_2_0, code);
            }
            if ("CERN-OHL-S-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CERN_OHL_S_2_0, code);
            }
            if ("CERN-OHL-W-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CERN_OHL_W_2_0, code);
            }
            if ("CFITSIO".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CFITSIO, code);
            }
            if ("checkmk".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CHECKMK, code);
            }
            if ("ClArtistic".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CLARTISTIC, code);
            }
            if ("Clips".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CLIPS, code);
            }
            if ("CMU-Mach".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CMU_MACH, code);
            }
            if ("CNRI-Jython".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CNRI_JYTHON, code);
            }
            if ("CNRI-Python".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CNRI_PYTHON, code);
            }
            if ("CNRI-Python-GPL-Compatible".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CNRI_PYTHON_GPL_COMPATIBLE, code);
            }
            if ("COIL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.COIL_1_0, code);
            }
            if ("Community-Spec-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.COMMUNITY_SPEC_1_0, code);
            }
            if ("Condor-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CONDOR_1_1, code);
            }
            if ("copyleft-next-0.3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.COPYLEFT_NEXT_0_3_0, code);
            }
            if ("copyleft-next-0.3.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.COPYLEFT_NEXT_0_3_1, code);
            }
            if ("Cornell-Lossless-JPEG".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CORNELL_LOSSLESS_JPEG, code);
            }
            if ("CPAL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CPAL_1_0, code);
            }
            if ("CPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CPL_1_0, code);
            }
            if ("CPOL-1.02".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CPOL_1_02, code);
            }
            if ("Crossword".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CROSSWORD, code);
            }
            if ("CrystalStacker".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CRYSTALSTACKER, code);
            }
            if ("CUA-OPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CUA_OPL_1_0, code);
            }
            if ("Cube".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CUBE, code);
            }
            if ("curl".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.CURL, code);
            }
            if ("D-FSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.D_FSL_1_0, code);
            }
            if ("diffmark".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DIFFMARK, code);
            }
            if ("DL-DE-BY-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DL_DE_BY_2_0, code);
            }
            if ("DOC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DOC, code);
            }
            if ("Dotseqn".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DOTSEQN, code);
            }
            if ("DRL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DRL_1_0, code);
            }
            if ("DSDP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DSDP, code);
            }
            if ("dtoa".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DTOA, code);
            }
            if ("dvipdfm".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.DVIPDFM, code);
            }
            if ("ECL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ECL_1_0, code);
            }
            if ("ECL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ECL_2_0, code);
            }
            if ("eCos-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ECOS_2_0, code);
            }
            if ("EFL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EFL_1_0, code);
            }
            if ("EFL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EFL_2_0, code);
            }
            if ("eGenix".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EGENIX, code);
            }
            if ("Elastic-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ELASTIC_2_0, code);
            }
            if ("Entessa".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ENTESSA, code);
            }
            if ("EPICS".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EPICS, code);
            }
            if ("EPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EPL_1_0, code);
            }
            if ("EPL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EPL_2_0, code);
            }
            if ("ErlPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ERLPL_1_1, code);
            }
            if ("etalab-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ETALAB_2_0, code);
            }
            if ("EUDatagrid".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EUDATAGRID, code);
            }
            if ("EUPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EUPL_1_0, code);
            }
            if ("EUPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EUPL_1_1, code);
            }
            if ("EUPL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EUPL_1_2, code);
            }
            if ("Eurosym".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.EUROSYM, code);
            }
            if ("Fair".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FAIR, code);
            }
            if ("FDK-AAC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FDK_AAC, code);
            }
            if ("Frameworx-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FRAMEWORX_1_0, code);
            }
            if ("FreeBSD-DOC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FREEBSD_DOC, code);
            }
            if ("FreeImage".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FREEIMAGE, code);
            }
            if ("FSFAP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FSFAP, code);
            }
            if ("FSFUL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FSFUL, code);
            }
            if ("FSFULLR".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FSFULLR, code);
            }
            if ("FSFULLRWD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FSFULLRWD, code);
            }
            if ("FTL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.FTL, code);
            }
            if ("GD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GD, code);
            }
            if ("GFDL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1, code);
            }
            if ("GFDL-1.1-invariants-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1_INVARIANTS_ONLY, code);
            }
            if ("GFDL-1.1-invariants-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1_INVARIANTS_OR_LATER, code);
            }
            if ("GFDL-1.1-no-invariants-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1_NO_INVARIANTS_ONLY, code);
            }
            if ("GFDL-1.1-no-invariants-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1_NO_INVARIANTS_OR_LATER, code);
            }
            if ("GFDL-1.1-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1_ONLY, code);
            }
            if ("GFDL-1.1-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_1_OR_LATER, code);
            }
            if ("GFDL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2, code);
            }
            if ("GFDL-1.2-invariants-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2_INVARIANTS_ONLY, code);
            }
            if ("GFDL-1.2-invariants-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2_INVARIANTS_OR_LATER, code);
            }
            if ("GFDL-1.2-no-invariants-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2_NO_INVARIANTS_ONLY, code);
            }
            if ("GFDL-1.2-no-invariants-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2_NO_INVARIANTS_OR_LATER, code);
            }
            if ("GFDL-1.2-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2_ONLY, code);
            }
            if ("GFDL-1.2-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_2_OR_LATER, code);
            }
            if ("GFDL-1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3, code);
            }
            if ("GFDL-1.3-invariants-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3_INVARIANTS_ONLY, code);
            }
            if ("GFDL-1.3-invariants-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3_INVARIANTS_OR_LATER, code);
            }
            if ("GFDL-1.3-no-invariants-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3_NO_INVARIANTS_ONLY, code);
            }
            if ("GFDL-1.3-no-invariants-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3_NO_INVARIANTS_OR_LATER, code);
            }
            if ("GFDL-1.3-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3_ONLY, code);
            }
            if ("GFDL-1.3-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GFDL_1_3_OR_LATER, code);
            }
            if ("Giftware".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GIFTWARE, code);
            }
            if ("GL2PS".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GL2PS, code);
            }
            if ("Glide".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GLIDE, code);
            }
            if ("Glulxe".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GLULXE, code);
            }
            if ("GLWTPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GLWTPL, code);
            }
            if ("gnuplot".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GNUPLOT, code);
            }
            if ("GPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_1_0, code);
            }
            if ("GPL-1.0+".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_1_0PLUS, code);
            }
            if ("GPL-1.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_1_0_ONLY, code);
            }
            if ("GPL-1.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_1_0_OR_LATER, code);
            }
            if ("GPL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0, code);
            }
            if ("GPL-2.0+".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0PLUS, code);
            }
            if ("GPL-2.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_ONLY, code);
            }
            if ("GPL-2.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_OR_LATER, code);
            }
            if ("GPL-2.0-with-autoconf-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_WITH_AUTOCONF_EXCEPTION, code);
            }
            if ("GPL-2.0-with-bison-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_WITH_BISON_EXCEPTION, code);
            }
            if ("GPL-2.0-with-classpath-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_WITH_CLASSPATH_EXCEPTION, code);
            }
            if ("GPL-2.0-with-font-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_WITH_FONT_EXCEPTION, code);
            }
            if ("GPL-2.0-with-GCC-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_2_0_WITH_GCC_EXCEPTION, code);
            }
            if ("GPL-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_3_0, code);
            }
            if ("GPL-3.0+".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_3_0PLUS, code);
            }
            if ("GPL-3.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_3_0_ONLY, code);
            }
            if ("GPL-3.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_3_0_OR_LATER, code);
            }
            if ("GPL-3.0-with-autoconf-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_3_0_WITH_AUTOCONF_EXCEPTION, code);
            }
            if ("GPL-3.0-with-GCC-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GPL_3_0_WITH_GCC_EXCEPTION, code);
            }
            if ("Graphics-Gems".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GRAPHICS_GEMS, code);
            }
            if ("gSOAP-1.3b".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.GSOAP_1_3B, code);
            }
            if ("HaskellReport".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HASKELLREPORT, code);
            }
            if ("Hippocratic-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HIPPOCRATIC_2_1, code);
            }
            if ("HP-1986".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HP_1986, code);
            }
            if ("HPND".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HPND, code);
            }
            if ("HPND-export-US".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HPND_EXPORT_US, code);
            }
            if ("HPND-Markus-Kuhn".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HPND_MARKUS_KUHN, code);
            }
            if ("HPND-sell-variant".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HPND_SELL_VARIANT, code);
            }
            if ("HPND-sell-variant-MIT-disclaimer".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HPND_SELL_VARIANT_MIT_DISCLAIMER, code);
            }
            if ("HTMLTIDY".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.HTMLTIDY, code);
            }
            if ("IBM-pibs".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IBM_PIBS, code);
            }
            if ("ICU".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ICU, code);
            }
            if ("IEC-Code-Components-EULA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IEC_CODE_COMPONENTS_EULA, code);
            }
            if ("IJG".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IJG, code);
            }
            if ("IJG-short".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IJG_SHORT, code);
            }
            if ("ImageMagick".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IMAGEMAGICK, code);
            }
            if ("iMatix".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IMATIX, code);
            }
            if ("Imlib2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IMLIB2, code);
            }
            if ("Info-ZIP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.INFO_ZIP, code);
            }
            if ("Inner-Net-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.INNER_NET_2_0, code);
            }
            if ("Intel".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.INTEL, code);
            }
            if ("Intel-ACPI".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.INTEL_ACPI, code);
            }
            if ("Interbase-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.INTERBASE_1_0, code);
            }
            if ("IPA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IPA, code);
            }
            if ("IPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.IPL_1_0, code);
            }
            if ("ISC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ISC, code);
            }
            if ("Jam".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.JAM, code);
            }
            if ("JasPer-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.JASPER_2_0, code);
            }
            if ("JPL-image".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.JPL_IMAGE, code);
            }
            if ("JPNIC".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.JPNIC, code);
            }
            if ("JSON".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.JSON, code);
            }
            if ("Kazlib".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.KAZLIB, code);
            }
            if ("Knuth-CTAN".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.KNUTH_CTAN, code);
            }
            if ("LAL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LAL_1_2, code);
            }
            if ("LAL-1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LAL_1_3, code);
            }
            if ("Latex2e".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LATEX2E, code);
            }
            if ("Latex2e-translated-notice".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LATEX2E_TRANSLATED_NOTICE, code);
            }
            if ("Leptonica".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LEPTONICA, code);
            }
            if ("LGPL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_0, code);
            }
            if ("LGPL-2.0+".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_0PLUS, code);
            }
            if ("LGPL-2.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_0_ONLY, code);
            }
            if ("LGPL-2.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_0_OR_LATER, code);
            }
            if ("LGPL-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_1, code);
            }
            if ("LGPL-2.1+".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_1PLUS, code);
            }
            if ("LGPL-2.1-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_1_ONLY, code);
            }
            if ("LGPL-2.1-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_2_1_OR_LATER, code);
            }
            if ("LGPL-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_3_0, code);
            }
            if ("LGPL-3.0+".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_3_0PLUS, code);
            }
            if ("LGPL-3.0-only".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_3_0_ONLY, code);
            }
            if ("LGPL-3.0-or-later".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPL_3_0_OR_LATER, code);
            }
            if ("LGPLLR".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LGPLLR, code);
            }
            if ("Libpng".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LIBPNG, code);
            }
            if ("libpng-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LIBPNG_2_0, code);
            }
            if ("libselinux-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LIBSELINUX_1_0, code);
            }
            if ("libtiff".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LIBTIFF, code);
            }
            if ("libutil-David-Nugent".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LIBUTIL_DAVID_NUGENT, code);
            }
            if ("LiLiQ-P-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LILIQ_P_1_1, code);
            }
            if ("LiLiQ-R-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LILIQ_R_1_1, code);
            }
            if ("LiLiQ-Rplus-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LILIQ_RPLUS_1_1, code);
            }
            if ("Linux-man-pages-1-para".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LINUX_MAN_PAGES_1_PARA, code);
            }
            if ("Linux-man-pages-copyleft".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LINUX_MAN_PAGES_COPYLEFT, code);
            }
            if ("Linux-man-pages-copyleft-2-para".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LINUX_MAN_PAGES_COPYLEFT_2_PARA, code);
            }
            if ("Linux-man-pages-copyleft-var".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LINUX_MAN_PAGES_COPYLEFT_VAR, code);
            }
            if ("Linux-OpenIB".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LINUX_OPENIB, code);
            }
            if ("LOOP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LOOP, code);
            }
            if ("LPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPL_1_0, code);
            }
            if ("LPL-1.02".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPL_1_02, code);
            }
            if ("LPPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPPL_1_0, code);
            }
            if ("LPPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPPL_1_1, code);
            }
            if ("LPPL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPPL_1_2, code);
            }
            if ("LPPL-1.3a".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPPL_1_3A, code);
            }
            if ("LPPL-1.3c".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LPPL_1_3C, code);
            }
            if ("LZMA-SDK-9.11-to-9.20".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LZMA_SDK_9_11_TO_9_20, code);
            }
            if ("LZMA-SDK-9.22".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.LZMA_SDK_9_22, code);
            }
            if ("MakeIndex".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MAKEINDEX, code);
            }
            if ("Martin-Birgmeier".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MARTIN_BIRGMEIER, code);
            }
            if ("metamail".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.METAMAIL, code);
            }
            if ("Minpack".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MINPACK, code);
            }
            if ("MirOS".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIROS, code);
            }
            if ("MIT".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT, code);
            }
            if ("MIT-0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_0, code);
            }
            if ("MIT-advertising".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_ADVERTISING, code);
            }
            if ("MIT-CMU".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_CMU, code);
            }
            if ("MIT-enna".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_ENNA, code);
            }
            if ("MIT-feh".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_FEH, code);
            }
            if ("MIT-Festival".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_FESTIVAL, code);
            }
            if ("MIT-Modern-Variant".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_MODERN_VARIANT, code);
            }
            if ("MIT-open-group".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_OPEN_GROUP, code);
            }
            if ("MIT-Wu".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MIT_WU, code);
            }
            if ("MITNFA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MITNFA, code);
            }
            if ("Motosoto".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MOTOSOTO, code);
            }
            if ("mpi-permissive".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPI_PERMISSIVE, code);
            }
            if ("mpich2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPICH2, code);
            }
            if ("MPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPL_1_0, code);
            }
            if ("MPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPL_1_1, code);
            }
            if ("MPL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPL_2_0, code);
            }
            if ("MPL-2.0-no-copyleft-exception".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION, code);
            }
            if ("mplus".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MPLUS, code);
            }
            if ("MS-LPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MS_LPL, code);
            }
            if ("MS-PL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MS_PL, code);
            }
            if ("MS-RL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MS_RL, code);
            }
            if ("MTLL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MTLL, code);
            }
            if ("MulanPSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MULANPSL_1_0, code);
            }
            if ("MulanPSL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MULANPSL_2_0, code);
            }
            if ("Multics".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MULTICS, code);
            }
            if ("Mup".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.MUP, code);
            }
            if ("NAIST-2003".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NAIST_2003, code);
            }
            if ("NASA-1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NASA_1_3, code);
            }
            if ("Naumen".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NAUMEN, code);
            }
            if ("NBPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NBPL_1_0, code);
            }
            if ("NCGL-UK-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NCGL_UK_2_0, code);
            }
            if ("NCSA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NCSA, code);
            }
            if ("Net-SNMP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NET_SNMP, code);
            }
            if ("NetCDF".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NETCDF, code);
            }
            if ("Newsletr".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NEWSLETR, code);
            }
            if ("NGPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NGPL, code);
            }
            if ("NICTA-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NICTA_1_0, code);
            }
            if ("NIST-PD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NIST_PD, code);
            }
            if ("NIST-PD-fallback".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NIST_PD_FALLBACK, code);
            }
            if ("NIST-Software".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NIST_SOFTWARE, code);
            }
            if ("NLOD-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NLOD_1_0, code);
            }
            if ("NLOD-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NLOD_2_0, code);
            }
            if ("NLPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NLPL, code);
            }
            if ("Nokia".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NOKIA, code);
            }
            if ("NOSL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NOSL, code);
            }
            if ("not-open-source".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NOT_OPEN_SOURCE, code);
            }
            if ("Noweb".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NOWEB, code);
            }
            if ("NPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NPL_1_0, code);
            }
            if ("NPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NPL_1_1, code);
            }
            if ("NPOSL-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NPOSL_3_0, code);
            }
            if ("NRL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NRL, code);
            }
            if ("NTP".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NTP, code);
            }
            if ("NTP-0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NTP_0, code);
            }
            if ("Nunit".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.NUNIT, code);
            }
            if ("O-UDA-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.O_UDA_1_0, code);
            }
            if ("OCCT-PL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OCCT_PL, code);
            }
            if ("OCLC-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OCLC_2_0, code);
            }
            if ("ODbL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ODBL_1_0, code);
            }
            if ("ODC-By-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ODC_BY_1_0, code);
            }
            if ("OFFIS".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFFIS, code);
            }
            if ("OFL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFL_1_0, code);
            }
            if ("OFL-1.0-no-RFN".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFL_1_0_NO_RFN, code);
            }
            if ("OFL-1.0-RFN".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFL_1_0_RFN, code);
            }
            if ("OFL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFL_1_1, code);
            }
            if ("OFL-1.1-no-RFN".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFL_1_1_NO_RFN, code);
            }
            if ("OFL-1.1-RFN".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OFL_1_1_RFN, code);
            }
            if ("OGC-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGC_1_0, code);
            }
            if ("OGDL-Taiwan-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGDL_TAIWAN_1_0, code);
            }
            if ("OGL-Canada-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGL_CANADA_2_0, code);
            }
            if ("OGL-UK-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGL_UK_1_0, code);
            }
            if ("OGL-UK-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGL_UK_2_0, code);
            }
            if ("OGL-UK-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGL_UK_3_0, code);
            }
            if ("OGTSL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OGTSL, code);
            }
            if ("OLDAP-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_1_1, code);
            }
            if ("OLDAP-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_1_2, code);
            }
            if ("OLDAP-1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_1_3, code);
            }
            if ("OLDAP-1.4".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_1_4, code);
            }
            if ("OLDAP-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_0, code);
            }
            if ("OLDAP-2.0.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_0_1, code);
            }
            if ("OLDAP-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_1, code);
            }
            if ("OLDAP-2.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_2, code);
            }
            if ("OLDAP-2.2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_2_1, code);
            }
            if ("OLDAP-2.2.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_2_2, code);
            }
            if ("OLDAP-2.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_3, code);
            }
            if ("OLDAP-2.4".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_4, code);
            }
            if ("OLDAP-2.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_5, code);
            }
            if ("OLDAP-2.6".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_6, code);
            }
            if ("OLDAP-2.7".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_7, code);
            }
            if ("OLDAP-2.8".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLDAP_2_8, code);
            }
            if ("OLFL-1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OLFL_1_3, code);
            }
            if ("OML".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OML, code);
            }
            if ("OpenPBS-2.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OPENPBS_2_3, code);
            }
            if ("OpenSSL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OPENSSL, code);
            }
            if ("OPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OPL_1_0, code);
            }
            if ("OPL-UK-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OPL_UK_3_0, code);
            }
            if ("OPUBL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OPUBL_1_0, code);
            }
            if ("OSET-PL-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OSET_PL_2_1, code);
            }
            if ("OSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OSL_1_0, code);
            }
            if ("OSL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OSL_1_1, code);
            }
            if ("OSL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OSL_2_0, code);
            }
            if ("OSL-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OSL_2_1, code);
            }
            if ("OSL-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.OSL_3_0, code);
            }
            if ("Parity-6.0.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PARITY_6_0_0, code);
            }
            if ("Parity-7.0.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PARITY_7_0_0, code);
            }
            if ("PDDL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PDDL_1_0, code);
            }
            if ("PHP-3.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PHP_3_0, code);
            }
            if ("PHP-3.01".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PHP_3_01, code);
            }
            if ("Plexus".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PLEXUS, code);
            }
            if ("PolyForm-Noncommercial-1.0.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.POLYFORM_NONCOMMERCIAL_1_0_0, code);
            }
            if ("PolyForm-Small-Business-1.0.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.POLYFORM_SMALL_BUSINESS_1_0_0, code);
            }
            if ("PostgreSQL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.POSTGRESQL, code);
            }
            if ("PSF-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PSF_2_0, code);
            }
            if ("psfrag".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PSFRAG, code);
            }
            if ("psutils".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PSUTILS, code);
            }
            if ("Python-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PYTHON_2_0, code);
            }
            if ("Python-2.0.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.PYTHON_2_0_1, code);
            }
            if ("Qhull".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.QHULL, code);
            }
            if ("QPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.QPL_1_0, code);
            }
            if ("QPL-1.0-INRIA-2004".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.QPL_1_0_INRIA_2004, code);
            }
            if ("Rdisc".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RDISC, code);
            }
            if ("RHeCos-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RHECOS_1_1, code);
            }
            if ("RPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RPL_1_1, code);
            }
            if ("RPL-1.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RPL_1_5, code);
            }
            if ("RPSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RPSL_1_0, code);
            }
            if ("RSA-MD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RSA_MD, code);
            }
            if ("RSCPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RSCPL, code);
            }
            if ("Ruby".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.RUBY, code);
            }
            if ("SAX-PD".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SAX_PD, code);
            }
            if ("Saxpath".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SAXPATH, code);
            }
            if ("SCEA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SCEA, code);
            }
            if ("SchemeReport".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SCHEMEREPORT, code);
            }
            if ("Sendmail".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SENDMAIL, code);
            }
            if ("Sendmail-8.23".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SENDMAIL_8_23, code);
            }
            if ("SGI-B-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SGI_B_1_0, code);
            }
            if ("SGI-B-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SGI_B_1_1, code);
            }
            if ("SGI-B-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SGI_B_2_0, code);
            }
            if ("SGP4".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SGP4, code);
            }
            if ("SHL-0.5".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SHL_0_5, code);
            }
            if ("SHL-0.51".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SHL_0_51, code);
            }
            if ("SimPL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SIMPL_2_0, code);
            }
            if ("SISSL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SISSL, code);
            }
            if ("SISSL-1.2".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SISSL_1_2, code);
            }
            if ("Sleepycat".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SLEEPYCAT, code);
            }
            if ("SMLNJ".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SMLNJ, code);
            }
            if ("SMPPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SMPPL, code);
            }
            if ("SNIA".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SNIA, code);
            }
            if ("snprintf".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SNPRINTF, code);
            }
            if ("Spencer-86".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SPENCER_86, code);
            }
            if ("Spencer-94".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SPENCER_94, code);
            }
            if ("Spencer-99".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SPENCER_99, code);
            }
            if ("SPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SPL_1_0, code);
            }
            if ("SSH-OpenSSH".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SSH_OPENSSH, code);
            }
            if ("SSH-short".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SSH_SHORT, code);
            }
            if ("SSPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SSPL_1_0, code);
            }
            if ("StandardML-NJ".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.STANDARDML_NJ, code);
            }
            if ("SugarCRM-1.1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SUGARCRM_1_1_3, code);
            }
            if ("SunPro".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SUNPRO, code);
            }
            if ("SWL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SWL, code);
            }
            if ("Symlinks".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.SYMLINKS, code);
            }
            if ("TAPR-OHL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TAPR_OHL_1_0, code);
            }
            if ("TCL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TCL, code);
            }
            if ("TCP-wrappers".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TCP_WRAPPERS, code);
            }
            if ("TermReadKey".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TERMREADKEY, code);
            }
            if ("TMate".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TMATE, code);
            }
            if ("TORQUE-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TORQUE_1_1, code);
            }
            if ("TOSL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TOSL, code);
            }
            if ("TPDL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TPDL, code);
            }
            if ("TPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TPL_1_0, code);
            }
            if ("TTWL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TTWL, code);
            }
            if ("TU-Berlin-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TU_BERLIN_1_0, code);
            }
            if ("TU-Berlin-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.TU_BERLIN_2_0, code);
            }
            if ("UCAR".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UCAR, code);
            }
            if ("UCL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UCL_1_0, code);
            }
            if ("Unicode-DFS-2015".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UNICODE_DFS_2015, code);
            }
            if ("Unicode-DFS-2016".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UNICODE_DFS_2016, code);
            }
            if ("Unicode-TOU".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UNICODE_TOU, code);
            }
            if ("UnixCrypt".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UNIXCRYPT, code);
            }
            if ("Unlicense".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UNLICENSE, code);
            }
            if ("UPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.UPL_1_0, code);
            }
            if ("Vim".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.VIM, code);
            }
            if ("VOSTROM".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.VOSTROM, code);
            }
            if ("VSL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.VSL_1_0, code);
            }
            if ("W3C".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.W3C, code);
            }
            if ("W3C-19980720".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.W3C_19980720, code);
            }
            if ("W3C-20150513".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.W3C_20150513, code);
            }
            if ("w3m".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.W3M, code);
            }
            if ("Watcom-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.WATCOM_1_0, code);
            }
            if ("Widget-Workshop".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.WIDGET_WORKSHOP, code);
            }
            if ("Wsuipa".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.WSUIPA, code);
            }
            if ("WTFPL".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.WTFPL, code);
            }
            if ("wxWindows".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.WXWINDOWS, code);
            }
            if ("X11".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.X11, code);
            }
            if ("X11-distribute-modifications-variant".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.X11_DISTRIBUTE_MODIFICATIONS_VARIANT, code);
            }
            if ("Xdebug-1.03".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XDEBUG_1_03, code);
            }
            if ("Xerox".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XEROX, code);
            }
            if ("Xfig".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XFIG, code);
            }
            if ("XFree86-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XFREE86_1_1, code);
            }
            if ("xinetd".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XINETD, code);
            }
            if ("xlock".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XLOCK, code);
            }
            if ("Xnet".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XNET, code);
            }
            if ("xpp".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XPP, code);
            }
            if ("XSkat".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.XSKAT, code);
            }
            if ("YPL-1.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.YPL_1_0, code);
            }
            if ("YPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.YPL_1_1, code);
            }
            if ("Zed".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZED, code);
            }
            if ("Zend-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZEND_2_0, code);
            }
            if ("Zimbra-1.3".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZIMBRA_1_3, code);
            }
            if ("Zimbra-1.4".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZIMBRA_1_4, code);
            }
            if ("Zlib".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZLIB, code);
            }
            if ("zlib-acknowledgement".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZLIB_ACKNOWLEDGEMENT, code);
            }
            if ("ZPL-1.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZPL_1_1, code);
            }
            if ("ZPL-2.0".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZPL_2_0, code);
            }
            if ("ZPL-2.1".equals(codeString)) {
                return new Enumeration<SPDXLicense>(this, SPDXLicense.ZPL_2_1, code);
            }
            throw new FHIRException("Unknown SPDXLicense code '" + codeString + "'");
        }

        @Override
        public String toCode(SPDXLicense code) {
            if (code == SPDXLicense.NULL) {
                return null;
            }
            if (code == SPDXLicense._0BSD) {
                return "0BSD";
            }
            if (code == SPDXLicense.AAL) {
                return "AAL";
            }
            if (code == SPDXLicense.ABSTYLES) {
                return "Abstyles";
            }
            if (code == SPDXLicense.ADACORE_DOC) {
                return "AdaCore-doc";
            }
            if (code == SPDXLicense.ADOBE_2006) {
                return "Adobe-2006";
            }
            if (code == SPDXLicense.ADOBE_GLYPH) {
                return "Adobe-Glyph";
            }
            if (code == SPDXLicense.ADSL) {
                return "ADSL";
            }
            if (code == SPDXLicense.AFL_1_1) {
                return "AFL-1.1";
            }
            if (code == SPDXLicense.AFL_1_2) {
                return "AFL-1.2";
            }
            if (code == SPDXLicense.AFL_2_0) {
                return "AFL-2.0";
            }
            if (code == SPDXLicense.AFL_2_1) {
                return "AFL-2.1";
            }
            if (code == SPDXLicense.AFL_3_0) {
                return "AFL-3.0";
            }
            if (code == SPDXLicense.AFMPARSE) {
                return "Afmparse";
            }
            if (code == SPDXLicense.AGPL_1_0) {
                return "AGPL-1.0";
            }
            if (code == SPDXLicense.AGPL_1_0_ONLY) {
                return "AGPL-1.0-only";
            }
            if (code == SPDXLicense.AGPL_1_0_OR_LATER) {
                return "AGPL-1.0-or-later";
            }
            if (code == SPDXLicense.AGPL_3_0) {
                return "AGPL-3.0";
            }
            if (code == SPDXLicense.AGPL_3_0_ONLY) {
                return "AGPL-3.0-only";
            }
            if (code == SPDXLicense.AGPL_3_0_OR_LATER) {
                return "AGPL-3.0-or-later";
            }
            if (code == SPDXLicense.ALADDIN) {
                return "Aladdin";
            }
            if (code == SPDXLicense.AMDPLPA) {
                return "AMDPLPA";
            }
            if (code == SPDXLicense.AML) {
                return "AML";
            }
            if (code == SPDXLicense.AMPAS) {
                return "AMPAS";
            }
            if (code == SPDXLicense.ANTLR_PD) {
                return "ANTLR-PD";
            }
            if (code == SPDXLicense.ANTLR_PD_FALLBACK) {
                return "ANTLR-PD-fallback";
            }
            if (code == SPDXLicense.APACHE_1_0) {
                return "Apache-1.0";
            }
            if (code == SPDXLicense.APACHE_1_1) {
                return "Apache-1.1";
            }
            if (code == SPDXLicense.APACHE_2_0) {
                return "Apache-2.0";
            }
            if (code == SPDXLicense.APAFML) {
                return "APAFML";
            }
            if (code == SPDXLicense.APL_1_0) {
                return "APL-1.0";
            }
            if (code == SPDXLicense.APP_S2P) {
                return "App-s2p";
            }
            if (code == SPDXLicense.APSL_1_0) {
                return "APSL-1.0";
            }
            if (code == SPDXLicense.APSL_1_1) {
                return "APSL-1.1";
            }
            if (code == SPDXLicense.APSL_1_2) {
                return "APSL-1.2";
            }
            if (code == SPDXLicense.APSL_2_0) {
                return "APSL-2.0";
            }
            if (code == SPDXLicense.ARPHIC_1999) {
                return "Arphic-1999";
            }
            if (code == SPDXLicense.ARTISTIC_1_0) {
                return "Artistic-1.0";
            }
            if (code == SPDXLicense.ARTISTIC_1_0_CL8) {
                return "Artistic-1.0-cl8";
            }
            if (code == SPDXLicense.ARTISTIC_1_0_PERL) {
                return "Artistic-1.0-Perl";
            }
            if (code == SPDXLicense.ARTISTIC_2_0) {
                return "Artistic-2.0";
            }
            if (code == SPDXLicense.ASWF_DIGITAL_ASSETS_1_0) {
                return "ASWF-Digital-Assets-1.0";
            }
            if (code == SPDXLicense.ASWF_DIGITAL_ASSETS_1_1) {
                return "ASWF-Digital-Assets-1.1";
            }
            if (code == SPDXLicense.BAEKMUK) {
                return "Baekmuk";
            }
            if (code == SPDXLicense.BAHYPH) {
                return "Bahyph";
            }
            if (code == SPDXLicense.BARR) {
                return "Barr";
            }
            if (code == SPDXLicense.BEERWARE) {
                return "Beerware";
            }
            if (code == SPDXLicense.BITSTREAM_CHARTER) {
                return "Bitstream-Charter";
            }
            if (code == SPDXLicense.BITSTREAM_VERA) {
                return "Bitstream-Vera";
            }
            if (code == SPDXLicense.BITTORRENT_1_0) {
                return "BitTorrent-1.0";
            }
            if (code == SPDXLicense.BITTORRENT_1_1) {
                return "BitTorrent-1.1";
            }
            if (code == SPDXLicense.BLESSING) {
                return "blessing";
            }
            if (code == SPDXLicense.BLUEOAK_1_0_0) {
                return "BlueOak-1.0.0";
            }
            if (code == SPDXLicense.BOEHM_GC) {
                return "Boehm-GC";
            }
            if (code == SPDXLicense.BORCEUX) {
                return "Borceux";
            }
            if (code == SPDXLicense.BRIAN_GLADMAN_3_CLAUSE) {
                return "Brian-Gladman-3-Clause";
            }
            if (code == SPDXLicense.BSD_1_CLAUSE) {
                return "BSD-1-Clause";
            }
            if (code == SPDXLicense.BSD_2_CLAUSE) {
                return "BSD-2-Clause";
            }
            if (code == SPDXLicense.BSD_2_CLAUSE_FREEBSD) {
                return "BSD-2-Clause-FreeBSD";
            }
            if (code == SPDXLicense.BSD_2_CLAUSE_NETBSD) {
                return "BSD-2-Clause-NetBSD";
            }
            if (code == SPDXLicense.BSD_2_CLAUSE_PATENT) {
                return "BSD-2-Clause-Patent";
            }
            if (code == SPDXLicense.BSD_2_CLAUSE_VIEWS) {
                return "BSD-2-Clause-Views";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE) {
                return "BSD-3-Clause";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_ATTRIBUTION) {
                return "BSD-3-Clause-Attribution";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_CLEAR) {
                return "BSD-3-Clause-Clear";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_LBNL) {
                return "BSD-3-Clause-LBNL";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_MODIFICATION) {
                return "BSD-3-Clause-Modification";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_NO_MILITARY_LICENSE) {
                return "BSD-3-Clause-No-Military-License";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE) {
                return "BSD-3-Clause-No-Nuclear-License";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014) {
                return "BSD-3-Clause-No-Nuclear-License-2014";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY) {
                return "BSD-3-Clause-No-Nuclear-Warranty";
            }
            if (code == SPDXLicense.BSD_3_CLAUSE_OPEN_MPI) {
                return "BSD-3-Clause-Open-MPI";
            }
            if (code == SPDXLicense.BSD_4_CLAUSE) {
                return "BSD-4-Clause";
            }
            if (code == SPDXLicense.BSD_4_CLAUSE_SHORTENED) {
                return "BSD-4-Clause-Shortened";
            }
            if (code == SPDXLicense.BSD_4_CLAUSE_UC) {
                return "BSD-4-Clause-UC";
            }
            if (code == SPDXLicense.BSD_4_3RENO) {
                return "BSD-4.3RENO";
            }
            if (code == SPDXLicense.BSD_4_3TAHOE) {
                return "BSD-4.3TAHOE";
            }
            if (code == SPDXLicense.BSD_ADVERTISING_ACKNOWLEDGEMENT) {
                return "BSD-Advertising-Acknowledgement";
            }
            if (code == SPDXLicense.BSD_ATTRIBUTION_HPND_DISCLAIMER) {
                return "BSD-Attribution-HPND-disclaimer";
            }
            if (code == SPDXLicense.BSD_PROTECTION) {
                return "BSD-Protection";
            }
            if (code == SPDXLicense.BSD_SOURCE_CODE) {
                return "BSD-Source-Code";
            }
            if (code == SPDXLicense.BSL_1_0) {
                return "BSL-1.0";
            }
            if (code == SPDXLicense.BUSL_1_1) {
                return "BUSL-1.1";
            }
            if (code == SPDXLicense.BZIP2_1_0_5) {
                return "bzip2-1.0.5";
            }
            if (code == SPDXLicense.BZIP2_1_0_6) {
                return "bzip2-1.0.6";
            }
            if (code == SPDXLicense.C_UDA_1_0) {
                return "C-UDA-1.0";
            }
            if (code == SPDXLicense.CAL_1_0) {
                return "CAL-1.0";
            }
            if (code == SPDXLicense.CAL_1_0_COMBINED_WORK_EXCEPTION) {
                return "CAL-1.0-Combined-Work-Exception";
            }
            if (code == SPDXLicense.CALDERA) {
                return "Caldera";
            }
            if (code == SPDXLicense.CATOSL_1_1) {
                return "CATOSL-1.1";
            }
            if (code == SPDXLicense.CC_BY_1_0) {
                return "CC-BY-1.0";
            }
            if (code == SPDXLicense.CC_BY_2_0) {
                return "CC-BY-2.0";
            }
            if (code == SPDXLicense.CC_BY_2_5) {
                return "CC-BY-2.5";
            }
            if (code == SPDXLicense.CC_BY_2_5_AU) {
                return "CC-BY-2.5-AU";
            }
            if (code == SPDXLicense.CC_BY_3_0) {
                return "CC-BY-3.0";
            }
            if (code == SPDXLicense.CC_BY_3_0_AT) {
                return "CC-BY-3.0-AT";
            }
            if (code == SPDXLicense.CC_BY_3_0_DE) {
                return "CC-BY-3.0-DE";
            }
            if (code == SPDXLicense.CC_BY_3_0_IGO) {
                return "CC-BY-3.0-IGO";
            }
            if (code == SPDXLicense.CC_BY_3_0_NL) {
                return "CC-BY-3.0-NL";
            }
            if (code == SPDXLicense.CC_BY_3_0_US) {
                return "CC-BY-3.0-US";
            }
            if (code == SPDXLicense.CC_BY_4_0) {
                return "CC-BY-4.0";
            }
            if (code == SPDXLicense.CC_BY_NC_1_0) {
                return "CC-BY-NC-1.0";
            }
            if (code == SPDXLicense.CC_BY_NC_2_0) {
                return "CC-BY-NC-2.0";
            }
            if (code == SPDXLicense.CC_BY_NC_2_5) {
                return "CC-BY-NC-2.5";
            }
            if (code == SPDXLicense.CC_BY_NC_3_0) {
                return "CC-BY-NC-3.0";
            }
            if (code == SPDXLicense.CC_BY_NC_3_0_DE) {
                return "CC-BY-NC-3.0-DE";
            }
            if (code == SPDXLicense.CC_BY_NC_4_0) {
                return "CC-BY-NC-4.0";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_1_0) {
                return "CC-BY-NC-ND-1.0";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_2_0) {
                return "CC-BY-NC-ND-2.0";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_2_5) {
                return "CC-BY-NC-ND-2.5";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_3_0) {
                return "CC-BY-NC-ND-3.0";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_3_0_DE) {
                return "CC-BY-NC-ND-3.0-DE";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_3_0_IGO) {
                return "CC-BY-NC-ND-3.0-IGO";
            }
            if (code == SPDXLicense.CC_BY_NC_ND_4_0) {
                return "CC-BY-NC-ND-4.0";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_1_0) {
                return "CC-BY-NC-SA-1.0";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_2_0) {
                return "CC-BY-NC-SA-2.0";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_2_0_DE) {
                return "CC-BY-NC-SA-2.0-DE";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_2_0_FR) {
                return "CC-BY-NC-SA-2.0-FR";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_2_0_UK) {
                return "CC-BY-NC-SA-2.0-UK";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_2_5) {
                return "CC-BY-NC-SA-2.5";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_3_0) {
                return "CC-BY-NC-SA-3.0";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_3_0_DE) {
                return "CC-BY-NC-SA-3.0-DE";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_3_0_IGO) {
                return "CC-BY-NC-SA-3.0-IGO";
            }
            if (code == SPDXLicense.CC_BY_NC_SA_4_0) {
                return "CC-BY-NC-SA-4.0";
            }
            if (code == SPDXLicense.CC_BY_ND_1_0) {
                return "CC-BY-ND-1.0";
            }
            if (code == SPDXLicense.CC_BY_ND_2_0) {
                return "CC-BY-ND-2.0";
            }
            if (code == SPDXLicense.CC_BY_ND_2_5) {
                return "CC-BY-ND-2.5";
            }
            if (code == SPDXLicense.CC_BY_ND_3_0) {
                return "CC-BY-ND-3.0";
            }
            if (code == SPDXLicense.CC_BY_ND_3_0_DE) {
                return "CC-BY-ND-3.0-DE";
            }
            if (code == SPDXLicense.CC_BY_ND_4_0) {
                return "CC-BY-ND-4.0";
            }
            if (code == SPDXLicense.CC_BY_SA_1_0) {
                return "CC-BY-SA-1.0";
            }
            if (code == SPDXLicense.CC_BY_SA_2_0) {
                return "CC-BY-SA-2.0";
            }
            if (code == SPDXLicense.CC_BY_SA_2_0_UK) {
                return "CC-BY-SA-2.0-UK";
            }
            if (code == SPDXLicense.CC_BY_SA_2_1_JP) {
                return "CC-BY-SA-2.1-JP";
            }
            if (code == SPDXLicense.CC_BY_SA_2_5) {
                return "CC-BY-SA-2.5";
            }
            if (code == SPDXLicense.CC_BY_SA_3_0) {
                return "CC-BY-SA-3.0";
            }
            if (code == SPDXLicense.CC_BY_SA_3_0_AT) {
                return "CC-BY-SA-3.0-AT";
            }
            if (code == SPDXLicense.CC_BY_SA_3_0_DE) {
                return "CC-BY-SA-3.0-DE";
            }
            if (code == SPDXLicense.CC_BY_SA_3_0_IGO) {
                return "CC-BY-SA-3.0-IGO";
            }
            if (code == SPDXLicense.CC_BY_SA_4_0) {
                return "CC-BY-SA-4.0";
            }
            if (code == SPDXLicense.CC_PDDC) {
                return "CC-PDDC";
            }
            if (code == SPDXLicense.CC0_1_0) {
                return "CC0-1.0";
            }
            if (code == SPDXLicense.CDDL_1_0) {
                return "CDDL-1.0";
            }
            if (code == SPDXLicense.CDDL_1_1) {
                return "CDDL-1.1";
            }
            if (code == SPDXLicense.CDL_1_0) {
                return "CDL-1.0";
            }
            if (code == SPDXLicense.CDLA_PERMISSIVE_1_0) {
                return "CDLA-Permissive-1.0";
            }
            if (code == SPDXLicense.CDLA_PERMISSIVE_2_0) {
                return "CDLA-Permissive-2.0";
            }
            if (code == SPDXLicense.CDLA_SHARING_1_0) {
                return "CDLA-Sharing-1.0";
            }
            if (code == SPDXLicense.CECILL_1_0) {
                return "CECILL-1.0";
            }
            if (code == SPDXLicense.CECILL_1_1) {
                return "CECILL-1.1";
            }
            if (code == SPDXLicense.CECILL_2_0) {
                return "CECILL-2.0";
            }
            if (code == SPDXLicense.CECILL_2_1) {
                return "CECILL-2.1";
            }
            if (code == SPDXLicense.CECILL_B) {
                return "CECILL-B";
            }
            if (code == SPDXLicense.CECILL_C) {
                return "CECILL-C";
            }
            if (code == SPDXLicense.CERN_OHL_1_1) {
                return "CERN-OHL-1.1";
            }
            if (code == SPDXLicense.CERN_OHL_1_2) {
                return "CERN-OHL-1.2";
            }
            if (code == SPDXLicense.CERN_OHL_P_2_0) {
                return "CERN-OHL-P-2.0";
            }
            if (code == SPDXLicense.CERN_OHL_S_2_0) {
                return "CERN-OHL-S-2.0";
            }
            if (code == SPDXLicense.CERN_OHL_W_2_0) {
                return "CERN-OHL-W-2.0";
            }
            if (code == SPDXLicense.CFITSIO) {
                return "CFITSIO";
            }
            if (code == SPDXLicense.CHECKMK) {
                return "checkmk";
            }
            if (code == SPDXLicense.CLARTISTIC) {
                return "ClArtistic";
            }
            if (code == SPDXLicense.CLIPS) {
                return "Clips";
            }
            if (code == SPDXLicense.CMU_MACH) {
                return "CMU-Mach";
            }
            if (code == SPDXLicense.CNRI_JYTHON) {
                return "CNRI-Jython";
            }
            if (code == SPDXLicense.CNRI_PYTHON) {
                return "CNRI-Python";
            }
            if (code == SPDXLicense.CNRI_PYTHON_GPL_COMPATIBLE) {
                return "CNRI-Python-GPL-Compatible";
            }
            if (code == SPDXLicense.COIL_1_0) {
                return "COIL-1.0";
            }
            if (code == SPDXLicense.COMMUNITY_SPEC_1_0) {
                return "Community-Spec-1.0";
            }
            if (code == SPDXLicense.CONDOR_1_1) {
                return "Condor-1.1";
            }
            if (code == SPDXLicense.COPYLEFT_NEXT_0_3_0) {
                return "copyleft-next-0.3.0";
            }
            if (code == SPDXLicense.COPYLEFT_NEXT_0_3_1) {
                return "copyleft-next-0.3.1";
            }
            if (code == SPDXLicense.CORNELL_LOSSLESS_JPEG) {
                return "Cornell-Lossless-JPEG";
            }
            if (code == SPDXLicense.CPAL_1_0) {
                return "CPAL-1.0";
            }
            if (code == SPDXLicense.CPL_1_0) {
                return "CPL-1.0";
            }
            if (code == SPDXLicense.CPOL_1_02) {
                return "CPOL-1.02";
            }
            if (code == SPDXLicense.CROSSWORD) {
                return "Crossword";
            }
            if (code == SPDXLicense.CRYSTALSTACKER) {
                return "CrystalStacker";
            }
            if (code == SPDXLicense.CUA_OPL_1_0) {
                return "CUA-OPL-1.0";
            }
            if (code == SPDXLicense.CUBE) {
                return "Cube";
            }
            if (code == SPDXLicense.CURL) {
                return "curl";
            }
            if (code == SPDXLicense.D_FSL_1_0) {
                return "D-FSL-1.0";
            }
            if (code == SPDXLicense.DIFFMARK) {
                return "diffmark";
            }
            if (code == SPDXLicense.DL_DE_BY_2_0) {
                return "DL-DE-BY-2.0";
            }
            if (code == SPDXLicense.DOC) {
                return "DOC";
            }
            if (code == SPDXLicense.DOTSEQN) {
                return "Dotseqn";
            }
            if (code == SPDXLicense.DRL_1_0) {
                return "DRL-1.0";
            }
            if (code == SPDXLicense.DSDP) {
                return "DSDP";
            }
            if (code == SPDXLicense.DTOA) {
                return "dtoa";
            }
            if (code == SPDXLicense.DVIPDFM) {
                return "dvipdfm";
            }
            if (code == SPDXLicense.ECL_1_0) {
                return "ECL-1.0";
            }
            if (code == SPDXLicense.ECL_2_0) {
                return "ECL-2.0";
            }
            if (code == SPDXLicense.ECOS_2_0) {
                return "eCos-2.0";
            }
            if (code == SPDXLicense.EFL_1_0) {
                return "EFL-1.0";
            }
            if (code == SPDXLicense.EFL_2_0) {
                return "EFL-2.0";
            }
            if (code == SPDXLicense.EGENIX) {
                return "eGenix";
            }
            if (code == SPDXLicense.ELASTIC_2_0) {
                return "Elastic-2.0";
            }
            if (code == SPDXLicense.ENTESSA) {
                return "Entessa";
            }
            if (code == SPDXLicense.EPICS) {
                return "EPICS";
            }
            if (code == SPDXLicense.EPL_1_0) {
                return "EPL-1.0";
            }
            if (code == SPDXLicense.EPL_2_0) {
                return "EPL-2.0";
            }
            if (code == SPDXLicense.ERLPL_1_1) {
                return "ErlPL-1.1";
            }
            if (code == SPDXLicense.ETALAB_2_0) {
                return "etalab-2.0";
            }
            if (code == SPDXLicense.EUDATAGRID) {
                return "EUDatagrid";
            }
            if (code == SPDXLicense.EUPL_1_0) {
                return "EUPL-1.0";
            }
            if (code == SPDXLicense.EUPL_1_1) {
                return "EUPL-1.1";
            }
            if (code == SPDXLicense.EUPL_1_2) {
                return "EUPL-1.2";
            }
            if (code == SPDXLicense.EUROSYM) {
                return "Eurosym";
            }
            if (code == SPDXLicense.FAIR) {
                return "Fair";
            }
            if (code == SPDXLicense.FDK_AAC) {
                return "FDK-AAC";
            }
            if (code == SPDXLicense.FRAMEWORX_1_0) {
                return "Frameworx-1.0";
            }
            if (code == SPDXLicense.FREEBSD_DOC) {
                return "FreeBSD-DOC";
            }
            if (code == SPDXLicense.FREEIMAGE) {
                return "FreeImage";
            }
            if (code == SPDXLicense.FSFAP) {
                return "FSFAP";
            }
            if (code == SPDXLicense.FSFUL) {
                return "FSFUL";
            }
            if (code == SPDXLicense.FSFULLR) {
                return "FSFULLR";
            }
            if (code == SPDXLicense.FSFULLRWD) {
                return "FSFULLRWD";
            }
            if (code == SPDXLicense.FTL) {
                return "FTL";
            }
            if (code == SPDXLicense.GD) {
                return "GD";
            }
            if (code == SPDXLicense.GFDL_1_1) {
                return "GFDL-1.1";
            }
            if (code == SPDXLicense.GFDL_1_1_INVARIANTS_ONLY) {
                return "GFDL-1.1-invariants-only";
            }
            if (code == SPDXLicense.GFDL_1_1_INVARIANTS_OR_LATER) {
                return "GFDL-1.1-invariants-or-later";
            }
            if (code == SPDXLicense.GFDL_1_1_NO_INVARIANTS_ONLY) {
                return "GFDL-1.1-no-invariants-only";
            }
            if (code == SPDXLicense.GFDL_1_1_NO_INVARIANTS_OR_LATER) {
                return "GFDL-1.1-no-invariants-or-later";
            }
            if (code == SPDXLicense.GFDL_1_1_ONLY) {
                return "GFDL-1.1-only";
            }
            if (code == SPDXLicense.GFDL_1_1_OR_LATER) {
                return "GFDL-1.1-or-later";
            }
            if (code == SPDXLicense.GFDL_1_2) {
                return "GFDL-1.2";
            }
            if (code == SPDXLicense.GFDL_1_2_INVARIANTS_ONLY) {
                return "GFDL-1.2-invariants-only";
            }
            if (code == SPDXLicense.GFDL_1_2_INVARIANTS_OR_LATER) {
                return "GFDL-1.2-invariants-or-later";
            }
            if (code == SPDXLicense.GFDL_1_2_NO_INVARIANTS_ONLY) {
                return "GFDL-1.2-no-invariants-only";
            }
            if (code == SPDXLicense.GFDL_1_2_NO_INVARIANTS_OR_LATER) {
                return "GFDL-1.2-no-invariants-or-later";
            }
            if (code == SPDXLicense.GFDL_1_2_ONLY) {
                return "GFDL-1.2-only";
            }
            if (code == SPDXLicense.GFDL_1_2_OR_LATER) {
                return "GFDL-1.2-or-later";
            }
            if (code == SPDXLicense.GFDL_1_3) {
                return "GFDL-1.3";
            }
            if (code == SPDXLicense.GFDL_1_3_INVARIANTS_ONLY) {
                return "GFDL-1.3-invariants-only";
            }
            if (code == SPDXLicense.GFDL_1_3_INVARIANTS_OR_LATER) {
                return "GFDL-1.3-invariants-or-later";
            }
            if (code == SPDXLicense.GFDL_1_3_NO_INVARIANTS_ONLY) {
                return "GFDL-1.3-no-invariants-only";
            }
            if (code == SPDXLicense.GFDL_1_3_NO_INVARIANTS_OR_LATER) {
                return "GFDL-1.3-no-invariants-or-later";
            }
            if (code == SPDXLicense.GFDL_1_3_ONLY) {
                return "GFDL-1.3-only";
            }
            if (code == SPDXLicense.GFDL_1_3_OR_LATER) {
                return "GFDL-1.3-or-later";
            }
            if (code == SPDXLicense.GIFTWARE) {
                return "Giftware";
            }
            if (code == SPDXLicense.GL2PS) {
                return "GL2PS";
            }
            if (code == SPDXLicense.GLIDE) {
                return "Glide";
            }
            if (code == SPDXLicense.GLULXE) {
                return "Glulxe";
            }
            if (code == SPDXLicense.GLWTPL) {
                return "GLWTPL";
            }
            if (code == SPDXLicense.GNUPLOT) {
                return "gnuplot";
            }
            if (code == SPDXLicense.GPL_1_0) {
                return "GPL-1.0";
            }
            if (code == SPDXLicense.GPL_1_0PLUS) {
                return "GPL-1.0+";
            }
            if (code == SPDXLicense.GPL_1_0_ONLY) {
                return "GPL-1.0-only";
            }
            if (code == SPDXLicense.GPL_1_0_OR_LATER) {
                return "GPL-1.0-or-later";
            }
            if (code == SPDXLicense.GPL_2_0) {
                return "GPL-2.0";
            }
            if (code == SPDXLicense.GPL_2_0PLUS) {
                return "GPL-2.0+";
            }
            if (code == SPDXLicense.GPL_2_0_ONLY) {
                return "GPL-2.0-only";
            }
            if (code == SPDXLicense.GPL_2_0_OR_LATER) {
                return "GPL-2.0-or-later";
            }
            if (code == SPDXLicense.GPL_2_0_WITH_AUTOCONF_EXCEPTION) {
                return "GPL-2.0-with-autoconf-exception";
            }
            if (code == SPDXLicense.GPL_2_0_WITH_BISON_EXCEPTION) {
                return "GPL-2.0-with-bison-exception";
            }
            if (code == SPDXLicense.GPL_2_0_WITH_CLASSPATH_EXCEPTION) {
                return "GPL-2.0-with-classpath-exception";
            }
            if (code == SPDXLicense.GPL_2_0_WITH_FONT_EXCEPTION) {
                return "GPL-2.0-with-font-exception";
            }
            if (code == SPDXLicense.GPL_2_0_WITH_GCC_EXCEPTION) {
                return "GPL-2.0-with-GCC-exception";
            }
            if (code == SPDXLicense.GPL_3_0) {
                return "GPL-3.0";
            }
            if (code == SPDXLicense.GPL_3_0PLUS) {
                return "GPL-3.0+";
            }
            if (code == SPDXLicense.GPL_3_0_ONLY) {
                return "GPL-3.0-only";
            }
            if (code == SPDXLicense.GPL_3_0_OR_LATER) {
                return "GPL-3.0-or-later";
            }
            if (code == SPDXLicense.GPL_3_0_WITH_AUTOCONF_EXCEPTION) {
                return "GPL-3.0-with-autoconf-exception";
            }
            if (code == SPDXLicense.GPL_3_0_WITH_GCC_EXCEPTION) {
                return "GPL-3.0-with-GCC-exception";
            }
            if (code == SPDXLicense.GRAPHICS_GEMS) {
                return "Graphics-Gems";
            }
            if (code == SPDXLicense.GSOAP_1_3B) {
                return "gSOAP-1.3b";
            }
            if (code == SPDXLicense.HASKELLREPORT) {
                return "HaskellReport";
            }
            if (code == SPDXLicense.HIPPOCRATIC_2_1) {
                return "Hippocratic-2.1";
            }
            if (code == SPDXLicense.HP_1986) {
                return "HP-1986";
            }
            if (code == SPDXLicense.HPND) {
                return "HPND";
            }
            if (code == SPDXLicense.HPND_EXPORT_US) {
                return "HPND-export-US";
            }
            if (code == SPDXLicense.HPND_MARKUS_KUHN) {
                return "HPND-Markus-Kuhn";
            }
            if (code == SPDXLicense.HPND_SELL_VARIANT) {
                return "HPND-sell-variant";
            }
            if (code == SPDXLicense.HPND_SELL_VARIANT_MIT_DISCLAIMER) {
                return "HPND-sell-variant-MIT-disclaimer";
            }
            if (code == SPDXLicense.HTMLTIDY) {
                return "HTMLTIDY";
            }
            if (code == SPDXLicense.IBM_PIBS) {
                return "IBM-pibs";
            }
            if (code == SPDXLicense.ICU) {
                return "ICU";
            }
            if (code == SPDXLicense.IEC_CODE_COMPONENTS_EULA) {
                return "IEC-Code-Components-EULA";
            }
            if (code == SPDXLicense.IJG) {
                return "IJG";
            }
            if (code == SPDXLicense.IJG_SHORT) {
                return "IJG-short";
            }
            if (code == SPDXLicense.IMAGEMAGICK) {
                return "ImageMagick";
            }
            if (code == SPDXLicense.IMATIX) {
                return "iMatix";
            }
            if (code == SPDXLicense.IMLIB2) {
                return "Imlib2";
            }
            if (code == SPDXLicense.INFO_ZIP) {
                return "Info-ZIP";
            }
            if (code == SPDXLicense.INNER_NET_2_0) {
                return "Inner-Net-2.0";
            }
            if (code == SPDXLicense.INTEL) {
                return "Intel";
            }
            if (code == SPDXLicense.INTEL_ACPI) {
                return "Intel-ACPI";
            }
            if (code == SPDXLicense.INTERBASE_1_0) {
                return "Interbase-1.0";
            }
            if (code == SPDXLicense.IPA) {
                return "IPA";
            }
            if (code == SPDXLicense.IPL_1_0) {
                return "IPL-1.0";
            }
            if (code == SPDXLicense.ISC) {
                return "ISC";
            }
            if (code == SPDXLicense.JAM) {
                return "Jam";
            }
            if (code == SPDXLicense.JASPER_2_0) {
                return "JasPer-2.0";
            }
            if (code == SPDXLicense.JPL_IMAGE) {
                return "JPL-image";
            }
            if (code == SPDXLicense.JPNIC) {
                return "JPNIC";
            }
            if (code == SPDXLicense.JSON) {
                return "JSON";
            }
            if (code == SPDXLicense.KAZLIB) {
                return "Kazlib";
            }
            if (code == SPDXLicense.KNUTH_CTAN) {
                return "Knuth-CTAN";
            }
            if (code == SPDXLicense.LAL_1_2) {
                return "LAL-1.2";
            }
            if (code == SPDXLicense.LAL_1_3) {
                return "LAL-1.3";
            }
            if (code == SPDXLicense.LATEX2E) {
                return "Latex2e";
            }
            if (code == SPDXLicense.LATEX2E_TRANSLATED_NOTICE) {
                return "Latex2e-translated-notice";
            }
            if (code == SPDXLicense.LEPTONICA) {
                return "Leptonica";
            }
            if (code == SPDXLicense.LGPL_2_0) {
                return "LGPL-2.0";
            }
            if (code == SPDXLicense.LGPL_2_0PLUS) {
                return "LGPL-2.0+";
            }
            if (code == SPDXLicense.LGPL_2_0_ONLY) {
                return "LGPL-2.0-only";
            }
            if (code == SPDXLicense.LGPL_2_0_OR_LATER) {
                return "LGPL-2.0-or-later";
            }
            if (code == SPDXLicense.LGPL_2_1) {
                return "LGPL-2.1";
            }
            if (code == SPDXLicense.LGPL_2_1PLUS) {
                return "LGPL-2.1+";
            }
            if (code == SPDXLicense.LGPL_2_1_ONLY) {
                return "LGPL-2.1-only";
            }
            if (code == SPDXLicense.LGPL_2_1_OR_LATER) {
                return "LGPL-2.1-or-later";
            }
            if (code == SPDXLicense.LGPL_3_0) {
                return "LGPL-3.0";
            }
            if (code == SPDXLicense.LGPL_3_0PLUS) {
                return "LGPL-3.0+";
            }
            if (code == SPDXLicense.LGPL_3_0_ONLY) {
                return "LGPL-3.0-only";
            }
            if (code == SPDXLicense.LGPL_3_0_OR_LATER) {
                return "LGPL-3.0-or-later";
            }
            if (code == SPDXLicense.LGPLLR) {
                return "LGPLLR";
            }
            if (code == SPDXLicense.LIBPNG) {
                return "Libpng";
            }
            if (code == SPDXLicense.LIBPNG_2_0) {
                return "libpng-2.0";
            }
            if (code == SPDXLicense.LIBSELINUX_1_0) {
                return "libselinux-1.0";
            }
            if (code == SPDXLicense.LIBTIFF) {
                return "libtiff";
            }
            if (code == SPDXLicense.LIBUTIL_DAVID_NUGENT) {
                return "libutil-David-Nugent";
            }
            if (code == SPDXLicense.LILIQ_P_1_1) {
                return "LiLiQ-P-1.1";
            }
            if (code == SPDXLicense.LILIQ_R_1_1) {
                return "LiLiQ-R-1.1";
            }
            if (code == SPDXLicense.LILIQ_RPLUS_1_1) {
                return "LiLiQ-Rplus-1.1";
            }
            if (code == SPDXLicense.LINUX_MAN_PAGES_1_PARA) {
                return "Linux-man-pages-1-para";
            }
            if (code == SPDXLicense.LINUX_MAN_PAGES_COPYLEFT) {
                return "Linux-man-pages-copyleft";
            }
            if (code == SPDXLicense.LINUX_MAN_PAGES_COPYLEFT_2_PARA) {
                return "Linux-man-pages-copyleft-2-para";
            }
            if (code == SPDXLicense.LINUX_MAN_PAGES_COPYLEFT_VAR) {
                return "Linux-man-pages-copyleft-var";
            }
            if (code == SPDXLicense.LINUX_OPENIB) {
                return "Linux-OpenIB";
            }
            if (code == SPDXLicense.LOOP) {
                return "LOOP";
            }
            if (code == SPDXLicense.LPL_1_0) {
                return "LPL-1.0";
            }
            if (code == SPDXLicense.LPL_1_02) {
                return "LPL-1.02";
            }
            if (code == SPDXLicense.LPPL_1_0) {
                return "LPPL-1.0";
            }
            if (code == SPDXLicense.LPPL_1_1) {
                return "LPPL-1.1";
            }
            if (code == SPDXLicense.LPPL_1_2) {
                return "LPPL-1.2";
            }
            if (code == SPDXLicense.LPPL_1_3A) {
                return "LPPL-1.3a";
            }
            if (code == SPDXLicense.LPPL_1_3C) {
                return "LPPL-1.3c";
            }
            if (code == SPDXLicense.LZMA_SDK_9_11_TO_9_20) {
                return "LZMA-SDK-9.11-to-9.20";
            }
            if (code == SPDXLicense.LZMA_SDK_9_22) {
                return "LZMA-SDK-9.22";
            }
            if (code == SPDXLicense.MAKEINDEX) {
                return "MakeIndex";
            }
            if (code == SPDXLicense.MARTIN_BIRGMEIER) {
                return "Martin-Birgmeier";
            }
            if (code == SPDXLicense.METAMAIL) {
                return "metamail";
            }
            if (code == SPDXLicense.MINPACK) {
                return "Minpack";
            }
            if (code == SPDXLicense.MIROS) {
                return "MirOS";
            }
            if (code == SPDXLicense.MIT) {
                return "MIT";
            }
            if (code == SPDXLicense.MIT_0) {
                return "MIT-0";
            }
            if (code == SPDXLicense.MIT_ADVERTISING) {
                return "MIT-advertising";
            }
            if (code == SPDXLicense.MIT_CMU) {
                return "MIT-CMU";
            }
            if (code == SPDXLicense.MIT_ENNA) {
                return "MIT-enna";
            }
            if (code == SPDXLicense.MIT_FEH) {
                return "MIT-feh";
            }
            if (code == SPDXLicense.MIT_FESTIVAL) {
                return "MIT-Festival";
            }
            if (code == SPDXLicense.MIT_MODERN_VARIANT) {
                return "MIT-Modern-Variant";
            }
            if (code == SPDXLicense.MIT_OPEN_GROUP) {
                return "MIT-open-group";
            }
            if (code == SPDXLicense.MIT_WU) {
                return "MIT-Wu";
            }
            if (code == SPDXLicense.MITNFA) {
                return "MITNFA";
            }
            if (code == SPDXLicense.MOTOSOTO) {
                return "Motosoto";
            }
            if (code == SPDXLicense.MPI_PERMISSIVE) {
                return "mpi-permissive";
            }
            if (code == SPDXLicense.MPICH2) {
                return "mpich2";
            }
            if (code == SPDXLicense.MPL_1_0) {
                return "MPL-1.0";
            }
            if (code == SPDXLicense.MPL_1_1) {
                return "MPL-1.1";
            }
            if (code == SPDXLicense.MPL_2_0) {
                return "MPL-2.0";
            }
            if (code == SPDXLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION) {
                return "MPL-2.0-no-copyleft-exception";
            }
            if (code == SPDXLicense.MPLUS) {
                return "mplus";
            }
            if (code == SPDXLicense.MS_LPL) {
                return "MS-LPL";
            }
            if (code == SPDXLicense.MS_PL) {
                return "MS-PL";
            }
            if (code == SPDXLicense.MS_RL) {
                return "MS-RL";
            }
            if (code == SPDXLicense.MTLL) {
                return "MTLL";
            }
            if (code == SPDXLicense.MULANPSL_1_0) {
                return "MulanPSL-1.0";
            }
            if (code == SPDXLicense.MULANPSL_2_0) {
                return "MulanPSL-2.0";
            }
            if (code == SPDXLicense.MULTICS) {
                return "Multics";
            }
            if (code == SPDXLicense.MUP) {
                return "Mup";
            }
            if (code == SPDXLicense.NAIST_2003) {
                return "NAIST-2003";
            }
            if (code == SPDXLicense.NASA_1_3) {
                return "NASA-1.3";
            }
            if (code == SPDXLicense.NAUMEN) {
                return "Naumen";
            }
            if (code == SPDXLicense.NBPL_1_0) {
                return "NBPL-1.0";
            }
            if (code == SPDXLicense.NCGL_UK_2_0) {
                return "NCGL-UK-2.0";
            }
            if (code == SPDXLicense.NCSA) {
                return "NCSA";
            }
            if (code == SPDXLicense.NET_SNMP) {
                return "Net-SNMP";
            }
            if (code == SPDXLicense.NETCDF) {
                return "NetCDF";
            }
            if (code == SPDXLicense.NEWSLETR) {
                return "Newsletr";
            }
            if (code == SPDXLicense.NGPL) {
                return "NGPL";
            }
            if (code == SPDXLicense.NICTA_1_0) {
                return "NICTA-1.0";
            }
            if (code == SPDXLicense.NIST_PD) {
                return "NIST-PD";
            }
            if (code == SPDXLicense.NIST_PD_FALLBACK) {
                return "NIST-PD-fallback";
            }
            if (code == SPDXLicense.NIST_SOFTWARE) {
                return "NIST-Software";
            }
            if (code == SPDXLicense.NLOD_1_0) {
                return "NLOD-1.0";
            }
            if (code == SPDXLicense.NLOD_2_0) {
                return "NLOD-2.0";
            }
            if (code == SPDXLicense.NLPL) {
                return "NLPL";
            }
            if (code == SPDXLicense.NOKIA) {
                return "Nokia";
            }
            if (code == SPDXLicense.NOSL) {
                return "NOSL";
            }
            if (code == SPDXLicense.NOT_OPEN_SOURCE) {
                return "not-open-source";
            }
            if (code == SPDXLicense.NOWEB) {
                return "Noweb";
            }
            if (code == SPDXLicense.NPL_1_0) {
                return "NPL-1.0";
            }
            if (code == SPDXLicense.NPL_1_1) {
                return "NPL-1.1";
            }
            if (code == SPDXLicense.NPOSL_3_0) {
                return "NPOSL-3.0";
            }
            if (code == SPDXLicense.NRL) {
                return "NRL";
            }
            if (code == SPDXLicense.NTP) {
                return "NTP";
            }
            if (code == SPDXLicense.NTP_0) {
                return "NTP-0";
            }
            if (code == SPDXLicense.NUNIT) {
                return "Nunit";
            }
            if (code == SPDXLicense.O_UDA_1_0) {
                return "O-UDA-1.0";
            }
            if (code == SPDXLicense.OCCT_PL) {
                return "OCCT-PL";
            }
            if (code == SPDXLicense.OCLC_2_0) {
                return "OCLC-2.0";
            }
            if (code == SPDXLicense.ODBL_1_0) {
                return "ODbL-1.0";
            }
            if (code == SPDXLicense.ODC_BY_1_0) {
                return "ODC-By-1.0";
            }
            if (code == SPDXLicense.OFFIS) {
                return "OFFIS";
            }
            if (code == SPDXLicense.OFL_1_0) {
                return "OFL-1.0";
            }
            if (code == SPDXLicense.OFL_1_0_NO_RFN) {
                return "OFL-1.0-no-RFN";
            }
            if (code == SPDXLicense.OFL_1_0_RFN) {
                return "OFL-1.0-RFN";
            }
            if (code == SPDXLicense.OFL_1_1) {
                return "OFL-1.1";
            }
            if (code == SPDXLicense.OFL_1_1_NO_RFN) {
                return "OFL-1.1-no-RFN";
            }
            if (code == SPDXLicense.OFL_1_1_RFN) {
                return "OFL-1.1-RFN";
            }
            if (code == SPDXLicense.OGC_1_0) {
                return "OGC-1.0";
            }
            if (code == SPDXLicense.OGDL_TAIWAN_1_0) {
                return "OGDL-Taiwan-1.0";
            }
            if (code == SPDXLicense.OGL_CANADA_2_0) {
                return "OGL-Canada-2.0";
            }
            if (code == SPDXLicense.OGL_UK_1_0) {
                return "OGL-UK-1.0";
            }
            if (code == SPDXLicense.OGL_UK_2_0) {
                return "OGL-UK-2.0";
            }
            if (code == SPDXLicense.OGL_UK_3_0) {
                return "OGL-UK-3.0";
            }
            if (code == SPDXLicense.OGTSL) {
                return "OGTSL";
            }
            if (code == SPDXLicense.OLDAP_1_1) {
                return "OLDAP-1.1";
            }
            if (code == SPDXLicense.OLDAP_1_2) {
                return "OLDAP-1.2";
            }
            if (code == SPDXLicense.OLDAP_1_3) {
                return "OLDAP-1.3";
            }
            if (code == SPDXLicense.OLDAP_1_4) {
                return "OLDAP-1.4";
            }
            if (code == SPDXLicense.OLDAP_2_0) {
                return "OLDAP-2.0";
            }
            if (code == SPDXLicense.OLDAP_2_0_1) {
                return "OLDAP-2.0.1";
            }
            if (code == SPDXLicense.OLDAP_2_1) {
                return "OLDAP-2.1";
            }
            if (code == SPDXLicense.OLDAP_2_2) {
                return "OLDAP-2.2";
            }
            if (code == SPDXLicense.OLDAP_2_2_1) {
                return "OLDAP-2.2.1";
            }
            if (code == SPDXLicense.OLDAP_2_2_2) {
                return "OLDAP-2.2.2";
            }
            if (code == SPDXLicense.OLDAP_2_3) {
                return "OLDAP-2.3";
            }
            if (code == SPDXLicense.OLDAP_2_4) {
                return "OLDAP-2.4";
            }
            if (code == SPDXLicense.OLDAP_2_5) {
                return "OLDAP-2.5";
            }
            if (code == SPDXLicense.OLDAP_2_6) {
                return "OLDAP-2.6";
            }
            if (code == SPDXLicense.OLDAP_2_7) {
                return "OLDAP-2.7";
            }
            if (code == SPDXLicense.OLDAP_2_8) {
                return "OLDAP-2.8";
            }
            if (code == SPDXLicense.OLFL_1_3) {
                return "OLFL-1.3";
            }
            if (code == SPDXLicense.OML) {
                return "OML";
            }
            if (code == SPDXLicense.OPENPBS_2_3) {
                return "OpenPBS-2.3";
            }
            if (code == SPDXLicense.OPENSSL) {
                return "OpenSSL";
            }
            if (code == SPDXLicense.OPL_1_0) {
                return "OPL-1.0";
            }
            if (code == SPDXLicense.OPL_UK_3_0) {
                return "OPL-UK-3.0";
            }
            if (code == SPDXLicense.OPUBL_1_0) {
                return "OPUBL-1.0";
            }
            if (code == SPDXLicense.OSET_PL_2_1) {
                return "OSET-PL-2.1";
            }
            if (code == SPDXLicense.OSL_1_0) {
                return "OSL-1.0";
            }
            if (code == SPDXLicense.OSL_1_1) {
                return "OSL-1.1";
            }
            if (code == SPDXLicense.OSL_2_0) {
                return "OSL-2.0";
            }
            if (code == SPDXLicense.OSL_2_1) {
                return "OSL-2.1";
            }
            if (code == SPDXLicense.OSL_3_0) {
                return "OSL-3.0";
            }
            if (code == SPDXLicense.PARITY_6_0_0) {
                return "Parity-6.0.0";
            }
            if (code == SPDXLicense.PARITY_7_0_0) {
                return "Parity-7.0.0";
            }
            if (code == SPDXLicense.PDDL_1_0) {
                return "PDDL-1.0";
            }
            if (code == SPDXLicense.PHP_3_0) {
                return "PHP-3.0";
            }
            if (code == SPDXLicense.PHP_3_01) {
                return "PHP-3.01";
            }
            if (code == SPDXLicense.PLEXUS) {
                return "Plexus";
            }
            if (code == SPDXLicense.POLYFORM_NONCOMMERCIAL_1_0_0) {
                return "PolyForm-Noncommercial-1.0.0";
            }
            if (code == SPDXLicense.POLYFORM_SMALL_BUSINESS_1_0_0) {
                return "PolyForm-Small-Business-1.0.0";
            }
            if (code == SPDXLicense.POSTGRESQL) {
                return "PostgreSQL";
            }
            if (code == SPDXLicense.PSF_2_0) {
                return "PSF-2.0";
            }
            if (code == SPDXLicense.PSFRAG) {
                return "psfrag";
            }
            if (code == SPDXLicense.PSUTILS) {
                return "psutils";
            }
            if (code == SPDXLicense.PYTHON_2_0) {
                return "Python-2.0";
            }
            if (code == SPDXLicense.PYTHON_2_0_1) {
                return "Python-2.0.1";
            }
            if (code == SPDXLicense.QHULL) {
                return "Qhull";
            }
            if (code == SPDXLicense.QPL_1_0) {
                return "QPL-1.0";
            }
            if (code == SPDXLicense.QPL_1_0_INRIA_2004) {
                return "QPL-1.0-INRIA-2004";
            }
            if (code == SPDXLicense.RDISC) {
                return "Rdisc";
            }
            if (code == SPDXLicense.RHECOS_1_1) {
                return "RHeCos-1.1";
            }
            if (code == SPDXLicense.RPL_1_1) {
                return "RPL-1.1";
            }
            if (code == SPDXLicense.RPL_1_5) {
                return "RPL-1.5";
            }
            if (code == SPDXLicense.RPSL_1_0) {
                return "RPSL-1.0";
            }
            if (code == SPDXLicense.RSA_MD) {
                return "RSA-MD";
            }
            if (code == SPDXLicense.RSCPL) {
                return "RSCPL";
            }
            if (code == SPDXLicense.RUBY) {
                return "Ruby";
            }
            if (code == SPDXLicense.SAX_PD) {
                return "SAX-PD";
            }
            if (code == SPDXLicense.SAXPATH) {
                return "Saxpath";
            }
            if (code == SPDXLicense.SCEA) {
                return "SCEA";
            }
            if (code == SPDXLicense.SCHEMEREPORT) {
                return "SchemeReport";
            }
            if (code == SPDXLicense.SENDMAIL) {
                return "Sendmail";
            }
            if (code == SPDXLicense.SENDMAIL_8_23) {
                return "Sendmail-8.23";
            }
            if (code == SPDXLicense.SGI_B_1_0) {
                return "SGI-B-1.0";
            }
            if (code == SPDXLicense.SGI_B_1_1) {
                return "SGI-B-1.1";
            }
            if (code == SPDXLicense.SGI_B_2_0) {
                return "SGI-B-2.0";
            }
            if (code == SPDXLicense.SGP4) {
                return "SGP4";
            }
            if (code == SPDXLicense.SHL_0_5) {
                return "SHL-0.5";
            }
            if (code == SPDXLicense.SHL_0_51) {
                return "SHL-0.51";
            }
            if (code == SPDXLicense.SIMPL_2_0) {
                return "SimPL-2.0";
            }
            if (code == SPDXLicense.SISSL) {
                return "SISSL";
            }
            if (code == SPDXLicense.SISSL_1_2) {
                return "SISSL-1.2";
            }
            if (code == SPDXLicense.SLEEPYCAT) {
                return "Sleepycat";
            }
            if (code == SPDXLicense.SMLNJ) {
                return "SMLNJ";
            }
            if (code == SPDXLicense.SMPPL) {
                return "SMPPL";
            }
            if (code == SPDXLicense.SNIA) {
                return "SNIA";
            }
            if (code == SPDXLicense.SNPRINTF) {
                return "snprintf";
            }
            if (code == SPDXLicense.SPENCER_86) {
                return "Spencer-86";
            }
            if (code == SPDXLicense.SPENCER_94) {
                return "Spencer-94";
            }
            if (code == SPDXLicense.SPENCER_99) {
                return "Spencer-99";
            }
            if (code == SPDXLicense.SPL_1_0) {
                return "SPL-1.0";
            }
            if (code == SPDXLicense.SSH_OPENSSH) {
                return "SSH-OpenSSH";
            }
            if (code == SPDXLicense.SSH_SHORT) {
                return "SSH-short";
            }
            if (code == SPDXLicense.SSPL_1_0) {
                return "SSPL-1.0";
            }
            if (code == SPDXLicense.STANDARDML_NJ) {
                return "StandardML-NJ";
            }
            if (code == SPDXLicense.SUGARCRM_1_1_3) {
                return "SugarCRM-1.1.3";
            }
            if (code == SPDXLicense.SUNPRO) {
                return "SunPro";
            }
            if (code == SPDXLicense.SWL) {
                return "SWL";
            }
            if (code == SPDXLicense.SYMLINKS) {
                return "Symlinks";
            }
            if (code == SPDXLicense.TAPR_OHL_1_0) {
                return "TAPR-OHL-1.0";
            }
            if (code == SPDXLicense.TCL) {
                return "TCL";
            }
            if (code == SPDXLicense.TCP_WRAPPERS) {
                return "TCP-wrappers";
            }
            if (code == SPDXLicense.TERMREADKEY) {
                return "TermReadKey";
            }
            if (code == SPDXLicense.TMATE) {
                return "TMate";
            }
            if (code == SPDXLicense.TORQUE_1_1) {
                return "TORQUE-1.1";
            }
            if (code == SPDXLicense.TOSL) {
                return "TOSL";
            }
            if (code == SPDXLicense.TPDL) {
                return "TPDL";
            }
            if (code == SPDXLicense.TPL_1_0) {
                return "TPL-1.0";
            }
            if (code == SPDXLicense.TTWL) {
                return "TTWL";
            }
            if (code == SPDXLicense.TU_BERLIN_1_0) {
                return "TU-Berlin-1.0";
            }
            if (code == SPDXLicense.TU_BERLIN_2_0) {
                return "TU-Berlin-2.0";
            }
            if (code == SPDXLicense.UCAR) {
                return "UCAR";
            }
            if (code == SPDXLicense.UCL_1_0) {
                return "UCL-1.0";
            }
            if (code == SPDXLicense.UNICODE_DFS_2015) {
                return "Unicode-DFS-2015";
            }
            if (code == SPDXLicense.UNICODE_DFS_2016) {
                return "Unicode-DFS-2016";
            }
            if (code == SPDXLicense.UNICODE_TOU) {
                return "Unicode-TOU";
            }
            if (code == SPDXLicense.UNIXCRYPT) {
                return "UnixCrypt";
            }
            if (code == SPDXLicense.UNLICENSE) {
                return "Unlicense";
            }
            if (code == SPDXLicense.UPL_1_0) {
                return "UPL-1.0";
            }
            if (code == SPDXLicense.VIM) {
                return "Vim";
            }
            if (code == SPDXLicense.VOSTROM) {
                return "VOSTROM";
            }
            if (code == SPDXLicense.VSL_1_0) {
                return "VSL-1.0";
            }
            if (code == SPDXLicense.W3C) {
                return "W3C";
            }
            if (code == SPDXLicense.W3C_19980720) {
                return "W3C-19980720";
            }
            if (code == SPDXLicense.W3C_20150513) {
                return "W3C-20150513";
            }
            if (code == SPDXLicense.W3M) {
                return "w3m";
            }
            if (code == SPDXLicense.WATCOM_1_0) {
                return "Watcom-1.0";
            }
            if (code == SPDXLicense.WIDGET_WORKSHOP) {
                return "Widget-Workshop";
            }
            if (code == SPDXLicense.WSUIPA) {
                return "Wsuipa";
            }
            if (code == SPDXLicense.WTFPL) {
                return "WTFPL";
            }
            if (code == SPDXLicense.WXWINDOWS) {
                return "wxWindows";
            }
            if (code == SPDXLicense.X11) {
                return "X11";
            }
            if (code == SPDXLicense.X11_DISTRIBUTE_MODIFICATIONS_VARIANT) {
                return "X11-distribute-modifications-variant";
            }
            if (code == SPDXLicense.XDEBUG_1_03) {
                return "Xdebug-1.03";
            }
            if (code == SPDXLicense.XEROX) {
                return "Xerox";
            }
            if (code == SPDXLicense.XFIG) {
                return "Xfig";
            }
            if (code == SPDXLicense.XFREE86_1_1) {
                return "XFree86-1.1";
            }
            if (code == SPDXLicense.XINETD) {
                return "xinetd";
            }
            if (code == SPDXLicense.XLOCK) {
                return "xlock";
            }
            if (code == SPDXLicense.XNET) {
                return "Xnet";
            }
            if (code == SPDXLicense.XPP) {
                return "xpp";
            }
            if (code == SPDXLicense.XSKAT) {
                return "XSkat";
            }
            if (code == SPDXLicense.YPL_1_0) {
                return "YPL-1.0";
            }
            if (code == SPDXLicense.YPL_1_1) {
                return "YPL-1.1";
            }
            if (code == SPDXLicense.ZED) {
                return "Zed";
            }
            if (code == SPDXLicense.ZEND_2_0) {
                return "Zend-2.0";
            }
            if (code == SPDXLicense.ZIMBRA_1_3) {
                return "Zimbra-1.3";
            }
            if (code == SPDXLicense.ZIMBRA_1_4) {
                return "Zimbra-1.4";
            }
            if (code == SPDXLicense.ZLIB) {
                return "Zlib";
            }
            if (code == SPDXLicense.ZLIB_ACKNOWLEDGEMENT) {
                return "zlib-acknowledgement";
            }
            if (code == SPDXLicense.ZPL_1_1) {
                return "ZPL-1.1";
            }
            if (code == SPDXLicense.ZPL_2_0) {
                return "ZPL-2.0";
            }
            if (code == SPDXLicense.ZPL_2_1) {
                return "ZPL-2.1";
            }
            return "?";
        }

        @Override
        public String toSystem(SPDXLicense code) {
            return code.getSystem();
        }
    }

    public static enum SPDXLicense {
        _0BSD,
        AAL,
        ABSTYLES,
        ADACORE_DOC,
        ADOBE_2006,
        ADOBE_GLYPH,
        ADSL,
        AFL_1_1,
        AFL_1_2,
        AFL_2_0,
        AFL_2_1,
        AFL_3_0,
        AFMPARSE,
        AGPL_1_0,
        AGPL_1_0_ONLY,
        AGPL_1_0_OR_LATER,
        AGPL_3_0,
        AGPL_3_0_ONLY,
        AGPL_3_0_OR_LATER,
        ALADDIN,
        AMDPLPA,
        AML,
        AMPAS,
        ANTLR_PD,
        ANTLR_PD_FALLBACK,
        APACHE_1_0,
        APACHE_1_1,
        APACHE_2_0,
        APAFML,
        APL_1_0,
        APP_S2P,
        APSL_1_0,
        APSL_1_1,
        APSL_1_2,
        APSL_2_0,
        ARPHIC_1999,
        ARTISTIC_1_0,
        ARTISTIC_1_0_CL8,
        ARTISTIC_1_0_PERL,
        ARTISTIC_2_0,
        ASWF_DIGITAL_ASSETS_1_0,
        ASWF_DIGITAL_ASSETS_1_1,
        BAEKMUK,
        BAHYPH,
        BARR,
        BEERWARE,
        BITSTREAM_CHARTER,
        BITSTREAM_VERA,
        BITTORRENT_1_0,
        BITTORRENT_1_1,
        BLESSING,
        BLUEOAK_1_0_0,
        BOEHM_GC,
        BORCEUX,
        BRIAN_GLADMAN_3_CLAUSE,
        BSD_1_CLAUSE,
        BSD_2_CLAUSE,
        BSD_2_CLAUSE_FREEBSD,
        BSD_2_CLAUSE_NETBSD,
        BSD_2_CLAUSE_PATENT,
        BSD_2_CLAUSE_VIEWS,
        BSD_3_CLAUSE,
        BSD_3_CLAUSE_ATTRIBUTION,
        BSD_3_CLAUSE_CLEAR,
        BSD_3_CLAUSE_LBNL,
        BSD_3_CLAUSE_MODIFICATION,
        BSD_3_CLAUSE_NO_MILITARY_LICENSE,
        BSD_3_CLAUSE_NO_NUCLEAR_LICENSE,
        BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014,
        BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY,
        BSD_3_CLAUSE_OPEN_MPI,
        BSD_4_CLAUSE,
        BSD_4_CLAUSE_SHORTENED,
        BSD_4_CLAUSE_UC,
        BSD_4_3RENO,
        BSD_4_3TAHOE,
        BSD_ADVERTISING_ACKNOWLEDGEMENT,
        BSD_ATTRIBUTION_HPND_DISCLAIMER,
        BSD_PROTECTION,
        BSD_SOURCE_CODE,
        BSL_1_0,
        BUSL_1_1,
        BZIP2_1_0_5,
        BZIP2_1_0_6,
        C_UDA_1_0,
        CAL_1_0,
        CAL_1_0_COMBINED_WORK_EXCEPTION,
        CALDERA,
        CATOSL_1_1,
        CC_BY_1_0,
        CC_BY_2_0,
        CC_BY_2_5,
        CC_BY_2_5_AU,
        CC_BY_3_0,
        CC_BY_3_0_AT,
        CC_BY_3_0_DE,
        CC_BY_3_0_IGO,
        CC_BY_3_0_NL,
        CC_BY_3_0_US,
        CC_BY_4_0,
        CC_BY_NC_1_0,
        CC_BY_NC_2_0,
        CC_BY_NC_2_5,
        CC_BY_NC_3_0,
        CC_BY_NC_3_0_DE,
        CC_BY_NC_4_0,
        CC_BY_NC_ND_1_0,
        CC_BY_NC_ND_2_0,
        CC_BY_NC_ND_2_5,
        CC_BY_NC_ND_3_0,
        CC_BY_NC_ND_3_0_DE,
        CC_BY_NC_ND_3_0_IGO,
        CC_BY_NC_ND_4_0,
        CC_BY_NC_SA_1_0,
        CC_BY_NC_SA_2_0,
        CC_BY_NC_SA_2_0_DE,
        CC_BY_NC_SA_2_0_FR,
        CC_BY_NC_SA_2_0_UK,
        CC_BY_NC_SA_2_5,
        CC_BY_NC_SA_3_0,
        CC_BY_NC_SA_3_0_DE,
        CC_BY_NC_SA_3_0_IGO,
        CC_BY_NC_SA_4_0,
        CC_BY_ND_1_0,
        CC_BY_ND_2_0,
        CC_BY_ND_2_5,
        CC_BY_ND_3_0,
        CC_BY_ND_3_0_DE,
        CC_BY_ND_4_0,
        CC_BY_SA_1_0,
        CC_BY_SA_2_0,
        CC_BY_SA_2_0_UK,
        CC_BY_SA_2_1_JP,
        CC_BY_SA_2_5,
        CC_BY_SA_3_0,
        CC_BY_SA_3_0_AT,
        CC_BY_SA_3_0_DE,
        CC_BY_SA_3_0_IGO,
        CC_BY_SA_4_0,
        CC_PDDC,
        CC0_1_0,
        CDDL_1_0,
        CDDL_1_1,
        CDL_1_0,
        CDLA_PERMISSIVE_1_0,
        CDLA_PERMISSIVE_2_0,
        CDLA_SHARING_1_0,
        CECILL_1_0,
        CECILL_1_1,
        CECILL_2_0,
        CECILL_2_1,
        CECILL_B,
        CECILL_C,
        CERN_OHL_1_1,
        CERN_OHL_1_2,
        CERN_OHL_P_2_0,
        CERN_OHL_S_2_0,
        CERN_OHL_W_2_0,
        CFITSIO,
        CHECKMK,
        CLARTISTIC,
        CLIPS,
        CMU_MACH,
        CNRI_JYTHON,
        CNRI_PYTHON,
        CNRI_PYTHON_GPL_COMPATIBLE,
        COIL_1_0,
        COMMUNITY_SPEC_1_0,
        CONDOR_1_1,
        COPYLEFT_NEXT_0_3_0,
        COPYLEFT_NEXT_0_3_1,
        CORNELL_LOSSLESS_JPEG,
        CPAL_1_0,
        CPL_1_0,
        CPOL_1_02,
        CROSSWORD,
        CRYSTALSTACKER,
        CUA_OPL_1_0,
        CUBE,
        CURL,
        D_FSL_1_0,
        DIFFMARK,
        DL_DE_BY_2_0,
        DOC,
        DOTSEQN,
        DRL_1_0,
        DSDP,
        DTOA,
        DVIPDFM,
        ECL_1_0,
        ECL_2_0,
        ECOS_2_0,
        EFL_1_0,
        EFL_2_0,
        EGENIX,
        ELASTIC_2_0,
        ENTESSA,
        EPICS,
        EPL_1_0,
        EPL_2_0,
        ERLPL_1_1,
        ETALAB_2_0,
        EUDATAGRID,
        EUPL_1_0,
        EUPL_1_1,
        EUPL_1_2,
        EUROSYM,
        FAIR,
        FDK_AAC,
        FRAMEWORX_1_0,
        FREEBSD_DOC,
        FREEIMAGE,
        FSFAP,
        FSFUL,
        FSFULLR,
        FSFULLRWD,
        FTL,
        GD,
        GFDL_1_1,
        GFDL_1_1_INVARIANTS_ONLY,
        GFDL_1_1_INVARIANTS_OR_LATER,
        GFDL_1_1_NO_INVARIANTS_ONLY,
        GFDL_1_1_NO_INVARIANTS_OR_LATER,
        GFDL_1_1_ONLY,
        GFDL_1_1_OR_LATER,
        GFDL_1_2,
        GFDL_1_2_INVARIANTS_ONLY,
        GFDL_1_2_INVARIANTS_OR_LATER,
        GFDL_1_2_NO_INVARIANTS_ONLY,
        GFDL_1_2_NO_INVARIANTS_OR_LATER,
        GFDL_1_2_ONLY,
        GFDL_1_2_OR_LATER,
        GFDL_1_3,
        GFDL_1_3_INVARIANTS_ONLY,
        GFDL_1_3_INVARIANTS_OR_LATER,
        GFDL_1_3_NO_INVARIANTS_ONLY,
        GFDL_1_3_NO_INVARIANTS_OR_LATER,
        GFDL_1_3_ONLY,
        GFDL_1_3_OR_LATER,
        GIFTWARE,
        GL2PS,
        GLIDE,
        GLULXE,
        GLWTPL,
        GNUPLOT,
        GPL_1_0,
        GPL_1_0PLUS,
        GPL_1_0_ONLY,
        GPL_1_0_OR_LATER,
        GPL_2_0,
        GPL_2_0PLUS,
        GPL_2_0_ONLY,
        GPL_2_0_OR_LATER,
        GPL_2_0_WITH_AUTOCONF_EXCEPTION,
        GPL_2_0_WITH_BISON_EXCEPTION,
        GPL_2_0_WITH_CLASSPATH_EXCEPTION,
        GPL_2_0_WITH_FONT_EXCEPTION,
        GPL_2_0_WITH_GCC_EXCEPTION,
        GPL_3_0,
        GPL_3_0PLUS,
        GPL_3_0_ONLY,
        GPL_3_0_OR_LATER,
        GPL_3_0_WITH_AUTOCONF_EXCEPTION,
        GPL_3_0_WITH_GCC_EXCEPTION,
        GRAPHICS_GEMS,
        GSOAP_1_3B,
        HASKELLREPORT,
        HIPPOCRATIC_2_1,
        HP_1986,
        HPND,
        HPND_EXPORT_US,
        HPND_MARKUS_KUHN,
        HPND_SELL_VARIANT,
        HPND_SELL_VARIANT_MIT_DISCLAIMER,
        HTMLTIDY,
        IBM_PIBS,
        ICU,
        IEC_CODE_COMPONENTS_EULA,
        IJG,
        IJG_SHORT,
        IMAGEMAGICK,
        IMATIX,
        IMLIB2,
        INFO_ZIP,
        INNER_NET_2_0,
        INTEL,
        INTEL_ACPI,
        INTERBASE_1_0,
        IPA,
        IPL_1_0,
        ISC,
        JAM,
        JASPER_2_0,
        JPL_IMAGE,
        JPNIC,
        JSON,
        KAZLIB,
        KNUTH_CTAN,
        LAL_1_2,
        LAL_1_3,
        LATEX2E,
        LATEX2E_TRANSLATED_NOTICE,
        LEPTONICA,
        LGPL_2_0,
        LGPL_2_0PLUS,
        LGPL_2_0_ONLY,
        LGPL_2_0_OR_LATER,
        LGPL_2_1,
        LGPL_2_1PLUS,
        LGPL_2_1_ONLY,
        LGPL_2_1_OR_LATER,
        LGPL_3_0,
        LGPL_3_0PLUS,
        LGPL_3_0_ONLY,
        LGPL_3_0_OR_LATER,
        LGPLLR,
        LIBPNG,
        LIBPNG_2_0,
        LIBSELINUX_1_0,
        LIBTIFF,
        LIBUTIL_DAVID_NUGENT,
        LILIQ_P_1_1,
        LILIQ_R_1_1,
        LILIQ_RPLUS_1_1,
        LINUX_MAN_PAGES_1_PARA,
        LINUX_MAN_PAGES_COPYLEFT,
        LINUX_MAN_PAGES_COPYLEFT_2_PARA,
        LINUX_MAN_PAGES_COPYLEFT_VAR,
        LINUX_OPENIB,
        LOOP,
        LPL_1_0,
        LPL_1_02,
        LPPL_1_0,
        LPPL_1_1,
        LPPL_1_2,
        LPPL_1_3A,
        LPPL_1_3C,
        LZMA_SDK_9_11_TO_9_20,
        LZMA_SDK_9_22,
        MAKEINDEX,
        MARTIN_BIRGMEIER,
        METAMAIL,
        MINPACK,
        MIROS,
        MIT,
        MIT_0,
        MIT_ADVERTISING,
        MIT_CMU,
        MIT_ENNA,
        MIT_FEH,
        MIT_FESTIVAL,
        MIT_MODERN_VARIANT,
        MIT_OPEN_GROUP,
        MIT_WU,
        MITNFA,
        MOTOSOTO,
        MPI_PERMISSIVE,
        MPICH2,
        MPL_1_0,
        MPL_1_1,
        MPL_2_0,
        MPL_2_0_NO_COPYLEFT_EXCEPTION,
        MPLUS,
        MS_LPL,
        MS_PL,
        MS_RL,
        MTLL,
        MULANPSL_1_0,
        MULANPSL_2_0,
        MULTICS,
        MUP,
        NAIST_2003,
        NASA_1_3,
        NAUMEN,
        NBPL_1_0,
        NCGL_UK_2_0,
        NCSA,
        NET_SNMP,
        NETCDF,
        NEWSLETR,
        NGPL,
        NICTA_1_0,
        NIST_PD,
        NIST_PD_FALLBACK,
        NIST_SOFTWARE,
        NLOD_1_0,
        NLOD_2_0,
        NLPL,
        NOKIA,
        NOSL,
        NOT_OPEN_SOURCE,
        NOWEB,
        NPL_1_0,
        NPL_1_1,
        NPOSL_3_0,
        NRL,
        NTP,
        NTP_0,
        NUNIT,
        O_UDA_1_0,
        OCCT_PL,
        OCLC_2_0,
        ODBL_1_0,
        ODC_BY_1_0,
        OFFIS,
        OFL_1_0,
        OFL_1_0_NO_RFN,
        OFL_1_0_RFN,
        OFL_1_1,
        OFL_1_1_NO_RFN,
        OFL_1_1_RFN,
        OGC_1_0,
        OGDL_TAIWAN_1_0,
        OGL_CANADA_2_0,
        OGL_UK_1_0,
        OGL_UK_2_0,
        OGL_UK_3_0,
        OGTSL,
        OLDAP_1_1,
        OLDAP_1_2,
        OLDAP_1_3,
        OLDAP_1_4,
        OLDAP_2_0,
        OLDAP_2_0_1,
        OLDAP_2_1,
        OLDAP_2_2,
        OLDAP_2_2_1,
        OLDAP_2_2_2,
        OLDAP_2_3,
        OLDAP_2_4,
        OLDAP_2_5,
        OLDAP_2_6,
        OLDAP_2_7,
        OLDAP_2_8,
        OLFL_1_3,
        OML,
        OPENPBS_2_3,
        OPENSSL,
        OPL_1_0,
        OPL_UK_3_0,
        OPUBL_1_0,
        OSET_PL_2_1,
        OSL_1_0,
        OSL_1_1,
        OSL_2_0,
        OSL_2_1,
        OSL_3_0,
        PARITY_6_0_0,
        PARITY_7_0_0,
        PDDL_1_0,
        PHP_3_0,
        PHP_3_01,
        PLEXUS,
        POLYFORM_NONCOMMERCIAL_1_0_0,
        POLYFORM_SMALL_BUSINESS_1_0_0,
        POSTGRESQL,
        PSF_2_0,
        PSFRAG,
        PSUTILS,
        PYTHON_2_0,
        PYTHON_2_0_1,
        QHULL,
        QPL_1_0,
        QPL_1_0_INRIA_2004,
        RDISC,
        RHECOS_1_1,
        RPL_1_1,
        RPL_1_5,
        RPSL_1_0,
        RSA_MD,
        RSCPL,
        RUBY,
        SAX_PD,
        SAXPATH,
        SCEA,
        SCHEMEREPORT,
        SENDMAIL,
        SENDMAIL_8_23,
        SGI_B_1_0,
        SGI_B_1_1,
        SGI_B_2_0,
        SGP4,
        SHL_0_5,
        SHL_0_51,
        SIMPL_2_0,
        SISSL,
        SISSL_1_2,
        SLEEPYCAT,
        SMLNJ,
        SMPPL,
        SNIA,
        SNPRINTF,
        SPENCER_86,
        SPENCER_94,
        SPENCER_99,
        SPL_1_0,
        SSH_OPENSSH,
        SSH_SHORT,
        SSPL_1_0,
        STANDARDML_NJ,
        SUGARCRM_1_1_3,
        SUNPRO,
        SWL,
        SYMLINKS,
        TAPR_OHL_1_0,
        TCL,
        TCP_WRAPPERS,
        TERMREADKEY,
        TMATE,
        TORQUE_1_1,
        TOSL,
        TPDL,
        TPL_1_0,
        TTWL,
        TU_BERLIN_1_0,
        TU_BERLIN_2_0,
        UCAR,
        UCL_1_0,
        UNICODE_DFS_2015,
        UNICODE_DFS_2016,
        UNICODE_TOU,
        UNIXCRYPT,
        UNLICENSE,
        UPL_1_0,
        VIM,
        VOSTROM,
        VSL_1_0,
        W3C,
        W3C_19980720,
        W3C_20150513,
        W3M,
        WATCOM_1_0,
        WIDGET_WORKSHOP,
        WSUIPA,
        WTFPL,
        WXWINDOWS,
        X11,
        X11_DISTRIBUTE_MODIFICATIONS_VARIANT,
        XDEBUG_1_03,
        XEROX,
        XFIG,
        XFREE86_1_1,
        XINETD,
        XLOCK,
        XNET,
        XPP,
        XSKAT,
        YPL_1_0,
        YPL_1_1,
        ZED,
        ZEND_2_0,
        ZIMBRA_1_3,
        ZIMBRA_1_4,
        ZLIB,
        ZLIB_ACKNOWLEDGEMENT,
        ZPL_1_1,
        ZPL_2_0,
        ZPL_2_1,
        NULL;


        public static SPDXLicense fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("0BSD".equals(codeString)) {
                return _0BSD;
            }
            if ("AAL".equals(codeString)) {
                return AAL;
            }
            if ("Abstyles".equals(codeString)) {
                return ABSTYLES;
            }
            if ("AdaCore-doc".equals(codeString)) {
                return ADACORE_DOC;
            }
            if ("Adobe-2006".equals(codeString)) {
                return ADOBE_2006;
            }
            if ("Adobe-Glyph".equals(codeString)) {
                return ADOBE_GLYPH;
            }
            if ("ADSL".equals(codeString)) {
                return ADSL;
            }
            if ("AFL-1.1".equals(codeString)) {
                return AFL_1_1;
            }
            if ("AFL-1.2".equals(codeString)) {
                return AFL_1_2;
            }
            if ("AFL-2.0".equals(codeString)) {
                return AFL_2_0;
            }
            if ("AFL-2.1".equals(codeString)) {
                return AFL_2_1;
            }
            if ("AFL-3.0".equals(codeString)) {
                return AFL_3_0;
            }
            if ("Afmparse".equals(codeString)) {
                return AFMPARSE;
            }
            if ("AGPL-1.0".equals(codeString)) {
                return AGPL_1_0;
            }
            if ("AGPL-1.0-only".equals(codeString)) {
                return AGPL_1_0_ONLY;
            }
            if ("AGPL-1.0-or-later".equals(codeString)) {
                return AGPL_1_0_OR_LATER;
            }
            if ("AGPL-3.0".equals(codeString)) {
                return AGPL_3_0;
            }
            if ("AGPL-3.0-only".equals(codeString)) {
                return AGPL_3_0_ONLY;
            }
            if ("AGPL-3.0-or-later".equals(codeString)) {
                return AGPL_3_0_OR_LATER;
            }
            if ("Aladdin".equals(codeString)) {
                return ALADDIN;
            }
            if ("AMDPLPA".equals(codeString)) {
                return AMDPLPA;
            }
            if ("AML".equals(codeString)) {
                return AML;
            }
            if ("AMPAS".equals(codeString)) {
                return AMPAS;
            }
            if ("ANTLR-PD".equals(codeString)) {
                return ANTLR_PD;
            }
            if ("ANTLR-PD-fallback".equals(codeString)) {
                return ANTLR_PD_FALLBACK;
            }
            if ("Apache-1.0".equals(codeString)) {
                return APACHE_1_0;
            }
            if ("Apache-1.1".equals(codeString)) {
                return APACHE_1_1;
            }
            if ("Apache-2.0".equals(codeString)) {
                return APACHE_2_0;
            }
            if ("APAFML".equals(codeString)) {
                return APAFML;
            }
            if ("APL-1.0".equals(codeString)) {
                return APL_1_0;
            }
            if ("App-s2p".equals(codeString)) {
                return APP_S2P;
            }
            if ("APSL-1.0".equals(codeString)) {
                return APSL_1_0;
            }
            if ("APSL-1.1".equals(codeString)) {
                return APSL_1_1;
            }
            if ("APSL-1.2".equals(codeString)) {
                return APSL_1_2;
            }
            if ("APSL-2.0".equals(codeString)) {
                return APSL_2_0;
            }
            if ("Arphic-1999".equals(codeString)) {
                return ARPHIC_1999;
            }
            if ("Artistic-1.0".equals(codeString)) {
                return ARTISTIC_1_0;
            }
            if ("Artistic-1.0-cl8".equals(codeString)) {
                return ARTISTIC_1_0_CL8;
            }
            if ("Artistic-1.0-Perl".equals(codeString)) {
                return ARTISTIC_1_0_PERL;
            }
            if ("Artistic-2.0".equals(codeString)) {
                return ARTISTIC_2_0;
            }
            if ("ASWF-Digital-Assets-1.0".equals(codeString)) {
                return ASWF_DIGITAL_ASSETS_1_0;
            }
            if ("ASWF-Digital-Assets-1.1".equals(codeString)) {
                return ASWF_DIGITAL_ASSETS_1_1;
            }
            if ("Baekmuk".equals(codeString)) {
                return BAEKMUK;
            }
            if ("Bahyph".equals(codeString)) {
                return BAHYPH;
            }
            if ("Barr".equals(codeString)) {
                return BARR;
            }
            if ("Beerware".equals(codeString)) {
                return BEERWARE;
            }
            if ("Bitstream-Charter".equals(codeString)) {
                return BITSTREAM_CHARTER;
            }
            if ("Bitstream-Vera".equals(codeString)) {
                return BITSTREAM_VERA;
            }
            if ("BitTorrent-1.0".equals(codeString)) {
                return BITTORRENT_1_0;
            }
            if ("BitTorrent-1.1".equals(codeString)) {
                return BITTORRENT_1_1;
            }
            if ("blessing".equals(codeString)) {
                return BLESSING;
            }
            if ("BlueOak-1.0.0".equals(codeString)) {
                return BLUEOAK_1_0_0;
            }
            if ("Boehm-GC".equals(codeString)) {
                return BOEHM_GC;
            }
            if ("Borceux".equals(codeString)) {
                return BORCEUX;
            }
            if ("Brian-Gladman-3-Clause".equals(codeString)) {
                return BRIAN_GLADMAN_3_CLAUSE;
            }
            if ("BSD-1-Clause".equals(codeString)) {
                return BSD_1_CLAUSE;
            }
            if ("BSD-2-Clause".equals(codeString)) {
                return BSD_2_CLAUSE;
            }
            if ("BSD-2-Clause-FreeBSD".equals(codeString)) {
                return BSD_2_CLAUSE_FREEBSD;
            }
            if ("BSD-2-Clause-NetBSD".equals(codeString)) {
                return BSD_2_CLAUSE_NETBSD;
            }
            if ("BSD-2-Clause-Patent".equals(codeString)) {
                return BSD_2_CLAUSE_PATENT;
            }
            if ("BSD-2-Clause-Views".equals(codeString)) {
                return BSD_2_CLAUSE_VIEWS;
            }
            if ("BSD-3-Clause".equals(codeString)) {
                return BSD_3_CLAUSE;
            }
            if ("BSD-3-Clause-Attribution".equals(codeString)) {
                return BSD_3_CLAUSE_ATTRIBUTION;
            }
            if ("BSD-3-Clause-Clear".equals(codeString)) {
                return BSD_3_CLAUSE_CLEAR;
            }
            if ("BSD-3-Clause-LBNL".equals(codeString)) {
                return BSD_3_CLAUSE_LBNL;
            }
            if ("BSD-3-Clause-Modification".equals(codeString)) {
                return BSD_3_CLAUSE_MODIFICATION;
            }
            if ("BSD-3-Clause-No-Military-License".equals(codeString)) {
                return BSD_3_CLAUSE_NO_MILITARY_LICENSE;
            }
            if ("BSD-3-Clause-No-Nuclear-License".equals(codeString)) {
                return BSD_3_CLAUSE_NO_NUCLEAR_LICENSE;
            }
            if ("BSD-3-Clause-No-Nuclear-License-2014".equals(codeString)) {
                return BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014;
            }
            if ("BSD-3-Clause-No-Nuclear-Warranty".equals(codeString)) {
                return BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY;
            }
            if ("BSD-3-Clause-Open-MPI".equals(codeString)) {
                return BSD_3_CLAUSE_OPEN_MPI;
            }
            if ("BSD-4-Clause".equals(codeString)) {
                return BSD_4_CLAUSE;
            }
            if ("BSD-4-Clause-Shortened".equals(codeString)) {
                return BSD_4_CLAUSE_SHORTENED;
            }
            if ("BSD-4-Clause-UC".equals(codeString)) {
                return BSD_4_CLAUSE_UC;
            }
            if ("BSD-4.3RENO".equals(codeString)) {
                return BSD_4_3RENO;
            }
            if ("BSD-4.3TAHOE".equals(codeString)) {
                return BSD_4_3TAHOE;
            }
            if ("BSD-Advertising-Acknowledgement".equals(codeString)) {
                return BSD_ADVERTISING_ACKNOWLEDGEMENT;
            }
            if ("BSD-Attribution-HPND-disclaimer".equals(codeString)) {
                return BSD_ATTRIBUTION_HPND_DISCLAIMER;
            }
            if ("BSD-Protection".equals(codeString)) {
                return BSD_PROTECTION;
            }
            if ("BSD-Source-Code".equals(codeString)) {
                return BSD_SOURCE_CODE;
            }
            if ("BSL-1.0".equals(codeString)) {
                return BSL_1_0;
            }
            if ("BUSL-1.1".equals(codeString)) {
                return BUSL_1_1;
            }
            if ("bzip2-1.0.5".equals(codeString)) {
                return BZIP2_1_0_5;
            }
            if ("bzip2-1.0.6".equals(codeString)) {
                return BZIP2_1_0_6;
            }
            if ("C-UDA-1.0".equals(codeString)) {
                return C_UDA_1_0;
            }
            if ("CAL-1.0".equals(codeString)) {
                return CAL_1_0;
            }
            if ("CAL-1.0-Combined-Work-Exception".equals(codeString)) {
                return CAL_1_0_COMBINED_WORK_EXCEPTION;
            }
            if ("Caldera".equals(codeString)) {
                return CALDERA;
            }
            if ("CATOSL-1.1".equals(codeString)) {
                return CATOSL_1_1;
            }
            if ("CC-BY-1.0".equals(codeString)) {
                return CC_BY_1_0;
            }
            if ("CC-BY-2.0".equals(codeString)) {
                return CC_BY_2_0;
            }
            if ("CC-BY-2.5".equals(codeString)) {
                return CC_BY_2_5;
            }
            if ("CC-BY-2.5-AU".equals(codeString)) {
                return CC_BY_2_5_AU;
            }
            if ("CC-BY-3.0".equals(codeString)) {
                return CC_BY_3_0;
            }
            if ("CC-BY-3.0-AT".equals(codeString)) {
                return CC_BY_3_0_AT;
            }
            if ("CC-BY-3.0-DE".equals(codeString)) {
                return CC_BY_3_0_DE;
            }
            if ("CC-BY-3.0-IGO".equals(codeString)) {
                return CC_BY_3_0_IGO;
            }
            if ("CC-BY-3.0-NL".equals(codeString)) {
                return CC_BY_3_0_NL;
            }
            if ("CC-BY-3.0-US".equals(codeString)) {
                return CC_BY_3_0_US;
            }
            if ("CC-BY-4.0".equals(codeString)) {
                return CC_BY_4_0;
            }
            if ("CC-BY-NC-1.0".equals(codeString)) {
                return CC_BY_NC_1_0;
            }
            if ("CC-BY-NC-2.0".equals(codeString)) {
                return CC_BY_NC_2_0;
            }
            if ("CC-BY-NC-2.5".equals(codeString)) {
                return CC_BY_NC_2_5;
            }
            if ("CC-BY-NC-3.0".equals(codeString)) {
                return CC_BY_NC_3_0;
            }
            if ("CC-BY-NC-3.0-DE".equals(codeString)) {
                return CC_BY_NC_3_0_DE;
            }
            if ("CC-BY-NC-4.0".equals(codeString)) {
                return CC_BY_NC_4_0;
            }
            if ("CC-BY-NC-ND-1.0".equals(codeString)) {
                return CC_BY_NC_ND_1_0;
            }
            if ("CC-BY-NC-ND-2.0".equals(codeString)) {
                return CC_BY_NC_ND_2_0;
            }
            if ("CC-BY-NC-ND-2.5".equals(codeString)) {
                return CC_BY_NC_ND_2_5;
            }
            if ("CC-BY-NC-ND-3.0".equals(codeString)) {
                return CC_BY_NC_ND_3_0;
            }
            if ("CC-BY-NC-ND-3.0-DE".equals(codeString)) {
                return CC_BY_NC_ND_3_0_DE;
            }
            if ("CC-BY-NC-ND-3.0-IGO".equals(codeString)) {
                return CC_BY_NC_ND_3_0_IGO;
            }
            if ("CC-BY-NC-ND-4.0".equals(codeString)) {
                return CC_BY_NC_ND_4_0;
            }
            if ("CC-BY-NC-SA-1.0".equals(codeString)) {
                return CC_BY_NC_SA_1_0;
            }
            if ("CC-BY-NC-SA-2.0".equals(codeString)) {
                return CC_BY_NC_SA_2_0;
            }
            if ("CC-BY-NC-SA-2.0-DE".equals(codeString)) {
                return CC_BY_NC_SA_2_0_DE;
            }
            if ("CC-BY-NC-SA-2.0-FR".equals(codeString)) {
                return CC_BY_NC_SA_2_0_FR;
            }
            if ("CC-BY-NC-SA-2.0-UK".equals(codeString)) {
                return CC_BY_NC_SA_2_0_UK;
            }
            if ("CC-BY-NC-SA-2.5".equals(codeString)) {
                return CC_BY_NC_SA_2_5;
            }
            if ("CC-BY-NC-SA-3.0".equals(codeString)) {
                return CC_BY_NC_SA_3_0;
            }
            if ("CC-BY-NC-SA-3.0-DE".equals(codeString)) {
                return CC_BY_NC_SA_3_0_DE;
            }
            if ("CC-BY-NC-SA-3.0-IGO".equals(codeString)) {
                return CC_BY_NC_SA_3_0_IGO;
            }
            if ("CC-BY-NC-SA-4.0".equals(codeString)) {
                return CC_BY_NC_SA_4_0;
            }
            if ("CC-BY-ND-1.0".equals(codeString)) {
                return CC_BY_ND_1_0;
            }
            if ("CC-BY-ND-2.0".equals(codeString)) {
                return CC_BY_ND_2_0;
            }
            if ("CC-BY-ND-2.5".equals(codeString)) {
                return CC_BY_ND_2_5;
            }
            if ("CC-BY-ND-3.0".equals(codeString)) {
                return CC_BY_ND_3_0;
            }
            if ("CC-BY-ND-3.0-DE".equals(codeString)) {
                return CC_BY_ND_3_0_DE;
            }
            if ("CC-BY-ND-4.0".equals(codeString)) {
                return CC_BY_ND_4_0;
            }
            if ("CC-BY-SA-1.0".equals(codeString)) {
                return CC_BY_SA_1_0;
            }
            if ("CC-BY-SA-2.0".equals(codeString)) {
                return CC_BY_SA_2_0;
            }
            if ("CC-BY-SA-2.0-UK".equals(codeString)) {
                return CC_BY_SA_2_0_UK;
            }
            if ("CC-BY-SA-2.1-JP".equals(codeString)) {
                return CC_BY_SA_2_1_JP;
            }
            if ("CC-BY-SA-2.5".equals(codeString)) {
                return CC_BY_SA_2_5;
            }
            if ("CC-BY-SA-3.0".equals(codeString)) {
                return CC_BY_SA_3_0;
            }
            if ("CC-BY-SA-3.0-AT".equals(codeString)) {
                return CC_BY_SA_3_0_AT;
            }
            if ("CC-BY-SA-3.0-DE".equals(codeString)) {
                return CC_BY_SA_3_0_DE;
            }
            if ("CC-BY-SA-3.0-IGO".equals(codeString)) {
                return CC_BY_SA_3_0_IGO;
            }
            if ("CC-BY-SA-4.0".equals(codeString)) {
                return CC_BY_SA_4_0;
            }
            if ("CC-PDDC".equals(codeString)) {
                return CC_PDDC;
            }
            if ("CC0-1.0".equals(codeString)) {
                return CC0_1_0;
            }
            if ("CDDL-1.0".equals(codeString)) {
                return CDDL_1_0;
            }
            if ("CDDL-1.1".equals(codeString)) {
                return CDDL_1_1;
            }
            if ("CDL-1.0".equals(codeString)) {
                return CDL_1_0;
            }
            if ("CDLA-Permissive-1.0".equals(codeString)) {
                return CDLA_PERMISSIVE_1_0;
            }
            if ("CDLA-Permissive-2.0".equals(codeString)) {
                return CDLA_PERMISSIVE_2_0;
            }
            if ("CDLA-Sharing-1.0".equals(codeString)) {
                return CDLA_SHARING_1_0;
            }
            if ("CECILL-1.0".equals(codeString)) {
                return CECILL_1_0;
            }
            if ("CECILL-1.1".equals(codeString)) {
                return CECILL_1_1;
            }
            if ("CECILL-2.0".equals(codeString)) {
                return CECILL_2_0;
            }
            if ("CECILL-2.1".equals(codeString)) {
                return CECILL_2_1;
            }
            if ("CECILL-B".equals(codeString)) {
                return CECILL_B;
            }
            if ("CECILL-C".equals(codeString)) {
                return CECILL_C;
            }
            if ("CERN-OHL-1.1".equals(codeString)) {
                return CERN_OHL_1_1;
            }
            if ("CERN-OHL-1.2".equals(codeString)) {
                return CERN_OHL_1_2;
            }
            if ("CERN-OHL-P-2.0".equals(codeString)) {
                return CERN_OHL_P_2_0;
            }
            if ("CERN-OHL-S-2.0".equals(codeString)) {
                return CERN_OHL_S_2_0;
            }
            if ("CERN-OHL-W-2.0".equals(codeString)) {
                return CERN_OHL_W_2_0;
            }
            if ("CFITSIO".equals(codeString)) {
                return CFITSIO;
            }
            if ("checkmk".equals(codeString)) {
                return CHECKMK;
            }
            if ("ClArtistic".equals(codeString)) {
                return CLARTISTIC;
            }
            if ("Clips".equals(codeString)) {
                return CLIPS;
            }
            if ("CMU-Mach".equals(codeString)) {
                return CMU_MACH;
            }
            if ("CNRI-Jython".equals(codeString)) {
                return CNRI_JYTHON;
            }
            if ("CNRI-Python".equals(codeString)) {
                return CNRI_PYTHON;
            }
            if ("CNRI-Python-GPL-Compatible".equals(codeString)) {
                return CNRI_PYTHON_GPL_COMPATIBLE;
            }
            if ("COIL-1.0".equals(codeString)) {
                return COIL_1_0;
            }
            if ("Community-Spec-1.0".equals(codeString)) {
                return COMMUNITY_SPEC_1_0;
            }
            if ("Condor-1.1".equals(codeString)) {
                return CONDOR_1_1;
            }
            if ("copyleft-next-0.3.0".equals(codeString)) {
                return COPYLEFT_NEXT_0_3_0;
            }
            if ("copyleft-next-0.3.1".equals(codeString)) {
                return COPYLEFT_NEXT_0_3_1;
            }
            if ("Cornell-Lossless-JPEG".equals(codeString)) {
                return CORNELL_LOSSLESS_JPEG;
            }
            if ("CPAL-1.0".equals(codeString)) {
                return CPAL_1_0;
            }
            if ("CPL-1.0".equals(codeString)) {
                return CPL_1_0;
            }
            if ("CPOL-1.02".equals(codeString)) {
                return CPOL_1_02;
            }
            if ("Crossword".equals(codeString)) {
                return CROSSWORD;
            }
            if ("CrystalStacker".equals(codeString)) {
                return CRYSTALSTACKER;
            }
            if ("CUA-OPL-1.0".equals(codeString)) {
                return CUA_OPL_1_0;
            }
            if ("Cube".equals(codeString)) {
                return CUBE;
            }
            if ("curl".equals(codeString)) {
                return CURL;
            }
            if ("D-FSL-1.0".equals(codeString)) {
                return D_FSL_1_0;
            }
            if ("diffmark".equals(codeString)) {
                return DIFFMARK;
            }
            if ("DL-DE-BY-2.0".equals(codeString)) {
                return DL_DE_BY_2_0;
            }
            if ("DOC".equals(codeString)) {
                return DOC;
            }
            if ("Dotseqn".equals(codeString)) {
                return DOTSEQN;
            }
            if ("DRL-1.0".equals(codeString)) {
                return DRL_1_0;
            }
            if ("DSDP".equals(codeString)) {
                return DSDP;
            }
            if ("dtoa".equals(codeString)) {
                return DTOA;
            }
            if ("dvipdfm".equals(codeString)) {
                return DVIPDFM;
            }
            if ("ECL-1.0".equals(codeString)) {
                return ECL_1_0;
            }
            if ("ECL-2.0".equals(codeString)) {
                return ECL_2_0;
            }
            if ("eCos-2.0".equals(codeString)) {
                return ECOS_2_0;
            }
            if ("EFL-1.0".equals(codeString)) {
                return EFL_1_0;
            }
            if ("EFL-2.0".equals(codeString)) {
                return EFL_2_0;
            }
            if ("eGenix".equals(codeString)) {
                return EGENIX;
            }
            if ("Elastic-2.0".equals(codeString)) {
                return ELASTIC_2_0;
            }
            if ("Entessa".equals(codeString)) {
                return ENTESSA;
            }
            if ("EPICS".equals(codeString)) {
                return EPICS;
            }
            if ("EPL-1.0".equals(codeString)) {
                return EPL_1_0;
            }
            if ("EPL-2.0".equals(codeString)) {
                return EPL_2_0;
            }
            if ("ErlPL-1.1".equals(codeString)) {
                return ERLPL_1_1;
            }
            if ("etalab-2.0".equals(codeString)) {
                return ETALAB_2_0;
            }
            if ("EUDatagrid".equals(codeString)) {
                return EUDATAGRID;
            }
            if ("EUPL-1.0".equals(codeString)) {
                return EUPL_1_0;
            }
            if ("EUPL-1.1".equals(codeString)) {
                return EUPL_1_1;
            }
            if ("EUPL-1.2".equals(codeString)) {
                return EUPL_1_2;
            }
            if ("Eurosym".equals(codeString)) {
                return EUROSYM;
            }
            if ("Fair".equals(codeString)) {
                return FAIR;
            }
            if ("FDK-AAC".equals(codeString)) {
                return FDK_AAC;
            }
            if ("Frameworx-1.0".equals(codeString)) {
                return FRAMEWORX_1_0;
            }
            if ("FreeBSD-DOC".equals(codeString)) {
                return FREEBSD_DOC;
            }
            if ("FreeImage".equals(codeString)) {
                return FREEIMAGE;
            }
            if ("FSFAP".equals(codeString)) {
                return FSFAP;
            }
            if ("FSFUL".equals(codeString)) {
                return FSFUL;
            }
            if ("FSFULLR".equals(codeString)) {
                return FSFULLR;
            }
            if ("FSFULLRWD".equals(codeString)) {
                return FSFULLRWD;
            }
            if ("FTL".equals(codeString)) {
                return FTL;
            }
            if ("GD".equals(codeString)) {
                return GD;
            }
            if ("GFDL-1.1".equals(codeString)) {
                return GFDL_1_1;
            }
            if ("GFDL-1.1-invariants-only".equals(codeString)) {
                return GFDL_1_1_INVARIANTS_ONLY;
            }
            if ("GFDL-1.1-invariants-or-later".equals(codeString)) {
                return GFDL_1_1_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.1-no-invariants-only".equals(codeString)) {
                return GFDL_1_1_NO_INVARIANTS_ONLY;
            }
            if ("GFDL-1.1-no-invariants-or-later".equals(codeString)) {
                return GFDL_1_1_NO_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.1-only".equals(codeString)) {
                return GFDL_1_1_ONLY;
            }
            if ("GFDL-1.1-or-later".equals(codeString)) {
                return GFDL_1_1_OR_LATER;
            }
            if ("GFDL-1.2".equals(codeString)) {
                return GFDL_1_2;
            }
            if ("GFDL-1.2-invariants-only".equals(codeString)) {
                return GFDL_1_2_INVARIANTS_ONLY;
            }
            if ("GFDL-1.2-invariants-or-later".equals(codeString)) {
                return GFDL_1_2_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.2-no-invariants-only".equals(codeString)) {
                return GFDL_1_2_NO_INVARIANTS_ONLY;
            }
            if ("GFDL-1.2-no-invariants-or-later".equals(codeString)) {
                return GFDL_1_2_NO_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.2-only".equals(codeString)) {
                return GFDL_1_2_ONLY;
            }
            if ("GFDL-1.2-or-later".equals(codeString)) {
                return GFDL_1_2_OR_LATER;
            }
            if ("GFDL-1.3".equals(codeString)) {
                return GFDL_1_3;
            }
            if ("GFDL-1.3-invariants-only".equals(codeString)) {
                return GFDL_1_3_INVARIANTS_ONLY;
            }
            if ("GFDL-1.3-invariants-or-later".equals(codeString)) {
                return GFDL_1_3_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.3-no-invariants-only".equals(codeString)) {
                return GFDL_1_3_NO_INVARIANTS_ONLY;
            }
            if ("GFDL-1.3-no-invariants-or-later".equals(codeString)) {
                return GFDL_1_3_NO_INVARIANTS_OR_LATER;
            }
            if ("GFDL-1.3-only".equals(codeString)) {
                return GFDL_1_3_ONLY;
            }
            if ("GFDL-1.3-or-later".equals(codeString)) {
                return GFDL_1_3_OR_LATER;
            }
            if ("Giftware".equals(codeString)) {
                return GIFTWARE;
            }
            if ("GL2PS".equals(codeString)) {
                return GL2PS;
            }
            if ("Glide".equals(codeString)) {
                return GLIDE;
            }
            if ("Glulxe".equals(codeString)) {
                return GLULXE;
            }
            if ("GLWTPL".equals(codeString)) {
                return GLWTPL;
            }
            if ("gnuplot".equals(codeString)) {
                return GNUPLOT;
            }
            if ("GPL-1.0".equals(codeString)) {
                return GPL_1_0;
            }
            if ("GPL-1.0+".equals(codeString)) {
                return GPL_1_0PLUS;
            }
            if ("GPL-1.0-only".equals(codeString)) {
                return GPL_1_0_ONLY;
            }
            if ("GPL-1.0-or-later".equals(codeString)) {
                return GPL_1_0_OR_LATER;
            }
            if ("GPL-2.0".equals(codeString)) {
                return GPL_2_0;
            }
            if ("GPL-2.0+".equals(codeString)) {
                return GPL_2_0PLUS;
            }
            if ("GPL-2.0-only".equals(codeString)) {
                return GPL_2_0_ONLY;
            }
            if ("GPL-2.0-or-later".equals(codeString)) {
                return GPL_2_0_OR_LATER;
            }
            if ("GPL-2.0-with-autoconf-exception".equals(codeString)) {
                return GPL_2_0_WITH_AUTOCONF_EXCEPTION;
            }
            if ("GPL-2.0-with-bison-exception".equals(codeString)) {
                return GPL_2_0_WITH_BISON_EXCEPTION;
            }
            if ("GPL-2.0-with-classpath-exception".equals(codeString)) {
                return GPL_2_0_WITH_CLASSPATH_EXCEPTION;
            }
            if ("GPL-2.0-with-font-exception".equals(codeString)) {
                return GPL_2_0_WITH_FONT_EXCEPTION;
            }
            if ("GPL-2.0-with-GCC-exception".equals(codeString)) {
                return GPL_2_0_WITH_GCC_EXCEPTION;
            }
            if ("GPL-3.0".equals(codeString)) {
                return GPL_3_0;
            }
            if ("GPL-3.0+".equals(codeString)) {
                return GPL_3_0PLUS;
            }
            if ("GPL-3.0-only".equals(codeString)) {
                return GPL_3_0_ONLY;
            }
            if ("GPL-3.0-or-later".equals(codeString)) {
                return GPL_3_0_OR_LATER;
            }
            if ("GPL-3.0-with-autoconf-exception".equals(codeString)) {
                return GPL_3_0_WITH_AUTOCONF_EXCEPTION;
            }
            if ("GPL-3.0-with-GCC-exception".equals(codeString)) {
                return GPL_3_0_WITH_GCC_EXCEPTION;
            }
            if ("Graphics-Gems".equals(codeString)) {
                return GRAPHICS_GEMS;
            }
            if ("gSOAP-1.3b".equals(codeString)) {
                return GSOAP_1_3B;
            }
            if ("HaskellReport".equals(codeString)) {
                return HASKELLREPORT;
            }
            if ("Hippocratic-2.1".equals(codeString)) {
                return HIPPOCRATIC_2_1;
            }
            if ("HP-1986".equals(codeString)) {
                return HP_1986;
            }
            if ("HPND".equals(codeString)) {
                return HPND;
            }
            if ("HPND-export-US".equals(codeString)) {
                return HPND_EXPORT_US;
            }
            if ("HPND-Markus-Kuhn".equals(codeString)) {
                return HPND_MARKUS_KUHN;
            }
            if ("HPND-sell-variant".equals(codeString)) {
                return HPND_SELL_VARIANT;
            }
            if ("HPND-sell-variant-MIT-disclaimer".equals(codeString)) {
                return HPND_SELL_VARIANT_MIT_DISCLAIMER;
            }
            if ("HTMLTIDY".equals(codeString)) {
                return HTMLTIDY;
            }
            if ("IBM-pibs".equals(codeString)) {
                return IBM_PIBS;
            }
            if ("ICU".equals(codeString)) {
                return ICU;
            }
            if ("IEC-Code-Components-EULA".equals(codeString)) {
                return IEC_CODE_COMPONENTS_EULA;
            }
            if ("IJG".equals(codeString)) {
                return IJG;
            }
            if ("IJG-short".equals(codeString)) {
                return IJG_SHORT;
            }
            if ("ImageMagick".equals(codeString)) {
                return IMAGEMAGICK;
            }
            if ("iMatix".equals(codeString)) {
                return IMATIX;
            }
            if ("Imlib2".equals(codeString)) {
                return IMLIB2;
            }
            if ("Info-ZIP".equals(codeString)) {
                return INFO_ZIP;
            }
            if ("Inner-Net-2.0".equals(codeString)) {
                return INNER_NET_2_0;
            }
            if ("Intel".equals(codeString)) {
                return INTEL;
            }
            if ("Intel-ACPI".equals(codeString)) {
                return INTEL_ACPI;
            }
            if ("Interbase-1.0".equals(codeString)) {
                return INTERBASE_1_0;
            }
            if ("IPA".equals(codeString)) {
                return IPA;
            }
            if ("IPL-1.0".equals(codeString)) {
                return IPL_1_0;
            }
            if ("ISC".equals(codeString)) {
                return ISC;
            }
            if ("Jam".equals(codeString)) {
                return JAM;
            }
            if ("JasPer-2.0".equals(codeString)) {
                return JASPER_2_0;
            }
            if ("JPL-image".equals(codeString)) {
                return JPL_IMAGE;
            }
            if ("JPNIC".equals(codeString)) {
                return JPNIC;
            }
            if ("JSON".equals(codeString)) {
                return JSON;
            }
            if ("Kazlib".equals(codeString)) {
                return KAZLIB;
            }
            if ("Knuth-CTAN".equals(codeString)) {
                return KNUTH_CTAN;
            }
            if ("LAL-1.2".equals(codeString)) {
                return LAL_1_2;
            }
            if ("LAL-1.3".equals(codeString)) {
                return LAL_1_3;
            }
            if ("Latex2e".equals(codeString)) {
                return LATEX2E;
            }
            if ("Latex2e-translated-notice".equals(codeString)) {
                return LATEX2E_TRANSLATED_NOTICE;
            }
            if ("Leptonica".equals(codeString)) {
                return LEPTONICA;
            }
            if ("LGPL-2.0".equals(codeString)) {
                return LGPL_2_0;
            }
            if ("LGPL-2.0+".equals(codeString)) {
                return LGPL_2_0PLUS;
            }
            if ("LGPL-2.0-only".equals(codeString)) {
                return LGPL_2_0_ONLY;
            }
            if ("LGPL-2.0-or-later".equals(codeString)) {
                return LGPL_2_0_OR_LATER;
            }
            if ("LGPL-2.1".equals(codeString)) {
                return LGPL_2_1;
            }
            if ("LGPL-2.1+".equals(codeString)) {
                return LGPL_2_1PLUS;
            }
            if ("LGPL-2.1-only".equals(codeString)) {
                return LGPL_2_1_ONLY;
            }
            if ("LGPL-2.1-or-later".equals(codeString)) {
                return LGPL_2_1_OR_LATER;
            }
            if ("LGPL-3.0".equals(codeString)) {
                return LGPL_3_0;
            }
            if ("LGPL-3.0+".equals(codeString)) {
                return LGPL_3_0PLUS;
            }
            if ("LGPL-3.0-only".equals(codeString)) {
                return LGPL_3_0_ONLY;
            }
            if ("LGPL-3.0-or-later".equals(codeString)) {
                return LGPL_3_0_OR_LATER;
            }
            if ("LGPLLR".equals(codeString)) {
                return LGPLLR;
            }
            if ("Libpng".equals(codeString)) {
                return LIBPNG;
            }
            if ("libpng-2.0".equals(codeString)) {
                return LIBPNG_2_0;
            }
            if ("libselinux-1.0".equals(codeString)) {
                return LIBSELINUX_1_0;
            }
            if ("libtiff".equals(codeString)) {
                return LIBTIFF;
            }
            if ("libutil-David-Nugent".equals(codeString)) {
                return LIBUTIL_DAVID_NUGENT;
            }
            if ("LiLiQ-P-1.1".equals(codeString)) {
                return LILIQ_P_1_1;
            }
            if ("LiLiQ-R-1.1".equals(codeString)) {
                return LILIQ_R_1_1;
            }
            if ("LiLiQ-Rplus-1.1".equals(codeString)) {
                return LILIQ_RPLUS_1_1;
            }
            if ("Linux-man-pages-1-para".equals(codeString)) {
                return LINUX_MAN_PAGES_1_PARA;
            }
            if ("Linux-man-pages-copyleft".equals(codeString)) {
                return LINUX_MAN_PAGES_COPYLEFT;
            }
            if ("Linux-man-pages-copyleft-2-para".equals(codeString)) {
                return LINUX_MAN_PAGES_COPYLEFT_2_PARA;
            }
            if ("Linux-man-pages-copyleft-var".equals(codeString)) {
                return LINUX_MAN_PAGES_COPYLEFT_VAR;
            }
            if ("Linux-OpenIB".equals(codeString)) {
                return LINUX_OPENIB;
            }
            if ("LOOP".equals(codeString)) {
                return LOOP;
            }
            if ("LPL-1.0".equals(codeString)) {
                return LPL_1_0;
            }
            if ("LPL-1.02".equals(codeString)) {
                return LPL_1_02;
            }
            if ("LPPL-1.0".equals(codeString)) {
                return LPPL_1_0;
            }
            if ("LPPL-1.1".equals(codeString)) {
                return LPPL_1_1;
            }
            if ("LPPL-1.2".equals(codeString)) {
                return LPPL_1_2;
            }
            if ("LPPL-1.3a".equals(codeString)) {
                return LPPL_1_3A;
            }
            if ("LPPL-1.3c".equals(codeString)) {
                return LPPL_1_3C;
            }
            if ("LZMA-SDK-9.11-to-9.20".equals(codeString)) {
                return LZMA_SDK_9_11_TO_9_20;
            }
            if ("LZMA-SDK-9.22".equals(codeString)) {
                return LZMA_SDK_9_22;
            }
            if ("MakeIndex".equals(codeString)) {
                return MAKEINDEX;
            }
            if ("Martin-Birgmeier".equals(codeString)) {
                return MARTIN_BIRGMEIER;
            }
            if ("metamail".equals(codeString)) {
                return METAMAIL;
            }
            if ("Minpack".equals(codeString)) {
                return MINPACK;
            }
            if ("MirOS".equals(codeString)) {
                return MIROS;
            }
            if ("MIT".equals(codeString)) {
                return MIT;
            }
            if ("MIT-0".equals(codeString)) {
                return MIT_0;
            }
            if ("MIT-advertising".equals(codeString)) {
                return MIT_ADVERTISING;
            }
            if ("MIT-CMU".equals(codeString)) {
                return MIT_CMU;
            }
            if ("MIT-enna".equals(codeString)) {
                return MIT_ENNA;
            }
            if ("MIT-feh".equals(codeString)) {
                return MIT_FEH;
            }
            if ("MIT-Festival".equals(codeString)) {
                return MIT_FESTIVAL;
            }
            if ("MIT-Modern-Variant".equals(codeString)) {
                return MIT_MODERN_VARIANT;
            }
            if ("MIT-open-group".equals(codeString)) {
                return MIT_OPEN_GROUP;
            }
            if ("MIT-Wu".equals(codeString)) {
                return MIT_WU;
            }
            if ("MITNFA".equals(codeString)) {
                return MITNFA;
            }
            if ("Motosoto".equals(codeString)) {
                return MOTOSOTO;
            }
            if ("mpi-permissive".equals(codeString)) {
                return MPI_PERMISSIVE;
            }
            if ("mpich2".equals(codeString)) {
                return MPICH2;
            }
            if ("MPL-1.0".equals(codeString)) {
                return MPL_1_0;
            }
            if ("MPL-1.1".equals(codeString)) {
                return MPL_1_1;
            }
            if ("MPL-2.0".equals(codeString)) {
                return MPL_2_0;
            }
            if ("MPL-2.0-no-copyleft-exception".equals(codeString)) {
                return MPL_2_0_NO_COPYLEFT_EXCEPTION;
            }
            if ("mplus".equals(codeString)) {
                return MPLUS;
            }
            if ("MS-LPL".equals(codeString)) {
                return MS_LPL;
            }
            if ("MS-PL".equals(codeString)) {
                return MS_PL;
            }
            if ("MS-RL".equals(codeString)) {
                return MS_RL;
            }
            if ("MTLL".equals(codeString)) {
                return MTLL;
            }
            if ("MulanPSL-1.0".equals(codeString)) {
                return MULANPSL_1_0;
            }
            if ("MulanPSL-2.0".equals(codeString)) {
                return MULANPSL_2_0;
            }
            if ("Multics".equals(codeString)) {
                return MULTICS;
            }
            if ("Mup".equals(codeString)) {
                return MUP;
            }
            if ("NAIST-2003".equals(codeString)) {
                return NAIST_2003;
            }
            if ("NASA-1.3".equals(codeString)) {
                return NASA_1_3;
            }
            if ("Naumen".equals(codeString)) {
                return NAUMEN;
            }
            if ("NBPL-1.0".equals(codeString)) {
                return NBPL_1_0;
            }
            if ("NCGL-UK-2.0".equals(codeString)) {
                return NCGL_UK_2_0;
            }
            if ("NCSA".equals(codeString)) {
                return NCSA;
            }
            if ("Net-SNMP".equals(codeString)) {
                return NET_SNMP;
            }
            if ("NetCDF".equals(codeString)) {
                return NETCDF;
            }
            if ("Newsletr".equals(codeString)) {
                return NEWSLETR;
            }
            if ("NGPL".equals(codeString)) {
                return NGPL;
            }
            if ("NICTA-1.0".equals(codeString)) {
                return NICTA_1_0;
            }
            if ("NIST-PD".equals(codeString)) {
                return NIST_PD;
            }
            if ("NIST-PD-fallback".equals(codeString)) {
                return NIST_PD_FALLBACK;
            }
            if ("NIST-Software".equals(codeString)) {
                return NIST_SOFTWARE;
            }
            if ("NLOD-1.0".equals(codeString)) {
                return NLOD_1_0;
            }
            if ("NLOD-2.0".equals(codeString)) {
                return NLOD_2_0;
            }
            if ("NLPL".equals(codeString)) {
                return NLPL;
            }
            if ("Nokia".equals(codeString)) {
                return NOKIA;
            }
            if ("NOSL".equals(codeString)) {
                return NOSL;
            }
            if ("not-open-source".equals(codeString)) {
                return NOT_OPEN_SOURCE;
            }
            if ("Noweb".equals(codeString)) {
                return NOWEB;
            }
            if ("NPL-1.0".equals(codeString)) {
                return NPL_1_0;
            }
            if ("NPL-1.1".equals(codeString)) {
                return NPL_1_1;
            }
            if ("NPOSL-3.0".equals(codeString)) {
                return NPOSL_3_0;
            }
            if ("NRL".equals(codeString)) {
                return NRL;
            }
            if ("NTP".equals(codeString)) {
                return NTP;
            }
            if ("NTP-0".equals(codeString)) {
                return NTP_0;
            }
            if ("Nunit".equals(codeString)) {
                return NUNIT;
            }
            if ("O-UDA-1.0".equals(codeString)) {
                return O_UDA_1_0;
            }
            if ("OCCT-PL".equals(codeString)) {
                return OCCT_PL;
            }
            if ("OCLC-2.0".equals(codeString)) {
                return OCLC_2_0;
            }
            if ("ODbL-1.0".equals(codeString)) {
                return ODBL_1_0;
            }
            if ("ODC-By-1.0".equals(codeString)) {
                return ODC_BY_1_0;
            }
            if ("OFFIS".equals(codeString)) {
                return OFFIS;
            }
            if ("OFL-1.0".equals(codeString)) {
                return OFL_1_0;
            }
            if ("OFL-1.0-no-RFN".equals(codeString)) {
                return OFL_1_0_NO_RFN;
            }
            if ("OFL-1.0-RFN".equals(codeString)) {
                return OFL_1_0_RFN;
            }
            if ("OFL-1.1".equals(codeString)) {
                return OFL_1_1;
            }
            if ("OFL-1.1-no-RFN".equals(codeString)) {
                return OFL_1_1_NO_RFN;
            }
            if ("OFL-1.1-RFN".equals(codeString)) {
                return OFL_1_1_RFN;
            }
            if ("OGC-1.0".equals(codeString)) {
                return OGC_1_0;
            }
            if ("OGDL-Taiwan-1.0".equals(codeString)) {
                return OGDL_TAIWAN_1_0;
            }
            if ("OGL-Canada-2.0".equals(codeString)) {
                return OGL_CANADA_2_0;
            }
            if ("OGL-UK-1.0".equals(codeString)) {
                return OGL_UK_1_0;
            }
            if ("OGL-UK-2.0".equals(codeString)) {
                return OGL_UK_2_0;
            }
            if ("OGL-UK-3.0".equals(codeString)) {
                return OGL_UK_3_0;
            }
            if ("OGTSL".equals(codeString)) {
                return OGTSL;
            }
            if ("OLDAP-1.1".equals(codeString)) {
                return OLDAP_1_1;
            }
            if ("OLDAP-1.2".equals(codeString)) {
                return OLDAP_1_2;
            }
            if ("OLDAP-1.3".equals(codeString)) {
                return OLDAP_1_3;
            }
            if ("OLDAP-1.4".equals(codeString)) {
                return OLDAP_1_4;
            }
            if ("OLDAP-2.0".equals(codeString)) {
                return OLDAP_2_0;
            }
            if ("OLDAP-2.0.1".equals(codeString)) {
                return OLDAP_2_0_1;
            }
            if ("OLDAP-2.1".equals(codeString)) {
                return OLDAP_2_1;
            }
            if ("OLDAP-2.2".equals(codeString)) {
                return OLDAP_2_2;
            }
            if ("OLDAP-2.2.1".equals(codeString)) {
                return OLDAP_2_2_1;
            }
            if ("OLDAP-2.2.2".equals(codeString)) {
                return OLDAP_2_2_2;
            }
            if ("OLDAP-2.3".equals(codeString)) {
                return OLDAP_2_3;
            }
            if ("OLDAP-2.4".equals(codeString)) {
                return OLDAP_2_4;
            }
            if ("OLDAP-2.5".equals(codeString)) {
                return OLDAP_2_5;
            }
            if ("OLDAP-2.6".equals(codeString)) {
                return OLDAP_2_6;
            }
            if ("OLDAP-2.7".equals(codeString)) {
                return OLDAP_2_7;
            }
            if ("OLDAP-2.8".equals(codeString)) {
                return OLDAP_2_8;
            }
            if ("OLFL-1.3".equals(codeString)) {
                return OLFL_1_3;
            }
            if ("OML".equals(codeString)) {
                return OML;
            }
            if ("OpenPBS-2.3".equals(codeString)) {
                return OPENPBS_2_3;
            }
            if ("OpenSSL".equals(codeString)) {
                return OPENSSL;
            }
            if ("OPL-1.0".equals(codeString)) {
                return OPL_1_0;
            }
            if ("OPL-UK-3.0".equals(codeString)) {
                return OPL_UK_3_0;
            }
            if ("OPUBL-1.0".equals(codeString)) {
                return OPUBL_1_0;
            }
            if ("OSET-PL-2.1".equals(codeString)) {
                return OSET_PL_2_1;
            }
            if ("OSL-1.0".equals(codeString)) {
                return OSL_1_0;
            }
            if ("OSL-1.1".equals(codeString)) {
                return OSL_1_1;
            }
            if ("OSL-2.0".equals(codeString)) {
                return OSL_2_0;
            }
            if ("OSL-2.1".equals(codeString)) {
                return OSL_2_1;
            }
            if ("OSL-3.0".equals(codeString)) {
                return OSL_3_0;
            }
            if ("Parity-6.0.0".equals(codeString)) {
                return PARITY_6_0_0;
            }
            if ("Parity-7.0.0".equals(codeString)) {
                return PARITY_7_0_0;
            }
            if ("PDDL-1.0".equals(codeString)) {
                return PDDL_1_0;
            }
            if ("PHP-3.0".equals(codeString)) {
                return PHP_3_0;
            }
            if ("PHP-3.01".equals(codeString)) {
                return PHP_3_01;
            }
            if ("Plexus".equals(codeString)) {
                return PLEXUS;
            }
            if ("PolyForm-Noncommercial-1.0.0".equals(codeString)) {
                return POLYFORM_NONCOMMERCIAL_1_0_0;
            }
            if ("PolyForm-Small-Business-1.0.0".equals(codeString)) {
                return POLYFORM_SMALL_BUSINESS_1_0_0;
            }
            if ("PostgreSQL".equals(codeString)) {
                return POSTGRESQL;
            }
            if ("PSF-2.0".equals(codeString)) {
                return PSF_2_0;
            }
            if ("psfrag".equals(codeString)) {
                return PSFRAG;
            }
            if ("psutils".equals(codeString)) {
                return PSUTILS;
            }
            if ("Python-2.0".equals(codeString)) {
                return PYTHON_2_0;
            }
            if ("Python-2.0.1".equals(codeString)) {
                return PYTHON_2_0_1;
            }
            if ("Qhull".equals(codeString)) {
                return QHULL;
            }
            if ("QPL-1.0".equals(codeString)) {
                return QPL_1_0;
            }
            if ("QPL-1.0-INRIA-2004".equals(codeString)) {
                return QPL_1_0_INRIA_2004;
            }
            if ("Rdisc".equals(codeString)) {
                return RDISC;
            }
            if ("RHeCos-1.1".equals(codeString)) {
                return RHECOS_1_1;
            }
            if ("RPL-1.1".equals(codeString)) {
                return RPL_1_1;
            }
            if ("RPL-1.5".equals(codeString)) {
                return RPL_1_5;
            }
            if ("RPSL-1.0".equals(codeString)) {
                return RPSL_1_0;
            }
            if ("RSA-MD".equals(codeString)) {
                return RSA_MD;
            }
            if ("RSCPL".equals(codeString)) {
                return RSCPL;
            }
            if ("Ruby".equals(codeString)) {
                return RUBY;
            }
            if ("SAX-PD".equals(codeString)) {
                return SAX_PD;
            }
            if ("Saxpath".equals(codeString)) {
                return SAXPATH;
            }
            if ("SCEA".equals(codeString)) {
                return SCEA;
            }
            if ("SchemeReport".equals(codeString)) {
                return SCHEMEREPORT;
            }
            if ("Sendmail".equals(codeString)) {
                return SENDMAIL;
            }
            if ("Sendmail-8.23".equals(codeString)) {
                return SENDMAIL_8_23;
            }
            if ("SGI-B-1.0".equals(codeString)) {
                return SGI_B_1_0;
            }
            if ("SGI-B-1.1".equals(codeString)) {
                return SGI_B_1_1;
            }
            if ("SGI-B-2.0".equals(codeString)) {
                return SGI_B_2_0;
            }
            if ("SGP4".equals(codeString)) {
                return SGP4;
            }
            if ("SHL-0.5".equals(codeString)) {
                return SHL_0_5;
            }
            if ("SHL-0.51".equals(codeString)) {
                return SHL_0_51;
            }
            if ("SimPL-2.0".equals(codeString)) {
                return SIMPL_2_0;
            }
            if ("SISSL".equals(codeString)) {
                return SISSL;
            }
            if ("SISSL-1.2".equals(codeString)) {
                return SISSL_1_2;
            }
            if ("Sleepycat".equals(codeString)) {
                return SLEEPYCAT;
            }
            if ("SMLNJ".equals(codeString)) {
                return SMLNJ;
            }
            if ("SMPPL".equals(codeString)) {
                return SMPPL;
            }
            if ("SNIA".equals(codeString)) {
                return SNIA;
            }
            if ("snprintf".equals(codeString)) {
                return SNPRINTF;
            }
            if ("Spencer-86".equals(codeString)) {
                return SPENCER_86;
            }
            if ("Spencer-94".equals(codeString)) {
                return SPENCER_94;
            }
            if ("Spencer-99".equals(codeString)) {
                return SPENCER_99;
            }
            if ("SPL-1.0".equals(codeString)) {
                return SPL_1_0;
            }
            if ("SSH-OpenSSH".equals(codeString)) {
                return SSH_OPENSSH;
            }
            if ("SSH-short".equals(codeString)) {
                return SSH_SHORT;
            }
            if ("SSPL-1.0".equals(codeString)) {
                return SSPL_1_0;
            }
            if ("StandardML-NJ".equals(codeString)) {
                return STANDARDML_NJ;
            }
            if ("SugarCRM-1.1.3".equals(codeString)) {
                return SUGARCRM_1_1_3;
            }
            if ("SunPro".equals(codeString)) {
                return SUNPRO;
            }
            if ("SWL".equals(codeString)) {
                return SWL;
            }
            if ("Symlinks".equals(codeString)) {
                return SYMLINKS;
            }
            if ("TAPR-OHL-1.0".equals(codeString)) {
                return TAPR_OHL_1_0;
            }
            if ("TCL".equals(codeString)) {
                return TCL;
            }
            if ("TCP-wrappers".equals(codeString)) {
                return TCP_WRAPPERS;
            }
            if ("TermReadKey".equals(codeString)) {
                return TERMREADKEY;
            }
            if ("TMate".equals(codeString)) {
                return TMATE;
            }
            if ("TORQUE-1.1".equals(codeString)) {
                return TORQUE_1_1;
            }
            if ("TOSL".equals(codeString)) {
                return TOSL;
            }
            if ("TPDL".equals(codeString)) {
                return TPDL;
            }
            if ("TPL-1.0".equals(codeString)) {
                return TPL_1_0;
            }
            if ("TTWL".equals(codeString)) {
                return TTWL;
            }
            if ("TU-Berlin-1.0".equals(codeString)) {
                return TU_BERLIN_1_0;
            }
            if ("TU-Berlin-2.0".equals(codeString)) {
                return TU_BERLIN_2_0;
            }
            if ("UCAR".equals(codeString)) {
                return UCAR;
            }
            if ("UCL-1.0".equals(codeString)) {
                return UCL_1_0;
            }
            if ("Unicode-DFS-2015".equals(codeString)) {
                return UNICODE_DFS_2015;
            }
            if ("Unicode-DFS-2016".equals(codeString)) {
                return UNICODE_DFS_2016;
            }
            if ("Unicode-TOU".equals(codeString)) {
                return UNICODE_TOU;
            }
            if ("UnixCrypt".equals(codeString)) {
                return UNIXCRYPT;
            }
            if ("Unlicense".equals(codeString)) {
                return UNLICENSE;
            }
            if ("UPL-1.0".equals(codeString)) {
                return UPL_1_0;
            }
            if ("Vim".equals(codeString)) {
                return VIM;
            }
            if ("VOSTROM".equals(codeString)) {
                return VOSTROM;
            }
            if ("VSL-1.0".equals(codeString)) {
                return VSL_1_0;
            }
            if ("W3C".equals(codeString)) {
                return W3C;
            }
            if ("W3C-19980720".equals(codeString)) {
                return W3C_19980720;
            }
            if ("W3C-20150513".equals(codeString)) {
                return W3C_20150513;
            }
            if ("w3m".equals(codeString)) {
                return W3M;
            }
            if ("Watcom-1.0".equals(codeString)) {
                return WATCOM_1_0;
            }
            if ("Widget-Workshop".equals(codeString)) {
                return WIDGET_WORKSHOP;
            }
            if ("Wsuipa".equals(codeString)) {
                return WSUIPA;
            }
            if ("WTFPL".equals(codeString)) {
                return WTFPL;
            }
            if ("wxWindows".equals(codeString)) {
                return WXWINDOWS;
            }
            if ("X11".equals(codeString)) {
                return X11;
            }
            if ("X11-distribute-modifications-variant".equals(codeString)) {
                return X11_DISTRIBUTE_MODIFICATIONS_VARIANT;
            }
            if ("Xdebug-1.03".equals(codeString)) {
                return XDEBUG_1_03;
            }
            if ("Xerox".equals(codeString)) {
                return XEROX;
            }
            if ("Xfig".equals(codeString)) {
                return XFIG;
            }
            if ("XFree86-1.1".equals(codeString)) {
                return XFREE86_1_1;
            }
            if ("xinetd".equals(codeString)) {
                return XINETD;
            }
            if ("xlock".equals(codeString)) {
                return XLOCK;
            }
            if ("Xnet".equals(codeString)) {
                return XNET;
            }
            if ("xpp".equals(codeString)) {
                return XPP;
            }
            if ("XSkat".equals(codeString)) {
                return XSKAT;
            }
            if ("YPL-1.0".equals(codeString)) {
                return YPL_1_0;
            }
            if ("YPL-1.1".equals(codeString)) {
                return YPL_1_1;
            }
            if ("Zed".equals(codeString)) {
                return ZED;
            }
            if ("Zend-2.0".equals(codeString)) {
                return ZEND_2_0;
            }
            if ("Zimbra-1.3".equals(codeString)) {
                return ZIMBRA_1_3;
            }
            if ("Zimbra-1.4".equals(codeString)) {
                return ZIMBRA_1_4;
            }
            if ("Zlib".equals(codeString)) {
                return ZLIB;
            }
            if ("zlib-acknowledgement".equals(codeString)) {
                return ZLIB_ACKNOWLEDGEMENT;
            }
            if ("ZPL-1.1".equals(codeString)) {
                return ZPL_1_1;
            }
            if ("ZPL-2.0".equals(codeString)) {
                return ZPL_2_0;
            }
            if ("ZPL-2.1".equals(codeString)) {
                return ZPL_2_1;
            }
            throw new FHIRException("Unknown SPDXLicense code '" + codeString + "'");
        }

        public static boolean isValidCode(String codeString) {
            if (codeString == null || "".equals(codeString)) {
                return false;
            }
            return Utilities.existsInList((String)codeString, (String[])new String[]{"0BSD", "AAL", "Abstyles", "AdaCore-doc", "Adobe-2006", "Adobe-Glyph", "ADSL", "AFL-1.1", "AFL-1.2", "AFL-2.0", "AFL-2.1", "AFL-3.0", "Afmparse", "AGPL-1.0", "AGPL-1.0-only", "AGPL-1.0-or-later", "AGPL-3.0", "AGPL-3.0-only", "AGPL-3.0-or-later", "Aladdin", "AMDPLPA", "AML", "AMPAS", "ANTLR-PD", "ANTLR-PD-fallback", "Apache-1.0", "Apache-1.1", "Apache-2.0", "APAFML", "APL-1.0", "App-s2p", "APSL-1.0", "APSL-1.1", "APSL-1.2", "APSL-2.0", "Arphic-1999", "Artistic-1.0", "Artistic-1.0-cl8", "Artistic-1.0-Perl", "Artistic-2.0", "ASWF-Digital-Assets-1.0", "ASWF-Digital-Assets-1.1", "Baekmuk", "Bahyph", "Barr", "Beerware", "Bitstream-Charter", "Bitstream-Vera", "BitTorrent-1.0", "BitTorrent-1.1", "blessing", "BlueOak-1.0.0", "Boehm-GC", "Borceux", "Brian-Gladman-3-Clause", "BSD-1-Clause", "BSD-2-Clause", "BSD-2-Clause-FreeBSD", "BSD-2-Clause-NetBSD", "BSD-2-Clause-Patent", "BSD-2-Clause-Views", "BSD-3-Clause", "BSD-3-Clause-Attribution", "BSD-3-Clause-Clear", "BSD-3-Clause-LBNL", "BSD-3-Clause-Modification", "BSD-3-Clause-No-Military-License", "BSD-3-Clause-No-Nuclear-License", "BSD-3-Clause-No-Nuclear-License-2014", "BSD-3-Clause-No-Nuclear-Warranty", "BSD-3-Clause-Open-MPI", "BSD-4-Clause", "BSD-4-Clause-Shortened", "BSD-4-Clause-UC", "BSD-4.3RENO", "BSD-4.3TAHOE", "BSD-Advertising-Acknowledgement", "BSD-Attribution-HPND-disclaimer", "BSD-Protection", "BSD-Source-Code", "BSL-1.0", "BUSL-1.1", "bzip2-1.0.5", "bzip2-1.0.6", "C-UDA-1.0", "CAL-1.0", "CAL-1.0-Combined-Work-Exception", "Caldera", "CATOSL-1.1", "CC-BY-1.0", "CC-BY-2.0", "CC-BY-2.5", "CC-BY-2.5-AU", "CC-BY-3.0", "CC-BY-3.0-AT", "CC-BY-3.0-DE", "CC-BY-3.0-IGO", "CC-BY-3.0-NL", "CC-BY-3.0-US", "CC-BY-4.0", "CC-BY-NC-1.0", "CC-BY-NC-2.0", "CC-BY-NC-2.5", "CC-BY-NC-3.0", "CC-BY-NC-3.0-DE", "CC-BY-NC-4.0", "CC-BY-NC-ND-1.0", "CC-BY-NC-ND-2.0", "CC-BY-NC-ND-2.5", "CC-BY-NC-ND-3.0", "CC-BY-NC-ND-3.0-DE", "CC-BY-NC-ND-3.0-IGO", "CC-BY-NC-ND-4.0", "CC-BY-NC-SA-1.0", "CC-BY-NC-SA-2.0", "CC-BY-NC-SA-2.0-DE", "CC-BY-NC-SA-2.0-FR", "CC-BY-NC-SA-2.0-UK", "CC-BY-NC-SA-2.5", "CC-BY-NC-SA-3.0", "CC-BY-NC-SA-3.0-DE", "CC-BY-NC-SA-3.0-IGO", "CC-BY-NC-SA-4.0", "CC-BY-ND-1.0", "CC-BY-ND-2.0", "CC-BY-ND-2.5", "CC-BY-ND-3.0", "CC-BY-ND-3.0-DE", "CC-BY-ND-4.0", "CC-BY-SA-1.0", "CC-BY-SA-2.0", "CC-BY-SA-2.0-UK", "CC-BY-SA-2.1-JP", "CC-BY-SA-2.5", "CC-BY-SA-3.0", "CC-BY-SA-3.0-AT", "CC-BY-SA-3.0-DE", "CC-BY-SA-3.0-IGO", "CC-BY-SA-4.0", "CC-PDDC", "CC0-1.0", "CDDL-1.0", "CDDL-1.1", "CDL-1.0", "CDLA-Permissive-1.0", "CDLA-Permissive-2.0", "CDLA-Sharing-1.0", "CECILL-1.0", "CECILL-1.1", "CECILL-2.0", "CECILL-2.1", "CECILL-B", "CECILL-C", "CERN-OHL-1.1", "CERN-OHL-1.2", "CERN-OHL-P-2.0", "CERN-OHL-S-2.0", "CERN-OHL-W-2.0", "CFITSIO", "checkmk", "ClArtistic", "Clips", "CMU-Mach", "CNRI-Jython", "CNRI-Python", "CNRI-Python-GPL-Compatible", "COIL-1.0", "Community-Spec-1.0", "Condor-1.1", "copyleft-next-0.3.0", "copyleft-next-0.3.1", "Cornell-Lossless-JPEG", "CPAL-1.0", "CPL-1.0", "CPOL-1.02", "Crossword", "CrystalStacker", "CUA-OPL-1.0", "Cube", "curl", "D-FSL-1.0", "diffmark", "DL-DE-BY-2.0", "DOC", "Dotseqn", "DRL-1.0", "DSDP", "dtoa", "dvipdfm", "ECL-1.0", "ECL-2.0", "eCos-2.0", "EFL-1.0", "EFL-2.0", "eGenix", "Elastic-2.0", "Entessa", "EPICS", "EPL-1.0", "EPL-2.0", "ErlPL-1.1", "etalab-2.0", "EUDatagrid", "EUPL-1.0", "EUPL-1.1", "EUPL-1.2", "Eurosym", "Fair", "FDK-AAC", "Frameworx-1.0", "FreeBSD-DOC", "FreeImage", "FSFAP", "FSFUL", "FSFULLR", "FSFULLRWD", "FTL", "GD", "GFDL-1.1", "GFDL-1.1-invariants-only", "GFDL-1.1-invariants-or-later", "GFDL-1.1-no-invariants-only", "GFDL-1.1-no-invariants-or-later", "GFDL-1.1-only", "GFDL-1.1-or-later", "GFDL-1.2", "GFDL-1.2-invariants-only", "GFDL-1.2-invariants-or-later", "GFDL-1.2-no-invariants-only", "GFDL-1.2-no-invariants-or-later", "GFDL-1.2-only", "GFDL-1.2-or-later", "GFDL-1.3", "GFDL-1.3-invariants-only", "GFDL-1.3-invariants-or-later", "GFDL-1.3-no-invariants-only", "GFDL-1.3-no-invariants-or-later", "GFDL-1.3-only", "GFDL-1.3-or-later", "Giftware", "GL2PS", "Glide", "Glulxe", "GLWTPL", "gnuplot", "GPL-1.0", "GPL-1.0+", "GPL-1.0-only", "GPL-1.0-or-later", "GPL-2.0", "GPL-2.0+", "GPL-2.0-only", "GPL-2.0-or-later", "GPL-2.0-with-autoconf-exception", "GPL-2.0-with-bison-exception", "GPL-2.0-with-classpath-exception", "GPL-2.0-with-font-exception", "GPL-2.0-with-GCC-exception", "GPL-3.0", "GPL-3.0+", "GPL-3.0-only", "GPL-3.0-or-later", "GPL-3.0-with-autoconf-exception", "GPL-3.0-with-GCC-exception", "Graphics-Gems", "gSOAP-1.3b", "HaskellReport", "Hippocratic-2.1", "HP-1986", "HPND", "HPND-export-US", "HPND-Markus-Kuhn", "HPND-sell-variant", "HPND-sell-variant-MIT-disclaimer", "HTMLTIDY", "IBM-pibs", "ICU", "IEC-Code-Components-EULA", "IJG", "IJG-short", "ImageMagick", "iMatix", "Imlib2", "Info-ZIP", "Inner-Net-2.0", "Intel", "Intel-ACPI", "Interbase-1.0", "IPA", "IPL-1.0", "ISC", "Jam", "JasPer-2.0", "JPL-image", "JPNIC", "JSON", "Kazlib", "Knuth-CTAN", "LAL-1.2", "LAL-1.3", "Latex2e", "Latex2e-translated-notice", "Leptonica", "LGPL-2.0", "LGPL-2.0+", "LGPL-2.0-only", "LGPL-2.0-or-later", "LGPL-2.1", "LGPL-2.1+", "LGPL-2.1-only", "LGPL-2.1-or-later", "LGPL-3.0", "LGPL-3.0+", "LGPL-3.0-only", "LGPL-3.0-or-later", "LGPLLR", "Libpng", "libpng-2.0", "libselinux-1.0", "libtiff", "libutil-David-Nugent", "LiLiQ-P-1.1", "LiLiQ-R-1.1", "LiLiQ-Rplus-1.1", "Linux-man-pages-1-para", "Linux-man-pages-copyleft", "Linux-man-pages-copyleft-2-para", "Linux-man-pages-copyleft-var", "Linux-OpenIB", "LOOP", "LPL-1.0", "LPL-1.02", "LPPL-1.0", "LPPL-1.1", "LPPL-1.2", "LPPL-1.3a", "LPPL-1.3c", "LZMA-SDK-9.11-to-9.20", "LZMA-SDK-9.22", "MakeIndex", "Martin-Birgmeier", "metamail", "Minpack", "MirOS", "MIT", "MIT-0", "MIT-advertising", "MIT-CMU", "MIT-enna", "MIT-feh", "MIT-Festival", "MIT-Modern-Variant", "MIT-open-group", "MIT-Wu", "MITNFA", "Motosoto", "mpi-permissive", "mpich2", "MPL-1.0", "MPL-1.1", "MPL-2.0", "MPL-2.0-no-copyleft-exception", "mplus", "MS-LPL", "MS-PL", "MS-RL", "MTLL", "MulanPSL-1.0", "MulanPSL-2.0", "Multics", "Mup", "NAIST-2003", "NASA-1.3", "Naumen", "NBPL-1.0", "NCGL-UK-2.0", "NCSA", "Net-SNMP", "NetCDF", "Newsletr", "NGPL", "NICTA-1.0", "NIST-PD", "NIST-PD-fallback", "NIST-Software", "NLOD-1.0", "NLOD-2.0", "NLPL", "Nokia", "NOSL", "not-open-source", "Noweb", "NPL-1.0", "NPL-1.1", "NPOSL-3.0", "NRL", "NTP", "NTP-0", "Nunit", "O-UDA-1.0", "OCCT-PL", "OCLC-2.0", "ODbL-1.0", "ODC-By-1.0", "OFFIS", "OFL-1.0", "OFL-1.0-no-RFN", "OFL-1.0-RFN", "OFL-1.1", "OFL-1.1-no-RFN", "OFL-1.1-RFN", "OGC-1.0", "OGDL-Taiwan-1.0", "OGL-Canada-2.0", "OGL-UK-1.0", "OGL-UK-2.0", "OGL-UK-3.0", "OGTSL", "OLDAP-1.1", "OLDAP-1.2", "OLDAP-1.3", "OLDAP-1.4", "OLDAP-2.0", "OLDAP-2.0.1", "OLDAP-2.1", "OLDAP-2.2", "OLDAP-2.2.1", "OLDAP-2.2.2", "OLDAP-2.3", "OLDAP-2.4", "OLDAP-2.5", "OLDAP-2.6", "OLDAP-2.7", "OLDAP-2.8", "OLFL-1.3", "OML", "OpenPBS-2.3", "OpenSSL", "OPL-1.0", "OPL-UK-3.0", "OPUBL-1.0", "OSET-PL-2.1", "OSL-1.0", "OSL-1.1", "OSL-2.0", "OSL-2.1", "OSL-3.0", "Parity-6.0.0", "Parity-7.0.0", "PDDL-1.0", "PHP-3.0", "PHP-3.01", "Plexus", "PolyForm-Noncommercial-1.0.0", "PolyForm-Small-Business-1.0.0", "PostgreSQL", "PSF-2.0", "psfrag", "psutils", "Python-2.0", "Python-2.0.1", "Qhull", "QPL-1.0", "QPL-1.0-INRIA-2004", "Rdisc", "RHeCos-1.1", "RPL-1.1", "RPL-1.5", "RPSL-1.0", "RSA-MD", "RSCPL", "Ruby", "SAX-PD", "Saxpath", "SCEA", "SchemeReport", "Sendmail", "Sendmail-8.23", "SGI-B-1.0", "SGI-B-1.1", "SGI-B-2.0", "SGP4", "SHL-0.5", "SHL-0.51", "SimPL-2.0", "SISSL", "SISSL-1.2", "Sleepycat", "SMLNJ", "SMPPL", "SNIA", "snprintf", "Spencer-86", "Spencer-94", "Spencer-99", "SPL-1.0", "SSH-OpenSSH", "SSH-short", "SSPL-1.0", "StandardML-NJ", "SugarCRM-1.1.3", "SunPro", "SWL", "Symlinks", "TAPR-OHL-1.0", "TCL", "TCP-wrappers", "TermReadKey", "TMate", "TORQUE-1.1", "TOSL", "TPDL", "TPL-1.0", "TTWL", "TU-Berlin-1.0", "TU-Berlin-2.0", "UCAR", "UCL-1.0", "Unicode-DFS-2015", "Unicode-DFS-2016", "Unicode-TOU", "UnixCrypt", "Unlicense", "UPL-1.0", "Vim", "VOSTROM", "VSL-1.0", "W3C", "W3C-19980720", "W3C-20150513", "w3m", "Watcom-1.0", "Widget-Workshop", "Wsuipa", "WTFPL", "wxWindows", "X11", "X11-distribute-modifications-variant", "Xdebug-1.03", "Xerox", "Xfig", "XFree86-1.1", "xinetd", "xlock", "Xnet", "xpp", "XSkat", "YPL-1.0", "YPL-1.1", "Zed", "Zend-2.0", "Zimbra-1.3", "Zimbra-1.4", "Zlib", "zlib-acknowledgement", "ZPL-1.1", "ZPL-2.0", "ZPL-2.1"});
        }

        public String toCode() {
            switch (this) {
                case _0BSD: {
                    return "0BSD";
                }
                case AAL: {
                    return "AAL";
                }
                case ABSTYLES: {
                    return "Abstyles";
                }
                case ADACORE_DOC: {
                    return "AdaCore-doc";
                }
                case ADOBE_2006: {
                    return "Adobe-2006";
                }
                case ADOBE_GLYPH: {
                    return "Adobe-Glyph";
                }
                case ADSL: {
                    return "ADSL";
                }
                case AFL_1_1: {
                    return "AFL-1.1";
                }
                case AFL_1_2: {
                    return "AFL-1.2";
                }
                case AFL_2_0: {
                    return "AFL-2.0";
                }
                case AFL_2_1: {
                    return "AFL-2.1";
                }
                case AFL_3_0: {
                    return "AFL-3.0";
                }
                case AFMPARSE: {
                    return "Afmparse";
                }
                case AGPL_1_0: {
                    return "AGPL-1.0";
                }
                case AGPL_1_0_ONLY: {
                    return "AGPL-1.0-only";
                }
                case AGPL_1_0_OR_LATER: {
                    return "AGPL-1.0-or-later";
                }
                case AGPL_3_0: {
                    return "AGPL-3.0";
                }
                case AGPL_3_0_ONLY: {
                    return "AGPL-3.0-only";
                }
                case AGPL_3_0_OR_LATER: {
                    return "AGPL-3.0-or-later";
                }
                case ALADDIN: {
                    return "Aladdin";
                }
                case AMDPLPA: {
                    return "AMDPLPA";
                }
                case AML: {
                    return "AML";
                }
                case AMPAS: {
                    return "AMPAS";
                }
                case ANTLR_PD: {
                    return "ANTLR-PD";
                }
                case ANTLR_PD_FALLBACK: {
                    return "ANTLR-PD-fallback";
                }
                case APACHE_1_0: {
                    return "Apache-1.0";
                }
                case APACHE_1_1: {
                    return "Apache-1.1";
                }
                case APACHE_2_0: {
                    return "Apache-2.0";
                }
                case APAFML: {
                    return "APAFML";
                }
                case APL_1_0: {
                    return "APL-1.0";
                }
                case APP_S2P: {
                    return "App-s2p";
                }
                case APSL_1_0: {
                    return "APSL-1.0";
                }
                case APSL_1_1: {
                    return "APSL-1.1";
                }
                case APSL_1_2: {
                    return "APSL-1.2";
                }
                case APSL_2_0: {
                    return "APSL-2.0";
                }
                case ARPHIC_1999: {
                    return "Arphic-1999";
                }
                case ARTISTIC_1_0: {
                    return "Artistic-1.0";
                }
                case ARTISTIC_1_0_CL8: {
                    return "Artistic-1.0-cl8";
                }
                case ARTISTIC_1_0_PERL: {
                    return "Artistic-1.0-Perl";
                }
                case ARTISTIC_2_0: {
                    return "Artistic-2.0";
                }
                case ASWF_DIGITAL_ASSETS_1_0: {
                    return "ASWF-Digital-Assets-1.0";
                }
                case ASWF_DIGITAL_ASSETS_1_1: {
                    return "ASWF-Digital-Assets-1.1";
                }
                case BAEKMUK: {
                    return "Baekmuk";
                }
                case BAHYPH: {
                    return "Bahyph";
                }
                case BARR: {
                    return "Barr";
                }
                case BEERWARE: {
                    return "Beerware";
                }
                case BITSTREAM_CHARTER: {
                    return "Bitstream-Charter";
                }
                case BITSTREAM_VERA: {
                    return "Bitstream-Vera";
                }
                case BITTORRENT_1_0: {
                    return "BitTorrent-1.0";
                }
                case BITTORRENT_1_1: {
                    return "BitTorrent-1.1";
                }
                case BLESSING: {
                    return "blessing";
                }
                case BLUEOAK_1_0_0: {
                    return "BlueOak-1.0.0";
                }
                case BOEHM_GC: {
                    return "Boehm-GC";
                }
                case BORCEUX: {
                    return "Borceux";
                }
                case BRIAN_GLADMAN_3_CLAUSE: {
                    return "Brian-Gladman-3-Clause";
                }
                case BSD_1_CLAUSE: {
                    return "BSD-1-Clause";
                }
                case BSD_2_CLAUSE: {
                    return "BSD-2-Clause";
                }
                case BSD_2_CLAUSE_FREEBSD: {
                    return "BSD-2-Clause-FreeBSD";
                }
                case BSD_2_CLAUSE_NETBSD: {
                    return "BSD-2-Clause-NetBSD";
                }
                case BSD_2_CLAUSE_PATENT: {
                    return "BSD-2-Clause-Patent";
                }
                case BSD_2_CLAUSE_VIEWS: {
                    return "BSD-2-Clause-Views";
                }
                case BSD_3_CLAUSE: {
                    return "BSD-3-Clause";
                }
                case BSD_3_CLAUSE_ATTRIBUTION: {
                    return "BSD-3-Clause-Attribution";
                }
                case BSD_3_CLAUSE_CLEAR: {
                    return "BSD-3-Clause-Clear";
                }
                case BSD_3_CLAUSE_LBNL: {
                    return "BSD-3-Clause-LBNL";
                }
                case BSD_3_CLAUSE_MODIFICATION: {
                    return "BSD-3-Clause-Modification";
                }
                case BSD_3_CLAUSE_NO_MILITARY_LICENSE: {
                    return "BSD-3-Clause-No-Military-License";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE: {
                    return "BSD-3-Clause-No-Nuclear-License";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014: {
                    return "BSD-3-Clause-No-Nuclear-License-2014";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY: {
                    return "BSD-3-Clause-No-Nuclear-Warranty";
                }
                case BSD_3_CLAUSE_OPEN_MPI: {
                    return "BSD-3-Clause-Open-MPI";
                }
                case BSD_4_CLAUSE: {
                    return "BSD-4-Clause";
                }
                case BSD_4_CLAUSE_SHORTENED: {
                    return "BSD-4-Clause-Shortened";
                }
                case BSD_4_CLAUSE_UC: {
                    return "BSD-4-Clause-UC";
                }
                case BSD_4_3RENO: {
                    return "BSD-4.3RENO";
                }
                case BSD_4_3TAHOE: {
                    return "BSD-4.3TAHOE";
                }
                case BSD_ADVERTISING_ACKNOWLEDGEMENT: {
                    return "BSD-Advertising-Acknowledgement";
                }
                case BSD_ATTRIBUTION_HPND_DISCLAIMER: {
                    return "BSD-Attribution-HPND-disclaimer";
                }
                case BSD_PROTECTION: {
                    return "BSD-Protection";
                }
                case BSD_SOURCE_CODE: {
                    return "BSD-Source-Code";
                }
                case BSL_1_0: {
                    return "BSL-1.0";
                }
                case BUSL_1_1: {
                    return "BUSL-1.1";
                }
                case BZIP2_1_0_5: {
                    return "bzip2-1.0.5";
                }
                case BZIP2_1_0_6: {
                    return "bzip2-1.0.6";
                }
                case C_UDA_1_0: {
                    return "C-UDA-1.0";
                }
                case CAL_1_0: {
                    return "CAL-1.0";
                }
                case CAL_1_0_COMBINED_WORK_EXCEPTION: {
                    return "CAL-1.0-Combined-Work-Exception";
                }
                case CALDERA: {
                    return "Caldera";
                }
                case CATOSL_1_1: {
                    return "CATOSL-1.1";
                }
                case CC_BY_1_0: {
                    return "CC-BY-1.0";
                }
                case CC_BY_2_0: {
                    return "CC-BY-2.0";
                }
                case CC_BY_2_5: {
                    return "CC-BY-2.5";
                }
                case CC_BY_2_5_AU: {
                    return "CC-BY-2.5-AU";
                }
                case CC_BY_3_0: {
                    return "CC-BY-3.0";
                }
                case CC_BY_3_0_AT: {
                    return "CC-BY-3.0-AT";
                }
                case CC_BY_3_0_DE: {
                    return "CC-BY-3.0-DE";
                }
                case CC_BY_3_0_IGO: {
                    return "CC-BY-3.0-IGO";
                }
                case CC_BY_3_0_NL: {
                    return "CC-BY-3.0-NL";
                }
                case CC_BY_3_0_US: {
                    return "CC-BY-3.0-US";
                }
                case CC_BY_4_0: {
                    return "CC-BY-4.0";
                }
                case CC_BY_NC_1_0: {
                    return "CC-BY-NC-1.0";
                }
                case CC_BY_NC_2_0: {
                    return "CC-BY-NC-2.0";
                }
                case CC_BY_NC_2_5: {
                    return "CC-BY-NC-2.5";
                }
                case CC_BY_NC_3_0: {
                    return "CC-BY-NC-3.0";
                }
                case CC_BY_NC_3_0_DE: {
                    return "CC-BY-NC-3.0-DE";
                }
                case CC_BY_NC_4_0: {
                    return "CC-BY-NC-4.0";
                }
                case CC_BY_NC_ND_1_0: {
                    return "CC-BY-NC-ND-1.0";
                }
                case CC_BY_NC_ND_2_0: {
                    return "CC-BY-NC-ND-2.0";
                }
                case CC_BY_NC_ND_2_5: {
                    return "CC-BY-NC-ND-2.5";
                }
                case CC_BY_NC_ND_3_0: {
                    return "CC-BY-NC-ND-3.0";
                }
                case CC_BY_NC_ND_3_0_DE: {
                    return "CC-BY-NC-ND-3.0-DE";
                }
                case CC_BY_NC_ND_3_0_IGO: {
                    return "CC-BY-NC-ND-3.0-IGO";
                }
                case CC_BY_NC_ND_4_0: {
                    return "CC-BY-NC-ND-4.0";
                }
                case CC_BY_NC_SA_1_0: {
                    return "CC-BY-NC-SA-1.0";
                }
                case CC_BY_NC_SA_2_0: {
                    return "CC-BY-NC-SA-2.0";
                }
                case CC_BY_NC_SA_2_0_DE: {
                    return "CC-BY-NC-SA-2.0-DE";
                }
                case CC_BY_NC_SA_2_0_FR: {
                    return "CC-BY-NC-SA-2.0-FR";
                }
                case CC_BY_NC_SA_2_0_UK: {
                    return "CC-BY-NC-SA-2.0-UK";
                }
                case CC_BY_NC_SA_2_5: {
                    return "CC-BY-NC-SA-2.5";
                }
                case CC_BY_NC_SA_3_0: {
                    return "CC-BY-NC-SA-3.0";
                }
                case CC_BY_NC_SA_3_0_DE: {
                    return "CC-BY-NC-SA-3.0-DE";
                }
                case CC_BY_NC_SA_3_0_IGO: {
                    return "CC-BY-NC-SA-3.0-IGO";
                }
                case CC_BY_NC_SA_4_0: {
                    return "CC-BY-NC-SA-4.0";
                }
                case CC_BY_ND_1_0: {
                    return "CC-BY-ND-1.0";
                }
                case CC_BY_ND_2_0: {
                    return "CC-BY-ND-2.0";
                }
                case CC_BY_ND_2_5: {
                    return "CC-BY-ND-2.5";
                }
                case CC_BY_ND_3_0: {
                    return "CC-BY-ND-3.0";
                }
                case CC_BY_ND_3_0_DE: {
                    return "CC-BY-ND-3.0-DE";
                }
                case CC_BY_ND_4_0: {
                    return "CC-BY-ND-4.0";
                }
                case CC_BY_SA_1_0: {
                    return "CC-BY-SA-1.0";
                }
                case CC_BY_SA_2_0: {
                    return "CC-BY-SA-2.0";
                }
                case CC_BY_SA_2_0_UK: {
                    return "CC-BY-SA-2.0-UK";
                }
                case CC_BY_SA_2_1_JP: {
                    return "CC-BY-SA-2.1-JP";
                }
                case CC_BY_SA_2_5: {
                    return "CC-BY-SA-2.5";
                }
                case CC_BY_SA_3_0: {
                    return "CC-BY-SA-3.0";
                }
                case CC_BY_SA_3_0_AT: {
                    return "CC-BY-SA-3.0-AT";
                }
                case CC_BY_SA_3_0_DE: {
                    return "CC-BY-SA-3.0-DE";
                }
                case CC_BY_SA_3_0_IGO: {
                    return "CC-BY-SA-3.0-IGO";
                }
                case CC_BY_SA_4_0: {
                    return "CC-BY-SA-4.0";
                }
                case CC_PDDC: {
                    return "CC-PDDC";
                }
                case CC0_1_0: {
                    return "CC0-1.0";
                }
                case CDDL_1_0: {
                    return "CDDL-1.0";
                }
                case CDDL_1_1: {
                    return "CDDL-1.1";
                }
                case CDL_1_0: {
                    return "CDL-1.0";
                }
                case CDLA_PERMISSIVE_1_0: {
                    return "CDLA-Permissive-1.0";
                }
                case CDLA_PERMISSIVE_2_0: {
                    return "CDLA-Permissive-2.0";
                }
                case CDLA_SHARING_1_0: {
                    return "CDLA-Sharing-1.0";
                }
                case CECILL_1_0: {
                    return "CECILL-1.0";
                }
                case CECILL_1_1: {
                    return "CECILL-1.1";
                }
                case CECILL_2_0: {
                    return "CECILL-2.0";
                }
                case CECILL_2_1: {
                    return "CECILL-2.1";
                }
                case CECILL_B: {
                    return "CECILL-B";
                }
                case CECILL_C: {
                    return "CECILL-C";
                }
                case CERN_OHL_1_1: {
                    return "CERN-OHL-1.1";
                }
                case CERN_OHL_1_2: {
                    return "CERN-OHL-1.2";
                }
                case CERN_OHL_P_2_0: {
                    return "CERN-OHL-P-2.0";
                }
                case CERN_OHL_S_2_0: {
                    return "CERN-OHL-S-2.0";
                }
                case CERN_OHL_W_2_0: {
                    return "CERN-OHL-W-2.0";
                }
                case CFITSIO: {
                    return "CFITSIO";
                }
                case CHECKMK: {
                    return "checkmk";
                }
                case CLARTISTIC: {
                    return "ClArtistic";
                }
                case CLIPS: {
                    return "Clips";
                }
                case CMU_MACH: {
                    return "CMU-Mach";
                }
                case CNRI_JYTHON: {
                    return "CNRI-Jython";
                }
                case CNRI_PYTHON: {
                    return "CNRI-Python";
                }
                case CNRI_PYTHON_GPL_COMPATIBLE: {
                    return "CNRI-Python-GPL-Compatible";
                }
                case COIL_1_0: {
                    return "COIL-1.0";
                }
                case COMMUNITY_SPEC_1_0: {
                    return "Community-Spec-1.0";
                }
                case CONDOR_1_1: {
                    return "Condor-1.1";
                }
                case COPYLEFT_NEXT_0_3_0: {
                    return "copyleft-next-0.3.0";
                }
                case COPYLEFT_NEXT_0_3_1: {
                    return "copyleft-next-0.3.1";
                }
                case CORNELL_LOSSLESS_JPEG: {
                    return "Cornell-Lossless-JPEG";
                }
                case CPAL_1_0: {
                    return "CPAL-1.0";
                }
                case CPL_1_0: {
                    return "CPL-1.0";
                }
                case CPOL_1_02: {
                    return "CPOL-1.02";
                }
                case CROSSWORD: {
                    return "Crossword";
                }
                case CRYSTALSTACKER: {
                    return "CrystalStacker";
                }
                case CUA_OPL_1_0: {
                    return "CUA-OPL-1.0";
                }
                case CUBE: {
                    return "Cube";
                }
                case CURL: {
                    return "curl";
                }
                case D_FSL_1_0: {
                    return "D-FSL-1.0";
                }
                case DIFFMARK: {
                    return "diffmark";
                }
                case DL_DE_BY_2_0: {
                    return "DL-DE-BY-2.0";
                }
                case DOC: {
                    return "DOC";
                }
                case DOTSEQN: {
                    return "Dotseqn";
                }
                case DRL_1_0: {
                    return "DRL-1.0";
                }
                case DSDP: {
                    return "DSDP";
                }
                case DTOA: {
                    return "dtoa";
                }
                case DVIPDFM: {
                    return "dvipdfm";
                }
                case ECL_1_0: {
                    return "ECL-1.0";
                }
                case ECL_2_0: {
                    return "ECL-2.0";
                }
                case ECOS_2_0: {
                    return "eCos-2.0";
                }
                case EFL_1_0: {
                    return "EFL-1.0";
                }
                case EFL_2_0: {
                    return "EFL-2.0";
                }
                case EGENIX: {
                    return "eGenix";
                }
                case ELASTIC_2_0: {
                    return "Elastic-2.0";
                }
                case ENTESSA: {
                    return "Entessa";
                }
                case EPICS: {
                    return "EPICS";
                }
                case EPL_1_0: {
                    return "EPL-1.0";
                }
                case EPL_2_0: {
                    return "EPL-2.0";
                }
                case ERLPL_1_1: {
                    return "ErlPL-1.1";
                }
                case ETALAB_2_0: {
                    return "etalab-2.0";
                }
                case EUDATAGRID: {
                    return "EUDatagrid";
                }
                case EUPL_1_0: {
                    return "EUPL-1.0";
                }
                case EUPL_1_1: {
                    return "EUPL-1.1";
                }
                case EUPL_1_2: {
                    return "EUPL-1.2";
                }
                case EUROSYM: {
                    return "Eurosym";
                }
                case FAIR: {
                    return "Fair";
                }
                case FDK_AAC: {
                    return "FDK-AAC";
                }
                case FRAMEWORX_1_0: {
                    return "Frameworx-1.0";
                }
                case FREEBSD_DOC: {
                    return "FreeBSD-DOC";
                }
                case FREEIMAGE: {
                    return "FreeImage";
                }
                case FSFAP: {
                    return "FSFAP";
                }
                case FSFUL: {
                    return "FSFUL";
                }
                case FSFULLR: {
                    return "FSFULLR";
                }
                case FSFULLRWD: {
                    return "FSFULLRWD";
                }
                case FTL: {
                    return "FTL";
                }
                case GD: {
                    return "GD";
                }
                case GFDL_1_1: {
                    return "GFDL-1.1";
                }
                case GFDL_1_1_INVARIANTS_ONLY: {
                    return "GFDL-1.1-invariants-only";
                }
                case GFDL_1_1_INVARIANTS_OR_LATER: {
                    return "GFDL-1.1-invariants-or-later";
                }
                case GFDL_1_1_NO_INVARIANTS_ONLY: {
                    return "GFDL-1.1-no-invariants-only";
                }
                case GFDL_1_1_NO_INVARIANTS_OR_LATER: {
                    return "GFDL-1.1-no-invariants-or-later";
                }
                case GFDL_1_1_ONLY: {
                    return "GFDL-1.1-only";
                }
                case GFDL_1_1_OR_LATER: {
                    return "GFDL-1.1-or-later";
                }
                case GFDL_1_2: {
                    return "GFDL-1.2";
                }
                case GFDL_1_2_INVARIANTS_ONLY: {
                    return "GFDL-1.2-invariants-only";
                }
                case GFDL_1_2_INVARIANTS_OR_LATER: {
                    return "GFDL-1.2-invariants-or-later";
                }
                case GFDL_1_2_NO_INVARIANTS_ONLY: {
                    return "GFDL-1.2-no-invariants-only";
                }
                case GFDL_1_2_NO_INVARIANTS_OR_LATER: {
                    return "GFDL-1.2-no-invariants-or-later";
                }
                case GFDL_1_2_ONLY: {
                    return "GFDL-1.2-only";
                }
                case GFDL_1_2_OR_LATER: {
                    return "GFDL-1.2-or-later";
                }
                case GFDL_1_3: {
                    return "GFDL-1.3";
                }
                case GFDL_1_3_INVARIANTS_ONLY: {
                    return "GFDL-1.3-invariants-only";
                }
                case GFDL_1_3_INVARIANTS_OR_LATER: {
                    return "GFDL-1.3-invariants-or-later";
                }
                case GFDL_1_3_NO_INVARIANTS_ONLY: {
                    return "GFDL-1.3-no-invariants-only";
                }
                case GFDL_1_3_NO_INVARIANTS_OR_LATER: {
                    return "GFDL-1.3-no-invariants-or-later";
                }
                case GFDL_1_3_ONLY: {
                    return "GFDL-1.3-only";
                }
                case GFDL_1_3_OR_LATER: {
                    return "GFDL-1.3-or-later";
                }
                case GIFTWARE: {
                    return "Giftware";
                }
                case GL2PS: {
                    return "GL2PS";
                }
                case GLIDE: {
                    return "Glide";
                }
                case GLULXE: {
                    return "Glulxe";
                }
                case GLWTPL: {
                    return "GLWTPL";
                }
                case GNUPLOT: {
                    return "gnuplot";
                }
                case GPL_1_0: {
                    return "GPL-1.0";
                }
                case GPL_1_0PLUS: {
                    return "GPL-1.0+";
                }
                case GPL_1_0_ONLY: {
                    return "GPL-1.0-only";
                }
                case GPL_1_0_OR_LATER: {
                    return "GPL-1.0-or-later";
                }
                case GPL_2_0: {
                    return "GPL-2.0";
                }
                case GPL_2_0PLUS: {
                    return "GPL-2.0+";
                }
                case GPL_2_0_ONLY: {
                    return "GPL-2.0-only";
                }
                case GPL_2_0_OR_LATER: {
                    return "GPL-2.0-or-later";
                }
                case GPL_2_0_WITH_AUTOCONF_EXCEPTION: {
                    return "GPL-2.0-with-autoconf-exception";
                }
                case GPL_2_0_WITH_BISON_EXCEPTION: {
                    return "GPL-2.0-with-bison-exception";
                }
                case GPL_2_0_WITH_CLASSPATH_EXCEPTION: {
                    return "GPL-2.0-with-classpath-exception";
                }
                case GPL_2_0_WITH_FONT_EXCEPTION: {
                    return "GPL-2.0-with-font-exception";
                }
                case GPL_2_0_WITH_GCC_EXCEPTION: {
                    return "GPL-2.0-with-GCC-exception";
                }
                case GPL_3_0: {
                    return "GPL-3.0";
                }
                case GPL_3_0PLUS: {
                    return "GPL-3.0+";
                }
                case GPL_3_0_ONLY: {
                    return "GPL-3.0-only";
                }
                case GPL_3_0_OR_LATER: {
                    return "GPL-3.0-or-later";
                }
                case GPL_3_0_WITH_AUTOCONF_EXCEPTION: {
                    return "GPL-3.0-with-autoconf-exception";
                }
                case GPL_3_0_WITH_GCC_EXCEPTION: {
                    return "GPL-3.0-with-GCC-exception";
                }
                case GRAPHICS_GEMS: {
                    return "Graphics-Gems";
                }
                case GSOAP_1_3B: {
                    return "gSOAP-1.3b";
                }
                case HASKELLREPORT: {
                    return "HaskellReport";
                }
                case HIPPOCRATIC_2_1: {
                    return "Hippocratic-2.1";
                }
                case HP_1986: {
                    return "HP-1986";
                }
                case HPND: {
                    return "HPND";
                }
                case HPND_EXPORT_US: {
                    return "HPND-export-US";
                }
                case HPND_MARKUS_KUHN: {
                    return "HPND-Markus-Kuhn";
                }
                case HPND_SELL_VARIANT: {
                    return "HPND-sell-variant";
                }
                case HPND_SELL_VARIANT_MIT_DISCLAIMER: {
                    return "HPND-sell-variant-MIT-disclaimer";
                }
                case HTMLTIDY: {
                    return "HTMLTIDY";
                }
                case IBM_PIBS: {
                    return "IBM-pibs";
                }
                case ICU: {
                    return "ICU";
                }
                case IEC_CODE_COMPONENTS_EULA: {
                    return "IEC-Code-Components-EULA";
                }
                case IJG: {
                    return "IJG";
                }
                case IJG_SHORT: {
                    return "IJG-short";
                }
                case IMAGEMAGICK: {
                    return "ImageMagick";
                }
                case IMATIX: {
                    return "iMatix";
                }
                case IMLIB2: {
                    return "Imlib2";
                }
                case INFO_ZIP: {
                    return "Info-ZIP";
                }
                case INNER_NET_2_0: {
                    return "Inner-Net-2.0";
                }
                case INTEL: {
                    return "Intel";
                }
                case INTEL_ACPI: {
                    return "Intel-ACPI";
                }
                case INTERBASE_1_0: {
                    return "Interbase-1.0";
                }
                case IPA: {
                    return "IPA";
                }
                case IPL_1_0: {
                    return "IPL-1.0";
                }
                case ISC: {
                    return "ISC";
                }
                case JAM: {
                    return "Jam";
                }
                case JASPER_2_0: {
                    return "JasPer-2.0";
                }
                case JPL_IMAGE: {
                    return "JPL-image";
                }
                case JPNIC: {
                    return "JPNIC";
                }
                case JSON: {
                    return "JSON";
                }
                case KAZLIB: {
                    return "Kazlib";
                }
                case KNUTH_CTAN: {
                    return "Knuth-CTAN";
                }
                case LAL_1_2: {
                    return "LAL-1.2";
                }
                case LAL_1_3: {
                    return "LAL-1.3";
                }
                case LATEX2E: {
                    return "Latex2e";
                }
                case LATEX2E_TRANSLATED_NOTICE: {
                    return "Latex2e-translated-notice";
                }
                case LEPTONICA: {
                    return "Leptonica";
                }
                case LGPL_2_0: {
                    return "LGPL-2.0";
                }
                case LGPL_2_0PLUS: {
                    return "LGPL-2.0+";
                }
                case LGPL_2_0_ONLY: {
                    return "LGPL-2.0-only";
                }
                case LGPL_2_0_OR_LATER: {
                    return "LGPL-2.0-or-later";
                }
                case LGPL_2_1: {
                    return "LGPL-2.1";
                }
                case LGPL_2_1PLUS: {
                    return "LGPL-2.1+";
                }
                case LGPL_2_1_ONLY: {
                    return "LGPL-2.1-only";
                }
                case LGPL_2_1_OR_LATER: {
                    return "LGPL-2.1-or-later";
                }
                case LGPL_3_0: {
                    return "LGPL-3.0";
                }
                case LGPL_3_0PLUS: {
                    return "LGPL-3.0+";
                }
                case LGPL_3_0_ONLY: {
                    return "LGPL-3.0-only";
                }
                case LGPL_3_0_OR_LATER: {
                    return "LGPL-3.0-or-later";
                }
                case LGPLLR: {
                    return "LGPLLR";
                }
                case LIBPNG: {
                    return "Libpng";
                }
                case LIBPNG_2_0: {
                    return "libpng-2.0";
                }
                case LIBSELINUX_1_0: {
                    return "libselinux-1.0";
                }
                case LIBTIFF: {
                    return "libtiff";
                }
                case LIBUTIL_DAVID_NUGENT: {
                    return "libutil-David-Nugent";
                }
                case LILIQ_P_1_1: {
                    return "LiLiQ-P-1.1";
                }
                case LILIQ_R_1_1: {
                    return "LiLiQ-R-1.1";
                }
                case LILIQ_RPLUS_1_1: {
                    return "LiLiQ-Rplus-1.1";
                }
                case LINUX_MAN_PAGES_1_PARA: {
                    return "Linux-man-pages-1-para";
                }
                case LINUX_MAN_PAGES_COPYLEFT: {
                    return "Linux-man-pages-copyleft";
                }
                case LINUX_MAN_PAGES_COPYLEFT_2_PARA: {
                    return "Linux-man-pages-copyleft-2-para";
                }
                case LINUX_MAN_PAGES_COPYLEFT_VAR: {
                    return "Linux-man-pages-copyleft-var";
                }
                case LINUX_OPENIB: {
                    return "Linux-OpenIB";
                }
                case LOOP: {
                    return "LOOP";
                }
                case LPL_1_0: {
                    return "LPL-1.0";
                }
                case LPL_1_02: {
                    return "LPL-1.02";
                }
                case LPPL_1_0: {
                    return "LPPL-1.0";
                }
                case LPPL_1_1: {
                    return "LPPL-1.1";
                }
                case LPPL_1_2: {
                    return "LPPL-1.2";
                }
                case LPPL_1_3A: {
                    return "LPPL-1.3a";
                }
                case LPPL_1_3C: {
                    return "LPPL-1.3c";
                }
                case LZMA_SDK_9_11_TO_9_20: {
                    return "LZMA-SDK-9.11-to-9.20";
                }
                case LZMA_SDK_9_22: {
                    return "LZMA-SDK-9.22";
                }
                case MAKEINDEX: {
                    return "MakeIndex";
                }
                case MARTIN_BIRGMEIER: {
                    return "Martin-Birgmeier";
                }
                case METAMAIL: {
                    return "metamail";
                }
                case MINPACK: {
                    return "Minpack";
                }
                case MIROS: {
                    return "MirOS";
                }
                case MIT: {
                    return "MIT";
                }
                case MIT_0: {
                    return "MIT-0";
                }
                case MIT_ADVERTISING: {
                    return "MIT-advertising";
                }
                case MIT_CMU: {
                    return "MIT-CMU";
                }
                case MIT_ENNA: {
                    return "MIT-enna";
                }
                case MIT_FEH: {
                    return "MIT-feh";
                }
                case MIT_FESTIVAL: {
                    return "MIT-Festival";
                }
                case MIT_MODERN_VARIANT: {
                    return "MIT-Modern-Variant";
                }
                case MIT_OPEN_GROUP: {
                    return "MIT-open-group";
                }
                case MIT_WU: {
                    return "MIT-Wu";
                }
                case MITNFA: {
                    return "MITNFA";
                }
                case MOTOSOTO: {
                    return "Motosoto";
                }
                case MPI_PERMISSIVE: {
                    return "mpi-permissive";
                }
                case MPICH2: {
                    return "mpich2";
                }
                case MPL_1_0: {
                    return "MPL-1.0";
                }
                case MPL_1_1: {
                    return "MPL-1.1";
                }
                case MPL_2_0: {
                    return "MPL-2.0";
                }
                case MPL_2_0_NO_COPYLEFT_EXCEPTION: {
                    return "MPL-2.0-no-copyleft-exception";
                }
                case MPLUS: {
                    return "mplus";
                }
                case MS_LPL: {
                    return "MS-LPL";
                }
                case MS_PL: {
                    return "MS-PL";
                }
                case MS_RL: {
                    return "MS-RL";
                }
                case MTLL: {
                    return "MTLL";
                }
                case MULANPSL_1_0: {
                    return "MulanPSL-1.0";
                }
                case MULANPSL_2_0: {
                    return "MulanPSL-2.0";
                }
                case MULTICS: {
                    return "Multics";
                }
                case MUP: {
                    return "Mup";
                }
                case NAIST_2003: {
                    return "NAIST-2003";
                }
                case NASA_1_3: {
                    return "NASA-1.3";
                }
                case NAUMEN: {
                    return "Naumen";
                }
                case NBPL_1_0: {
                    return "NBPL-1.0";
                }
                case NCGL_UK_2_0: {
                    return "NCGL-UK-2.0";
                }
                case NCSA: {
                    return "NCSA";
                }
                case NET_SNMP: {
                    return "Net-SNMP";
                }
                case NETCDF: {
                    return "NetCDF";
                }
                case NEWSLETR: {
                    return "Newsletr";
                }
                case NGPL: {
                    return "NGPL";
                }
                case NICTA_1_0: {
                    return "NICTA-1.0";
                }
                case NIST_PD: {
                    return "NIST-PD";
                }
                case NIST_PD_FALLBACK: {
                    return "NIST-PD-fallback";
                }
                case NIST_SOFTWARE: {
                    return "NIST-Software";
                }
                case NLOD_1_0: {
                    return "NLOD-1.0";
                }
                case NLOD_2_0: {
                    return "NLOD-2.0";
                }
                case NLPL: {
                    return "NLPL";
                }
                case NOKIA: {
                    return "Nokia";
                }
                case NOSL: {
                    return "NOSL";
                }
                case NOT_OPEN_SOURCE: {
                    return "not-open-source";
                }
                case NOWEB: {
                    return "Noweb";
                }
                case NPL_1_0: {
                    return "NPL-1.0";
                }
                case NPL_1_1: {
                    return "NPL-1.1";
                }
                case NPOSL_3_0: {
                    return "NPOSL-3.0";
                }
                case NRL: {
                    return "NRL";
                }
                case NTP: {
                    return "NTP";
                }
                case NTP_0: {
                    return "NTP-0";
                }
                case NUNIT: {
                    return "Nunit";
                }
                case O_UDA_1_0: {
                    return "O-UDA-1.0";
                }
                case OCCT_PL: {
                    return "OCCT-PL";
                }
                case OCLC_2_0: {
                    return "OCLC-2.0";
                }
                case ODBL_1_0: {
                    return "ODbL-1.0";
                }
                case ODC_BY_1_0: {
                    return "ODC-By-1.0";
                }
                case OFFIS: {
                    return "OFFIS";
                }
                case OFL_1_0: {
                    return "OFL-1.0";
                }
                case OFL_1_0_NO_RFN: {
                    return "OFL-1.0-no-RFN";
                }
                case OFL_1_0_RFN: {
                    return "OFL-1.0-RFN";
                }
                case OFL_1_1: {
                    return "OFL-1.1";
                }
                case OFL_1_1_NO_RFN: {
                    return "OFL-1.1-no-RFN";
                }
                case OFL_1_1_RFN: {
                    return "OFL-1.1-RFN";
                }
                case OGC_1_0: {
                    return "OGC-1.0";
                }
                case OGDL_TAIWAN_1_0: {
                    return "OGDL-Taiwan-1.0";
                }
                case OGL_CANADA_2_0: {
                    return "OGL-Canada-2.0";
                }
                case OGL_UK_1_0: {
                    return "OGL-UK-1.0";
                }
                case OGL_UK_2_0: {
                    return "OGL-UK-2.0";
                }
                case OGL_UK_3_0: {
                    return "OGL-UK-3.0";
                }
                case OGTSL: {
                    return "OGTSL";
                }
                case OLDAP_1_1: {
                    return "OLDAP-1.1";
                }
                case OLDAP_1_2: {
                    return "OLDAP-1.2";
                }
                case OLDAP_1_3: {
                    return "OLDAP-1.3";
                }
                case OLDAP_1_4: {
                    return "OLDAP-1.4";
                }
                case OLDAP_2_0: {
                    return "OLDAP-2.0";
                }
                case OLDAP_2_0_1: {
                    return "OLDAP-2.0.1";
                }
                case OLDAP_2_1: {
                    return "OLDAP-2.1";
                }
                case OLDAP_2_2: {
                    return "OLDAP-2.2";
                }
                case OLDAP_2_2_1: {
                    return "OLDAP-2.2.1";
                }
                case OLDAP_2_2_2: {
                    return "OLDAP-2.2.2";
                }
                case OLDAP_2_3: {
                    return "OLDAP-2.3";
                }
                case OLDAP_2_4: {
                    return "OLDAP-2.4";
                }
                case OLDAP_2_5: {
                    return "OLDAP-2.5";
                }
                case OLDAP_2_6: {
                    return "OLDAP-2.6";
                }
                case OLDAP_2_7: {
                    return "OLDAP-2.7";
                }
                case OLDAP_2_8: {
                    return "OLDAP-2.8";
                }
                case OLFL_1_3: {
                    return "OLFL-1.3";
                }
                case OML: {
                    return "OML";
                }
                case OPENPBS_2_3: {
                    return "OpenPBS-2.3";
                }
                case OPENSSL: {
                    return "OpenSSL";
                }
                case OPL_1_0: {
                    return "OPL-1.0";
                }
                case OPL_UK_3_0: {
                    return "OPL-UK-3.0";
                }
                case OPUBL_1_0: {
                    return "OPUBL-1.0";
                }
                case OSET_PL_2_1: {
                    return "OSET-PL-2.1";
                }
                case OSL_1_0: {
                    return "OSL-1.0";
                }
                case OSL_1_1: {
                    return "OSL-1.1";
                }
                case OSL_2_0: {
                    return "OSL-2.0";
                }
                case OSL_2_1: {
                    return "OSL-2.1";
                }
                case OSL_3_0: {
                    return "OSL-3.0";
                }
                case PARITY_6_0_0: {
                    return "Parity-6.0.0";
                }
                case PARITY_7_0_0: {
                    return "Parity-7.0.0";
                }
                case PDDL_1_0: {
                    return "PDDL-1.0";
                }
                case PHP_3_0: {
                    return "PHP-3.0";
                }
                case PHP_3_01: {
                    return "PHP-3.01";
                }
                case PLEXUS: {
                    return "Plexus";
                }
                case POLYFORM_NONCOMMERCIAL_1_0_0: {
                    return "PolyForm-Noncommercial-1.0.0";
                }
                case POLYFORM_SMALL_BUSINESS_1_0_0: {
                    return "PolyForm-Small-Business-1.0.0";
                }
                case POSTGRESQL: {
                    return "PostgreSQL";
                }
                case PSF_2_0: {
                    return "PSF-2.0";
                }
                case PSFRAG: {
                    return "psfrag";
                }
                case PSUTILS: {
                    return "psutils";
                }
                case PYTHON_2_0: {
                    return "Python-2.0";
                }
                case PYTHON_2_0_1: {
                    return "Python-2.0.1";
                }
                case QHULL: {
                    return "Qhull";
                }
                case QPL_1_0: {
                    return "QPL-1.0";
                }
                case QPL_1_0_INRIA_2004: {
                    return "QPL-1.0-INRIA-2004";
                }
                case RDISC: {
                    return "Rdisc";
                }
                case RHECOS_1_1: {
                    return "RHeCos-1.1";
                }
                case RPL_1_1: {
                    return "RPL-1.1";
                }
                case RPL_1_5: {
                    return "RPL-1.5";
                }
                case RPSL_1_0: {
                    return "RPSL-1.0";
                }
                case RSA_MD: {
                    return "RSA-MD";
                }
                case RSCPL: {
                    return "RSCPL";
                }
                case RUBY: {
                    return "Ruby";
                }
                case SAX_PD: {
                    return "SAX-PD";
                }
                case SAXPATH: {
                    return "Saxpath";
                }
                case SCEA: {
                    return "SCEA";
                }
                case SCHEMEREPORT: {
                    return "SchemeReport";
                }
                case SENDMAIL: {
                    return "Sendmail";
                }
                case SENDMAIL_8_23: {
                    return "Sendmail-8.23";
                }
                case SGI_B_1_0: {
                    return "SGI-B-1.0";
                }
                case SGI_B_1_1: {
                    return "SGI-B-1.1";
                }
                case SGI_B_2_0: {
                    return "SGI-B-2.0";
                }
                case SGP4: {
                    return "SGP4";
                }
                case SHL_0_5: {
                    return "SHL-0.5";
                }
                case SHL_0_51: {
                    return "SHL-0.51";
                }
                case SIMPL_2_0: {
                    return "SimPL-2.0";
                }
                case SISSL: {
                    return "SISSL";
                }
                case SISSL_1_2: {
                    return "SISSL-1.2";
                }
                case SLEEPYCAT: {
                    return "Sleepycat";
                }
                case SMLNJ: {
                    return "SMLNJ";
                }
                case SMPPL: {
                    return "SMPPL";
                }
                case SNIA: {
                    return "SNIA";
                }
                case SNPRINTF: {
                    return "snprintf";
                }
                case SPENCER_86: {
                    return "Spencer-86";
                }
                case SPENCER_94: {
                    return "Spencer-94";
                }
                case SPENCER_99: {
                    return "Spencer-99";
                }
                case SPL_1_0: {
                    return "SPL-1.0";
                }
                case SSH_OPENSSH: {
                    return "SSH-OpenSSH";
                }
                case SSH_SHORT: {
                    return "SSH-short";
                }
                case SSPL_1_0: {
                    return "SSPL-1.0";
                }
                case STANDARDML_NJ: {
                    return "StandardML-NJ";
                }
                case SUGARCRM_1_1_3: {
                    return "SugarCRM-1.1.3";
                }
                case SUNPRO: {
                    return "SunPro";
                }
                case SWL: {
                    return "SWL";
                }
                case SYMLINKS: {
                    return "Symlinks";
                }
                case TAPR_OHL_1_0: {
                    return "TAPR-OHL-1.0";
                }
                case TCL: {
                    return "TCL";
                }
                case TCP_WRAPPERS: {
                    return "TCP-wrappers";
                }
                case TERMREADKEY: {
                    return "TermReadKey";
                }
                case TMATE: {
                    return "TMate";
                }
                case TORQUE_1_1: {
                    return "TORQUE-1.1";
                }
                case TOSL: {
                    return "TOSL";
                }
                case TPDL: {
                    return "TPDL";
                }
                case TPL_1_0: {
                    return "TPL-1.0";
                }
                case TTWL: {
                    return "TTWL";
                }
                case TU_BERLIN_1_0: {
                    return "TU-Berlin-1.0";
                }
                case TU_BERLIN_2_0: {
                    return "TU-Berlin-2.0";
                }
                case UCAR: {
                    return "UCAR";
                }
                case UCL_1_0: {
                    return "UCL-1.0";
                }
                case UNICODE_DFS_2015: {
                    return "Unicode-DFS-2015";
                }
                case UNICODE_DFS_2016: {
                    return "Unicode-DFS-2016";
                }
                case UNICODE_TOU: {
                    return "Unicode-TOU";
                }
                case UNIXCRYPT: {
                    return "UnixCrypt";
                }
                case UNLICENSE: {
                    return "Unlicense";
                }
                case UPL_1_0: {
                    return "UPL-1.0";
                }
                case VIM: {
                    return "Vim";
                }
                case VOSTROM: {
                    return "VOSTROM";
                }
                case VSL_1_0: {
                    return "VSL-1.0";
                }
                case W3C: {
                    return "W3C";
                }
                case W3C_19980720: {
                    return "W3C-19980720";
                }
                case W3C_20150513: {
                    return "W3C-20150513";
                }
                case W3M: {
                    return "w3m";
                }
                case WATCOM_1_0: {
                    return "Watcom-1.0";
                }
                case WIDGET_WORKSHOP: {
                    return "Widget-Workshop";
                }
                case WSUIPA: {
                    return "Wsuipa";
                }
                case WTFPL: {
                    return "WTFPL";
                }
                case WXWINDOWS: {
                    return "wxWindows";
                }
                case X11: {
                    return "X11";
                }
                case X11_DISTRIBUTE_MODIFICATIONS_VARIANT: {
                    return "X11-distribute-modifications-variant";
                }
                case XDEBUG_1_03: {
                    return "Xdebug-1.03";
                }
                case XEROX: {
                    return "Xerox";
                }
                case XFIG: {
                    return "Xfig";
                }
                case XFREE86_1_1: {
                    return "XFree86-1.1";
                }
                case XINETD: {
                    return "xinetd";
                }
                case XLOCK: {
                    return "xlock";
                }
                case XNET: {
                    return "Xnet";
                }
                case XPP: {
                    return "xpp";
                }
                case XSKAT: {
                    return "XSkat";
                }
                case YPL_1_0: {
                    return "YPL-1.0";
                }
                case YPL_1_1: {
                    return "YPL-1.1";
                }
                case ZED: {
                    return "Zed";
                }
                case ZEND_2_0: {
                    return "Zend-2.0";
                }
                case ZIMBRA_1_3: {
                    return "Zimbra-1.3";
                }
                case ZIMBRA_1_4: {
                    return "Zimbra-1.4";
                }
                case ZLIB: {
                    return "Zlib";
                }
                case ZLIB_ACKNOWLEDGEMENT: {
                    return "zlib-acknowledgement";
                }
                case ZPL_1_1: {
                    return "ZPL-1.1";
                }
                case ZPL_2_0: {
                    return "ZPL-2.0";
                }
                case ZPL_2_1: {
                    return "ZPL-2.1";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case _0BSD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AAL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ABSTYLES: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ADACORE_DOC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ADOBE_2006: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ADOBE_GLYPH: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ADSL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AFL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AFL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AFL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AFL_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AFL_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AFMPARSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AGPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AGPL_1_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AGPL_1_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AGPL_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AGPL_3_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AGPL_3_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ALADDIN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AMDPLPA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AML: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case AMPAS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ANTLR_PD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ANTLR_PD_FALLBACK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APACHE_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APACHE_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APACHE_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APAFML: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APP_S2P: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APSL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APSL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case APSL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ARPHIC_1999: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ARTISTIC_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ARTISTIC_1_0_CL8: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ARTISTIC_1_0_PERL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ARTISTIC_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ASWF_DIGITAL_ASSETS_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ASWF_DIGITAL_ASSETS_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BAEKMUK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BAHYPH: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BARR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BEERWARE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BITSTREAM_CHARTER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BITSTREAM_VERA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BITTORRENT_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BITTORRENT_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BLESSING: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BLUEOAK_1_0_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BOEHM_GC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BORCEUX: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BRIAN_GLADMAN_3_CLAUSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_1_CLAUSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_2_CLAUSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_2_CLAUSE_FREEBSD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_2_CLAUSE_NETBSD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_2_CLAUSE_PATENT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_2_CLAUSE_VIEWS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_ATTRIBUTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_CLEAR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_LBNL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_MODIFICATION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_NO_MILITARY_LICENSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_3_CLAUSE_OPEN_MPI: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_4_CLAUSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_4_CLAUSE_SHORTENED: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_4_CLAUSE_UC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_4_3RENO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_4_3TAHOE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_ADVERTISING_ACKNOWLEDGEMENT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_ATTRIBUTION_HPND_DISCLAIMER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_PROTECTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSD_SOURCE_CODE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BUSL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BZIP2_1_0_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case BZIP2_1_0_6: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case C_UDA_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CAL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CAL_1_0_COMBINED_WORK_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CALDERA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CATOSL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_2_5_AU: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_3_0_AT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_3_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_3_0_IGO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_3_0_NL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_3_0_US: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_4_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_3_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_4_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_3_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_3_0_IGO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_ND_4_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_2_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_2_0_FR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_2_0_UK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_3_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_3_0_IGO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_NC_SA_4_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_ND_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_ND_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_ND_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_ND_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_ND_3_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_ND_4_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_2_0_UK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_2_1_JP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_3_0_AT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_3_0_DE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_3_0_IGO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_BY_SA_4_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC_PDDC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CC0_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CDDL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CDDL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CDL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CDLA_PERMISSIVE_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CDLA_PERMISSIVE_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CDLA_SHARING_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CECILL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CECILL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CECILL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CECILL_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CECILL_B: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CECILL_C: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CERN_OHL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CERN_OHL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CERN_OHL_P_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CERN_OHL_S_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CERN_OHL_W_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CFITSIO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CHECKMK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CLARTISTIC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CLIPS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CMU_MACH: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CNRI_JYTHON: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CNRI_PYTHON: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CNRI_PYTHON_GPL_COMPATIBLE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case COIL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case COMMUNITY_SPEC_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CONDOR_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case COPYLEFT_NEXT_0_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case COPYLEFT_NEXT_0_3_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CORNELL_LOSSLESS_JPEG: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CPAL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CPOL_1_02: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CROSSWORD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CRYSTALSTACKER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CUA_OPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CUBE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case CURL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case D_FSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DIFFMARK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DL_DE_BY_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DOC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DOTSEQN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DRL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DSDP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DTOA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case DVIPDFM: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ECL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ECL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ECOS_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EFL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EFL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EGENIX: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ELASTIC_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ENTESSA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EPICS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EPL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ERLPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ETALAB_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EUDATAGRID: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EUPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EUPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EUPL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case EUROSYM: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FAIR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FDK_AAC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FRAMEWORX_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FREEBSD_DOC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FREEIMAGE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FSFAP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FSFUL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FSFULLR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FSFULLRWD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case FTL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1_INVARIANTS_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1_INVARIANTS_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1_NO_INVARIANTS_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1_NO_INVARIANTS_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_1_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2_INVARIANTS_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2_INVARIANTS_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2_NO_INVARIANTS_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2_NO_INVARIANTS_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_2_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3_INVARIANTS_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3_INVARIANTS_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3_NO_INVARIANTS_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3_NO_INVARIANTS_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GFDL_1_3_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GIFTWARE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GL2PS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GLIDE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GLULXE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GLWTPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GNUPLOT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_1_0PLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_1_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_1_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0PLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_WITH_AUTOCONF_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_WITH_BISON_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_WITH_CLASSPATH_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_WITH_FONT_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_2_0_WITH_GCC_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_3_0PLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_3_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_3_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_3_0_WITH_AUTOCONF_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GPL_3_0_WITH_GCC_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GRAPHICS_GEMS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case GSOAP_1_3B: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HASKELLREPORT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HIPPOCRATIC_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HP_1986: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HPND: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HPND_EXPORT_US: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HPND_MARKUS_KUHN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HPND_SELL_VARIANT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HPND_SELL_VARIANT_MIT_DISCLAIMER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case HTMLTIDY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IBM_PIBS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ICU: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IEC_CODE_COMPONENTS_EULA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IJG: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IJG_SHORT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IMAGEMAGICK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IMATIX: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IMLIB2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case INFO_ZIP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case INNER_NET_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case INTEL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case INTEL_ACPI: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case INTERBASE_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IPA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case IPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ISC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case JAM: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case JASPER_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case JPL_IMAGE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case JPNIC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case JSON: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case KAZLIB: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case KNUTH_CTAN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LAL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LAL_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LATEX2E: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LATEX2E_TRANSLATED_NOTICE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LEPTONICA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_0PLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_1PLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_1_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_2_1_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_3_0PLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_3_0_ONLY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPL_3_0_OR_LATER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LGPLLR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LIBPNG: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LIBPNG_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LIBSELINUX_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LIBTIFF: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LIBUTIL_DAVID_NUGENT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LILIQ_P_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LILIQ_R_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LILIQ_RPLUS_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LINUX_MAN_PAGES_1_PARA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LINUX_MAN_PAGES_COPYLEFT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LINUX_MAN_PAGES_COPYLEFT_2_PARA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LINUX_MAN_PAGES_COPYLEFT_VAR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LINUX_OPENIB: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LOOP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPL_1_02: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPPL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPPL_1_3A: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LPPL_1_3C: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LZMA_SDK_9_11_TO_9_20: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case LZMA_SDK_9_22: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MAKEINDEX: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MARTIN_BIRGMEIER: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case METAMAIL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MINPACK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIROS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_ADVERTISING: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_CMU: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_ENNA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_FEH: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_FESTIVAL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_MODERN_VARIANT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_OPEN_GROUP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MIT_WU: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MITNFA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MOTOSOTO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPI_PERMISSIVE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPICH2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPL_2_0_NO_COPYLEFT_EXCEPTION: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MPLUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MS_LPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MS_PL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MS_RL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MTLL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MULANPSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MULANPSL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MULTICS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case MUP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NAIST_2003: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NASA_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NAUMEN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NBPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NCGL_UK_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NCSA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NET_SNMP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NETCDF: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NEWSLETR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NGPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NICTA_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NIST_PD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NIST_PD_FALLBACK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NIST_SOFTWARE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NLOD_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NLOD_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NLPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NOKIA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NOSL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NOT_OPEN_SOURCE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NOWEB: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NPOSL_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NRL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NTP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NTP_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NUNIT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case O_UDA_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OCCT_PL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OCLC_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ODBL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ODC_BY_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFFIS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFL_1_0_NO_RFN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFL_1_0_RFN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFL_1_1_NO_RFN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OFL_1_1_RFN: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGC_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGDL_TAIWAN_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGL_CANADA_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGL_UK_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGL_UK_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGL_UK_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OGTSL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_1_4: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_0_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_2_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_4: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_6: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_7: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLDAP_2_8: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OLFL_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OML: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OPENPBS_2_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OPENSSL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OPL_UK_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OPUBL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OSET_PL_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OSL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OSL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OSL_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case OSL_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PARITY_6_0_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PARITY_7_0_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PDDL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PHP_3_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PHP_3_01: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PLEXUS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case POLYFORM_NONCOMMERCIAL_1_0_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case POLYFORM_SMALL_BUSINESS_1_0_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case POSTGRESQL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PSF_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PSFRAG: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PSUTILS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PYTHON_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case PYTHON_2_0_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case QHULL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case QPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case QPL_1_0_INRIA_2004: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RDISC: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RHECOS_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RPL_1_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RPSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RSA_MD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RSCPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case RUBY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SAX_PD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SAXPATH: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SCEA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SCHEMEREPORT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SENDMAIL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SENDMAIL_8_23: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SGI_B_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SGI_B_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SGI_B_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SGP4: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SHL_0_5: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SHL_0_51: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SIMPL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SISSL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SISSL_1_2: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SLEEPYCAT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SMLNJ: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SMPPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SNIA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SNPRINTF: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SPENCER_86: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SPENCER_94: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SPENCER_99: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SSH_OPENSSH: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SSH_SHORT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SSPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case STANDARDML_NJ: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SUGARCRM_1_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SUNPRO: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SWL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case SYMLINKS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TAPR_OHL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TCL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TCP_WRAPPERS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TERMREADKEY: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TMATE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TORQUE_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TOSL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TPDL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TTWL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TU_BERLIN_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case TU_BERLIN_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UCAR: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UCL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UNICODE_DFS_2015: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UNICODE_DFS_2016: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UNICODE_TOU: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UNIXCRYPT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UNLICENSE: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case UPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case VIM: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case VOSTROM: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case VSL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case W3C: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case W3C_19980720: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case W3C_20150513: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case W3M: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case WATCOM_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case WIDGET_WORKSHOP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case WSUIPA: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case WTFPL: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case WXWINDOWS: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case X11: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case X11_DISTRIBUTE_MODIFICATIONS_VARIANT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XDEBUG_1_03: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XEROX: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XFIG: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XFREE86_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XINETD: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XLOCK: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XNET: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XPP: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case XSKAT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case YPL_1_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case YPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZED: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZEND_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZIMBRA_1_3: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZIMBRA_1_4: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZLIB: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZLIB_ACKNOWLEDGEMENT: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZPL_1_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZPL_2_0: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case ZPL_2_1: {
                    return "http://hl7.org/fhir/spdx-license";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case _0BSD: {
                    return "BSD Zero Clause License";
                }
                case AAL: {
                    return "Attribution Assurance License";
                }
                case ABSTYLES: {
                    return "Abstyles License";
                }
                case ADACORE_DOC: {
                    return "AdaCore Doc License";
                }
                case ADOBE_2006: {
                    return "Adobe Systems Incorporated Source Code License Agreement";
                }
                case ADOBE_GLYPH: {
                    return "Adobe Glyph List License";
                }
                case ADSL: {
                    return "Amazon Digital Services License";
                }
                case AFL_1_1: {
                    return "Academic Free License v1.1";
                }
                case AFL_1_2: {
                    return "Academic Free License v1.2";
                }
                case AFL_2_0: {
                    return "Academic Free License v2.0";
                }
                case AFL_2_1: {
                    return "Academic Free License v2.1";
                }
                case AFL_3_0: {
                    return "Academic Free License v3.0";
                }
                case AFMPARSE: {
                    return "Afmparse License";
                }
                case AGPL_1_0: {
                    return "Affero General Public License v1.0";
                }
                case AGPL_1_0_ONLY: {
                    return "Affero General Public License v1.0 only";
                }
                case AGPL_1_0_OR_LATER: {
                    return "Affero General Public License v1.0 or later";
                }
                case AGPL_3_0: {
                    return "GNU Affero General Public License v3.0";
                }
                case AGPL_3_0_ONLY: {
                    return "GNU Affero General Public License v3.0 only";
                }
                case AGPL_3_0_OR_LATER: {
                    return "GNU Affero General Public License v3.0 or later";
                }
                case ALADDIN: {
                    return "Aladdin Free Public License";
                }
                case AMDPLPA: {
                    return "AMD's plpa_map.c License";
                }
                case AML: {
                    return "Apple MIT License";
                }
                case AMPAS: {
                    return "Academy of Motion Picture Arts and Sciences BSD";
                }
                case ANTLR_PD: {
                    return "ANTLR Software Rights Notice";
                }
                case ANTLR_PD_FALLBACK: {
                    return "ANTLR Software Rights Notice with license fallback";
                }
                case APACHE_1_0: {
                    return "Apache License 1.0";
                }
                case APACHE_1_1: {
                    return "Apache License 1.1";
                }
                case APACHE_2_0: {
                    return "Apache License 2.0";
                }
                case APAFML: {
                    return "Adobe Postscript AFM License";
                }
                case APL_1_0: {
                    return "Adaptive Public License 1.0";
                }
                case APP_S2P: {
                    return "App::s2p License";
                }
                case APSL_1_0: {
                    return "Apple Public Source License 1.0";
                }
                case APSL_1_1: {
                    return "Apple Public Source License 1.1";
                }
                case APSL_1_2: {
                    return "Apple Public Source License 1.2";
                }
                case APSL_2_0: {
                    return "Apple Public Source License 2.0";
                }
                case ARPHIC_1999: {
                    return "Arphic Public License";
                }
                case ARTISTIC_1_0: {
                    return "Artistic License 1.0";
                }
                case ARTISTIC_1_0_CL8: {
                    return "Artistic License 1.0 w/clause 8";
                }
                case ARTISTIC_1_0_PERL: {
                    return "Artistic License 1.0 (Perl)";
                }
                case ARTISTIC_2_0: {
                    return "Artistic License 2.0";
                }
                case ASWF_DIGITAL_ASSETS_1_0: {
                    return "ASWF Digital Assets License version 1.0";
                }
                case ASWF_DIGITAL_ASSETS_1_1: {
                    return "ASWF Digital Assets License 1.1";
                }
                case BAEKMUK: {
                    return "Baekmuk License";
                }
                case BAHYPH: {
                    return "Bahyph License";
                }
                case BARR: {
                    return "Barr License";
                }
                case BEERWARE: {
                    return "Beerware License";
                }
                case BITSTREAM_CHARTER: {
                    return "Bitstream Charter Font License";
                }
                case BITSTREAM_VERA: {
                    return "Bitstream Vera Font License";
                }
                case BITTORRENT_1_0: {
                    return "BitTorrent Open Source License v1.0";
                }
                case BITTORRENT_1_1: {
                    return "BitTorrent Open Source License v1.1";
                }
                case BLESSING: {
                    return "SQLite Blessing";
                }
                case BLUEOAK_1_0_0: {
                    return "Blue Oak Model License 1.0.0";
                }
                case BOEHM_GC: {
                    return "Boehm-Demers-Weiser GC License";
                }
                case BORCEUX: {
                    return "Borceux license";
                }
                case BRIAN_GLADMAN_3_CLAUSE: {
                    return "Brian Gladman 3-Clause License";
                }
                case BSD_1_CLAUSE: {
                    return "BSD 1-Clause License";
                }
                case BSD_2_CLAUSE: {
                    return "BSD 2-Clause \"Simplified\" License";
                }
                case BSD_2_CLAUSE_FREEBSD: {
                    return "BSD 2-Clause FreeBSD License";
                }
                case BSD_2_CLAUSE_NETBSD: {
                    return "BSD 2-Clause NetBSD License";
                }
                case BSD_2_CLAUSE_PATENT: {
                    return "BSD-2-Clause Plus Patent License";
                }
                case BSD_2_CLAUSE_VIEWS: {
                    return "BSD 2-Clause with views sentence";
                }
                case BSD_3_CLAUSE: {
                    return "BSD 3-Clause \"New\" or \"Revised\" License";
                }
                case BSD_3_CLAUSE_ATTRIBUTION: {
                    return "BSD with attribution";
                }
                case BSD_3_CLAUSE_CLEAR: {
                    return "BSD 3-Clause Clear License";
                }
                case BSD_3_CLAUSE_LBNL: {
                    return "Lawrence Berkeley National Labs BSD variant license";
                }
                case BSD_3_CLAUSE_MODIFICATION: {
                    return "BSD 3-Clause Modification";
                }
                case BSD_3_CLAUSE_NO_MILITARY_LICENSE: {
                    return "BSD 3-Clause No Military License";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE: {
                    return "BSD 3-Clause No Nuclear License";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014: {
                    return "BSD 3-Clause No Nuclear License 2014";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY: {
                    return "BSD 3-Clause No Nuclear Warranty";
                }
                case BSD_3_CLAUSE_OPEN_MPI: {
                    return "BSD 3-Clause Open MPI variant";
                }
                case BSD_4_CLAUSE: {
                    return "BSD 4-Clause \"Original\" or \"Old\" License";
                }
                case BSD_4_CLAUSE_SHORTENED: {
                    return "BSD 4 Clause Shortened";
                }
                case BSD_4_CLAUSE_UC: {
                    return "BSD-4-Clause (University of California-Specific)";
                }
                case BSD_4_3RENO: {
                    return "BSD 4.3 RENO License";
                }
                case BSD_4_3TAHOE: {
                    return "BSD 4.3 TAHOE License";
                }
                case BSD_ADVERTISING_ACKNOWLEDGEMENT: {
                    return "BSD Advertising Acknowledgement License";
                }
                case BSD_ATTRIBUTION_HPND_DISCLAIMER: {
                    return "BSD with Attribution and HPND disclaimer";
                }
                case BSD_PROTECTION: {
                    return "BSD Protection License";
                }
                case BSD_SOURCE_CODE: {
                    return "BSD Source Code Attribution";
                }
                case BSL_1_0: {
                    return "Boost Software License 1.0";
                }
                case BUSL_1_1: {
                    return "Business Source License 1.1";
                }
                case BZIP2_1_0_5: {
                    return "bzip2 and libbzip2 License v1.0.5";
                }
                case BZIP2_1_0_6: {
                    return "bzip2 and libbzip2 License v1.0.6";
                }
                case C_UDA_1_0: {
                    return "Computational Use of Data Agreement v1.0";
                }
                case CAL_1_0: {
                    return "Cryptographic Autonomy License 1.0";
                }
                case CAL_1_0_COMBINED_WORK_EXCEPTION: {
                    return "Cryptographic Autonomy License 1.0 (Combined Work Exception)";
                }
                case CALDERA: {
                    return "Caldera License";
                }
                case CATOSL_1_1: {
                    return "Computer Associates Trusted Open Source License 1.1";
                }
                case CC_BY_1_0: {
                    return "Creative Commons Attribution 1.0 Generic";
                }
                case CC_BY_2_0: {
                    return "Creative Commons Attribution 2.0 Generic";
                }
                case CC_BY_2_5: {
                    return "Creative Commons Attribution 2.5 Generic";
                }
                case CC_BY_2_5_AU: {
                    return "Creative Commons Attribution 2.5 Australia";
                }
                case CC_BY_3_0: {
                    return "Creative Commons Attribution 3.0 Unported";
                }
                case CC_BY_3_0_AT: {
                    return "Creative Commons Attribution 3.0 Austria";
                }
                case CC_BY_3_0_DE: {
                    return "Creative Commons Attribution 3.0 Germany";
                }
                case CC_BY_3_0_IGO: {
                    return "Creative Commons Attribution 3.0 IGO";
                }
                case CC_BY_3_0_NL: {
                    return "Creative Commons Attribution 3.0 Netherlands";
                }
                case CC_BY_3_0_US: {
                    return "Creative Commons Attribution 3.0 United States";
                }
                case CC_BY_4_0: {
                    return "Creative Commons Attribution 4.0 International";
                }
                case CC_BY_NC_1_0: {
                    return "Creative Commons Attribution Non Commercial 1.0 Generic";
                }
                case CC_BY_NC_2_0: {
                    return "Creative Commons Attribution Non Commercial 2.0 Generic";
                }
                case CC_BY_NC_2_5: {
                    return "Creative Commons Attribution Non Commercial 2.5 Generic";
                }
                case CC_BY_NC_3_0: {
                    return "Creative Commons Attribution Non Commercial 3.0 Unported";
                }
                case CC_BY_NC_3_0_DE: {
                    return "Creative Commons Attribution Non Commercial 3.0 Germany";
                }
                case CC_BY_NC_4_0: {
                    return "Creative Commons Attribution Non Commercial 4.0 International";
                }
                case CC_BY_NC_ND_1_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic";
                }
                case CC_BY_NC_ND_2_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic";
                }
                case CC_BY_NC_ND_2_5: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic";
                }
                case CC_BY_NC_ND_3_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported";
                }
                case CC_BY_NC_ND_3_0_DE: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany";
                }
                case CC_BY_NC_ND_3_0_IGO: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO";
                }
                case CC_BY_NC_ND_4_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 4.0 International";
                }
                case CC_BY_NC_SA_1_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic";
                }
                case CC_BY_NC_SA_2_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic";
                }
                case CC_BY_NC_SA_2_0_DE: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.0 Germany";
                }
                case CC_BY_NC_SA_2_0_FR: {
                    return "Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France";
                }
                case CC_BY_NC_SA_2_0_UK: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales";
                }
                case CC_BY_NC_SA_2_5: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic";
                }
                case CC_BY_NC_SA_3_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported";
                }
                case CC_BY_NC_SA_3_0_DE: {
                    return "Creative Commons Attribution Non Commercial Share Alike 3.0 Germany";
                }
                case CC_BY_NC_SA_3_0_IGO: {
                    return "Creative Commons Attribution Non Commercial Share Alike 3.0 IGO";
                }
                case CC_BY_NC_SA_4_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 4.0 International";
                }
                case CC_BY_ND_1_0: {
                    return "Creative Commons Attribution No Derivatives 1.0 Generic";
                }
                case CC_BY_ND_2_0: {
                    return "Creative Commons Attribution No Derivatives 2.0 Generic";
                }
                case CC_BY_ND_2_5: {
                    return "Creative Commons Attribution No Derivatives 2.5 Generic";
                }
                case CC_BY_ND_3_0: {
                    return "Creative Commons Attribution No Derivatives 3.0 Unported";
                }
                case CC_BY_ND_3_0_DE: {
                    return "Creative Commons Attribution No Derivatives 3.0 Germany";
                }
                case CC_BY_ND_4_0: {
                    return "Creative Commons Attribution No Derivatives 4.0 International";
                }
                case CC_BY_SA_1_0: {
                    return "Creative Commons Attribution Share Alike 1.0 Generic";
                }
                case CC_BY_SA_2_0: {
                    return "Creative Commons Attribution Share Alike 2.0 Generic";
                }
                case CC_BY_SA_2_0_UK: {
                    return "Creative Commons Attribution Share Alike 2.0 England and Wales";
                }
                case CC_BY_SA_2_1_JP: {
                    return "Creative Commons Attribution Share Alike 2.1 Japan";
                }
                case CC_BY_SA_2_5: {
                    return "Creative Commons Attribution Share Alike 2.5 Generic";
                }
                case CC_BY_SA_3_0: {
                    return "Creative Commons Attribution Share Alike 3.0 Unported";
                }
                case CC_BY_SA_3_0_AT: {
                    return "Creative Commons Attribution Share Alike 3.0 Austria";
                }
                case CC_BY_SA_3_0_DE: {
                    return "Creative Commons Attribution Share Alike 3.0 Germany";
                }
                case CC_BY_SA_3_0_IGO: {
                    return "Creative Commons Attribution-ShareAlike 3.0 IGO";
                }
                case CC_BY_SA_4_0: {
                    return "Creative Commons Attribution Share Alike 4.0 International";
                }
                case CC_PDDC: {
                    return "Creative Commons Public Domain Dedication and Certification";
                }
                case CC0_1_0: {
                    return "Creative Commons Zero v1.0 Universal";
                }
                case CDDL_1_0: {
                    return "Common Development and Distribution License 1.0";
                }
                case CDDL_1_1: {
                    return "Common Development and Distribution License 1.1";
                }
                case CDL_1_0: {
                    return "Common Documentation License 1.0";
                }
                case CDLA_PERMISSIVE_1_0: {
                    return "Community Data License Agreement Permissive 1.0";
                }
                case CDLA_PERMISSIVE_2_0: {
                    return "Community Data License Agreement Permissive 2.0";
                }
                case CDLA_SHARING_1_0: {
                    return "Community Data License Agreement Sharing 1.0";
                }
                case CECILL_1_0: {
                    return "CeCILL Free Software License Agreement v1.0";
                }
                case CECILL_1_1: {
                    return "CeCILL Free Software License Agreement v1.1";
                }
                case CECILL_2_0: {
                    return "CeCILL Free Software License Agreement v2.0";
                }
                case CECILL_2_1: {
                    return "CeCILL Free Software License Agreement v2.1";
                }
                case CECILL_B: {
                    return "CeCILL-B Free Software License Agreement";
                }
                case CECILL_C: {
                    return "CeCILL-C Free Software License Agreement";
                }
                case CERN_OHL_1_1: {
                    return "CERN Open Hardware Licence v1.1";
                }
                case CERN_OHL_1_2: {
                    return "CERN Open Hardware Licence v1.2";
                }
                case CERN_OHL_P_2_0: {
                    return "CERN Open Hardware Licence Version 2 - Permissive";
                }
                case CERN_OHL_S_2_0: {
                    return "CERN Open Hardware Licence Version 2 - Strongly Reciprocal";
                }
                case CERN_OHL_W_2_0: {
                    return "CERN Open Hardware Licence Version 2 - Weakly Reciprocal";
                }
                case CFITSIO: {
                    return "CFITSIO License";
                }
                case CHECKMK: {
                    return "Checkmk License";
                }
                case CLARTISTIC: {
                    return "Clarified Artistic License";
                }
                case CLIPS: {
                    return "Clips License";
                }
                case CMU_MACH: {
                    return "CMU Mach License";
                }
                case CNRI_JYTHON: {
                    return "CNRI Jython License";
                }
                case CNRI_PYTHON: {
                    return "CNRI Python License";
                }
                case CNRI_PYTHON_GPL_COMPATIBLE: {
                    return "CNRI Python Open Source GPL Compatible License Agreement";
                }
                case COIL_1_0: {
                    return "Copyfree Open Innovation License";
                }
                case COMMUNITY_SPEC_1_0: {
                    return "Community Specification License 1.0";
                }
                case CONDOR_1_1: {
                    return "Condor Public License v1.1";
                }
                case COPYLEFT_NEXT_0_3_0: {
                    return "copyleft-next 0.3.0";
                }
                case COPYLEFT_NEXT_0_3_1: {
                    return "copyleft-next 0.3.1";
                }
                case CORNELL_LOSSLESS_JPEG: {
                    return "Cornell Lossless JPEG License";
                }
                case CPAL_1_0: {
                    return "Common Public Attribution License 1.0";
                }
                case CPL_1_0: {
                    return "Common Public License 1.0";
                }
                case CPOL_1_02: {
                    return "Code Project Open License 1.02";
                }
                case CROSSWORD: {
                    return "Crossword License";
                }
                case CRYSTALSTACKER: {
                    return "CrystalStacker License";
                }
                case CUA_OPL_1_0: {
                    return "CUA Office Public License v1.0";
                }
                case CUBE: {
                    return "Cube License";
                }
                case CURL: {
                    return "curl License";
                }
                case D_FSL_1_0: {
                    return "Deutsche Freie Software Lizenz";
                }
                case DIFFMARK: {
                    return "diffmark license";
                }
                case DL_DE_BY_2_0: {
                    return "Data licence Germany \u2013 attribution \u2013 version 2.0";
                }
                case DOC: {
                    return "DOC License";
                }
                case DOTSEQN: {
                    return "Dotseqn License";
                }
                case DRL_1_0: {
                    return "Detection Rule License 1.0";
                }
                case DSDP: {
                    return "DSDP License";
                }
                case DTOA: {
                    return "David M. Gay dtoa License";
                }
                case DVIPDFM: {
                    return "dvipdfm License";
                }
                case ECL_1_0: {
                    return "Educational Community License v1.0";
                }
                case ECL_2_0: {
                    return "Educational Community License v2.0";
                }
                case ECOS_2_0: {
                    return "eCos license version 2.0";
                }
                case EFL_1_0: {
                    return "Eiffel Forum License v1.0";
                }
                case EFL_2_0: {
                    return "Eiffel Forum License v2.0";
                }
                case EGENIX: {
                    return "eGenix.com Public License 1.1.0";
                }
                case ELASTIC_2_0: {
                    return "Elastic License 2.0";
                }
                case ENTESSA: {
                    return "Entessa Public License v1.0";
                }
                case EPICS: {
                    return "EPICS Open License";
                }
                case EPL_1_0: {
                    return "Eclipse Public License 1.0";
                }
                case EPL_2_0: {
                    return "Eclipse Public License 2.0";
                }
                case ERLPL_1_1: {
                    return "Erlang Public License v1.1";
                }
                case ETALAB_2_0: {
                    return "Etalab Open License 2.0";
                }
                case EUDATAGRID: {
                    return "EU DataGrid Software License";
                }
                case EUPL_1_0: {
                    return "European Union Public License 1.0";
                }
                case EUPL_1_1: {
                    return "European Union Public License 1.1";
                }
                case EUPL_1_2: {
                    return "European Union Public License 1.2";
                }
                case EUROSYM: {
                    return "Eurosym License";
                }
                case FAIR: {
                    return "Fair License";
                }
                case FDK_AAC: {
                    return "Fraunhofer FDK AAC Codec Library";
                }
                case FRAMEWORX_1_0: {
                    return "Frameworx Open License 1.0";
                }
                case FREEBSD_DOC: {
                    return "FreeBSD Documentation License";
                }
                case FREEIMAGE: {
                    return "FreeImage Public License v1.0";
                }
                case FSFAP: {
                    return "FSF All Permissive License";
                }
                case FSFUL: {
                    return "FSF Unlimited License";
                }
                case FSFULLR: {
                    return "FSF Unlimited License (with License Retention)";
                }
                case FSFULLRWD: {
                    return "FSF Unlimited License (With License Retention and Warranty Disclaimer)";
                }
                case FTL: {
                    return "Freetype Project License";
                }
                case GD: {
                    return "GD License";
                }
                case GFDL_1_1: {
                    return "GNU Free Documentation License v1.1";
                }
                case GFDL_1_1_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.1 only - invariants";
                }
                case GFDL_1_1_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.1 or later - invariants";
                }
                case GFDL_1_1_NO_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.1 only - no invariants";
                }
                case GFDL_1_1_NO_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.1 or later - no invariants";
                }
                case GFDL_1_1_ONLY: {
                    return "GNU Free Documentation License v1.1 only";
                }
                case GFDL_1_1_OR_LATER: {
                    return "GNU Free Documentation License v1.1 or later";
                }
                case GFDL_1_2: {
                    return "GNU Free Documentation License v1.2";
                }
                case GFDL_1_2_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.2 only - invariants";
                }
                case GFDL_1_2_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.2 or later - invariants";
                }
                case GFDL_1_2_NO_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.2 only - no invariants";
                }
                case GFDL_1_2_NO_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.2 or later - no invariants";
                }
                case GFDL_1_2_ONLY: {
                    return "GNU Free Documentation License v1.2 only";
                }
                case GFDL_1_2_OR_LATER: {
                    return "GNU Free Documentation License v1.2 or later";
                }
                case GFDL_1_3: {
                    return "GNU Free Documentation License v1.3";
                }
                case GFDL_1_3_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.3 only - invariants";
                }
                case GFDL_1_3_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.3 or later - invariants";
                }
                case GFDL_1_3_NO_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.3 only - no invariants";
                }
                case GFDL_1_3_NO_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.3 or later - no invariants";
                }
                case GFDL_1_3_ONLY: {
                    return "GNU Free Documentation License v1.3 only";
                }
                case GFDL_1_3_OR_LATER: {
                    return "GNU Free Documentation License v1.3 or later";
                }
                case GIFTWARE: {
                    return "Giftware License";
                }
                case GL2PS: {
                    return "GL2PS License";
                }
                case GLIDE: {
                    return "3dfx Glide License";
                }
                case GLULXE: {
                    return "Glulxe License";
                }
                case GLWTPL: {
                    return "Good Luck With That Public License";
                }
                case GNUPLOT: {
                    return "gnuplot License";
                }
                case GPL_1_0: {
                    return "GNU General Public License v1.0 only";
                }
                case GPL_1_0PLUS: {
                    return "GNU General Public License v1.0 or later";
                }
                case GPL_1_0_ONLY: {
                    return "GNU General Public License v1.0 only";
                }
                case GPL_1_0_OR_LATER: {
                    return "GNU General Public License v1.0 or later";
                }
                case GPL_2_0: {
                    return "GNU General Public License v2.0 only";
                }
                case GPL_2_0PLUS: {
                    return "GNU General Public License v2.0 or later";
                }
                case GPL_2_0_ONLY: {
                    return "GNU General Public License v2.0 only";
                }
                case GPL_2_0_OR_LATER: {
                    return "GNU General Public License v2.0 or later";
                }
                case GPL_2_0_WITH_AUTOCONF_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Autoconf exception";
                }
                case GPL_2_0_WITH_BISON_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Bison exception";
                }
                case GPL_2_0_WITH_CLASSPATH_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Classpath exception";
                }
                case GPL_2_0_WITH_FONT_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Font exception";
                }
                case GPL_2_0_WITH_GCC_EXCEPTION: {
                    return "GNU General Public License v2.0 w/GCC Runtime Library exception";
                }
                case GPL_3_0: {
                    return "GNU General Public License v3.0 only";
                }
                case GPL_3_0PLUS: {
                    return "GNU General Public License v3.0 or later";
                }
                case GPL_3_0_ONLY: {
                    return "GNU General Public License v3.0 only";
                }
                case GPL_3_0_OR_LATER: {
                    return "GNU General Public License v3.0 or later";
                }
                case GPL_3_0_WITH_AUTOCONF_EXCEPTION: {
                    return "GNU General Public License v3.0 w/Autoconf exception";
                }
                case GPL_3_0_WITH_GCC_EXCEPTION: {
                    return "GNU General Public License v3.0 w/GCC Runtime Library exception";
                }
                case GRAPHICS_GEMS: {
                    return "Graphics Gems License";
                }
                case GSOAP_1_3B: {
                    return "gSOAP Public License v1.3b";
                }
                case HASKELLREPORT: {
                    return "Haskell Language Report License";
                }
                case HIPPOCRATIC_2_1: {
                    return "Hippocratic License 2.1";
                }
                case HP_1986: {
                    return "Hewlett-Packard 1986 License";
                }
                case HPND: {
                    return "Historical Permission Notice and Disclaimer";
                }
                case HPND_EXPORT_US: {
                    return "HPND with US Government export control warning";
                }
                case HPND_MARKUS_KUHN: {
                    return "Historical Permission Notice and Disclaimer - Markus Kuhn variant";
                }
                case HPND_SELL_VARIANT: {
                    return "Historical Permission Notice and Disclaimer - sell variant";
                }
                case HPND_SELL_VARIANT_MIT_DISCLAIMER: {
                    return "HPND sell variant with MIT disclaimer";
                }
                case HTMLTIDY: {
                    return "HTML Tidy License";
                }
                case IBM_PIBS: {
                    return "IBM PowerPC Initialization and Boot Software";
                }
                case ICU: {
                    return "ICU License";
                }
                case IEC_CODE_COMPONENTS_EULA: {
                    return "IEC    Code Components End-user licence agreement";
                }
                case IJG: {
                    return "Independent JPEG Group License";
                }
                case IJG_SHORT: {
                    return "Independent JPEG Group License - short";
                }
                case IMAGEMAGICK: {
                    return "ImageMagick License";
                }
                case IMATIX: {
                    return "iMatix Standard Function Library Agreement";
                }
                case IMLIB2: {
                    return "Imlib2 License";
                }
                case INFO_ZIP: {
                    return "Info-ZIP License";
                }
                case INNER_NET_2_0: {
                    return "Inner Net License v2.0";
                }
                case INTEL: {
                    return "Intel Open Source License";
                }
                case INTEL_ACPI: {
                    return "Intel ACPI Software License Agreement";
                }
                case INTERBASE_1_0: {
                    return "Interbase Public License v1.0";
                }
                case IPA: {
                    return "IPA Font License";
                }
                case IPL_1_0: {
                    return "IBM Public License v1.0";
                }
                case ISC: {
                    return "ISC License";
                }
                case JAM: {
                    return "Jam License";
                }
                case JASPER_2_0: {
                    return "JasPer License";
                }
                case JPL_IMAGE: {
                    return "JPL Image Use Policy";
                }
                case JPNIC: {
                    return "Japan Network Information Center License";
                }
                case JSON: {
                    return "JSON License";
                }
                case KAZLIB: {
                    return "Kazlib License";
                }
                case KNUTH_CTAN: {
                    return "Knuth CTAN License";
                }
                case LAL_1_2: {
                    return "Licence Art Libre 1.2";
                }
                case LAL_1_3: {
                    return "Licence Art Libre 1.3";
                }
                case LATEX2E: {
                    return "Latex2e License";
                }
                case LATEX2E_TRANSLATED_NOTICE: {
                    return "Latex2e with translated notice permission";
                }
                case LEPTONICA: {
                    return "Leptonica License";
                }
                case LGPL_2_0: {
                    return "GNU Library General Public License v2 only";
                }
                case LGPL_2_0PLUS: {
                    return "GNU Library General Public License v2 or later";
                }
                case LGPL_2_0_ONLY: {
                    return "GNU Library General Public License v2 only";
                }
                case LGPL_2_0_OR_LATER: {
                    return "GNU Library General Public License v2 or later";
                }
                case LGPL_2_1: {
                    return "GNU Lesser General Public License v2.1 only";
                }
                case LGPL_2_1PLUS: {
                    return "GNU Lesser General Public License v2.1 or later";
                }
                case LGPL_2_1_ONLY: {
                    return "GNU Lesser General Public License v2.1 only";
                }
                case LGPL_2_1_OR_LATER: {
                    return "GNU Lesser General Public License v2.1 or later";
                }
                case LGPL_3_0: {
                    return "GNU Lesser General Public License v3.0 only";
                }
                case LGPL_3_0PLUS: {
                    return "GNU Lesser General Public License v3.0 or later";
                }
                case LGPL_3_0_ONLY: {
                    return "GNU Lesser General Public License v3.0 only";
                }
                case LGPL_3_0_OR_LATER: {
                    return "GNU Lesser General Public License v3.0 or later";
                }
                case LGPLLR: {
                    return "Lesser General Public License For Linguistic Resources";
                }
                case LIBPNG: {
                    return "libpng License";
                }
                case LIBPNG_2_0: {
                    return "PNG Reference Library version 2";
                }
                case LIBSELINUX_1_0: {
                    return "libselinux public domain notice";
                }
                case LIBTIFF: {
                    return "libtiff License";
                }
                case LIBUTIL_DAVID_NUGENT: {
                    return "libutil David Nugent License";
                }
                case LILIQ_P_1_1: {
                    return "Licence Libre du Qu\u00e9bec \u2013 Permissive version 1.1";
                }
                case LILIQ_R_1_1: {
                    return "Licence Libre du Qu\u00e9bec \u2013 R\u00e9ciprocit\u00e9 version 1.1";
                }
                case LILIQ_RPLUS_1_1: {
                    return "Licence Libre du Qu\u00e9bec \u2013 R\u00e9ciprocit\u00e9 forte version 1.1";
                }
                case LINUX_MAN_PAGES_1_PARA: {
                    return "Linux man-pages - 1 paragraph";
                }
                case LINUX_MAN_PAGES_COPYLEFT: {
                    return "Linux man-pages Copyleft";
                }
                case LINUX_MAN_PAGES_COPYLEFT_2_PARA: {
                    return "Linux man-pages Copyleft - 2 paragraphs";
                }
                case LINUX_MAN_PAGES_COPYLEFT_VAR: {
                    return "Linux man-pages Copyleft Variant";
                }
                case LINUX_OPENIB: {
                    return "Linux Kernel Variant of OpenIB.org license";
                }
                case LOOP: {
                    return "Common Lisp LOOP License";
                }
                case LPL_1_0: {
                    return "Lucent Public License Version 1.0";
                }
                case LPL_1_02: {
                    return "Lucent Public License v1.02";
                }
                case LPPL_1_0: {
                    return "LaTeX Project Public License v1.0";
                }
                case LPPL_1_1: {
                    return "LaTeX Project Public License v1.1";
                }
                case LPPL_1_2: {
                    return "LaTeX Project Public License v1.2";
                }
                case LPPL_1_3A: {
                    return "LaTeX Project Public License v1.3a";
                }
                case LPPL_1_3C: {
                    return "LaTeX Project Public License v1.3c";
                }
                case LZMA_SDK_9_11_TO_9_20: {
                    return "LZMA SDK License (versions 9.11 to 9.20)";
                }
                case LZMA_SDK_9_22: {
                    return "LZMA SDK License (versions 9.22 and beyond)";
                }
                case MAKEINDEX: {
                    return "MakeIndex License";
                }
                case MARTIN_BIRGMEIER: {
                    return "Martin Birgmeier License";
                }
                case METAMAIL: {
                    return "metamail License";
                }
                case MINPACK: {
                    return "Minpack License";
                }
                case MIROS: {
                    return "The MirOS Licence";
                }
                case MIT: {
                    return "MIT License";
                }
                case MIT_0: {
                    return "MIT No Attribution";
                }
                case MIT_ADVERTISING: {
                    return "Enlightenment License (e16)";
                }
                case MIT_CMU: {
                    return "CMU License";
                }
                case MIT_ENNA: {
                    return "enna License";
                }
                case MIT_FEH: {
                    return "feh License";
                }
                case MIT_FESTIVAL: {
                    return "MIT Festival Variant";
                }
                case MIT_MODERN_VARIANT: {
                    return "MIT License Modern Variant";
                }
                case MIT_OPEN_GROUP: {
                    return "MIT Open Group variant";
                }
                case MIT_WU: {
                    return "MIT Tom Wu Variant";
                }
                case MITNFA: {
                    return "MIT +no-false-attribs license";
                }
                case MOTOSOTO: {
                    return "Motosoto License";
                }
                case MPI_PERMISSIVE: {
                    return "mpi Permissive License";
                }
                case MPICH2: {
                    return "mpich2 License";
                }
                case MPL_1_0: {
                    return "Mozilla Public License 1.0";
                }
                case MPL_1_1: {
                    return "Mozilla Public License 1.1";
                }
                case MPL_2_0: {
                    return "Mozilla Public License 2.0";
                }
                case MPL_2_0_NO_COPYLEFT_EXCEPTION: {
                    return "Mozilla Public License 2.0 (no copyleft exception)";
                }
                case MPLUS: {
                    return "mplus Font License";
                }
                case MS_LPL: {
                    return "Microsoft Limited Public License";
                }
                case MS_PL: {
                    return "Microsoft Public License";
                }
                case MS_RL: {
                    return "Microsoft Reciprocal License";
                }
                case MTLL: {
                    return "Matrix Template Library License";
                }
                case MULANPSL_1_0: {
                    return "Mulan Permissive Software License, Version 1";
                }
                case MULANPSL_2_0: {
                    return "Mulan Permissive Software License, Version 2";
                }
                case MULTICS: {
                    return "Multics License";
                }
                case MUP: {
                    return "Mup License";
                }
                case NAIST_2003: {
                    return "Nara Institute of Science and Technology License (2003)";
                }
                case NASA_1_3: {
                    return "NASA Open Source Agreement 1.3";
                }
                case NAUMEN: {
                    return "Naumen Public License";
                }
                case NBPL_1_0: {
                    return "Net Boolean Public License v1";
                }
                case NCGL_UK_2_0: {
                    return "Non-Commercial Government Licence";
                }
                case NCSA: {
                    return "University of Illinois/NCSA Open Source License";
                }
                case NET_SNMP: {
                    return "Net-SNMP License";
                }
                case NETCDF: {
                    return "NetCDF license";
                }
                case NEWSLETR: {
                    return "Newsletr License";
                }
                case NGPL: {
                    return "Nethack General Public License";
                }
                case NICTA_1_0: {
                    return "NICTA Public Software License, Version 1.0";
                }
                case NIST_PD: {
                    return "NIST Public Domain Notice";
                }
                case NIST_PD_FALLBACK: {
                    return "NIST Public Domain Notice with license fallback";
                }
                case NIST_SOFTWARE: {
                    return "NIST Software License";
                }
                case NLOD_1_0: {
                    return "Norwegian Licence for Open Government Data (NLOD) 1.0";
                }
                case NLOD_2_0: {
                    return "Norwegian Licence for Open Government Data (NLOD) 2.0";
                }
                case NLPL: {
                    return "No Limit Public License";
                }
                case NOKIA: {
                    return "Nokia Open Source License";
                }
                case NOSL: {
                    return "Netizen Open Source License";
                }
                case NOT_OPEN_SOURCE: {
                    return "Not an open source license.";
                }
                case NOWEB: {
                    return "Noweb License";
                }
                case NPL_1_0: {
                    return "Netscape Public License v1.0";
                }
                case NPL_1_1: {
                    return "Netscape Public License v1.1";
                }
                case NPOSL_3_0: {
                    return "Non-Profit Open Software License 3.0";
                }
                case NRL: {
                    return "NRL License";
                }
                case NTP: {
                    return "NTP License";
                }
                case NTP_0: {
                    return "NTP No Attribution";
                }
                case NUNIT: {
                    return "Nunit License";
                }
                case O_UDA_1_0: {
                    return "Open Use of Data Agreement v1.0";
                }
                case OCCT_PL: {
                    return "Open CASCADE Technology Public License";
                }
                case OCLC_2_0: {
                    return "OCLC Research Public License 2.0";
                }
                case ODBL_1_0: {
                    return "Open Data Commons Open Database License v1.0";
                }
                case ODC_BY_1_0: {
                    return "Open Data Commons Attribution License v1.0";
                }
                case OFFIS: {
                    return "OFFIS License";
                }
                case OFL_1_0: {
                    return "SIL Open Font License 1.0";
                }
                case OFL_1_0_NO_RFN: {
                    return "SIL Open Font License 1.0 with no Reserved Font Name";
                }
                case OFL_1_0_RFN: {
                    return "SIL Open Font License 1.0 with Reserved Font Name";
                }
                case OFL_1_1: {
                    return "SIL Open Font License 1.1";
                }
                case OFL_1_1_NO_RFN: {
                    return "SIL Open Font License 1.1 with no Reserved Font Name";
                }
                case OFL_1_1_RFN: {
                    return "SIL Open Font License 1.1 with Reserved Font Name";
                }
                case OGC_1_0: {
                    return "OGC Software License, Version 1.0";
                }
                case OGDL_TAIWAN_1_0: {
                    return "Taiwan Open Government Data License, version 1.0";
                }
                case OGL_CANADA_2_0: {
                    return "Open Government Licence - Canada";
                }
                case OGL_UK_1_0: {
                    return "Open Government Licence v1.0";
                }
                case OGL_UK_2_0: {
                    return "Open Government Licence v2.0";
                }
                case OGL_UK_3_0: {
                    return "Open Government Licence v3.0";
                }
                case OGTSL: {
                    return "Open Group Test Suite License";
                }
                case OLDAP_1_1: {
                    return "Open LDAP Public License v1.1";
                }
                case OLDAP_1_2: {
                    return "Open LDAP Public License v1.2";
                }
                case OLDAP_1_3: {
                    return "Open LDAP Public License v1.3";
                }
                case OLDAP_1_4: {
                    return "Open LDAP Public License v1.4";
                }
                case OLDAP_2_0: {
                    return "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)";
                }
                case OLDAP_2_0_1: {
                    return "Open LDAP Public License v2.0.1";
                }
                case OLDAP_2_1: {
                    return "Open LDAP Public License v2.1";
                }
                case OLDAP_2_2: {
                    return "Open LDAP Public License v2.2";
                }
                case OLDAP_2_2_1: {
                    return "Open LDAP Public License v2.2.1";
                }
                case OLDAP_2_2_2: {
                    return "Open LDAP Public License 2.2.2";
                }
                case OLDAP_2_3: {
                    return "Open LDAP Public License v2.3";
                }
                case OLDAP_2_4: {
                    return "Open LDAP Public License v2.4";
                }
                case OLDAP_2_5: {
                    return "Open LDAP Public License v2.5";
                }
                case OLDAP_2_6: {
                    return "Open LDAP Public License v2.6";
                }
                case OLDAP_2_7: {
                    return "Open LDAP Public License v2.7";
                }
                case OLDAP_2_8: {
                    return "Open LDAP Public License v2.8";
                }
                case OLFL_1_3: {
                    return "Open Logistics Foundation License Version 1.3";
                }
                case OML: {
                    return "Open Market License";
                }
                case OPENPBS_2_3: {
                    return "OpenPBS v2.3 Software License";
                }
                case OPENSSL: {
                    return "OpenSSL License";
                }
                case OPL_1_0: {
                    return "Open Public License v1.0";
                }
                case OPL_UK_3_0: {
                    return "United    Kingdom Open Parliament Licence v3.0";
                }
                case OPUBL_1_0: {
                    return "Open Publication License v1.0";
                }
                case OSET_PL_2_1: {
                    return "OSET Public License version 2.1";
                }
                case OSL_1_0: {
                    return "Open Software License 1.0";
                }
                case OSL_1_1: {
                    return "Open Software License 1.1";
                }
                case OSL_2_0: {
                    return "Open Software License 2.0";
                }
                case OSL_2_1: {
                    return "Open Software License 2.1";
                }
                case OSL_3_0: {
                    return "Open Software License 3.0";
                }
                case PARITY_6_0_0: {
                    return "The Parity Public License 6.0.0";
                }
                case PARITY_7_0_0: {
                    return "The Parity Public License 7.0.0";
                }
                case PDDL_1_0: {
                    return "Open Data Commons Public Domain Dedication & License 1.0";
                }
                case PHP_3_0: {
                    return "PHP License v3.0";
                }
                case PHP_3_01: {
                    return "PHP License v3.01";
                }
                case PLEXUS: {
                    return "Plexus Classworlds License";
                }
                case POLYFORM_NONCOMMERCIAL_1_0_0: {
                    return "PolyForm Noncommercial License 1.0.0";
                }
                case POLYFORM_SMALL_BUSINESS_1_0_0: {
                    return "PolyForm Small Business License 1.0.0";
                }
                case POSTGRESQL: {
                    return "PostgreSQL License";
                }
                case PSF_2_0: {
                    return "Python Software Foundation License 2.0";
                }
                case PSFRAG: {
                    return "psfrag License";
                }
                case PSUTILS: {
                    return "psutils License";
                }
                case PYTHON_2_0: {
                    return "Python License 2.0";
                }
                case PYTHON_2_0_1: {
                    return "Python License 2.0.1";
                }
                case QHULL: {
                    return "Qhull License";
                }
                case QPL_1_0: {
                    return "Q Public License 1.0";
                }
                case QPL_1_0_INRIA_2004: {
                    return "Q Public License 1.0 - INRIA 2004 variant";
                }
                case RDISC: {
                    return "Rdisc License";
                }
                case RHECOS_1_1: {
                    return "Red Hat eCos Public License v1.1";
                }
                case RPL_1_1: {
                    return "Reciprocal Public License 1.1";
                }
                case RPL_1_5: {
                    return "Reciprocal Public License 1.5";
                }
                case RPSL_1_0: {
                    return "RealNetworks Public Source License v1.0";
                }
                case RSA_MD: {
                    return "RSA Message-Digest License";
                }
                case RSCPL: {
                    return "Ricoh Source Code Public License";
                }
                case RUBY: {
                    return "Ruby License";
                }
                case SAX_PD: {
                    return "Sax Public Domain Notice";
                }
                case SAXPATH: {
                    return "Saxpath License";
                }
                case SCEA: {
                    return "SCEA Shared Source License";
                }
                case SCHEMEREPORT: {
                    return "Scheme Language Report License";
                }
                case SENDMAIL: {
                    return "Sendmail License";
                }
                case SENDMAIL_8_23: {
                    return "Sendmail License 8.23";
                }
                case SGI_B_1_0: {
                    return "SGI Free Software License B v1.0";
                }
                case SGI_B_1_1: {
                    return "SGI Free Software License B v1.1";
                }
                case SGI_B_2_0: {
                    return "SGI Free Software License B v2.0";
                }
                case SGP4: {
                    return "SGP4 Permission Notice";
                }
                case SHL_0_5: {
                    return "Solderpad Hardware License v0.5";
                }
                case SHL_0_51: {
                    return "Solderpad Hardware License, Version 0.51";
                }
                case SIMPL_2_0: {
                    return "Simple Public License 2.0";
                }
                case SISSL: {
                    return "Sun Industry Standards Source License v1.1";
                }
                case SISSL_1_2: {
                    return "Sun Industry Standards Source License v1.2";
                }
                case SLEEPYCAT: {
                    return "Sleepycat License";
                }
                case SMLNJ: {
                    return "Standard ML of New Jersey License";
                }
                case SMPPL: {
                    return "Secure Messaging Protocol Public License";
                }
                case SNIA: {
                    return "SNIA Public License 1.1";
                }
                case SNPRINTF: {
                    return "snprintf License";
                }
                case SPENCER_86: {
                    return "Spencer License 86";
                }
                case SPENCER_94: {
                    return "Spencer License 94";
                }
                case SPENCER_99: {
                    return "Spencer License 99";
                }
                case SPL_1_0: {
                    return "Sun Public License v1.0";
                }
                case SSH_OPENSSH: {
                    return "SSH OpenSSH license";
                }
                case SSH_SHORT: {
                    return "SSH short notice";
                }
                case SSPL_1_0: {
                    return "Server Side Public License, v 1";
                }
                case STANDARDML_NJ: {
                    return "Standard ML of New Jersey License";
                }
                case SUGARCRM_1_1_3: {
                    return "SugarCRM Public License v1.1.3";
                }
                case SUNPRO: {
                    return "SunPro License";
                }
                case SWL: {
                    return "Scheme Widget Library (SWL) Software License Agreement";
                }
                case SYMLINKS: {
                    return "Symlinks License";
                }
                case TAPR_OHL_1_0: {
                    return "TAPR Open Hardware License v1.0";
                }
                case TCL: {
                    return "TCL/TK License";
                }
                case TCP_WRAPPERS: {
                    return "TCP Wrappers License";
                }
                case TERMREADKEY: {
                    return "TermReadKey License";
                }
                case TMATE: {
                    return "TMate Open Source License";
                }
                case TORQUE_1_1: {
                    return "TORQUE v2.5+ Software License v1.1";
                }
                case TOSL: {
                    return "Trusster Open Source License";
                }
                case TPDL: {
                    return "Time::ParseDate License";
                }
                case TPL_1_0: {
                    return "THOR Public License 1.0";
                }
                case TTWL: {
                    return "Text-Tabs+Wrap License";
                }
                case TU_BERLIN_1_0: {
                    return "Technische Universitaet Berlin License 1.0";
                }
                case TU_BERLIN_2_0: {
                    return "Technische Universitaet Berlin License 2.0";
                }
                case UCAR: {
                    return "UCAR License";
                }
                case UCL_1_0: {
                    return "Upstream Compatibility License v1.0";
                }
                case UNICODE_DFS_2015: {
                    return "Unicode License Agreement - Data Files and Software (2015)";
                }
                case UNICODE_DFS_2016: {
                    return "Unicode License Agreement - Data Files and Software (2016)";
                }
                case UNICODE_TOU: {
                    return "Unicode Terms of Use";
                }
                case UNIXCRYPT: {
                    return "UnixCrypt License";
                }
                case UNLICENSE: {
                    return "The Unlicense";
                }
                case UPL_1_0: {
                    return "Universal Permissive License v1.0";
                }
                case VIM: {
                    return "Vim License";
                }
                case VOSTROM: {
                    return "VOSTROM Public License for Open Source";
                }
                case VSL_1_0: {
                    return "Vovida Software License v1.0";
                }
                case W3C: {
                    return "W3C Software Notice and License (2002-12-31)";
                }
                case W3C_19980720: {
                    return "W3C Software Notice and License (1998-07-20)";
                }
                case W3C_20150513: {
                    return "W3C Software Notice and Document License (2015-05-13)";
                }
                case W3M: {
                    return "w3m License";
                }
                case WATCOM_1_0: {
                    return "Sybase Open Watcom Public License 1.0";
                }
                case WIDGET_WORKSHOP: {
                    return "Widget Workshop License";
                }
                case WSUIPA: {
                    return "Wsuipa License";
                }
                case WTFPL: {
                    return "Do What The F*ck You Want To Public License";
                }
                case WXWINDOWS: {
                    return "wxWindows Library License";
                }
                case X11: {
                    return "X11 License";
                }
                case X11_DISTRIBUTE_MODIFICATIONS_VARIANT: {
                    return "X11 License Distribution Modification Variant";
                }
                case XDEBUG_1_03: {
                    return "Xdebug License v 1.03";
                }
                case XEROX: {
                    return "Xerox License";
                }
                case XFIG: {
                    return "Xfig License";
                }
                case XFREE86_1_1: {
                    return "XFree86 License 1.1";
                }
                case XINETD: {
                    return "xinetd License";
                }
                case XLOCK: {
                    return "xlock License";
                }
                case XNET: {
                    return "X.Net License";
                }
                case XPP: {
                    return "XPP License";
                }
                case XSKAT: {
                    return "XSkat License";
                }
                case YPL_1_0: {
                    return "Yahoo! Public License v1.0";
                }
                case YPL_1_1: {
                    return "Yahoo! Public License v1.1";
                }
                case ZED: {
                    return "Zed License";
                }
                case ZEND_2_0: {
                    return "Zend License v2.0";
                }
                case ZIMBRA_1_3: {
                    return "Zimbra Public License v1.3";
                }
                case ZIMBRA_1_4: {
                    return "Zimbra Public License v1.4";
                }
                case ZLIB: {
                    return "zlib License";
                }
                case ZLIB_ACKNOWLEDGEMENT: {
                    return "zlib/libpng License with Acknowledgement";
                }
                case ZPL_1_1: {
                    return "Zope Public License 1.1";
                }
                case ZPL_2_0: {
                    return "Zope Public License 2.0";
                }
                case ZPL_2_1: {
                    return "Zope Public License 2.1";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case _0BSD: {
                    return "BSD Zero Clause License";
                }
                case AAL: {
                    return "Attribution Assurance License";
                }
                case ABSTYLES: {
                    return "Abstyles License";
                }
                case ADACORE_DOC: {
                    return "AdaCore Doc License";
                }
                case ADOBE_2006: {
                    return "Adobe Systems Incorporated Source Code License Agreement";
                }
                case ADOBE_GLYPH: {
                    return "Adobe Glyph List License";
                }
                case ADSL: {
                    return "Amazon Digital Services License";
                }
                case AFL_1_1: {
                    return "Academic Free License v1.1";
                }
                case AFL_1_2: {
                    return "Academic Free License v1.2";
                }
                case AFL_2_0: {
                    return "Academic Free License v2.0";
                }
                case AFL_2_1: {
                    return "Academic Free License v2.1";
                }
                case AFL_3_0: {
                    return "Academic Free License v3.0";
                }
                case AFMPARSE: {
                    return "Afmparse License";
                }
                case AGPL_1_0: {
                    return "Affero General Public License v1.0";
                }
                case AGPL_1_0_ONLY: {
                    return "Affero General Public License v1.0 only";
                }
                case AGPL_1_0_OR_LATER: {
                    return "Affero General Public License v1.0 or later";
                }
                case AGPL_3_0: {
                    return "GNU Affero General Public License v3.0";
                }
                case AGPL_3_0_ONLY: {
                    return "GNU Affero General Public License v3.0 only";
                }
                case AGPL_3_0_OR_LATER: {
                    return "GNU Affero General Public License v3.0 or later";
                }
                case ALADDIN: {
                    return "Aladdin Free Public License";
                }
                case AMDPLPA: {
                    return "AMD's plpa_map.c License";
                }
                case AML: {
                    return "Apple MIT License";
                }
                case AMPAS: {
                    return "Academy of Motion Picture Arts and Sciences BSD";
                }
                case ANTLR_PD: {
                    return "ANTLR Software Rights Notice";
                }
                case ANTLR_PD_FALLBACK: {
                    return "ANTLR Software Rights Notice with license fallback";
                }
                case APACHE_1_0: {
                    return "Apache License 1.0";
                }
                case APACHE_1_1: {
                    return "Apache License 1.1";
                }
                case APACHE_2_0: {
                    return "Apache License 2.0";
                }
                case APAFML: {
                    return "Adobe Postscript AFM License";
                }
                case APL_1_0: {
                    return "Adaptive Public License 1.0";
                }
                case APP_S2P: {
                    return "App::s2p License";
                }
                case APSL_1_0: {
                    return "Apple Public Source License 1.0";
                }
                case APSL_1_1: {
                    return "Apple Public Source License 1.1";
                }
                case APSL_1_2: {
                    return "Apple Public Source License 1.2";
                }
                case APSL_2_0: {
                    return "Apple Public Source License 2.0";
                }
                case ARPHIC_1999: {
                    return "Arphic Public License";
                }
                case ARTISTIC_1_0: {
                    return "Artistic License 1.0";
                }
                case ARTISTIC_1_0_CL8: {
                    return "Artistic License 1.0 w/clause 8";
                }
                case ARTISTIC_1_0_PERL: {
                    return "Artistic License 1.0 (Perl)";
                }
                case ARTISTIC_2_0: {
                    return "Artistic License 2.0";
                }
                case ASWF_DIGITAL_ASSETS_1_0: {
                    return "ASWF Digital Assets License version 1.0";
                }
                case ASWF_DIGITAL_ASSETS_1_1: {
                    return "ASWF Digital Assets License 1.1";
                }
                case BAEKMUK: {
                    return "Baekmuk License";
                }
                case BAHYPH: {
                    return "Bahyph License";
                }
                case BARR: {
                    return "Barr License";
                }
                case BEERWARE: {
                    return "Beerware License";
                }
                case BITSTREAM_CHARTER: {
                    return "Bitstream Charter Font License";
                }
                case BITSTREAM_VERA: {
                    return "Bitstream Vera Font License";
                }
                case BITTORRENT_1_0: {
                    return "BitTorrent Open Source License v1.0";
                }
                case BITTORRENT_1_1: {
                    return "BitTorrent Open Source License v1.1";
                }
                case BLESSING: {
                    return "SQLite Blessing";
                }
                case BLUEOAK_1_0_0: {
                    return "Blue Oak Model License 1.0.0";
                }
                case BOEHM_GC: {
                    return "Boehm-Demers-Weiser GC License";
                }
                case BORCEUX: {
                    return "Borceux license";
                }
                case BRIAN_GLADMAN_3_CLAUSE: {
                    return "Brian Gladman 3-Clause License";
                }
                case BSD_1_CLAUSE: {
                    return "BSD 1-Clause License";
                }
                case BSD_2_CLAUSE: {
                    return "BSD 2-Clause \"Simplified\" License";
                }
                case BSD_2_CLAUSE_FREEBSD: {
                    return "BSD 2-Clause FreeBSD License";
                }
                case BSD_2_CLAUSE_NETBSD: {
                    return "BSD 2-Clause NetBSD License";
                }
                case BSD_2_CLAUSE_PATENT: {
                    return "BSD-2-Clause Plus Patent License";
                }
                case BSD_2_CLAUSE_VIEWS: {
                    return "BSD 2-Clause with views sentence";
                }
                case BSD_3_CLAUSE: {
                    return "BSD 3-Clause \"New\" or \"Revised\" License";
                }
                case BSD_3_CLAUSE_ATTRIBUTION: {
                    return "BSD with attribution";
                }
                case BSD_3_CLAUSE_CLEAR: {
                    return "BSD 3-Clause Clear License";
                }
                case BSD_3_CLAUSE_LBNL: {
                    return "Lawrence Berkeley National Labs BSD variant license";
                }
                case BSD_3_CLAUSE_MODIFICATION: {
                    return "BSD 3-Clause Modification";
                }
                case BSD_3_CLAUSE_NO_MILITARY_LICENSE: {
                    return "BSD 3-Clause No Military License";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE: {
                    return "BSD 3-Clause No Nuclear License";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014: {
                    return "BSD 3-Clause No Nuclear License 2014";
                }
                case BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY: {
                    return "BSD 3-Clause No Nuclear Warranty";
                }
                case BSD_3_CLAUSE_OPEN_MPI: {
                    return "BSD 3-Clause Open MPI variant";
                }
                case BSD_4_CLAUSE: {
                    return "BSD 4-Clause \"Original\" or \"Old\" License";
                }
                case BSD_4_CLAUSE_SHORTENED: {
                    return "BSD 4 Clause Shortened";
                }
                case BSD_4_CLAUSE_UC: {
                    return "BSD-4-Clause (University of California-Specific)";
                }
                case BSD_4_3RENO: {
                    return "BSD 4.3 RENO License";
                }
                case BSD_4_3TAHOE: {
                    return "BSD 4.3 TAHOE License";
                }
                case BSD_ADVERTISING_ACKNOWLEDGEMENT: {
                    return "BSD Advertising Acknowledgement License";
                }
                case BSD_ATTRIBUTION_HPND_DISCLAIMER: {
                    return "BSD with Attribution and HPND disclaimer";
                }
                case BSD_PROTECTION: {
                    return "BSD Protection License";
                }
                case BSD_SOURCE_CODE: {
                    return "BSD Source Code Attribution";
                }
                case BSL_1_0: {
                    return "Boost Software License 1.0";
                }
                case BUSL_1_1: {
                    return "Business Source License 1.1";
                }
                case BZIP2_1_0_5: {
                    return "bzip2 and libbzip2 License v1.0.5";
                }
                case BZIP2_1_0_6: {
                    return "bzip2 and libbzip2 License v1.0.6";
                }
                case C_UDA_1_0: {
                    return "Computational Use of Data Agreement v1.0";
                }
                case CAL_1_0: {
                    return "Cryptographic Autonomy License 1.0";
                }
                case CAL_1_0_COMBINED_WORK_EXCEPTION: {
                    return "Cryptographic Autonomy License 1.0 (Combined Work Exception)";
                }
                case CALDERA: {
                    return "Caldera License";
                }
                case CATOSL_1_1: {
                    return "Computer Associates Trusted Open Source License 1.1";
                }
                case CC_BY_1_0: {
                    return "Creative Commons Attribution 1.0 Generic";
                }
                case CC_BY_2_0: {
                    return "Creative Commons Attribution 2.0 Generic";
                }
                case CC_BY_2_5: {
                    return "Creative Commons Attribution 2.5 Generic";
                }
                case CC_BY_2_5_AU: {
                    return "Creative Commons Attribution 2.5 Australia";
                }
                case CC_BY_3_0: {
                    return "Creative Commons Attribution 3.0 Unported";
                }
                case CC_BY_3_0_AT: {
                    return "Creative Commons Attribution 3.0 Austria";
                }
                case CC_BY_3_0_DE: {
                    return "Creative Commons Attribution 3.0 Germany";
                }
                case CC_BY_3_0_IGO: {
                    return "Creative Commons Attribution 3.0 IGO";
                }
                case CC_BY_3_0_NL: {
                    return "Creative Commons Attribution 3.0 Netherlands";
                }
                case CC_BY_3_0_US: {
                    return "Creative Commons Attribution 3.0 United States";
                }
                case CC_BY_4_0: {
                    return "Creative Commons Attribution 4.0 International";
                }
                case CC_BY_NC_1_0: {
                    return "Creative Commons Attribution Non Commercial 1.0 Generic";
                }
                case CC_BY_NC_2_0: {
                    return "Creative Commons Attribution Non Commercial 2.0 Generic";
                }
                case CC_BY_NC_2_5: {
                    return "Creative Commons Attribution Non Commercial 2.5 Generic";
                }
                case CC_BY_NC_3_0: {
                    return "Creative Commons Attribution Non Commercial 3.0 Unported";
                }
                case CC_BY_NC_3_0_DE: {
                    return "Creative Commons Attribution Non Commercial 3.0 Germany";
                }
                case CC_BY_NC_4_0: {
                    return "Creative Commons Attribution Non Commercial 4.0 International";
                }
                case CC_BY_NC_ND_1_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic";
                }
                case CC_BY_NC_ND_2_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic";
                }
                case CC_BY_NC_ND_2_5: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic";
                }
                case CC_BY_NC_ND_3_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported";
                }
                case CC_BY_NC_ND_3_0_DE: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany";
                }
                case CC_BY_NC_ND_3_0_IGO: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO";
                }
                case CC_BY_NC_ND_4_0: {
                    return "Creative Commons Attribution Non Commercial No Derivatives 4.0 International";
                }
                case CC_BY_NC_SA_1_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic";
                }
                case CC_BY_NC_SA_2_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic";
                }
                case CC_BY_NC_SA_2_0_DE: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.0 Germany";
                }
                case CC_BY_NC_SA_2_0_FR: {
                    return "Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France";
                }
                case CC_BY_NC_SA_2_0_UK: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales";
                }
                case CC_BY_NC_SA_2_5: {
                    return "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic";
                }
                case CC_BY_NC_SA_3_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported";
                }
                case CC_BY_NC_SA_3_0_DE: {
                    return "Creative Commons Attribution Non Commercial Share Alike 3.0 Germany";
                }
                case CC_BY_NC_SA_3_0_IGO: {
                    return "Creative Commons Attribution Non Commercial Share Alike 3.0 IGO";
                }
                case CC_BY_NC_SA_4_0: {
                    return "Creative Commons Attribution Non Commercial Share Alike 4.0 International";
                }
                case CC_BY_ND_1_0: {
                    return "Creative Commons Attribution No Derivatives 1.0 Generic";
                }
                case CC_BY_ND_2_0: {
                    return "Creative Commons Attribution No Derivatives 2.0 Generic";
                }
                case CC_BY_ND_2_5: {
                    return "Creative Commons Attribution No Derivatives 2.5 Generic";
                }
                case CC_BY_ND_3_0: {
                    return "Creative Commons Attribution No Derivatives 3.0 Unported";
                }
                case CC_BY_ND_3_0_DE: {
                    return "Creative Commons Attribution No Derivatives 3.0 Germany";
                }
                case CC_BY_ND_4_0: {
                    return "Creative Commons Attribution No Derivatives 4.0 International";
                }
                case CC_BY_SA_1_0: {
                    return "Creative Commons Attribution Share Alike 1.0 Generic";
                }
                case CC_BY_SA_2_0: {
                    return "Creative Commons Attribution Share Alike 2.0 Generic";
                }
                case CC_BY_SA_2_0_UK: {
                    return "Creative Commons Attribution Share Alike 2.0 England and Wales";
                }
                case CC_BY_SA_2_1_JP: {
                    return "Creative Commons Attribution Share Alike 2.1 Japan";
                }
                case CC_BY_SA_2_5: {
                    return "Creative Commons Attribution Share Alike 2.5 Generic";
                }
                case CC_BY_SA_3_0: {
                    return "Creative Commons Attribution Share Alike 3.0 Unported";
                }
                case CC_BY_SA_3_0_AT: {
                    return "Creative Commons Attribution Share Alike 3.0 Austria";
                }
                case CC_BY_SA_3_0_DE: {
                    return "Creative Commons Attribution Share Alike 3.0 Germany";
                }
                case CC_BY_SA_3_0_IGO: {
                    return "Creative Commons Attribution-ShareAlike 3.0 IGO";
                }
                case CC_BY_SA_4_0: {
                    return "Creative Commons Attribution Share Alike 4.0 International";
                }
                case CC_PDDC: {
                    return "Creative Commons Public Domain Dedication and Certification";
                }
                case CC0_1_0: {
                    return "Creative Commons Zero v1.0 Universal";
                }
                case CDDL_1_0: {
                    return "Common Development and Distribution License 1.0";
                }
                case CDDL_1_1: {
                    return "Common Development and Distribution License 1.1";
                }
                case CDL_1_0: {
                    return "Common Documentation License 1.0";
                }
                case CDLA_PERMISSIVE_1_0: {
                    return "Community Data License Agreement Permissive 1.0";
                }
                case CDLA_PERMISSIVE_2_0: {
                    return "Community Data License Agreement Permissive 2.0";
                }
                case CDLA_SHARING_1_0: {
                    return "Community Data License Agreement Sharing 1.0";
                }
                case CECILL_1_0: {
                    return "CeCILL Free Software License Agreement v1.0";
                }
                case CECILL_1_1: {
                    return "CeCILL Free Software License Agreement v1.1";
                }
                case CECILL_2_0: {
                    return "CeCILL Free Software License Agreement v2.0";
                }
                case CECILL_2_1: {
                    return "CeCILL Free Software License Agreement v2.1";
                }
                case CECILL_B: {
                    return "CeCILL-B Free Software License Agreement";
                }
                case CECILL_C: {
                    return "CeCILL-C Free Software License Agreement";
                }
                case CERN_OHL_1_1: {
                    return "CERN Open Hardware Licence v1.1";
                }
                case CERN_OHL_1_2: {
                    return "CERN Open Hardware Licence v1.2";
                }
                case CERN_OHL_P_2_0: {
                    return "CERN Open Hardware Licence Version 2 - Permissive";
                }
                case CERN_OHL_S_2_0: {
                    return "CERN Open Hardware Licence Version 2 - Strongly Reciprocal";
                }
                case CERN_OHL_W_2_0: {
                    return "CERN Open Hardware Licence Version 2 - Weakly Reciprocal";
                }
                case CFITSIO: {
                    return "CFITSIO License";
                }
                case CHECKMK: {
                    return "Checkmk License";
                }
                case CLARTISTIC: {
                    return "Clarified Artistic License";
                }
                case CLIPS: {
                    return "Clips License";
                }
                case CMU_MACH: {
                    return "CMU Mach License";
                }
                case CNRI_JYTHON: {
                    return "CNRI Jython License";
                }
                case CNRI_PYTHON: {
                    return "CNRI Python License";
                }
                case CNRI_PYTHON_GPL_COMPATIBLE: {
                    return "CNRI Python Open Source GPL Compatible License Agreement";
                }
                case COIL_1_0: {
                    return "Copyfree Open Innovation License";
                }
                case COMMUNITY_SPEC_1_0: {
                    return "Community Specification License 1.0";
                }
                case CONDOR_1_1: {
                    return "Condor Public License v1.1";
                }
                case COPYLEFT_NEXT_0_3_0: {
                    return "copyleft-next 0.3.0";
                }
                case COPYLEFT_NEXT_0_3_1: {
                    return "copyleft-next 0.3.1";
                }
                case CORNELL_LOSSLESS_JPEG: {
                    return "Cornell Lossless JPEG License";
                }
                case CPAL_1_0: {
                    return "Common Public Attribution License 1.0";
                }
                case CPL_1_0: {
                    return "Common Public License 1.0";
                }
                case CPOL_1_02: {
                    return "Code Project Open License 1.02";
                }
                case CROSSWORD: {
                    return "Crossword License";
                }
                case CRYSTALSTACKER: {
                    return "CrystalStacker License";
                }
                case CUA_OPL_1_0: {
                    return "CUA Office Public License v1.0";
                }
                case CUBE: {
                    return "Cube License";
                }
                case CURL: {
                    return "curl License";
                }
                case D_FSL_1_0: {
                    return "Deutsche Freie Software Lizenz";
                }
                case DIFFMARK: {
                    return "diffmark license";
                }
                case DL_DE_BY_2_0: {
                    return "Data licence Germany \u2013 attribution \u2013 version 2.0";
                }
                case DOC: {
                    return "DOC License";
                }
                case DOTSEQN: {
                    return "Dotseqn License";
                }
                case DRL_1_0: {
                    return "Detection Rule License 1.0";
                }
                case DSDP: {
                    return "DSDP License";
                }
                case DTOA: {
                    return "David M. Gay dtoa License";
                }
                case DVIPDFM: {
                    return "dvipdfm License";
                }
                case ECL_1_0: {
                    return "Educational Community License v1.0";
                }
                case ECL_2_0: {
                    return "Educational Community License v2.0";
                }
                case ECOS_2_0: {
                    return "eCos license version 2.0";
                }
                case EFL_1_0: {
                    return "Eiffel Forum License v1.0";
                }
                case EFL_2_0: {
                    return "Eiffel Forum License v2.0";
                }
                case EGENIX: {
                    return "eGenix.com Public License 1.1.0";
                }
                case ELASTIC_2_0: {
                    return "Elastic License 2.0";
                }
                case ENTESSA: {
                    return "Entessa Public License v1.0";
                }
                case EPICS: {
                    return "EPICS Open License";
                }
                case EPL_1_0: {
                    return "Eclipse Public License 1.0";
                }
                case EPL_2_0: {
                    return "Eclipse Public License 2.0";
                }
                case ERLPL_1_1: {
                    return "Erlang Public License v1.1";
                }
                case ETALAB_2_0: {
                    return "Etalab Open License 2.0";
                }
                case EUDATAGRID: {
                    return "EU DataGrid Software License";
                }
                case EUPL_1_0: {
                    return "European Union Public License 1.0";
                }
                case EUPL_1_1: {
                    return "European Union Public License 1.1";
                }
                case EUPL_1_2: {
                    return "European Union Public License 1.2";
                }
                case EUROSYM: {
                    return "Eurosym License";
                }
                case FAIR: {
                    return "Fair License";
                }
                case FDK_AAC: {
                    return "Fraunhofer FDK AAC Codec Library";
                }
                case FRAMEWORX_1_0: {
                    return "Frameworx Open License 1.0";
                }
                case FREEBSD_DOC: {
                    return "FreeBSD Documentation License";
                }
                case FREEIMAGE: {
                    return "FreeImage Public License v1.0";
                }
                case FSFAP: {
                    return "FSF All Permissive License";
                }
                case FSFUL: {
                    return "FSF Unlimited License";
                }
                case FSFULLR: {
                    return "FSF Unlimited License (with License Retention)";
                }
                case FSFULLRWD: {
                    return "FSF Unlimited License (With License Retention and Warranty Disclaimer)";
                }
                case FTL: {
                    return "Freetype Project License";
                }
                case GD: {
                    return "GD License";
                }
                case GFDL_1_1: {
                    return "GNU Free Documentation License v1.1";
                }
                case GFDL_1_1_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.1 only - invariants";
                }
                case GFDL_1_1_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.1 or later - invariants";
                }
                case GFDL_1_1_NO_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.1 only - no invariants";
                }
                case GFDL_1_1_NO_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.1 or later - no invariants";
                }
                case GFDL_1_1_ONLY: {
                    return "GNU Free Documentation License v1.1 only";
                }
                case GFDL_1_1_OR_LATER: {
                    return "GNU Free Documentation License v1.1 or later";
                }
                case GFDL_1_2: {
                    return "GNU Free Documentation License v1.2";
                }
                case GFDL_1_2_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.2 only - invariants";
                }
                case GFDL_1_2_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.2 or later - invariants";
                }
                case GFDL_1_2_NO_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.2 only - no invariants";
                }
                case GFDL_1_2_NO_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.2 or later - no invariants";
                }
                case GFDL_1_2_ONLY: {
                    return "GNU Free Documentation License v1.2 only";
                }
                case GFDL_1_2_OR_LATER: {
                    return "GNU Free Documentation License v1.2 or later";
                }
                case GFDL_1_3: {
                    return "GNU Free Documentation License v1.3";
                }
                case GFDL_1_3_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.3 only - invariants";
                }
                case GFDL_1_3_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.3 or later - invariants";
                }
                case GFDL_1_3_NO_INVARIANTS_ONLY: {
                    return "GNU Free Documentation License v1.3 only - no invariants";
                }
                case GFDL_1_3_NO_INVARIANTS_OR_LATER: {
                    return "GNU Free Documentation License v1.3 or later - no invariants";
                }
                case GFDL_1_3_ONLY: {
                    return "GNU Free Documentation License v1.3 only";
                }
                case GFDL_1_3_OR_LATER: {
                    return "GNU Free Documentation License v1.3 or later";
                }
                case GIFTWARE: {
                    return "Giftware License";
                }
                case GL2PS: {
                    return "GL2PS License";
                }
                case GLIDE: {
                    return "3dfx Glide License";
                }
                case GLULXE: {
                    return "Glulxe License";
                }
                case GLWTPL: {
                    return "Good Luck With That Public License";
                }
                case GNUPLOT: {
                    return "gnuplot License";
                }
                case GPL_1_0: {
                    return "GNU General Public License v1.0 only";
                }
                case GPL_1_0PLUS: {
                    return "GNU General Public License v1.0 or later";
                }
                case GPL_1_0_ONLY: {
                    return "GNU General Public License v1.0 only";
                }
                case GPL_1_0_OR_LATER: {
                    return "GNU General Public License v1.0 or later";
                }
                case GPL_2_0: {
                    return "GNU General Public License v2.0 only";
                }
                case GPL_2_0PLUS: {
                    return "GNU General Public License v2.0 or later";
                }
                case GPL_2_0_ONLY: {
                    return "GNU General Public License v2.0 only";
                }
                case GPL_2_0_OR_LATER: {
                    return "GNU General Public License v2.0 or later";
                }
                case GPL_2_0_WITH_AUTOCONF_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Autoconf exception";
                }
                case GPL_2_0_WITH_BISON_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Bison exception";
                }
                case GPL_2_0_WITH_CLASSPATH_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Classpath exception";
                }
                case GPL_2_0_WITH_FONT_EXCEPTION: {
                    return "GNU General Public License v2.0 w/Font exception";
                }
                case GPL_2_0_WITH_GCC_EXCEPTION: {
                    return "GNU General Public License v2.0 w/GCC Runtime Library exception";
                }
                case GPL_3_0: {
                    return "GNU General Public License v3.0 only";
                }
                case GPL_3_0PLUS: {
                    return "GNU General Public License v3.0 or later";
                }
                case GPL_3_0_ONLY: {
                    return "GNU General Public License v3.0 only";
                }
                case GPL_3_0_OR_LATER: {
                    return "GNU General Public License v3.0 or later";
                }
                case GPL_3_0_WITH_AUTOCONF_EXCEPTION: {
                    return "GNU General Public License v3.0 w/Autoconf exception";
                }
                case GPL_3_0_WITH_GCC_EXCEPTION: {
                    return "GNU General Public License v3.0 w/GCC Runtime Library exception";
                }
                case GRAPHICS_GEMS: {
                    return "Graphics Gems License";
                }
                case GSOAP_1_3B: {
                    return "gSOAP Public License v1.3b";
                }
                case HASKELLREPORT: {
                    return "Haskell Language Report License";
                }
                case HIPPOCRATIC_2_1: {
                    return "Hippocratic License 2.1";
                }
                case HP_1986: {
                    return "Hewlett-Packard 1986 License";
                }
                case HPND: {
                    return "Historical Permission Notice and Disclaimer";
                }
                case HPND_EXPORT_US: {
                    return "HPND with US Government export control warning";
                }
                case HPND_MARKUS_KUHN: {
                    return "Historical Permission Notice and Disclaimer - Markus Kuhn variant";
                }
                case HPND_SELL_VARIANT: {
                    return "Historical Permission Notice and Disclaimer - sell variant";
                }
                case HPND_SELL_VARIANT_MIT_DISCLAIMER: {
                    return "HPND sell variant with MIT disclaimer";
                }
                case HTMLTIDY: {
                    return "HTML Tidy License";
                }
                case IBM_PIBS: {
                    return "IBM PowerPC Initialization and Boot Software";
                }
                case ICU: {
                    return "ICU License";
                }
                case IEC_CODE_COMPONENTS_EULA: {
                    return "IEC    Code Components End-user licence agreement";
                }
                case IJG: {
                    return "Independent JPEG Group License";
                }
                case IJG_SHORT: {
                    return "Independent JPEG Group License - short";
                }
                case IMAGEMAGICK: {
                    return "ImageMagick License";
                }
                case IMATIX: {
                    return "iMatix Standard Function Library Agreement";
                }
                case IMLIB2: {
                    return "Imlib2 License";
                }
                case INFO_ZIP: {
                    return "Info-ZIP License";
                }
                case INNER_NET_2_0: {
                    return "Inner Net License v2.0";
                }
                case INTEL: {
                    return "Intel Open Source License";
                }
                case INTEL_ACPI: {
                    return "Intel ACPI Software License Agreement";
                }
                case INTERBASE_1_0: {
                    return "Interbase Public License v1.0";
                }
                case IPA: {
                    return "IPA Font License";
                }
                case IPL_1_0: {
                    return "IBM Public License v1.0";
                }
                case ISC: {
                    return "ISC License";
                }
                case JAM: {
                    return "Jam License";
                }
                case JASPER_2_0: {
                    return "JasPer License";
                }
                case JPL_IMAGE: {
                    return "JPL Image Use Policy";
                }
                case JPNIC: {
                    return "Japan Network Information Center License";
                }
                case JSON: {
                    return "JSON License";
                }
                case KAZLIB: {
                    return "Kazlib License";
                }
                case KNUTH_CTAN: {
                    return "Knuth CTAN License";
                }
                case LAL_1_2: {
                    return "Licence Art Libre 1.2";
                }
                case LAL_1_3: {
                    return "Licence Art Libre 1.3";
                }
                case LATEX2E: {
                    return "Latex2e License";
                }
                case LATEX2E_TRANSLATED_NOTICE: {
                    return "Latex2e with translated notice permission";
                }
                case LEPTONICA: {
                    return "Leptonica License";
                }
                case LGPL_2_0: {
                    return "GNU Library General Public License v2 only";
                }
                case LGPL_2_0PLUS: {
                    return "GNU Library General Public License v2 or later";
                }
                case LGPL_2_0_ONLY: {
                    return "GNU Library General Public License v2 only";
                }
                case LGPL_2_0_OR_LATER: {
                    return "GNU Library General Public License v2 or later";
                }
                case LGPL_2_1: {
                    return "GNU Lesser General Public License v2.1 only";
                }
                case LGPL_2_1PLUS: {
                    return "GNU Lesser General Public License v2.1 or later";
                }
                case LGPL_2_1_ONLY: {
                    return "GNU Lesser General Public License v2.1 only";
                }
                case LGPL_2_1_OR_LATER: {
                    return "GNU Lesser General Public License v2.1 or later";
                }
                case LGPL_3_0: {
                    return "GNU Lesser General Public License v3.0 only";
                }
                case LGPL_3_0PLUS: {
                    return "GNU Lesser General Public License v3.0 or later";
                }
                case LGPL_3_0_ONLY: {
                    return "GNU Lesser General Public License v3.0 only";
                }
                case LGPL_3_0_OR_LATER: {
                    return "GNU Lesser General Public License v3.0 or later";
                }
                case LGPLLR: {
                    return "Lesser General Public License For Linguistic Resources";
                }
                case LIBPNG: {
                    return "libpng License";
                }
                case LIBPNG_2_0: {
                    return "PNG Reference Library version 2";
                }
                case LIBSELINUX_1_0: {
                    return "libselinux public domain notice";
                }
                case LIBTIFF: {
                    return "libtiff License";
                }
                case LIBUTIL_DAVID_NUGENT: {
                    return "libutil David Nugent License";
                }
                case LILIQ_P_1_1: {
                    return "Licence Libre du Qu\u00e9bec \u2013 Permissive version 1.1";
                }
                case LILIQ_R_1_1: {
                    return "Licence Libre du Qu\u00e9bec \u2013 R\u00e9ciprocit\u00e9 version 1.1";
                }
                case LILIQ_RPLUS_1_1: {
                    return "Licence Libre du Qu\u00e9bec \u2013 R\u00e9ciprocit\u00e9 forte version 1.1";
                }
                case LINUX_MAN_PAGES_1_PARA: {
                    return "Linux man-pages - 1 paragraph";
                }
                case LINUX_MAN_PAGES_COPYLEFT: {
                    return "Linux man-pages Copyleft";
                }
                case LINUX_MAN_PAGES_COPYLEFT_2_PARA: {
                    return "Linux man-pages Copyleft - 2 paragraphs";
                }
                case LINUX_MAN_PAGES_COPYLEFT_VAR: {
                    return "Linux man-pages Copyleft Variant";
                }
                case LINUX_OPENIB: {
                    return "Linux Kernel Variant of OpenIB.org license";
                }
                case LOOP: {
                    return "Common Lisp LOOP License";
                }
                case LPL_1_0: {
                    return "Lucent Public License Version 1.0";
                }
                case LPL_1_02: {
                    return "Lucent Public License v1.02";
                }
                case LPPL_1_0: {
                    return "LaTeX Project Public License v1.0";
                }
                case LPPL_1_1: {
                    return "LaTeX Project Public License v1.1";
                }
                case LPPL_1_2: {
                    return "LaTeX Project Public License v1.2";
                }
                case LPPL_1_3A: {
                    return "LaTeX Project Public License v1.3a";
                }
                case LPPL_1_3C: {
                    return "LaTeX Project Public License v1.3c";
                }
                case LZMA_SDK_9_11_TO_9_20: {
                    return "LZMA SDK License (versions 9.11 to 9.20)";
                }
                case LZMA_SDK_9_22: {
                    return "LZMA SDK License (versions 9.22 and beyond)";
                }
                case MAKEINDEX: {
                    return "MakeIndex License";
                }
                case MARTIN_BIRGMEIER: {
                    return "Martin Birgmeier License";
                }
                case METAMAIL: {
                    return "metamail License";
                }
                case MINPACK: {
                    return "Minpack License";
                }
                case MIROS: {
                    return "The MirOS Licence";
                }
                case MIT: {
                    return "MIT License";
                }
                case MIT_0: {
                    return "MIT No Attribution";
                }
                case MIT_ADVERTISING: {
                    return "Enlightenment License (e16)";
                }
                case MIT_CMU: {
                    return "CMU License";
                }
                case MIT_ENNA: {
                    return "enna License";
                }
                case MIT_FEH: {
                    return "feh License";
                }
                case MIT_FESTIVAL: {
                    return "MIT Festival Variant";
                }
                case MIT_MODERN_VARIANT: {
                    return "MIT License Modern Variant";
                }
                case MIT_OPEN_GROUP: {
                    return "MIT Open Group variant";
                }
                case MIT_WU: {
                    return "MIT Tom Wu Variant";
                }
                case MITNFA: {
                    return "MIT +no-false-attribs license";
                }
                case MOTOSOTO: {
                    return "Motosoto License";
                }
                case MPI_PERMISSIVE: {
                    return "mpi Permissive License";
                }
                case MPICH2: {
                    return "mpich2 License";
                }
                case MPL_1_0: {
                    return "Mozilla Public License 1.0";
                }
                case MPL_1_1: {
                    return "Mozilla Public License 1.1";
                }
                case MPL_2_0: {
                    return "Mozilla Public License 2.0";
                }
                case MPL_2_0_NO_COPYLEFT_EXCEPTION: {
                    return "Mozilla Public License 2.0 (no copyleft exception)";
                }
                case MPLUS: {
                    return "mplus Font License";
                }
                case MS_LPL: {
                    return "Microsoft Limited Public License";
                }
                case MS_PL: {
                    return "Microsoft Public License";
                }
                case MS_RL: {
                    return "Microsoft Reciprocal License";
                }
                case MTLL: {
                    return "Matrix Template Library License";
                }
                case MULANPSL_1_0: {
                    return "Mulan Permissive Software License, Version 1";
                }
                case MULANPSL_2_0: {
                    return "Mulan Permissive Software License, Version 2";
                }
                case MULTICS: {
                    return "Multics License";
                }
                case MUP: {
                    return "Mup License";
                }
                case NAIST_2003: {
                    return "Nara Institute of Science and Technology License (2003)";
                }
                case NASA_1_3: {
                    return "NASA Open Source Agreement 1.3";
                }
                case NAUMEN: {
                    return "Naumen Public License";
                }
                case NBPL_1_0: {
                    return "Net Boolean Public License v1";
                }
                case NCGL_UK_2_0: {
                    return "Non-Commercial Government Licence";
                }
                case NCSA: {
                    return "University of Illinois/NCSA Open Source License";
                }
                case NET_SNMP: {
                    return "Net-SNMP License";
                }
                case NETCDF: {
                    return "NetCDF license";
                }
                case NEWSLETR: {
                    return "Newsletr License";
                }
                case NGPL: {
                    return "Nethack General Public License";
                }
                case NICTA_1_0: {
                    return "NICTA Public Software License, Version 1.0";
                }
                case NIST_PD: {
                    return "NIST Public Domain Notice";
                }
                case NIST_PD_FALLBACK: {
                    return "NIST Public Domain Notice with license fallback";
                }
                case NIST_SOFTWARE: {
                    return "NIST Software License";
                }
                case NLOD_1_0: {
                    return "Norwegian Licence for Open Government Data (NLOD) 1.0";
                }
                case NLOD_2_0: {
                    return "Norwegian Licence for Open Government Data (NLOD) 2.0";
                }
                case NLPL: {
                    return "No Limit Public License";
                }
                case NOKIA: {
                    return "Nokia Open Source License";
                }
                case NOSL: {
                    return "Netizen Open Source License";
                }
                case NOT_OPEN_SOURCE: {
                    return "Not open source";
                }
                case NOWEB: {
                    return "Noweb License";
                }
                case NPL_1_0: {
                    return "Netscape Public License v1.0";
                }
                case NPL_1_1: {
                    return "Netscape Public License v1.1";
                }
                case NPOSL_3_0: {
                    return "Non-Profit Open Software License 3.0";
                }
                case NRL: {
                    return "NRL License";
                }
                case NTP: {
                    return "NTP License";
                }
                case NTP_0: {
                    return "NTP No Attribution";
                }
                case NUNIT: {
                    return "Nunit License";
                }
                case O_UDA_1_0: {
                    return "Open Use of Data Agreement v1.0";
                }
                case OCCT_PL: {
                    return "Open CASCADE Technology Public License";
                }
                case OCLC_2_0: {
                    return "OCLC Research Public License 2.0";
                }
                case ODBL_1_0: {
                    return "Open Data Commons Open Database License v1.0";
                }
                case ODC_BY_1_0: {
                    return "Open Data Commons Attribution License v1.0";
                }
                case OFFIS: {
                    return "OFFIS License";
                }
                case OFL_1_0: {
                    return "SIL Open Font License 1.0";
                }
                case OFL_1_0_NO_RFN: {
                    return "SIL Open Font License 1.0 with no Reserved Font Name";
                }
                case OFL_1_0_RFN: {
                    return "SIL Open Font License 1.0 with Reserved Font Name";
                }
                case OFL_1_1: {
                    return "SIL Open Font License 1.1";
                }
                case OFL_1_1_NO_RFN: {
                    return "SIL Open Font License 1.1 with no Reserved Font Name";
                }
                case OFL_1_1_RFN: {
                    return "SIL Open Font License 1.1 with Reserved Font Name";
                }
                case OGC_1_0: {
                    return "OGC Software License, Version 1.0";
                }
                case OGDL_TAIWAN_1_0: {
                    return "Taiwan Open Government Data License, version 1.0";
                }
                case OGL_CANADA_2_0: {
                    return "Open Government Licence - Canada";
                }
                case OGL_UK_1_0: {
                    return "Open Government Licence v1.0";
                }
                case OGL_UK_2_0: {
                    return "Open Government Licence v2.0";
                }
                case OGL_UK_3_0: {
                    return "Open Government Licence v3.0";
                }
                case OGTSL: {
                    return "Open Group Test Suite License";
                }
                case OLDAP_1_1: {
                    return "Open LDAP Public License v1.1";
                }
                case OLDAP_1_2: {
                    return "Open LDAP Public License v1.2";
                }
                case OLDAP_1_3: {
                    return "Open LDAP Public License v1.3";
                }
                case OLDAP_1_4: {
                    return "Open LDAP Public License v1.4";
                }
                case OLDAP_2_0: {
                    return "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)";
                }
                case OLDAP_2_0_1: {
                    return "Open LDAP Public License v2.0.1";
                }
                case OLDAP_2_1: {
                    return "Open LDAP Public License v2.1";
                }
                case OLDAP_2_2: {
                    return "Open LDAP Public License v2.2";
                }
                case OLDAP_2_2_1: {
                    return "Open LDAP Public License v2.2.1";
                }
                case OLDAP_2_2_2: {
                    return "Open LDAP Public License 2.2.2";
                }
                case OLDAP_2_3: {
                    return "Open LDAP Public License v2.3";
                }
                case OLDAP_2_4: {
                    return "Open LDAP Public License v2.4";
                }
                case OLDAP_2_5: {
                    return "Open LDAP Public License v2.5";
                }
                case OLDAP_2_6: {
                    return "Open LDAP Public License v2.6";
                }
                case OLDAP_2_7: {
                    return "Open LDAP Public License v2.7";
                }
                case OLDAP_2_8: {
                    return "Open LDAP Public License v2.8";
                }
                case OLFL_1_3: {
                    return "Open Logistics Foundation License Version 1.3";
                }
                case OML: {
                    return "Open Market License";
                }
                case OPENPBS_2_3: {
                    return "OpenPBS v2.3 Software License";
                }
                case OPENSSL: {
                    return "OpenSSL License";
                }
                case OPL_1_0: {
                    return "Open Public License v1.0";
                }
                case OPL_UK_3_0: {
                    return "United    Kingdom Open Parliament Licence v3.0";
                }
                case OPUBL_1_0: {
                    return "Open Publication License v1.0";
                }
                case OSET_PL_2_1: {
                    return "OSET Public License version 2.1";
                }
                case OSL_1_0: {
                    return "Open Software License 1.0";
                }
                case OSL_1_1: {
                    return "Open Software License 1.1";
                }
                case OSL_2_0: {
                    return "Open Software License 2.0";
                }
                case OSL_2_1: {
                    return "Open Software License 2.1";
                }
                case OSL_3_0: {
                    return "Open Software License 3.0";
                }
                case PARITY_6_0_0: {
                    return "The Parity Public License 6.0.0";
                }
                case PARITY_7_0_0: {
                    return "The Parity Public License 7.0.0";
                }
                case PDDL_1_0: {
                    return "Open Data Commons Public Domain Dedication & License 1.0";
                }
                case PHP_3_0: {
                    return "PHP License v3.0";
                }
                case PHP_3_01: {
                    return "PHP License v3.01";
                }
                case PLEXUS: {
                    return "Plexus Classworlds License";
                }
                case POLYFORM_NONCOMMERCIAL_1_0_0: {
                    return "PolyForm Noncommercial License 1.0.0";
                }
                case POLYFORM_SMALL_BUSINESS_1_0_0: {
                    return "PolyForm Small Business License 1.0.0";
                }
                case POSTGRESQL: {
                    return "PostgreSQL License";
                }
                case PSF_2_0: {
                    return "Python Software Foundation License 2.0";
                }
                case PSFRAG: {
                    return "psfrag License";
                }
                case PSUTILS: {
                    return "psutils License";
                }
                case PYTHON_2_0: {
                    return "Python License 2.0";
                }
                case PYTHON_2_0_1: {
                    return "Python License 2.0.1";
                }
                case QHULL: {
                    return "Qhull License";
                }
                case QPL_1_0: {
                    return "Q Public License 1.0";
                }
                case QPL_1_0_INRIA_2004: {
                    return "Q Public License 1.0 - INRIA 2004 variant";
                }
                case RDISC: {
                    return "Rdisc License";
                }
                case RHECOS_1_1: {
                    return "Red Hat eCos Public License v1.1";
                }
                case RPL_1_1: {
                    return "Reciprocal Public License 1.1";
                }
                case RPL_1_5: {
                    return "Reciprocal Public License 1.5";
                }
                case RPSL_1_0: {
                    return "RealNetworks Public Source License v1.0";
                }
                case RSA_MD: {
                    return "RSA Message-Digest License";
                }
                case RSCPL: {
                    return "Ricoh Source Code Public License";
                }
                case RUBY: {
                    return "Ruby License";
                }
                case SAX_PD: {
                    return "Sax Public Domain Notice";
                }
                case SAXPATH: {
                    return "Saxpath License";
                }
                case SCEA: {
                    return "SCEA Shared Source License";
                }
                case SCHEMEREPORT: {
                    return "Scheme Language Report License";
                }
                case SENDMAIL: {
                    return "Sendmail License";
                }
                case SENDMAIL_8_23: {
                    return "Sendmail License 8.23";
                }
                case SGI_B_1_0: {
                    return "SGI Free Software License B v1.0";
                }
                case SGI_B_1_1: {
                    return "SGI Free Software License B v1.1";
                }
                case SGI_B_2_0: {
                    return "SGI Free Software License B v2.0";
                }
                case SGP4: {
                    return "SGP4 Permission Notice";
                }
                case SHL_0_5: {
                    return "Solderpad Hardware License v0.5";
                }
                case SHL_0_51: {
                    return "Solderpad Hardware License, Version 0.51";
                }
                case SIMPL_2_0: {
                    return "Simple Public License 2.0";
                }
                case SISSL: {
                    return "Sun Industry Standards Source License v1.1";
                }
                case SISSL_1_2: {
                    return "Sun Industry Standards Source License v1.2";
                }
                case SLEEPYCAT: {
                    return "Sleepycat License";
                }
                case SMLNJ: {
                    return "Standard ML of New Jersey License";
                }
                case SMPPL: {
                    return "Secure Messaging Protocol Public License";
                }
                case SNIA: {
                    return "SNIA Public License 1.1";
                }
                case SNPRINTF: {
                    return "snprintf License";
                }
                case SPENCER_86: {
                    return "Spencer License 86";
                }
                case SPENCER_94: {
                    return "Spencer License 94";
                }
                case SPENCER_99: {
                    return "Spencer License 99";
                }
                case SPL_1_0: {
                    return "Sun Public License v1.0";
                }
                case SSH_OPENSSH: {
                    return "SSH OpenSSH license";
                }
                case SSH_SHORT: {
                    return "SSH short notice";
                }
                case SSPL_1_0: {
                    return "Server Side Public License, v 1";
                }
                case STANDARDML_NJ: {
                    return "Standard ML of New Jersey License";
                }
                case SUGARCRM_1_1_3: {
                    return "SugarCRM Public License v1.1.3";
                }
                case SUNPRO: {
                    return "SunPro License";
                }
                case SWL: {
                    return "Scheme Widget Library (SWL) Software License Agreement";
                }
                case SYMLINKS: {
                    return "Symlinks License";
                }
                case TAPR_OHL_1_0: {
                    return "TAPR Open Hardware License v1.0";
                }
                case TCL: {
                    return "TCL/TK License";
                }
                case TCP_WRAPPERS: {
                    return "TCP Wrappers License";
                }
                case TERMREADKEY: {
                    return "TermReadKey License";
                }
                case TMATE: {
                    return "TMate Open Source License";
                }
                case TORQUE_1_1: {
                    return "TORQUE v2.5+ Software License v1.1";
                }
                case TOSL: {
                    return "Trusster Open Source License";
                }
                case TPDL: {
                    return "Time::ParseDate License";
                }
                case TPL_1_0: {
                    return "THOR Public License 1.0";
                }
                case TTWL: {
                    return "Text-Tabs+Wrap License";
                }
                case TU_BERLIN_1_0: {
                    return "Technische Universitaet Berlin License 1.0";
                }
                case TU_BERLIN_2_0: {
                    return "Technische Universitaet Berlin License 2.0";
                }
                case UCAR: {
                    return "UCAR License";
                }
                case UCL_1_0: {
                    return "Upstream Compatibility License v1.0";
                }
                case UNICODE_DFS_2015: {
                    return "Unicode License Agreement - Data Files and Software (2015)";
                }
                case UNICODE_DFS_2016: {
                    return "Unicode License Agreement - Data Files and Software (2016)";
                }
                case UNICODE_TOU: {
                    return "Unicode Terms of Use";
                }
                case UNIXCRYPT: {
                    return "UnixCrypt License";
                }
                case UNLICENSE: {
                    return "The Unlicense";
                }
                case UPL_1_0: {
                    return "Universal Permissive License v1.0";
                }
                case VIM: {
                    return "Vim License";
                }
                case VOSTROM: {
                    return "VOSTROM Public License for Open Source";
                }
                case VSL_1_0: {
                    return "Vovida Software License v1.0";
                }
                case W3C: {
                    return "W3C Software Notice and License (2002-12-31)";
                }
                case W3C_19980720: {
                    return "W3C Software Notice and License (1998-07-20)";
                }
                case W3C_20150513: {
                    return "W3C Software Notice and Document License (2015-05-13)";
                }
                case W3M: {
                    return "w3m License";
                }
                case WATCOM_1_0: {
                    return "Sybase Open Watcom Public License 1.0";
                }
                case WIDGET_WORKSHOP: {
                    return "Widget Workshop License";
                }
                case WSUIPA: {
                    return "Wsuipa License";
                }
                case WTFPL: {
                    return "Do What The F*ck You Want To Public License";
                }
                case WXWINDOWS: {
                    return "wxWindows Library License";
                }
                case X11: {
                    return "X11 License";
                }
                case X11_DISTRIBUTE_MODIFICATIONS_VARIANT: {
                    return "X11 License Distribution Modification Variant";
                }
                case XDEBUG_1_03: {
                    return "Xdebug License v 1.03";
                }
                case XEROX: {
                    return "Xerox License";
                }
                case XFIG: {
                    return "Xfig License";
                }
                case XFREE86_1_1: {
                    return "XFree86 License 1.1";
                }
                case XINETD: {
                    return "xinetd License";
                }
                case XLOCK: {
                    return "xlock License";
                }
                case XNET: {
                    return "X.Net License";
                }
                case XPP: {
                    return "XPP License";
                }
                case XSKAT: {
                    return "XSkat License";
                }
                case YPL_1_0: {
                    return "Yahoo! Public License v1.0";
                }
                case YPL_1_1: {
                    return "Yahoo! Public License v1.1";
                }
                case ZED: {
                    return "Zed License";
                }
                case ZEND_2_0: {
                    return "Zend License v2.0";
                }
                case ZIMBRA_1_3: {
                    return "Zimbra Public License v1.3";
                }
                case ZIMBRA_1_4: {
                    return "Zimbra Public License v1.4";
                }
                case ZLIB: {
                    return "zlib License";
                }
                case ZLIB_ACKNOWLEDGEMENT: {
                    return "zlib/libpng License with Acknowledgement";
                }
                case ZPL_1_1: {
                    return "Zope Public License 1.1";
                }
                case ZPL_2_0: {
                    return "Zope Public License 2.0";
                }
                case ZPL_2_1: {
                    return "Zope Public License 2.1";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class GuideParameterCodeEnumFactory
    implements EnumFactory<GuideParameterCode> {
        @Override
        public GuideParameterCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("apply".equals(codeString)) {
                return GuideParameterCode.APPLY;
            }
            if ("path-resource".equals(codeString)) {
                return GuideParameterCode.PATHRESOURCE;
            }
            if ("path-pages".equals(codeString)) {
                return GuideParameterCode.PATHPAGES;
            }
            if ("path-tx-cache".equals(codeString)) {
                return GuideParameterCode.PATHTXCACHE;
            }
            if ("expansion-parameter".equals(codeString)) {
                return GuideParameterCode.EXPANSIONPARAMETER;
            }
            if ("rule-broken-links".equals(codeString)) {
                return GuideParameterCode.RULEBROKENLINKS;
            }
            if ("generate-xml".equals(codeString)) {
                return GuideParameterCode.GENERATEXML;
            }
            if ("generate-json".equals(codeString)) {
                return GuideParameterCode.GENERATEJSON;
            }
            if ("generate-turtle".equals(codeString)) {
                return GuideParameterCode.GENERATETURTLE;
            }
            if ("html-template".equals(codeString)) {
                return GuideParameterCode.HTMLTEMPLATE;
            }
            throw new IllegalArgumentException("Unknown GuideParameterCode code '" + codeString + "'");
        }

        public Enumeration<GuideParameterCode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.NULL, code);
            }
            if ("apply".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.APPLY, code);
            }
            if ("path-resource".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.PATHRESOURCE, code);
            }
            if ("path-pages".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.PATHPAGES, code);
            }
            if ("path-tx-cache".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.PATHTXCACHE, code);
            }
            if ("expansion-parameter".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.EXPANSIONPARAMETER, code);
            }
            if ("rule-broken-links".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.RULEBROKENLINKS, code);
            }
            if ("generate-xml".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.GENERATEXML, code);
            }
            if ("generate-json".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.GENERATEJSON, code);
            }
            if ("generate-turtle".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.GENERATETURTLE, code);
            }
            if ("html-template".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.HTMLTEMPLATE, code);
            }
            throw new FHIRException("Unknown GuideParameterCode code '" + codeString + "'");
        }

        @Override
        public String toCode(GuideParameterCode code) {
            if (code == GuideParameterCode.NULL) {
                return null;
            }
            if (code == GuideParameterCode.APPLY) {
                return "apply";
            }
            if (code == GuideParameterCode.PATHRESOURCE) {
                return "path-resource";
            }
            if (code == GuideParameterCode.PATHPAGES) {
                return "path-pages";
            }
            if (code == GuideParameterCode.PATHTXCACHE) {
                return "path-tx-cache";
            }
            if (code == GuideParameterCode.EXPANSIONPARAMETER) {
                return "expansion-parameter";
            }
            if (code == GuideParameterCode.RULEBROKENLINKS) {
                return "rule-broken-links";
            }
            if (code == GuideParameterCode.GENERATEXML) {
                return "generate-xml";
            }
            if (code == GuideParameterCode.GENERATEJSON) {
                return "generate-json";
            }
            if (code == GuideParameterCode.GENERATETURTLE) {
                return "generate-turtle";
            }
            if (code == GuideParameterCode.HTMLTEMPLATE) {
                return "html-template";
            }
            return "?";
        }

        @Override
        public String toSystem(GuideParameterCode code) {
            return code.getSystem();
        }
    }

    public static enum GuideParameterCode {
        APPLY,
        PATHRESOURCE,
        PATHPAGES,
        PATHTXCACHE,
        EXPANSIONPARAMETER,
        RULEBROKENLINKS,
        GENERATEXML,
        GENERATEJSON,
        GENERATETURTLE,
        HTMLTEMPLATE,
        NULL;


        public static GuideParameterCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("apply".equals(codeString)) {
                return APPLY;
            }
            if ("path-resource".equals(codeString)) {
                return PATHRESOURCE;
            }
            if ("path-pages".equals(codeString)) {
                return PATHPAGES;
            }
            if ("path-tx-cache".equals(codeString)) {
                return PATHTXCACHE;
            }
            if ("expansion-parameter".equals(codeString)) {
                return EXPANSIONPARAMETER;
            }
            if ("rule-broken-links".equals(codeString)) {
                return RULEBROKENLINKS;
            }
            if ("generate-xml".equals(codeString)) {
                return GENERATEXML;
            }
            if ("generate-json".equals(codeString)) {
                return GENERATEJSON;
            }
            if ("generate-turtle".equals(codeString)) {
                return GENERATETURTLE;
            }
            if ("html-template".equals(codeString)) {
                return HTMLTEMPLATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuideParameterCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case APPLY: {
                    return "apply";
                }
                case PATHRESOURCE: {
                    return "path-resource";
                }
                case PATHPAGES: {
                    return "path-pages";
                }
                case PATHTXCACHE: {
                    return "path-tx-cache";
                }
                case EXPANSIONPARAMETER: {
                    return "expansion-parameter";
                }
                case RULEBROKENLINKS: {
                    return "rule-broken-links";
                }
                case GENERATEXML: {
                    return "generate-xml";
                }
                case GENERATEJSON: {
                    return "generate-json";
                }
                case GENERATETURTLE: {
                    return "generate-turtle";
                }
                case HTMLTEMPLATE: {
                    return "html-template";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case APPLY: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case PATHRESOURCE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case PATHPAGES: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case PATHTXCACHE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case EXPANSIONPARAMETER: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case RULEBROKENLINKS: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case GENERATEXML: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case GENERATEJSON: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case GENERATETURTLE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case HTMLTEMPLATE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case APPLY: {
                    return "If the value of this string 0..* parameter is one of the metadata fields then all conformance resources will have any specified [Resource].[field] overwritten with the ImplementationGuide.[field], where field is one of: version, date, status, publisher, contact, copyright, experimental, jurisdiction, useContext.";
                }
                case PATHRESOURCE: {
                    return "The value of this string 0..* parameter is a subfolder of the build context's location that is to be scanned to load resources. Scope is (if present) a particular resource type.";
                }
                case PATHPAGES: {
                    return "The value of this string 0..1 parameter is a subfolder of the build context's location that contains files that are part of the html content processed by the builder.";
                }
                case PATHTXCACHE: {
                    return "The value of this string 0..1 parameter is a subfolder of the build context's location that is used as the terminology cache. If this is not present, the terminology cache is on the local system, not under version control.";
                }
                case EXPANSIONPARAMETER: {
                    return "The value of this string 0..* parameter is a parameter (name=value) when expanding value sets for this implementation guide. This is particularly used to specify the versions of published terminologies such as SNOMED CT.";
                }
                case RULEBROKENLINKS: {
                    return "The value of this string 0..1 parameter is either \"warning\" or \"error\" (default = \"error\"). If the value is \"warning\" then IG build tools allow the IG to be considered successfully build even when there is no internal broken links.";
                }
                case GENERATEXML: {
                    return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in XML format. If not present, the Publication Tool decides whether to generate XML.";
                }
                case GENERATEJSON: {
                    return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in JSON format. If not present, the Publication Tool decides whether to generate JSON.";
                }
                case GENERATETURTLE: {
                    return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in Turtle format. If not present, the Publication Tool decides whether to generate Turtle.";
                }
                case HTMLTEMPLATE: {
                    return "The value of this string singleton parameter is the name of the file to use as the builder template for each generated page (see templating).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case APPLY: {
                    return "Apply Metadata Value";
                }
                case PATHRESOURCE: {
                    return "Resource Path";
                }
                case PATHPAGES: {
                    return "Pages Path";
                }
                case PATHTXCACHE: {
                    return "Terminology Cache Path";
                }
                case EXPANSIONPARAMETER: {
                    return "Expansion Profile";
                }
                case RULEBROKENLINKS: {
                    return "Broken Links Rule";
                }
                case GENERATEXML: {
                    return "Generate XML";
                }
                case GENERATEJSON: {
                    return "Generate JSON";
                }
                case GENERATETURTLE: {
                    return "Generate Turtle";
                }
                case HTMLTEMPLATE: {
                    return "HTML Template";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class GuidePageGenerationEnumFactory
    implements EnumFactory<GuidePageGeneration> {
        @Override
        public GuidePageGeneration fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("html".equals(codeString)) {
                return GuidePageGeneration.HTML;
            }
            if ("markdown".equals(codeString)) {
                return GuidePageGeneration.MARKDOWN;
            }
            if ("xml".equals(codeString)) {
                return GuidePageGeneration.XML;
            }
            if ("generated".equals(codeString)) {
                return GuidePageGeneration.GENERATED;
            }
            throw new IllegalArgumentException("Unknown GuidePageGeneration code '" + codeString + "'");
        }

        public Enumeration<GuidePageGeneration> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.NULL, code);
            }
            if ("html".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.HTML, code);
            }
            if ("markdown".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.MARKDOWN, code);
            }
            if ("xml".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.XML, code);
            }
            if ("generated".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.GENERATED, code);
            }
            throw new FHIRException("Unknown GuidePageGeneration code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidePageGeneration code) {
            if (code == GuidePageGeneration.NULL) {
                return null;
            }
            if (code == GuidePageGeneration.HTML) {
                return "html";
            }
            if (code == GuidePageGeneration.MARKDOWN) {
                return "markdown";
            }
            if (code == GuidePageGeneration.XML) {
                return "xml";
            }
            if (code == GuidePageGeneration.GENERATED) {
                return "generated";
            }
            return "?";
        }

        @Override
        public String toSystem(GuidePageGeneration code) {
            return code.getSystem();
        }
    }

    public static enum GuidePageGeneration {
        HTML,
        MARKDOWN,
        XML,
        GENERATED,
        NULL;


        public static GuidePageGeneration fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("html".equals(codeString)) {
                return HTML;
            }
            if ("markdown".equals(codeString)) {
                return MARKDOWN;
            }
            if ("xml".equals(codeString)) {
                return XML;
            }
            if ("generated".equals(codeString)) {
                return GENERATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuidePageGeneration code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HTML: {
                    return "html";
                }
                case MARKDOWN: {
                    return "markdown";
                }
                case XML: {
                    return "xml";
                }
                case GENERATED: {
                    return "generated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HTML: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case MARKDOWN: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case XML: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case GENERATED: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HTML: {
                    return "Page is proper xhtml with no templating.  Will be brought across unchanged for standard post-processing.";
                }
                case MARKDOWN: {
                    return "Page is markdown with templating.  Will use the template to create a file that imports the markdown file prior to post-processing.";
                }
                case XML: {
                    return "Page is xml with templating.  Will use the template to create a file that imports the source file and run the nominated XSLT transform (see parameters) if present prior to post-processing.";
                }
                case GENERATED: {
                    return "Page will be generated by the publication process - no source to bring across.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HTML: {
                    return "HTML";
                }
                case MARKDOWN: {
                    return "Markdown";
                }
                case XML: {
                    return "XML";
                }
                case GENERATED: {
                    return "Generated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

