/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DateType;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubscriptionTopic", profile="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic")
public class SubscriptionTopic
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical canonical URL to reference this SubscriptionTopic (globally unique)", formalDefinition="An absolute URL that is used to identify this SubscriptionTopic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for SubscriptionTopic", formalDefinition="Business identifiers assigned to this SubscriptionTopic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the SubscriptionTopic", formalDefinition="The identifier that is used to identify this version of the SubscriptionTopic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.")
    protected StringType version;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this SubscriptionTopic (Human friendly)", formalDefinition="A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".")
    protected StringType title;
    @Child(name="derivedFrom", type={CanonicalType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on FHIR protocol or definition", formalDefinition="The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.")
    protected List<CanonicalType> derivedFrom;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the SubscriptionTopic.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date status first applied", formalDefinition="For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the individual or organization that published the SubscriptionTopic", formalDefinition="Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the SubscriptionTopic", formalDefinition="A free text natural language description of the Topic from the consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction of the SubscriptionTopic (if applicable)", formalDefinition="A jurisdiction in which the Topic is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this SubscriptionTopic is defined", formalDefinition="Explains why this Topic is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When SubscriptionTopic is/was approved by publisher", formalDefinition="The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date the Subscription Topic was last reviewed by the publisher", formalDefinition="The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effective date range for the SubscriptionTopic", formalDefinition="The period during which the SubscriptionTopic content was or is planned to be effective.")
    protected Period effectivePeriod;
    @Child(name="resourceTrigger", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Definition of a resource-based trigger for the subscription topic", formalDefinition="A definition of a resource-based event that triggers a notification based on the SubscriptionTopic. The criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression. Multiple triggers are considered OR joined (e.g., a resource update matching ANY of the definitions will trigger a notification).")
    protected List<SubscriptionTopicResourceTriggerComponent> resourceTrigger;
    @Child(name="eventTrigger", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Event definitions the SubscriptionTopic", formalDefinition="Event definition which can be used to trigger the SubscriptionTopic.")
    protected List<SubscriptionTopicEventTriggerComponent> eventTrigger;
    @Child(name="canFilterBy", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Properties by which a Subscription can filter notifications from the SubscriptionTopic", formalDefinition="List of properties by which Subscriptions on the SubscriptionTopic can be filtered. May be defined Search Parameters (e.g., Encounter.patient) or parameters defined within this SubscriptionTopic context (e.g., hub.event).")
    protected List<SubscriptionTopicCanFilterByComponent> canFilterBy;
    @Child(name="notificationShape", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Properties for describing the shape of notifications generated by this topic", formalDefinition="List of properties to describe the shape (e.g., resources) included in notifications from this Subscription Topic.")
    protected List<SubscriptionTopicNotificationShapeComponent> notificationShape;
    private static final long serialVersionUID = -1726252832L;
    @SearchParamDefinition(name="date", path="SubscriptionTopic.date", description="Date status first applied", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="derived-or-self", path="SubscriptionTopic.url | SubscriptionTopic.derivedFrom", description="A server defined search that matches either the url or derivedFrom", type="uri")
    public static final String SP_DERIVED_OR_SELF = "derived-or-self";
    public static final UriClientParam DERIVED_OR_SELF = new UriClientParam("derived-or-self");
    @SearchParamDefinition(name="identifier", path="SubscriptionTopic.identifier", description="Business Identifier for SubscriptionTopic", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="resource", path="SubscriptionTopic.resourceTrigger.resource", description="Allowed Data type or Resource (reference to definition) for this definition, searches resourceTrigger, eventTrigger, and notificationShape for matches.", type="uri")
    public static final String SP_RESOURCE = "resource";
    public static final UriClientParam RESOURCE = new UriClientParam("resource");
    @SearchParamDefinition(name="status", path="SubscriptionTopic.status", description="draft | active | retired | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="SubscriptionTopic.title", description="Name for this SubscriptionTopic (Human friendly)", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="trigger-description", path="SubscriptionTopic.resourceTrigger.description", description="Text representation of the trigger", type="string")
    public static final String SP_TRIGGER_DESCRIPTION = "trigger-description";
    public static final StringClientParam TRIGGER_DESCRIPTION = new StringClientParam("trigger-description");
    @SearchParamDefinition(name="url", path="SubscriptionTopic.url", description="Logical canonical URL to reference this SubscriptionTopic (globally unique)", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="SubscriptionTopic.version", description="Business version of the SubscriptionTopic", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public SubscriptionTopic() {
    }

    public SubscriptionTopic(String url, Enumerations.PublicationStatus status) {
        this.setUrl(url);
        this.setStatus(status);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public SubscriptionTopic setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public SubscriptionTopic setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public SubscriptionTopic setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public SubscriptionTopic addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public SubscriptionTopic setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public SubscriptionTopic setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public SubscriptionTopic setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public SubscriptionTopic setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        return this.derivedFrom;
    }

    public SubscriptionTopic setDerivedFrom(List<CanonicalType> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public SubscriptionTopic addDerivedFrom(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public boolean hasDerivedFrom(String value) {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFrom) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SubscriptionTopic setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public SubscriptionTopic setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public SubscriptionTopic setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public SubscriptionTopic setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public SubscriptionTopic setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public SubscriptionTopic setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public SubscriptionTopic setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public SubscriptionTopic setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public SubscriptionTopic setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public SubscriptionTopic addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public SubscriptionTopic setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public SubscriptionTopic setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    public SubscriptionTopic setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    public SubscriptionTopic addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public SubscriptionTopic setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public SubscriptionTopic addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public SubscriptionTopic setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public SubscriptionTopic setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public SubscriptionTopic setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public SubscriptionTopic setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public SubscriptionTopic setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public SubscriptionTopic setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public SubscriptionTopic setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public SubscriptionTopic setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public SubscriptionTopic setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<SubscriptionTopicResourceTriggerComponent> getResourceTrigger() {
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        return this.resourceTrigger;
    }

    public SubscriptionTopic setResourceTrigger(List<SubscriptionTopicResourceTriggerComponent> theResourceTrigger) {
        this.resourceTrigger = theResourceTrigger;
        return this;
    }

    public boolean hasResourceTrigger() {
        if (this.resourceTrigger == null) {
            return false;
        }
        for (SubscriptionTopicResourceTriggerComponent item : this.resourceTrigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicResourceTriggerComponent addResourceTrigger() {
        SubscriptionTopicResourceTriggerComponent t = new SubscriptionTopicResourceTriggerComponent();
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        this.resourceTrigger.add(t);
        return t;
    }

    public SubscriptionTopic addResourceTrigger(SubscriptionTopicResourceTriggerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        this.resourceTrigger.add(t);
        return this;
    }

    public SubscriptionTopicResourceTriggerComponent getResourceTriggerFirstRep() {
        if (this.getResourceTrigger().isEmpty()) {
            this.addResourceTrigger();
        }
        return this.getResourceTrigger().get(0);
    }

    public List<SubscriptionTopicEventTriggerComponent> getEventTrigger() {
        if (this.eventTrigger == null) {
            this.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
        }
        return this.eventTrigger;
    }

    public SubscriptionTopic setEventTrigger(List<SubscriptionTopicEventTriggerComponent> theEventTrigger) {
        this.eventTrigger = theEventTrigger;
        return this;
    }

    public boolean hasEventTrigger() {
        if (this.eventTrigger == null) {
            return false;
        }
        for (SubscriptionTopicEventTriggerComponent item : this.eventTrigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicEventTriggerComponent addEventTrigger() {
        SubscriptionTopicEventTriggerComponent t = new SubscriptionTopicEventTriggerComponent();
        if (this.eventTrigger == null) {
            this.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
        }
        this.eventTrigger.add(t);
        return t;
    }

    public SubscriptionTopic addEventTrigger(SubscriptionTopicEventTriggerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.eventTrigger == null) {
            this.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
        }
        this.eventTrigger.add(t);
        return this;
    }

    public SubscriptionTopicEventTriggerComponent getEventTriggerFirstRep() {
        if (this.getEventTrigger().isEmpty()) {
            this.addEventTrigger();
        }
        return this.getEventTrigger().get(0);
    }

    public List<SubscriptionTopicCanFilterByComponent> getCanFilterBy() {
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
        }
        return this.canFilterBy;
    }

    public SubscriptionTopic setCanFilterBy(List<SubscriptionTopicCanFilterByComponent> theCanFilterBy) {
        this.canFilterBy = theCanFilterBy;
        return this;
    }

    public boolean hasCanFilterBy() {
        if (this.canFilterBy == null) {
            return false;
        }
        for (SubscriptionTopicCanFilterByComponent item : this.canFilterBy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicCanFilterByComponent addCanFilterBy() {
        SubscriptionTopicCanFilterByComponent t = new SubscriptionTopicCanFilterByComponent();
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
        }
        this.canFilterBy.add(t);
        return t;
    }

    public SubscriptionTopic addCanFilterBy(SubscriptionTopicCanFilterByComponent t) {
        if (t == null) {
            return this;
        }
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
        }
        this.canFilterBy.add(t);
        return this;
    }

    public SubscriptionTopicCanFilterByComponent getCanFilterByFirstRep() {
        if (this.getCanFilterBy().isEmpty()) {
            this.addCanFilterBy();
        }
        return this.getCanFilterBy().get(0);
    }

    public List<SubscriptionTopicNotificationShapeComponent> getNotificationShape() {
        if (this.notificationShape == null) {
            this.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
        }
        return this.notificationShape;
    }

    public SubscriptionTopic setNotificationShape(List<SubscriptionTopicNotificationShapeComponent> theNotificationShape) {
        this.notificationShape = theNotificationShape;
        return this;
    }

    public boolean hasNotificationShape() {
        if (this.notificationShape == null) {
            return false;
        }
        for (SubscriptionTopicNotificationShapeComponent item : this.notificationShape) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicNotificationShapeComponent addNotificationShape() {
        SubscriptionTopicNotificationShapeComponent t = new SubscriptionTopicNotificationShapeComponent();
        if (this.notificationShape == null) {
            this.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
        }
        this.notificationShape.add(t);
        return t;
    }

    public SubscriptionTopic addNotificationShape(SubscriptionTopicNotificationShapeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notificationShape == null) {
            this.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
        }
        this.notificationShape.add(t);
        return this;
    }

    public SubscriptionTopicNotificationShapeComponent getNotificationShapeFirstRep() {
        if (this.getNotificationShape().isEmpty()) {
            this.addNotificationShape();
        }
        return this.getNotificationShape().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this SubscriptionTopic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this SubscriptionTopic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the SubscriptionTopic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".", 0, 1, this.title));
        children.add(new Property("derivedFrom", "canonical(SubscriptionTopic)", "The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property(SP_STATUS, "code", "The current state of the SubscriptionTopic.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date));
        children.add(new Property("publisher", "string", "Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the SubscriptionTopic content was or is planned to be effective.", 0, 1, this.effectivePeriod));
        children.add(new Property("resourceTrigger", "", "A definition of a resource-based event that triggers a notification based on the SubscriptionTopic. The criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression. Multiple triggers are considered OR joined (e.g., a resource update matching ANY of the definitions will trigger a notification).", 0, Integer.MAX_VALUE, this.resourceTrigger));
        children.add(new Property("eventTrigger", "", "Event definition which can be used to trigger the SubscriptionTopic.", 0, Integer.MAX_VALUE, this.eventTrigger));
        children.add(new Property("canFilterBy", "", "List of properties by which Subscriptions on the SubscriptionTopic can be filtered. May be defined Search Parameters (e.g., Encounter.patient) or parameters defined within this SubscriptionTopic context (e.g., hub.event).", 0, Integer.MAX_VALUE, this.canFilterBy));
        children.add(new Property("notificationShape", "", "List of properties to describe the shape (e.g., resources) included in notifications from this Subscription Topic.", 0, Integer.MAX_VALUE, this.notificationShape));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URL that is used to identify this SubscriptionTopic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this SubscriptionTopic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the SubscriptionTopic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".", 0, 1, this.title);
            }
            case 1077922663: {
                return new Property("derivedFrom", "canonical(SubscriptionTopic)", "The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the SubscriptionTopic.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property("publisher", "string", "Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the SubscriptionTopic content was or is planned to be effective.", 0, 1, this.effectivePeriod);
            }
            case -424927798: {
                return new Property("resourceTrigger", "", "A definition of a resource-based event that triggers a notification based on the SubscriptionTopic. The criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression. Multiple triggers are considered OR joined (e.g., a resource update matching ANY of the definitions will trigger a notification).", 0, Integer.MAX_VALUE, this.resourceTrigger);
            }
            case -151635522: {
                return new Property("eventTrigger", "", "Event definition which can be used to trigger the SubscriptionTopic.", 0, Integer.MAX_VALUE, this.eventTrigger);
            }
            case -1299519009: {
                return new Property("canFilterBy", "", "List of properties by which Subscriptions on the SubscriptionTopic can be filtered. May be defined Search Parameters (e.g., Encounter.patient) or parameters defined within this SubscriptionTopic context (e.g., hub.event).", 0, Integer.MAX_VALUE, this.canFilterBy);
            }
            case -1583369866: {
                return new Property("notificationShape", "", "List of properties to describe the shape (e.g., resources) included in notifications from this Subscription Topic.", 0, Integer.MAX_VALUE, this.notificationShape);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -424927798: {
                return this.resourceTrigger == null ? new Base[]{} : this.resourceTrigger.toArray(new Base[this.resourceTrigger.size()]);
            }
            case -151635522: {
                return this.eventTrigger == null ? new Base[]{} : this.eventTrigger.toArray(new Base[this.eventTrigger.size()]);
            }
            case -1299519009: {
                return this.canFilterBy == null ? new Base[]{} : this.canFilterBy.toArray(new Base[this.canFilterBy.size()]);
            }
            case -1583369866: {
                return this.notificationShape == null ? new Base[]{} : this.notificationShape.toArray(new Base[this.notificationShape.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -424927798: {
                this.getResourceTrigger().add((SubscriptionTopicResourceTriggerComponent)((Object)value));
                return value;
            }
            case -151635522: {
                this.getEventTrigger().add((SubscriptionTopicEventTriggerComponent)((Object)value));
                return value;
            }
            case -1299519009: {
                this.getCanFilterBy().add((SubscriptionTopicCanFilterByComponent)((Object)value));
                return value;
            }
            case -1583369866: {
                this.getNotificationShape().add((SubscriptionTopicNotificationShapeComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("publisher")) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("resourceTrigger")) {
            this.getResourceTrigger().add((SubscriptionTopicResourceTriggerComponent)((Object)value));
        } else if (name.equals("eventTrigger")) {
            this.getEventTrigger().add((SubscriptionTopicEventTriggerComponent)((Object)value));
        } else if (name.equals("canFilterBy")) {
            this.getCanFilterBy().add((SubscriptionTopicCanFilterByComponent)((Object)value));
        } else if (name.equals("notificationShape")) {
            this.getNotificationShape().add((SubscriptionTopicNotificationShapeComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().remove(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals("publisher")) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = null;
        } else if (name.equals("resourceTrigger")) {
            this.getResourceTrigger().remove((SubscriptionTopicResourceTriggerComponent)value);
        } else if (name.equals("eventTrigger")) {
            this.getEventTrigger().remove((SubscriptionTopicEventTriggerComponent)value);
        } else if (name.equals("canFilterBy")) {
            this.getCanFilterBy().remove((SubscriptionTopicCanFilterByComponent)value);
        } else if (name.equals("notificationShape")) {
            this.getNotificationShape().remove((SubscriptionTopicNotificationShapeComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1077922663: {
                return this.addDerivedFromElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -424927798: {
                return this.addResourceTrigger();
            }
            case -151635522: {
                return this.addEventTrigger();
            }
            case -1299519009: {
                return this.addCanFilterBy();
            }
            case -1583369866: {
                return this.addNotificationShape();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1077922663: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -424927798: {
                return new String[0];
            }
            case -151635522: {
                return new String[0];
            }
            case -1299519009: {
                return new String[0];
            }
            case -1583369866: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.title");
        }
        if (name.equals("derivedFrom")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.derivedFrom");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.date");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("resourceTrigger")) {
            return this.addResourceTrigger();
        }
        if (name.equals("eventTrigger")) {
            return this.addEventTrigger();
        }
        if (name.equals("canFilterBy")) {
            return this.addCanFilterBy();
        }
        if (name.equals("notificationShape")) {
            return this.addNotificationShape();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubscriptionTopic";
    }

    @Override
    public SubscriptionTopic copy() {
        SubscriptionTopic dst = new SubscriptionTopic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubscriptionTopic dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFrom) {
                dst.derivedFrom.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.resourceTrigger != null) {
            dst.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
            for (SubscriptionTopicResourceTriggerComponent subscriptionTopicResourceTriggerComponent : this.resourceTrigger) {
                dst.resourceTrigger.add(subscriptionTopicResourceTriggerComponent.copy());
            }
        }
        if (this.eventTrigger != null) {
            dst.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
            for (SubscriptionTopicEventTriggerComponent subscriptionTopicEventTriggerComponent : this.eventTrigger) {
                dst.eventTrigger.add(subscriptionTopicEventTriggerComponent.copy());
            }
        }
        if (this.canFilterBy != null) {
            dst.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
            for (SubscriptionTopicCanFilterByComponent subscriptionTopicCanFilterByComponent : this.canFilterBy) {
                dst.canFilterBy.add(subscriptionTopicCanFilterByComponent.copy());
            }
        }
        if (this.notificationShape != null) {
            dst.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
            for (SubscriptionTopicNotificationShapeComponent subscriptionTopicNotificationShapeComponent : this.notificationShape) {
                dst.notificationShape.add(subscriptionTopicNotificationShapeComponent.copy());
            }
        }
    }

    protected SubscriptionTopic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionTopic)) {
            return false;
        }
        SubscriptionTopic o = (SubscriptionTopic)other_;
        return SubscriptionTopic.compareDeep(this.url, o.url, true) && SubscriptionTopic.compareDeep(this.identifier, o.identifier, true) && SubscriptionTopic.compareDeep(this.version, o.version, true) && SubscriptionTopic.compareDeep(this.title, o.title, true) && SubscriptionTopic.compareDeep(this.derivedFrom, o.derivedFrom, true) && SubscriptionTopic.compareDeep(this.status, o.status, true) && SubscriptionTopic.compareDeep(this.experimental, o.experimental, true) && SubscriptionTopic.compareDeep(this.date, o.date, true) && SubscriptionTopic.compareDeep(this.publisher, o.publisher, true) && SubscriptionTopic.compareDeep(this.contact, o.contact, true) && SubscriptionTopic.compareDeep(this.description, o.description, true) && SubscriptionTopic.compareDeep(this.useContext, o.useContext, true) && SubscriptionTopic.compareDeep(this.jurisdiction, o.jurisdiction, true) && SubscriptionTopic.compareDeep(this.purpose, o.purpose, true) && SubscriptionTopic.compareDeep(this.copyright, o.copyright, true) && SubscriptionTopic.compareDeep(this.approvalDate, o.approvalDate, true) && SubscriptionTopic.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && SubscriptionTopic.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && SubscriptionTopic.compareDeep(this.resourceTrigger, o.resourceTrigger, true) && SubscriptionTopic.compareDeep(this.eventTrigger, o.eventTrigger, true) && SubscriptionTopic.compareDeep(this.canFilterBy, o.canFilterBy, true) && SubscriptionTopic.compareDeep(this.notificationShape, o.notificationShape, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionTopic)) {
            return false;
        }
        SubscriptionTopic o = (SubscriptionTopic)other_;
        return SubscriptionTopic.compareValues(this.url, o.url, true) && SubscriptionTopic.compareValues(this.version, o.version, true) && SubscriptionTopic.compareValues(this.title, o.title, true) && SubscriptionTopic.compareValues(this.derivedFrom, o.derivedFrom, true) && SubscriptionTopic.compareValues(this.status, o.status, true) && SubscriptionTopic.compareValues(this.experimental, o.experimental, true) && SubscriptionTopic.compareValues(this.date, o.date, true) && SubscriptionTopic.compareValues(this.publisher, o.publisher, true) && SubscriptionTopic.compareValues(this.description, o.description, true) && SubscriptionTopic.compareValues(this.purpose, o.purpose, true) && SubscriptionTopic.compareValues(this.copyright, o.copyright, true) && SubscriptionTopic.compareValues(this.approvalDate, o.approvalDate, true) && SubscriptionTopic.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.title, this.derivedFrom, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.resourceTrigger, this.eventTrigger, this.canFilterBy, this.notificationShape});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubscriptionTopic;
    }

    @Block
    public static class SubscriptionTopicNotificationShapeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resource", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL of the Resource that is the focus (main) resource in a notification shape", formalDefinition="URL of the Resource that is the type used in this shape. This is the \"focus\" of the topic (or one of them if there are more than one) and the root resource for this shape definition. It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected UriType resource;
        @Child(name="include", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Include directives, rooted in the resource for this shape", formalDefinition="Search-style _include directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.")
        protected List<StringType> include;
        @Child(name="revInclude", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Reverse include directives, rooted in the resource for this shape", formalDefinition="Search-style _revinclude directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.")
        protected List<StringType> revInclude;
        private static final long serialVersionUID = -1718592091L;

        public SubscriptionTopicNotificationShapeComponent() {
        }

        public SubscriptionTopicNotificationShapeComponent(String resource) {
            this.setResource(resource);
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicNotificationShapeComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicNotificationShapeComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicNotificationShapeComponent setResource(String value) {
            if (this.resource == null) {
                this.resource = new UriType();
            }
            this.resource.setValue(value);
            return this;
        }

        public List<StringType> getInclude() {
            if (this.include == null) {
                this.include = new ArrayList<StringType>();
            }
            return this.include;
        }

        public SubscriptionTopicNotificationShapeComponent setInclude(List<StringType> theInclude) {
            this.include = theInclude;
            return this;
        }

        public boolean hasInclude() {
            if (this.include == null) {
                return false;
            }
            for (StringType item : this.include) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addIncludeElement() {
            StringType t = new StringType();
            if (this.include == null) {
                this.include = new ArrayList<StringType>();
            }
            this.include.add(t);
            return t;
        }

        public SubscriptionTopicNotificationShapeComponent addInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.include == null) {
                this.include = new ArrayList<StringType>();
            }
            this.include.add(t);
            return this;
        }

        public boolean hasInclude(String value) {
            if (this.include == null) {
                return false;
            }
            for (StringType v : this.include) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getRevInclude() {
            if (this.revInclude == null) {
                this.revInclude = new ArrayList<StringType>();
            }
            return this.revInclude;
        }

        public SubscriptionTopicNotificationShapeComponent setRevInclude(List<StringType> theRevInclude) {
            this.revInclude = theRevInclude;
            return this;
        }

        public boolean hasRevInclude() {
            if (this.revInclude == null) {
                return false;
            }
            for (StringType item : this.revInclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addRevIncludeElement() {
            StringType t = new StringType();
            if (this.revInclude == null) {
                this.revInclude = new ArrayList<StringType>();
            }
            this.revInclude.add(t);
            return t;
        }

        public SubscriptionTopicNotificationShapeComponent addRevInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.revInclude == null) {
                this.revInclude = new ArrayList<StringType>();
            }
            this.revInclude.add(t);
            return this;
        }

        public boolean hasRevInclude(String value) {
            if (this.revInclude == null) {
                return false;
            }
            for (StringType v : this.revInclude) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this shape. This is the \"focus\" of the topic (or one of them if there are more than one) and the root resource for this shape definition. It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource));
            children.add(new Property("include", "string", "Search-style _include directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.include));
            children.add(new Property("revInclude", "string", "Search-style _revinclude directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.revInclude));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this shape. This is the \"focus\" of the topic (or one of them if there are more than one) and the root resource for this shape definition. It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource);
                }
                case 1942574248: {
                    return new Property("include", "string", "Search-style _include directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.include);
                }
                case 8439429: {
                    return new Property("revInclude", "string", "Search-style _revinclude directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.revInclude);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resource;
                    }
                    return baseArray;
                }
                case 1942574248: {
                    return this.include == null ? new Base[]{} : this.include.toArray(new Base[this.include.size()]);
                }
                case 8439429: {
                    return this.revInclude == null ? new Base[]{} : this.revInclude.toArray(new Base[this.revInclude.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
                case 1942574248: {
                    this.getInclude().add(TypeConvertor.castToString(value));
                    return value;
                }
                case 8439429: {
                    this.getRevInclude().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else if (name.equals("include")) {
                this.getInclude().add(TypeConvertor.castToString(value));
            } else if (name.equals("revInclude")) {
                this.getRevInclude().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = null;
            } else if (name.equals("include")) {
                this.getInclude().remove(value);
            } else if (name.equals("revInclude")) {
                this.getRevInclude().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return this.getResourceElement();
                }
                case 1942574248: {
                    return this.addIncludeElement();
                }
                case 8439429: {
                    return this.addRevIncludeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return new String[]{"uri"};
                }
                case 1942574248: {
                    return new String[]{"string"};
                }
                case 8439429: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.notificationShape.resource");
            }
            if (name.equals("include")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.notificationShape.include");
            }
            if (name.equals("revInclude")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.notificationShape.revInclude");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicNotificationShapeComponent copy() {
            SubscriptionTopicNotificationShapeComponent dst = new SubscriptionTopicNotificationShapeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicNotificationShapeComponent dst) {
            super.copyValues(dst);
            UriType uriType = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.include != null) {
                dst.include = new ArrayList<StringType>();
                for (StringType i : this.include) {
                    dst.include.add(i.copy());
                }
            }
            if (this.revInclude != null) {
                dst.revInclude = new ArrayList<StringType>();
                for (StringType i : this.revInclude) {
                    dst.revInclude.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicNotificationShapeComponent)) {
                return false;
            }
            SubscriptionTopicNotificationShapeComponent o = (SubscriptionTopicNotificationShapeComponent)other_;
            return SubscriptionTopicNotificationShapeComponent.compareDeep(this.resource, o.resource, true) && SubscriptionTopicNotificationShapeComponent.compareDeep(this.include, o.include, true) && SubscriptionTopicNotificationShapeComponent.compareDeep(this.revInclude, o.revInclude, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicNotificationShapeComponent)) {
                return false;
            }
            SubscriptionTopicNotificationShapeComponent o = (SubscriptionTopicNotificationShapeComponent)other_;
            return SubscriptionTopicNotificationShapeComponent.compareValues(this.resource, o.resource, true) && SubscriptionTopicNotificationShapeComponent.compareValues(this.include, o.include, true) && SubscriptionTopicNotificationShapeComponent.compareValues(this.revInclude, o.revInclude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.resource, this.include, this.revInclude});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.notificationShape";
        }
    }

    @Block
    public static class SubscriptionTopicCanFilterByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of this filter parameter", formalDefinition="Description of how this filtering parameter is intended to be used.")
        protected MarkdownType description;
        @Child(name="resource", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL of the triggering Resource that this filter applies to", formalDefinition="URL of the Resource that is the type used in this filter. This is the \"focus\" of the topic (or one of them if there are more than one). It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected UriType resource;
        @Child(name="filterParameter", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Resource Search Parameter or filter parameter defined in this topic that serves as filter key", formalDefinition="Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or topic-defined parameter (like \"hub.event\") which is a label for the filter.")
        protected StringType filterParameter;
        @Child(name="modifier", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="= | eq | ne | gt | lt | ge | le | sa | eb | ap | above | below | in | not-in | of-type", formalDefinition="Allowable operators to apply when determining matches (Search Modifiers).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-search-modifier")
        protected List<Enumeration<SubscriptionSearchModifier>> modifier;
        private static final long serialVersionUID = -2140856175L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setResource(String value) {
            if (Utilities.noString((String)value)) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new UriType();
                }
                this.resource.setValue(value);
            }
            return this;
        }

        public StringType getFilterParameterElement() {
            if (this.filterParameter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.filterParameter");
                }
                if (Configuration.doAutoCreate()) {
                    this.filterParameter = new StringType();
                }
            }
            return this.filterParameter;
        }

        public boolean hasFilterParameterElement() {
            return this.filterParameter != null && !this.filterParameter.isEmpty();
        }

        public boolean hasFilterParameter() {
            return this.filterParameter != null && !this.filterParameter.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setFilterParameterElement(StringType value) {
            this.filterParameter = value;
            return this;
        }

        public String getFilterParameter() {
            return this.filterParameter == null ? null : (String)this.filterParameter.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setFilterParameter(String value) {
            if (Utilities.noString((String)value)) {
                this.filterParameter = null;
            } else {
                if (this.filterParameter == null) {
                    this.filterParameter = new StringType();
                }
                this.filterParameter.setValue(value);
            }
            return this;
        }

        public List<Enumeration<SubscriptionSearchModifier>> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<SubscriptionSearchModifier>>();
            }
            return this.modifier;
        }

        public SubscriptionTopicCanFilterByComponent setModifier(List<Enumeration<SubscriptionSearchModifier>> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (Enumeration<SubscriptionSearchModifier> item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<SubscriptionSearchModifier> addModifierElement() {
            Enumeration<SubscriptionSearchModifier> t = new Enumeration<SubscriptionSearchModifier>(new SubscriptionSearchModifierEnumFactory());
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<SubscriptionSearchModifier>>();
            }
            this.modifier.add(t);
            return t;
        }

        public SubscriptionTopicCanFilterByComponent addModifier(SubscriptionSearchModifier value) {
            Enumeration<SubscriptionSearchModifier> t = new Enumeration<SubscriptionSearchModifier>(new SubscriptionSearchModifierEnumFactory());
            t.setValue((Object)value);
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<SubscriptionSearchModifier>>();
            }
            this.modifier.add(t);
            return this;
        }

        public boolean hasModifier(SubscriptionSearchModifier value) {
            if (this.modifier == null) {
                return false;
            }
            for (Enumeration<SubscriptionSearchModifier> v : this.modifier) {
                if (!((SubscriptionSearchModifier)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "Description of how this filtering parameter is intended to be used.", 0, 1, this.description));
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this filter. This is the \"focus\" of the topic (or one of them if there are more than one). It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource));
            children.add(new Property("filterParameter", "string", "Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or topic-defined parameter (like \"hub.event\") which is a label for the filter.", 0, 1, this.filterParameter));
            children.add(new Property("modifier", "code", "Allowable operators to apply when determining matches (Search Modifiers).", 0, Integer.MAX_VALUE, this.modifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "Description of how this filtering parameter is intended to be used.", 0, 1, this.description);
                }
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this filter. This is the \"focus\" of the topic (or one of them if there are more than one). It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource);
                }
                case 618257: {
                    return new Property("filterParameter", "string", "Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or topic-defined parameter (like \"hub.event\") which is a label for the filter.", 0, 1, this.filterParameter);
                }
                case -615513385: {
                    return new Property("modifier", "code", "Allowable operators to apply when determining matches (Search Modifiers).", 0, Integer.MAX_VALUE, this.modifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 618257: {
                    Base[] baseArray;
                    if (this.filterParameter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.filterParameter;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
                case 618257: {
                    this.filterParameter = TypeConvertor.castToString(value);
                    return value;
                }
                case -615513385: {
                    value = new SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getModifier().add(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else if (name.equals("filterParameter")) {
                this.filterParameter = TypeConvertor.castToString(value);
            } else if (name.equals("modifier")) {
                value = new SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getModifier().add(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = null;
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = null;
            } else if (name.equals("filterParameter")) {
                this.filterParameter = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove((Enumeration)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case 618257: {
                    return this.getFilterParameterElement();
                }
                case -615513385: {
                    return this.addModifierElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -341064690: {
                    return new String[]{"uri"};
                }
                case 618257: {
                    return new String[]{"string"};
                }
                case -615513385: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.canFilterBy.description");
            }
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.canFilterBy.resource");
            }
            if (name.equals("filterParameter")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.canFilterBy.filterParameter");
            }
            if (name.equals("modifier")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.canFilterBy.modifier");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicCanFilterByComponent copy() {
            SubscriptionTopicCanFilterByComponent dst = new SubscriptionTopicCanFilterByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicCanFilterByComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            StringType stringType = dst.filterParameter = this.filterParameter == null ? null : this.filterParameter.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<Enumeration<SubscriptionSearchModifier>>();
                for (Enumeration<SubscriptionSearchModifier> i : this.modifier) {
                    dst.modifier.add((Enumeration<SubscriptionSearchModifier>)i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicCanFilterByComponent)) {
                return false;
            }
            SubscriptionTopicCanFilterByComponent o = (SubscriptionTopicCanFilterByComponent)other_;
            return SubscriptionTopicCanFilterByComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.resource, o.resource, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.filterParameter, o.filterParameter, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.modifier, o.modifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicCanFilterByComponent)) {
                return false;
            }
            SubscriptionTopicCanFilterByComponent o = (SubscriptionTopicCanFilterByComponent)other_;
            return SubscriptionTopicCanFilterByComponent.compareValues(this.description, o.description, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.resource, o.resource, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.filterParameter, o.filterParameter, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.modifier, o.modifier, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.resource, this.filterParameter, this.modifier});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.canFilterBy";
        }
    }

    @Block
    public static class SubscriptionTopicEventTriggerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text representation of the event trigger", formalDefinition="The human readable description of an event to trigger a notification for the SubscriptionTopic - for example, \"Patient Admission, as defined in HL7v2 via message ADT^A01\". Multiple values are considered OR joined (e.g., matching any single event listed).")
        protected MarkdownType description;
        @Child(name="event", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event which can trigger a notification from the SubscriptionTopic", formalDefinition="A well-defined event which can be used to trigger notifications from the SubscriptionTopic.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0003")
        protected CodeableConcept event;
        @Child(name="resource", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Data Type or Resource (reference to definition) for this trigger definition", formalDefinition="URL of the Resource that is the focus type used in this event trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected UriType resource;
        private static final long serialVersionUID = 1818872110L;

        public SubscriptionTopicEventTriggerComponent() {
        }

        public SubscriptionTopicEventTriggerComponent(CodeableConcept event, String resource) {
            this.setEvent(event);
            this.setResource(resource);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicEventTriggerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicEventTriggerComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicEventTriggerComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getEvent() {
            if (this.event == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicEventTriggerComponent.event");
                }
                if (Configuration.doAutoCreate()) {
                    this.event = new CodeableConcept();
                }
            }
            return this.event;
        }

        public boolean hasEvent() {
            return this.event != null && !this.event.isEmpty();
        }

        public SubscriptionTopicEventTriggerComponent setEvent(CodeableConcept value) {
            this.event = value;
            return this;
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicEventTriggerComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicEventTriggerComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicEventTriggerComponent setResource(String value) {
            if (this.resource == null) {
                this.resource = new UriType();
            }
            this.resource.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "The human readable description of an event to trigger a notification for the SubscriptionTopic - for example, \"Patient Admission, as defined in HL7v2 via message ADT^A01\". Multiple values are considered OR joined (e.g., matching any single event listed).", 0, 1, this.description));
            children.add(new Property("event", "CodeableConcept", "A well-defined event which can be used to trigger notifications from the SubscriptionTopic.", 0, 1, this.event));
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the focus type used in this event trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "The human readable description of an event to trigger a notification for the SubscriptionTopic - for example, \"Patient Admission, as defined in HL7v2 via message ADT^A01\". Multiple values are considered OR joined (e.g., matching any single event listed).", 0, 1, this.description);
                }
                case 96891546: {
                    return new Property("event", "CodeableConcept", "A well-defined event which can be used to trigger notifications from the SubscriptionTopic.", 0, 1, this.event);
                }
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the focus type used in this event trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 96891546: {
                    Base[] baseArray;
                    if (this.event == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.event;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 96891546: {
                    this.event = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("event")) {
                this.event = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("event")) {
                this.event = null;
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 96891546: {
                    return this.getEvent();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 96891546: {
                    return new String[]{"CodeableConcept"};
                }
                case -341064690: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.eventTrigger.description");
            }
            if (name.equals("event")) {
                this.event = new CodeableConcept();
                return this.event;
            }
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.eventTrigger.resource");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicEventTriggerComponent copy() {
            SubscriptionTopicEventTriggerComponent dst = new SubscriptionTopicEventTriggerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicEventTriggerComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.event = this.event == null ? null : this.event.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicEventTriggerComponent)) {
                return false;
            }
            SubscriptionTopicEventTriggerComponent o = (SubscriptionTopicEventTriggerComponent)other_;
            return SubscriptionTopicEventTriggerComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicEventTriggerComponent.compareDeep(this.event, o.event, true) && SubscriptionTopicEventTriggerComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicEventTriggerComponent)) {
                return false;
            }
            SubscriptionTopicEventTriggerComponent o = (SubscriptionTopicEventTriggerComponent)other_;
            return SubscriptionTopicEventTriggerComponent.compareValues(this.description, o.description, true) && SubscriptionTopicEventTriggerComponent.compareValues(this.resource, o.resource, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.event, this.resource});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.eventTrigger";
        }
    }

    @Block
    public static class SubscriptionTopicResourceTriggerQueryCriteriaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="previous", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to previous resource state", formalDefinition="The FHIR query based rules are applied to the previous resource state (e.g., state before an update).")
        protected StringType previous;
        @Child(name="resultForCreate", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="test-passes | test-fails", formalDefinition="What behavior a server will exhibit if the previous state of a resource does NOT exist (e.g., prior to a create).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior")
        protected Enumeration<CriteriaNotExistsBehavior> resultForCreate;
        @Child(name="current", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to current resource state", formalDefinition="The FHIR query based rules are applied to the current resource state (e.g., state after an update).")
        protected StringType current;
        @Child(name="resultForDelete", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="test-passes | test-fails", formalDefinition="What behavior a server will exhibit if the current state of a resource does NOT exist (e.g., after a DELETE).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior")
        protected Enumeration<CriteriaNotExistsBehavior> resultForDelete;
        @Child(name="requireBoth", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Both must be true flag", formalDefinition="If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.")
        protected BooleanType requireBoth;
        private static final long serialVersionUID = -291746067L;

        public StringType getPreviousElement() {
            if (this.previous == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.previous");
                }
                if (Configuration.doAutoCreate()) {
                    this.previous = new StringType();
                }
            }
            return this.previous;
        }

        public boolean hasPreviousElement() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public boolean hasPrevious() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setPreviousElement(StringType value) {
            this.previous = value;
            return this;
        }

        public String getPrevious() {
            return this.previous == null ? null : (String)this.previous.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setPrevious(String value) {
            if (Utilities.noString((String)value)) {
                this.previous = null;
            } else {
                if (this.previous == null) {
                    this.previous = new StringType();
                }
                this.previous.setValue(value);
            }
            return this;
        }

        public Enumeration<CriteriaNotExistsBehavior> getResultForCreateElement() {
            if (this.resultForCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.resultForCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.resultForCreate = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
            }
            return this.resultForCreate;
        }

        public boolean hasResultForCreateElement() {
            return this.resultForCreate != null && !this.resultForCreate.isEmpty();
        }

        public boolean hasResultForCreate() {
            return this.resultForCreate != null && !this.resultForCreate.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForCreateElement(Enumeration<CriteriaNotExistsBehavior> value) {
            this.resultForCreate = value;
            return this;
        }

        public CriteriaNotExistsBehavior getResultForCreate() {
            return this.resultForCreate == null ? null : (CriteriaNotExistsBehavior)((Object)this.resultForCreate.getValue());
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForCreate(CriteriaNotExistsBehavior value) {
            if (value == null) {
                this.resultForCreate = null;
            } else {
                if (this.resultForCreate == null) {
                    this.resultForCreate = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
                this.resultForCreate.setValue((Object)value);
            }
            return this;
        }

        public StringType getCurrentElement() {
            if (this.current == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.current");
                }
                if (Configuration.doAutoCreate()) {
                    this.current = new StringType();
                }
            }
            return this.current;
        }

        public boolean hasCurrentElement() {
            return this.current != null && !this.current.isEmpty();
        }

        public boolean hasCurrent() {
            return this.current != null && !this.current.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setCurrentElement(StringType value) {
            this.current = value;
            return this;
        }

        public String getCurrent() {
            return this.current == null ? null : (String)this.current.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setCurrent(String value) {
            if (Utilities.noString((String)value)) {
                this.current = null;
            } else {
                if (this.current == null) {
                    this.current = new StringType();
                }
                this.current.setValue(value);
            }
            return this;
        }

        public Enumeration<CriteriaNotExistsBehavior> getResultForDeleteElement() {
            if (this.resultForDelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.resultForDelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.resultForDelete = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
            }
            return this.resultForDelete;
        }

        public boolean hasResultForDeleteElement() {
            return this.resultForDelete != null && !this.resultForDelete.isEmpty();
        }

        public boolean hasResultForDelete() {
            return this.resultForDelete != null && !this.resultForDelete.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForDeleteElement(Enumeration<CriteriaNotExistsBehavior> value) {
            this.resultForDelete = value;
            return this;
        }

        public CriteriaNotExistsBehavior getResultForDelete() {
            return this.resultForDelete == null ? null : (CriteriaNotExistsBehavior)((Object)this.resultForDelete.getValue());
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForDelete(CriteriaNotExistsBehavior value) {
            if (value == null) {
                this.resultForDelete = null;
            } else {
                if (this.resultForDelete == null) {
                    this.resultForDelete = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
                this.resultForDelete.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getRequireBothElement() {
            if (this.requireBoth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.requireBoth");
                }
                if (Configuration.doAutoCreate()) {
                    this.requireBoth = new BooleanType();
                }
            }
            return this.requireBoth;
        }

        public boolean hasRequireBothElement() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public boolean hasRequireBoth() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setRequireBothElement(BooleanType value) {
            this.requireBoth = value;
            return this;
        }

        public boolean getRequireBoth() {
            return this.requireBoth == null || this.requireBoth.isEmpty() ? false : (Boolean)this.requireBoth.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setRequireBoth(boolean value) {
            if (this.requireBoth == null) {
                this.requireBoth = new BooleanType();
            }
            this.requireBoth.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state (e.g., state before an update).", 0, 1, this.previous));
            children.add(new Property("resultForCreate", "code", "What behavior a server will exhibit if the previous state of a resource does NOT exist (e.g., prior to a create).", 0, 1, this.resultForCreate));
            children.add(new Property("current", "string", "The FHIR query based rules are applied to the current resource state (e.g., state after an update).", 0, 1, this.current));
            children.add(new Property("resultForDelete", "code", "What behavior a server will exhibit if the current state of a resource does NOT exist (e.g., after a DELETE).", 0, 1, this.resultForDelete));
            children.add(new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1273775369: {
                    return new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state (e.g., state before an update).", 0, 1, this.previous);
                }
                case -407976056: {
                    return new Property("resultForCreate", "code", "What behavior a server will exhibit if the previous state of a resource does NOT exist (e.g., prior to a create).", 0, 1, this.resultForCreate);
                }
                case 1126940025: {
                    return new Property("current", "string", "The FHIR query based rules are applied to the current resource state (e.g., state after an update).", 0, 1, this.current);
                }
                case -391140297: {
                    return new Property("resultForDelete", "code", "What behavior a server will exhibit if the current state of a resource does NOT exist (e.g., after a DELETE).", 0, 1, this.resultForDelete);
                }
                case 362116742: {
                    return new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    Base[] baseArray;
                    if (this.previous == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.previous;
                    }
                    return baseArray;
                }
                case -407976056: {
                    Base[] baseArray;
                    if (this.resultForCreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resultForCreate;
                    }
                    return baseArray;
                }
                case 1126940025: {
                    Base[] baseArray;
                    if (this.current == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.current;
                    }
                    return baseArray;
                }
                case -391140297: {
                    Base[] baseArray;
                    if (this.resultForDelete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.resultForDelete;
                    }
                    return baseArray;
                }
                case 362116742: {
                    Base[] baseArray;
                    if (this.requireBoth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.requireBoth;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    this.previous = TypeConvertor.castToString(value);
                    return value;
                }
                case -407976056: {
                    value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resultForCreate = value;
                    return value;
                }
                case 1126940025: {
                    this.current = TypeConvertor.castToString(value);
                    return value;
                }
                case -391140297: {
                    value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resultForDelete = value;
                    return value;
                }
                case 362116742: {
                    this.requireBoth = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("previous")) {
                this.previous = TypeConvertor.castToString(value);
            } else if (name.equals("resultForCreate")) {
                value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resultForCreate = value;
            } else if (name.equals("current")) {
                this.current = TypeConvertor.castToString(value);
            } else if (name.equals("resultForDelete")) {
                value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resultForDelete = value;
            } else if (name.equals("requireBoth")) {
                this.requireBoth = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("previous")) {
                this.previous = null;
            } else if (name.equals("resultForCreate")) {
                this.resultForCreate = null;
            } else if (name.equals("current")) {
                this.current = null;
            } else if (name.equals("resultForDelete")) {
                this.resultForDelete = null;
            } else if (name.equals("requireBoth")) {
                this.requireBoth = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return this.getPreviousElement();
                }
                case -407976056: {
                    return this.getResultForCreateElement();
                }
                case 1126940025: {
                    return this.getCurrentElement();
                }
                case -391140297: {
                    return this.getResultForDeleteElement();
                }
                case 362116742: {
                    return this.getRequireBothElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return new String[]{"string"};
                }
                case -407976056: {
                    return new String[]{"code"};
                }
                case 1126940025: {
                    return new String[]{"string"};
                }
                case -391140297: {
                    return new String[]{"code"};
                }
                case 362116742: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("previous")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.queryCriteria.previous");
            }
            if (name.equals("resultForCreate")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.queryCriteria.resultForCreate");
            }
            if (name.equals("current")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.queryCriteria.current");
            }
            if (name.equals("resultForDelete")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.queryCriteria.resultForDelete");
            }
            if (name.equals("requireBoth")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.queryCriteria.requireBoth");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerQueryCriteriaComponent copy() {
            SubscriptionTopicResourceTriggerQueryCriteriaComponent dst = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerQueryCriteriaComponent dst) {
            super.copyValues(dst);
            dst.previous = this.previous == null ? null : this.previous.copy();
            dst.resultForCreate = this.resultForCreate == null ? null : this.resultForCreate.copy();
            dst.current = this.current == null ? null : this.current.copy();
            dst.resultForDelete = this.resultForDelete == null ? null : this.resultForDelete.copy();
            dst.requireBoth = this.requireBoth == null ? null : this.requireBoth.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent o = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)other_;
            return SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.previous, o.previous, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.resultForCreate, o.resultForCreate, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.current, o.current, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.resultForDelete, o.resultForDelete, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent o = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)other_;
            return SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.previous, o.previous, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.resultForCreate, o.resultForCreate, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.current, o.current, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.resultForDelete, o.resultForDelete, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.previous, this.resultForCreate, this.current, this.resultForDelete, this.requireBoth});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger.queryCriteria";
        }
    }

    @Block
    public static class SubscriptionTopicResourceTriggerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text representation of the resource trigger", formalDefinition="The human readable description of this resource trigger for the SubscriptionTopic -  for example, \"An Encounter enters the 'in-progress' state\".")
        protected MarkdownType description;
        @Child(name="resource", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Data Type or Resource (reference to definition) for this trigger definition", formalDefinition="URL of the Resource that is the type used in this resource trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected UriType resource;
        @Child(name="supportedInteraction", type={CodeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="create | update | delete", formalDefinition="The FHIR RESTful interaction which can be used to trigger a notification for the SubscriptionTopic. Multiple values are considered OR joined (e.g., CREATE or UPDATE).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/interaction-trigger")
        protected List<Enumeration<InteractionTrigger>> supportedInteraction;
        @Child(name="queryCriteria", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Query based trigger rule", formalDefinition="The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.")
        protected SubscriptionTopicResourceTriggerQueryCriteriaComponent queryCriteria;
        @Child(name="fhirPathCriteria", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath based trigger rule", formalDefinition="The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.")
        protected StringType fhirPathCriteria;
        private static final long serialVersionUID = -1086940999L;

        public SubscriptionTopicResourceTriggerComponent() {
        }

        public SubscriptionTopicResourceTriggerComponent(String resource) {
            this.setResource(resource);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setResource(String value) {
            if (this.resource == null) {
                this.resource = new UriType();
            }
            this.resource.setValue(value);
            return this;
        }

        public List<Enumeration<InteractionTrigger>> getSupportedInteraction() {
            if (this.supportedInteraction == null) {
                this.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            return this.supportedInteraction;
        }

        public SubscriptionTopicResourceTriggerComponent setSupportedInteraction(List<Enumeration<InteractionTrigger>> theSupportedInteraction) {
            this.supportedInteraction = theSupportedInteraction;
            return this;
        }

        public boolean hasSupportedInteraction() {
            if (this.supportedInteraction == null) {
                return false;
            }
            for (Enumeration<InteractionTrigger> item : this.supportedInteraction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<InteractionTrigger> addSupportedInteractionElement() {
            Enumeration<InteractionTrigger> t = new Enumeration<InteractionTrigger>(new InteractionTriggerEnumFactory());
            if (this.supportedInteraction == null) {
                this.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            this.supportedInteraction.add(t);
            return t;
        }

        public SubscriptionTopicResourceTriggerComponent addSupportedInteraction(InteractionTrigger value) {
            Enumeration<InteractionTrigger> t = new Enumeration<InteractionTrigger>(new InteractionTriggerEnumFactory());
            t.setValue((Object)value);
            if (this.supportedInteraction == null) {
                this.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            this.supportedInteraction.add(t);
            return this;
        }

        public boolean hasSupportedInteraction(InteractionTrigger value) {
            if (this.supportedInteraction == null) {
                return false;
            }
            for (Enumeration<InteractionTrigger> v : this.supportedInteraction) {
                if (!((InteractionTrigger)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent getQueryCriteria() {
            if (this.queryCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.queryCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.queryCriteria = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
                }
            }
            return this.queryCriteria;
        }

        public boolean hasQueryCriteria() {
            return this.queryCriteria != null && !this.queryCriteria.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setQueryCriteria(SubscriptionTopicResourceTriggerQueryCriteriaComponent value) {
            this.queryCriteria = value;
            return this;
        }

        public StringType getFhirPathCriteriaElement() {
            if (this.fhirPathCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.fhirPathCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.fhirPathCriteria = new StringType();
                }
            }
            return this.fhirPathCriteria;
        }

        public boolean hasFhirPathCriteriaElement() {
            return this.fhirPathCriteria != null && !this.fhirPathCriteria.isEmpty();
        }

        public boolean hasFhirPathCriteria() {
            return this.fhirPathCriteria != null && !this.fhirPathCriteria.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setFhirPathCriteriaElement(StringType value) {
            this.fhirPathCriteria = value;
            return this;
        }

        public String getFhirPathCriteria() {
            return this.fhirPathCriteria == null ? null : (String)this.fhirPathCriteria.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setFhirPathCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.fhirPathCriteria = null;
            } else {
                if (this.fhirPathCriteria == null) {
                    this.fhirPathCriteria = new StringType();
                }
                this.fhirPathCriteria.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "The human readable description of this resource trigger for the SubscriptionTopic -  for example, \"An Encounter enters the 'in-progress' state\".", 0, 1, this.description));
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this resource trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource));
            children.add(new Property("supportedInteraction", "code", "The FHIR RESTful interaction which can be used to trigger a notification for the SubscriptionTopic. Multiple values are considered OR joined (e.g., CREATE or UPDATE).", 0, Integer.MAX_VALUE, this.supportedInteraction));
            children.add(new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.", 0, 1, this.queryCriteria));
            children.add(new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.fhirPathCriteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "The human readable description of this resource trigger for the SubscriptionTopic -  for example, \"An Encounter enters the 'in-progress' state\".", 0, 1, this.description);
                }
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this resource trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource);
                }
                case 1838450820: {
                    return new Property("supportedInteraction", "code", "The FHIR RESTful interaction which can be used to trigger a notification for the SubscriptionTopic. Multiple values are considered OR joined (e.g., CREATE or UPDATE).", 0, Integer.MAX_VALUE, this.supportedInteraction);
                }
                case -545123257: {
                    return new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.", 0, 1, this.queryCriteria);
                }
                case 1929785263: {
                    return new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.fhirPathCriteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 1838450820: {
                    return this.supportedInteraction == null ? new Base[]{} : this.supportedInteraction.toArray(new Base[this.supportedInteraction.size()]);
                }
                case -545123257: {
                    Base[] baseArray;
                    if (this.queryCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.queryCriteria;
                    }
                    return baseArray;
                }
                case 1929785263: {
                    Base[] baseArray;
                    if (this.fhirPathCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.fhirPathCriteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
                case 1838450820: {
                    value = new InteractionTriggerEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getSupportedInteraction().add(value);
                    return value;
                }
                case -545123257: {
                    this.queryCriteria = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)((Object)value);
                    return value;
                }
                case 1929785263: {
                    this.fhirPathCriteria = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else if (name.equals("supportedInteraction")) {
                value = new InteractionTriggerEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getSupportedInteraction().add(value);
            } else if (name.equals("queryCriteria")) {
                this.queryCriteria = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)((Object)value);
            } else if (name.equals("fhirPathCriteria")) {
                this.fhirPathCriteria = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = null;
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = null;
            } else if (name.equals("supportedInteraction")) {
                this.getSupportedInteraction().remove((Enumeration)value);
            } else if (name.equals("queryCriteria")) {
                this.queryCriteria = null;
            } else if (name.equals("fhirPathCriteria")) {
                this.fhirPathCriteria = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case 1838450820: {
                    return this.addSupportedInteractionElement();
                }
                case -545123257: {
                    return this.getQueryCriteria();
                }
                case 1929785263: {
                    return this.getFhirPathCriteriaElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -341064690: {
                    return new String[]{"uri"};
                }
                case 1838450820: {
                    return new String[]{"code"};
                }
                case -545123257: {
                    return new String[0];
                }
                case 1929785263: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.description");
            }
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.resource");
            }
            if (name.equals("supportedInteraction")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.supportedInteraction");
            }
            if (name.equals("queryCriteria")) {
                this.queryCriteria = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
                return this.queryCriteria;
            }
            if (name.equals("fhirPathCriteria")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubscriptionTopic.resourceTrigger.fhirPathCriteria");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerComponent copy() {
            SubscriptionTopicResourceTriggerComponent dst = new SubscriptionTopicResourceTriggerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            UriType uriType = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.supportedInteraction != null) {
                dst.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
                for (Enumeration<InteractionTrigger> i : this.supportedInteraction) {
                    dst.supportedInteraction.add((Enumeration<InteractionTrigger>)i.copy());
                }
            }
            dst.queryCriteria = this.queryCriteria == null ? null : this.queryCriteria.copy();
            dst.fhirPathCriteria = this.fhirPathCriteria == null ? null : this.fhirPathCriteria.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerComponent o = (SubscriptionTopicResourceTriggerComponent)other_;
            return SubscriptionTopicResourceTriggerComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.resource, o.resource, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.supportedInteraction, o.supportedInteraction, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.queryCriteria, o.queryCriteria, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerComponent o = (SubscriptionTopicResourceTriggerComponent)other_;
            return SubscriptionTopicResourceTriggerComponent.compareValues(this.description, o.description, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.resource, o.resource, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.supportedInteraction, o.supportedInteraction, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.resource, this.supportedInteraction, this.queryCriteria, this.fhirPathCriteria});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger";
        }
    }

    public static class SubscriptionSearchModifierEnumFactory
    implements EnumFactory<SubscriptionSearchModifier> {
        @Override
        public SubscriptionSearchModifier fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("=".equals(codeString)) {
                return SubscriptionSearchModifier.EQUAL;
            }
            if ("eq".equals(codeString)) {
                return SubscriptionSearchModifier.EQ;
            }
            if ("ne".equals(codeString)) {
                return SubscriptionSearchModifier.NE;
            }
            if ("gt".equals(codeString)) {
                return SubscriptionSearchModifier.GT;
            }
            if ("lt".equals(codeString)) {
                return SubscriptionSearchModifier.LT;
            }
            if ("ge".equals(codeString)) {
                return SubscriptionSearchModifier.GE;
            }
            if ("le".equals(codeString)) {
                return SubscriptionSearchModifier.LE;
            }
            if ("sa".equals(codeString)) {
                return SubscriptionSearchModifier.SA;
            }
            if ("eb".equals(codeString)) {
                return SubscriptionSearchModifier.EB;
            }
            if ("ap".equals(codeString)) {
                return SubscriptionSearchModifier.AP;
            }
            if ("above".equals(codeString)) {
                return SubscriptionSearchModifier.ABOVE;
            }
            if ("below".equals(codeString)) {
                return SubscriptionSearchModifier.BELOW;
            }
            if ("in".equals(codeString)) {
                return SubscriptionSearchModifier.IN;
            }
            if ("not-in".equals(codeString)) {
                return SubscriptionSearchModifier.NOTIN;
            }
            if ("of-type".equals(codeString)) {
                return SubscriptionSearchModifier.OFTYPE;
            }
            throw new IllegalArgumentException("Unknown SubscriptionSearchModifier code '" + codeString + "'");
        }

        public Enumeration<SubscriptionSearchModifier> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.NULL, code);
            }
            if ("=".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.EQUAL, code);
            }
            if ("eq".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.EQ, code);
            }
            if ("ne".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.NE, code);
            }
            if ("gt".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.GT, code);
            }
            if ("lt".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.LT, code);
            }
            if ("ge".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.GE, code);
            }
            if ("le".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.LE, code);
            }
            if ("sa".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.SA, code);
            }
            if ("eb".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.EB, code);
            }
            if ("ap".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.AP, code);
            }
            if ("above".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.ABOVE, code);
            }
            if ("below".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.BELOW, code);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.IN, code);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.NOTIN, code);
            }
            if ("of-type".equals(codeString)) {
                return new Enumeration<SubscriptionSearchModifier>(this, SubscriptionSearchModifier.OFTYPE, code);
            }
            throw new FHIRException("Unknown SubscriptionSearchModifier code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionSearchModifier code) {
            if (code == SubscriptionSearchModifier.NULL) {
                return null;
            }
            if (code == SubscriptionSearchModifier.EQUAL) {
                return "=";
            }
            if (code == SubscriptionSearchModifier.EQ) {
                return "eq";
            }
            if (code == SubscriptionSearchModifier.NE) {
                return "ne";
            }
            if (code == SubscriptionSearchModifier.GT) {
                return "gt";
            }
            if (code == SubscriptionSearchModifier.LT) {
                return "lt";
            }
            if (code == SubscriptionSearchModifier.GE) {
                return "ge";
            }
            if (code == SubscriptionSearchModifier.LE) {
                return "le";
            }
            if (code == SubscriptionSearchModifier.SA) {
                return "sa";
            }
            if (code == SubscriptionSearchModifier.EB) {
                return "eb";
            }
            if (code == SubscriptionSearchModifier.AP) {
                return "ap";
            }
            if (code == SubscriptionSearchModifier.ABOVE) {
                return "above";
            }
            if (code == SubscriptionSearchModifier.BELOW) {
                return "below";
            }
            if (code == SubscriptionSearchModifier.IN) {
                return "in";
            }
            if (code == SubscriptionSearchModifier.NOTIN) {
                return "not-in";
            }
            if (code == SubscriptionSearchModifier.OFTYPE) {
                return "of-type";
            }
            return "?";
        }

        @Override
        public String toSystem(SubscriptionSearchModifier code) {
            return code.getSystem();
        }
    }

    public static enum SubscriptionSearchModifier {
        EQUAL,
        EQ,
        NE,
        GT,
        LT,
        GE,
        LE,
        SA,
        EB,
        AP,
        ABOVE,
        BELOW,
        IN,
        NOTIN,
        OFTYPE,
        NULL;


        public static SubscriptionSearchModifier fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return EQUAL;
            }
            if ("eq".equals(codeString)) {
                return EQ;
            }
            if ("ne".equals(codeString)) {
                return NE;
            }
            if ("gt".equals(codeString)) {
                return GT;
            }
            if ("lt".equals(codeString)) {
                return LT;
            }
            if ("ge".equals(codeString)) {
                return GE;
            }
            if ("le".equals(codeString)) {
                return LE;
            }
            if ("sa".equals(codeString)) {
                return SA;
            }
            if ("eb".equals(codeString)) {
                return EB;
            }
            if ("ap".equals(codeString)) {
                return AP;
            }
            if ("above".equals(codeString)) {
                return ABOVE;
            }
            if ("below".equals(codeString)) {
                return BELOW;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            if ("of-type".equals(codeString)) {
                return OFTYPE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SubscriptionSearchModifier code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case EQ: {
                    return "eq";
                }
                case NE: {
                    return "ne";
                }
                case GT: {
                    return "gt";
                }
                case LT: {
                    return "lt";
                }
                case GE: {
                    return "ge";
                }
                case LE: {
                    return "le";
                }
                case SA: {
                    return "sa";
                }
                case EB: {
                    return "eb";
                }
                case AP: {
                    return "ap";
                }
                case ABOVE: {
                    return "above";
                }
                case BELOW: {
                    return "below";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case OFTYPE: {
                    return "of-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQUAL: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case EQ: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case NE: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case GT: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case LT: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case GE: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case LE: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case SA: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case EB: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case AP: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case ABOVE: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case BELOW: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case IN: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case NOTIN: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case OFTYPE: {
                    return "http://terminology.hl7.org/CodeSystem/subscription-search-modifier";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQUAL: {
                    return "Used to match a value according to FHIR Search rules (e.g., Patient/123, Encounter/2002).";
                }
                case EQ: {
                    return "The value for the parameter in the resource is equal to the provided value.";
                }
                case NE: {
                    return "The value for the parameter in the resource is not equal to the provided value.";
                }
                case GT: {
                    return "The value for the parameter in the resource is greater than the provided value.";
                }
                case LT: {
                    return "The value for the parameter in the resource is less than the provided value.";
                }
                case GE: {
                    return "The value for the parameter in the resource is greater or equal to the provided value.";
                }
                case LE: {
                    return "The value for the parameter in the resource is less or equal to the provided value.";
                }
                case SA: {
                    return "The value for the parameter in the resource starts after the provided value.";
                }
                case EB: {
                    return "The value for the parameter in the resource ends before the provided value.";
                }
                case AP: {
                    return "The value for the parameter in the resource is approximately the same to the provided value. Note that the recommended value for the approximation is 10% of the stated value (or for a date, 10% of the gap between now and the date), but systems may choose other values where appropriate.";
                }
                case ABOVE: {
                    return "The search parameter is a concept with the form [system]|[code], and the search parameter tests whether the coding in a resource subsumes the specified search code.";
                }
                case BELOW: {
                    return "The search parameter is a concept with the form [system]|[code], and the search parameter tests whether the coding in a resource is subsumed by the specified search code.";
                }
                case IN: {
                    return "The search parameter is a member of a Group or List, or the search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the value is present in the specified Group, List, or Value Set.";
                }
                case NOTIN: {
                    return "The search parameter is a member of a Group or List, or the search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the value is NOT present in the specified Group, List, or Value Set.";
                }
                case OFTYPE: {
                    return "The search parameter has the format system|code|value, where the system and code refer to a\u00a0Identifier.type.coding.system\u00a0and\u00a0.code, and match if any of the type codes match. All 3 parts must be present.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case EQ: {
                    return "Equal";
                }
                case NE: {
                    return "Not Equal";
                }
                case GT: {
                    return "Greater Than";
                }
                case LT: {
                    return "Less Than";
                }
                case GE: {
                    return "Greater Than or Equal";
                }
                case LE: {
                    return "Less Than or Equal";
                }
                case SA: {
                    return "Starts After";
                }
                case EB: {
                    return "Ends Before";
                }
                case AP: {
                    return "Approximately";
                }
                case ABOVE: {
                    return "Above";
                }
                case BELOW: {
                    return "Below";
                }
                case IN: {
                    return "In";
                }
                case NOTIN: {
                    return "Not In";
                }
                case OFTYPE: {
                    return "Of Type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class InteractionTriggerEnumFactory
    implements EnumFactory<InteractionTrigger> {
        @Override
        public InteractionTrigger fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return InteractionTrigger.CREATE;
            }
            if ("update".equals(codeString)) {
                return InteractionTrigger.UPDATE;
            }
            if ("delete".equals(codeString)) {
                return InteractionTrigger.DELETE;
            }
            throw new IllegalArgumentException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        public Enumeration<InteractionTrigger> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.NULL, code);
            }
            if ("create".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.CREATE, code);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.UPDATE, code);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.DELETE, code);
            }
            throw new FHIRException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        @Override
        public String toCode(InteractionTrigger code) {
            if (code == InteractionTrigger.NULL) {
                return null;
            }
            if (code == InteractionTrigger.CREATE) {
                return "create";
            }
            if (code == InteractionTrigger.UPDATE) {
                return "update";
            }
            if (code == InteractionTrigger.DELETE) {
                return "delete";
            }
            return "?";
        }

        @Override
        public String toSystem(InteractionTrigger code) {
            return code.getSystem();
        }
    }

    public static enum InteractionTrigger {
        CREATE,
        UPDATE,
        DELETE,
        NULL;


        public static InteractionTrigger fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "Create a new resource with a server assigned id.";
                }
                case UPDATE: {
                    return "Update an existing resource by its id (or create it if it is new).";
                }
                case DELETE: {
                    return "Delete a resource.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CriteriaNotExistsBehaviorEnumFactory
    implements EnumFactory<CriteriaNotExistsBehavior> {
        @Override
        public CriteriaNotExistsBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return CriteriaNotExistsBehavior.TESTPASSES;
            }
            if ("test-fails".equals(codeString)) {
                return CriteriaNotExistsBehavior.TESTFAILS;
            }
            throw new IllegalArgumentException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        public Enumeration<CriteriaNotExistsBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.NULL, code);
            }
            if ("test-passes".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.TESTPASSES, code);
            }
            if ("test-fails".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.TESTFAILS, code);
            }
            throw new FHIRException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(CriteriaNotExistsBehavior code) {
            if (code == CriteriaNotExistsBehavior.NULL) {
                return null;
            }
            if (code == CriteriaNotExistsBehavior.TESTPASSES) {
                return "test-passes";
            }
            if (code == CriteriaNotExistsBehavior.TESTFAILS) {
                return "test-fails";
            }
            return "?";
        }

        @Override
        public String toSystem(CriteriaNotExistsBehavior code) {
            return code.getSystem();
        }
    }

    public static enum CriteriaNotExistsBehavior {
        TESTPASSES,
        TESTFAILS,
        NULL;


        public static CriteriaNotExistsBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return TESTPASSES;
            }
            if ("test-fails".equals(codeString)) {
                return TESTFAILS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TESTPASSES: {
                    return "test-passes";
                }
                case TESTFAILS: {
                    return "test-fails";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TESTPASSES: {
                    return "http://hl7.org/fhir/subscriptiontopic-cr-behavior";
                }
                case TESTFAILS: {
                    return "http://hl7.org/fhir/subscriptiontopic-cr-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TESTPASSES: {
                    return "The requested conditional statement will pass if a matching state does not exist (e.g., previous state during create).";
                }
                case TESTFAILS: {
                    return "The requested conditional statement will fail if a matching state does not exist (e.g., previous state during create).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TESTPASSES: {
                    return "test passes";
                }
                case TESTFAILS: {
                    return "test fails";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

