/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.renderers.ResourceRenderer;
import org.hl7.fhir.r4b.renderers.utils.BaseWrappers;
import org.hl7.fhir.r4b.renderers.utils.RenderingContext;
import org.hl7.fhir.r4b.renderers.utils.Resolver;
import org.hl7.fhir.r4b.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r4b.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CanonicalPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@Deprecated
public abstract class TerminologyRenderer
extends ResourceRenderer {
    public TerminologyRenderer(RenderingContext context) {
        super(context);
    }

    public TerminologyRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((CanonicalResource)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        if (r.has("name")) {
            return r.children("name").get(0).getBase().primitiveValue();
        }
        return "??";
    }

    protected void addMapHeaders(XhtmlNode tr, List<UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        for (UsedConceptMap m : maps) {
            XhtmlNode td = tr.td();
            XhtmlNode b = td.b();
            XhtmlNode a = b.ah(this.getContext().getSpecificationLink() + m.getLink());
            a.addText(m.getDetails().getName());
            if (!m.getDetails().isDoDescription() || !m.getMap().hasDescription()) continue;
            this.addMarkdown(td, m.getMap().getDescription());
        }
    }

    protected String getHeader() {
        int i;
        for (i = 3; i <= this.getContext().getHeaderLevelContext(); ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    protected List<TargetElementComponentWrapper> findMappingsForCode(String code, ConceptMap map) {
        ArrayList<TargetElementComponentWrapper> mappings = new ArrayList<TargetElementComponentWrapper>();
        for (ConceptMap.ConceptMapGroupComponent g : map.getGroup()) {
            for (ConceptMap.SourceElementComponent c : g.getElement()) {
                if (!c.getCode().equals(code)) continue;
                for (ConceptMap.TargetElementComponent cc : c.getTarget()) {
                    mappings.add(new TargetElementComponentWrapper(g, cc));
                }
            }
        }
        return mappings;
    }

    protected String getCharForRelationship(ConceptMap.TargetElementComponent mapping) {
        if (!mapping.hasEquivalence()) {
            return "";
        }
        switch (mapping.getEquivalence()) {
            case EQUIVALENT: {
                return "~";
            }
            case WIDER: {
                return "<";
            }
            case NARROWER: {
                return ">";
            }
            case DISJOINT: {
                return "!=";
            }
        }
        return "?";
    }

    protected <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent inc, XhtmlNode li, T cs) {
        String spec;
        Object ref = null;
        boolean addHtml = true;
        if (cs != null) {
            ref = (String)cs.getUserData("external.url");
            if (Utilities.noString((String)ref)) {
                ref = (String)cs.getUserData("filename");
            } else {
                addHtml = false;
            }
            if (Utilities.noString((String)ref) && (ref = (String)cs.getUserData("path")) != null) {
                addHtml = false;
            }
        }
        if ((spec = this.getSpecialReference(inc.getSystem())) != null) {
            XhtmlNode a = li.ah(spec);
            a.code(inc.getSystem());
        } else if (cs != null && ref != null) {
            if (addHtml && !((String)ref).contains(".html")) {
                ref = (String)ref + ".html";
            }
            ref = this.context.fixReference((String)ref);
            XhtmlNode a = li.ah(((String)ref).replace("\\", "/"));
            a.code(inc.getSystem());
        } else {
            li.code(inc.getSystem());
        }
    }

    private String getSpecialReference(String system) {
        if ("http://snomed.info/sct".equals(system)) {
            return "http://www.snomed.org/";
        }
        if (Utilities.existsInList((String)system, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm", "http://ncimeta.nci.nih.gov", "http://fdasis.nlm.nih.gov", "http://www.radlex.org", "http://www.whocc.no/atc", "http://dicom.nema.org/resources/ontology/DCM", "http://www.genenames.org", "http://www.ensembl.org", "http://www.ncbi.nlm.nih.gov/nuccore", "http://www.ncbi.nlm.nih.gov/clinvar", "http://sequenceontology.org", "http://www.hgvs.org/mutnomen", "http://www.ncbi.nlm.nih.gov/projects/SNP", "http://cancer.sanger.ac.uk/cancergenome/projects/cosmic", "http://www.lrg-sequence.org", "http://www.omim.org", "http://www.ncbi.nlm.nih.gov/pubmed", "http://www.pharmgkb.org", "http://clinicaltrials.gov", "http://www.ebi.ac.uk/ipd/imgt/hla/"})) {
            return system;
        }
        return null;
    }

    protected XhtmlNode addTableHeaderRowStandard(XhtmlNode t, boolean hasHierarchy, boolean hasDisplay, boolean definitions, boolean comments, boolean version, boolean deprecated, List<CodeSystem.PropertyComponent> properties, List<String> langs, boolean doLangs) {
        XhtmlNode tr = t.tr();
        if (hasHierarchy) {
            tr.td().b().tx("Lvl");
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Code", this.getContext().getLang()));
        if (hasDisplay) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Display", this.getContext().getLang()));
        }
        if (definitions) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Definition", this.getContext().getLang()));
        }
        if (deprecated) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Deprecated", this.getContext().getLang()));
        }
        if (comments) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Comments", this.getContext().getLang()));
        }
        if (version) {
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Version", this.getContext().getLang()));
        }
        if (properties != null) {
            for (CodeSystem.PropertyComponent pc : properties) {
                String display = ToolingExtensions.getPresentation(pc, pc.getCodeElement());
                if ((display == null || display.equals(pc.getCode()) && pc.hasUri()) && (display = this.getDisplayForProperty(pc.getUri())) == null) {
                    display = pc.getCode();
                }
                tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", display, this.getContext().getLang()));
            }
        }
        if (doLangs) {
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
        }
        return tr;
    }

    protected String getDisplayForProperty(String uri) {
        CodeSystem cs;
        if (Utilities.noString((String)uri)) {
            return null;
        }
        String code = null;
        if (uri.contains("#")) {
            code = uri.substring(uri.indexOf("#") + 1);
            uri = uri.substring(0, uri.indexOf("#"));
        }
        if ((cs = this.getContext().getWorker().fetchCodeSystem(uri)) == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent cc = code == null ? null : CodeSystemUtilities.getCode(cs, code);
        return cc == null ? null : cc.getDisplay();
    }

    protected void AddVsRef(String value, XhtmlNode li) {
        Bundle.BundleEntryComponent be;
        Resource res = null;
        if (this.rcontext != null && (be = this.rcontext.resolve(value)) != null) {
            res = be.getResource();
        }
        if (res != null && !(res instanceof CanonicalResource)) {
            li.addText(value);
            return;
        }
        CanonicalResource vs = (CanonicalResource)res;
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(ValueSet.class, value);
        }
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(StructureDefinition.class, value);
        }
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(Questionnaire.class, value);
        }
        if (vs != null) {
            String ref = (String)vs.getUserData("path");
            XhtmlNode a = li.ah((ref = this.context.fixReference(ref)) == null ? "?ngen-11?" : ref.replace("\\", "/"));
            a.addText(value);
        } else {
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(value);
            if (cs != null) {
                String ref = (String)cs.getUserData("path");
                XhtmlNode a = li.ah((ref = this.context.fixReference(ref)) == null ? "?ngen-12?" : ref.replace("\\", "/"));
                a.addText(value);
            } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
                XhtmlNode a = li.ah(value);
                a.tx("SNOMED-CT");
            } else {
                li.addText(value);
            }
        }
    }

    protected String getDisplayForConcept(String canonical, String value) {
        CanonicalPair split = CanonicalPair.of((String)canonical);
        return this.getDisplayForConcept(split.getUrl(), split.getVersion(), value);
    }

    private String getDisplayForConcept(String system, String version, String value) {
        if (value == null || system == null) {
            return null;
        }
        IWorkerContext.ValidationResult cl = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions().withVersionFlexible(true), system, version, value, null);
        return cl == null ? null : cl.getDisplay();
    }

    public class ConceptMapRenderInstructions {
        private String name;
        private String url;
        private boolean doDescription;

        public ConceptMapRenderInstructions(String name, String url, boolean doDescription) {
            this.name = name;
            this.url = url;
            this.doDescription = doDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDoDescription() {
            return this.doDescription;
        }
    }

    public class UsedConceptMap {
        private ConceptMapRenderInstructions details;
        private String link;
        private ConceptMap map;

        public UsedConceptMap(ConceptMapRenderInstructions details, String link, ConceptMap map) {
            this.details = details;
            this.link = link;
            this.map = map;
        }

        public ConceptMapRenderInstructions getDetails() {
            return this.details;
        }

        public ConceptMap getMap() {
            return this.map;
        }

        public String getLink() {
            return this.link;
        }
    }

    protected class TargetElementComponentWrapper {
        protected ConceptMap.ConceptMapGroupComponent group;
        protected ConceptMap.TargetElementComponent comp;

        protected TargetElementComponentWrapper(ConceptMap.ConceptMapGroupComponent group, ConceptMap.TargetElementComponent comp) {
            this.group = group;
            this.comp = comp;
        }
    }
}

