package org.hl7.fhir.r4b.model;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Mon, Jun 13, 2022 17:19+0300 for FHIR v4.3.0

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.r4b.model.Enumerations.*;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Block;

/**
 * The definition and characteristics of a medicinal manufactured item, such as
 * a tablet or capsule, as contained in a packaged medicinal product.
 */
@ResourceDef(name = "ManufacturedItemDefinition", profile = "http://hl7.org/fhir/StructureDefinition/ManufacturedItemDefinition")
public class ManufacturedItemDefinition extends DomainResource {

  @Block()
  public static class ManufacturedItemDefinitionPropertyComponent extends BackboneElement
      implements IBaseBackboneElement {
    /**
     * A code expressing the type of characteristic.
     */
    @Child(name = "type", type = {
        CodeableConcept.class }, order = 1, min = 1, max = 1, modifier = false, summary = true)
    @Description(shortDefinition = "A code expressing the type of characteristic", formalDefinition = "A code expressing the type of characteristic.")
    protected CodeableConcept type;

    /**
     * A value for the characteristic.
     */
    @Child(name = "value", type = { CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class,
        Attachment.class }, order = 2, min = 0, max = 1, modifier = false, summary = true)
    @Description(shortDefinition = "A value for the characteristic", formalDefinition = "A value for the characteristic.")
    protected DataType value;

    private static final long serialVersionUID = -1659186716L;

    /**
     * Constructor
     */
    public ManufacturedItemDefinitionPropertyComponent() {
      super();
    }

    /**
     * Constructor
     */
    public ManufacturedItemDefinitionPropertyComponent(CodeableConcept type) {
      super();
      this.setType(type);
    }

    /**
     * @return {@link #type} (A code expressing the type of characteristic.)
     */
    public CodeableConcept getType() {
      if (this.type == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create ManufacturedItemDefinitionPropertyComponent.type");
        else if (Configuration.doAutoCreate())
          this.type = new CodeableConcept(); // cc
      return this.type;
    }

    public boolean hasType() {
      return this.type != null && !this.type.isEmpty();
    }

    /**
     * @param value {@link #type} (A code expressing the type of characteristic.)
     */
    public ManufacturedItemDefinitionPropertyComponent setType(CodeableConcept value) {
      this.type = value;
      return this;
    }

    /**
     * @return {@link #value} (A value for the characteristic.)
     */
    public DataType getValue() {
      return this.value;
    }

    /**
     * @return {@link #value} (A value for the characteristic.)
     */
    public CodeableConcept getValueCodeableConcept() throws FHIRException {
      if (this.value == null)
        this.value = new CodeableConcept();
      if (!(this.value instanceof CodeableConcept))
        throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but "
            + this.value.getClass().getName() + " was encountered");
      return (CodeableConcept) this.value;
    }

    public boolean hasValueCodeableConcept() {
      return this != null && this.value instanceof CodeableConcept;
    }

    /**
     * @return {@link #value} (A value for the characteristic.)
     */
    public Quantity getValueQuantity() throws FHIRException {
      if (this.value == null)
        this.value = new Quantity();
      if (!(this.value instanceof Quantity))
        throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName()
            + " was encountered");
      return (Quantity) this.value;
    }

    public boolean hasValueQuantity() {
      return this != null && this.value instanceof Quantity;
    }

    /**
     * @return {@link #value} (A value for the characteristic.)
     */
    public DateType getValueDateType() throws FHIRException {
      if (this.value == null)
        this.value = new DateType();
      if (!(this.value instanceof DateType))
        throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName()
            + " was encountered");
      return (DateType) this.value;
    }

    public boolean hasValueDateType() {
      return this != null && this.value instanceof DateType;
    }

    /**
     * @return {@link #value} (A value for the characteristic.)
     */
    public BooleanType getValueBooleanType() throws FHIRException {
      if (this.value == null)
        this.value = new BooleanType();
      if (!(this.value instanceof BooleanType))
        throw new FHIRException("Type mismatch: the type BooleanType was expected, but "
            + this.value.getClass().getName() + " was encountered");
      return (BooleanType) this.value;
    }

    public boolean hasValueBooleanType() {
      return this != null && this.value instanceof BooleanType;
    }

    /**
     * @return {@link #value} (A value for the characteristic.)
     */
    public Attachment getValueAttachment() throws FHIRException {
      if (this.value == null)
        this.value = new Attachment();
      if (!(this.value instanceof Attachment))
        throw new FHIRException("Type mismatch: the type Attachment was expected, but "
            + this.value.getClass().getName() + " was encountered");
      return (Attachment) this.value;
    }

    public boolean hasValueAttachment() {
      return this != null && this.value instanceof Attachment;
    }

    public boolean hasValue() {
      return this.value != null && !this.value.isEmpty();
    }

    /**
     * @param value {@link #value} (A value for the characteristic.)
     */
    public ManufacturedItemDefinitionPropertyComponent setValue(DataType value) {
      if (value != null && !(value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType
          || value instanceof BooleanType || value instanceof Attachment))
        throw new Error("Not the right type for ManufacturedItemDefinition.property.value[x]: " + value.fhirType());
      this.value = value;
      return this;
    }

    protected void listChildren(List<Property> children) {
      super.listChildren(children);
      children
          .add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, type));
      children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment",
          "A value for the characteristic.", 0, 1, value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
      switch (_hash) {
      case 3575610:
        /* type */ return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1,
            type);
      case -1410166417:
        /* value[x] */ return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment",
            "A value for the characteristic.", 0, 1, value);
      case 111972721:
        /* value */ return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment",
            "A value for the characteristic.", 0, 1, value);
      case 924902896:
        /* valueCodeableConcept */ return new Property("value[x]", "CodeableConcept", "A value for the characteristic.",
            0, 1, value);
      case -2029823716:
        /* valueQuantity */ return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, value);
      case -766192449:
        /* valueDate */ return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, value);
      case 733421943:
        /* valueBoolean */ return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, value);
      case -475566732:
        /* valueAttachment */ return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1,
            value);
      default:
        return super.getNamedProperty(_hash, _name, _checkValid);
      }

    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
      switch (hash) {
      case 3575610:
        /* type */ return this.type == null ? new Base[0] : new Base[] { this.type }; // CodeableConcept
      case 111972721:
        /* value */ return this.value == null ? new Base[0] : new Base[] { this.value }; // DataType
      default:
        return super.getProperty(hash, name, checkValid);
      }

    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
      switch (hash) {
      case 3575610: // type
        this.type = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
        return value;
      case 111972721: // value
        this.value = TypeConvertor.castToType(value); // DataType
        return value;
      default:
        return super.setProperty(hash, name, value);
      }

    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
      if (name.equals("type")) {
        this.type = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
      } else if (name.equals("value[x]")) {
        this.value = TypeConvertor.castToType(value); // DataType
      } else
        return super.setProperty(name, value);
      return value;
    }

  @Override
  public void removeChild(String name, Base value) throws FHIRException {
      if (name.equals("type")) {
        this.type = null;
      } else if (name.equals("value[x]")) {
        this.value = null;
      } else
        super.removeChild(name, value);
      
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
      switch (hash) {
      case 3575610:
        return getType();
      case -1410166417:
        return getValue();
      case 111972721:
        return getValue();
      default:
        return super.makeProperty(hash, name);
      }

    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
      switch (hash) {
      case 3575610:
        /* type */ return new String[] { "CodeableConcept" };
      case 111972721:
        /* value */ return new String[] { "CodeableConcept", "Quantity", "date", "boolean", "Attachment" };
      default:
        return super.getTypesForProperty(hash, name);
      }

    }

    @Override
    public Base addChild(String name) throws FHIRException {
      if (name.equals("type")) {
        this.type = new CodeableConcept();
        return this.type;
      } else if (name.equals("valueCodeableConcept")) {
        this.value = new CodeableConcept();
        return this.value;
      } else if (name.equals("valueQuantity")) {
        this.value = new Quantity();
        return this.value;
      } else if (name.equals("valueDate")) {
        this.value = new DateType();
        return this.value;
      } else if (name.equals("valueBoolean")) {
        this.value = new BooleanType();
        return this.value;
      } else if (name.equals("valueAttachment")) {
        this.value = new Attachment();
        return this.value;
      } else
        return super.addChild(name);
    }

    public ManufacturedItemDefinitionPropertyComponent copy() {
      ManufacturedItemDefinitionPropertyComponent dst = new ManufacturedItemDefinitionPropertyComponent();
      copyValues(dst);
      return dst;
    }

    public void copyValues(ManufacturedItemDefinitionPropertyComponent dst) {
      super.copyValues(dst);
      dst.type = type == null ? null : type.copy();
      dst.value = value == null ? null : value.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
      if (!super.equalsDeep(other_))
        return false;
      if (!(other_ instanceof ManufacturedItemDefinitionPropertyComponent))
        return false;
      ManufacturedItemDefinitionPropertyComponent o = (ManufacturedItemDefinitionPropertyComponent) other_;
      return compareDeep(type, o.type, true) && compareDeep(value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
      if (!super.equalsShallow(other_))
        return false;
      if (!(other_ instanceof ManufacturedItemDefinitionPropertyComponent))
        return false;
      ManufacturedItemDefinitionPropertyComponent o = (ManufacturedItemDefinitionPropertyComponent) other_;
      return true;
    }

    public boolean isEmpty() {
      return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(type, value);
    }

    public String fhirType() {
      return "ManufacturedItemDefinition.property";

    }

  }

  /**
   * Unique identifier.
   */
  @Child(name = "identifier", type = {
      Identifier.class }, order = 0, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "Unique identifier", formalDefinition = "Unique identifier.")
  protected List<Identifier> identifier;

  /**
   * The status of this item. Enables tracking the life-cycle of the content.
   */
  @Child(name = "status", type = { CodeType.class }, order = 1, min = 1, max = 1, modifier = true, summary = true)
  @Description(shortDefinition = "draft | active | retired | unknown", formalDefinition = "The status of this item. Enables tracking the life-cycle of the content.")
  @ca.uhn.fhir.model.api.annotation.Binding(valueSet = "http://hl7.org/fhir/ValueSet/publication-status")
  protected Enumeration<PublicationStatus> status;

  /**
   * Dose form as manufactured and before any transformation into the
   * pharmaceutical product.
   */
  @Child(name = "manufacturedDoseForm", type = {
      CodeableConcept.class }, order = 2, min = 1, max = 1, modifier = false, summary = true)
  @Description(shortDefinition = "Dose form as manufactured and before any transformation into the pharmaceutical product", formalDefinition = "Dose form as manufactured and before any transformation into the pharmaceutical product.")
  protected CodeableConcept manufacturedDoseForm;

  /**
   * The “real world” units in which the quantity of the manufactured item is
   * described.
   */
  @Child(name = "unitOfPresentation", type = {
      CodeableConcept.class }, order = 3, min = 0, max = 1, modifier = false, summary = true)
  @Description(shortDefinition = "The “real world” units in which the quantity of the manufactured item is described", formalDefinition = "The “real world” units in which the quantity of the manufactured item is described.")
  protected CodeableConcept unitOfPresentation;

  /**
   * Manufacturer of the item (Note that this should be named "manufacturer" but
   * it currently causes technical issues).
   */
  @Child(name = "manufacturer", type = {
      Organization.class }, order = 4, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues)", formalDefinition = "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).")
  protected List<Reference> manufacturer;

  /**
   * The ingredients of this manufactured item. This is only needed if the
   * ingredients are not specified by incoming references from the Ingredient
   * resource.
   */
  @Child(name = "ingredient", type = {
      CodeableConcept.class }, order = 5, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource", formalDefinition = "The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource.")
  protected List<CodeableConcept> ingredient;

  /**
   * General characteristics of this item.
   */
  @Child(name = "property", type = {}, order = 6, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "General characteristics of this item", formalDefinition = "General characteristics of this item.")
  protected List<ManufacturedItemDefinitionPropertyComponent> property;

  private static final long serialVersionUID = 1578434864L;

  /**
   * Constructor
   */
  public ManufacturedItemDefinition() {
    super();
  }

  /**
   * Constructor
   */
  public ManufacturedItemDefinition(PublicationStatus status, CodeableConcept manufacturedDoseForm) {
    super();
    this.setStatus(status);
    this.setManufacturedDoseForm(manufacturedDoseForm);
  }

  /**
   * @return {@link #identifier} (Unique identifier.)
   */
  public List<Identifier> getIdentifier() {
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    return this.identifier;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public ManufacturedItemDefinition setIdentifier(List<Identifier> theIdentifier) {
    this.identifier = theIdentifier;
    return this;
  }

  public boolean hasIdentifier() {
    if (this.identifier == null)
      return false;
    for (Identifier item : this.identifier)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Identifier addIdentifier() { // 3
    Identifier t = new Identifier();
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    this.identifier.add(t);
    return t;
  }

  public ManufacturedItemDefinition addIdentifier(Identifier t) { // 3
    if (t == null)
      return this;
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    this.identifier.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #identifier}, creating
   *         it if it does not already exist {3}
   */
  public Identifier getIdentifierFirstRep() {
    if (getIdentifier().isEmpty()) {
      addIdentifier();
    }
    return getIdentifier().get(0);
  }

  /**
   * @return {@link #status} (The status of this item. Enables tracking the
   *         life-cycle of the content.). This is the underlying object with id,
   *         value and extensions. The accessor "getStatus" gives direct access to
   *         the value
   */
  public Enumeration<PublicationStatus> getStatusElement() {
    if (this.status == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create ManufacturedItemDefinition.status");
      else if (Configuration.doAutoCreate())
        this.status = new Enumeration<PublicationStatus>(new PublicationStatusEnumFactory()); // bb
    return this.status;
  }

  public boolean hasStatusElement() {
    return this.status != null && !this.status.isEmpty();
  }

  public boolean hasStatus() {
    return this.status != null && !this.status.isEmpty();
  }

  /**
   * @param value {@link #status} (The status of this item. Enables tracking the
   *              life-cycle of the content.). This is the underlying object with
   *              id, value and extensions. The accessor "getStatus" gives direct
   *              access to the value
   */
  public ManufacturedItemDefinition setStatusElement(Enumeration<PublicationStatus> value) {
    this.status = value;
    return this;
  }

  /**
   * @return The status of this item. Enables tracking the life-cycle of the
   *         content.
   */
  public PublicationStatus getStatus() {
    return this.status == null ? null : this.status.getValue();
  }

  /**
   * @param value The status of this item. Enables tracking the life-cycle of the
   *              content.
   */
  public ManufacturedItemDefinition setStatus(PublicationStatus value) {
    if (this.status == null)
      this.status = new Enumeration<PublicationStatus>(new PublicationStatusEnumFactory());
    this.status.setValue(value);
    return this;
  }

  /**
   * @return {@link #manufacturedDoseForm} (Dose form as manufactured and before
   *         any transformation into the pharmaceutical product.)
   */
  public CodeableConcept getManufacturedDoseForm() {
    if (this.manufacturedDoseForm == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create ManufacturedItemDefinition.manufacturedDoseForm");
      else if (Configuration.doAutoCreate())
        this.manufacturedDoseForm = new CodeableConcept(); // cc
    return this.manufacturedDoseForm;
  }

  public boolean hasManufacturedDoseForm() {
    return this.manufacturedDoseForm != null && !this.manufacturedDoseForm.isEmpty();
  }

  /**
   * @param value {@link #manufacturedDoseForm} (Dose form as manufactured and
   *              before any transformation into the pharmaceutical product.)
   */
  public ManufacturedItemDefinition setManufacturedDoseForm(CodeableConcept value) {
    this.manufacturedDoseForm = value;
    return this;
  }

  /**
   * @return {@link #unitOfPresentation} (The “real world” units in which the
   *         quantity of the manufactured item is described.)
   */
  public CodeableConcept getUnitOfPresentation() {
    if (this.unitOfPresentation == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create ManufacturedItemDefinition.unitOfPresentation");
      else if (Configuration.doAutoCreate())
        this.unitOfPresentation = new CodeableConcept(); // cc
    return this.unitOfPresentation;
  }

  public boolean hasUnitOfPresentation() {
    return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
  }

  /**
   * @param value {@link #unitOfPresentation} (The “real world” units in which the
   *              quantity of the manufactured item is described.)
   */
  public ManufacturedItemDefinition setUnitOfPresentation(CodeableConcept value) {
    this.unitOfPresentation = value;
    return this;
  }

  /**
   * @return {@link #manufacturer} (Manufacturer of the item (Note that this
   *         should be named "manufacturer" but it currently causes technical
   *         issues).)
   */
  public List<Reference> getManufacturer() {
    if (this.manufacturer == null)
      this.manufacturer = new ArrayList<Reference>();
    return this.manufacturer;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public ManufacturedItemDefinition setManufacturer(List<Reference> theManufacturer) {
    this.manufacturer = theManufacturer;
    return this;
  }

  public boolean hasManufacturer() {
    if (this.manufacturer == null)
      return false;
    for (Reference item : this.manufacturer)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Reference addManufacturer() { // 3
    Reference t = new Reference();
    if (this.manufacturer == null)
      this.manufacturer = new ArrayList<Reference>();
    this.manufacturer.add(t);
    return t;
  }

  public ManufacturedItemDefinition addManufacturer(Reference t) { // 3
    if (t == null)
      return this;
    if (this.manufacturer == null)
      this.manufacturer = new ArrayList<Reference>();
    this.manufacturer.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #manufacturer},
   *         creating it if it does not already exist {3}
   */
  public Reference getManufacturerFirstRep() {
    if (getManufacturer().isEmpty()) {
      addManufacturer();
    }
    return getManufacturer().get(0);
  }

  /**
   * @return {@link #ingredient} (The ingredients of this manufactured item. This
   *         is only needed if the ingredients are not specified by incoming
   *         references from the Ingredient resource.)
   */
  public List<CodeableConcept> getIngredient() {
    if (this.ingredient == null)
      this.ingredient = new ArrayList<CodeableConcept>();
    return this.ingredient;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public ManufacturedItemDefinition setIngredient(List<CodeableConcept> theIngredient) {
    this.ingredient = theIngredient;
    return this;
  }

  public boolean hasIngredient() {
    if (this.ingredient == null)
      return false;
    for (CodeableConcept item : this.ingredient)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public CodeableConcept addIngredient() { // 3
    CodeableConcept t = new CodeableConcept();
    if (this.ingredient == null)
      this.ingredient = new ArrayList<CodeableConcept>();
    this.ingredient.add(t);
    return t;
  }

  public ManufacturedItemDefinition addIngredient(CodeableConcept t) { // 3
    if (t == null)
      return this;
    if (this.ingredient == null)
      this.ingredient = new ArrayList<CodeableConcept>();
    this.ingredient.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #ingredient}, creating
   *         it if it does not already exist {3}
   */
  public CodeableConcept getIngredientFirstRep() {
    if (getIngredient().isEmpty()) {
      addIngredient();
    }
    return getIngredient().get(0);
  }

  /**
   * @return {@link #property} (General characteristics of this item.)
   */
  public List<ManufacturedItemDefinitionPropertyComponent> getProperty() {
    if (this.property == null)
      this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
    return this.property;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public ManufacturedItemDefinition setProperty(List<ManufacturedItemDefinitionPropertyComponent> theProperty) {
    this.property = theProperty;
    return this;
  }

  public boolean hasProperty() {
    if (this.property == null)
      return false;
    for (ManufacturedItemDefinitionPropertyComponent item : this.property)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ManufacturedItemDefinitionPropertyComponent addProperty() { // 3
    ManufacturedItemDefinitionPropertyComponent t = new ManufacturedItemDefinitionPropertyComponent();
    if (this.property == null)
      this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
    this.property.add(t);
    return t;
  }

  public ManufacturedItemDefinition addProperty(ManufacturedItemDefinitionPropertyComponent t) { // 3
    if (t == null)
      return this;
    if (this.property == null)
      this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
    this.property.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #property}, creating
   *         it if it does not already exist {3}
   */
  public ManufacturedItemDefinitionPropertyComponent getPropertyFirstRep() {
    if (getProperty().isEmpty()) {
      addProperty();
    }
    return getProperty().get(0);
  }

  protected void listChildren(List<Property> children) {
    super.listChildren(children);
    children.add(
        new Property("identifier", "Identifier", "Unique identifier.", 0, java.lang.Integer.MAX_VALUE, identifier));
    children.add(new Property("status", "code",
        "The status of this item. Enables tracking the life-cycle of the content.", 0, 1, status));
    children.add(new Property("manufacturedDoseForm", "CodeableConcept",
        "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1,
        manufacturedDoseForm));
    children.add(new Property("unitOfPresentation", "CodeableConcept",
        "The “real world” units in which the quantity of the manufactured item is described.", 0, 1,
        unitOfPresentation));
    children.add(new Property("manufacturer", "Reference(Organization)",
        "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).",
        0, java.lang.Integer.MAX_VALUE, manufacturer));
    children.add(new Property("ingredient", "CodeableConcept",
        "The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource.",
        0, java.lang.Integer.MAX_VALUE, ingredient));
    children.add(new Property("property", "", "General characteristics of this item.", 0, java.lang.Integer.MAX_VALUE,
        property));
  }

  @Override
  public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
    switch (_hash) {
    case -1618432855:
      /* identifier */ return new Property("identifier", "Identifier", "Unique identifier.", 0,
          java.lang.Integer.MAX_VALUE, identifier);
    case -892481550:
      /* status */ return new Property("status", "code",
          "The status of this item. Enables tracking the life-cycle of the content.", 0, 1, status);
    case -1451400348:
      /* manufacturedDoseForm */ return new Property("manufacturedDoseForm", "CodeableConcept",
          "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1,
          manufacturedDoseForm);
    case -1427765963:
      /* unitOfPresentation */ return new Property("unitOfPresentation", "CodeableConcept",
          "The “real world” units in which the quantity of the manufactured item is described.", 0, 1,
          unitOfPresentation);
    case -1969347631:
      /* manufacturer */ return new Property("manufacturer", "Reference(Organization)",
          "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).",
          0, java.lang.Integer.MAX_VALUE, manufacturer);
    case -206409263:
      /* ingredient */ return new Property("ingredient", "CodeableConcept",
          "The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource.",
          0, java.lang.Integer.MAX_VALUE, ingredient);
    case -993141291:
      /* property */ return new Property("property", "", "General characteristics of this item.", 0,
          java.lang.Integer.MAX_VALUE, property);
    default:
      return super.getNamedProperty(_hash, _name, _checkValid);
    }

  }

  @Override
  public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
    switch (hash) {
    case -1618432855:
      /* identifier */ return this.identifier == null ? new Base[0]
          : this.identifier.toArray(new Base[this.identifier.size()]); // Identifier
    case -892481550:
      /* status */ return this.status == null ? new Base[0] : new Base[] { this.status }; // Enumeration<PublicationStatus>
    case -1451400348:
      /* manufacturedDoseForm */ return this.manufacturedDoseForm == null ? new Base[0]
          : new Base[] { this.manufacturedDoseForm }; // CodeableConcept
    case -1427765963:
      /* unitOfPresentation */ return this.unitOfPresentation == null ? new Base[0]
          : new Base[] { this.unitOfPresentation }; // CodeableConcept
    case -1969347631:
      /* manufacturer */ return this.manufacturer == null ? new Base[0]
          : this.manufacturer.toArray(new Base[this.manufacturer.size()]); // Reference
    case -206409263:
      /* ingredient */ return this.ingredient == null ? new Base[0]
          : this.ingredient.toArray(new Base[this.ingredient.size()]); // CodeableConcept
    case -993141291:
      /* property */ return this.property == null ? new Base[0] : this.property.toArray(new Base[this.property.size()]); // ManufacturedItemDefinitionPropertyComponent
    default:
      return super.getProperty(hash, name, checkValid);
    }

  }

  @Override
  public Base setProperty(int hash, String name, Base value) throws FHIRException {
    switch (hash) {
    case -1618432855: // identifier
      this.getIdentifier().add(TypeConvertor.castToIdentifier(value)); // Identifier
      return value;
    case -892481550: // status
      value = new PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
      this.status = (Enumeration) value; // Enumeration<PublicationStatus>
      return value;
    case -1451400348: // manufacturedDoseForm
      this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
      return value;
    case -1427765963: // unitOfPresentation
      this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
      return value;
    case -1969347631: // manufacturer
      this.getManufacturer().add(TypeConvertor.castToReference(value)); // Reference
      return value;
    case -206409263: // ingredient
      this.getIngredient().add(TypeConvertor.castToCodeableConcept(value)); // CodeableConcept
      return value;
    case -993141291: // property
      this.getProperty().add((ManufacturedItemDefinitionPropertyComponent) value); // ManufacturedItemDefinitionPropertyComponent
      return value;
    default:
      return super.setProperty(hash, name, value);
    }

  }

  @Override
  public Base setProperty(String name, Base value) throws FHIRException {
    if (name.equals("identifier")) {
      this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
    } else if (name.equals("status")) {
      value = new PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
      this.status = (Enumeration) value; // Enumeration<PublicationStatus>
    } else if (name.equals("manufacturedDoseForm")) {
      this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
    } else if (name.equals("unitOfPresentation")) {
      this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
    } else if (name.equals("manufacturer")) {
      this.getManufacturer().add(TypeConvertor.castToReference(value));
    } else if (name.equals("ingredient")) {
      this.getIngredient().add(TypeConvertor.castToCodeableConcept(value));
    } else if (name.equals("property")) {
      this.getProperty().add((ManufacturedItemDefinitionPropertyComponent) value);
    } else
      return super.setProperty(name, value);
    return value;
  }

  @Override
  public void removeChild(String name, Base value) throws FHIRException {
    if (name.equals("identifier")) {
      this.getIdentifier().remove(value);
    } else if (name.equals("status")) {
      this.status = null;
    } else if (name.equals("manufacturedDoseForm")) {
      this.manufacturedDoseForm = null;
    } else if (name.equals("unitOfPresentation")) {
      this.unitOfPresentation = null;
    } else if (name.equals("manufacturer")) {
      this.getManufacturer().remove(value);
    } else if (name.equals("ingredient")) {
      this.getIngredient().remove(value);
    } else if (name.equals("property")) {
      this.getProperty().remove((ManufacturedItemDefinitionPropertyComponent) value);
    } else
      super.removeChild(name, value);
    
  }

  @Override
  public Base makeProperty(int hash, String name) throws FHIRException {
    switch (hash) {
    case -1618432855:
      return addIdentifier();
    case -892481550:
      return getStatusElement();
    case -1451400348:
      return getManufacturedDoseForm();
    case -1427765963:
      return getUnitOfPresentation();
    case -1969347631:
      return addManufacturer();
    case -206409263:
      return addIngredient();
    case -993141291:
      return addProperty();
    default:
      return super.makeProperty(hash, name);
    }

  }

  @Override
  public String[] getTypesForProperty(int hash, String name) throws FHIRException {
    switch (hash) {
    case -1618432855:
      /* identifier */ return new String[] { "Identifier" };
    case -892481550:
      /* status */ return new String[] { "code" };
    case -1451400348:
      /* manufacturedDoseForm */ return new String[] { "CodeableConcept" };
    case -1427765963:
      /* unitOfPresentation */ return new String[] { "CodeableConcept" };
    case -1969347631:
      /* manufacturer */ return new String[] { "Reference" };
    case -206409263:
      /* ingredient */ return new String[] { "CodeableConcept" };
    case -993141291:
      /* property */ return new String[] {};
    default:
      return super.getTypesForProperty(hash, name);
    }

  }

  @Override
  public Base addChild(String name) throws FHIRException {
    if (name.equals("identifier")) {
      return addIdentifier();
    } else if (name.equals("status")) {
      throw new FHIRException("Cannot call addChild on a singleton property ManufacturedItemDefinition.status");
    } else if (name.equals("manufacturedDoseForm")) {
      this.manufacturedDoseForm = new CodeableConcept();
      return this.manufacturedDoseForm;
    } else if (name.equals("unitOfPresentation")) {
      this.unitOfPresentation = new CodeableConcept();
      return this.unitOfPresentation;
    } else if (name.equals("manufacturer")) {
      return addManufacturer();
    } else if (name.equals("ingredient")) {
      return addIngredient();
    } else if (name.equals("property")) {
      return addProperty();
    } else
      return super.addChild(name);
  }

  public String fhirType() {
    return "ManufacturedItemDefinition";

  }

  public ManufacturedItemDefinition copy() {
    ManufacturedItemDefinition dst = new ManufacturedItemDefinition();
    copyValues(dst);
    return dst;
  }

  public void copyValues(ManufacturedItemDefinition dst) {
    super.copyValues(dst);
    if (identifier != null) {
      dst.identifier = new ArrayList<Identifier>();
      for (Identifier i : identifier)
        dst.identifier.add(i.copy());
    }
    ;
    dst.status = status == null ? null : status.copy();
    dst.manufacturedDoseForm = manufacturedDoseForm == null ? null : manufacturedDoseForm.copy();
    dst.unitOfPresentation = unitOfPresentation == null ? null : unitOfPresentation.copy();
    if (manufacturer != null) {
      dst.manufacturer = new ArrayList<Reference>();
      for (Reference i : manufacturer)
        dst.manufacturer.add(i.copy());
    }
    ;
    if (ingredient != null) {
      dst.ingredient = new ArrayList<CodeableConcept>();
      for (CodeableConcept i : ingredient)
        dst.ingredient.add(i.copy());
    }
    ;
    if (property != null) {
      dst.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
      for (ManufacturedItemDefinitionPropertyComponent i : property)
        dst.property.add(i.copy());
    }
    ;
  }

  protected ManufacturedItemDefinition typedCopy() {
    return copy();
  }

  @Override
  public boolean equalsDeep(Base other_) {
    if (!super.equalsDeep(other_))
      return false;
    if (!(other_ instanceof ManufacturedItemDefinition))
      return false;
    ManufacturedItemDefinition o = (ManufacturedItemDefinition) other_;
    return compareDeep(identifier, o.identifier, true) && compareDeep(status, o.status, true)
        && compareDeep(manufacturedDoseForm, o.manufacturedDoseForm, true)
        && compareDeep(unitOfPresentation, o.unitOfPresentation, true)
        && compareDeep(manufacturer, o.manufacturer, true) && compareDeep(ingredient, o.ingredient, true)
        && compareDeep(property, o.property, true);
  }

  @Override
  public boolean equalsShallow(Base other_) {
    if (!super.equalsShallow(other_))
      return false;
    if (!(other_ instanceof ManufacturedItemDefinition))
      return false;
    ManufacturedItemDefinition o = (ManufacturedItemDefinition) other_;
    return compareValues(status, o.status, true);
  }

  public boolean isEmpty() {
    return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(identifier, status, manufacturedDoseForm,
        unitOfPresentation, manufacturer, ingredient, property);
  }

  @Override
  public ResourceType getResourceType() {
    return ResourceType.ManufacturedItemDefinition;
  }

  /**
   * Search parameter: <b>dose-form</b>
   * <p>
   * Description: <b>Dose form as manufactured and before any transformation into
   * the pharmaceutical product</b><br>
   * Type: <b>token</b><br>
   * Path: <b>ManufacturedItemDefinition.manufacturedDoseForm</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "dose-form", path = "ManufacturedItemDefinition.manufacturedDoseForm", description = "Dose form as manufactured and before any transformation into the pharmaceutical product", type = "token")
  public static final String SP_DOSE_FORM = "dose-form";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>dose-form</b>
   * <p>
   * Description: <b>Dose form as manufactured and before any transformation into
   * the pharmaceutical product</b><br>
   * Type: <b>token</b><br>
   * Path: <b>ManufacturedItemDefinition.manufacturedDoseForm</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam DOSE_FORM = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_DOSE_FORM);

  /**
   * Search parameter: <b>identifier</b>
   * <p>
   * Description: <b>Unique identifier</b><br>
   * Type: <b>token</b><br>
   * Path: <b>ManufacturedItemDefinition.identifier</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "identifier", path = "ManufacturedItemDefinition.identifier", description = "Unique identifier", type = "token")
  public static final String SP_IDENTIFIER = "identifier";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>identifier</b>
   * <p>
   * Description: <b>Unique identifier</b><br>
   * Type: <b>token</b><br>
   * Path: <b>ManufacturedItemDefinition.identifier</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam IDENTIFIER = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_IDENTIFIER);

  /**
   * Search parameter: <b>ingredient</b>
   * <p>
   * Description: <b>An ingredient of this item</b><br>
   * Type: <b>token</b><br>
   * Path: <b>ManufacturedItemDefinition.ingredient</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "ingredient", path = "ManufacturedItemDefinition.ingredient", description = "An ingredient of this item", type = "token")
  public static final String SP_INGREDIENT = "ingredient";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>ingredient</b>
   * <p>
   * Description: <b>An ingredient of this item</b><br>
   * Type: <b>token</b><br>
   * Path: <b>ManufacturedItemDefinition.ingredient</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam INGREDIENT = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_INGREDIENT);

}
