package org.hl7.fhir.r4b.model;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Mon, Jun 13, 2022 17:19+0300 for FHIR v4.3.0

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.r4b.model.Enumerations.*;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Block;

/**
 * A formally or informally recognized grouping of people or organizations
 * formed for the purpose of achieving some form of collective action. Includes
 * companies, institutions, corporations, departments, community groups,
 * healthcare practice groups, payer/insurer, etc.
 */
@ResourceDef(name = "Organization", profile = "http://hl7.org/fhir/StructureDefinition/Organization")
public class Organization extends DomainResource {

  @Block()
  public static class OrganizationContactComponent extends BackboneElement implements IBaseBackboneElement {
    /**
     * Indicates a purpose for which the contact can be reached.
     */
    @Child(name = "purpose", type = {
        CodeableConcept.class }, order = 1, min = 0, max = 1, modifier = false, summary = false)
    @Description(shortDefinition = "The type of contact", formalDefinition = "Indicates a purpose for which the contact can be reached.")
    @ca.uhn.fhir.model.api.annotation.Binding(valueSet = "http://hl7.org/fhir/ValueSet/contactentity-type")
    protected CodeableConcept purpose;

    /**
     * A name associated with the contact.
     */
    @Child(name = "name", type = { HumanName.class }, order = 2, min = 0, max = 1, modifier = false, summary = false)
    @Description(shortDefinition = "A name associated with the contact", formalDefinition = "A name associated with the contact.")
    protected HumanName name;

    /**
     * A contact detail (e.g. a telephone number or an email address) by which the
     * party may be contacted.
     */
    @Child(name = "telecom", type = {
        ContactPoint.class }, order = 3, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
    @Description(shortDefinition = "Contact details (telephone, email, etc.)  for a contact", formalDefinition = "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
    protected List<ContactPoint> telecom;

    /**
     * Visiting or postal addresses for the contact.
     */
    @Child(name = "address", type = { Address.class }, order = 4, min = 0, max = 1, modifier = false, summary = false)
    @Description(shortDefinition = "Visiting or postal addresses for the contact", formalDefinition = "Visiting or postal addresses for the contact.")
    protected Address address;

    private static final long serialVersionUID = 1831121305L;

    /**
     * Constructor
     */
    public OrganizationContactComponent() {
      super();
    }

    /**
     * @return {@link #purpose} (Indicates a purpose for which the contact can be
     *         reached.)
     */
    public CodeableConcept getPurpose() {
      if (this.purpose == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create OrganizationContactComponent.purpose");
        else if (Configuration.doAutoCreate())
          this.purpose = new CodeableConcept(); // cc
      return this.purpose;
    }

    public boolean hasPurpose() {
      return this.purpose != null && !this.purpose.isEmpty();
    }

    /**
     * @param value {@link #purpose} (Indicates a purpose for which the contact can
     *              be reached.)
     */
    public OrganizationContactComponent setPurpose(CodeableConcept value) {
      this.purpose = value;
      return this;
    }

    /**
     * @return {@link #name} (A name associated with the contact.)
     */
    public HumanName getName() {
      if (this.name == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create OrganizationContactComponent.name");
        else if (Configuration.doAutoCreate())
          this.name = new HumanName(); // cc
      return this.name;
    }

    public boolean hasName() {
      return this.name != null && !this.name.isEmpty();
    }

    /**
     * @param value {@link #name} (A name associated with the contact.)
     */
    public OrganizationContactComponent setName(HumanName value) {
      this.name = value;
      return this;
    }

    /**
     * @return {@link #telecom} (A contact detail (e.g. a telephone number or an
     *         email address) by which the party may be contacted.)
     */
    public List<ContactPoint> getTelecom() {
      if (this.telecom == null)
        this.telecom = new ArrayList<ContactPoint>();
      return this.telecom;
    }

    /**
     * @return Returns a reference to <code>this</code> for easy method chaining
     */
    public OrganizationContactComponent setTelecom(List<ContactPoint> theTelecom) {
      this.telecom = theTelecom;
      return this;
    }

    public boolean hasTelecom() {
      if (this.telecom == null)
        return false;
      for (ContactPoint item : this.telecom)
        if (!item.isEmpty())
          return true;
      return false;
    }

    public ContactPoint addTelecom() { // 3
      ContactPoint t = new ContactPoint();
      if (this.telecom == null)
        this.telecom = new ArrayList<ContactPoint>();
      this.telecom.add(t);
      return t;
    }

    public OrganizationContactComponent addTelecom(ContactPoint t) { // 3
      if (t == null)
        return this;
      if (this.telecom == null)
        this.telecom = new ArrayList<ContactPoint>();
      this.telecom.add(t);
      return this;
    }

    /**
     * @return The first repetition of repeating field {@link #telecom}, creating it
     *         if it does not already exist {3}
     */
    public ContactPoint getTelecomFirstRep() {
      if (getTelecom().isEmpty()) {
        addTelecom();
      }
      return getTelecom().get(0);
    }

    /**
     * @return {@link #address} (Visiting or postal addresses for the contact.)
     */
    public Address getAddress() {
      if (this.address == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create OrganizationContactComponent.address");
        else if (Configuration.doAutoCreate())
          this.address = new Address(); // cc
      return this.address;
    }

    public boolean hasAddress() {
      return this.address != null && !this.address.isEmpty();
    }

    /**
     * @param value {@link #address} (Visiting or postal addresses for the contact.)
     */
    public OrganizationContactComponent setAddress(Address value) {
      this.address = value;
      return this;
    }

    protected void listChildren(List<Property> children) {
      super.listChildren(children);
      children.add(new Property("purpose", "CodeableConcept",
          "Indicates a purpose for which the contact can be reached.", 0, 1, purpose));
      children.add(new Property("name", "HumanName", "A name associated with the contact.", 0, 1, name));
      children.add(new Property("telecom", "ContactPoint",
          "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0,
          java.lang.Integer.MAX_VALUE, telecom));
      children.add(new Property("address", "Address", "Visiting or postal addresses for the contact.", 0, 1, address));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
      switch (_hash) {
      case -220463842:
        /* purpose */ return new Property("purpose", "CodeableConcept",
            "Indicates a purpose for which the contact can be reached.", 0, 1, purpose);
      case 3373707:
        /* name */ return new Property("name", "HumanName", "A name associated with the contact.", 0, 1, name);
      case -1429363305:
        /* telecom */ return new Property("telecom", "ContactPoint",
            "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0,
            java.lang.Integer.MAX_VALUE, telecom);
      case -1147692044:
        /* address */ return new Property("address", "Address", "Visiting or postal addresses for the contact.", 0, 1,
            address);
      default:
        return super.getNamedProperty(_hash, _name, _checkValid);
      }

    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
      switch (hash) {
      case -220463842:
        /* purpose */ return this.purpose == null ? new Base[0] : new Base[] { this.purpose }; // CodeableConcept
      case 3373707:
        /* name */ return this.name == null ? new Base[0] : new Base[] { this.name }; // HumanName
      case -1429363305:
        /* telecom */ return this.telecom == null ? new Base[0] : this.telecom.toArray(new Base[this.telecom.size()]); // ContactPoint
      case -1147692044:
        /* address */ return this.address == null ? new Base[0] : new Base[] { this.address }; // Address
      default:
        return super.getProperty(hash, name, checkValid);
      }

    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
      switch (hash) {
      case -220463842: // purpose
        this.purpose = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
        return value;
      case 3373707: // name
        this.name = TypeConvertor.castToHumanName(value); // HumanName
        return value;
      case -1429363305: // telecom
        this.getTelecom().add(TypeConvertor.castToContactPoint(value)); // ContactPoint
        return value;
      case -1147692044: // address
        this.address = TypeConvertor.castToAddress(value); // Address
        return value;
      default:
        return super.setProperty(hash, name, value);
      }

    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
      if (name.equals("purpose")) {
        this.purpose = TypeConvertor.castToCodeableConcept(value); // CodeableConcept
      } else if (name.equals("name")) {
        this.name = TypeConvertor.castToHumanName(value); // HumanName
      } else if (name.equals("telecom")) {
        this.getTelecom().add(TypeConvertor.castToContactPoint(value));
      } else if (name.equals("address")) {
        this.address = TypeConvertor.castToAddress(value); // Address
      } else
        return super.setProperty(name, value);
      return value;
    }

  @Override
  public void removeChild(String name, Base value) throws FHIRException {
      if (name.equals("purpose")) {
        this.purpose = null;
      } else if (name.equals("name")) {
        this.name = null;
      } else if (name.equals("telecom")) {
        this.getTelecom().remove(value);
      } else if (name.equals("address")) {
        this.address = null;
      } else
        super.removeChild(name, value);
      
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
      switch (hash) {
      case -220463842:
        return getPurpose();
      case 3373707:
        return getName();
      case -1429363305:
        return addTelecom();
      case -1147692044:
        return getAddress();
      default:
        return super.makeProperty(hash, name);
      }

    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
      switch (hash) {
      case -220463842:
        /* purpose */ return new String[] { "CodeableConcept" };
      case 3373707:
        /* name */ return new String[] { "HumanName" };
      case -1429363305:
        /* telecom */ return new String[] { "ContactPoint" };
      case -1147692044:
        /* address */ return new String[] { "Address" };
      default:
        return super.getTypesForProperty(hash, name);
      }

    }

    @Override
    public Base addChild(String name) throws FHIRException {
      if (name.equals("purpose")) {
        this.purpose = new CodeableConcept();
        return this.purpose;
      } else if (name.equals("name")) {
        this.name = new HumanName();
        return this.name;
      } else if (name.equals("telecom")) {
        return addTelecom();
      } else if (name.equals("address")) {
        this.address = new Address();
        return this.address;
      } else
        return super.addChild(name);
    }

    public OrganizationContactComponent copy() {
      OrganizationContactComponent dst = new OrganizationContactComponent();
      copyValues(dst);
      return dst;
    }

    public void copyValues(OrganizationContactComponent dst) {
      super.copyValues(dst);
      dst.purpose = purpose == null ? null : purpose.copy();
      dst.name = name == null ? null : name.copy();
      if (telecom != null) {
        dst.telecom = new ArrayList<ContactPoint>();
        for (ContactPoint i : telecom)
          dst.telecom.add(i.copy());
      }
      ;
      dst.address = address == null ? null : address.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
      if (!super.equalsDeep(other_))
        return false;
      if (!(other_ instanceof OrganizationContactComponent))
        return false;
      OrganizationContactComponent o = (OrganizationContactComponent) other_;
      return compareDeep(purpose, o.purpose, true) && compareDeep(name, o.name, true)
          && compareDeep(telecom, o.telecom, true) && compareDeep(address, o.address, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
      if (!super.equalsShallow(other_))
        return false;
      if (!(other_ instanceof OrganizationContactComponent))
        return false;
      OrganizationContactComponent o = (OrganizationContactComponent) other_;
      return true;
    }

    public boolean isEmpty() {
      return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(purpose, name, telecom, address);
    }

    public String fhirType() {
      return "Organization.contact";

    }

  }

  /**
   * Identifier for the organization that is used to identify the organization
   * across multiple disparate systems.
   */
  @Child(name = "identifier", type = {
      Identifier.class }, order = 0, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "Identifies this organization  across multiple systems", formalDefinition = "Identifier for the organization that is used to identify the organization across multiple disparate systems.")
  protected List<Identifier> identifier;

  /**
   * Whether the organization's record is still in active use.
   */
  @Child(name = "active", type = { BooleanType.class }, order = 1, min = 0, max = 1, modifier = true, summary = true)
  @Description(shortDefinition = "Whether the organization's record is still in active use", formalDefinition = "Whether the organization's record is still in active use.")
  protected BooleanType active;

  /**
   * The kind(s) of organization that this is.
   */
  @Child(name = "type", type = {
      CodeableConcept.class }, order = 2, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "Kind of organization", formalDefinition = "The kind(s) of organization that this is.")
  @ca.uhn.fhir.model.api.annotation.Binding(valueSet = "http://hl7.org/fhir/ValueSet/organization-type")
  protected List<CodeableConcept> type;

  /**
   * A name associated with the organization.
   */
  @Child(name = "name", type = { StringType.class }, order = 3, min = 0, max = 1, modifier = false, summary = true)
  @Description(shortDefinition = "Name used for the organization", formalDefinition = "A name associated with the organization.")
  protected StringType name;

  /**
   * A list of alternate names that the organization is known as, or was known as
   * in the past.
   */
  @Child(name = "alias", type = {
      StringType.class }, order = 4, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "A list of alternate names that the organization is known as, or was known as in the past", formalDefinition = "A list of alternate names that the organization is known as, or was known as in the past.")
  protected List<StringType> alias;

  /**
   * A contact detail for the organization.
   */
  @Child(name = "telecom", type = {
      ContactPoint.class }, order = 5, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "A contact detail for the organization", formalDefinition = "A contact detail for the organization.")
  protected List<ContactPoint> telecom;

  /**
   * An address for the organization.
   */
  @Child(name = "address", type = {
      Address.class }, order = 6, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "An address for the organization", formalDefinition = "An address for the organization.")
  protected List<Address> address;

  /**
   * The organization of which this organization forms a part.
   */
  @Child(name = "partOf", type = { Organization.class }, order = 7, min = 0, max = 1, modifier = false, summary = true)
  @Description(shortDefinition = "The organization of which this organization forms a part", formalDefinition = "The organization of which this organization forms a part.")
  protected Reference partOf;

  /**
   * Contact for the organization for a certain purpose.
   */
  @Child(name = "contact", type = {}, order = 8, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Contact for the organization for a certain purpose", formalDefinition = "Contact for the organization for a certain purpose.")
  protected List<OrganizationContactComponent> contact;

  /**
   * Technical endpoints providing access to services operated for the
   * organization.
   */
  @Child(name = "endpoint", type = {
      Endpoint.class }, order = 9, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Technical endpoints providing access to services operated for the organization", formalDefinition = "Technical endpoints providing access to services operated for the organization.")
  protected List<Reference> endpoint;

  private static final long serialVersionUID = -1305337184L;

  /**
   * Constructor
   */
  public Organization() {
    super();
  }

  /**
   * @return {@link #identifier} (Identifier for the organization that is used to
   *         identify the organization across multiple disparate systems.)
   */
  public List<Identifier> getIdentifier() {
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    return this.identifier;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setIdentifier(List<Identifier> theIdentifier) {
    this.identifier = theIdentifier;
    return this;
  }

  public boolean hasIdentifier() {
    if (this.identifier == null)
      return false;
    for (Identifier item : this.identifier)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Identifier addIdentifier() { // 3
    Identifier t = new Identifier();
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    this.identifier.add(t);
    return t;
  }

  public Organization addIdentifier(Identifier t) { // 3
    if (t == null)
      return this;
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    this.identifier.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #identifier}, creating
   *         it if it does not already exist {3}
   */
  public Identifier getIdentifierFirstRep() {
    if (getIdentifier().isEmpty()) {
      addIdentifier();
    }
    return getIdentifier().get(0);
  }

  /**
   * @return {@link #active} (Whether the organization's record is still in active
   *         use.). This is the underlying object with id, value and extensions.
   *         The accessor "getActive" gives direct access to the value
   */
  public BooleanType getActiveElement() {
    if (this.active == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Organization.active");
      else if (Configuration.doAutoCreate())
        this.active = new BooleanType(); // bb
    return this.active;
  }

  public boolean hasActiveElement() {
    return this.active != null && !this.active.isEmpty();
  }

  public boolean hasActive() {
    return this.active != null && !this.active.isEmpty();
  }

  /**
   * @param value {@link #active} (Whether the organization's record is still in
   *              active use.). This is the underlying object with id, value and
   *              extensions. The accessor "getActive" gives direct access to the
   *              value
   */
  public Organization setActiveElement(BooleanType value) {
    this.active = value;
    return this;
  }

  /**
   * @return Whether the organization's record is still in active use.
   */
  public boolean getActive() {
    return this.active == null || this.active.isEmpty() ? false : this.active.getValue();
  }

  /**
   * @param value Whether the organization's record is still in active use.
   */
  public Organization setActive(boolean value) {
    if (this.active == null)
      this.active = new BooleanType();
    this.active.setValue(value);
    return this;
  }

  /**
   * @return {@link #type} (The kind(s) of organization that this is.)
   */
  public List<CodeableConcept> getType() {
    if (this.type == null)
      this.type = new ArrayList<CodeableConcept>();
    return this.type;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setType(List<CodeableConcept> theType) {
    this.type = theType;
    return this;
  }

  public boolean hasType() {
    if (this.type == null)
      return false;
    for (CodeableConcept item : this.type)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public CodeableConcept addType() { // 3
    CodeableConcept t = new CodeableConcept();
    if (this.type == null)
      this.type = new ArrayList<CodeableConcept>();
    this.type.add(t);
    return t;
  }

  public Organization addType(CodeableConcept t) { // 3
    if (t == null)
      return this;
    if (this.type == null)
      this.type = new ArrayList<CodeableConcept>();
    this.type.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #type}, creating it if
   *         it does not already exist {3}
   */
  public CodeableConcept getTypeFirstRep() {
    if (getType().isEmpty()) {
      addType();
    }
    return getType().get(0);
  }

  /**
   * @return {@link #name} (A name associated with the organization.). This is the
   *         underlying object with id, value and extensions. The accessor
   *         "getName" gives direct access to the value
   */
  public StringType getNameElement() {
    if (this.name == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Organization.name");
      else if (Configuration.doAutoCreate())
        this.name = new StringType(); // bb
    return this.name;
  }

  public boolean hasNameElement() {
    return this.name != null && !this.name.isEmpty();
  }

  public boolean hasName() {
    return this.name != null && !this.name.isEmpty();
  }

  /**
   * @param value {@link #name} (A name associated with the organization.). This
   *              is the underlying object with id, value and extensions. The
   *              accessor "getName" gives direct access to the value
   */
  public Organization setNameElement(StringType value) {
    this.name = value;
    return this;
  }

  /**
   * @return A name associated with the organization.
   */
  public String getName() {
    return this.name == null ? null : this.name.getValue();
  }

  /**
   * @param value A name associated with the organization.
   */
  public Organization setName(String value) {
    if (Utilities.noString(value))
      this.name = null;
    else {
      if (this.name == null)
        this.name = new StringType();
      this.name.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #alias} (A list of alternate names that the organization is
   *         known as, or was known as in the past.)
   */
  public List<StringType> getAlias() {
    if (this.alias == null)
      this.alias = new ArrayList<StringType>();
    return this.alias;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setAlias(List<StringType> theAlias) {
    this.alias = theAlias;
    return this;
  }

  public boolean hasAlias() {
    if (this.alias == null)
      return false;
    for (StringType item : this.alias)
      if (!item.isEmpty())
        return true;
    return false;
  }

  /**
   * @return {@link #alias} (A list of alternate names that the organization is
   *         known as, or was known as in the past.)
   */
  public StringType addAliasElement() {// 2
    StringType t = new StringType();
    if (this.alias == null)
      this.alias = new ArrayList<StringType>();
    this.alias.add(t);
    return t;
  }

  /**
   * @param value {@link #alias} (A list of alternate names that the organization
   *              is known as, or was known as in the past.)
   */
  public Organization addAlias(String value) { // 1
    StringType t = new StringType();
    t.setValue(value);
    if (this.alias == null)
      this.alias = new ArrayList<StringType>();
    this.alias.add(t);
    return this;
  }

  /**
   * @param value {@link #alias} (A list of alternate names that the organization
   *              is known as, or was known as in the past.)
   */
  public boolean hasAlias(String value) {
    if (this.alias == null)
      return false;
    for (StringType v : this.alias)
      if (v.getValue().equals(value)) // string
        return true;
    return false;
  }

  /**
   * @return {@link #telecom} (A contact detail for the organization.)
   */
  public List<ContactPoint> getTelecom() {
    if (this.telecom == null)
      this.telecom = new ArrayList<ContactPoint>();
    return this.telecom;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setTelecom(List<ContactPoint> theTelecom) {
    this.telecom = theTelecom;
    return this;
  }

  public boolean hasTelecom() {
    if (this.telecom == null)
      return false;
    for (ContactPoint item : this.telecom)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ContactPoint addTelecom() { // 3
    ContactPoint t = new ContactPoint();
    if (this.telecom == null)
      this.telecom = new ArrayList<ContactPoint>();
    this.telecom.add(t);
    return t;
  }

  public Organization addTelecom(ContactPoint t) { // 3
    if (t == null)
      return this;
    if (this.telecom == null)
      this.telecom = new ArrayList<ContactPoint>();
    this.telecom.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #telecom}, creating it
   *         if it does not already exist {3}
   */
  public ContactPoint getTelecomFirstRep() {
    if (getTelecom().isEmpty()) {
      addTelecom();
    }
    return getTelecom().get(0);
  }

  /**
   * @return {@link #address} (An address for the organization.)
   */
  public List<Address> getAddress() {
    if (this.address == null)
      this.address = new ArrayList<Address>();
    return this.address;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setAddress(List<Address> theAddress) {
    this.address = theAddress;
    return this;
  }

  public boolean hasAddress() {
    if (this.address == null)
      return false;
    for (Address item : this.address)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Address addAddress() { // 3
    Address t = new Address();
    if (this.address == null)
      this.address = new ArrayList<Address>();
    this.address.add(t);
    return t;
  }

  public Organization addAddress(Address t) { // 3
    if (t == null)
      return this;
    if (this.address == null)
      this.address = new ArrayList<Address>();
    this.address.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #address}, creating it
   *         if it does not already exist {3}
   */
  public Address getAddressFirstRep() {
    if (getAddress().isEmpty()) {
      addAddress();
    }
    return getAddress().get(0);
  }

  /**
   * @return {@link #partOf} (The organization of which this organization forms a
   *         part.)
   */
  public Reference getPartOf() {
    if (this.partOf == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Organization.partOf");
      else if (Configuration.doAutoCreate())
        this.partOf = new Reference(); // cc
    return this.partOf;
  }

  public boolean hasPartOf() {
    return this.partOf != null && !this.partOf.isEmpty();
  }

  /**
   * @param value {@link #partOf} (The organization of which this organization
   *              forms a part.)
   */
  public Organization setPartOf(Reference value) {
    this.partOf = value;
    return this;
  }

  /**
   * @return {@link #contact} (Contact for the organization for a certain
   *         purpose.)
   */
  public List<OrganizationContactComponent> getContact() {
    if (this.contact == null)
      this.contact = new ArrayList<OrganizationContactComponent>();
    return this.contact;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setContact(List<OrganizationContactComponent> theContact) {
    this.contact = theContact;
    return this;
  }

  public boolean hasContact() {
    if (this.contact == null)
      return false;
    for (OrganizationContactComponent item : this.contact)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public OrganizationContactComponent addContact() { // 3
    OrganizationContactComponent t = new OrganizationContactComponent();
    if (this.contact == null)
      this.contact = new ArrayList<OrganizationContactComponent>();
    this.contact.add(t);
    return t;
  }

  public Organization addContact(OrganizationContactComponent t) { // 3
    if (t == null)
      return this;
    if (this.contact == null)
      this.contact = new ArrayList<OrganizationContactComponent>();
    this.contact.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #contact}, creating it
   *         if it does not already exist {3}
   */
  public OrganizationContactComponent getContactFirstRep() {
    if (getContact().isEmpty()) {
      addContact();
    }
    return getContact().get(0);
  }

  /**
   * @return {@link #endpoint} (Technical endpoints providing access to services
   *         operated for the organization.)
   */
  public List<Reference> getEndpoint() {
    if (this.endpoint == null)
      this.endpoint = new ArrayList<Reference>();
    return this.endpoint;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Organization setEndpoint(List<Reference> theEndpoint) {
    this.endpoint = theEndpoint;
    return this;
  }

  public boolean hasEndpoint() {
    if (this.endpoint == null)
      return false;
    for (Reference item : this.endpoint)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Reference addEndpoint() { // 3
    Reference t = new Reference();
    if (this.endpoint == null)
      this.endpoint = new ArrayList<Reference>();
    this.endpoint.add(t);
    return t;
  }

  public Organization addEndpoint(Reference t) { // 3
    if (t == null)
      return this;
    if (this.endpoint == null)
      this.endpoint = new ArrayList<Reference>();
    this.endpoint.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #endpoint}, creating
   *         it if it does not already exist {3}
   */
  public Reference getEndpointFirstRep() {
    if (getEndpoint().isEmpty()) {
      addEndpoint();
    }
    return getEndpoint().get(0);
  }

  protected void listChildren(List<Property> children) {
    super.listChildren(children);
    children.add(new Property("identifier", "Identifier",
        "Identifier for the organization that is used to identify the organization across multiple disparate systems.",
        0, java.lang.Integer.MAX_VALUE, identifier));
    children.add(
        new Property("active", "boolean", "Whether the organization's record is still in active use.", 0, 1, active));
    children.add(new Property("type", "CodeableConcept", "The kind(s) of organization that this is.", 0,
        java.lang.Integer.MAX_VALUE, type));
    children.add(new Property("name", "string", "A name associated with the organization.", 0, 1, name));
    children.add(new Property("alias", "string",
        "A list of alternate names that the organization is known as, or was known as in the past.", 0,
        java.lang.Integer.MAX_VALUE, alias));
    children.add(new Property("telecom", "ContactPoint", "A contact detail for the organization.", 0,
        java.lang.Integer.MAX_VALUE, telecom));
    children.add(new Property("address", "Address", "An address for the organization.", 0, java.lang.Integer.MAX_VALUE,
        address));
    children.add(new Property("partOf", "Reference(Organization)",
        "The organization of which this organization forms a part.", 0, 1, partOf));
    children.add(new Property("contact", "", "Contact for the organization for a certain purpose.", 0,
        java.lang.Integer.MAX_VALUE, contact));
    children.add(new Property("endpoint", "Reference(Endpoint)",
        "Technical endpoints providing access to services operated for the organization.", 0,
        java.lang.Integer.MAX_VALUE, endpoint));
  }

  @Override
  public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
    switch (_hash) {
    case -1618432855:
      /* identifier */ return new Property("identifier", "Identifier",
          "Identifier for the organization that is used to identify the organization across multiple disparate systems.",
          0, java.lang.Integer.MAX_VALUE, identifier);
    case -1422950650:
      /* active */ return new Property("active", "boolean", "Whether the organization's record is still in active use.",
          0, 1, active);
    case 3575610:
      /* type */ return new Property("type", "CodeableConcept", "The kind(s) of organization that this is.", 0,
          java.lang.Integer.MAX_VALUE, type);
    case 3373707:
      /* name */ return new Property("name", "string", "A name associated with the organization.", 0, 1, name);
    case 92902992:
      /* alias */ return new Property("alias", "string",
          "A list of alternate names that the organization is known as, or was known as in the past.", 0,
          java.lang.Integer.MAX_VALUE, alias);
    case -1429363305:
      /* telecom */ return new Property("telecom", "ContactPoint", "A contact detail for the organization.", 0,
          java.lang.Integer.MAX_VALUE, telecom);
    case -1147692044:
      /* address */ return new Property("address", "Address", "An address for the organization.", 0,
          java.lang.Integer.MAX_VALUE, address);
    case -995410646:
      /* partOf */ return new Property("partOf", "Reference(Organization)",
          "The organization of which this organization forms a part.", 0, 1, partOf);
    case 951526432:
      /* contact */ return new Property("contact", "", "Contact for the organization for a certain purpose.", 0,
          java.lang.Integer.MAX_VALUE, contact);
    case 1741102485:
      /* endpoint */ return new Property("endpoint", "Reference(Endpoint)",
          "Technical endpoints providing access to services operated for the organization.", 0,
          java.lang.Integer.MAX_VALUE, endpoint);
    default:
      return super.getNamedProperty(_hash, _name, _checkValid);
    }

  }

  @Override
  public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
    switch (hash) {
    case -1618432855:
      /* identifier */ return this.identifier == null ? new Base[0]
          : this.identifier.toArray(new Base[this.identifier.size()]); // Identifier
    case -1422950650:
      /* active */ return this.active == null ? new Base[0] : new Base[] { this.active }; // BooleanType
    case 3575610:
      /* type */ return this.type == null ? new Base[0] : this.type.toArray(new Base[this.type.size()]); // CodeableConcept
    case 3373707:
      /* name */ return this.name == null ? new Base[0] : new Base[] { this.name }; // StringType
    case 92902992:
      /* alias */ return this.alias == null ? new Base[0] : this.alias.toArray(new Base[this.alias.size()]); // StringType
    case -1429363305:
      /* telecom */ return this.telecom == null ? new Base[0] : this.telecom.toArray(new Base[this.telecom.size()]); // ContactPoint
    case -1147692044:
      /* address */ return this.address == null ? new Base[0] : this.address.toArray(new Base[this.address.size()]); // Address
    case -995410646:
      /* partOf */ return this.partOf == null ? new Base[0] : new Base[] { this.partOf }; // Reference
    case 951526432:
      /* contact */ return this.contact == null ? new Base[0] : this.contact.toArray(new Base[this.contact.size()]); // OrganizationContactComponent
    case 1741102485:
      /* endpoint */ return this.endpoint == null ? new Base[0] : this.endpoint.toArray(new Base[this.endpoint.size()]); // Reference
    default:
      return super.getProperty(hash, name, checkValid);
    }

  }

  @Override
  public Base setProperty(int hash, String name, Base value) throws FHIRException {
    switch (hash) {
    case -1618432855: // identifier
      this.getIdentifier().add(TypeConvertor.castToIdentifier(value)); // Identifier
      return value;
    case -1422950650: // active
      this.active = TypeConvertor.castToBoolean(value); // BooleanType
      return value;
    case 3575610: // type
      this.getType().add(TypeConvertor.castToCodeableConcept(value)); // CodeableConcept
      return value;
    case 3373707: // name
      this.name = TypeConvertor.castToString(value); // StringType
      return value;
    case 92902992: // alias
      this.getAlias().add(TypeConvertor.castToString(value)); // StringType
      return value;
    case -1429363305: // telecom
      this.getTelecom().add(TypeConvertor.castToContactPoint(value)); // ContactPoint
      return value;
    case -1147692044: // address
      this.getAddress().add(TypeConvertor.castToAddress(value)); // Address
      return value;
    case -995410646: // partOf
      this.partOf = TypeConvertor.castToReference(value); // Reference
      return value;
    case 951526432: // contact
      this.getContact().add((OrganizationContactComponent) value); // OrganizationContactComponent
      return value;
    case 1741102485: // endpoint
      this.getEndpoint().add(TypeConvertor.castToReference(value)); // Reference
      return value;
    default:
      return super.setProperty(hash, name, value);
    }

  }

  @Override
  public Base setProperty(String name, Base value) throws FHIRException {
    if (name.equals("identifier")) {
      this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
    } else if (name.equals("active")) {
      this.active = TypeConvertor.castToBoolean(value); // BooleanType
    } else if (name.equals("type")) {
      this.getType().add(TypeConvertor.castToCodeableConcept(value));
    } else if (name.equals("name")) {
      this.name = TypeConvertor.castToString(value); // StringType
    } else if (name.equals("alias")) {
      this.getAlias().add(TypeConvertor.castToString(value));
    } else if (name.equals("telecom")) {
      this.getTelecom().add(TypeConvertor.castToContactPoint(value));
    } else if (name.equals("address")) {
      this.getAddress().add(TypeConvertor.castToAddress(value));
    } else if (name.equals("partOf")) {
      this.partOf = TypeConvertor.castToReference(value); // Reference
    } else if (name.equals("contact")) {
      this.getContact().add((OrganizationContactComponent) value);
    } else if (name.equals("endpoint")) {
      this.getEndpoint().add(TypeConvertor.castToReference(value));
    } else
      return super.setProperty(name, value);
    return value;
  }

  @Override
  public void removeChild(String name, Base value) throws FHIRException {
    if (name.equals("identifier")) {
      this.getIdentifier().remove(value);
    } else if (name.equals("active")) {
      this.active = null;
    } else if (name.equals("type")) {
      this.getType().remove(value);
    } else if (name.equals("name")) {
      this.name = null;
    } else if (name.equals("alias")) {
      this.getAlias().remove(value);
    } else if (name.equals("telecom")) {
      this.getTelecom().remove(value);
    } else if (name.equals("address")) {
      this.getAddress().remove(value);
    } else if (name.equals("partOf")) {
      this.partOf = null;
    } else if (name.equals("contact")) {
      this.getContact().remove((OrganizationContactComponent) value);
    } else if (name.equals("endpoint")) {
      this.getEndpoint().remove(value);
    } else
      super.removeChild(name, value);
    
  }

  @Override
  public Base makeProperty(int hash, String name) throws FHIRException {
    switch (hash) {
    case -1618432855:
      return addIdentifier();
    case -1422950650:
      return getActiveElement();
    case 3575610:
      return addType();
    case 3373707:
      return getNameElement();
    case 92902992:
      return addAliasElement();
    case -1429363305:
      return addTelecom();
    case -1147692044:
      return addAddress();
    case -995410646:
      return getPartOf();
    case 951526432:
      return addContact();
    case 1741102485:
      return addEndpoint();
    default:
      return super.makeProperty(hash, name);
    }

  }

  @Override
  public String[] getTypesForProperty(int hash, String name) throws FHIRException {
    switch (hash) {
    case -1618432855:
      /* identifier */ return new String[] { "Identifier" };
    case -1422950650:
      /* active */ return new String[] { "boolean" };
    case 3575610:
      /* type */ return new String[] { "CodeableConcept" };
    case 3373707:
      /* name */ return new String[] { "string" };
    case 92902992:
      /* alias */ return new String[] { "string" };
    case -1429363305:
      /* telecom */ return new String[] { "ContactPoint" };
    case -1147692044:
      /* address */ return new String[] { "Address" };
    case -995410646:
      /* partOf */ return new String[] { "Reference" };
    case 951526432:
      /* contact */ return new String[] {};
    case 1741102485:
      /* endpoint */ return new String[] { "Reference" };
    default:
      return super.getTypesForProperty(hash, name);
    }

  }

  @Override
  public Base addChild(String name) throws FHIRException {
    if (name.equals("identifier")) {
      return addIdentifier();
    } else if (name.equals("active")) {
      throw new FHIRException("Cannot call addChild on a singleton property Organization.active");
    } else if (name.equals("type")) {
      return addType();
    } else if (name.equals("name")) {
      throw new FHIRException("Cannot call addChild on a singleton property Organization.name");
    } else if (name.equals("alias")) {
      throw new FHIRException("Cannot call addChild on a singleton property Organization.alias");
    } else if (name.equals("telecom")) {
      return addTelecom();
    } else if (name.equals("address")) {
      return addAddress();
    } else if (name.equals("partOf")) {
      this.partOf = new Reference();
      return this.partOf;
    } else if (name.equals("contact")) {
      return addContact();
    } else if (name.equals("endpoint")) {
      return addEndpoint();
    } else
      return super.addChild(name);
  }

  public String fhirType() {
    return "Organization";

  }

  public Organization copy() {
    Organization dst = new Organization();
    copyValues(dst);
    return dst;
  }

  public void copyValues(Organization dst) {
    super.copyValues(dst);
    if (identifier != null) {
      dst.identifier = new ArrayList<Identifier>();
      for (Identifier i : identifier)
        dst.identifier.add(i.copy());
    }
    ;
    dst.active = active == null ? null : active.copy();
    if (type != null) {
      dst.type = new ArrayList<CodeableConcept>();
      for (CodeableConcept i : type)
        dst.type.add(i.copy());
    }
    ;
    dst.name = name == null ? null : name.copy();
    if (alias != null) {
      dst.alias = new ArrayList<StringType>();
      for (StringType i : alias)
        dst.alias.add(i.copy());
    }
    ;
    if (telecom != null) {
      dst.telecom = new ArrayList<ContactPoint>();
      for (ContactPoint i : telecom)
        dst.telecom.add(i.copy());
    }
    ;
    if (address != null) {
      dst.address = new ArrayList<Address>();
      for (Address i : address)
        dst.address.add(i.copy());
    }
    ;
    dst.partOf = partOf == null ? null : partOf.copy();
    if (contact != null) {
      dst.contact = new ArrayList<OrganizationContactComponent>();
      for (OrganizationContactComponent i : contact)
        dst.contact.add(i.copy());
    }
    ;
    if (endpoint != null) {
      dst.endpoint = new ArrayList<Reference>();
      for (Reference i : endpoint)
        dst.endpoint.add(i.copy());
    }
    ;
  }

  protected Organization typedCopy() {
    return copy();
  }

  @Override
  public boolean equalsDeep(Base other_) {
    if (!super.equalsDeep(other_))
      return false;
    if (!(other_ instanceof Organization))
      return false;
    Organization o = (Organization) other_;
    return compareDeep(identifier, o.identifier, true) && compareDeep(active, o.active, true)
        && compareDeep(type, o.type, true) && compareDeep(name, o.name, true) && compareDeep(alias, o.alias, true)
        && compareDeep(telecom, o.telecom, true) && compareDeep(address, o.address, true)
        && compareDeep(partOf, o.partOf, true) && compareDeep(contact, o.contact, true)
        && compareDeep(endpoint, o.endpoint, true);
  }

  @Override
  public boolean equalsShallow(Base other_) {
    if (!super.equalsShallow(other_))
      return false;
    if (!(other_ instanceof Organization))
      return false;
    Organization o = (Organization) other_;
    return compareValues(active, o.active, true) && compareValues(name, o.name, true)
        && compareValues(alias, o.alias, true);
  }

  public boolean isEmpty() {
    return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(identifier, active, type, name, alias, telecom,
        address, partOf, contact, endpoint);
  }

  @Override
  public ResourceType getResourceType() {
    return ResourceType.Organization;
  }

  /**
   * Search parameter: <b>active</b>
   * <p>
   * Description: <b>Is the Organization record active</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.active</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "active", path = "Organization.active", description = "Is the Organization record active", type = "token")
  public static final String SP_ACTIVE = "active";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>active</b>
   * <p>
   * Description: <b>Is the Organization record active</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.active</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam ACTIVE = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_ACTIVE);

  /**
   * Search parameter: <b>address-city</b>
   * <p>
   * Description: <b>A city specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.city</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "address-city", path = "Organization.address.city", description = "A city specified in an address", type = "string")
  public static final String SP_ADDRESS_CITY = "address-city";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>address-city</b>
   * <p>
   * Description: <b>A city specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.city</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam ADDRESS_CITY = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_ADDRESS_CITY);

  /**
   * Search parameter: <b>address-country</b>
   * <p>
   * Description: <b>A country specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.country</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "address-country", path = "Organization.address.country", description = "A country specified in an address", type = "string")
  public static final String SP_ADDRESS_COUNTRY = "address-country";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>address-country</b>
   * <p>
   * Description: <b>A country specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.country</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam ADDRESS_COUNTRY = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_ADDRESS_COUNTRY);

  /**
   * Search parameter: <b>address-postalcode</b>
   * <p>
   * Description: <b>A postal code specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.postalCode</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "address-postalcode", path = "Organization.address.postalCode", description = "A postal code specified in an address", type = "string")
  public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>address-postalcode</b>
   * <p>
   * Description: <b>A postal code specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.postalCode</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam ADDRESS_POSTALCODE = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_ADDRESS_POSTALCODE);

  /**
   * Search parameter: <b>address-state</b>
   * <p>
   * Description: <b>A state specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.state</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "address-state", path = "Organization.address.state", description = "A state specified in an address", type = "string")
  public static final String SP_ADDRESS_STATE = "address-state";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>address-state</b>
   * <p>
   * Description: <b>A state specified in an address</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address.state</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam ADDRESS_STATE = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_ADDRESS_STATE);

  /**
   * Search parameter: <b>address-use</b>
   * <p>
   * Description: <b>A use code specified in an address</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.address.use</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "address-use", path = "Organization.address.use", description = "A use code specified in an address", type = "token")
  public static final String SP_ADDRESS_USE = "address-use";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>address-use</b>
   * <p>
   * Description: <b>A use code specified in an address</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.address.use</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam ADDRESS_USE = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_ADDRESS_USE);

  /**
   * Search parameter: <b>address</b>
   * <p>
   * Description: <b>A server defined search that may match any of the string
   * fields in the Address, including line, city, district, state, country,
   * postalCode, and/or text</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "address", path = "Organization.address", description = "A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text", type = "string")
  public static final String SP_ADDRESS = "address";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>address</b>
   * <p>
   * Description: <b>A server defined search that may match any of the string
   * fields in the Address, including line, city, district, state, country,
   * postalCode, and/or text</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.address</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam ADDRESS = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_ADDRESS);

  /**
   * Search parameter: <b>endpoint</b>
   * <p>
   * Description: <b>Technical endpoints providing access to services operated for
   * the organization</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Organization.endpoint</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "endpoint", path = "Organization.endpoint", description = "Technical endpoints providing access to services operated for the organization", type = "reference", target = {
      Endpoint.class })
  public static final String SP_ENDPOINT = "endpoint";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>endpoint</b>
   * <p>
   * Description: <b>Technical endpoints providing access to services operated for
   * the organization</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Organization.endpoint</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam ENDPOINT = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_ENDPOINT);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Organization:endpoint</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_ENDPOINT = new ca.uhn.fhir.model.api.Include(
      "Organization:endpoint").toLocked();

  /**
   * Search parameter: <b>identifier</b>
   * <p>
   * Description: <b>Any identifier for the organization (not the accreditation
   * issuer's identifier)</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.identifier</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "identifier", path = "Organization.identifier", description = "Any identifier for the organization (not the accreditation issuer's identifier)", type = "token")
  public static final String SP_IDENTIFIER = "identifier";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>identifier</b>
   * <p>
   * Description: <b>Any identifier for the organization (not the accreditation
   * issuer's identifier)</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.identifier</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam IDENTIFIER = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_IDENTIFIER);

  /**
   * Search parameter: <b>name</b>
   * <p>
   * Description: <b>A portion of the organization's name or alias</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.name | Organization.alias</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "name", path = "Organization.name | Organization.alias", description = "A portion of the organization's name or alias", type = "string")
  public static final String SP_NAME = "name";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>name</b>
   * <p>
   * Description: <b>A portion of the organization's name or alias</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.name | Organization.alias</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam NAME = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_NAME);

  /**
   * Search parameter: <b>partof</b>
   * <p>
   * Description: <b>An organization of which this organization forms a
   * part</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Organization.partOf</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "partof", path = "Organization.partOf", description = "An organization of which this organization forms a part", type = "reference", target = {
      Organization.class })
  public static final String SP_PARTOF = "partof";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>partof</b>
   * <p>
   * Description: <b>An organization of which this organization forms a
   * part</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Organization.partOf</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam PARTOF = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_PARTOF);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Organization:partof</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_PARTOF = new ca.uhn.fhir.model.api.Include(
      "Organization:partof").toLocked();

  /**
   * Search parameter: <b>phonetic</b>
   * <p>
   * Description: <b>A portion of the organization's name using some kind of
   * phonetic matching algorithm</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.name</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "phonetic", path = "Organization.name", description = "A portion of the organization's name using some kind of phonetic matching algorithm", type = "string")
  public static final String SP_PHONETIC = "phonetic";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>phonetic</b>
   * <p>
   * Description: <b>A portion of the organization's name using some kind of
   * phonetic matching algorithm</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Organization.name</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam PHONETIC = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_PHONETIC);

  /**
   * Search parameter: <b>type</b>
   * <p>
   * Description: <b>A code for the type of organization</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.type</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "type", path = "Organization.type", description = "A code for the type of organization", type = "token")
  public static final String SP_TYPE = "type";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>type</b>
   * <p>
   * Description: <b>A code for the type of organization</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Organization.type</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam TYPE = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_TYPE);

}
