/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.HTMLClientLogger;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.MetadataResourceManager;
import org.hl7.fhir.r5.context.TerminologyCache;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.terminologies.ValueSetCheckerSimple;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class BaseWorkerContext
implements IWorkerContext {
    private Object lock = new Object();
    private Map<String, Map<String, Resource>> allResourcesById = new HashMap<String, Map<String, Resource>>();
    private MetadataResourceManager<CodeSystem> codeSystems = new MetadataResourceManager();
    private Set<String> supportedCodeSystems = new HashSet<String>();
    private MetadataResourceManager<ValueSet> valueSets = new MetadataResourceManager();
    private MetadataResourceManager<ConceptMap> maps = new MetadataResourceManager();
    protected MetadataResourceManager<StructureMap> transforms = new MetadataResourceManager();
    private MetadataResourceManager<StructureDefinition> structures = new MetadataResourceManager();
    private MetadataResourceManager<ImplementationGuide> guides = new MetadataResourceManager();
    private MetadataResourceManager<CapabilityStatement> capstmts = new MetadataResourceManager();
    private MetadataResourceManager<SearchParameter> searchParameters = new MetadataResourceManager();
    private MetadataResourceManager<Questionnaire> questionnaires = new MetadataResourceManager();
    private MetadataResourceManager<OperationDefinition> operations = new MetadataResourceManager();
    private MetadataResourceManager<PlanDefinition> plans = new MetadataResourceManager();
    private List<NamingSystem> systems = new ArrayList<NamingSystem>();
    private UcumService ucumService;
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected String tsServer;
    protected String name;
    private boolean allowLoadingDuplicates;
    protected TerminologyClient txClient;
    protected HTMLClientLogger txLog;
    private TerminologyCapabilities txcaps;
    private boolean canRunWithoutTerminology;
    protected boolean noTerminologyServer;
    private int expandCodesLimit = 1000;
    protected IWorkerContext.ILoggingService logger;
    protected Parameters expParameters;
    private TranslationServices translator = new NullTranslator();
    protected TerminologyCache txCache;
    private boolean tlogging = true;
    private Set<String> notCanonical = new HashSet<String>();
    private String overrideVersionNs;

    public BaseWorkerContext() throws FileNotFoundException, IOException, FHIRException {
        this.txCache = new TerminologyCache(this.lock, null);
    }

    public BaseWorkerContext(MetadataResourceManager<CodeSystem> codeSystems, MetadataResourceManager<ValueSet> valueSets, MetadataResourceManager<ConceptMap> maps, MetadataResourceManager<StructureDefinition> profiles, MetadataResourceManager<ImplementationGuide> guides) throws FileNotFoundException, IOException, FHIRException {
        this.codeSystems = codeSystems;
        this.valueSets = valueSets;
        this.maps = maps;
        this.structures = profiles;
        this.guides = guides;
        this.txCache = new TerminologyCache(this.lock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(BaseWorkerContext other) {
        Object object = other.lock;
        synchronized (object) {
            this.allResourcesById.putAll(other.allResourcesById);
            this.translator = other.translator;
            this.codeSystems.copy(other.codeSystems);
            this.txcaps = other.txcaps;
            this.valueSets.copy(other.valueSets);
            this.maps.copy(other.maps);
            this.transforms.copy(other.transforms);
            this.structures.copy(other.structures);
            this.searchParameters.copy(other.searchParameters);
            this.plans.copy(other.plans);
            this.questionnaires.copy(other.questionnaires);
            this.operations.copy(other.operations);
            this.systems.addAll(other.systems);
            this.guides.copy(other.guides);
            this.capstmts.copy(other.capstmts);
            this.allowLoadingDuplicates = other.allowLoadingDuplicates;
            this.tsServer = other.tsServer;
            this.name = other.name;
            this.txClient = other.txClient;
            this.txLog = other.txLog;
            this.txcaps = other.txcaps;
            this.canRunWithoutTerminology = other.canRunWithoutTerminology;
            this.noTerminologyServer = other.noTerminologyServer;
            if (other.txCache != null) {
                this.txCache = other.txCache.copy();
            }
            this.expandCodesLimit = other.expandCodesLimit;
            this.logger = other.logger;
            this.expParameters = other.expParameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheResource(Resource r) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Resource> map = this.allResourcesById.get(r.fhirType());
            if (map == null) {
                map = new HashMap<String, Resource>();
                this.allResourcesById.put(r.fhirType(), map);
            }
            map.put(r.getId(), r);
            if (r instanceof MetadataResource) {
                MetadataResource m = (MetadataResource)r;
                String url = m.getUrl();
                if (!this.allowLoadingDuplicates && this.hasResource(r.getClass(), url)) {
                    throw new DefinitionException("Duplicate Resource " + url);
                }
                if (r instanceof StructureDefinition) {
                    this.structures.see((StructureDefinition)m);
                } else if (r instanceof ValueSet) {
                    this.valueSets.see((ValueSet)m);
                } else if (r instanceof CodeSystem) {
                    this.codeSystems.see((CodeSystem)m);
                } else if (r instanceof ImplementationGuide) {
                    this.guides.see((ImplementationGuide)m);
                } else if (r instanceof CapabilityStatement) {
                    this.capstmts.see((CapabilityStatement)m);
                } else if (r instanceof SearchParameter) {
                    this.searchParameters.see((SearchParameter)m);
                } else if (r instanceof PlanDefinition) {
                    this.plans.see((PlanDefinition)m);
                } else if (r instanceof OperationDefinition) {
                    this.operations.see((OperationDefinition)m);
                } else if (r instanceof Questionnaire) {
                    this.questionnaires.see((Questionnaire)m);
                } else if (r instanceof ConceptMap) {
                    this.maps.see((ConceptMap)m);
                } else if (r instanceof StructureMap) {
                    this.transforms.see((StructureMap)m);
                } else if (r instanceof NamingSystem) {
                    this.systems.add((NamingSystem)r);
                }
            }
        }
    }

    private boolean laterVersion(String newVersion, String oldVersion) {
        newVersion = newVersion.trim();
        oldVersion = oldVersion.trim();
        if (StringUtils.isNumeric((CharSequence)newVersion) && StringUtils.isNumeric((CharSequence)oldVersion)) {
            return Double.parseDouble(newVersion) > Double.parseDouble(oldVersion);
        }
        if (this.hasDelimiter(newVersion, oldVersion, ".")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\.");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "-")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\-");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "_")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\_");
        }
        if (this.hasDelimiter(newVersion, oldVersion, ":")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\:");
        }
        if (this.hasDelimiter(newVersion, oldVersion, " ")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\ ");
        }
        return newVersion.compareTo(oldVersion) > 0;
    }

    private boolean hasDelimiter(String s1, String s2, String delimiter) {
        return s1.contains(delimiter) && s2.contains(delimiter) && s1.split(delimiter).length == s2.split(delimiter).length;
    }

    private boolean laterDelimitedVersion(String newVersion, String oldVersion, String delimiter) {
        String[] newParts = newVersion.split(delimiter);
        String[] oldParts = oldVersion.split(delimiter);
        for (int i = 0; i < newParts.length; ++i) {
            if (newParts[i].equals(oldParts[i])) continue;
            return this.laterVersion(newParts[i], oldParts[i]);
        }
        throw new Error("Delimited versions have exact match for delimiter '" + delimiter + "' : " + newParts + " vs " + oldParts);
    }

    protected <T extends MetadataResource> void seeMetadataResource(T r, Map<String, T> map, List<T> list, boolean addId) throws FHIRException {
        list.add(r);
        if (r.hasUrl()) {
            if (r.hasVersion()) {
                map.put(r.getUrl() + "|" + r.getVersion(), r);
            }
            if (!map.containsKey(r.getUrl())) {
                map.put(r.getUrl(), r);
            } else {
                ArrayList<MetadataResource> rl = new ArrayList<MetadataResource>();
                for (MetadataResource t : list) {
                    if (!t.getUrl().equals(r.getUrl()) || rl.contains(t)) continue;
                    rl.add(t);
                }
                Collections.sort(rl, new MetadataResourceVersionComparator<T>(list));
                map.put(r.getUrl(), (MetadataResource)rl.get(rl.size() - 1));
                MetadataResource latest = null;
                for (MetadataResource t : rl) {
                    if (!VersionUtilities.versionsCompatible((String)t.getVersion(), (String)r.getVersion())) continue;
                    latest = t;
                }
                if (latest != null) {
                    map.put(r.getUrl() + "|" + VersionUtilities.getMajMin((String)latest.getVersion()), (MetadataResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeSystem fetchCodeSystem(String system) {
        Object object = this.lock;
        synchronized (object) {
            return this.codeSystems.get(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSystem(String system) throws TerminologyServiceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.codeSystems.has(system) && this.codeSystems.get(system).getContent() != CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                return true;
            }
            if (this.supportedCodeSystems.contains(system)) {
                return true;
            }
            if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
                return false;
            }
            if (this.noTerminologyServer) {
                return false;
            }
            if (this.txcaps == null) {
                try {
                    this.log("Terminology server: Check for supported code systems for " + system);
                    this.txcaps = this.txClient.getTerminologyCapabilities();
                }
                catch (Exception e) {
                    if (this.canRunWithoutTerminology) {
                        this.noTerminologyServer = true;
                        this.log("==============!! Running without terminology server !! ==============");
                        if (this.txClient != null) {
                            this.log("txServer = " + this.txClient.getAddress());
                            this.log("Error = " + e.getMessage() + "");
                        }
                        this.log("=====================================================================");
                        return false;
                    }
                    throw new TerminologyServiceException((Throwable)e);
                }
                if (this.txcaps != null) {
                    for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tccs : this.txcaps.getCodeSystem()) {
                        this.supportedCodeSystems.add(tccs.getUri());
                    }
                }
                if (this.supportedCodeSystems.contains(system)) {
                    return true;
                }
            }
            return false;
        }
    }

    private void log(String message) {
        if (this.logger != null) {
            this.logger.logMessage(message);
        } else {
            System.out.println(message);
        }
    }

    protected void tlog(String msg) {
        if (this.tlogging) {
            if (this.logger != null) {
                this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.TX, msg);
            } else {
                System.out.println("-tx: " + msg);
            }
        }
    }

    public int getExpandCodesLimit() {
        return this.expandCodesLimit;
    }

    public void setExpandCodesLimit(int expandCodesLimit) {
        this.expandCodesLimit = expandCodesLimit;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heirarchical) throws FHIRException {
        ValueSet vs = null;
        vs = this.fetchResource(ValueSet.class, binding.getValueSet());
        if (vs == null) {
            throw new FHIRException("Unable to resolve value Set " + binding.getValueSet());
        }
        return this.expandVS(vs, cacheOk, heirarchical);
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean heirachical) throws TerminologyServiceException {
        ValueSetExpander.ValueSetExpansionOutcome res;
        TerminologyCache.CacheToken cacheToken;
        block4: {
            ValueSet vs = new ValueSet();
            vs.setCompose(new ValueSet.ValueSetComposeComponent());
            vs.getCompose().getInclude().add(inc);
            cacheToken = this.txCache.generateExpandToken(vs, heirachical);
            res = this.txCache.getExpansion(cacheToken);
            if (res != null) {
                return res;
            }
            Parameters p = this.expParameters.copy();
            p.setParameter("includeDefinition", false);
            p.setParameter("excludeNested", !heirachical);
            if (this.noTerminologyServer) {
                return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", Integer.toString(this.expandCodesLimit));
            params.put("_incomplete", "true");
            this.tlog("$expand on " + this.txCache.summary(vs));
            try {
                ValueSet result = this.txClient.expandValueset(vs, p, params);
                res = new ValueSetExpander.ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
            }
            catch (Exception e) {
                res = new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
                if (this.txLog == null) break block4;
                res.setTxLink(this.txLog.getLastId());
            }
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical) {
        if (this.expParameters == null) {
            throw new Error("No Expansion Parameters provided");
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, p);
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical, Parameters p) {
        ValueSetExpander.ValueSetExpansionOutcome res;
        if (p == null) {
            throw new Error("No Parameters provided to expandVS");
        }
        if (vs.hasExpansion()) {
            return new ValueSetExpander.ValueSetExpansionOutcome(vs.copy());
        }
        if (!vs.hasUrl()) {
            throw new Error("no value set");
        }
        TerminologyCache.CacheToken cacheToken = this.txCache.generateExpandToken(vs, heirarchical);
        if (cacheOk && (res = this.txCache.getExpansion(cacheToken)) != null) {
            return res;
        }
        p.setParameter("includeDefinition", false);
        p.setParameter("excludeNested", !heirarchical);
        try {
            ValueSetExpanderSimple vse = new ValueSetExpanderSimple(this);
            res = vse.doExpand(vs, p);
            if (!res.getValueset().hasUrl()) {
                throw new Error("no url in expand value set");
            }
            this.txCache.cacheExpansion(cacheToken, res, false);
            return res;
        }
        catch (Exception vse) {
            if (this.noTerminologyServer) {
                return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", Integer.toString(this.expandCodesLimit));
            params.put("_incomplete", "true");
            this.tlog("$expand on " + this.txCache.summary(vs));
            try {
                ValueSet result = this.txClient.expandValueset(vs, p, params);
                if (!result.hasUrl()) {
                    result.setUrl(vs.getUrl());
                }
                if (!result.hasUrl()) {
                    throw new Error("no url in expand value set 2");
                }
                res = new ValueSetExpander.ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
            }
            catch (Exception e) {
                res = new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
            }
            this.txCache.cacheExpansion(cacheToken, res, true);
            return res;
        }
    }

    private boolean hasTooCostlyExpansion(ValueSet valueset) {
        return valueset != null && valueset.hasExpansion() && ToolingExtensions.hasExtension(valueset.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions options, String system, String code, String display) {
        Coding c = new Coding(system, code, display);
        return this.validateCode(options, c, null);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions options, String system, String code, String display, ValueSet vs) {
        Coding c = new Coding(system, code, display);
        return this.validateCode(options, c, vs);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions options, String code, ValueSet vs) {
        Coding c = new Coding(null, code, null);
        return this.doValidateCode(options, c, vs, true);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions options, String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
        Coding c = new Coding(system, code, display);
        ValueSet vs = new ValueSet();
        vs.setUrl(Utilities.makeUuidUrn());
        vs.getCompose().addInclude(vsi);
        return this.validateCode(options, c, vs);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions options, Coding code, ValueSet vs) {
        return this.doValidateCode(options, code, vs, false);
    }

    public IWorkerContext.ValidationResult doValidateCode(TerminologyServiceOptions options, Coding code, ValueSet vs, boolean implySystem) {
        TerminologyCache.CacheToken cacheToken = this.txCache != null ? this.txCache.generateValidationToken(options, code, vs) : null;
        IWorkerContext.ValidationResult res = null;
        if (this.txCache != null) {
            res = this.txCache.getValidation(cacheToken);
        }
        if (res != null) {
            return res;
        }
        try {
            ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(options, vs, this);
            res = vsc.validateCode(code);
            if (this.txCache != null) {
                this.txCache.cacheValidation(cacheToken, res, false);
            }
            return res;
        }
        catch (Exception vsc) {
            String csumm;
            if (this.noTerminologyServer) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            String string = csumm = this.txCache != null ? this.txCache.summary(code) : null;
            if (this.txCache != null) {
                this.tlog("$validate " + csumm + " for " + this.txCache.summary(vs));
            } else {
                this.tlog("$validate " + csumm + " before cache exists");
            }
            try {
                Parameters pIn = new Parameters();
                pIn.addParameter().setName("coding").setValue(code);
                if (implySystem) {
                    pIn.addParameter().setName("implySystem").setValue(new BooleanType(true));
                }
                if (options != null) {
                    this.setTerminologyOptions(options, pIn);
                }
                res = this.validateOnServer(vs, pIn);
            }
            catch (Exception e) {
                res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage()).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
            }
            if (this.txCache != null) {
                this.txCache.cacheValidation(cacheToken, res, true);
            }
            return res;
        }
    }

    private void setTerminologyOptions(TerminologyServiceOptions options, Parameters pIn) {
        if (options != null && !Utilities.noString((String)options.getLanguage())) {
            pIn.addParameter("displayLanguage", options.getLanguage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions options, CodeableConcept code, ValueSet vs) {
        TerminologyCache.CacheToken cacheToken = this.txCache.generateValidationToken(options, code, vs);
        IWorkerContext.ValidationResult res = this.txCache.getValidation(cacheToken);
        if (res != null) {
            return res;
        }
        try {
            ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(options, vs, this);
            res = vsc.validateCode(code);
            this.txCache.cacheValidation(cacheToken, res, false);
            return res;
        }
        catch (Exception vsc) {
            if (this.noTerminologyServer) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            this.tlog("$validate " + this.txCache.summary(code) + " for " + this.txCache.summary(vs));
            try {
                Parameters pIn = new Parameters();
                pIn.addParameter().setName("codeableConcept").setValue(code);
                if (options != null) {
                    this.setTerminologyOptions(options, pIn);
                }
                res = this.validateOnServer(vs, pIn);
            }
            catch (Exception e) {
                res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage()).setTxLink(this.txLog.getLastId());
            }
            this.txCache.cacheValidation(cacheToken, res, true);
            return res;
        }
    }

    private IWorkerContext.ValidationResult validateOnServer(ValueSet vs, Parameters pin) throws FHIRException {
        if (vs != null) {
            pin.addParameter().setName("valueSet").setResource(vs);
        }
        for (Parameters.ParametersParameterComponent pp : pin.getParameter()) {
            if (!pp.getName().equals("profile")) continue;
            throw new Error("Can only specify profile in the context");
        }
        if (this.expParameters == null) {
            throw new Error("No ExpansionProfile provided");
        }
        pin.addParameter().setName("profile").setResource(this.expParameters);
        this.txLog.clearLastId();
        Parameters pOut = vs == null ? this.txClient.validateCS(pin) : this.txClient.validateVS(pin);
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        ValueSetExpander.TerminologyServiceErrorClass err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
        for (Parameters.ParametersParameterComponent p : pOut.getParameter()) {
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("display")) {
                display = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (!p.getName().equals("cause")) continue;
            try {
                ValidationMessage.IssueType it = ValidationMessage.IssueType.fromCode((String)((String)((StringType)p.getValue()).getValue()));
                if (it == ValidationMessage.IssueType.UNKNOWN) {
                    err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
                    continue;
                }
                if (it != ValidationMessage.IssueType.NOTSUPPORTED) continue;
                err = ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED;
            }
            catch (FHIRException fHIRException) {}
        }
        if (!ok) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, message, err).setTxLink(this.txLog.getLastId()).setTxLink(this.txLog.getLastId());
        }
        if (message != null && !message.equals("No Message returned")) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, message, new CodeSystem.ConceptDefinitionComponent().setDisplay(display)).setTxLink(this.txLog.getLastId()).setTxLink(this.txLog.getLastId());
        }
        if (display != null) {
            return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setDisplay(display)).setTxLink(this.txLog.getLastId()).setTxLink(this.txLog.getLastId());
        }
        return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent()).setTxLink(this.txLog.getLastId()).setTxLink(this.txLog.getLastId());
    }

    public void initTS(String cachePath) throws Exception {
        this.txCache = new TerminologyCache(this.lock, cachePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConceptMap> findMapsForSource(String url) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ConceptMap> res = new ArrayList<ConceptMap>();
            for (ConceptMap map : this.maps.getList()) {
                if (!((Reference)map.getSource()).getReference().equals(url)) continue;
                res.add(map);
            }
            return res;
        }
    }

    public boolean isCanRunWithoutTerminology() {
        return this.canRunWithoutTerminology;
    }

    public void setCanRunWithoutTerminology(boolean canRunWithoutTerminology) {
        this.canRunWithoutTerminology = canRunWithoutTerminology;
    }

    @Override
    public void setLogger(IWorkerContext.ILoggingService logger) {
        this.logger = logger;
    }

    @Override
    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    @Override
    public void setExpansionProfile(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    @Override
    public boolean isNoTerminologyServer() {
        return this.noTerminologyServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Set<String> getResourceNamesAsSet() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getResourceNames());
        return res;
    }

    public boolean isAllowLoadingDuplicates() {
        return this.allowLoadingDuplicates;
    }

    public void setAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
        this.allowLoadingDuplicates = allowLoadingDuplicates;
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        if (class_ == StructureDefinition.class) {
            uri = ProfileUtilities.sdNs(uri, this.getOverrideVersionNs());
        }
        Object object = this.lock;
        synchronized (object) {
            if (uri.startsWith("http:") || uri.startsWith("https:")) {
                String version = null;
                if (uri.contains("|")) {
                    version = uri.substring(uri.lastIndexOf("|") + 1);
                    uri = uri.substring(0, uri.lastIndexOf("|"));
                }
                if (uri.contains("#")) {
                    uri = uri.substring(0, uri.indexOf("#"));
                }
                if (class_ == Resource.class || class_ == null) {
                    if (this.structures.has(uri)) {
                        return (T)this.structures.get(uri);
                    }
                    if (this.guides.has(uri)) {
                        return (T)this.guides.get(uri);
                    }
                    if (this.capstmts.has(uri)) {
                        return (T)this.capstmts.get(uri);
                    }
                    if (this.valueSets.has(uri)) {
                        return (T)this.valueSets.get(uri);
                    }
                    if (this.codeSystems.has(uri)) {
                        return (T)this.codeSystems.get(uri);
                    }
                    if (this.operations.has(uri)) {
                        return (T)this.operations.get(uri);
                    }
                    if (this.searchParameters.has(uri)) {
                        return (T)this.searchParameters.get(uri);
                    }
                    if (this.plans.has(uri)) {
                        return (T)this.plans.get(uri);
                    }
                    if (this.maps.has(uri)) {
                        return (T)this.maps.get(uri);
                    }
                    if (this.transforms.has(uri)) {
                        return (T)this.transforms.get(uri);
                    }
                    if (this.questionnaires.has(uri)) {
                        return (T)this.questionnaires.get(uri);
                    }
                    for (Map<String, Resource> rt : this.allResourcesById.values()) {
                        for (Resource r : rt.values()) {
                            MetadataResource mr;
                            if (!(r instanceof MetadataResource) || !uri.equals((mr = (MetadataResource)r).getUrl())) continue;
                            return (T)mr;
                        }
                    }
                    return null;
                }
                if (class_ == ImplementationGuide.class) {
                    return (T)this.guides.get(uri);
                }
                if (class_ == CapabilityStatement.class) {
                    return (T)this.capstmts.get(uri);
                }
                if (class_ == StructureDefinition.class) {
                    return (T)this.structures.get(uri);
                }
                if (class_ == StructureMap.class) {
                    return (T)this.transforms.get(uri);
                }
                if (class_ == ValueSet.class) {
                    if (this.valueSets.has(uri, version)) {
                        return (T)this.valueSets.get(uri, version);
                    }
                    return (T)this.valueSets.get(uri);
                }
                if (class_ == CodeSystem.class) {
                    if (this.codeSystems.has(uri, version)) {
                        return (T)this.codeSystems.get(uri, version);
                    }
                    return (T)this.codeSystems.get(uri);
                }
                if (class_ == ConceptMap.class) {
                    return (T)this.maps.get(uri);
                }
                if (class_ == PlanDefinition.class) {
                    return (T)this.plans.get(uri);
                }
                if (class_ == OperationDefinition.class) {
                    OperationDefinition od = this.operations.get(uri);
                    return (T)od;
                }
                if (class_ == SearchParameter.class) {
                    SearchParameter res = this.searchParameters.get(uri);
                    return (T)res;
                }
            }
            if (class_ == CodeSystem.class && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri);
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri);
            }
            if (class_ == null) {
                T res;
                if (uri.matches("((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CapabilityStatement2|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|ClinicalUseIssue|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationUsage|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|Topic|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                if ((Utilities.isAbsoluteUrl((String)uri) || uri.startsWith("ValueSet/")) && (res = null) != null) {
                    return res;
                }
                return null;
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException("not done yet: can't fetch " + uri);
        }
    }

    @Override
    public Resource fetchResourceById(String type, String uri) {
        Object object = this.lock;
        synchronized (object) {
            String[] parts = uri.split("\\/");
            if (!Utilities.noString((String)type) && parts.length == 1) {
                if (this.allResourcesById.containsKey(type)) {
                    return this.allResourcesById.get(type).get(parts[0]);
                }
                return null;
            }
            if (parts.length >= 2) {
                if (!Utilities.noString((String)type) && !type.equals(parts[parts.length - 2])) {
                    throw new Error("Resource type mismatch for " + type + " / " + uri);
                }
                return this.allResourcesById.get(parts[parts.length - 2]).get(parts[parts.length - 1]);
            }
            throw new Error("Unable to process request for resource for " + type + " / " + uri);
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public TranslationServices translator() {
        return this.translator;
    }

    public void setTranslator(TranslationServices translator) {
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportStatus(JsonObject json) {
        Object object = this.lock;
        synchronized (object) {
            json.addProperty("codeystem-count", (Number)this.codeSystems.size());
            json.addProperty("valueset-count", (Number)this.valueSets.size());
            json.addProperty("conceptmap-count", (Number)this.maps.size());
            json.addProperty("transforms-count", (Number)this.transforms.size());
            json.addProperty("structures-count", (Number)this.structures.size());
            json.addProperty("guides-count", (Number)this.guides.size());
            json.addProperty("statements-count", (Number)this.capstmts.size());
        }
    }

    public void dropResource(Resource r) throws FHIRException {
        this.dropResource(r.fhirType(), r.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropResource(String fhirType, String id) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Resource> map = this.allResourcesById.get(fhirType);
            if (map == null) {
                map = new HashMap<String, Resource>();
                this.allResourcesById.put(fhirType, map);
            }
            if (map.containsKey(id)) {
                map.remove(id);
            }
            if (fhirType.equals("StructureDefinition")) {
                this.structures.drop(id);
            } else if (fhirType.equals("ImplementationGuide")) {
                this.guides.drop(id);
            } else if (fhirType.equals("CapabilityStatement")) {
                this.capstmts.drop(id);
            } else if (fhirType.equals("ValueSet")) {
                this.valueSets.drop(id);
            } else if (fhirType.equals("CodeSystem")) {
                this.codeSystems.drop(id);
            } else if (fhirType.equals("OperationDefinition")) {
                this.operations.drop(id);
            } else if (fhirType.equals("Questionnaire")) {
                this.questionnaires.drop(id);
            } else if (fhirType.equals("ConceptMap")) {
                this.maps.drop(id);
            } else if (fhirType.equals("StructureMap")) {
                this.transforms.drop(id);
            } else if (fhirType.equals("NamingSystem")) {
                for (int i = this.systems.size() - 1; i >= 0; --i) {
                    if (!this.systems.get(i).getId().equals(id)) continue;
                    this.systems.remove(i);
                }
            }
        }
    }

    private <T extends MetadataResource> void dropMetadataResource(Map<String, T> map, String id) {
        MetadataResource res = (MetadataResource)map.get(id);
        if (res != null) {
            map.remove(id);
            if (map.containsKey(res.getUrl())) {
                map.remove(res.getUrl());
            }
            if (res.getVersion() != null && map.containsKey(res.getUrl() + "|" + res.getVersion())) {
                map.remove(res.getUrl() + "|" + res.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetadataResource> allConformanceResources() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<MetadataResource> result = new ArrayList<MetadataResource>();
            this.structures.listAllM(result);
            this.guides.listAllM(result);
            this.capstmts.listAllM(result);
            this.codeSystems.listAllM(result);
            this.valueSets.listAllM(result);
            this.maps.listAllM(result);
            this.transforms.listAllM(result);
            this.plans.listAllM(result);
            this.questionnaires.listAllM(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSupportedSystems() {
        Object object = this.lock;
        synchronized (object) {
            String sl = null;
            for (String s : this.supportedCodeSystems) {
                sl = sl == null ? s : sl + "\r\n" + s;
            }
            return sl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueSets.size() + this.maps.size() + this.structures.size() + this.transforms.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConceptMap> listMaps() {
        ArrayList<ConceptMap> m = new ArrayList<ConceptMap>();
        Object object = this.lock;
        synchronized (object) {
            this.maps.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StructureMap> listTransforms() {
        ArrayList<StructureMap> m = new ArrayList<StructureMap>();
        Object object = this.lock;
        synchronized (object) {
            this.transforms.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StructureMap getTransform(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.transforms.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StructureDefinition> listStructures() {
        ArrayList<StructureDefinition> m = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            this.structures.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureDefinition getStructure(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.structures.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String oid2Uri(String oid) {
        Object object = this.lock;
        synchronized (object) {
            String uri = OIDUtils.getUriForOid((String)oid);
            if (uri != null) {
                return uri;
            }
            for (NamingSystem ns : this.systems) {
                if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
                return null;
            }
        }
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheVS(JsonObject json, Map<String, IWorkerContext.ValidationResult> t) {
        Object object = this.lock;
        synchronized (object) {
            this.validationCache.put(json.get("url").getAsString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchParameter getSearchParameter(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.searchParameters.get(code);
        }
    }

    @Override
    public String getOverrideVersionNs() {
        return this.overrideVersionNs;
    }

    @Override
    public void setOverrideVersionNs(String value) {
        this.overrideVersionNs = value;
    }

    @Override
    public IWorkerContext.ILoggingService getLogger() {
        return this.logger;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        if (Utilities.isAbsoluteUrl((String)typeName)) {
            return this.fetchResource(StructureDefinition.class, typeName);
        }
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public boolean isTlogging() {
        return this.tlogging;
    }

    public void setTlogging(boolean tlogging) {
        this.tlogging = tlogging;
    }

    @Override
    public UcumService getUcumService() {
        return this.ucumService;
    }

    @Override
    public void setUcumService(UcumService ucumService) {
        this.ucumService = ucumService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StructureDefinition> getStructures() {
        ArrayList<StructureDefinition> res = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            this.structures.listAll(res);
        }
        return res;
    }

    @Override
    public String getLinkForUrl(String corePath, String url) {
        if (this.codeSystems.has(url)) {
            return this.codeSystems.get(url).getUserString("path");
        }
        if (this.valueSets.has(url)) {
            return this.valueSets.get(url).getUserString("path");
        }
        if (this.maps.has(url)) {
            return this.maps.get(url).getUserString("path");
        }
        if (this.transforms.has(url)) {
            return this.transforms.get(url).getUserString("path");
        }
        if (this.structures.has(url)) {
            return this.structures.get(url).getUserString("path");
        }
        if (this.guides.has(url)) {
            return this.guides.get(url).getUserString("path");
        }
        if (this.capstmts.has(url)) {
            return this.capstmts.get(url).getUserString("path");
        }
        if (this.searchParameters.has(url)) {
            return this.searchParameters.get(url).getUserString("path");
        }
        if (this.questionnaires.has(url)) {
            return this.questionnaires.get(url).getUserString("path");
        }
        if (this.operations.has(url)) {
            return this.operations.get(url).getUserString("path");
        }
        if (this.plans.has(url)) {
            return this.plans.get(url).getUserString("path");
        }
        if (url.equals("http://loinc.org")) {
            return corePath + "loinc.html";
        }
        if (url.equals("http://unitsofmeasure.org")) {
            return corePath + "ucum.html";
        }
        if (url.equals("http://snomed.info/sct")) {
            return corePath + "snomed.html";
        }
        return null;
    }

    public List<ImplementationGuide> allImplementationGuides() {
        ArrayList<ImplementationGuide> res = new ArrayList<ImplementationGuide>();
        this.guides.listAll(res);
        return res;
    }

    public class NullTranslator
    implements TranslationServices {
        public String translate(String context, String value, String targetLang) {
            return value;
        }

        public String translate(String context, String value) {
            return value;
        }

        public String toStr(float value) {
            return null;
        }

        public String toStr(Date value) {
            return null;
        }

        public String translateAndFormat(String contest, String lang, String value, Object ... args) {
            return String.format(value, args);
        }

        public Map<String, String> translations(String value) {
            return null;
        }

        public Set<String> listTranslations(String category) {
            return null;
        }
    }

    public class MetadataResourceVersionComparator<T extends MetadataResource>
    implements Comparator<T> {
        private List<T> list;

        public MetadataResourceVersionComparator(List<T> list) {
            this.list = list;
        }

        @Override
        public int compare(T arg1, T arg2) {
            String v1 = ((MetadataResource)arg1).getVersion();
            String v2 = ((MetadataResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(this.list.indexOf(arg1), this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }
}

