/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Type;

@DatatypeDef(name="BackboneElement")
public abstract class BackboneType
extends Type
implements IBaseBackboneElement {
    @Child(name="modifierExtension", type={Extension.class}, order=0, min=0, max=-1, modifier=true, summary=true)
    @Description(shortDefinition="Extensions that cannot be ignored", formalDefinition="May be used to represent additional information that is not part of the basic definition of the element, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.")
    protected List<Extension> modifierExtension;
    private static final long serialVersionUID = -1431673179L;

    public List<Extension> getModifierExtension() {
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        return this.modifierExtension;
    }

    public BackboneType setModifierExtension(List<Extension> theModifierExtension) {
        this.modifierExtension = theModifierExtension;
        return this;
    }

    public boolean hasModifierExtension() {
        if (this.modifierExtension == null) {
            return false;
        }
        for (Extension item : this.modifierExtension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addModifierExtension() {
        Extension t = new Extension();
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return t;
    }

    public BackboneType addModifierExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return this;
    }

    public Extension getModifierExtensionFirstRep() {
        if (this.getModifierExtension().isEmpty()) {
            this.addModifierExtension();
        }
        return this.getModifierExtension().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        children.add(new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.", 0, Integer.MAX_VALUE, this.modifierExtension));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -298878168: {
                return new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.", 0, Integer.MAX_VALUE, this.modifierExtension);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -298878168: {
                return this.modifierExtension == null ? new Base[]{} : this.modifierExtension.toArray(new Base[this.modifierExtension.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -298878168: {
                this.getModifierExtension().add(this.castToExtension(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("modifierExtension")) {
            return super.setProperty(name, value);
        }
        this.getModifierExtension().add(this.castToExtension(value));
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -298878168: {
                return this.addModifierExtension();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -298878168: {
                return new String[]{"Extension"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("modifierExtension")) {
            return this.addModifierExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BackboneElement";
    }

    @Override
    public abstract BackboneType copy();

    public void copyValues(BackboneType dst) {
        super.copyValues(dst);
        if (this.modifierExtension != null) {
            dst.modifierExtension = new ArrayList<Extension>();
            for (Extension i : this.modifierExtension) {
                dst.modifierExtension.add(i.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BackboneType)) {
            return false;
        }
        BackboneType o = (BackboneType)other_;
        return BackboneType.compareDeep(this.modifierExtension, o.modifierExtension, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BackboneType)) {
            return false;
        }
        BackboneType o = (BackboneType)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.modifierExtension);
    }

    public void checkNoModifiers(String noun, String verb) throws FHIRException {
        if (this.hasModifierExtension()) {
            throw new FHIRException("Found unknown Modifier Exceptions on " + noun + " doing " + verb);
        }
    }
}

