/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.ProdCharacteristic;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;

@ResourceDef(name="ManufacturedItemDefinition", profile="http://hl7.org/fhir/StructureDefinition/ManufacturedItemDefinition")
public class ManufacturedItemDefinition
extends DomainResource {
    @Child(name="manufacturedDoseForm", type={CodeableConcept.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product", formalDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product.")
    protected CodeableConcept manufacturedDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described", formalDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described.")
    protected CodeableConcept unitOfPresentation;
    @Child(name="manufacturer", type={Organization.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues)", formalDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).")
    protected List<Reference> manufacturer;
    @Child(name="ingredient", type={Ingredient.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Ingredient", formalDefinition="Ingredient.")
    protected List<Reference> ingredient;
    @Child(name="physicalCharacteristics", type={ProdCharacteristic.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dimensions, color etc.", formalDefinition="Dimensions, color etc.")
    protected ProdCharacteristic physicalCharacteristics;
    @Child(name="otherCharacteristics", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other codeable characteristics", formalDefinition="Other codeable characteristics.")
    protected List<CodeableConcept> otherCharacteristics;
    private static final long serialVersionUID = -533921707L;

    public ManufacturedItemDefinition() {
    }

    public ManufacturedItemDefinition(CodeableConcept manufacturedDoseForm) {
        this.manufacturedDoseForm = manufacturedDoseForm;
    }

    public CodeableConcept getManufacturedDoseForm() {
        if (this.manufacturedDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.manufacturedDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturedDoseForm = new CodeableConcept();
            }
        }
        return this.manufacturedDoseForm;
    }

    public boolean hasManufacturedDoseForm() {
        return this.manufacturedDoseForm != null && !this.manufacturedDoseForm.isEmpty();
    }

    public ManufacturedItemDefinition setManufacturedDoseForm(CodeableConcept value) {
        this.manufacturedDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public ManufacturedItemDefinition setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public ManufacturedItemDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public ManufacturedItemDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<Reference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        return this.ingredient;
    }

    public ManufacturedItemDefinition setIngredient(List<Reference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (Reference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIngredient() {
        Reference t = new Reference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIngredient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public Reference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public ProdCharacteristic getPhysicalCharacteristics() {
        if (this.physicalCharacteristics == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.physicalCharacteristics");
            }
            if (Configuration.doAutoCreate()) {
                this.physicalCharacteristics = new ProdCharacteristic();
            }
        }
        return this.physicalCharacteristics;
    }

    public boolean hasPhysicalCharacteristics() {
        return this.physicalCharacteristics != null && !this.physicalCharacteristics.isEmpty();
    }

    public ManufacturedItemDefinition setPhysicalCharacteristics(ProdCharacteristic value) {
        this.physicalCharacteristics = value;
        return this;
    }

    public List<CodeableConcept> getOtherCharacteristics() {
        if (this.otherCharacteristics == null) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>();
        }
        return this.otherCharacteristics;
    }

    public ManufacturedItemDefinition setOtherCharacteristics(List<CodeableConcept> theOtherCharacteristics) {
        this.otherCharacteristics = theOtherCharacteristics;
        return this;
    }

    public boolean hasOtherCharacteristics() {
        if (this.otherCharacteristics == null) {
            return false;
        }
        for (CodeableConcept item : this.otherCharacteristics) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addOtherCharacteristics() {
        CodeableConcept t = new CodeableConcept();
        if (this.otherCharacteristics == null) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>();
        }
        this.otherCharacteristics.add(t);
        return t;
    }

    public ManufacturedItemDefinition addOtherCharacteristics(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.otherCharacteristics == null) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>();
        }
        this.otherCharacteristics.add(t);
        return this;
    }

    public CodeableConcept getOtherCharacteristicsFirstRep() {
        if (this.getOtherCharacteristics().isEmpty()) {
            this.addOtherCharacteristics();
        }
        return this.getOtherCharacteristics().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("ingredient", "Reference(Ingredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics));
        children.add(new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1451400348: {
                return new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -206409263: {
                return new Property("ingredient", "Reference(Ingredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -1599676319: {
                return new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics);
            }
            case 722135304: {
                return new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1451400348: {
                Base[] baseArray;
                if (this.manufacturedDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.manufacturedDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -1599676319: {
                Base[] baseArray;
                if (this.physicalCharacteristics == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.physicalCharacteristics;
                }
                return baseArray;
            }
            case 722135304: {
                return this.otherCharacteristics == null ? new Base[]{} : this.otherCharacteristics.toArray(new Base[this.otherCharacteristics.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1451400348: {
                this.manufacturedDoseForm = this.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = this.castToCodeableConcept(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(this.castToReference(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(this.castToReference(value));
                return value;
            }
            case -1599676319: {
                this.physicalCharacteristics = this.castToProdCharacteristic(value);
                return value;
            }
            case 722135304: {
                this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = this.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = this.castToCodeableConcept(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(this.castToReference(value));
        } else if (name.equals("ingredient")) {
            this.getIngredient().add(this.castToReference(value));
        } else if (name.equals("physicalCharacteristics")) {
            this.physicalCharacteristics = this.castToProdCharacteristic(value);
        } else if (name.equals("otherCharacteristics")) {
            this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1451400348: {
                return this.getManufacturedDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -1599676319: {
                return this.getPhysicalCharacteristics();
            }
            case 722135304: {
                return this.addOtherCharacteristics();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1451400348: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -206409263: {
                return new String[]{"Reference"};
            }
            case -1599676319: {
                return new String[]{"ProdCharacteristic"};
            }
            case 722135304: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = new CodeableConcept();
            return this.manufacturedDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        if (name.equals("physicalCharacteristics")) {
            this.physicalCharacteristics = new ProdCharacteristic();
            return this.physicalCharacteristics;
        }
        if (name.equals("otherCharacteristics")) {
            return this.addOtherCharacteristics();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ManufacturedItemDefinition";
    }

    @Override
    public ManufacturedItemDefinition copy() {
        ManufacturedItemDefinition dst = new ManufacturedItemDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ManufacturedItemDefinition dst) {
        super.copyValues(dst);
        dst.manufacturedDoseForm = this.manufacturedDoseForm == null ? null : this.manufacturedDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<Reference>();
            for (Reference reference : this.ingredient) {
                dst.ingredient.add(reference.copy());
            }
        }
        ProdCharacteristic prodCharacteristic = dst.physicalCharacteristics = this.physicalCharacteristics == null ? null : this.physicalCharacteristics.copy();
        if (this.otherCharacteristics != null) {
            dst.otherCharacteristics = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.otherCharacteristics) {
                dst.otherCharacteristics.add(codeableConcept2.copy());
            }
        }
    }

    protected ManufacturedItemDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return ManufacturedItemDefinition.compareDeep(this.manufacturedDoseForm, o.manufacturedDoseForm, true) && ManufacturedItemDefinition.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && ManufacturedItemDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && ManufacturedItemDefinition.compareDeep(this.ingredient, o.ingredient, true) && ManufacturedItemDefinition.compareDeep(this.physicalCharacteristics, o.physicalCharacteristics, true) && ManufacturedItemDefinition.compareDeep(this.otherCharacteristics, o.otherCharacteristics, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.manufacturedDoseForm, this.unitOfPresentation, this.manufacturer, this.ingredient, this.physicalCharacteristics, this.otherCharacteristics});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ManufacturedItemDefinition;
    }
}

