/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import java.io.IOException;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class XhtmlType
extends Element {
    private Narrative place;

    public XhtmlType(Narrative place) {
        this.place = place;
    }

    public XhtmlType() {
    }

    @Override
    public String fhirType() {
        return "xhtml";
    }

    @Override
    protected void listChildren(List<Property> result) {
    }

    @Override
    public String getIdBase() {
        return null;
    }

    @Override
    public void setIdBase(String value) {
    }

    @Override
    public Element copy() {
        return null;
    }

    public XhtmlNode getValue() {
        return this.place == null ? new XhtmlNode(NodeType.Element, "div") : this.place.getDiv();
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        if ("value".equals(name)) {
            if (value instanceof StringType) {
                this.place.getDiv().setValueAsString(((StringType)value).asStringValue());
            } else {
                this.place.setDiv(this.castToXhtml(value));
            }
            return value;
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if ("value".equals(name)) {
            return new Base[]{this};
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public String primitiveValue() {
        try {
            return new XhtmlComposer(false).compose(this.getValue());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean hasPrimitiveValue() {
        return true;
    }
}

