/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ActionParticipantType;

public class ActionParticipantTypeEnumFactory
implements EnumFactory<ActionParticipantType> {
    @Override
    public ActionParticipantType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return ActionParticipantType.PATIENT;
        }
        if ("practitioner".equals(codeString)) {
            return ActionParticipantType.PRACTITIONER;
        }
        if ("related-person".equals(codeString)) {
            return ActionParticipantType.RELATEDPERSON;
        }
        if ("device".equals(codeString)) {
            return ActionParticipantType.DEVICE;
        }
        throw new IllegalArgumentException("Unknown ActionParticipantType code '" + codeString + "'");
    }

    @Override
    public String toCode(ActionParticipantType code) {
        if (code == ActionParticipantType.PATIENT) {
            return "patient";
        }
        if (code == ActionParticipantType.PRACTITIONER) {
            return "practitioner";
        }
        if (code == ActionParticipantType.RELATEDPERSON) {
            return "related-person";
        }
        if (code == ActionParticipantType.DEVICE) {
            return "device";
        }
        return "?";
    }

    @Override
    public String toSystem(ActionParticipantType code) {
        return code.getSystem();
    }
}

