/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogentryStatus {
    DRAFT,
    ACTIVE,
    RETIRED,
    NULL;


    public static CatalogentryStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("retired".equals(codeString)) {
            return RETIRED;
        }
        throw new FHIRException("Unknown CatalogentryStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case RETIRED: {
                return "retired";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalogentry-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "";
            }
            case ACTIVE: {
                return "";
            }
            case RETIRED: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case RETIRED: {
                return "Retired";
            }
        }
        return "?";
    }
}

