/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClinicalUseIssueType {
    INDICATION,
    CONTRAINDICATION,
    INTERACTION,
    UNDESIRABLEEFFECT,
    OTHER,
    NULL;


    public static ClinicalUseIssueType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("indication".equals(codeString)) {
            return INDICATION;
        }
        if ("contraindication".equals(codeString)) {
            return CONTRAINDICATION;
        }
        if ("interaction".equals(codeString)) {
            return INTERACTION;
        }
        if ("undesirable-effect".equals(codeString)) {
            return UNDESIRABLEEFFECT;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown ClinicalUseIssueType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INDICATION: {
                return "indication";
            }
            case CONTRAINDICATION: {
                return "contraindication";
            }
            case INTERACTION: {
                return "interaction";
            }
            case UNDESIRABLEEFFECT: {
                return "undesirable-effect";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/clinical-use-issue-type";
    }

    public String getDefinition() {
        switch (this) {
            case INDICATION: {
                return "A reason for giving the medicaton.";
            }
            case CONTRAINDICATION: {
                return "A reason for not giving the medicaition.";
            }
            case INTERACTION: {
                return "Interactions between the medication and other substances.";
            }
            case UNDESIRABLEEFFECT: {
                return "Side effects or adverse effects associated with the medication.";
            }
            case OTHER: {
                return "Other.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INDICATION: {
                return "Indication";
            }
            case CONTRAINDICATION: {
                return "Contraindication";
            }
            case INTERACTION: {
                return "Interaction";
            }
            case UNDESIRABLEEFFECT: {
                return "Undesirable Effect";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "?";
    }
}

