/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.CommunicationCategory;

public class CommunicationCategoryEnumFactory
implements EnumFactory<CommunicationCategory> {
    @Override
    public CommunicationCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("alert".equals(codeString)) {
            return CommunicationCategory.ALERT;
        }
        if ("notification".equals(codeString)) {
            return CommunicationCategory.NOTIFICATION;
        }
        if ("reminder".equals(codeString)) {
            return CommunicationCategory.REMINDER;
        }
        if ("instruction".equals(codeString)) {
            return CommunicationCategory.INSTRUCTION;
        }
        throw new IllegalArgumentException("Unknown CommunicationCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(CommunicationCategory code) {
        if (code == CommunicationCategory.ALERT) {
            return "alert";
        }
        if (code == CommunicationCategory.NOTIFICATION) {
            return "notification";
        }
        if (code == CommunicationCategory.REMINDER) {
            return "reminder";
        }
        if (code == CommunicationCategory.INSTRUCTION) {
            return "instruction";
        }
        return "?";
    }

    @Override
    public String toSystem(CommunicationCategory code) {
        return code.getSystem();
    }
}

