/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ConceptMapRelationship;

public class ConceptMapRelationshipEnumFactory
implements EnumFactory<ConceptMapRelationship> {
    @Override
    public ConceptMapRelationship fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("related-to".equals(codeString)) {
            return ConceptMapRelationship.RELATEDTO;
        }
        if ("equivalent".equals(codeString)) {
            return ConceptMapRelationship.EQUIVALENT;
        }
        if ("broader".equals(codeString)) {
            return ConceptMapRelationship.BROADER;
        }
        if ("narrower".equals(codeString)) {
            return ConceptMapRelationship.NARROWER;
        }
        if ("not-related-to".equals(codeString)) {
            return ConceptMapRelationship.NOTRELATEDTO;
        }
        throw new IllegalArgumentException("Unknown ConceptMapRelationship code '" + codeString + "'");
    }

    @Override
    public String toCode(ConceptMapRelationship code) {
        if (code == ConceptMapRelationship.RELATEDTO) {
            return "related-to";
        }
        if (code == ConceptMapRelationship.EQUIVALENT) {
            return "equivalent";
        }
        if (code == ConceptMapRelationship.BROADER) {
            return "broader";
        }
        if (code == ConceptMapRelationship.NARROWER) {
            return "narrower";
        }
        if (code == ConceptMapRelationship.NOTRELATEDTO) {
            return "not-related-to";
        }
        return "?";
    }

    @Override
    public String toSystem(ConceptMapRelationship code) {
        return code.getSystem();
    }
}

