/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractDataMeaning {
    INSTANCE,
    RELATED,
    DEPENDENTS,
    AUTHOREDBY,
    NULL;


    public static ContractDataMeaning fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("instance".equals(codeString)) {
            return INSTANCE;
        }
        if ("related".equals(codeString)) {
            return RELATED;
        }
        if ("dependents".equals(codeString)) {
            return DEPENDENTS;
        }
        if ("authoredby".equals(codeString)) {
            return AUTHOREDBY;
        }
        throw new FHIRException("Unknown ContractDataMeaning code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INSTANCE: {
                return "instance";
            }
            case RELATED: {
                return "related";
            }
            case DEPENDENTS: {
                return "dependents";
            }
            case AUTHOREDBY: {
                return "authoredby";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/contract-data-meaning";
    }

    public String getDefinition() {
        switch (this) {
            case INSTANCE: {
                return "The consent applies directly to the instance of the resource.";
            }
            case RELATED: {
                return "The consent applies directly to the instance of the resource and instances it refers to.";
            }
            case DEPENDENTS: {
                return "The consent applies directly to the instance of the resource and instances that refer to it.";
            }
            case AUTHOREDBY: {
                return "The consent applies to instances of resources that are authored by.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INSTANCE: {
                return "Instance";
            }
            case RELATED: {
                return "Related";
            }
            case DEPENDENTS: {
                return "Dependents";
            }
            case AUTHOREDBY: {
                return "AuthoredBy";
            }
        }
        return "?";
    }
}

