/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ContractStatus;

public class ContractStatusEnumFactory
implements EnumFactory<ContractStatus> {
    @Override
    public ContractStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("amended".equals(codeString)) {
            return ContractStatus.AMENDED;
        }
        if ("appended".equals(codeString)) {
            return ContractStatus.APPENDED;
        }
        if ("cancelled".equals(codeString)) {
            return ContractStatus.CANCELLED;
        }
        if ("disputed".equals(codeString)) {
            return ContractStatus.DISPUTED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ContractStatus.ENTEREDINERROR;
        }
        if ("executable".equals(codeString)) {
            return ContractStatus.EXECUTABLE;
        }
        if ("executed".equals(codeString)) {
            return ContractStatus.EXECUTED;
        }
        if ("negotiable".equals(codeString)) {
            return ContractStatus.NEGOTIABLE;
        }
        if ("offered".equals(codeString)) {
            return ContractStatus.OFFERED;
        }
        if ("policy".equals(codeString)) {
            return ContractStatus.POLICY;
        }
        if ("rejected".equals(codeString)) {
            return ContractStatus.REJECTED;
        }
        if ("renewed".equals(codeString)) {
            return ContractStatus.RENEWED;
        }
        if ("revoked".equals(codeString)) {
            return ContractStatus.REVOKED;
        }
        if ("resolved".equals(codeString)) {
            return ContractStatus.RESOLVED;
        }
        if ("terminated".equals(codeString)) {
            return ContractStatus.TERMINATED;
        }
        throw new IllegalArgumentException("Unknown ContractStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractStatus code) {
        if (code == ContractStatus.AMENDED) {
            return "amended";
        }
        if (code == ContractStatus.APPENDED) {
            return "appended";
        }
        if (code == ContractStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == ContractStatus.DISPUTED) {
            return "disputed";
        }
        if (code == ContractStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == ContractStatus.EXECUTABLE) {
            return "executable";
        }
        if (code == ContractStatus.EXECUTED) {
            return "executed";
        }
        if (code == ContractStatus.NEGOTIABLE) {
            return "negotiable";
        }
        if (code == ContractStatus.OFFERED) {
            return "offered";
        }
        if (code == ContractStatus.POLICY) {
            return "policy";
        }
        if (code == ContractStatus.REJECTED) {
            return "rejected";
        }
        if (code == ContractStatus.RENEWED) {
            return "renewed";
        }
        if (code == ContractStatus.REVOKED) {
            return "revoked";
        }
        if (code == ContractStatus.RESOLVED) {
            return "resolved";
        }
        if (code == ContractStatus.TERMINATED) {
            return "terminated";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractStatus code) {
        return code.getSystem();
    }
}

