/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ContractTermType;

public class ContractTermTypeEnumFactory
implements EnumFactory<ContractTermType> {
    @Override
    public ContractTermType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("statutory".equals(codeString)) {
            return ContractTermType.STATUTORY;
        }
        if ("subject-to".equals(codeString)) {
            return ContractTermType.SUBJECTTO;
        }
        throw new IllegalArgumentException("Unknown ContractTermType code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractTermType code) {
        if (code == ContractTermType.STATUTORY) {
            return "statutory";
        }
        if (code == ContractTermType.SUBJECTTO) {
            return "subject-to";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractTermType code) {
        return code.getSystem();
    }
}

