/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DefinitionStatus {
    DRAFT,
    ACTIVE,
    WITHDRAWN,
    UNKNOWN,
    NULL;


    public static DefinitionStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("withdrawn".equals(codeString)) {
            return WITHDRAWN;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown DefinitionStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case WITHDRAWN: {
                return "withdrawn";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/definition-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The definition is in the design stage and is not yet considered to be \"ready for use\".";
            }
            case ACTIVE: {
                return "The definition is considered ready for use.";
            }
            case WITHDRAWN: {
                return "The definition should no longer be used.";
            }
            case UNKNOWN: {
                return "The authoring/source system does not know which of the status values currently applies for this resource.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply,  but the authoring/source system does not know which.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case WITHDRAWN: {
                return "Withdrawn";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

