/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterSubjectStatus {
    ARRIVED,
    TRIAGED,
    ONLEAVE,
    DEPARTED,
    NULL;


    public static EncounterSubjectStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("arrived".equals(codeString)) {
            return ARRIVED;
        }
        if ("triaged".equals(codeString)) {
            return TRIAGED;
        }
        if ("on-leave".equals(codeString)) {
            return ONLEAVE;
        }
        if ("departed".equals(codeString)) {
            return DEPARTED;
        }
        throw new FHIRException("Unknown EncounterSubjectStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ARRIVED: {
                return "arrived";
            }
            case TRIAGED: {
                return "triaged";
            }
            case ONLEAVE: {
                return "on-leave";
            }
            case DEPARTED: {
                return "departed";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/encounter-subject-status";
    }

    public String getDefinition() {
        switch (this) {
            case ARRIVED: {
                return "";
            }
            case TRIAGED: {
                return "";
            }
            case ONLEAVE: {
                return "";
            }
            case DEPARTED: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ARRIVED: {
                return "Arrived";
            }
            case TRIAGED: {
                return "Triaged";
            }
            case ONLEAVE: {
                return "On Leave";
            }
            case DEPARTED: {
                return "Departed";
            }
        }
        return "?";
    }
}

