/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EpisodeofcareType {
    HACC,
    PAC,
    DIAB,
    DA,
    CACP,
    NULL;


    public static EpisodeofcareType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("hacc".equals(codeString)) {
            return HACC;
        }
        if ("pac".equals(codeString)) {
            return PAC;
        }
        if ("diab".equals(codeString)) {
            return DIAB;
        }
        if ("da".equals(codeString)) {
            return DA;
        }
        if ("cacp".equals(codeString)) {
            return CACP;
        }
        throw new FHIRException("Unknown EpisodeofcareType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HACC: {
                return "hacc";
            }
            case PAC: {
                return "pac";
            }
            case DIAB: {
                return "diab";
            }
            case DA: {
                return "da";
            }
            case CACP: {
                return "cacp";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/episodeofcare-type";
    }

    public String getDefinition() {
        switch (this) {
            case HACC: {
                return "";
            }
            case PAC: {
                return "";
            }
            case DIAB: {
                return "";
            }
            case DA: {
                return "";
            }
            case CACP: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HACC: {
                return "Home and Community Care";
            }
            case PAC: {
                return "Post Acute Care";
            }
            case DIAB: {
                return "Post coordinated diabetes program";
            }
            case DA: {
                return "Drug and alcohol rehabilitation";
            }
            case CACP: {
                return "Community-based aged care";
            }
        }
        return "?";
    }
}

