/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.EvidenceQuality;

public class EvidenceQualityEnumFactory
implements EnumFactory<EvidenceQuality> {
    @Override
    public EvidenceQuality fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("high".equals(codeString)) {
            return EvidenceQuality.HIGH;
        }
        if ("moderate".equals(codeString)) {
            return EvidenceQuality.MODERATE;
        }
        if ("low".equals(codeString)) {
            return EvidenceQuality.LOW;
        }
        if ("very-low".equals(codeString)) {
            return EvidenceQuality.VERYLOW;
        }
        throw new IllegalArgumentException("Unknown EvidenceQuality code '" + codeString + "'");
    }

    @Override
    public String toCode(EvidenceQuality code) {
        if (code == EvidenceQuality.HIGH) {
            return "high";
        }
        if (code == EvidenceQuality.MODERATE) {
            return "moderate";
        }
        if (code == EvidenceQuality.LOW) {
            return "low";
        }
        if (code == EvidenceQuality.VERYLOW) {
            return "very-low";
        }
        return "?";
    }

    @Override
    public String toSystem(EvidenceQuality code) {
        return code.getSystem();
    }
}

