/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExposureState {
    EXPOSURE,
    EXPOSUREALTERNATIVE,
    NULL;


    public static ExposureState fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("exposure".equals(codeString)) {
            return EXPOSURE;
        }
        if ("exposure-alternative".equals(codeString)) {
            return EXPOSUREALTERNATIVE;
        }
        throw new FHIRException("Unknown ExposureState code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EXPOSURE: {
                return "exposure";
            }
            case EXPOSUREALTERNATIVE: {
                return "exposure-alternative";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/exposure-state";
    }

    public String getDefinition() {
        switch (this) {
            case EXPOSURE: {
                return "used when the results by exposure is describing the results for the primary exposure of interest.";
            }
            case EXPOSUREALTERNATIVE: {
                return "used when the results by exposure is describing the results for the alternative exposure state, control state or comparator state.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EXPOSURE: {
                return "Exposure";
            }
            case EXPOSUREALTERNATIVE: {
                return "Exposure Alternative";
            }
        }
        return "?";
    }
}

