/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ExposureState;

public class ExposureStateEnumFactory
implements EnumFactory<ExposureState> {
    @Override
    public ExposureState fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("exposure".equals(codeString)) {
            return ExposureState.EXPOSURE;
        }
        if ("exposure-alternative".equals(codeString)) {
            return ExposureState.EXPOSUREALTERNATIVE;
        }
        throw new IllegalArgumentException("Unknown ExposureState code '" + codeString + "'");
    }

    @Override
    public String toCode(ExposureState code) {
        if (code == ExposureState.EXPOSURE) {
            return "exposure";
        }
        if (code == ExposureState.EXPOSUREALTERNATIVE) {
            return "exposure-alternative";
        }
        return "?";
    }

    @Override
    public String toSystem(ExposureState code) {
        return code.getSystem();
    }
}

