/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImmunizationRecommendationStatus {
    DUE,
    OVERDUE,
    IMMUNE,
    CONTRAINDICATED,
    COMPLETE,
    NULL;


    public static ImmunizationRecommendationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("due".equals(codeString)) {
            return DUE;
        }
        if ("overdue".equals(codeString)) {
            return OVERDUE;
        }
        if ("immune".equals(codeString)) {
            return IMMUNE;
        }
        if ("contraindicated".equals(codeString)) {
            return CONTRAINDICATED;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        throw new FHIRException("Unknown ImmunizationRecommendationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DUE: {
                return "due";
            }
            case OVERDUE: {
                return "overdue";
            }
            case IMMUNE: {
                return "immune";
            }
            case CONTRAINDICATED: {
                return "contraindicated";
            }
            case COMPLETE: {
                return "complete";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/immunization-recommendation-status";
    }

    public String getDefinition() {
        switch (this) {
            case DUE: {
                return "The patient is due for their next vaccination.";
            }
            case OVERDUE: {
                return "The patient is considered overdue for their next vaccination.";
            }
            case IMMUNE: {
                return "The patient is immune to the target disease and further immunization against the disease is not likely to provide benefit.";
            }
            case CONTRAINDICATED: {
                return "The patient is contraindicated for futher doses.";
            }
            case COMPLETE: {
                return "The patient is fully protected and no further doses are recommended.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DUE: {
                return "Due";
            }
            case OVERDUE: {
                return "Overdue";
            }
            case IMMUNE: {
                return "Immune";
            }
            case CONTRAINDICATED: {
                return "Contraindicated";
            }
            case COMPLETE: {
                return "Complete";
            }
        }
        return "?";
    }
}

