/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LocationMode {
    INSTANCE,
    KIND,
    NULL;


    public static LocationMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("instance".equals(codeString)) {
            return INSTANCE;
        }
        if ("kind".equals(codeString)) {
            return KIND;
        }
        throw new FHIRException("Unknown LocationMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INSTANCE: {
                return "instance";
            }
            case KIND: {
                return "kind";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/location-mode";
    }

    public String getDefinition() {
        switch (this) {
            case INSTANCE: {
                return "The Location resource represents a specific instance of a location (e.g. Operating Theatre 1A).";
            }
            case KIND: {
                return "The Location represents a class of locations (e.g. Any Operating Theatre) although this class of locations could be constrained within a specific boundary (such as organization, or parent location, address etc.).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INSTANCE: {
                return "Instance";
            }
            case KIND: {
                return "Kind";
            }
        }
        return "?";
    }
}

