/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.MeasureReportType;

public class MeasureReportTypeEnumFactory
implements EnumFactory<MeasureReportType> {
    @Override
    public MeasureReportType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("individual".equals(codeString)) {
            return MeasureReportType.INDIVIDUAL;
        }
        if ("subject-list".equals(codeString)) {
            return MeasureReportType.SUBJECTLIST;
        }
        if ("summary".equals(codeString)) {
            return MeasureReportType.SUMMARY;
        }
        if ("data-collection".equals(codeString)) {
            return MeasureReportType.DATACOLLECTION;
        }
        throw new IllegalArgumentException("Unknown MeasureReportType code '" + codeString + "'");
    }

    @Override
    public String toCode(MeasureReportType code) {
        if (code == MeasureReportType.INDIVIDUAL) {
            return "individual";
        }
        if (code == MeasureReportType.SUBJECTLIST) {
            return "subject-list";
        }
        if (code == MeasureReportType.SUMMARY) {
            return "summary";
        }
        if (code == MeasureReportType.DATACOLLECTION) {
            return "data-collection";
        }
        return "?";
    }

    @Override
    public String toSystem(MeasureReportType code) {
        return code.getSystem();
    }
}

