/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProductStorageScale {
    FARENHEIT,
    CELSIUS,
    KELVIN,
    NULL;


    public static ProductStorageScale fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("farenheit".equals(codeString)) {
            return FARENHEIT;
        }
        if ("celsius".equals(codeString)) {
            return CELSIUS;
        }
        if ("kelvin".equals(codeString)) {
            return KELVIN;
        }
        throw new FHIRException("Unknown ProductStorageScale code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FARENHEIT: {
                return "farenheit";
            }
            case CELSIUS: {
                return "celsius";
            }
            case KELVIN: {
                return "kelvin";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/product-storage-scale";
    }

    public String getDefinition() {
        switch (this) {
            case FARENHEIT: {
                return "Fahrenheit temperature scale.";
            }
            case CELSIUS: {
                return "Celsius or centigrade temperature scale.";
            }
            case KELVIN: {
                return "Kelvin absolute thermodynamic temperature scale.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FARENHEIT: {
                return "Fahrenheit";
            }
            case CELSIUS: {
                return "Celsius";
            }
            case KELVIN: {
                return "Kelvin";
            }
        }
        return "?";
    }
}

