/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SupplyrequestKind {
    CENTRAL,
    NONSTOCK,
    NULL;


    public static SupplyrequestKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("central".equals(codeString)) {
            return CENTRAL;
        }
        if ("nonstock".equals(codeString)) {
            return NONSTOCK;
        }
        throw new FHIRException("Unknown SupplyrequestKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CENTRAL: {
                return "central";
            }
            case NONSTOCK: {
                return "nonstock";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/supply-kind";
    }

    public String getDefinition() {
        switch (this) {
            case CENTRAL: {
                return "Supply is stored and requested from central supply.";
            }
            case NONSTOCK: {
                return "Supply is not onsite and must be requested from an outside vendor using a non-stock requisition.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CENTRAL: {
                return "Central Supply";
            }
            case NONSTOCK: {
                return "Non-Stock";
            }
        }
        return "?";
    }
}

