/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3AcknowledgementCondition {
    AL,
    ER,
    NE,
    SU,
    NULL;


    public static V3AcknowledgementCondition fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AL".equals(codeString)) {
            return AL;
        }
        if ("ER".equals(codeString)) {
            return ER;
        }
        if ("NE".equals(codeString)) {
            return NE;
        }
        if ("SU".equals(codeString)) {
            return SU;
        }
        throw new FHIRException("Unknown V3AcknowledgementCondition code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AL: {
                return "AL";
            }
            case ER: {
                return "ER";
            }
            case NE: {
                return "NE";
            }
            case SU: {
                return "SU";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-AcknowledgementCondition";
    }

    public String getDefinition() {
        switch (this) {
            case AL: {
                return "Always send an acknowledgement.";
            }
            case ER: {
                return "Send an acknowledgement for error/reject conditions only.";
            }
            case NE: {
                return "Never send an acknowledgement.";
            }
            case SU: {
                return "Send an acknowledgement for successful completions only.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AL: {
                return "Always";
            }
            case ER: {
                return "Error/reject only";
            }
            case NE: {
                return "Never";
            }
            case SU: {
                return "Successful only";
            }
        }
        return "?";
    }
}

