/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3TableCellScope {
    COL,
    COLGROUP,
    ROW,
    ROWGROUP,
    NULL;


    public static V3TableCellScope fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("col".equals(codeString)) {
            return COL;
        }
        if ("colgroup".equals(codeString)) {
            return COLGROUP;
        }
        if ("row".equals(codeString)) {
            return ROW;
        }
        if ("rowgroup".equals(codeString)) {
            return ROWGROUP;
        }
        throw new FHIRException("Unknown V3TableCellScope code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COL: {
                return "col";
            }
            case COLGROUP: {
                return "colgroup";
            }
            case ROW: {
                return "row";
            }
            case ROWGROUP: {
                return "rowgroup";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-TableCellScope";
    }

    public String getDefinition() {
        switch (this) {
            case COL: {
                return "col";
            }
            case COLGROUP: {
                return "colgroup";
            }
            case ROW: {
                return "row";
            }
            case ROWGROUP: {
                return "rowgroup";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COL: {
                return "col";
            }
            case COLGROUP: {
                return "colgroup";
            }
            case ROW: {
                return "row";
            }
            case ROWGROUP: {
                return "rowgroup";
            }
        }
        return "?";
    }
}

