package org.hl7.fhir.r5.terminologies;

/*-
 * #%L
 * org.hl7.fhir.r5
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import java.util.Map;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.HTMLClientLogger;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.client.ToolingClientLogger;

public interface TerminologyClient {
  public String getAddress();
  public TerminologyCapabilities getTerminologyCapabilities() throws FHIRException;
  public ValueSet expandValueset(ValueSet vs, Parameters p, Map<String, String> params) throws FHIRException;
  public Parameters validateCS(Parameters pin) throws FHIRException;
  public Parameters validateVS(Parameters pin) throws FHIRException;
  public void setTimeout(int i) throws FHIRException;
  public void setLogger(ToolingClientLogger txLog) throws FHIRException;
  public CapabilityStatement getCapabilitiesStatementQuick() throws FHIRException;
  public Parameters lookupCode(Map<String, String> params) throws FHIRException;
}
